# 
#         bukavu
#                   www.fabiocrameri.ch/colourmaps
from matplotlib.colors import LinearSegmentedColormap      
      
cm_data = [[0.10021, 0.20003, 0.20006],      
           [0.10119, 0.20327, 0.20759],      
           [0.10214, 0.20654, 0.21514],      
           [0.10309, 0.20978, 0.2228],      
           [0.10398, 0.21308, 0.23049],      
           [0.10485, 0.21645, 0.23829],      
           [0.10581, 0.21983, 0.24619],      
           [0.10676, 0.22327, 0.25422],      
           [0.10764, 0.22676, 0.26235],      
           [0.10857, 0.23028, 0.27063],      
           [0.1096, 0.23389, 0.27903],      
           [0.11055, 0.23758, 0.28756],      
           [0.11155, 0.2413, 0.29628],      
           [0.11257, 0.24508, 0.30515],      
           [0.1136, 0.24898, 0.31418],      
           [0.1146, 0.25293, 0.3234],      
           [0.11573, 0.25697, 0.33284],      
           [0.11683, 0.2611, 0.34248],      
           [0.11799, 0.26534, 0.35237],      
           [0.11916, 0.26972, 0.36254],      
           [0.12035, 0.2742, 0.37302],      
           [0.12159, 0.27885, 0.38384],      
           [0.12288, 0.28364, 0.39503],      
           [0.12424, 0.28861, 0.40661],      
           [0.12566, 0.29374, 0.41859],      
           [0.12705, 0.29908, 0.43098],      
           [0.12855, 0.30459, 0.44376],      
           [0.13012, 0.3103, 0.45686],      
           [0.13166, 0.31619, 0.47025],      
           [0.13328, 0.32225, 0.48379],      
           [0.13497, 0.32851, 0.49737],      
           [0.13668, 0.33496, 0.51082],      
           [0.13853, 0.34156, 0.52399],      
           [0.14046, 0.34836, 0.53675],      
           [0.14249, 0.35532, 0.54898],      
           [0.14464, 0.3624, 0.56065],      
           [0.14685, 0.3696, 0.57179],      
           [0.14918, 0.3769, 0.58243],      
           [0.15154, 0.38423, 0.59269],      
           [0.15395, 0.3916, 0.60262],      
           [0.15641, 0.39896, 0.61232],      
           [0.15884, 0.40632, 0.62186],      
           [0.16128, 0.41364, 0.6313],      
           [0.16371, 0.42092, 0.64064],      
           [0.16609, 0.42818, 0.64992],      
           [0.16851, 0.43541, 0.65914],      
           [0.1709, 0.44259, 0.66833],      
           [0.17328, 0.44974, 0.67747],      
           [0.17564, 0.45686, 0.68656],      
           [0.17807, 0.46398, 0.69563],      
           [0.18042, 0.47107, 0.70465],      
           [0.18286, 0.47816, 0.7136],      
           [0.18543, 0.48526, 0.72243],      
           [0.1881, 0.49237, 0.73109],      
           [0.19099, 0.49951, 0.73945],      
           [0.19428, 0.50667, 0.74735],      
           [0.19798, 0.51386, 0.75463],      
           [0.20227, 0.52105, 0.76114],      
           [0.20722, 0.52825, 0.76674],      
           [0.21278, 0.53544, 0.77137],      
           [0.21896, 0.54263, 0.77503],      
           [0.22564, 0.54979, 0.77784],      
           [0.23268, 0.55691, 0.7799],      
           [0.24, 0.564, 0.78141],      
           [0.24748, 0.57103, 0.78251],      
           [0.25504, 0.57802, 0.78335],      
           [0.2626, 0.58497, 0.78403],      
           [0.27017, 0.59187, 0.78461],      
           [0.27768, 0.59871, 0.78514],      
           [0.28515, 0.60551, 0.78565],      
           [0.2926, 0.61226, 0.78615],      
           [0.3, 0.61898, 0.78665],      
           [0.30734, 0.62564, 0.78714],      
           [0.31466, 0.63227, 0.78763],      
           [0.32194, 0.63886, 0.78812],      
           [0.32919, 0.64541, 0.7886],      
           [0.33638, 0.65195, 0.78909],      
           [0.34357, 0.65844, 0.78957],      
           [0.35073, 0.66491, 0.79005],      
           [0.35786, 0.67136, 0.79052],      
           [0.36495, 0.67779, 0.791],      
           [0.37204, 0.68418, 0.79147],      
           [0.37911, 0.69057, 0.79195],      
           [0.38614, 0.69693, 0.79242],      
           [0.39317, 0.70328, 0.79289],      
           [0.40018, 0.7096, 0.79336],      
           [0.40716, 0.71591, 0.79383],      
           [0.41412, 0.72219, 0.79429],      
           [0.42106, 0.72846, 0.79475],      
           [0.42799, 0.73472, 0.79521],      
           [0.43492, 0.74095, 0.79568],      
           [0.44186, 0.74719, 0.79615],      
           [0.44884, 0.75342, 0.79665],      
           [0.45592, 0.75966, 0.79719],      
           [0.46318, 0.76593, 0.79779],      
           [0.47076, 0.77225, 0.79851],      
           [0.47876, 0.77864, 0.79941],      
           [0.48737, 0.78514, 0.80053],      
           [0.49672, 0.79177, 0.80195],      
           [0.50697, 0.79854, 0.80371],      
           [0.51814, 0.80547, 0.80585],      
           [0.53022, 0.81256, 0.80836],      
           [0.54311, 0.81977, 0.81121],      
           [0.55667, 0.82709, 0.81434],      
           [0.57071, 0.83447, 0.81769],      
           [0.58511, 0.84188, 0.82119],      
           [0.59968, 0.84931, 0.82479],      
           [0.61433, 0.85672, 0.82843],      
           [0.629, 0.86411, 0.8321],      
           [0.64362, 0.87145, 0.83576],      
           [0.65819, 0.87876, 0.83941],      
           [0.67268, 0.88603, 0.84304],      
           [0.68708, 0.89325, 0.84665],      
           [0.70139, 0.90042, 0.85024],      
           [0.71562, 0.90756, 0.8538],      
           [0.72975, 0.91464, 0.85734],      
           [0.7438, 0.92168, 0.86086],      
           [0.75776, 0.92867, 0.86436],      
           [0.77165, 0.93563, 0.86784],      
           [0.78544, 0.94254, 0.87129],      
           [0.79917, 0.94941, 0.87472],      
           [0.8128, 0.95625, 0.87814],      
           [0.82638, 0.96304, 0.88154],      
           [0.83989, 0.9698, 0.88492],      
           [0.85332, 0.97653, 0.88828],      
           [0.8667, 0.98324, 0.89163],      
           [0.88002, 0.98992, 0.89497],      
           [0.89329, 0.99658, 0.89829],      
           [0.0032381, 0.25205, 0.14935],      
           [0.0070186, 0.25631, 0.14576],      
           [0.010799, 0.26069, 0.14206],      
           [0.014794, 0.26516, 0.1383],      
           [0.018683, 0.26978, 0.13446],      
           [0.022712, 0.27451, 0.13053],      
           [0.02695, 0.27942, 0.12648],      
           [0.031482, 0.28445, 0.12235],      
           [0.036599, 0.28968, 0.11826],      
           [0.042054, 0.29506, 0.11401],      
           [0.047635, 0.30062, 0.10982],      
           [0.053619, 0.30638, 0.10551],      
           [0.060099, 0.31226, 0.10127],      
           [0.066906, 0.31833, 0.097065],      
           [0.07431, 0.32454, 0.092956],      
           [0.082337, 0.33088, 0.089057],      
           [0.090972, 0.33734, 0.085272],      
           [0.10026, 0.34385, 0.081885],      
           [0.11032, 0.35044, 0.078683],      
           [0.12094, 0.35702, 0.076034],      
           [0.13231, 0.36356, 0.073986],      
           [0.14425, 0.37004, 0.072442],      
           [0.15673, 0.37642, 0.071703],      
           [0.16969, 0.38262, 0.071689],      
           [0.183, 0.38863, 0.072425],      
           [0.19667, 0.3944, 0.074055],      
           [0.21051, 0.39991, 0.076332],      
           [0.22446, 0.40514, 0.079395],      
           [0.23849, 0.41008, 0.083096],      
           [0.25249, 0.41469, 0.087378],      
           [0.26636, 0.419, 0.092025],      
           [0.28006, 0.42301, 0.096959],      
           [0.29355, 0.42673, 0.10224],      
           [0.30681, 0.43018, 0.10768],      
           [0.31978, 0.43337, 0.11326],      
           [0.33246, 0.43634, 0.11884],      
           [0.34481, 0.43908, 0.12441],      
           [0.35688, 0.44166, 0.13005],      
           [0.36864, 0.44407, 0.13553],      
           [0.3801, 0.44632, 0.14103],      
           [0.39128, 0.44846, 0.14638],      
           [0.40217, 0.45049, 0.15167],      
           [0.41284, 0.45244, 0.15689],      
           [0.42323, 0.45429, 0.16202],      
           [0.43341, 0.45607, 0.16703],      
           [0.44338, 0.4578, 0.17194],      
           [0.45314, 0.45949, 0.17678],      
           [0.46272, 0.46112, 0.18154],      
           [0.47215, 0.46272, 0.18626],      
           [0.48141, 0.46432, 0.19088],      
           [0.49055, 0.46586, 0.19546],      
           [0.49955, 0.46741, 0.19999],      
           [0.50847, 0.46895, 0.20453],      
           [0.51728, 0.47049, 0.209],      
           [0.52601, 0.47205, 0.21349],      
           [0.53468, 0.47362, 0.21801],      
           [0.54331, 0.47526, 0.22257],      
           [0.5519, 0.47694, 0.22719],      
           [0.56048, 0.4787, 0.23193],      
           [0.56906, 0.48057, 0.23679],      
           [0.57765, 0.48258, 0.24181],      
           [0.58628, 0.48475, 0.24706],      
           [0.59494, 0.48714, 0.25258],      
           [0.60364, 0.48975, 0.25841],      
           [0.61238, 0.49266, 0.2646],      
           [0.62117, 0.49589, 0.27121],      
           [0.62999, 0.49949, 0.27828],      
           [0.63881, 0.50348, 0.2858],      
           [0.64761, 0.50792, 0.29387],      
           [0.65636, 0.5128, 0.30245],      
           [0.66501, 0.51815, 0.31157],      
           [0.67354, 0.52396, 0.32121],      
           [0.68187, 0.53024, 0.33131],      
           [0.68999, 0.53695, 0.34189],      
           [0.69784, 0.54406, 0.35286],      
           [0.70539, 0.55154, 0.36417],      
           [0.71263, 0.55933, 0.37578],      
           [0.71955, 0.56741, 0.38761],      
           [0.72612, 0.57572, 0.39964],      
           [0.73238, 0.58421, 0.41181],      
           [0.73833, 0.59285, 0.42407],      
           [0.74399, 0.6016, 0.43641],      
           [0.7494, 0.61043, 0.44878],      
           [0.75459, 0.61932, 0.46118],      
           [0.75958, 0.62824, 0.4736],      
           [0.76441, 0.63718, 0.48604],      
           [0.7691, 0.64613, 0.49851],      
           [0.77369, 0.65507, 0.51098],      
           [0.7782, 0.66402, 0.5235],      
           [0.78264, 0.67295, 0.53605],      
           [0.78705, 0.68184, 0.54867],      
           [0.79143, 0.69072, 0.56132],      
           [0.79579, 0.69956, 0.57406],      
           [0.80015, 0.70837, 0.58687],      
           [0.80451, 0.71712, 0.59977],      
           [0.80887, 0.7258, 0.61274],      
           [0.81324, 0.73442, 0.62579],      
           [0.81761, 0.74294, 0.6389],      
           [0.82198, 0.75136, 0.65207],      
           [0.82633, 0.75964, 0.66525],      
           [0.83067, 0.76778, 0.67844],      
           [0.83499, 0.77577, 0.6916],      
           [0.83926, 0.78357, 0.70469],      
           [0.84348, 0.79116, 0.71769],      
           [0.84765, 0.79855, 0.73054],      
           [0.85175, 0.8057, 0.74322],      
           [0.85578, 0.81263, 0.7557],      
           [0.85972, 0.81931, 0.76795],      
           [0.86357, 0.82577, 0.77995],      
           [0.86733, 0.832, 0.7917],      
           [0.871, 0.838, 0.80319],      
           [0.87459, 0.84379, 0.81441],      
           [0.87811, 0.8494, 0.8254],      
           [0.88155, 0.85485, 0.83618],      
           [0.88494, 0.86016, 0.84678],      
           [0.88828, 0.86537, 0.85724],      
           [0.8916, 0.8705, 0.86763],      
           [0.89492, 0.8756, 0.87798],      
           [0.89823, 0.88068, 0.88836],      
           [0.90157, 0.88579, 0.89881],      
           [0.90495, 0.89093, 0.90938],      
           [0.90836, 0.89615, 0.92011],      
           [0.91183, 0.90145, 0.93102],      
           [0.91535, 0.90684, 0.94214],      
           [0.91892, 0.91233, 0.95347],      
           [0.92255, 0.91792, 0.96502],      
           [0.92622, 0.92361, 0.97677],      
           [0.92992, 0.92937, 0.98871]]      
      
bukavu_map = LinearSegmentedColormap.from_list('bukavu', cm_data)      
# For use of "viscm view"      
test_cm = bukavu_map      
      
if __name__ == "__main__":      
    import matplotlib.pyplot as plt      
    import numpy as np      
      
    try:      
        from viscm import viscm      
        viscm(bukavu_map)      
    except ImportError:      
        print("viscm not found, falling back on simple display")      
        plt.imshow(np.linspace(0, 100, 256)[None, :], aspect='auto',      
                   cmap=bukavu_map)      
    plt.show()      
