# 
#         broc
#                   www.fabiocrameri.ch/colourmaps
from matplotlib.colors import LinearSegmentedColormap      
      
cm_data = [[0.17081, 0.10027, 0.29985],      
           [0.17075, 0.10634, 0.30558],      
           [0.17061, 0.11229, 0.3113],      
           [0.1704, 0.11821, 0.31705],      
           [0.17013, 0.12404, 0.32282],      
           [0.16981, 0.12995, 0.3286],      
           [0.16943, 0.13572, 0.33441],      
           [0.169, 0.14158, 0.34021],      
           [0.1685, 0.14739, 0.34603],      
           [0.16797, 0.15317, 0.35187],      
           [0.16745, 0.159, 0.35775],      
           [0.16688, 0.1648, 0.36361],      
           [0.16626, 0.17063, 0.36951],      
           [0.16562, 0.17645, 0.37541],      
           [0.16499, 0.18231, 0.38135],      
           [0.16438, 0.18822, 0.38728],      
           [0.16373, 0.19411, 0.39324],      
           [0.16306, 0.19999, 0.39922],      
           [0.16241, 0.20596, 0.40522],      
           [0.16178, 0.21193, 0.41124],      
           [0.16114, 0.21792, 0.41729],      
           [0.1605, 0.22393, 0.42333],      
           [0.15991, 0.22999, 0.42941],      
           [0.1594, 0.23611, 0.43551],      
           [0.15895, 0.24223, 0.44162],      
           [0.15856, 0.24842, 0.44774],      
           [0.15825, 0.25463, 0.45388],      
           [0.15805, 0.26087, 0.46004],      
           [0.15799, 0.26715, 0.4662],      
           [0.1581, 0.27351, 0.47238],      
           [0.15841, 0.27989, 0.47855],      
           [0.15892, 0.28631, 0.48472],      
           [0.15966, 0.2928, 0.4909],      
           [0.16075, 0.29934, 0.49703],      
           [0.16216, 0.30592, 0.50316],      
           [0.16391, 0.31252, 0.50927],      
           [0.16599, 0.31919, 0.51534],      
           [0.16854, 0.32588, 0.52137],      
           [0.17149, 0.33265, 0.52735],      
           [0.1749, 0.33942, 0.53327],      
           [0.17874, 0.3462, 0.53913],      
           [0.183, 0.35303, 0.54493],      
           [0.18776, 0.35987, 0.55065],      
           [0.19288, 0.36673, 0.55629],      
           [0.19842, 0.37358, 0.56186],      
           [0.20439, 0.38045, 0.56734],      
           [0.21065, 0.3873, 0.57274],      
           [0.21727, 0.39416, 0.57805],      
           [0.22416, 0.40103, 0.5833],      
           [0.23136, 0.40786, 0.58847],      
           [0.23875, 0.4147, 0.59358],      
           [0.24637, 0.42151, 0.59862],      
           [0.25418, 0.42834, 0.60361],      
           [0.26213, 0.43515, 0.60855],      
           [0.27024, 0.44195, 0.61342],      
           [0.27844, 0.44874, 0.61828],      
           [0.28674, 0.45553, 0.6231],      
           [0.29515, 0.46231, 0.62789],      
           [0.30363, 0.4691, 0.63266],      
           [0.31216, 0.47588, 0.63742],      
           [0.32079, 0.48266, 0.64216],      
           [0.32944, 0.48945, 0.64689],      
           [0.33811, 0.49624, 0.65162],      
           [0.34685, 0.50304, 0.65634],      
           [0.35562, 0.50985, 0.66106],      
           [0.3644, 0.51666, 0.66578],      
           [0.37322, 0.52348, 0.67051],      
           [0.38206, 0.5303, 0.67522],      
           [0.39094, 0.53714, 0.67995],      
           [0.39982, 0.54397, 0.68468],      
           [0.40874, 0.55082, 0.68943],      
           [0.41768, 0.55768, 0.69416],      
           [0.42663, 0.56454, 0.69891],      
           [0.4356, 0.57141, 0.70367],      
           [0.44459, 0.57829, 0.70843],      
           [0.45359, 0.58519, 0.71319],      
           [0.46261, 0.59209, 0.71796],      
           [0.47166, 0.59899, 0.72273],      
           [0.4807, 0.6059, 0.72751],      
           [0.48977, 0.61282, 0.73231],      
           [0.49887, 0.61976, 0.7371],      
           [0.50797, 0.6267, 0.74189],      
           [0.51709, 0.63365, 0.7467],      
           [0.52622, 0.6406, 0.75151],      
           [0.53536, 0.64757, 0.75633],      
           [0.54452, 0.65454, 0.76115],      
           [0.55369, 0.66152, 0.76598],      
           [0.56289, 0.66851, 0.77081],      
           [0.57208, 0.67551, 0.77565],      
           [0.5813, 0.68251, 0.7805],      
           [0.59052, 0.68954, 0.78535],      
           [0.59977, 0.69656, 0.79021],      
           [0.60904, 0.70359, 0.79507],      
           [0.6183, 0.71063, 0.79995],      
           [0.62758, 0.71768, 0.80482],      
           [0.63689, 0.72474, 0.8097],      
           [0.64619, 0.73181, 0.81459],      
           [0.65552, 0.73889, 0.81948],      
           [0.66485, 0.74597, 0.82438],      
           [0.67421, 0.75305, 0.82929],      
           [0.68357, 0.76016, 0.8342],      
           [0.69295, 0.76727, 0.83911],      
           [0.70233, 0.77438, 0.84402],      
           [0.71174, 0.78151, 0.84894],      
           [0.72114, 0.78864, 0.85385],      
           [0.73057, 0.79577, 0.85877],      
           [0.74, 0.80291, 0.86368],      
           [0.74943, 0.81005, 0.86857],      
           [0.75888, 0.81719, 0.87343],      
           [0.76832, 0.82432, 0.87828],      
           [0.77776, 0.83145, 0.88308],      
           [0.7872, 0.83856, 0.88783],      
           [0.79662, 0.84564, 0.89251],      
           [0.80602, 0.8527, 0.8971],      
           [0.81538, 0.85971, 0.90156],      
           [0.82469, 0.86666, 0.90589],      
           [0.83394, 0.87352, 0.91001],      
           [0.84309, 0.88029, 0.91391],      
           [0.85212, 0.88692, 0.91752],      
           [0.86097, 0.89338, 0.92078],      
           [0.86962, 0.89963, 0.92365],      
           [0.87801, 0.90562, 0.92603],      
           [0.88606, 0.91129, 0.92785],      
           [0.8937, 0.91659, 0.92905],      
           [0.90086, 0.92145, 0.92956],      
           [0.90746, 0.92581, 0.92931],      
           [0.9134, 0.9296, 0.92825],      
           [0.91862, 0.93277, 0.92635],      
           [0.92307, 0.93528, 0.92359],      
           [0.92667, 0.9371, 0.91997],      
           [0.92943, 0.93822, 0.91554],      
           [0.93133, 0.93863, 0.91034],      
           [0.93239, 0.93838, 0.90443],      
           [0.93266, 0.93749, 0.8979],      
           [0.93219, 0.93601, 0.89081],      
           [0.93105, 0.93401, 0.88326],      
           [0.9293, 0.93154, 0.87532],      
           [0.92702, 0.92866, 0.86706],      
           [0.9243, 0.92545, 0.85854],      
           [0.92119, 0.92194, 0.84982],      
           [0.91776, 0.91818, 0.84094],      
           [0.91406, 0.91422, 0.83194],      
           [0.91015, 0.91011, 0.82285],      
           [0.90606, 0.90586, 0.81368],      
           [0.90184, 0.90151, 0.80447],      
           [0.89751, 0.89708, 0.79521],      
           [0.89309, 0.89259, 0.78594],      
           [0.88861, 0.88805, 0.77664],      
           [0.88407, 0.88347, 0.76733],      
           [0.87949, 0.87886, 0.75803],      
           [0.87489, 0.87423, 0.74871],      
           [0.87026, 0.86958, 0.7394],      
           [0.86561, 0.86491, 0.73009],      
           [0.86094, 0.86024, 0.72077],      
           [0.85625, 0.85553, 0.71146],      
           [0.85153, 0.8508, 0.70213],      
           [0.84679, 0.84606, 0.69282],      
           [0.84202, 0.84128, 0.68348],      
           [0.8372, 0.83645, 0.67414],      
           [0.83232, 0.83158, 0.66478],      
           [0.82739, 0.82665, 0.65542],      
           [0.82238, 0.82164, 0.64602],      
           [0.81728, 0.81655, 0.63661],      
           [0.81208, 0.81135, 0.62715],      
           [0.80676, 0.80603, 0.61766],      
           [0.80129, 0.80058, 0.60815],      
           [0.79568, 0.79499, 0.59859],      
           [0.7899, 0.78922, 0.589],      
           [0.78394, 0.78328, 0.5794],      
           [0.77778, 0.77715, 0.56976],      
           [0.77143, 0.77082, 0.56013],      
           [0.76486, 0.76428, 0.5505],      
           [0.75809, 0.75754, 0.54089],      
           [0.75112, 0.75061, 0.53133],      
           [0.74395, 0.74348, 0.52183],      
           [0.73661, 0.73616, 0.51242],      
           [0.72909, 0.72869, 0.50312],      
           [0.72143, 0.72106, 0.49397],      
           [0.71365, 0.71331, 0.48495],      
           [0.70576, 0.70546, 0.47611],      
           [0.69778, 0.69751, 0.46744],      
           [0.68975, 0.68951, 0.45895],      
           [0.68166, 0.68144, 0.45065],      
           [0.67355, 0.67336, 0.44254],      
           [0.66542, 0.66525, 0.4346],      
           [0.65729, 0.65714, 0.42684],      
           [0.64917, 0.64903, 0.41924],      
           [0.64105, 0.64093, 0.41179],      
           [0.63296, 0.63285, 0.40447],      
           [0.62488, 0.62478, 0.39727],      
           [0.61684, 0.61674, 0.39019],      
           [0.60881, 0.60873, 0.38321],      
           [0.6008, 0.60072, 0.3763],      
           [0.59283, 0.59275, 0.36945],      
           [0.58488, 0.5848, 0.36268],      
           [0.57695, 0.57687, 0.35596],      
           [0.56904, 0.56896, 0.34928],      
           [0.56116, 0.56108, 0.34265],      
           [0.55329, 0.55322, 0.33604],      
           [0.54546, 0.54538, 0.32949],      
           [0.53765, 0.53757, 0.32294],      
           [0.52985, 0.52977, 0.31642],      
           [0.52207, 0.52198, 0.30993],      
           [0.51433, 0.51424, 0.30344],      
           [0.50659, 0.5065, 0.29701],      
           [0.49888, 0.49879, 0.29056],      
           [0.4912, 0.49111, 0.28415],      
           [0.48352, 0.48342, 0.27777],      
           [0.47588, 0.47578, 0.27139],      
           [0.46825, 0.46814, 0.26503],      
           [0.46064, 0.46053, 0.2587],      
           [0.45307, 0.45296, 0.25239],      
           [0.4455, 0.44539, 0.24608],      
           [0.43798, 0.43786, 0.23981],      
           [0.43046, 0.43033, 0.23354],      
           [0.42296, 0.42283, 0.22732],      
           [0.4155, 0.41537, 0.22111],      
           [0.40805, 0.40792, 0.21489],      
           [0.40065, 0.4005, 0.20872],      
           [0.39323, 0.39309, 0.20257],      
           [0.38586, 0.38571, 0.19647],      
           [0.37851, 0.37836, 0.19034],      
           [0.37118, 0.37103, 0.18426],      
           [0.36389, 0.36373, 0.17824],      
           [0.35663, 0.35647, 0.17218],      
           [0.34937, 0.34922, 0.16619],      
           [0.34215, 0.342, 0.16021],      
           [0.33497, 0.33482, 0.1543],      
           [0.32778, 0.32764, 0.1484],      
           [0.32065, 0.32052, 0.14258],      
           [0.31352, 0.31341, 0.13676],      
           [0.30644, 0.30635, 0.13103],      
           [0.29937, 0.29931, 0.12531],      
           [0.29233, 0.2923, 0.11965],      
           [0.28532, 0.28532, 0.11406],      
           [0.27836, 0.27841, 0.10854],      
           [0.2714, 0.27151, 0.10314],      
           [0.26449, 0.26467, 0.097785],      
           [0.25761, 0.25787, 0.092474],      
           [0.25076, 0.25114, 0.087347],      
           [0.24394, 0.24442, 0.082262],      
           [0.2372, 0.2378, 0.077192],      
           [0.23042, 0.2312, 0.072349],      
           [0.22373, 0.22463, 0.067628],      
           [0.21709, 0.21818, 0.063025],      
           [0.21046, 0.21177, 0.058419],      
           [0.20394, 0.20539, 0.053781],      
           [0.19749, 0.19907, 0.048969],      
           [0.19115, 0.19284, 0.043546],      
           [0.18494, 0.18665, 0.037943],      
           [0.17882, 0.18051, 0.031907],      
           [0.1728, 0.17444, 0.026044],      
           [0.16695, 0.1684, 0.020145],      
           [0.16119, 0.16243, 0.014202],      
           [0.15554, 0.15649, 0.0080014],      
           [0.15005, 0.15056, 0.0019303]]      
      
broc_map = LinearSegmentedColormap.from_list('broc', cm_data)      
# For use of "viscm view"      
test_cm = broc_map      
      
if __name__ == "__main__":      
    import matplotlib.pyplot as plt      
    import numpy as np      
      
    try:      
        from viscm import viscm      
        viscm(broc_map)      
    except ImportError:      
        print("viscm not found, falling back on simple display")      
        plt.imshow(np.linspace(0, 100, 256)[None, :], aspect='auto',      
                   cmap=broc_map)      
    plt.show()      
