# 
#         bilbaoS
#                   www.fabiocrameri.ch/colourmaps
from matplotlib.colors import LinearSegmentedColormap      
      
cm_data = [[0.97444, 0.97436, 0.97404],      
           [0.30038, 0.0018649, 0.005395],      
           [0.66363, 0.52013, 0.39457],      
           [0.57462, 0.29121, 0.27658],      
           [0.75309, 0.72739, 0.63056],      
           [0.45012, 0.15241, 0.15024],      
           [0.7033, 0.63649, 0.47457],      
           [0.63239, 0.41316, 0.34776],      
           [0.82543, 0.81985, 0.79928],      
           [0.376, 0.080518, 0.085505],      
           [0.89469, 0.89362, 0.88971],      
           [0.61245, 0.35818, 0.32062],      
           [0.77963, 0.76475, 0.70894],      
           [0.5194, 0.22336, 0.21855],      
           [0.73002, 0.69041, 0.55373],      
           [0.67995, 0.57389, 0.42194],      
           [0.64775, 0.46507, 0.37052],      
           [0.48546, 0.18765, 0.18446],      
           [0.33776, 0.039997, 0.052327],      
           [0.8578, 0.85513, 0.84526],      
           [0.93399, 0.93366, 0.93239],      
           [0.71687, 0.6658, 0.51263],      
           [0.69067, 0.60481, 0.44391],      
           [0.65565, 0.49253, 0.38241],      
           [0.79938, 0.7896, 0.75329],      
           [0.59644, 0.32588, 0.30116],      
           [0.41364, 0.11708, 0.11692],      
           [0.74241, 0.71097, 0.59485],      
           [0.63975, 0.43754, 0.35856],      
           [0.54704, 0.2551, 0.24709],      
           [0.67194, 0.54828, 0.40784],      
           [0.76616, 0.74638, 0.67176],      
           [0.62416, 0.38817, 0.33609],      
           [0.7888, 0.77656, 0.73085],      
           [0.35684, 0.061064, 0.070322],      
           [0.6051, 0.34235, 0.31148],      
           [0.31891, 0.01913, 0.029528],      
           [0.69678, 0.62072, 0.45811],      
           [0.43203, 0.13486, 0.1334],      
           [0.95413, 0.95395, 0.95329],      
           [0.65171, 0.4788, 0.37647],      
           [0.56148, 0.27324, 0.26236],      
           [0.81157, 0.80403, 0.77616],      
           [0.46793, 0.17, 0.1673],      
           [0.61872, 0.37341, 0.32874],      
           [0.5863, 0.30882, 0.28955],      
           [0.68507, 0.58913, 0.43195],      
           [0.64377, 0.45132, 0.36457],      
           [0.75942, 0.73674, 0.65105],      
           [0.84091, 0.83696, 0.82239],      
           [0.73628, 0.70106, 0.57435],      
           [0.66771, 0.5341, 0.40098],      
           [0.50265, 0.2054, 0.20158],      
           [0.87582, 0.87409, 0.86773],      
           [0.71006, 0.65165, 0.49292],      
           [0.39496, 0.099059, 0.10092],      
           [0.65962, 0.5063, 0.38843],      
           [0.72354, 0.67872, 0.53307],      
           [0.91414, 0.91353, 0.91124],      
           [0.74849, 0.72042, 0.61525],      
           [0.63666, 0.42714, 0.35399],      
           [0.67526, 0.5591, 0.41347],      
           [0.62784, 0.39898, 0.34125],      
           [0.53155, 0.23693, 0.231],      
           [0.77161, 0.75396, 0.68752],      
           [0.71347, 0.65887, 0.50265],      
           [0.68245, 0.58145, 0.42672],      
           [0.64177, 0.44444, 0.36158],      
           [0.59156, 0.31742, 0.29552],      
           [0.55441, 0.26418, 0.25486],      
           [0.53941, 0.24598, 0.23913],      
           [0.70666, 0.64416, 0.48353],      
           [0.69366, 0.61275, 0.45072],      
           [0.34729, 0.050813, 0.061797],      
           [0.64973, 0.47194, 0.3735],      
           [0.45906, 0.16122, 0.15875],      
           [0.77549, 0.75924, 0.69816],      
           [0.63455, 0.42016, 0.35091],      
           [0.65368, 0.48566, 0.37943],      
           [0.32831, 0.028994, 0.041679],      
           [0.90435, 0.90354, 0.90053],      
           [0.66981, 0.54115, 0.40433],      
           [0.66565, 0.52711, 0.39773],      
           [0.88516, 0.88381, 0.87878],      
           [0.40433, 0.1081, 0.10886],      
           [0.4411, 0.14364, 0.14178],      
           [0.72023, 0.67242, 0.5228],      
           [0.56822, 0.28227, 0.26963],      
           [0.83298, 0.82826, 0.81084],      
           [0.63016, 0.40611, 0.34453],      
           [0.78406, 0.77051, 0.71983],      
           [0.69999, 0.62865, 0.46606],      
           [0.47673, 0.1788, 0.17585],      
           [0.81829, 0.81178, 0.7877],      
           [0.75622, 0.73205, 0.64078],      
           [0.67757, 0.56645, 0.41755],      
           [0.73937, 0.70609, 0.58462],      
           [0.51109, 0.21436, 0.2101],      
           [0.30961, 0.0099596, 0.017575],      
           [0.86668, 0.86453, 0.85655]]      
      
bilbaoS_map = LinearSegmentedColormap.from_list('bilbaoS', cm_data)      
# For use of "viscm view"      
test_cm = bilbaoS_map      
      
if __name__ == "__main__":      
    import matplotlib.pyplot as plt      
    import numpy as np      
      
    try:      
        from viscm import viscm      
        viscm(bilbaoS_map)      
    except ImportError:      
        print("viscm not found, falling back on simple display")      
        plt.imshow(np.linspace(0, 100, 256)[None, :], aspect='auto',      
                   cmap=bilbaoS_map)      
    plt.show()      
