# 
#         batlowW
#                   www.fabiocrameri.ch/colourmaps
from matplotlib.colors import LinearSegmentedColormap      
      
cm_data = [[0.0046368, 0.098343, 0.34983],      
           [0.0085802, 0.10456, 0.35092],      
           [0.012565, 0.11082, 0.35198],      
           [0.016171, 0.11693, 0.35306],      
           [0.019623, 0.12298, 0.35411],      
           [0.022916, 0.12901, 0.35517],      
           [0.026056, 0.13501, 0.3562],      
           [0.029046, 0.14093, 0.35723],      
           [0.031891, 0.14675, 0.35823],      
           [0.034696, 0.15256, 0.35923],      
           [0.037367, 0.15836, 0.36022],      
           [0.039804, 0.16407, 0.3612],      
           [0.042104, 0.16971, 0.36218],      
           [0.044107, 0.17527, 0.36312],      
           [0.045968, 0.18076, 0.36406],      
           [0.047742, 0.18621, 0.36498],      
           [0.049465, 0.19151, 0.36588],      
           [0.05089, 0.19677, 0.36676],      
           [0.052254, 0.20184, 0.36761],      
           [0.053547, 0.20688, 0.36846],      
           [0.054774, 0.21175, 0.36927],      
           [0.055952, 0.21651, 0.37005],      
           [0.057021, 0.22114, 0.37081],      
           [0.057975, 0.22565, 0.37156],      
           [0.059056, 0.23002, 0.37228],      
           [0.060029, 0.23434, 0.37298],      
           [0.060869, 0.2385, 0.37367],      
           [0.061774, 0.24259, 0.37434],      
           [0.062771, 0.2466, 0.37498],      
           [0.063628, 0.25052, 0.37561],      
           [0.064516, 0.25439, 0.37623],      
           [0.06542, 0.25817, 0.37684],      
           [0.066347, 0.26192, 0.37742],      
           [0.067303, 0.26563, 0.37799],      
           [0.068289, 0.2693, 0.37856],      
           [0.069324, 0.27292, 0.37911],      
           [0.070259, 0.27655, 0.37965],      
           [0.071367, 0.28013, 0.38019],      
           [0.072397, 0.28371, 0.38071],      
           [0.073609, 0.28728, 0.38121],      
           [0.074722, 0.29085, 0.38169],      
           [0.075923, 0.2944, 0.38216],      
           [0.077185, 0.29796, 0.38262],      
           [0.078521, 0.3015, 0.38306],      
           [0.079937, 0.30506, 0.38347],      
           [0.081445, 0.3086, 0.38386],      
           [0.082923, 0.3121, 0.38421],      
           [0.084562, 0.31565, 0.38454],      
           [0.086163, 0.31915, 0.38483],      
           [0.087968, 0.32265, 0.38509],      
           [0.089792, 0.32611, 0.38531],      
           [0.091746, 0.3296, 0.38549],      
           [0.093708, 0.33305, 0.38562],      
           [0.095823, 0.33646, 0.3857],      
           [0.098076, 0.33988, 0.38573],      
           [0.10036, 0.34327, 0.3857],      
           [0.10281, 0.34663, 0.38561],      
           [0.10533, 0.34998, 0.38546],      
           [0.10799, 0.35329, 0.38524],      
           [0.11082, 0.35659, 0.38495],      
           [0.11372, 0.35985, 0.38459],      
           [0.11674, 0.36308, 0.38415],      
           [0.11987, 0.36629, 0.38364],      
           [0.12314, 0.36945, 0.38304],      
           [0.12658, 0.37259, 0.38234],      
           [0.13016, 0.3757, 0.38157],      
           [0.13379, 0.37877, 0.38071],      
           [0.13759, 0.38181, 0.37975],      
           [0.14149, 0.3848, 0.3787],      
           [0.14553, 0.38776, 0.37756],      
           [0.14967, 0.39069, 0.37633],      
           [0.15389, 0.39358, 0.37499],      
           [0.15829, 0.39642, 0.37357],      
           [0.16276, 0.39923, 0.37204],      
           [0.16734, 0.402, 0.37043],      
           [0.172, 0.40474, 0.36874],      
           [0.17678, 0.40745, 0.36694],      
           [0.18164, 0.41012, 0.36505],      
           [0.18661, 0.41276, 0.36308],      
           [0.19165, 0.41535, 0.36102],      
           [0.1968, 0.41791, 0.35888],      
           [0.20197, 0.42045, 0.35667],      
           [0.20727, 0.42296, 0.35437],      
           [0.21261, 0.42545, 0.35199],      
           [0.21803, 0.42791, 0.34956],      
           [0.2235, 0.43035, 0.34706],      
           [0.22904, 0.43276, 0.34448],      
           [0.23465, 0.43516, 0.34185],      
           [0.24027, 0.43754, 0.33917],      
           [0.24598, 0.4399, 0.33641],      
           [0.25176, 0.44226, 0.33363],      
           [0.25755, 0.4446, 0.33077],      
           [0.26341, 0.44692, 0.32789],      
           [0.2693, 0.44924, 0.32496],      
           [0.27522, 0.45155, 0.32201],      
           [0.28117, 0.45385, 0.31902],      
           [0.28717, 0.45615, 0.31601],      
           [0.29322, 0.45844, 0.31294],      
           [0.2993, 0.46072, 0.30988],      
           [0.3054, 0.463, 0.30678],      
           [0.31151, 0.46528, 0.30365],      
           [0.31767, 0.46757, 0.30052],      
           [0.32385, 0.46985, 0.29739],      
           [0.33007, 0.47213, 0.29422],      
           [0.33628, 0.4744, 0.29106],      
           [0.34255, 0.47667, 0.28788],      
           [0.34882, 0.47895, 0.2847],      
           [0.35513, 0.48122, 0.28152],      
           [0.36144, 0.48349, 0.27834],      
           [0.36778, 0.48577, 0.27515],      
           [0.37417, 0.48806, 0.27194],      
           [0.38056, 0.49035, 0.26878],      
           [0.38698, 0.49263, 0.26558],      
           [0.39343, 0.49493, 0.2624],      
           [0.39991, 0.49723, 0.25924],      
           [0.40643, 0.49952, 0.25604],      
           [0.41298, 0.50185, 0.2529],      
           [0.41956, 0.50417, 0.24973],      
           [0.42617, 0.50649, 0.2466],      
           [0.43284, 0.50884, 0.24347],      
           [0.43954, 0.51118, 0.24037],      
           [0.44629, 0.51356, 0.23733],      
           [0.45309, 0.51592, 0.23427],      
           [0.45994, 0.51833, 0.23126],      
           [0.46685, 0.52073, 0.22829],      
           [0.47381, 0.52317, 0.22535],      
           [0.48083, 0.52561, 0.22249],      
           [0.48793, 0.52807, 0.21969],      
           [0.49507, 0.53056, 0.21696],      
           [0.50229, 0.53307, 0.21432],      
           [0.50959, 0.53559, 0.2118],      
           [0.51696, 0.53816, 0.20936],      
           [0.5244, 0.54072, 0.2071],      
           [0.53192, 0.54333, 0.20496],      
           [0.53951, 0.54596, 0.203],      
           [0.5472, 0.54861, 0.20122],      
           [0.55496, 0.55128, 0.19968],      
           [0.56281, 0.55397, 0.19839],      
           [0.57072, 0.5567, 0.19737],      
           [0.57873, 0.55944, 0.19664],      
           [0.5868, 0.56222, 0.19621],      
           [0.59495, 0.56499, 0.19612],      
           [0.60316, 0.5678, 0.19642],      
           [0.61143, 0.57062, 0.19708],      
           [0.61976, 0.57345, 0.19814],      
           [0.62813, 0.5763, 0.19964],      
           [0.63653, 0.57914, 0.20159],      
           [0.64495, 0.58198, 0.20402],      
           [0.65339, 0.58483, 0.20688],      
           [0.66183, 0.58766, 0.21017],      
           [0.67025, 0.59049, 0.21394],      
           [0.67863, 0.5933, 0.21816],      
           [0.68697, 0.59609, 0.22281],      
           [0.69525, 0.59885, 0.22788],      
           [0.70345, 0.60157, 0.23331],      
           [0.71157, 0.60427, 0.23917],      
           [0.71957, 0.60692, 0.24535],      
           [0.72745, 0.60953, 0.25188],      
           [0.73521, 0.61208, 0.25868],      
           [0.74282, 0.61459, 0.26576],      
           [0.75027, 0.61705, 0.27306],      
           [0.75757, 0.61945, 0.28056],      
           [0.76469, 0.62178, 0.28826],      
           [0.77165, 0.62407, 0.2961],      
           [0.77841, 0.62628, 0.30406],      
           [0.78501, 0.62845, 0.3121],      
           [0.79141, 0.63055, 0.32026],      
           [0.79764, 0.63259, 0.32844],      
           [0.80369, 0.63459, 0.33665],      
           [0.80957, 0.63652, 0.34489],      
           [0.81527, 0.6384, 0.35313],      
           [0.82081, 0.64023, 0.36134],      
           [0.82619, 0.64201, 0.36954],      
           [0.83142, 0.64375, 0.3777],      
           [0.8365, 0.64544, 0.38582],      
           [0.84144, 0.64711, 0.39389],      
           [0.84624, 0.64873, 0.4019],      
           [0.85092, 0.65032, 0.40988],      
           [0.85549, 0.65189, 0.41778],      
           [0.85994, 0.65342, 0.42562],      
           [0.86429, 0.65494, 0.4334],      
           [0.86855, 0.65646, 0.44113],      
           [0.87271, 0.65797, 0.44881],      
           [0.87679, 0.65946, 0.45643],      
           [0.88079, 0.66096, 0.46402],      
           [0.88473, 0.66248, 0.47156],      
           [0.8886, 0.664, 0.47907],      
           [0.89241, 0.66555, 0.48656],      
           [0.89616, 0.66714, 0.49404],      
           [0.89987, 0.66877, 0.50151],      
           [0.90353, 0.67045, 0.50899],      
           [0.90715, 0.67218, 0.51648],      
           [0.91073, 0.67399, 0.52401],      
           [0.91428, 0.67588, 0.53159],      
           [0.91781, 0.67788, 0.53921],      
           [0.9213, 0.67997, 0.54692],      
           [0.92476, 0.68219, 0.5547],      
           [0.9282, 0.68456, 0.56259],      
           [0.93162, 0.68708, 0.57057],      
           [0.93502, 0.68977, 0.57869],      
           [0.93839, 0.69264, 0.58695],      
           [0.94173, 0.69571, 0.59535],      
           [0.94504, 0.69899, 0.60392],      
           [0.94832, 0.7025, 0.61263],      
           [0.95155, 0.70626, 0.62151],      
           [0.95475, 0.71026, 0.63058],      
           [0.95789, 0.71452, 0.6398],      
           [0.96096, 0.71905, 0.64919],      
           [0.96397, 0.72385, 0.65873],      
           [0.9669, 0.72892, 0.66842],      
           [0.96974, 0.73426, 0.67823],      
           [0.97248, 0.73985, 0.68814],      
           [0.97511, 0.74568, 0.69814],      
           [0.97762, 0.75176, 0.70819],      
           [0.98001, 0.75804, 0.71826],      
           [0.98226, 0.76451, 0.72833],      
           [0.98436, 0.77115, 0.73836],      
           [0.98632, 0.77792, 0.74832],      
           [0.98812, 0.7848, 0.75817],      
           [0.98978, 0.79175, 0.76788],      
           [0.99128, 0.79877, 0.77744],      
           [0.99264, 0.80579, 0.7868],      
           [0.99385, 0.81282, 0.79595],      
           [0.99491, 0.81982, 0.80489],      
           [0.99585, 0.82678, 0.81359],      
           [0.99667, 0.83367, 0.82206],      
           [0.99737, 0.84049, 0.83027],      
           [0.99797, 0.8472, 0.83825],      
           [0.99847, 0.85382, 0.84598],      
           [0.99889, 0.86035, 0.85348],      
           [0.99922, 0.86675, 0.86076],      
           [0.99949, 0.87305, 0.86782],      
           [0.99969, 0.87923, 0.87467],      
           [0.99984, 0.8853, 0.88132],      
           [0.99995, 0.89125, 0.88779],      
           [1, 0.89711, 0.89408],      
           [1, 0.90286, 0.90021],      
           [1, 0.9085, 0.90619],      
           [1, 0.91406, 0.91203],      
           [1, 0.91952, 0.91775],      
           [1, 0.92489, 0.92334],      
           [1, 0.93018, 0.92881],      
           [1, 0.93538, 0.93417],      
           [1, 0.9405, 0.93944],      
           [1, 0.94553, 0.9446],      
           [1, 0.95048, 0.94965],      
           [1, 0.95535, 0.95462],      
           [1, 0.96014, 0.95949],      
           [1, 0.96484, 0.96427],      
           [1, 0.96947, 0.96897],      
           [1, 0.97402, 0.97358],      
           [1, 0.97849, 0.97812],      
           [1, 0.98291, 0.98259],      
           [1, 0.98726, 0.98699],      
           [1, 0.99155, 0.99133],      
           [1, 0.99579, 0.99563]]      
      
batlowW_map = LinearSegmentedColormap.from_list('batlowW', cm_data)      
# For use of "viscm view"      
test_cm = batlowW_map      
      
if __name__ == "__main__":      
    import matplotlib.pyplot as plt      
    import numpy as np      
      
    try:      
        from viscm import viscm      
        viscm(batlowW_map)      
    except ImportError:      
        print("viscm not found, falling back on simple display")      
        plt.imshow(np.linspace(0, 100, 256)[None, :], aspect='auto',      
                   cmap=batlowW_map)      
    plt.show()      
