# 
#         batlowWS
#                   www.fabiocrameri.ch/colourmaps
from matplotlib.colors import LinearSegmentedColormap      
      
cm_data = [[1, 0.99579, 0.99563],      
           [0.0046368, 0.098343, 0.34983],      
           [0.48793, 0.52807, 0.21969],      
           [0.90715, 0.67218, 0.51648],      
           [0.12658, 0.37259, 0.38234],      
           [0.066347, 0.26192, 0.37742],      
           [0.99491, 0.81982, 0.80489],      
           [0.74282, 0.61459, 0.26576],      
           [0.28117, 0.45385, 0.31902],      
           [0.61143, 0.57062, 0.19708],      
           [0.049465, 0.19151, 0.36588],      
           [0.84144, 0.64711, 0.39389],      
           [0.086163, 0.31915, 0.38483],      
           [0.96096, 0.71905, 0.64919],      
           [1, 0.91952, 0.91775],      
           [0.38056, 0.49035, 0.26878],      
           [0.1968, 0.41791, 0.35888],      
           [0.43284, 0.50884, 0.24347],      
           [0.15829, 0.39642, 0.37357],      
           [0.074722, 0.29085, 0.38169],      
           [0.98226, 0.76451, 0.72833],      
           [0.059056, 0.23002, 0.37228],      
           [0.031891, 0.14675, 0.35823],      
           [0.93502, 0.68977, 0.57869],      
           [0.5472, 0.54861, 0.20122],      
           [0.87679, 0.65946, 0.45643],      
           [0.99949, 0.87305, 0.86782],      
           [1, 0.96014, 0.95949],      
           [0.33007, 0.47213, 0.29422],      
           [0.10281, 0.34663, 0.38561],      
           [0.79764, 0.63259, 0.32844],      
           [0.67863, 0.5933, 0.21816],      
           [0.24027, 0.43754, 0.33917],      
           [0.98978, 0.79175, 0.76788],      
           [1, 0.9405, 0.93944],      
           [0.21803, 0.42791, 0.34956],      
           [1, 0.97849, 0.97812],      
           [0.94832, 0.7025, 0.61263],      
           [0.11372, 0.35985, 0.38459],      
           [0.45994, 0.51833, 0.23126],      
           [0.35513, 0.48122, 0.28152],      
           [0.070259, 0.27655, 0.37965],      
           [0.079937, 0.30506, 0.38347],      
           [0.57873, 0.55944, 0.19664],      
           [0.85994, 0.65342, 0.42562],      
           [0.97248, 0.73985, 0.68814],      
           [0.054774, 0.21175, 0.36927],      
           [0.019623, 0.12298, 0.35411],      
           [0.042104, 0.16971, 0.36218],      
           [0.40643, 0.49952, 0.25604],      
           [0.99797, 0.8472, 0.83825],      
           [1, 0.89711, 0.89408],      
           [0.82081, 0.64023, 0.36134],      
           [0.9213, 0.67997, 0.54692],      
           [0.14149, 0.3848, 0.3787],      
           [0.77165, 0.62407, 0.2961],      
           [0.17678, 0.40745, 0.36694],      
           [0.093708, 0.33305, 0.38562],      
           [0.51696, 0.53816, 0.20936],      
           [0.71157, 0.60427, 0.23917],      
           [0.062771, 0.2466, 0.37498],      
           [0.89241, 0.66555, 0.48656],      
           [0.3054, 0.463, 0.30678],      
           [0.64495, 0.58198, 0.20402],      
           [0.25755, 0.4446, 0.33077],      
           [0.052254, 0.20184, 0.36761],      
           [0.94173, 0.69571, 0.59535],      
           [0.99984, 0.8853, 0.88132],      
           [1, 0.9085, 0.90619],      
           [0.10799, 0.35329, 0.38524],      
           [0.082923, 0.3121, 0.38421],      
           [0.14967, 0.39069, 0.37633],      
           [0.13379, 0.37877, 0.38071],      
           [0.037367, 0.15836, 0.36022],      
           [0.59495, 0.56499, 0.19612],      
           [0.11987, 0.36629, 0.38364],      
           [0.72745, 0.60953, 0.25188],      
           [0.045968, 0.18076, 0.36406],      
           [1, 0.98726, 0.98699],      
           [0.012565, 0.11082, 0.35198],      
           [0.44629, 0.51356, 0.23733],      
           [0.83142, 0.64375, 0.3777],      
           [0.47381, 0.52317, 0.22535],      
           [0.88473, 0.66248, 0.47156],      
           [0.98632, 0.77792, 0.74832],      
           [0.29322, 0.45844, 0.31294],      
           [0.2693, 0.44924, 0.32496],      
           [0.098076, 0.33988, 0.38573],      
           [0.85092, 0.65032, 0.40988],      
           [0.9282, 0.68456, 0.56259],      
           [0.78501, 0.62845, 0.3121],      
           [0.80957, 0.63652, 0.34489],      
           [0.060869, 0.2385, 0.37367],      
           [0.18661, 0.41276, 0.36308],      
           [0.91428, 0.67588, 0.53159],      
           [0.36778, 0.48577, 0.27515],      
           [0.16734, 0.402, 0.37043],      
           [0.072397, 0.28371, 0.38071],      
           [0.064516, 0.25439, 0.37623],      
           [0.50229, 0.53307, 0.21432]]      
      
batlowWS_map = LinearSegmentedColormap.from_list('batlowWS', cm_data)      
# For use of "viscm view"      
test_cm = batlowWS_map      
      
if __name__ == "__main__":      
    import matplotlib.pyplot as plt      
    import numpy as np      
      
    try:      
        from viscm import viscm      
        viscm(batlowWS_map)      
    except ImportError:      
        print("viscm not found, falling back on simple display")      
        plt.imshow(np.linspace(0, 100, 256)[None, :], aspect='auto',      
                   cmap=batlowWS_map)      
    plt.show()      
