# 
#         batlowS
#                   www.fabiocrameri.ch/colourmaps
from matplotlib.colors import LinearSegmentedColormap      
      
cm_data = [[0.0051932, 0.098238, 0.34984],      
           [0.98135, 0.80041, 0.98127],      
           [0.51125, 0.5109, 0.1933],      
           [0.1333, 0.37528, 0.3794],      
           [0.9507, 0.61665, 0.42862],      
           [0.066899, 0.26319, 0.37759],      
           [0.30238, 0.45028, 0.30012],      
           [0.75427, 0.56503, 0.21176],      
           [0.99277, 0.70769, 0.71238],      
           [0.20908, 0.41741, 0.34968],      
           [0.088353, 0.32217, 0.38473],      
           [0.86517, 0.58588, 0.30225],      
           [0.9886, 0.66138, 0.57526],      
           [0.40297, 0.48047, 0.24473],      
           [0.63151, 0.54075, 0.17007],      
           [0.049378, 0.19108, 0.36581],      
           [0.98875, 0.75395, 0.84663],      
           [0.45577, 0.49558, 0.21777],      
           [0.91275, 0.59919, 0.36099],      
           [0.075833, 0.29332, 0.38192],      
           [0.25445, 0.43453, 0.32643],      
           [0.10684, 0.34977, 0.38455],      
           [0.35198, 0.46544, 0.27249],      
           [0.57002, 0.52619, 0.17527],      
           [0.81169, 0.57519, 0.25257],      
           [0.032053, 0.14677, 0.35824],      
           [0.97584, 0.63801, 0.50183],      
           [0.16795, 0.39789, 0.36778],      
           [0.059164, 0.22984, 0.37225],      
           [0.69372, 0.5538, 0.18261],      
           [0.99112, 0.73049, 0.77861],      
           [0.99281, 0.68482, 0.64542],      
           [0.9855, 0.77838, 0.91744],      
           [0.27817, 0.44252, 0.31355],      
           [0.081553, 0.30786, 0.3836],      
           [0.019936, 0.12298, 0.35412],      
           [0.23136, 0.4262, 0.33857],      
           [0.8899, 0.59209, 0.33045],      
           [0.78342, 0.57016, 0.23096],      
           [0.60052, 0.5336, 0.17065],      
           [0.42909, 0.48801, 0.2311],      
           [0.14971, 0.38698, 0.37445],      
           [0.66269, 0.5475, 0.17404],      
           [0.98357, 0.64959, 0.53882],      
           [0.99148, 0.67316, 0.61084],      
           [0.54023, 0.51858, 0.1831],      
           [0.96494, 0.62693, 0.46486],      
           [0.72432, 0.55963, 0.19541],      
           [0.054721, 0.21123, 0.36918],      
           [0.37729, 0.47295, 0.25859],      
           [0.11899, 0.36285, 0.38271],      
           [0.063071, 0.24709, 0.37505],      
           [0.071115, 0.2785, 0.37989],      
           [0.18789, 0.408, 0.35948],      
           [0.99311, 0.69631, 0.67918],      
           [0.48312, 0.50322, 0.20504],      
           [0.99205, 0.71905, 0.7454],      
           [0.096618, 0.33616, 0.38513],      
           [0.042104, 0.16956, 0.36215],      
           [0.93318, 0.60737, 0.39382],      
           [0.839, 0.58034, 0.27635],      
           [0.98728, 0.76605, 0.8817],      
           [0.32701, 0.4579, 0.28638],      
           [0.99002, 0.7421, 0.81229],      
           [0.98332, 0.79091, 0.95375],      
           [0.045905, 0.18046, 0.36401],      
           [0.41597, 0.48423, 0.23789],      
           [0.67824, 0.55071, 0.1778],      
           [0.87774, 0.58887, 0.31608],      
           [0.9233, 0.60314, 0.37714],      
           [0.76894, 0.56763, 0.22105],      
           [0.94233, 0.61187, 0.41101],      
           [0.24279, 0.43042, 0.33263],      
           [0.5852, 0.52993, 0.17249],      
           [0.064936, 0.25526, 0.37636],      
           [0.052164, 0.20132, 0.36752],      
           [0.98643, 0.77218, 0.89949],      
           [0.15862, 0.39253, 0.37132],      
           [0.6471, 0.54418, 0.17146],      
           [0.98805, 0.75996, 0.86408],      
           [0.084778, 0.31504, 0.38424],      
           [0.10148, 0.34304, 0.38498],      
           [0.26624, 0.43856, 0.32009],      
           [0.99161, 0.72475, 0.76196],      
           [0.33947, 0.46168, 0.27947],      
           [0.14126, 0.38124, 0.37713],      
           [0.07344, 0.28594, 0.38096],      
           [0.39007, 0.47671, 0.25166],      
           [0.31465, 0.45411, 0.29328],      
           [0.069002, 0.27092, 0.37877],      
           [0.49709, 0.50706, 0.19899],      
           [0.057033, 0.22075, 0.37075],      
           [0.85225, 0.58304, 0.28904],      
           [0.012963, 0.11078, 0.35199],      
           [0.79767, 0.57268, 0.24149],      
           [0.9923, 0.67901, 0.62825],      
           [0.17775, 0.40304, 0.36383],      
           [0.52564, 0.51475, 0.18799],      
           [0.82547, 0.57773, 0.2642],      
           [0.037449, 0.15831, 0.36022]]      
      
batlowS_map = LinearSegmentedColormap.from_list('batlowS', cm_data)      
# For use of "viscm view"      
test_cm = batlowS_map      
      
if __name__ == "__main__":      
    import matplotlib.pyplot as plt      
    import numpy as np      
      
    try:      
        from viscm import viscm      
        viscm(batlowS_map)      
    except ImportError:      
        print("viscm not found, falling back on simple display")      
        plt.imshow(np.linspace(0, 100, 256)[None, :], aspect='auto',      
                   cmap=batlowS_map)      
    plt.show()      
