# 
#         bamakoS
#                   www.fabiocrameri.ch/colourmaps
from matplotlib.colors import LinearSegmentedColormap      
      
cm_data = [[0.0011753, 0.25004, 0.3],      
           [0.9999, 0.89988, 0.59995],      
           [0.38057, 0.49296, 0.078304],      
           [0.16705, 0.35489, 0.20248],      
           [0.72588, 0.6474, 0.14503],      
           [0.88958, 0.78905, 0.38098],      
           [0.084163, 0.29972, 0.25365],      
           [0.26278, 0.41728, 0.14546],      
           [0.53601, 0.55933, 0.010585],      
           [0.21297, 0.38493, 0.17486],      
           [0.12416, 0.32653, 0.22873],      
           [0.82142, 0.72482, 0.26361],      
           [0.3179, 0.45289, 0.11362],      
           [0.94603, 0.84535, 0.49169],      
           [0.044597, 0.27432, 0.27734],      
           [0.45421, 0.5344, 0.036906],      
           [0.62581, 0.58551, 0.051565],      
           [0.41578, 0.51431, 0.058651],      
           [0.18959, 0.36966, 0.18887],      
           [0.28956, 0.43459, 0.12989],      
           [0.77702, 0.68709, 0.20308],      
           [0.91835, 0.81764, 0.43686],      
           [0.57835, 0.56824, 0.019098],      
           [0.022743, 0.26208, 0.28878],      
           [0.49497, 0.54985, 0.018512],      
           [0.23735, 0.40078, 0.16037],      
           [0.14528, 0.34051, 0.21578],      
           [0.064737, 0.28684, 0.26564],      
           [0.97318, 0.87268, 0.54594],      
           [0.10384, 0.31294, 0.24134],      
           [0.34812, 0.47233, 0.096453],      
           [0.85818, 0.7586, 0.32333],      
           [0.67856, 0.6148, 0.098456],      
           [0.276, 0.42581, 0.13775],      
           [0.39779, 0.50362, 0.068802],      
           [0.60129, 0.5754, 0.03187],      
           [0.95966, 0.85904, 0.51886],      
           [0.65173, 0.59876, 0.074092],      
           [0.22501, 0.39277, 0.16768],      
           [0.84066, 0.74221, 0.29369],      
           [0.074435, 0.29324, 0.25969],      
           [0.033437, 0.26816, 0.28309],      
           [0.054846, 0.28053, 0.27151],      
           [0.13465, 0.33348, 0.22228],      
           [0.24989, 0.40893, 0.15296],      
           [0.20116, 0.37724, 0.18189],      
           [0.012175, 0.25604, 0.2944],      
           [0.5155, 0.55517, 0.013033],      
           [0.11391, 0.3197, 0.23509],      
           [0.17824, 0.36222, 0.19572],      
           [0.7521, 0.66724, 0.17352],      
           [0.93228, 0.83157, 0.46438],      
           [0.98659, 0.88628, 0.57296],      
           [0.47444, 0.54291, 0.026597],      
           [0.90417, 0.8035, 0.40909],      
           [0.36403, 0.48251, 0.087617],      
           [0.4346, 0.5247, 0.047969],      
           [0.3035, 0.44361, 0.12179],      
           [0.33277, 0.46245, 0.10513],      
           [0.55677, 0.56328, 0.012516],      
           [0.093906, 0.3063, 0.24754],      
           [0.15607, 0.34765, 0.20917],      
           [0.87436, 0.77414, 0.35241],      
           [0.80021, 0.7064, 0.23325],      
           [0.70569, 0.63293, 0.12447],      
           [0.89694, 0.79632, 0.39508],      
           [0.93918, 0.83847, 0.47804],      
           [0.11904, 0.32311, 0.23191],      
           [0.17259, 0.35853, 0.1991],      
           [0.88207, 0.78167, 0.36676],      
           [0.46428, 0.53884, 0.031435],      
           [0.35601, 0.47738, 0.092102],      
           [0.50524, 0.55269, 0.015412],      
           [0.81106, 0.71574, 0.24845],      
           [0.37221, 0.48772, 0.082993],      
           [0.10884, 0.31632, 0.23821],      
           [0.29648, 0.43906, 0.12588],      
           [0.26935, 0.42151, 0.14161],      
           [0.9799, 0.87948, 0.55945],      
           [0.52575, 0.55735, 0.011416],      
           [0.61335, 0.58006, 0.041287],      
           [0.63862, 0.59176, 0.062625],      
           [0.19535, 0.37344, 0.18542],      
           [0.34037, 0.46736, 0.10085],      
           [0.40668, 0.50898, 0.063774],      
           [0.069647, 0.29003, 0.26267],      
           [0.42509, 0.51956, 0.053359],      
           [0.66506, 0.60647, 0.085984],      
           [0.24357, 0.40482, 0.15671],      
           [0.84961, 0.75052, 0.30859],      
           [0.69213, 0.62366, 0.11129],      
           [0.18387, 0.36593, 0.1923],      
           [0.25629, 0.41308, 0.14922],      
           [0.20706, 0.38108, 0.17841],      
           [0.78886, 0.69684, 0.21813],      
           [0.73912, 0.65728, 0.15912],      
           [0.21898, 0.38884, 0.17127],      
           [0.56742, 0.56555, 0.015118],      
           [0.96643, 0.86586, 0.53241],      
           [0.76475, 0.67721, 0.18823]]      
      
bamakoS_map = LinearSegmentedColormap.from_list('bamakoS', cm_data)      
# For use of "viscm view"      
test_cm = bamakoS_map      
      
if __name__ == "__main__":      
    import matplotlib.pyplot as plt      
    import numpy as np      
      
    try:      
        from viscm import viscm      
        viscm(bamakoS_map)      
    except ImportError:      
        print("viscm not found, falling back on simple display")      
        plt.imshow(np.linspace(0, 100, 256)[None, :], aspect='auto',      
                   cmap=bamakoS_map)      
    plt.show()      
