# 
#         bam
#                   www.fabiocrameri.ch/colourmaps
from matplotlib.colors import LinearSegmentedColormap      
      
cm_data = [[0.39622, 0.0081199, 0.29605],      
           [0.40507, 0.018136, 0.30473],      
           [0.41391, 0.028663, 0.31342],      
           [0.4227, 0.0401, 0.32208],      
           [0.43148, 0.051043, 0.33072],      
           [0.44019, 0.06117, 0.33935],      
           [0.44885, 0.070776, 0.34792],      
           [0.45745, 0.079825, 0.35645],      
           [0.46599, 0.088578, 0.36492],      
           [0.47448, 0.096961, 0.37335],      
           [0.48289, 0.10516, 0.38173],      
           [0.49125, 0.11322, 0.39005],      
           [0.49951, 0.12098, 0.39832],      
           [0.50774, 0.12868, 0.40652],      
           [0.51586, 0.13623, 0.41466],      
           [0.52394, 0.14372, 0.42273],      
           [0.53194, 0.15107, 0.43074],      
           [0.53985, 0.15837, 0.43868],      
           [0.5477, 0.16553, 0.44655],      
           [0.55546, 0.17269, 0.45435],      
           [0.56315, 0.17977, 0.46207],      
           [0.57075, 0.1868, 0.46972],      
           [0.57827, 0.19379, 0.47728],      
           [0.58572, 0.20069, 0.48477],      
           [0.59306, 0.2076, 0.49219],      
           [0.60032, 0.21444, 0.49952],      
           [0.6075, 0.22126, 0.50677],      
           [0.61457, 0.22804, 0.51394],      
           [0.62157, 0.23479, 0.52102],      
           [0.62847, 0.2415, 0.52801],      
           [0.63526, 0.24819, 0.53492],      
           [0.64197, 0.25485, 0.54174],      
           [0.64857, 0.26148, 0.54848],      
           [0.65507, 0.26808, 0.55512],      
           [0.66148, 0.27469, 0.56168],      
           [0.66779, 0.28127, 0.56814],      
           [0.67398, 0.28785, 0.57452],      
           [0.68008, 0.29442, 0.58082],      
           [0.68609, 0.301, 0.58704],      
           [0.69201, 0.30758, 0.59318],      
           [0.69782, 0.31419, 0.59926],      
           [0.70357, 0.32083, 0.60526],      
           [0.70924, 0.32749, 0.61122],      
           [0.71483, 0.33423, 0.61713],      
           [0.72036, 0.341, 0.623],      
           [0.72584, 0.34786, 0.62883],      
           [0.73125, 0.35481, 0.63464],      
           [0.73661, 0.36183, 0.64043],      
           [0.74193, 0.36895, 0.6462],      
           [0.7472, 0.37618, 0.65196],      
           [0.75241, 0.38351, 0.6577],      
           [0.75758, 0.39094, 0.66342],      
           [0.7627, 0.39847, 0.66912],      
           [0.76776, 0.40612, 0.67481],      
           [0.77276, 0.41386, 0.68048],      
           [0.77771, 0.4217, 0.68613],      
           [0.78259, 0.42965, 0.69176],      
           [0.78741, 0.4377, 0.69736],      
           [0.79216, 0.44581, 0.70293],      
           [0.79684, 0.45404, 0.70848],      
           [0.80146, 0.46233, 0.71399],      
           [0.80601, 0.47072, 0.71947],      
           [0.81048, 0.47917, 0.72492],      
           [0.81488, 0.48769, 0.73033],      
           [0.81921, 0.49627, 0.73571],      
           [0.82346, 0.50492, 0.74104],      
           [0.82765, 0.51362, 0.74635],      
           [0.83177, 0.52236, 0.75162],      
           [0.83581, 0.53116, 0.75684],      
           [0.83979, 0.53999, 0.76202],      
           [0.84369, 0.54887, 0.76717],      
           [0.84754, 0.55777, 0.77228],      
           [0.85131, 0.56669, 0.77736],      
           [0.85504, 0.57564, 0.78239],      
           [0.85869, 0.5846, 0.78739],      
           [0.8623, 0.59357, 0.79234],      
           [0.86584, 0.60255, 0.79726],      
           [0.86933, 0.61153, 0.80215],      
           [0.87276, 0.62051, 0.807],      
           [0.87615, 0.62948, 0.8118],      
           [0.87948, 0.63844, 0.81658],      
           [0.88277, 0.64739, 0.82131],      
           [0.88602, 0.65632, 0.82601],      
           [0.88922, 0.66521, 0.83067],      
           [0.89238, 0.67407, 0.83528],      
           [0.89549, 0.6829, 0.83986],      
           [0.89856, 0.69169, 0.84439],      
           [0.90159, 0.70042, 0.84888],      
           [0.90457, 0.70911, 0.85332],      
           [0.90751, 0.71772, 0.85771],      
           [0.9104, 0.72627, 0.86206],      
           [0.91325, 0.73474, 0.86634],      
           [0.91604, 0.74314, 0.87055],      
           [0.9188, 0.75144, 0.87471],      
           [0.9215, 0.75964, 0.87881],      
           [0.92415, 0.76775, 0.88283],      
           [0.92674, 0.77576, 0.88678],      
           [0.92928, 0.78365, 0.89064],      
           [0.93177, 0.79142, 0.89443],      
           [0.93419, 0.79908, 0.89813],      
           [0.93656, 0.80661, 0.90174],      
           [0.93885, 0.814, 0.90525],      
           [0.94108, 0.82127, 0.90866],      
           [0.94324, 0.82839, 0.91197],      
           [0.94533, 0.83537, 0.91516],      
           [0.94733, 0.84221, 0.91824],      
           [0.94926, 0.84888, 0.9212],      
           [0.95111, 0.85541, 0.92403],      
           [0.95287, 0.86176, 0.92672],      
           [0.95453, 0.86794, 0.92927],      
           [0.9561, 0.87394, 0.93168],      
           [0.95757, 0.87977, 0.93392],      
           [0.95894, 0.8854, 0.93602],      
           [0.9602, 0.89084, 0.93793],      
           [0.96134, 0.89607, 0.93967],      
           [0.96236, 0.9011, 0.94123],      
           [0.96327, 0.90592, 0.94261],      
           [0.96405, 0.91051, 0.94378],      
           [0.96471, 0.91487, 0.94476],      
           [0.96523, 0.919, 0.94553],      
           [0.96563, 0.92291, 0.9461],      
           [0.96588, 0.92657, 0.94645],      
           [0.966, 0.92999, 0.94659],      
           [0.96599, 0.93316, 0.94651],      
           [0.96583, 0.93609, 0.94622],      
           [0.96554, 0.93877, 0.94571],      
           [0.96511, 0.9412, 0.94499],      
           [0.96454, 0.9434, 0.94404],      
           [0.96383, 0.94536, 0.94287],      
           [0.96298, 0.9471, 0.94147],      
           [0.96198, 0.94861, 0.93985],      
           [0.96083, 0.94991, 0.93797],      
           [0.95951, 0.95101, 0.93584],      
           [0.95802, 0.95192, 0.93343],      
           [0.95635, 0.95263, 0.93074],      
           [0.95449, 0.95316, 0.92775],      
           [0.95243, 0.9535, 0.92445],      
           [0.95018, 0.95364, 0.92084],      
           [0.94772, 0.9536, 0.91691],      
           [0.94506, 0.95337, 0.91265],      
           [0.94219, 0.95294, 0.90808],      
           [0.93911, 0.95231, 0.90317],      
           [0.93583, 0.9515, 0.89793],      
           [0.93232, 0.95049, 0.89238],      
           [0.92861, 0.94929, 0.8865],      
           [0.92469, 0.9479, 0.8803],      
           [0.92056, 0.94632, 0.87378],      
           [0.91622, 0.94455, 0.86694],      
           [0.91167, 0.94259, 0.8598],      
           [0.90691, 0.94044, 0.85234],      
           [0.90194, 0.93811, 0.84457],      
           [0.89675, 0.9356, 0.8365],      
           [0.89134, 0.93289, 0.82813],      
           [0.88573, 0.93002, 0.81946],      
           [0.87989, 0.92695, 0.81049],      
           [0.87384, 0.92372, 0.80124],      
           [0.86757, 0.92029, 0.79171],      
           [0.86107, 0.91669, 0.7819],      
           [0.85436, 0.9129, 0.77181],      
           [0.84743, 0.90894, 0.76146],      
           [0.84028, 0.9048, 0.75086],      
           [0.8329, 0.90047, 0.74001],      
           [0.82531, 0.89598, 0.72893],      
           [0.81751, 0.8913, 0.71765],      
           [0.8095, 0.88646, 0.70616],      
           [0.80128, 0.88143, 0.69448],      
           [0.79287, 0.87624, 0.68265],      
           [0.78427, 0.87089, 0.67069],      
           [0.77548, 0.86538, 0.65859],      
           [0.76653, 0.85971, 0.6464],      
           [0.75741, 0.85388, 0.63415],      
           [0.74814, 0.84792, 0.62183],      
           [0.73874, 0.84182, 0.6095],      
           [0.7292, 0.83558, 0.59716],      
           [0.71956, 0.82921, 0.58485],      
           [0.70982, 0.82273, 0.57258],      
           [0.69999, 0.81614, 0.56037],      
           [0.69009, 0.80945, 0.54826],      
           [0.68013, 0.80266, 0.53625],      
           [0.67015, 0.79579, 0.52437],      
           [0.66013, 0.78885, 0.51264],      
           [0.6501, 0.78184, 0.50108],      
           [0.64007, 0.77477, 0.48969],      
           [0.63005, 0.76767, 0.47851],      
           [0.62007, 0.76053, 0.46753],      
           [0.61012, 0.75335, 0.45676],      
           [0.60022, 0.74616, 0.44621],      
           [0.59038, 0.73896, 0.4359],      
           [0.58061, 0.73174, 0.42581],      
           [0.57091, 0.72454, 0.41596],      
           [0.5613, 0.71735, 0.40635],      
           [0.55179, 0.71016, 0.39696],      
           [0.54235, 0.703, 0.38782],      
           [0.53302, 0.69587, 0.37891],      
           [0.52379, 0.68877, 0.37022],      
           [0.51467, 0.68169, 0.36177],      
           [0.50563, 0.67467, 0.35351],      
           [0.49672, 0.66769, 0.34547],      
           [0.48792, 0.66074, 0.33764],      
           [0.47922, 0.65385, 0.33],      
           [0.47063, 0.64701, 0.32255],      
           [0.46214, 0.64023, 0.31526],      
           [0.45376, 0.63349, 0.30815],      
           [0.44549, 0.62681, 0.3012],      
           [0.43734, 0.62019, 0.29442],      
           [0.42927, 0.61361, 0.28778],      
           [0.4213, 0.60712, 0.28129],      
           [0.41345, 0.60066, 0.27494],      
           [0.4057, 0.59428, 0.26872],      
           [0.39803, 0.58794, 0.2626],      
           [0.39046, 0.58168, 0.2566],      
           [0.383, 0.57548, 0.25072],      
           [0.37561, 0.56932, 0.24493],      
           [0.36833, 0.56324, 0.23926],      
           [0.36112, 0.5572, 0.23365],      
           [0.354, 0.55121, 0.22817],      
           [0.34697, 0.54527, 0.22273],      
           [0.33999, 0.53938, 0.21736],      
           [0.33309, 0.53352, 0.21206],      
           [0.3262, 0.5277, 0.20681],      
           [0.3194, 0.52189, 0.20156],      
           [0.3126, 0.51609, 0.19642],      
           [0.30586, 0.51031, 0.19123],      
           [0.2991, 0.50452, 0.18609],      
           [0.29233, 0.4987, 0.18091],      
           [0.28555, 0.49285, 0.17574],      
           [0.27878, 0.48699, 0.17058],      
           [0.27195, 0.48108, 0.16536],      
           [0.26511, 0.47515, 0.16012],      
           [0.25823, 0.46916, 0.15488],      
           [0.25134, 0.4631, 0.14961],      
           [0.24435, 0.45702, 0.14426],      
           [0.23738, 0.45089, 0.13886],      
           [0.2303, 0.44471, 0.13344],      
           [0.22322, 0.43847, 0.12797],      
           [0.21608, 0.43219, 0.12239],      
           [0.20886, 0.42584, 0.11683],      
           [0.20159, 0.41947, 0.11121],      
           [0.19432, 0.41303, 0.10546],      
           [0.18691, 0.40654, 0.099681],      
           [0.17946, 0.4, 0.093826],      
           [0.17194, 0.39342, 0.087904],      
           [0.16436, 0.38679, 0.081888],      
           [0.15666, 0.38012, 0.075659],      
           [0.14884, 0.37339, 0.069479],      
           [0.14097, 0.36663, 0.06304],      
           [0.13291, 0.3598, 0.056434],      
           [0.1247, 0.35294, 0.049637],      
           [0.11638, 0.34602, 0.04255],      
           [0.10778, 0.33909, 0.035407],      
           [0.098981, 0.3321, 0.028358],      
           [0.0899, 0.32505, 0.021963],      
           [0.080424, 0.318, 0.016],      
           [0.070529, 0.31091, 0.010244],      
           [0.060124, 0.30378, 0.0051395],      
           [0.049098, 0.29666, 0]]      
      
bam_map = LinearSegmentedColormap.from_list('bam', cm_data)      
# For use of "viscm view"      
test_cm = bam_map      
      
if __name__ == "__main__":      
    import matplotlib.pyplot as plt      
    import numpy as np      
      
    try:      
        from viscm import viscm      
        viscm(bam_map)      
    except ImportError:      
        print("viscm not found, falling back on simple display")      
        plt.imshow(np.linspace(0, 100, 256)[None, :], aspect='auto',      
                   cmap=bam_map)      
    plt.show()      
