# 
#         actonS
#                   www.fabiocrameri.ch/colourmaps
from matplotlib.colors import LinearSegmentedColormap      
      
cm_data = [[0.18063, 0.12992, 0.30024],      
           [0.90047, 0.90012, 0.94005],      
           [0.76786, 0.4312, 0.60779],      
           [0.46779, 0.35109, 0.52396],      
           [0.82977, 0.65598, 0.77186],      
           [0.83411, 0.55045, 0.69646],      
           [0.62402, 0.39717, 0.57513],      
           [0.31231, 0.24467, 0.41609],      
           [0.85425, 0.77147, 0.85212],      
           [0.83003, 0.6023, 0.73378],      
           [0.38631, 0.30175, 0.47358],      
           [0.54988, 0.38348, 0.55842],      
           [0.82315, 0.4919, 0.65366],      
           [0.69317, 0.40397, 0.58441],      
           [0.24481, 0.1865, 0.35762],      
           [0.87628, 0.83514, 0.89573],      
           [0.83846, 0.71388, 0.81235],      
           [0.27798, 0.2155, 0.38677],      
           [0.42634, 0.32799, 0.50023],      
           [0.34832, 0.27367, 0.44523],      
           [0.8013, 0.45945, 0.62948],      
           [0.5881, 0.39224, 0.56862],      
           [0.8648, 0.80309, 0.87381],      
           [0.2125, 0.15792, 0.32875],      
           [0.50944, 0.36981, 0.54359],      
           [0.83229, 0.57653, 0.7153],      
           [0.83294, 0.6844, 0.79181],      
           [0.72988, 0.41285, 0.59277],      
           [0.65846, 0.40013, 0.57961],      
           [0.8326, 0.52267, 0.67625],      
           [0.88827, 0.86752, 0.91783],      
           [0.82892, 0.62865, 0.75254],      
           [0.84505, 0.74043, 0.83074],      
           [0.2286, 0.17214, 0.34314],      
           [0.78567, 0.44434, 0.61799],      
           [0.67566, 0.40171, 0.58178],      
           [0.89437, 0.8838, 0.92892],      
           [0.83106, 0.67005, 0.78176],      
           [0.71122, 0.40747, 0.58792],      
           [0.85939, 0.78722, 0.86294],      
           [0.3301, 0.25925, 0.43071],      
           [0.56929, 0.38842, 0.56407],      
           [0.87045, 0.81906, 0.88475],      
           [0.84946, 0.75587, 0.84139],      
           [0.83339, 0.56361, 0.70598],      
           [0.81391, 0.47561, 0.64158],      
           [0.48868, 0.36105, 0.53435],      
           [0.83542, 0.69901, 0.80201],      
           [0.26128, 0.20094, 0.37216],      
           [0.83402, 0.53689, 0.6866],      
           [0.8292, 0.50768, 0.66527],      
           [0.82927, 0.61537, 0.74311],      
           [0.44695, 0.34002, 0.51254],      
           [0.83109, 0.58938, 0.72453],      
           [0.82907, 0.64218, 0.76212],      
           [0.36706, 0.28787, 0.45956],      
           [0.60631, 0.39509, 0.57225],      
           [0.88223, 0.85129, 0.90676],      
           [0.52989, 0.37729, 0.55162],      
           [0.29496, 0.23008, 0.40143],      
           [0.64132, 0.39875, 0.57749],      
           [0.74895, 0.42065, 0.59933],      
           [0.19655, 0.14383, 0.31444],      
           [0.40611, 0.31519, 0.4872],      
           [0.84205, 0.72897, 0.82282],      
           [0.84019, 0.7214, 0.81757],      
           [0.82904, 0.62198, 0.74781],      
           [0.88524, 0.8594, 0.91229],      
           [0.20451, 0.15085, 0.32158],      
           [0.59728, 0.39377, 0.57054],      
           [0.83382, 0.55707, 0.70125],      
           [0.49909, 0.36559, 0.53912],      
           [0.41617, 0.32167, 0.4938],      
           [0.8296, 0.60882, 0.73843],      
           [0.83119, 0.51528, 0.67085],      
           [0.81895, 0.48377, 0.64766],      
           [0.83287, 0.57008, 0.71065],      
           [0.2367, 0.17931, 0.35037],      
           [0.57878, 0.39046, 0.56647],      
           [0.70211, 0.40553, 0.58603],      
           [0.43661, 0.33412, 0.50649],      
           [0.82935, 0.64904, 0.76697],      
           [0.85678, 0.77932, 0.85752],      
           [0.47824, 0.35622, 0.5293],      
           [0.83034, 0.66298, 0.77679],      
           [0.30359, 0.23742, 0.40876],      
           [0.85181, 0.76365, 0.84674],      
           [0.32115, 0.25198, 0.4234],      
           [0.80802, 0.46745, 0.6355],      
           [0.63271, 0.39801, 0.57637],      
           [0.83687, 0.70642, 0.80717],      
           [0.73939, 0.41642, 0.59581],      
           [0.72047, 0.40989, 0.59014],      
           [0.8676, 0.81107, 0.87927],      
           [0.55967, 0.38609, 0.56139],      
           [0.66704, 0.40088, 0.58066],      
           [0.89132, 0.87565, 0.92337],      
           [0.22054, 0.165, 0.33593],      
           [0.89742, 0.89195, 0.93448],      
           [0.35764, 0.28079, 0.45243]]      
      
actonS_map = LinearSegmentedColormap.from_list('actonS', cm_data)      
# For use of "viscm view"      
test_cm = actonS_map      
      
if __name__ == "__main__":      
    import matplotlib.pyplot as plt      
    import numpy as np      
      
    try:      
        from viscm import viscm      
        viscm(actonS_map)      
    except ImportError:      
        print("viscm not found, falling back on simple display")      
        plt.imshow(np.linspace(0, 100, 256)[None, :], aspect='auto',      
                   cmap=actonS_map)      
    plt.show()      
