#!/usr/bin/env python3

import os
import math
import tensorflow as tf
import pandas as pd
import keras
from keras import layers
from tensorflow import data as tf_data
import random
import numpy as np
import autoAnalysis
from sklearn.preprocessing import StandardScaler
from sklearn.metrics import classification_report, accuracy_score


class TransLayers(layers.Layer):
    def __init__(self, embed_dim, num_heads, ftp_dim, rate=0.1):
        super(TransLayers, self).__init__()
        self.mlp_layers = []
        # parametreleri
        self.att = layers.MultiHeadAttention(num_heads=num_heads, key_dim=embed_dim)
        # Create multiple layers of the MLP.
        for block_idx in range(NUM_CLASSES):
            # Create a multi-head attention layer.
            attention_output = layers.MultiHeadAttention(
                num_heads=num_heads,
                key_dim=embedding_dims,
                dropout=dropout_rate,
                name=f"multihead_attention_{block_idx}",
            )(encoded_numerical_features, encoded_numerical_features)
            # attention connection
            self.att = layers.Add(name=f"attention_{block_idx}")(
                [attention_output, encoded_numerical_features]
            )
            # Layer normalization
            atte_layer = layers.LayerNormalization(name=f"layer_norm1_{block_idx}", epsilon=1e-6)(self.att)
            self.att = layers.Add(name=f"aonnection_{block_idx}")([atte_output, self.att])

        self.ffn = keras.Sequential(
            [layers.Dense(ftp_dim, activation="relu"), layers.Dense(embed_dim),]
        )
        # batch-layer
        for units in hidden_units:
            self.mlp_layers.append(normalization_layer(epsilon=1e-6)),
            self.mlp_layers.append(layers.Dense(units, activation=activation))
            self.mlp_layers.append(layers.Dropout(dropout_rate))
        #
        self.mlp_layers.append(self.att)

    def call(self, inputs, training):
        attn_output = self.att(inputs, inputs)
        out1 = self.layernorm1(inputs + attn_output)
        ffn_output = self.ffn(out1)
        return self.layernorm2(out1 + ffn_output)

class MLP_modification(keras.Model):

    def __init__(self, 
            num_continuous,
            dim_in,
            dim_out,
            depth,
            heads,
            attn_dropout,
            ftp_dropout_rate,
            mlp_hidden,
            normalize_continuous = True):
        """  MLP model constructor
        Args:
            dim_in (int): dimension of each embedding layer output
            dim_out (int): output dimension of the model
            depth (int): number of MLP to stack
            heads (int): number of attention heads
            attn_dropout (float): dropout to use in attention layer of MLP
            ftp_dropout_rate (float): dropout to use in feed-forward layer of MLP
            mlp_hidden (list): list of tuples, indicating the size of the mlp layers and
                their activation functions
            normalize_continuous (boolean): whether the continuous features are normalized
        """
        super(MLP_modification, self).__init__()

        # --> continuous inputs
        self.normalize_continuous = normalize_continuous
        if normalize_continuous:
            self.continuous_normalization = layers.LayerNormalization()

        # embedding
        self.embedding_layers = []
        for number_of_classes in categories:
            self.embedding_layers.append(layers.Embedding(input_dim = number_of_classes, output_dim = dim_out))

        # concatenation
        self.embedded_concatenation = layers.Concatenate(axis=1)

        # adding MLP
        self.MLP_layers = []
        for _ in range(depth):
            self.MLP_layers.append(TransLayers(dim_in, heads, dim_in))

        # MLP connection
        self.pre_mlp_concatenation = layers.Concatenate()

        # mlp layers
        self.mlp_layers = []
        for size, activation in mlp_hidden:
            self.mlp_layers.append(layers.Dense(size, activation=activation))

        self.output_layer = layers.Dense(units=NUM_CLASSES, activation="softmax")(features)

    def call(self, inputs):
        
        # normalization
        if self.normalize_continuous:
            continuous_inputs = self.continuous_normalization(continuous_inputs)

        #  MLP
        mlp_input = self.pre_mlp_concatenation([continuous_inputs])
        for mlp_layer in self.mlp_layers:
            mlp_input = mlp_layer(mlp_input)

        return self.output_layer(mlp_input)
