#!/usr/bin/env python3

import pandas as pd
import numpy as np
import random
import os
import math
import tensorflow as tf
import keras
from keras import layers
import autoAnalysis
from autoAnalysis import run_experiment
from tensorflow import data as tf_data
#
from keras.layers import StringLookup
from sklearn import metrics
from sklearn.metrics import accuracy_score  
#
#


#
#
def scale_data_teil(data):
	col_end = data.shape[1] - 1
	targets = data.iloc[:,col_end].values
	vorData = data.drop(data.columns[col_end], axis=1)
	#
	# Define the scaler 
	scaler = StandardScaler().fit(vorData)
	vorData_scale = scaler.transform(vorData)
	vorData_scale = pd.DataFrame(vorData_scale) * 10
	for c in vorData_scale.columns:
			vorData_scale[c] = vorData_scale[c].astype(int)
	scaleData = pd.concat([vorData_scale.reset_index(drop=True), pd.DataFrame(targets)], axis=1)
	return(scaleData)
#
#

#
def run_valid2_parallel(create_mod, input_file, valid_1_file, valid_2_file, num_epochs, split_round):
	""" """  
	record = []
	record2 = []
	bestModel = ''
	valid_2_dat = get_dataset_from_csv(valid_2_file, batch_size, shuffle=True)
	#
	for lev in range(split_round):
		print(f"round: {lev}")
		model_trial = create_mod()
		res = run_experiment(model_trial, input_file, valid_1_file, num_epochs)
		if len(record)>0:
			if res > max(record):
				bestModel = model_trial
		else:
			bestModel = model_trial
		record.append(res)
		_, accuracy2 = bestModel.evaluate(valid_2_dat, verbose=0)
		res2 = round(accuracy2 * 100, 2)
		record2.append(res2)
	#
	lower, upper = median_confidence_interval_percentile(record)
	print(f"valid1 median: {np.median(record)} \t 95% CI: {lower} - {upper}")
	lower2, upper2 = median_confidence_interval_percentile(record2)
	print(f"valid2 median: {np.median(record2)} \t 95% CI: {lower2} - {upper2}")
	#
	return bestModel
#
#

#
def median_confidence_interval_percentile(data, confidence=0.95):
    lower = np.percentile(data, (1 - confidence) / 2 * 100)
    upper = np.percentile(data, (1 + confidence) / 2 * 100)
    return lower, upper
#

#
def get_dataset_from_csv(csv_file_path, batch_size, shuffle=False):
    dataset = tf_data.experimental.make_csv_dataset(
        csv_file_path,
        batch_size=batch_size,
        column_names=CSV_HEADER,
        column_defaults=COLUMN_DEFAULTS,
        label_name=TARGET_FEATURE_NAME,
        num_epochs=1,
        header=True,
        shuffle=shuffle,
    )
    return dataset.cache()
#
#

#
def create_model_inputs():
    inputs = {}
    for feature_name in FEATURE_NAMES:
        if feature_name in NUMERIC_FEATURE_NAMES:
            inputs[feature_name] = layers.Input(
                name=feature_name, shape=(), dtype="float32"
            )
        else:
            inputs[feature_name] = layers.Input(
                name=feature_name, shape=(), dtype="string"
            )
    return inputs
#
#

#
def encode_inputs(inputs, use_embedding=False):
    encoded_features = []
    for feature_name in inputs:
        if feature_name in CATEGORICAL_FEATURE_NAMES:
            vocabulary = CATEGORICAL_FEATURES_WITH_VOCABULARY[feature_name]
            lookup = layers.StringLookup(
                vocabulary=vocabulary,
                mask_token=None,
                num_oov_indices=0,
                output_mode="int" if use_embedding else "binary",
            )
            if use_embedding:
                # Convert the string input values into integer indices.
                encoded_feature = lookup(inputs[feature_name])
                embedding_dims = int(math.sqrt(len(vocabulary)))
                # Create an embedding layer with the specified dimensions.
                embedding = layers.Embedding(
                    input_dim=len(vocabulary), output_dim=embedding_dims
                )
                # Convert the index values to embedding representations.
                encoded_feature = embedding(encoded_feature)
            else:
                # Convert the string input values into a one hot encoding.
                encoded_feature = lookup(
                    tf.expand_dims(inputs[feature_name], -1)
                )
        else:
            # Use the numerical features as-is.
            encoded_feature = tf.expand_dims(inputs[feature_name], -1)
        #
        encoded_features.append(encoded_feature)
    #
    all_features = layers.concatenate(encoded_features)
    return all_features
#
#

######
#
#
#
def create_mlp(hidden_units, dropout_rate, activation, normalization_layer, name=None):
    mlp_layers = []
    for units in hidden_units:
        mlp_layers.append(normalization_layer()),
        mlp_layers.append(layers.Dense(units, activation=activation))
        mlp_layers.append(layers.Dropout(dropout_rate))
    #
    # Create multiple layers of the Transformer.
    for block_idx in range(NUM_CLASSES):
        # Create a multi-head attention layer.
        attention_output = layers.MultiHeadAttention(
            num_heads=num_heads,
            key_dim=embedding_dims,
            dropout=dropout_rate,
            name=f"multihead_attention_{block_idx}",
        )(encoded_numerical_features, encoded_numerical_features)
        #connection 1.
        atte_layer = layers.Add(name=f"attention_{block_idx}")(
            [attention_output, encoded_numerical_features]
        )
        # Layer normalization 1.
        atte_layer = layers.LayerNormalization(name=f"layer_norm1_{block_idx}", epsilon=1e-6)(atte_layer)
        #connection 2.
        atte_layer = layers.Add(name=f"aonnection_{block_idx}")([atte_output, x])
    #    
    mlp_layers.append(attention_layer)
    #
    return keras.Sequential(mlp_layers, name=name)
#

#
def create_base_MLP(
    embedding_dims, num_mlp_blocks, mlp_hidden_units_factors, dropout_rate
):
    # Create model inputs.
    inputs = create_model_inputs()
    # encode features.
    encoded_categorical_feature_list, numerical_feature_list = encode_inputs_trans(
        inputs, embedding_dims
    )
    # Concatenate all features.
    features = layers.concatenate(
        encoded_categorical_feature_list + numerical_feature_list
    )
    # Compute Feedforward layer units.
    feedforward_units = [features.shape[-1]]
    #
    # Create several feedforwad layers with skip connections.
    for layer_idx in range(num_mlp_blocks):
        features = create_mlp(
            hidden_units=feedforward_units,
            dropout_rate=dropout_rate,
            activation=keras.activations.gelu,
            normalization_layer=layers.LayerNormalization,
            name=f"feedforward_{layer_idx}",
        )(features)
    #
    # Compute MLP hidden_units.
    mlp_hidden_units = [
        factor * features.shape[-1] for factor in mlp_hidden_units_factors
    ]
    # Create final MLP.
    features = create_mlp(
        hidden_units=mlp_hidden_units,
        dropout_rate=dropout_rate,
        activation=keras.activations.selu,
        normalization_layer=layers.BatchNormalization,
        name="MLP",
    )(features)
    #
    outputs = layers.Dense(units=NUM_CLASSES, activation="softmax")(features)
    model = keras.Model(inputs=inputs, outputs=outputs)
    return model
#
#