# CoNFILD
## Create python Environment

create a conda environment named "CoNFiLD"

1. install `conda` managed packages
    ```bash
    conda env create -f env.yml
    ```
2. install `pip` managed packages
    ```bash
    pip install -r requirements_pip.txt
    ```

## Download data & trained model 
* input files: download from [Google drive](https://drive.google.com/drive/folders/1-o50dN5IWK8KGhXFa71E1Gx-TXxTtwCg?usp=sharing). Save the folder `input` to the same location as this readme file
    ```
    input # all the input files
    |
    |-- random_sensor # sensor measurements
    |  |
    |  |-- number of sensors
    |  |-- ...
    | 
    |-- CNF_data # Files for CNF decoding
    |  |
    |  |-- coords.npy # query coordinates
    |  |-- infos.npz  # geometry mask data
    ```

* trained model paramters: download from [Google drive](https://drive.google.com/drive/folders/1-o50dN5IWK8KGhXFa71E1Gx-TXxTtwCg?usp=sharing). Save the folder `model_params` to the same location as this readme file
    ```
    model_params
    |
    |-- checkpoint_20000.pt # trainable parameters for the CNF part
    |
    |-- ema_0.9999_400000.pt # trainable parameters for the diffusion model part
    |
    |-- Hirachical2-11-11_normalizer_params.pt # normalization parameters for CNF
    ```
## Generate samples using `inference/inference_phy_random_sensor.ipynb`. Please follow the instructions in the Jupyter Notebook






