clear; clc; close all;

% Analytical Crank - Rocker Position Analysis Script
% Cem Aygul - April 2023
% All units in mm, degrees
% 
% a = 5.13; % crank
% b = 19.49; % coupler
% c = 22.96; % rockerc
% d = 33.84; % ground

a = 5.13; % crank
b = 19.49; % coupler
c = 25; % rockerc
d = 33.84; % ground

% delta =  254.1600; % coupler angle
e = 50; % coupler point length

delta =  235; % coupler angle
% e = 32.76; % coupler point length


Ax_array = [];
Ay_array = [];

Bx_array = [];
By_array = [];

Cx_array = [];
Cy_array = [];



for theta2 = 0:1:360
Ax = a*cosd(theta2);
Ay = a*sind(theta2);

S = (a^2 - b^2 + c^2 - d^2)/(2*(Ax-d));
P = Ay^2/(Ax - d)^2 + 1;
R = (d - S)^2 - c^2;
Q = (2 * Ay * (d - S))/(Ax - d);

By_1 = (- Q + sqrt(Q^2 - 4*P*R))/(2*P);
By_2 = (- Q - sqrt(Q^2 - 4*P*R))/(2*P);

By = By_1;

Bx = S - (2*Ay*By)/(2*(Ax - d));

theta3 = atan2d((By - Ay),(Bx - Ax));
theta4 = atan2d(By,(Bx - d));

Cx = a*cosd(theta2) + e*cosd(theta3 + delta);
Cy = a*sind(theta2) + e*sind(theta3 + delta);

Ax_array = [Ax_array Ax];
Ay_array = [Ay_array Ay];

Bx_array = [Bx_array Bx];
By_array = [By_array By];

Cx_array = [Cx_array Cx];
Cy_array = [Cy_array Cy];



plot([0 Ax_array(theta2+1)],[0 Ay_array(theta2+1)],'b','LineWidth',1.75); hold on;
plot([d Bx_array(theta2+1)],[0 By_array(theta2+1)],'b','LineWidth',1.75);
plot([Ax_array(theta2+1) Bx_array(theta2+1)],[Ay_array(theta2+1) By_array(theta2+1)],'g','LineWidth',1.75); 
plot([Ax_array(theta2+1) Cx_array(theta2+1)],[Ay_array(theta2+1) Cy_array(theta2+1)],'g','LineWidth',1.75); 
plot(Ax_array,Ay_array,'k'); 
plot(Bx_array,By_array,'k'); 
plot(Cx_array,Cy_array,'r--','LineWidth',2); 
plot(Ax,Cx,'b');
title('Crank - Rocker Linkage Animation')
xlabel('X Coordinate (mm)');
ylabel('Y Coordinate (mm)');
hold off
axis equal
grid on
axis([-30 d+30 -70 20])
pause(0.00001);



end

% plot(Ax_array,Ay_array)
% hold on
% plot(Bx_array,By_array)
% plot(Cx_array,Cy_array)
% axis equal
% axis([-10 25 -30 20])

