#include "Adafruit_NECremote.h"
#define IRpin 4
Adafruit_NECremote remote(IRpin);

int mode = 1; // 1 manual and 2 auto for the robot  

volatile long encoderTicks1 = 0;
volatile long encoderTicks2 = 0;
volatile long encoderTicks3 = 0;
volatile long encoderTicks4 = 0;

const int encoderPinA1 = 1;
const int encoderPinA2 = 0;
const int encoderPinA3 = 2;
const int encoderPinA4 = 7;

int motorState = 1; 
int motorState2 = 0; 
int threshold = 2;

//Initlizting the PID values 
double lastError1 = 0.0;
double integral1 = 0.0;

double lastError2 = 0.0;
double integral2 = 0.0;

double lastError3 = 0.0;
double integral3 = 0.0;

double lastError4 = 0.0;
double integral4 = 0.0;

int lastcode = -1;
int lastcode2 = -1;

// Motor Class  
class Motor {
public:
    Motor(int pwmPin, int encoderPin, int inA, int inB, double Kp, double Ki, double Kd);

    void encoderInterrupt();
    void runCW(double position, int threshold);
    void runCCW(double position, int threshold);
    double getCurrentPositionDegrees();
    double getControlEffort();
    void resetPID();
    double getEncoder();
    void runSet(double direction); 
    void resetEncoder(); 

    static void encoderInterrupt1();
    static void encoderInterrupt2();
    static void encoderInterrupt3();
    static void encoderInterrupt4();

    volatile long _encoderTicks = 0;
    double _controlEffort = 0.0;
    double _lastError = 0.0;

private:
    int _pwmPin, _encoderPin, _inA, _inB;
    double _Kp, _Ki, _Kd;
    double _integral = 0.0;
};

//PID constants 
const double Kp = 3;    
const double Ki = 0.0005;
const double Kd = 0.5;

Motor motor1(3, 1, 21, 20, Kp, Ki, Kd);
Motor motor2(5, 0, 19, 18, Kp, Ki, Kd);
Motor motor3(6, 2, 14, 15, Kp, Ki, Kd);
Motor motor4(9, 7, 16, 10, Kp, Ki, Kd);

Motor::Motor(int pwmPin, int encoderPin, int inA, int inB, double Kp, double Ki, double Kd)
    : _pwmPin(pwmPin), _encoderPin(encoderPin), _inA(inA), _inB(inB),
      _Kp(Kp), _Ki(Ki), _Kd(Kd) {

    //HIGH/LOW
    pinMode(_inA, OUTPUT);
    pinMode(_inB, OUTPUT);
    //encoder
    pinMode(_encoderPin, INPUT);
}

void Motor::encoderInterrupt() {
    if (digitalRead(_encoderPin) == 1) {
        _encoderTicks++;
    }
}

void Motor::encoderInterrupt1() {
    motor1.encoderInterrupt();
}

void Motor::encoderInterrupt2() {
    motor2.encoderInterrupt();
}

void Motor::encoderInterrupt3() {
    motor3.encoderInterrupt();
}

void Motor::encoderInterrupt4() {
    motor4.encoderInterrupt();
}

void Motor::resetEncoder(){
    _encoderTicks = 0; 
}

float sawtoothWave2(unsigned long t, float period, float amplitude) {
  return (t % (unsigned long)period) * (amplitude / period);
}

void Motor::runCW(double position, int threshold) {

    // get the current pose
    long currentPosition = _encoderTicks;
    double currentPositionDegrees = ((currentPosition / 3000.0) * 360.0);
    double currentPositionDegreesReal = fmod(currentPositionDegrees * 4, 360);

    // Error calculations
    double error = position - currentPositionDegreesReal;

    if (error > 180) {
        error -= 360; // saat tersi 
    } else if (error < -180) {
        error += 360; 
    }

    // Proportional 
    double proportionalTerm = _Kp * error;

    // Integral 
    _integral += _Ki * error;

    // Derivative 
    double derivative = _Kd * (error - _lastError);
    _lastError = error;

    // Calculate the PID 
    _controlEffort = constrain(proportionalTerm + _integral + derivative, 0, 255);

    digitalWrite(_inA, HIGH);
    digitalWrite(_inB, LOW);
    analogWrite(_pwmPin, constrain(_controlEffort, 0, 255)); // set to [0, 255]

}

void Motor::runCCW(double position, int threshold) {
    // get the current pose
    long currentPosition = _encoderTicks;
    double currentPositionDegrees = ((currentPosition / 3000.0) * 360.0);
    double currentPositionDegreesReal = fmod(currentPositionDegrees * 4, 360);

    // Error calculation
    double error = position - currentPositionDegreesReal;

    if (error > 180) {
        error -= 360; // saat tersi 
    } else if (error < -180) {
        error += 360; 
    }
    // Proportional 
    double proportionalTerm = _Kp * error;

    // Integral 
    _integral += _Ki * error;

    // Derivative 
    double derivative = _Kd * (error - _lastError);
    _lastError = error;

    // Calculate the PID 
    _controlEffort = constrain(proportionalTerm + _integral + derivative, 0, 255);

    digitalWrite(_inA, LOW);
    digitalWrite(_inB, HIGH);
    analogWrite(_pwmPin, constrain(_controlEffort, 0, 255)); // set to [0, 255]
}

void Motor::runSet(double direction){
  // 1 forward // 2 backward
  if (direction == 1){
    digitalWrite(_inA, LOW);
    digitalWrite(_inB, HIGH);
    analogWrite(_pwmPin, 255);
    delay(25);
    analogWrite(_pwmPin, 0);    
  }
  else {
    digitalWrite(_inA, HIGH);
    digitalWrite(_inB, LOW);
    analogWrite(_pwmPin, 255);
    delay(25);
    analogWrite(_pwmPin, 0);   
  }
}

double Motor::getCurrentPositionDegrees() {
    long currentPosition = _encoderTicks;
    double currentPositionDegrees = ((currentPosition / 3000.0) * 360.0);
    double currentPositionDegreesReal = fmod(currentPositionDegrees * 4, 360);
    return currentPositionDegreesReal;
}

double Motor::getControlEffort() {
   return _controlEffort; 
}

double Motor::getEncoder() {
   return _encoderTicks; 
}

void calibration() {
  int c = remote.listen(5);  // seconds to wait before timing out!
  // Or you can wait 'forever' for a valid code
  //int c = remote.listen();  // Without a #, it means wait forever
  if (c >= 0) {
    Serial.print("Received code #"); 
    Serial.println(c);
    lastcode = c;
    if (c == 16){
      motorState = 1; 
    }
    if (c == 17){
      motorState = 2; 
    }
    else if (c == 18){
      motorState = 3; 
    }
    else if (c == 20){
      motorState = 4; 
    }
    else if (c == 9){
      motorState = 5; 
    }

      // adjust different motors
       switch(motorState){
        case 1:
            Serial.println("1");
            if (lastcode == 5) {
            motor1.runSet(1);
            }
            else if (lastcode == 13){
            motor1.runSet(2);
            }
        break;

        case 2: 
          if (lastcode == 5) {
            Serial.println("2");
            motor2.runSet(1);
            }
            else if (lastcode == 13){
            motor2.runSet(2);
            }
        break;
        case 3: 
          if (lastcode == 5) {
            Serial.println("3");
            motor3.runSet(1);
            }
            else if (lastcode == 13){
            motor3.runSet(2);
            }
        break;
        case 4: 
          if (lastcode == 5) {
            Serial.println("4");
            motor4.runSet(1);
            }
            else if (lastcode == 13){
            motor4.runSet(2);
            }
        break;
        case 5:
        Serial.println("5"); 
        mode = 2;
          motor1.resetEncoder();
          motor2.resetEncoder();
          motor3.resetEncoder();
          motor4.resetEncoder();
        break;

        default:
        // statement
        break;
       }
  
    } else if (c == -3) {
    Serial.print("Repeat (");
    Serial.print(lastcode);
    Serial.println(")");
  } else if (c == -2) {
    Serial.println("Data error");
  }
}

void setup() {
  Serial.begin(115200);
  attachInterrupt(digitalPinToInterrupt(encoderPinA1), Motor::encoderInterrupt1, CHANGE);
  attachInterrupt(digitalPinToInterrupt(encoderPinA2), Motor::encoderInterrupt2, CHANGE);
  attachInterrupt(digitalPinToInterrupt(encoderPinA3), Motor::encoderInterrupt3, CHANGE);
  attachInterrupt(digitalPinToInterrupt(encoderPinA4), Motor::encoderInterrupt4, CHANGE);
}

void loop() {
  // mode 1 = manual 2= auto 
  switch(mode){
     // mode 1 = manual 2 = auto
    case 1:
    calibration();
    break;
    case 2:     
    //Create wave 
    unsigned long currentMillis = millis();
    double timeForOneCycle = 1600.0; // one cycle
    double setPosition = sawtoothWave2(currentMillis, timeForOneCycle, 360);
    int threshold2 = 3;
    
    motor1.runCW(setPosition,threshold2);
    motor2.runCW(setPosition,threshold2);
    motor3.runCW(setPosition,threshold2);
    motor4.runCCW(setPosition,threshold2);

    delay(50);
    break;

    default:
    // statement
    break;

  }
}
