% Please make sure that the videos are in the same folder as this matlab file  
clear; clc; close all;
tic 

videos = {'AC_body_1080.mp4', 0.4;
    'AN_body_1080.mp4', 0.4;
    'AN_wide_body_1080.mp4', 0.4;
    'AN_long_body_1080.mp4', 0.4;
    'CN_body_1080.mp4', 0.4};


number_videos = size(videos, 1);
all_coordinates = cell(number_videos, 1);
%% Threshold the images and save the data 
for v = 1:number_videos
    conversion = videos{v,2};
    
    trajectory = zeros(1500, 1500);
    
    video = VideoReader(videos{v, 1});
    motor_coords = videos{v, 2};
    k = 1;

    while hasFrame(video)
        img = readFrame(video);
        
        %Gaussian filter 
        img_smoothed = imgaussfilt(img, 1);

        % Based on the image quality adjust the resolution 
        % 4K = 2160 and 3840
        % 1080p = 1080 and 1920
        for i = 1:1080 
            for j = 1:1920 
                red = img_smoothed(i, j, 1);
                green = img_smoothed(i, j, 2);
                blue = img_smoothed(i, j, 3);

                % Video image thresholds adjust accordingly, use threshold
                % tool if you are working on a new video
                if v == 1  
                    threshold_condition = (blue > 100 && green < 180 && red < 90);
                elseif v == 2  
                    threshold_condition = (blue > 100 && green < 180 && red < 90);
                elseif v == 3  
                    threshold_condition = (blue > 95 && green < 180 && red < 90);
                elseif v == 4  
                    threshold_condition = (blue > 100 && green < 180 && red < 90);
                elseif v == 5  
                    threshold_condition = (blue > 100 && green < 180 && red < 90);
                end

                if threshold_condition
                    trajectory(i, j) = 1;
                end
            end
        end

        s = regionprops(trajectory, 'Centroid');
        centroids = cat(1, s.Centroid);

        if isempty(centroids)
             disp("no centroids found, check the color threshold")
           break; % Exit the loop if there are no more centroids
        end

        coordinates(k, 1) = centroids(1, 1);
        coordinates(k, 2) = centroids(1, 2);

        %To show the processed image and adjust the location 
        %to show the image threshold 
        if v ==1
            %imshow(trajectory) 
        elseif v==2
            %imshow(trajectory);
        elseif v ==3
            %imshow(trajectory) 
        end 
        k = k + 1;
        trajectory = zeros(1080, 1920);
    end

    all_coordinates{v} = coordinates * conversion;
    
    coordinates = zeros(500, 2); 

end

%% Plot the tracjectory 
figure;
for v = 1:number_videos %number_videos
    plot(all_coordinates{v}(:, 1),-all_coordinates{v}(:, 2), '-', 'DisplayName', ['Video ', num2str(v) , videos{v,1}],'LineWidth',2);
    hold on;
end
%% Saving the data into excel file

% calculate the frames 
max_frames = max(cellfun(@(c) size(c, 1), all_coordinates));

column_names = {};
for v = 1:number_videos
    column_names{end + 1} = ['Video', videos{v,1}, '_X'];
    column_names{end + 1} = ['Video', videos{v,1}, '_Y'];
end
coordinates_table = array2table(nan(max_frames, 2 * number_videos), 'VariableNames', column_names);

% Fill the table with coordinates
for v = 1:number_videos
    num_frames = size(all_coordinates{v}, 1);
    coordinates_table{1:num_frames, (2*v-1):(2*v)} = all_coordinates{v};
end
writetable(coordinates_table, 'xy_body_coordinates_new.xlsx');

%% Create the distance traveled 
% measuring the body length per second by using the video properties 
for v = 1:number_videos
    distance_traveled_mm = norm(all_coordinates{v}(end, :) - all_coordinates{v}(1, :));
    
    frame_rate = 30; 
    time_taken_seconds = size(all_coordinates{v}, 1) / frame_rate;
    
    robot_body_length_mm = 105; 
    body_length_per_second = (distance_traveled_mm / time_taken_seconds) / robot_body_length_mm;

    disp(['body length per second for ' videos{v,1} ' is : ' num2str(body_length_per_second) 'and distance travalled' num2str(distance_traveled_mm)]);
end 

hold on
title('Walking Trajectory')
xlabel('Length (mm)')
ylabel('Length (mm)')
axis equal
legend('Location', 'best')
toc 