#' Read in keys
#'
#' @name read_keys
#' @description A number of cunctiont aht read in the required files to correct and update the names in the LEMIS dataset.
#' @return The file as a dataframe, ready for downstream functions.
#'
#' @export
read_name_key <- function(){

  nameConvertingKey_complete <- read.csv(file = here("data", "nameReview", "nameConvertingKey_complete_2023_06_25.csv"))

  # names(nameConvertingKey_complete)
  # sort(unique(nameConvertingKey_complete$group_))
  # sort(table(nameConvertingKey_complete$corrected), decreasing = TRUE)
  return(nameConvertingKey_complete)
}

#' @export
read_code_key <- function(){

  speciesCodeFixes <- read.csv(file = here("data", "nameReview", "speciesCodeCorrections_2023-06-25.csv"))
  return(speciesCodeFixes)

}

#' @export
read_generic_key <- function(){

  genericFixes <- read.csv(file = here("data", "nameReview", "genericsNames_Fixed.csv"))
  return(genericFixes)

}

#' @export
read_lemis_key <- function(){

  lemisCodes <- read.csv(here("data", "lemis_codes_2023-04-19.csv"))
  return(lemisCodes)

}

#' @export
read_invasives <- function(){

  invasives100 <- read.csv(here("data", "100InvasiveSpecies.csv"))
  extraDetails <- read.csv(here("data", "100IvasivesSpeciesExtraDetails.csv"))

  return(list(
     "invasives100" = invasives100,
     "extraDetails" = extraDetails)
    )

}

#' @export
read_outliers <- function(){

  knownOutliers <- read.csv(here("data", "LEMIS_known_outliers - Sheet1.csv"))
  return(knownOutliers)

}

