#' generate_speciesWild_plots
#'
#' @name generate_speciesWild_plots
#' @return Creates the plots of wild / captive rates on a species by species basis.
#'
#' @export
generate_speciesWild_plots <- function(generalSummaries, filterOpt = filter){

  palettesList <- generate_palette()
  # list2env(palettesList)
  list2env(palettesList, environment())
  names(groupPalette) <- groupPaletteDF$group_
  # targets::tar_load("speciesGenusSummary")
  # targets::tar_load("generalSummaries_tenK")
  # generalSummaries <- generalSummaries_tenK

  # Species wild rates ------------------------------------------------------

  speciesLevelWildCap <- generalSummaries$speciesLevelWildCap

  # speciesLevelWildCap <- lemisDataProcessed %>%
  #   filter(rank == "Species") %>%
  #   group_by(corrected) %>%
  #   mutate(totalQty = sum(quantity, na.rm = TRUE)) %>%
  #   group_by(originCapWild, corrected, group_) %>%
  #   mutate(sumQty = sum(quantity, na.rm = TRUE)) %>%
  #   select(totalQty, sumQty, group_) %>%
  #   slice_head(n = 1) %>%
  #   mutate(percentQty = sumQty/totalQty *100,
  #          vert = case_when(group_ %in% c("Terrestrial Mammals",
  #                                         "Reptiles",
  #                                         "Birds",
  #                                         "Amphibians",
  #                                         "Fish",
  #                                         "Marine Mammals") ~ "Vertebrates",
  #                           group_ %in% c("Crustaceans and Molluscs",
  #                                         "Arachnids",
  #                                         "Insecta and Myriapoda",
  #                                         "Other Invertebrates",
  #                                         "Lepidoptera",
  #                                         "Echinoderms and Cnidaria",
  #                                         "Porifera Sponges, Bryozoa, and Squirts",
  #                                         "Plants",
  #                                         "Miscellaneous") ~ "Invertebrates"),
  #          vert = factor(vert, levels = c("Vertebrates", "Invertebrates")))

  meanWild <- speciesLevelWildCap %>%
    filter(originCapWild == "Wild") %>%
    group_by(group_) %>%
    summarise(meanWild = round(mean(percentQty), digits = 2))

  names(groupPalette) <- groupPaletteDF %>%
    left_join(meanWild) %>%
    mutate(group_ = glue::glue("<b style='color:{group_colour}'>{group_}</b> <i>{meanWild}%</i>")) %>%
    pull(group_)

  logBreaks <- c(c(1) %o% 10^(1:20))

  logLabs <- trimws(sub("000B$", "T",
                        sub("000M$", "B",
                            sub("000K$", "M",
                                sub("000$", "K", format(logBreaks, scientific = FALSE))))))

  speciesLevelWildCapPlotData <- speciesLevelWildCap %>%
    filter(originCapWild == "Wild") %>%
    left_join(meanWild) %>%
    left_join(groupPaletteDF) %>%
    mutate(group_ = glue::glue("<b style='color:{group_colour}'>{group_}</b> <i>{meanWild}%</i>"))

  over99Summary <- speciesLevelWildCapPlotData %>%
    mutate(o99 = if_else(percentQty > 99, "Over 99%", "Under 99%")) %>%
    group_by(vert) %>%
    count(o99) %>%
    reframe(label = paste0(o99, ": ", format(n, big.mark = ","))) %>%
    mutate(loc = c(102, 96, 102, 96))

  speciesLevelWildCapPlotData %>%
    ggplot() +
    geom_vline(xintercept = 1, alpha = 0.25, linetype = 2) +
    geom_point(aes(x = totalQty, y = percentQty, colour = reorder(group_, -percentQty), shape = vert),
               alpha = 1) +
    geom_hline(yintercept = 99, alpha = 1, linetype = 3, colour = "#4d4d4d") +
    geom_text(data = over99Summary,
              aes(x = Inf, y = loc, label = label),
              hjust = 1, vjust = 0.5, fontface = 3, colour = "#4d4d4d") +
    coord_cartesian(clip = "off") +
    scale_x_log10(breaks = logBreaks,
                  labels = logLabs) +
    scale_colour_manual(values = groupPalette) +
    scale_y_continuous(expand = c(0.01,0), breaks = seq(0,100,25)) +
    facet_wrap(vert~., scales = "free") +
    labs(x = "Number of individuals traded", y = "Percentage\nwild sourced",
         colour = "<b>Group</b> & <i>mean species wild source %</i>") +
    theme_bw() +
    theme(
      text = element_text(colour = "#4d4d4d"),
      line = element_line(colour = "#4d4d4d"),
      axis.ticks = element_line(colour = "#4d4d4d"),
      axis.title = element_text(face = 2),
      axis.title.y = element_text(face = 2, angle = 0, hjust = 1),
      axis.text.y = element_markdown(),
      legend.text = element_markdown(),
      legend.title = element_markdown(),
      strip.background = element_blank(),
      strip.text = element_markdown(hjust = 0, face = 4, size = 14,
                                    lineheight = 1.2,colour = "#4D4D4D"),
      panel.grid = element_blank(),
      panel.border = element_blank(),
      axis.line.y.left = element_line(),
      axis.line.x.bottom = element_line(),
      axis.line = element_line(colour = "#4D4D4D")
    ) +
    guides(shape = "none", size = guide_legend(override.aes = list(colour = "#4d4d4d")))

  ggsave(here("figures", paste0("wildRatesSpecies_", Sys.Date(), "_", filterOpt, ".png")),
         width = 380, height = 160, units = "mm")
  ggsave(here("figures", paste0("wildRatesSpecies_", Sys.Date(), "_", filterOpt, ".pdf")),
         width = 380, height = 160, units = "mm")

}
