#' generate_speciesGen_plots
#'
#' @name generate_speciesGen_plots
#' @return Create species over time plots.
#'
#' @export
generate_speciesGen_plots <- function(speciesGenusSummary){

  palettesList <- generate_palette()
  # list2env(palettesList)
  list2env(palettesList, environment())
  names(groupPalette) <- groupPaletteDF$group_
  # targets::tar_load("speciesGenusSummary")

  names(speciesGenusSummary)
  # list2env(speciesGenusSummary)
  list2env(speciesGenusSummary, environment())

  # Species by year ---------------------------------------------------------

  speciesCountByYear <- speciesCountByYear %>%
    filter(!is.na(group_)) %>%
    filter(!group_ == "Miscellaneous")

  endLabsSpp <- speciesCountByYear %>%
    filter(sYear == 2022) %>%
    mutate(vert = factor(vert, levels = c("Vertebrate", "Non")))

  speciesCountByYear %>%
    mutate(vert = factor(vert, levels = c("Vertebrate", "Non"))) %>%
    ggplot() +
    annotate("segment", x = 2000, xend = 2022, yend = 0, y = 0, linetype = 2, alpha = 0.5) +
    geom_path(aes(x = sYear, y = nSpp, group = group_, colour = group_),
              linewidth = 1.2) +
    # geom_text_repel(data = endLabsSpp,
    #                 aes(x = sYear, y = nSpp, label = group_, colour = group_),
    #                 direction = "both", xlim = c(2023, 2050), ylim = c(-200, 1500),
    #                 vjust = 0.5, hjust = 0.5,
    #                 size = 3, fontface = 2) +
    scale_colour_manual(values = groupPalette,
                        breaks = endLabsSpp %>%
                          group_by(vert) %>%
                          arrange(desc(nSpp), .by_group=TRUE) %>% pull(group_)
                        ) +
    scale_fill_manual(values = groupPalette) +
    # coord_cartesian(clip = "off", xlim = c(2000, 2035), expand = 0) +
    scale_y_continuous(breaks = seq(0,2000,250)) +
    scale_x_continuous(breaks = seq(2000,2022,1),
                       labels = sub("^20", "'", seq(2000, 2022, 1))) +
    facet_grid(vert~., scales = "free_y", space = "free_y") +
    theme_bw() +
    labs(x = "Year", y = "Number of\nspecies",
         colour = "<b><i>Group<br></i></b><i>(ordered by 2022 species count)</i>") +
    theme(
      text = element_text(colour = "#4d4d4d"),
      line = element_line(colour = "#4d4d4d"),
      axis.ticks = element_line(colour = "#4d4d4d"),
      axis.title = element_text(face = 2),
      axis.title.y = element_text(face = 2, angle = 0, hjust = 0),
      legend.title = element_markdown(colour = "#4d4d4d"),
      # legend.position = "none",
      strip.background = element_blank(),
      strip.text = element_blank(),
      panel.grid.minor.y = element_blank(),
      panel.grid.major.y = element_blank(),
      panel.grid.minor.x = element_blank(),
      panel.border = element_blank(),
      axis.line = element_line()
    )

  ggsave(here("figures", paste0("speciesByYear_", Sys.Date(), ".pdf")),
         width = 210, height = 120, units = "mm")
  ggsave(here("figures", paste0("speciesByYear_", Sys.Date(), ".png")),
         width = 210, height = 120, units = "mm")

  # Genus per group ---------------------------------------------------------

  # genusCountByGroupCapWild <- read.csv(here("tables", "12_genusCountByGroupCapWild.csv"))

  # Genus by year ---------------------------------------------------------

  # genusCountByYear <- read.csv(here("tables", "12_genusCountByYear.csv"))
  #
  # endLabsGen <- genusCountByYear %>%
  #   filter(sYear == 2022) %>%
  #   mutate(vert = factor(vert, levels = c("Vertebrate", "Non")))
  #
  # genusCountByYear %>%
  #   mutate(vert = factor(vert, levels = c("Vertebrate", "Non"))) %>%
  #   ggplot() +
  #   annotate("segment", x = 2000, xend = 2022, yend = 0, y = 0, linetype = 2, alpha = 0.5) +
  #   geom_path(aes(x = sYear, y = nGen, group = group_, colour = group_),
  #             linewidth = 1.2) +
  #   geom_text_repel(data = endLabsGen,
  #                   aes(x = sYear, y = nGen, label = group_, colour = group_),
  #                   direction = "y", xlim = c(2022, Inf),
  #                   vjust = 0.5, hjust = 0.5,
  #                   size = 3, fontface = 2) +
  #   scale_colour_manual(values = groupPalette) +
  #   scale_fill_manual(values = groupPalette) +
  #   coord_cartesian(clip = "off", xlim = c(2000, 2032), expand = 0) +
  #   scale_y_continuous(breaks = seq(0,2000,250)) +
  #   scale_x_continuous(breaks = seq(2000,2022,1),
  #                      labels = sub("^20", "'", seq(2000, 2022, 1))) +
  #   facet_grid(vert~., scales = "free_y", space = "free_y") +
  #   theme_bw() +
  #   labs(x = "Year", y = "Number of\nGenera") +
  #   theme(
  #     text = element_text(colour = "#4d4d4d"),
  #     line = element_line(colour = "#4d4d4d"),
  #     axis.ticks = element_line(colour = "#4d4d4d"),
  #     axis.title = element_text(face = 2),
  #     axis.title.y = element_text(face = 2, angle = 0, hjust = 0),
  #     legend.position = "none",
  #     strip.background = element_blank(),
  #     strip.text = element_blank(),
  #     panel.grid.minor.y = element_blank(),
  #     panel.grid.major.y = element_blank(),
  #     panel.grid.minor.x = element_blank(),
  #     panel.border = element_blank(),
  #     axis.line = element_line()
  #   )
  #
  # ggsave(here("figures", "Core_SuppFigure1_genusByYear.pdf"),
  #        width = 210, height = 120, units = "mm")
  # ggsave(here("figures", "Core_SuppFigure1_genusByYear.png"),
  #        width = 210, height = 120, units = "mm")


  # Cumulative species counts -----------------------------------------------

  # cumSumSpecies <- read.csv(file = here("tables", "12_cumSumSpecies.csv"))

  endLabsCS <- cumSumSpecies %>%
    # left_join(groupPaletteDF) %>%
    # mutate(group_ = glue::glue("<b style='color:{group_colour}'>{group_}</b>")) %>%
    filter(sYear == 2022) %>%
    mutate(vert = factor(vert, levels = c("Vertebrate", "Non")))


  (cumSumSpeciesPlot <- cumSumSpecies %>%
      # left_join(groupPaletteDF) %>%
      # mutate(group_ = glue::glue("<b style='color:{group_colour}'>{group_}</b>")) %>%
      mutate(vert = factor(vert, levels = c("Vertebrate", "Non"))) %>%
      ggplot() +
      geom_line(aes(x = sYear, y = cumsum, colour = group_)) +
      # geom_text_repel(data = endLabsCS,
      #                 aes(x = sYear, y = cumsum, label = group_, colour = group_),
      #                 direction = "both", xlim = c(2023, 2050), ylim = c(-200, 4500),
      #                 vjust = 0.5, hjust = 0.5,
      #                 size = 3, fontface = 2) +
      annotate("segment", x = 2000, xend = 2022, yend = 0, y = 0, linetype = 2, alpha = 0.5) +
      scale_colour_manual(values = groupPalette,
                          breaks = endLabsCS %>%
                            group_by(vert) %>%
                            arrange(desc(cumsum), .by_group=TRUE) %>% pull(group_)
      ) +
      scale_fill_manual(values = groupPalette) +
      coord_cartesian(clip = "off",
                      xlim = c(2000, 2023), expand = 0) +
      scale_y_continuous(breaks = seq(0,6000,500)) +
      scale_x_continuous(breaks = seq(2000,2022,1),
                         labels = sub("^20", "'", seq(2000, 2022, 1))) +
      facet_grid(rows = "vert", scales = "free_y", space = "free_y") +
      theme_bw() +
      labs(x = "Year", y = "Cumulative\nnumber\nof species",
           colour = "<b><i>Group<br></i></b><i>(ordered by overall species count)</i>") +
      theme(
        text = element_text(colour = "#4d4d4d"),
        line = element_line(colour = "#4d4d4d"),
        axis.ticks = element_line(colour = "#4d4d4d"),
        axis.title = element_text(face = 2),
        axis.title.y = element_text(face = 2, angle = 0, hjust = 0),
        legend.title = element_markdown(colour = "#4d4d4d"),
        # legend.position = "none",
        strip.background = element_blank(),
        strip.text = element_blank(),
        panel.grid.minor.y = element_blank(),
        panel.grid.major.y = element_blank(),
        panel.grid.minor.x = element_blank(),
        panel.border = element_blank(),
        axis.line = element_line()
      ))


  # Counts of species appearance in years -----------------------------------

  # speciesByYear <- read.csv(file = here("tables", "12_speciesByYear.csv"))

  speciesByYear <- speciesByYear %>%
    filter(!is.na(group_)) %>%
    filter(!group_ == "Miscellaneous")

  (speciesAppearanceNYear <- speciesByYear %>%
      group_by(group_, corrected) %>%
      summarise(nYears = n_distinct(sYear)) %>%
      group_by(group_, nYears) %>%
      summarise(nSp = n()) %>%
      left_join(cumSumSpecies %>%
                  select(group_, vert) %>%
                  group_by(group_, vert) %>%
                  slice_head(n = 1)) %>%
      left_join(groupPaletteDF) %>%
      mutate(group_ = glue::glue("<b style='color:{group_colour}'>{group_}</b>")) %>%
      ungroup() %>%
      mutate(nSp = if_else(nSp > 1000, 1000, as.numeric(nSp))) %>% # limit top end results to make the pattern visible, only really impacts one year of birds and fish
      mutate(vert = factor(vert, levels = c("Vertebrate", "Non"))) %>%
     mutate(group_ = factor(group_, levels = endLabsCS %>%
                              left_join(groupPaletteDF) %>%
                              mutate(group_ = glue::glue("<b style='color:{group_colour}'>{group_}</b>")) %>%
                              group_by(vert) %>%
                              arrange(cumsum, .by_group=TRUE) %>% pull(group_))) %>%
      ggplot() +
      geom_tile(aes(x = nYears, y = group_, fill = nSp), colour = "#ffffff",
                linewidth = 0.5) +
      scale_colour_manual(values = groupPalette) +
      scale_fill_gradient(high = "#030303",
                          low = "#f8f8f8",
                          # limits = c(0, 1000),
                          breaks = seq(0, 1000, 250),
                          labels = c(seq(0, 750, 250), ">1000")) +
      scale_x_continuous(breaks = c(seq(1,23,2), 24),
                         labels = c(seq(1,23,2), "+NA"),
                         expand = c(0,0)) +
      scale_y_discrete(position = "right") +
      facet_grid(vert~., scales = "free_y", space = "free_y") +
      theme_bw() +
      labs(x = "Number of years appearing in", y = "",
           fill = "Number of species") +
      theme(
        text = element_text(colour = "#4d4d4d"),
        line = element_line(colour = "#4d4d4d"),
        axis.ticks = element_line(colour = "#4d4d4d"),
        axis.title = element_text(face = 2),
        axis.title.y = element_text(face = 2, angle = 0, hjust = 0),
        axis.text.y = element_markdown(),
        axis.text.y.right = element_markdown(),
        # legend.position = "none",
        legend.title = element_text(face = 4, margin = margin(0,0,10,0)),
        axis.ticks.y = element_blank(),
        strip.background = element_blank(),
        strip.text = element_blank(),
        panel.grid.minor = element_blank(),
        panel.grid.major = element_blank(),
        panel.border = element_blank(),
        axis.line = element_line()
      ))

  patchwork::wrap_plots(
    cumSumSpeciesPlot,
    speciesAppearanceNYear) +
    patchwork::plot_layout(ncol = 1, guides = "collect") +
    patchwork::plot_annotation(tag_levels = "A",
                               theme = theme(plot.tag = element_text(face = 2))) &
    theme(plot.tag = element_text(face = 4, size = 18, colour = "#4d4d4d",
                                  margin = margin(0,10,0,10)))

  ggsave(here("figures", paste0("cumSumSpeciesAndPerYear_", Sys.Date(), ".png")),
         width = 310, height = 240, units = "mm")
  ggsave(here("figures", paste0("cumSumSpeciesAndPerYear_", Sys.Date(), ".pdf")),
         width = 310, height = 240, units = "mm")

}
