#' generate_purpose_summary
#'
#' @name generate_purpose_summary
#' @return Creates summaries based on the listed purposes, while also
#'   simplifying the purposes to make plotting easier.
#'
#' @export
generate_purpose_summary <- function(lemisDataProcessed, filterOpt = filter){

  # targets::tar_load("lemisDataProcessed")

  # Origin by group by purpose overall ----------------------------------------------

  overallPurposeByGroup <- lemisDataProcessed %>%
    group_by(group_) %>%
    mutate(totalQty = sum(quantity, na.rm = TRUE)) %>%
    mutate(purpose = factor(case_when(
      purpose == "B" ~  "Breeding in captivity or artificial propagation",
      purpose == "E" ~                                      "Educational",
      purpose == "G" ~                                  "Botanic gardens",
      purpose == "H" ~                                 "Hunting Trophies",
      purpose == "L" ~   "Law Enforcement / Judicial / Forensic use only",
      # purpose == "M" ~                              "Biomedical research",
      purpose == "P" ~                                         "Personal",
      # purpose == "Q" ~                   "Circuses/traveling exhibitions",
      purpose %in% c("S", "M") ~                  "Scientific / Research",
      purpose == "T" ~                                       "Commercial",
      purpose == "Y" ~        "Reintroduction/introduction into the wild",
      purpose %in% c("Z", "Q") ~                        "Zoos / Circuses",
      TRUE ~ "Other"),
      levels = c(
        "Commercial",
        "Hunting Trophies",
        "Personal",
        "Botanic gardens",
        "Breeding in captivity or artificial propagation",
        "Zoos / Circuses",
        "Reintroduction/introduction into the wild",
        "Law Enforcement / Judicial / Forensic use only",
        "Scientific / Research",
        "Educational",
        "Other")
    )
    ) %>%
    group_by(purpose, group_) %>%
    mutate(sumQty = sum(quantity, na.rm = TRUE)) %>%
    select(totalQty, sumQty) %>%
    slice_head(n = 1) %>%
    mutate(percentQty = sumQty/totalQty *100) %>%
    arrange(desc(percentQty))

  write.csv(overallPurposeByGroup, file = here("tables", paste0("14_overallPurposeByGroup_",
                                                                Sys.Date(), "_", filterOpt, ".csv")),
            row.names = FALSE)

  purposeData <- lemisDataProcessed %>%
    group_by(group_) %>%
    mutate(totalQty = sum(quantity, na.rm = TRUE)) %>%
    mutate(purpose = factor(case_when(
      purpose == "B" ~  "Breeding in captivity or artificial propagation",
      purpose == "E" ~                                      "Educational",
      purpose == "G" ~                                  "Botanic gardens",
      purpose == "H" ~                                 "Hunting Trophies",
      purpose == "L" ~   "Law Enforcement / Judicial / Forensic use only",
      # purpose == "M" ~                              "Biomedical research",
      purpose == "P" ~                                         "Personal",
      # purpose == "Q" ~                   "Circuses/traveling exhibitions",
      purpose %in% c("S", "M") ~                  "Scientific / Research",
      purpose == "T" ~                                       "Commercial",
      purpose == "Y" ~        "Reintroduction/introduction into the wild",
      purpose %in% c("Z", "Q") ~                        "Zoos / Circuses",
      TRUE ~ "Other"),
      levels = c(
        "Commercial",
        "Hunting Trophies",
        "Personal",
        "Botanic gardens",
        "Breeding in captivity or artificial propagation",
        "Zoos / Circuses",
        "Reintroduction/introduction into the wild",
        "Law Enforcement / Judicial / Forensic use only",
        "Scientific / Research",
        "Educational",
        "Other")
    )
    ) %>%
    group_by(originCapWild, purpose, group_) %>%
    mutate(sumQty = sum(quantity, na.rm = TRUE)) %>%
    select(totalQty, sumQty) %>%
    # filter(originCapWild == "Wild") %>%
    slice_head(n = 1) %>%
    mutate(percentQty = sumQty/totalQty *100) %>%
    arrange(desc(percentQty)) %>%
    mutate(percentQty = if_else(originCapWild == "Wild", -percentQty, percentQty)) %>%
    select(originCapWild, purpose, percentQty, group_) %>%
    pivot_longer(cols = c("percentQty"),
                 names_to = "variable",
                 values_to = "value")

  write.csv(purposeData, file = here("tables", paste0("14_purposeData_",
                                                      Sys.Date(), "_", filterOpt, ".csv")),
            row.names = FALSE)

  # Origin by group by purpose non comm ----------------------------------------------

  purposeDataNonComm <- lemisDataProcessed %>%
    filter(!purpose == "T") %>%
    group_by(group_) %>%
    mutate(totalQty = sum(quantity, na.rm = TRUE)) %>%
    group_by(originCapWild, purpose, group_) %>%
    mutate(sumQty = sum(quantity, na.rm = TRUE)) %>%
    select(totalQty, sumQty) %>%
    # filter(originCapWild == "Wild") %>%
    slice_head(n = 1) %>%
    mutate(percentQty = sumQty/totalQty *100) %>%
    arrange(desc(percentQty)) %>%
    mutate(percentQty = if_else(originCapWild == "Wild", -percentQty, percentQty)) %>%
    select(originCapWild, purpose, percentQty, group_) %>%
    pivot_longer(cols = c("percentQty"),
                 names_to = "variable",
                 values_to = "value") %>%
    mutate(purpose = factor(case_when(
      purpose == "B" ~  "Breeding in captivity or artificial propagation",
      purpose == "E" ~                                      "Educational",
      purpose == "G" ~                                  "Botanic gardens",
      purpose == "H" ~                                 "Hunting Trophies",
      purpose == "L" ~   "Law Enforcement / Judicial / Forensic use only",
      # purpose == "M" ~                              "Biomedical research",
      purpose == "P" ~                                         "Personal",
      # purpose == "Q" ~                   "Circuses/traveling exhibitions",
      purpose %in% c("S", "M") ~                  "Scientific / Research",
      purpose == "T" ~                                       "Commercial",
      purpose == "Y" ~        "Reintroduction/introduction into the wild",
      purpose %in% c("Z", "Q") ~                        "Zoos / Circuses",
      TRUE ~ "Other"),
      levels = c(
        "Commercial",
        "Hunting Trophies",
        "Personal",
        "Botanic gardens",
        "Breeding in captivity or artificial propagation",
        "Zoos / Circuses",
        "Reintroduction/introduction into the wild",
        "Law Enforcement / Judicial / Forensic use only",
        "Scientific / Research",
        "Educational",
        "Other")
    )
    )

  write.csv(purposeDataNonComm, file = here("tables", paste0("14_purposeDataNonComm_",
                                                             Sys.Date(), "_", filterOpt, ".csv")),
            row.names = FALSE)

  # Origin by group by purpose live ----------------------------------------------

  purposeDataLive <- lemisDataProcessed %>%
    filter(description %in% c("LIV")) %>%
    group_by(group_) %>%
    mutate(totalQty = sum(quantity, na.rm = TRUE)) %>%
    mutate(purpose = factor(case_when(
      purpose == "B" ~  "Breeding in captivity or artificial propagation",
      purpose == "E" ~                                      "Educational",
      purpose == "G" ~                                  "Botanic gardens",
      purpose == "H" ~                                 "Hunting Trophies",
      purpose == "L" ~   "Law Enforcement / Judicial / Forensic use only",
      # purpose == "M" ~                              "Biomedical research",
      purpose == "P" ~                                         "Personal",
      # purpose == "Q" ~                   "Circuses/traveling exhibitions",
      purpose %in% c("S", "M") ~                  "Scientific / Research",
      purpose == "T" ~                                       "Commercial",
      purpose == "Y" ~        "Reintroduction/introduction into the wild",
      purpose %in% c("Z", "Q") ~                        "Zoos / Circuses",
      TRUE ~ "Other"),
      levels = c(
        "Commercial",
        "Hunting Trophies",
        "Personal",
        "Botanic gardens",
        "Breeding in captivity or artificial propagation",
        "Zoos / Circuses",
        "Reintroduction/introduction into the wild",
        "Law Enforcement / Judicial / Forensic use only",
        "Scientific / Research",
        "Educational",
        "Other")
    )
    ) %>%
    group_by(originCapWild, purpose, group_) %>%
    mutate(sumQty = sum(quantity, na.rm = TRUE)) %>%
    select(totalQty, sumQty) %>%
    # filter(originCapWild == "Wild") %>%
    slice_head(n = 1) %>%
    mutate(percentQty = sumQty/totalQty *100) %>%
    arrange(desc(percentQty)) %>%
    mutate(percentQty = if_else(originCapWild == "Wild", -percentQty, percentQty)) %>%
    select(originCapWild, purpose, percentQty, group_) %>%
    pivot_longer(cols = c("percentQty"),
                 names_to = "variable",
                 values_to = "value")

  write.csv(purposeDataLive, file = here("tables", paste0("14_purposeDataLive_",
                                                          Sys.Date(), "_", filterOpt, ".csv")),
            row.names = FALSE)

  # Origin by group by purpose live non comm ----------------------------------------------

  purposeDataLiveNonComm <- lemisDataProcessed %>%
    filter(description %in% c("LIV")) %>%
    filter(!purpose == "T") %>%
    group_by(group_) %>%
    mutate(totalQty = sum(quantity, na.rm = TRUE)) %>%
    group_by(originCapWild, purpose, group_) %>%
    mutate(sumQty = sum(quantity, na.rm = TRUE)) %>%
    select(totalQty, sumQty) %>%
    # filter(originCapWild == "Wild") %>%
    slice_head(n = 1) %>%
    mutate(percentQty = sumQty/totalQty *100) %>%
    arrange(desc(percentQty)) %>%
    mutate(percentQty = if_else(originCapWild == "Wild", -percentQty, percentQty)) %>%
    select(originCapWild, purpose, percentQty, group_) %>%
    pivot_longer(cols = c("percentQty"),
                 names_to = "variable",
                 values_to = "value") %>%
    mutate(purpose = factor(case_when(
      purpose == "B" ~  "Breeding in captivity or artificial propagation",
      purpose == "E" ~                                      "Educational",
      purpose == "G" ~                                  "Botanic gardens",
      purpose == "H" ~                                 "Hunting Trophies",
      purpose == "L" ~   "Law Enforcement / Judicial / Forensic use only",
      # purpose == "M" ~                              "Biomedical research",
      purpose == "P" ~                                         "Personal",
      # purpose == "Q" ~                   "Circuses/traveling exhibitions",
      purpose %in% c("S", "M") ~                  "Scientific / Research",
      purpose == "T" ~                                       "Commercial",
      purpose == "Y" ~        "Reintroduction/introduction into the wild",
      purpose %in% c("Z", "Q") ~                        "Zoos / Circuses",
      TRUE ~ "Other"),
      levels = c(
        "Commercial",
        "Hunting Trophies",
        "Personal",
        "Botanic gardens",
        "Breeding in captivity or artificial propagation",
        "Zoos / Circuses",
        "Reintroduction/introduction into the wild",
        "Law Enforcement / Judicial / Forensic use only",
        "Scientific / Research",
        "Educational",
        "Other")
    )
    )

  write.csv(purposeDataLiveNonComm, file = here("tables", paste0("14_purposeDataLiveNonComm_",
                                                                 Sys.Date(), "_", filterOpt, ".csv")),
            row.names = FALSE)


  purposeList <- list(
    "overallPurposeByGroup" = overallPurposeByGroup,
    "purposeData" = purposeData,
    "purposeDataNonComm"= purposeDataNonComm,
    "purposeDataLive" = purposeDataLive,
    "purposeDataLiveNonComm" = purposeDataLiveNonComm
  )

  return(purposeList)

}
