#' generate_purpose_plots
#'
#' @name generate_purpose_plots
#' @return Creates plots that display the wild / captive balance and the purpose
#'   of import of each group.
#'
#' @export
generate_purpose_plots <- function(purposeSummary, filterOpt = filter){

  palettesList <- generate_palette()
  list2env(palettesList, environment())

  # targets::tar_load("purposeSummary")

  list2env(purposeSummary, environment())

  groupLabs <- purposeData %>%
    filter(!is.na(group_)) %>%
    filter(originCapWild == "Wild") %>%
    group_by(group_) %>%
    summarise(min = sum(value, na.rm = TRUE),
              centre = min + 50)

  (purposePlot_comm <- purposeData %>%
      mutate(group_ = factor(group_,
                             levels = groupLabs %>%
                               arrange(desc(min)) %>% pull(group_))
      ) %>%
      ggplot() +
      geom_vline(xintercept = 0, linewidth = 0.5, linetype = 2,
                 alpha = 0.5, colour = "black") +
      geom_col(aes(y = group_, x = value, fill = purpose),
               width = 0.35) +
      geom_text(data = groupLabs,
                aes(x = min, y = group_, label = group_), fontface = 4,
                colour = "#4d4d4d", size = 3.5,
                vjust = 0.5, hjust = 0, position = position_nudge(y = 0.45)) +
      annotate("segment", x = 0.01, xend = 20,
               y = n_distinct(groupLabs)+1,
               yend = n_distinct(groupLabs)+1,
               linewidth = 1.25,
               arrow = arrow(angle = 30, type = "closed", length = unit(2, "mm")),
               colour = paletteWildCap["Captive"]) +
      annotate("text", x = 22, y = Inf, label = "Captive & Ranched",
               colour = paletteWildCap["Captive"], hjust = 0, vjust = 0.5, lineheight = 0.95, fontface = 2) +
      annotate("segment", x = -0.01, xend = -20, y = Inf, yend = Inf,
               linewidth = 1.25,
               arrow = arrow(angle = 30, type = "closed", length = unit(2, "mm")),
               colour = paletteWildCap["Wild"]) +
      annotate("text", x = -22, y = Inf, label = "Wild",
               colour = paletteWildCap["Wild"], hjust = 1, vjust = 0.5, lineheight = 0.95, fontface = 2) +
      coord_cartesian(clip = "off", ylim = c(1, NA)) +
      facet_wrap(variable~., ncol = 1) +
      labs(y = "Group", x = "Percentage of Individuals", fill = "Purpose") +
      scale_x_continuous(breaks = seq(-100,100,20),
                         labels = c(seq(100,0,-20), seq(20,100,20)),
                         limits = c(-100,100), expand = c(0,0)) +
      scale_fill_manual(values = purposePal) +
      theme_bw() +
      theme(
        text = element_text(colour = "#4d4d4d"),
        line = element_line(colour = "#4d4d4d"),
        axis.ticks = element_line(colour = "#4d4d4d"),
        legend.title = element_text(face = 2),
        axis.title = element_text(face = 2),
        axis.title.y = element_blank(),
        axis.text.y = element_blank(),
        axis.ticks.y = element_blank(),
        axis.text.x = element_text(margin = margin(2,0,10,0)),
        strip.background = element_blank(),
        strip.text = element_blank(),
        plot.margin = margin(20,10,10,10),
        panel.grid.major.y = element_blank(),
        panel.grid.minor = element_blank(),
        panel.border = element_blank(),
        axis.line.y = element_blank(),
        axis.line.x.bottom = element_line(),
        axis.line = element_line(colour = "#4D4D4D")
      ))

  # ggsave(here("figures", "originCapWildPurpose.png"),
  #        width = 210, height = 120, units = "mm")

  # Origin by group by purpose non comm ----------------------------------------------

  groupLabsNonComm <- purposeDataNonComm %>%
    filter(originCapWild == "Wild") %>%
    group_by(group_) %>%
    summarise(min = sum(value, na.rm = TRUE),
              centre = min + 50)

  (purposePlot_noncomm <- purposeDataNonComm %>%
      mutate(group_ = factor(group_,
                             levels = groupLabsNonComm %>%
                               arrange(desc(min)) %>% pull(group_))
      ) %>%
      ggplot() +
      geom_vline(xintercept = 0, linewidth = 0.5, linetype = 2, alpha = 0.5, colour = "black") +
      geom_col(aes(y = group_, x = value, fill = purpose),
               width = 0.35) +
      geom_text(data = groupLabsNonComm,
                aes(x = min, y = group_, label = group_), fontface = 4,
                colour = "#4d4d4d", size = 3.5,
                vjust = 0.5, hjust = 0, position = position_nudge(y = 0.45)) +
      annotate("segment", x = 0.01, xend = 20,
               y = n_distinct(groupLabs)+1,
               yend = n_distinct(groupLabs)+1,
               linewidth = 1.25,
               arrow = arrow(angle = 30, type = "closed", length = unit(2, "mm")),
               colour = paletteWildCap["Captive"]) +
      annotate("text", x = 22, y = Inf, label = "Captive & Ranched",
               colour = paletteWildCap["Captive"], hjust = 0, vjust = 0.5, lineheight = 0.95, fontface = 2) +
      annotate("segment", x = -0.01, xend = -20, y = Inf, yend = Inf,
               linewidth = 1.25,
               arrow = arrow(angle = 30, type = "closed", length = unit(2, "mm")),
               colour = paletteWildCap["Wild"]) +
      annotate("text", x = -22, y = Inf, label = "Wild",
               colour = paletteWildCap["Wild"], hjust = 1, vjust = 0.5, lineheight = 0.95, fontface = 2) +
      scale_fill_manual(values = purposePal) +
      coord_cartesian(clip = "off", ylim = c(1, NA)) +
      facet_wrap(variable~., ncol = 1) +
      labs(y = "Group", x = "Percentage of Individuals (%)",
           fill = "Purpose") +
      scale_x_continuous(breaks = seq(-100,100,20),
                         labels = c(seq(100,0,-20), seq(20,100,20)),
                         limits = c(-100,100), expand = c(0,0)) +
      theme_bw() +
      theme(
        text = element_text(colour = "#4d4d4d"),
        line = element_line(colour = "#4d4d4d"),
        axis.ticks = element_line(colour = "#4d4d4d"),
        legend.title = element_text(face = 2),
        axis.title = element_text(face = 2),
        axis.title.y = element_blank(),
        axis.text.y = element_blank(),
        axis.ticks.y = element_blank(),
        axis.text.x = element_text(margin = margin(2,0,10,0)),
        strip.background = element_blank(),
        strip.text = element_blank(),
        plot.margin = margin(20,10,10,10),
        panel.grid.major.y = element_blank(),
        panel.grid.minor = element_blank(),
        panel.border = element_blank(),
        axis.line.y = element_blank(),
        axis.line.x.bottom = element_line(),
        axis.line = element_line(colour = "#4D4D4D")
      ))

  # ggsave(here("figures", "originCapWildPurposeNonCommercial.png"),
  #        width = 210, height = 120, units = "mm")


  # Combine for main figure -------------------------------------------------

  purposePlot_comm +
    theme(axis.text.x = element_blank(),
          axis.title.x = element_blank()) +
    purposePlot_noncomm +
    theme(legend.position = "none") +
    plot_layout(ncol = 1) +
    plot_annotation(tag_levels = "A", theme = theme(plot.tag = element_text(face = 2))) &
    theme(plot.tag = element_text(face = 4, size = 18, colour = "#4d4d4d",
                                  margin = margin(0,10,0,10)))



  ggsave(here("figures", paste0("originCapWildPurposeCombo_", Sys.Date(), "_", filterOpt, ".png")),
         width = 210, height = 240, units = "mm")
  ggsave(here("figures", paste0("originCapWildPurposeCombo_", Sys.Date(), "_", filterOpt, ".pdf")),
         width = 210, height = 240, units = "mm")

  # Origin by group by purpose live ----------------------------------------------

  groupLabs <- purposeDataLive %>%
    filter(originCapWild == "Wild") %>%
    group_by(group_) %>%
    summarise(min = sum(value, na.rm = TRUE),
              centre = min + 50)

  (purposeDataLive_plot <- purposeDataLive %>%
      mutate(group_ = factor(group_,
                             levels = groupLabs %>%
                               arrange(desc(min)) %>% pull(group_))
      ) %>%
      ggplot() +
      geom_vline(xintercept = 0, linewidth = 0.5, linetype = 2, alpha = 0.5, colour = "black") +
      geom_col(aes(y = group_, x = value, fill = purpose),
               width = 0.35) +
      geom_text(data = groupLabs,
                aes(x = min, y = group_, label = group_), fontface = 4,
                colour = "#4d4d4d", size = 3.5,
                vjust = 0.5, hjust = 0, position = position_nudge(y = 0.45)) +
      annotate("segment", x = 0.01, xend = 20,
               y = n_distinct(groupLabs)+1,
               yend = n_distinct(groupLabs)+1,
               linewidth = 1.25,
               arrow = arrow(angle = 30, type = "closed", length = unit(2, "mm")),
               colour = paletteWildCap["Captive"]) +
      annotate("text", x = 22, y = Inf, label = "Captive & Ranched",
               colour = paletteWildCap["Captive"], hjust = 0, vjust = 0.5, lineheight = 0.95, fontface = 2) +
      annotate("segment", x = -0.01, xend = -20, y = Inf, yend = Inf,
               linewidth = 1.25,
               arrow = arrow(angle = 30, type = "closed", length = unit(2, "mm")),
               colour = paletteWildCap["Wild"]) +
      annotate("text", x = -22, y = Inf, label = "Wild",
               colour = paletteWildCap["Wild"], hjust = 1, vjust = 0.5, lineheight = 0.95, fontface = 2) +
      scale_fill_manual(values = purposePal) +
      coord_cartesian(clip = "off", ylim = c(1, NA)) +
      facet_wrap(variable~., ncol = 1) +
      labs(y = "Group", x = "Percentage of Live Individuals (%)",
           fill = "Purpose") +
      scale_x_continuous(breaks = seq(-100,100,20),
                         labels = c(seq(100,0,-20), seq(20,100,20)),
                         limits = c(-100,100), expand = c(0,0)) +
      theme_bw() +
      theme(
        text = element_text(colour = "#4d4d4d"),
        line = element_line(colour = "#4d4d4d"),
        axis.ticks = element_line(colour = "#4d4d4d"),
        legend.title = element_text(face = 2),
        axis.title = element_text(face = 2),
        axis.title.y = element_blank(),
        axis.text.y = element_blank(),
        axis.ticks.y = element_blank(),
        axis.text.x = element_text(margin = margin(2,0,10,0)),
        strip.background = element_blank(),
        strip.text = element_blank(),
        plot.margin = margin(20,10,10,10),
        panel.grid.major.y = element_blank(),
        panel.grid.minor = element_blank(),
        panel.border = element_blank(),
        axis.line.y = element_blank(),
        axis.line.x.bottom = element_line(),
        axis.line = element_line(colour = "#4D4D4D")
      ))

  # ggsave(here("figures", "originCapWildPurposeLive.png"),
  #        width = 210, height = 120, units = "mm")

  # Origin by group by purpose live non comm ----------------------------------------------

  groupLabsLive <- purposeDataLiveNonComm %>%
    filter(originCapWild == "Wild") %>%
    group_by(group_) %>%
    summarise(min = sum(value, na.rm = TRUE),
              centre = min + 50)

  (purposeDataLiveNonComm_plot <- purposeDataLiveNonComm %>%
      mutate(group_ = factor(group_,
                             levels = groupLabsLive %>%
                               arrange(desc(min)) %>% pull(group_))
      ) %>%
      ggplot() +
      geom_vline(xintercept = 0, linewidth = 0.5, linetype = 2, alpha = 0.5, colour = "black") +
      geom_col(aes(y = group_, x = value, fill = purpose),
               width = 0.35) +
      geom_text(data = groupLabsLive,
                aes(x = min, y = group_, label = group_), fontface = 4,
                colour = "#4d4d4d", size = 3.5,
                vjust = 0.5, hjust = 0, position = position_nudge(y = 0.45)) +
      annotate("segment", x = 0.01, xend = 20,
               y = n_distinct(groupLabs)+1,
               yend = n_distinct(groupLabs)+1,
               linewidth = 1.25,
               arrow = arrow(angle = 30, type = "closed", length = unit(2, "mm")),
               colour = paletteWildCap["Captive"]) +
      annotate("text", x = 22, y = Inf, label = "Captive & Ranched",
               colour = paletteWildCap["Captive"], hjust = 0, vjust = 0.5, lineheight = 0.95, fontface = 2) +
      annotate("segment", x = -0.01, xend = -20, y = Inf, yend = Inf,
               linewidth = 1.25,
               arrow = arrow(angle = 30, type = "closed", length = unit(2, "mm")),
               colour = paletteWildCap["Wild"]) +
      annotate("text", x = -22, y = Inf, label = "Wild",
               colour = paletteWildCap["Wild"], hjust = 1, vjust = 0.5, lineheight = 0.95, fontface = 2) +
      labs(y = "Group", x = "Percentage of Live Individuals (%)",
           fill = "Purpose") +
      scale_fill_manual(values = purposePal) +
      coord_cartesian(clip = "off", ylim = c(1, NA)) +
      facet_wrap(variable~., ncol = 1) +
      scale_x_continuous(breaks = seq(-100,100,20),
                         labels = c(seq(100,0,-20), seq(20,100,20)),
                         limits = c(-100,100), expand = c(0,0)) +
      theme_bw() +
      theme(
        text = element_text(colour = "#4d4d4d"),
        line = element_line(colour = "#4d4d4d"),
        axis.ticks = element_line(colour = "#4d4d4d"),
        legend.title = element_text(face = 2),
        axis.title = element_text(face = 2),
        axis.title.y = element_blank(),
        axis.text.y = element_blank(),
        axis.ticks.y = element_blank(),
        axis.text.x = element_text(margin = margin(2,0,10,0)),
        strip.background = element_blank(),
        strip.text = element_blank(),
        plot.margin = margin(20,10,10,10),
        panel.grid.major.y = element_blank(),
        panel.grid.minor = element_blank(),
        panel.border = element_blank(),
        axis.line.y = element_blank(),
        axis.line.x.bottom = element_line(),
        axis.line = element_line(colour = "#4D4D4D")
      ))

  # ggsave(here("figures", "originCapWildPurposeNonCommercialLive.png"),
  #        width = 210, height = 120, units = "mm")

  # Combine for supp figure -------------------------------------------------

  purposeDataLive_plot +
    theme(axis.text.x = element_blank(),
          axis.title.x = element_blank()) +
    purposeDataLiveNonComm_plot +
    theme(legend.position = "none") +
    plot_layout(ncol = 1) +
    plot_annotation(tag_levels = "A", theme = theme(plot.tag = element_text(face = 2))) &
    theme(plot.tag = element_text(face = 4, size = 18, colour = "#4d4d4d",
                                  margin = margin(0,10,0,10)))

  ggsave(here("figures", paste0("originCapWildPurposeComboLive_", Sys.Date(), "_", filterOpt, ".png")),
         width = 210, height = 240, units = "mm")
  ggsave(here("figures", paste0("originCapWildPurposeComboLive_", Sys.Date(), "_", filterOpt, ".pdf")),
         width = 210, height = 240, units = "mm")


  # Shifts of wild capture % from whole to live only ------------------------

  purposeDifferences <- list(
    overallPurposeByGroup %>%
      group_by(group_) %>%
      slice_max(percentQty) %>%
      arrange(percentQty),

    overallPurposeByGroup %>%
      group_by(group_) %>%
      filter(purpose == "Commercial") %>%
      arrange(percentQty),

    purposeData %>%
      filter(originCapWild == "Wild") %>%
      group_by(group_) %>%
      summarise(sumAll = sum(value)) %>%
      left_join(
        purposeDataLive %>%
          filter(originCapWild == "Wild") %>%
          group_by(group_) %>%
          summarise(sumLive = sum(value))) %>%
      mutate(diff = sumAll - sumLive)
  )

}
