#' generate_overall_summaries
#'
#' @name generate_overall_summaries
#' @return Generates an overall summary that includes overall counts.
#'
#' @export
generate_overall_summaries <- function(lemisDataProcessed, filterOpt = filter){

  # targets::tar_load("lemisDataProcessed_mag2_tenK")
  # lemisDataProcessed <- lemisDataProcessed_mag2_tenK

  quantityBarData <- lemisDataProcessed %>%
    group_by(group_) %>%
    summarise(totalQuantity = sum(quantity, na.rm = TRUE)) %>%
    mutate(group_ = reorder(group_, totalQuantity))

  entryBarData <- lemisDataProcessed %>%
    group_by(group_) %>%
    summarise(entries = n())

  overallTotals <- full_join(quantityBarData, entryBarData)

  # prettyNum(sum(overallTotals$totalQuantity), scientific = FALSE, digits = 16,
  #           big.mark = ",")
  #
  # prettyNum(sum(overallTotals$entries), scientific = FALSE, digits = 16,
  #           big.mark = ",")

  write.csv(overallTotals, file = here("tables",
                                       paste0("11_totalsData_",
                                              Sys.Date(), "_", filterOpt, ".csv")),
            row.names = FALSE)

  return(overallTotals)

}
