#' generate_overall_plots
#'
#' @name generate_overall_plots
#' @return Create the bar plots for the overall counts of individuals and
#'   entries.
#'
#' @export
generate_overall_plots <- function(overallTotals, filterOpt = filter){

  # targets::tar_load("overallTotals")

  overallTotals

  # library(dplyr)
  # library(tidyr)
  # library(ggplot2)
  # library(ggtext)
  # library(stringr)
  # library(patchwork)


  overallTotalsLong <- overallTotals %>%
    # select(originCapWild, percentQty, percentShip, percentWeight, group_) %>%
    pivot_longer(cols = c("totalQuantity", "entries"),
                 names_to = "variable", values_to = "value")

  palettesList <- generate_palette()
  list2env(palettesList, environment())

  groupPaletteDF_glued <- groupPaletteDF %>%
    mutate(group_ = glue::glue("<b style='color:{group_colour}'>{group_}</b>"))

  names(groupPalette) <- groupPaletteDF_glued$group_

  logBreaks <- c(c(1) %o% 10^(1:11))

  logLabs <- trimws(sub("000M$", "B",
                            sub("000K$", "M",
                                sub("000$", "K", format(logBreaks, scientific = FALSE)))))

  subTitles <- overallTotalsLong %>%
    group_by(variable) %>%
    # filter(variable == "totalQuantity") %>%
    summarise(subTitle = paste0("Total: ",
                                format(sum(value),
                                       scientific = FALSE, big.mark=",")))

  plotQty <- overallTotalsLong %>%
    filter(variable == "totalQuantity") %>%
    left_join(groupPaletteDF) %>%
    mutate(group_ = glue::glue("<b style='color:{group_colour}'>{group_}</b>")) %>%
    arrange(variable, value) %>%
    ggplot(aes(y = reorder(group_, value), x = value, fill = group_)) +
    geom_col() +
    scale_x_log10(breaks = logBreaks,
                  labels = logLabs,
                  # minor_breaks = c(seq(2,8,2) %o% 10^(1:20)),
                  expand = c(0,0)) +
    scale_fill_manual(values = groupPalette) +
    coord_cartesian(clip = "off", xlim = c(1,1e12)) +
    # facet_wrap(variable~., ncol = 1, scales = "free_x") +
    labs(title = "Whole individuals", y = "Group", x = "Count",
         caption = str_wrap("Counts of whole individuals including specimens (live and dead), eggs, entire skins, and trophies comprising the entire animal.",
                            80),
         subtitle = subTitles %>% filter(variable == "totalQuantity") %>% pull(subTitle)
         ) +
    theme_bw() +
    theme(
      text = element_text(colour = "#4d4d4d"),
      line = element_line(colour = "#4d4d4d"),
      axis.ticks = element_line(colour = "#4d4d4d"),
      plot.title = element_text(face = 4),
      plot.subtitle = element_text(face = 3, size = 10),
      axis.title = element_text(face = 2),
      axis.title.y = element_blank(),
      axis.text.y = element_markdown(),
      axis.text.x = element_text(hjust = -0.1, vjust = 1, margin = margin(-8,0,0,-5),
                                 size = 7),
      axis.ticks.length.x = unit(4, "mm"),
      axis.title.x = element_text(hjust = 0.5, vjust = 0),
      legend.position = "none",
      strip.background = element_blank(),
      strip.text = element_markdown(hjust = 0, face = 4, size = 10),
      panel.grid.major.y = element_blank(),
      panel.grid.minor.x = element_blank(),
      panel.border = element_blank(),
      axis.line.x.bottom = element_line(),
      plot.title.position = "plot",
      plot.caption.position =  "plot"
    )

  plotEntries <- overallTotalsLong %>%
    filter(variable == "entries") %>%
    left_join(groupPaletteDF) %>%
    mutate(group_ = glue::glue("<b style='color:{group_colour}'>{group_}</b>")) %>%
    arrange(variable, value) %>%
    ggplot(aes(y = reorder(group_, value), x = value, fill = group_)) +
    geom_col() +
    scale_x_log10(breaks = logBreaks,
                  labels = logLabs,
                  # minor_breaks = c(seq(2,8,2) %o% 10^(1:20)),
                  expand = c(0,0)) +
    # scale_x_log10(breaks = x_breaks, labels = x_labels) +
    scale_fill_manual(values = groupPalette) +
    coord_cartesian(clip = "off") +
    # facet_wrap(variable~., ncol = 1, scales = "free_x") +
    labs(title = "Entries", y = "Group", x = "Count",
         subtitle = subTitles %>% filter(variable == "entries") %>% pull(subTitle),
         caption = str_wrap("Counts of data entries into the LEMIS dataset.",
                            80)) +
    theme_bw() +
    theme(
      text = element_text(colour = "#4d4d4d"),
      line = element_line(colour = "#4d4d4d"),
      axis.ticks = element_line(colour = "#4d4d4d"),
      plot.title = element_text(face = 4),
      plot.subtitle = element_text(face = 3, size = 10),
      axis.title = element_text(face = 2),
      axis.title.y = element_blank(),
      axis.text.y = element_markdown(),
      axis.text.x = element_text(hjust = -0.1, vjust = 1, margin = margin(-8,0,0,-5),
                                 size = 7),
      axis.ticks.length.x = unit(4, "mm"),
      axis.title.x = element_text(hjust = 0.5, vjust = 0),
      legend.position = "none",
      strip.background = element_blank(),
      strip.text = element_markdown(hjust = 0, face = 4, size = 10),
      panel.grid.major.y = element_blank(),
      panel.grid.minor.x = element_blank(),
      panel.border = element_blank(),
      axis.line.x.bottom = element_line(),
      plot.title.position = "plot",
      plot.caption.position =  "plot"
    )

  combinedPlots <-
    plotQty +
    plotEntries +
    plot_layout(ncol = 2) +
    plot_annotation(tag_levels = "A") &
    theme(plot.tag = element_text(face = 4, size = 18, colour = "#4d4d4d",
                                  margin = margin(0,10,0,10)))

  combinedPlots

  ggsave(here("figures", paste0("overallBars_", Sys.Date(), "_", filterOpt, ".pdf")),
         width = 340, height = 140, units = "mm")
  ggsave(here("figures", paste0("overallBars_", Sys.Date(), "_", filterOpt, ".png")),
         width = 340, height = 140, units = "mm")

  return(combinedPlots)
}

