#' generate_invasive_summary
#'
#' @name generate_invasive_summary
#' @return Compares the list of species in the LEMIS data to the top 100 invasive species.
#'
#' @export
generate_invasive_summary <- function(lemisDataProcessed, invasiveSpecies100, filterOpt = filter){

  invasives100 <- invasiveSpecies100$invasives100

  # Invasive species --------------------------------------------------------------

  invasiveSpp <- lemisDataProcessed %>%
    filter(description == "LIV") %>%
    filter(corrected %in% invasives100$invasiveSpecies) %>%
    pull(corrected) %>% unique()

  lemisInv100Live <- lemisDataProcessed %>%
    filter(description == "LIV") %>%
    filter(corrected %in% invasives100$invasiveSpecies)

  lemisInv100Live_NO <- lemisInv100Live %>%
    filter(unit == "NO") %>%
    group_by(corrected) %>%
    summarise(corrected = corrected[1],
              quantity_entries = n(),
              quantity = sum(quantity))

  lemisInv100Live_details <- lemisInv100Live %>%
    group_by(corrected) %>%
    summarise(purposes = paste0(sort(unique(purpose[!purpose %in% c("non-standard value") & !is.na(purpose)])),
                                collapse = ", "),
              origins = paste0(sub("Ctry_", "", sort(unique(country_origin[!country_origin %in%
                                                                             c("Ex 4", "Ex4") & !is.na(country_origin)]))),
                               collapse = ", "),
              years = paste0(sort(unique(sYear[!is.na(sYear)])),
                             collapse = ", "))

  lemisInv100Live_Summary <- lemisInv100Live_NO %>%
    left_join(lemisInv100Live_details)

  lemisInv100Live_Summary <- lemisInv100Live_Summary %>%
    mutate(across(c("quantity_entries", "quantity"), ~replace_na(.x, 0)))

  # based on http://www.iucngisd.org/gisd/search.php
  extraDetails <- invasiveSpecies100$extraDetails

  lemisInv100Live_Summary <- lemisInv100Live_Summary %>%
    left_join(extraDetails)

  invasiveSpp

  lemisInvasives <- list(
    "invasiveSpp" = invasiveSpp,
    "lemisInv100Live_Summary" = lemisInv100Live_Summary
  )

  write.csv(lemisInv100Live_Summary, file = here("tables", paste0("17_top100invasivesSummary_",
                                                                  Sys.Date(), "_", filterOpt, ".csv")),
            row.names = FALSE)

  return(lemisInvasives)

}
