#' generate_capwild_summary
#'
#' @name generate_capwild_summary
#' @return Summarise the data to better see the patterns of wild and captive take.
#'
#' @export
generate_capwild_summary <- function(lemisDataProcessed, filterOpt = filter){

  # Captive wild summary overall ----------------------------------------------------

  capWildByQty <- lemisDataProcessed %>%
    group_by(group_) %>%
    mutate(totalQty = sum(quantity, na.rm = TRUE)) %>%
    group_by(originCapWild, group_) %>%
    mutate(sumQty = sum(quantity, na.rm = TRUE)) %>%
    select(totalQty, sumQty) %>%
    slice_head(n = 1) %>%
    mutate(percentQty = sumQty/totalQty *100)

  capWildSummaryByEntries <- lemisDataProcessed %>%
    group_by(group_) %>%
    mutate(totalEntries = n()) %>%
    group_by(originCapWild, group_) %>%
    mutate(sumEntries = n()) %>%
    select(totalEntries, sumEntries) %>%
    slice_head(n = 1) %>%
    mutate(percentEntries = sumEntries/totalEntries *100)

  capWildSummary <- full_join(capWildByQty, capWildSummaryByEntries)

  capWildSummary

  write.csv(capWildSummary, file = here("tables", paste0("13_capWildSummary_byGroup_",
                                                         Sys.Date(), "_", filterOpt, ".csv")),
            row.names = FALSE)

  # Origin by group by year PERCENTAGES -------------------------------------------------

  capWildByQtyByYear <- lemisDataProcessed %>%
    group_by(group_, sYear) %>%
    mutate(totalQty = sum(quantity, na.rm = TRUE)) %>%
    group_by(originCapWild, group_, sYear) %>%
    mutate(sumQty = sum(quantity, na.rm = TRUE)) %>%
    select(totalQty, sumQty) %>%
    slice_head(n = 1) %>%
    mutate(percentQty = sumQty/totalQty *100)

  capWildByQtyByYear <- capWildByQtyByYear %>%
    ungroup() %>%
    complete(originCapWild, group_, sYear,
             fill = list(
               "totalQty" = 0,
               "sumQty" = 0,
               "percentQty" = 0))

  capWildSummaryByEntriesByYear <- lemisDataProcessed %>%
    group_by(group_, sYear) %>%
    mutate(totalEntries = n()) %>%
    group_by(originCapWild, group_, sYear) %>%
    mutate(sumEntries = n()) %>%
    select(totalEntries, sumEntries) %>%
    slice_head(n = 1) %>%
    mutate(percentEntries = sumEntries/totalEntries *100)

  capWildSummaryByEntriesByYear <- capWildSummaryByEntriesByYear %>%
    ungroup() %>%
    complete(originCapWild, group_, sYear,
             fill = list(
               "totalEntries" = 0,
               "sumEntries" = 0,
               "percentEntries" = 0))

  capWildSummaryByYear <- full_join(capWildByQtyByYear, capWildSummaryByEntriesByYear)

  write.csv(capWildSummaryByYear, file = here("tables", paste0("13_capWildSummaryByYear_",
                                                               Sys.Date(), "_", filterOpt, ".csv")), row.names = FALSE)

  # Origin by group by year COUNTS ------------------------------------------

  capWildByQtyByYearCOUNT <- lemisDataProcessed %>%
    group_by(originCapWild, group_, sYear) %>%
    summarise(totalQty = sum(quantity, na.rm = TRUE))

  capWildByEntriesByYearCOUNT <- lemisDataProcessed %>%
    group_by(originCapWild, group_, sYear) %>%
    summarise(totalEntries = n())

  capWildSummaryByYearCOUNT <- full_join(capWildByQtyByYearCOUNT, capWildByEntriesByYearCOUNT)

  write.csv(capWildSummaryByYearCOUNT, file = here("tables", paste0("13_capWildSummaryByYearCOUNT_",
                                                                    Sys.Date(), "_", filterOpt, ".csv")),
            row.names = FALSE)

  # Origin by group by year COUNTS Live ------------------------------------------

  capWildByQtyByYearCOUNTLive <- lemisDataProcessed %>%
    filter(description %in% c("LIV")) %>%
    filter(unit == "NO") %>%
    group_by(originCapWild, group_, sYear) %>%
    summarise(totalQty = sum(quantity, na.rm = TRUE))

  write.csv(capWildByQtyByYearCOUNTLive, file = here("tables", paste0("13_capWildByQtyByYearCOUNTLive_",
                                                                      Sys.Date(), "_", filterOpt, ".csv")),
            row.names = FALSE)

  capWildSummaryList <- list(
    "capWildSummary" = capWildSummary,
    "capWildSummaryByYear" = capWildSummaryByYear,
    "capWildSummaryByYearCOUNT" = capWildSummaryByYearCOUNT,
    "capWildByQtyByYearCOUNTLive" = capWildByQtyByYearCOUNTLive
  )

  return(capWildSummaryList)

}
