#' generate_capwild_plots
#'
#' @name generate_capwild_plots
#' @return Create plots that show wild/captive rates per group. Both overall and over time.
#'
#' @export
generate_capwild_plots <- function(capWildSummaryList, filterOpt = filter){

  palettesList <- generate_palette()
  list2env(palettesList, environment())

  capWildSummaryList
  list2env(capWildSummaryList, environment())

  capWildSummaryPlotData <- capWildSummary %>%
    filter(!is.na(group_)) %>%
    filter(!group_ == "Miscellaneous") %>%
    select(originCapWild, percentQty, percentEntries, group_) %>%
    replace(is.na(.), 0) %>%
    left_join(groupPaletteDF) %>%
    mutate(group_ = glue::glue("<b style='color:{group_colour}'>{group_}</b>")) %>%
    pivot_longer(cols = c("percentQty", "percentEntries"),
                 names_to = "variable", values_to = "value") %>%
    mutate(
      variable = case_when(
        variable == "percentQty" ~ "<i><b style='color:#4D4D4D'>Percentage of imported individuals from difference sources:</b></i><br>
      <b style='color:#7e3d11'>Wild</b> <b style='color:#fa8334'>Ranched</b> <b style='color:#388697'>Captive</b> <b style='color:#808080'>Other</b>",
      variable == "percentEntries" ~ "<i><b style='color:#4D4D4D'>Percentage of entries from difference sources:</b></i><br>
      <b style='color:#7e3d11'>Wild</b> <b style='color:#fa8334'>Ranched</b> <b style='color:#388697'>Captive</b> <b style='color:#808080'>Other</b>"
      ),
      group_ = factor(group_, levels = c(
        "<b style='color:#F58234'>Lepidoptera</b>",
        "<b style='color:#7E3E1B'>Arachnids</b>",
        "<b style='color:#3E640D'>Plants</b>",
        "<b style='color:#324B64'>Porifera Sponges, Bryozoa, and Squirts</b>",
        "<b style='color:#5BC0BE'>Amphibians</b>",
        "<b style='color:#4e862d'>Reptiles</b>",
        "<b style='color:#9EB78D'>Birds</b>",
        "<b style='color:#068D9D'>Fish</b>",
        "<b style='color:#808080'>Miscellaneous</b>",
        "<b style='color:#B55727'>Insecta and Myriapoda</b>",
        "<b style='color:#CECE85'>Terrestrial Mammals</b>",
        "<b style='color:#1C6E8C'>Marine Mammals</b>",
        "<b style='color:#FEBF55'>Other Invertebrates</b>",
        "<b style='color:#A4778B'>Crustaceans and Molluscs</b>",
        "<b style='color:#281231'>Echinoderms and Cnidaria</b>"
      )),
      originCapWild = factor(originCapWild, levels = c(
        "Other",
        "Captive",
        "Ranched",
        "Wild"
      ))
    ) %>%
    group_by(group_, variable) %>%
    arrange(desc(originCapWild)) %>%
    mutate(perCum = cumsum(value)) %>%
    ungroup()

  plotOrder <- capWildSummaryPlotData %>%
    filter(originCapWild == "Wild") %>%
    group_by(variable) %>%
    arrange(-value) %>%
    mutate(plotOrder = row_number()) %>%
    select(group_, plotOrder, variable)

  (capWildSummaryPlot_indi <-
      capWildSummaryPlotData %>%
      left_join(plotOrder) %>%
      filter(variable == variable[1]) %>%
      ggplot() +
      geom_vline(xintercept = 0, linewidth = 0.5, linetype = 1, alpha = 1, colour = "#4D4D4D") +
      geom_col(aes(y = reorder(group_, -plotOrder), x = value, fill = originCapWild),
               width = 0.55) +
      geom_text(aes(y = group_, x = perCum,
                    label = ifelse(#originCapWild %in% c("Other") |
                      value < 10,
                      "",
                      paste0(round(value, digits = 0), "%"))),
                colour = "white", hjust = 1, vjust = 0.5, fontface = 4, size = 3) +
      facet_wrap(variable~., ncol = 1, scales = "free_y") +
      scale_fill_manual(values = paletteWildCap) +
      labs(y = "Group", x = "Percentage (%)") +
      scale_x_continuous(limits = c(0, 105),
                         breaks = seq(0,100,20),
                         expand = c(0, 0)) +
      theme_bw() +
      theme(
        text = element_text(colour = "#4d4d4d"),
        line = element_line(colour = "#4d4d4d"),
        axis.ticks = element_line(colour = "#4d4d4d"),
        axis.title = element_text(face = 2),
        axis.title.y = element_blank(),
        axis.text.y = element_markdown(),
        axis.text.x.bottom = element_blank(),
        axis.title.x = element_blank(),
        legend.position = "none",
        strip.background = element_blank(),
        strip.text = element_markdown(hjust = 0, face = 4, size = 10, lineheight = 1.2),
        panel.grid = element_blank(),
        panel.border = element_blank(),
        axis.line.x.bottom = element_line()
      )
  )

  (capWildSummaryPlot_entries <-
      capWildSummaryPlotData %>%
      left_join(plotOrder) %>%
      filter(variable == variable[2]) %>%
      ggplot() +
      geom_vline(xintercept = 0, linewidth = 0.5, linetype = 1, alpha = 1, colour = "#4D4D4D") +
      geom_col(aes(y = reorder(group_, -plotOrder), x = value, fill = originCapWild),
               width = 0.55) +
      geom_text(aes(y = group_, x = perCum,
                    label = ifelse(#originCapWild %in% c("Other") |
                      value < 10,
                      "",
                      paste0(round(value, digits = 0), "%"))),
                colour = "white", hjust = 1, vjust = 0.5, fontface = 4, size = 3) +
      facet_wrap(variable~., ncol = 1, scales = "free_y") +
      scale_fill_manual(values = paletteWildCap) +
      labs(y = "Group", x = "Percentage (%)") +
      scale_x_continuous(limits = c(0, 105),
                         breaks = seq(0,100,20),
                         expand = c(0, 0)) +
      theme_bw() +
      theme(
        text = element_text(colour = "#4d4d4d"),
        line = element_line(colour = "#4d4d4d"),
        axis.ticks = element_line(colour = "#4d4d4d"),
        axis.title = element_text(face = 2),
        axis.title.y = element_blank(),
        axis.text.x.bottom = element_blank(),
        axis.title.x = element_blank(),
        axis.text.y = element_markdown(),
        legend.position = "none",
        strip.background = element_blank(),
        strip.text = element_markdown(hjust = 0, face = 4, size = 10, lineheight = 1.2),
        panel.grid = element_blank(),
        panel.border = element_blank(),
        axis.line.x.bottom = element_line()
      )
  )

  capWildSummaryPlot_indi +
    theme(plot.margin = margin(0,0,0,0)) +
    capWildSummaryPlot_entries +
    theme(plot.margin = margin(0,0,0,0)) +
    patchwork::plot_layout(ncol = 1) +
    patchwork::plot_annotation(tag_levels = "A", theme = theme(plot.tag = element_text(face = 2))) &
    theme(plot.tag = element_text(face = 4, size = 18, colour = "#4d4d4d",
                                  margin = margin(0,10,0,10)))

  ggsave(here("figures", paste0("originCapWild_", Sys.Date(), "_", filterOpt, ".png")),
         width = 210, height = 220, units = "mm")
  ggsave(here("figures", paste0("originCapWild_", Sys.Date(), "_", filterOpt, ".pdf")),
         width = 210, height = 220, units = "mm")

  # Origin by group by year PERCENTAGES -------------------------------------------------

  # capWildSummaryByYear <- read.csv(file = here("tables", "13_capWildSummaryByYear.csv"))

  capWildSummaryByYear %>%
    mutate(originCapWild = factor(originCapWild, levels = c(
      "Other",
      "Captive",
      "Ranched",
      "Wild"
    ))) %>%
    ggplot() +
    geom_area(aes(x = sYear, y = percentQty,
                  fill = originCapWild,
                  group = originCapWild)) +
    geom_text(data = capWildSummaryByYear %>%
                ungroup() %>%
                group_by(group_) %>%
                slice_head(n = 1),
              aes(x = 2000+0.1, y = 15, label = group_), colour = "white",
              hjust = 0, vjust = 0, fontface = 4) +
    facet_wrap(group_~., ncol = 1) +
    labs(x = "Shipment Year", y = "Percentage\nof Individuals", fill = "Origin") +
    scale_y_continuous(breaks = seq(0,100,50),
                       expand = expansion(0,0)) +
    scale_x_continuous(expand = expansion(0,0),
                       breaks = seq(2000,2022,1)) +
    scale_fill_manual(values = paletteWildCap) +
    coord_cartesian(clip = "off") +
    theme_bw() +
    theme(
      text = element_text(colour = "#4d4d4d"),
      line = element_line(colour = "#4d4d4d"),
      axis.ticks = element_line(colour = "#4d4d4d", linewidth = 0.75),
      axis.title = element_text(face = 2),
      axis.title.y = element_text(face = 2, angle = 0, hjust = 1),
      axis.text.x = element_text(margin = margin(2,0,8,0)),
      strip.background = element_blank(),
      strip.text = element_blank(),
      legend.title = element_text(face = 2),
      axis.text.y.left = element_text(vjust = c(0, 0.5, 1),
                                      margin = margin(0,0,0,0)),
      panel.grid = element_blank(),
      panel.border = element_blank(),
      axis.ticks.y = element_blank(),
      axis.line.x.bottom = element_line(linewidth = 0.75)
    )

  ggsave(here("figures", paste0("originCapWildByYearByQty_", Sys.Date(), "_", filterOpt, ".png")),
         width = 260, height = 180, units = "mm")
  ggsave(here("figures", paste0("originCapWildByYearByQty_", Sys.Date(), "_", filterOpt, ".pdf")),
         width = 260, height = 180, units = "mm")


  capWildSummaryByYear %>%
    mutate(originCapWild = factor(originCapWild, levels = c(
      "Other",
      "Captive",
      "Ranched",
      "Wild"
    ))) %>%
    ggplot() +
    geom_area(aes(x = sYear, y = percentEntries,
                  fill = originCapWild,
                  group = originCapWild)) +
    geom_text(data = capWildSummaryByYear %>%
                ungroup() %>%
                group_by(group_) %>%
                slice_head(n = 1),
              aes(x = as.numeric(sYear)+0.1, y = 15, label = group_), colour = "white",
              hjust = 0, vjust = 0, fontface = 4) +
    facet_wrap(group_~., ncol = 1) +
    labs(x = "Shipment Year", y = "Percentage\nof Entries", fill = "Origin") +
    scale_y_continuous(breaks = seq(0,100,50),
                       expand = expansion(0,0)) +
    scale_x_continuous(expand = expansion(0,0),
                       breaks = seq(2000,2022,1)) +
    scale_fill_manual(values = paletteWildCap) +
    coord_cartesian(clip = "off") +
    theme_bw() +
    theme(
      text = element_text(colour = "#4d4d4d"),
      line = element_line(colour = "#4d4d4d"),
      axis.ticks = element_line(colour = "#4d4d4d", linewidth = 0.75),
      axis.title = element_text(face = 2),
      axis.title.y = element_text(face = 2, angle = 0, hjust = 1),
      axis.text.x = element_text(margin = margin(2,0,8,0)),
      strip.background = element_blank(),
      strip.text = element_blank(),
      legend.title = element_text(face = 2),
      axis.text.y.left = element_text(vjust = c(0, 0.5, 1),
                                      margin = margin(0,0,0,0)),
      panel.grid = element_blank(),
      panel.border = element_blank(),
      axis.ticks.y = element_blank(),
      axis.line.x.bottom = element_line(linewidth = 0.75)
    )

  # ggsave(here("figures", "originCapWildByYearByEntries.png"),
  #        width = 260, height = 180, units = "mm")
  # ggsave(here("figures", "originCapWildByYearByEntries.pdf"),
  #        width = 260, height = 180, units = "mm")

  # Origin by group by year COUNTS ------------------------------------------

  # capWildSummaryByYearCOUNT <- read.csv(file = here("tables", "13_capWildSummaryByYearCOUNT.csv"))

  capWildSummaryByYearCOUNT %>%
    mutate(originCapWild = factor(originCapWild, levels = c(
      "Other",
      "Captive",
      "Ranched",
      "Wild"
    ))) %>%
    ggplot() +
    geom_area(aes(x = sYear, y = totalQty, fill = originCapWild),
              position = position_stack()) +
    geom_text(data = capWildSummaryByYearCOUNT %>%
                ungroup() %>%
                group_by(group_) %>%
                slice_head(n = 1),
              aes(x = 2000+0.1, y = Inf, label = group_), colour = "black",
              hjust = 0, vjust = 1, fontface = 4) +
    facet_wrap(group_~., ncol = 1, scales = "free_y") +
    labs(x = "Shipment Year", y = "Number of\nIndividuals", fill = "Origin") +
    scale_y_continuous(breaks = function(x) c(0, max(x, na.rm = TRUE)),
                       labels = scales::comma) +
    scale_x_continuous(expand = expansion(0,0),
                       breaks = seq(2000,2022,1)) +
    scale_fill_manual(values = paletteWildCap) +
    coord_cartesian(clip = "off") +
    theme_bw() +
    theme(
      text = element_text(colour = "#4d4d4d"),
      line = element_line(colour = "#4d4d4d"),
      axis.ticks = element_line(colour = "#4d4d4d", linewidth = 0.75),
      axis.title = element_text(face = 2),
      axis.title.y = element_text(face = 2, angle = 0, hjust = 1),
      axis.text.x = element_text(margin = margin(2,0,8,0)),
      strip.background = element_blank(),
      strip.text = element_blank(),
      legend.title = element_text(face = 2),
      # axis.text.y.left = element_text(vjust = c(0, 0.5, 1),
      #                                 margin = margin(0,0,0,0)),
      panel.grid.minor = element_blank(),
      panel.border = element_blank(),
      axis.line = element_line(linewidth = 0.75),
      panel.spacing = unit(4, "mm")
    )

  ggsave(here("figures", paste0("originCapWildByYearByQtyCOUNT_", Sys.Date(), "_", filterOpt, ".png")),
         width = 260, height = 260, units = "mm")
  ggsave(here("figures", paste0("originCapWildByYearByQtyCOUNT_", Sys.Date(), "_", filterOpt, ".pdf")),
         width = 260, height = 260, units = "mm")

  capWildSummaryByYearCOUNT %>%
    ggplot() +
    geom_area(aes(x = sYear, y = totalEntries, fill = originCapWild),
              position = position_stack()) +
    geom_text(data = capWildSummaryByYearCOUNT %>%
                ungroup() %>%
                group_by(group_) %>%
                slice_head(n = 1),
              aes(x = 2000+0.1, y = Inf, label = group_), colour = "black",
              hjust = 0, vjust = 1, fontface = 4) +
    facet_wrap(group_~., ncol = 1, scales = "free_y") +
    labs(x = "Shipment Year", y = "Number of\nEntries", fill = "Origin") +
    scale_y_continuous(breaks = function(x) c(0, max(x, na.rm = TRUE)),
                       labels = scales::comma) +
    scale_x_continuous(expand = expansion(0,0),
                       breaks = seq(2000,2022,1)) +
    scale_fill_manual(values = paletteWildCap) +
    coord_cartesian(clip = "off") +
    theme_bw() +
    theme(
      text = element_text(colour = "#4d4d4d"),
      line = element_line(colour = "#4d4d4d"),
      axis.ticks = element_line(colour = "#4d4d4d", linewidth = 0.75),
      axis.title = element_text(face = 2),
      axis.title.y = element_text(face = 2, angle = 0, hjust = 1),
      axis.text.x = element_text(margin = margin(2,0,8,0)),
      strip.background = element_blank(),
      strip.text = element_blank(),
      legend.title = element_text(face = 2),
      # axis.text.y.left = element_text(vjust = c(0, 0.5, 1),
      #                                 margin = margin(0,0,0,0)),
      panel.grid.minor = element_blank(),
      panel.border = element_blank(),
      axis.line = element_line(linewidth = 0.75),
      panel.spacing = unit(4, "mm")
    )

  # ggsave(here("figures", "originCapWildByYearByEntriesCOUNT.png"),
  #        width = 260, height = 260, units = "mm")
  # ggsave(here("figures", "originCapWildByYearByEntriesCOUNT.pdf"),
  #        width = 260, height = 260, units = "mm")

  # Origin by group by year COUNTS Live ------------------------------------------

  # capWildByQtyByYearCOUNTLive <- read.csv(file = here("tables", "13_capWildByQtyByYearCOUNTLive.csv"))

  capWildByQtyByYearCOUNTLive %>%
    ggplot() +
    geom_area(aes(x = sYear, y = totalQty, fill = originCapWild),
              position = position_stack()) +
    geom_text(data = capWildByQtyByYearCOUNTLive %>%
                ungroup() %>%
                group_by(group_) %>%
                slice_head(n = 1),
              aes(x = 2000+0.1, y = Inf, label = group_), colour = "black",
              hjust = 0, vjust = 1, fontface = 4) +
    facet_wrap(group_~., ncol = 1, scales = "free_y") +
    labs(x = "Shipment Year", y = "Number of\nIndividuals\n(Live)", fill = "Origin") +
    scale_y_continuous(breaks = function(x) c(0, max(x, na.rm = TRUE)),
                       labels = scales::comma) +
    scale_x_continuous(expand = expansion(0,0),
                       breaks = seq(2000,2022,1)) +
    scale_fill_manual(values = paletteWildCap) +
    coord_cartesian(clip = "off") +
    theme_bw() +
    theme(
      text = element_text(colour = "#4d4d4d"),
      line = element_line(colour = "#4d4d4d"),
      axis.ticks = element_line(colour = "#4d4d4d", linewidth = 0.75),
      axis.title = element_text(face = 2),
      axis.title.y = element_text(face = 2, angle = 0, hjust = 1),
      axis.text.x = element_text(margin = margin(2,0,8,0)),
      strip.background = element_blank(),
      strip.text = element_blank(),
      legend.title = element_text(face = 2),
      # axis.text.y.left = element_text(vjust = c(0, 0.5, 1),
      #                                 margin = margin(0,0,0,0)),
      panel.grid.minor = element_blank(),
      panel.border = element_blank(),
      axis.line = element_line(linewidth = 0.75),
      panel.spacing = unit(4, "mm")
    )

  ggsave(here("figures", paste0("originCapWildByYearByQtyCOUNTLive_", Sys.Date(), "_", filterOpt, ".png")),
         width = 260, height = 260, units = "mm")
  ggsave(here("figures", paste0("originCapWildByYearByQtyCOUNTLive_", Sys.Date(), "_", filterOpt, ".pdf")),
         width = 260, height = 260, units = "mm")


}
