figure 
hold all

%% NEW U-Pb CA-ID-TIMS (analytical+tracer errors)
IFage0=[1886.5, 1887.2, 1885.8];
IFerror0=[1.6,1.2, 2.0];

subplot(1,5,1)
errorbar([1:3],IFage0,IFerror0,'pr', 'vertical')
ylim([1800,1950])
set(gca, 'YDir','reverse')
xlabel('Emperor Volcanics-Ironwood iron formation')
 xlim([0,4])
% %% Pb-Pb + Total uncertainties
% subplot(1,5,2)
% hold
% %New CA-ID-TIMS Data 
% IFage1=[1887.1, 1890.1, 1888.3];
% IFerror1=[6.1,6.1, 6.5];
% 
% errorbar([1:length(IFage1)],IFage1,IFerror1,'pr', 'vertical')
% ylim([1800,1950])
% set(gca, 'YDir','reverse')
% 
% %New LA-ICP-MS Data
% IFage2=[1898.79, 1891.2, 1901.4];
% IFerror2=[23.6, 26, 26.8];
% errorbar([1:length(IFage2)],IFage2,IFerror2,'vm', 'vertical')
%% Pb-Pb + analytical uncertainties (not decay constants)
subplot(1,5,2)
hold
%New CA-ID-TIMS Data 
IFage1=[1887.1, 1890.1, 1888.3];
IFerror1=[1.6,1.5, 2.9];

errorbar([1:length(IFage1)],IFage1,IFerror1,'pr', 'vertical')
ylim([1800,1950])
set(gca, 'YDir','reverse')

%New LA-ICP-MS Data
IFage2=[1898.79, 1891.2, 1901.4];
IFerror2=[6.9, 13, 14.3];
errorbar([1:length(IFage2)],IFage2,IFerror2,'vm', 'vertical')
% Start-end dates of iron deposition
IFmax=[1935.00	1911.00];
IFmin=[1866.00	1876.00];
x=[1:length(IFmax)];
plot([x;x]+4, [IFmax; IFmin],'-k')
%title('Emperor volcanics CA-ID-TIMS (red), LA-ICP-MS (pink) and calculated iron formation onset/demise ages using 10, 20, 50cm/yr depositional rates(black) ')
%% Previosly published data

subplot(1,5,3)
hold
%recalculated Fralick Gunflint age
GFage=[1877.2];
GFerror=[2.5];

errorbar([1],GFage,GFerror,'*r', 'vertical')
ylim([1800,1950])
set(gca, 'YDir','reverse')

% Start-end dates of iron deposition
Gunflintmax=[1883.50	1880.50];
Gunflintmin=[1864.50 1871.00];
x=[1:length(IFmax)];
plot([x;x]+4, [Gunflintmax; Gunflintmin],'-k')
% title('gunflint age (red) and calculated onset/demise ages using 10, 20, 50cm/yr depositional rates(black) ')
xlabel('Gunflint')
%% CIRCUM SUPERIOR MAGMATIC PROVINCE
 % Data from Supplementary table 3
CSMPageALL=[1907	1900	1896.8	1891	1887	1886	1885.2	1885	1885	1884.5	1884	1883.7	1883	1883	1882.9	1882.7	1882.1	1882	1881.5	1880.6	1879.9	1878.5	1877.2	1877	1876.7	1876	1874.6	1872	1870.8	1870.7	1870.3	1870	1865	1864	1855];
CSMPerrorALL=[1.4	14	1.4	4	39	0.9	2.1	5	49	3.8	2	1.7	2	1.7	1.45	1.3	2	3.9	0.9	2.4	5	0.8	5.3	7	5.1	8	3.4	13	2.5	1.1	7.1	4	22	6	13];

subplot(1,5,4)
hold
violin(CSMPageALL.','CSMP')
boxplot(CSMPageALL,'CSMP')
errorbar(ones(length(CSMPageALL),1),CSMPageALL,CSMPerrorALL,'og', 'vertical')
 xlim([0,1.8])
  ylim([1800,1950])
set(gca, 'YDir','reverse')
 
% Hulbert 2005 and Heaman 2009
 CSMPage=[1876.4, 1879.1];
 CSMPerror=[2.2, 3.1];

 errorbar([1.5,1.6],CSMPage,CSMPerror,'*k', 'vertical')


%% PENOKEAN AGES
 % Data from Supplementary table 3
PenokeanAgeALL=[1892	1889	1889	1885	1885	1885	1880	1877	1871	1870	1869	1866	1862	1861	1860	1859	1858	1858	1857	1856	1853	1852	1852	1848	1847	1847	1846	1846	1845	1842	1842	1841	1839	1838	1837	1837	1836	1836	1835	1835	1835	1833.2	1833	1831	1827	1824	1815	1815	1814	1812	1800	1790	1773	1768	1765	1760	1760	1752	1739, 1861	1844	1844	1831	1829	1829	1828	1819	1817	1810	1799	1796	1793	1791	1790	1788	1786	1780	1779	1777	1776	1775	1774	1768	1764	1759	1759	1758	1756	1744	1741	1729];
PenokeanErrorALL=[9	6	7	65	65	65	30	15	5	7	6	39	5	40	7	20	5	11	19	5	21	13	15	58	10	16	20	11	7	7	10	10	18	6	9	10	13	11	6	6	10	5.7	4	17	14	25	5	7	4	3.6	4	25	8	11	6	10	12	8	8, 10	7	9	6	5	5	7	3	7	18	3	17	4	6	10	4	4	14	8	3	4	25	7	13	8	6	13	5	5	3	4	11 ];

subplot(1,5,5)
hold
violin(PenokeanAgeALL.','Penokean')
boxplot(PenokeanAgeALL,'Penokean')
errorbar(ones(length(PenokeanAgeALL),1),PenokeanAgeALL,PenokeanErrorALL,'ok', 'vertical')
 ylim([1800,1950])
  xlim([0,1.8])
set(gca, 'YDir','reverse')

% % Holm, 2005
PenokeanAgeSINGLEN=[1880.1];
PenokeanErrorSINGLEN=[6.8];
errorbar([1.5],PenokeanAgeSINGLEN,PenokeanErrorSINGLEN,'*b', 'vertical')


% %Li and Rasmussen 2020
% PenokeanAge=[1844.5 1844.7];
% PenokeanError=[25.0 29.7];
% errorbar([1.6, 1.7],PenokeanAge,PenokeanError,'sb', 'vertical')

PenokeanAge=[1844.5 1844.7];
PenokeanError=[15.8 22.5];
errorbar([1.6, 1.7],PenokeanAge,PenokeanError,'sb', 'vertical')

%% Additional possible plots:
%all reported IF dates
%  IFage=[1878.3	1891	1890	1889	1873.7	1891	1877.8	1884	1880	1870	1874];																											
%  IFerror=[1.3	8	10	32	9.3	3	1.3	1.6	2	4	3];		

% % Penokean ages split up by type
% PenokeanIgAge=[1892	1889	1889	1885	1885	1885	1880	1877	1871	1870	1869	1866	1862	1861	1860	1859	1858	1858	1857	1856	1853	1852	1852	1848	1847	1847	1846	1846	1845	1842	1842	1841	1839	1838	1837	1837	1836	1836	1835	1835	1835	1833.2	1833	1831	1827	1824	1815	1815	1814	1812	1800	1790	1773	1768	1765	1760	1760	1752	1739];
% PenokeanIgError=[9	6	7	65	65	65	30	15	5	7	6	39	5	40	7	20	5	11	19	5	21	13	15	58	10	16	20	11	7	7	10	10	18	6	9	10	13	11	6	6	10	5.7	4	17	14	25	5	7	4	3.6	4	25	8	11	6	10	12	8	8];
% errorbar([1:length(PenokeanIgAge)],PenokeanIgAge,PenokeanIgError,'ok', 'vertical')
% 
%  
% PenokeanMetAge=[1861	1844	1844	1831	1829	1829	1828	1819	1817	1810	1799	1796	1793	1791	1790	1788	1786	1780	1779	1777	1776	1775	1774	1768	1764	1759	1759	1758	1756	1744	1741	1729];
% PenokeanMetError=[10	7	9	6	5	5	7	3	7	18	3	17	4	6	10	4	4	14	8	3	4	25	7	13	8	6	13	5	5	3	4	11 ];
% errorbar([1:length(PenokeanMetAge)],PenokeanMetAge,PenokeanMetError,'om', 'vertical')
% set(gca, 'YDir','reverse')