%Load in data file with headers as column vectors, TYPE=string, replace unimportable cells with NaN and text options as string array
% Region	Group	Formation	Thickness  (m)	Area (m^2)	Age	uncertainty	Min age	max age	stratigraphic height of age	Notes on age	Age references	Notes on area/thickness	References							
% Choose thickness,area or volume as well. 

%Time in millions of years Myr
   t=[1:.001:3500];
%    t=[1:.01:3500];
%       t=[1:1:3500];
   % depositional rate m/Myr
% Iron formations deposited at a rate of 1m/Myr minimum (1-43 m/Myr, Rasmussen et al., 2016; 3.5-49 m/Myr, de Oliveira Carvalho Rodrigues et al., 2019; 1-20 m/Myr, Lantink et al., 2019).
   ms=[1,2, 10, 20, 50]; 
% legend('1 m/Myr','2 m/Myr', '10 m/Myr', '20 m/Myr', '50 m/Myr')


% chert depositional rate=2-10m/Myr
% carbonate depositional rate=20-200m/Myr
% Black shales=5-100m/Myr
%      ms=[2,5,10, 20, 100, 200];
%  legend('chert min 2 m/Myr','black shales min 5 m/Myr','chert max 10 m/Myr',  'carbonate min 20 m/Myr', 'black shales max 100 m/Myr', 'carbonate max 200 m/Myr')

% 
% Tidal flats=20-1000m/Myr
% stable shelf=10-100m/Myr
% Graben/rift basin=50-1000m/Myr
%   ms=[10, 20, 50, 100, 1000];
%  legend('Shelf min 10 m/Myr','Tidal Flats 20 m/Myr','Graben/rift min 50 m/Myr',  'Stable shelf max 100 m/Myr', 'Tidal Flats and Rift max 1000 m/Myr')
%   



  figure(1)
  hold all
   
for k=1:length(ms)
 
     CumIFmin=zeros(length(t),1);
     %Give preference for average age if both min-max age constraints exist
for i=1:length(Age)

    h=Thickness(i); %m height total
    if(strcmp(TYPE(i),'min '))
        tmin=(Min_age(i));
        tmax=(tmin+h/ms(k));
        [~, kmin]=min(abs(t-tmin));
        [~, kmax]=min(abs(t-tmax));   
        CumIFmin(kmin:kmax)=CumIFmin(kmin:kmax)+ms(k);
    elseif(strcmp(TYPE(i),'minmax'))
         ta=((Max_age(i)+(Min_age(i)))/2);
         ha=h/2;
         tmin=(ta-((h-ha)/ms(k)));
         tmax=(ta+ha/ms(k));
        [~, kmin]=min(abs(t-tmin));
        [~, kmax]=min(abs(t-tmax)) ;
         CumIFmin(kmin:kmax)=CumIFmin(kmin:kmax)+ms(k);
    else 
        % If agesig=number
%         ta=(Age(i)-uncertainty(i));
         ta=(Age(i));
         ha=age_height(i);
         tmin=(ta-((h-ha)/ms(k)));
         tmax=(ta+ha/ms(k));
        [~, kmin]=min(abs(t-tmin));
        [~, kmax]=min(abs(t-tmax)); 
         CumIFmin(kmin:kmax)=CumIFmin(kmin:kmax)+ms(k);
         clear ta ha 
    end
    if kmin==kmax
        i;
        'error kmin=kmax';
    end
    clear kmin kmax tmin tmax h
end

 CumIFTotal=cumsum(flip(CumIFmin));
plot(flip(t),(CumIFTotal))

clear CumIFmin
clear CumIFTotal
clear i
end
sum(Thickness)
%   legend('1 m/Myr','2 m/Myr', '10 m/Myr', '20 m/Myr', '50 m/Myr')
%  legend('chert min 2 m/Myr','black shales min 5 m/Myr','chert max 10 m/Myr',  'carbonate min 20 m/Myr', 'black shales max 100 m/Myr', 'carbonate max 200 m/Myr')

%  legend('Shelf min 10 m/Myr','Tidal Flats 20 m/Myr','Graben/rift min 50 m/Myr',  'Stable shelf max 100 m/Myr', 'Tidal Flats and Rift max 1000 m/Myr')
 xlabel('Age (Myr)')
ylabel('Global Iron Depositional (m/Myr)')
 xlim([1800,2200])
 set(gca,'Xdir','reverse')
  title('average constraints')



    figure(2)
     hold all
   
for k=1:length(ms)
     CumIFmin=zeros(size(t));
     %Give preference for maximum age if both minimum and maximum age
     %constraints exist
for i=1:length(Age)
    h=Thickness(i); %m height total
    if(strcmp(TYPE(i),'min '))
        tmin=(Min_age(i));
        tmax=(tmin+h/ms(k));
        [~, kmin]=min(abs(t-tmin));
        [~, kmax]=min(abs(t-tmax));   
        CumIFmin(kmin:kmax)=CumIFmin(kmin:kmax)+ms(k);
    elseif(strcmp(TYPE(i),'minmax'))
        tmax=(Max_age(i));
        tmin=(tmax-h/ms(k));
        [~, kmin]=min(abs(t-tmin));
        [~, kmax]=min(abs(t-tmax)) ;
        
        CumIFmin(kmin:kmax)=CumIFmin(kmin:kmax)+ms(k);
    else 
        % If agesig=number
%           ta=(Age(i));
          ta=(Age(i)+uncertainty(i)); %maximum age for stratigraphic date
         ha=age_height(i);
         tmin=(ta-((h-ha)/ms(k)));
         tmax=(ta+ha/ms(k));
        [~, kmin]=min(abs(t-tmin));
        [~, kmax]=min(abs(t-tmax)); 
         CumIFmin(kmin:kmax)=CumIFmin(kmin:kmax)+ms(k);
         clear ta ha 
    end
    if kmin==kmax
        i;
        'error kmin=kmax';
    end
    clear kmin kmax tmin tmax h
end

 CumIFTotal=cumsum(flip(CumIFmin));
plot(flip(t),(CumIFTotal))

clear CumIFmin
clear CumIFTotal
clear i
end
sum(Thickness)
%  legend('chert min 2 m/Myr','black shales min 5 m/Myr','chert max 10 m/Myr',  'carbonate min 20 m/Myr', 'black shales max 100 m/Myr', 'carbonate max 200 m/Myr')
%   legend('1 m/Myr','2 m/Myr', '10 m/Myr', '20 m/Myr', '50 m/Myr')
%  legend('Shelf min 10 m/Myr','Tidal Flats 20 m/Myr','Graben/rift min 50 m/Myr',  'Stable shelf max 100 m/Myr', 'Tidal Flats and Rift max 1000 m/Myr')
 xlabel('Age (Myr)')
ylabel('Global Iron Depositional')
 xlim([1800,2200])
 set(gca,'Xdir','reverse')
  title('Maximum constraints')

% 
   figure(3)
   hold all
   
for k=1:length(ms)
     CumIFmin=zeros(size(t));
    
     %Give preference for minimum age if both minimum and maximum age
     %constraints exist
for i=1:length(Age)   
    h=Thickness(i); %m height total
    if(strcmp(TYPE(i),'min '))
        tmin=(Min_age(i));
        tmax=(tmin+h/ms(k));
        [~, kmin]=min(abs(t-tmin));
        [~, kmax]=min(abs(t-tmax));   
        CumIFmin(kmin:kmax)=CumIFmin(kmin:kmax)+ms(k);
    elseif(strcmp(TYPE(i),'minmax'))
        tmin=(Min_age(i));
        tmax=(tmin+h/ms(k));
        [~, kmin]=min(abs(t-tmin));
        [~, kmax]=min(abs(t-tmax)) ;
        
        CumIFmin(kmin:kmax)=CumIFmin(kmin:kmax)+ms(k);
    else 
        % If agesig=number
       ta=(Age(i)-uncertainty(i));  %minimum age for stratigraphic date
%               ta=(Age(i));
         ha=age_height(i);
         tmin=(ta-((h-ha)/ms(k)));
         tmax=(ta+ha/ms(k));
        [~, kmin]=min(abs(t-tmin));
        [~, kmax]=min(abs(t-tmax)); 
         CumIFmin(kmin:kmax)=CumIFmin(kmin:kmax)+ms(k);
         clear ta ha 
    end
    if kmin==kmax
        i;
        'error kmin=kmax';
    end
    clear kmin kmax tmin tmax h
end
% subplot(3,1,3);
%   hold all

 CumIFTotal=cumsum(flip(CumIFmin));
plot(flip(t),(CumIFTotal))

clear CumIFmin
clear CumIFTotal
clear i
end
sum(Thickness)
   legend('1 m/Myr','2 m/Myr', '10 m/Myr', '20 m/Myr', '50 m/Myr')
%   legend('chert min 2 m/Myr','black shales min 5 m/Myr','chert max 10 m/Myr',  'carbonate min 20 m/Myr', 'black shales max 100 m/Myr', 'carbonate max 200 m/Myr')
%   legend('Shelf min 10 m/Myr','Tidal Flats 20 m/Myr','Graben/rift min 50 m/Myr',  'Stable shelf max 100 m/Myr', 'Tidal Flats and Rift max 1000 m/Myr')
 xlabel('Age (Myr)')
ylabel('Global Iron Depositional')
 xlim([1800,2200])
 set(gca,'Xdir','reverse')
 title('Minimum constraints')
