
import sys

def main():
    ARGS = sys.argv[1:]
    try:
        in_bim = ARGS[0]
        in_tsv = ARGS[1]
    except:
        print("format_breakpoint_res.py <in.bim> <in.tsv>")
        sys.exit(1)

    # read data in bim to dict
    snpid_chrpos=dict()
    in_fh = open(in_bim, "r")
    for line in in_fh:
        data = line.rstrip().split("\t")
        chrom = data[0]
        pos = data[3]
        snpid = data[1]
        snpid_chrpos[snpid] = (chrom, int(pos))
    in_fh.close()

    # read input table, print header to stdout
    in_fh = open(in_tsv, "r")
    header = in_fh.readline()
    print(header.rstrip())
    for line in in_fh:
        data = line.rstrip().split("\t")
        locus_data = data[0].split("_")
        cnvtype = locus_data[1]
        markers_list = locus_data[0].split(",")
        chroms = set([])
        pos_max = 0
        pos_min = float("inf")
        for marker in markers_list:
            chroms.add(snpid_chrpos[marker][0])
            pos = snpid_chrpos[marker][1]
            if pos > pos_max: pos_max = pos
            if pos < pos_min: pos_min = pos
        if len(chroms) > 1: 
            print("ERROR : marker set on more than 1 chromosome")
            sys.exit(1)
        chroms = list(chroms)
        interval_name = chroms[0] + "_" + str(pos_min) + "_" + str(pos_max)
        test_name_new = interval_name + "_" + cnvtype
        data[0] = test_name_new
        out_str = "\t".join(data)
        print(out_str)

    # close filehandle
    in_fh.close()

    return

if __name__ == "__main__":
    main()
