#!/bin/bash

# check ARGS
if [[ $# -lt 3 ]]
then
  echo "tables_merge.sh <out.tsv> <in.1.tsv> .. <in.N.tsv>"
  exit
fi

# get ARGS
out_tsv=$1
shift
in_tsvs=("$@")

# get n input tsvs (zero-indexed)
n_in_tsvs=${#in_tsvs[@]}
n_in_tsvs_0=`expr $n_in_tsvs - 1`

# for each input file ..
for i in `seq 0 $n_in_tsvs_0`
do

  # get input file
  in_tsv_i="${in_tsvs[$i]}"

  # if this is the first file, then just copy to output file.
  # otherwise, paste every line except for the header to 
  # the output file
  if [[ $i == 0 ]]
  then
    cat $in_tsv_i \
    > $out_tsv
  else
    cat $in_tsv_i \
    | tail -n+2 \
    >> $out_tsv
  fi

done

exit
