

class PenncnvEntry(object):
    def __init__(self, 
                 penncnv_line,
                 iid_prefix_rm=None,
                 iid_postfix_rm=None):
        self.line = penncnv_line.rstrip()
        data = self.line.split()
        self.interval = data[0]
        chrom_startend = self.interval.split(":")
        self.chrom = chrom_startend[0].replace("chr","")
        startend_list = chrom_startend[1].split("-")
        self.start = int(startend_list[0])
        self.end = int(startend_list[1])
        self.numsnp = int(data[1].replace("numsnp=",""))
        self.length = data[2].replace("length=","")
        self.length = int(self.length.replace(",",""))
        state_cn = data[3].split(",")
        self.state = state_cn[0]
        self.cn = int(state_cn[1].replace("cn=",""))
        self.iid = data[4]
        if self.cn < 2:
            self.cnv_type="DEL"
        elif self.cn > 2:
            self.cnv_type="DUP"
        else:
            self.cnv_type=None
        if iid_prefix_rm != None:
            self.iid = self.iid.replace(iid_prefix_rm, "")
        if iid_postfix_rm != None:
            self.iid = self.iid.replace(iid_postfix_rm, "")
        self.info = dict()
        for keyval_str in data[5:]:
            keyval = keyval_str.split("=")
            self.info[keyval[0]] = keyval[1]
        
    def form_bed_line(self):
        bed_list = [self.chrom, self.start - 1, self.end, self.interval, self.cnv_type, self.iid]
        bed_line = "\t".join([str(x) for x in bed_list])
        return bed_line


