#!/usr/bin/env Rscript

## LIBRARY
library(ggplot2)
library(gridExtra)

## PARAM
METRICS_TSV="results/intensity_qc/NORDiC_2021.intensity_callset_metrics.biolqc_intensity_cnv_qc.tsv"
FAM_FILE="../NORDiC_GWAS_CNV_202103/results/sample_biological_qc/NORDiC_2021.MERGED.pruned_miss_sex_rel_EUR_nonoutlier_het.fam"
EIGENVEC_FILE="results/intensity_qc/NORDiC_2021.intensity_callset_metrics.biolqc_intensity_cnv_qc.PCA.eigenvec"
CNV_COUNTS_TSV="results/annot_cnv/NORDiC_2021.qual_cnv.outlier_pruned.30kb_rare_filtered.annot.CDS.counts_global.tsv"
# CNV_COUNTS_TSV="results/annot_cnv/NORDiC_2021.qual_cnv.outlier_pruned.annot.CDS.counts_global.tsv"
GSA_V1_DATASETS <- c("NORDiC-NOR_cases_2019_1",
                     "ANGI_PhaseII_Pedersen_Controls_GSA-MD_wave1",
                     "ANGI_PhaseII_Pedersen_Controls_GSA-MD_wave2")
GSA_V2_DATASETS <- c("NORDiC-NOR_cases_2019_2",
                     "NORDiC-SWE_cases_2018",
                     "LG500_ctrls_2019")
GSA_V3_DATASETS <- c("NORDiC-NOR_cases_2020",
                     "NORDiC-SWE_cases_2020")
GSA_DECODE_DATASETS <- c("norway_ctrls_2019",
                         "norway_ctrls_2020")
GSA_LIFTOVER_DATASETS <- GSA_DECODE_DATASETS
CTRL_DATASETS <- c("ANGI_PhaseII_Pedersen_Controls_GSA-MD_wave1",
                   "ANGI_PhaseII_Pedersen_Controls_GSA-MD_wave2",
                   "LG500_ctrls_2019",
                   "norway_ctrls_2019",
                   "norway_ctrls_2020")
DATASETS <- c(GSA_V1_DATASETS, GSA_V2_DATASETS, GSA_V3_DATASETS,
              GSA_DECODE_DATASETS)
# DUP_COLOR <- "#0072B2"
DUP_COLOR <- "#56B4E9"
# DUP_COLOR <- "#009E73"
DEL_COLOR <- "#D55E00"
# DEL_COLOR <- "#56B4E9"
DEL_COLOR <- "#EE6677"
DUP_COLOR <- "#4477AA"

DELDUP_COLORS <- c(DEL_COLOR, DUP_COLOR)

Main <- function() {

  # get args
  ARGS<- commandArgs(trailingOnly=T)
  if (length(ARGS) != 2) {
    cat("plot_global_cnv_burden_analysis_results.R <in.tsv> <outroot>\n")
    q()
  }
  in_tsv <- ARGS[1]
  outroot <- ARGS[2]

  # read results df
  out_df <- read.table(in_tsv, header=T, stringsAsFactors=F, sep="\t")
  out_df$group <- gsub("_vs_","/", out_df$group)
  out_df$group <- gsub("ctrls","", out_df$group)

  # set plot param
  pd <- position_dodge(0.3)

  # plot results by del, dup (n_cnv)
  out_df.i <- subset(out_df, grepl("cnv", predictor) == F)
  out_df.i <- subset(out_df.i, grepl("n_",predictor) == T)
  out_df.i <- subset(out_df.i, grepl("del_", predictor)==F)
  out_df.i <- subset(out_df.i, grepl("dup_", predictor)==F)
  out_df.i$predictor <- factor(out_df.i$predictor, 
                               levels=c("n_del",
                                        "n_dup")
                              )
  gg1 <- ggplot(out_df.i, aes(x=group, y=lg_est, group=predictor,
                              color=predictor)) + 
                geom_errorbar(aes(ymin=lg_est_95ci_l, ymax=lg_est_95ci_u),
                              width=0.1, position=pd) +
                geom_point(position=pd) + 
                geom_hline(yintercept=1) + 
                theme(axis.text=element_text(size=14),
                      axis.title.x=element_blank()) + 
                ylab("odds ratio")
  ggsave(paste0(outroot, ".n_cnv.lg.pdf"))

  # plot results by del, dup (nbp_cnv)
  out_df.i <- subset(out_df, grepl("cnv", predictor) == F)
  out_df.i <- subset(out_df.i, grepl("nbp_",predictor) == T)
  out_df.i <- subset(out_df.i, grepl("del_", predictor)==F)
  out_df.i <- subset(out_df.i, grepl("dup_", predictor)==F)
  out_df.i$predictor <- factor(out_df.i$predictor, 
                               levels=c("nbp_del",
                                        "nbp_dup")
                              )
  gg1 <- ggplot(out_df.i, aes(x=group, y=lg_est, group=predictor,
                              color=predictor)) + 
                geom_errorbar(aes(ymin=lg_est_95ci_l, ymax=lg_est_95ci_u),
                              width=0.1, position=pd) +
                geom_point(position=pd) + 
                geom_hline(yintercept=1) + 
                theme(axis.text=element_text(size=14),
                      axis.title.x=element_blank()) + 
                ylab("odds ratio")
  ggsave(paste0(outroot, ".nbp_cnv.lg.pdf"))


  q()

}

# fix pval cols
PvalFix <- function(pvals, pvals_digits=2) {
  pvals.x <- ifelse(pvals <= 1,
                    paste0("p = ", 
                           formatC(pvals, format='e', digits=pvals_digits)),
                    "")
  return(pvals.x)
}

if (interactive() == F) {
  Main()
}
