

Main <- function() {
  ARGS <- commandArgs(trailingOnly=T)
  if (length(ARGS) != 5) {
    cat("add_padj_col.R <in.res.tsv> <pval_colname>",
        "<padj_method> <padj_colname> <out.tsv>\n")
    q()
  }
  in.res.tsv <- ARGS[1]
  pval.colname <- ARGS[2]
  padj.method <- ARGS[3]
  padj.colname <- ARGS[4]
  out.tsv <- ARGS[5]
  df<-read.table(in.res.tsv, header=T, stringsAsFactors=F, sep="\t")
  df[[padj.colname]] <- p.adjust(df[[pval.colname]],
                                 method=padj.method)
  write.table(df,
              file=out.tsv,
              row.names=F, col.names=T, sep="\t", quote=F)
}

if (interactive() == F) {
  Main()
}
