
import sys

def main():
    ARGS = sys.argv[1:]
    if len(ARGS) != 2:
        print("gene_to_loci.py <in.tsv> <out.gene_to_loci.tsv>")
        sys.exit(1)

    in_fh = open(ARGS[0], "r")
    gene_to_loci = dict()
    for line in in_fh:
        data = line.rstrip().split("\t")
        if len(data) != 2:
            continue
        if data[1] == "":
            continue
        locus = data[0]
        genes = data[1]
        for gene in genes.split(","):
            if gene not in gene_to_loci:
                gene_to_loci[gene] = []
            gene_to_loci[gene].append(locus)
    in_fh.close()
    
    genes = list(gene_to_loci.keys())
    genes.sort()
    if ARGS[1] == "stdout" or ARGS[1] == "-":
        for gene in genes: 
            print("\t".join([gene, ",".join(gene_to_loci[gene])]))
    else:
        out_fh = open(ARGS[1], "w")
        for gene in genes:
            out_fh.write("\t".join([gene, ",".join(gene_to_loci[gene])])+"\n")
        out_fh.close()


    return

if __name__ == "__main__":
    main()
