

import sys
import argparse

def main():
    parser = argparse.ArgumentParser(
        description=__doc__,
        formatter_class=argparse.RawDescriptionHelpFormatter)
    parser.add_argument('in_bed', help='Input BED (supports "stdin").')
    args = parser.parse_args()   

    # init input fh
    if args.in_bed == "stdin":
        in_fh = sys.stdin
    else:
        in_fh = open(args.in_bed, "r")
    gene_chroms = dict()
    gene_start0_min = dict()
    gene_end_max = dict()
    i = 0
    for line in in_fh:
        i += 1
        if line[0]=="#": continue
        data = line.rstrip().split()
        chrom = data[0]
        start0 = int(data[1])
        end = int(data[2])
        gene = data[3]

        # init gene entry if not in dicts yet
        if gene not in gene_chroms:
            gene_chroms[gene] = set([])
            gene_start0_min[gene] = float('inf')
            gene_end_max[gene] = - float('inf')
       
        # add gene chrom to set
        gene_chroms[gene].add(chrom)

        # update maxes and mins
        if start0 < gene_start0_min[gene]:
            gene_start0_min[gene] = start0
        if end > gene_end_max[gene]:
            gene_end_max[gene] = end

    # close filehandle
    in_fh.close()
    
    # for each gene ..
    for gene in gene_chroms.keys():
        # skip if multiple chroms for gene
        if len(gene_chroms[gene]) > 1:
            continue
        # get single gene chrom
        chroms = list(gene_chroms[gene])
        chrom = chroms[0]
        # define start0 and end as min_start0, max_end
        start0 = gene_start0_min[gene]
        end = gene_end_max[gene]
        # print interval to stdout
        out_list=[chrom, str(start0), str(end), gene]
        out_str = "\t".join(out_list)
        print(out_str)

    return

if __name__ == "__main__":
    main()
