#!/bin/bash

module load R/4.0.4 R_packages/4.0.4

# make output dir
mkdir -p results/mainfigures_maintables/

# Figure 2: CNV burden (nongenic/genic, pLI bins)
rsync \
results/global_cnv_burden_analysis/NORDiC_2022.global_cnv_burden_analysis.plot.del_dup_burden.nongenicgenic_pLI_bins.pdf \
results/mainfigures_maintables/Figure2.global_CNV_burden.genic_pLI_bins.pdf

# Figure 3: CNV burden per constraint bin
rsync \
results/global_cnv_burden_analysis/NORDiC_2022.global_cnv_burden_analysis.plot.del_dup_burden.cons_bins.pdf \
results/mainfigures_maintables/Figure3.global_CNV_burden.constraint_bins.pdf

# Figure 4: gene-based tests
# A: QQ plot (deletions)
# B: QQ plot (duplications)
# C: CNV permutation tests for recurrence of results
rsync \
results/assoc_tests/NORDiC_2022.full.gene.del.qq.pdf \
results/mainfigures_maintables/Figure4A.gene_based_tests.del.qq.pdf
rsync \
results/assoc_tests/NORDiC_2022.full.gene.dup.qq.pdf \
results/mainfigures_maintables/Figure4B.gene_based_tests.dup.qq.pdf
Rscript src/mainfigures_maintables/plot_cnv_recurrence_results.R \
results/assoc_tests/NORDiC_2022.full.sumstats_case_excess.del.perm_counts.tsv \
results/assoc_tests/NORDiC_2022.full.sumstats_case_excess.del.results.tsv \
results/assoc_tests/NORDiC_2022.full.sumstats_case_excess.dup.perm_counts.tsv \
results/assoc_tests/NORDiC_2022.full.sumstats_case_excess.dup.results.tsv \
results/mainfigures_maintables/Figure4C.gene_based_tests.cnv_recurrence.pdf

# convert figure 4A/B/C into image files and combine into one figure
convert -density 300 -quality 100 -scale 95% \
results/mainfigures_maintables/Figure4A.gene_based_tests.del.qq.pdf \
results/mainfigures_maintables/Figure4A.gene_based_tests.del.qq.png
convert -density 300 -quality 100 -scale 95% \
results/mainfigures_maintables/Figure4B.gene_based_tests.dup.qq.pdf \
results/mainfigures_maintables/Figure4B.gene_based_tests.dup.qq.png
convert -density 300 -quality 100 \
results/mainfigures_maintables/Figure4C.gene_based_tests.cnv_recurrence.pdf \
results/mainfigures_maintables/Figure4C.gene_based_tests.cnv_recurrence.png
convert +append \
results/mainfigures_maintables/Figure4A.gene_based_tests.del.qq.png \
results/mainfigures_maintables/Figure4B.gene_based_tests.dup.qq.png \
results/mainfigures_maintables/Figure4AB.gene_based_tests.deldup.qq.png
rsync \
results/global_cnv_burden_analysis/NORDiC_2022.global_cnv_burden_analysis.plot.del_dup_burden.neurodevelopmental.pdf \
results/mainfigures_maintables/Figure4D.neurodevelopmental.pdf
convert -density 300 -quality 100 \
results/mainfigures_maintables/Figure4D.neurodevelopmental.pdf \
results/mainfigures_maintables/Figure4D.neurodevelopmental.png
convert +append \
results/mainfigures_maintables/Figure4C.gene_based_tests.cnv_recurrence.png \
results/mainfigures_maintables/Figure4D.neurodevelopmental.png \
results/mainfigures_maintables/Figure4CD.recurrence_neurodevelopmental.png
convert -append \
results/mainfigures_maintables/Figure4AB.gene_based_tests.deldup.qq.png \
results/mainfigures_maintables/Figure4CD.recurrence_neurodevelopmental.png \
results/mainfigures_maintables/Figure4.gene_based_tests.png

# make tarball of main figures and tables
cd results/
DATESTAMP=`date +%Y%m%d`
tar -cvzf NORDiC_CNV.mainfigures_maintables.$DATESTAMP.tar.gz mainfigures_maintables/
cd ../

exit
