#!/bin/bash

## MODULE 
module load R/4.0.4 R_packages/4.0.4

# get datestamp
DATESTAMP=`date +%Y%m%d`

# make sure output dir exists
mkdir -p results/cnv_carrier_table/

# make CNV carrier table with the following info :
# sample_iid,indiv_iid,locus,cnvtype,size,is_neurodev,is_gt_1mb,is_pli_995
Rscript 08.cnv_carrier_table.R \
results/cnv_carrier_table/NORDiC.cnv_carrier_table.${DATESTAMP}

# go to output dir 
cd results/cnv_carrier_table/

# make tarball with all files
tar -cvzf NORDiC.cnv_carrier_table.${DATESTAMP}.tar.gz \
NORDiC.cnv_carrier_table.${DATESTAMP}.*.tsv \
NORDiC.cnv_carrier_table.${DATESTAMP}.*.xlsx \
NORDiC.cnv_carrier_table.${DATESTAMP}.*.bed

exit
