#!/bin/bash
#SBATCH -A sens2018605
#SBATCH -p core
#SBATCH -N 1
#SBATCH -n 1
#SBATCH -t 24:00:00
#SBATCH --mem=8g
#SBATCH -J 07.wes_meta
#SBATCH --output=logs/wes_meta/wes_meta.%A.out
#SBATCH --error=logs/wes_meta/wes_meta.%A.err

## MODULE
module load bioinfo-tools plink/1.07
module load python/3.8.7
module load R/3.6.0 R_packages/3.6.0

# get path to penncnv scripts
source cfg/cnv_calling.cfg

# add to python path
export PYTHONPATH="$PYTHONPATH:$PWD/src/python/:$PY3_MODULES_DIR"

# meta-analyze CNV data using results from Halvorsen et al. 2021
# 1. enrichment in genes with pLI > 0.995 and OR > 1 in WES caco,
#    relative to other genes with pLI > 0.995
# 2. meta-analysis of WES LoF case/control data and CNV del gene-based
# 3. enrichment in genes hit by at least one DNM in OCD (misD, LoF)
#

# make sure output dir exists
mkdir -p results/wes_meta/

# create Makevars file to use for building rstan
echo "CXX14 = g++" > results/wes_meta/Makevars
echo "CXX14FLAGS = -std=c++14 -fPIC -O3" >> results/wes_meta/Makevars

# define path to Makevars file required for using rstan
export R_MAKEVARS_USER=$PWD/results/wes_meta/Makevars

# get CNV minmax positions per gene
python3 src/annot_cnv/bed_minmax_locus.py \
results/annot_cnv/Homo_sapiens.GRCh37.87.CDS.bed \
> results/wes_meta/Homo_sapiens.GRCh37.87.CDS.minmax_per_gene.bed

# run extTADA meta-analysis with existing OCD exome summary statistics
Rscript 07.wes_meta.R \
> results/wes_meta/NORDiC_2022.OCD_rarevar_meta-analysis.771trios_2724ca_5369co.out \
2>results/wes_meta/NORDiC_2022.OCD_rarevar_meta-analysis.771trios_2724ca_5369co.err

# plot extTADA results in the form of a manhattan plot
Rscript src/wes_meta/plot_extTADA.R \
results/wes_meta/Homo_sapiens.GRCh37.87.CDS.minmax_per_gene.bed \
results/wes_meta/NORDiC_2022.OCD_rarevar_meta-analysis.771trios_2724ca_5369co.gene_res.tsv \
results/wes_meta/NORDiC_2022.OCD_rarevar_meta-analysis.771trios_2724ca_5369co.manhattan.pdf \
> results/wes_meta/NORDiC_2022.OCD_rarevar_meta-analysis.771trios_2724ca_5369co.manhattan.out \
2>results/wes_meta/NORDiC_2022.OCD_rarevar_meta-analysis.771trios_2724ca_5369co.manhattan.err

exit

