#!/bin/bash
#SBATCH -A sens2018605
#SBATCH -p core
#SBATCH -N 1
#SBATCH -n 1
#SBATCH -t 48:00:00
#SBATCH --mem=8g
#SBATCH -J 00.hdf5
#SBATCH --output=logs/hdf5/hdf5.%A.out
#SBATCH --error=logs/hdf5/hdf5.%A.err

# python/3.3    python/3.3.1  python/3.4.3  python/3.5.0  python/3.6.0  python/3.6.8  python/3.7.2  python/3.8.7
module load python/3.8.7

# make sure output dir exists
mkdir -p results/hdf5/

# build bim
awk '{if ($1=="23") {
        $1="X"
      } else if ($1=="24") {
        $1="Y"
      } else if ($1=="25") {
        $1="XY"
      } else if ($1=="26") {
        $1="M"
      }
      OFS="\t"; print $1,$2,$3,$4,$5,$6
    }' \
../NORDiC_GWAS_CNV_202103/results/dataset_merge/NORDiC_2021.MERGED.with_phe.nonambig_snv.bim \
> results/hdf5/NORDiC_2021.X_Y_XY_M.bim

python src/hdf5/intensity_hdf5_build.py \
--hdf5-write-mode w \
--chroms "1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,X" \
--intensity-file-suffix ".txt.adjusted" \
--intensity-filename-sampleid-pos 2 \
results/hdf5/NORDiC_CNV_caco_2021.intensity_data.h5 \
GSA \
results/hdf5/NORDiC_2021.X_Y_XY_M.bim \
NORDiC-SWE_cases_2018:../NORDiC_GWAS_CNV_202103/results/genomic_wave/SWE/NORDiC-SWE_cases_2018/ \
NORDiC-SWE_cases_2020:../NORDiC_GWAS_CNV_202103/results/genomic_wave/SWE/NORDiC-SWE_cases_2020/ \
LG500_ctrls_2019:../NORDiC_GWAS_CNV_202103/results/genomic_wave/SWE/LG500_ctrls_2019/ \
ANGI_PhaseII_Pedersen_Controls_GSA-MD_wave1:../NORDiC_GWAS_CNV_202103/results/extra_quantisnp_files/SWE/ANGI_PhaseII_Pedersen_Controls_GSA-MD_wave1/ \
ANGI_PhaseII_Pedersen_Controls_GSA-MD_wave2:../NORDiC_GWAS_CNV_202103/results/extra_quantisnp_files/SWE/ANGI_PhaseII_Pedersen_Controls_GSA-MD_wave2/ \
NORDiC-NOR_cases_2019_1:../NORDiC_GWAS_CNV_202103/results/genomic_wave/NOR/NORDiC-NOR_cases_2019_1/ \
NORDiC-NOR_cases_2019_2:../NORDiC_GWAS_CNV_202103/results/genomic_wave/NOR/NORDiC-NOR_cases_2019_2/ \
NORDiC-NOR_cases_2020:../NORDiC_GWAS_CNV_202103/results/genomic_wave/NOR/NORDiC-NOR_cases_2020/ \
norway_ctrls_2019:../NORDiC_GWAS_CNV_202103/results/extra_quantisnp_files/NOR/norway_ctrls_2019/ \
norway_ctrls_2020:../NORDiC_GWAS_CNV_202103/results/extra_quantisnp_files/NOR/norway_ctrls_2020/

exit
