function [table] = network_data(parameters)

    % table for storing data
    num_timesteps = parameters.EndTime / parameters.TimeStep - 3;
    table = zeros(num_timesteps,17);
    index = 1;

    % iterate through each introduction in the simulation
    for i = 8000:2000:parameters.EndTime

        % load data from each snapshot
        output = parameters.OutputDirectoryPath;
        snapshot = load(sprintf('%s/modelled/snapshots/snapshot-%d.mat', output, i));
        network = full(snapshot.A);

        [num_p, num_a] = size(network);
        richness = num_p + num_a;
        connectence = sum(sum(network > 0)) / (num_p * num_a);
        network_stats = [...
            num_p, ...
            num_a, ...
            richness, ...
            connectence, ...
            sum(snapshot.VP.PopulationDensity), ...
            sum(snapshot.VA.PopulationDensity), ...
            ];

        params = [...
            parameters.TimeStep, ...
            parameters.EndTime, ...
            parameters.InvPlantProb, ...
            parameters.InvPolProb, ...
            parameters.SpcPlantProb, ...
            parameters.SpcPolProb, ...
            parameters.NumPlantsPerTimeStep, ...
            parameters.NumPolsPerTimeStep, ...
            parameters.PlantExtThresh, ...
            parameters.PolExtThresh];
        
        % add data to table
        table(index, :) = [params, i, network_stats];
        index = index + 1;

    end
end
