"""
Created by Giuseppe Nisticò
March 25, 2022.

An example of program on how to plot the 3D coordinate data and 
performing PCA analysis. 
"""

import numpy as np
import matplotlib.pyplot as plt

import stereoscopy as stereo

plt.ion()

#------------------------------------------------

ft = 'data_example/output.dat' # sample
fscc = 'data_example/scc_measure_output.dat'

# reading the content of file ft
points = stereo.read_triangulation_output(ft)

#plotting the data points in the HEEQ reference frames
fig, ax = stereo.plot_heeq_projections(points, 'blue')

# reading the content of file fscc
points_scc= stereo.read_scc_measure_file(fscc)

# overplot the data points from fscc in the fig environment
stereo.overplot_points(points_scc, ax, 'red')

# calculation of the midpoint
midpoint = np.array(0.5 * (points[:,0] + points[:,-1]))
print('Midpoint=', midpoint)

#performin PCA
evalue, evector = stereo.pca(points, midpoint)


# plot PCA eigenvectors and defining the best-fitting curve
stereo.plot_pca_heeq(ax, points, midpoint, evalue, evector)
ss, loop, loop_heeq = stereo.define_loop(midpoint, evalue, evector)
stereo.plot_loop(loop_heeq, midpoint, ax)

# plot the data points and the best-fitting curve in the local reference frame
fig1, ax1 = stereo.plot_loop_local_frame(points, midpoint, loop_heeq, evalue, evector)

fig.savefig('event_20130121_heeq.png', dpi=300,bbox_inches='tight')
fig1.savefig('event_20130121_local.png', dpi=300,bbox_inches='tight')

plt.show()
