(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    938046,      21794]
NotebookOptionsPosition[    918267,      21501]
NotebookOutlinePosition[    918667,      21517]
CellTagsIndexPosition[    918624,      21514]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "set", " ", "path", " ", "to", " ", "the", " ", "folder", " ", "where", 
     " ", "input", " ", "data", " ", "for", " ", "economy", " ", "data"}], 
    ",", " ", 
    RowBox[{
     RowBox[{"i", ".", "e", ".", " ", "PWT"}], " ", "data", " ", "is", " ", 
     "located"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
  "SetDirectory", "[", "\"\<...\\\\Data\\Economy_Population_Data\>\"", 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.8364777107833996`*^9, 3.8364777165127416`*^9}, {
   3.8364777559038625`*^9, 3.8364777866487913`*^9}, {3.839672809954939*^9, 
   3.8396728120392575`*^9}, {3.843456124947671*^9, 3.843456181870958*^9}, {
   3.8434715802198286`*^9, 3.8434716157068615`*^9}, {3.8472039721178327`*^9, 
   3.8472040573639383`*^9}, {3.847204088233445*^9, 3.8472041146700993`*^9}, 
   3.847420517471401*^9, {3.876585435288249*^9, 3.876585438255335*^9}},
 EmphasizeSyntaxErrors->
  True,ExpressionUUID->"3a2299ed-c337-4a69-b47b-2a7067412548"],

Cell[BoxData["\<\"C:\\\\Users\\\\rickels\\\\Dropbox\\\\Historic_DICE_Dropbox\\\
\\Data\\\\Economy_Population_Data\"\>"], "Output",
 CellChangeTimes->{
  3.847420518153681*^9, 3.8475614080094976`*^9, 3.8481281724315777`*^9, {
   3.8489776093446546`*^9, 3.8489776203933744`*^9}, 3.84911664113462*^9, 
   3.850413891652196*^9, 3.851416717039143*^9, 3.852983473280803*^9, 
   3.8725014357338667`*^9, 3.872562598044712*^9, 3.8730108499240427`*^9, 
   3.873105538984622*^9, 3.8744804187853556`*^9},
 CellLabel->
  "Out[254]=",ExpressionUUID->"8d771d77-795d-4258-9e98-19613dd2e158"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Calculate output time series Data at National Prices (rgdpna: Real GDP at \
constant 2017 national prices (in mil. 2017US$))\
\>", "Section",
 CellChangeTimes->{{3.836542594258254*^9, 3.8365426333406935`*^9}, {
  3.8514179079447613`*^9, 3.8514179341607065`*^9}, {3.8728243262115707`*^9, 
  3.8728243362728667`*^9}},ExpressionUUID->"9c26658f-85de-4ad1-ae89-\
4eecb7c5fd1c"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"outdat", "=", 
   RowBox[{"Import", "[", "\"\<rgdpna_Transposed.csv\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Dimensions", "[", "outdat", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"outraw", "=", 
   RowBox[{"outdat", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", ";;"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Dimensions", "[", "outraw", "]"}]}], "Input",
 CellChangeTimes->{{3.836488684322794*^9, 3.836488717665448*^9}, {
   3.8365095817211227`*^9, 3.836509641295874*^9}, {3.836509682166654*^9, 
   3.836509702458148*^9}, {3.8365097675526342`*^9, 3.836509784129525*^9}, {
   3.8365426811963367`*^9, 3.836542682395773*^9}, 3.837857662115677*^9, 
   3.851417898047611*^9},
 CellLabel->
  "In[255]:=",ExpressionUUID->"0666d5bf-b080-4b23-9cfa-7d0df3d9425b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"72", ",", "181"}], "}"}]], "Output",
 CellChangeTimes->{{3.836509693100114*^9, 3.83650970921728*^9}, {
   3.836509758333559*^9, 3.836509784954318*^9}, 3.8365426835969915`*^9, 
   3.8377865051016493`*^9, {3.837793677191223*^9, 3.8377936965753813`*^9}, 
   3.8378576636494656`*^9, 3.838396485242078*^9, 3.838476313106024*^9, 
   3.839672869446193*^9, 3.8434600935730104`*^9, 3.8472041727345524`*^9, 
   3.8474204863300977`*^9, 3.848128174786978*^9, 3.8489827295626907`*^9, 
   3.8491166562133064`*^9, 3.849514993408242*^9, 3.851417900277008*^9, 
   3.8725014376430655`*^9, 3.87256259854665*^9, 3.8730108504234047`*^9, 
   3.874480424809184*^9},
 CellLabel->
  "Out[256]=",ExpressionUUID->"da0ab1f5-e54c-4e7e-8b1f-1f911a34bd42"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"71", ",", "181"}], "}"}]], "Output",
 CellChangeTimes->{{3.836509693100114*^9, 3.83650970921728*^9}, {
   3.836509758333559*^9, 3.836509784954318*^9}, 3.8365426835969915`*^9, 
   3.8377865051016493`*^9, {3.837793677191223*^9, 3.8377936965753813`*^9}, 
   3.8378576636494656`*^9, 3.838396485242078*^9, 3.838476313106024*^9, 
   3.839672869446193*^9, 3.8434600935730104`*^9, 3.8472041727345524`*^9, 
   3.8474204863300977`*^9, 3.848128174786978*^9, 3.8489827295626907`*^9, 
   3.8491166562133064`*^9, 3.849514993408242*^9, 3.851417900277008*^9, 
   3.8725014376430655`*^9, 3.87256259854665*^9, 3.8730108504234047`*^9, 
   3.874480424813165*^9},
 CellLabel->
  "Out[258]=",ExpressionUUID->"755624ce-5ce1-4114-bae7-85e373fd0408"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"loutraw", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "71"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "181"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"loutraw", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "1"}], "]"}], "]"}], "=", "\"\<year\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"loutraw", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", 
      RowBox[{"2", ";;"}]}], "]"}], "]"}], "=", 
   RowBox[{"outraw", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", 
      RowBox[{"2", ";;"}]}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"loutraw", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "1"}], "]"}], "]"}], "=", 
   RowBox[{"outraw", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "1"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"noutraw", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"\"\<\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "181"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"noutraw", "[", 
      RowBox[{"[", "i", "]"}], "]"}], "=", 
     RowBox[{
      RowBox[{
       RowBox[{"Position", "[", 
        RowBox[{
         RowBox[{"outraw", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;"}], ",", "i"}], "]"}], "]"}], ",", 
         RowBox[{"_", "?", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"#", "\[NotEqual]", "\"\<\>\""}], "&"}], ")"}]}], ",", 
         "1", ",", "1"}], "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "1"}], "]"}], "]"}], "+", "1"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "2", ",", "181"}], "}"}]}], "]"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"noutraw", "[", 
      RowBox[{"[", "141", "]"}], "]"}], "=", "52"}], ";"}], " ", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      RowBox[{
      "for", " ", "Russia", " ", "we", " ", "use", " ", "the", " ", "period", 
       " ", "from", " ", "2000", " ", "onwards", " ", "to", " ", "fit", " ", 
       "the", " ", "data"}], ")"}], ";"}], "*)"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rout", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "181"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "3"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"loutraw", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{
        RowBox[{"noutraw", "[", 
         RowBox[{"[", "i", "]"}], "]"}], ";;"}], ",", "i"}], "]"}], "]"}], 
    "=", 
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{"outraw", "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{
          RowBox[{"noutraw", "[", 
           RowBox[{"[", "i", "]"}], "]"}], ";;"}], ",", "i"}], "]"}], "]"}], 
      "]"}], "//", "N"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "181"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"rout", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "2"}], "]"}], "]"}], "=", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"loutraw", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{
           RowBox[{"noutraw", "[", 
            RowBox[{"[", "i", "]"}], "]"}], "+", "15"}], ",", "i"}], "]"}], 
        "]"}], "-", 
       RowBox[{"loutraw", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"noutraw", "[", 
           RowBox[{"[", "i", "]"}], "]"}], ",", "i"}], "]"}], "]"}]}], ")"}], 
     "/", "15"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "181"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"rout", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "3"}], "]"}], "]"}], "=", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"loutraw", "[", 
        RowBox[{"[", 
         RowBox[{"71", ",", "i"}], "]"}], "]"}], "-", 
       RowBox[{"loutraw", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"noutraw", "[", 
           RowBox[{"[", "i", "]"}], "]"}], ",", "i"}], "]"}], "]"}]}], ")"}], 
     "/", 
     RowBox[{"(", 
      RowBox[{"71", "-", 
       RowBox[{"noutraw", "[", 
        RowBox[{"[", "i", "]"}], "]"}]}], ")"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "181"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"rout", "[", 
    RowBox[{"[", 
     RowBox[{"170", ",", "2"}], "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"loutraw", "[", 
       RowBox[{"[", 
        RowBox[{"65", ",", "170"}], "]"}], "]"}], "-", 
      RowBox[{"loutraw", "[", 
       RowBox[{"[", 
        RowBox[{"50", ",", "170"}], "]"}], "]"}]}], ")"}], "/", "2"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"rout", "[", 
    RowBox[{"[", 
     RowBox[{"170", ",", "3"}], "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"loutraw", "[", 
       RowBox[{"[", 
        RowBox[{"71", ",", "170"}], "]"}], "]"}], "-", 
      RowBox[{"loutraw", "[", 
       RowBox[{"[", 
        RowBox[{"50", ",", "170"}], "]"}], "]"}]}], ")"}], "/", "2"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"rout", "[", 
    RowBox[{"[", 
     RowBox[{"141", ",", "2"}], "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"loutraw", "[", 
       RowBox[{"[", 
        RowBox[{"71", ",", "141"}], "]"}], "]"}], "-", 
      RowBox[{"loutraw", "[", 
       RowBox[{"[", 
        RowBox[{"57", ",", "141"}], "]"}], "]"}]}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{"71", "-", "57"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"rout", "[", 
    RowBox[{"[", 
     RowBox[{"141", ",", "3"}], "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"loutraw", "[", 
       RowBox[{"[", 
        RowBox[{"71", ",", "141"}], "]"}], "]"}], "-", 
      RowBox[{"loutraw", "[", 
       RowBox[{"[", 
        RowBox[{"57", ",", "141"}], "]"}], "]"}]}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{"71", "-", "57"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"noutraw", "[", 
       RowBox[{"[", "i", "]"}], "]"}], ">", "2"}], ",", 
     RowBox[{"{", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"loutraw", "[", 
          RowBox[{"[", 
           RowBox[{"j", ",", "i"}], "]"}], "]"}], "=", 
         RowBox[{
          RowBox[{"loutraw", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"noutraw", "[", 
              RowBox[{"[", "i", "]"}], "]"}], ",", "i"}], "]"}], "]"}], "-", 
          RowBox[{
           RowBox[{"rout", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "3"}], "]"}], "]"}], "*", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"noutraw", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "-", "j"}], ")"}]}]}]}], ",", 
        RowBox[{"{", 
         RowBox[{"j", ",", "2", ",", 
          RowBox[{
           RowBox[{"noutraw", "[", 
            RowBox[{"[", "i", "]"}], "]"}], "-", "1"}]}], "}"}]}], "]"}], 
      "}"}], ",", "0"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "181"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.8377865358923397`*^9, 3.8377865413048134`*^9}, {
   3.8377865731830053`*^9, 3.8377866407921705`*^9}, {3.8377867860774937`*^9, 
   3.837786893508796*^9}, {3.837786957132304*^9, 3.8377870728695292`*^9}, {
   3.837787175653967*^9, 3.8377871852739315`*^9}, {3.837787389994054*^9, 
   3.8377873906527557`*^9}, {3.8377951511307583`*^9, 3.837795174982689*^9}, {
   3.8377954391211367`*^9, 3.837795442642807*^9}, {3.8377955250139475`*^9, 
   3.837795530462528*^9}, 3.837795610728823*^9},
 CellLabel->
  "In[259]:=",ExpressionUUID->"a88d68a9-3de2-4baa-85e5-28d1ae181487"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"outraw2", "=", "outraw"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"Do", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"outraw2", "[", 
       RowBox[{"[", 
        RowBox[{"i", ",", "j"}], "]"}], "]"}], "=", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"outraw", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "j"}], "]"}], "]"}], "\[Equal]", "\"\<\>\""}], 
        ",", "0", ",", 
        RowBox[{"outraw", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "j"}], "]"}], "]"}]}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"j", ",", "2", ",", "181"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.836602351965149*^9, 3.8366023706535263`*^9}},
 CellLabel->
  "In[274]:=",ExpressionUUID->"7df25b39-2f94-4444-b28c-d3d0db751a17"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"outfull", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "71"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "181"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"outfull", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "1"}], "]"}], "]"}], "=", "\"\<year\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"outfull", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", 
      RowBox[{"2", ";;"}]}], "]"}], "]"}], "=", 
   RowBox[{"outraw", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", 
      RowBox[{"2", ";;"}]}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"outfull", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "1"}], "]"}], "]"}], "=", 
   RowBox[{"outraw", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "1"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"outfull", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", 
      RowBox[{"2", ";;"}]}], "]"}], "]"}], "=", 
   RowBox[{"Exp", "[", 
    RowBox[{"loutraw", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", 
       RowBox[{"2", ";;"}]}], "]"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"outtotal", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "71"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "4"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"outtotal", "[", 
    RowBox[{"[", "1", "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
    "\"\<year\>\"", ",", "\"\<out\>\"", ",", "\"\<out/10^6\>\"", ",", 
     "\"\<lout\>\""}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"outtotal", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "1"}], "]"}], "]"}], "=", 
    RowBox[{"1948", "+", "i"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"outtotal", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "2"}], "]"}], "]"}], "=", 
    RowBox[{"Total", "[", 
     RowBox[{"outfull", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", 
        RowBox[{"2", ";;"}]}], "]"}], "]"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"outtotal", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "3"}], "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"outtotal", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", "2"}], "]"}], "]"}], "/", 
    RowBox[{"10", "^", "6"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"outtotal", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "4"}], "]"}], "]"}], "=", 
   RowBox[{"Log", "[", 
    RowBox[{"outtotal", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", "2"}], "]"}], "]"}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.847643652781067*^9, 3.847643690791991*^9}, {
  3.872508690676736*^9, 3.872508751934106*^9}},
 CellLabel->
  "In[276]:=",ExpressionUUID->"01740d0c-1a31-4e86-90b0-9199eb29c0f9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<rgdpna_calc_full.csv\>\"", ",", "outfull"}], "]"}]], "Input",
 CellLabel->"In[34]:=",ExpressionUUID->"2ecb525f-ec32-4c7e-8f60-21e256f6a0ae"],

Cell[BoxData["\<\"rgdpna_calc_full.csv\"\>"], "Output",
 CellChangeTimes->{3.8514180065444417`*^9, 3.8730108543274193`*^9},
 CellLabel->"Out[34]=",ExpressionUUID->"31b1df94-bf1f-4a10-83fa-b899aa31981a"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"noexout", "=", 
   RowBox[{"Position", "[", 
    RowBox[{"noutraw", ",", "2"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nexout", "=", 
   RowBox[{"Position", "[", 
    RowBox[{"noutraw", ",", 
     RowBox[{"n_", "/;", 
      RowBox[{"n", ">", "2"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"outnoextotal", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "71"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "4"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"outnoextotal", "[", 
    RowBox[{"[", "1", "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
    "\"\<year\>\"", ",", "\"\<cap\>\"", ",", "\"\<cap\>\"", ",", 
     "\"\<cap\>\""}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"outnoextotal", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "1"}], "]"}], "]"}], "=", 
    RowBox[{"1948", "+", "i"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"outnoextotal", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "2"}], "]"}], "]"}], "=", 
    RowBox[{
     RowBox[{"Total", "[", 
      RowBox[{"outfull", "[", 
       RowBox[{"[", 
        RowBox[{"i", ",", 
         RowBox[{"Flatten", "[", "noexout", "]"}]}], "]"}], "]"}], "]"}], "/", 
     RowBox[{"10", "^", "6"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"outnoextotal", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "3"}], "]"}], "]"}], "=", 
    RowBox[{
     RowBox[{"Total", "[", 
      RowBox[{"outfull", "[", 
       RowBox[{"[", 
        RowBox[{"i", ",", 
         RowBox[{"Flatten", "[", "nexout", "]"}]}], "]"}], "]"}], "]"}], "/", 
     RowBox[{"10", "^", "6"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"outnoextotal", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "4"}], "]"}], "]"}], "=", 
    RowBox[{
     RowBox[{"Total", "[", 
      RowBox[{"outraw2", "[", 
       RowBox[{"[", 
        RowBox[{"i", ",", 
         RowBox[{"Flatten", "[", "nexout", "]"}]}], "]"}], "]"}], "]"}], "/", 
     RowBox[{"10", "^", "6"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.8365439750544896`*^9, 3.836544018969983*^9}, {
  3.836602190664647*^9, 3.8366023038589687`*^9}, {3.8725087834049473`*^9, 
  3.872508840791393*^9}},
 CellLabel->
  "In[287]:=",ExpressionUUID->"aca4d7c7-abe0-404e-b569-f3842a4c73e9"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"fig1out", "=", 
    RowBox[{"ListLinePlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Legended", "[", 
         RowBox[{
          RowBox[{"outtotal", "[", 
           RowBox[{"[", 
            RowBox[{"2", ";;"}], "]"}], "]"}], ",", 
          RowBox[{"Placed", "[", 
           RowBox[{"\"\<all countries\>\"", ",", "Below"}], "]"}]}], "]"}], 
        ",", 
        RowBox[{"Legended", "[", 
         RowBox[{
          RowBox[{"outnoextotal", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"2", ";;"}], ",", 
             RowBox[{"{", 
              RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}], ",", 
          RowBox[{"Placed", "[", 
           RowBox[{"\"\<wo extrapolated countries\>\"", ",", "Below"}], 
           "]"}]}], "]"}]}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Blue", ",", "Black"}], "}"}]}], ",", 
      RowBox[{"PlotLabel", "\[Rule]", "\"\<Output MER\>\""}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}]}], ";", 
   "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{"\"\<fig3_out.pdf\>\"", ",", "fig1out"}], "]"}]}], 
  "*)"}]], "Input",
 CellChangeTimes->{{3.8365440494763436`*^9, 3.8365440751337667`*^9}, 
   3.836601941919462*^9, {3.8366023948680353`*^9, 3.836602398250554*^9}, {
   3.8434602090075865`*^9, 3.8434602163076086`*^9}},
 CellLabel->"In[97]:=",ExpressionUUID->"a88ebc3b-18f0-483a-a7a5-90a84c7e70e8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"figrgpna", "=", 
  RowBox[{"ListLinePlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Legended", "[", 
       RowBox[{
        RowBox[{"outtotal", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "3"}], "}"}]}], "]"}], "]"}], ",", 
        RowBox[{"Placed", "[", 
         RowBox[{
         "\"\<all countries (including extrapolated data)\>\"", ",", 
          "Below"}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Legended", "[", 
       RowBox[{
        RowBox[{"outnoextotal", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}], ",", 
        RowBox[{"Placed", "[", 
         RowBox[{
         "\"\<only countries with complete data, 1950-2019\>\"", ",", 
          "Below"}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Legended", "[", 
       RowBox[{
        RowBox[{"outnoextotal", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "3"}], "}"}]}], "]"}], "]"}], ",", 
        RowBox[{"Placed", "[", 
         RowBox[{
         "\"\<extrapolated for countries missing data\>\"", ",", "Below"}], 
         "]"}]}], "]"}], ",", 
      RowBox[{"Legended", "[", 
       RowBox[{
        RowBox[{"outnoextotal", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "4"}], "}"}]}], "]"}], "]"}], ",", 
        RowBox[{"Placed", "[", 
         RowBox[{
         "\"\<not extrapolated for countries with missing data\>\"", ",", 
          "Below"}], "]"}]}], "]"}]}], "}"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Black", ",", "Red", ",", 
       RowBox[{"{", 
        RowBox[{"Blue", ",", "Dashed"}], "}"}], ",", "Blue"}], "}"}]}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<year\>\"", ",", "\"\<tril. $\>\""}], "}"}]}], ",", 
    RowBox[{
    "PlotLabel", "\[Rule]", 
     "\"\<rgdpna: Real GDP at constant 2017 national prices\>\""}], ",", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{
       RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
       RowBox[{"FontSize", "\[Rule]", "14"}], ",", "Black"}], "]"}]}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.836600880730194*^9, 3.836600932254799*^9}, {
  3.8366015380523195`*^9, 3.836601538421136*^9}, {3.8366016948824472`*^9, 
  3.836601716244355*^9}, {3.8366017468674383`*^9, 3.836601747231467*^9}, {
  3.8366018223387165`*^9, 3.836601846712026*^9}, {3.8366024546510468`*^9, 
  3.836602491436014*^9}, {3.8434602445694246`*^9, 3.843460391805679*^9}, {
  3.84825057448604*^9, 3.8482505751490316`*^9}, {3.8482506231130676`*^9, 
  3.8482506265991507`*^9}, {3.852983011946371*^9, 3.8529830252489195`*^9}, {
  3.852983057597453*^9, 3.852983153365591*^9}, {3.852983186763053*^9, 
  3.852983191733876*^9}, {3.852983537802271*^9, 3.8529835543253756`*^9}, {
  3.8725088468968983`*^9, 3.8725088475250797`*^9}, {3.8725089215705547`*^9, 
  3.8725089430521493`*^9}},
 CellLabel->
  "In[295]:=",ExpressionUUID->"dc491e42-5118-4fb8-a0ec-ff6d1dd69c86"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{}, {{{}, {}, 
       TagBox[{
         Hue[0.67, 0.6, 0.6], 
         Directive[
          PointSize[
           NCache[
            Rational[1, 90], 0.011111111111111112`]], 
          AbsoluteThickness[1.6], 
          GrayLevel[0]], 
         LineBox[CompressedData["
1:eJwt0A9MzQsUB/C7Rxvp5W5Z772EmNYfedI/IvVVSeWm0Ktc/bsp6+3WxPxp
UytbCOGWXq8rzsmG9OZf90m9+fv2Sm7dtWxJbyMhhLthCNHmcn5nOzv77Gzf
7ZyZWRtX5/ygUqmibP1tfq9CgvXy1vrEj+747iLCePVPvtP9PcSlhB1j7o7O
Tp7iMkK1tlWTEeAlLidMNZqyI3oVVxAm7f4/+UbIHLGBYAz+ZdVYpI+4mnDO
k56VxMwV1xI6R6saOsf9Kj5KmNES3OAfO09cT7CkbNobm+UrPkHQx3f89WhY
8WnCO6cXw82m+eIzhMz3Jpd/DX7iCwT1CteqjAZ/8UXC28awh4ePBohbCbvy
1Cu9DIHiK4Q+w48vjicHiW8QtjcdHppbskDcRjhQ7VDgblkovkWo7Dlgf7I5
WGwh/F07fZbj4CJxD6Fp7US9V1iIuJfQocl3XfBpibifMOARvLeuLVR8j5C+
qP1qu0+YeJCQq3mZpkuFeIiwTnPHtcduqXiYwKE9vx+5pNhqu19ljhrLDxe/
JvjXkEHfr/gdofGasbk4MEL80ZZ/pv/mBq3iL4SRB8nh5x4rVjHOVy5+XmyO
FI9n/HnozpvOXcvEExhxo0tbS6KjxA4MY6N3vc5ruVjNyHKza8+cEy2ewkCc
/dOp42LEPzOcnYty/LoUuzKmFH45e3lSrNiN4ec02XwwX/FshrW2xpQ3qNiT
4fJcN9/72AqxD8PyqcVQUaoR+zIy0pNGdv4RJw5g1Bmfbv6veaV4IWPs/PWc
bG28OITRlauzvx+UIAajd/SQ4+YRxZGMR/Muae6nrxJHM56cmti5/6FijS1v
mkdgS/lqcQLDuwv7k4rXiBMZETEb+tozE8UpDI+3Qx0D+t/EqYzabsOtgm1J
4kzGvdBRq5MqWZzNUCfogtIGlX0uY0/KdrNWnSLOYwyYDBeLPiguYPSpYz87
VK8Vb2FU/WP/uVWvFRcyTiP81cs168RFjLaNB2tc3FLFpYwG84TbZVbFZYy7
loqm9b1p4nLbv/c5mOpq0sUVjPzZ3XHZ8Rn4CrZ6Wgw=
          "]]}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$133720, {1}}]& ], 
       TagBox[{
         Hue[0.9060679774997897, 0.6, 0.6], 
         Directive[
          PointSize[
           NCache[
            Rational[1, 90], 0.011111111111111112`]], 
          AbsoluteThickness[1.6], 
          RGBColor[1, 0, 0]], 
         LineBox[CompressedData["
1:eJwt0X1QDHgYB/Bl8jp7N3kbx4WyqxK2lWKJ+lZbyVurzJW4swg3cyVK6Y+M
olRkBxGT8zx3hxkqrM5giGlGepkxc5mRstMQejnc3WzDeLltGsvze2aeeeYz
z1/P8/XZlJGwZahGo4lx95f5tXIJrQbsbSzzwlfnEVx77hVV26aK8wkHkv1G
XmmfJi4k1FWsibHe8BaXEKa6/quPDPcRlxE+NT32Clk7XXyEoHcWxJtG6cTH
Cbvmtrka7iqfIhRv91w4wqAX/0qwfj8mzLhohvg3wtFC3+IpBb7ic4TqCp0V
B/3EFwhdhz2dz9r8xTWEbr/V7f9ODhDbCT+uypk4eH+W+BrBPPp66IiAOeKb
hEm6xLj+KoO4jnCR32bGOgLF9QSnfaBk43OjuMH9n7js9ELHXHEzYetK16vL
NUHiB4Qoas5dmzZP3OreH3V1OHcEix8R/sh66eq7ESLuIDS3F/ee0M8XdxIi
NgzL2Zek3EXYF+R4bMlYIO4mdKR8uBmXYhL/TVhfYVr+3rpQ/A+h7+S44bqE
RWInQZv6+nzwG+V37rzzjQ+SMkPFHwn/n6rTXyhSHiCURfPLENNisYbhiL7z
09PcJWIPxuiZNZr00jDxSEZGUNs3Zw6Ei7UMTVPajGc/QOzJKPhl+4vJ2gjx
eIah6lDO7Srl7xh7M4NtBwMixV6MPzV/GWqylL0Z91q8Jwz2KusZGxIq7VHh
UWJ/xgSz/UNln/JsBmnHcFi2WWxkDCn1eNjjGy0OZiQ9mZg6+5WyidHnE9M/
vTxGvJgxvLt7/8CyWDEY8WMbncfmLRWbGRHjXNfCy5WXMnbnNZYaB5VXMHa2
WB3J5+LEFkbX7w/PPj+7TLyGob10Nb3HtlyczFiXNhO1J1eI1zO+zXY1ddpW
iq2MM3cs+aVPlVMZuilvei2xyj8z6o8EVrZmrRKnMYpSyiPtkfHiHYzKztp3
m3uUdzHYx31BokWcy3jUaer3aFDOY3hvC0zaaV4tzmeE+g+Z01KtXMiovb/l
bUBogriEcWvYZltynXIZ43b/6fMDkxLxGdCVVvQ=
          "]]}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$133720, {2}}]& ], 
       TagBox[{
         Hue[0.1421359549995791, 0.6, 0.6], 
         Directive[
          PointSize[
           NCache[
            Rational[1, 90], 0.011111111111111112`]], 
          AbsoluteThickness[1.6], 
          RGBColor[0, 0, 1], 
          Dashing[{Small, Small}]], 
         LineBox[CompressedData["
1:eJwt0X1MFHQYB3Aw0FA4DziPlxDuBA3BUBQTFd2Xk/OOGxK+ZMbAF5Jm5jJf
ChyvnuehyEBP52Tq8ziUrQTTilAHmVMBbSpqpYxkmS8FzFlOq6vOF/T5Pdt3
333++26PMW/1vPxBXl5eswfyol9eISHAtXBTW4cGL11MCEv7qcl4dLi4nLC6
LkZXkqkVOwjHKjr8n/6rvIXwZHqFxTsuUFxFiCn2/VTfobyd0OdKeKWyIEi8
i7D+wY4bn4wIFu8hOEN9e5wNyvsIpVPmXhts0IkPEDTZhSF/OJUPEeZrr/f7
1Sh/RtAmVZwNiRohbiSc2Dy2NTZALz5GqKhxhNkDQ8RNBOx0BaRGhopPEH75
cG/9mX7lVoKfz1tn3J+HiU8TogflfJRYEC4+R7DE5Q51tL8mPk9o8LfZu6Ij
xBcJx/veqb92eaT4CiHROMV6OzlK/CMh/avgVLIbxF2E+AN55mEwim8SpjaX
1TgPK98i0EX3hTuuUeK7hJai972P5EWLewntlzq1JaEx4vuEL696NEeDR4v/
JDRvr/87bZvyY8Izt+9My0NlN+GLsr6rtsVjxB5C62ODaU7k62IvhqZl3e/T
kmLFPgzz/Sdtc33Gil9lvO3IbTunixP7M96r/KffzxYv1jLKfsiuDCkZJ9Yx
sqr++3bjsjfEoYyc6shctieIIxilPd94ZixVNjBaRp/sNIUrxzCmhz8ccsih
HMvQ72r/LeW68jhGdvecO3v1E8QTGKcOH7Ql9ygnMSrL949MqE0UJzPiIh71
2quVUxiRP7cYi8wTxWA0tX+9qG7tJHEaw6f29vm/FiSJrYyGulrd5a2TxRmM
oHvdUfHdb4qzGL29S+7tPpIsXsD4//vJpRn508SLGP2PwPryFHEOw5qV4fJr
nSleygg7ffBdMkK8nOGx39j8wQblFYxMw3fuu42p4lWMqcOqx6Q3msQfM4LN
v3o3m2aJ1w/sGb+zs2h8mriQ0dgR5LkUZRYXM9IDT5XOO65czugyDbcWbJwt
djBsmsziNRMt4i2MUUPnW5xNylUD/89fntW50ornS25F+g==
          "]]}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$133720, {3}}]& ], 
       TagBox[{
         Hue[0.37820393249936934`, 0.6, 0.6], 
         Directive[
          PointSize[
           NCache[
            Rational[1, 90], 0.011111111111111112`]], 
          AbsoluteThickness[1.6], 
          RGBColor[0, 0, 1]], 
         LineBox[CompressedData["
1:eJxN0n1M02cQB/CKops6QWVYsRVqplTZKGI1qKhfC1RwdSGCTpfhdIPowOG7
YkoAEQ2iEl+IQjrvpihhpkMNDlRwMmKqYyrO9zDqC0Ot+AIKRONoss77/eEl
Ty6f3JPL3ZNH9+2KuSleKpXK7Dn/53eRQVC9H5mEbfsbHnifqZ7xzjmEpvTZ
d163tIrzCFXZdx+Xl7rE+QTji3Hme+WPxTsIhhtT023qdvEuQqYjJMzd1iEu
Ily3p9Wv7XopLiacXVJqd197Jf6RsP/6ys9uZnWJfyIcuGfc3bjpX/FhgqUs
L3hs6ltxOWHJPNS7CpS6nfDHRqTbn7vFxwl9h+mWOxNVsudJwnecdSr7dC/x
KYJzXTtPLvYS1xJsibbcivm9xXWE7XU+zvCQPuLzhCgk6Y+4vcUXCWu8TnQH
/uAjvkSgzzOiCzSDxVcJX6oN+oQZQ8Q3CEdi0zVtvw8V3/HU05rrozr8xM2e
edZXHq1Y97H4PqGjomjEmk5/cStBq40PGR+pFrsIT6sc2bssw8XPCFPcjmvF
LQHiDsKfNQFJG9JGiLsIAzOaDcYGxW8879Nf33YiVCPuIdTO674y36BV/gUj
WH/+o75XR4r7MLo3P7l9+Vag+APGiku7g/PLgsQDGd47G2xuq07sy9h8MMGc
ahol9mOU/RWXbK1WrGYsKhyZxLmhYg3D6vy1Z9pixUGMmtGnG00Bij9hTA54
2e9wnmI9w7/I8SjyluJPGV81zfnH5h8mDmOcO1o6O8Kp2MgoyDmgDS0ZL45g
jNV0unILFUcytH/X6Kwx4WIwKh2VCw6tniCOZvQuabnYnWgUxzJ+PlTid2Xb
RLGF4fuwKTCkaZI4nvHE9c3Dfb9EiBMZPQ0TsywpU8QLGO2dYP+cSPHXjDnx
lj0f1k4XL2ao60oXkg7iZIY79/aW7zcqXua5H3TuTat9png5Y+qAwjFxdpN4
JWNozINeVaYo8VrGI8PeRqshWpzBOHZhSM/lwBhxpqff4N+y5lYrzmE4TT6x
GzaZxXkM86AvMleFzxLnM8b0T5i19aTiHYylKcnxjamx+A8hdVnv
          "]]}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$133720, {4}}]& ]}, {
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$133720, {1}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$133720, {2}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$133720, {3}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$133720, {4}}]& ]}, {
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$133720, {1}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$133720, {2}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$133720, {3}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$133720, {
          4}}]& ], {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, {
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$133720, {1}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$133720, {2}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$133720, {3}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$133720, {
          4}}]& ], {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}}, {{}, \
{}}}, {DisplayFunction -> Identity, DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {
       FormBox["\"year\"", TraditionalForm], 
       FormBox["\"tril. $\"", TraditionalForm]}, AxesOrigin -> {1948.5625, 0},
      DisplayFunction :> Identity, Frame -> {{False, False}, {False, False}}, 
     FrameLabel -> {{None, None}, {None, None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> 600, LabelStyle -> 
     Directive[FontFamily -> "Helvetica", FontSize -> 14, 
       GrayLevel[0]], 
     Method -> {
      "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
       "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& )}}, PlotLabel -> 
     FormBox["\"rgdpna: Real GDP at constant 2017 national prices\"", 
       TraditionalForm], 
     PlotRange -> {{1948.5625, 2019.}, {0, 125.24049706584056`}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.05]}}, Ticks -> {Automatic, Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{
      "\"all countries (including extrapolated data)\"", 
       "\"only countries with complete data, 1950-2019\"", 
       "\"extrapolated for countries missing data\"", 
       "\"not extrapolated for countries with missing data\""}, "LineLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.8, 0.5}}}], "Grid"]}, {
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.8, 0.5}}}], "Grid"]}, {
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1], 
                    Dashing[{Small, Small}]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1], 
                    Dashing[{Small, Small}]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.8, 0.5}}}], "Grid"]}, {
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #4}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.8, 0.5}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxDividers -> {"Columns" -> {{None}}, "Rows" -> {{None}}}, 
             GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
             GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{1}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
          Directive[FontFamily -> "Helvetica", FontSize -> 14, 
           GrayLevel[0]], FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0, 0], Editable -> False, Selectable -> 
                    False]}], "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 0, 1], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"Small", ",", "Small"}], "}"}], "]"}]}], "]"}], 
                   ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 0, 1], Editable -> False, Selectable -> 
                    False]}], "]"}]}], "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0, 0], Editable -> False, Selectable -> 
                    False]}], "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 0, 1], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"Small", ",", "Small"}], "}"}], "]"}]}], "]"}], 
                   ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 0, 1], Editable -> False, Selectable -> 
                    False]}], "]"}]}], "}"}]}], "}"}], ",", 
           RowBox[{"{", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{#, ",", #2, ",", #3, ",", #4}], "}"}], ",", 
               RowBox[{"{", "}"}]}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"None", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"None", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"None", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"None", ",", "Automatic"}], "}"}]}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], 
               "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"True", ",", "True", ",", "True", ",", "True"}], 
                   "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"True", ",", "True", ",", "True", ",", "True"}], 
                   "}"}]}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
               RowBox[{
                 RowBox[{"FontFamily", "\[Rule]", "\"Helvetica\""}], ",", 
                 RowBox[{"FontSize", "\[Rule]", "14"}], ",", 
                 InterpretationBox[
                  ButtonBox[
                   TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                   BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                   ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                   Automatic, Method -> "Preemptive"], 
                  GrayLevel[0], Editable -> False, Selectable -> False]}], 
               "]"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Row\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "Below"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.8366024927173214`*^9, 3.837787138269371*^9, 3.8377872112686462`*^9, 
   3.8377874299766645`*^9, 3.8377952224016237`*^9, 3.837795567947322*^9, 
   3.8383964985883837`*^9, 3.8434603588333693`*^9, 3.8434603926077547`*^9, 
   3.8472041729419985`*^9, 3.84742048655009*^9, 3.8481281749794507`*^9, 
   3.8482505815695395`*^9, 3.8482506274933558`*^9, 3.8495150091340904`*^9, 
   3.8514180578122506`*^9, 3.8529825574652367`*^9, 3.8529831930186644`*^9, 
   3.852983555907784*^9, 3.8725084922224846`*^9, 3.872508847965551*^9, {
   3.8725089365788536`*^9, 3.8725089442920313`*^9}, 3.8725626052705555`*^9, 
   3.873010859270958*^9, 3.8744804390838737`*^9},
 CellLabel->
  "Out[295]=",ExpressionUUID->"59aef25c-5d9c-489a-9ae9-c21992857e9f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<figrgpna.eps\>\"", ",", "figrgpna"}], "]"}]], "Input",
 CellChangeTimes->{{3.852983589651716*^9, 3.852983626742639*^9}},
 CellLabel->
  "In[1708]:=",ExpressionUUID->"bc22d246-31d9-44d4-8743-58b651439433"],

Cell[BoxData["\<\"figrgpna.eps\"\>"], "Output",
 CellChangeTimes->{3.8529836287163515`*^9, 3.872509007871452*^9, 
  3.8725117146842833`*^9},
 CellLabel->
  "Out[1708]=",ExpressionUUID->"a474c71d-9318-42ff-a9d5-d68e3ec6d39b"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"outrate", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "71"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "181"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"outrate", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "1"}], "]"}], "]"}], "=", "\"\<year\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"outrate", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", 
      RowBox[{"2", ";;"}]}], "]"}], "]"}], "=", 
   RowBox[{"outfull", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", 
      RowBox[{"2", ";;"}]}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"outrate", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "1"}], "]"}], "]"}], "=", 
   RowBox[{"outfull", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "1"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"outrate", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", 
       RowBox[{"2", ";;"}]}], "]"}], "]"}], "=", 
    RowBox[{
     RowBox[{"outfull", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", 
        RowBox[{"2", ";;"}]}], "]"}], "]"}], "/", 
     RowBox[{"outfull", "[", 
      RowBox[{"[", 
       RowBox[{"71", ",", 
        RowBox[{"2", ";;"}]}], "]"}], "]"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.8365430376849103`*^9, 3.8365431309944043`*^9}, {
  3.836543239023137*^9, 3.8365432426271424`*^9}, {3.8504129694923587`*^9, 
  3.8504129697575197`*^9}},
 CellLabel->
  "In[296]:=",ExpressionUUID->"dd3c6d6a-e718-45e4-9860-b489f7935b2a"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
For comparison: Output Data at Chained Prices(rgdpo: Output-side real GDP at \
chained PPPs (in mil. 2017US$) for comparison)\
\>", "Section",
 CellChangeTimes->{{3.836542594258254*^9, 3.8365426333406935`*^9}, {
  3.8514179079447613`*^9, 3.8514179341607065`*^9}, {3.8529940324088564`*^9, 
  3.8529940647820544`*^9}, {3.872562615826354*^9, 3.8725626183855295`*^9}, {
  3.8728243512655573`*^9, 
  3.8728243553491898`*^9}},ExpressionUUID->"f9088f16-3a96-4b86-a60b-\
22d11848bfb4"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"rgdpodat", "=", 
   RowBox[{"Import", "[", "\"\<rgdpo_Transposed.csv\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Dimensions", "[", "rgdpodat", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rgdporaw", "=", 
   RowBox[{"rgdpodat", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", ";;"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Dimensions", "[", "rgdporaw", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rgdporaw2", "=", 
   RowBox[{"rgdporaw", "[", 
    RowBox[{"[", 
     RowBox[{";;", ",", 
      RowBox[{";;", "181"}]}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Dimensions", "[", "rgdporaw2", "]"}]}], "Input",
 CellChangeTimes->{{3.8514335133969865`*^9, 3.851433596111031*^9}, {
  3.8514342451299753`*^9, 3.8514342571681004`*^9}},
 CellLabel->
  "In[301]:=",ExpressionUUID->"ed9d8459-fd80-46c8-806e-86abaf394fde"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"72", ",", "184"}], "}"}]], "Output",
 CellChangeTimes->{3.851433604198637*^9, 3.8514342580917573`*^9, 
  3.8529940727956886`*^9, 3.8725120340151277`*^9, 3.872562621757759*^9, 
  3.873010864176813*^9, 3.8744804481593904`*^9},
 CellLabel->
  "Out[302]=",ExpressionUUID->"992e21da-cefa-4688-8392-9a4a62b25583"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"71", ",", "184"}], "}"}]], "Output",
 CellChangeTimes->{3.851433604198637*^9, 3.8514342580917573`*^9, 
  3.8529940727956886`*^9, 3.8725120340151277`*^9, 3.872562621757759*^9, 
  3.873010864176813*^9, 3.8744804481623816`*^9},
 CellLabel->
  "Out[304]=",ExpressionUUID->"132e5238-684c-4267-8eed-2c70a8ffd0b2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"71", ",", "181"}], "}"}]], "Output",
 CellChangeTimes->{3.851433604198637*^9, 3.8514342580917573`*^9, 
  3.8529940727956886`*^9, 3.8725120340151277`*^9, 3.872562621757759*^9, 
  3.873010864176813*^9, 3.874480448165374*^9},
 CellLabel->
  "Out[306]=",ExpressionUUID->"f50dee86-c4b6-446a-8013-169c3b16a3ff"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"Do", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"rgdporaw2", "[", 
       RowBox[{"[", 
        RowBox[{"i", ",", "j"}], "]"}], "]"}], "=", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"rgdporaw", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "j"}], "]"}], "]"}], "\[Equal]", "\"\<\>\""}], 
        ",", "0", ",", 
        RowBox[{"rgdporaw2", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "j"}], "]"}], "]"}]}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"j", ",", "2", ",", "181"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lrgdporaw", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "71"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "181"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"lrgdporaw", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "1"}], "]"}], "]"}], "=", "\"\<year\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"lrgdporaw", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", 
      RowBox[{"2", ";;"}]}], "]"}], "]"}], "=", 
   RowBox[{"rgdporaw2", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", 
      RowBox[{"2", ";;"}]}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"lrgdporaw", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "1"}], "]"}], "]"}], "=", 
   RowBox[{"rgdporaw2", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "1"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nrgdpo", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"\"\<\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "181"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rrgdpo", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "181"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "3"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"nrgdpo", "[", 
      RowBox[{"[", "i", "]"}], "]"}], "=", 
     RowBox[{
      RowBox[{
       RowBox[{"Position", "[", 
        RowBox[{
         RowBox[{"rgdporaw", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;"}], ",", "i"}], "]"}], "]"}], ",", 
         RowBox[{"_", "?", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"#", "\[NotEqual]", "\"\<\>\""}], "&"}], ")"}]}], ",", 
         "1", ",", "1"}], "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "1"}], "]"}], "]"}], "+", "1"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "2", ",", "181"}], "}"}]}], "]"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"ncapraw", "[", 
      RowBox[{"[", "141", "]"}], "]"}], "=", "52"}], ";"}], " ", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      RowBox[{
      "for", " ", "Russia", " ", "we", " ", "use", " ", "the", " ", "period", 
       " ", "from", " ", "2000", " ", "onwards", " ", "to", " ", "fit", " ", 
       "the", " ", "data"}], ")"}], ";"}], "*)"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"lrgdporaw", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{
        RowBox[{"nrgdpo", "[", 
         RowBox[{"[", "i", "]"}], "]"}], ";;"}], ",", "i"}], "]"}], "]"}], 
    "=", 
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{"rgdporaw", "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{
          RowBox[{"nrgdpo", "[", 
           RowBox[{"[", "i", "]"}], "]"}], ";;"}], ",", "i"}], "]"}], "]"}], 
      "]"}], "//", "N"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "181"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"rrgdpo", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "2"}], "]"}], "]"}], "=", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"lrgdporaw", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{
           RowBox[{"nrgdpo", "[", 
            RowBox[{"[", "i", "]"}], "]"}], "+", "15"}], ",", "i"}], "]"}], 
        "]"}], "-", 
       RowBox[{"lrgdporaw", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"nrgdpo", "[", 
           RowBox[{"[", "i", "]"}], "]"}], ",", "i"}], "]"}], "]"}]}], ")"}], 
     "/", "15"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "181"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"rrgdpo", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "3"}], "]"}], "]"}], "=", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"lrgdporaw", "[", 
        RowBox[{"[", 
         RowBox[{"71", ",", "i"}], "]"}], "]"}], "-", 
       RowBox[{"lrgdporaw", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"nrgdpo", "[", 
           RowBox[{"[", "i", "]"}], "]"}], ",", "i"}], "]"}], "]"}]}], ")"}], 
     "/", 
     RowBox[{"(", 
      RowBox[{"71", "-", 
       RowBox[{"nrgdpo", "[", 
        RowBox[{"[", "i", "]"}], "]"}]}], ")"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "181"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"rrgdpo", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "2"}], "]"}], "]"}], "<", "0"}], ",", 
      RowBox[{
       RowBox[{"rrgdpo", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "2"}], "]"}], "]"}], "=", 
       RowBox[{"rrgdpo", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "3"}], "]"}], "]"}]}], ",", "0"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "2", ",", "181"}], "}"}]}], "]"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"rcap", "[", 
      RowBox[{"[", 
       RowBox[{"170", ",", "2"}], "]"}], "]"}], "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"lcapraw", "[", 
         RowBox[{"[", 
          RowBox[{"44", ",", "170"}], "]"}], "]"}], "-", 
        RowBox[{"lcapraw", "[", 
         RowBox[{"[", 
          RowBox[{"42", ",", "170"}], "]"}], "]"}]}], ")"}], "/", "2"}]}], 
    ";", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"rcap", "[", 
      RowBox[{"[", 
       RowBox[{"170", ",", "3"}], "]"}], "]"}], "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"lcapraw", "[", 
         RowBox[{"[", 
          RowBox[{"44", ",", "170"}], "]"}], "]"}], "-", 
        RowBox[{"lcapraw", "[", 
         RowBox[{"[", 
          RowBox[{"42", ",", "170"}], "]"}], "]"}]}], ")"}], "/", "2"}]}], 
    ";", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"rcap", "[", 
      RowBox[{"[", 
       RowBox[{"141", ",", "2"}], "]"}], "]"}], "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"lcapraw", "[", 
         RowBox[{"[", 
          RowBox[{"71", ",", "141"}], "]"}], "]"}], "-", 
        RowBox[{"lcapraw", "[", 
         RowBox[{"[", 
          RowBox[{"57", ",", "141"}], "]"}], "]"}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"71", "-", "57"}], ")"}]}]}], ";", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"rcap", "[", 
      RowBox[{"[", 
       RowBox[{"141", ",", "3"}], "]"}], "]"}], "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"lcapraw", "[", 
         RowBox[{"[", 
          RowBox[{"71", ",", "141"}], "]"}], "]"}], "-", 
        RowBox[{"lcapraw", "[", 
         RowBox[{"[", 
          RowBox[{"57", ",", "141"}], "]"}], "]"}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"71", "-", "57"}], ")"}]}]}], ";"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"nrgdpo", "[", 
       RowBox[{"[", "i", "]"}], "]"}], ">", "2"}], ",", 
     RowBox[{"{", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"lrgdporaw", "[", 
          RowBox[{"[", 
           RowBox[{"j", ",", "i"}], "]"}], "]"}], "=", 
         RowBox[{
          RowBox[{"lrgdporaw", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"nrgdpo", "[", 
              RowBox[{"[", "i", "]"}], "]"}], ",", "i"}], "]"}], "]"}], "-", 
          RowBox[{
           RowBox[{"rrgdpo", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "2"}], "]"}], "]"}], "*", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"nrgdpo", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "-", "j"}], ")"}]}]}]}], ",", 
        RowBox[{"{", 
         RowBox[{"j", ",", "2", ",", 
          RowBox[{
           RowBox[{"nrgdpo", "[", 
            RowBox[{"[", "i", "]"}], "]"}], "-", "1"}]}], "}"}]}], "]"}], 
      "}"}], ",", "0"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "181"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.851434212864863*^9, 3.8514343206021767`*^9}, {
  3.851434625909913*^9, 3.851434769677987*^9}, {3.8514374973346324`*^9, 
  3.85143755535594*^9}, {3.851437587361165*^9, 3.851437853417103*^9}},
 CellLabel->
  "In[307]:=",ExpressionUUID->"305eca97-6c33-4d5e-a668-6ac4c33142fd"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"rgdpofull", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "71"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "181"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"rgdpofull", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "1"}], "]"}], "]"}], "=", "\"\<year\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"rgdpofull", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", 
      RowBox[{"2", ";;"}]}], "]"}], "]"}], "=", 
   RowBox[{"rgdporaw", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", 
      RowBox[{"2", ";;", "181"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"rgdpofull", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "1"}], "]"}], "]"}], "=", 
   RowBox[{"rgdporaw", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "1"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"rgdpofull", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", 
      RowBox[{"2", ";;"}]}], "]"}], "]"}], "=", 
   RowBox[{"Exp", "[", 
    RowBox[{"lrgdporaw", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", 
       RowBox[{"2", ";;"}]}], "]"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rgdpototal", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "71"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "3"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"rgdpototal", "[", 
    RowBox[{"[", "1", "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"\"\<year\>\"", ",", "\"\<cap\>\"", ",", "\"\<lcap\>\""}], 
    "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"rgdpototal", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "1"}], "]"}], "]"}], "=", 
    RowBox[{"1948", "+", "i"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"rgdpototal", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "2"}], "]"}], "]"}], "=", 
    RowBox[{"Total", "[", 
     RowBox[{"rgdpofull", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", 
        RowBox[{"2", ";;"}]}], "]"}], "]"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"rgdpototal", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "3"}], "]"}], "]"}], "=", 
   RowBox[{"Log", "[", 
    RowBox[{"rgdpototal", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", "2"}], "]"}], "]"}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.8514588731396027`*^9, 3.851459034577615*^9}},
 CellLabel->
  "In[320]:=",ExpressionUUID->"3198e342-dfaf-468f-999f-dd31d44f23d2"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"noexrgdpo", "=", 
   RowBox[{"Position", "[", 
    RowBox[{"nrgdpo", ",", "2"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nexrgdpo", "=", 
   RowBox[{"Position", "[", 
    RowBox[{"nrgdpo", ",", 
     RowBox[{"n_", "/;", 
      RowBox[{"n", ">", "2"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rgdponoextotal", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "71"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "5"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"rgdponoextotal", "[", 
    RowBox[{"[", "1", "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
    "\"\<year\>\"", ",", "\"\<out-noex\>\"", ",", "\"\<out-ex\>\"", ",", 
     "\"\<out_woex\>\"", ",", "\"\<l_out_woex\>\""}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"rgdponoextotal", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "1"}], "]"}], "]"}], "=", 
    RowBox[{"1948", "+", "i"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"rgdponoextotal", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "2"}], "]"}], "]"}], "=", 
    RowBox[{"Total", "[", 
     RowBox[{"rgdpofull", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", 
        RowBox[{"Flatten", "[", "noexrgdpo", "]"}]}], "]"}], "]"}], "]"}]}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"rgdponoextotal", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "3"}], "]"}], "]"}], "=", 
    RowBox[{"Total", "[", 
     RowBox[{"rgdpofull", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", 
        RowBox[{"Flatten", "[", "nexrgdpo", "]"}]}], "]"}], "]"}], "]"}]}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"rgdponoextotal", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "4"}], "]"}], "]"}], "=", 
    RowBox[{"Total", "[", 
     RowBox[{"rgdporaw2", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", 
        RowBox[{"Flatten", "[", "nexrgdpo", "]"}]}], "]"}], "]"}], "]"}]}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"rgdponoextotal", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "5"}], "]"}], "]"}], "=", 
   RowBox[{"Log", "[", 
    RowBox[{"rgdponoextotal", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", "2"}], "]"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.851459180760378*^9, 3.8514595453796463`*^9}, {
  3.851459643733511*^9, 3.8514596448175097`*^9}},
 CellLabel->
  "In[330]:=",ExpressionUUID->"9aae84c0-d6ea-48c7-afa0-b43feadac856"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"figrgpo", "=", 
  RowBox[{"ListLinePlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Legended", "[", 
       RowBox[{
        RowBox[{"outtotal", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}], ",", 
        RowBox[{"Placed", "[", 
         RowBox[{
         "\"\<all countries (including extrapolated data)\>\"", ",", 
          "Below"}], "]"}]}], "]"}], ",", 
      RowBox[{"Legended", "[", 
       RowBox[{
        RowBox[{"rgdpototal", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}], ",", 
        RowBox[{"Placed", "[", 
         RowBox[{
         "\"\<all countries (including extrapolated data)\>\"", ",", 
          "Below"}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Legended", "[", 
       RowBox[{
        RowBox[{"rgdponoextotal", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}], ",", 
        RowBox[{"Placed", "[", 
         RowBox[{
         "\"\<only countries with complete data, 1950-2019\>\"", ",", 
          "Below"}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Legended", "[", 
       RowBox[{
        RowBox[{"rgdponoextotal", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "3"}], "}"}]}], "]"}], "]"}], ",", 
        RowBox[{"Placed", "[", 
         RowBox[{
         "\"\<extrapolated for countries missing data\>\"", ",", "Below"}], 
         "]"}]}], "]"}], ",", 
      RowBox[{"Legended", "[", 
       RowBox[{
        RowBox[{"rgdponoextotal", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "4"}], "}"}]}], "]"}], "]"}], ",", 
        RowBox[{"Placed", "[", 
         RowBox[{
         "\"\<not extrapolated for countries with missing data\>\"", ",", 
          "Below"}], "]"}]}], "]"}]}], "}"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Black", ",", 
       RowBox[{"{", 
        RowBox[{"Dashed", ",", "Black"}], "}"}], ",", "Red", ",", 
       RowBox[{"{", 
        RowBox[{"Blue", ",", "Dashed"}], "}"}], ",", "Blue"}], "}"}]}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<year\>\"", ",", "\"\<mio. USD\>\""}], "}"}]}], ",", 
    RowBox[{
    "PlotLabel", "\[Rule]", 
     "\"\<rgdpo: Output-side Real GDP at chainned prices\>\""}], ",", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{
       RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
       RowBox[{"FontSize", "\[Rule]", "14"}], ",", "Black"}], "]"}]}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8529941724804506`*^9, 3.85299429603329*^9}, {
  3.85299439052798*^9, 3.8529944182963643`*^9}, {3.852994459181543*^9, 
  3.8529944686309414`*^9}},
 CellLabel->
  "In[339]:=",ExpressionUUID->"e2dc2c95-127f-4d47-bbc0-2b53d0ce87f4"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{}, {{{}, {}, 
       TagBox[{
         Hue[0.67, 0.6, 0.6], 
         Directive[
          PointSize[
           NCache[
            Rational[1, 90], 0.011111111111111112`]], 
          AbsoluteThickness[1.6], 
          GrayLevel[0]], 
         LineBox[CompressedData["
1:eJwt03tME1YUBvDOmDkNKplgZJr4GIkaqlNCUCKRDyS+YlRUlCBbFikbg2oR
AVExFMFaHWi1paLgPSViRUE0gk9cmYaJolGHCC0SJQ4XCQoIpYAaWee5Nzm5
+SXnj3NO8k3folkXN0KhUCx11///l5cuUF7XZKrrU4V+cYbAPpuX6+PUX9ha
gff+5ipjv3SOQJhW5582Op6tF/CITfHuLZbOFYiuqHtRPfQb2yCQnNzpW92f
wDYJjIyoWazsSmQXCFSdXXDpGanZRQKlOuv5qc1b2RaBmTdcN4dCNOwSgRsf
z9RHTUtilwr0PDdmN7RJlwuMWX8y3lS1nX1JQJddaVlpS2ZXufujMwZmlO5g
XxewFQeWaAwp7FsC/c2OM+dXp7L/FOjsWGvZH5/GrhWIqRmv8rTuZN8TuGUN
d9hy0tkPBez9WR82FO9iPxF45GrerOzZzW4UyFPaj9XkZ7Dt7nnvnmu/tmkv
u1Xgp7KK2nHV0m0CjX0J5sqATHa7wN3oGmX3Ii37jcBQzNEWfbv0WwGL3vul
2pjF7hFI2zvgfDso7RSImlC78WLEPvagwMPdH8pepUh/Emjw/mPyowFpBSHY
+FXUYEM2eySh/fDokFxdDvsbguOB6d0i7Gd7EKw/xL64PFHH9iSYj6sibR4H
2F4EL7+5o/a0SE8iaA89KVx1Qs+eQnD6BOntTdLTCIklVzO/DzjI9iV0W7Wz
LxZLzyL0LlFEVEQeYisJrsrKsfq5v7PnESa5PF+XBuayAwhNvcP2Iyvy2AsJ
l0f4/Gr4VzqYMKvQed/33WE2COuWdf64bI6BHU4I0wSHtxqklxO2FQU5M8Ye
Za8iTLyjtneUS68l3N74ekqA+Rh7AyGwxE/5ncbIjnLvu74l6+lWEzuGsDTo
65ke6nz2z4TJzWWKNd3SKsJwXI/K82/peMJs7/rGwV4zW014tvr0ubjHx9lJ
hJ1dkfOvqArYKYQtuhWpsf4n2Onu+9UvvNA4/qTMP+FIV/DzvAZpLSHprw5H
Zn6hzD9hjF/IP5bkIpl/wrjPBUaH3ymZf8KVxCW137aeCv0PDdh8qw==
          "]]}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$135293, {1}}]& ], 
       TagBox[{
         Hue[0.9060679774997897, 0.6, 0.6], 
         Directive[
          PointSize[
           NCache[
            Rational[1, 90], 0.011111111111111112`]], 
          AbsoluteThickness[1.6], 
          Dashing[{Small, Small}], 
          GrayLevel[0]], 
         LineBox[CompressedData["
1:eJwt03tME3YQB/Bm4FC0ilEUHbqO+UBdnQNlzAd8mYQZQWIYA0MQCRYHgoBQ
CSogogMLSBqkoFDuUJG4zTA0aHwtGnyha8DXIokdmInxMZ2KrjhfW/V+l1wu
n//ucvl+kpQZlfyBRqMJc/a7+b7yCCU35g68DDOEvHc+AUvGV3NQsriIcPz8
iWVNvcpbCfYJC3/dbVsl3kbI2pcaaY/8XlxBsCz2vZxrShGbCfq40an+cani
asKWjrLybJ/V4p0E40bvH+c1KlsJ5w7ixfBf0sSNBPf28OWuHeniJkJL2mxb
Q+Ua8X6CJ/3zW+jvGeIDhLtefo9Oj8sStxJcHPHPNG+V2wjF446ND76wVnyU
8KdXb1duSbb4JCHea8WR7sk54tOEGN8Myz0Xo/gsIam1wmWOxzpxB2HWkGnW
sa65Yhuh65RbrbVf+TKhP2aRdpA2T3ydkJMQVzevfL24m9B35LBb/5cbxHZC
rcvEU7o65VuExzWehcY/Nor7nPs+/Tl86ogC8T1CZvmd1wnRheKHhOkfDUmK
Nm0SPyGEDk/OKJpUJH5OKCw+t2t1jPILwn6/dWNtwcqvCT3p7i16k7KG8eTi
q079zM1iV0ZF8F9XIkh5MOPznpqoRP9i8TCGKfO7Uo1D2YOxO26KQ2/bIh7N
iHn0pnFJ4VaxF2NlHx7qAn4QezMSn14KqqpU1jEiRk7frp1SIp7EMFRd+WbT
XmVfRtfFBQX1hlLxZ4y/tcFnblZvE89iPJ459MbAgEk8m7FHF/SAO8rEgYzm
zlKzz8Ry8XzGF4cm13zoWSEG47i5Jc2/bLs4lLEgXjsUukrxIoZjR7s2oFc5
grEwwPDGdZBZvJRxaVR9gfU/5WiGn+VTh09KlXgZ44BHd1RIyQ5xPGOEI9+t
p6tanMhYf980uLnTIjYwrmZGWoOKlVMYGywJXxlX1YrTGf3zT8TOeLVTnOW8
byChzGzfJTYywn66GRYbUSfOY0RijHdOu3K+c9/Aa20f31IuYrgfXdlW+229
yj8jI7zldmO2VeWf8fbf62tMXzeo/Dv/macPfGlvCPkf7sZgLg==
          "]]}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$135293, {2}}]& ], 
       TagBox[{
         Hue[0.1421359549995791, 0.6, 0.6], 
         Directive[
          PointSize[
           NCache[
            Rational[1, 90], 0.011111111111111112`]], 
          AbsoluteThickness[1.6], 
          RGBColor[1, 0, 0]], 
         LineBox[CompressedData["
1:eJwt0w9IFHYUB3DRSteudFghq5XmwZacLNYhp7T4eliuiGrDsC5zdalzt0y7
Lu9qtzzzXKanV5bLxL2nEvNyxtqfmllQk1oDx3TmORuWGjmiCRMq03SyW+/3
gx8/Pnzh8d6DX4w5/4Ps4KCgoHWB+//78jgIl5MSY3fcT09+aSehK6V/Ot25
XewixHiHTo1YTGI3YdGxVVffvrJDXEaYk46OkMYMsYfwoqR40Xh1pvgE4Qvb
6fzE9g/FpwmPbg/mDeftEtcSepJaojTtyvUEbWTBZt3Xu8UNhL7ed75dd94s
Pkd46E/cfd2+R+wjtHsHugyVWeJWgvvC9qydZ7LFFwmZd0v31wd/JP6BYBw/
fOmNuFxxW6C/30L/bXJ8LL5GeNDo0zzPsYhvEKJ09d/Ujn4ivkm4ZmhZO1OZ
J/6FcOG7hLnegX3iXwm5wbNDlocXiLsJNXHvlw88V+4ltB4ZjbassIr7Cf7z
VsOZYuWBwD7K822dbcpDhGnfHHtN+wHxQ0JYcuhMXZlN/Ijg6nNOLnEfFI8S
TGVVJdV7CsVjgXr3o9c7nig/DezXGOsivV08QWjoJfOtIZVPE157hc0ROpUH
MRq2dBlzppRnMZYdoIicUoc4jGEw+eONrkNiDWNb+ODjDjosjmDMryl6HDL8
qXgBIzqpM7v2qVMcxej56fulHfOOiJcwfrw8dknbpBzNMN9r0x5qKRJrGdaK
s192rHeJ32IwLV14fEpZx4jrSenU+YvFKxl9YZ/tm7x1VKwP5P9sWBZpLREb
GBNFmy76p5RXM/46+uJ3Y7NbDEZGT3+CtrJUnMLQHjTqR24ov8cwhSx+dcWk
8kbGUKNvONvzuXgLY2dV5kRa2TFxGuNcfPMab+Rx8TZGty1hwRp9uTiDURgx
pSm1VYh3MSzjrpFBeMRZjLq6d2+avCrPZZz9W+9wWyrFexm4m+YuvF0lLmDM
ujPWkN/kFdsC89jveByaE2IHI9X5Znx4qrKT8ZWH7TMVyi6GLyPmj73dym7G
n6nNxmfmk+r/M1o39oeeGlH2MF7f+rN168rq5P8ABGhm8Q==
          "]]}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$135293, {3}}]& ], 
       TagBox[{
         Hue[0.37820393249936934`, 0.6, 0.6], 
         Directive[
          PointSize[
           NCache[
            Rational[1, 90], 0.011111111111111112`]], 
          AbsoluteThickness[1.6], 
          RGBColor[0, 0, 1], 
          Dashing[{Small, Small}]], 
         LineBox[CompressedData["
1:eJwt031IFHYYB/DrxYpWdjJXYUpZ2aJbUSZmS/GrqXkVdJrenXar1Hxraq6O
TdeRV6mpGMnwllg8j4kDYW4aOF+amQsrq+uNGmv2JsyaXK7CsmVzOdfze+Dh
4cPz3/Pw9U3eE5s6UaPRRI33//N95RGM1uCr1Y2GsPe2ERrjLbo/NTFiO2Hr
u299UuKUCwm1zbHnPuxTLiH0vvymt3lUuZyw0uNG6d8FseIKQndoZfLyt8qV
hDUTjOsWZm4VVxEiDvYv2OFUPkkIDzkVc2FqnLiGkNm7yrw/RLmO4NAN/9qx
XLme0OLt/2ZOhXIDoXLaR4PRQfHiJkKMX4brypByM6E4/9lYV49R3EawXMyK
dCw1iTsIP/rouqyXlbsIi/T217mBZnE3wdPw8NBvixPEPYSMc4EWmBLFTgIP
Tze4jm4T3yTsPX3/g9o4i/gOwaug9XHkkc/EdwnrAmaEfP77dvF9wuw/2pfF
F+0Q9xGe3PNx74zcKe4nNCfpT8ydmSQeIDzKvDWlsEZ5cPw/fsMdhzcli18Q
svfHfuzxvfIrQkPRjbTsF8pvCNt9j1d9F5IiHiWYTj0dcjiVNYyCYkOL65dd
4smM53Nyl6TnpIqnMTZ3Nz0bdSrPYOTx8Q226jSxlrEb1ZOactLFngyvsKQ2
N22GeC7DNfPkvrEOZW+Gp3njsbFh5QWMrLLAp+vXZ4oXM3rm9dUPpSkvZZxv
sNXo65Q/Ycx6PvDo53e7xSsZSVVBtSOXssQBjP4LTt3qxGxxEOPMp4/tq0vV
Ppix4myDdlar2oPx5YjxdvCrPeIIRsB1xw8/deaKoxlrfbe4eTm/EG9mGByh
/tH/7BUbGDn+jW49f1nFcQz7SOi27PyvxGaGR8LLhaVN+WILY0vrv5NyjDbx
ToZ7u5/pbtsB8a7x+5R1DkS4lDMYltCStynJB8VZjLoaX13fisPiXIbe+9q+
07MLxVbGnVSt9WyBch5DW/LgwaXXyjZGlDn96/B6ZTuju6XwTPyUIpV/xrKp
7uGm+cUq/4zaxJGrg+3K5YyKqOtl+oQjYf8B5N5f2g==
          "]]}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$135293, {4}}]& ], 
       TagBox[{
         Hue[0.6142719099991583, 0.6, 0.6], 
         Directive[
          PointSize[
           NCache[
            Rational[1, 90], 0.011111111111111112`]], 
          AbsoluteThickness[1.6], 
          RGBColor[0, 0, 1]], 
         LineBox[CompressedData["
1:eJxN03tQzFEUB/CV5xiqIctgJBWGpm1EdlLtN5mtPKO0lZC8WURLIQpFW97j
UR737BBCXqNseTQZmZosU+Q1XonMSsajZWwoy/n94czcufO53/PPuTPHJX7F
tPl2MplMbTt/73+VLCD7v1IEltbYFRpym/k9TWDMTucWba5r4D+nC3RxGVih
MA1mZwpU/9Ctj/juzt4uoD3sH/T8/jD2boFOuoSY32c82Pts+Ry5fVofT3aO
QDvzu4w6uYJ9RKB+wOf25Q+92AYBHYxX8pxGs/MEvvhUWVWto9j5Al9rXVc7
NPiwCwT8Tw8JeHZIyb4oUOuvsbt/yJddaJvnZmuiyerHLhZwc0vqVZTsz74u
cFTplNTUHMAuE8gaeSAo7qCKXS5walTvXEu/QHalQCz9dAuOCmWbBN6oS19b
V05gVwtsNirVHmcmsmsFsqdV5e8pnsx+IlDR4rzDfXMY+7lAWf3h2Y2yqew6
AePLraldn0p+KxAQfdlQowxnm239wY9O31VEsJsELOHyjLaI6ezPtv/VL6kO
r5dsEah8ax2v9o1k/xAYrX2maTRI/iUw4/xxxRe9hi0jBFrySs4GRLM7EBIo
OzEnLobdhWAY2lext0FyN0LRJHmYV3As25GQo9/wuLVwJtuJ4GoWPRbfmsXu
Q3jf/Uhi2/VF7P6EnlHjd7V9kzyQoM3y+RAUtJjtRqjqV5f/dYHkoYTyghRD
aJ5kD0L3T+ZX11qXsL0I8TnKY9YKLXsk4fVt03DvmGVsJaHEtyHNWy/lfgTP
GwWODkYpB2GNNfKBn2UFexzB+97+c0WlCewQwhiXKR37mlayJxKm7FeNCPm5
ih1GWD7iQsfKjzp2BCHVqpqxbG0SO4pgH908SH9xLTuWMNX4u/3yyBR2HKFH
ibvmSfFG9jyCU1apeVyj5EWEWFVmy9z4TWwt4aTBZXid5xZ2AiGk/93ES/J0
to5QM99RdyNVcjLBIfPFi4rvklNs/VEL143Nl5xGKLuSfnV6pwxp/wlDOtuP
1ThvlfafcCLGeqepRPJ2wj71vazQ6G2BfwAh0GCl
          "]]}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$135293, {5}}]& ]}, {
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$135293, {1}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$135293, {2}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$135293, {3}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$135293, {4}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$135293, {5}}]& ]}, {
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$135293, {1}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$135293, {2}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$135293, {3}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$135293, {4}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$135293, {
          5}}]& ], {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}}, {
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$135293, {1}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$135293, {2}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$135293, {3}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$135293, {4}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$135293, {
          5}}]& ], {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}}}, {{}, {}}}, {
    DisplayFunction -> Identity, DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {
       FormBox["\"year\"", TraditionalForm], 
       FormBox["\"mio. USD\"", TraditionalForm]}, 
     AxesOrigin -> {1948.5625, 0}, DisplayFunction :> Identity, 
     Frame -> {{False, False}, {False, False}}, 
     FrameLabel -> {{None, None}, {None, None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> 600, LabelStyle -> 
     Directive[FontFamily -> "Helvetica", FontSize -> 14, 
       GrayLevel[0]], 
     Method -> {
      "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
       "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& )}}, PlotLabel -> 
     FormBox["\"rgdpo: Output-side Real GDP at chainned prices\"", 
       TraditionalForm], 
     PlotRange -> {{1948.5625, 2019.}, {0, 1.2525531004440455`*^8}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.05]}}, Ticks -> {Automatic, Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{
      "\"all countries (including extrapolated data)\"", 
       "\"all countries (including extrapolated data)\"", 
       "\"only countries with complete data, 1950-2019\"", 
       "\"extrapolated for countries missing data\"", 
       "\"not extrapolated for countries with missing data\""}, "LineLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.8, 0.5}}}], "Grid"]}, {
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    Dashing[{Small, Small}], 
                    GrayLevel[0]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    Dashing[{Small, Small}], 
                    GrayLevel[0]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.8, 0.5}}}], "Grid"]}, {
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.8, 0.5}}}], "Grid"]}, {
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1], 
                    Dashing[{Small, Small}]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1], 
                    Dashing[{Small, Small}]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #4}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.8, 0.5}}}], "Grid"]}, {
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #5}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.8, 0.5}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxDividers -> {"Columns" -> {{None}}, "Rows" -> {{None}}}, 
             GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
             GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{1}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
          Directive[FontFamily -> "Helvetica", FontSize -> 14, 
           GrayLevel[0]], FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"Small", ",", "Small"}], "}"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0, 0], Editable -> False, Selectable -> 
                    False]}], "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 0, 1], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"Small", ",", "Small"}], "}"}], "]"}]}], "]"}], 
                   ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 0, 1], Editable -> False, Selectable -> 
                    False]}], "]"}]}], "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"Small", ",", "Small"}], "}"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0, 0], Editable -> False, Selectable -> 
                    False]}], "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 0, 1], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"Small", ",", "Small"}], "}"}], "]"}]}], "]"}], 
                   ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 0, 1], Editable -> False, Selectable -> 
                    False]}], "]"}]}], "}"}]}], "}"}], ",", 
           RowBox[{"{", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{#, ",", #2, ",", #3, ",", #4, ",", #5}], "}"}], ",", 
               RowBox[{"{", "}"}]}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"None", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"None", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"None", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"None", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"None", ",", "Automatic"}], "}"}]}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], 
               "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   
                   RowBox[{
                    "True", ",", "True", ",", "True", ",", "True", ",", 
                    "True"}], "}"}], ",", 
                 RowBox[{"{", 
                   
                   RowBox[{
                    "True", ",", "True", ",", "True", ",", "True", ",", 
                    "True"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
               RowBox[{
                 RowBox[{"FontFamily", "\[Rule]", "\"Helvetica\""}], ",", 
                 RowBox[{"FontSize", "\[Rule]", "14"}], ",", 
                 InterpretationBox[
                  ButtonBox[
                   TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                   BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                   ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                   Automatic, Method -> "Preemptive"], 
                  GrayLevel[0], Editable -> False, Selectable -> False]}], 
               "]"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Row\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "Below"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{3.852994298401698*^9, 3.8529944725925846`*^9, 
  3.872512042741706*^9, 3.8725626308163137`*^9, 3.873010872210184*^9, 
  3.874480454511063*^9},
 CellLabel->
  "Out[339]=",ExpressionUUID->"c82972a6-ea60-4ddb-9464-8951e0a5b710"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"lmrgdpo", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"LinearModelFit", "[", 
      RowBox[{
       RowBox[{"rgdponoextotal", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "5"}], "}"}]}], "]"}], "]"}], ",", "x", ",", 
       "x"}], "]"}], "\[IndentingNewLine]", "lrp"}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{"Normal", "[", "lmrgdpo", "]"}], "\[IndentingNewLine]", 
      "Figlog"}], "=", 
     RowBox[{"Show", "[", 
      RowBox[{
       RowBox[{"ListLinePlot", "[", 
        RowBox[{
         RowBox[{"rgdponoextotal", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "5"}], "}"}]}], "]"}], "]"}], ",", 
         RowBox[{
         "PlotLabel", "\[Rule]", 
          "\"\<Log of output (N=55) and linear fit\>\""}]}], "]"}], ",", 
       RowBox[{"Plot", "[", 
        RowBox[{"lrp", ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "1950", ",", "2019"}], "}"}]}], "]"}], ",", 
       RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}]}]}]}], 
  "*)"}]], "Input",
 CellChangeTimes->{{3.851459858892714*^9, 3.851459859291297*^9}, {
  3.852994340566414*^9, 
  3.852994347415553*^9}},ExpressionUUID->"ff7c1af8-f0ec-4108-b6b1-\
788321d52f20"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Calculate capital data time series at Constant National Prices (rnna) (not \
used in analysis, only for weighting reasons)\
\>", "Section",
 CellChangeTimes->{{3.836542594258254*^9, 3.8365426333406935`*^9}, {
  3.8514170283388023`*^9, 3.8514170453475494`*^9}, {3.8728243672631*^9, 
  3.8728244118362255`*^9}},ExpressionUUID->"99fccddf-18b2-4c50-ba0e-\
df2b97e7f920"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"rnna", ":", " ", 
   RowBox[{
   "Capital", " ", "stock", " ", "at", " ", "constant", " ", "2017", " ", 
    "national", " ", "prices", " ", 
    RowBox[{"(", 
     RowBox[{"in", " ", 
      RowBox[{"mil", ".", "2017"}], "US$"}], ")"}]}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.8514167943763256`*^9, 
  3.851416812376667*^9}},ExpressionUUID->"0570c3f9-47d2-4761-a9c8-\
6732c5423097"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"capdat", "=", 
   RowBox[{"Import", "[", "\"\<rnna_Transposed.csv\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"capraw", "=", 
   RowBox[{"capdat", "[", 
    RowBox[{"[", 
     RowBox[{"2", ";;"}], "]"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.8364778162026234`*^9, 3.836477863960676*^9}, {
   3.8364967458204145`*^9, 3.8364967735686293`*^9}, {3.836496813028172*^9, 
   3.836496830627359*^9}, 3.8378420379142914`*^9, {3.8514166918219604`*^9, 
   3.8514166932242527`*^9}},
 CellLabel->
  "In[340]:=",ExpressionUUID->"3169ff3a-952a-422b-b99e-8042caea363f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"capraw2", "=", "capraw"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"Do", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"capraw2", "[", 
       RowBox[{"[", 
        RowBox[{"i", ",", "j"}], "]"}], "]"}], "=", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"capraw", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "j"}], "]"}], "]"}], "\[Equal]", "\"\<\>\""}], 
        ",", "0", ",", 
        RowBox[{"capraw", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "j"}], "]"}], "]"}]}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"j", ",", "2", ",", "181"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lcapraw", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "71"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "181"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"lcapraw", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "1"}], "]"}], "]"}], "=", "\"\<year\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"lcapraw", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", 
      RowBox[{"2", ";;"}]}], "]"}], "]"}], "=", 
   RowBox[{"capraw", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", 
      RowBox[{"2", ";;"}]}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"lcapraw", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "1"}], "]"}], "]"}], "=", 
   RowBox[{"capraw", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "1"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ncapraw", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"\"\<\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "181"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rcap", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "181"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "3"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ncapraw", "[", 
     RowBox[{"[", "i", "]"}], "]"}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{"Position", "[", 
       RowBox[{
        RowBox[{"capraw", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;"}], ",", "i"}], "]"}], "]"}], ",", 
        RowBox[{"_", "?", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"#", "\[NotEqual]", "\"\<\>\""}], "&"}], ")"}]}], ",", "1",
         ",", "1"}], "]"}], "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1"}], "]"}], "]"}], "+", "1"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "181"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ncapraw", "[", 
     RowBox[{"[", "141", "]"}], "]"}], "=", "52"}], ";"}], " ", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{
     "for", " ", "Russia", " ", "we", " ", "use", " ", "the", " ", "period", 
      " ", "from", " ", "2000", " ", "onwards", " ", "to", " ", "fit", " ", 
      "the", " ", "data"}], ")"}], ";"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"lcapraw", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{
        RowBox[{"ncapraw", "[", 
         RowBox[{"[", "i", "]"}], "]"}], ";;"}], ",", "i"}], "]"}], "]"}], 
    "=", 
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{"capraw", "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{
          RowBox[{"ncapraw", "[", 
           RowBox[{"[", "i", "]"}], "]"}], ";;"}], ",", "i"}], "]"}], "]"}], 
      "]"}], "//", "N"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "181"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"rcap", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "2"}], "]"}], "]"}], "=", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"lcapraw", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{
           RowBox[{"ncapraw", "[", 
            RowBox[{"[", "i", "]"}], "]"}], "+", "15"}], ",", "i"}], "]"}], 
        "]"}], "-", 
       RowBox[{"lcapraw", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"ncapraw", "[", 
           RowBox[{"[", "i", "]"}], "]"}], ",", "i"}], "]"}], "]"}]}], ")"}], 
     "/", "15"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "181"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"rcap", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "3"}], "]"}], "]"}], "=", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"lcapraw", "[", 
        RowBox[{"[", 
         RowBox[{"71", ",", "i"}], "]"}], "]"}], "-", 
       RowBox[{"lcapraw", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"ncapraw", "[", 
           RowBox[{"[", "i", "]"}], "]"}], ",", "i"}], "]"}], "]"}]}], ")"}], 
     "/", 
     RowBox[{"(", 
      RowBox[{"71", "-", 
       RowBox[{"ncapraw", "[", 
        RowBox[{"[", "i", "]"}], "]"}]}], ")"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "181"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"rcap", "[", 
    RowBox[{"[", 
     RowBox[{"170", ",", "2"}], "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"lcapraw", "[", 
       RowBox[{"[", 
        RowBox[{"44", ",", "170"}], "]"}], "]"}], "-", 
      RowBox[{"lcapraw", "[", 
       RowBox[{"[", 
        RowBox[{"42", ",", "170"}], "]"}], "]"}]}], ")"}], "/", "2"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"rcap", "[", 
    RowBox[{"[", 
     RowBox[{"170", ",", "3"}], "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"lcapraw", "[", 
       RowBox[{"[", 
        RowBox[{"44", ",", "170"}], "]"}], "]"}], "-", 
      RowBox[{"lcapraw", "[", 
       RowBox[{"[", 
        RowBox[{"42", ",", "170"}], "]"}], "]"}]}], ")"}], "/", "2"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"rcap", "[", 
    RowBox[{"[", 
     RowBox[{"141", ",", "2"}], "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"lcapraw", "[", 
       RowBox[{"[", 
        RowBox[{"71", ",", "141"}], "]"}], "]"}], "-", 
      RowBox[{"lcapraw", "[", 
       RowBox[{"[", 
        RowBox[{"57", ",", "141"}], "]"}], "]"}]}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{"71", "-", "57"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"rcap", "[", 
    RowBox[{"[", 
     RowBox[{"141", ",", "3"}], "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"lcapraw", "[", 
       RowBox[{"[", 
        RowBox[{"71", ",", "141"}], "]"}], "]"}], "-", 
      RowBox[{"lcapraw", "[", 
       RowBox[{"[", 
        RowBox[{"57", ",", "141"}], "]"}], "]"}]}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{"71", "-", "57"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"ncapraw", "[", 
       RowBox[{"[", "i", "]"}], "]"}], ">", "2"}], ",", 
     RowBox[{"{", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"lcapraw", "[", 
          RowBox[{"[", 
           RowBox[{"j", ",", "i"}], "]"}], "]"}], "=", 
         RowBox[{
          RowBox[{"lcapraw", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"ncapraw", "[", 
              RowBox[{"[", "i", "]"}], "]"}], ",", "i"}], "]"}], "]"}], "-", 
          RowBox[{
           RowBox[{"rcap", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "2"}], "]"}], "]"}], "*", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"ncapraw", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "-", "j"}], ")"}]}]}]}], ",", 
        RowBox[{"{", 
         RowBox[{"j", ",", "2", ",", 
          RowBox[{
           RowBox[{"ncapraw", "[", 
            RowBox[{"[", "i", "]"}], "]"}], "-", "1"}]}], "}"}]}], "]"}], 
      "}"}], ",", "0"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "181"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.8366002681272573`*^9, 3.836600269959715*^9}, {
  3.837610675847801*^9, 3.8376106983746624`*^9}, {3.8376169321733513`*^9, 
  3.8376169692181673`*^9}, {3.837618186361331*^9, 3.8376183309691315`*^9}, {
  3.8376187126835184`*^9, 3.837618731840352*^9}, {3.8376193529465427`*^9, 
  3.8376194231915317`*^9}, {3.837619484036174*^9, 3.8376194844250183`*^9}, {
  3.8376219090336637`*^9, 3.837621913424988*^9}, {3.8376221220251455`*^9, 
  3.837622129013462*^9}, {3.837622979954011*^9, 3.8376230458735027`*^9}, {
  3.837623107432669*^9, 3.8376231890078716`*^9}, {3.837624533394182*^9, 
  3.8376245481426516`*^9}},
 CellLabel->
  "In[342]:=",ExpressionUUID->"0d6f9d68-19fb-4423-8d02-db118dc25f91"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Dimensions", "[", 
    RowBox[{"Flatten", "[", 
     RowBox[{"Position", "[", 
      RowBox[{"ncapraw", ",", "2"}], "]"}], "]"}], "]"}], "*)"}], " ", 
  RowBox[{"(*", 
   RowBox[{
   "number", " ", "of", " ", "countries", " ", "with", " ", "data", " ", 
    "from", " ", "1950", " ", "onward"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Dimensions", "[", 
    RowBox[{"Flatten", "[", 
     RowBox[{"Position", "[", 
      RowBox[{"ncapraw", ",", 
       RowBox[{"_", "?", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"#", "<", "20"}], "&"}], ")"}]}]}], "]"}], "]"}], "]"}], 
   "*)"}], 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "Number", " ", "of", " ", "countries", " ", "with", " ", "data", " ", 
     "starting"}], " ", "<", 
    RowBox[{"1968", " ", "onward", " ", "availabe"}]}], "*)"}]}]], "Input",
 CellChangeTimes->{{3.843456259207822*^9, 3.843456261967708*^9}, {
  3.8434563250812397`*^9, 3.843456363959548*^9}, {3.843456425965951*^9, 
  3.8434564286379976`*^9}, {3.843456477360572*^9, 3.843456510244914*^9}, {
  3.8434581973495903`*^9, 3.843458266951518*^9}},
 CellLabel->"In[22]:=",ExpressionUUID->"fc15fc96-b499-4ad6-8f19-57649263fe41"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"capfull", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "71"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "181"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"capfull", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "1"}], "]"}], "]"}], "=", "\"\<year\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"capfull", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", 
      RowBox[{"2", ";;"}]}], "]"}], "]"}], "=", 
   RowBox[{"capraw", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", 
      RowBox[{"2", ";;"}]}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"capfull", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "1"}], "]"}], "]"}], "=", 
   RowBox[{"capraw", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "1"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"capfull", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", 
      RowBox[{"2", ";;"}]}], "]"}], "]"}], "=", 
   RowBox[{"Exp", "[", 
    RowBox[{"lcapraw", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", 
       RowBox[{"2", ";;"}]}], "]"}], "]"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.836478615265397*^9, 3.836478774751958*^9}, {
   3.836478808256502*^9, 3.8364788305636053`*^9}, {3.836479159261264*^9, 
   3.8364791638443966`*^9}, {3.8364792609777117`*^9, 3.836479261858905*^9}, {
   3.836479367582426*^9, 3.8364796969513073`*^9}, {3.8364798623528824`*^9, 
   3.836479879028204*^9}, {3.8364800270652175`*^9, 3.83648002802437*^9}, {
   3.8364802663791127`*^9, 3.8364802851164074`*^9}, {3.8364811568987665`*^9, 
   3.8364811580054984`*^9}, {3.836486741739381*^9, 3.8364867439573355`*^9}, {
   3.8364885043487105`*^9, 3.8364885183351393`*^9}, {3.836488650882226*^9, 
   3.836488660596323*^9}, {3.8364892635376062`*^9, 3.8364892850899634`*^9}, {
   3.8364959576389503`*^9, 3.8364959579926214`*^9}, 3.8364966275187197`*^9, {
   3.836496803853406*^9, 3.8364968098945255`*^9}, {3.8364968483405724`*^9, 
   3.836496881543643*^9}, {3.8364970099941816`*^9, 3.836497011018032*^9}, {
   3.8364970857320867`*^9, 3.836497086753092*^9}, {3.836502360265394*^9, 
   3.836502517300318*^9}, {3.8365025522917023`*^9, 3.8365026662313643`*^9}, {
   3.836502703371941*^9, 3.836502703816445*^9}, {3.8365027607879443`*^9, 
   3.8365027643451676`*^9}, {3.8365028401260967`*^9, 
   3.8365028409667344`*^9}, {3.8365032275742006`*^9, 
   3.8365032577984858`*^9}, {3.836545643808959*^9, 3.836545652988243*^9}, {
   3.8375027286812983`*^9, 3.8375027290561304`*^9}, {3.837502843953373*^9, 
   3.837502850336053*^9}, {3.8376217912271566`*^9, 3.837621809160245*^9}, 
   3.837622087303434*^9, {3.8376221782240868`*^9, 3.8376221784075966`*^9}, {
   3.8376245670189867`*^9, 3.8376245704050694`*^9}, {3.8434562302473125`*^9, 
   3.8434562378290944`*^9}, 3.8490292828740835`*^9},
 CellLabel->
  "In[360]:=",ExpressionUUID->"44f87d9b-4a8d-4258-a38f-591bf4280f7d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<rnna_calc_full.csv\>\"", ",", "capfull"}], "]"}]], "Input",
 CellChangeTimes->{{3.8364954288155046`*^9, 3.8364954448825808`*^9}, {
  3.837842240009288*^9, 3.8378422563845224`*^9}, {3.838476276132435*^9, 
  3.8384762785452976`*^9}, {3.8514168247144146`*^9, 3.8514168252161465`*^9}},
 CellLabel->"In[28]:=",ExpressionUUID->"fb3b2f47-96d8-4644-b7e9-4c86abecd9bd"],

Cell[BoxData["\<\"rnna_calc_full.csv\"\>"], "Output",
 CellChangeTimes->{
  3.836495446583298*^9, 3.836495972441991*^9, {3.836502711212123*^9, 
   3.8365027246218634`*^9}, 3.8365027707701244`*^9, 3.836503362922517*^9, 
   3.837624603026782*^9, 3.8378417774968653`*^9, 3.838476282681054*^9, 
   3.8472041716757765`*^9, 3.8474204849753685`*^9, 3.8481281729487104`*^9, 
   3.851416833242944*^9},
 CellLabel->"Out[28]=",ExpressionUUID->"17d6a8c8-1c4c-4ed5-a574-420939c4c206"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"stocks", "=", 
    RowBox[{"Table", "[", 
     RowBox[{"0", ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "181"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "7"}], "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"stocks", "[", 
     RowBox[{"[", "1", "]"}], "]"}], "=", 
    RowBox[{"{", 
     RowBox[{
     "\"\<1-country\>\"", ",", "\"\<2-cap-1950\>\"", ",", 
      "\"\<3-cap-2019\>\"", ",", "\"\<4-delta-cap\>\"", ",", 
      "\"\<5-pop-1950\>\"", ",", "\"\<6-pop-2019\>\"", ",", 
      "\"\<7-delta-pop\>\""}], "}"}]}], ";", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"stocks", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", "1"}], "]"}], "]"}], "=", 
    RowBox[{"capfull", "[", 
     RowBox[{"[", 
      RowBox[{"1", ",", 
       RowBox[{"2", ";;"}]}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"stocks", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", "2"}], "]"}], "]"}], "=", 
    RowBox[{"capfull", "[", 
     RowBox[{"[", 
      RowBox[{"2", ",", 
       RowBox[{"2", ";;"}]}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"stocks", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", "3"}], "]"}], "]"}], "=", 
    RowBox[{"capfull", "[", 
     RowBox[{"[", 
      RowBox[{"71", ",", 
       RowBox[{"2", ";;"}]}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"stocks", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", "4"}], "]"}], "]"}], "=", 
    RowBox[{
     RowBox[{"stocks", "[", 
      RowBox[{"[", 
       RowBox[{
        RowBox[{"2", ";;"}], ",", "3"}], "]"}], "]"}], "-", 
     RowBox[{"stocks", "[", 
      RowBox[{"[", 
       RowBox[{
        RowBox[{"2", ";;"}], ",", "2"}], "]"}], "]"}]}]}], ";"}], 
  "*)"}]], "Input",
 CellChangeTimes->{{3.8521389960669966`*^9, 3.8521393354263377`*^9}, {
  3.872512226019617*^9, 
  3.8725122309020295`*^9}},ExpressionUUID->"8d6b2b93-949b-4cf8-bf09-\
f8be3078dddc"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"captotal", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "71"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "3"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"captotal", "[", 
    RowBox[{"[", "1", "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"\"\<year\>\"", ",", "\"\<cap\>\"", ",", "\"\<lcap\>\""}], 
    "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"captotal", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "1"}], "]"}], "]"}], "=", 
    RowBox[{"1948", "+", "i"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"captotal", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "2"}], "]"}], "]"}], "=", 
    RowBox[{"Total", "[", 
     RowBox[{"capfull", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", 
        RowBox[{"2", ";;"}]}], "]"}], "]"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"captotal", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "3"}], "]"}], "]"}], "=", 
   RowBox[{"Log", "[", 
    RowBox[{"captotal", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", "2"}], "]"}], "]"}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.8364951290971956`*^9, 3.836495346408888*^9}, {
  3.847644405607142*^9, 3.8476444488555465`*^9}, {3.8476461863180833`*^9, 
  3.8476461898019943`*^9}},
 CellLabel->
  "In[365]:=",ExpressionUUID->"d0d4fff3-b893-4b30-8c6a-f5e8b580649c"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"nexcap", "=", 
   RowBox[{"Position", "[", 
    RowBox[{"ncapraw", ",", 
     RowBox[{"n_", "/;", 
      RowBox[{"n", ">", "2"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"noexcap", "=", 
   RowBox[{"Position", "[", 
    RowBox[{"ncapraw", ",", 
     RowBox[{"n_", "/;", 
      RowBox[{"n", "==", "2"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"capnoextotal", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "71"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "4"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"capnoextotal", "[", 
    RowBox[{"[", "1", "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
    "\"\<year\>\"", ",", "\"\<cap\>\"", ",", "\"\<cap\>\"", ",", 
     "\"\<cap\>\""}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"capnoextotal", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "1"}], "]"}], "]"}], "=", 
    RowBox[{"1948", "+", "i"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"capnoextotal", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "2"}], "]"}], "]"}], "=", 
    RowBox[{"Total", "[", 
     RowBox[{"capfull", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", 
        RowBox[{"Flatten", "[", "noexcap", "]"}]}], "]"}], "]"}], "]"}]}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"capnoextotal", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "3"}], "]"}], "]"}], "=", 
    RowBox[{"Total", "[", 
     RowBox[{"capfull", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", 
        RowBox[{"Flatten", "[", "nexcap", "]"}]}], "]"}], "]"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"capnoextotal", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "4"}], "]"}], "]"}], "=", 
    RowBox[{"Total", "[", 
     RowBox[{"capraw2", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", 
        RowBox[{"Flatten", "[", "nexcap", "]"}]}], "]"}], "]"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.8365434344171085`*^9, 3.836543483636301*^9}, {
   3.8365827730947933`*^9, 3.8365828030303745`*^9}, {3.836582904823327*^9, 
   3.836582908978444*^9}, {3.836583089627802*^9, 3.836583091555582*^9}, {
   3.8365832174974127`*^9, 3.8365832270898876`*^9}, 3.836583783388259*^9, {
   3.8366009881099296`*^9, 3.8366010082874594`*^9}, {3.8366013373245525`*^9, 
   3.836601352615738*^9}, {3.8366013877178135`*^9, 3.836601433897071*^9}, {
   3.8366015884348793`*^9, 3.8366016191320267`*^9}},
 CellLabel->
  "In[370]:=",ExpressionUUID->"e93d06fd-543b-4a3f-9030-a7cfee4cd0a7"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"fig1cap", "=", 
    RowBox[{"ListLinePlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Legended", "[", 
         RowBox[{
          RowBox[{"captotal", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"2", ";;"}], ",", 
             RowBox[{"{", 
              RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}], ",", 
          RowBox[{"Placed", "[", 
           RowBox[{"\"\<all countries\>\"", ",", "Below"}], "]"}]}], "]"}], 
        ",", 
        RowBox[{"Legended", "[", 
         RowBox[{
          RowBox[{"capnoextotal", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"2", ";;"}], ",", 
             RowBox[{"{", 
              RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}], ",", 
          RowBox[{"Placed", "[", 
           RowBox[{"\"\<wo extrapolated countries\>\"", ",", "Below"}], 
           "]"}]}], "]"}]}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Blue", ",", "Black"}], "}"}]}], ",", 
      RowBox[{"PlotLabel", "\[Rule]", "\"\<Capital Stock MER\>\""}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Export", "[", 
    RowBox[{"\"\<fig1_cap.pdf\>\"", ",", "fig1cap"}], "]"}], "*)"}], 
  "*)"}]], "Input",
 CellChangeTimes->{{3.8365028712385054`*^9, 3.836502905492655*^9}, {
  3.8365434919245367`*^9, 3.8365435815505667`*^9}, {3.836543693365947*^9, 
  3.8365436955917587`*^9}, {3.8365437445480328`*^9, 3.8365437846816273`*^9}, {
  3.8365438614909787`*^9, 3.836543889557788*^9}, {3.836545913872012*^9, 
  3.8365459852549*^9}, {3.8365828279417534`*^9, 3.836582857438449*^9}, {
  3.836600809352606*^9, 3.8366008204361486`*^9}, {3.836601463324025*^9, 
  3.836601495137479*^9}, {3.843458549564601*^9, 3.8434585654952865`*^9}, {
  3.8476444639314566`*^9, 3.847644464444497*^9}, {3.849514912126855*^9, 
  3.84951493567695*^9}, {3.8514168600328245`*^9, 
  3.851416863624423*^9}},ExpressionUUID->"1b5e2dd1-2b65-4764-912c-\
fbc6f4ab1190"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"fig2cap", "=", 
   RowBox[{"ListLinePlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Legended", "[", 
        RowBox[{
         RowBox[{"captotal", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}], ",", 
         RowBox[{"Placed", "[", 
          RowBox[{
          "\"\<all countries (including extrapolated data)\>\"", ",", 
           "Below"}], "]"}]}], "]"}], ",", 
       RowBox[{"Legended", "[", 
        RowBox[{
         RowBox[{"capnoextotal", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "3"}], "}"}]}], "]"}], "]"}], ",", 
         RowBox[{"Placed", "[", 
          RowBox[{
          "\"\<extrapolated for countries missing data\>\"", ",", "Below"}], 
          "]"}]}], "]"}], ",", 
       RowBox[{"Legended", "[", 
        RowBox[{
         RowBox[{"capnoextotal", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "4"}], "}"}]}], "]"}], "]"}], ",", 
         RowBox[{"Placed", "[", 
          RowBox[{
          "\"\<not extrapolated for countries with missing data\>\"", ",", 
           "Below"}], "]"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Black", ",", 
        RowBox[{"{", 
         RowBox[{"Blue", ",", "Dashed"}], "}"}], ",", "Blue"}], "}"}]}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<year\>\"", ",", "\"\<mio. USD\>\""}], "}"}]}], ",", 
     RowBox[{
     "PlotLabel", "\[Rule]", 
      "\"\<Capital Stock (market exchange) aggregated\>\""}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.836600880730194*^9, 3.836600932254799*^9}, {
  3.8366015380523195`*^9, 3.836601538421136*^9}, {3.8366016948824472`*^9, 
  3.836601716244355*^9}, {3.8366017468674383`*^9, 3.836601747231467*^9}, {
  3.8366018223387165`*^9, 3.836601846712026*^9}, {3.8434585902652764`*^9, 
  3.8434586021442738`*^9}, {3.8434587960026274`*^9, 3.8434588250326633`*^9}, {
  3.8434588797812886`*^9, 3.843458967079728*^9}, {3.8434595603896203`*^9, 
  3.8434596379416695`*^9}, {3.8476444804139347`*^9, 3.84764448087984*^9}, {
  3.847644574819309*^9, 3.847644577426305*^9}, {3.849516647894266*^9, 
  3.849516661048194*^9}, {3.872512259494197*^9, 3.8725122629572277`*^9}},
 CellLabel->
  "In[1791]:=",ExpressionUUID->"fd8f22ae-079f-477f-9d6e-d833fe285df2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"Export", "[", 
   RowBox[{"\"\<fig2_cap.eps\>\"", ",", "fig2cap"}], "]"}], "*)"}]], "Input",
 CellChangeTimes->{{3.8366018718078613`*^9, 3.836601892596155*^9}, {
  3.843458618379673*^9, 3.843458620422483*^9}, {3.872512267509945*^9, 
  3.8725122698673625`*^9}},ExpressionUUID->"cf8757a0-410c-47a5-9057-\
2e017256a93a"],

Cell[BoxData["\<\"fig2_cap.eps\"\>"], "Output",
 CellChangeTimes->{3.836601893642423*^9, 3.837624685209673*^9, 
  3.843458621437058*^9, 3.8434596474429116`*^9, 3.847204172511035*^9, 
  3.8474204862460895`*^9, 3.8481281742421107`*^9},
 CellLabel->"Out[46]=",ExpressionUUID->"00e8cd6f-d921-4881-a289-e621cbb50b71"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"ListLinePlot", "[", 
   RowBox[{"{", 
    RowBox[{"Legended", "[", 
     RowBox[{
      RowBox[{"captotal", "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{"2", ";;"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "3"}], "}"}]}], "]"}], "]"}], ",", 
      RowBox[{"Placed", "[", 
       RowBox[{
       "\"\<all countries (including extrapolated data)\>\"", ",", "Below"}], 
       "]"}]}], "]"}], "}"}], "]"}], "*)"}]], "Input",
 CellChangeTimes->{{3.8476446004452243`*^9, 3.8476446103322983`*^9}, {
  3.851416991462158*^9, 3.85141699634661*^9}},
 CellLabel->"In[43]:=",ExpressionUUID->"3ae79447-32b3-4bd8-ae8e-e171c1a31c12"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"caprates", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "71"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "181"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"caprates", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "1"}], "]"}], "]"}], "=", "\"\<year\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"caprates", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", 
      RowBox[{"2", ";;"}]}], "]"}], "]"}], "=", 
   RowBox[{"capraw", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", 
      RowBox[{"2", ";;"}]}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"caprates", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "1"}], "]"}], "]"}], "=", 
   RowBox[{"capraw", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "1"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"caprates", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", 
       RowBox[{"2", ";;"}]}], "]"}], "]"}], "=", 
    RowBox[{
     RowBox[{"capfull", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", 
        RowBox[{"2", ";;"}]}], "]"}], "]"}], "/", 
     RowBox[{"capfull", "[", 
      RowBox[{"[", 
       RowBox[{"71", ",", 
        RowBox[{"2", ";;"}]}], "]"}], "]"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.8365424055850086`*^9, 3.836542415774574*^9}, {
  3.8365424794372663`*^9, 3.836542553269309*^9}},
 CellLabel->
  "In[378]:=",ExpressionUUID->"e29d0357-aa08-48d0-8fe4-9d624f551a26"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"lshareraw", "=", 
    RowBox[{"Import", "[", "\"\<labor_share_PWT_Transposed.csv\>\"", "]"}]}], 
   ";", "\[IndentingNewLine]", 
   RowBox[{"Dimensions", "[", "lshareraw", "]"}], ";", "\[IndentingNewLine]", 
   RowBox[{"lshare", "=", 
    RowBox[{"lshareraw", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", ";;"}], "]"}], "]"}]}], ";", 
   "\[IndentingNewLine]", 
   RowBox[{"Dimensions", "[", "lshare", "]"}], ";", "\[IndentingNewLine]", 
   RowBox[{"Dimensions", "[", "outraw", "]"}], ";", "\[IndentingNewLine]", 
   RowBox[{"lnraw", "=", 
    RowBox[{"Table", "[", 
     RowBox[{"\"\<\>\"", ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "181"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "3"}], "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"lnraw", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "1"}], "]"}], "]"}], "=", 
       RowBox[{
        RowBox[{
         RowBox[{"Position", "[", 
          RowBox[{
           RowBox[{"lshare", "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"2", ";;"}], ",", "i"}], "]"}], "]"}], ",", 
           RowBox[{"_", "?", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"#", "\[NotEqual]", "\"\<\>\""}], "&"}], ")"}]}], ",", 
           "1", ",", "1"}], "]"}], "[", 
         RowBox[{"[", 
          RowBox[{"1", ",", "1"}], "]"}], "]"}], "+", "1"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "2", ",", "181"}], "}"}]}], "]"}], 
    "\[IndentingNewLine]", 
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"lnraw", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "2"}], "]"}], "]"}], "=", 
       RowBox[{"lshare", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"lnraw", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", "i"}], "]"}], "]"}]}],
       ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "2", ",", "181"}], "}"}]}], "]"}], 
    "\[IndentingNewLine]", 
    RowBox[{"lfull", "=", "lshare"}]}], ";", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"lfull", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "j"}], "]"}], "]"}], "=", 
         RowBox[{"lnraw", "[", 
          RowBox[{"[", 
           RowBox[{"j", ",", "2"}], "]"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "2", ",", 
          RowBox[{"lnraw", "[", 
           RowBox[{"[", 
            RowBox[{"j", ",", "1"}], "]"}], "]"}]}], "}"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "2", ",", "181"}], "}"}]}], "]"}], 
    "\[IndentingNewLine]", 
    RowBox[{"lfull2", "=", "lshare"}]}], ";", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"lfull2", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "j"}], "]"}], "]"}], "=", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"lshare", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", "j"}], "]"}], "]"}], "\[Equal]", "\"\<\>\""}],
            ",", "0", ",", 
           RowBox[{"lshare", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "j"}], "]"}], "]"}]}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "2", ",", "181"}], "}"}]}], "]"}], 
    "\[IndentingNewLine]", 
    RowBox[{"outfull2", "=", "outfull"}]}], ";", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"outPPPcalc2", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "j"}], "]"}], "]"}], "=", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"lshare", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", "j"}], "]"}], "]"}], "\[Equal]", "\"\<\>\""}],
            ",", "0", ",", 
           RowBox[{"outPPPcalc2", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "j"}], "]"}], "]"}]}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "2", ",", "181"}], "}"}]}], "]"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Do", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"lnraw", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "2"}], "]"}], "]"}], "=", 
          RowBox[{"lshare", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"dnraw", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", "i"}], "]"}], 
           "]"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "2", ",", "181"}], "}"}]}], "]"}], 
       "\[IndentingNewLine]", "lfull"}], "=", "lshare"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{"Do", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"lfull", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "j"}], "]"}], "]"}], "=", 
           RowBox[{"lnraw", "[", 
            RowBox[{"[", 
             RowBox[{"j", ",", "2"}], "]"}], "]"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "2", ",", 
            RowBox[{"lnraw", "[", 
             RowBox[{"[", 
              RowBox[{"j", ",", "1"}], "]"}], "]"}]}], "}"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"j", ",", "2", ",", "181"}], "}"}]}], "]"}], 
      "\[IndentingNewLine]", 
      RowBox[{"lfull2", "=", "lshare"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{"Do", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"lfull2", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "j"}], "]"}], "]"}], "=", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"lshare", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "j"}], "]"}], "]"}], "\[Equal]", 
             "\"\<\>\""}], ",", "0", ",", 
            RowBox[{"lshare", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", "j"}], "]"}], "]"}]}], "]"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "2", ",", "181"}], "}"}]}], "]"}]}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"outPPPcalc2", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "j"}], "]"}], "]"}], "=", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"lshare", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", "j"}], "]"}], "]"}], "\[Equal]", "\"\<\>\""}],
            ",", "0", ",", 
           RowBox[{"outPPPcalc2", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "j"}], "]"}], "]"}]}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "2", ",", "70"}], "}"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "2", ",", "181"}], "}"}]}], "]"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"outfull2", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "j"}], "]"}], "]"}], "=", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"lfull2", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", "j"}], "]"}], "]"}], "\[Equal]", "0"}], ",", 
           "0", ",", 
           RowBox[{"outfull2", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "j"}], "]"}], "]"}]}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "2", ",", "181"}], "}"}]}], "]"}], 
    "\[IndentingNewLine]", 
    RowBox[{"(*", 
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"outPPPcalc2", "[", 
         RowBox[{"[", 
          RowBox[{"71", ",", "j"}], "]"}], "]"}], "=", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"lshare", "[", 
            RowBox[{"[", 
             RowBox[{"71", ",", "j"}], "]"}], "]"}], "\[Equal]", "0"}], ",", 
          "0", ",", 
          RowBox[{"outPPPcalc2", "[", 
           RowBox[{"[", 
            RowBox[{"71", ",", "j"}], "]"}], "]"}]}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "2", ",", "70"}], "}"}]}], "]"}], "*)"}], 
    "\[IndentingNewLine]", 
    RowBox[{"lsweight", "=", 
     RowBox[{"Table", "[", 
      RowBox[{"0", ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "71"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "3"}], "}"}]}], "]"}]}]}], ";", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lsweight", "[", 
     RowBox[{"[", "1", "]"}], "]"}], "=", 
    RowBox[{"{", 
     RowBox[{
     "\"\<year\>\"", ",", "\"\<totalOut\>\"", ",", "\"\<weightedLS\>\""}], 
     "}"}]}], ";", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"lsweight", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "1"}], "]"}], "]"}], "=", 
        RowBox[{"1948", "+", "i"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], 
     "\[IndentingNewLine]", 
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"lsweight", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "2"}], "]"}], "]"}], "=", 
        RowBox[{"Total", "[", 
         RowBox[{"outfull2", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", 
            RowBox[{"2", ";;"}]}], "]"}], "]"}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], 
     "\[IndentingNewLine]", 
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"lsweight", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "3"}], "]"}], "]"}], "=", 
        RowBox[{
         RowBox[{"Total", "[", 
          RowBox[{
           RowBox[{"outfull2", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", 
              RowBox[{"2", ";;"}]}], "]"}], "]"}], "*", 
           RowBox[{"lfull2", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", 
              RowBox[{"2", ";;"}]}], "]"}], "]"}]}], "]"}], "/", 
         RowBox[{"lsweight", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "2"}], "]"}], "]"}]}]}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], 
     "\[IndentingNewLine]", "kappa1"}], "=", 
    RowBox[{
     RowBox[{"1", "-", 
      RowBox[{
       RowBox[{"Mean", "[", 
        RowBox[{"lsweight", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"61", ";;", "71"}], ",", "3"}], "]"}], "]"}], "]"}], 
       "\[IndentingNewLine]", "kappa2"}]}], "=", 
     RowBox[{
      RowBox[{"1", "-", 
       RowBox[{
        RowBox[{"Mean", "[", 
         RowBox[{"lsweight", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"71", ";;", "71"}], ",", "3"}], "]"}], "]"}], "]"}], 
        "\[IndentingNewLine]", "kappa3"}]}], "=", 
      RowBox[{"1", "-", 
       RowBox[{"Mean", "[", 
        RowBox[{"lsweight", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;"}], ",", "3"}], "]"}], "]"}], "]"}]}]}]}]}]}], 
  "*)"}]], "Input",
 CellChangeTimes->{{3.8396731776047497`*^9, 3.8396732638622293`*^9}, {
  3.839674059878787*^9, 3.8396740844186745`*^9}, {3.8396741518233557`*^9, 
  3.8396741713307943`*^9}, {3.84346370550237*^9, 3.8434637932520957`*^9}, {
  3.848251000574577*^9, 3.848251012855946*^9}, {3.8482518332565813`*^9, 
  3.848251833822481*^9}, {3.8482521986984544`*^9, 3.8482522021917844`*^9}, {
  3.8482523348118367`*^9, 3.848252341627327*^9}, {3.848252385510352*^9, 
  3.8482524447079554`*^9}, {3.8482525756715155`*^9, 3.8482525847725134`*^9}, {
  3.849528483573511*^9, 
  3.8495284906050043`*^9}},ExpressionUUID->"89f94d37-b8f3-4c43-8f18-\
52a622fba668"],

Cell[BoxData["0.45526968230334497`"], "Output",
 CellChangeTimes->{3.848251185417801*^9, 3.8482518355665364`*^9, 
  3.848252127611105*^9, 3.8482522042942853`*^9, 3.8482526063122387`*^9, 
  3.8495151923088093`*^9},
 CellLabel->
  "Out[778]=",ExpressionUUID->"26b7a38f-d949-4040-9e42-f4db792d73fa"],

Cell[BoxData["0.4527896457908587`"], "Output",
 CellChangeTimes->{3.848251185417801*^9, 3.8482518355665364`*^9, 
  3.848252127611105*^9, 3.8482522042942853`*^9, 3.8482526063122387`*^9, 
  3.8495151923130255`*^9},
 CellLabel->
  "Out[779]=",ExpressionUUID->"c9d61508-9e81-483c-9bf7-327811c1e357"],

Cell[BoxData["0.4203545247550038`"], "Output",
 CellChangeTimes->{3.848251185417801*^9, 3.8482518355665364`*^9, 
  3.848252127611105*^9, 3.8482522042942853`*^9, 3.8482526063122387`*^9, 
  3.849515192317191*^9},
 CellLabel->
  "Out[780]=",ExpressionUUID->"04e20790-9b15-4516-8d2b-b1993e2745b1"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"cr", "=", "capfull"}], ";", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"cr", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", 
       RowBox[{"2", ";;"}]}], "]"}], "]"}], "=", 
    RowBox[{
     RowBox[{"capfull", "[", 
      RowBox[{"[", 
       RowBox[{
        RowBox[{"2", ";;"}], ",", 
        RowBox[{"2", ";;"}]}], "]"}], "]"}], "/", 
     RowBox[{"outfull", "[", 
      RowBox[{"[", 
       RowBox[{
        RowBox[{"2", ";;"}], ",", 
        RowBox[{"2", ";;"}]}], "]"}], "]"}]}]}], ";", "\[IndentingNewLine]", 
   RowBox[{"crr", "=", "capraw"}], ";", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"crr", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", 
       RowBox[{"2", ";;"}]}], "]"}], "]"}], "=", 
    RowBox[{
     RowBox[{"capraw", "[", 
      RowBox[{"[", 
       RowBox[{
        RowBox[{"2", ";;"}], ",", 
        RowBox[{"2", ";;"}]}], "]"}], "]"}], "/", 
     RowBox[{"outraw", "[", 
      RowBox[{"[", 
       RowBox[{
        RowBox[{"2", ";;"}], ",", 
        RowBox[{"2", ";;"}]}], "]"}], "]"}]}]}], ";", 
   RowBox[{"craw", "=", 
    RowBox[{"Table", "[", 
     RowBox[{"0", ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "71"}], "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"craw", "[", 
     RowBox[{"[", "1", "]"}], "]"}], "=", "\"\<C_total\>\""}], ";", 
   "\[IndentingNewLine]", 
   RowBox[{"oraw", "=", 
    RowBox[{"Table", "[", 
     RowBox[{"0", ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "71"}], "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"oraw", "[", 
     RowBox[{"[", "1", "]"}], "]"}], "=", "\"\<O_total\>\""}], ";", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"craw", "[", 
        RowBox[{"[", "i", "]"}], "]"}], "=", 
       RowBox[{"Total", "[", 
        RowBox[{"DeleteCases", "[", 
         RowBox[{
          RowBox[{"capraw", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", 
             RowBox[{"2", ";;"}]}], "]"}], "]"}], ",", "\"\<\>\""}], "]"}], 
        "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], 
    "\[IndentingNewLine]", 
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"oraw", "[", 
        RowBox[{"[", "i", "]"}], "]"}], "=", 
       RowBox[{"Total", "[", 
        RowBox[{"DeleteCases", "[", 
         RowBox[{
          RowBox[{"outraw", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", 
             RowBox[{"2", ";;"}]}], "]"}], "]"}], ",", "\"\<\>\""}], "]"}], 
        "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], 
    "\[IndentingNewLine]", 
    RowBox[{"coshare", "=", 
     RowBox[{"Table", "[", 
      RowBox[{"0", ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "71"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "2"}], "}"}]}], "]"}]}]}], ";", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"coshare", "[", 
     RowBox[{"[", "1", "]"}], "]"}], "=", 
    RowBox[{"{", 
     RowBox[{"\"\<year\>\"", ",", "\"\<Cap-out-ratio\>\""}], "}"}]}], ";", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"coshare", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "1"}], "]"}], "]"}], "=", 
        RowBox[{"1950", "+", "i", "-", "2"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], 
     "\[IndentingNewLine]", 
     RowBox[{"coshare", "[", 
      RowBox[{"[", 
       RowBox[{
        RowBox[{"2", ";;"}], ",", "2"}], "]"}], "]"}]}], "=", 
    RowBox[{
     RowBox[{"craw", "[", 
      RowBox[{"[", 
       RowBox[{"2", ";;"}], "]"}], "]"}], "/", 
     RowBox[{"oraw", "[", 
      RowBox[{"[", 
       RowBox[{"2", ";;"}], "]"}], "]"}]}]}], ";"}], "*)"}]], "Input",
 CellChangeTimes->{{3.8482564041059575`*^9, 3.8482564289275064`*^9}, {
  3.8482564608487825`*^9, 3.8482564880310154`*^9}, {3.8514190609053783`*^9, 
  3.8514190773239756`*^9}},ExpressionUUID->"10552795-2732-47c5-b730-\
c01a4bfeab88"],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.8482914357883854`*^9, 3.848291451746818*^9}, 
   3.85141905958766*^9},ExpressionUUID->"bb0847b9-b18a-4f0d-944d-\
ebb18b401e2e"],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.8482916910351686`*^9, 3.848291823380331*^9}, {
   3.848291981885288*^9, 3.848292000238503*^9}, {3.8482920941239405`*^9, 
   3.8482920946269474`*^9}, {3.848292284443427*^9, 3.848292395134393*^9}, {
   3.84829245520426*^9, 3.8482925241626096`*^9}, 
   3.85141906503351*^9},ExpressionUUID->"816f3a26-9da9-49ad-ac72-\
6a563f995d63"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"figirr", "=", 
   RowBox[{"ListLinePlot", "[", 
    RowBox[{
     RowBox[{"rweight", "[", 
      RowBox[{"[", 
       RowBox[{
        RowBox[{"2", ";;"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "4"}], "}"}]}], "]"}], "]"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Blue", ",", "Thick"}], "}"}]}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<year\>\"", ",", "\"\<irr\>\""}], "}"}]}], ",", 
     RowBox[{
     "PlotLabel", "\[Rule]", 
      "\"\<capital-weighted internal rate of return\>\""}], ",", 
     RowBox[{"LabelStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{
        RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
        RowBox[{"FontSize", "\[Rule]", "14"}], ",", "Black"}], "]"}]}], ",", 
     " ", 
     RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.848254113104438*^9, 3.848254159719494*^9}, {
  3.8725123800257444`*^9, 3.8725123849145784`*^9}},
 CellLabel->
  "In[1797]:=",ExpressionUUID->"897230b6-ed0d-4ac4-99e6-8dde49b2fb39"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"figcapratio", "=", 
   RowBox[{"ListLinePlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Legended", "[", 
        RowBox[{
         RowBox[{"rweight", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "5"}], "}"}]}], "]"}], "]"}], ",", 
         RowBox[{"Placed", "[", 
          RowBox[{"\"\<With extrapolated data\>\"", ",", "Below"}], "]"}]}], 
        "]"}], ",", 
       RowBox[{"Legended", "[", 
        RowBox[{
         RowBox[{"coshare", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}], ",", 
         RowBox[{"Placed", "[", 
          RowBox[{"\"\<without extrapolated data\>\"", ",", "Below"}], 
          "]"}]}], "]"}], ",", 
       RowBox[{"Legended", "[", 
        RowBox[{
         RowBox[{"cr", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "172"}], "}"}]}], "]"}], "]"}], ",", 
         RowBox[{"Placed", "[", 
          RowBox[{"\"\<USA\>\"", ",", "Below"}], "]"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Blue", ",", "Black", ",", "Red"}], "}"}]}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<year\>\"", ",", "\"\<cap-output\>\""}], "}"}]}], ",", 
     RowBox[{"PlotLabel", "\[Rule]", "\"\<capital-output ratio\>\""}], ",", 
     RowBox[{"LabelStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{
        RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
        RowBox[{"FontSize", "\[Rule]", "14"}], ",", "Black"}], "]"}]}], ",", 
     " ", 
     RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.8482546289151073`*^9, 3.848254656328342*^9}, {
  3.8482924423768606`*^9, 3.848292447763236*^9}, {3.848292541242334*^9, 
  3.8482925663946705`*^9}, {3.848293343349703*^9, 3.848293354437584*^9}, {
  3.8482937251012535`*^9, 3.8482939257920218`*^9}, {3.8514191064673157`*^9, 
  3.8514191100105357`*^9}},
 CellLabel->
  "In[104]:=",ExpressionUUID->"ca607068-fc00-427e-9007-bbfc00b8d352"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"figalpha", "=", 
   RowBox[{"ListLinePlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Legended", "[", 
        RowBox[{
         RowBox[{"rweight", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "6"}], "}"}]}], "]"}], "]"}], ",", 
         RowBox[{"Placed", "[", 
          RowBox[{"\"\<With extrapolated data\>\"", ",", "Below"}], "]"}]}], 
        "]"}], ",", 
       RowBox[{"Legended", "[", 
        RowBox[{
         RowBox[{"rweight", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "7"}], "}"}]}], "]"}], "]"}], ",", 
         RowBox[{"Placed", "[", 
          RowBox[{"\"\<without extrapolated data\>\"", ",", "Below"}], 
          "]"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Blue", ",", "Black"}], "}"}]}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<year\>\"", ",", "\"\<alpha\>\""}], "}"}]}], ",", 
     RowBox[{"PlotLabel", "\[Rule]", "\"\<alpha\>\""}], ",", 
     RowBox[{"LabelStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{
        RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
        RowBox[{"FontSize", "\[Rule]", "14"}], ",", "Black"}], "]"}]}], ",", 
     " ", 
     RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.8482978381325464`*^9, 3.848297904737728*^9}, {
  3.851419120867751*^9, 3.851419125003811*^9}},
 CellLabel->
  "In[105]:=",ExpressionUUID->"d38e4f37-cf76-4c69-a1c9-c23080c2bec3"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Calculation of capital output ratio, to derive capital time series with the \
same prices as output
i.e. using current values with price level (pl_n*cn/(cgdpo*pl_gdpo)
cn: Capital services levels at current PPPs (USA=1)
cgdpo: Output-side real GDP at current PPPs (in mil. 2017US$)
pl_gdpo: Price level of CGDPo (PPP/XR), price level of USA GDPo in 2017=1
pl_n: Price level of the capital stock, price level of USA in 2017=1\
\>", "Section",
 CellChangeTimes->{{3.836542594258254*^9, 3.8365426333406935`*^9}, {
  3.8514179079447613`*^9, 3.8514179341607065`*^9}, {3.8514192021766233`*^9, 
  3.8514193548261733`*^9}, {3.8514195233812437`*^9, 3.851419527320367*^9}, {
  3.872824429795203*^9, 
  3.8728244505557384`*^9}},ExpressionUUID->"c735a4db-bf6e-40e3-8c46-\
0ecf8c885aa0"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"capPPPdat", "=", 
   RowBox[{"Import", "[", "\"\<cn_Transposed.csv\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"capPPPraw", "=", 
   RowBox[{"capPPPdat", "[", 
    RowBox[{"[", 
     RowBox[{"2", ";;"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pcapPPPdat", "=", 
   RowBox[{"Import", "[", "\"\<pl_n_Transposed.csv\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pcapPPPraw", "=", 
   RowBox[{"pcapPPPdat", "[", 
    RowBox[{"[", 
     RowBox[{"2", ";;"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"outputPPPdat", "=", 
   RowBox[{"Import", "[", "\"\<cgdpo_Transposed_adj.csv\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"outputPPPraw", "=", 
   RowBox[{"outputPPPdat", "[", 
    RowBox[{"[", 
     RowBox[{"2", ";;"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"poutputPPPdat", "=", 
   RowBox[{"Import", "[", "\"\<pl_gdpo_Transposed_adj.csv\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"poutputPPPraw", "=", 
   RowBox[{"poutputPPPdat", "[", 
    RowBox[{"[", 
     RowBox[{"2", ";;"}], "]"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.8489775280449123`*^9, 3.848977528464863*^9}, {
   3.8489775907050734`*^9, 3.8489775986577673`*^9}, 3.851419991655684*^9, {
   3.8514202158677807`*^9, 3.8514202250477543`*^9}},
 CellLabel->
  "In[383]:=",ExpressionUUID->"25d03b5b-1c01-48e9-a2d2-5a2bef53afc9"],

Cell[BoxData[
 RowBox[{
  RowBox[{"pinvraw", "=", 
   RowBox[{"Import", "[", "\"\<pl_i_Transposed.csv\>\"", "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.8514952257522197`*^9, 3.851495238040654*^9}},
 CellLabel->
  "In[391]:=",ExpressionUUID->"a758f683-cd4a-47d8-bdbb-c666b7f3c6a4"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Dimensions", "[", "capPPPraw", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Dimensions", "[", "pcapPPPraw", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Dimensions", "[", "outputPPPraw", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Dimensions", "[", "poutputPPPraw", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Dimensions", "[", "pinvraw", "]"}]}], "Input",
 CellChangeTimes->{{3.848978174511667*^9, 3.848978195798887*^9}, {
  3.848980922418482*^9, 3.8489809451742835`*^9}, {3.8514952504561224`*^9, 
  3.851495259929249*^9}},
 CellLabel->
  "In[392]:=",ExpressionUUID->"7fbd6e72-f344-4aaf-8b1c-5b9eda17c45d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"71", ",", "181"}], "}"}]], "Output",
 CellChangeTimes->{
  3.848978196506974*^9, 3.848978252354085*^9, {3.8489809460067625`*^9, 
   3.84898095094907*^9}, 3.849019297305234*^9, 3.8495401909920645`*^9, 
   3.851420328381179*^9, 3.8514952607133274`*^9, 3.872514830515725*^9, 
   3.8730109059593725`*^9, 3.8744805103995094`*^9},
 CellLabel->
  "Out[392]=",ExpressionUUID->"94ead80a-eb68-42a2-ba2f-84fcfbcd0408"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"71", ",", "181"}], "}"}]], "Output",
 CellChangeTimes->{
  3.848978196506974*^9, 3.848978252354085*^9, {3.8489809460067625`*^9, 
   3.84898095094907*^9}, 3.849019297305234*^9, 3.8495401909920645`*^9, 
   3.851420328381179*^9, 3.8514952607133274`*^9, 3.872514830515725*^9, 
   3.8730109059593725`*^9, 3.8744805104025*^9},
 CellLabel->
  "Out[393]=",ExpressionUUID->"26c26a3c-5121-481e-a48a-8d02d8d5f532"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"71", ",", "184"}], "}"}]], "Output",
 CellChangeTimes->{
  3.848978196506974*^9, 3.848978252354085*^9, {3.8489809460067625`*^9, 
   3.84898095094907*^9}, 3.849019297305234*^9, 3.8495401909920645`*^9, 
   3.851420328381179*^9, 3.8514952607133274`*^9, 3.872514830515725*^9, 
   3.8730109059593725`*^9, 3.874480510406493*^9},
 CellLabel->
  "Out[394]=",ExpressionUUID->"0c2f6e71-7635-42e5-b70a-e3bddee35353"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"71", ",", "184"}], "}"}]], "Output",
 CellChangeTimes->{
  3.848978196506974*^9, 3.848978252354085*^9, {3.8489809460067625`*^9, 
   3.84898095094907*^9}, 3.849019297305234*^9, 3.8495401909920645`*^9, 
   3.851420328381179*^9, 3.8514952607133274`*^9, 3.872514830515725*^9, 
   3.8730109059593725`*^9, 3.874480510410897*^9},
 CellLabel->
  "Out[395]=",ExpressionUUID->"fff3c355-425b-45ec-ae51-5ec86f316685"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"71", ",", "184"}], "}"}]], "Output",
 CellChangeTimes->{
  3.848978196506974*^9, 3.848978252354085*^9, {3.8489809460067625`*^9, 
   3.84898095094907*^9}, 3.849019297305234*^9, 3.8495401909920645`*^9, 
   3.851420328381179*^9, 3.8514952607133274`*^9, 3.872514830515725*^9, 
   3.8730109059593725`*^9, 3.874480510413888*^9},
 CellLabel->
  "Out[396]=",ExpressionUUID->"21693b02-bb6a-4d3a-8176-4cba4a74b15f"]
}, Open  ]],

Cell["\<\
Calculation for Germany and the US for demonstration purposes\
\>", "Text",
 CellChangeTimes->{{3.8725149029752684`*^9, 3.8725149297488565`*^9}},
 FontSize->16,ExpressionUUID->"1e632f57-2ca2-48c9-a44f-04c70d1eb590"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ncapPPPUSA", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "71"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "2"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ncapPPPUSA", "[", 
    RowBox[{"[", "1", "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"\"\<year\>\"", ",", "\"\<ncap\>\""}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ncapPPPUSA", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "1"}], "]"}], "]"}], "=", 
   RowBox[{"capPPPraw", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "1"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ncapPPPUSA", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "2"}], "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"pcapPPPraw", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", "172"}], "]"}], "]"}], "*", 
    RowBox[{"capPPPraw", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", "172"}], "]"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"noutPPPUSA", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "71"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "2"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"noutPPPUSA", "[", 
    RowBox[{"[", "1", "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"\"\<year\>\"", ",", "\"\<ncap\>\""}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"noutPPPUSA", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "1"}], "]"}], "]"}], "=", 
   RowBox[{"outputPPPraw", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "1"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"noutPPPUSA", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "2"}], "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"poutputPPPraw", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", "172"}], "]"}], "]"}], "*", 
    RowBox[{"outputPPPraw", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", "172"}], "]"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ncapPPPDEU", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "71"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "2"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ncapPPPDEU", "[", 
    RowBox[{"[", "1", "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"\"\<year\>\"", ",", "\"\<ncap\>\""}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ncapPPPDEU", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "1"}], "]"}], "]"}], "=", 
   RowBox[{"capPPPraw", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "1"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ncapPPPDEU", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "2"}], "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"pcapPPPraw", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", "48"}], "]"}], "]"}], "*", 
    RowBox[{"capPPPraw", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", "48"}], "]"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"noutPPPDEU", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "71"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "2"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"noutPPPDEU", "[", 
    RowBox[{"[", "1", "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"\"\<year\>\"", ",", "\"\<ncap\>\""}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"noutPPPDEU", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "1"}], "]"}], "]"}], "=", 
   RowBox[{"outputPPPraw", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "1"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"noutPPPDEU", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "2"}], "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"poutputPPPraw", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", "48"}], "]"}], "]"}], "*", 
    RowBox[{"outputPPPraw", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", "48"}], "]"}], "]"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.8489790379992247`*^9, 3.848979089945797*^9}, {
  3.848979184766255*^9, 3.8489792921955166`*^9}, {3.8514203487815604`*^9, 
  3.851420356018678*^9}},
 CellLabel->
  "In[397]:=",ExpressionUUID->"dfc6e64a-500e-48b6-bf82-9541cc7d40fe"],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.852998365372102*^9, 
  3.8529984011781535`*^9}},ExpressionUUID->"bb873d8c-de28-4583-af1d-\
5f42dc6bdd3f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"capsnap", "=", 
  RowBox[{"ListLinePlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Legended", "[", 
       RowBox[{
        RowBox[{"capraw", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "172"}], "}"}]}], "]"}], "]"}], ",", 
        "\"\<USA, PPP constant\>\""}], "]"}], ",", 
      RowBox[{"Legended", "[", 
       RowBox[{
        RowBox[{"capPPPraw", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "172"}], "}"}]}], "]"}], "]"}], ",", 
        "\"\<USA, PPP current\>\""}], "]"}], ",", 
      RowBox[{"Legended", "[", 
       RowBox[{
        RowBox[{"ncapPPPUSA", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}], ",", 
        "\"\<USA, PPP nominal\>\""}], "]"}], ",", 
      RowBox[{"Legended", "[", 
       RowBox[{
        RowBox[{"capraw", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "48"}], "}"}]}], "]"}], "]"}], ",", 
        "\"\<DEU PPP constant\>\""}], "]"}], ",", 
      RowBox[{"Legended", "[", 
       RowBox[{
        RowBox[{"capPPPraw", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "48"}], "}"}]}], "]"}], "]"}], ",", 
        "\"\<DEU PPP current\>\""}], "]"}], ",", 
      RowBox[{"Legended", "[", 
       RowBox[{
        RowBox[{"ncapPPPDEU", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}], ",", 
        "\"\<DEU PPP nominal\>\""}], "]"}]}], "}"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Blue", ",", 
       RowBox[{"{", 
        RowBox[{"Blue", ",", "Dashed"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Blue", ",", "Dotted"}], "}"}], ",", "Black", ",", 
       RowBox[{"{", 
        RowBox[{"Black", ",", "Dashed"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Black", ",", "Dotted"}], "}"}]}], "}"}]}], ",", " ", 
    RowBox[{"PlotLabel", "\[Rule]", "\"\<Capital Stocks USA versus DEU\>\""}],
     ",", 
    RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.84897910884871*^9, 3.8489791746389275`*^9}, {
  3.848979298038895*^9, 3.848979317057916*^9}, {3.848979507424108*^9, 
  3.8489795832248726`*^9}, {3.8489811280276937`*^9, 3.8489813003098297`*^9}, {
  3.848981397342231*^9, 3.8489814200240955`*^9}, {3.848982560851529*^9, 
  3.8489825795411386`*^9}, {3.8489826169371595`*^9, 3.8489826430619907`*^9}, {
  3.849503982628955*^9, 3.849503990508624*^9}, {3.8514203738896055`*^9, 
  3.8514203986076913`*^9}},
 CellLabel->
  "In[413]:=",ExpressionUUID->"7b1ba76f-1e47-4d49-8d9c-fb14ead5c15a"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{}, {{{}, {}, 
       TagBox[{
         Hue[0.67, 0.6, 0.6], 
         Directive[
          PointSize[
           NCache[
            Rational[1, 90], 0.011111111111111112`]], 
          AbsoluteThickness[1.6], 
          RGBColor[0, 0, 1]], 
         LineBox[CompressedData["
1:eJwt011IU2EYwPFDOUwQFhh9KhiEZA2yWGm0iwkRFoIiXnRhNXPOaZY2t5w2
9VSzNvNjkVCLarvwIkPRQNBAakRioA4vJCRa7CKiMKRAykAse//PgZ3x43ne
5+OFs/diQ1n1Jk3TTm38/v+rx/vUuvGOeUz2QmWfcvbpebGOe/Vq7FeOthU5
cEDZVpJag7uV9Y6EOER8+IUT91NvTq/FD+mfb6nDj5W1jNxLOKqc7DHW4wFl
a5N2GT/De4xX8BD1V80NeJR5TZZGPEb9rGXxBD44dBVPkr/5ggvHqN+5vQm/
ZZ6aWfE75p+sdeNZ6rnSPHie/cdeixeIe4PX8CIuPtqMP9L/27g4Sf+pMi/+
TP5vYwv+Srzqp/g79+/51Ip/cB/awHW8wvy5dh9exbvXxWvUN4y0YS2izh95
0o5TlGMzkQ68BX8p1XG6crQ1Lt6KJ87cwNuUk+Zp8U68fvwmzlS2HXggzqZ+
+I94X4T7qLqF95P/fFFsUtYPlftxHv3DCbGZfSpdnbiAeud33cYW8s/FxVby
HV138EllLf9wABdx/tEbcTHxvIogLuX8S0MXLiff+kp8lv1PuO/iCvaN7+jG
Nub5Gxbb2e/eB7GT+K/MHlxPfYdT3Eh+cErsZr5ETi/2cn7wvthH/6ihT75/
7rfFI/ZTb3xJHGD+98dC8v3j1OZQ4T+Y3vVU
          "]]}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$138555, {1}}]& ], 
       TagBox[{
         Hue[0.9060679774997897, 0.6, 0.6], 
         Directive[
          PointSize[
           NCache[
            Rational[1, 90], 0.011111111111111112`]], 
          AbsoluteThickness[1.6], 
          RGBColor[0, 0, 1], 
          Dashing[{Small, Small}]], 
         LineBox[CompressedData["
1:eJwt019IU3EUwPFLaBkI7iH6Az4sELMwatBCQ3RGVEQPJvYXwVFbzbL8t+XN
llu2dNqqlYEF1fawhwIjH4z1IG5IpQ+yDIKkLPbgg1BEQkJFVHa+58Lu+HDO
+Z1zfnDXH2+udS8zDGP30u//vzzmQ8fS2zpY6qoW+8XxzGt1UBxMBdw4RLxz
z0kcFjvty0/hiNg4NKuOih2+YQ++w3mhQCO+S312x2l8n/onG87gOF4oaMIJ
cTZpnMWPiDcUnMND9Cu2N+NhXFXRgkeYf/NX9XPi5UOteBRbGtpwmn63Vrfj
F8S9U+pJ5p9s9OIp9uta6cPT3O94Sv2W/J6+83iG84/ZO/As+YtJdZZ+b2pN
PMe+OZYLeB63Lqi/0L/7Uyf+xr75iYv4uzhtc/nxD+LWP+rf9Fvx9BI2YjLP
lgddOEfseBUL4DyxMVcTxPnYzKgt4vizfZfxKrHTNqFeK07/Ku/GhbhoUG0V
Zwd+qovonzpxBZcwX2JGXUp+SV0Ib6X/7Y/qbfQ/2nYVlxE/uK4HV4iDBzJq
B+cf7u/Fu9hvoy2M99IvMq7eT/2m+j5cQ79kbj+uo37nmPoIrvRew/XMM70m
gp3cx997ahf50fdqD/HFwuu4iXndHnUL8/W+VHuZ70PxDWxyn48H1H7yY7k3
9fvHpk8doj75WR1mv3fbo/r9c15eR7T6H2mN9KI=
          "]]}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$138555, {2}}]& ], 
       TagBox[{
         Hue[0.1421359549995791, 0.6, 0.6], 
         Directive[
          PointSize[
           NCache[
            Rational[1, 90], 0.011111111111111112`]], 
          AbsoluteThickness[1.6], 
          RGBColor[0, 0, 1], 
          Dashing[{0, Small}]], 
         LineBox[CompressedData["
1:eJwt03tM01cUB/CKwkimGb7LwqZkovgYSO0UZ8UvQrsiDQJixMDQblgmqx0w
BGQNMMNGMQIVphLLziHoDAtqfODwgUB8LHuYUaOiROb4Q0QmyrKxDTIY6zy/
m9zcfO65uefeP76B732UuMNLpVIZPPP/9cUoICQcOJldkLI08oXthKsfXhmM
Gg8RlxC2/6Axv2FdLi4lTO5ca/hKHSZ2EMKSO/x9WPF+wtd19dpFrBE7CQst
e/4y5WvFXxASL615oOt4S1xLcJ0K0/0YvVJc5+l3q17fqF0lridEzVldnukb
Lj5GCEgwP7f2Km4kTIp+OdE5vlp8gmCrHI4vm7ZGfJowuP6cIWmXTtxMCAqt
yTNtiRBf8Nx/LPbwpq0QtxL0vwe36T+LFHcQOr0f7VzsFyW+Tugd9tXceEkv
/o5QcrLR3XTbIL5JOB/uXdw3PUbsJtxQt/dlu2LFdwjZAf41t9vjxPcJbUuN
efozCeIegle5rWdoUpK4l1C4/kT/waObxY887+sITG0LSRY/Icy2jY41lKaI
BwnP5mZezrVvE/9GKN5rWrj1F7N4mDA2A/lGTbp4hNA953GldmiHeIzQdK21
tqjFIlYxlvx5NuPcHxniKQxHxMZ7qzbuFPsyds10VUz0ZoqnMqjtUNqbhVax
H8P+fXjcrDibeBZDnVrV0O6fJVYzQhoGNgX9rTiAEWvWDD38Mls8n7HuSdPo
6JIc8QJG9QwvS//ij8XBjAleVteyNle8jKE18qfNn+wWL2cEJvzza3VpnljL
uOW+MPb4m3xxOKPBYExrnr5HrGMMBFS94zxaKAbj9bdrHe4iuziakfb+lfln
LUViIyM9dN+Is7tYbGKMFB8pvP+gRBzPsB032+1xe8VJjPGJgXkFEaXiZEaG
X6t7S/Dn4lRGVs6K9LtpZeLtDNezn4+nqB3idIbKfCi1v1+pf8B4pae774yP
Urcy3o2PiZl7UXGW57/eK3zWUbk4l9H46uV5D7/dJy5gbOhqvdeVs1/Jv+e8
ZeVPN/MrlPwz9K85Qit2Vyr59/T37LY8rVLyz/h3Qdk03y6nkn+GKciq63Qd
iPwP6z9a0g==
          "]]}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$138555, {3}}]& ], 
       TagBox[{
         Hue[0.37820393249936934`, 0.6, 0.6], 
         Directive[
          PointSize[
           NCache[
            Rational[1, 90], 0.011111111111111112`]], 
          AbsoluteThickness[1.6], 
          GrayLevel[0]], 
         LineBox[CompressedData["
1:eJwt019IU2EYx/GjKAgFaWXZn4sVBhaVXQQFFZ35ZykzsqllanXmZlmZbhk4
w2BTLywWBEV0EbqLyIIVRguFoiZKJHRhJf2hILEaNgq66MJkF9nzfQ6cc/jw
vO/z/t73cNY1trma0g3DcCzc/99yBfrNhWfEKt1jF3eJp28c2IuD+MEnE/eK
TfeSItzH/JlAMQ7jpa2l+CrOO7YPX2d+0lGOb4ptk+ud+JY4+KhuP46IjY5F
lfg2eQY9B/FdcXzFExeOUn87X4WH6HfYX4Nj5Jn4ewiP4HRvLX7K+F0XjuA4
+V48r8Pj5LlT1IBf4oFfR/Er1n937zieFFuOIQtP4ZJuN/6Avxc04s+sPzGs
niZfyOnB39jvaEI9i2suefFP+m3c0YR/U8+YUf/h/IO+E3iO+mBCnWK/ue6T
2BiQ/cxPqTPEZkVxM84SRx7H1IvFwfCGUzhbHI9G1Mtx9dbTOE9sW/lavZZ+
ORfPYBvj3xS24HzqnePqArE14jmLN1NPptTbqP+40oq349FVbXgn+5m7r95N
/kS+D5u4yq8uoX//Q3UZ+ca+qCvw6iw/rtR8W9TVzH/vUtdyvh971A2MTw6r
LbERTaq95LmWeQ43U8/epG6h/1i92kce52X1eZwbUwdYb81XdRfzvcva9f8n
n71c3cv4jpC6j35pz9Rhvmco1W7/B5Wf+ZE=
          "]]}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$138555, {4}}]& ], 
       TagBox[{
         Hue[0.6142719099991583, 0.6, 0.6], 
         Directive[
          PointSize[
           NCache[
            Rational[1, 90], 0.011111111111111112`]], 
          AbsoluteThickness[1.6], 
          GrayLevel[0], 
          Dashing[{Small, Small}]], 
         LineBox[CompressedData["
1:eJwt019IUwEUx/GLJCT5YNFfMlAy8GHQHoqWGtz5Z4iJqcw/U8u1nGmlW87K
wGCCqQ/DDCJ8EF0QYRBUq6SHgj1UWO3B/kA+CI6wEpHw4dJEeijP9wzG5cM5
v3POZSzXF6j1pxmG4fr/3XzKp2/S3Hz8tDmc4n5xPPjlOA6Lo83zhXiQ/om5
E3hEHK7fYeII9dyYE4+Jvb6aEnwHf14sxePkt7W58ATuKSjHUXFO3o0KfJ/7
PM8q8bTYvPm7Cj/i3gfhavyE/ukXNfi5OLnnTy1+ST22z41fcd8xSx3nfTpT
dfgN8xftDXiW/VcfNuIE938PefAc8yNu9Vfc+0P753m/o7fVC8y3fVAnucca
0/wS/Rv3mvAy9z1+14xXqaenncZr5EvW1Rb7bwXO4HXsOKX+S37W0n5jStz+
Ub1FbBTv0v6tYjOVUGdi+6dWnCWO50968U7qTUNn8V7mzdz14Wz2ZSTO4Ryx
tyzTj/PIHzjUjvPFSdf+89jGvOG3ajv70ws68BHqDSmtO8jXx9VFeOW62uQe
67C6VBxu/ab7y5k/4FFXcl/LL3U1+YMXNO8mP2WpG3HZ+07cQr5w+CL2kvcX
d+E27h/t7sYd1DfGA/iS3hMI4iDzZ05exr3iaGx3D+6jv2tB3a/zt4f0/0+/
WaEe5Pe4NqAeYf7rp+oI+StrIec/m0HvJQ==
          "]]}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$138555, {5}}]& ], 
       TagBox[{
         Hue[0.8503398874989481, 0.6, 0.6], 
         Directive[
          PointSize[
           NCache[
            Rational[1, 90], 0.011111111111111112`]], 
          AbsoluteThickness[1.6], 
          GrayLevel[0], 
          Dashing[{0, Small}]], 
         LineBox[CompressedData["
1:eJwt0A1MFGQYB3CCA2nQAIUDJgSduBiQnbt0eLvgz8BQD43pgYExTJGhAXcy
JlS3EEbjQlgffoCCzxMoTYdkfsTYoKIV5IwaZnPiCMzpRNYukA9JiLp43nd7
9+63Z+//ed73hT3W7fvc3dzcXnPt/8+lVU7o1hSMx/pMYMl2Qs66AP3nn06J
DxMmyxL+NXTNiKsJs14/dne2z4odhKiBNZaFqjlxHSEp0n26Mm9e/DEh4mxi
Wef0ovgYoe+h9lKd9ZmkJTcSHh/p6D2a5CFuJmTooivz/T3FnxHaKpwn25uW
ic8S3jXPZF0s8RWfIzz3x9TBpv3+4gsEh94U1KpdLv6S4M0f7A9aFyi+Sqi8
4fPqiiatuIuQXRGwusYcIu4hTFBNniE4VNxLuFZW/v3Jd1aKfyC0rFm/oT8/
QnyNcCd3/MzOM6vEA4TgTP9bh5pfFA8SOhpjDVU9ceLfXPM+8LjRHWMQ3yYY
+wtPh1WsFw8TQouMP2V/HS++SyhdtSlwMdwovk84n/leSWpugniMUO1I15i2
JYv/JCRuPNo235IqniAc+ttevXatWTxNWB3UVRt1WdXnCObAKXtMsvIC4Zun
d372TFB2YzRn5RtS+jaKNYzIp++P1F9X9maYvUa/wOw2sS/jSv381tTSHWJ/
RtaIcWR4wCIOZNzU7py8ckQ5hHHK4/yjvX7Z4jDGPc0nzgMHd4kjGS/3fOtc
cSpXHMWIsC74OduVoxk5lmNfxQ7sFse58pvdZ8y/7hXrGbrc1vv6LcqvMBK1
Y8706LfE8YxWy+st1hRlE2NoVNdQfEvlgeGbsdlr6z854hTX+z+sMYd3KG9i
mBZbK7QfqXnSGAX2+snbYapfOuN3v6tp52r3iS2M4YC/0vK888VvMH4xOU36
ceU3GXPJdxv2lBwQ72b0XgzX1dqKxHkMx8TQdZ/SQnGB6z92BXUbv3tbXMg4
/WRZW0tisdjGeHA8tHPIU90vZdgeZtATjVVczojv18XddCrbGc/HvDRYWKvy
DjP6RgetydGqXzUjpKqosSFY5TsYVZfH3LtO2MR1jEuZxc8+rrcl/QezClY5

          "]]}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$138555, {6}}]& ]}, {
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$138555, {1}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$138555, {2}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$138555, {3}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$138555, {4}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$138555, {5}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$138555, {6}}]& ]}, {
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$138555, {1}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$138555, {2}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$138555, {3}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$138555, {4}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$138555, {5}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$138555, {
          6}}]& ], {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, {
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$138555, {1}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$138555, {2}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$138555, {3}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$138555, {4}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$138555, {5}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$138555, {
          6}}]& ], {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}}, {{}, \
{}}}, {DisplayFunction -> Identity, DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {1948.5625, 0}, DisplayFunction :> 
     Identity, Frame -> {{False, False}, {False, False}}, 
     FrameLabel -> {{None, None}, {None, None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> 600, 
     Method -> {
      "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
       "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& )}}, PlotLabel -> 
     FormBox["\"Capital Stocks USA versus DEU\"", TraditionalForm], 
     PlotRange -> {{1948.5625, 2019.}, {0, 7.385595110561103*^7}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.05]}}, Ticks -> {Automatic, Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{
      "\"USA, PPP constant\"", "\"USA, PPP current\"", "\"USA, PPP nominal\"",
        "\"DEU PPP constant\"", "\"DEU PPP current\"", "\"DEU PPP nominal\"", 
       "None", "None", "None", "None", "None", "None"}, "LineLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1], 
                    Dashing[{Small, Small}]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1], 
                    Dashing[{Small, Small}]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1], 
                    Dashing[{0, Small}]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1], 
                    Dashing[{0, Small}]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #4}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0], 
                    Dashing[{Small, Small}]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0], 
                    Dashing[{Small, Small}]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #5}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0], 
                    Dashing[{0, Small}]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0], 
                    Dashing[{0, Small}]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #6}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 0, 1], Editable -> False, Selectable -> 
                    False]}], "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 0, 1], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"Small", ",", "Small"}], "}"}], "]"}]}], "]"}], 
                   ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 0, 1], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "Small"}], "}"}], "]"}]}], "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False], 
                    ",", 
                    RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"Small", ",", "Small"}], "}"}], "]"}]}], "]"}], 
                   ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False], 
                    ",", 
                    RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "Small"}], "}"}], "]"}]}], "]"}]}], 
                 "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 0, 1], Editable -> False, Selectable -> 
                    False]}], "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 0, 1], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"Small", ",", "Small"}], "}"}], "]"}]}], "]"}], 
                   ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 0, 1], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "Small"}], "}"}], "]"}]}], "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False], 
                    ",", 
                    RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"Small", ",", "Small"}], "}"}], "]"}]}], "]"}], 
                   ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False], 
                    ",", 
                    RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "Small"}], "}"}], "]"}]}], "]"}]}], 
                 "}"}]}], "}"}], ",", 
           RowBox[{"{", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{#, ",", #2, ",", #3, ",", #4, ",", #5, ",", #6}], 
                 "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{#7, ",", #8, ",", #9, ",", #10, ",", #11, ",", #12}],
                  "}"}]}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"None", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"None", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"None", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"None", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"None", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"None", ",", "Automatic"}], "}"}]}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], 
               "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   
                   RowBox[{
                    "True", ",", "True", ",", "True", ",", "True", ",", 
                    "True", ",", "True"}], "}"}], ",", 
                 RowBox[{"{", 
                   
                   RowBox[{
                    "True", ",", "True", ",", "True", ",", "True", ",", 
                    "True", ",", "True"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.84897917563501*^9, 3.848979317972875*^9, {3.848979556724845*^9, 
   3.848979585351742*^9}, 3.848981152974907*^9, 3.8489811863134003`*^9, {
   3.8489812171301794`*^9, 3.848981221885295*^9}, {3.848981278282774*^9, 
   3.848981304643179*^9}, {3.8489814029034595`*^9, 3.848981421043579*^9}, 
   3.848982581317916*^9, 3.8489826439152594`*^9, 3.8490193406580286`*^9, 
   3.8491168244470997`*^9, {3.849503970983718*^9, 3.8495039949594707`*^9}, 
   3.851420409331274*^9, 3.872514983645316*^9, 3.872566644450828*^9, 
   3.8730109101073236`*^9, 3.874480514729766*^9},
 CellLabel->
  "Out[413]=",ExpressionUUID->"e2d9f3be-afef-4153-90f7-19dc2a3f5682"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<fcapsnapUSADEU.tiff\>\"", ",", "capsnap"}], "]"}]], "Input",
 CellChangeTimes->{{3.849503997908141*^9, 3.8495040159013886`*^9}},
 CellLabel->
  "In[634]:=",ExpressionUUID->"4db49b3d-70e5-4b16-a993-0b53c9fc141e"],

Cell[BoxData["\<\"fcapsnapUSADEU.tiff\"\>"], "Output",
 CellChangeTimes->{3.84950401803782*^9},
 CellLabel->
  "Out[634]=",ExpressionUUID->"7abf56d3-7481-4467-8741-1806fb702a3e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"outputsnap", "=", 
  RowBox[{"ListLinePlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Legended", "[", 
       RowBox[{
        RowBox[{"outraw", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "172"}], "}"}]}], "]"}], "]"}], ",", 
        "\"\<USA, PPP constant\>\""}], "]"}], ",", 
      RowBox[{"Legended", "[", 
       RowBox[{
        RowBox[{"outputPPPraw", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "175"}], "}"}]}], "]"}], "]"}], ",", 
        "\"\<USA, PPP current\>\""}], "]"}], ",", 
      RowBox[{"Legended", "[", 
       RowBox[{
        RowBox[{"noutPPPUSA", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}], ",", 
        "\"\<USA, PPP nominal\>\""}], "]"}], ",", 
      RowBox[{"Legended", "[", 
       RowBox[{
        RowBox[{"outraw", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "48"}], "}"}]}], "]"}], "]"}], ",", 
        "\"\<DEU PPP constant\>\""}], "]"}], ",", 
      RowBox[{"Legended", "[", 
       RowBox[{
        RowBox[{"outputPPPraw", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "49"}], "}"}]}], "]"}], "]"}], ",", 
        "\"\<DEU PPP current\>\""}], "]"}], ",", 
      RowBox[{"Legended", "[", 
       RowBox[{
        RowBox[{"noutPPPDEU", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}], ",", 
        "\"\<DEU PPP nominal\>\""}], "]"}]}], "}"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Blue", ",", 
       RowBox[{"{", 
        RowBox[{"Blue", ",", "Dashed"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Blue", ",", "Dotted"}], "}"}], ",", "Black", ",", 
       RowBox[{"{", 
        RowBox[{"Black", ",", "Dashed"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Black", ",", "Dotted"}], "}"}]}], "}"}]}], ",", " ", 
    RowBox[{"PlotLabel", "\[Rule]", "\"\<Output USA versus DEU\>\""}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.848981461685177*^9, 3.848981517202166*^9}, {
  3.848982682743218*^9, 3.8489827011616077`*^9}, {3.8489827891178746`*^9, 
  3.848982866877036*^9}, {3.8495040305069923`*^9, 3.8495040361042786`*^9}, {
  3.85142055607794*^9, 3.85142058266166*^9}},
 CellLabel->
  "In[414]:=",ExpressionUUID->"2dacfd25-569f-4c82-8456-89f86918cbc3"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{}, {{{}, {}, 
       TagBox[{
         Hue[0.67, 0.6, 0.6], 
         Directive[
          PointSize[
           NCache[
            Rational[1, 90], 0.011111111111111112`]], 
          AbsoluteThickness[1.6], 
          RGBColor[0, 0, 1]], 
         LineBox[CompressedData["
1:eJwt011IU2EYwPFDKXmREBEVsWSDiAURJmKD5txqmpTGMlerZi4/cuVS1yqW
eDHSQkjIogsHI4d6kZga1YVgFwOzDxhkFNVFF2Ilg7wwEDGoyJ7/c+Ccw4/n
432fF15LXWtV4xrDMMpW3/9/eaIPnKvfwN13B1ziDrGR9rpxjPirXaW4Szxr
spbhbnHSnKPuoX4mfgj3Uj+wrRzfJ34noe4Tx+wt6gT+sf0wTlLveaMewlej
R/BDsTm+sxI/Yn9dzUfxY/bn2ezBz+j/13IMT1C/52AVfk7/yJQ6hV3jx/EL
fKuyGr+mv+FTp+l/c60XzxAP5Z3AH5jfdPYk/oxfFqu/0L9nr3pWnIqGffgb
872/dwpncNGf03hB7Fz5dAYvMt/ItHqJ/Wxp9+MV8oeXNf6b/LeOGmz0S/+4
vxZn4TFvAOfg9nn1erHT2nEObxCbLfvq8CZxqn5OvVUc6C2uxya836Y249vf
1TvExlS4AVtxv7sR72b96Y/qfNYbGz6PC9nPk5EmbBPHXJNBbKdfQeYCdpK/
+OsidhOfczTjcuI1E+oKzqOpM4Q9rP+07xKuZp6vAy3YR376Riv24425bTjA
PNfWqRvEyUmH5gfpP5+t8RD1naXqNtazDaqvUD/6Ux2lf0ltWO8/9dkZdYz8
60WX9f6Tbx9Ud+PCgojef84zmIi4/gHth+6R
          "]]}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$138917, {1}}]& ], 
       TagBox[{
         Hue[0.9060679774997897, 0.6, 0.6], 
         Directive[
          PointSize[
           NCache[
            Rational[1, 90], 0.011111111111111112`]], 
          AbsoluteThickness[1.6], 
          RGBColor[0, 0, 1], 
          Dashing[{Small, Small}]], 
         LineBox[CompressedData["
1:eJw101tIk2EYB/CPuTmLLLPDmi79tqSi7AQyKszeYA21RatFZRYNXRAd0FBI
YsQoQS8GKXQRFe8rEUvKLMTI2hiDDih04UXBLoyGumq2cpqJLQfV+38ajI8f
/+f0MWauazh0WqMoiv3v999Tflo4EzX5XY7JESbt5SxkmfuoN8VgH2ebKnSR
UN8o3MqZ7YNete8bg9thZo/Dfs5qvQt9L1PkDuSB4Gf4BnwlloBvwjX+r/Ad
uCP3G9yF/db4BHyPM4PQuANtVN+N/GE4Cfdw+TSdnYSfIP/UNAX3c5ZwZ0RT
lDyA+rvl03AI85295AjqM1k/4Vey3ucomoUHOVs9FN+9w/ULfot5gc3kYc7e
XCjzicI0/A75itsZOMrZmLUgsqEha4/0iDSb+aGBY9inm6V8HP3PKrTwF86u
j08Xb/zvJGcXC3PdmuxsOIV5923kGdQ/30WekxbdS3XwPOrXqGRFyLzvKFkr
5L2XHtO+HCHvc26h+xbBxhfkPNlfPHqS6pej/3c15aukWb2HchP6zyXJqpDv
k6jVwyWon+ile9bjPmsn1ZfKfmWqjfKtmFe1llyGfGc/eTvmX95L/eVw/RLK
Ge4vGVgA27DfE8yBKzHvoIXsQD50le51In9Qtxg+TPuql8HHcF/+rZXwCZmr
80+NsBv9RyqLYI80ywsXwGfQv86owuel3Z06C9yI/sYD5GbkVfvNcAv2GRQD
7JWODbvo9/EJ+X82N3+Xc5RWwdLvTWppahBuF6znUfTUcddr2C9YeJtWuZYO
sj+CbSIH
          "]]}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$138917, {2}}]& ], 
       TagBox[{
         Hue[0.1421359549995791, 0.6, 0.6], 
         Directive[
          PointSize[
           NCache[
            Rational[1, 90], 0.011111111111111112`]], 
          AbsoluteThickness[1.6], 
          RGBColor[0, 0, 1], 
          Dashing[{0, Small}]], 
         LineBox[CompressedData["
1:eJwt031I1AcYB3Ct7EUPl5LuJGXaLtFyvqCtiZLfa5bKWTpX1nXqNLVMa75c
L6fUVqKb2JtzrbnS5xnqSrR3FCtu6MIymqVB6VGKt7jITcmorKQ1Vz2/Bx4e
Pnz/e+DrszE/KXuanZ3dyrf77r4fE8EyW318VYyr9r13E/xG9Kd2LnQT7yWc
cGhsL8x0F5cR7PUvjamXPxRXEGpTjz8I6lN8gKDfMjwZ/8xDXEVYWcvO/Zvn
i48QVBO+9Zv+8RTXEGrqBiJd9V7iWsKFsNvLDX0fiX8lTPmfCYyr9BY3ErKw
s97P10fcRDDf/8X8OG+B+BTB2fvqmxmFH4vPEQaWFYf/ZdWIWwnjCaMtPo2+
4ouExRMeRbd7/cRmgqY/0PF6xCJxJ6GhNsql9HyAuIuQUXo4yawKEl8nDBd6
eP2cHizuIewpV70OuRYi7iOEJlRPlZeFiu8QOqe+dbF2LBFbCFWBH8yZf2Sp
eJBwzThzZlNbuNhKcB9Zbpt+NFJsI1g/7R736YoSjxAMUUOVL59oxWOEnBvG
x6VO0eInhH0NDkWne1aInxOai12d/9gVK3719t8Pn37TXxon/pfwff+hicuX
dGI7xq3EdHpxc7V4BoNsMSdiDyaKZzPWFf9u0Zm+EKsYxnbtaF55knguQ+0e
VNk2+aV4HmPHXbWboXytWM14YfR8k9GRLPZkbCvbktKzZ53Ym+FY0dq6b3i9
WMP4cfXTrl7/DWI/RkJF52RBj0EcwIhwfhV/XpMqDmbk/lRnHPkzTRzGONPs
NKpNSRd/xnitPbkgLC5DHMn4yq3jriltoxgMVUOdYdahTHE0Q3f07yuPArPE
sYzesTufqwYVxzP4eeug5V62OJEx4VSy1qzbLF7DyA4wHdg/lCNezzgdPaXO
1eeKUxjBV7u/q67KE6czNuW45NrP3SrOYoRmfvKD5rCS5zBKuv87llyj5FsZ
SdOq7/n+tk1cwMh74O94wfa1eDvD1rzCbci+QGxiZOxNO+vVrng3w979kqUt
q1DpP2NOy6gm36q4jPHuK5ENRUr/GQNndTEhTUal/4yx/Y/qLxZs1/4Pllhb
ag==
          "]]}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$138917, {3}}]& ], 
       TagBox[{
         Hue[0.37820393249936934`, 0.6, 0.6], 
         Directive[
          PointSize[
           NCache[
            Rational[1, 90], 0.011111111111111112`]], 
          AbsoluteThickness[1.6], 
          GrayLevel[0]], 
         LineBox[CompressedData["
1:eJw1011IU3EYx/HTi9VFF2FBBlEnrXwbMWXVlpZnaceXzIZINrCSUPBCyIsx
RkScIsjEqHRQ0FgjupBYpMygpGKIF11UGMQyKhgU0UWR1YIIpfL5Pg3G4cPv
/zz8zoH/puMnWrsXG4Zh//svPOUXiVsLj6hvg198SpytiJrYIQ+ahficOJF6
VIT7Od9ib8GD4nTf62J8WWz9HC3FUfb9qCnH18TmXNiFY3Fr5wW/+TW1DSeY
L0y68S08cKYCj4g7vx+qxEn6zWfUo3hykQePi53zru34Pn2HkuqH9Bv+7zR5
+6sdeIq+JWe9+An+kvThp8xnTu7C0/QLxqvwS32f2Wo8g/Mrd+O39Gv6pnmW
fX+O7cEfyO2uGvyJ759XbuHP9H2eUc/Sb2C1H+fYd6dM/YvzrevUc/QpPqo2
bkj/22/US/Faey9eIbYKxtQryd059SqxmT9Si9eIja29dbiA+fen9+H1Ymf+
qo1N9nmX1+PNzN98pnkJ87VBzV3MX7qndjMf+aj2kG9sa8BecfriC3U1fcON
jdhiv7GsCdexLy+sbiCP9aibcb1PHWBfWb+6jf7vHqgPixO/H+/HHezvHmrG
nZy/PqPuYn+RR8/34Kp2zXvxktAB3Me+K8PqEHlqXB3h/Sc6WvT+833GptUO
8zHnoN5/+vpKA3r/ye8eUQ+Ks7lQwP8XLVjjVA==
          "]]}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$138917, {4}}]& ], 
       TagBox[{
         Hue[0.6142719099991583, 0.6, 0.6], 
         Directive[
          PointSize[
           NCache[
            Rational[1, 90], 0.011111111111111112`]], 
          AbsoluteThickness[1.6], 
          GrayLevel[0], 
          Dashing[{Small, Small}]], 
         LineBox[CompressedData["
1:eJw10HtI01EUB/AfMvORo0XhAyfbohe9C3v8IfjFCiKEIowUk9kL7cWyDEyk
beEf0QOzJ5beY2VpFrZkqUnhipD1TvSPkGSjZmrOHBpu1mrVzu3C5fLhHr7n
3GvYadqyJ0JRlBV/978zvJwCRxYkKb1LKhH2a4G2KIPelH+e/V6goHu6I2Xx
BXaPwI7bI8Yk5SL7g8CJs8OulVHy/qNAaVbQVVR7ie0WSKtL1FvrL7M9Al3N
33S5Dlk/KNC5bzwU2yLzvAJFyWr3k3PSPoH+jH7j6W0y7zvfH6yRDghMtKrc
xrwr7KBAX8yEMaFJWiE8nhVwNRZKqwjdT3+kFzTKeaIJ5dX+kPWNdBxhrMpL
rf/zNATfKbc5uV16JoXz5zXI+kTCs01aVOTIebSEvZ9S3Dmp0npCyXpfR+Tc
KvZsQoVnTNe4vJY9n8LvUdtk3iJC5fjv9ONV19jLCAkUke+1y/6phECnRrk3
9Sp7DWGG9avODuk0gu2Vj5rU1WwQ0DHqylwlvY5ws3jIeGOr9AbCnMh4h+qF
7JfJ/9F1WLA3EzRHdRbPS2Jncf/nfjl/NmHXw0lz3oM69nZCblms5dGXW+x8
wrApxjGwv4G9m+CARv+5XdYXEmo2TrGUjlxnHyDYh6Ld8avr2Ye476D2DruY
EDEtTq+1SZcQmnuDHbFr77LLCIaBX2Znj41tIWS8/Rmy90mXExYunSSP/z77
JMF5LKQbbWphn+H6tnet+ANSIQqh
          "]]}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$138917, {5}}]& ], 
       TagBox[{
         Hue[0.8503398874989481, 0.6, 0.6], 
         Directive[
          PointSize[
           NCache[
            Rational[1, 90], 0.011111111111111112`]], 
          AbsoluteThickness[1.6], 
          GrayLevel[0], 
          Dashing[{0, Small}]], 
         LineBox[CompressedData["
1:eJwtzntM01cUB/Cf7YTyTHEYim7KwIIiVZwiRmB+GcLAFEWmFKcYXZwaI/II
bFqYwYAZ2fijZJgZnOdsgi8w8QFbVNT4YlbDMiIsA4fKoohVFCVVMSw4x7k3
ubn55HvOueeDz/Myv9Bpmpby9v7/jp3thP6rupwk3x6MuZRQfqYuMi32H3EZ
4du7WTb78XviCoJ+X3xs1ZQ+cSVhYneq82zDA3EVwWNe5+WofpfYQQgwG78q
PDAgriH8ELU2w3P+oHgvwTLzSMnwlWfiHwlZAbbQ2zlD4p8I3+cG78jb4xbX
E7y3LA7rKX0lPkI4mn/oo6WXX4uPEc61n7ozYB0RnyCkxbfV6LVRcTMhxNza
snKDljjm0wRn0Px6V+448TlC693+a38dVL5IaDc35bKXXnyVULLaUNa3f7zY
SbiSww3d2d7iNsKQv1+6R4W/uJ0wMyemMdM6QdxJuHVit+5khkncRUgpLnPd
s0wW9xC+sUSe8Rx6X9xLyJ4QV+A+PVV8n3Dp+cYLWZ+Gih8S6sIuRb/YGy4e
IPg1b56ysC9S/IxgTJgUV6JZxG7CyuTQjprc6eJhwtf5niHjmyLE/xL6Pr7D
EbuVNUZdUNCX/SFq/juM2ybHjM7PlA0MrdIwMuvpbLEvo/DJ4xs+f8wVGxlv
DDuWp6+PEQcyuhwtc7RVyiZGian+1k5DnPg9hq/XwmZ7Rbw4hDG51taYnwTx
NIb/hxfndNQuEk9n2N2WomM3VR7F2NUU7fQ6mySOZnSH3t/v8FOexwh+oPdC
r6pf8HYfcp/UTUwUxzMy1x81bTuvcjCiYj3bNh1KEC9mpL6s9JjUoJzKsL5b
v+ipQ+1jZVz3mRZm9FH/ZTBuTo0wDm5LFq9g/FIbNhrwq3I2Y/RGweE/O1LE
axiPng+3XgheIl7H2LpW12Uvtoo3MD4p753repwm3swYNxgeuMulvJVhK32T
aq1W9fmMjoTC77Jdal4R47cCR3W5XeXbGTG2vAXOn9PFpYzAZcbfzfvUvDJG
Q+yod3GR6q9gzN5ZnbzHpPorGebIkcaWhKXiKkZ4tP7vxOL0xP8AiD9MfQ==

          "]]}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$138917, {6}}]& ]}, {
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$138917, {1}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$138917, {2}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$138917, {3}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$138917, {4}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$138917, {5}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$138917, {6}}]& ]}, {
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$138917, {1}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$138917, {2}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$138917, {3}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$138917, {4}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$138917, {5}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$138917, {
          6}}]& ], {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, {
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$138917, {1}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$138917, {2}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$138917, {3}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$138917, {4}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$138917, {5}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$138917, {
          6}}]& ], {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}}, {{}, \
{}}}, {DisplayFunction -> Identity, DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {1948.5625, 0}, DisplayFunction :> 
     Identity, Frame -> {{False, False}, {False, False}}, 
     FrameLabel -> {{None, None}, {None, None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> 600, 
     Method -> {
      "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
       "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& )}}, PlotLabel -> 
     FormBox["\"Output USA versus DEU\"", TraditionalForm], 
     PlotRange -> {{1948.5625, 2019.}, {0, 2.1433226181529924`*^7}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.05]}}, Ticks -> {Automatic, Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{
      "\"USA, PPP constant\"", "\"USA, PPP current\"", "\"USA, PPP nominal\"",
        "\"DEU PPP constant\"", "\"DEU PPP current\"", "\"DEU PPP nominal\"", 
       "None", "None", "None", "None", "None", "None"}, "LineLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1], 
                    Dashing[{Small, Small}]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1], 
                    Dashing[{Small, Small}]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1], 
                    Dashing[{0, Small}]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1], 
                    Dashing[{0, Small}]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #4}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0], 
                    Dashing[{Small, Small}]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0], 
                    Dashing[{Small, Small}]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #5}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0], 
                    Dashing[{0, Small}]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0], 
                    Dashing[{0, Small}]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #6}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 0, 1], Editable -> False, Selectable -> 
                    False]}], "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 0, 1], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"Small", ",", "Small"}], "}"}], "]"}]}], "]"}], 
                   ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 0, 1], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "Small"}], "}"}], "]"}]}], "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False], 
                    ",", 
                    RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"Small", ",", "Small"}], "}"}], "]"}]}], "]"}], 
                   ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False], 
                    ",", 
                    RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "Small"}], "}"}], "]"}]}], "]"}]}], 
                 "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 0, 1], Editable -> False, Selectable -> 
                    False]}], "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 0, 1], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"Small", ",", "Small"}], "}"}], "]"}]}], "]"}], 
                   ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 0, 1], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "Small"}], "}"}], "]"}]}], "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False], 
                    ",", 
                    RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"Small", ",", "Small"}], "}"}], "]"}]}], "]"}], 
                   ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False], 
                    ",", 
                    RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "Small"}], "}"}], "]"}]}], "]"}]}], 
                 "}"}]}], "}"}], ",", 
           RowBox[{"{", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{#, ",", #2, ",", #3, ",", #4, ",", #5, ",", #6}], 
                 "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{#7, ",", #8, ",", #9, ",", #10, ",", #11, ",", #12}],
                  "}"}]}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"None", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"None", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"None", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"None", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"None", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"None", ",", "Automatic"}], "}"}]}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], 
               "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   
                   RowBox[{
                    "True", ",", "True", ",", "True", ",", "True", ",", 
                    "True", ",", "True"}], "}"}], ",", 
                 RowBox[{"{", 
                   
                   RowBox[{
                    "True", ",", "True", ",", "True", ",", "True", ",", 
                    "True", ",", "True"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{3.848981518188147*^9, 3.8489828850684624`*^9, 
  3.849019351439454*^9, 3.849117136731059*^9, 3.8495040371557136`*^9, 
  3.8514206032373533`*^9, 3.8725150365164747`*^9, 3.8725666481068697`*^9, 
  3.873010913218272*^9, 3.8744805176835265`*^9},
 CellLabel->
  "Out[414]=",ExpressionUUID->"002bba58-92a5-477d-aeb0-52ba62b407f3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<foutsnapUSADEU.tiff\>\"", ",", "outputsnap"}], "]"}]], "Input",
 CellChangeTimes->{{3.8495040435687046`*^9, 3.8495040796105285`*^9}},
 CellLabel->
  "In[636]:=",ExpressionUUID->"34f9ef09-87db-499a-b359-a0bfe9274e4c"],

Cell[BoxData["\<\"foutsnapUSADEU.tiff\"\>"], "Output",
 CellChangeTimes->{3.8495040811165085`*^9},
 CellLabel->
  "Out[636]=",ExpressionUUID->"17e15982-b9b2-4181-9ba3-e293ef9e5539"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ncapratio", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "71"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "7"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ncapratio", "[", 
    RowBox[{"[", "1", "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
    "\"\<year\>\"", ",", "\"\<USA_cMERcap\>\"", ",", "\"\<USA_cPPPcap\>\"", 
     ",", "\"\<USA_nPPPcap\>\"", ",", "\"\<DEU_cMERcap\>\"", ",", 
     "\"\<DEU_cPPPcap\>\"", ",", "\"\<DEU_nPPPcap\>\""}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ncapratio", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "1"}], "]"}], "]"}], "=", 
   RowBox[{"capPPPraw", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "1"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ncapratio", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "2"}], "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"capraw", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", "172"}], "]"}], "]"}], "/", 
    RowBox[{"outraw", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", "172"}], "]"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ncapratio", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "3"}], "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"capPPPraw", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", "172"}], "]"}], "]"}], "/", 
    RowBox[{"outputPPPraw", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", "172"}], "]"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ncapratio", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "4"}], "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"ncapPPPUSA", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", "2"}], "]"}], "]"}], "/", 
    RowBox[{"noutPPPUSA", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", "2"}], "]"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ncapratio", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "5"}], "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"capraw", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", "48"}], "]"}], "]"}], "/", 
    RowBox[{"outraw", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", "48"}], "]"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ncapratio", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "6"}], "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"capPPPraw", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", "48"}], "]"}], "]"}], "/", 
    RowBox[{"outputPPPraw", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", "48"}], "]"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ncapratio", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "7"}], "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"ncapPPPDEU", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", "2"}], "]"}], "]"}], "/", 
    RowBox[{"noutPPPDEU", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", "2"}], "]"}], "]"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.8489785590807953`*^9, 3.8489785657984056`*^9}, {
  3.8489820547058945`*^9, 3.848982289844822*^9}, {3.8490193678177967`*^9, 
  3.84901937029603*^9}, {3.849019410109478*^9, 3.849019583882126*^9}},
 CellLabel->
  "In[415]:=",ExpressionUUID->"d65eb0c5-7350-4d6b-a99c-28f8ff7cc97a"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
  "calculation", " ", "of", " ", "nominal", " ", "capital", " ", "stocks"}], 
  "*)"}]], "Input",
 CellChangeTimes->{{3.848978278130439*^9, 
  3.848978292805191*^9}},ExpressionUUID->"7600c860-27c4-47d8-bdc2-\
6add7a72bf11"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fcapratioUSA", "=", 
  RowBox[{"ListLinePlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Legended", "[", 
       RowBox[{
        RowBox[{"ncapratio", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}], ",", 
        "\"\<constant-PPP\>\""}], "]"}], ",", 
      RowBox[{"Legended", "[", 
       RowBox[{
        RowBox[{"ncapratio", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "3"}], "}"}]}], "]"}], "]"}], ",", 
        "\"\<current-PPP\>\""}], "]"}], ",", 
      RowBox[{"Legended", "[", 
       RowBox[{
        RowBox[{"ncapratio", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "4"}], "}"}]}], "]"}], "]"}], ",", 
        "\"\<nominal-PPP\>\""}], "]"}]}], "}"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Red", ",", "Blue", ",", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", 
         RowBox[{"Darker", "[", "Green", "]"}]}], "}"}]}], "}"}]}], ",", " ", 
    RowBox[{"PlotLabel", "\[Rule]", "\"\<Cap-Out-Ratio USA\>\""}], ",", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{
       RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
       RowBox[{"FontSize", "\[Rule]", "14"}], ",", "Black"}], "]"}]}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.848982294184306*^9, 3.848982367844365*^9}, {
  3.8490196021555443`*^9, 3.8490196545424566`*^9}, {3.849019692562455*^9, 
  3.8490197328945885`*^9}, {3.849019772963372*^9, 3.8490198329790583`*^9}, {
  3.849515659502536*^9, 3.8495157610706267`*^9}, {3.84951580079996*^9, 
  3.8495158158887043`*^9}, {3.8514207411367793`*^9, 3.8514207447984557`*^9}},
 CellLabel->
  "In[424]:=",ExpressionUUID->"4c3d4c61-72bb-473b-af79-de2a4548fa03"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{}, {{{}, {}, 
       TagBox[{
         Hue[0.67, 0.6, 0.6], 
         Directive[
          PointSize[
           NCache[
            Rational[1, 72], 0.013888888888888888`]], 
          AbsoluteThickness[1.6], 
          RGBColor[1, 0, 0]], 
         LineBox[CompressedData["
1:eJw1z39MzHEYB/Ava6IrP/IjYkVOi9SYNv4o3tKwCSFLCpfOj0YLkVsysdtq
ucYmaUvPg0NOTZGoya9qI1qaH4ucZPqF22nVOtmJuMdn++yz197P53k+nxnb
k9bvGK4oyvKh/ff8t3QEa8c57XffcfjnNEKPn9syjWasw+mEdqtdyV8q1hNK
7ozKjvMQZxI2aos61lWKDYQArzjV5wDxaUJMsqoqVCvOIWSZ2tLicsR5BPvP
Ae9TgTL/POFhoKrqulHyC4RCc3lWS7X4MqHryrrBtW3ia4SQNWu7C46Jiwmq
zMZvfQniUkJHju1I4SzxbYJLd1z4FB7jcAXhvYd6idY22uEqgs9lu8+dSMkf
ESKVN/HlzuJawq+vtVePBomfEkyPbZU9btK/nlCUOKn4hJO4kdBfGbXBliL1
rwn5e5qSGswy7y1hfmLQwsg+yc0Et2WeTaWxcr+VcMO2+VZDk+RthGjPhFzE
irsIYx5OvnKgWvpZCJadDesXfxJ3E2zNN9uD3kl9H+GRZ++9mE7xD8Kz6pub
qnJlnp1wuya5Pj5ErDBcm48rZcFS78QIz+3M+DIg/UcyDLcuZT1pE7syvBeo
e9T/3zOWMcnvx2CJRjyB8cBqzJw5XTyZYfF/aV4VIZ7GMD5PLXjdK57OOKmU
7s/Qi9WM5vtTt+yKFvsxuqLK3bVmN4fnMqaW5C0x1InnMXY+LTsVmyIOGrp/
aHVD9KCrw4sYgTFOb0fniYMZZnVnq85fDMaUlC8Tiywqh8MYYXqPDdYEyVcy
ts1JLl98VhzO2Pxx3Bn3FHEEozCqdetdH3Eko97Y8vK3VfptYrT0X8qO+CSO
ZcxYoem3KFKvGfq/zjS+xCDWMlK3F0SosuU/uxlepSZTiLt4L8OaPHC05qvU
72OEvrcUHb4oPsj4aGhMr9eJdQzT96zUxNniNIb9hb+Lb4W8J31ovplHDDOK
9Yymk429wbvEmQx92quyw85iA6OiriX+zQcX/AGfollt
          "]]}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$139500, {1}}]& ], 
       TagBox[{
         Hue[0.9060679774997897, 0.6, 0.6], 
         Directive[
          PointSize[
           NCache[
            Rational[1, 72], 0.013888888888888888`]], 
          AbsoluteThickness[1.6], 
          RGBColor[0, 0, 1]], 
         LineBox[CompressedData["
1:eJwtzwtMDWAUB/Bby6rb81bIPCruhGrTg2ru7F+3eSyk0jzySF49pEb0cKWt
cJF2S5alnRPaPMJozRJTqM2GdU2jTGGqNbU8eqDySPd827dvv/3Pd873ecSn
Ru0yVygUy8b3/3NiZRLCHK1sPcxVmLCOsORi7uSDGkeTcwkNWveXte7ifEJQ
w4cXxT0OJusJWzNXWitLJS8g5B0JarO0ERsIXh4d0T9CxSUEl/vW2o408XnC
aHO1Z5a1zC8nKJI3WoUdlbyCkKyjPUoWVxIOfSkeUD8SXyUEGF6mmG0R3yCc
Wvd9m8cK8W1CRf/jp0Pm4hqC35xrg1s3y/trCSEZ9VmtNfYmPyD8zTmR98tJ
8gZCoFvZK32T5I2EWeGD4b7fxU8JiffCppS8lvrnhM9LThT+aRQbCf1rbJIK
/cUthPycEYfM83K/lRBTbVuffFPyd4RPqZq6tkB57wfC2eDtXekGyTsJqs/O
1ytdxD2EtOGpXod10q+P0Ho/fp7hgvgrIWPHjZGREqkfJFzPUjb5XxH/JGja
nUYV2TJvjFCZFP3WUy1WMNY39+x/rpJ6C0ZEYOTJWqP0t2KMVWrL3tWLbRm+
Sf7FRSx2ZHQPhwQv1YpdGA31pTPfWopdGS4bck/WLRXPYCxqdEsJ7ha7M74m
xj3szxarGTPUnQvK14rnMZRmqlNRLXYmezMOnbv1qu6ReCGjynlx+YN94gBG
rIVXVc2QrclBjG8XfAq9DWINw/ugXYKzWgzGgpKfvz922ZgcxqiIXt28fafk
KxjTn/i43i0Sr2LcSbmlLj0gXsvIuFqd3OYmXsfI2308Ud8r/TaMz/MLGZj1
XryZYYjpJeMfcRzDGBnxPr1A7u9kPNPd/ZZzRv6TwPD3mawqdhLvZdxc3rjJ
u1fq0xit0xLjBy+K0xn65bMvRWSJMxlzs0vL2ueLdYyuY0322lqZnzver2hS
aOxlcT7jzWnjgGaPWM9I67PyzLcUF4z/L9r3i0W7Ev8A8MRBbQ==
          "]]}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$139500, {2}}]& ], 
       TagBox[{
         Hue[0.1421359549995791, 0.6, 0.6], 
         Directive[
          PointSize[
           NCache[
            Rational[1, 72], 0.013888888888888888`]], 
          AbsoluteThickness[1.6], 
          Thickness[Large], 
          RGBColor[0, 
           NCache[
            Rational[2, 3], 0.6666666666666666], 0]], 
         LineBox[CompressedData["
1:eJw10QtMDVAYB/C7O49ScrWMqK1WlqUlryQt/xRiZWW2WzE35aamlDtU0yKK
Io9oYbXvK2G5bkvmkZAUW8ujGs2dvKWHWA/NK8blfs52dvbbd873nXM+55jk
1VqlQqFYZpp/138jjaA/1OKuGxqLf84gbOw0qo7qxLsJDcWp4cp0cTYBtcUV
iTbiXEJoaUfIq0pxPmHWXf3cnV/GmH2UcMTRmFX+XuKFhMe3/Wq9bC3MPkmI
26VzH14uLiH4eua3xatlfylhWltbacZi8RlCUbP3j6vzxRWEqPKSfX3HpJ6B
sMfzxZ2iQPFFwqCucvGHptFmXybUn/juOJIirjHdb+bWwWeTxDcJLjX+ijka
cT3B2rdze/4S8V1C92Sjb55B3ETQjGj7x4VKvQcEn/11P4IKxK0ES5+Ersoy
8ROC0vWtVReJjQS35kD+rpT3Pyfs5eO/nbrFrwkJj7JzPBaKOwmua5M5fJ24
hxDQHmKrPSD+SBhtUzu/y9nS7AHC+SvFAQF+48weJqxU5+l7E8TfCLdVruvT
9lqZ/dNUr8M71s5H4gqGi0vv4Yo3kn8UI64ZqZ6pYguG3WfPsZYktmZUfzo0
puWUWMXIPtjjb79MbMdYvdkQdWNA+jeF8XbV/YkXX4gdGL8idFGRv8VOjK/n
EieXacSuJtfFXVeniGcwgqdGKF+GiD0YE6w3LLhfJPZiWDSd0xq14nkMg21Y
lcdssQ+jfai/c+k8sR/jXoP6wPj/BuOpQud0LUwcxBhqvKQ/bS/vCWbcyjFU
qraIQxiqBbmNy6vEYQxNdFnYvunSjzUMfatdZOp4+d8IxgrjoOFhj3gdIym5
xC3TWfoRzcjKyyoypos3MmIuZNbbNIjjTXGdg/Okd3I+kTHFoEk3VolTTP3z
39HqkSfexgi/pVbVN4rTGN1xX2NnLZJ8GYycs3U3t08T72b4FtKbL0vE2ab/
ONj62W+TOJeh7KtO2hAvzmc8qN4R7VRghT8diEQa
          "]]}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$139500, {3}}]& ]}, {
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$139500, {1}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$139500, {2}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$139500, {3}}]& ]}, {
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$139500, {1}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$139500, {2}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$139500, {
          3}}]& ], {}, {}, {}, {}, {}, {}, {}}, {
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$139500, {1}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$139500, {2}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$139500, {
          3}}]& ], {}, {}, {}, {}, {}, {}, {}}}, {{}, {}}}, {
    DisplayFunction -> Identity, DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {1948.5625, 2.543460599021107}, 
     DisplayFunction :> Identity, Frame -> {{False, False}, {False, False}}, 
     FrameLabel -> {{None, None}, {None, None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> 600, LabelStyle -> 
     Directive[FontFamily -> "Helvetica", FontSize -> 14, 
       GrayLevel[0]], 
     Method -> {
      "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
       "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& )}}, PlotLabel -> 
     FormBox["\"Cap-Out-Ratio USA\"", TraditionalForm], 
     PlotRange -> {{1948.5625, 2019.}, {2.543460599021107, 
      4.295467853195756}}, PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.05], 
        Scaled[0.05]}}, Ticks -> {Automatic, Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{
      "\"constant-PPP\"", "\"current-PPP\"", "\"nominal-PPP\"", "None", 
       "None", "None"}, "LineLegend", DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large], 
                    RGBColor[0, 
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large], 
                    RGBColor[0, 
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0]], {}}}, 
                    AspectRatio -> Full, ImageSize -> {20, 10}, 
                    PlotRangePadding -> None, ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
          Directive[FontFamily -> "Helvetica", FontSize -> 14, 
           GrayLevel[0]], FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "72"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0, 0], Editable -> False, Selectable -> 
                    False]}], "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "72"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 0, 1], Editable -> False, Selectable -> 
                    False]}], "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "72"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    RowBox[{"Thickness", "[", "Large", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 
                    Rational[2, 3], 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0.4444444444444444, 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", 
                    FractionBox["2", "3"], ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 
                    Rational[2, 3], 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 
                    Rational[2, 3], 0], Editable -> False, Selectable -> 
                    False]}], "]"}]}], "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "72"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0, 0], Editable -> False, Selectable -> 
                    False]}], "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "72"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 0, 1], Editable -> False, Selectable -> 
                    False]}], "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "72"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    RowBox[{"Thickness", "[", "Large", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 
                    Rational[2, 3], 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0.4444444444444444, 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", 
                    FractionBox["2", "3"], ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 
                    Rational[2, 3], 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 
                    Rational[2, 3], 0], Editable -> False, Selectable -> 
                    False]}], "]"}]}], "}"}]}], "}"}], ",", 
           RowBox[{"{", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{#, ",", #2, ",", #3}], "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{#4, ",", #5, ",", #6}], "}"}]}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"None", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"None", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"None", ",", "Automatic"}], "}"}]}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], 
               "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"True", ",", "True", ",", "True"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"True", ",", "True", ",", "True"}], "}"}]}], 
               "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
               RowBox[{
                 RowBox[{"FontFamily", "\[Rule]", "\"Helvetica\""}], ",", 
                 RowBox[{"FontSize", "\[Rule]", "14"}], ",", 
                 InterpretationBox[
                  ButtonBox[
                   TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                   BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                   ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                   Automatic, Method -> "Preemptive"], 
                  GrayLevel[0], Editable -> False, Selectable -> False]}], 
               "]"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.848982368547891*^9, 3.8490193863598366`*^9, 3.8490196564992824`*^9, 
   3.849019718679711*^9, 3.8490198338266187`*^9, 3.8491171667727423`*^9, {
   3.8495157096824484`*^9, 3.849515761870269*^9}, {3.849515804007228*^9, 
   3.8495158171812615`*^9}, 3.8514207298679028`*^9, 3.851420779526743*^9, 
   3.8725151032515893`*^9, 3.8725666547771163`*^9, 3.8730109241638536`*^9, 
   3.8744805234832945`*^9},
 CellLabel->
  "Out[424]=",ExpressionUUID->"080e29d2-0876-4fcd-90f2-4ceeedf334b2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<FcapratioUSA.tiff\>\"", ",", "fcapratioUSA"}], "]"}]], "Input",
 CellChangeTimes->{{3.849515819374856*^9, 3.849515842168111*^9}},
 CellLabel->
  "In[838]:=",ExpressionUUID->"270dafc9-b234-43c1-804e-6217ce383ad8"],

Cell[BoxData["\<\"FcapratioUSA.tiff\"\>"], "Output",
 CellChangeTimes->{3.849515843215021*^9},
 CellLabel->
  "Out[838]=",ExpressionUUID->"76f32154-78ef-4428-8142-1f513240869d"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"capPPPraw2", "=", "capPPPraw"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"Do", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"capPPPraw2", "[", 
       RowBox[{"[", 
        RowBox[{"i", ",", "j"}], "]"}], "]"}], "=", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"capPPPraw", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "j"}], "]"}], "]"}], "\[Equal]", "\"\<\>\""}], 
        ",", "0", ",", 
        RowBox[{"capPPPraw", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "j"}], "]"}], "]"}]}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"j", ",", "2", ",", "181"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lcapPPPraw", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "71"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "181"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lncapPPPraw", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "71"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "181"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"lcapPPPraw", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "1"}], "]"}], "]"}], "=", "\"\<year\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"lncapPPPraw", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "1"}], "]"}], "]"}], "=", "\"\<year\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"lcapPPPraw", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", 
      RowBox[{"2", ";;"}]}], "]"}], "]"}], "=", 
   RowBox[{"capPPPraw", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", 
      RowBox[{"2", ";;"}]}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"lcapPPPraw", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "1"}], "]"}], "]"}], "=", 
   RowBox[{"capPPPraw", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "1"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"lncapPPPraw", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", 
      RowBox[{"2", ";;"}]}], "]"}], "]"}], "=", 
   RowBox[{"capPPPraw", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", 
      RowBox[{"2", ";;"}]}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"lncapPPPraw", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "1"}], "]"}], "]"}], "=", 
   RowBox[{"capPPPraw", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "1"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ncapPPP", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"\"\<\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "181"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rcapPPP", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "181"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "3"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"ncapPPP", "[", 
      RowBox[{"[", "i", "]"}], "]"}], "=", 
     RowBox[{
      RowBox[{
       RowBox[{"Position", "[", 
        RowBox[{
         RowBox[{"capPPPraw", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;"}], ",", "i"}], "]"}], "]"}], ",", 
         RowBox[{"_", "?", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"#", "\[NotEqual]", "\"\<\>\""}], "&"}], ")"}]}], ",", 
         "1", ",", "1"}], "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "1"}], "]"}], "]"}], "+", "1"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "2", ",", "181"}], "}"}]}], "]"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"ncapraw", "[", 
      RowBox[{"[", "141", "]"}], "]"}], "=", "52"}], ";"}], " ", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      RowBox[{
      "for", " ", "Russia", " ", "we", " ", "use", " ", "the", " ", "period", 
       " ", "from", " ", "2000", " ", "onwards", " ", "to", " ", "fit", " ", 
       "the", " ", "data"}], ")"}], ";"}], "*)"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"lcapPPPraw", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{
        RowBox[{"ncapPPP", "[", 
         RowBox[{"[", "i", "]"}], "]"}], ";;"}], ",", "i"}], "]"}], "]"}], 
    "=", 
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{"capPPPraw", "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{
          RowBox[{"ncapPPP", "[", 
           RowBox[{"[", "i", "]"}], "]"}], ";;"}], ",", "i"}], "]"}], "]"}], 
      "]"}], "//", "N"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "181"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"lncapPPPraw", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{
        RowBox[{"ncapPPP", "[", 
         RowBox[{"[", "i", "]"}], "]"}], ";;"}], ",", "i"}], "]"}], "]"}], 
    "=", 
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{
       RowBox[{"capPPPraw", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{
           RowBox[{"ncapPPP", "[", 
            RowBox[{"[", "i", "]"}], "]"}], ";;"}], ",", "i"}], "]"}], "]"}], 
       "*", 
       RowBox[{"pcapPPPraw", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{
           RowBox[{"ncapPPP", "[", 
            RowBox[{"[", "i", "]"}], "]"}], ";;"}], ",", "i"}], "]"}], 
        "]"}]}], "]"}], "//", "N"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "181"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"rcapPPP", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "2"}], "]"}], "]"}], "=", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"lncapPPPraw", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{
           RowBox[{"ncapPPP", "[", 
            RowBox[{"[", "i", "]"}], "]"}], "+", "15"}], ",", "i"}], "]"}], 
        "]"}], "-", 
       RowBox[{"lncapPPPraw", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"ncapPPP", "[", 
           RowBox[{"[", "i", "]"}], "]"}], ",", "i"}], "]"}], "]"}]}], ")"}], 
     "/", "15"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "181"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"rcapPPP", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "3"}], "]"}], "]"}], "=", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"lncapPPPraw", "[", 
        RowBox[{"[", 
         RowBox[{"71", ",", "i"}], "]"}], "]"}], "-", 
       RowBox[{"lncapPPPraw", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"ncapPPP", "[", 
           RowBox[{"[", "i", "]"}], "]"}], ",", "i"}], "]"}], "]"}]}], ")"}], 
     "/", 
     RowBox[{"(", 
      RowBox[{"71", "-", 
       RowBox[{"ncapPPP", "[", 
        RowBox[{"[", "i", "]"}], "]"}]}], ")"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "181"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"rcapPPP", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "2"}], "]"}], "]"}], "<", "0"}], ",", 
      RowBox[{
       RowBox[{"rcapPPP", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "2"}], "]"}], "]"}], "=", 
       RowBox[{"rcapPPP", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "3"}], "]"}], "]"}]}], ",", "0"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "2", ",", "181"}], "}"}]}], "]"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"rcap", "[", 
      RowBox[{"[", 
       RowBox[{"170", ",", "2"}], "]"}], "]"}], "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"lcapraw", "[", 
         RowBox[{"[", 
          RowBox[{"44", ",", "170"}], "]"}], "]"}], "-", 
        RowBox[{"lcapraw", "[", 
         RowBox[{"[", 
          RowBox[{"42", ",", "170"}], "]"}], "]"}]}], ")"}], "/", "2"}]}], 
    ";", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"rcap", "[", 
      RowBox[{"[", 
       RowBox[{"170", ",", "3"}], "]"}], "]"}], "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"lcapraw", "[", 
         RowBox[{"[", 
          RowBox[{"44", ",", "170"}], "]"}], "]"}], "-", 
        RowBox[{"lcapraw", "[", 
         RowBox[{"[", 
          RowBox[{"42", ",", "170"}], "]"}], "]"}]}], ")"}], "/", "2"}]}], 
    ";", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"rcap", "[", 
      RowBox[{"[", 
       RowBox[{"141", ",", "2"}], "]"}], "]"}], "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"lcapraw", "[", 
         RowBox[{"[", 
          RowBox[{"71", ",", "141"}], "]"}], "]"}], "-", 
        RowBox[{"lcapraw", "[", 
         RowBox[{"[", 
          RowBox[{"57", ",", "141"}], "]"}], "]"}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"71", "-", "57"}], ")"}]}]}], ";", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"rcap", "[", 
      RowBox[{"[", 
       RowBox[{"141", ",", "3"}], "]"}], "]"}], "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"lcapraw", "[", 
         RowBox[{"[", 
          RowBox[{"71", ",", "141"}], "]"}], "]"}], "-", 
        RowBox[{"lcapraw", "[", 
         RowBox[{"[", 
          RowBox[{"57", ",", "141"}], "]"}], "]"}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"71", "-", "57"}], ")"}]}]}], ";"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"ncapPPP", "[", 
       RowBox[{"[", "i", "]"}], "]"}], ">", "2"}], ",", 
     RowBox[{"{", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"lncapPPPraw", "[", 
          RowBox[{"[", 
           RowBox[{"j", ",", "i"}], "]"}], "]"}], "=", 
         RowBox[{
          RowBox[{"lncapPPPraw", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"ncapPPP", "[", 
              RowBox[{"[", "i", "]"}], "]"}], ",", "i"}], "]"}], "]"}], "-", 
          RowBox[{
           RowBox[{"rcapPPP", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "2"}], "]"}], "]"}], "*", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"ncapPPP", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "-", "j"}], ")"}]}]}]}], ",", 
        RowBox[{"{", 
         RowBox[{"j", ",", "2", ",", 
          RowBox[{
           RowBox[{"ncapPPP", "[", 
            RowBox[{"[", "i", "]"}], "]"}], "-", "1"}]}], "}"}]}], "]"}], 
      "}"}], ",", "0"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "181"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.8490207085891924`*^9, 3.8490207924815235`*^9}, {
   3.8490208365399237`*^9, 3.849020938820698*^9}, {3.8490210023832445`*^9, 
   3.849021009836955*^9}, {3.849021086392329*^9, 3.849021113198059*^9}, {
   3.849023264121134*^9, 3.849023341315259*^9}, {3.8490234256021833`*^9, 
   3.84902353384196*^9}, {3.849023655194517*^9, 3.8490236561004944`*^9}, {
   3.849027079822214*^9, 3.8490270867096*^9}, {3.8490271197360487`*^9, 
   3.8490272401097136`*^9}, {3.8490273656147738`*^9, 
   3.8490273737221546`*^9}, {3.849027451027341*^9, 3.8490275527283025`*^9}, {
   3.8490289890961018`*^9, 3.8490291036054163`*^9}, 3.8490291743342986`*^9},
 CellLabel->
  "In[425]:=",ExpressionUUID->"c5fbfe50-7e17-4505-8404-067035f11712"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ncapPPPfull", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "71"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "181"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ncapPPPfull", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "1"}], "]"}], "]"}], "=", "\"\<year\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ncapPPPfull", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", 
      RowBox[{"2", ";;"}]}], "]"}], "]"}], "=", 
   RowBox[{"capraw", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", 
      RowBox[{"2", ";;"}]}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ncapPPPfull", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "1"}], "]"}], "]"}], "=", 
   RowBox[{"capraw", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "1"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ncapPPPfull", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", 
      RowBox[{"2", ";;"}]}], "]"}], "]"}], "=", 
   RowBox[{"Exp", "[", 
    RowBox[{"lncapPPPraw", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", 
       RowBox[{"2", ";;"}]}], "]"}], "]"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.836478615265397*^9, 3.836478774751958*^9}, {
   3.836478808256502*^9, 3.8364788305636053`*^9}, {3.836479159261264*^9, 
   3.8364791638443966`*^9}, {3.8364792609777117`*^9, 3.836479261858905*^9}, {
   3.836479367582426*^9, 3.8364796969513073`*^9}, {3.8364798623528824`*^9, 
   3.836479879028204*^9}, {3.8364800270652175`*^9, 3.83648002802437*^9}, {
   3.8364802663791127`*^9, 3.8364802851164074`*^9}, {3.8364811568987665`*^9, 
   3.8364811580054984`*^9}, {3.836486741739381*^9, 3.8364867439573355`*^9}, {
   3.8364885043487105`*^9, 3.8364885183351393`*^9}, {3.836488650882226*^9, 
   3.836488660596323*^9}, {3.8364892635376062`*^9, 3.8364892850899634`*^9}, {
   3.8364959576389503`*^9, 3.8364959579926214`*^9}, 3.8364966275187197`*^9, {
   3.836496803853406*^9, 3.8364968098945255`*^9}, {3.8364968483405724`*^9, 
   3.836496881543643*^9}, {3.8364970099941816`*^9, 3.836497011018032*^9}, {
   3.8364970857320867`*^9, 3.836497086753092*^9}, {3.836502360265394*^9, 
   3.836502517300318*^9}, {3.8365025522917023`*^9, 3.8365026662313643`*^9}, {
   3.836502703371941*^9, 3.836502703816445*^9}, {3.8365027607879443`*^9, 
   3.8365027643451676`*^9}, {3.8365028401260967`*^9, 
   3.8365028409667344`*^9}, {3.8365032275742006`*^9, 
   3.8365032577984858`*^9}, {3.836545643808959*^9, 3.836545652988243*^9}, {
   3.8375027286812983`*^9, 3.8375027290561304`*^9}, {3.837502843953373*^9, 
   3.837502850336053*^9}, {3.8376217912271566`*^9, 3.837621809160245*^9}, 
   3.837622087303434*^9, {3.8376221782240868`*^9, 3.8376221784075966`*^9}, {
   3.8376245670189867`*^9, 3.8376245704050694`*^9}, {3.8434562302473125`*^9, 
   3.8434562378290944`*^9}, 3.8490292828740835`*^9, {3.849029321459628*^9, 
   3.8490293596818953`*^9}},
 CellLabel->
  "In[444]:=",ExpressionUUID->"7f396c2c-d245-4644-92c4-792b6a0a9640"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<capital_nominal_calc_full.csv\>\"", ",", "ncapPPPfull"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.8364954288155046`*^9, 3.8364954448825808`*^9}, {
  3.837842240009288*^9, 3.8378422563845224`*^9}, {3.838476276132435*^9, 
  3.8384762785452976`*^9}, {3.849029372426011*^9, 3.849029383357377*^9}, {
  3.8514220360077267`*^9, 3.851422038405907*^9}},
 CellLabel->
  "In[449]:=",ExpressionUUID->"49d67d05-4c04-43b2-8a98-6f0868b6ef25"],

Cell[BoxData["\<\"capital_nominal_calc_full.csv\"\>"], "Output",
 CellChangeTimes->{
  3.836495446583298*^9, 3.836495972441991*^9, {3.836502711212123*^9, 
   3.8365027246218634`*^9}, 3.8365027707701244`*^9, 3.836503362922517*^9, 
   3.837624603026782*^9, 3.8378417774968653`*^9, 3.838476282681054*^9, 
   3.8472041716757765`*^9, 3.8474204849753685`*^9, 3.8481281729487104`*^9, 
   3.8490293876064873`*^9, 3.851422027352287*^9, 3.8730109534936647`*^9, 
   3.8744805420907*^9},
 CellLabel->
  "Out[449]=",ExpressionUUID->"07cf2a10-a7e9-45c3-9624-a7869cf9dc64"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ncaptotal", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "71"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "3"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ncaptotal", "[", 
    RowBox[{"[", "1", "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"\"\<year\>\"", ",", "\"\<cap\>\"", ",", "\"\<lcap\>\""}], 
    "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ncaptotal", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "1"}], "]"}], "]"}], "=", 
    RowBox[{"1948", "+", "i"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ncaptotal", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "2"}], "]"}], "]"}], "=", 
    RowBox[{"Total", "[", 
     RowBox[{"ncapPPPfull", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", 
        RowBox[{"2", ";;"}]}], "]"}], "]"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ncaptotal", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "3"}], "]"}], "]"}], "=", 
   RowBox[{"Log", "[", 
    RowBox[{"ncaptotal", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", "2"}], "]"}], "]"}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.8364951290971956`*^9, 3.836495346408888*^9}, {
  3.847644405607142*^9, 3.8476444488555465`*^9}, {3.8476461863180833`*^9, 
  3.8476461898019943`*^9}, {3.849029393357268*^9, 3.8490294451430283`*^9}, {
  3.8514220840725613`*^9, 3.8514220991439905`*^9}},
 CellLabel->
  "In[450]:=",ExpressionUUID->"bdb962f4-2953-48ef-99ad-c182a695f105"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"nexncap", "=", 
   RowBox[{"Position", "[", 
    RowBox[{"ncapraw", ",", 
     RowBox[{"n_", "/;", 
      RowBox[{"n", ">", "2"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"noexncap", "=", 
   RowBox[{"Position", "[", 
    RowBox[{"ncapraw", ",", 
     RowBox[{"n_", "/;", 
      RowBox[{"n", "==", "2"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ncapnoextotal", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "71"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "4"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ncapnoextotal", "[", 
    RowBox[{"[", "1", "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
    "\"\<year\>\"", ",", "\"\<cap_noex\>\"", ",", "\"\<cap_ex\>\"", ",", 
     "\"\<cap\>\""}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ncapnoextotal", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "1"}], "]"}], "]"}], "=", 
    RowBox[{"1948", "+", "i"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ncapnoextotal", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "2"}], "]"}], "]"}], "=", 
    RowBox[{"Total", "[", 
     RowBox[{"ncapPPPfull", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", 
        RowBox[{"Flatten", "[", "noexncap", "]"}]}], "]"}], "]"}], "]"}]}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ncapnoextotal", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "3"}], "]"}], "]"}], "=", 
    RowBox[{"Total", "[", 
     RowBox[{"ncapPPPfull", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", 
        RowBox[{"Flatten", "[", "nexncap", "]"}]}], "]"}], "]"}], "]"}]}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ncapnoextotal", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "4"}], "]"}], "]"}], "=", 
    RowBox[{"Total", "[", 
     RowBox[{"capPPPraw2", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", 
        RowBox[{"Flatten", "[", "nexncap", "]"}]}], "]"}], "]"}], "]"}]}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.8365434344171085`*^9, 3.836543483636301*^9}, {
   3.8365827730947933`*^9, 3.8365828030303745`*^9}, {3.836582904823327*^9, 
   3.836582908978444*^9}, {3.836583089627802*^9, 3.836583091555582*^9}, {
   3.8365832174974127`*^9, 3.8365832270898876`*^9}, 3.836583783388259*^9, {
   3.8366009881099296`*^9, 3.8366010082874594`*^9}, {3.8366013373245525`*^9, 
   3.836601352615738*^9}, {3.8366013877178135`*^9, 3.836601433897071*^9}, {
   3.8366015884348793`*^9, 3.8366016191320267`*^9}, {3.8490294936424165`*^9, 
   3.8490296226794577`*^9}, 3.849031300434575*^9, {3.849459528121801*^9, 
   3.8494595400251384`*^9}, {3.8514221464652357`*^9, 3.8514221935224543`*^9}},
 CellLabel->
  "In[455]:=",ExpressionUUID->"65bbd0a5-0ab5-4ef2-ae6d-de398b355f3d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"outPPPraw2", "=", 
   RowBox[{"outputPPPraw", "[", 
    RowBox[{"[", 
     RowBox[{";;", ",", 
      RowBox[{"1", ";;", "181"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"outPPPraw2", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "j"}], "]"}], "]"}], "=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"outputPPPraw", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "j"}], "]"}], "]"}], "\[Equal]", "\"\<\>\""}], 
         ",", "0", ",", 
         RowBox[{"outputPPPraw", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "j"}], "]"}], "]"}]}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "2", ",", "181"}], "}"}]}], "]"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"loutPPPraw", "=", 
     RowBox[{"Table", "[", 
      RowBox[{"0", ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "71"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "181"}], "}"}]}], "]"}]}], ";"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"lnoutPPPraw", "=", 
    RowBox[{"Table", "[", 
     RowBox[{"0", ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "71"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "181"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"lcapPPPraw", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1"}], "]"}], "]"}], "=", "\"\<year\>\""}], ";"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"lncapPPPraw", "[", 
     RowBox[{"[", 
      RowBox[{"1", ",", "1"}], "]"}], "]"}], "=", "\"\<year\>\""}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"lcapPPPraw", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", 
        RowBox[{"2", ";;"}]}], "]"}], "]"}], "=", 
     RowBox[{"capPPPraw", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", 
        RowBox[{"2", ";;"}]}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"lcapPPPraw", "[", 
      RowBox[{"[", 
       RowBox[{
        RowBox[{"2", ";;"}], ",", "1"}], "]"}], "]"}], "=", 
     RowBox[{"capPPPraw", "[", 
      RowBox[{"[", 
       RowBox[{
        RowBox[{"2", ";;"}], ",", "1"}], "]"}], "]"}]}], ";"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"lnoutPPPraw", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", 
      RowBox[{"2", ";;"}]}], "]"}], "]"}], "=", 
   RowBox[{"outPPPraw2", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", 
      RowBox[{"2", ";;"}]}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"lnoutPPPraw", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "1"}], "]"}], "]"}], "=", 
   RowBox[{"outPPPraw2", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "1"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"noutPPP", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"\"\<\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "181"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"routPPP", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "181"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "3"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"noutPPP", "[", 
      RowBox[{"[", "i", "]"}], "]"}], "=", 
     RowBox[{
      RowBox[{
       RowBox[{"Position", "[", 
        RowBox[{
         RowBox[{"outputPPPraw", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;"}], ",", "i"}], "]"}], "]"}], ",", 
         RowBox[{"_", "?", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"#", "\[NotEqual]", "\"\<\>\""}], "&"}], ")"}]}], ",", 
         "1", ",", "1"}], "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "1"}], "]"}], "]"}], "+", "1"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "2", ",", "181"}], "}"}]}], "]"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"ncapraw", "[", 
      RowBox[{"[", "141", "]"}], "]"}], "=", "52"}], ";"}], " ", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      RowBox[{
      "for", " ", "Russia", " ", "we", " ", "use", " ", "the", " ", "period", 
       " ", "from", " ", "2000", " ", "onwards", " ", "to", " ", "fit", " ", 
       "the", " ", "data"}], ")"}], ";"}], "*)"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Do", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"lcapPPPraw", "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{
          RowBox[{"ncapPPP", "[", 
           RowBox[{"[", "i", "]"}], "]"}], ";;"}], ",", "i"}], "]"}], "]"}], 
      "=", 
      RowBox[{
       RowBox[{"Log", "[", 
        RowBox[{"capPPPraw", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{
            RowBox[{"ncapPPP", "[", 
             RowBox[{"[", "i", "]"}], "]"}], ";;"}], ",", "i"}], "]"}], "]"}],
         "]"}], "//", "N"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "2", ",", "181"}], "}"}]}], "]"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"lnoutPPPraw", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{
        RowBox[{"noutPPP", "[", 
         RowBox[{"[", "i", "]"}], "]"}], ";;"}], ",", "i"}], "]"}], "]"}], 
    "=", 
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{
       RowBox[{"outPPPraw2", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{
           RowBox[{"noutPPP", "[", 
            RowBox[{"[", "i", "]"}], "]"}], ";;"}], ",", "i"}], "]"}], "]"}], 
       "*", 
       RowBox[{"poutputPPPraw", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{
           RowBox[{"noutPPP", "[", 
            RowBox[{"[", "i", "]"}], "]"}], ";;"}], ",", "i"}], "]"}], 
        "]"}]}], "]"}], "//", "N"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "181"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"routPPP", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "2"}], "]"}], "]"}], "=", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"lnoutPPPraw", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{
           RowBox[{"noutPPP", "[", 
            RowBox[{"[", "i", "]"}], "]"}], "+", "15"}], ",", "i"}], "]"}], 
        "]"}], "-", 
       RowBox[{"lnoutPPPraw", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"noutPPP", "[", 
           RowBox[{"[", "i", "]"}], "]"}], ",", "i"}], "]"}], "]"}]}], ")"}], 
     "/", "15"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "181"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"routPPP", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "3"}], "]"}], "]"}], "=", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"lnoutPPPraw", "[", 
        RowBox[{"[", 
         RowBox[{"71", ",", "i"}], "]"}], "]"}], "-", 
       RowBox[{"lnoutPPPraw", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"noutPPP", "[", 
           RowBox[{"[", "i", "]"}], "]"}], ",", "i"}], "]"}], "]"}]}], ")"}], 
     "/", 
     RowBox[{"(", 
      RowBox[{"71", "-", 
       RowBox[{"noutPPP", "[", 
        RowBox[{"[", "i", "]"}], "]"}]}], ")"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "181"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"routPPP", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "2"}], "]"}], "]"}], "<", "0"}], ",", 
      RowBox[{
       RowBox[{"routPPP", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "2"}], "]"}], "]"}], "=", 
       RowBox[{"routPPP", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "3"}], "]"}], "]"}]}], ",", "0"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "2", ",", "181"}], "}"}]}], "]"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"rcap", "[", 
      RowBox[{"[", 
       RowBox[{"170", ",", "2"}], "]"}], "]"}], "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"lcapraw", "[", 
         RowBox[{"[", 
          RowBox[{"44", ",", "170"}], "]"}], "]"}], "-", 
        RowBox[{"lcapraw", "[", 
         RowBox[{"[", 
          RowBox[{"42", ",", "170"}], "]"}], "]"}]}], ")"}], "/", "2"}]}], 
    ";", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"rcap", "[", 
      RowBox[{"[", 
       RowBox[{"170", ",", "3"}], "]"}], "]"}], "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"lcapraw", "[", 
         RowBox[{"[", 
          RowBox[{"44", ",", "170"}], "]"}], "]"}], "-", 
        RowBox[{"lcapraw", "[", 
         RowBox[{"[", 
          RowBox[{"42", ",", "170"}], "]"}], "]"}]}], ")"}], "/", "2"}]}], 
    ";", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"rcap", "[", 
      RowBox[{"[", 
       RowBox[{"141", ",", "2"}], "]"}], "]"}], "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"lcapraw", "[", 
         RowBox[{"[", 
          RowBox[{"71", ",", "141"}], "]"}], "]"}], "-", 
        RowBox[{"lcapraw", "[", 
         RowBox[{"[", 
          RowBox[{"57", ",", "141"}], "]"}], "]"}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"71", "-", "57"}], ")"}]}]}], ";", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"rcap", "[", 
      RowBox[{"[", 
       RowBox[{"141", ",", "3"}], "]"}], "]"}], "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"lcapraw", "[", 
         RowBox[{"[", 
          RowBox[{"71", ",", "141"}], "]"}], "]"}], "-", 
        RowBox[{"lcapraw", "[", 
         RowBox[{"[", 
          RowBox[{"57", ",", "141"}], "]"}], "]"}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"71", "-", "57"}], ")"}]}]}], ";"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"noutPPP", "[", 
       RowBox[{"[", "i", "]"}], "]"}], ">", "2"}], ",", 
     RowBox[{"{", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"lnoutPPPraw", "[", 
          RowBox[{"[", 
           RowBox[{"j", ",", "i"}], "]"}], "]"}], "=", 
         RowBox[{
          RowBox[{"lnoutPPPraw", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"noutPPP", "[", 
              RowBox[{"[", "i", "]"}], "]"}], ",", "i"}], "]"}], "]"}], "-", 
          RowBox[{
           RowBox[{"routPPP", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "2"}], "]"}], "]"}], "*", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"noutPPP", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "-", "j"}], ")"}]}]}]}], ",", 
        RowBox[{"{", 
         RowBox[{"j", ",", "2", ",", 
          RowBox[{
           RowBox[{"noutPPP", "[", 
            RowBox[{"[", "i", "]"}], "]"}], "-", "1"}]}], "}"}]}], "]"}], 
      "}"}], ",", "0"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "181"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.8490207085891924`*^9, 3.8490207924815235`*^9}, {
   3.8490208365399237`*^9, 3.849020938820698*^9}, {3.8490210023832445`*^9, 
   3.849021009836955*^9}, {3.849021086392329*^9, 3.849021113198059*^9}, {
   3.849023264121134*^9, 3.849023341315259*^9}, {3.8490234256021833`*^9, 
   3.84902353384196*^9}, {3.849023655194517*^9, 3.8490236561004944`*^9}, {
   3.849027079822214*^9, 3.8490270867096*^9}, {3.8490271197360487`*^9, 
   3.8490272401097136`*^9}, {3.8490273656147738`*^9, 
   3.8490273737221546`*^9}, {3.849027451027341*^9, 3.8490275527283025`*^9}, {
   3.8490289890961018`*^9, 3.8490291036054163`*^9}, 3.8490291743342986`*^9, {
   3.849117535057333*^9, 3.8491175416023498`*^9}, {3.8491175787607164`*^9, 
   3.849117609445013*^9}, {3.849117665896202*^9, 3.849117725755828*^9}, {
   3.8491177764103794`*^9, 3.8491177809432597`*^9}, {3.8491178977748384`*^9, 
   3.8491179255315075`*^9}, {3.8491180390061026`*^9, 3.849118059412131*^9}, {
   3.8491182042287006`*^9, 3.8491182294607854`*^9}, {3.8491182723745637`*^9, 
   3.8491183370378337`*^9}, {3.84911837863914*^9, 3.8491184148936195`*^9}, {
   3.8491184773966618`*^9, 3.849118522312951*^9}, {3.849118575819069*^9, 
   3.8491186491589823`*^9}, {3.849118702845546*^9, 3.849118706240699*^9}, {
   3.8514244274750156`*^9, 3.8514244289840937`*^9}, {3.8514247095670786`*^9, 
   3.8514247105499287`*^9}},
 CellLabel->
  "In[463]:=",ExpressionUUID->"efd40710-fc3e-4c20-9f2e-af110855d849"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"noutPPPfull", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "71"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "181"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"noutPPPfull", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "1"}], "]"}], "]"}], "=", "\"\<year\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"noutPPPfull", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", 
      RowBox[{"2", ";;"}]}], "]"}], "]"}], "=", 
   RowBox[{"outPPPraw2", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", 
      RowBox[{"2", ";;"}]}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"noutPPPfull", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "1"}], "]"}], "]"}], "=", 
   RowBox[{"outPPPraw2", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "1"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"noutPPPfull", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", 
      RowBox[{"2", ";;"}]}], "]"}], "]"}], "=", 
   RowBox[{"Exp", "[", 
    RowBox[{"lnoutPPPraw", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", 
       RowBox[{"2", ";;"}]}], "]"}], "]"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.8491188846598125`*^9, 3.849118932045005*^9}},
 CellLabel->
  "In[477]:=",ExpressionUUID->"3103213e-a34c-423a-a65b-44251a086fa0"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"noutPPPtotal", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "71"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "3"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"noutPPPtotal", "[", 
    RowBox[{"[", "1", "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"\"\<year\>\"", ",", "\"\<out\>\"", ",", "\"\<lout\>\""}], 
    "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"noutPPPtotal", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "1"}], "]"}], "]"}], "=", 
    RowBox[{"1948", "+", "i"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"noutPPPtotal", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "2"}], "]"}], "]"}], "=", 
    RowBox[{"Total", "[", 
     RowBox[{"noutPPPfull", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", 
        RowBox[{"2", ";;"}]}], "]"}], "]"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"noutPPPtotal", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "3"}], "]"}], "]"}], "=", 
   RowBox[{"Log", "[", 
    RowBox[{"noutPPPtotal", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", "2"}], "]"}], "]"}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.8364951290971956`*^9, 3.836495346408888*^9}, {
  3.847644405607142*^9, 3.8476444488555465`*^9}, {3.8476461863180833`*^9, 
  3.8476461898019943`*^9}, {3.849029393357268*^9, 3.8490294451430283`*^9}, {
  3.8491190436058283`*^9, 3.8491190760168605`*^9}, {3.8504111661476984`*^9, 
  3.8504111720648985`*^9}},
 CellLabel->
  "In[482]:=",ExpressionUUID->"fc6fdcb0-7747-4d5a-9263-4478407dae47"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"nexnoutPPP", "=", 
   RowBox[{"Position", "[", 
    RowBox[{"noutraw", ",", 
     RowBox[{"n_", "/;", 
      RowBox[{"n", ">", "2"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"noexnoutPPP", "=", 
   RowBox[{"Position", "[", 
    RowBox[{"noutraw", ",", 
     RowBox[{"n_", "/;", 
      RowBox[{"n", "==", "2"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"noutPPPnoextotal", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "71"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "4"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"noutPPPnoextotal", "[", 
    RowBox[{"[", "1", "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
    "\"\<year\>\"", ",", "\"\<out_noex\>\"", ",", "\"\<out_ex\>\"", ",", 
     "\"\<out_total\>\""}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"noutPPPnoextotal", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "1"}], "]"}], "]"}], "=", 
    RowBox[{"1948", "+", "i"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"noutPPPnoextotal", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "2"}], "]"}], "]"}], "=", 
    RowBox[{"Total", "[", 
     RowBox[{"noutPPPfull", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", 
        RowBox[{"Flatten", "[", "noexnoutPPP", "]"}]}], "]"}], "]"}], "]"}]}],
    ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"noutPPPnoextotal", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "3"}], "]"}], "]"}], "=", 
    RowBox[{"Total", "[", 
     RowBox[{"noutPPPfull", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", 
        RowBox[{"Flatten", "[", "nexnoutPPP", "]"}]}], "]"}], "]"}], "]"}]}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"noutPPPnoextotal", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "4"}], "]"}], "]"}], "=", 
    RowBox[{"Total", "[", 
     RowBox[{"outPPPraw2", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", 
        RowBox[{"Flatten", "[", "nexnoutPPP", "]"}]}], "]"}], "]"}], "]"}]}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.8365434344171085`*^9, 3.836543483636301*^9}, {
   3.8365827730947933`*^9, 3.8365828030303745`*^9}, {3.836582904823327*^9, 
   3.836582908978444*^9}, {3.836583089627802*^9, 3.836583091555582*^9}, {
   3.8365832174974127`*^9, 3.8365832270898876`*^9}, 3.836583783388259*^9, {
   3.8366009881099296`*^9, 3.8366010082874594`*^9}, {3.8366013373245525`*^9, 
   3.836601352615738*^9}, {3.8366013877178135`*^9, 3.836601433897071*^9}, {
   3.8366015884348793`*^9, 3.8366016191320267`*^9}, {3.8490294936424165`*^9, 
   3.8490296226794577`*^9}, 3.849031300434575*^9, {3.84911910303144*^9, 
   3.8491191173345327`*^9}, {3.8491192380396852`*^9, 
   3.8491193019499707`*^9}, {3.849459967398987*^9, 3.849459984275796*^9}, {
   3.8495169216708293`*^9, 3.849516922600342*^9}, 3.849517008069577*^9},
 CellLabel->
  "In[487]:=",ExpressionUUID->"91190bf0-1eb4-4cf0-8806-eee9003ce9b5"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"noutPPPcalc", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "71"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "181"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"noutPPPcalc", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "1"}], "]"}], "]"}], "=", "\"\<year\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"noutPPPcalc", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "1"}], "]"}], "]"}], "=", 
   RowBox[{"noutPPPfull", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "1"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"noutPPPcalc", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", 
      RowBox[{"2", ";;"}]}], "]"}], "]"}], "=", 
   RowBox[{"noutPPPfull", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", 
      RowBox[{"2", ";;", "181"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"noutPPPcalc", "[", 
    RowBox[{"[", 
     RowBox[{"71", ",", 
      RowBox[{"2", ";;"}]}], "]"}], "]"}], "=", 
   RowBox[{"noutPPPfull", "[", 
    RowBox[{"[", 
     RowBox[{"71", ",", 
      RowBox[{"2", ";;", "181"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"noutPPPcalc", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", 
       RowBox[{"2", ";;"}]}], "]"}], "]"}], "=", 
    RowBox[{
     RowBox[{"noutPPPcalc", "[", 
      RowBox[{"[", 
       RowBox[{"71", ",", 
        RowBox[{"2", ";;"}]}], "]"}], "]"}], "*", 
     RowBox[{"outrate", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", 
        RowBox[{"2", ";;"}]}], "]"}], "]"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "70"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"noutPPPcalctotal", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "71"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "3"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"noutPPPcalctotal", "[", 
    RowBox[{"[", "1", "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"\"\<year\>\"", ",", "\"\<c_out\>\"", ",", "\"\<lout\>\""}], 
    "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"noutPPPcalctotal", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "1"}], "]"}], "]"}], "=", 
    RowBox[{"1948", "+", "i"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"noutPPPcalctotal", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "2"}], "]"}], "]"}], "=", 
    RowBox[{"Total", "[", 
     RowBox[{"noutPPPcalc", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", 
        RowBox[{"2", ";;"}]}], "]"}], "]"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"noutPPPcalctotal", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "3"}], "]"}], "]"}], "=", 
   RowBox[{"Log", "[", 
    RowBox[{"noutPPPcalctotal", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", "2"}], "]"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.8504127914444327`*^9, 3.850412797796713*^9}, {
   3.8504128310099125`*^9, 3.850412849474349*^9}, {3.8504131950343866`*^9, 
   3.8504132723207097`*^9}, {3.850413462656035*^9, 3.850413554471651*^9}, {
   3.85041367888768*^9, 3.850413688544469*^9}, 3.850413725706085*^9, {
   3.850413779504122*^9, 3.8504138055374336`*^9}},
 CellLabel->
  "In[495]:=",ExpressionUUID->"e8c10e15-15ac-4e6e-96cc-4c5ac73cff1d"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"outtotal", "[", 
   RowBox[{"[", 
    RowBox[{"71", ",", "2"}], "]"}], "]"}], "*", 
  RowBox[{
   RowBox[{"10", "^", "6"}], "/", 
   RowBox[{"10", "^", "12"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rgdpototal", "[", 
   RowBox[{"[", 
    RowBox[{"71", ",", "2"}], "]"}], "]"}], "*", 
  RowBox[{
   RowBox[{"10", "^", "6"}], "/", 
   RowBox[{"10", "^", "12"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"noutPPPtotal", "[", 
   RowBox[{"[", 
    RowBox[{"71", ",", "2"}], "]"}], "]"}], "*", 
  RowBox[{
   RowBox[{"10", "^", "6"}], "/", 
   RowBox[{"10", "^", "12"}]}]}]}], "Input",
 CellChangeTimes->{{3.851533526530343*^9, 3.8515335690698137`*^9}, {
  3.8515336895969906`*^9, 3.851533702288625*^9}, {3.8515337385651274`*^9, 
  3.851533751480198*^9}},
 CellLabel->
  "In[506]:=",ExpressionUUID->"3a6fba77-4065-4194-a6ba-2224f148f8f0"],

Cell[BoxData["125.24049706584056`"], "Output",
 CellChangeTimes->{{3.851533533458951*^9, 3.8515335696117477`*^9}, 
   3.8515337032612233`*^9, 3.8515337526130805`*^9, 3.8725153542539496`*^9, 
   3.8730109781630006`*^9, 3.874480567730484*^9},
 CellLabel->
  "Out[506]=",ExpressionUUID->"cb53c8e1-9380-4f39-86d2-bbabea857435"],

Cell[BoxData["125.25531004440455`"], "Output",
 CellChangeTimes->{{3.851533533458951*^9, 3.8515335696117477`*^9}, 
   3.8515337032612233`*^9, 3.8515337526130805`*^9, 3.8725153542539496`*^9, 
   3.8730109781630006`*^9, 3.8744805677334747`*^9},
 CellLabel->
  "Out[507]=",ExpressionUUID->"7183f36a-ce34-4746-abc1-5685576d1ec0"],

Cell[BoxData["87.06235920741683`"], "Output",
 CellChangeTimes->{{3.851533533458951*^9, 3.8515335696117477`*^9}, 
   3.8515337032612233`*^9, 3.8515337526130805`*^9, 3.8725153542539496`*^9, 
   3.8730109781630006`*^9, 3.874480567738462*^9},
 CellLabel->
  "Out[508]=",ExpressionUUID->"8e4850ca-cc9c-465d-9ecf-bc54556c7dab"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FigOutput", "=", 
  RowBox[{"ListLinePlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Legended", "[", 
       RowBox[{
        RowBox[{"outtotal", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}], ",", 
        RowBox[{"Placed", "[", 
         RowBox[{
         "\"\<constant 2017, PPP, national prices (in 2017 USD)\>\"", ",", 
          "Below"}], "]"}]}], "]"}], ",", 
      RowBox[{"Legended", "[", 
       RowBox[{
        RowBox[{"rgdpototal", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}], ",", 
        RowBox[{"Placed", "[", 
         RowBox[{
         "\"\<constant 2017, PPP, chained PPP prices (in 2017 USD)\>\"", ",", 
          "Below"}], "]"}]}], "]"}], ",", 
      RowBox[{"Legended", "[", 
       RowBox[{
        RowBox[{"noutPPPtotal", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}], ",", 
        RowBox[{"Placed", "[", 
         RowBox[{"\"\<Nominal, Current (in 2017 USD)\>\"", ",", "Below"}], 
         "]"}]}], "]"}], ",", 
      RowBox[{"Legended", "[", 
       RowBox[{
        RowBox[{"noutPPPcalctotal", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}], ",", 
        RowBox[{"Placed", "[", 
         RowBox[{
         "\"\<Nominal, Constant, Calculated (in 2017 USD)\>\"", ",", 
          "Below"}], "]"}]}], "]"}]}], "}"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Red", ",", "Blue", ",", 
       RowBox[{"{", 
        RowBox[{"Green", ",", "Dashed"}], "}"}], ",", "Green"}], "}"}]}], ",", 
    RowBox[{
    "PlotLabel", "\[Rule]", "\"\<World GDP (N=180, extrapolated)\>\""}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8504122199326096`*^9, 3.8504122594046288`*^9}, {
  3.85041231034105*^9, 3.850412373034731*^9}, {3.850412578227056*^9, 
  3.8504125879053726`*^9}, {3.850412627788637*^9, 3.8504126649361954`*^9}, {
  3.8504132872060413`*^9, 3.850413338167117*^9}, {3.8504135673213005`*^9, 
  3.850413567903343*^9}, {3.850413840665432*^9, 3.8504138459473467`*^9}, {
  3.8514605201295958`*^9, 3.85146055224234*^9}, {3.8514605960168447`*^9, 
  3.85146065000982*^9}, {3.8514606951589823`*^9, 3.8514607273770313`*^9}, {
  3.851532372210264*^9, 3.851532437965156*^9}},
 CellLabel->
  "In[509]:=",ExpressionUUID->"d8ca0cd3-fc9a-40e1-a6d8-65aefd2da0f9"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{}, {{{}, {}, 
       TagBox[{
         Hue[0.67, 0.6, 0.6], 
         Directive[
          PointSize[
           NCache[
            Rational[1, 90], 0.011111111111111112`]], 
          AbsoluteThickness[1.6], 
          RGBColor[1, 0, 0]], 
         LineBox[CompressedData["
1:eJwt03tME1YUBvDOmDkNKplgZJr4GIkaqlNCUCKRDyS+YlRUlCBbFikbg2oR
AVExFMFaHWi1paLgPSViRUE0gk9cmYaJolGHCC0SJQ4XCQoIpYAaWee5Nzm5
+SXnj3NO8k3folkXN0KhUCx11///l5cuUF7XZKrrU4V+cYbAPpuX6+PUX9ha
gff+5ipjv3SOQJhW5582Op6tF/CITfHuLZbOFYiuqHtRPfQb2yCQnNzpW92f
wDYJjIyoWazsSmQXCFSdXXDpGanZRQKlOuv5qc1b2RaBmTdcN4dCNOwSgRsf
z9RHTUtilwr0PDdmN7RJlwuMWX8y3lS1nX1JQJddaVlpS2ZXufujMwZmlO5g
XxewFQeWaAwp7FsC/c2OM+dXp7L/FOjsWGvZH5/GrhWIqRmv8rTuZN8TuGUN
d9hy0tkPBez9WR82FO9iPxF45GrerOzZzW4UyFPaj9XkZ7Dt7nnvnmu/tmkv
u1Xgp7KK2nHV0m0CjX0J5sqATHa7wN3oGmX3Ii37jcBQzNEWfbv0WwGL3vul
2pjF7hFI2zvgfDso7RSImlC78WLEPvagwMPdH8pepUh/Emjw/mPyowFpBSHY
+FXUYEM2eySh/fDokFxdDvsbguOB6d0i7Gd7EKw/xL64PFHH9iSYj6sibR4H
2F4EL7+5o/a0SE8iaA89KVx1Qs+eQnD6BOntTdLTCIklVzO/DzjI9iV0W7Wz
LxZLzyL0LlFEVEQeYisJrsrKsfq5v7PnESa5PF+XBuayAwhNvcP2Iyvy2AsJ
l0f4/Gr4VzqYMKvQed/33WE2COuWdf64bI6BHU4I0wSHtxqklxO2FQU5M8Ye
Za8iTLyjtneUS68l3N74ekqA+Rh7AyGwxE/5ncbIjnLvu74l6+lWEzuGsDTo
65ke6nz2z4TJzWWKNd3SKsJwXI/K82/peMJs7/rGwV4zW014tvr0ubjHx9lJ
hJ1dkfOvqArYKYQtuhWpsf4n2Onu+9UvvNA4/qTMP+FIV/DzvAZpLSHprw5H
Zn6hzD9hjF/IP5bkIpl/wrjPBUaH3ymZf8KVxCW137aeCv0PDdh8qw==
          "]]}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$142736, {1}}]& ], 
       TagBox[{
         Hue[0.9060679774997897, 0.6, 0.6], 
         Directive[
          PointSize[
           NCache[
            Rational[1, 90], 0.011111111111111112`]], 
          AbsoluteThickness[1.6], 
          RGBColor[0, 0, 1]], 
         LineBox[CompressedData["
1:eJwt03tME3YQB/Bm4FC0ilEUHbqO+UBdnQNlzAd8mYQZQWIYA0MQCRYHgoBQ
CSogogMLSBqkoFDuUJG4zTA0aHwtGnyha8DXIokdmInxMZ2KrjhfW/V+l1wu
n//ucvl+kpQZlfyBRqMJc/a7+b7yCCU35g68DDOEvHc+AUvGV3NQsriIcPz8
iWVNvcpbCfYJC3/dbVsl3kbI2pcaaY/8XlxBsCz2vZxrShGbCfq40an+cani
asKWjrLybJ/V4p0E40bvH+c1KlsJ5w7ixfBf0sSNBPf28OWuHeniJkJL2mxb
Q+Ua8X6CJ/3zW+jvGeIDhLtefo9Oj8sStxJcHPHPNG+V2wjF446ND76wVnyU
8KdXb1duSbb4JCHea8WR7sk54tOEGN8Myz0Xo/gsIam1wmWOxzpxB2HWkGnW
sa65Yhuh65RbrbVf+TKhP2aRdpA2T3ydkJMQVzevfL24m9B35LBb/5cbxHZC
rcvEU7o65VuExzWehcY/Nor7nPs+/Tl86ogC8T1CZvmd1wnRheKHhOkfDUmK
Nm0SPyGEDk/OKJpUJH5OKCw+t2t1jPILwn6/dWNtwcqvCT3p7i16k7KG8eTi
q079zM1iV0ZF8F9XIkh5MOPznpqoRP9i8TCGKfO7Uo1D2YOxO26KQ2/bIh7N
iHn0pnFJ4VaxF2NlHx7qAn4QezMSn14KqqpU1jEiRk7frp1SIp7EMFRd+WbT
XmVfRtfFBQX1hlLxZ4y/tcFnblZvE89iPJ459MbAgEk8m7FHF/SAO8rEgYzm
zlKzz8Ry8XzGF4cm13zoWSEG47i5Jc2/bLs4lLEgXjsUukrxIoZjR7s2oFc5
grEwwPDGdZBZvJRxaVR9gfU/5WiGn+VTh09KlXgZ44BHd1RIyQ5xPGOEI9+t
p6tanMhYf980uLnTIjYwrmZGWoOKlVMYGywJXxlX1YrTGf3zT8TOeLVTnOW8
byChzGzfJTYywn66GRYbUSfOY0RijHdOu3K+c9/Aa20f31IuYrgfXdlW+229
yj8jI7zldmO2VeWf8fbf62tMXzeo/Dv/macPfGlvCPkf7sZgLg==
          "]]}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$142736, {2}}]& ], 
       TagBox[{
         Hue[0.1421359549995791, 0.6, 0.6], 
         Directive[
          PointSize[
           NCache[
            Rational[1, 90], 0.011111111111111112`]], 
          AbsoluteThickness[1.6], 
          RGBColor[0, 1, 0], 
          Dashing[{Small, Small}]], 
         LineBox[CompressedData["
1:eJwt031M1AUYB/DzIEPXjRDmGLqFZVmK7pADPLzY9yToRrGRIREiJIGcG+xu
aseFguw6T4LzJDoTXT0PKmsgrbTBrBMXWnPXYKiIIL6QS2TgNJih84gxyef3
bM+effY8fzzbs2dZoWVjsVqlUqXN5f/1edgJmp8nP3UHaY3PvYcQlfhPekZn
rLia0Lim+Wq2f63YSei8/3vpv51x4hrC/d6U8FdMOrGbcNd7tzbVEy+uJ3TH
LrFkjiSIvYQpY6p9/hvrxI2EkMP7h9QPFX9L0P2oeW92VZK4idAV1uvRZ68X
NxOcrZHhCysN4hZCu/bJr0lIFv8wt4/G2rYyAuJThJX7NBMvZBnF7QRLnKvA
3LhB/AvBFbr92IGHKeJOQmz/uVi9OlXcRYjJj9d/aU0T/0EYGPw+OsxmEvsJ
5spD9dMt6eIewtDw+byBVRniy4RHSRPqLTWZ4n6CLbFvcVHHh+LrhOwvKkLn
b84W3yIM3mnwzfbmiO8QNgzFXDswnCseIWjDfRl9kfniMUJk8Niax6e2ih8Q
ptV/GfuyisSThNH+aH9U1zbxFGFe8Im9ZZtKxE8JJ2+EmD6KUjxDWLqvuS7h
J8UqRtrryfYrNWZxMGN00v/uSPp2cQijcfXpas/WMvFLjMySi61n2q3ilxnd
G/ML2s7uEEcwEv/L3Wk8ulMcybg8qKWOS5+JlzJaLeM676hNHM0wWHP0C6rs
4uUMx3e29bpHit9kWEp/M9U3VYhjGJfKW2eOH6wUaxkvJozdatJWiXWMQPcF
d61G8TrGn8nelJZhZd7AKHfaek8H7RWDUeF9EFo7pvgdxky8b+qDc4pNjEJf
eUDlqBa/z+C6BYULXQ5xJiN4s+4t8w2nOIvhurnbqz3sEucw7OOW/UUVNeI8
xoWIwNthR+rEnzBmx3ue1hs94iJGrWHC91qHW2xm/J0bKPeUHRSXMpbz2bbA
7q/EVsarxT0ngq4r3jV3vyM0tSivQWxnFKQe8hdcVbyHce/eis9LupX5aoZ7
2uEYXKT0nYx5qIoz6L9W/p8xYPpY/Y3Vq/w/I6K4P+/2ea/xGSbiYSI=
          "]]}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$142736, {3}}]& ], 
       TagBox[{
         Hue[0.37820393249936934`, 0.6, 0.6], 
         Directive[
          PointSize[
           NCache[
            Rational[1, 90], 0.011111111111111112`]], 
          AbsoluteThickness[1.6], 
          RGBColor[0, 1, 0]], 
         LineBox[CompressedData["
1:eJwt039MFGQYB/ADWdJEoobMoVtWmlI0m+WEQfa9DQ2Fity51Jz8OA4PdnoH
HReexK8zPA8MUKIkex42mZCeQIpFUKTAFrXGiIjh6YVtSEQWUGCEsTp93nd7
9u7zz/u8z/vu+1iaeYfBX6PRbPXVvf3+yiPkuM53e//ep73vfEL04gB9XXaK
uIjgan49xxaeKj5C+HY+5JjnL2UnoXnLgpbS0sTlBGvW9p6aAr24kjBYVzpb
8mK6uJrg7FzpfWBO+QNC8vWIruB0g/g0od7pd27BnCGu8/XTGB+3F+8X1xMu
74ywRycZxY2E8o5ubWllpthNMFUf3/r9tSxxCyFh48n4yWKTuJUQ0O4sTPA7
KG4jpA5P5n/kMIu/IAS2j/Sd0VnEVwjbT0X+bNuULe4hfPZVvfbLiBxxL2Hm
x+T1cUPK3xEWPawte+TjN8X9hAwrLjzZZBUP+uZPaoupuZMrHvad79mpzzXY
xDcI6y9mHiqsUb5JsPzwu+6llrfEo4TJqZD/wjhPPE4YHjHfvtp4SHybkL37
c8uGi3bxFKH21VOrvJGHxTOEkqauNXfcynOE+YiBs5p+5X8JN83b7JYP88Ua
RoL2pwbPzNviAEb/4IJxU1ChOJBRvy1r+fGlReIghstxyz19TjmEsS+29f3e
tGJxKKP20hSZ5pWXM14ZTy77x14iXskIMw9dH2tVXsW4cWYi9plQh3g145vD
bakFB5TXMTr36OI3Bh0RRzKeCqyiAy3KzzLqbIG206Z3xM8zpqPmoq/FlIqj
GCNLSpL+6FaO9d3fHdrwqeuoGIxPnu7QL37PKY5jNC3VfP3oimPieMaG1wxv
pLQrJzLcVyx8y+ESJzEmhmbDH+ooE+sYbaPmmQc95eJdDMufBwd2r31XvJfh
faGi4OXMCnEKI7Fn0Qq/WeV0RkzODmNflbKRcXdgXfiUo1JsYsSvrvg1eUmV
2MJYU6iLCt6vbGU4nzj/XPOYch7jaK3/L/7WEyr/vvdf5uS108pFvv86O92y
TH9S5Z/hKf4tNW5C2ckInt28+e6uapV/RqhhcK/3arX2fz8faxw=
          "]]}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$142736, {4}}]& ]}, {
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$142736, {1}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$142736, {2}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$142736, {3}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$142736, {4}}]& ]}, {
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$142736, {1}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$142736, {2}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$142736, {3}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$142736, {
          4}}]& ], {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, {
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$142736, {1}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$142736, {2}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$142736, {3}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$142736, {
          4}}]& ], {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}}, {{}, \
{}}}, {DisplayFunction -> Identity, DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {1948.5625, 0}, DisplayFunction :> 
     Identity, Frame -> {{False, False}, {False, False}}, 
     FrameLabel -> {{None, None}, {None, None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> 600, 
     Method -> {
      "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
       "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& )}}, PlotLabel -> 
     FormBox["\"World GDP (N=180, extrapolated)\"", TraditionalForm], 
     PlotRange -> {{1948.5625, 2019.}, {0, 1.2525531004440455`*^8}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.05]}}, Ticks -> {Automatic, Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{
      "\"constant 2017, PPP, national prices (in 2017 USD)\"", 
       "\"constant 2017, PPP, chained PPP prices (in 2017 USD)\"", 
       "\"Nominal, Current (in 2017 USD)\"", 
       "\"Nominal, Constant, Calculated (in 2017 USD)\""}, "LineLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.8, 0.5}}}], "Grid"]}, {
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.8, 0.5}}}], "Grid"]}, {
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 1, 0], 
                    Dashing[{Small, Small}]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 1, 0], 
                    Dashing[{Small, Small}]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.8, 0.5}}}], "Grid"]}, {
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 1, 0]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 1, 0]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #4}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.8, 0.5}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxDividers -> {"Columns" -> {{None}}, "Rows" -> {{None}}}, 
             GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
             GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{1}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0, 0], Editable -> False, Selectable -> 
                    False]}], "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 0, 1], Editable -> False, Selectable -> 
                    False]}], "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0.6666666666666666, 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "1", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 1, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 1, 0], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"Small", ",", "Small"}], "}"}], "]"}]}], "]"}], 
                   ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0.6666666666666666, 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "1", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 1, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 1, 0], Editable -> False, Selectable -> 
                    False]}], "]"}]}], "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0, 0], Editable -> False, Selectable -> 
                    False]}], "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 0, 1], Editable -> False, Selectable -> 
                    False]}], "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0.6666666666666666, 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "1", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 1, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 1, 0], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"Small", ",", "Small"}], "}"}], "]"}]}], "]"}], 
                   ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0.6666666666666666, 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "1", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 1, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 1, 0], Editable -> False, Selectable -> 
                    False]}], "]"}]}], "}"}]}], "}"}], ",", 
           RowBox[{"{", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{#, ",", #2, ",", #3, ",", #4}], "}"}], ",", 
               RowBox[{"{", "}"}]}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"None", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"None", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"None", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"None", ",", "Automatic"}], "}"}]}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], 
               "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"True", ",", "True", ",", "True", ",", "True"}], 
                   "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"True", ",", "True", ",", "True", ",", "True"}], 
                   "}"}]}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Row\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "Below"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.850412260781076*^9, {3.850412343303944*^9, 3.8504123737286053`*^9}, 
   3.8504126679154797`*^9, 3.8504133392511625`*^9, 3.850413572176487*^9, {
   3.850413824833519*^9, 3.8504138511758423`*^9}, 3.8514230650847163`*^9, 
   3.8514244432501354`*^9, 3.8514247238122087`*^9, 3.8514605616362534`*^9, 
   3.85146063227024*^9, 3.851460728484412*^9, 3.851532349316595*^9, 
   3.85153238217837*^9, {3.8515324224067864`*^9, 3.8515324456145105`*^9}, 
   3.8725153809175205`*^9, 3.8725670106738477`*^9, 3.873010980158305*^9, 
   3.874480569200127*^9},
 CellLabel->
  "Out[509]=",ExpressionUUID->"d3aa4fc6-da18-44ca-859a-01232a5ffaad"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ncoratio", "=", "ncapPPPfull"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ncoratio", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", 
      RowBox[{"2", ";;"}]}], "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"ncapPPPfull", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", 
       RowBox[{"2", ";;"}]}], "]"}], "]"}], "/", 
    RowBox[{"noutPPPfull", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", 
       RowBox[{"2", ";;"}]}], "]"}], "]"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.849152102497772*^9, 3.8491521630535126`*^9}},
 CellLabel->
  "In[510]:=",ExpressionUUID->"ba6458e1-8409-45a7-9d0f-1f35ad4819fa"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"check", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "70"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "2"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"check", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", "1"}], "]"}], "]"}], "=", 
     RowBox[{"1950", "+", "i", "-", "1"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", "70"}], "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"check", "[", 
    RowBox[{"[", 
     RowBox[{";;", ",", "2"}], "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"ncaptotal", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", "2"}], "]"}], "]"}], "/", 
    RowBox[{"noutPPPtotal", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", "2"}], "]"}], "]"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.8491219791569705`*^9, 3.8491220439469385`*^9}, {
   3.8491222037735558`*^9, 3.849122234426328*^9}, {3.8491222684606943`*^9, 
   3.849122298501167*^9}, {3.8514235135720844`*^9, 3.851423513994829*^9}, 
   3.8725155077268486`*^9},
 CellLabel->
  "In[512]:=",ExpressionUUID->"45be73bb-8c89-4d4f-bb66-5f668608313c"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ncosummary", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "71"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "8"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ncosummary", "[", 
   RowBox[{"[", "1", "]"}], "]"}], "=", 
  RowBox[{"{", 
   RowBox[{
   "\"\<year\>\"", ",", "\"\<mean\>\"", ",", "\"\<median\>\"", ",", 
    "\"\<05-CI\>\"", ",", "\"\<95-CI\>\"", ",", "\"\<Min\>\"", ",", 
    "\"\<Max\>\"", ",", "\"\<Aggregated\>\""}], 
   "}"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ncosummary", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "1"}], "]"}], "]"}], "=", 
   RowBox[{"ncapPPPfull", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "1"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ncosummary", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"i", ";;"}], ",", "2"}], "]"}], "]"}], "=", 
    RowBox[{"Mean", "[", 
     RowBox[{"ncoratio", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", 
        RowBox[{"2", ";;"}]}], "]"}], "]"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ncosummary", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"i", ";;"}], ",", "3"}], "]"}], "]"}], "=", 
    RowBox[{"Median", "[", 
     RowBox[{"ncoratio", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", 
        RowBox[{"2", ";;"}]}], "]"}], "]"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ncosummary", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"i", ";;"}], ",", "4"}], "]"}], "]"}], "=", 
    RowBox[{"Quantile", "[", 
     RowBox[{
      RowBox[{"ncoratio", "[", 
       RowBox[{"[", 
        RowBox[{"i", ",", 
         RowBox[{"2", ";;"}]}], "]"}], "]"}], ",", "0.05"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ncosummary", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"i", ";;"}], ",", "5"}], "]"}], "]"}], "=", 
    RowBox[{"Quantile", "[", 
     RowBox[{
      RowBox[{"ncoratio", "[", 
       RowBox[{"[", 
        RowBox[{"i", ",", 
         RowBox[{"2", ";;"}]}], "]"}], "]"}], ",", "0.95"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ncosummary", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"i", ";;"}], ",", "6"}], "]"}], "]"}], "=", 
    RowBox[{"Min", "[", 
     RowBox[{"ncoratio", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", 
        RowBox[{"2", ";;"}]}], "]"}], "]"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ncosummary", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"i", ";;"}], ",", "7"}], "]"}], "]"}], "=", 
    RowBox[{"Max", "[", 
     RowBox[{"ncoratio", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", 
        RowBox[{"2", ";;"}]}], "]"}], "]"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ncosummary", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "8"}], "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"ncaptotal", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", "2"}], "]"}], "]"}], "/", 
    RowBox[{"noutPPPtotal", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", "2"}], "]"}], "]"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.849162400126461*^9, 3.8491626101154337`*^9}, {
   3.849162833638878*^9, 3.8491628462128673`*^9}, {3.849162946385274*^9, 
   3.84916296783436*^9}, {3.8491635433150043`*^9, 3.84916360274291*^9}, {
   3.84916399783294*^9, 3.849164030084038*^9}, {3.849287790771019*^9, 
   3.8492878207267065`*^9}, {3.849291409578245*^9, 3.849291457617323*^9}, 
   3.8492914902045097`*^9, 3.85142352354086*^9},
 CellLabel->
  "In[515]:=",ExpressionUUID->"04ed6b99-9aef-4161-a066-6f87a77e0800"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"year\"\>", ",", "\<\"mean\"\>", ",", "\<\"median\"\>", 
   ",", "\<\"05-CI\"\>", ",", "\<\"95-CI\"\>", ",", "\<\"Min\"\>", 
   ",", "\<\"Max\"\>", ",", "\<\"Aggregated\"\>"}], "}"}]], "Output",
 CellChangeTimes->{3.8514235255019016`*^9, 3.851424740650429*^9, 
  3.872515542613841*^9, 3.872567025002471*^9, 3.87301099933445*^9, 
  3.874480582653926*^9},
 CellLabel->
  "Out[516]=",ExpressionUUID->"c9aa627c-73fd-48fc-a877-fb77026043ff"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fcpobs", "=", 
  RowBox[{"ListLinePlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Legended", "[", 
       RowBox[{
        RowBox[{"ncosummary", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}], ",", 
        RowBox[{"Placed", "[", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"\"\<Mean\>\"", ",", 
            RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
            RowBox[{"FontSize", "\[Rule]", "18"}]}], "]"}], ",", "Below"}], 
         "]"}]}], "]"}], ",", 
      RowBox[{"Legended", "[", 
       RowBox[{
        RowBox[{"ncosummary", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "3"}], "}"}]}], "]"}], "]"}], ",", 
        RowBox[{"Placed", "[", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"\"\<Median\>\"", ",", 
            RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
            RowBox[{"FontSize", "\[Rule]", "18"}]}], "]"}], ",", "Below"}], 
         "]"}]}], "]"}], ",", 
      RowBox[{"Legended", "[", 
       RowBox[{
        RowBox[{"ncosummary", "[", 
         RowBox[{"[", 
          RowBox[{";;", ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "8"}], "}"}]}], "]"}], "]"}], ",", 
        RowBox[{"Placed", "[", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"\"\<Aggregated\>\"", ",", 
            RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
            RowBox[{"FontSize", "\[Rule]", "18"}]}], "]"}], ",", "Below"}], 
         "]"}]}], "]"}]}], "}"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Red", ",", 
         RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Blue", ",", 
         RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Green", ",", 
         RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "}"}]}], "}"}]}], 
    ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1950", ",", "2019"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.8", ",", "4"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<year\>\"", ",", "\"\<ratio\>\""}], "}"}]}], ",", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{
       RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
       RowBox[{"FontSize", "\[Rule]", "18"}], ",", "Black"}], "]"}]}], ",", 
    RowBox[{"PlotLabel", "\[Rule]", 
     RowBox[{"Style", "[", 
      RowBox[{"\"\<a) Capital-Output Ratio (N=180)\>\"", ",", 
       RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
       RowBox[{"FontSize", "\[Rule]", "18"}]}], "]"}]}], ",", 
    RowBox[{"GridLines", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2", ",", "2.5", ",", "3", ",", "3.5"}], "}"}], "}"}]}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8491631230744467`*^9, 3.849163157574312*^9}, {
  3.8491632137220645`*^9, 3.8491632204059553`*^9}, {3.8491633558556004`*^9, 
  3.849163363040077*^9}, {3.8492909740402203`*^9, 3.849291024562606*^9}, {
  3.8492911040891056`*^9, 3.8492912045664134`*^9}, {3.8492912405622797`*^9, 
  3.849291250114426*^9}, {3.849291303587417*^9, 3.849291307476453*^9}, {
  3.849291528712917*^9, 3.849291536588784*^9}, {3.8494628493903313`*^9, 
  3.8494628497861795`*^9}, {3.8494637435420227`*^9, 3.849463745585466*^9}, {
  3.8725708392767606`*^9, 3.8725709627913294`*^9}, {3.8725710185858526`*^9, 
  3.872571049767736*^9}, {3.872571170787508*^9, 3.8725711886780868`*^9}, {
  3.872571218811454*^9, 3.872571279801075*^9}, {3.872571440060586*^9, 
  3.8725714992349043`*^9}, {3.872575899951693*^9, 3.87257593176559*^9}, {
  3.872586696867011*^9, 3.8725867131772046`*^9}},
 CellLabel->
  "In[525]:=",ExpressionUUID->"9f17f4de-6975-4e5d-85c2-13f140340f0c"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{}, {{{}, {}, 
       TagBox[{
         Hue[0.67, 0.6, 0.6], 
         Directive[
          PointSize[
           NCache[
            Rational[1, 72], 0.013888888888888888`]], 
          RGBColor[1, 0, 0], 
          AbsoluteThickness[2]], 
         LineBox[CompressedData["
1:eJwt0AtMzXEUB/AbqW6lmddIky7X2iiSWpn0TS61MI9GuCSvYpG1InnULKbE
Grk9xjmmvENcj4witbGU2r0aay155BUqt/LKI/3Pb/vtt8++v3P2Oz+3NXGL
1vdTqVSze/f/s28lEWLMWV5PJlihz7sIA1MMXVWTxKmELFfng2f14jTCMmPw
3nXR4gOEhmzdUpO/OJOgXfZ21vgAcRZhadjIfP8McTbhyqkhxqgz4lxCTYVL
xY9a8XFCcYhHkq5ZfJKg1tu3PDWLCwnN736+cnggPkcwzFu+rbNDXESwcc9V
H3wpLia4W7ye7WkUXyc45B3+kNElLiFcNjzM7/givku45qG+sSS4n+L7hLYj
ESdcw8SVBI0pKPKOTvyod/4x/qbh7VJfTfAJ9N4RAcnrCLnJiWxMFD8l7NvY
skeTKn5O4AJvi6ZW3EhwLItMHmDsr7iZ8OfYoIr6sdaK3xDmT040WwWJ3xNu
3SvVru4QfyI4eVmqf3wXtxNUx+1afZ0GKO4k/B3t16Uzir8T3l76uzjHylZx
D6Hx4czWxG82ilWMM3p1vHac5NYMzzq3GSuOiu0YL/IS/lhG2Sl2ZFTe/mro
DhUPYoxa5euwaZN4KKPiasHjjEzxCEb8/vTT6mi1YhdGvduvlMJI8RhGT+XF
orIGe8XjGIUfWm6kz3FU7M5Inxb44H7bQMUTGVG55s5SFyfFkxnBt8pbq5sk
n8pI/ta5PzZA6v0Yqs+mmvgi8XTG+QD/aXHZYjBO1UT+TtGLZzF277Tk+F5y
UBzCGK9NN+27LJ7LKD5WOSRKJ17A8EnT9t8+WxzO2FBVZ7K+KfNEMHZ412mT
Q8V6xu/NZ094hIhXM7rXxC2IXihe1/sfJa/XPlbLe2IYoVuWv3mZIP1jGb4X
Dv2cYpb7WxnlXz3eNWkkT2C4+c0Ld3YWJzFsmlpqYkPFuxhtw1bSeY30T+11
4cfdgz3FaQzv8sB2g1Z8gOHq2cOuJVKfyWiyPR3eU+6If5UeTZw=
          "]]}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$143742, {1}}]& ], 
       TagBox[{
         Hue[0.9060679774997897, 0.6, 0.6], 
         Directive[
          PointSize[
           NCache[
            Rational[1, 72], 0.013888888888888888`]], 
          RGBColor[0, 0, 1], 
          AbsoluteThickness[2]], 
         LineBox[CompressedData["
1:eJw10XtMzWEYB/Cj03UMEXObamxoLnFaoaO+SC7DWokitJTrqVxbtnA40WWn
Rs6Wiec5OydFc2krK+MPlyK0k/slNCoOyx+ydLGSo9/j3d69++z7Xp49r29C
amSSk0qlCnfMf+vASCcU2HOGPYr6EzrgDMLpYzCUpYn1BK+KgF7dBXEmobLM
9YrmpTib8NP/l0uYXWwk6P2qnm6L7Vd8klAWaOur6BKbCCnzejRhLeIzhG8r
bDFFuSoM+Bzh2Mn4/ugKsZmgzdXGNkWJiwmp4XWhKbHii4TljTHJ6Zniy4Tg
8UUJ7TPE5Y56biXeb14sriQELF23bewscTXhd3/4Rv8T4lsEVdrsstYG8W1C
dnb7xI5X4hqCrma+5pdRXEdYqyrZGHhNXE+IH/aotilqkOInBE9rnAYN4heE
uKkRN0w+TorfEGoLixoibJK/d/QrYoe60Sr5R8Kr+iPRbS3iVkJQzxm1xSb+
SmjaVPBiSpJa8XeC+ym/RU6B4h8E04HUnDyLuINgbNt8LiTBWXE34eP1G4fN
q1wU9xK+PtiZkWoUqxibyj+H2NxcFTsz9OnetRO1YndGZ/7WLQt7xUMY9dZd
z4O+iIczJrUef4t8N8VejPjQoLpLU9wVj2HoNFm25SHiCQyDa1700SFiH0bo
vq53g0vEkxknaoOeeA/1UDyVMdpz0erRN8XTGeNMD4s6non9GS1vPiQFXJXz
AYzI926zXdqlnrmMnmRP0+U2ybWM4sT1zebTYjB8+zaXdo4QhzFUozacVx8U
L2MMfdc69q5dvJKx67Nz4Z2L4gjG3NLqe/r74jWOfl7/rl3ZJ+/HMGp8iq2r
y8VxjK3mnnJrijieMa29sMu8X5zIOLyw0SMyT+7bzqje6/2p+7VY5/iPyoYr
h6pk/25G8x6dgV6L9zNmGuzJXmrZn8744Hp2Aj2WPIMxfG1wbtZ6yfWMOSPt
loL//c9kJNjHVC0wiLMZ5uDS7jWe0m8j4+ftJZZYiwf+Ah16Uko=
          "]]}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$143742, {2}}]& ], 
       TagBox[{
         Hue[0.1421359549995791, 0.6, 0.6], 
         Directive[
          PointSize[
           NCache[
            Rational[1, 72], 0.013888888888888888`]], 
          RGBColor[0, 1, 0], 
          AbsoluteThickness[2]], 
         LineBox[CompressedData["
1:eJwt0QlMznEYB/BXh96ovGHKpOV+zTtXWpnUV2voGDmW3gkdGrnK9RJZyDpI
dBHa81hRoeicK7E3o5TxWnJTlljYTOXYMtL/+W2/Pfvs+T3H9hsTEbM0ykyl
Us3vu/9j/9lNOD83wzHD8Ne73/GElnFPgytnqtDv/YSxU79XmMWJDxFqowM8
cpeIUwgb6rydf+8TpxGSzrqpkgzi44Q1viMOqn+KswmaeQWWxsUDFOcSvHz1
02IjxHkEh+HDnF8tEJ8lZDbyxWcbxecIrj4J+dXl4mJCXO2cQEOFuITQ/tH+
QnSjuIwQU/MuI88kriKcWLeyYGWb+BrhpqdfSrG1meIagnf5nXTrMPEdQm6h
Q3rWQfFdQnO+efrpenE9YUZH7Ko9OnPFTYQJM38aNWXix4T1Z9a+fOtkobiZ
UNFa1XR4u/h5335Vi6jwlKXi1wTDky6H6MKBilsJGx+/bRlfLW4nPJyqH5kw
ykrxJ4Jxi741oVL8hXB33pFIuyi14m+ECHeP/GN6a8XdhO7Xoyf1FIl/Edwb
ynRe5YMU9xLswn0Ov7gkVjECQn+saNeLLRh/tlW2dViI1YwfQ8Isg6zFNowB
N0zjdnVKfw3DPGj0y64W8XCGviBGZf9Q7NjX36guCdZJvRNjdoOfdsoMsQvj
wuSO5J4i8XjG4mUa3RGXwYq1jLjGPL/CcLGOca3JMeL6avF0xofzTW5HIZ7F
uP2+82+3rdiDUXYrdHKmmdiTkZi6rMOpU+aBsTcl+c2YZrEvwzl7+fOtC+X9
QoY22HtraYI4kDG0+t5Eq/viIIbfUcvLiVY2ipczbmm/1wbqxCGMkCJTXomb
OJTRq/5aN3uSOIxR6vVBM/CpeC2DHzjtNH61Vbye4R4aeTX1neQ3Mco9/J80
HBPHMlwPTNfmnBTvYKy6ctLiokG8m1FserQ5PlEcz+jOsu8NXyfez/Cv+Tzs
War4EKOmIDWqskWc0ve/STmmZCvZJ43RtvpcSfxOW/wDizVDlg==
          "]]}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$143742, {3}}]& ]}, {
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$143742, {1}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$143742, {2}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$143742, {3}}]& ]}, {
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$143742, {1}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$143742, {2}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$143742, {
          3}}]& ], {}, {}, {}, {}, {}, {}, {}}, {
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$143742, {1}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$143742, {2}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$143742, {
          3}}]& ], {}, {}, {}, {}, {}, {}, {}}}, {{}, {}}}, {
    DisplayFunction -> Identity, DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {
       FormBox["\"year\"", TraditionalForm], 
       FormBox["\"ratio\"", TraditionalForm]}, AxesOrigin -> {1950., 1.8}, 
     DisplayFunction :> Identity, Frame -> {{False, False}, {False, False}}, 
     FrameLabel -> {{None, None}, {None, None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {{2, 2.5, 3, 3.5}, {2, 2.5, 3, 3.5}}, GridLinesStyle -> 
     Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> 600, LabelStyle -> 
     Directive[FontFamily -> "Helvetica", FontSize -> 18, 
       GrayLevel[0]], 
     Method -> {
      "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
       "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& )}}, PlotLabel -> FormBox[
       StyleBox[
       "\"a) Capital-Output Ratio (N=180)\"", FontFamily -> "Helvetica", 
        FontSize -> 18, StripOnInput -> False], TraditionalForm], 
     PlotRange -> {{1950, 2019}, {1.8, 4}}, PlotRangeClipping -> True, 
     PlotRangePadding -> {{0, 0}, {0, 0}}, Ticks -> {Automatic, Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{
       StyleBox[
       "\"Mean\"", FontFamily -> "Helvetica", FontSize -> 18, StripOnInput -> 
        False], 
       StyleBox[
       "\"Median\"", FontFamily -> "Helvetica", FontSize -> 18, StripOnInput -> 
        False], 
       StyleBox[
       "\"Aggregated\"", FontFamily -> "Helvetica", FontSize -> 18, 
        StripOnInput -> False]}, "LineLegend", DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[1, 0, 0], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[1, 0, 0], 
                    AbsoluteThickness[2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #, 
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0, 0, 1], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0, 0, 1], 
                    AbsoluteThickness[2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2, 
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0, 1, 0], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0, 1, 0], 
                    AbsoluteThickness[2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.8, 0.5}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxDividers -> {"Columns" -> {{None}}, "Rows" -> {{None}}}, 
             GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
             GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{1}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
          Directive[FontFamily -> "Helvetica", FontSize -> 18, 
           GrayLevel[0]], FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "72"], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0, 0], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}], 
                   ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "72"], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 0, 1], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}], 
                   ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "72"], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0.6666666666666666, 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "1", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 1, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 1, 0], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}]}], 
                 "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "72"], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0, 0], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}], 
                   ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "72"], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 0, 1], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}], 
                   ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "72"], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0.6666666666666666, 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "1", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 1, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 1, 0], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}]}], 
                 "}"}]}], "}"}], ",", 
           RowBox[{"{", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{#, ",", #2, ",", #3}], "}"}], ",", 
               RowBox[{"{", "}"}]}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"None", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"None", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"None", ",", "Automatic"}], "}"}]}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], 
               "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"True", ",", "True", ",", "True"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"True", ",", "True", ",", "True"}], "}"}]}], 
               "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
               RowBox[{
                 RowBox[{"FontFamily", "\[Rule]", "\"Helvetica\""}], ",", 
                 RowBox[{"FontSize", "\[Rule]", "18"}], ",", 
                 InterpretationBox[
                  ButtonBox[
                   TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                   BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                   ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                   Automatic, Method -> "Preemptive"], 
                  GrayLevel[0], Editable -> False, Selectable -> False]}], 
               "]"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Row\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "Below"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.849163144851035*^9, 3.8491632214079733`*^9, 3.8491633636097608`*^9, 
   3.849164038478134*^9, 3.8492909861390867`*^9, 3.849291025439652*^9, 
   3.8492911067310915`*^9, {3.8492911909607677`*^9, 3.8492912053470287`*^9}, 
   3.8492912519241495`*^9, 3.849291308908763*^9, 3.8492915374802027`*^9, 
   3.849462850847488*^9, 3.849463746658798*^9, 3.8514245570874724`*^9, 
   3.872521172598085*^9, 3.8725671947937155`*^9, 3.872570825369382*^9, 
   3.872570857646514*^9, {3.8725709047214427`*^9, 3.8725709230382385`*^9}, 
   3.8725709638207493`*^9, {3.872571032977477*^9, 3.872571050666684*^9}, {
   3.8725712204436846`*^9, 3.8725712466533365`*^9}, 3.872571280987281*^9, {
   3.8725714637089396`*^9, 3.8725714999477034`*^9}, {3.8725759144866495`*^9, 
   3.872575932280341*^9}, 3.8725867173685675`*^9, 3.873011013862751*^9, 
   3.8744805908493233`*^9},
 CellLabel->
  "Out[525]=",ExpressionUUID->"7670775e-cadb-4c66-877d-73be2d67531a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fcpobsmoments", "=", 
  RowBox[{"ListLinePlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Legended", "[", 
       RowBox[{
        RowBox[{"ncosummary", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}], ",", 
        "\"\<Mean\>\""}], "]"}], ",", 
      RowBox[{"Legended", "[", 
       RowBox[{
        RowBox[{"ncosummary", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "3"}], "}"}]}], "]"}], "]"}], ",", 
        "\"\<Median\>\""}], "]"}], ",", 
      RowBox[{"Legended", "[", 
       RowBox[{
        RowBox[{"ncosummary", "[", 
         RowBox[{"[", 
          RowBox[{";;", ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "4"}], "}"}]}], "]"}], "]"}], ",", 
        "\"\<05-CI\>\""}], "]"}], ",", 
      RowBox[{"Legended", "[", 
       RowBox[{
        RowBox[{"ncosummary", "[", 
         RowBox[{"[", 
          RowBox[{";;", ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "5"}], "}"}]}], "]"}], "]"}], ",", 
        "\"\<95-CI\>\""}], "]"}]}], "}"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Red", ",", "Blue", ",", 
       RowBox[{"{", 
        RowBox[{"Red", ",", "Dashed"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Red", ",", "Dashed"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1950", ",", "2019"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "10"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{
       RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
       RowBox[{"FontSize", "\[Rule]", "14"}], ",", "Black"}], "]"}]}], ",", 
    RowBox[{"GridLines", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
       "1", ",", "1.5", ",", "2", ",", "2.5", ",", "3", ",", "3.5", ",", "4", 
        ",", "4.5", ",", "5", ",", "6"}], "}"}], "}"}]}], ",", 
    RowBox[{
    "PlotLabel", "\[Rule]", 
     "\"\<Observed Nominal Capital-Output Ratio (N=180)\>\""}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.849517454811266*^9, 3.849517602392634*^9}, {
  3.8495176497812996`*^9, 3.849517697437377*^9}, {3.84951816328083*^9, 
  3.8495181648130264`*^9}},
 CellLabel->
  "In[526]:=",ExpressionUUID->"cf511ed8-12f1-4628-85db-f0b77ab06ec9"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{}, {{{}, {}, 
       TagBox[{
         Hue[0.67, 0.6, 0.6], 
         Directive[
          PointSize[
           NCache[
            Rational[1, 90], 0.011111111111111112`]], 
          AbsoluteThickness[1.6], 
          RGBColor[1, 0, 0]], 
         LineBox[CompressedData["
1:eJwt0AtMzXEUB/AbqW6lmddIky7X2iiSWpn0TS61MI9GuCSvYpG1InnULKbE
Grk9xjmmvENcj4witbGU2r0aay155BUqt/LKI/3Pb/vtt8++v3P2Oz+3NXGL
1vdTqVSze/f/s28lEWLMWV5PJlihz7sIA1MMXVWTxKmELFfng2f14jTCMmPw
3nXR4gOEhmzdUpO/OJOgXfZ21vgAcRZhadjIfP8McTbhyqkhxqgz4lxCTYVL
xY9a8XFCcYhHkq5ZfJKg1tu3PDWLCwnN736+cnggPkcwzFu+rbNDXESwcc9V
H3wpLia4W7ye7WkUXyc45B3+kNElLiFcNjzM7/givku45qG+sSS4n+L7hLYj
ESdcw8SVBI0pKPKOTvyod/4x/qbh7VJfTfAJ9N4RAcnrCLnJiWxMFD8l7NvY
skeTKn5O4AJvi6ZW3EhwLItMHmDsr7iZ8OfYoIr6sdaK3xDmT040WwWJ3xNu
3SvVru4QfyI4eVmqf3wXtxNUx+1afZ0GKO4k/B3t16Uzir8T3l76uzjHylZx
D6Hx4czWxG82ilWMM3p1vHac5NYMzzq3GSuOiu0YL/IS/lhG2Sl2ZFTe/mro
DhUPYoxa5euwaZN4KKPiasHjjEzxCEb8/vTT6mi1YhdGvduvlMJI8RhGT+XF
orIGe8XjGIUfWm6kz3FU7M5Inxb44H7bQMUTGVG55s5SFyfFkxnBt8pbq5sk
n8pI/ta5PzZA6v0Yqs+mmvgi8XTG+QD/aXHZYjBO1UT+TtGLZzF277Tk+F5y
UBzCGK9NN+27LJ7LKD5WOSRKJ17A8EnT9t8+WxzO2FBVZ7K+KfNEMHZ412mT
Q8V6xu/NZ094hIhXM7rXxC2IXihe1/sfJa/XPlbLe2IYoVuWv3mZIP1jGb4X
Dv2cYpb7WxnlXz3eNWkkT2C4+c0Ld3YWJzFsmlpqYkPFuxhtw1bSeY30T+11
4cfdgz3FaQzv8sB2g1Z8gOHq2cOuJVKfyWiyPR3eU+6If5UeTZw=
          "]]}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$144018, {1}}]& ], 
       TagBox[{
         Hue[0.9060679774997897, 0.6, 0.6], 
         Directive[
          PointSize[
           NCache[
            Rational[1, 90], 0.011111111111111112`]], 
          AbsoluteThickness[1.6], 
          RGBColor[0, 0, 1]], 
         LineBox[CompressedData["
1:eJw10XtMzWEYB/Cj03UMEXObamxoLnFaoaO+SC7DWokitJTrqVxbtnA40WWn
Rs6Wiec5OydFc2krK+MPlyK0k/slNCoOyx+ydLGSo9/j3d69++z7Xp49r29C
amSSk0qlCnfMf+vASCcU2HOGPYr6EzrgDMLpYzCUpYn1BK+KgF7dBXEmobLM
9YrmpTib8NP/l0uYXWwk6P2qnm6L7Vd8klAWaOur6BKbCCnzejRhLeIzhG8r
bDFFuSoM+Bzh2Mn4/ugKsZmgzdXGNkWJiwmp4XWhKbHii4TljTHJ6Zniy4Tg
8UUJ7TPE5Y56biXeb14sriQELF23bewscTXhd3/4Rv8T4lsEVdrsstYG8W1C
dnb7xI5X4hqCrma+5pdRXEdYqyrZGHhNXE+IH/aotilqkOInBE9rnAYN4heE
uKkRN0w+TorfEGoLixoibJK/d/QrYoe60Sr5R8Kr+iPRbS3iVkJQzxm1xSb+
SmjaVPBiSpJa8XeC+ym/RU6B4h8E04HUnDyLuINgbNt8LiTBWXE34eP1G4fN
q1wU9xK+PtiZkWoUqxibyj+H2NxcFTsz9OnetRO1YndGZ/7WLQt7xUMY9dZd
z4O+iIczJrUef4t8N8VejPjQoLpLU9wVj2HoNFm25SHiCQyDa1700SFiH0bo
vq53g0vEkxknaoOeeA/1UDyVMdpz0erRN8XTGeNMD4s6non9GS1vPiQFXJXz
AYzI926zXdqlnrmMnmRP0+U2ybWM4sT1zebTYjB8+zaXdo4QhzFUozacVx8U
L2MMfdc69q5dvJKx67Nz4Z2L4gjG3NLqe/r74jWOfl7/rl3ZJ+/HMGp8iq2r
y8VxjK3mnnJrijieMa29sMu8X5zIOLyw0SMyT+7bzqje6/2p+7VY5/iPyoYr
h6pk/25G8x6dgV6L9zNmGuzJXmrZn8744Hp2Aj2WPIMxfG1wbtZ6yfWMOSPt
loL//c9kJNjHVC0wiLMZ5uDS7jWe0m8j4+ftJZZYiwf+Ah16Uko=
          "]]}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$144018, {2}}]& ], 
       TagBox[{
         Hue[0.1421359549995791, 0.6, 0.6], 
         Directive[
          PointSize[
           NCache[
            Rational[1, 90], 0.011111111111111112`]], 
          AbsoluteThickness[1.6], 
          RGBColor[1, 0, 0], 
          Dashing[{Small, Small}]], 
         LineBox[CompressedData["
1:eJwt0wtMjXEYBvBYOHTmTrmEDOU2jSaXxsN02ZFSYWkuCTlKipjOHHdhR1LK
pVXvqzFrRqImzWU016HacRmOS8dBN5coKiHxf7/t27ffnud9/9++7XOJiA1e
2d7Ozs6n7f73/H8lEKxb9qxcaHo1/b+NhNOnKq2pca+VtxMsMRm9DI/EuwkD
TvhbglwqlPcRqoa1C/CqFycRhhY4HzKXWZVTCK5bR+/lorfK6YTL/p5PO2ba
lI8RKt06DZ8e9U45i3AisFVvDn2vfJygG7vfWGr+oHySEDxyIixLq5RzCfGh
GePcr1YrnyG43dg0SJtYo5xPaFkc75jxuFa5kPDCpXmyOeij8iXCn9qXRs3q
T8pXCEvXGe8d/yy+TujVNyY/Nvqz8k3Cw091Rbn9Zf4uwb9BU+l5T/oPCEtq
MoNW+InLCT6BxanZznXKjwn3x/qGpU+Vfc8IC9eE5GX3E78k5IU1J/bf+UW5
om1eO9/Ja85X5XcEm/fGsBmHxVWElPAAbZP3N+WPBN/2scnxF+uV6wi3ChpN
p1IlbyAM8ehQNuWu5E2E17N2FUQUNyj/IvgdOOqg+yK5HcOtMeJsUtx3ZXvG
1M2JDUdzpa9hHPPMyZpxU6xlROXYO+RrpN+d0TLOPMU5T9ybMc1g7XzAJn0n
RvU8XWpKneQDGTvS/ixol9aoPISxOFan1ff5oTyMYSrvGhDvK7kbY1DNwBdp
u8VjGEdKv5p6VEvfnfFmeaj32vmSezBCWsqLLlZIPonxTPP8QmZHsRfj9qHC
Ccti5H3AyGxt2Ty3RPJZjBxjtNGgl9yPMbPiXH23SLE/Y4G+Z8kbg5w3lzEh
LDLOEiOex5i06k5R5BZxKKM1+/Q6j22yf1Hb93L08DR0ljycMVoX+Su9WPav
YBSUJAz+7dCsrGfMto0J7LOpSXkNY2Nyl8HNJPNxDFunW85O+eINjFHXZgaW
ZokTGN+T+eD58bLPyKiM8glPPivezih1H1HbIfin/P+Mk9nb5lifSL6P4V6y
3HV9tJyfxNClmCwZbfN/Aex1gfg=
          "]]}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$144018, {3}}]& ], 
       TagBox[{
         Hue[0.37820393249936934`, 0.6, 0.6], 
         Directive[
          PointSize[
           NCache[
            Rational[1, 90], 0.011111111111111112`]], 
          AbsoluteThickness[1.6], 
          RGBColor[1, 0, 0], 
          Dashing[{Small, Small}]], 
         LineBox[CompressedData["
1:eJw10HtMzWEYB/CzEprYKenmUM1109CKmku+O7k01yiXdBmFkQ4puSTWlKNC
6w/MlPfJJqcWhkOONB2TcqwSS0ltjpTTfkJtlVvi8Hv8tne/ffZ93ud93tc7
du+67TYKhWKpdf39//sOCTic8tclXXTEP6cJjA6/caBmKTtdoLnpcED0K3am
QOjade4N3ewsgSNxNZJ6K/u0gKdmxN3uWew8gabbNsdafitlnxU4Nz9oqLaX
fUGgu69oqHEm1xcIlGuiFwQ+ZRcKXH6/2mzRsa8IZNVvPhFbw/uLBTJ6pEHX
Ac6vCTz7vKz9s4l9U6B6TMoDP0/2HYHHyU4eExRsg8AXXdux2BTuV2Gd5+HJ
qqmRbKO1X9Lzt29K2VUCJYm3fCtM7KcCvbpM7S0Vu9bar+GS7cIV7AaB7DXO
/aWu7EaBDYsNg0272a8FWpP9+20lnqdN4H6g93q12km2WSDs6LWLSjt2h4Dd
+mJ7xzyu7xJoMfeYFF2cdwtYFrnZJoWxewQKp73oPOnN7hPQBywsL1jO/iYw
T8oxzrUfK3tQwKyhXu1/KwgxdWNjrmjZwwhj1Ek70pTOskcSrrb75xuq2Q4E
fbtJNVDJVhLaiiUfycB2JkR+q5wYn8B2I4Qal9ytPz5OtopgF1KpMijZXoRH
vkWTgnLdZU8mpH/ZE7koTiV7OsElJ0ojBXnK9rGepz1a5aX2kj2boN2VccSv
k+1P8NN19CQX8/5AQkCp8bw+f7zsBYQto5xPpH5gg/C7wtf+4DuuX0x4HJ7g
uTOe5wkhrOp64RgY7yF7JSEi7VdzeZ+r7FBCcFlOmXBykx1OqAuNiOnId5G9
ifBS1fExroTvG0W43l9iGlXP77PF+l5kCZE+sbcRzA73cvdlc/1OQkNjblHn
BXYCYYa+LHtjH9cnEqrHta5NGcb5fsLKIkvw1+l8/iHCvsYzOXMsnKcRLMtN
Q0skztMJ7Y7mrCk/2JmE7wPGn70T+T5ZhCf2w1u1YZyfJhzwuJ8apnfBH4K3
WUc=
          "]]}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$144018, {4}}]& ]}, {
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$144018, {1}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$144018, {2}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$144018, {3}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$144018, {4}}]& ]}, {
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$144018, {1}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$144018, {2}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$144018, {3}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$144018, {
          4}}]& ], {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, {
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$144018, {1}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$144018, {2}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$144018, {3}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$144018, {
          4}}]& ], {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}}, {{}, \
{}}}, {DisplayFunction -> Identity, DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {1950., 0}, DisplayFunction :> 
     Identity, Frame -> {{False, False}, {False, False}}, 
     FrameLabel -> {{None, None}, {None, None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {{1, 1.5, 2, 2.5, 3, 3.5, 4, 4.5, 5, 6}, {
       1, 1.5, 2, 2.5, 3, 3.5, 4, 4.5, 5, 6}}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> 600, LabelStyle -> 
     Directive[FontFamily -> "Helvetica", FontSize -> 14, 
       GrayLevel[0]], 
     Method -> {
      "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
       "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& )}}, PlotLabel -> 
     FormBox["\"Observed Nominal Capital-Output Ratio (N=180)\"", 
       TraditionalForm], PlotRange -> {{1950, 2019}, {0, 10}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{0, 0}, {0, 0}}, 
     Ticks -> {Automatic, Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{
      "\"Mean\"", "\"Median\"", "\"05-CI\"", "\"95-CI\"", "None", "None", 
       "None"}, "LineLegend", DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0], 
                    Dashing[{Small, Small}]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0], 
                    Dashing[{Small, Small}]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0], 
                    Dashing[{Small, Small}]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0], 
                    Dashing[{Small, Small}]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #4}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
          Directive[FontFamily -> "Helvetica", FontSize -> 14, 
           GrayLevel[0]], FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0, 0], Editable -> False, Selectable -> 
                    False]}], "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 0, 1], Editable -> False, Selectable -> 
                    False]}], "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0, 0], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"Small", ",", "Small"}], "}"}], "]"}]}], "]"}], 
                   ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0, 0], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"Small", ",", "Small"}], "}"}], "]"}]}], "]"}]}], 
                 "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0, 0], Editable -> False, Selectable -> 
                    False]}], "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 0, 1], Editable -> False, Selectable -> 
                    False]}], "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0, 0], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"Small", ",", "Small"}], "}"}], "]"}]}], "]"}]}], 
                 "}"}]}], "}"}], ",", 
           RowBox[{"{", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{#, ",", #2, ",", #3, ",", #4}], "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{#5, ",", #6, ",", #7}], "}"}]}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"None", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"None", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"None", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"None", ",", "Automatic"}], "}"}]}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], 
               "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"True", ",", "True", ",", "True", ",", "True"}], 
                   "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"True", ",", "True", ",", "True", ",", "True"}], 
                   "}"}]}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
               RowBox[{
                 RowBox[{"FontFamily", "\[Rule]", "\"Helvetica\""}], ",", 
                 RowBox[{"FontSize", "\[Rule]", "14"}], ",", 
                 InterpretationBox[
                  ButtonBox[
                   TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                   BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                   ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                   Automatic, Method -> "Preemptive"], 
                  GrayLevel[0], Editable -> False, Selectable -> False]}], 
               "]"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.8495175637063684`*^9, {3.849517598174828*^9, 3.8495176029118986`*^9}, {
   3.849517667386669*^9, 3.849517671562045*^9}, 3.8495177019068675`*^9, 
   3.8495181657283907`*^9, 3.8514245634536705`*^9, 3.872521185587211*^9, 
   3.872571627165444*^9, 3.874480594570557*^9},
 CellLabel->
  "Out[526]=",ExpressionUUID->"43de7273-717a-4b42-a1bf-32193fbba314"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<Fcpobsmoments.tiff\>\"", ",", "fcpobsmoments"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.849517706180951*^9, 3.849517722102002*^9}},
 CellLabel->
  "In[888]:=",ExpressionUUID->"81d08c00-bcdb-43a4-8387-a5389a032114"],

Cell[BoxData["\<\"Fcpobsmoments.tiff\"\>"], "Output",
 CellChangeTimes->{
  3.8495177231273766`*^9, {3.849518170650247*^9, 3.8495181860804377`*^9}},
 CellLabel->
  "Out[888]=",ExpressionUUID->"14190cc4-97c0-4af0-a71d-b1d650bd9c08"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"fcpnoexobs", "=", 
   RowBox[{"ListLinePlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Legended", "[", 
        RowBox[{
         RowBox[{"nconoexsummary", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}], ",", 
         "\"\<Mean\>\""}], "]"}], ",", 
       RowBox[{"Legended", "[", 
        RowBox[{
         RowBox[{"nconoexsummary", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "3"}], "}"}]}], "]"}], "]"}], ",", 
         "\"\<Median\>\""}], "]"}], ",", 
       RowBox[{"Legended", "[", 
        RowBox[{
         RowBox[{"nconoexsummary", "[", 
          RowBox[{"[", 
           RowBox[{";;", ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "8"}], "}"}]}], "]"}], "]"}], ",", 
         "\"\<Aggregated\>\""}], "]"}]}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Red", ",", "Blue", ",", "Green"}], "}"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1950", ",", "2019"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1.5", ",", "4"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"LabelStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{
        RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
        RowBox[{"FontSize", "\[Rule]", "14"}], ",", "Black"}], "]"}]}], ",", 
     RowBox[{
     "PlotLabel", "\[Rule]", 
      "\"\<Observed Nominal Capital-Output Ratio (N=55)\>\""}], ",", 
     RowBox[{"GridLines", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"2", ",", "2.5", ",", "3", ",", "3.5"}], "}"}], "}"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.849293079818202*^9, 3.8492931244501576`*^9}, {
  3.8494627707827406`*^9, 3.849462798660964*^9}, {3.8494635242302523`*^9, 
  3.849463577652025*^9}, {3.8494636609683113`*^9, 3.8494637201028943`*^9}, {
  3.8495178939045362`*^9, 3.849517894087201*^9}, {3.8514246481264453`*^9, 
  3.851424652402339*^9}},
 CellLabel->
  "In[364]:=",ExpressionUUID->"c393dd95-e180-41f9-8dfa-5542e69b8f16"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"fcpnoexobsmoments", "=", 
   RowBox[{"ListLinePlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Legended", "[", 
        RowBox[{
         RowBox[{"nconoexsummary", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}], ",", 
         "\"\<Mean\>\""}], "]"}], ",", 
       RowBox[{"Legended", "[", 
        RowBox[{
         RowBox[{"nconoexsummary", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "3"}], "}"}]}], "]"}], "]"}], ",", 
         "\"\<Median\>\""}], "]"}], ",", 
       RowBox[{"Legended", "[", 
        RowBox[{
         RowBox[{"nconoexsummary", "[", 
          RowBox[{"[", 
           RowBox[{";;", ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "4"}], "}"}]}], "]"}], "]"}], ",", 
         "\"\<05-CI\>\""}], "]"}], ",", 
       RowBox[{"Legended", "[", 
        RowBox[{
         RowBox[{"nconoexsummary", "[", 
          RowBox[{"[", 
           RowBox[{";;", ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "5"}], "}"}]}], "]"}], "]"}], ",", 
         "\"\<95-CI\>\""}], "]"}]}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Red", ",", "Blue", ",", 
        RowBox[{"{", 
         RowBox[{"Red", ",", "Dashed"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Red", ",", "Dashed"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1950", ",", "2019"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "7"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"LabelStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{
        RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
        RowBox[{"FontSize", "\[Rule]", "14"}], ",", "Black"}], "]"}]}], ",", 
     RowBox[{
     "PlotLabel", "\[Rule]", 
      "\"\<Observed Nominal Capital-Output Ratio (N=55)\>\""}], ",", 
     RowBox[{"GridLines", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "1.5", ",", "2", ",", "2.5", ",", "3", ",", "3.5", ",", "4",
          ",", "4.5", ",", "5", ",", "6"}], "}"}], "}"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.849518000809767*^9, 3.8495180741718936`*^9}, {
  3.849518115177416*^9, 3.8495181389222193`*^9}, {3.849518254971374*^9, 
  3.8495182560506706`*^9}, {3.8514246717742863`*^9, 3.8514246756498737`*^9}},
 CellLabel->
  "In[365]:=",ExpressionUUID->"31e1c61f-cf97-43ba-9a8e-64a1e634538b"],

Cell["\<\
Using capital output ratio to determine capital stock time series \
\>", "Text",
 CellChangeTimes->{{3.851461073055309*^9, 3.8514611207164297`*^9}, 
   3.872521203611925*^9},
 FontSize->24,ExpressionUUID->"b119cbc0-e003-4d91-9181-4f8b53c50781"],

Cell[BoxData[
 RowBox[{
  RowBox[{"FigOutput", "=", 
   RowBox[{"ListLinePlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Legended", "[", 
        RowBox[{
         RowBox[{"outtotal", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}], ",", 
         "\"\<constant 2017, PPP, national prices (in 2017 USD)\>\""}], "]"}],
        ",", 
       RowBox[{"Legended", "[", 
        RowBox[{
         RowBox[{"rgdpototal", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}], ",", 
         "\"\<constant 2017, PPP, chained PPP prices (in 2017 USD)\>\""}], 
        "]"}], ",", 
       RowBox[{"Legended", "[", 
        RowBox[{
         RowBox[{"noutPPPtotal", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}], ",", 
         "\"\<Nominal, Current (in 2017 USD)\>\""}], "]"}], ",", 
       RowBox[{"Legended", "[", 
        RowBox[{
         RowBox[{"noutPPPcalctotal", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}], ",", 
         "\"\<Nominal, Constant, Calculated (in 2017 USD)\>\""}], "]"}]}], 
      "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Red", ",", "Blue", ",", 
        RowBox[{"{", 
         RowBox[{"Green", ",", "Dashed"}], "}"}], ",", "Green"}], "}"}]}], 
     ",", 
     RowBox[{"PlotLabel", "\[Rule]", "\"\<World GDP\>\""}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{3.872521222017996*^9},
 CellLabel->
  "In[1951]:=",ExpressionUUID->"c633c27d-a174-46c4-864b-79ad744f3ec1"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"capoutresults", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "71"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "22"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"capoutresults", "[", 
    RowBox[{"[", "1", "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
    "\"\<year\>\"", ",", "\"\<rgdpo\>\"", ",", "\"\<rgdpna\>\"", ",", 
     "\"\<ngdpcalc\>\"", ",", "\"\<cap_rgdpo\>\"", ",", "\"\<cap_rgdpna\>\"", 
     ",", "\"\<cap_ngdpcalc\>\"", ",", "\"\<depreciation\>\"", ",", 
     "\"\<inv_rgdpo\>\"", ",", "\"\<inv_rgdpna\>\"", ",", 
     "\"\<inv_ngdpcalc\>\"", ",", "\"\<share_rgdpo\>\"", ",", 
     "\"\<share_rgdpna\>\"", ",", "\"\<share_ngdpcalc\>\"", ",", 
     "\"\<csh_i\>\"", ",", "\"\<p_csh_i\>\"", ",", "\"\<im_inv_rgdpo\>\"", 
     ",", "\"\<im_inv_rgdpna\>\"", ",", "\"\<im_inv_ngdpcalc\>\"", ",", 
     "\"\<im_cap_rgdpo\>\"", ",", "\"\<im_cap_rgdpna\>\"", ",", 
     "\"\<im_cap_ngdpcalc\>\""}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"capoutresults", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "1"}], "]"}], "]"}], "=", 
   RowBox[{"outtotal", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "1"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"capoutresults", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "2"}], "]"}], "]"}], "=", 
   RowBox[{"rgdpototal", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "2"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"capoutresults", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "3"}], "]"}], "]"}], "=", 
   RowBox[{"outtotal", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "2"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"capoutresults", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "4"}], "]"}], "]"}], "=", 
   RowBox[{"noutPPPcalctotal", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "2"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"capoutresults", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "5"}], "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"capoutresults", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", "2"}], "]"}], "]"}], "*", 
    RowBox[{"ncosummary", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", "8"}], "]"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"capoutresults", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "6"}], "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"capoutresults", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", "3"}], "]"}], "]"}], "*", 
    RowBox[{"ncosummary", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", "8"}], "]"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"capoutresults", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", "7"}], "]"}], "]"}], "=", 
    RowBox[{
     RowBox[{"capoutresults", "[", 
      RowBox[{"[", 
       RowBox[{
        RowBox[{"2", ";;"}], ",", "4"}], "]"}], "]"}], "*", 
     RowBox[{"ncosummary", "[", 
      RowBox[{"[", 
       RowBox[{
        RowBox[{"2", ";;"}], ",", "8"}], "]"}], "]"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.8514611695996428`*^9, 3.8514612737951994`*^9}, {
   3.8514613630112453`*^9, 3.8514615328660507`*^9}, {3.8514622206606817`*^9, 
   3.851462242417326*^9}, 3.851462277243823*^9, {3.8514623096938224`*^9, 
   3.85146231505926*^9}, {3.851462349987711*^9, 3.851462365010931*^9}, {
   3.85146310120609*^9, 3.851463170430074*^9}, {3.8514640149297943`*^9, 
   3.8514640407680607`*^9}, {3.851465474235702*^9, 3.851465490787387*^9}, {
   3.851504914150143*^9, 3.851504930744281*^9}, {3.8515103605972304`*^9, 
   3.8515104750454245`*^9}},
 CellLabel->
  "In[527]:=",ExpressionUUID->"dd907f42-c99b-4d17-a6ec-a1bb4cad6a8e"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"depdat", "=", 
   RowBox[{
   "Import", "[", "\"\<depreciation_data_PWT_Transposed.csv\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Dimensions", "[", "depdat", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"depraw", "=", 
   RowBox[{"depdat", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", ";;"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Dimensions", "[", "depraw", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"depraw2", "=", "depraw"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"Do", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"depraw2", "[", 
       RowBox[{"[", 
        RowBox[{"i", ",", "j"}], "]"}], "]"}], "=", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"depraw", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "j"}], "]"}], "]"}], "\[Equal]", "\"\<\>\""}], 
        ",", "0", ",", 
        RowBox[{"depraw", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "j"}], "]"}], "]"}]}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"j", ",", "2", ",", "181"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.8514629380518446`*^9, 3.851462939281989*^9}},
 CellLabel->
  "In[537]:=",ExpressionUUID->"fcec4030-6e16-4b5e-936c-15da5453a663"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"72", ",", "181"}], "}"}]], "Output",
 CellChangeTimes->{3.8514624317501464`*^9, 3.8514629441919193`*^9, 
  3.8515049354086905`*^9, 3.8515217380156765`*^9, 3.8725212906452074`*^9, 
  3.8725720841794662`*^9, 3.872572322125859*^9, 3.873011023712998*^9, 
  3.8730413319072075`*^9, 3.8744806842091208`*^9},
 CellLabel->
  "Out[538]=",ExpressionUUID->"0cf30e7d-35f4-4b98-8c86-5de3058f4f30"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"71", ",", "181"}], "}"}]], "Output",
 CellChangeTimes->{3.8514624317501464`*^9, 3.8514629441919193`*^9, 
  3.8515049354086905`*^9, 3.8515217380156765`*^9, 3.8725212906452074`*^9, 
  3.8725720841794662`*^9, 3.872572322125859*^9, 3.873011023712998*^9, 
  3.8730413319072075`*^9, 3.874480684216031*^9},
 CellLabel->
  "Out[540]=",ExpressionUUID->"e37e9f98-9297-4b90-9983-a13634e8724a"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"depweight", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "71"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "5"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"depweight", "[", 
    RowBox[{"[", "1", "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
    "\"\<year\>\"", ",", "\"\<total_rc_na\>\"", ",", "\"\<weightedD\>\"", 
     ",", "\"\<total_cc\>\"", ",", "\"\<weightedD\>\""}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"depweight", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "1"}], "]"}], "]"}], "=", 
    RowBox[{"1948", "+", "i"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"depweight", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "2"}], "]"}], "]"}], "=", 
    RowBox[{"Total", "[", 
     RowBox[{"capraw2", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", 
        RowBox[{"2", ";;"}]}], "]"}], "]"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"depweight", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "3"}], "]"}], "]"}], "=", 
    RowBox[{
     RowBox[{"Total", "[", 
      RowBox[{
       RowBox[{"capraw2", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", 
          RowBox[{"2", ";;"}]}], "]"}], "]"}], "*", 
       RowBox[{"depraw2", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", 
          RowBox[{"2", ";;"}]}], "]"}], "]"}]}], "]"}], "/", 
     RowBox[{"depweight", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", "2"}], "]"}], "]"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"depweight", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "4"}], "]"}], "]"}], "=", 
    RowBox[{"Total", "[", 
     RowBox[{"ncapPPPfull", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", 
        RowBox[{"2", ";;"}]}], "]"}], "]"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"depweight", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "5"}], "]"}], "]"}], "=", 
    RowBox[{
     RowBox[{"Total", "[", 
      RowBox[{
       RowBox[{"ncapPPPfull", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", 
          RowBox[{"2", ";;"}]}], "]"}], "]"}], "*", 
       RowBox[{"depraw2", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", 
          RowBox[{"2", ";;"}]}], "]"}], "]"}]}], "]"}], "/", 
     RowBox[{"depweight", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", "4"}], "]"}], "]"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.851462621587405*^9, 3.8514626250667315`*^9}, {
  3.8514627626479187`*^9, 3.851462889707246*^9}, {3.851462955014664*^9, 
  3.8514629808926287`*^9}, {3.872576406061991*^9, 3.87257641808729*^9}, {
  3.872576453382309*^9, 3.8725764593712783`*^9}},
 CellLabel->
  "In[543]:=",ExpressionUUID->"a87c861d-6b7a-4319-92b3-0d6a0aed498a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FigDepreciation", "=", 
  RowBox[{"ListLinePlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"depweight", "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{"2", ";;"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "3"}], "}"}]}], "]"}], "]"}], ",", 
      RowBox[{"depweight", "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{"2", ";;"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "5"}], "}"}]}], "]"}], "]"}]}], "}"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Blue", ",", "Orange"}], "}"}]}], ",", 
    RowBox[{
    "PlotLabel", "\[Rule]", "\"\<Depreciation Rate (weighted mean)\>\""}], 
    ",", 
    RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8514629851754727`*^9, 3.8514630495544033`*^9}, {
  3.851535434210487*^9, 3.8515354845735974`*^9}, {3.8725213228380127`*^9, 
  3.872521323874757*^9}, {3.872576478930543*^9, 3.8725765001538024`*^9}},
 CellLabel->
  "In[550]:=",ExpressionUUID->"fdc05475-f76b-4fab-9645-5e5ea1f0f719"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {RGBColor[0, 0, 1], PointSize[
      NCache[
       Rational[1, 72], 0.013888888888888888`]], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJw1031MzAEYB/AfsrFlhfK+eSlmJiEUsr4jNCtyXmrTSF52ynumMyFE0l0L
R5n2POnSneTcvEydk5STl8Yhlde8FHmZt4yS5e0ez/bsu89/zx/fZ2DMGtWy
9oqiTPuzf/PfaAjeqQG+9U0c9M+JBJfCEJ2uT47TSYQq75Q0F5U4mXC9iMqe
rxbvIaQ6FL+aNLGWkKvxivaxijMIF5sflmXXivWEXj7LfrR+F2cRKrps981w
O+p0NsGTX23rPEScQ6hRnw6YGi7OI0yq09xzU4tNhEsGn2IlQVxIODMo03h/
s9hCaJnzbbojSXyWsPejZV22VlxEWJJw+/LCHLGNUNa6pS3TIi4lnDh/w+Jn
FV8hZM2yb/1aIb5GeJ7V23zwvbiSoIoteDm9c67TDsLn2EPWmP7iKsK+Xdci
bRPFtQT3OLu9ZoH4MWHit5LDeo34GSFjy2DDigPiekK66ZwlrEDcSMjTJbR+
uSh+T2hMi3ikvyH+RIiYP2mR+o74K+HphJExDxziZoLP7rj9bRXinwQl/vz6
hLNihdHf5jbC9ajYhbEkysP/kl7ciaHzeBQfrBW7MuJfJLra94jdGdueju0+
///9HoxmQ7sfT0ziXozweaZAJVPcj/FhX3zkTJt4AMPczrwjq1rszYg2n7RZ
G8RDGV5TGpanvxMPZxibYtVXW8QjGZuocXR+d4PTYxg1r60pt0aJAxgRnulV
qWHiQEbf3B1rPdViMAaMu6oKTRUHMxrrzO4tBeIQRtCgc7Wzy8WhDP3AGX7H
H4vDGbbISmVVxzyn5zJ6lAfaf00WRzLyV6eMMGSIoxgO1/3+JfXiaMZd7Vud
y/hjTi9luJmWljzcKFYzhldXDwstFK9kLIxpWlz8RbyWMSrkTbY9IN/pDYyq
lydCVOvEGkbPeZn+UUfEiYzy5Ch9h1JxEoMbthsLn4mT//Sh9PvNNsUo/8/w
PdVt5yYvsZZxoa62669gY9BvAYh8wQ==
      "]]}, 
    {RGBColor[1, 0.5, 0], PointSize[
      NCache[
       Rational[1, 72], 0.013888888888888888`]], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJwt03tMzQEUB/BbyyRJI0JNITLFGqpLXb5c8xgSSzSh1y3qhvJYbiJENnmU
2LVb51TyHBPCzdoktRqirDbDKEWZRgilaxO/c7azs88f54+zs++4qK2rdNYq
lWphf/+b/yuFoGL7py1txrn/vYdQWn3a5PXnrOJ0QoPeMsjWxaQ4g6Dxfjgg
RC8+Qgg9Eb+vaJ84i2Cn7tmv/iE+SXif+9OhIThPcS5huNuB9rATYiNBN0Q9
9LhRnEfouu+c+rxSXEC4ufZRd+exfMXFhM74wU/TisWXCIlbMt3iisRXCYta
Nk56ViYuIYzWahzKa8SlhOzAmcMMP8Rmgrnvq8Z/HikuJyx9lWDKSRRXECxv
zPm3ssRVBPvuguyeOnEtof3VwDinalb8hODbZDvovl2B4nrCr77dDdZ+4kbC
GavbCZnbxS8ILqvL7aZcFb8mZLT7bzbWi5sJNWR1jT6I2wjGiy0BJU6FijsI
Xz67/K6YLe4kvL2xRvM4VNzVf59jU442UtxN8Hh3yu92griH4Owb8/uuTmwh
WGXarA9bIVYxertufh/qL7ZhTEoq024ZK7ZlIMuQGOQptmeMWRkZ1+cndmTw
In3zmBCxEyPIXNw7cId4VP9+xBW7KwFFil0Z7150BORHi90ZsWHRhRMPiT0Y
hiXJGYHXxZMZszySoysvi70ZjuXpm9LMYh+GdeK6B073xDMZLqH7U10bxWqG
b+vH8aZv4kDG0eS3Nl+mnlMMRpTXejdTjHgBY+J7/6bVqeLFjMW6ycaUY+Jl
jGbLSK3uuDiYcX6zT9KzPHEIY85eTbh3jXgt42Vt2B1niziccfDrNG2pulhx
BKO1ZL7ekCmOYXwKSjPE1Io3MardqwZH/RLrGTtVu+ocfM4r3sbYMOLwtcPJ
4h2Mdq/w1m2F4hTGBPcqSmkS72GkH3qUne56QfLf/+8yj8a66eIMxjf1rLj4
5eIjjI4VvTNOJomzGONik/o8cy/M/Qt+72rV
      "]]}}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{1948.5625, 0.023136301300004845`},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->600,
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotLabel->FormBox["\"Depreciation Rate (weighted mean)\"", TraditionalForm],
  PlotRange->{{1948.5625, 2019.}, {0.023136301300004845`, 
   0.045448275498017186`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.8514629984221525`*^9, {3.8514630388531036`*^9, 3.8514630504260035`*^9}, {
   3.8515354583960032`*^9, 3.8515354852831807`*^9}, 3.8520871907809534`*^9, 
   3.8725213248092628`*^9, 3.8725720876607895`*^9, 3.872572325706017*^9, 
   3.872576465388397*^9, 3.872576500962878*^9, 3.8725766162942777`*^9, 
   3.8730110277795105`*^9, 3.874480687642126*^9},
 CellLabel->
  "Out[550]=",ExpressionUUID->"644f5c00-d2b3-4edb-9aa9-ecaa41f5bcab"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FigDepreciation2", "=", 
  RowBox[{"ListLinePlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"Legended", "[", 
      RowBox[{
       RowBox[{"depweight", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "3"}], "}"}]}], "]"}], "]"}], ",", 
       RowBox[{"Placed", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"\"\<Deprecriation rate\>\"", ",", 
           RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
           RowBox[{"FontSize", "\[Rule]", "18"}]}], "]"}], ",", "Below"}], 
        "]"}]}], "]"}], "}"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"Blue", ",", 
        RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "}"}], "}"}]}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1950", ",", "2018"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.03", ",", "0.05"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"PlotLabel", "\[Rule]", 
     RowBox[{"Style", "[", 
      RowBox[{
      "\"\<b) Depreciation Rate (capital-stock weighted mean)\>\"", ",", 
       RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
       RowBox[{"FontSize", "\[Rule]", "18"}]}], "]"}]}], ",", 
    RowBox[{"GridLines", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"0.035", ",", "0.04", ",", "0.045"}], "}"}], "}"}]}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<year\>\"", ",", "\"\<rate\>\""}], "}"}]}], ",", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{
       RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
       RowBox[{"FontSize", "\[Rule]", "18"}], ",", "Black"}], "]"}]}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8725765746981525`*^9, 3.8725766135419817`*^9}, {
  3.8725766838207273`*^9, 3.872576690590747*^9}, {3.872576755930887*^9, 
  3.872576941885544*^9}, {3.8725866554056587`*^9, 3.8725866715192394`*^9}},
 CellLabel->
  "In[551]:=",ExpressionUUID->"9a1debe1-697d-4f35-bfbd-90625b91d969"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{}, {{{}, {}, 
       TagBox[{
         Hue[0.67, 0.6, 0.6], 
         Directive[
          PointSize[
           NCache[
            Rational[1, 60], 0.016666666666666666`]], 
          RGBColor[0, 0, 1], 
          AbsoluteThickness[2]], 
         LineBox[CompressedData["
1:eJw1031MzAEYB/AfsrFlhfK+eSlmJiEUsr4jNCtyXmrTSF52ynumMyFE0l0L
R5n2POnSneTcvEydk5STl8Yhlde8FHmZt4yS5e0ez/bsu89/zx/fZ2DMGtWy
9oqiTPuzf/PfaAjeqQG+9U0c9M+JBJfCEJ2uT47TSYQq75Q0F5U4mXC9iMqe
rxbvIaQ6FL+aNLGWkKvxivaxijMIF5sflmXXivWEXj7LfrR+F2cRKrps981w
O+p0NsGTX23rPEScQ6hRnw6YGi7OI0yq09xzU4tNhEsGn2IlQVxIODMo03h/
s9hCaJnzbbojSXyWsPejZV22VlxEWJJw+/LCHLGNUNa6pS3TIi4lnDh/w+Jn
FV8hZM2yb/1aIb5GeJ7V23zwvbiSoIoteDm9c67TDsLn2EPWmP7iKsK+Xdci
bRPFtQT3OLu9ZoH4MWHit5LDeo34GSFjy2DDigPiekK66ZwlrEDcSMjTJbR+
uSh+T2hMi3ikvyH+RIiYP2mR+o74K+HphJExDxziZoLP7rj9bRXinwQl/vz6
hLNihdHf5jbC9ajYhbEkysP/kl7ciaHzeBQfrBW7MuJfJLra94jdGdueju0+
///9HoxmQ7sfT0ziXozweaZAJVPcj/FhX3zkTJt4AMPczrwjq1rszYg2n7RZ
G8RDGV5TGpanvxMPZxibYtVXW8QjGZuocXR+d4PTYxg1r60pt0aJAxgRnulV
qWHiQEbf3B1rPdViMAaMu6oKTRUHMxrrzO4tBeIQRtCgc7Wzy8WhDP3AGX7H
H4vDGbbISmVVxzyn5zJ6lAfaf00WRzLyV6eMMGSIoxgO1/3+JfXiaMZd7Vud
y/hjTi9luJmWljzcKFYzhldXDwstFK9kLIxpWlz8RbyWMSrkTbY9IN/pDYyq
lydCVOvEGkbPeZn+UUfEiYzy5Ch9h1JxEoMbthsLn4mT//Sh9PvNNsUo/8/w
PdVt5yYvsZZxoa62669gY9BvAYh8wQ==
          "]]}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$152332, {1}}]& ]}, {
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$152332, {1}}]& ]}, {
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$152332, {
          1}}]& ], {}}, {
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$152332, {
          1}}]& ], {}}}, {{}, {}}}, {
    DisplayFunction -> Identity, DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {
       FormBox["\"year\"", TraditionalForm], 
       FormBox["\"rate\"", TraditionalForm]}, AxesOrigin -> {1950., 0.03}, 
     DisplayFunction :> Identity, Frame -> {{False, False}, {False, False}}, 
     FrameLabel -> {{None, None}, {None, None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {{0.035, 0.04, 0.045}, {0.035, 0.04, 0.045}}, 
     GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> 600, LabelStyle -> 
     Directive[FontFamily -> "Helvetica", FontSize -> 18, 
       GrayLevel[0]], 
     Method -> {
      "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
       "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& )}}, PlotLabel -> FormBox[
       StyleBox[
       "\"b) Depreciation Rate (capital-stock weighted mean)\"", FontFamily -> 
        "Helvetica", FontSize -> 18, StripOnInput -> False], TraditionalForm],
      PlotRange -> {{1950, 2018}, {0.03, 0.05}}, PlotRangeClipping -> True, 
     PlotRangePadding -> {{0, 0}, {0, 0}}, Ticks -> {Automatic, Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{
       StyleBox[
       "\"Deprecriation rate\"", FontFamily -> "Helvetica", FontSize -> 18, 
        StripOnInput -> False]}, "LineLegend", DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0, 0, 1], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0, 0, 1], 
                    AbsoluteThickness[2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.8, 0.5}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxDividers -> {"Columns" -> {{None}}, "Rows" -> {{None}}}, 
             GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
             GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{1}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
          Directive[FontFamily -> "Helvetica", FontSize -> 18, 
           GrayLevel[0]], FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{"Directive", "[", 
                   RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "60"], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 0, 1], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}], 
                 "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{"Directive", "[", 
                   RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "60"], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 0, 1], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}], 
                 "}"}]}], "}"}], ",", 
           RowBox[{"{", 
             RowBox[{
               RowBox[{"{", #, "}"}], ",", 
               RowBox[{"{", "}"}]}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"{", 
                    RowBox[{"None", ",", "Automatic"}], "}"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}], "}"}]}], 
               "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", "True", "}"}], ",", 
                 RowBox[{"{", "True", "}"}]}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
               RowBox[{
                 RowBox[{"FontFamily", "\[Rule]", "\"Helvetica\""}], ",", 
                 RowBox[{"FontSize", "\[Rule]", "18"}], ",", 
                 InterpretationBox[
                  ButtonBox[
                   TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                   BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                   ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                   Automatic, Method -> "Preemptive"], 
                  GrayLevel[0], Editable -> False, Selectable -> False]}], 
               "]"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Row\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "Below"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{3.872576942713241*^9, 3.8725866727579737`*^9, 
  3.8730110318660717`*^9, 3.874480689202339*^9},
 CellLabel->
  "Out[551]=",ExpressionUUID->"3567b4b6-5a17-4360-9d22-a3e4116d45f1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"depconstant", "=", 
  RowBox[{"GeometricMean", "[", 
   RowBox[{"depweight", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "3"}], "]"}], "]"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"depconstant", "=", 
  RowBox[{"GeometricMean", "[", 
   RowBox[{"depweight", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "5"}], "]"}], "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.8520871964488134`*^9, 3.852087230918434*^9}, {
  3.852110362369314*^9, 3.8521103647128277`*^9}},
 CellLabel->
  "In[552]:=",ExpressionUUID->"8ffd16a3-4b5c-485a-929b-b735886774ab"],

Cell[BoxData["0.03697907576214632`"], "Output",
 CellChangeTimes->{3.852087232111248*^9, 3.852110365157405*^9, 
  3.87252133038455*^9, 3.8725723275868177`*^9, 3.8725765131653423`*^9, 
  3.873011033539364*^9, 3.874480690869525*^9},
 CellLabel->
  "Out[552]=",ExpressionUUID->"bf4da003-b270-4084-8160-f36329dd4ae6"],

Cell[BoxData["0.03398551360555769`"], "Output",
 CellChangeTimes->{3.852087232111248*^9, 3.852110365157405*^9, 
  3.87252133038455*^9, 3.8725723275868177`*^9, 3.8725765131653423`*^9, 
  3.873011033539364*^9, 3.8744806908723593`*^9},
 CellLabel->
  "Out[553]=",ExpressionUUID->"f1dc6758-a454-478f-95b2-afe210b806bb"]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.8514632633501897`*^9, 3.851463285855341*^9}, 
   3.87282463296097*^9},ExpressionUUID->"44753cf7-82eb-488b-9116-\
d5281e56ed7e"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"capoutresults", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "8"}], "]"}], "]"}], "=", 
   RowBox[{"depweight", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "3"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"capoutresults", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "9"}], "]"}], "]"}], "=", 
    RowBox[{
     RowBox[{"capoutresults", "[", 
      RowBox[{"[", 
       RowBox[{
        RowBox[{"i", "+", "1"}], ",", "5"}], "]"}], "]"}], "-", 
     RowBox[{
      RowBox[{"capoutresults", "[", 
       RowBox[{"[", 
        RowBox[{"i", ",", "5"}], "]"}], "]"}], "*", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"capoutresults", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "8"}], "]"}], "]"}]}], ")"}]}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "70"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"capoutresults", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "10"}], "]"}], "]"}], "=", 
    RowBox[{
     RowBox[{"capoutresults", "[", 
      RowBox[{"[", 
       RowBox[{
        RowBox[{"i", "+", "1"}], ",", "6"}], "]"}], "]"}], "-", 
     RowBox[{
      RowBox[{"capoutresults", "[", 
       RowBox[{"[", 
        RowBox[{"i", ",", "6"}], "]"}], "]"}], "*", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"capoutresults", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "8"}], "]"}], "]"}]}], ")"}]}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "70"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"capoutresults", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "11"}], "]"}], "]"}], "=", 
    RowBox[{
     RowBox[{"capoutresults", "[", 
      RowBox[{"[", 
       RowBox[{
        RowBox[{"i", "+", "1"}], ",", "7"}], "]"}], "]"}], "-", 
     RowBox[{
      RowBox[{"capoutresults", "[", 
       RowBox[{"[", 
        RowBox[{"i", ",", "7"}], "]"}], "]"}], "*", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"capoutresults", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "8"}], "]"}], "]"}]}], ")"}]}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "70"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"capoutresults", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "12"}], "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"capoutresults", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", "9"}], "]"}], "]"}], "/", 
    RowBox[{"capoutresults", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", "2"}], "]"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"capoutresults", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "13"}], "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"capoutresults", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", "10"}], "]"}], "]"}], "/", 
    RowBox[{"capoutresults", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", "3"}], "]"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"capoutresults", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "14"}], "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"capoutresults", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", "11"}], "]"}], "]"}], "/", 
    RowBox[{"capoutresults", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", "4"}], "]"}], "]"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.851463380796199*^9, 3.851463535669383*^9}, {
  3.8514637676249895`*^9, 3.851463791278949*^9}, {3.8514640550418854`*^9, 
  3.8514641197614956`*^9}, {3.851464246219226*^9, 3.8514642581802487`*^9}, {
  3.872824634294111*^9, 3.872824635576557*^9}},
 CellLabel->
  "In[554]:=",ExpressionUUID->"857ecea0-4e58-4be2-9385-817ff92a9800"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"pinvraw2", "=", "pinvraw"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"poutputPPPraw2", "=", "poutputPPPraw"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"Do", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"poutputPPPraw2", "[", 
       RowBox[{"[", 
        RowBox[{"i", ",", "j"}], "]"}], "]"}], "=", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"poutputPPPraw", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "j"}], "]"}], "]"}], "\[Equal]", "\"\<\>\""}], 
        ",", "0", ",", 
        RowBox[{"poutputPPPraw2", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "j"}], "]"}], "]"}]}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"j", ",", "2", ",", "181"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"Do", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"pinvraw2", "[", 
       RowBox[{"[", 
        RowBox[{"i", ",", "j"}], "]"}], "]"}], "=", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"pinvraw", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "j"}], "]"}], "]"}], "\[Equal]", "\"\<\>\""}], 
        ",", "0", ",", 
        RowBox[{"pinvraw", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "j"}], "]"}], "]"}]}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"j", ",", "2", ",", "181"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.8514953613602223`*^9, 3.8514954469322844`*^9}},
 CellLabel->
  "In[561]:=",ExpressionUUID->"7dc30912-e35f-4aed-9279-01fbe90ee413"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"invshare", "=", 
   RowBox[{"Import", "[", "\"\<csh_i_Transposed.csv\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Dimensions", "[", "invshare", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"invshare2", "=", "invshare"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"Do", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"invshare2", "[", 
       RowBox[{"[", 
        RowBox[{"i", ",", "j"}], "]"}], "]"}], "=", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"invshare", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "j"}], "]"}], "]"}], "\[Equal]", "\"\<\>\""}], 
        ",", "0", ",", 
        RowBox[{"invshare", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "j"}], "]"}], "]"}]}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"j", ",", "2", ",", "181"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"invweight", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "71"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "5"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"invweight", "[", 
    RowBox[{"[", "1", "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
    "\"\<year\>\"", ",", "\"\<total_rc_cc\>\"", ",", "\"\<weightedInv\>\"", 
     ",", "\"\<total_ncc\>\"", ",", "\"\<weightedInv\>\""}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"invweight", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "1"}], "]"}], "]"}], "=", 
    RowBox[{"1948", "+", "i"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"invweight", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "2"}], "]"}], "]"}], "=", 
    RowBox[{"Total", "[", 
     RowBox[{"outPPPraw2", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", 
        RowBox[{"2", ";;"}]}], "]"}], "]"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"invweight", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "3"}], "]"}], "]"}], "=", 
    RowBox[{
     RowBox[{"Total", "[", 
      RowBox[{
       RowBox[{"outPPPraw2", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", 
          RowBox[{"2", ";;"}]}], "]"}], "]"}], "*", 
       RowBox[{"invshare2", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", 
          RowBox[{"2", ";;", "181"}]}], "]"}], "]"}]}], "]"}], "/", 
     RowBox[{"invweight", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", "2"}], "]"}], "]"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"invweight", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "4"}], "]"}], "]"}], "=", 
    RowBox[{"Total", "[", 
     RowBox[{
      RowBox[{"outPPPraw2", "[", 
       RowBox[{"[", 
        RowBox[{"i", ",", 
         RowBox[{"2", ";;", "181"}]}], "]"}], "]"}], "*", 
      RowBox[{"poutputPPPraw2", "[", 
       RowBox[{"[", 
        RowBox[{"i", ",", 
         RowBox[{"2", ";;", "181"}]}], "]"}], "]"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"invweight", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "5"}], "]"}], "]"}], "=", 
    RowBox[{
     RowBox[{"Total", "[", 
      RowBox[{
       RowBox[{"pinvraw2", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", 
          RowBox[{"2", ";;", "181"}]}], "]"}], "]"}], "*", 
       RowBox[{"invshare2", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", 
          RowBox[{"2", ";;", "181"}]}], "]"}], "]"}], "*", 
       RowBox[{"outPPPraw2", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", 
          RowBox[{"2", ";;", "181"}]}], "]"}], "]"}]}], "]"}], "/", 
     RowBox[{"invweight", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", "4"}], "]"}], "]"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.8514650529702644`*^9, 3.851465306864596*^9}, {
  3.851465348781186*^9, 3.8514653660034*^9}, {3.851495067111662*^9, 
  3.851495074562714*^9}, {3.8515044330573587`*^9, 3.851504445710407*^9}, {
  3.8515044816315327`*^9, 3.8515045865151296`*^9}, {3.85150461978865*^9, 
  3.851504790377283*^9}},
 CellLabel->
  "In[565]:=",ExpressionUUID->"57869d5a-5fee-4c8d-9ea1-0bc229e05ed0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"71", ",", "184"}], "}"}]], "Output",
 CellChangeTimes->{
  3.851465121606986*^9, 3.851465226410077*^9, {3.8514652780099506`*^9, 
   3.851465307757363*^9}, 3.851465367069337*^9, 3.851495079239667*^9, 
   3.851504587648286*^9, 3.8515046210745897`*^9, 3.8515047513441467`*^9, 
   3.851504790946273*^9, 3.8515218045525885`*^9, 3.8725217824133325`*^9, 
   3.872572156461977*^9, 3.8725722592547636`*^9, 3.8725723423527336`*^9, 
   3.8730110391920195`*^9, 3.8730112136249003`*^9, 3.874480699845427*^9},
 CellLabel->
  "Out[566]=",ExpressionUUID->"5e3165f0-ef95-4088-8722-d1c44d61f652"]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.8514655223934755`*^9, 3.851465540495652*^9}, {
   3.851504953703441*^9, 3.8515049649355097`*^9}, 
   3.8728246524889135`*^9},ExpressionUUID->"e7de544d-42b7-4c25-a430-\
b1ae05e7109b"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"capoutresults", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", 
      RowBox[{"15", ";;", "16"}]}], "]"}], "]"}], "=", 
   RowBox[{"invweight", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", "5"}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"capoutresults", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", 
      RowBox[{"17", ";;", "19"}]}], "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"capoutresults", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", 
       RowBox[{"2", ";;", "4"}]}], "]"}], "]"}], "*", 
    RowBox[{"capoutresults", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", "16"}], "]"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"capoutresults", "[", 
    RowBox[{"[", 
     RowBox[{"2", ",", 
      RowBox[{"20", ";;", "22"}]}], "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"capoutresults", "[", 
     RowBox[{"[", 
      RowBox[{"2", ",", 
       RowBox[{"2", ";;", "4"}]}], "]"}], "]"}], "*", 
    RowBox[{"ncosummary", "[", 
     RowBox[{"[", 
      RowBox[{"2", ",", "8"}], "]"}], "]"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.851521912922868*^9, 3.8515220066208963`*^9}, {
  3.8515220607556267`*^9, 3.851522080387554*^9}, {3.8515222431493464`*^9, 
  3.851522246950162*^9}, {3.851523747140745*^9, 3.8515237534655786`*^9}, {
  3.851524055022316*^9, 3.8515240568970213`*^9}, {3.8728246539681597`*^9, 
  3.8728246545114565`*^9}},
 CellLabel->
  "In[576]:=",ExpressionUUID->"8684e5b5-db5c-491d-81d5-a8aa8abd9acb"],

Cell[BoxData[{
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"capoutresults", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"i", "+", "1"}], ",", "20"}], "]"}], "]"}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{"capoutresults", "[", 
       RowBox[{"[", 
        RowBox[{"i", ",", "20"}], "]"}], "]"}], "*", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"capoutresults", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "8"}], "]"}], "]"}]}], ")"}]}], "+", 
     RowBox[{"capoutresults", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", "17"}], "]"}], "]"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "70"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"capoutresults", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"i", "+", "1"}], ",", "21"}], "]"}], "]"}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{"capoutresults", "[", 
       RowBox[{"[", 
        RowBox[{"i", ",", "21"}], "]"}], "]"}], "*", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"capoutresults", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "8"}], "]"}], "]"}]}], ")"}]}], "+", 
     RowBox[{"capoutresults", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", "18"}], "]"}], "]"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "70"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"capoutresults", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"i", "+", "1"}], ",", "22"}], "]"}], "]"}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{"capoutresults", "[", 
       RowBox[{"[", 
        RowBox[{"i", ",", "22"}], "]"}], "]"}], "*", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"capoutresults", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "8"}], "]"}], "]"}]}], ")"}]}], "+", 
     RowBox[{"capoutresults", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", "19"}], "]"}], "]"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "70"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.8515225454729047`*^9, 3.8515226830866213`*^9}, {
  3.8515227244696236`*^9, 3.8515228182642345`*^9}, {3.8515237854499483`*^9, 
  3.851523848563325*^9}, {3.8515246670538836`*^9, 3.851524667483315*^9}, {
  3.85152922944643*^9, 3.85152924939686*^9}},
 CellLabel->
  "In[579]:=",ExpressionUUID->"d0aed822-2c16-4a03-80ee-d6983d19342b"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"capoutcheck", "=", 
   RowBox[{"capoutresults", "[", 
    RowBox[{"[", 
     RowBox[{";;", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "20", ",", "21", ",", "22"}], "}"}]}], "]"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"capoutcheck", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"i", "+", "1"}], ",", "2"}], "]"}], "]"}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{"capoutcheck", "[", 
       RowBox[{"[", 
        RowBox[{"i", ",", "2"}], "]"}], "]"}], "*", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"capoutresults", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "8"}], "]"}], "]"}]}], ")"}]}], "+", 
     RowBox[{"capoutresults", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", "9"}], "]"}], "]"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "70"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"capoutcheck", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"i", "+", "1"}], ",", "3"}], "]"}], "]"}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{"capoutcheck", "[", 
       RowBox[{"[", 
        RowBox[{"i", ",", "3"}], "]"}], "]"}], "*", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"capoutresults", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "8"}], "]"}], "]"}]}], ")"}]}], "+", 
     RowBox[{"capoutresults", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", "10"}], "]"}], "]"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "70"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"capoutcheck", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"i", "+", "1"}], ",", "4"}], "]"}], "]"}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{"capoutcheck", "[", 
       RowBox[{"[", 
        RowBox[{"i", ",", "4"}], "]"}], "]"}], "*", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"capoutresults", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "8"}], "]"}], "]"}]}], ")"}]}], "+", 
     RowBox[{"capoutresults", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", "11"}], "]"}], "]"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "70"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.85210150647696*^9, 3.852101542037289*^9}, {
  3.8521023997615623`*^9, 3.852102462040865*^9}, {3.852102524229597*^9, 
  3.8521025302130117`*^9}},
 CellLabel->
  "In[582]:=",ExpressionUUID->"032bfac0-53f8-464b-8513-0872d3a5ad9b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FigInvshare", "=", 
  RowBox[{"ListLinePlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Legended", "[", 
       RowBox[{
        RowBox[{"capoutresults", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;", "70"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "12"}], "}"}]}], "]"}], "]"}], ",", 
        RowBox[{"Placed", "[", 
         RowBox[{"\"\<rgdpo-based\>\"", ",", "Below"}], "]"}]}], "]"}], ",", 
      RowBox[{"Legended", "[", 
       RowBox[{
        RowBox[{"capoutresults", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;", "70"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "13"}], "}"}]}], "]"}], "]"}], ",", 
        RowBox[{"Placed", "[", 
         RowBox[{"\"\<rgdna-based\>\"", ",", "Below"}], "]"}]}], "]"}], ",", 
      RowBox[{"Legended", "[", 
       RowBox[{
        RowBox[{"capoutresults", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;", "70"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "14"}], "}"}]}], "]"}], "]"}], ",", 
        RowBox[{"Placed", "[", 
         RowBox[{"\"\<nominal-constant\>\"", ",", "Below"}], "]"}]}], "]"}], 
      ",", 
      RowBox[{"Legended", "[", 
       RowBox[{
        RowBox[{"capoutresults", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;", "70"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "16"}], "}"}]}], "]"}], "]"}], ",", 
        RowBox[{"Placed", "[", 
         RowBox[{"\"\<share capital formation\>\"", ",", "Below"}], "]"}]}], 
       "]"}]}], "}"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Blue", ",", "Red", ",", "Green", ",", "Black"}], "}"}]}], ",", 
    RowBox[{"PlotLabel", "\[Rule]", "\"\<Investment Share\>\""}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.85157959310703*^9, 3.8515797833117266`*^9}, {
  3.8515798388511825`*^9, 3.8515798706610622`*^9}, {3.8515799208169365`*^9, 
  3.8515800815154457`*^9}},
 CellLabel->
  "In[586]:=",ExpressionUUID->"85fda522-3380-4a26-8e89-fa963454d74c"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{}, {{{}, {}, 
       TagBox[{
         Hue[0.67, 0.6, 0.6], 
         Directive[
          PointSize[
           NCache[
            Rational[1, 90], 0.011111111111111112`]], 
          AbsoluteThickness[1.6], 
          RGBColor[0, 0, 1]], 
         LineBox[CompressedData["
1:eJwt0gss1WEUAPCb1FLmsSnCzRWmtppW6mrpOrUUI7VyS6E80szuyGpFsazE
nRpCE+k72C1JU5OE6nqkvB953JuF1RCT5BmVrJvv/Lf//vvt/L9zvnO+zzIg
7EiQlkAgcNa8/7+LTwSDfEVzZ1xho9OioxjEyRVlvidquGMYvPA/fWJmvpI7
lkFVb2J0zsoqbjkDy0YXf8nUO+5bDKYj46Rej+q5kxlsycz7W7asljuNgZ4q
NE9qW8F9l4FrnXSyOr2aO0tTv1hbKzDpPXc2g46BXJMAGeVXMMBZ0wWXQfIj
BpmHVpWOd1P+JwyWd5w1UA1S/WcMEvbHT2ydpXgxgwr3rfEO5+u4SxkEi4O8
dcX0/2sGVhPGyqJX5EoGtuEXzCxPtXDXMNjuuebOikRynabe5N6RKps27iYG
C8kdTXOF5DYGm18ffByW1M7dySC6O2y9Kq2D+yMD5U6lSi35wN3D4EvaDo9U
SSv3ZwZO5jdb1pZQfEAzX/0EQ+daWj/MoH/30jfuezq5Rxnop/9y3csoPs6g
XhFUP/KW+p1m8KxadnmbdzP3nGa/87k6gZ9o3vMMrlV72LV+beAWIFzX7je2
V9B90EZomTIKs7Gl9SsQfOwK1KorNA9dhOdJ4S4SberfAOF233Hxt/4mbiME
z+cpVUIV9WOC4F8ZZbhaSvXNEbwCZjzLd1FchDCiJ90nC6F81gido0UWw8cp
vgHhp1VZ+0MR9bsJoedwq8G9SPIWBLOjTsl5BdSPPYLSetX5ySHqxwEhs2nM
z82I9u+IcODNet+U+3RegGDaq7PkpS3V34cgUg87hgrpfFwQHL5Hs2wLqueO
oPt0QS/k2EfuwwhXjygTJOk93J4Ivg9+CDxGVNxeCCUv5Q32l9TcPpr5iYVZ
vx92c/shhI+dLLcX0v7OIGzsUxu1DXVxByPIQkRdM6WUT6ZZj8I/+Wtp/+cQ
TMa7zDKi6D5fQJgo2bxwsYbOIwIhP10st/KmeUQhZBisc3ugRfViEHKWyHJb
DCl/LMLQZOpA7A3KL0doFhVn+zW0O/0DetN54Q==
          "]]}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$154176, {1}}]& ], 
       TagBox[{
         Hue[0.9060679774997897, 0.6, 0.6], 
         Directive[
          PointSize[
           NCache[
            Rational[1, 90], 0.011111111111111112`]], 
          AbsoluteThickness[1.6], 
          RGBColor[1, 0, 0]], 
         LineBox[CompressedData["
1:eJwtkgtMjXEYxpM2lksYym0uaR25hNmRafOUU7IVR9rRSu0UyqXcL0mUNCtD
qXYml/c193SZXJbcukhKkepIoxTDSIYOxsbm1P/9tm/ffnve//O8//f9JkZu
Clxja2Nj42N9e769TxxhvWmeqbjxyYJeTiC8WrtjybSEKsVJBP2T02MOzKpQ
nEJ44eL22lBUrjiV8PvphLcuMVJ/mPCm2ZJ/sOux4gyCLunQqo1bqxVnE+L9
sgxzveX8cYLPiLbyhSEPFJ8iZAf7LvIskPozhJc3p7eZOsT/POGo+/XW9Hbh
y4SVDt77P0ytUZxPyBxx31LSKPlXCanJXuSTL343CNqr80pLL0j9LYLm0dvc
RT+F7xKulMWUXadaxWWENqc97SG6esWVBAf3M7XnfoleTZiRa5uYws8U11nP
u7kkv9M0KH5GeM79uCG6UbGZ0Lk4JMw+p0lxC+FwH4+Ge//kfKt1XiGehU22
wh2EDZG6vF068XtHiHVbWrtlhpz/SCi6c81SHmFW3GXNDy4IbDaK/o3wrY/h
RmeJ9PuD4Bi24Xv6JvH7TQgf3GLSuYr+1+pXr9EHJcr/YMMI7fY3766Q+dkx
Rsd253WOfqq4P8Nh8afc/clSP5Axu9/L7IJHMq8hjI749rPrquoUD2cEaOtL
vtpLvhPDHJZDOCH7H8t4kZniGmAnfhMY1XHmiOE5kjeZcT42fPOlQTIfDeNf
3b6oIkfRpzGWp3lFu74XnsmYNPexu3+6+M3p6dfIXRlyHw9GVPGRzyvSRPdk
VNnHH4uOkP7AeB1aY6FhwjrGHy8O9c2SfD9Gbn3hSU2z7NefURiw83Lg7GbF
ekZjjfGL8yzZTxCjeH5Ci75SOJjR+j18akG67Gul9T4/p1w0TRbdyMhytGgN
AyR/NWPA8XFVe91kX2sZ3e8zdiUVy7xjGHZBhofxfsKbGbvHb/syLkr63c7o
a1z2OVEr/cYxjmo9ht6+KPUJjHMn1nwsvSR5SYy8UkOhpUn6S2F4I2qUvk70
VIbjm5HOzvuaFvwH0O54yQ==
          "]]}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$154176, {2}}]& ], 
       TagBox[{
         Hue[0.1421359549995791, 0.6, 0.6], 
         Directive[
          PointSize[
           NCache[
            Rational[1, 90], 0.011111111111111112`]], 
          AbsoluteThickness[1.6], 
          RGBColor[0, 1, 0]], 
         LineBox[CompressedData["
1:eJwt0ntMzWEYB/BT2nRiS8iacqmcDimF4059bY6ZbMXKSuk2uda6slBEl+VS
OpZR8j6ROTERRVFbnZzUqdNF0mhmrFY0wyzjD5nD+/y2s98+e37v+3zf5z2u
sYk74qwVCoXW8vv3/v+kC1xtaB6+H9Pj/98ZAl2rddp3c9qkswS0vuOVhpEW
6RyBGH2Iw+Fsg3S+gNpxbXfYOH9/XqDPa3ZwkmundJHAEmOnp3Jnu3SxQLI5
7NDoUJP0FYEVtjWLbrm1SpcJNKpKXCa18/flljwn7Pt+5PD+NwXqVqqHNX5c
rxSIct4w6n3OJH1XINU1/El4DfevFrjxxpS2vIXrtQI7DIEVYwMd0vUWfz8Z
tFHJbhSIeL5w8aVYs3SzQPFIyt46D56PUWDd3Az8sud6u+V863SV1pG90maB
EWWj5mTAC+leAQc32moo6JPuF7BzmhFujGe/FpiV27p/qorXvxUoq40bnF7D
/d4LvDRtnLjvwPsNCxTEPHL3OP5S+qOlX1s81NH90p8FIo9YFeUl8/7fBH5e
7NeX7OZ5jAuM90zKLBvifr8Evg2W2tzO5fpvgeVe/uLcrm5pBaEpoMBRv5Tn
Z0MY7Xrw531xl7QtoSD0S3PIFPZUgt7b42FGKeefRiiO6ni8PYXnNZNgl6Dp
dQ7j/k6Elg9n12yvMEq7EDQeymPX/Xj9fEKKMrDjlCd7AeFWYWz1J1uex0KC
q2ql27AN5/UiJDehQTPAeXwJp2JqgxqS2BrCM+sD+k1v+DyrCfu09U8HUrm+
nrB1ovrMvh+cD4R7WXlxlUfZmwhFTu6Ze+Zxni2E01DMXJXLebYRQgN1NsvG
+D6CCDdxfFr6ZL6vYEKdOioxM44dSig3+RypsuL7iiD4LJ6Y5XKdHW3pX3hB
m/2Wz7eH0GO+E6bT8f9/P6E91eTdvILzxxPKtLklidXsJILRTz1v7Wten0Yw
KHX9+oOcN51wufzVBt8ErmcQEu2vfbl6hs+bZam/6DSrhjhPDmFKdrA26CvX
8wnp7zbr1lf1+f8Fp9prRA==
          "]]}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$154176, {3}}]& ], 
       TagBox[{
         Hue[0.37820393249936934`, 0.6, 0.6], 
         Directive[
          PointSize[
           NCache[
            Rational[1, 90], 0.011111111111111112`]], 
          AbsoluteThickness[1.6], 
          GrayLevel[0]], 
         LineBox[CompressedData["
1:eJw10ntMzWEYB/CjoiiUhdAf5RhyZywq+cY5RyqOcpkaK8ZcynJbDHNSSekg
zaUtPY9U5LKQbMlxcomMyjljVlFLSsLE1iwOcjhPv+233z57v8/zPr93r/e6
+IgNdgqFQm19/33/P3sIQ71bjjeefDbvv/cTLu/qrOporbE5kWAMmlieN7za
5hSCRttys32COI3wsSLCf/BcsZ4QWRYb5vlN6jMJ++6qNuoTam0+SShzevuq
I1ecTRj3VfGFXkj+LOFgmVPKtcPPbT5HOF2b0aZ/Ly4gnHK9eiN6i7iIMEhX
19dsL75KODFnTv+qEPF1wq2LCbMKFplsLiXY24e4BerFZYSm+Mal7wrEBsL0
V6pWdxfxPev8hrFZRm9xJSFhzcP8izrxE4JycnDJ2nZxNeFwafT865ViE4HM
Oa/jG8UvCRmpq3su5JltriPoYiOnel4SvyFkdU24lZQr+WaCXVXOpu5Dst5q
PT8Hg5/6gfgDwZSeV3ilSfyZsHu8W2hog/grwTFgS5tjsbiLEDjAxbVPjLib
kHu62PlOnOz3i6AuvdPlMFisYMTfD/GesUPswFiWOqLfZnuxEyPaeOKooUTO
24XR8ylK86he7MoY9bG6vjZZ8u4Mf2W7nbJY7MEYFp6ZvWKt2JPR9uRnlqa3
vxfDLamPOjxS+o1htAb+3qi6LfdnPCO2kNOT7WR9EqOcoywZKvE0hu5n6Krl
I8QzGQ+2dpScdxbPZhRO1Tsm50i/AEaUT5Elb7sYDKNFqVtmEaus8zs/1XZ3
y30NZixZsJVWzheHMXxrfjVXZoiXMhav8+isSJL65Qx1jK7B30n2X8V4GhwQ
N/KxeLU1H61V1vvK/8cw/PaF/pmkEa9nNO300Lp0Sv9NjCGaNJ+aFKmPY1ww
N2grRkt+G+O75XXQswDxLsZeX7+o/BDxHgadMSwM3y3ezzj2o/qA/og4kZFQ
mz/wR+88KYwIi3KKKV2cZp3HbPTS15nm/QVd6HWP
          "]]}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$154176, {4}}]& ]}, {
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$154176, {1}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$154176, {2}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$154176, {3}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$154176, {4}}]& ]}, {
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$154176, {1}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$154176, {2}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$154176, {3}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$154176, {
          4}}]& ], {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, {
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$154176, {1}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$154176, {2}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$154176, {3}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$154176, {
          4}}]& ], {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}}, {{}, \
{}}}, {DisplayFunction -> Identity, DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {1948.5833333333335`, 0}, 
     DisplayFunction :> Identity, Frame -> {{False, False}, {False, False}}, 
     FrameLabel -> {{None, None}, {None, None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> 600, 
     Method -> {
      "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
       "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& )}}, PlotLabel -> 
     FormBox["\"Investment Share\"", TraditionalForm], 
     PlotRange -> {{1948.5833333333335`, 2018.}, {0, 0.4467312197605579}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.05]}}, Ticks -> {Automatic, Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{
      "\"rgdpo-based\"", "\"rgdna-based\"", "\"nominal-constant\"", 
       "\"share capital formation\""}, "LineLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #, 
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2, 
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 1, 0]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 1, 0]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.8, 0.5}}}], "Grid"]}, {
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #4}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.8, 0.5}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxDividers -> {"Columns" -> {{None}}, "Rows" -> {{None}}}, 
             GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
             GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{1}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 0, 1], Editable -> False, Selectable -> 
                    False]}], "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0, 0], Editable -> False, Selectable -> 
                    False]}], "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0.6666666666666666, 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "1", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 1, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 1, 0], Editable -> False, Selectable -> 
                    False]}], "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False]}], 
                    "]"}]}], "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 0, 1], Editable -> False, Selectable -> 
                    False]}], "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0, 0], Editable -> False, Selectable -> 
                    False]}], "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0.6666666666666666, 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "1", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 1, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 1, 0], Editable -> False, Selectable -> 
                    False]}], "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False]}], 
                    "]"}]}], "}"}]}], "}"}], ",", 
           RowBox[{"{", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{#, ",", #2, ",", #3, ",", #4}], "}"}], ",", 
               RowBox[{"{", "}"}]}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"None", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"None", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"None", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"None", ",", "Automatic"}], "}"}]}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], 
               "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"True", ",", "True", ",", "True", ",", "True"}], 
                   "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"True", ",", "True", ",", "True", ",", "True"}], 
                   "}"}]}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Row\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "Below"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{{3.8515796361663694`*^9, 3.851579641749968*^9}, {
   3.8515796719234195`*^9, 3.85157969430735*^9}, 3.8515797297816453`*^9, {
   3.851579775230996*^9, 3.8515797864539733`*^9}, 3.851579871706543*^9, 
   3.851579967625315*^9, 3.851580034937846*^9, 3.8515800823904743`*^9, 
   3.8725218254381037`*^9, 3.872572202175112*^9, 3.872572264305046*^9, 
   3.8725723519303207`*^9, 3.873011045143527*^9, 3.874480708551517*^9},
 CellLabel->
  "Out[586]=",ExpressionUUID->"092cdc36-c725-40c3-bcdb-d2ad5906865b"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"figcap1", "=", 
   RowBox[{"ListLinePlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"capoutresults", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;", "70"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "5"}], "}"}]}], "]"}], "]"}], ",", 
       RowBox[{"capoutresults", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;", "70"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "20"}], "}"}]}], "]"}], "]"}], ",", 
       RowBox[{"capoutcheck", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;", "70"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "}"}], ",", 
     RowBox[{
     "PlotLabel", "\[Rule]", "\"\<cap stock, based on PPP constant\>\""}], 
     ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Blue", ",", "Orange", ",", "Blue"}], "}"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "400"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"figcap2", "=", 
   RowBox[{"ListLinePlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"capoutresults", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;", "70"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "6"}], "}"}]}], "]"}], "]"}], ",", 
       RowBox[{"capoutresults", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;", "70"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "21"}], "}"}]}], "]"}], "]"}], ",", 
       RowBox[{"capoutcheck", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;", "70"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "3"}], "}"}]}], "]"}], "]"}]}], "}"}], ",", 
     RowBox[{
     "PlotLabel", "\[Rule]", 
      "\"\<cap stock, based on PPP nationa prices\>\""}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Blue", ",", "Orange", ",", "Blue"}], "}"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "400"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"figcap3", "=", 
   RowBox[{"ListLinePlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"capoutresults", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;", "70"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "7"}], "}"}]}], "]"}], "]"}], ",", 
       RowBox[{"capoutresults", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;", "70"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "22"}], "}"}]}], "]"}], "]"}], ",", 
       RowBox[{"capoutcheck", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;", "70"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "4"}], "}"}]}], "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Blue", ",", "Orange", ",", "Blue"}], "}"}]}], ",", 
     RowBox[{
     "PlotLabel", "\[Rule]", "\"\<cap stock, based on nominal constant\>\""}],
      ",", 
     RowBox[{"ImageSize", "\[Rule]", "400"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.851523096131273*^9, 3.851523123605159*^9}, {
  3.8515231859797354`*^9, 3.8515232019846725`*^9}, {3.8515232560505652`*^9, 
  3.8515232810702744`*^9}, {3.8515234420535283`*^9, 3.851523443028859*^9}, {
  3.851523869087657*^9, 3.851523869708769*^9}, {3.8515239061304893`*^9, 
  3.8515239270004787`*^9}, {3.8515243958963404`*^9, 3.851524451079977*^9}, {
  3.851524683273324*^9, 3.8515246892325163`*^9}, {3.851529259526848*^9, 
  3.851529309794404*^9}, {3.851535839280069*^9, 3.85153587804694*^9}, {
  3.851535922145795*^9, 3.8515359574330664`*^9}, {3.851536044279987*^9, 
  3.851536060046545*^9}, {3.851576894081602*^9, 3.851576897736664*^9}, {
  3.851585861399395*^9, 3.851585868913389*^9}, {3.852086648902915*^9, 
  3.8520866668535414`*^9}, {3.8521025644237776`*^9, 3.852102689792043*^9}},
 CellLabel->
  "In[587]:=",ExpressionUUID->"8e2efc6b-d804-49d7-ac75-da0da52fc3a5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FigCapCom", "=", 
  RowBox[{"Grid", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "figcap1", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"figcap2", ",", "figcap3"}], "}"}]}], "}"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.851535966497717*^9, 3.851536026309332*^9}, {
  3.8515858722199283`*^9, 3.8515858842491975`*^9}},
 CellLabel->
  "In[590]:=",ExpressionUUID->"9e7f8d0d-4a82-49f8-9629-7f553082f373"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     GraphicsBox[{{}, {{}, {}, 
        {RGBColor[0, 0, 1], PointSize[
          NCache[
           Rational[1, 72], 0.013888888888888888`]], AbsoluteThickness[1.6], 
         LineBox[CompressedData["
1:eJwt0w9M1AUUB/ALzTU1wGTM8adoUTIQYQyJJdaXFhALTAJTRBDpTGWGDOhA
gjj+M2DJHzO40/f4cxDxT8CLThSjDSj/YTW7EWOOgtzFKLBBitLq4v3e9vb2
2dve9t72nk86+c4RG5VKFWLN/+tqZBH+evaFsZn59OBV5xD2rul+/37+h2It
YTrTL2ZzsUZcRNCnh9fdQ6a4jBBXOL370LoscSWhZmjF+ZXXTomrCI+SFuMb
f8kWnyHsutxvnArNEdcRiv4oybf7U/E5QpN2/0T0vVxxA6G3+4Ffwbt5YgPB
L3VTmmWfVtxG0IzOmvF0vriT4Dkya2trUdxDUOemBeTOFYiNhFe/KRl1ulso
NhF+9o5Lyfi1SHyF4KGrjir4p1g8RND6FP47uLVUPExwKj3fGzVQJv7O6r0v
ttsllYtvEuajN5soqFL8PeHwe4mOnTs/Ed8hLL1clIzoKvE4wf6gr1nXVy2e
JHg/siRH3qkRTxF09uaRlZFa8QyhPsCYNvn4jNhCyHz42YkRzVnxHOFo6IbZ
s+vrxAvW+c9db1DX1osXCa62zpMlfjrxQ4LjtY8qO5314hXC7xHql4qrFKsY
H1ja8qreOidey6gYTDY0tSp+inHodFK6A50Xb2RExobd2NlPYntGRKp/mmqZ
xQ4MdZamXVXSIN7CeOLWQENCbKPYhTGR3bXjb4NiN8Zvp34s90pvErszvp7a
Fbvs2yz2YHjn95tC1hrE2xgdXkFO8etaxL6M4/vULXrXVrE/Y+PrNR8vGRQH
MhaKWy26acVBjPjRbk0ZfS4GI+wHL3YZbhO/wditfzB6/MIX4jcZlhi3sYLS
dnEE4xlTl83V2x3iPYze0OVPI7/tEscwdAG6uXr/HvF+hvuNxz8FBvSKDzLC
b5u3H3m7T5xovb/vzOxKy0WxmnF/8sKmcVej+Bijzng30cX1S/EJRlNC6MyT
Ef3iVOu+S/qxPOevxBmMiwe86qPUirMYGY1ut7aMK86x9vsOnJyfUKxl9A0t
h08kmJT/t+4f3Gz2bL6k/D8jxWkh3KdiIPg/my5siQ==
          "]]}, 
        {RGBColor[1, 0.5, 0], PointSize[
          NCache[
           Rational[1, 72], 0.013888888888888888`]], AbsoluteThickness[1.6], 
         LineBox[CompressedData["
1:eJwt031QzAkYB/BNFKc5Gmkyoto7opJincNevmsO56ZCuru4QyWc0anxdg0R
eQubirqleJ4tiW3X7VJXXd4607mUE8Z4SV5u7Yy3hi4NwuXi+T0zzzzzmXme
57+vX3xS1MJuKpVqcle/nx8qhdA2+JOLjmcrdB+cSlBbm/o8Slsl3kB4Oel7
w/2In8WbCf1KwqyjX6SIMwiae/a+keY1Yj3htDlgZFNsqjib8PGuuIkhUevF
uYQ3nc5DMgM3iPcS/vy6vSNp1EbxfoLL0LxBV4LSxUZCjwGFrksnbxIXE5q/
mZdlWrJZfIQwbayjdWrGFrGF4H12582E0q1iG+GJ9p9l/Zq3icsJnpq86/Wa
7eIqwheN+sWq4h3ik4T7+wLD7H56cQ1hQnxGpyErU1zbtX+yZMR3fbLEdQS3
A6GOQbOzxRcIC9rrvc+OzxFfIvzUTW0J8t0tvkpIqvP4Xe++R3yDsPOzgsT+
Q3PFzQSzYXVEgDZPfI+wsX5EuduoX8QOwsF3FnVIuEH8kGC55pp9efVecQvB
sSg3Q2/dJ24lJDQts437N1/cTnBui5m/JXi/+BWhuvp8y+C5B8RvCdaGwEL/
+SRWMXZZTT6h37K4OyNqW9WlstFGcU9GkvvpuMhKxW4MXYpfwBltobgvo8xf
N+VlvWIPxqbuHoGliUViL8YVJ//e+Z4Hxd4MH5cWb2ONYl/GwLdzUs/FFos/
ZQxvTGt990bxMIZnzN/qtJxD4iBGbYdOExBSIg5hxJ06sf75bcWarvu7Hx0r
MhwWf85wmuXl9yr6iFjLcE3XBat7mcRgHLoev9T8h+IvGYmVsWssWaXirxgd
vRsa2yLM4nBGr0npkXXOFvEMxp6CiwPs5xRHM4xFr/svP3pUHMPA1XLtfyd+
Ff/ASDY9To5usYpjGQ+eFYx5brSJExhVVg/7glnHxD8ybLMbXObdUpzIWF5b
PaRox3Fxctd/U3RnWFSZeCVj5oytXmk+5eIUht2WWeP7WHEqIyd/+l8xFb8p
+Wdkqu+8frK2Qsk/I7hinfvTMZVK/hmhi8NvJTtV6f4HlgpjBw==
          "]]}, 
        {RGBColor[0, 0, 1], PointSize[
          NCache[
           Rational[1, 72], 0.013888888888888888`]], AbsoluteThickness[1.6], 
         LineBox[CompressedData["
1:eJwt0w9M1AUUB/ALzTU1wGTM8adoUTIQYQyJJdaXFhALTAJTRBDpTGWGDOhA
gjj+M2DJHzO40/f4cxDxT8CLThSjDSj/YTW7EWOOgtzFKLBBitLq4v3e9vb2
2dve9t72nk86+c4RG5VKFWLN/+tqZBH+evaFsZn59OBV5xD2rul+/37+h2It
YTrTL2ZzsUZcRNCnh9fdQ6a4jBBXOL370LoscSWhZmjF+ZXXTomrCI+SFuMb
f8kWnyHsutxvnArNEdcRiv4oybf7U/E5QpN2/0T0vVxxA6G3+4Ffwbt5YgPB
L3VTmmWfVtxG0IzOmvF0vriT4Dkya2trUdxDUOemBeTOFYiNhFe/KRl1ulso
NhF+9o5Lyfi1SHyF4KGrjir4p1g8RND6FP47uLVUPExwKj3fGzVQJv7O6r0v
ttsllYtvEuajN5soqFL8PeHwe4mOnTs/Ed8hLL1clIzoKvE4wf6gr1nXVy2e
JHg/siRH3qkRTxF09uaRlZFa8QyhPsCYNvn4jNhCyHz42YkRzVnxHOFo6IbZ
s+vrxAvW+c9db1DX1osXCa62zpMlfjrxQ4LjtY8qO5314hXC7xHql4qrFKsY
H1ja8qreOidey6gYTDY0tSp+inHodFK6A50Xb2RExobd2NlPYntGRKp/mmqZ
xQ4MdZamXVXSIN7CeOLWQENCbKPYhTGR3bXjb4NiN8Zvp34s90pvErszvp7a
Fbvs2yz2YHjn95tC1hrE2xgdXkFO8etaxL6M4/vULXrXVrE/Y+PrNR8vGRQH
MhaKWy26acVBjPjRbk0ZfS4GI+wHL3YZbhO/wditfzB6/MIX4jcZlhi3sYLS
dnEE4xlTl83V2x3iPYze0OVPI7/tEscwdAG6uXr/HvF+hvuNxz8FBvSKDzLC
b5u3H3m7T5xovb/vzOxKy0WxmnF/8sKmcVej+Bijzng30cX1S/EJRlNC6MyT
Ef3iVOu+S/qxPOevxBmMiwe86qPUirMYGY1ut7aMK86x9vsOnJyfUKxl9A0t
h08kmJT/t+4f3Gz2bL6k/D8jxWkh3KdiIPg/my5siQ==
          "]]}}, {{}, {}}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{1948.5833333333335`, 0},
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImageSize->400,
      Method->{
       "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
        "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& )}},
      PlotLabel->FormBox[
       "\"cap stock, based on PPP constant\"", TraditionalForm],
      PlotRange->{{1948.5833333333335`, 2018.}, {0, 4.453292259379033*^8}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.02], 
         Scaled[0.05]}},
      Ticks->{Automatic, Automatic}], ""},
    {
     GraphicsBox[{{}, {{}, {}, 
        {RGBColor[0, 0, 1], PointSize[
          NCache[
           Rational[1, 72], 0.013888888888888888`]], AbsoluteThickness[1.6], 
         LineBox[CompressedData["
1:eJwt031QzAkYB/Cd7rjG290MJq+pGXfrpcGkyTrLfqVDhrxkhsFtXiJhcGqz
sa4kp0bkZCmznkdKluhyVmo14/1tW9XskLzsXaTSULuEu26c03l+z8wzz3xm
nv++8w1cvmHeSh+VSvVD5/5/P4+RkBH8eHplbsLkzzYRVKGLm/1WJYpTCCNb
+l7R5G8WpxG+3r/4Vrc0ozidwJPM1c9WJIkzCXnDRoeo7VvE+wjo2eXtP2aT
+AAhsqOmOELzsziHkJTMF9v6J4sthF4R4wwzBqeIjxLqu7qCZ32xXVxAyFk+
Vbf1vmIroVkPS2BRqvg04YJWU/quZIe4hFAe4FxR8Wea2EawJRSoU//aKS4j
tDVNi28etUtcQah77bLFGNPFlwn/dtOPT3yVIb5O2Lax/My8a7vFtwkXXaHB
lcv2iJ2EKV0a4igjS1xDeNM+ZUtc2z7xPcLc0Mb6u+H7xXWEIZ5kd0JVtvgJ
obHarQ7tbhbXE6x+vqanQw+KnxOGj1zW0nPTIfGLzn/9AKNv11zxK0LpG03F
t87DYi/BXuiakJlkEb8lOIaHTfREHxH/TfAL2z5wpYPEHwjxvVkbRyxWMXRn
3f/1jzoq/pLhrjrwJLFEsS+jn757U/SMPHEPRrXh0fvsBsXfMNa2bvr1juWY
uA/jUcF36zMn5Iv7MbZGBFnz/QvEgxh7bo9bY5+vOIDxtFUXVfhR8VDG2EhH
u8l+XDyMEbjTcfxEeqE4iBGj2ttepjshHsNYkLsgyvcrqziE8f2QU6YHVxVr
GIviLS6v9qRYy/jDE+Lx+JwSg3EvJkfdK6BIHM7wc8f+ZNCdFk9n6M3bbtZG
nhHPZAyoUgec/K1YPIcRHmH1OqaViOcz2ms2T/UfdFa8kBEWsmTEjz6/i5cw
Ui9lf3DWKV7KCNrQNGrNtXPiGMaDh2NqsmJt4tWMI1c7zrXYFK/rzOvuy1YD
zos3Ml7sshuKKhUnMPp6i22/xJWKjYxG/49ar+aC0v/OvGrfdTRUKU5hOA3W
2Xm5ZUr/GdEDdbUj8suV/jNuZMSaDyfaJ38CH35wuQ==
          "]]}, 
        {RGBColor[1, 0.5, 0], PointSize[
          NCache[
           Rational[1, 72], 0.013888888888888888`]], AbsoluteThickness[1.6], 
         LineBox[CompressedData["
1:eJwt03tQzQkUB/A7HmWFUWuM0ozMNF5lU8n1Wr6UJvaimobsWDXcUIpFmjxC
q9palbKo0DkJdcvdSqWbxx/Kq+sxdYWsyiORbKUZj4pm7OX8zsyZM5//vnNm
vuPXbvEPGaBSqRaZ99v9PtGEJLdGnztZkQu+ew9B+3NCqIM6SryfYPTvLtHZ
RovjCLlFRlPfvzvFiQTLbuOgU4W7xcmEhi/zrANiYsRphCofn5StafvERwjN
9drznc37xZmE0MUxNdrPseKThCk7ol69tTogziEcdV81e+j8OPEZwpyJR6vV
f8SLdeY8nzJ7TlcliPUEP781rSEWieISwugnjS9C1ySJywmD86pW9rT8Ja4k
lDY05WfFJouvEO6pXtW2u6WKrxLUJvvrefWHxNcJXn0PTQtvpolrCLZ1dhEa
Q7r4LiFsVIrxS8VhcR3hnR+n91/+W/yA4BZoerGr9oj4sfk/kd4Hr/5wTNxE
GOiXb1e4KEP8nGC/1K7ZsDpT3EpoHdC0wjs7S/yG4BSsc6zvOi7uIPy69mmv
87KT4m5CxGate40hW/yBkOzy+WDBWBb3EqyL+jbdmZUj7ifEWbSVpdcpVjGK
R3fatq87JR7ESGz7qfODZa54CMPGN8RqXIHiYYyWlyrVM81p8UhGUL6nd02f
4lGMP/uLy95eOSMew3Ae/vo/36SzYnvGRBroZBOQJ3Zg6PWzHPNG5osdGfEZ
s122VyuexNCcSD1RtkkndjbnPfRx5lf7AvE0xqUJz68VNSiezjBl2WxuzSgU
z2QYat2Ni4POiecynO72VJc66MVgBF8cdyzhtWIvRtT9lbkbq/4R+zCWTNW1
+6YUiTWMDmPg2N/8i8W+jJxt5d03bErEAYwNHv3VYSmKAxnLJ+9y8frxvHg1
I+DB8r3zdIqDGTsm3K7w+KVUrGU8aVOXj+hSvJHhop/qGhFaJg5nWFi/rL2s
Khf/zrgV7jUj7KziSEZCvGWLneaCONqcN1z9NLtH8R7GI899Gdv0FUr/zf+z
Gtrlsd6g9J/Re9z1fYdtpdJ/RqxnUKBrY+WC/wE6AXET
          "]]}, 
        {RGBColor[0, 0, 1], PointSize[
          NCache[
           Rational[1, 72], 0.013888888888888888`]], AbsoluteThickness[1.6], 
         LineBox[CompressedData["
1:eJwt031QzAkYB/Cd7rjG290MJq+pGXfrpcGkyTrLfqVDhrxkhsFtXiJhcGqz
sa4kp0bkZCmznkdKluhyVmo14/1tW9XskLzsXaTSULuEu26c03l+z8wzz3xm
nv++8w1cvmHeSh+VSvVD5/5/P4+RkBH8eHplbsLkzzYRVKGLm/1WJYpTCCNb
+l7R5G8WpxG+3r/4Vrc0ozidwJPM1c9WJIkzCXnDRoeo7VvE+wjo2eXtP2aT
+AAhsqOmOELzsziHkJTMF9v6J4sthF4R4wwzBqeIjxLqu7qCZ32xXVxAyFk+
Vbf1vmIroVkPS2BRqvg04YJWU/quZIe4hFAe4FxR8Wea2EawJRSoU//aKS4j
tDVNi28etUtcQah77bLFGNPFlwn/dtOPT3yVIb5O2Lax/My8a7vFtwkXXaHB
lcv2iJ2EKV0a4igjS1xDeNM+ZUtc2z7xPcLc0Mb6u+H7xXWEIZ5kd0JVtvgJ
obHarQ7tbhbXE6x+vqanQw+KnxOGj1zW0nPTIfGLzn/9AKNv11zxK0LpG03F
t87DYi/BXuiakJlkEb8lOIaHTfREHxH/TfAL2z5wpYPEHwjxvVkbRyxWMXRn
3f/1jzoq/pLhrjrwJLFEsS+jn757U/SMPHEPRrXh0fvsBsXfMNa2bvr1juWY
uA/jUcF36zMn5Iv7MbZGBFnz/QvEgxh7bo9bY5+vOIDxtFUXVfhR8VDG2EhH
u8l+XDyMEbjTcfxEeqE4iBGj2ttepjshHsNYkLsgyvcrqziE8f2QU6YHVxVr
GIviLS6v9qRYy/jDE+Lx+JwSg3EvJkfdK6BIHM7wc8f+ZNCdFk9n6M3bbtZG
nhHPZAyoUgec/K1YPIcRHmH1OqaViOcz2ms2T/UfdFa8kBEWsmTEjz6/i5cw
Ui9lf3DWKV7KCNrQNGrNtXPiGMaDh2NqsmJt4tWMI1c7zrXYFK/rzOvuy1YD
zos3Ml7sshuKKhUnMPp6i22/xJWKjYxG/49ar+aC0v/OvGrfdTRUKU5hOA3W
2Xm5ZUr/GdEDdbUj8suV/jNuZMSaDyfaJ38CH35wuQ==
          "]]}}, {{}, {}}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{1948.5833333333335`, 0},
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImageSize->400,
      Method->{
       "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
        "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& )}},
      PlotLabel->FormBox[
       "\"cap stock, based on PPP nationa prices\"", TraditionalForm],
      PlotRange->{{1948.5833333333335`, 2018.}, {0, 4.4398043740444595`*^8}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.02], 
         Scaled[0.05]}},
      Ticks->{Automatic, Automatic}], 
     GraphicsBox[{{}, {{}, {}, 
        {RGBColor[0, 0, 1], PointSize[
          NCache[
           Rational[1, 72], 0.013888888888888888`]], AbsoluteThickness[1.6], 
         LineBox[CompressedData["
1:eJwt031QzAkYB/At3NzY0zgyl1LnyNu52F4IW3tfCuXOyxk1ojCRGImyq9WV
VmXlrkgpXep5ti5Hodu63FyYoXA0u5LxlonRxYwujek6MxjcXjy/Z+aZZz5/
fueZ7xex25bHOatUqvkD+/5+GCMhcah23sPkxLkfnEYYU1h97dyx7WITISjN
qr95NEmcTUj51Ode/NJkcQ6ht/Ovl2v+VZxL8BxRaXG46MX5hBtcPH2c0SA+
TNj/MsffxbpTXEJo/mZjdk9wiriMcNa2rKlJaxRbCF5z2r9XlewSVxHI1yM/
7HGq+ATBbp2U8duCNPEpgot1sdb2IF1sJaws3bvLfCFD3DCQJ1o/3nHJJP6D
YFx1ufDHS3vE5wlxz590Bjdlii8SjpfXTXnakyW+TPBRZ7rXLt8rvkZQRx4I
aS0wi+2EhtXvNnv55ojbCEm6RxOdHPvFtwn7akJq7o7IFbcTDLljM4KDDogf
ELa49bs8fH1Q3EmI7tOuD7+RL35CCMjnPNPVQ+JuwmlLVPdsp0JxLyEm8mLo
i6jD4j5CSEpjpse+IvELQmjUxFexmmLxK0Jx/H+uw/yPiN8SnPJG7e69p1jF
SP7dsMXtZIl4MOOKZcjBWt1P4o8Z//yg0cR8Xir+hJHqEdMS5VA8nKHu01U8
G1kmdmWsWlMee+adYjdGlznBrtaSeAyjtTq7fAcrHssw7/mya3gLi70ZpjY/
9jZaxJMZg7rfjk+dVCH+ijFE53fUvV6xhtGQNfpqh65SHMDwNHx3y9eueBZj
2KjpSyYE/iwOYkR0zHLusysGo7/5foS6rEocygjX/z25Mf6YOIwxbca0xG6P
X8TfMnZMSX3qP/i4eBnD0WL8WrPohHgFY+GRgjONG6vFKxl5Np8E56IacTTj
szcj71dVnhSvY6xubr3jaTsl3sC4EHD+z3rzafEmRk9WYGDFdcUJjGZNh8l1
a614O6NpsV9D4OhfxXrGhuQ6r53tio2M+XO6ZkYkWZX+D/x3auTjgDbFJoZt
bVr6jEV1Sv8ZTull3qX9inMYz+5+lL3VUD/3f91bYVM=
          "]]}, 
        {RGBColor[1, 0.5, 0], PointSize[
          NCache[
           Rational[1, 72], 0.013888888888888888`]], AbsoluteThickness[1.6], 
         LineBox[CompressedData["
1:eJwt03tM0wcQB/CCZjZqQDM0THCD6JQaXdCAGIr4FRUlc4C4rCrqRDExWFGx
OGB2lKYq8nAFccjDu8JkKqCrzPkABIyPauJrxgk+cA4Z4njMEMlQ1Fi93yWX
y+e/by75+q7dHLPeVaVSLXDu+/thUgiJw7VhrUmJcz94B+Ht0Iem9oQtYhMh
TbvfEX57q9hCKNaeexTju02cSZjU6dbyh9EgziHsTelJ2P4gWWx12secHKv/
TlxAWDdu5da/3VPFBwgRi78fCD2XJi4ljBw7eHaKbofYRniyN2OAJv8gPkQI
jgozzlSbxEcI3hciJhW+UlxNaB9//fKFvgyxnTDafbvby5dm8UnCnXv9q2ZN
tIjPEF78ZpngEr9TXE8ItK9Vu57cJW4ipGQX6WP+3y2+SMjV6U+titwjvkJ4
rDEnnLqYJb5GMAb4JFUsyRHfInTNnmcq+SdXfIfwmaXXMMf6o7iFUGCLKDPW
WcUPCZ2F3R8nHssTPyaMb/ULTs3IF7cTpuvMC2sM+8SdhPqeHrdvDQXibsJ/
55PTgtL3i58TqhvPq+/m/SR+Qbjx77X43oOF4gHCpd7Kz0ttB8SvCZ82NH/i
Zy4Sqxiq8LjqwdXF4qGMBXmajiHflIjVjBnpa9TBEaXikYxofmVpmnNQPIqh
CV+Wv28eiT0Y4zwrNQ0bWOzJuFTlEVD3lU3szbjx+2n3p+2KfRjTz37h6p9U
Jp7IcJxRTX02oNiP8XxF+uGs1HLxVMaiooqFJS4/i/0Zoc1LO2qtigMYt1eE
54ROOCSexTAn92m96hSHMGpvXvHaGFUhBqNr/r2/3nQons+42mGOa8n9RbyI
ETste/2XfofFi535NzW23a9THM3wf9QZ2Ko7Iv6a0dg/IjJoxFHxMoZ37LD8
KdcVr3R6RtaJZ+WV4jWMgDaddkxWlTiesdw+rbt7U7V4A2P3n9b66DHHxHrG
8JAER02b4i3O/3u09TuajosNDK/sPt8Q26/iFMYTh+eDqDC70n/GYLNxXVyt
YhMjw758lD7whNJ/xkcNXY0uVYozGZnm/KDJmpq57wB4fGdU
          "]]}, 
        {RGBColor[0, 0, 1], PointSize[
          NCache[
           Rational[1, 72], 0.013888888888888888`]], AbsoluteThickness[1.6], 
         LineBox[CompressedData["
1:eJwt031QzAkYB/At3NzY0zgyl1LnyNu52F4IW3tfCuXOyxk1ojCRGImyq9WV
VmXlrkgpXep5ti5Hodu63FyYoXA0u5LxlonRxYwujek6MxjcXjy/Z+aZZz5/
fueZ7xex25bHOatUqvkD+/5+GCMhcah23sPkxLkfnEYYU1h97dyx7WITISjN
qr95NEmcTUj51Ode/NJkcQ6ht/Ovl2v+VZxL8BxRaXG46MX5hBtcPH2c0SA+
TNj/MsffxbpTXEJo/mZjdk9wiriMcNa2rKlJaxRbCF5z2r9XlewSVxHI1yM/
7HGq+ATBbp2U8duCNPEpgot1sdb2IF1sJaws3bvLfCFD3DCQJ1o/3nHJJP6D
YFx1ufDHS3vE5wlxz590Bjdlii8SjpfXTXnakyW+TPBRZ7rXLt8rvkZQRx4I
aS0wi+2EhtXvNnv55ojbCEm6RxOdHPvFtwn7akJq7o7IFbcTDLljM4KDDogf
ELa49bs8fH1Q3EmI7tOuD7+RL35CCMjnPNPVQ+JuwmlLVPdsp0JxLyEm8mLo
i6jD4j5CSEpjpse+IvELQmjUxFexmmLxK0Jx/H+uw/yPiN8SnPJG7e69p1jF
SP7dsMXtZIl4MOOKZcjBWt1P4o8Z//yg0cR8Xir+hJHqEdMS5VA8nKHu01U8
G1kmdmWsWlMee+adYjdGlznBrtaSeAyjtTq7fAcrHssw7/mya3gLi70ZpjY/
9jZaxJMZg7rfjk+dVCH+ijFE53fUvV6xhtGQNfpqh65SHMDwNHx3y9eueBZj
2KjpSyYE/iwOYkR0zHLusysGo7/5foS6rEocygjX/z25Mf6YOIwxbca0xG6P
X8TfMnZMSX3qP/i4eBnD0WL8WrPohHgFY+GRgjONG6vFKxl5Np8E56IacTTj
szcj71dVnhSvY6xubr3jaTsl3sC4EHD+z3rzafEmRk9WYGDFdcUJjGZNh8l1
a614O6NpsV9D4OhfxXrGhuQ6r53tio2M+XO6ZkYkWZX+D/x3auTjgDbFJoZt
bVr6jEV1Sv8ZTull3qX9inMYz+5+lL3VUD/3f91bYVM=
          "]]}}, {{}, {}}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{1948.5833333333335`, 0},
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImageSize->400,
      Method->{
       "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
        "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& )}},
      PlotLabel->FormBox[
       "\"cap stock, based on nominal constant\"", TraditionalForm],
      PlotRange->{{1948.5833333333335`, 2018.}, {0, 3.096856360267169*^8}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.02], 
         Scaled[0.05]}},
      Ticks->{Automatic, Automatic}]}
   },
   AutoDelete->False,
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellChangeTimes->{3.851536009293935*^9, 3.8515360643890567`*^9, 
  3.8515858853568897`*^9, 3.852086669675652*^9, 3.8521026947163925`*^9, 
  3.8725222459021316`*^9, 3.8725722814663954`*^9, 3.872572376424938*^9, 
  3.873011047643783*^9, 3.8744807125206385`*^9},
 CellLabel->
  "Out[590]=",ExpressionUUID->"192a1855-2cf3-4a41-8fab-adc3c7b634e4"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"capoutresultstri", "=", "capoutresults"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"capoutresultstri", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", 
      RowBox[{"{", 
       RowBox[{"6", ",", "10", ",", "18", ",", "21"}], "}"}]}], "]"}], "]"}], 
   "=", 
   RowBox[{
    RowBox[{"capoutresults", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", 
       RowBox[{"{", 
        RowBox[{"6", ",", "10", ",", "18", ",", "21"}], "}"}]}], "]"}], "]"}],
     "/", 
    RowBox[{"10", "^", "6"}]}]}], ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.8725861051879663`*^9, 3.8725861912785816`*^9}, {
  3.8725868652100277`*^9, 3.8725868755488997`*^9}},
 CellLabel->
  "In[591]:=",ExpressionUUID->"c6721c3d-33f0-4654-a4a2-883b8699b017"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"figcap22", "=", 
   RowBox[{"ListLinePlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Legended", "[", 
        RowBox[{
         RowBox[{"capoutresultstri", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;", "70"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "6"}], "}"}]}], "]"}], "]"}], ",", 
         RowBox[{"Placed", "[", 
          RowBox[{"\"\<cap-output-ratio based\>\"", ",", "Below"}], "]"}]}], 
        "]"}], ",", 
       RowBox[{"Legended", "[", 
        RowBox[{
         RowBox[{"capoutresultstri", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;", "70"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "21"}], "}"}]}], "]"}], "]"}], ",", 
         RowBox[{"Placed", "[", 
          RowBox[{"\"\<investment time-series based\>\"", ",", "Below"}], 
          "]"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1950", ",", "2018"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"10", ",", "450"}], "}"}]}], "}"}]}], ",", 
     RowBox[{
     "PlotLabel", "\[Rule]", 
      "\"\<c) capital stock (PPP, national prices)\>\""}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Blue", ",", 
          RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Orange", ",", 
          RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "}"}]}], "}"}]}], 
     ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<year\>\"", ",", "\"\<tril. $\>\""}], "}"}]}], ",", 
     RowBox[{"GridLines", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"100", ",", "200", ",", "300", ",", "400"}], "}"}], "}"}]}], 
     ",", 
     RowBox[{"LabelStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{
        RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
        RowBox[{"FontSize", "\[Rule]", "18"}], ",", "Black"}], "]"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}]}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.8725859472033176`*^9, 3.872586080648632*^9}, {
  3.872586196325844*^9, 3.872586344137269*^9}, {3.8725863853622093`*^9, 
  3.8725864107105904`*^9}, {3.8725864587221203`*^9, 3.872586481946723*^9}},
 CellLabel->
  "In[593]:=",ExpressionUUID->"7ad13441-854f-4cfa-a8b0-f3ae7512f6a4"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{}, {{{}, {}, 
       TagBox[{
         Hue[0.67, 0.6, 0.6], 
         Directive[
          PointSize[
           NCache[
            Rational[1, 72], 0.013888888888888888`]], 
          RGBColor[0, 0, 1], 
          AbsoluteThickness[2]], 
         LineBox[CompressedData["
1:eJwt0GtM0wcUBfBKiYJspjbCQJ3arYmPsapEGSDIUXFiKggMBzOMIC9B63MF
mRCpsVGIGjFSwoy5Fx9MEnXDjDkYzkeHiQQV5CVabbGgc4tzJCKiMUP0/k9y
cvL7enTpWxKyPFQq1fLRvtv3KSAkGDj+1Q8L8d5FhPbe4OHjRV+ILQSPneXm
Oc0hYishMSgz9EldqLiEMN07w8EcJj5A2Fu+r9g6NlxcRtjYoE7LexUhLick
rZrx3Lc2UlxJ0DrXFCfHQnyM8E/umcSfHimuIpj0Y1IedC8RnyKcO7HwoyW/
LBXXEG6bSlZGH1kmPksY6d2d3FkdJa4lwP+CIa5vubiOYJ75wOec1wpxPeHs
bFNt0Opo8UXCpIJNxvM1K8VXCIWbZ53uMhjFTYRLpV6Fh6fGiK8TuvxsusDW
WPENQliX/drjkjhx2+gf/wU4X1yJF3eO/rk6Vvtm5lfiHsJLV3uMvSlRfJ/g
a9tV8VjztbiXkFoceBQhSeJ+glN3ef4xW7L4CaE5MjM3OGKt+CnB/re7JT0g
RTxAmD2Rfasd34oHCeoe94ehN1PFw4TxUWH6an2a+A3h7qX/828eUaxiaL3z
vaZMWyf2ZCzuNv6lsij2Ynz6nNwZunTxB4ym052Tve2KNYxabbArwpohnsTw
7Nii+m1OptifUemzZ0G3f5Z4KiNgR6ztYLziGQzHmEP7f1dni/UM9ZTwceev
K57FqFGvs7iq1osDGX5Xy9Z0peWI5zGs6hUhHfNzxQsYJzMeua4OKQ5haO5o
DjfnbxCHMwoXeziyv9woBuNe78QfU7eZxFGMWxr9s0baJI5mbPikZcTYuFm8
inFQU/q0ym+rOI4RttaZFKndJk5kZA1N8OkbUJzMGNGc0ce7t4tTGMbPzbbP
/vxOnMao69fHGRrM4kzGwGDZ3JisPHEOozXh4XDOBcUmxqL7ztKL0fnirQyX
g4J+vafYzGjb05O3yLJDXMDY5Tl3af03BeIixscBhvrBIcUWhqXoVPD+lu/F
VkaF2972+uFOcQnj3z90rp8vF+ItZntUGA==
          "]]}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$155171, {1}}]& ], 
       TagBox[{
         Hue[0.9060679774997897, 0.6, 0.6], 
         Directive[
          PointSize[
           NCache[
            Rational[1, 72], 0.013888888888888888`]], 
          RGBColor[1, 0.5, 0], 
          AbsoluteThickness[2]], 
         LineBox[CompressedData["
1:eJwt0H1MzHEcB/BbHuZpZMzTMRomzZKHIqq90VXS0cOdIpFTCqdOD9zd7tII
USzzmNr3E5GOk/L8EGKxEBJ/FKbYRaUdax4KM8fn99k+++y1z/bZ3h8XTXJ4
vJNMJlM4+t/8X3qBcHcK6873xH+bBLzUNVrNolnsTIGAm1avaIU3O0ugbURX
TKp8LjtbYGztqltWJ192rkDNwz2J/Tv82HkCfobyB8ZcsA8K9MsOGnXu/Dz2
UYHZe66c+tY4n10o0N3j6KT7XQvYRY59dXrFszkK9kmBDyW2YeV7A9ilAp9X
H9lc9CaQbRWwm1e2uE5byC533JMZm9/nB7MvCUTEGNxCp4WwrwnY1JqTw2xK
dqXAzjLySz2zhF0l0BqYsuDq+VB2tUBBXlPb68Nh7BqBwb5b7ccOhLNrBdKa
Zr66TBHsOoGGMm1EXIWK/VLg6TzTTv96NbtB4Ky5XflUHsl+I1Aab4t1Tohi
NwsM6ZseYs1ZxrYJBN3N6vfk9XJ2q8CN3l+S7viuYHcI5P/J0buVxbC/CLRU
btMtnbyK/VUgdtCzUiyJZXcJlBRnVu3vsZr9W6DOdPrXmeOSZQS1f36xm4+G
3ZNgKB+e5t4quQ9B+7Pu+pT9a9gDCHLL1N/NPnFsZ0Lg2zCzR6fkoYTw2heZ
T27Hs0cQRubpdrgcWsseTZj+6/uYynUJ7HGEFzs+TTBMTWRPIDi9lXu3tUl2
JZidxq/UFKxjTyF0dHrfDFavZ3sQrFerH/cfuYE9k2DRNViPvJc8mzDxHQqt
F7VsH0LBj5QbxoyNbBAUAy1F7coktj/BtKvuUNKMZHYQYYvlgoJ66tghhKjJ
9fvsGySHEr7HGHqdfiVZRbhmyelG9CZ2FGHxWM/mYx8lryBsswU/er49hR1L
0JmVeRfdU9lxjnztquL0RsmJhMgWe0D98jS2lnD8sVJv7Jasc/xzd+Fd15J0
dhrhQ2PGok7VZrbekW+Ns/xRny1sE6FhqSEn4YHkTMIts8rusVvPziJURd57
eEJhYGcT7ngYcoOdjfgLkUJkPA==
          "]]}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$155171, {2}}]& ]}, {
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$155171, {1}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$155171, {2}}]& ]}, {
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$155171, {1}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$155171, {
          2}}]& ], {}, {}, {}}, {
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$155171, {1}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$155171, {
          2}}]& ], {}, {}, {}}}, {{}, {}}}, {
    DisplayFunction -> Identity, DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {
       FormBox["\"year\"", TraditionalForm], 
       FormBox["\"tril. $\"", TraditionalForm]}, AxesOrigin -> {1950., 10.}, 
     DisplayFunction :> Identity, Frame -> {{False, False}, {False, False}}, 
     FrameLabel -> {{None, None}, {None, None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {{100, 200, 300, 400}, {100, 200, 300, 400}}, 
     GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> 600, LabelStyle -> 
     Directive[FontFamily -> "Helvetica", FontSize -> 18, 
       GrayLevel[0]], 
     Method -> {
      "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
       "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& )}}, PlotLabel -> 
     FormBox["\"c) capital stock (PPP, national prices)\"", TraditionalForm], 
     PlotRange -> {{1950, 2018}, {10, 450}}, PlotRangeClipping -> True, 
     PlotRangePadding -> {{0, 0}, {0, 0}}, Ticks -> {Automatic, Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{
      "\"cap-output-ratio based\"", "\"investment time-series based\""}, 
      "LineLegend", DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0, 0, 1], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0, 0, 1], 
                    AbsoluteThickness[2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #, 
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[1, 0.5, 0], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[1, 0.5, 0], 
                    AbsoluteThickness[2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.8, 0.5}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxDividers -> {"Columns" -> {{None}}, "Rows" -> {{None}}}, 
             GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
             GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{1}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
          Directive[FontFamily -> "Helvetica", FontSize -> 18, 
           GrayLevel[0]], FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "72"], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 0, 1], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}], 
                   ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "72"], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0.5, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[0.6666666666666666, 0.33333333333333337`, 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0.5`", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0.5, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0.5, 0], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}]}], 
                 "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "72"], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 0, 1], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}], 
                   ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "72"], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0.5, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[0.6666666666666666, 0.33333333333333337`, 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0.5`", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0.5, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0.5, 0], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}]}], 
                 "}"}]}], "}"}], ",", 
           RowBox[{"{", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{#, ",", #2}], "}"}], ",", 
               RowBox[{"{", "}"}]}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"None", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"None", ",", "Automatic"}], "}"}]}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], 
               "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"True", ",", "True"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"True", ",", "True"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
               RowBox[{
                 RowBox[{"FontFamily", "\[Rule]", "\"Helvetica\""}], ",", 
                 RowBox[{"FontSize", "\[Rule]", "18"}], ",", 
                 InterpretationBox[
                  ButtonBox[
                   TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                   BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                   ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                   Automatic, Method -> "Preemptive"], 
                  GrayLevel[0], Editable -> False, Selectable -> False]}], 
               "]"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Row\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "Below"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.8725859571688404`*^9, 3.8725859946273823`*^9, 3.872586037918578*^9, 
   3.8725860811790266`*^9, {3.872586206899217*^9, 3.8725862424363966`*^9}, 
   3.8725862807587986`*^9, {3.872586337445475*^9, 3.872586344660573*^9}, 
   3.872586411634099*^9, 3.8725864837674155`*^9, 3.8730110517288675`*^9, {
   3.8730112332064247`*^9, 3.8730112412879353`*^9}, 3.874480737293383*^9},
 CellLabel->
  "Out[593]=",ExpressionUUID->"9a0ae9e7-1c3b-4933-9db4-4b98e217f52b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"figinv22", "=", 
   RowBox[{"ListLinePlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Legended", "[", 
        RowBox[{
         RowBox[{"capoutresultstri", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;", "70"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "10"}], "}"}]}], "]"}], "]"}], ",", 
         RowBox[{"Placed", "[", 
          RowBox[{"\"\<cap-output-ratio based\>\"", ",", "Below"}], "]"}]}], 
        "]"}], ",", 
       RowBox[{"Legended", "[", 
        RowBox[{
         RowBox[{"capoutresultstri", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;", "70"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "18"}], "}"}]}], "]"}], "]"}], ",", 
         RowBox[{"Placed", "[", 
          RowBox[{"\"\<investment time-series based\>\"", ",", "Below"}], 
          "]"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1950", ",", "2018"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "40"}], "}"}]}], "}"}]}], ",", 
     RowBox[{
     "PlotLabel", "\[Rule]", "\"\<d) investment (PPP, national prices)\>\""}],
      ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Blue", ",", 
          RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Orange", ",", 
          RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "}"}]}], "}"}]}], 
     ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<year\>\"", ",", "\"\<tril. $\>\""}], "}"}]}], ",", 
     RowBox[{"GridLines", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"10", ",", "20", ",", "30", ",", "40"}], "}"}], "}"}]}], ",", 
     RowBox[{"LabelStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{
        RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
        RowBox[{"FontSize", "\[Rule]", "18"}], ",", "Black"}], "]"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}]}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.872586822640783*^9, 3.8725868537841206`*^9}, {
  3.8725868951696105`*^9, 3.8725869779594936`*^9}},
 CellLabel->
  "In[595]:=",ExpressionUUID->"48aff6f4-eff4-4525-8467-164f5a59e105"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{}, {{{}, {}, 
       TagBox[{
         Hue[0.67, 0.6, 0.6], 
         Directive[
          PointSize[
           NCache[
            Rational[1, 72], 0.013888888888888888`]], 
          RGBColor[0, 0, 1], 
          AbsoluteThickness[2]], 
         LineBox[CompressedData["
1:eJwt0Q1IlVcYB/BXZ6lp2rizdFh5xbxmsszm1GX5T/yqTNrNrKUt20wtFWvJ
1LiGwZVuZnVbrpzm86wvMiprUhFruyvWotXUMO0DjAZpOPtQMNE5y24+54WX
lx//838457z6rwuNGx01TYu3v++/408J4XGsZ+6VUieM20TQCsMHg5dr4nLC
zaVJu4fX/x8zbjMh6+nCYocnyhbC74ZjyVE+jrK+ijDNYB5o7J0othK+yl6b
1FEzQVxNWHTnXmby4THp1xAqpy/c0xuo+kcI26isY5LeRfwT4dySYnd9gbP4
BOH66VNVZSEqbyBE/XDNdOeBm/gswXlCwXe/zfQUXyA822fzP5viIb5I2GeN
yppaMUV8hRBhtC7rKftQ/Cthrnl7sy1JJ75G2L/HtmXj4FTxDcKOJw5d6894
iW8RTOtSXIcufSz+277ea2TE1uYrvktY1Zl/bE6Mn7idkPm06c0X6f7ih4Sf
dU0XE9JU3kloN2y6lRg2U/wP4dCBlsLgBr24i9A6+PzfFbkB4h77/R14cGO7
NVD8gnA8zeN7g1G5n9Bb0hDknarmvyZ8tvq/kj9fqf6w/T5H12VOzFf5KCG8
L6yvdJXan8b2/+E5Y5uXyp0YkTZqtsSovgujrzLfWl2l7M6YtfaXvfWaQTyF
UVG8s/Pu1VnijxgFqX+kZZ8IFnszdlS63R76UZ3Xl3E+3fKlP6m+H8Mvtsjs
Hz9bHMB42DYtJWNI9YMY8e7f1P41pPIQxgcHF7SQeY44lGFYmrByeKXyp4z7
I4F1OQfV/EiGx+vqGab+EHE0I2BxU55WP08MRrdr18AhnzBxHMNYm4Prb1We
xHB72WbUTQ4XJzPaN+R1J1yOEq9gNEcX3t5VEylOtZ/fx/vq2Lefi9cw6uO6
TEWhyhmM1en64c2J0eJMRg91B20oV/0sRqmWOOl83nxxLiO28YLX/UcR4nzG
yQ6nrctz1fotjNC60ZPJEWp+ESM7OOPZJ7pF4hJG67J5LY3OC8QmxuWE6HOj
LjHicoZvjfm044vFYjNDN7viyJLDEFsYlhzXyWNHY/EOGjhF9Q==
          "]]}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$155716, {1}}]& ], 
       TagBox[{
         Hue[0.9060679774997897, 0.6, 0.6], 
         Directive[
          PointSize[
           NCache[
            Rational[1, 72], 0.013888888888888888`]], 
          RGBColor[1, 0.5, 0], 
          AbsoluteThickness[2]], 
         LineBox[CompressedData["
1:eJwt0HtME3YQB/AOVp2KCtRZlaoIRUAFRVB8FP2KMGTxMYhmI8z4GFRiWO3U
RKI14gMlaBCj+Iq707g5DEgYUjOVKEFGcBBFVh8g+AiMqJWhBgg+IFbvd8nl
8sl975+bsHZDYqqbRqOJdfWn+bkyCO//O+lR3umGz7YR9PcbhscXacWZhKMP
E0q2+invIfwS1M00dYA4m3Cpt7vVvVb5AGGDdt3/cbZB4jxCyPUw57rng8VH
CHbrzmyL1kN8nJDo0F3peDtEfIpg2XarNNcxTHyaEFBhqY9e4Sn+jZBenZN/
54RyAWF7sm++KdBLXETwa+2O/zXQW1xCuF5qdjq+GCEuI2hXzGiLSvha/Bfh
hcO+bI1lpLickLK25nZmmnIFYeiusZ7lJXpxFSEctef7Do0W1xDc9w7Msgb7
iOsIF9ySHlsmGcT1hIXX3BL01WPFDkLT4VV5t3f7ih8QLj9/OtzjvXIzIU5v
fXx3qvITQnCB++oA5wRxm+v//+YuaGnzEz8jRP7eaN9X4y9+ScjNN1qX5hnF
rwg7OhODOhqUuwhZlfU39c3KvYSO9fFznS3q/oPrn6MfPkrqUdYwWrIWFjat
DBB/ydht8lm6Jkf5K8Y9/81LSr0nij0YP9U1v7MPDRR7Mvz676TY3gSJRzBe
X622LtdNEo9iVOg3xhjSlA2MnB1/3/D0UvZlhJRFTGxvDRYbGbmlunrNLeUg
Ruq3ZyLSK1V+CqMzOVh7tHGyeBrjZUF0MSqmiCMY135e1TO/NkQ8izGu2Pd7
Q5+yiWGN/kM3oClUDNd9WPu8mPRp4hhX/tCY/eNilRcxIhv032QkKS9mnHxW
6Gw0hIm/Y/j0tUT6508XL2d8cFzu6asMF//A2OIV0WWInSH+kdGYGlr1oGqm
eDUj/KDzdVdKpDiF8a7I2D/LrPJpjNkXC/+0X1T7dEa57YDRHjJbbGXUmc75
RHUrb2YsSu5/1ds+R5zBKCgyd1wabxLbGINuFG86p4sSZzLOHvPWlSUo72Gs
/CfanHh3njibkRcXal48BvgICwFPnQ==
          "]]}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$155716, {2}}]& ]}, {
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$155716, {1}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$155716, {2}}]& ]}, {
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$155716, {1}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$155716, {
          2}}]& ], {}, {}, {}}, {
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$155716, {1}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$155716, {
          2}}]& ], {}, {}, {}}}, {{}, {}}}, {
    DisplayFunction -> Identity, DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {
       FormBox["\"year\"", TraditionalForm], 
       FormBox["\"tril. $\"", TraditionalForm]}, AxesOrigin -> {1950., 0}, 
     DisplayFunction :> Identity, Frame -> {{False, False}, {False, False}}, 
     FrameLabel -> {{None, None}, {None, None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {{10, 20, 30, 40}, {10, 20, 30, 40}}, GridLinesStyle -> 
     Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> 600, LabelStyle -> 
     Directive[FontFamily -> "Helvetica", FontSize -> 18, 
       GrayLevel[0]], 
     Method -> {
      "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
       "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& )}}, PlotLabel -> 
     FormBox["\"d) investment (PPP, national prices)\"", TraditionalForm], 
     PlotRange -> {{1950, 2018}, {0, 40}}, PlotRangeClipping -> True, 
     PlotRangePadding -> {{0, 0}, {0, 0}}, Ticks -> {Automatic, Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{
      "\"cap-output-ratio based\"", "\"investment time-series based\""}, 
      "LineLegend", DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0, 0, 1], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0, 0, 1], 
                    AbsoluteThickness[2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #, 
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[1, 0.5, 0], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[1, 0.5, 0], 
                    AbsoluteThickness[2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.8, 0.5}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxDividers -> {"Columns" -> {{None}}, "Rows" -> {{None}}}, 
             GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
             GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{1}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
          Directive[FontFamily -> "Helvetica", FontSize -> 18, 
           GrayLevel[0]], FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "72"], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 0, 1], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}], 
                   ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "72"], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0.5, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[0.6666666666666666, 0.33333333333333337`, 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0.5`", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0.5, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0.5, 0], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}]}], 
                 "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "72"], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 0, 1], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}], 
                   ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "72"], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0.5, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[0.6666666666666666, 0.33333333333333337`, 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0.5`", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0.5, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0.5, 0], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}]}], 
                 "}"}]}], "}"}], ",", 
           RowBox[{"{", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{#, ",", #2}], "}"}], ",", 
               RowBox[{"{", "}"}]}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"None", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"None", ",", "Automatic"}], "}"}]}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], 
               "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"True", ",", "True"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"True", ",", "True"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
               RowBox[{
                 RowBox[{"FontFamily", "\[Rule]", "\"Helvetica\""}], ",", 
                 RowBox[{"FontSize", "\[Rule]", "18"}], ",", 
                 InterpretationBox[
                  ButtonBox[
                   TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                   BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                   ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                   Automatic, Method -> "Preemptive"], 
                  GrayLevel[0], Editable -> False, Selectable -> False]}], 
               "]"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Row\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "Below"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{{3.872586908764107*^9, 3.8725869787398405`*^9}, 
   3.873011164295615*^9, {3.8730112272451344`*^9, 3.873011247876465*^9}, 
   3.874480757819789*^9},
 CellLabel->
  "Out[595]=",ExpressionUUID->"bb5276e6-1932-466f-aca9-2b853a1d3dc7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Figcalib", "=", 
  RowBox[{"Grid", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Fcpobs", ",", "FigDepreciation2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"figcap22", ",", "figinv22"}], "}"}]}], "}"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.872586993445966*^9, 3.872587024622456*^9}, {
  3.8725871060806246`*^9, 3.8725871078379107`*^9}},
 CellLabel->
  "In[596]:=",ExpressionUUID->"21e00f89-2fa5-499c-a2e8-a717ff527f34"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     TemplateBox[{
       GraphicsBox[{{}, {{{}, {}, 
           TagBox[{
             Hue[0.67, 0.6, 0.6], 
             Directive[
              PointSize[
               NCache[
                Rational[1, 72], 0.013888888888888888`]], 
              RGBColor[1, 0, 0], 
              AbsoluteThickness[2]], 
             LineBox[CompressedData["
1:eJwt0AtMzXEUB/AbqW6lmddIky7X2iiSWpn0TS61MI9GuCSvYpG1InnULKbE
Grk9xjmmvENcj4witbGU2r0aay155BUqt/LKI/3Pb/vtt8++v3P2Oz+3NXGL
1vdTqVSze/f/s28lEWLMWV5PJlihz7sIA1MMXVWTxKmELFfng2f14jTCMmPw
3nXR4gOEhmzdUpO/OJOgXfZ21vgAcRZhadjIfP8McTbhyqkhxqgz4lxCTYVL
xY9a8XFCcYhHkq5ZfJKg1tu3PDWLCwnN736+cnggPkcwzFu+rbNDXESwcc9V
H3wpLia4W7ye7WkUXyc45B3+kNElLiFcNjzM7/givku45qG+sSS4n+L7hLYj
ESdcw8SVBI0pKPKOTvyod/4x/qbh7VJfTfAJ9N4RAcnrCLnJiWxMFD8l7NvY
skeTKn5O4AJvi6ZW3EhwLItMHmDsr7iZ8OfYoIr6sdaK3xDmT040WwWJ3xNu
3SvVru4QfyI4eVmqf3wXtxNUx+1afZ0GKO4k/B3t16Uzir8T3l76uzjHylZx
D6Hx4czWxG82ilWMM3p1vHac5NYMzzq3GSuOiu0YL/IS/lhG2Sl2ZFTe/mro
DhUPYoxa5euwaZN4KKPiasHjjEzxCEb8/vTT6mi1YhdGvduvlMJI8RhGT+XF
orIGe8XjGIUfWm6kz3FU7M5Inxb44H7bQMUTGVG55s5SFyfFkxnBt8pbq5sk
n8pI/ta5PzZA6v0Yqs+mmvgi8XTG+QD/aXHZYjBO1UT+TtGLZzF277Tk+F5y
UBzCGK9NN+27LJ7LKD5WOSRKJ17A8EnT9t8+WxzO2FBVZ7K+KfNEMHZ412mT
Q8V6xu/NZ094hIhXM7rXxC2IXihe1/sfJa/XPlbLe2IYoVuWv3mZIP1jGb4X
Dv2cYpb7WxnlXz3eNWkkT2C4+c0Ld3YWJzFsmlpqYkPFuxhtw1bSeY30T+11
4cfdgz3FaQzv8sB2g1Z8gOHq2cOuJVKfyWiyPR3eU+6If5UeTZw=
              "]]}, 
            Annotation[#, {{Legended}, Charting`Private`Tag$143742, {1}}]& ], 
           TagBox[{
             Hue[0.9060679774997897, 0.6, 0.6], 
             Directive[
              PointSize[
               NCache[
                Rational[1, 72], 0.013888888888888888`]], 
              RGBColor[0, 0, 1], 
              AbsoluteThickness[2]], 
             LineBox[CompressedData["
1:eJw10XtMzWEYB/Cj03UMEXObamxoLnFaoaO+SC7DWokitJTrqVxbtnA40WWn
Rs6Wiec5OydFc2krK+MPlyK0k/slNCoOyx+ydLGSo9/j3d69++z7Xp49r29C
amSSk0qlCnfMf+vASCcU2HOGPYr6EzrgDMLpYzCUpYn1BK+KgF7dBXEmobLM
9YrmpTib8NP/l0uYXWwk6P2qnm6L7Vd8klAWaOur6BKbCCnzejRhLeIzhG8r
bDFFuSoM+Bzh2Mn4/ugKsZmgzdXGNkWJiwmp4XWhKbHii4TljTHJ6Zniy4Tg
8UUJ7TPE5Y56biXeb14sriQELF23bewscTXhd3/4Rv8T4lsEVdrsstYG8W1C
dnb7xI5X4hqCrma+5pdRXEdYqyrZGHhNXE+IH/aotilqkOInBE9rnAYN4heE
uKkRN0w+TorfEGoLixoibJK/d/QrYoe60Sr5R8Kr+iPRbS3iVkJQzxm1xSb+
SmjaVPBiSpJa8XeC+ym/RU6B4h8E04HUnDyLuINgbNt8LiTBWXE34eP1G4fN
q1wU9xK+PtiZkWoUqxibyj+H2NxcFTsz9OnetRO1YndGZ/7WLQt7xUMY9dZd
z4O+iIczJrUef4t8N8VejPjQoLpLU9wVj2HoNFm25SHiCQyDa1700SFiH0bo
vq53g0vEkxknaoOeeA/1UDyVMdpz0erRN8XTGeNMD4s6non9GS1vPiQFXJXz
AYzI926zXdqlnrmMnmRP0+U2ybWM4sT1zebTYjB8+zaXdo4QhzFUozacVx8U
L2MMfdc69q5dvJKx67Nz4Z2L4gjG3NLqe/r74jWOfl7/rl3ZJ+/HMGp8iq2r
y8VxjK3mnnJrijieMa29sMu8X5zIOLyw0SMyT+7bzqje6/2p+7VY5/iPyoYr
h6pk/25G8x6dgV6L9zNmGuzJXmrZn8744Hp2Aj2WPIMxfG1wbtZ6yfWMOSPt
loL//c9kJNjHVC0wiLMZ5uDS7jWe0m8j4+ftJZZYiwf+Ah16Uko=
              "]]}, 
            Annotation[#, {{Legended}, Charting`Private`Tag$143742, {2}}]& ], 
           TagBox[{
             Hue[0.1421359549995791, 0.6, 0.6], 
             Directive[
              PointSize[
               NCache[
                Rational[1, 72], 0.013888888888888888`]], 
              RGBColor[0, 1, 0], 
              AbsoluteThickness[2]], 
             LineBox[CompressedData["
1:eJwt0QlMznEYB/BXh96ovGHKpOV+zTtXWpnUV2voGDmW3gkdGrnK9RJZyDpI
dBHa81hRoeicK7E3o5TxWnJTlljYTOXYMtL/+W2/Pfvs+T3H9hsTEbM0ykyl
Us3vu/9j/9lNOD83wzHD8Ne73/GElnFPgytnqtDv/YSxU79XmMWJDxFqowM8
cpeIUwgb6rydf+8TpxGSzrqpkgzi44Q1viMOqn+KswmaeQWWxsUDFOcSvHz1
02IjxHkEh+HDnF8tEJ8lZDbyxWcbxecIrj4J+dXl4mJCXO2cQEOFuITQ/tH+
QnSjuIwQU/MuI88kriKcWLeyYGWb+BrhpqdfSrG1meIagnf5nXTrMPEdQm6h
Q3rWQfFdQnO+efrpenE9YUZH7Ko9OnPFTYQJM38aNWXix4T1Z9a+fOtkobiZ
UNFa1XR4u/h5335Vi6jwlKXi1wTDky6H6MKBilsJGx+/bRlfLW4nPJyqH5kw
ykrxJ4Jxi741oVL8hXB33pFIuyi14m+ECHeP/GN6a8XdhO7Xoyf1FIl/Edwb
ynRe5YMU9xLswn0Ov7gkVjECQn+saNeLLRh/tlW2dViI1YwfQ8Isg6zFNowB
N0zjdnVKfw3DPGj0y64W8XCGviBGZf9Q7NjX36guCdZJvRNjdoOfdsoMsQvj
wuSO5J4i8XjG4mUa3RGXwYq1jLjGPL/CcLGOca3JMeL6avF0xofzTW5HIZ7F
uP2+82+3rdiDUXYrdHKmmdiTkZi6rMOpU+aBsTcl+c2YZrEvwzl7+fOtC+X9
QoY22HtraYI4kDG0+t5Eq/viIIbfUcvLiVY2ipczbmm/1wbqxCGMkCJTXomb
OJTRq/5aN3uSOIxR6vVBM/CpeC2DHzjtNH61Vbye4R4aeTX1neQ3Mco9/J80
HBPHMlwPTNfmnBTvYKy6ctLiokG8m1FserQ5PlEcz+jOsu8NXyfez/Cv+Tzs
War4EKOmIDWqskWc0ve/STmmZCvZJ43RtvpcSfxOW/wDizVDlg==
              "]]}, 
            Annotation[#, {{Legended}, Charting`Private`Tag$143742, {
              3}}]& ]}, {
           
           TagBox[{}, 
            Annotation[#, {{Legended}, Charting`Private`Tag$143742, {1}}]& ], 
           
           TagBox[{}, 
            Annotation[#, {{Legended}, Charting`Private`Tag$143742, {2}}]& ], 
           
           TagBox[{}, 
            Annotation[#, {{Legended}, Charting`Private`Tag$143742, {
              3}}]& ]}, {
           
           TagBox[{}, 
            Annotation[#, {{Legended}, Charting`Private`Tag$143742, {1}}]& ], 
           
           TagBox[{}, 
            Annotation[#, {{Legended}, Charting`Private`Tag$143742, {2}}]& ], 
           
           TagBox[{}, 
            Annotation[#, {{Legended}, Charting`Private`Tag$143742, {
              3}}]& ], {}, {}, {}, {}, {}, {}, {}}, {
           
           TagBox[{}, 
            Annotation[#, {{Legended}, Charting`Private`Tag$143742, {1}}]& ], 
           
           TagBox[{}, 
            Annotation[#, {{Legended}, Charting`Private`Tag$143742, {2}}]& ], 
           
           TagBox[{}, 
            Annotation[#, {{Legended}, Charting`Private`Tag$143742, {
              3}}]& ], {}, {}, {}, {}, {}, {}, {}}}, {{}, {}}}, {
        DisplayFunction -> Identity, DisplayFunction -> Identity, AspectRatio -> 
         NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
         AxesLabel -> {
           FormBox["\"year\"", TraditionalForm], 
           FormBox["\"ratio\"", TraditionalForm]}, AxesOrigin -> {1950., 1.8},
          DisplayFunction :> Identity, 
         Frame -> {{False, False}, {False, False}}, 
         FrameLabel -> {{None, None}, {None, None}}, 
         FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
         GridLines -> {{2, 2.5, 3, 3.5}, {2, 2.5, 3, 3.5}}, GridLinesStyle -> 
         Directive[
           GrayLevel[0.5, 0.4]], ImageSize -> 600, LabelStyle -> 
         Directive[FontFamily -> "Helvetica", FontSize -> 18, 
           GrayLevel[0]], 
         Method -> {
          "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
           "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), "CopiedValueFunction" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& )}}, PlotLabel -> FormBox[
           StyleBox[
           "\"a) Capital-Output Ratio (N=180)\"", FontFamily -> "Helvetica", 
            FontSize -> 18, StripOnInput -> False], TraditionalForm], 
         PlotRange -> {{1950, 2019}, {1.8, 4}}, PlotRangeClipping -> True, 
         PlotRangePadding -> {{0, 0}, {0, 0}}, 
         Ticks -> {Automatic, Automatic}}], 
       FormBox[
        FormBox[
         TemplateBox[{
           StyleBox[
           "\"Mean\"", FontFamily -> "Helvetica", FontSize -> 18, 
            StripOnInput -> False], 
           StyleBox[
           "\"Median\"", FontFamily -> "Helvetica", FontSize -> 18, 
            StripOnInput -> False], 
           StyleBox[
           "\"Aggregated\"", FontFamily -> "Helvetica", FontSize -> 18, 
            StripOnInput -> False]}, "LineLegend", DisplayFunction -> (FormBox[
            StyleBox[
             StyleBox[
              PaneBox[
               TagBox[
                GridBox[{{
                   TagBox[
                    GridBox[{{
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[1, 0, 0], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[1, 0, 0], 
                    AbsoluteThickness[2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #, 
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0, 0, 1], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0, 0, 1], 
                    AbsoluteThickness[2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2, 
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0, 1, 0], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0, 1, 0], 
                    AbsoluteThickness[2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                    AutoDelete -> False, 
                    GridBoxDividers -> {
                    "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                    GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                    GridBoxSpacings -> {"Columns" -> {{0.8, 0.5}}}], 
                    "Grid"]}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                 False, GridBoxDividers -> {
                  "Columns" -> {{None}}, "Rows" -> {{None}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{1}}}], 
                "Grid"], Alignment -> Left, AppearanceElements -> None, 
               ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
               "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
              Directive[FontFamily -> "Helvetica", FontSize -> 18, 
               GrayLevel[0]], FontFamily -> "Arial"}, Background -> Automatic,
              StripOnInput -> False], TraditionalForm]& ), 
          InterpretationFunction :> (RowBox[{"LineLegend", "[", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "72"], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0, 0], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "72"], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 0, 1], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "72"], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0.6666666666666666, 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "1", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 1, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 1, 0], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}]}], 
                    "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "72"], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0, 0], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "72"], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 0, 1], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "72"], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0.6666666666666666, 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "1", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 1, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 1, 0], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}]}], 
                    "}"}]}], "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{#, ",", #2, ",", #3}], "}"}], ",", 
                   RowBox[{"{", "}"}]}], "}"}], ",", 
               RowBox[{"LegendMarkers", "\[Rule]", 
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"None", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"None", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"None", ",", "Automatic"}], "}"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], 
                   "}"}]}], ",", 
               RowBox[{"Joined", "\[Rule]", 
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"True", ",", "True", ",", "True"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"True", ",", "True", ",", "True"}], "}"}]}], 
                   "}"}]}], ",", 
               RowBox[{"LabelStyle", "\[Rule]", 
                 RowBox[{"Directive", "[", 
                   RowBox[{
                    RowBox[{"FontFamily", "\[Rule]", "\"Helvetica\""}], ",", 
                    RowBox[{"FontSize", "\[Rule]", "18"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False]}], 
                   "]"}]}], ",", 
               RowBox[{"LegendLayout", "\[Rule]", "\"Row\""}]}], "]"}]& ), 
          Editable -> True], TraditionalForm], TraditionalForm]},
      "Legended",
      DisplayFunction->(GridBox[{{
          TagBox[
           ItemBox[
            PaneBox[
             TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline},
              BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
           "SkipImageSizeLevel"]}, {
          ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
        GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
        AutoDelete -> False, GridBoxItemSize -> Automatic, 
        BaselinePosition -> {1, 1}]& ),
      Editable->True,
      InterpretationFunction->(RowBox[{"Legended", "[", 
         RowBox[{#, ",", 
           RowBox[{"Placed", "[", 
             RowBox[{#2, ",", "Below"}], "]"}]}], "]"}]& )], 
     TemplateBox[{
       GraphicsBox[{{}, {{{}, {}, 
           TagBox[{
             Hue[0.67, 0.6, 0.6], 
             Directive[
              PointSize[
               NCache[
                Rational[1, 60], 0.016666666666666666`]], 
              RGBColor[0, 0, 1], 
              AbsoluteThickness[2]], 
             LineBox[CompressedData["
1:eJw1031MzAEYB/AfsrFlhfK+eSlmJiEUsr4jNCtyXmrTSF52ynumMyFE0l0L
R5n2POnSneTcvEydk5STl8Yhlde8FHmZt4yS5e0ez/bsu89/zx/fZ2DMGtWy
9oqiTPuzf/PfaAjeqQG+9U0c9M+JBJfCEJ2uT47TSYQq75Q0F5U4mXC9iMqe
rxbvIaQ6FL+aNLGWkKvxivaxijMIF5sflmXXivWEXj7LfrR+F2cRKrps981w
O+p0NsGTX23rPEScQ6hRnw6YGi7OI0yq09xzU4tNhEsGn2IlQVxIODMo03h/
s9hCaJnzbbojSXyWsPejZV22VlxEWJJw+/LCHLGNUNa6pS3TIi4lnDh/w+Jn
FV8hZM2yb/1aIb5GeJ7V23zwvbiSoIoteDm9c67TDsLn2EPWmP7iKsK+Xdci
bRPFtQT3OLu9ZoH4MWHit5LDeo34GSFjy2DDigPiekK66ZwlrEDcSMjTJbR+
uSh+T2hMi3ikvyH+RIiYP2mR+o74K+HphJExDxziZoLP7rj9bRXinwQl/vz6
hLNihdHf5jbC9ajYhbEkysP/kl7ciaHzeBQfrBW7MuJfJLra94jdGdueju0+
///9HoxmQ7sfT0ziXozweaZAJVPcj/FhX3zkTJt4AMPczrwjq1rszYg2n7RZ
G8RDGV5TGpanvxMPZxibYtVXW8QjGZuocXR+d4PTYxg1r60pt0aJAxgRnulV
qWHiQEbf3B1rPdViMAaMu6oKTRUHMxrrzO4tBeIQRtCgc7Wzy8WhDP3AGX7H
H4vDGbbISmVVxzyn5zJ6lAfaf00WRzLyV6eMMGSIoxgO1/3+JfXiaMZd7Vud
y/hjTi9luJmWljzcKFYzhldXDwstFK9kLIxpWlz8RbyWMSrkTbY9IN/pDYyq
lydCVOvEGkbPeZn+UUfEiYzy5Ch9h1JxEoMbthsLn4mT//Sh9PvNNsUo/8/w
PdVt5yYvsZZxoa62669gY9BvAYh8wQ==
              "]]}, 
            Annotation[#, {{Legended}, Charting`Private`Tag$152332, {
              1}}]& ]}, {
           
           TagBox[{}, 
            Annotation[#, {{Legended}, Charting`Private`Tag$152332, {
              1}}]& ]}, {
           
           TagBox[{}, 
            Annotation[#, {{Legended}, Charting`Private`Tag$152332, {
              1}}]& ], {}}, {
           
           TagBox[{}, 
            Annotation[#, {{Legended}, Charting`Private`Tag$152332, {
              1}}]& ], {}}}, {{}, {}}}, {
        DisplayFunction -> Identity, DisplayFunction -> Identity, AspectRatio -> 
         NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
         AxesLabel -> {
           FormBox["\"year\"", TraditionalForm], 
           FormBox["\"rate\"", TraditionalForm]}, AxesOrigin -> {1950., 0.03},
          DisplayFunction :> Identity, 
         Frame -> {{False, False}, {False, False}}, 
         FrameLabel -> {{None, None}, {None, None}}, 
         FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
         GridLines -> {{0.035, 0.04, 0.045}, {0.035, 0.04, 0.045}}, 
         GridLinesStyle -> Directive[
           GrayLevel[0.5, 0.4]], ImageSize -> 600, LabelStyle -> 
         Directive[FontFamily -> "Helvetica", FontSize -> 18, 
           GrayLevel[0]], 
         Method -> {
          "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
           "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), "CopiedValueFunction" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& )}}, PlotLabel -> FormBox[
           StyleBox[
           "\"b) Depreciation Rate (capital-stock weighted mean)\"", 
            FontFamily -> "Helvetica", FontSize -> 18, StripOnInput -> False],
            TraditionalForm], PlotRange -> {{1950, 2018}, {0.03, 0.05}}, 
         PlotRangeClipping -> True, PlotRangePadding -> {{0, 0}, {0, 0}}, 
         Ticks -> {Automatic, Automatic}}], 
       FormBox[
        FormBox[
         TemplateBox[{
           StyleBox[
           "\"Deprecriation rate\"", FontFamily -> "Helvetica", FontSize -> 
            18, StripOnInput -> False]}, "LineLegend", 
          DisplayFunction -> (FormBox[
            StyleBox[
             StyleBox[
              PaneBox[
               TagBox[
                GridBox[{{
                   TagBox[
                    GridBox[{{
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0, 0, 1], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0, 0, 1], 
                    AbsoluteThickness[2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                    AutoDelete -> False, 
                    GridBoxDividers -> {
                    "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                    GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                    GridBoxSpacings -> {"Columns" -> {{0.8, 0.5}}}], 
                    "Grid"]}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                 False, GridBoxDividers -> {
                  "Columns" -> {{None}}, "Rows" -> {{None}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{1}}}], 
                "Grid"], Alignment -> Left, AppearanceElements -> None, 
               ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
               "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
              Directive[FontFamily -> "Helvetica", FontSize -> 18, 
               GrayLevel[0]], FontFamily -> "Arial"}, Background -> Automatic,
              StripOnInput -> False], TraditionalForm]& ), 
          InterpretationFunction :> (RowBox[{"LineLegend", "[", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "60"], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 0, 1], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}], 
                    "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "60"], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 0, 1], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}], 
                    "}"}]}], "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"{", #, "}"}], ",", 
                   RowBox[{"{", "}"}]}], "}"}], ",", 
               RowBox[{"LegendMarkers", "\[Rule]", 
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"None", ",", "Automatic"}], "}"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}], "}"}]}], 
                   "}"}]}], ",", 
               RowBox[{"Joined", "\[Rule]", 
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", "True", "}"}], ",", 
                    RowBox[{"{", "True", "}"}]}], "}"}]}], ",", 
               RowBox[{"LabelStyle", "\[Rule]", 
                 RowBox[{"Directive", "[", 
                   RowBox[{
                    RowBox[{"FontFamily", "\[Rule]", "\"Helvetica\""}], ",", 
                    RowBox[{"FontSize", "\[Rule]", "18"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False]}], 
                   "]"}]}], ",", 
               RowBox[{"LegendLayout", "\[Rule]", "\"Row\""}]}], "]"}]& ), 
          Editable -> True], TraditionalForm], TraditionalForm]},
      "Legended",
      DisplayFunction->(GridBox[{{
          TagBox[
           ItemBox[
            PaneBox[
             TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline},
              BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
           "SkipImageSizeLevel"]}, {
          ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
        GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
        AutoDelete -> False, GridBoxItemSize -> Automatic, 
        BaselinePosition -> {1, 1}]& ),
      Editable->True,
      InterpretationFunction->(RowBox[{"Legended", "[", 
         RowBox[{#, ",", 
           RowBox[{"Placed", "[", 
             RowBox[{#2, ",", "Below"}], "]"}]}], "]"}]& )]},
    {
     TemplateBox[{
       GraphicsBox[{{}, {{{}, {}, 
           TagBox[{
             Hue[0.67, 0.6, 0.6], 
             Directive[
              PointSize[
               NCache[
                Rational[1, 72], 0.013888888888888888`]], 
              RGBColor[0, 0, 1], 
              AbsoluteThickness[2]], 
             LineBox[CompressedData["
1:eJwt0GtM0wcUBfBKiYJspjbCQJ3arYmPsapEGSDIUXFiKggMBzOMIC9B63MF
mRCpsVGIGjFSwoy5Fx9MEnXDjDkYzkeHiQQV5CVabbGgc4tzJCKiMUP0/k9y
cvL7enTpWxKyPFQq1fLRvtv3KSAkGDj+1Q8L8d5FhPbe4OHjRV+ILQSPneXm
Oc0hYishMSgz9EldqLiEMN07w8EcJj5A2Fu+r9g6NlxcRtjYoE7LexUhLick
rZrx3Lc2UlxJ0DrXFCfHQnyM8E/umcSfHimuIpj0Y1IedC8RnyKcO7HwoyW/
LBXXEG6bSlZGH1kmPksY6d2d3FkdJa4lwP+CIa5vubiOYJ75wOec1wpxPeHs
bFNt0Opo8UXCpIJNxvM1K8VXCIWbZ53uMhjFTYRLpV6Fh6fGiK8TuvxsusDW
WPENQliX/drjkjhx2+gf/wU4X1yJF3eO/rk6Vvtm5lfiHsJLV3uMvSlRfJ/g
a9tV8VjztbiXkFoceBQhSeJ+glN3ef4xW7L4CaE5MjM3OGKt+CnB/re7JT0g
RTxAmD2Rfasd34oHCeoe94ehN1PFw4TxUWH6an2a+A3h7qX/828eUaxiaL3z
vaZMWyf2ZCzuNv6lsij2Ynz6nNwZunTxB4ym052Tve2KNYxabbArwpohnsTw
7Nii+m1OptifUemzZ0G3f5Z4KiNgR6ztYLziGQzHmEP7f1dni/UM9ZTwceev
K57FqFGvs7iq1osDGX5Xy9Z0peWI5zGs6hUhHfNzxQsYJzMeua4OKQ5haO5o
DjfnbxCHMwoXeziyv9woBuNe78QfU7eZxFGMWxr9s0baJI5mbPikZcTYuFm8
inFQU/q0ym+rOI4RttaZFKndJk5kZA1N8OkbUJzMGNGc0ce7t4tTGMbPzbbP
/vxOnMao69fHGRrM4kzGwGDZ3JisPHEOozXh4XDOBcUmxqL7ztKL0fnirQyX
g4J+vafYzGjb05O3yLJDXMDY5Tl3af03BeIixscBhvrBIcUWhqXoVPD+lu/F
VkaF2972+uFOcQnj3z90rp8vF+ItZntUGA==
              "]]}, 
            Annotation[#, {{Legended}, Charting`Private`Tag$155171, {1}}]& ], 
           TagBox[{
             Hue[0.9060679774997897, 0.6, 0.6], 
             Directive[
              PointSize[
               NCache[
                Rational[1, 72], 0.013888888888888888`]], 
              RGBColor[1, 0.5, 0], 
              AbsoluteThickness[2]], 
             LineBox[CompressedData["
1:eJwt0H1MzHEcB/BbHuZpZMzTMRomzZKHIqq90VXS0cOdIpFTCqdOD9zd7tII
USzzmNr3E5GOk/L8EGKxEBJ/FKbYRaUdax4KM8fn99k+++y1z/bZ3h8XTXJ4
vJNMJlM4+t/8X3qBcHcK6873xH+bBLzUNVrNolnsTIGAm1avaIU3O0ugbURX
TKp8LjtbYGztqltWJ192rkDNwz2J/Tv82HkCfobyB8ZcsA8K9MsOGnXu/Dz2
UYHZe66c+tY4n10o0N3j6KT7XQvYRY59dXrFszkK9kmBDyW2YeV7A9ilAp9X
H9lc9CaQbRWwm1e2uE5byC533JMZm9/nB7MvCUTEGNxCp4WwrwnY1JqTw2xK
dqXAzjLySz2zhF0l0BqYsuDq+VB2tUBBXlPb68Nh7BqBwb5b7ccOhLNrBdKa
Zr66TBHsOoGGMm1EXIWK/VLg6TzTTv96NbtB4Ky5XflUHsl+I1Aab4t1Tohi
NwsM6ZseYs1ZxrYJBN3N6vfk9XJ2q8CN3l+S7viuYHcI5P/J0buVxbC/CLRU
btMtnbyK/VUgdtCzUiyJZXcJlBRnVu3vsZr9W6DOdPrXmeOSZQS1f36xm4+G
3ZNgKB+e5t4quQ9B+7Pu+pT9a9gDCHLL1N/NPnFsZ0Lg2zCzR6fkoYTw2heZ
T27Hs0cQRubpdrgcWsseTZj+6/uYynUJ7HGEFzs+TTBMTWRPIDi9lXu3tUl2
JZidxq/UFKxjTyF0dHrfDFavZ3sQrFerH/cfuYE9k2DRNViPvJc8mzDxHQqt
F7VsH0LBj5QbxoyNbBAUAy1F7coktj/BtKvuUNKMZHYQYYvlgoJ66tghhKjJ
9fvsGySHEr7HGHqdfiVZRbhmyelG9CZ2FGHxWM/mYx8lryBsswU/er49hR1L
0JmVeRfdU9lxjnztquL0RsmJhMgWe0D98jS2lnD8sVJv7Jasc/xzd+Fd15J0
dhrhQ2PGok7VZrbekW+Ns/xRny1sE6FhqSEn4YHkTMIts8rusVvPziJURd57
eEJhYGcT7ngYcoOdjfgLkUJkPA==
              "]]}, 
            Annotation[#, {{Legended}, Charting`Private`Tag$155171, {
              2}}]& ]}, {
           
           TagBox[{}, 
            Annotation[#, {{Legended}, Charting`Private`Tag$155171, {1}}]& ], 
           
           TagBox[{}, 
            Annotation[#, {{Legended}, Charting`Private`Tag$155171, {
              2}}]& ]}, {
           
           TagBox[{}, 
            Annotation[#, {{Legended}, Charting`Private`Tag$155171, {1}}]& ], 
           
           TagBox[{}, 
            Annotation[#, {{Legended}, Charting`Private`Tag$155171, {
              2}}]& ], {}, {}, {}}, {
           
           TagBox[{}, 
            Annotation[#, {{Legended}, Charting`Private`Tag$155171, {1}}]& ], 
           
           TagBox[{}, 
            Annotation[#, {{Legended}, Charting`Private`Tag$155171, {
              2}}]& ], {}, {}, {}}}, {{}, {}}}, {
        DisplayFunction -> Identity, DisplayFunction -> Identity, AspectRatio -> 
         NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
         AxesLabel -> {
           FormBox["\"year\"", TraditionalForm], 
           FormBox["\"tril. $\"", TraditionalForm]}, 
         AxesOrigin -> {1950., 10.}, DisplayFunction :> Identity, 
         Frame -> {{False, False}, {False, False}}, 
         FrameLabel -> {{None, None}, {None, None}}, 
         FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
         GridLines -> {{100, 200, 300, 400}, {100, 200, 300, 400}}, 
         GridLinesStyle -> Directive[
           GrayLevel[0.5, 0.4]], ImageSize -> 600, LabelStyle -> 
         Directive[FontFamily -> "Helvetica", FontSize -> 18, 
           GrayLevel[0]], 
         Method -> {
          "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
           "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), "CopiedValueFunction" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& )}}, PlotLabel -> 
         FormBox["\"c) capital stock (PPP, national prices)\"", 
           TraditionalForm], PlotRange -> {{1950, 2018}, {10, 450}}, 
         PlotRangeClipping -> True, PlotRangePadding -> {{0, 0}, {0, 0}}, 
         Ticks -> {Automatic, Automatic}}], 
       FormBox[
        FormBox[
         TemplateBox[{
          "\"cap-output-ratio based\"", "\"investment time-series based\""}, 
          "LineLegend", DisplayFunction -> (FormBox[
            StyleBox[
             StyleBox[
              PaneBox[
               TagBox[
                GridBox[{{
                   TagBox[
                    GridBox[{{
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0, 0, 1], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0, 0, 1], 
                    AbsoluteThickness[2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #, 
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[1, 0.5, 0], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[1, 0.5, 0], 
                    AbsoluteThickness[2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                    AutoDelete -> False, 
                    GridBoxDividers -> {
                    "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                    GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                    GridBoxSpacings -> {"Columns" -> {{0.8, 0.5}}}], 
                    "Grid"]}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                 False, GridBoxDividers -> {
                  "Columns" -> {{None}}, "Rows" -> {{None}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{1}}}], 
                "Grid"], Alignment -> Left, AppearanceElements -> None, 
               ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
               "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
              Directive[FontFamily -> "Helvetica", FontSize -> 18, 
               GrayLevel[0]], FontFamily -> "Arial"}, Background -> Automatic,
              StripOnInput -> False], TraditionalForm]& ), 
          InterpretationFunction :> (RowBox[{"LineLegend", "[", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "72"], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 0, 1], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "72"], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0.5, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[0.6666666666666666, 0.33333333333333337`, 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0.5`", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0.5, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0.5, 0], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}]}], 
                    "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "72"], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 0, 1], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "72"], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0.5, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[0.6666666666666666, 0.33333333333333337`, 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0.5`", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0.5, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0.5, 0], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}]}], 
                    "}"}]}], "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{#, ",", #2}], "}"}], ",", 
                   RowBox[{"{", "}"}]}], "}"}], ",", 
               RowBox[{"LegendMarkers", "\[Rule]", 
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"None", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"None", ",", "Automatic"}], "}"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], 
                   "}"}]}], ",", 
               RowBox[{"Joined", "\[Rule]", 
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"True", ",", "True"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"True", ",", "True"}], "}"}]}], "}"}]}], ",", 
               RowBox[{"LabelStyle", "\[Rule]", 
                 RowBox[{"Directive", "[", 
                   RowBox[{
                    RowBox[{"FontFamily", "\[Rule]", "\"Helvetica\""}], ",", 
                    RowBox[{"FontSize", "\[Rule]", "18"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False]}], 
                   "]"}]}], ",", 
               RowBox[{"LegendLayout", "\[Rule]", "\"Row\""}]}], "]"}]& ), 
          Editable -> True], TraditionalForm], TraditionalForm]},
      "Legended",
      DisplayFunction->(GridBox[{{
          TagBox[
           ItemBox[
            PaneBox[
             TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline},
              BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
           "SkipImageSizeLevel"]}, {
          ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
        GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
        AutoDelete -> False, GridBoxItemSize -> Automatic, 
        BaselinePosition -> {1, 1}]& ),
      Editable->True,
      InterpretationFunction->(RowBox[{"Legended", "[", 
         RowBox[{#, ",", 
           RowBox[{"Placed", "[", 
             RowBox[{#2, ",", "Below"}], "]"}]}], "]"}]& )], 
     TemplateBox[{
       GraphicsBox[{{}, {{{}, {}, 
           TagBox[{
             Hue[0.67, 0.6, 0.6], 
             Directive[
              PointSize[
               NCache[
                Rational[1, 72], 0.013888888888888888`]], 
              RGBColor[0, 0, 1], 
              AbsoluteThickness[2]], 
             LineBox[CompressedData["
1:eJwt0Q1IlVcYB/BXZ6lp2rizdFh5xbxmsszm1GX5T/yqTNrNrKUt20wtFWvJ
1LiGwZVuZnVbrpzm86wvMiprUhFruyvWotXUMO0DjAZpOPtQMNE5y24+54WX
lx//838457z6rwuNGx01TYu3v++/408J4XGsZ+6VUieM20TQCsMHg5dr4nLC
zaVJu4fX/x8zbjMh6+nCYocnyhbC74ZjyVE+jrK+ijDNYB5o7J0othK+yl6b
1FEzQVxNWHTnXmby4THp1xAqpy/c0xuo+kcI26isY5LeRfwT4dySYnd9gbP4
BOH66VNVZSEqbyBE/XDNdOeBm/gswXlCwXe/zfQUXyA822fzP5viIb5I2GeN
yppaMUV8hRBhtC7rKftQ/Cthrnl7sy1JJ75G2L/HtmXj4FTxDcKOJw5d6894
iW8RTOtSXIcufSz+277ea2TE1uYrvktY1Zl/bE6Mn7idkPm06c0X6f7ih4Sf
dU0XE9JU3kloN2y6lRg2U/wP4dCBlsLgBr24i9A6+PzfFbkB4h77/R14cGO7
NVD8gnA8zeN7g1G5n9Bb0hDknarmvyZ8tvq/kj9fqf6w/T5H12VOzFf5KCG8
L6yvdJXan8b2/+E5Y5uXyp0YkTZqtsSovgujrzLfWl2l7M6YtfaXvfWaQTyF
UVG8s/Pu1VnijxgFqX+kZZ8IFnszdlS63R76UZ3Xl3E+3fKlP6m+H8Mvtsjs
Hz9bHMB42DYtJWNI9YMY8e7f1P41pPIQxgcHF7SQeY44lGFYmrByeKXyp4z7
I4F1OQfV/EiGx+vqGab+EHE0I2BxU55WP08MRrdr18AhnzBxHMNYm4Prb1We
xHB72WbUTQ4XJzPaN+R1J1yOEq9gNEcX3t5VEylOtZ/fx/vq2Lefi9cw6uO6
TEWhyhmM1en64c2J0eJMRg91B20oV/0sRqmWOOl83nxxLiO28YLX/UcR4nzG
yQ6nrctz1fotjNC60ZPJEWp+ESM7OOPZJ7pF4hJG67J5LY3OC8QmxuWE6HOj
LjHicoZvjfm044vFYjNDN7viyJLDEFsYlhzXyWNHY/EOGjhF9Q==
              "]]}, 
            Annotation[#, {{Legended}, Charting`Private`Tag$155716, {1}}]& ], 
           TagBox[{
             Hue[0.9060679774997897, 0.6, 0.6], 
             Directive[
              PointSize[
               NCache[
                Rational[1, 72], 0.013888888888888888`]], 
              RGBColor[1, 0.5, 0], 
              AbsoluteThickness[2]], 
             LineBox[CompressedData["
1:eJwt0HtME3YQB/AOVp2KCtRZlaoIRUAFRVB8FP2KMGTxMYhmI8z4GFRiWO3U
RKI14gMlaBCj+Iq707g5DEgYUjOVKEFGcBBFVh8g+AiMqJWhBgg+IFbvd8nl
8sl975+bsHZDYqqbRqOJdfWn+bkyCO//O+lR3umGz7YR9PcbhscXacWZhKMP
E0q2+invIfwS1M00dYA4m3Cpt7vVvVb5AGGDdt3/cbZB4jxCyPUw57rng8VH
CHbrzmyL1kN8nJDo0F3peDtEfIpg2XarNNcxTHyaEFBhqY9e4Sn+jZBenZN/
54RyAWF7sm++KdBLXETwa+2O/zXQW1xCuF5qdjq+GCEuI2hXzGiLSvha/Bfh
hcO+bI1lpLickLK25nZmmnIFYeiusZ7lJXpxFSEctef7Do0W1xDc9w7Msgb7
iOsIF9ySHlsmGcT1hIXX3BL01WPFDkLT4VV5t3f7ih8QLj9/OtzjvXIzIU5v
fXx3qvITQnCB++oA5wRxm+v//+YuaGnzEz8jRP7eaN9X4y9+ScjNN1qX5hnF
rwg7OhODOhqUuwhZlfU39c3KvYSO9fFznS3q/oPrn6MfPkrqUdYwWrIWFjat
DBB/ydht8lm6Jkf5K8Y9/81LSr0nij0YP9U1v7MPDRR7Mvz676TY3gSJRzBe
X622LtdNEo9iVOg3xhjSlA2MnB1/3/D0UvZlhJRFTGxvDRYbGbmlunrNLeUg
Ruq3ZyLSK1V+CqMzOVh7tHGyeBrjZUF0MSqmiCMY135e1TO/NkQ8izGu2Pd7
Q5+yiWGN/kM3oClUDNd9WPu8mPRp4hhX/tCY/eNilRcxIhv032QkKS9mnHxW
6Gw0hIm/Y/j0tUT6508XL2d8cFzu6asMF//A2OIV0WWInSH+kdGYGlr1oGqm
eDUj/KDzdVdKpDiF8a7I2D/LrPJpjNkXC/+0X1T7dEa57YDRHjJbbGXUmc75
RHUrb2YsSu5/1ds+R5zBKCgyd1wabxLbGINuFG86p4sSZzLOHvPWlSUo72Gs
/CfanHh3njibkRcXal48BvgICwFPnQ==
              "]]}, 
            Annotation[#, {{Legended}, Charting`Private`Tag$155716, {
              2}}]& ]}, {
           
           TagBox[{}, 
            Annotation[#, {{Legended}, Charting`Private`Tag$155716, {1}}]& ], 
           
           TagBox[{}, 
            Annotation[#, {{Legended}, Charting`Private`Tag$155716, {
              2}}]& ]}, {
           
           TagBox[{}, 
            Annotation[#, {{Legended}, Charting`Private`Tag$155716, {1}}]& ], 
           
           TagBox[{}, 
            Annotation[#, {{Legended}, Charting`Private`Tag$155716, {
              2}}]& ], {}, {}, {}}, {
           
           TagBox[{}, 
            Annotation[#, {{Legended}, Charting`Private`Tag$155716, {1}}]& ], 
           
           TagBox[{}, 
            Annotation[#, {{Legended}, Charting`Private`Tag$155716, {
              2}}]& ], {}, {}, {}}}, {{}, {}}}, {
        DisplayFunction -> Identity, DisplayFunction -> Identity, AspectRatio -> 
         NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
         AxesLabel -> {
           FormBox["\"year\"", TraditionalForm], 
           FormBox["\"tril. $\"", TraditionalForm]}, AxesOrigin -> {1950., 0},
          DisplayFunction :> Identity, 
         Frame -> {{False, False}, {False, False}}, 
         FrameLabel -> {{None, None}, {None, None}}, 
         FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
         GridLines -> {{10, 20, 30, 40}, {10, 20, 30, 40}}, GridLinesStyle -> 
         Directive[
           GrayLevel[0.5, 0.4]], ImageSize -> 600, LabelStyle -> 
         Directive[FontFamily -> "Helvetica", FontSize -> 18, 
           GrayLevel[0]], 
         Method -> {
          "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
           "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), "CopiedValueFunction" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& )}}, PlotLabel -> 
         FormBox["\"d) investment (PPP, national prices)\"", TraditionalForm],
          PlotRange -> {{1950, 2018}, {0, 40}}, PlotRangeClipping -> True, 
         PlotRangePadding -> {{0, 0}, {0, 0}}, 
         Ticks -> {Automatic, Automatic}}], 
       FormBox[
        FormBox[
         TemplateBox[{
          "\"cap-output-ratio based\"", "\"investment time-series based\""}, 
          "LineLegend", DisplayFunction -> (FormBox[
            StyleBox[
             StyleBox[
              PaneBox[
               TagBox[
                GridBox[{{
                   TagBox[
                    GridBox[{{
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0, 0, 1], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0, 0, 1], 
                    AbsoluteThickness[2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #, 
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[1, 0.5, 0], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[1, 0.5, 0], 
                    AbsoluteThickness[2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                    AutoDelete -> False, 
                    GridBoxDividers -> {
                    "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                    GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                    GridBoxSpacings -> {"Columns" -> {{0.8, 0.5}}}], 
                    "Grid"]}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                 False, GridBoxDividers -> {
                  "Columns" -> {{None}}, "Rows" -> {{None}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{1}}}], 
                "Grid"], Alignment -> Left, AppearanceElements -> None, 
               ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
               "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
              Directive[FontFamily -> "Helvetica", FontSize -> 18, 
               GrayLevel[0]], FontFamily -> "Arial"}, Background -> Automatic,
              StripOnInput -> False], TraditionalForm]& ), 
          InterpretationFunction :> (RowBox[{"LineLegend", "[", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "72"], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 0, 1], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "72"], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0.5, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[0.6666666666666666, 0.33333333333333337`, 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0.5`", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0.5, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0.5, 0], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}]}], 
                    "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "72"], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 0, 1], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "72"], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0.5, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[0.6666666666666666, 0.33333333333333337`, 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0.5`", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0.5, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0.5, 0], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}]}], 
                    "}"}]}], "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{#, ",", #2}], "}"}], ",", 
                   RowBox[{"{", "}"}]}], "}"}], ",", 
               RowBox[{"LegendMarkers", "\[Rule]", 
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"None", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"None", ",", "Automatic"}], "}"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], 
                   "}"}]}], ",", 
               RowBox[{"Joined", "\[Rule]", 
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"True", ",", "True"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"True", ",", "True"}], "}"}]}], "}"}]}], ",", 
               RowBox[{"LabelStyle", "\[Rule]", 
                 RowBox[{"Directive", "[", 
                   RowBox[{
                    RowBox[{"FontFamily", "\[Rule]", "\"Helvetica\""}], ",", 
                    RowBox[{"FontSize", "\[Rule]", "18"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False]}], 
                   "]"}]}], ",", 
               RowBox[{"LegendLayout", "\[Rule]", "\"Row\""}]}], "]"}]& ), 
          Editable -> True], TraditionalForm], TraditionalForm]},
      "Legended",
      DisplayFunction->(GridBox[{{
          TagBox[
           ItemBox[
            PaneBox[
             TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline},
              BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
           "SkipImageSizeLevel"]}, {
          ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
        GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
        AutoDelete -> False, GridBoxItemSize -> Automatic, 
        BaselinePosition -> {1, 1}]& ),
      Editable->True,
      InterpretationFunction->(RowBox[{"Legended", "[", 
         RowBox[{#, ",", 
           RowBox[{"Placed", "[", 
             RowBox[{#2, ",", "Below"}], "]"}]}], "]"}]& )]}
   },
   AutoDelete->False,
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellChangeTimes->{3.8725871086668396`*^9, 3.8730111672670894`*^9, 
  3.873011254350527*^9, 3.8744807602764144`*^9},
 CellLabel->
  "Out[596]=",ExpressionUUID->"4cfa9ab9-6730-498a-967f-2ed37195ab73"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Figinvshares", "=", 
  RowBox[{"ListLinePlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Legended", "[", 
       RowBox[{
        RowBox[{"capoutresults", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;", "70"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "12"}], "}"}]}], "]"}], "]"}], ",", 
        "\"\<rgdpo_based\>\""}], "]"}], ",", 
      RowBox[{"Legended", "[", 
       RowBox[{
        RowBox[{"capoutresults", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;", "70"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "13"}], "}"}]}], "]"}], "]"}], ",", 
        "\"\<rgdpna_based\>\""}], "]"}], ",", 
      RowBox[{"Legended", "[", 
       RowBox[{
        RowBox[{"capoutresults", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;", "70"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "14"}], "}"}]}], "]"}], "]"}], ",", 
        "\"\<nominal,constant\>\""}], "]"}], ",", 
      RowBox[{"Legended", "[", 
       RowBox[{
        RowBox[{"capoutresults", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;", "70"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "15"}], "}"}]}], "]"}], "]"}], ",", 
        "\"\<capital formation\>\""}], "]"}], ",", 
      RowBox[{"Legended", "[", 
       RowBox[{
        RowBox[{"capoutresults", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;", "70"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "16"}], "}"}]}], "]"}], "]"}], ",", 
        "\"\<capital formation, price_adj\>\""}], "]"}]}], "}"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "Blue", ",", " ", "Red", ",", "Green", ",", "Black", ",", "Orange"}], 
      "}"}]}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.851464158072153*^9, 3.8514642385144205`*^9}, {
  3.8514642705832376`*^9, 3.8514643275227003`*^9}, {3.8514655566829433`*^9, 
  3.8514655648271194`*^9}, {3.851504976319178*^9, 3.851505002177988*^9}, {
  3.851505065015895*^9, 3.851505226218047*^9}, {3.8515052737298775`*^9, 
  3.8515052754874735`*^9}, {3.85208659747587*^9, 3.8520866005055017`*^9}},
 CellLabel->
  "In[597]:=",ExpressionUUID->"f24b81c9-71e0-4e79-8413-fc8ae52cb689"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{}, {{{}, {}, 
       TagBox[{
         Hue[0.67, 0.6, 0.6], 
         Directive[
          PointSize[
           NCache[
            Rational[1, 90], 0.011111111111111112`]], 
          AbsoluteThickness[1.6], 
          RGBColor[0, 0, 1]], 
         LineBox[CompressedData["
1:eJwt0ntIk1EUAPBpKzTFB1iaD3yz/igUMzWy7SRWEx9FOVTUSsWIEIfYH1kK
UaFiomaGYXWuyXCWIaJWWjq3ZTlzPnJjS9Io1BKz8JkGJi3v+eDy8eN895x7
zv18M+Wns60FAkGYZf1/bz1XEJ4ohozFLYOSLRciFJcqutJT+rivIzzPOJey
uqHmvoWgmawoerxTw12K4DsozRAvv+UuR1gpKJYlNw1wVyEE1yn/dm3v565B
cDDlKmWiXu77CDE62ZK2Vsv90FK/Q2idVfmOux7BMN3glplD+RUIbM19UzpD
bkKoO2nXuTBO+Z8h7DBccDLNUP1WhLLjJYshaxTvQOiNCymJyNdxdyJcDM9O
tQ+n77sR/BddVW2vyWoEUd5lD9+zw9x9CAcTd9+zqSDrLPWWouY0gaPceoTN
KoN+vYU8irC/O/6pvHKM24hQNC73M9UYuD8iqA6pTGbxB+4JhK81YQl3xSPc
XxAknreH97yg+LRlvo5lzsf6af8swtSRbT1xR43c8wiOtX9iopDiCwgDiuyB
uTfU7wpCqzbn6oHUIe51y3k3GmyzPtG8NxBuaBOCRr695xYwuCmccg1V0P8g
ZDC87CIPFNF+GwZpQc1m0zWahz2D9so8qVhI/TsxuPM5KfzHlJ7bhUFie7XG
y0T9uDHIUBc675JRfU8GyZmria8OU9yHwZyDLDrnEuULYGCcb/OeTaL4Xga/
/bvGGn2o330MJk6NOD0oIAcz8DgjqVI2Uz+hDFQBdvlL36mfCAZ1+l/nY13o
/JEMTvT4pVc/ovsCBu6TtlYvRVQ/moGPeTYy14vuR8og4mcR1nsbJM5pVurq
WAbljcttVjqz5B/WfynO
          "]], 
         LineBox[{{2004.847411458377, 0.371582436330393}, {2005., 
          0.3580508240834968}, {2006., 0.36665076998439916`}, {
          2006.144345047909, 0.371582436330393}}], 
         LineBox[{{2007.1765877278, 0.371582436330393}, {2008., 
          0.23526629542708435`}, {2009., 0.34227373156997715`}, {2010., 
          0.35503907979151594`}, {2011., 0.28281640551585524`}, {2012., 
          0.19911493167080674`}, {2013., 0.22474563036978837`}, {2014., 
          0.15903133536556638`}, {2015., 0.23445573966831004`}, {2016., 
          0.34483686315072687`}, {2017., 0.28939935991347315`}, {2018., 
          0.293602139413008}}]}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$156246, {1}}]& ], 
       TagBox[{
         Hue[0.9060679774997897, 0.6, 0.6], 
         Directive[
          PointSize[
           NCache[
            Rational[1, 90], 0.011111111111111112`]], 
          AbsoluteThickness[1.6], 
          RGBColor[1, 0, 0]], 
         LineBox[CompressedData["
1:eJwtkgtMjXEYxpM2lksYym0uaR25hNmRafOUU7IVR9rRSu0UyqXcL0mUNCtD
qXYml/c193SZXJbcukhKkepIoxTDSIYOxsbm1P/9tm/ffnve//O8//f9JkZu
Clxja2Nj42N9e769TxxhvWmeqbjxyYJeTiC8WrtjybSEKsVJBP2T02MOzKpQ
nEJ44eL22lBUrjiV8PvphLcuMVJ/mPCm2ZJ/sOux4gyCLunQqo1bqxVnE+L9
sgxzveX8cYLPiLbyhSEPFJ8iZAf7LvIskPozhJc3p7eZOsT/POGo+/XW9Hbh
y4SVDt77P0ytUZxPyBxx31LSKPlXCanJXuSTL343CNqr80pLL0j9LYLm0dvc
RT+F7xKulMWUXadaxWWENqc97SG6esWVBAf3M7XnfoleTZiRa5uYws8U11nP
u7kkv9M0KH5GeM79uCG6UbGZ0Lk4JMw+p0lxC+FwH4+Ge//kfKt1XiGehU22
wh2EDZG6vF068XtHiHVbWrtlhpz/SCi6c81SHmFW3GXNDy4IbDaK/o3wrY/h
RmeJ9PuD4Bi24Xv6JvH7TQgf3GLSuYr+1+pXr9EHJcr/YMMI7fY3766Q+dkx
Rsd253WOfqq4P8Nh8afc/clSP5Axu9/L7IJHMq8hjI749rPrquoUD2cEaOtL
vtpLvhPDHJZDOCH7H8t4kZniGmAnfhMY1XHmiOE5kjeZcT42fPOlQTIfDeNf
3b6oIkfRpzGWp3lFu74XnsmYNPexu3+6+M3p6dfIXRlyHw9GVPGRzyvSRPdk
VNnHH4uOkP7AeB1aY6FhwjrGHy8O9c2SfD9Gbn3hSU2z7NefURiw83Lg7GbF
ekZjjfGL8yzZTxCjeH5Ci75SOJjR+j18akG67Gul9T4/p1w0TRbdyMhytGgN
AyR/NWPA8XFVe91kX2sZ3e8zdiUVy7xjGHZBhofxfsKbGbvHb/syLkr63c7o
a1z2OVEr/cYxjmo9ht6+KPUJjHMn1nwsvSR5SYy8UkOhpUn6S2F4I2qUvk70
VIbjm5HOzvuaFvwH0O54yQ==
          "]]}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$156246, {2}}]& ], 
       TagBox[{
         Hue[0.1421359549995791, 0.6, 0.6], 
         Directive[
          PointSize[
           NCache[
            Rational[1, 90], 0.011111111111111112`]], 
          AbsoluteThickness[1.6], 
          RGBColor[0, 1, 0]], 
         LineBox[CompressedData["
1:eJwt0ntMzWEYB/BT2nRiS8iacqmcDimF4059bY6ZbMXKSuk2uda6slBEl+VS
OpZR8j6ROTERRVFbnZzUqdNF0mhmrFY0wyzjD5nD+/y2s98+e37v+3zf5z2u
sYk74qwVCoXW8vv3/v+kC1xtaB6+H9Pj/98ZAl2rddp3c9qkswS0vuOVhpEW
6RyBGH2Iw+Fsg3S+gNpxbXfYOH9/XqDPa3ZwkmundJHAEmOnp3Jnu3SxQLI5
7NDoUJP0FYEVtjWLbrm1SpcJNKpKXCa18/flljwn7Pt+5PD+NwXqVqqHNX5c
rxSIct4w6n3OJH1XINU1/El4DfevFrjxxpS2vIXrtQI7DIEVYwMd0vUWfz8Z
tFHJbhSIeL5w8aVYs3SzQPFIyt46D56PUWDd3Az8sud6u+V863SV1pG90maB
EWWj5mTAC+leAQc32moo6JPuF7BzmhFujGe/FpiV27p/qorXvxUoq40bnF7D
/d4LvDRtnLjvwPsNCxTEPHL3OP5S+qOlX1s81NH90p8FIo9YFeUl8/7fBH5e
7NeX7OZ5jAuM90zKLBvifr8Evg2W2tzO5fpvgeVe/uLcrm5pBaEpoMBRv5Tn
Z0MY7Xrw531xl7QtoSD0S3PIFPZUgt7b42FGKeefRiiO6ni8PYXnNZNgl6Dp
dQ7j/k6Elg9n12yvMEq7EDQeymPX/Xj9fEKKMrDjlCd7AeFWYWz1J1uex0KC
q2ql27AN5/UiJDehQTPAeXwJp2JqgxqS2BrCM+sD+k1v+DyrCfu09U8HUrm+
nrB1ovrMvh+cD4R7WXlxlUfZmwhFTu6Ze+Zxni2E01DMXJXLebYRQgN1NsvG
+D6CCDdxfFr6ZL6vYEKdOioxM44dSig3+RypsuL7iiD4LJ6Y5XKdHW3pX3hB
m/2Wz7eH0GO+E6bT8f9/P6E91eTdvILzxxPKtLklidXsJILRTz1v7Wten0Yw
KHX9+oOcN51wufzVBt8ErmcQEu2vfbl6hs+bZam/6DSrhjhPDmFKdrA26CvX
8wnp7zbr1lf1+f8Fp9prRA==
          "]]}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$156246, {3}}]& ], 
       TagBox[{
         Hue[0.37820393249936934`, 0.6, 0.6], 
         Directive[
          PointSize[
           NCache[
            Rational[1, 90], 0.011111111111111112`]], 
          AbsoluteThickness[1.6], 
          GrayLevel[0]], 
         LineBox[CompressedData["
1:eJw10gsslWEYB/CT2zKMjONSm2yIpjiyUmOeDoc0w8jBFBbmGidLk1wbYcyl
EMr7WJymFmMuS7kc67gUoiUiK8SSWSwSW6mT8/i2b99++7/P87zv3s/4crx3
uAKHwxHI3v/f3SeJQbnKvF/AkSHHXacw6Ozt6XWpHpE7g4GTZeFgXhvlWQzC
viC/dY6cy8CwPNa85eyw3AUM2kWF15unqL6YwVHFK/FjqW/kLmXgkmq0MjxI
rmCgperBk3qQH8jmLwoEHZwxuWsYLM29dBzSJdcxsH5cw1U5OSp3PYM+K4lf
SRTVP2Uwzx270btKbpLtVyySnjej+lYG9clc47hI8jMGZo2PhjGT3MkgYM0o
OHqI+ksYiHO0uTvqlEsZZK+H+/gnkAcZVFS9aC5dJQ8zMFhdqhyXkMcYXG0P
bcusII8zqMs2MWh3eyv3BwY6Yh9RbwJ5hkH1TJxGZR6tn2WgdypQM+c45QsM
0uuHYiaSyUsMNtJCJIZS8goDTZ6+UXUbeY1Bd8+tS2si8obsPpJGKv7wyFsM
xm9/G20IoHm/GfT0//pc/oTOz0Gw+ZnHn3KgXAmhtqQookhA3o9gdXr2vtsB
sjqCSR7PZtaCrIVQbqvrsNlE1kHwHDAtK+ki6yM4qSVqhz0kH0IYXx+N3/El
H0YIvKuh0yUkmyBsDGzFcfbmmSMo8lVcY0zJlgjxfM2OT8fI1giODcVSu731
tgiTowuqfSpkO4SP25uuOuZ0XnuE9I6oMo8Z+n8AoaVKqmDuTrkzgledpn3P
NuXnEKZdlguEVWR3BIfJE90aJbTeC8Elrcm1IJ/mXUCYKGx4zukk+yOEGjmv
SdXoPi4iCJfFbjEp5BCEqfyD77i15DBZv9f+01atVB+JEBXknxp0k/JYhOhX
wYLkYrII4b3votjzDvkaQrCClce+IHKS7PwWX3+sJ5FTZPeX2Nl4xoGcgaC8
kChOVyZnIfTfi2B/heRcBL1i7+9Ksn7/AA5OdAM=
          "]]}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$156246, {4}}]& ], 
       TagBox[{
         Hue[0.6142719099991583, 0.6, 0.6], 
         Directive[
          PointSize[
           NCache[
            Rational[1, 90], 0.011111111111111112`]], 
          AbsoluteThickness[1.6], 
          RGBColor[1, 0.5, 0]], 
         LineBox[CompressedData["
1:eJw10ntMzWEYB/CjoiiUhdAf5RhyZywq+cY5RyqOcpkaK8ZcynJbDHNSSekg
zaUtPY9U5LKQbMlxcomMyjljVlFLSsLE1iwOcjhPv+233z57v8/zPr93r/e6
+IgNdgqFQm19/33/P3sIQ71bjjeefDbvv/cTLu/qrOporbE5kWAMmlieN7za
5hSCRttys32COI3wsSLCf/BcsZ4QWRYb5vlN6jMJ++6qNuoTam0+SShzevuq
I1ecTRj3VfGFXkj+LOFgmVPKtcPPbT5HOF2b0aZ/Ly4gnHK9eiN6i7iIMEhX
19dsL75KODFnTv+qEPF1wq2LCbMKFplsLiXY24e4BerFZYSm+Mal7wrEBsL0
V6pWdxfxPev8hrFZRm9xJSFhzcP8izrxE4JycnDJ2nZxNeFwafT865ViE4HM
Oa/jG8UvCRmpq3su5JltriPoYiOnel4SvyFkdU24lZQr+WaCXVXOpu5Dst5q
PT8Hg5/6gfgDwZSeV3ilSfyZsHu8W2hog/grwTFgS5tjsbiLEDjAxbVPjLib
kHu62PlOnOz3i6AuvdPlMFisYMTfD/GesUPswFiWOqLfZnuxEyPaeOKooUTO
24XR8ylK86he7MoY9bG6vjZZ8u4Mf2W7nbJY7MEYFp6ZvWKt2JPR9uRnlqa3
vxfDLamPOjxS+o1htAb+3qi6LfdnPCO2kNOT7WR9EqOcoywZKvE0hu5n6Krl
I8QzGQ+2dpScdxbPZhRO1Tsm50i/AEaUT5Elb7sYDKNFqVtmEaus8zs/1XZ3
y30NZixZsJVWzheHMXxrfjVXZoiXMhav8+isSJL65Qx1jK7B30n2X8V4GhwQ
N/KxeLU1H61V1vvK/8cw/PaF/pmkEa9nNO300Lp0Sv9NjCGaNJ+aFKmPY1ww
N2grRkt+G+O75XXQswDxLsZeX7+o/BDxHgadMSwM3y3ezzj2o/qA/og4kZFQ
mz/wR+88KYwIi3KKKV2cZp3HbPTS15nm/QVd6HWP
          "]]}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$156246, {5}}]& ]}, {
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$156246, {1}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$156246, {2}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$156246, {3}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$156246, {4}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$156246, {5}}]& ]}, {
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$156246, {1}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$156246, {2}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$156246, {3}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$156246, {4}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$156246, {
          5}}]& ], {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}}, {
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$156246, {1}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$156246, {2}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$156246, {3}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$156246, {4}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$156246, {
          5}}]& ], {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}}}, {{}, {}}}, {
    DisplayFunction -> Identity, DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {1948.5833333333335`, 0}, 
     DisplayFunction :> Identity, Frame -> {{False, False}, {False, False}}, 
     FrameLabel -> {{None, None}, {None, None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> 600, 
     Method -> {
      "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
       "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{1948.5833333333335`, 2018.}, {0, 0.371582436330393}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.05]}}, Ticks -> {Automatic, Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{
      "\"rgdpo_based\"", "\"rgdpna_based\"", "\"nominal,constant\"", 
       "\"capital formation\"", "\"capital formation, price_adj\"", "None", 
       "None", "None", "None", "None"}, "LineLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 1, 0]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 1, 0]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #4}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0.5, 0]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0.5, 0]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #5}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 0, 1], Editable -> False, Selectable -> 
                    False]}], "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0, 0], Editable -> False, Selectable -> 
                    False]}], "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0.6666666666666666, 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "1", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 1, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 1, 0], Editable -> False, Selectable -> 
                    False]}], "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0.5, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[0.6666666666666666, 0.33333333333333337`, 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0.5`", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0.5, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0.5, 0], Editable -> False, Selectable -> 
                    False]}], "]"}]}], "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 0, 1], Editable -> False, Selectable -> 
                    False]}], "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0, 0], Editable -> False, Selectable -> 
                    False]}], "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0.6666666666666666, 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "1", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 1, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 1, 0], Editable -> False, Selectable -> 
                    False]}], "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False]}], 
                    "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0.5, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[0.6666666666666666, 0.33333333333333337`, 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0.5`", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0.5, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0.5, 0], Editable -> False, Selectable -> 
                    False]}], "]"}]}], "}"}]}], "}"}], ",", 
           RowBox[{"{", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{#, ",", #2, ",", #3, ",", #4, ",", #5}], "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{#6, ",", #7, ",", #8, ",", #9, ",", #10}], "}"}]}], 
             "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"None", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"None", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"None", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"None", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"None", ",", "Automatic"}], "}"}]}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], 
               "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   
                   RowBox[{
                    "True", ",", "True", ",", "True", ",", "True", ",", 
                    "True"}], "}"}], ",", 
                 RowBox[{"{", 
                   
                   RowBox[{
                    "True", ",", "True", ",", "True", ",", "True", ",", 
                    "True"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.8514641998833942`*^9, {3.8514642389537454`*^9, 3.851464328502756*^9}, 
   3.8514655658260984`*^9, 3.8514656303056397`*^9, 3.8514950892388797`*^9, {
   3.8515049780320787`*^9, 3.8515050027455645`*^9}, {3.851505081229794*^9, 
   3.8515050995742817`*^9}, 3.8515052763758435`*^9, 3.852086601697781*^9, 
   3.872522295561494*^9, 3.8725722938819933`*^9, 3.872651671034768*^9, 
   3.8728248082327137`*^9, 3.873011173064255*^9, 3.8744807646105103`*^9},
 CellLabel->
  "Out[597]=",ExpressionUUID->"c6387065-688a-4364-884d-86d4acf2af4c"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"countryinv", "=", "outfull"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"countryinv", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "j"}], "]"}], "]"}], "=", 
       RowBox[{
        RowBox[{"outfull", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "j"}], "]"}], "]"}], "*", 
        RowBox[{"invshare2", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "j"}], "]"}], "]"}]}]}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "2", ",", "181"}], "}"}]}], "]"}], ";"}]}], "Input",
 CellLabel->
  "In[598]:=",ExpressionUUID->"4377d213-5afa-47ea-b7e5-25e3fa8e0c80"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Export", "[", 
  RowBox[{"\"\<countryinvestment.csv\>\"", ",", "countryinv"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{"\"\<countryoutput.csv\>\"", ",", "outfull"}], "]"}]}], "Input",
 CellChangeTimes->{{3.872861081468837*^9, 3.872861106947728*^9}, {
  3.8731669665155306`*^9, 
  3.8731669669051185`*^9}},ExpressionUUID->"bbc106ae-6fb9-4ab1-b2ad-\
39b9054907c7"],

Cell[BoxData["\<\"countryinvestment.csv\"\>"], "Output",
 CellChangeTimes->{3.8728611092179728`*^9},
 CellLabel->
  "Out[754]=",ExpressionUUID->"d096d6b9-b314-41a3-a196-5b10bd6092b3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.872903286609606*^9, 3.872903310004917*^9}, 
   3.8731669651779175`*^9},ExpressionUUID->"bc5ca29f-4765-4cc2-9dd4-\
c93f3363a43f"],

Cell[BoxData["\<\"countryoutput.csv\"\>"], "Output",
 CellChangeTimes->{3.8729033123521576`*^9},
 CellLabel->
  "Out[755]=",ExpressionUUID->"e0cc8c68-ea1c-4a7c-afe9-fc941e2546c1"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"capcalc", "=", "outfull"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"capcalc", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", 
      RowBox[{"2", ";;"}]}], "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"outfull", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", 
       RowBox[{"2", ";;"}]}], "]"}], "]"}], "*", 
    RowBox[{"ncoratio", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", 
       RowBox[{"2", ";;"}]}], "]"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"doutraw", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"\"\<\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "181"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"doutraw", "[", 
     RowBox[{"[", "i", "]"}], "]"}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{"Position", "[", 
       RowBox[{
        RowBox[{"depraw", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;"}], ",", "i"}], "]"}], "]"}], ",", 
        RowBox[{"_", "?", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"#", "\[NotEqual]", "\"\<\>\""}], "&"}], ")"}]}], ",", "1",
         ",", "1"}], "]"}], "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1"}], "]"}], "]"}], "+", "1"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "181"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dlast", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "181"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"dlast", "[", 
     RowBox[{"[", "i", "]"}], "]"}], "=", 
    RowBox[{"depraw", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"doutraw", "[", 
        RowBox[{"[", "i", "]"}], "]"}], ",", "i"}], "]"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "181"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dfill", "=", "depraw"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"dfill", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;", 
        RowBox[{"doutraw", "[", 
         RowBox[{"[", "i", "]"}], "]"}]}], ",", "i"}], "]"}], "]"}], "=", 
    RowBox[{"dlast", "[", 
     RowBox[{"[", "i", "]"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "181"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"invcalc", "=", "capcalc"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"invcalc", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", 
      RowBox[{"2", ";;"}]}], "]"}], "]"}], "=", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"Do", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"invcalc", "[", 
       RowBox[{"[", 
        RowBox[{"i", ",", "j"}], "]"}], "]"}], "=", 
      RowBox[{"Max", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"capcalc", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"i", "+", "1"}], ",", "j"}], "]"}], "]"}], "-", 
         RowBox[{
          RowBox[{"capcalc", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "j"}], "]"}], "]"}], "*", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{"dfill", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", "j"}], "]"}], "]"}]}], ")"}]}]}], ",", "0"}], 
       "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "2", ",", "70"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"j", ",", "2", ",", "181"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"countryinvfill", "=", "countryinv"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dinv", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"\"\<\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "181"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"dinv", "[", 
     RowBox[{"[", "i", "]"}], "]"}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{"Position", "[", 
       RowBox[{
        RowBox[{"countryinv", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;"}], ",", "i"}], "]"}], "]"}], ",", 
        RowBox[{"_", "?", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"#", "\[NotEqual]", "0"}], "&"}], ")"}]}], ",", "1", ",", 
        "1"}], "]"}], "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1"}], "]"}], "]"}], "+", "1"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "181"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dinv", "[", 
    RowBox[{"[", 
     RowBox[{"{", 
      RowBox[{
      "9", ",", "13", ",", "23", ",", "47", ",", "57", ",", "64", ",", "89", 
       ",", "91", ",", "106", ",", "110", ",", "149", ",", " ", "162"}], 
      "}"}], "]"}], "]"}], "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"dinv", "[", 
       RowBox[{"[", "i", "]"}], "]"}], ">", "2"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"countryinvfill", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;", 
           RowBox[{"dinv", "[", 
            RowBox[{"[", "i", "]"}], "]"}]}], ",", "i"}], "]"}], "]"}], "=", 
       RowBox[{"invcalc", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;", 
           RowBox[{"dinv", "[", 
            RowBox[{"[", "i", "]"}], "]"}]}], ",", "i"}], "]"}], "]"}]}], 
      "}"}], ",", "0"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "181"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"countryinvfill", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "25"}], "]"}], "]"}], "=", "0"}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.873166983822847*^9, 3.8731670100449524`*^9}, {
  3.873169429658327*^9, 3.8731694308231297`*^9}, {3.873169538251037*^9, 
  3.8731695388640013`*^9}},
 CellLabel->
  "In[600]:=",ExpressionUUID->"cd848c51-13ce-452c-8833-d43f48f179c0"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Export", "[", 
  RowBox[{"\"\<invcalc.csv\>\"", ",", "invcalc"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{"\"\<countryinvfill.csv\>\"", ",", "countryinvfill"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.8731670162545176`*^9, 3.8731670500873604`*^9}},
 CellLabel->
  "In[753]:=",ExpressionUUID->"32486c5c-5dbb-4932-9103-16abdb06a0c8"],

Cell[BoxData["\<\"invcalc.csv\"\>"], "Output",
 CellChangeTimes->{{3.8731670509939938`*^9, 3.873167071267479*^9}, 
   3.8731672027652626`*^9},
 CellLabel->
  "Out[753]=",ExpressionUUID->"33140467-18c5-4ee0-b00c-e985eca642b0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<capcalc.csv\>\"", ",", "capcalc"}], "]"}]], "Input",
 CellChangeTimes->{{3.874480847306904*^9, 3.8744808617518024`*^9}},
 CellLabel->
  "In[618]:=",ExpressionUUID->"2e6c8006-53f6-456c-b62d-24c51707f214"],

Cell[BoxData["\<\"capcalc.csv\"\>"], "Output",
 CellChangeTimes->{{3.8731670509939938`*^9, 3.873167071267479*^9}, 
   3.8731672028420906`*^9, 3.8744808625110073`*^9},
 CellLabel->
  "Out[618]=",ExpressionUUID->"c3b68d61-11ef-4ef7-be53-6eba5b17d569"]
}, Open  ]],

Cell["\<\
Calculation of capital elasticity of output based on labor share \
\>", "Text",
 CellChangeTimes->{{3.8728248190164056`*^9, 3.872824852516651*^9}},
 FontSize->36,
 Background->RGBColor[
  0.87, 0.94, 1],ExpressionUUID->"3e23c470-78e5-445b-9d66-35817939ac42"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"lshareraw", "=", 
   RowBox[{"Import", "[", "\"\<labor_share_PWT_Transposed.csv\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Dimensions", "[", "lshareraw", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lshare", "=", 
   RowBox[{"lshareraw", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", ";;"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Dimensions", "[", "lshare", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Dimensions", "[", "outputPPPraw", 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.8396731776047497`*^9, 3.8396732638622293`*^9}, {
   3.839674059878787*^9, 3.8396740844186745`*^9}, {3.8396741518233557`*^9, 
   3.8396741713307943`*^9}, {3.84346370550237*^9, 3.8434637932520957`*^9}, {
   3.848251000574577*^9, 3.848251012855946*^9}, {3.8482518332565813`*^9, 
   3.848251833822481*^9}, {3.8482521986984544`*^9, 3.8482522021917844`*^9}, {
   3.8482523348118367`*^9, 3.848252341627327*^9}, {3.848252385510352*^9, 
   3.8482524447079554`*^9}, {3.8482525756715155`*^9, 
   3.8482525847725134`*^9}, {3.849527715846615*^9, 3.849527759458805*^9}, 
   3.8495277918865185`*^9},
 CellLabel->
  "In[525]:=",ExpressionUUID->"7f9b6098-a1a4-43a4-9a37-0b5e9a79fa6c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"71", ",", "181"}], "}"}]], "Output",
 CellChangeTimes->{3.849527747940892*^9, 3.8495277946664352`*^9, 
  3.851681194810303*^9, 3.8726519214725018`*^9},
 CellLabel->
  "Out[528]=",ExpressionUUID->"747902ee-7234-4cba-9570-d4db18442f49"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"71", ",", "184"}], "}"}]], "Output",
 CellChangeTimes->{3.849527747940892*^9, 3.8495277946664352`*^9, 
  3.851681194810303*^9, 3.872651921478484*^9},
 CellLabel->
  "Out[529]=",ExpressionUUID->"e3ed30fd-596c-4f26-ac46-04b3ae205c7d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"lnraw", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"\"\<\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "181"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "3"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"lnraw", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "1"}], "]"}], "]"}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{"Position", "[", 
       RowBox[{
        RowBox[{"lshare", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;"}], ",", "i"}], "]"}], "]"}], ",", 
        RowBox[{"_", "?", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"#", "\[NotEqual]", "\"\<\>\""}], "&"}], ")"}]}], ",", "1",
         ",", "1"}], "]"}], "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1"}], "]"}], "]"}], "+", "1"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "181"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"lnraw", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "2"}], "]"}], "]"}], "=", 
    RowBox[{"lshare", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"lnraw", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", "i"}], "]"}], "]"}]}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "181"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lfull", "=", "lshare"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"Do", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"lfull", "[", 
       RowBox[{"[", 
        RowBox[{"i", ",", "j"}], "]"}], "]"}], "=", 
      RowBox[{"lnraw", "[", 
       RowBox[{"[", 
        RowBox[{"j", ",", "2"}], "]"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "2", ",", 
       RowBox[{"lnraw", "[", 
        RowBox[{"[", 
         RowBox[{"j", ",", "1"}], "]"}], "]"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"j", ",", "2", ",", "181"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lfull2", "=", "lshare"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"Do", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"lfull2", "[", 
       RowBox[{"[", 
        RowBox[{"i", ",", "j"}], "]"}], "]"}], "=", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"lshare", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "j"}], "]"}], "]"}], "\[Equal]", "\"\<\>\""}], 
        ",", "0", ",", 
        RowBox[{"lshare", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "j"}], "]"}], "]"}]}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"j", ",", "2", ",", "181"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"lsnoutPPPfull", "=", "noutPPPfull"}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Do", "[", 
    RowBox[{
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"outPPPcalc2", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "j"}], "]"}], "]"}], "=", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"lshare", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "j"}], "]"}], "]"}], "\[Equal]", "\"\<\>\""}], 
          ",", "0", ",", 
          RowBox[{"outPPPcalc2", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "j"}], "]"}], "]"}]}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "2", ",", "181"}], "}"}]}], "]"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"lnraw", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "2"}], "]"}], "]"}], "=", 
         RowBox[{"lshare", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"dnraw", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", "i"}], "]"}], 
          "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "2", ",", "181"}], "}"}]}], "]"}], 
      "\[IndentingNewLine]", "lfull"}], "=", "lshare"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{"Do", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"lfull", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "j"}], "]"}], "]"}], "=", 
          RowBox[{"lnraw", "[", 
           RowBox[{"[", 
            RowBox[{"j", ",", "2"}], "]"}], "]"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "2", ",", 
           RowBox[{"lnraw", "[", 
            RowBox[{"[", 
             RowBox[{"j", ",", "1"}], "]"}], "]"}]}], "}"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "2", ",", "181"}], "}"}]}], "]"}], 
     "\[IndentingNewLine]", 
     RowBox[{"lfull2", "=", "lshare"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"lfull2", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "j"}], "]"}], "]"}], "=", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"lshare", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", "j"}], "]"}], "]"}], "\[Equal]", "\"\<\>\""}],
            ",", "0", ",", 
           RowBox[{"lshare", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "j"}], "]"}], "]"}]}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "2", ",", "181"}], "}"}]}], "]"}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Do", "[", 
    RowBox[{
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"outPPPcalc2", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "j"}], "]"}], "]"}], "=", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"lshare", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "j"}], "]"}], "]"}], "\[Equal]", "\"\<\>\""}], 
          ",", "0", ",", 
          RowBox[{"outPPPcalc2", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "j"}], "]"}], "]"}]}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "2", ",", "70"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "2", ",", "181"}], "}"}]}], "]"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"lsnoutPPPfull", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "j"}], "]"}], "]"}], "=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"lfull2", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "j"}], "]"}], "]"}], "\[Equal]", "0"}], ",", 
         "0", ",", 
         RowBox[{"noutPPPfull", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "j"}], "]"}], "]"}]}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "2", ",", "181"}], "}"}]}], "]"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Do", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"outPPPcalc2", "[", 
       RowBox[{"[", 
        RowBox[{"71", ",", "j"}], "]"}], "]"}], "=", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"lshare", "[", 
          RowBox[{"[", 
           RowBox[{"71", ",", "j"}], "]"}], "]"}], "\[Equal]", "0"}], ",", 
        "0", ",", 
        RowBox[{"outPPPcalc2", "[", 
         RowBox[{"[", 
          RowBox[{"71", ",", "j"}], "]"}], "]"}]}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "2", ",", "70"}], "}"}]}], "]"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lsweight", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "71"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "4"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"lsweight", "[", 
    RowBox[{"[", "1", "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
    "\"\<year\>\"", ",", "\"\<totalOut\>\"", ",", "\"\<weightedLS\>\"", ",", 
     "\"\<alpha\>\""}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"lsweight", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "1"}], "]"}], "]"}], "=", 
    RowBox[{"1948", "+", "i"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"lsweight", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "2"}], "]"}], "]"}], "=", 
    RowBox[{"Total", "[", 
     RowBox[{"lsnoutPPPfull", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", 
        RowBox[{"2", ";;"}]}], "]"}], "]"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"lsweight", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "3"}], "]"}], "]"}], "=", 
    RowBox[{
     RowBox[{"Total", "[", 
      RowBox[{
       RowBox[{"lsnoutPPPfull", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", 
          RowBox[{"2", ";;"}]}], "]"}], "]"}], "*", 
       RowBox[{"lfull2", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", 
          RowBox[{"2", ";;"}]}], "]"}], "]"}]}], "]"}], "/", 
     RowBox[{"lsweight", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", "2"}], "]"}], "]"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"lsweight", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "4"}], "]"}], "]"}], "=", 
   RowBox[{"1", "-", 
    RowBox[{"lsweight", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", "3"}], "]"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"kappa1", "=", 
  RowBox[{"1", "-", 
   RowBox[{"Mean", "[", 
    RowBox[{"lsweight", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"61", ";;", "71"}], ",", "3"}], "]"}], "]"}], 
    "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"kappa2", "=", 
  RowBox[{"1", "-", 
   RowBox[{"Mean", "[", 
    RowBox[{"lsweight", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"71", ";;", "71"}], ",", "3"}], "]"}], "]"}], 
    "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"kappa3", "=", 
  RowBox[{"1", "-", 
   RowBox[{"Mean", "[", 
    RowBox[{"lsweight", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", "3"}], "]"}], "]"}], "]"}]}]}]}], "Input",
 CellChangeTimes->{{3.849529053249532*^9, 3.8495291310552316`*^9}, {
  3.8495452234366813`*^9, 3.8495452621574035`*^9}},
 CellLabel->
  "In[604]:=",ExpressionUUID->"d74fe3cb-d45a-4fec-8b20-4b4cb1b13d4d"],

Cell[BoxData["0.4401327295440489`"], "Output",
 CellChangeTimes->{3.848251185417801*^9, 3.8482518355665364`*^9, 
  3.848252127611105*^9, 3.8482522042942853`*^9, 3.8482526063122387`*^9, 
  3.8495151923088093`*^9, 3.8495291415165796`*^9, 3.849545263913022*^9, 
  3.8516915818056507`*^9, 3.872651954248249*^9, 3.8727434569570303`*^9},
 CellLabel->
  "Out[619]=",ExpressionUUID->"474e42f8-7d1e-463a-95db-09586b251378"],

Cell[BoxData["0.4363889182512142`"], "Output",
 CellChangeTimes->{3.848251185417801*^9, 3.8482518355665364`*^9, 
  3.848252127611105*^9, 3.8482522042942853`*^9, 3.8482526063122387`*^9, 
  3.8495151923088093`*^9, 3.8495291415165796`*^9, 3.849545263913022*^9, 
  3.8516915818056507`*^9, 3.872651954248249*^9, 3.872743456960738*^9},
 CellLabel->
  "Out[620]=",ExpressionUUID->"17189ac6-97d8-4baf-a9ad-9a94b097eaf0"],

Cell[BoxData["0.40441558593039884`"], "Output",
 CellChangeTimes->{3.848251185417801*^9, 3.8482518355665364`*^9, 
  3.848252127611105*^9, 3.8482522042942853`*^9, 3.8482526063122387`*^9, 
  3.8495151923088093`*^9, 3.8495291415165796`*^9, 3.849545263913022*^9, 
  3.8516915818056507`*^9, 3.872651954248249*^9, 3.8727434569657745`*^9},
 CellLabel->
  "Out[621]=",ExpressionUUID->"70c20744-2155-47cd-accf-a250a72f76b9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"figls", "=", 
  RowBox[{"ListLinePlot", "[", 
   RowBox[{
    RowBox[{"lsweight", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "3"}], "}"}]}], "]"}], "]"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Red", ",", "Thick"}], "}"}]}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<year\>\"", ",", "\"\<1-\[Alpha]\>\""}], "}"}]}], ",", 
    RowBox[{
    "PlotLabel", "\[Rule]", 
     "\"\<Nomimal(!)-Output-weighted share of labour compensation from \
GDP\>\""}], ",", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{
       RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
       RowBox[{"FontSize", "\[Rule]", "14"}], ",", "Black"}], "]"}]}], ",", 
    RowBox[{"GridLines", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"0.56", ",", "0.58", ",", "0.6", ",", "0.62"}], "}"}], "}"}]}],
     ",", " ", 
    RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8482526787457433`*^9, 3.8482526976591816`*^9}, {
  3.84825275195516*^9, 3.8482528449378657`*^9}, {3.8482529558644724`*^9, 
  3.848252958861005*^9}, {3.848252989504523*^9, 3.8482530019727383`*^9}, {
  3.8495383777979555`*^9, 3.849538490116207*^9}, {3.849545293745802*^9, 
  3.849545295445305*^9}},
 CellLabel->
  "In[622]:=",ExpressionUUID->"88d658f2-20bf-4bd7-ad7f-95db159111ae"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {RGBColor[1, 0, 0], PointSize[
      NCache[
       Rational[1, 60], 0.016666666666666666`]], Thickness[Large], 
     LineBox[CompressedData["
1:eJw10AssFVAYB/BLl9EDzeNSdxWT3KIxj0nhP1JWzXpQimKmofXUS02lsqVG
0SgrO1+TRKhuSx7TWLlo0S5TtK7kKuWRrKQX1Y2vs52d/fad/87+xzZ6z/rt
+hKJZIVu/zsnVqJAVcSU36Z9PX4TThJIL+gYe/CZnSyQ356b72P3dtIpAjGH
qnyVs9ipAjfPLfxlJGGnCaBJaS97wvkMgdU1/X5WY+wsgWJnu6K4j+wcgZZA
h4GZWnauQFKDf9eSJvY1Ab3a6daBnex8gY9PVU8fvGYXChh6XnFf1cEuEVAr
ltpEtrHvCniZlhmYtLLvC1R69I56PGJXCOSd/aS50cCuFghdty/82At2rcDm
qtund/ez63T9C89e1pNy30YBb/OhnMYsnjcJnMuior6TbLVAQUrQ76gMdpuA
vn1pcEU2u0PAUzagN36MrRG4NCfAomYX+42uf/CIS0gU+63AuxuWF0pj2B8E
ikLGcwzj2YMCwZ0JC2evZw/r+qsD3BKC2CO6fteNP2TYsL8LNKtNutqd2WMC
j745Gnw1YUsIFdWlCnmvdtJSwmXLl3MHB9hGhFCcUPhL+f50Ql9vl8pqBtuM
cF2l2uYjYVsQbO5uyVvwjvPWhG2K+RWB/+dygtuWgISHZux5hI3PDnq52LHt
dfMwvdaVo5x3JKiPGDc7aNhOhC8WnRvSWtguBMv6ctmIku1OsItcUjuex/Yi
aH/WnXFqZi8jLCrLzyzQskG4FS9HZgd7OSG6cNPii8PsIEKlq/uhO3XsNQRS
Dm1tzWGvJcgOFsauC2WHEP4Eh/24Z8YOI9hHl3vJv3dPOoJwVXNpv+YZO4pg
7lJ+3rOeHUOQKh3SP0/jfBwhvHh46uFKnu8kmDS5xcnK2HsJv2KfP85WsQ/o
/j+xYVDexk4k2HbrS0ffs5MISkdvfcUPdjLhlXdPia8Rv5dCOO6aveOoITtV
915oz6lcA3YaIaY+cfYsY63fXy4hfgw=
      "]]}}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{
    FormBox["\"year\"", TraditionalForm], 
    FormBox["\"1-\[Alpha]\"", TraditionalForm]},
  AxesOrigin->{1948.5625, 0.5491434492203565},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{{0.56, 0.58, 0.6, 0.62}, {0.56, 0.58, 0.6, 0.62}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->600,
  LabelStyle->Directive[FontFamily -> "Helvetica", FontSize -> 14, 
    GrayLevel[0]],
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotLabel->FormBox[
   "\"Nomimal(!)-Output-weighted share of labour compensation from GDP\"", 
    TraditionalForm],
  PlotRange->{{1948.5625, 2019.}, {0.5491434492203565, 0.6291797843066331}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.849529161050064*^9, 3.849538431562627*^9, {3.84953846463354*^9, 
   3.8495384910743837`*^9}, 3.8495452961642056`*^9, 3.8516915910346317`*^9, 
   3.872651966848549*^9, 3.872743460661804*^9},
 CellLabel->
  "Out[622]=",ExpressionUUID->"921c9aef-e4e1-4716-ba02-63d1ee8ed423"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"Export", "[", 
   RowBox[{"\"\<Flabshare.tiff\>\"", ",", "figls"}], "]"}], "*)"}]], "Input",
 CellChangeTimes->{{3.849538341202546*^9, 3.8495383578256764`*^9}, {
  3.8495385017629786`*^9, 3.849538503706499*^9}, {3.872824904656417*^9, 
  3.872824906849149*^9}},ExpressionUUID->"f61493ad-4ca6-4a2c-96aa-\
0f2c884f9750"],

Cell["\<\
Calculation of capital elasticity of output based on real return for capital \
\>", "Text",
 CellChangeTimes->{{3.8728248190164056`*^9, 3.872824852516651*^9}, {
  3.872824950930335*^9, 3.8728249598504624`*^9}},
 FontSize->36,
 Background->RGBColor[
  0.87, 0.94, 1],ExpressionUUID->"c902f7d9-54fe-4da8-be50-c30862db8e2b"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"returnraw", "=", 
   RowBox[{
   "Import", "[", "\"\<realreturn_data_PWT_transposed.csv\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Dimensions", "[", "returnraw", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"return", "=", 
   RowBox[{"returnraw", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", ";;"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Dimensions", "[", "return", "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.839761744793041*^9, 3.8397618499823284`*^9}, 
   3.8434647895942917`*^9, 3.8495394064651966`*^9},
 CellLabel->
  "In[549]:=",ExpressionUUID->"677b7888-cbf5-4985-bbe5-8b39f19d5824"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"72", ",", "181"}], "}"}]], "Output",
 CellChangeTimes->{3.872653223221813*^9},
 CellLabel->
  "Out[550]=",ExpressionUUID->"a2d723fe-ed48-465a-8935-12d00135b2ac"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"71", ",", "181"}], "}"}]], "Output",
 CellChangeTimes->{3.8726532232262*^9},
 CellLabel->
  "Out[552]=",ExpressionUUID->"47524e35-38fa-4c91-a110-a56048aa99f6"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{
   "weighted", " ", "averages", " ", "of", " ", "capital", " ", "fraction"}], 
   ",", " ", 
   RowBox[{"i", ".", "e", ".", " ", "alpha"}], ",", " ", 
   RowBox[{"and", " ", "weighted", " ", "averages", " ", "of", " ", "r"}]}], 
  "*)"}]], "Input",
 CellChangeTimes->{{3.8520863446676493`*^9, 
  3.8520863867632513`*^9}},ExpressionUUID->"c9dc9c29-662b-44b4-9201-\
3683522665bd"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ncapPPPraw", "=", "capPPPraw"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ncapPPPraw", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", 
      RowBox[{"2", ";;"}]}], "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"capPPPraw", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", 
       RowBox[{"2", ";;"}]}], "]"}], "]"}], "*", 
    RowBox[{"pcapPPPraw", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", 
       RowBox[{"2", ";;"}]}], "]"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"Do", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"ncapPPPraw", "[", 
       RowBox[{"[", 
        RowBox[{"i", ",", "j"}], "]"}], "]"}], "=", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"return", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "j"}], "]"}], "]"}], "\[Equal]", "0"}], ",", "0",
         ",", 
        RowBox[{"ncapPPPraw", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "j"}], "]"}], "]"}]}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"j", ",", "2", ",", "181"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"capreturncalc", "=", "ncapPPPraw"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"capreturncalc", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", 
      RowBox[{"2", ";;"}]}], "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"return", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", 
       RowBox[{"2", ";;"}]}], "]"}], "]"}], "*", 
    RowBox[{"ncapPPPraw", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", 
       RowBox[{"2", ";;"}]}], "]"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"depraw2", "=", "depraw"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"Do", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"depraw2", "[", 
       RowBox[{"[", 
        RowBox[{"i", ",", "j"}], "]"}], "]"}], "=", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"depraw", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "j"}], "]"}], "]"}], "\[Equal]", "\"\<\>\""}], 
        ",", "0", ",", 
        RowBox[{"depraw", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "j"}], "]"}], "]"}]}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"j", ",", "2", ",", "181"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"return2", "=", "return"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"Do", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"return2", "[", 
       RowBox[{"[", 
        RowBox[{"i", ",", "j"}], "]"}], "]"}], "=", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"return", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "j"}], "]"}], "]"}], "\[Equal]", "\"\<\>\""}], 
        ",", "0", ",", 
        RowBox[{"return", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "j"}], "]"}], "]"}]}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"j", ",", "2", ",", "181"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"capreturncalc", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", 
      RowBox[{"2", ";;"}]}], "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"capreturncalc", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", 
       RowBox[{"2", ";;"}]}], "]"}], "]"}], "+", 
    RowBox[{
     RowBox[{"depraw2", "[", 
      RowBox[{"[", 
       RowBox[{
        RowBox[{"2", ";;"}], ",", 
        RowBox[{"2", ";;"}]}], "]"}], "]"}], "*", 
     RowBox[{"ncapPPPraw", "[", 
      RowBox[{"[", 
       RowBox[{
        RowBox[{"2", ";;"}], ",", 
        RowBox[{"2", ";;"}]}], "]"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"Do", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"capreturncalc", "[", 
       RowBox[{"[", 
        RowBox[{"i", ",", "j"}], "]"}], "]"}], "=", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"return", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "j"}], "]"}], "]"}], "\[Equal]", "0"}], ",", "0",
         ",", 
        RowBox[{"capreturncalc", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "j"}], "]"}], "]"}]}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"j", ",", "2", ",", "181"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"noutPPP", "=", 
   RowBox[{"outPPPraw2", "[", 
    RowBox[{"[", 
     RowBox[{";;", ",", 
      RowBox[{"1", ";;", "181"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"noutPPP", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", 
      RowBox[{"2", ";;"}]}], "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"outPPPraw2", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", 
       RowBox[{"2", ";;", "181"}]}], "]"}], "]"}], "*", 
    RowBox[{"poutputPPPraw", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", 
       RowBox[{"2", ";;", "181"}]}], "]"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"Do", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"noutPPP", "[", 
       RowBox[{"[", 
        RowBox[{"i", ",", "j"}], "]"}], "]"}], "=", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"return", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "j"}], "]"}], "]"}], "\[Equal]", "0"}], ",", "0",
         ",", 
        RowBox[{"noutPPP", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "j"}], "]"}], "]"}]}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"j", ",", "2", ",", "181"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"capreturncalc1", "=", "capreturncalc"}], ";"}], " ", 
  RowBox[{"(*", 
   RowBox[{
   "calculate", " ", "the", " ", "fraction", " ", "of", " ", "capital", " ", 
    "income"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"capreturncalc2", "=", "capreturncalc"}], ";"}], " ", 
  RowBox[{"(*", 
   RowBox[{"calculate", " ", "r"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"capreturncalc3", "=", "capreturncalc"}], ";"}], " ", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"calculate", " ", "r"}], ",", " ", 
    RowBox[{"different", " ", "weighting"}]}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"capreturncalc1", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "j"}], "]"}], "]"}], "=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"return", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "j"}], "]"}], "]"}], "\[Equal]", "0"}], ",", 
         "0", ",", 
         RowBox[{
          RowBox[{"capreturncalc", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "j"}], "]"}], "]"}], "/", 
          RowBox[{"noutPPP", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "j"}], "]"}], "]"}]}]}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "2", ",", "181"}], "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"capreturncalc2", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "j"}], "]"}], "]"}], "=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"return", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "j"}], "]"}], "]"}], "\[Equal]", "0"}], ",", 
         "0", ",", 
         RowBox[{
          RowBox[{"capreturncalc", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "j"}], "]"}], "]"}], "/", 
          RowBox[{"capPPPraw", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "j"}], "]"}], "]"}]}]}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "2", ",", "181"}], "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"capreturncalc3", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "j"}], "]"}], "]"}], "=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"return", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "j"}], "]"}], "]"}], "\[Equal]", "0"}], ",", 
         "0", ",", 
         RowBox[{
          RowBox[{"capreturncalc", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "j"}], "]"}], "]"}], "/", 
          RowBox[{"ncapPPPraw", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "j"}], "]"}], "]"}]}]}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "2", ",", "181"}], "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"capreturnweight", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "71"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "7"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"returnweight", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "71"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "5"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"capreturnweight", "[", 
    RowBox[{"[", "1", "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
    "\"\<year\>\"", ",", "\"\<totalout\>\"", ",", "\"\<totalcap\>\"", ",", 
     "\"\<totalncap\>\"", ",", "\"\<walpha\>\"", ",", "\"\<wr\>\"", ",", 
     "\"\<wr\>\""}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"returnweight", "[", 
    RowBox[{"[", "1", "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
    "\"\<year\>\"", ",", "\"\<totalcap\>\"", ",", "\"\<totalncap\>\"", ",", 
     "\"\<wR\>\"", ",", "\"\<wnR\>\""}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"capreturnweight", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "1"}], "]"}], "]"}], "=", 
    RowBox[{"1948", "+", "i"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"returnweight", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "1"}], "]"}], "]"}], "=", 
    RowBox[{"1948", "+", "i"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"capreturnweight", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "2"}], "]"}], "]"}], "=", 
    RowBox[{"Total", "[", 
     RowBox[{"noutPPP", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", 
        RowBox[{"2", ";;"}]}], "]"}], "]"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"capreturnweight", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "3"}], "]"}], "]"}], "=", 
    RowBox[{"Total", "[", 
     RowBox[{"capPPPraw2", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", 
        RowBox[{"2", ";;"}]}], "]"}], "]"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"capreturnweight", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "4"}], "]"}], "]"}], "=", 
    RowBox[{"Total", "[", 
     RowBox[{"ncapPPPraw", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", 
        RowBox[{"2", ";;"}]}], "]"}], "]"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"capreturnweight", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "5"}], "]"}], "]"}], "=", 
    RowBox[{
     RowBox[{"Total", "[", 
      RowBox[{
       RowBox[{"noutPPP", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", 
          RowBox[{"2", ";;"}]}], "]"}], "]"}], "*", 
       RowBox[{"capreturncalc1", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", 
          RowBox[{"2", ";;"}]}], "]"}], "]"}]}], "]"}], "/", 
     RowBox[{"capreturnweight", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", "2"}], "]"}], "]"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"capreturnweight", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "6"}], "]"}], "]"}], "=", 
    RowBox[{
     RowBox[{"Total", "[", 
      RowBox[{
       RowBox[{"capPPPraw2", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", 
          RowBox[{"2", ";;"}]}], "]"}], "]"}], "*", 
       RowBox[{"capreturncalc2", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", 
          RowBox[{"2", ";;"}]}], "]"}], "]"}]}], "]"}], "/", 
     RowBox[{"capreturnweight", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", "3"}], "]"}], "]"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"capreturnweight", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "7"}], "]"}], "]"}], "=", 
    RowBox[{
     RowBox[{"Total", "[", 
      RowBox[{
       RowBox[{"ncapPPPraw", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", 
          RowBox[{"2", ";;"}]}], "]"}], "]"}], "*", 
       RowBox[{"capreturncalc3", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", 
          RowBox[{"2", ";;"}]}], "]"}], "]"}]}], "]"}], "/", 
     RowBox[{"capreturnweight", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", "4"}], "]"}], "]"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"returnweight", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "2"}], "]"}], "]"}], "=", 
    RowBox[{"Total", "[", 
     RowBox[{"capPPPraw2", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", 
        RowBox[{"2", ";;"}]}], "]"}], "]"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"returnweight", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "3"}], "]"}], "]"}], "=", 
    RowBox[{"Total", "[", 
     RowBox[{"ncapPPPraw", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", 
        RowBox[{"2", ";;"}]}], "]"}], "]"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"returnweight", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "4"}], "]"}], "]"}], "=", 
    RowBox[{
     RowBox[{"Total", "[", 
      RowBox[{
       RowBox[{"capPPPraw2", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", 
          RowBox[{"2", ";;"}]}], "]"}], "]"}], "*", 
       RowBox[{"return2", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", 
          RowBox[{"2", ";;"}]}], "]"}], "]"}]}], "]"}], "/", 
     RowBox[{"returnweight", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", "2"}], "]"}], "]"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"returnweight", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", "5"}], "]"}], "]"}], "=", 
     RowBox[{
      RowBox[{"Total", "[", 
       RowBox[{
        RowBox[{"ncapPPPraw", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", 
           RowBox[{"2", ";;"}]}], "]"}], "]"}], "*", 
        RowBox[{"return2", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", 
           RowBox[{"2", ";;"}]}], "]"}], "]"}]}], "]"}], "/", 
      RowBox[{"returnweight", "[", 
       RowBox[{"[", 
        RowBox[{"i", ",", "3"}], "]"}], "]"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.849539926677206*^9, 3.8495400297212987`*^9}, {
   3.8495409228841906`*^9, 3.8495409455586815`*^9}, {3.8495410276589885`*^9, 
   3.8495410930244274`*^9}, 3.849541370968718*^9, {3.849541520344577*^9, 
   3.8495416272295027`*^9}, {3.84954223478922*^9, 3.849542374390813*^9}, {
   3.8495425030916185`*^9, 3.8495425977340574`*^9}, 3.8495426326147537`*^9, {
   3.849542773966338*^9, 3.8495427919919233`*^9}, {3.8495428337828746`*^9, 
   3.8495428588657036`*^9}, {3.8495437926817255`*^9, 3.849543803462923*^9}, {
   3.849544389946944*^9, 3.8495446110694685`*^9}, {3.8495446613411903`*^9, 
   3.8495446641016855`*^9}, 3.8514629219890966`*^9, 3.85169731640104*^9, {
   3.8516978717288933`*^9, 3.8516979795314703`*^9}, {3.8516980194851875`*^9, 
   3.8516980339400644`*^9}, 3.851698469929706*^9, {3.8516988354172273`*^9, 
   3.851699148399168*^9}, {3.851733101244319*^9, 3.8517333261457567`*^9}, {
   3.8517338648620253`*^9, 3.8517338694119754`*^9}, {3.8728249705795584`*^9, 
   3.8728249712071066`*^9}},ExpressionUUID->"e2588517-b1bc-4202-9e0d-\
29fd1814309e"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"figRcomparison", "=", 
   RowBox[{
    RowBox[{"ListLinePlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Legended", "[", 
         RowBox[{
          RowBox[{"returnweight", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"2", ";;"}], ",", 
             RowBox[{"{", 
              RowBox[{"1", ",", "4"}], "}"}]}], "]"}], "]"}], ",", 
          "\"\<weighted irr, w=cap\>\""}], "]"}], ",", 
        RowBox[{"Legended", "[", 
         RowBox[{
          RowBox[{"returnweight", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"2", ";;"}], ",", 
             RowBox[{"{", 
              RowBox[{"1", ",", "5"}], "}"}]}], "]"}], "]"}], ",", 
          "\"\<weighted irr, w=ncap\>\""}], "]"}], ",", 
        RowBox[{"Legended", "[", 
         RowBox[{
          RowBox[{"capreturnweight", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"2", ";;"}], ",", 
             RowBox[{"{", 
              RowBox[{"1", ",", "6"}], "}"}]}], "]"}], "]"}], ",", 
          "\"\<weighted r, w=cap \>\""}], "]"}], ",", 
        RowBox[{"Legended", "[", 
         RowBox[{
          RowBox[{"capreturnweight", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"2", ";;"}], ",", 
             RowBox[{"{", 
              RowBox[{"1", ",", "7"}], "}"}]}], "]"}], "]"}], ",", 
          "\"\<weighted nr, w=ncap\>\""}], "]"}]}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Blue", ",", "Orange", ",", "Green", ",", "Purple"}], "}"}]}],
       ",", 
      RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}], "\[IndentingNewLine]", 
    RowBox[{"Export", "[", 
     RowBox[{"\"\<F_r_comparison.tiff\>\"", ",", "figRcomparison"}], 
     "]"}]}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.8516991527012053`*^9, 3.8516992072062435`*^9}, {
  3.8516993616569915`*^9, 3.851699406248083*^9}, {3.8517333386523614`*^9, 
  3.8517333838989916`*^9}, {3.8517335328038893`*^9, 3.8517336320096254`*^9}, {
  3.8517336795628223`*^9, 3.8517336900847125`*^9}, {3.851733785479064*^9, 
  3.8517338018257217`*^9}, {3.8517339170679913`*^9, 3.8517339446718426`*^9}, {
  3.872653802649501*^9, 3.8726538076958814`*^9}, {3.8728249732121058`*^9, 
  3.8728249883479013`*^9}},ExpressionUUID->"690b3e49-b409-41b9-82bd-\
6e55cd085f9c"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"temp", "=", "ncosummary"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"temp", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"1", ";;"}], ",", "4"}], "]"}], "]"}], "=", 
   RowBox[{"ncosummary", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"1", ";;"}], ",", "8"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"temp", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "5"}], "]"}], "]"}], "=", "\"\<alpha\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"temp", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "5"}], "]"}], "]"}], "=", 
   RowBox[{"capreturnweight", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "5"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"temp", "[", 
     RowBox[{"[", 
      RowBox[{"1", ",", "6"}], "]"}], "]"}], "=", "\"\<alpha_calc\>\""}], 
   ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"cescalibration", "=", 
     RowBox[{"temp", "[", 
      RowBox[{"[", 
       RowBox[{
        RowBox[{"1", ";;"}], ",", 
        RowBox[{"1", ";;", "5"}]}], "]"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"Export", "[", 
     RowBox[{"\"\<cescalibration.csv\>\"", ",", "cescalibration"}], "]"}]}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gamma", "=", 
   RowBox[{"Mean", "[", 
    RowBox[{"temp", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", "5"}], "]"}], "]"}], "]"}]}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Export", "[", 
    RowBox[{"\"\<capreturnweight.csv\>\"", ",", "capreturnweight"}], "]"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Export", "[", 
    RowBox[{"\"\<gamma.csv\>\"", ",", "temp"}], "]"}], "*)"}]}]}], "Input",
 CellChangeTimes->{{3.8516957095631695`*^9, 3.8516957237383747`*^9}, {
   3.851695761315687*^9, 3.8516958581913805`*^9}, {3.8516958985402985`*^9, 
   3.851695976578811*^9}, {3.8521053627981114`*^9, 3.852105448967985*^9}, 
   3.852105486275675*^9, {3.852105518467273*^9, 3.8521055543172545`*^9}, {
   3.852105585486662*^9, 3.852105602744968*^9}, {3.8521056666693344`*^9, 
   3.852105764726384*^9}, {3.8521058478947353`*^9, 3.8521059001796503`*^9}, {
   3.852106047645762*^9, 3.852106085914688*^9}, {3.8521075855210953`*^9, 
   3.8521075880418477`*^9}, {3.872825008714164*^9, 
   3.872825059286662*^9}},ExpressionUUID->"376bc10f-ea07-474b-9d90-\
de2626460c71"],

Cell[BoxData["0.3650699687108941`"], "Output",
 CellChangeTimes->{3.872825016247672*^9},
 CellLabel->
  "Out[692]=",ExpressionUUID->"0d7c2dee-ddcb-4657-a60f-a12de09283bf"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"figalpha", "=", 
  RowBox[{"ListLinePlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Legended", "[", 
       RowBox[{
        RowBox[{"lsweight", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "4"}], "}"}]}], "]"}], "]"}], ",", 
        RowBox[{"Placed", "[", 
         RowBox[{"\"\<1-labour share\>\"", ",", "Below"}], "]"}]}], "]"}], 
      ",", 
      RowBox[{"Legended", "[", 
       RowBox[{
        RowBox[{"capreturnweight", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "5"}], "}"}]}], "]"}], "]"}], ",", 
        RowBox[{"Placed", "[", 
         RowBox[{"\"\<based on return to capital\>\"", ",", "Below"}], 
         "]"}]}], "]"}]}], "}"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Red", ",", 
         RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Blue", ",", 
         RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "}"}]}], "}"}]}], 
    ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1950", ",", "2018"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.3", ",", "0.45"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<year\>\"", ",", "\"\<\[Alpha]\>\""}], "}"}]}], ",", 
    RowBox[{
    "PlotLabel", "\[Rule]", 
     "\"\<Comparison capital share in production\>\""}], ",", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{
       RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
       RowBox[{"FontSize", "\[Rule]", "14"}], ",", "Black"}], "]"}]}], ",", 
    RowBox[{"GridLines", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"0.35", ",", "0.4"}], "}"}], "}"}]}], ",", " ", 
    RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8495453257837057`*^9, 3.849545442968615*^9}, {
  3.872743599253456*^9, 3.872743601057547*^9}, {3.8727440169849496`*^9, 
  3.8727442060586166`*^9}},
 CellLabel->
  "In[693]:=",ExpressionUUID->"8120171e-4f48-43f6-ab7c-83ae928a3777"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{}, {{{}, {}, 
       TagBox[{
         Hue[0.67, 0.6, 0.6], 
         Directive[
          PointSize[
           NCache[
            Rational[1, 72], 0.013888888888888888`]], 
          RGBColor[1, 0, 0], 
          AbsoluteThickness[2]], 
         LineBox[CompressedData["
1:eJw10Ass1VEcB/BbrpJSCtMokyTktV4jyo959MTKo+0iu4j1ormZYkOjKW/R
w67z63Gz0vXYTVKsmTVCCd28k4TMrrK6Rbqlf91fZzs7++x3fufs+1snjDkY
uZDH43lx++/5byUwyPL6oTFs2+v6z0kMxmU+iwqMyCkMav2aatLqetROY+Co
l3m+pJWcwUA2Wbbk0zw5i0FKlLim8yT15zE4lmqd8noxuZBBmaSu3G4D+RqD
UNEDq0FnspiB1ulzbllR5BsMfiePvzrjSZYwsIgWRRe4k+8yUF5uu3Lclyxl
ECa9+NItiFzFIO99kfKDgFzNIKdwy6rCRHItg3qFqVd1LLmeQWDI2j2ah8gN
DHwyb82abSI/4/JXKjpUM5T3OTe/vvXtp7qp/oKBortBaqMidzCo/n5KY9c7
spyB6tEdYa6c3MugsNNKpcnvU3uQgbzxbE+qOXmYyx9uyIJcyaMMtlfL30u2
kycYVARqtn+xJSsYRHga3W8RkKe5/EcSrhvHkJVcvscK+6EX5FkGR0NH3Pwk
ZBWDJN2KbwYjZB5C3gWJtHlLv9p8hC75gYaNlmQthMDkBeWJM3R/GYLdZhB1
jZF1EZ6IRO7p82R9hHbcW1e1jfpXI3iUP8wV/a+vQSjed9Y4fYhsiuAfrp+L
dWRzru77SxCrR/2WCGHLpiJl3mQbBKNuz8Mfg8kOCN1xeR2GYvJWhHq37GT+
E7Ijgot2/HRpJNkFoayoZlC2gwwIUpvm5Lc+ZA/ufqXf7QET8m6EHPFVvZvx
5P0IjWIzD0E72Y+bl0GlQ0jAgNr+CAuFvjrFQ+TDCLXO+TnNKwbVDkZo9epa
7S0khyH0Y/5IQRw5AmG2RDZmNEH90Qh775lMrsym+gmE0ahr9p1F5FgEbYeA
BLmILOLmv+K0RVMQOQHh6c65GT0HchICq8j8Wa5DTuHev+RUev4z/ZeGwC95
Y730KzmD+y/Aaa5JSc5CcIxb3tI2NeD6B1kGhxU=
          "]]}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$118401, {1}}]& ], 
       TagBox[{
         Hue[0.9060679774997897, 0.6, 0.6], 
         Directive[
          PointSize[
           NCache[
            Rational[1, 72], 0.013888888888888888`]], 
          RGBColor[0, 0, 1], 
          AbsoluteThickness[2]], 
         LineBox[CompressedData["
1:eJw1039MDVAUB/CUJSqZWpJC+dXSYsaUX+/LwsN7LS/0KpvIj1pF8iSryWjm
Ry9przy0c5r1B4ZVaotq2hAlaemHFLWkGnnl56o1Q+90t7u7z8737tzzx/XY
d0RzwNLCwmLTv/3/HFtJhEUerZt3a5oVY04hxGkWOdyYIz5NcFGN2r9qaDI7
jWB775mqvFt8nlBh0B2fM03y6YS9A8fWGWPEmQSd/50jGYOSNxCq42wWvv8q
NhK0RWG6l1Mkn0twrF3ysWaVOI+QdLDWuX+yOJ/Ql9GU8fyP3L9FOFmojp3i
KPW7hD3unxpsZokLCJMW6BO/e4mLCXn9kX15SnEpIT3CaqPPenE5IVl5uOD6
+PyVBMUMvWbbqPR7StiSEJRcVyV+QXic0Jk+qBfXEmZO7Fuef0NcT6gvta0P
iBc3Ev6MWPp/CRG/JazurYgxzRS3EzKiEsKDPcSdhJ0lt3+5uIi7CYtHrX0T
7cV9hCEHxzCVr7if0PiltrVBKx4khG/IDupUiH8S6t7hqmL8vUME/w+Nl3Qs
HiXk5B+N1DrL/BaMQz+7O5KN4omMzpyUEMNDsQ1DnXhzT2iV2I5xxbNXuaxO
PI2xeCT3jevUFrOdGCmNw6m3w8UujNDAFqv6vWI3RsOH5oAJoeK5DK+Wqm5v
tXg+o32N76T4crEXw3TuYtPC2W/N9mFEmXJ6HZXipQy7NCO3GsTLGc/O7mrr
KRT7MX4PdFhujRSvYTxZOdy8Yr4YjDIfd1ORmzjg3zw7r6Wafkh/JaMmxOmb
Qi11FSPY+CIrqFgcxKiMjiyNULeavYNRXeK0L7dMrGV0nTus8fws3s24tf56
z33Xd2ZHMGZsv3wz0Ea8n1FhzFq9IVvyUYzM+KqEQDepxzLW6vQPpo87nvE0
u+hE9Ph9HeOC/vWpHfPESYwA10vaZSpxCqO/Q+HddUZ8muFva1V5sECcxrD2
W+JksG6T/89ImtzRYtgoTmcMWz9yfhzWpvgLayh44g==
          "]]}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$118401, {2}}]& ]}, {
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$118401, {1}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$118401, {2}}]& ]}, {
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$118401, {1}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$118401, {
          2}}]& ], {}, {}, {}}, {
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$118401, {1}}]& ], 
       TagBox[{}, 
        Annotation[#, {{Legended}, Charting`Private`Tag$118401, {
          2}}]& ], {}, {}, {}}}, {{}, {}}}, {
    DisplayFunction -> Identity, DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {
       FormBox["\"year\"", TraditionalForm], 
       FormBox["\"\[Alpha]\"", TraditionalForm]}, AxesOrigin -> {1950., 0.3}, 
     DisplayFunction :> Identity, Frame -> {{False, False}, {False, False}}, 
     FrameLabel -> {{None, None}, {None, None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {{0.35, 0.4}, {0.35, 0.4}}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> 600, LabelStyle -> 
     Directive[FontFamily -> "Helvetica", FontSize -> 14, 
       GrayLevel[0]], 
     Method -> {
      "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
       "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& )}}, PlotLabel -> 
     FormBox["\"Comparison capital share in production\"", TraditionalForm], 
     PlotRange -> {{1950, 2018}, {0.3, 0.45}}, PlotRangeClipping -> True, 
     PlotRangePadding -> {{0, 0}, {0, 0}}, Ticks -> {Automatic, Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{"\"1-labour share\"", "\"based on return to capital\""}, 
      "LineLegend", DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[1, 0, 0], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[1, 0, 0], 
                    AbsoluteThickness[2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #, 
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0, 0, 1], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0, 0, 1], 
                    AbsoluteThickness[2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.8, 0.5}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxDividers -> {"Columns" -> {{None}}, "Rows" -> {{None}}}, 
             GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
             GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{1}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
          Directive[FontFamily -> "Helvetica", FontSize -> 14, 
           GrayLevel[0]], FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "72"], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0, 0], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}], 
                   ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "72"], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 0, 1], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}]}], 
                 "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "72"], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0, 0], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}], 
                   ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", 
                    FractionBox["1", "72"], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 0, 1], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}]}], 
                 "}"}]}], "}"}], ",", 
           RowBox[{"{", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{#, ",", #2}], "}"}], ",", 
               RowBox[{"{", "}"}]}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"None", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"None", ",", "Automatic"}], "}"}]}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], 
               "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"True", ",", "True"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"True", ",", "True"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
               RowBox[{
                 RowBox[{"FontFamily", "\[Rule]", "\"Helvetica\""}], ",", 
                 RowBox[{"FontSize", "\[Rule]", "14"}], ",", 
                 InterpretationBox[
                  ButtonBox[
                   TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                   BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                   ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                   Automatic, Method -> "Preemptive"], 
                  GrayLevel[0], Editable -> False, Selectable -> False]}], 
               "]"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Row\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "Below"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.8495454457580132`*^9, {3.8495491401445436`*^9, 3.8495491445952287`*^9}, 
   3.8516916373881035`*^9, {3.8727434124657087`*^9, 3.872743421006385*^9}, 
   3.8727434711856065`*^9, 3.87274360163276*^9, {3.8727441482769866`*^9, 
   3.872744206679878*^9}, 3.8728250723390303`*^9},
 CellLabel->
  "Out[693]=",ExpressionUUID->"2f6c288c-0942-479e-8b1a-5361837e569a"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"dnraw", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"\"\<\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "181"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "2"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"dnraw", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "1"}], "]"}], "]"}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{"Position", "[", 
       RowBox[{
        RowBox[{"depraw", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;"}], ",", "i"}], "]"}], "]"}], ",", 
        RowBox[{"_", "?", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"#", "\[NotEqual]", "\"\<\>\""}], "&"}], ")"}]}], ",", "1",
         ",", "1"}], "]"}], "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1"}], "]"}], "]"}], "+", "1"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "181"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"dnraw", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "2"}], "]"}], "]"}], "=", 
    RowBox[{"depraw", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"dnraw", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", "i"}], "]"}], "]"}]}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "181"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"depfull", "=", "depraw"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"Do", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"depfull", "[", 
       RowBox[{"[", 
        RowBox[{"i", ",", "j"}], "]"}], "]"}], "=", 
      RowBox[{"dnraw", "[", 
       RowBox[{"[", 
        RowBox[{"j", ",", "2"}], "]"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "2", ",", 
       RowBox[{"dnraw", "[", 
        RowBox[{"[", 
         RowBox[{"j", ",", "1"}], "]"}], "]"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"j", ",", "2", ",", "181"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "use", " ", "the", " ", "last", " ", "observed", " ", "deprecition", " ", 
    "value", " ", "for", " ", "the", " ", "missing", " ", "data"}], 
   "*)"}]}]}], "Input",
 CellChangeTimes->{{3.8383986692649603`*^9, 3.8383986973006244`*^9}, {
  3.838398727592216*^9, 3.838398776156545*^9}, {3.8383996415978355`*^9, 
  3.838399798337038*^9}, {3.838399860381991*^9, 3.8383998615436306`*^9}, {
  3.8434627873278065`*^9, 3.8434628127180986`*^9}},
 CellLabel->
  "In[704]:=",ExpressionUUID->"92425cc9-9460-46e0-944d-d353b39180d5"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"capPPPraw2", "=", "capPPPraw"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"Do", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"capPPPraw2", "[", 
       RowBox[{"[", 
        RowBox[{"i", ",", "j"}], "]"}], "]"}], "=", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"capPPPraw", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "j"}], "]"}], "]"}], "\[Equal]", "\"\<\>\""}], 
        ",", "0", ",", 
        RowBox[{"capPPPraw", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "j"}], "]"}], "]"}]}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "2", ",", "71"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"j", ",", "2", ",", "181"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "do", " ", "not", " ", "consider", " ", "deprecition", " ", "rates", " ", 
    "of", " ", "missing", " ", "countries"}], "*)"}]}]}], "Input",
 CellChangeTimes->{{3.8366069177324295`*^9, 3.8366069362272964`*^9}, {
   3.8366070201993785`*^9, 3.8366070715860248`*^9}, 3.836607191054178*^9, {
   3.8366073794423294`*^9, 3.8366073799858255`*^9}, {3.8366074416524663`*^9, 
   3.836607446205468*^9}, {3.8434628350972376`*^9, 3.8434628539261236`*^9}, 
   3.8495413537061267`*^9},ExpressionUUID->"44035543-4035-4098-8058-\
02a8180e6fa2"]
}, Open  ]]
},
WindowSize->{1428., 743.25},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
FrontEndVersion->"12.1 for Microsoft Windows (64-bit) (June 9, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"03433be8-300e-4d7f-9a3c-4facfd9557a7"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 1018, 21, 48, "Input",ExpressionUUID->"3a2299ed-c337-4a69-b47b-2a7067412548"],
Cell[1601, 45, 575, 9, 32, "Output",ExpressionUUID->"8d771d77-795d-4258-9e98-19613dd2e158"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2213, 59, 382, 7, 105, "Section",ExpressionUUID->"9c26658f-85de-4ad1-ae89-4eecb7c5fd1c"],
Cell[CellGroupData[{
Cell[2620, 70, 861, 20, 86, "Input",ExpressionUUID->"0666d5bf-b080-4b23-9cfa-7d0df3d9425b"],
Cell[3484, 92, 765, 13, 32, "Output",ExpressionUUID->"da0ab1f5-e54c-4e7e-8b1f-1f911a34bd42"],
Cell[4252, 107, 765, 13, 32, "Output",ExpressionUUID->"755624ce-5ce1-4114-bae7-85e373fd0408"]
}, Open  ]],
Cell[5032, 123, 8277, 267, 314, "Input",ExpressionUUID->"a88d68a9-3de2-4baa-85e5-28d1ae181487"],
Cell[13312, 392, 963, 28, 67, "Input",ExpressionUUID->"7df25b39-2f94-4444-b28c-d3d0db751a17"],
Cell[14278, 422, 3424, 116, 219, "Input",ExpressionUUID->"01740d0c-1a31-4e86-90b0-9199eb29c0f9"],
Cell[CellGroupData[{
Cell[17727, 542, 194, 3, 28, "Input",ExpressionUUID->"2ecb525f-ec32-4c7e-8f60-21e256f6a0ae"],
Cell[17924, 547, 202, 2, 32, "Output",ExpressionUUID->"31b1df94-bf1f-4a10-83fa-b899aa31981a"]
}, Open  ]],
Cell[18141, 552, 2865, 86, 181, "Input",ExpressionUUID->"aca4d7c7-abe0-404e-b569-f3842a4c73e9"],
Cell[21009, 640, 1527, 39, 67, "Input",ExpressionUUID->"a88ebc3b-18f0-483a-a7a5-90a84c7e70e8"],
Cell[CellGroupData[{
Cell[22561, 683, 3436, 83, 105, "Input",ExpressionUUID->"dc491e42-5118-4fb8-a0ec-ff6d1dd69c86"],
Cell[26000, 768, 40610, 809, 526, "Output",ExpressionUUID->"59aef25c-5d9c-489a-9ae9-c21992857e9f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[66647, 1582, 258, 5, 28, "Input",ExpressionUUID->"bc22d246-31d9-44d4-8743-58b651439433"],
Cell[66908, 1589, 224, 4, 32, "Output",ExpressionUUID->"a474c71d-9318-42ff-a9d5-d68e3ec6d39b"]
}, Open  ]],
Cell[67147, 1596, 1791, 59, 105, "Input",ExpressionUUID->"dd3c6d6a-e718-45e4-9860-b489f7935b2a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[68975, 1660, 487, 9, 105, "Section",ExpressionUUID->"f9088f16-3a96-4b86-a60b-22d11848bfb4"],
Cell[CellGroupData[{
Cell[69487, 1673, 936, 24, 124, "Input",ExpressionUUID->"ed9d8459-fd80-46c8-806e-86abaf394fde"],
Cell[70426, 1699, 347, 7, 32, "Output",ExpressionUUID->"992e21da-cefa-4688-8392-9a4a62b25583"],
Cell[70776, 1708, 347, 7, 32, "Output",ExpressionUUID->"132e5238-684c-4267-8eed-2c70a8ffd0b2"],
Cell[71126, 1717, 345, 7, 32, "Output",ExpressionUUID->"f50dee86-c4b6-446a-8013-169c3b16a3ff"]
}, Open  ]],
Cell[71486, 1727, 9414, 304, 352, "Input",ExpressionUUID->"305eca97-6c33-4d5e-a668-6ac4c33142fd"],
Cell[80903, 2033, 3044, 103, 200, "Input",ExpressionUUID->"3198e342-dfaf-468f-999f-dd31d44f23d2"],
Cell[83950, 2138, 3059, 94, 200, "Input",ExpressionUUID->"9aae84c0-d6ea-48c7-afa0-b43feadac856"],
Cell[CellGroupData[{
Cell[87034, 2236, 3332, 89, 124, "Input",ExpressionUUID->"e2dc2c95-127f-4d47-bbc0-2b53d0ce87f4"],
Cell[90369, 2327, 48755, 976, 536, "Output",ExpressionUUID->"c82972a6-ea60-4ddb-9464-8951e0a5b710"]
}, Open  ]],
Cell[139139, 3306, 1381, 40, 67, "Input",ExpressionUUID->"ff7c1af8-f0ec-4108-b6b1-788321d52f20"]
}, Open  ]],
Cell[CellGroupData[{
Cell[140557, 3351, 376, 7, 67, "Section",ExpressionUUID->"99fccddf-18b2-4c50-ba0e-df2b97e7f920"],
Cell[140936, 3360, 427, 11, 28, "Input",ExpressionUUID->"0570c3f9-47d2-4761-a9c8-6732c5423097"],
Cell[141366, 3373, 624, 15, 48, "Input",ExpressionUUID->"3169ff3a-952a-422b-b99e-8042caea363f"],
Cell[141993, 3390, 9125, 292, 352, "Input",ExpressionUUID->"0d6f9d68-19fb-4423-8d02-db118dc25f91"],
Cell[151121, 3684, 1240, 31, 67, "Input",ExpressionUUID->"fc15fc96-b499-4ad6-8f19-57649263fe41"],
Cell[152364, 3717, 3126, 74, 105, "Input",ExpressionUUID->"44f87d9b-4a8d-4258-a38f-591bf4280f7d"],
Cell[CellGroupData[{
Cell[155515, 3795, 414, 6, 28, "Input",ExpressionUUID->"fb3b2f47-96d8-4644-b7e9-4c86abecd9bd"],
Cell[155932, 3803, 471, 7, 32, "Output",ExpressionUUID->"17d6a8c8-1c4c-4ed5-a574-420939c4c206"]
}, Open  ]],
Cell[156418, 3813, 2103, 64, 124, "Input",ExpressionUUID->"8d6b2b93-949b-4cf8-bf09-f8be3078dddc"],
Cell[158524, 3879, 1742, 54, 105, "Input",ExpressionUUID->"d0d4fff3-b893-4b30-8c6a-f5e8b580649c"],
Cell[160269, 3935, 3060, 86, 162, "Input",ExpressionUUID->"e93d06fd-543b-4a3f-9030-a7cfee4cd0a7"],
Cell[163332, 4023, 2107, 50, 67, "Input",ExpressionUUID->"1b5e2dd1-2b65-4764-912c-fbc6f4ab1190"],
Cell[165442, 4075, 2695, 65, 86, "Input",ExpressionUUID->"fd8f22ae-079f-477f-9d6e-d833fe285df2"],
Cell[CellGroupData[{
Cell[168162, 4144, 358, 7, 28, "Input",ExpressionUUID->"cf8757a0-410c-47a5-9057-2e017256a93a"],
Cell[168523, 4153, 312, 4, 32, "Output",ExpressionUUID->"00e8cd6f-d921-4881-a289-e621cbb50b71"]
}, Open  ]],
Cell[168850, 4160, 692, 18, 28, "Input",ExpressionUUID->"3ae79447-32b3-4bd8-ae8e-e171c1a31c12"],
Cell[169545, 4180, 1765, 59, 124, "Input",ExpressionUUID->"e29d0357-aa08-48d0-8fe4-9d624f551a26"],
Cell[CellGroupData[{
Cell[171335, 4243, 12596, 365, 580, "Input",ExpressionUUID->"89f94d37-b8f3-4c43-8f18-52a622fba668"],
Cell[183934, 4610, 296, 5, 32, "Output",ExpressionUUID->"26b7a38f-d949-4040-9e42-f4db792d73fa"],
Cell[184233, 4617, 295, 5, 32, "Output",ExpressionUUID->"c9d61508-9e81-483c-9bf7-327811c1e357"],
Cell[184531, 4624, 293, 5, 32, "Output",ExpressionUUID->"04e20790-9b15-4516-8d2b-b1993e2745b1"]
}, Open  ]],
Cell[184839, 4632, 4201, 130, 257, "Input",ExpressionUUID->"10552795-2732-47c5-b730-c01a4bfeab88"],
Cell[189043, 4764, 176, 3, 28, "Input",ExpressionUUID->"bb0847b9-b18a-4f0d-944d-ebb18b401e2e"],
Cell[189222, 4769, 377, 6, 28, "Input",ExpressionUUID->"816f3a26-9da9-49ad-ac72-6a563f995d63"],
Cell[189602, 4777, 1160, 30, 48, "Input",ExpressionUUID->"897230b6-ed0d-4ac4-99e6-8dde49b2fb39"],
Cell[190765, 4809, 2360, 59, 67, "Input",ExpressionUUID->"ca607068-fc00-427e-9007-bbfc00b8d352"],
Cell[193128, 4870, 1759, 46, 48, "Input",ExpressionUUID->"d38e4f37-cf76-4c69-a1c9-c23080c2bec3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[194924, 4921, 784, 14, 257, "Section",ExpressionUUID->"c735a4db-bf6e-40e3-8c46-0ecf8c885aa0"],
Cell[195711, 4937, 1512, 41, 162, "Input",ExpressionUUID->"25d03b5b-1c01-48e9-a2d2-5a2bef53afc9"],
Cell[197226, 4980, 287, 7, 28, "Input",ExpressionUUID->"a758f683-cd4a-47d8-bdbb-c666b7f3c6a4"],
Cell[CellGroupData[{
Cell[197538, 4991, 618, 10, 105, "Input",ExpressionUUID->"7fbd6e72-f344-4aaf-8b1c-5b9eda17c45d"],
Cell[198159, 5003, 447, 9, 32, "Output",ExpressionUUID->"94ead80a-eb68-42a2-ba2f-84fcfbcd0408"],
Cell[198609, 5014, 443, 9, 32, "Output",ExpressionUUID->"26c26a3c-5121-481e-a48a-8d02d8d5f532"],
Cell[199055, 5025, 445, 9, 32, "Output",ExpressionUUID->"0c2f6e71-7635-42e5-b70a-e3bddee35353"],
Cell[199503, 5036, 445, 9, 32, "Output",ExpressionUUID->"fff3c355-425b-45ec-ae51-5ec86f316685"],
Cell[199951, 5047, 445, 9, 32, "Output",ExpressionUUID->"21693b02-bb6a-4d3a-8176-4cba4a74b15f"]
}, Open  ]],
Cell[200411, 5059, 225, 4, 35, "Text",ExpressionUUID->"1e632f57-2ca2-48c9-a44f-04c70d1eb590"],
Cell[200639, 5065, 5037, 172, 314, "Input",ExpressionUUID->"dfc6e64a-500e-48b6-bf82-9541cc7d40fe"],
Cell[205679, 5239, 154, 3, 28, "Input",ExpressionUUID->"bb873d8c-de28-4583-af1d-5f42dc6bdd3f"],
Cell[CellGroupData[{
Cell[205858, 5246, 3081, 82, 86, "Input",ExpressionUUID->"7b1ba76f-1e47-4d49-8d9c-fb14ead5c15a"],
Cell[208942, 5330, 51853, 1047, 394, "Output",ExpressionUUID->"e2d9f3be-afef-4153-90f7-19dc2a3f5682"]
}, Open  ]],
Cell[CellGroupData[{
Cell[260832, 6382, 265, 5, 28, "Input",ExpressionUUID->"4db49b3d-70e5-4b16-a993-0b53c9fc141e"],
Cell[261100, 6389, 178, 3, 32, "Output",ExpressionUUID->"7abf56d3-7481-4467-8741-1806fb702a3e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[261315, 6397, 2871, 78, 86, "Input",ExpressionUUID->"2dacfd25-569f-4c82-8456-89f86918cbc3"],
Cell[264189, 6477, 51665, 1045, 389, "Output",ExpressionUUID->"002bba58-92a5-477d-aeb0-52ba62b407f3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[315891, 7527, 270, 5, 28, "Input",ExpressionUUID->"34f9ef09-87db-499a-b359-a0bfe9274e4c"],
Cell[316164, 7534, 181, 3, 32, "Output",ExpressionUUID->"17e15982-b9b2-4181-9ba3-e293ef9e5539"]
}, Open  ]],
Cell[316360, 7540, 3836, 129, 181, "Input",ExpressionUUID->"d65eb0c5-7350-4d6b-a99c-28f8ff7cc97a"],
Cell[320199, 7671, 264, 7, 28, "Input",ExpressionUUID->"7600c860-27c4-47d8-bdc2-6add7a72bf11"],
Cell[CellGroupData[{
Cell[320488, 7682, 2079, 52, 48, "Input",ExpressionUUID->"4c3d4c61-72bb-473b-af79-de2a4548fa03"],
Cell[322570, 7736, 31232, 629, 396, "Output",ExpressionUUID->"080e29d2-0876-4fcd-90f2-4ceeedf334b2"]
}, Open  ]],
Cell[CellGroupData[{
Cell[353839, 8370, 266, 5, 28, "Input",ExpressionUUID->"270dafc9-b234-43c1-804e-6217ce383ad8"],
Cell[354108, 8377, 177, 3, 32, "Output",ExpressionUUID->"76f32154-78ef-4428-8142-1f513240869d"]
}, Open  ]],
Cell[354300, 8383, 11863, 378, 466, "Input",ExpressionUUID->"c5fbfe50-7e17-4505-8404-067035f11712"],
Cell[366166, 8763, 3202, 75, 105, "Input",ExpressionUUID->"7f396c2c-d245-4644-92c4-792b6a0a9640"],
Cell[CellGroupData[{
Cell[369393, 8842, 483, 9, 28, "Input",ExpressionUUID->"49d67d05-4c04-43b2-8a98-6f0868b6ef25"],
Cell[369879, 8853, 558, 9, 32, "Output",ExpressionUUID->"07cf2a10-a7e9-45c3-9624-a7869cf9dc64"]
}, Open  ]],
Cell[370452, 8865, 1853, 55, 105, "Input",ExpressionUUID->"bdb962f4-2953-48ef-99ad-c182a695f105"],
Cell[372308, 8922, 3276, 90, 162, "Input",ExpressionUUID->"65bbd0a5-0ab5-4ef2-ae6d-de398b355f3d"],
Cell[375587, 9014, 12982, 399, 466, "Input",ExpressionUUID->"efd40710-fc3e-4c20-9f2e-af110855d849"],
Cell[388572, 9415, 1547, 52, 105, "Input",ExpressionUUID->"3103213e-a34c-423a-a65b-44251a086fa0"],
Cell[390122, 9469, 1924, 56, 105, "Input",ExpressionUUID->"fc6fdcb0-7747-4d5a-9263-4478407dae47"],
Cell[392049, 9527, 3464, 93, 181, "Input",ExpressionUUID->"91190bf0-1eb4-4cf0-8806-eee9003ce9b5"],
Cell[395516, 9622, 3871, 122, 238, "Input",ExpressionUUID->"e8c10e15-15ac-4e6e-96cc-4c5ac73cff1d"],
Cell[CellGroupData[{
Cell[399412, 9748, 887, 26, 67, "Input",ExpressionUUID->"3a6fba77-4065-4194-a6ba-2224f148f8f0"],
Cell[400302, 9776, 323, 5, 32, "Output",ExpressionUUID->"cb53c8e1-9380-4f39-86d2-bbabea857435"],
Cell[400628, 9783, 325, 5, 32, "Output",ExpressionUUID->"7183f36a-ce34-4746-abc1-5685576d1ec0"],
Cell[400956, 9790, 322, 5, 32, "Output",ExpressionUUID->"8e4850ca-cc9c-465d-9ecf-bc54556c7dab"]
}, Open  ]],
Cell[CellGroupData[{
Cell[401315, 9800, 2799, 70, 105, "Input",ExpressionUUID->"d8ca0cd3-fc9a-40e1-a6d8-65aefd2da0f9"],
Cell[404117, 9872, 38385, 770, 500, "Output",ExpressionUUID->"d3aa4fc6-da18-44ca-859a-01232a5ffaad"]
}, Open  ]],
Cell[442517, 10645, 744, 23, 48, "Input",ExpressionUUID->"ba6458e1-8409-45a7-9d0f-1f35ad4819fa"],
Cell[443264, 10670, 1308, 39, 67, "Input",ExpressionUUID->"45be73bb-8c89-4d4f-bb66-5f668608313c"],
Cell[CellGroupData[{
Cell[444597, 10713, 4467, 137, 200, "Input",ExpressionUUID->"04ed6b99-9aef-4161-a066-6f87a77e0800"],
Cell[449067, 10852, 479, 9, 32, "Output",ExpressionUUID->"c9aa627c-73fd-48fc-a877-fb77026043ff"]
}, Open  ]],
Cell[CellGroupData[{
Cell[449583, 10866, 4248, 101, 124, "Input",ExpressionUUID->"9f17f4de-6975-4e5d-85c2-13f140340f0c"],
Cell[453834, 10969, 31361, 630, 454, "Output",ExpressionUUID->"7670775e-cadb-4c66-877d-73be2d67531a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[485232, 11604, 2628, 73, 86, "Input",ExpressionUUID->"cf511ed8-12f1-4628-85db-f0b77ab06ec9"],
Cell[487863, 11679, 36367, 730, 424, "Output",ExpressionUUID->"43de7273-717a-4b42-a1bf-32193fbba314"]
}, Open  ]],
Cell[CellGroupData[{
Cell[524267, 12414, 271, 6, 28, "Input",ExpressionUUID->"81d08c00-bcdb-43a4-8387-a5389a032114"],
Cell[524541, 12422, 231, 4, 32, "Output",ExpressionUUID->"14190cc4-97c0-4af0-a71d-b1d650bd9c08"]
}, Open  ]],
Cell[524787, 12429, 2392, 62, 67, "Input",ExpressionUUID->"c393dd95-e180-41f9-8dfa-5542e69b8f16"],
Cell[527182, 12493, 2791, 74, 86, "Input",ExpressionUUID->"31e1c61f-cf97-43ba-9a8e-64a1e634538b"],
Cell[529976, 12569, 254, 5, 46, "Text",ExpressionUUID->"b119cbc0-e003-4d91-9181-4f8b53c50781"],
Cell[530233, 12576, 2015, 56, 67, "Input",ExpressionUUID->"c633c27d-a174-46c4-864b-79ad744f3ec1"],
Cell[532251, 12634, 4315, 128, 238, "Input",ExpressionUUID->"dd907f42-c99b-4d17-a6ec-a1bb4cad6a8e"],
Cell[CellGroupData[{
Cell[536591, 12766, 1443, 42, 143, "Input",ExpressionUUID->"fcec4030-6e16-4b5e-936c-15da5453a663"],
Cell[538037, 12810, 424, 8, 32, "Output",ExpressionUUID->"0cf30e7d-35f4-4b98-8c86-5de3058f4f30"],
Cell[538464, 12820, 422, 8, 32, "Output",ExpressionUUID->"e37e9f98-9297-4b90-9983-a13634e8724a"]
}, Open  ]],
Cell[538901, 12831, 3370, 102, 143, "Input",ExpressionUUID->"a87c861d-6b7a-4319-92b3-0d6a0aed498a"],
Cell[CellGroupData[{
Cell[542296, 12937, 1098, 29, 28, "Input",ExpressionUUID->"fdc05475-f76b-4fab-9645-5e5ea1f0f719"],
Cell[543397, 12968, 3986, 86, 388, "Output",ExpressionUUID->"644f5c00-d2b3-4edb-9aa9-ecaa41f5bcab"]
}, Open  ]],
Cell[CellGroupData[{
Cell[547420, 13059, 2248, 55, 86, "Input",ExpressionUUID->"9a1debe1-697d-4f35-bfbd-90625b91d969"],
Cell[549671, 13116, 14772, 303, 441, "Output",ExpressionUUID->"3567b4b6-5a17-4360-9d22-a3e4116d45f1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[564480, 13424, 629, 17, 48, "Input",ExpressionUUID->"8ffd16a3-4b5c-485a-929b-b735886774ab"],
Cell[565112, 13443, 313, 5, 32, "Output",ExpressionUUID->"bf4da003-b270-4084-8160-f36329dd4ae6"],
Cell[565428, 13450, 315, 5, 32, "Output",ExpressionUUID->"f1dc6758-a454-478f-95b2-afe210b806bb"]
}, Open  ]],
Cell[565758, 13458, 176, 3, 28, "Input",ExpressionUUID->"44753cf7-82eb-488b-9116-d5281e56ed7e"],
Cell[565937, 13463, 4093, 130, 143, "Input",ExpressionUUID->"857ecea0-4e58-4be2-9385-817ff92a9800"],
Cell[570033, 13595, 1771, 53, 86, "Input",ExpressionUUID->"7dc30912-e35f-4aed-9279-01fbe90ee413"],
Cell[CellGroupData[{
Cell[571829, 13652, 4774, 142, 219, "Input",ExpressionUUID->"57869d5a-5fee-4c8d-9ea1-0bc229e05ed0"],
Cell[576606, 13796, 618, 11, 32, "Output",ExpressionUUID->"5e3165f0-ef95-4088-8722-d1c44d61f652"]
}, Open  ]],
Cell[577239, 13810, 231, 4, 28, "Input",ExpressionUUID->"e7de544d-42b7-4c25-a430-b1ae05e7109b"],
Cell[577473, 13816, 1726, 53, 67, "Input",ExpressionUUID->"8684e5b5-db5c-491d-81d5-a8aa8abd9acb"],
Cell[579202, 13871, 2456, 72, 67, "Input",ExpressionUUID->"d0aed822-2c16-4a03-80ee-d6983d19342b"],
Cell[581661, 13945, 2589, 79, 86, "Input",ExpressionUUID->"032bfac0-53f8-464b-8513-0872d3a5ad9b"],
Cell[CellGroupData[{
Cell[584275, 14028, 2189, 57, 67, "Input",ExpressionUUID->"85fda522-3380-4a26-8e89-fa963454d74c"],
Cell[586467, 14087, 36215, 725, 467, "Output",ExpressionUUID->"092cdc36-c725-40c3-bcdb-d2ad5906865b"]
}, Open  ]],
Cell[622697, 14815, 4120, 108, 124, "Input",ExpressionUUID->"8e2efc6b-d804-49d7-ac75-da0da52fc3a5"],
Cell[CellGroupData[{
Cell[626842, 14927, 436, 11, 28, "Input",ExpressionUUID->"9e7f8d0d-4a82-49f8-9629-7f553082f373"],
Cell[627281, 14940, 15765, 322, 538, "Output",ExpressionUUID->"192a1855-2cf3-4a41-8fab-adc3c7b634e4"]
}, Open  ]],
Cell[643061, 15265, 850, 25, 67, "Input",ExpressionUUID->"c6721c3d-33f0-4654-a4a2-883b8699b017"],
Cell[CellGroupData[{
Cell[643936, 15294, 2575, 68, 105, "Input",ExpressionUUID->"7ad13441-854f-4cfa-a8b0-f3ae7512f6a4"],
Cell[646514, 15364, 23004, 466, 455, "Output",ExpressionUUID->"9a0ae9e7-1c3b-4933-9db4-4b98e217f52b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[669555, 15835, 2463, 66, 105, "Input",ExpressionUUID->"48aff6f4-eff4-4525-8467-164f5a59e105"],
Cell[672021, 15903, 22784, 463, 461, "Output",ExpressionUUID->"bb5276e6-1932-466f-aca9-2b853a1d3dc7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[694842, 16371, 478, 12, 28, "Input",ExpressionUUID->"21e00f89-2fa5-499c-a2e8-a717ff527f34"],
Cell[695323, 16385, 93132, 1878, 901, "Output",ExpressionUUID->"4cfa9ab9-6730-498a-967f-2ed37195ab73"]
}, Open  ]],
Cell[CellGroupData[{
Cell[788492, 18268, 2400, 63, 67, "Input",ExpressionUUID->"f24b81c9-71e0-4e79-8413-fc8ae52cb689"],
Cell[790895, 18333, 44185, 883, 392, "Output",ExpressionUUID->"c6387065-688a-4364-884d-86d4acf2af4c"]
}, Open  ]],
Cell[835095, 19219, 811, 24, 48, "Input",ExpressionUUID->"4377d213-5afa-47ea-b7e5-25e3fa8e0c80"],
Cell[CellGroupData[{
Cell[835931, 19247, 416, 9, 48, "Input",ExpressionUUID->"bbc106ae-6fb9-4ab1-b2ad-39b9054907c7"],
Cell[836350, 19258, 183, 3, 32, "Output",ExpressionUUID->"d096d6b9-b314-41a3-a196-5b10bd6092b3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[836570, 19266, 177, 3, 28, "Input",ExpressionUUID->"bc5ca29f-4765-4cc2-9dd4-c93f3363a43f"],
Cell[836750, 19271, 179, 3, 32, "Output",ExpressionUUID->"e0cc8c68-ea1c-4a7c-afe9-fc941e2546c1"]
}, Open  ]],
Cell[836944, 19277, 6279, 204, 352, "Input",ExpressionUUID->"cd848c51-13ce-452c-8833-d43f48f179c0"],
Cell[CellGroupData[{
Cell[843248, 19485, 388, 9, 48, "Input",ExpressionUUID->"32486c5c-5dbb-4932-9103-16abdb06a0c8"],
Cell[843639, 19496, 225, 4, 32, "Output",ExpressionUUID->"33140467-18c5-4ee0-b00c-e985eca642b0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[843901, 19505, 257, 5, 28, "Input",ExpressionUUID->"2e6c8006-53f6-456c-b62d-24c51707f214"],
Cell[844161, 19512, 249, 4, 32, "Output",ExpressionUUID->"c3b68d61-11ef-4ef7-be53-6eba5b17d569"]
}, Open  ]],
Cell[844425, 19519, 268, 6, 76, "Text",ExpressionUUID->"3e23c470-78e5-445b-9d66-35817939ac42"],
Cell[CellGroupData[{
Cell[844718, 19529, 1289, 27, 124, "Input",ExpressionUUID->"7f9b6098-a1a4-43a4-9a37-0b5e9a79fa6c"],
Cell[846010, 19558, 274, 6, 32, "Output",ExpressionUUID->"747902ee-7234-4cba-9570-d4db18442f49"],
Cell[846287, 19566, 272, 6, 32, "Output",ExpressionUUID->"e3ed30fd-596c-4f26-ac46-04b3ae205c7d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[846596, 19577, 11174, 354, 504, "Input",ExpressionUUID->"d74fe3cb-d45a-4fec-8b20-4b4cb1b13d4d"],
Cell[857773, 19933, 414, 6, 32, "Output",ExpressionUUID->"474e42f8-7d1e-463a-95db-09586b251378"],
Cell[858190, 19941, 412, 6, 32, "Output",ExpressionUUID->"17189ac6-97d8-4baf-a9ad-9a94b097eaf0"],
Cell[858605, 19949, 415, 6, 32, "Output",ExpressionUUID->"70c20744-2155-47cd-accf-a250a72f76b9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[859057, 19960, 1503, 37, 48, "Input",ExpressionUUID->"88d658f2-20bf-4bd7-ad7f-95db159111ae"],
Cell[860563, 19999, 2872, 67, 396, "Output",ExpressionUUID->"921c9aef-e4e1-4716-ba02-63d1ee8ed423"]
}, Open  ]],
Cell[863450, 20069, 358, 7, 28, "Input",ExpressionUUID->"f61493ad-4ca6-4a2c-96aa-0f2c884f9750"],
Cell[863811, 20078, 331, 7, 76, "Text",ExpressionUUID->"c902f7d9-54fe-4da8-be50-c30862db8e2b"],
Cell[CellGroupData[{
Cell[864167, 20089, 714, 18, 105, "Input",ExpressionUUID->"677b7888-cbf5-4985-bbe5-8b39f19d5824"],
Cell[864884, 20109, 201, 5, 32, "Output",ExpressionUUID->"a2d723fe-ed48-465a-8935-12d00135b2ac"],
Cell[865088, 20116, 199, 5, 32, "Output",ExpressionUUID->"47524e35-38fa-4c91-a110-a56048aa99f6"]
}, Open  ]],
Cell[865302, 20124, 436, 11, 28, "Input",ExpressionUUID->"c9dc9c29-662b-44b4-9201-3683522665bd"],
Cell[865741, 20137, 18090, 558, 732, "Input",ExpressionUUID->"e2588517-b1bc-4202-9e0d-29fd1814309e"],
Cell[883834, 20697, 2393, 59, 86, "Input",ExpressionUUID->"690b3e49-b409-41b9-82bd-6e55cd085f9c"],
Cell[CellGroupData[{
Cell[886252, 20760, 2579, 75, 200, "Input",ExpressionUUID->"376bc10f-ea07-474b-9d90-de2626460c71"],
Cell[888834, 20837, 171, 3, 32, "Output",ExpressionUUID->"0d7c2dee-ddcb-4657-a60f-a12de09283bf"]
}, Open  ]],
Cell[CellGroupData[{
Cell[889042, 20845, 2371, 65, 67, "Input",ExpressionUUID->"8120171e-4f48-43f6-ab7c-83ae928a3777"],
Cell[891416, 20912, 22781, 464, 439, "Output",ExpressionUUID->"2f6c288c-0942-479e-8b1a-5361837e569a"]
}, Open  ]],
Cell[914212, 21379, 2648, 81, 124, "Input",ExpressionUUID->"92425cc9-9460-46e0-944d-d353b39180d5"],
Cell[916863, 21462, 1388, 36, 67, "Input",ExpressionUUID->"44035543-4035-4098-8058-02a8180e6fa2"]
}, Open  ]]
}
]
*)

