(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[   6273872,     132738]
NotebookOptionsPosition[   6218623,     131906]
NotebookOutlinePosition[   6219120,     131923]
CellTagsIndexPosition[   6219077,     131920]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
   "SetDirectory", "[", 
    "\"\<C:\\\\Users\\\\wilmsen\\\\Dropbox\\\\Historic_DICE_Dropbox\\\\Data_\
1960_2019\\\\SI_SpinUp\>\"", "]"}], ";"}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.818438376389078*^9, 3.8184383796690826`*^9}, 
   3.8313892410244665`*^9},
 CellLabel->"In[89]:=",ExpressionUUID->"012e4ec2-5954-4e72-8e0c-cd62752b98ad"],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "SetDirectory", "[", 
   "\"\<C:\\\\Users\\\\Rickels\\\\Dropbox\\\\Historic_DICE_Dropbox\\\\Data_\
1960_2019\\\\SI_SpinUp\>\"", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.8241808193512616`*^9, 3.824180820761224*^9}, {
  3.831173359438088*^9, 3.8311733741053286`*^9}, {3.8311842771845646`*^9, 
  3.8311842840717587`*^9}},
 CellLabel->
  "In[178]:=",ExpressionUUID->"71510dd2-2def-4f9f-b96e-bdf21b72f1d2"],

Cell["Fair Carbon Cycle Setup", "Text",
 CellChangeTimes->{{3.71113575119866*^9, 3.7111357648642597`*^9}, {
  3.711171131470954*^9, 3.711171132484956*^9}, {3.712408724609439*^9, 
  3.7124087395614595`*^9}, {3.7662479249546547`*^9, 3.7662479290036545`*^9}, {
  3.810276061054193*^9, 3.810276074321699*^9}},
 FontSize->18,
 Background->RGBColor[
  0.87, 0.94, 1],ExpressionUUID->"f703d587-e791-4118-b11d-f6f4e4ac5987"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"parFair", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"q1", "\[Rule]", "0.33"}], ",", 
     RowBox[{"q2", "\[Rule]", "0.41"}], ",", 
     RowBox[{"d1", "\[Rule]", "239"}], ",", 
     RowBox[{"d2", "\[Rule]", "4.1"}], ",", 
     RowBox[{"r0", "\[Rule]", "35"}], 
     RowBox[{"(*", "32.4", "*)"}], ",", 
     RowBox[{"rc", "\[Rule]", "0.019"}], ",", 
     RowBox[{"rT", "\[Rule]", "4.165"}], ",", 
     RowBox[{"F2x", "\[Rule]", "3.71"}], ",", 
     RowBox[{"\[Tau]1", "\[Rule]", 
      RowBox[{"10", "^", "6"}]}], ",", 
     RowBox[{"\[Tau]2", "\[Rule]", "394.4"}], ",", 
     RowBox[{"\[Tau]3", "\[Rule]", "36.54"}], ",", 
     RowBox[{"\[Tau]4", "\[Rule]", "4.304"}]}], " ", "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"aFair", "=", 
   RowBox[{"{", 
    RowBox[{"0.2173", ",", "0.2240", ",", "0.2824", ",", "0.2763"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Tau]Fair", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"10", "^", "6"}], ",", "394.4", ",", "36.54", ",", "4.304"}], 
    "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"rirf", "[", 
    RowBox[{"Cacc_", ",", "T_"}], "]"}], "=", 
   RowBox[{
    RowBox[{"r0", "+", 
     RowBox[{"rc", "*", "Cacc"}], "+", 
     RowBox[{"rT", "*", "T"}]}], "/.", "parFair"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fn", "[", 
    RowBox[{"\[Alpha]_", ",", "ai_", ",", "\[Tau]i_"}], "]"}], "=", 
   RowBox[{"\[Alpha]", "*", "ai", "*", "\[Tau]i", "*", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"Exp", "[", 
       RowBox[{
        RowBox[{"-", "100"}], "/", 
        RowBox[{"(", 
         RowBox[{"\[Alpha]", "*", "\[Tau]i"}], ")"}]}], "]"}]}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"lirf", "[", "\[Alpha]_", "]"}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"fn", "[", 
       RowBox[{"\[Alpha]", ",", 
        RowBox[{"aFair", "[", 
         RowBox[{"[", "1", "]"}], "]"}], ",", "\[Tau]1"}], "]"}], "+", 
      RowBox[{"fn", "[", 
       RowBox[{"\[Alpha]", ",", 
        RowBox[{"aFair", "[", 
         RowBox[{"[", "2", "]"}], "]"}], ",", "\[Tau]2"}], "]"}], "+", 
      RowBox[{"fn", "[", 
       RowBox[{"\[Alpha]", ",", 
        RowBox[{"aFair", "[", 
         RowBox[{"[", "3", "]"}], "]"}], ",", "\[Tau]3"}], "]"}], "+", 
      RowBox[{"fn", "[", 
       RowBox[{"\[Alpha]", ",", 
        RowBox[{"aFair", "[", 
         RowBox[{"[", "4", "]"}], "]"}], ",", "\[Tau]4"}], "]"}]}], "/.", 
     "parFair"}], "//", "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dalpha", "[", "\[Alpha]_", "]"}], "=", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"lirf", "[", "\[Alpha]", "]"}], ",", "\[Alpha]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dr", "[", 
    RowBox[{"ai_", ",", "\[Tau]i_", ",", "\[Alpha]_", ",", "e_", ",", "R_"}], 
    "]"}], "=", 
   RowBox[{
    RowBox[{"ai", "*", "e"}], "-", 
    RowBox[{"R", "/", 
     RowBox[{"(", 
      RowBox[{"\[Alpha]", "*", "\[Tau]i"}], ")"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"parPG", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Lambda]g", "->", "1.18"}], ",", 
     RowBox[{"upperc", "->", "8.2"}], ",", 
     RowBox[{"lowerc", "->", "109.0"}], ",", 
     RowBox[{"\[Beta]", "->", "0.67"}], ",", 
     RowBox[{"eff", "->", "1.28"}], ",", 
     RowBox[{"dt", "->", "1"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"cdeepp", "=", 
   RowBox[{
    RowBox[{"lowerc", "*", "eff"}], "/.", "parPG"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gammap", "=", 
   RowBox[{
    RowBox[{"\[Beta]", "*", "eff"}], "/.", "parPG"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g1", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"\[Lambda]g", "+", "gammap"}], ")"}], "/", "upperc"}], "/.", 
    "parPG"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g2", "=", 
   RowBox[{"gammap", "/", "cdeepp"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"g1", "+", "g2"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"gstar", "=", 
   RowBox[{"g1", "-", "g2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"delsqrt", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"g", "*", "g"}], "-", 
       RowBox[{"4", "*", "g2", "*", 
        RowBox[{"\[Lambda]g", "/", "upperc"}]}]}], ")"}], "^", "0.5"}], "/.", 
    "parPG"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"afast", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"g", "+", "delsqrt"}], ")"}], "/", "2"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"aslow", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"g", "-", "delsqrt"}], ")"}], "/", "2"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"cc", "=", 
   RowBox[{
    RowBox[{"0.5", "/", 
     RowBox[{"(", 
      RowBox[{"upperc", "*", "delsqrt"}], ")"}]}], "/.", "parPG"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"amixf", "=", 
   RowBox[{"cc", "*", 
    RowBox[{"(", 
     RowBox[{"gstar", "+", "delsqrt"}], ")"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"amixs", "=", 
   RowBox[{
    RowBox[{"-", "cc"}], "*", 
    RowBox[{"(", 
     RowBox[{"gstar", "-", "delsqrt"}], ")"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"adeepf", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "gammap"}], "/", 
     RowBox[{"(", 
      RowBox[{"upperc", "*", "cdeepp", "*", "delsqrt"}], ")"}]}], "/.", 
    "parPG"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"adeeps", "=", 
   RowBox[{"-", "adeepf"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"adf", "=", 
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"afast", "*", "1"}], ")"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"ads", "=", 
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"aslow", "*", "1"}], ")"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"expf", "=", 
   RowBox[{"Exp", "[", 
    RowBox[{
     RowBox[{"-", "1"}], "/", "adf"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"exps", "=", 
   RowBox[{"Exp", "[", 
    RowBox[{
     RowBox[{"-", "1"}], "/", "ads"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"intf", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"f0", "*", "adf"}], "+", 
      RowBox[{"f1", "*", 
       RowBox[{"(", 
        RowBox[{"1", "-", "adf"}], ")"}]}], "-", 
      RowBox[{"expf", "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"f0", "*", 
          RowBox[{"(", 
           RowBox[{"1", "+", "adf"}], ")"}]}], "-", 
         RowBox[{"f1", "*", "adf"}]}], ")"}]}]}], ")"}], "/", "afast"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"ints", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"f0", "*", "ads"}], "+", 
      RowBox[{"f1", "*", 
       RowBox[{"(", 
        RowBox[{"1", "-", "ads"}], ")"}]}], "-", 
      RowBox[{"exps", "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"f0", "*", 
          RowBox[{"(", 
           RowBox[{"1", "+", "ads"}], ")"}]}], "-", 
         RowBox[{"f1", "*", "ads"}]}], ")"}]}]}], ")"}], "/", "aslow"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.810277248743802*^9, 3.8102773313886356`*^9}, {
  3.810277381764123*^9, 3.810277400477229*^9}, {3.810277857843212*^9, 
  3.810277859394146*^9}, {3.813333362695059*^9, 3.8133334744113755`*^9}, {
  3.813549386661647*^9, 3.813549387362056*^9}},
 CellLabel->
  "In[179]:=",ExpressionUUID->"e2867d17-67ce-400c-8e50-5ca3eff26e6c"],

Cell["Fair Carbon Cycle Spin-up", "Text",
 CellChangeTimes->{{3.71113575119866*^9, 3.7111357648642597`*^9}, {
  3.711171131470954*^9, 3.711171132484956*^9}, {3.712408724609439*^9, 
  3.7124087395614595`*^9}, {3.7662479249546547`*^9, 3.7662479290036545`*^9}, {
  3.810276061054193*^9, 3.810276074321699*^9}, {3.8227995602020345`*^9, 
  3.8227995659345427`*^9}},
 FontSize->18,
 Background->RGBColor[
  0.87, 0.94, 1],ExpressionUUID->"e3ce86a0-f9e3-4e92-9220-6d4ace1602d8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dalpha", "[", "0.491714646", "]"}]], "Input",
 CellChangeTimes->{{3.824224476472345*^9, 3.824224498094448*^9}},
 CellLabel->
  "In[2037]:=",ExpressionUUID->"fe1cd5a5-8a5e-44be-8c44-9a2df8048964"],

Cell[BoxData["19.644795466098003`"], "Output",
 CellChangeTimes->{3.8242245003369226`*^9},
 CellLabel->
  "Out[2037]=",ExpressionUUID->"a4f8cda3-668a-44cf-8ca8-85d7e58d40cc"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Import", "[", "\"\<hist_emissions_3.csv\>\"", "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.831184072986274*^9, 3.831184097552437*^9}, {
  3.8311842327609935`*^9, 3.8311842352948065`*^9}, {3.8316610941384273`*^9, 
  3.831661094598428*^9}, {3.833461259229766*^9, 3.8334612596995316`*^9}},
 CellLabel->
  "In[208]:=",ExpressionUUID->"9e535e12-e998-42b7-a958-92111de62308"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dimensions", "[", "data", "]"}]], "Input",
 CellChangeTimes->{{3.831184103881863*^9, 3.831184107922657*^9}},
 CellLabel->
  "In[209]:=",ExpressionUUID->"acb51b51-9bd9-46b7-83fa-e14b0de3a1f5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"256", ",", "13"}], "}"}]], "Output",
 CellChangeTimes->{3.8311841091016846`*^9, 3.831184199725914*^9, 
  3.8311843000624905`*^9, 3.831661102619439*^9, 3.8316626217561445`*^9, 
  3.8316626805672817`*^9, 3.831662977436762*^9, 3.833461261767647*^9},
 CellLabel->
  "Out[209]=",ExpressionUUID->"0fd7274a-9d14-4bdd-a9d0-042d14573637"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"y", "=", "255"}], ",", "\[IndentingNewLine]", 
      RowBox[{"transFairG", "=", 
       RowBox[{"Table", "[", 
        RowBox[{"0", ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "y"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"j", ",", "20"}], "}"}]}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transFairG", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "=", 
       RowBox[{"{", 
        RowBox[{
        "\"\<1-Y\>\"", ",", "\"\<2-E\>\"", ",", "\"\<3-R1\>\"", ",", 
         "\"\<4-R2\>\"", ",", "\"\<5-R3\>\"", ",", "\"\<6-R4\>\"", ",", 
         "\"\<7-C\>\"", ",", "\"\<8-CCA\>\"", ",", "\"\<9-F\>\"", ",", 
         "\"\<10-Fex\>\"", ",", "\"\<11-TF\>\"", ",", "\"\<12-TMF\>\"", ",", 
         "\"\<13-TMS\>\"", ",", "\"\<14-TDF\>\"", ",", "\"\<15-TDS\>\"", ",", 
         "\"\<16-TM\>\"", ",", "\"\<17-TD\>\"", ",", "\"\<18-\[Alpha]\>\"", 
         ",", "\"\<19-\[Alpha]check\>\"", ",", "\"\<20-atmosGt\>\""}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"transFairG", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"n", "+", "1"}], ",", "1"}], "]"}], "]"}], "=", 
         RowBox[{"1765", "-", "1", "+", "n"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"n", ",", "1", ",", 
          RowBox[{"y", "-", "1"}]}], "}"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"emcolumns", "=", 
       RowBox[{"{", "5", "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{
         RowBox[{"transFairG", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;"}], ",", "2"}], "]"}], "]"}], "=", 
         RowBox[{
          RowBox[{"dtemp", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"2", ";;"}], ",", "3"}], "]"}], "]"}], "/", "2.12"}]}], 
        ","}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transFairG", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;", "y"}], ",", "2"}], "]"}], "]"}], "=", 
       RowBox[{
        RowBox[{"data", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"3", ";;"}], ",", 
           RowBox[{"emcolumns", "[", 
            RowBox[{"[", "k", "]"}], "]"}]}], "]"}], "]"}], "/", 
        "2.1293970467500096"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transFairG", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", 
          RowBox[{"{", 
           RowBox[{"3", ",", "4", ",", "5", ",", "6"}], "}"}]}], "]"}], "]"}],
        "=", "0"}], ",", " ", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{
        "initial", " ", "carbon", " ", "values", " ", "for", " ", "R1"}], ",",
         "R2", ",", "R3", ",", "R4"}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transFairG", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "7"}], "]"}], "]"}], "=", 
       RowBox[{
        RowBox[{"Total", "[", 
         RowBox[{"transFairG", "[", 
          RowBox[{"[", 
           RowBox[{"2", ",", 
            RowBox[{"3", ";;", "6"}]}], "]"}], "]"}], "]"}], "+", 
        "278.0014091894"}]}], ",", " ", 
      RowBox[{"(*", 
       RowBox[{
       "initial", " ", "atmospheric", " ", "carbon", " ", "concentration"}], 
       "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transFairG", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "8"}], "]"}], "]"}], "=", "0"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transFairG", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "9"}], "]"}], "]"}], "=", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"F2x", "/", 
           RowBox[{"Log", "[", "2", "]"}]}], ")"}], "*", 
         RowBox[{"Log", "[", 
          RowBox[{
           RowBox[{"transFairG", "[", 
            RowBox[{"[", 
             RowBox[{"2", ",", "7"}], "]"}], "]"}], "/", "278"}], "]"}]}], "/.",
         "parFair"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"fexcolumns", "=", 
       RowBox[{"{", "6", "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transFairG", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", "10"}], "]"}], "]"}], "=", 
       RowBox[{"data", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"3", ";;"}], ",", 
          RowBox[{"fexcolumns", "[", 
           RowBox[{"[", "k", "]"}], "]"}]}], "]"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transFairG", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", "11"}], "]"}], "]"}], "=", 
       RowBox[{"Total", "[", 
        RowBox[{"transFairG", "[", 
         RowBox[{"[", 
          RowBox[{"2", ",", 
           RowBox[{"9", ";;", "10"}]}], "]"}], "]"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transFairG", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", 
          RowBox[{"{", 
           RowBox[{"12", ",", "13", ",", "14", ",", "15"}], "}"}]}], "]"}], 
        "]"}], "=", "0"}], ",", " ", 
      RowBox[{"(*", 
       RowBox[{
       "initial", " ", "values", " ", "for", " ", "Mix", " ", "Layer", " ", 
        "Fast", " ", "and", " ", "Slow", " ", "Response", " ", "and", " ", 
        "Deep", " ", "Layer", " ", "Fast", " ", "and", " ", "Slow", " ", 
        "Response"}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transFairG", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "16"}], "]"}], "]"}], "=", 
       RowBox[{"Total", "[", 
        RowBox[{"transFairG", "[", 
         RowBox[{"[", 
          RowBox[{"2", ",", 
           RowBox[{"12", ";;", "13"}]}], "]"}], "]"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transFairG", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "17"}], "]"}], "]"}], "=", 
       RowBox[{"Total", "[", 
        RowBox[{"transFairG", "[", 
         RowBox[{"[", 
          RowBox[{"2", ",", 
           RowBox[{"14", ";;", "15"}]}], "]"}], "]"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transFairG", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", "18"}], "]"}], "]"}], "=", 
       RowBox[{
        RowBox[{"FindRoot", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"rirf", "[", 
            RowBox[{
             RowBox[{"transFairG", "[", 
              RowBox[{"[", 
               RowBox[{"2", ",", "8"}], "]"}], "]"}], ",", 
             RowBox[{"transFairG", "[", 
              RowBox[{"[", 
               RowBox[{"2", ",", "16"}], "]"}], "]"}]}], "]"}], "\[Equal]", 
           RowBox[{"lirf", "[", "\[Alpha]", "]"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"\[Alpha]", ",", "0.2"}], "}"}]}], "]"}], "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", "2"}], "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transFairG", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "19"}], "]"}], "]"}], "=", 
       RowBox[{"transFairG", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "18"}], "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"transFairG", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", 
              RowBox[{"3", ";;", "6"}]}], "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{"transFairG", "[", 
             RowBox[{"[", 
              RowBox[{
               RowBox[{"i", "-", "1"}], ",", 
               RowBox[{"3", ";;", "6"}]}], "]"}], "]"}], "+", 
            RowBox[{"dr", "[", 
             RowBox[{"aFair", ",", "\[Tau]Fair", ",", 
              RowBox[{"transFairG", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "-", "1"}], ",", "18"}], "]"}], "]"}], ",", 
              RowBox[{"transFairG", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "-", "1"}], ",", "2"}], "]"}], "]"}], ",", 
              RowBox[{"transFairG", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "-", "1"}], ",", 
                 RowBox[{"3", ";;", "6"}]}], "]"}], "]"}]}], "]"}]}]}], ",", 
          RowBox[{
           RowBox[{"transFairG", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "7"}], "]"}], "]"}], "=", 
           RowBox[{"278.0014091894", "+", 
            RowBox[{"Total", "[", 
             RowBox[{"transFairG", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", 
                RowBox[{"3", ";;", "6"}]}], "]"}], "]"}], "]"}]}]}], ",", 
          RowBox[{
           RowBox[{"transFairG", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "8"}], "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{"transFairG", "[", 
             RowBox[{"[", 
              RowBox[{
               RowBox[{"i", "-", "1"}], ",", "8"}], "]"}], "]"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"transFairG", "[", 
                RowBox[{"[", 
                 RowBox[{
                  RowBox[{"i", "-", "1"}], ",", "2"}], "]"}], "]"}], "-", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"transFairG", "[", 
                  RowBox[{"[", 
                   RowBox[{"i", ",", "7"}], "]"}], "]"}], "-", 
                 RowBox[{"transFairG", "[", 
                  RowBox[{"[", 
                   RowBox[{
                    RowBox[{"i", "-", "1"}], ",", "7"}], "]"}], "]"}]}], 
                ")"}]}], ")"}], "*", "2.12"}]}]}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"transFairG", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "9"}], "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"F2x", "/", 
               RowBox[{"Log", "[", "2", "]"}]}], ")"}], "*", 
             RowBox[{"Log", "[", 
              RowBox[{
               RowBox[{"transFairG", "[", 
                RowBox[{"[", 
                 RowBox[{"i", ",", "7"}], "]"}], "]"}], "/", 
               "278.0014091894"}], "]"}]}], "/.", "parFair"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"transFairG", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "11"}], "]"}], "]"}], "=", 
           RowBox[{"Total", "[", 
            RowBox[{"transFairG", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", 
               RowBox[{"9", ";;", "10"}]}], "]"}], "]"}], "]"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"transFairG", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "12"}], "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"expf", "*", 
               RowBox[{"transFairG", "[", 
                RowBox[{"[", 
                 RowBox[{
                  RowBox[{"i", "-", "1"}], ",", "12"}], "]"}], "]"}]}], "+", 
              RowBox[{"amixf", "*", "intf"}]}], "/.", 
             RowBox[{"f0", "\[Rule]", 
              RowBox[{"transFairG", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "-", "1"}], ",", "11"}], "]"}], "]"}]}]}], "/.", 
            RowBox[{"f1", "\[Rule]", 
             RowBox[{"transFairG", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "11"}], "]"}], "]"}]}]}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"transFairG", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "13"}], "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"exps", "*", 
               RowBox[{"transFairG", "[", 
                RowBox[{"[", 
                 RowBox[{
                  RowBox[{"i", "-", "1"}], ",", "13"}], "]"}], "]"}]}], "+", 
              RowBox[{"amixs", "*", "ints"}]}], "/.", 
             RowBox[{"f0", "\[Rule]", 
              RowBox[{"transFairG", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "-", "1"}], ",", "11"}], "]"}], "]"}]}]}], "/.", 
            RowBox[{"f1", "\[Rule]", 
             RowBox[{"transFairG", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "11"}], "]"}], "]"}]}]}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"transFairG", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "14"}], "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"expf", "*", 
               RowBox[{"transFairG", "[", 
                RowBox[{"[", 
                 RowBox[{
                  RowBox[{"i", "-", "1"}], ",", "14"}], "]"}], "]"}]}], "+", 
              RowBox[{"adeepf", "*", "intf"}]}], "/.", 
             RowBox[{"f0", "\[Rule]", 
              RowBox[{"transFairG", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "-", "1"}], ",", "11"}], "]"}], "]"}]}]}], "/.", 
            RowBox[{"f1", "\[Rule]", 
             RowBox[{"transFairG", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "11"}], "]"}], "]"}]}]}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"transFairG", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "15"}], "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"exps", "*", 
               RowBox[{"transFairG", "[", 
                RowBox[{"[", 
                 RowBox[{
                  RowBox[{"i", "-", "1"}], ",", "15"}], "]"}], "]"}]}], "+", 
              RowBox[{"adeeps", "*", "ints"}]}], "/.", 
             RowBox[{"f0", "\[Rule]", 
              RowBox[{"transFairG", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "-", "1"}], ",", "11"}], "]"}], "]"}]}]}], "/.", 
            RowBox[{"f1", "\[Rule]", 
             RowBox[{"transFairG", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "11"}], "]"}], "]"}]}]}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"transFairG", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "16"}], "]"}], "]"}], "=", 
           RowBox[{"Total", "[", 
            RowBox[{"transFairG", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", 
               RowBox[{"12", ";;", "13"}]}], "]"}], "]"}], "]"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"transFairG", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "17"}], "]"}], "]"}], "=", 
           RowBox[{"Total", "[", 
            RowBox[{"transFairG", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", 
               RowBox[{"14", ";;", "15"}]}], "]"}], "]"}], "]"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"(*", 
           RowBox[{
            RowBox[{
             RowBox[{"transFairG", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", 
                RowBox[{"{", 
                 RowBox[{"11", ",", "12"}], "}"}]}], "]"}], "]"}], "=", 
             RowBox[{
              RowBox[{
               RowBox[{"transT", ".", 
                RowBox[{"transFairG", "[", 
                 RowBox[{"[", 
                  RowBox[{
                   RowBox[{"i", "-", "1"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"11", ",", "12"}], "}"}]}], "]"}], "]"}]}], "+", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"1", ",", "0"}], "}"}], "*", "xi1", "*", 
                RowBox[{"Total", "[", 
                 RowBox[{"transFairG", "[", 
                  RowBox[{"[", 
                   RowBox[{"i", ",", 
                    RowBox[{"9", ";;", "10"}]}], "]"}], "]"}], "]"}]}]}], "/.",
               "parTG"}]}], ","}], "\[IndentingNewLine]", 
           RowBox[{"(*", 
            RowBox[{
             RowBox[{
              RowBox[{"transFairG", "[", 
               RowBox[{"[", 
                RowBox[{"i", ",", "13"}], "]"}], "]"}], "=", 
              RowBox[{"Total", "[", 
               RowBox[{"transFairG", "[", 
                RowBox[{"[", 
                 RowBox[{"i", ",", 
                  RowBox[{"11", ";;", "12"}]}], "]"}], "]"}], "]"}]}], ","}], 
            "*)"}], "*)"}], "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"transFairG", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "18"}], "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{"FindRoot", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"rirf", "[", 
                RowBox[{
                 RowBox[{"transFairG", "[", 
                  RowBox[{"[", 
                   RowBox[{"i", ",", "8"}], "]"}], "]"}], ",", 
                 RowBox[{"transFairG", "[", 
                  RowBox[{"[", 
                   RowBox[{"i", ",", "16"}], "]"}], "]"}]}], "]"}], 
               "\[Equal]", 
               RowBox[{"lirf", "[", "\[Alpha]", "]"}]}], ",", 
              RowBox[{"{", 
               RowBox[{"\[Alpha]", ",", 
                RowBox[{"transFairG", "[", 
                 RowBox[{"[", 
                  RowBox[{
                   RowBox[{"i", "-", "1"}], ",", "18"}], "]"}], "]"}]}], 
               "}"}]}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "2"}], "]"}], "]"}]}], ",", 
          RowBox[{
           RowBox[{"transFairG", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "19"}], "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{
             RowBox[{"transFairG", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"i", "-", "1"}], ",", "19"}], "]"}], "]"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"rT", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"transFairG", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "16"}], "]"}], "]"}], "-", 
                   RowBox[{"transFairG", "[", 
                    RowBox[{"[", 
                    RowBox[{
                    RowBox[{"i", "-", "1"}], ",", "16"}], "]"}], "]"}]}], 
                  ")"}]}], "+", 
                RowBox[{"rc", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"transFairG", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "8"}], "]"}], "]"}], "-", 
                   RowBox[{"transFairG", "[", 
                    RowBox[{"[", 
                    RowBox[{
                    RowBox[{"i", "-", "1"}], ",", "8"}], "]"}], "]"}]}], 
                  ")"}]}]}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{"dalpha", "[", 
                RowBox[{"transFairG", "[", 
                 RowBox[{"[", 
                  RowBox[{
                   RowBox[{"i", "-", "1"}], ",", "19"}], "]"}], "]"}], "]"}], 
               ")"}]}]}], "/.", "parFair"}]}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "3", ",", "255"}], "}"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transFairG", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", "20"}], "]"}], "]"}], "=", 
       RowBox[{
        RowBox[{"transFairG", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;"}], ",", "7"}], "]"}], "]"}], "*", "2.12"}]}]}], 
     "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", "1", ",", "1"}], "}"}]}], "]"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->CompressedData["
1:eJwdz2tIU2EAxvHh2rqMLtIUUyS0EPEyJ8RKAvPQhXJddF20ZObUnDNiaZKV
ozJz2WZEpiWmYUa6KEdnTi1MMws0tKXbtAshIoXLTscCpSa0ep/3w8Pv6/8J
y9arjvkJBIJ4MnjHP7q8ModjmpJ0T+CCsugwS5RHj1PdXX2t7UTBlRGqUeSN
c+dyjCdCIoe+d440r5Zjboan5cLLif5FcEJ4gCp1tzVn6Dim/ofRBvsLRd3w
nCF3CFbmP7eribtTA3uheHP8APxc1kudUH6fhoHPpDw0Jn+NyCTabz+NhMKZ
jzFw7tOfdDh9NysLBjXc0sDI4CN5sP/vVh18zXbWwVWmcerSB0PdsOXNsj5o
VW8q0KBXbC2B/KLZi3CQjS2DbudALZzQj1FFppBhGzHddoPqehw1CauU81Rb
T8E8/CV54YOetyGh7USZ40s4bHilkMEp3qeAoRmXjsP87vfUoKRvWjv6Vv6m
GnTJ2Q/1HFN8MJXK/gw4BRXWxmLIyydXjxB3XddIoS1gY43jJMcE29Oo+ySS
LbpSjlkSFUT9sEGYscZA/sQcVUOXuDoPDvvU+VC+zvOolFioqmiDkzuUHVA8
aOmEYcUtJ5afJ53hFXrIX+s7Ddc7t52Fi/dYm1YQ5xtj70FPXM4oHJR1OWFm
zb+AUSPHzFi6AqFpuzkhxcwxKld1IrSYX5ZoiQtTbDmc9dt7FSrrmmqhOftQ
M/Ro+y0w01vPwjNzrdSq/XwHlMtknTDhvqkHcmtZaqSvfmdKFcdcGHMq4X8r
CZi0
  "],
 CellLabel->
  "In[210]:=",ExpressionUUID->"d89c5852-c7fb-45f8-b606-2af1c7082687"],

Cell[BoxData[
 TemplateBox[{
  "FindRoot", "lstol", 
   "\"The line search decreased the step size to within tolerance specified \
by AccuracyGoal and PrecisionGoal but was unable to find a sufficient \
decrease in the merit function. You may need more than \
\\!\\(\\*RowBox[{\\\"MachinePrecision\\\"}]\\) digits of working precision to \
meet these tolerances.\"", 2, 210, 45, 18008878885229653641, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.8334612691550117`*^9},
 CellLabel->
  "During evaluation of \
In[210]:=",ExpressionUUID->"0b16895b-7e46-4bbc-96fe-da0d9a39f43c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"transFairG", "[", 
   RowBox[{"[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "2", ",", "197", ",", "247", ",", "251", ",", "252", ",", 
      "253", ",", "254", ",", "255"}], "}"}], "]"}], "]"}], "//", 
  "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.812610320252155*^9, 3.8126103463259954`*^9}, {
  3.8126104820408783`*^9, 3.8126104826246424`*^9}, {3.8126105132640886`*^9, 
  3.812610520476856*^9}, {3.8133407106776934`*^9, 3.8133407307417655`*^9}, {
  3.813514094220465*^9, 3.8135140948207846`*^9}, {3.816718726108967*^9, 
  3.816718726338008*^9}, {3.8231536821488037`*^9, 3.8231536841888065`*^9}, {
  3.8241842101302752`*^9, 3.82418421268314*^9}, {3.831184733311742*^9, 
  3.831184734932646*^9}, {3.8311848435235987`*^9, 3.8311848453155003`*^9}},
 CellLabel->
  "In[193]:=",ExpressionUUID->"70226d3f-4f0d-4604-bcb2-050673ad408b"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"\<\"1-Y\"\>", "\<\"2-E\"\>", "\<\"3-R1\"\>", "\<\"4-R2\"\>", "\<\"5-R3\
\"\>", "\<\"6-R4\"\>", "\<\"7-C\"\>", "\<\"8-CCA\"\>", "\<\"9-F\"\>", \
"\<\"10-Fex\"\>", "\<\"11-TF\"\>", "\<\"12-TMF\"\>", "\<\"13-TMS\"\>", \
"\<\"14-TDF\"\>", "\<\"15-TDS\"\>", "\<\"16-TM\"\>", "\<\"17-TD\"\>", \
"\<\"18-\[Alpha]\"\>", "\<\"19-\[Alpha]check\"\>", "\<\"20-atmosGt\"\>"},
     {"1765", "0.0014088495166172733`", "0", "0", "0", "0", "278.0014091894`",
       "0", "0.00002713138222216843`", "0", "0.00002713138222216843`", "0", 
      "0", "0", "0", "0", "0", "0.16376976980682398`", "0.16376976980682398`",
       "589.3629874815281`"},
     {"1960", "1.7246695751762968`", "21.128016455610116`", 
      "12.041886991164457`", "3.4119549764376633`", "0.5061354237604159`", 
      "315.0894030363727`", "127.56488942971775`", "0.6702821347860664`", 
      RowBox[{"-", "0.09670858`"}], "0.5735735547860663`", 
      "0.2534828146212345`", "0.04053992541980838`", 
      RowBox[{"-", "0.006360514038650576`"}], "0.09495473705431338`", 
      "0.2940227400410429`", "0.0885942230156628`", "0.24914898566511132`", 
      "0.2489932388658875`", "667.9895344371101`"},
     {"2010", "4.60072395373719`", "54.395812785054716`", 
      "38.104457687986105`", "15.230256853137249`", "2.4708283156476973`", 
      "388.20276483122575`", "297.1779392615091`", "1.7871745114727609`", 
      "0.2547602`", "2.041934711472761`", "0.8979088044922683`", 
      "0.1077961260893991`", 
      RowBox[{"-", "0.02253076432394403`"}], "0.25248573356504406`", 
      "1.0057049305816674`", "0.22995496924110004`", "0.4900094318510931`", 
      "0.48781982781618194`", "822.9898614421986`"},
     {"2014", "4.849620232056403`", "58.5137321144719`", "41.55824290672556`",
       "17.12755978043411`", "2.8708721601886618`", "398.0718161512202`", 
      "316.4346986077009`", "1.9215445445769808`", "0.2990513`", 
      "2.2205958445769807`", "0.9821635382596897`", "0.11722840854548483`", 
      RowBox[{"-", "0.024644925071887522`"}], "0.2745785196559136`", 
      "1.0993919468051745`", "0.2499335945840261`", "0.5295702100541317`", 
      "0.5269445084677723`", "843.9122502405869`"},
     {"2015", "4.836184034216424`", "59.56744409802825`", 
      "42.44558365842843`", "17.611969990090504`", "2.95126459635369`", 
      "400.5776715323009`", "321.4034800917695`", "1.9551321973784577`", 
      "0.311306`", "2.2664381973784575`", "1.0035483905924911`", 
      "0.11971111363887513`", 
      RowBox[{"-", "0.025181524184851048`"}], "0.280393641585346`", 
      "1.1232595042313662`", "0.255212117400495`", "0.5400935034982736`", 
      "0.5373497873401497`", "849.2246636484779`"},
     {"2016", "4.831120159437196`", "60.61823659767921`", 
      "43.32962588869623`", "18.08528600716167`", "3.017902191781555`", 
      "403.0524598747187`", "326.4096389583826`", "1.9880978491591057`", 
      "0.3241427`", "2.312240549159106`", "1.0250736427620089`", 
      "0.12224421516035053`", 
      RowBox[{"-", "0.025721646278785863`"}], "0.28632680466872085`", 
      "1.1473178579223593`", "0.260605158389935`", "0.5508580494954226`", 
      "0.5479929193952289`", "854.4712149344036`"},
     {"2017", "4.880110553295034`", "61.667928965026725`", 
      "44.21235861029307`", "18.551096291605795`", "3.079843882713954`", 
      "405.51263693903957`", "331.4360383200292`", "2.020668854179594`", 
      "0.3375113`", "2.358180154179594`", "1.0467137007422491`", 
      "0.12482759871299468`", 
      RowBox[{"-", "0.026264649135946817`"}], "0.29237774095958796`", 
      "1.1715412994552439`", "0.2661130918236411`", "0.5618441408504795`", 
      "0.5588545439224608`", "859.686790310764`"},
     {"2018", "4.966369243415948`", "62.72826722840713`", 
      "45.10598131359999`", "19.025620873086613`", "3.154596336147857`", 
      "408.0158749406416`", "336.47500812961835`", "2.0536077608540353`", 
      "0.3513641`", "2.4049718608540354`", "1.0684974474811786`", 
      "0.1274617260629264`", 
      RowBox[{"-", "0.026811257501308416`"}], "0.29854753203074097`", 
      "1.195959173544105`", "0.27173627452943255`", "0.5730541419741644`", 
      "0.5699369560569854`", "864.9936548741603`"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.8126103403973227`*^9, 3.812610346905287*^9}, 
   3.812610483083152*^9, {3.812610517594801*^9, 3.8126105210978527`*^9}, {
   3.813340687561257*^9, 3.8133407315874386`*^9}, 3.8133462478810263`*^9, 
   3.8133463178110123`*^9, 3.8135078297700357`*^9, {3.8135140850713997`*^9, 
   3.813514095687074*^9}, 3.816638337925257*^9, 3.816718505834943*^9, 
   3.816718727291587*^9, 3.8169992505846715`*^9, {3.8171381834836793`*^9, 
   3.8171382049738493`*^9}, 3.81723972571554*^9, 3.818438724693569*^9, 
   3.8184389950529575`*^9, 3.81843925293132*^9, 3.8227641330424848`*^9, {
   3.8231536768662963`*^9, 3.823153684981308*^9}, 3.8233613965483255`*^9, 
   3.823361466285424*^9, {3.8241841970859747`*^9, 3.8241842134691486`*^9}, 
   3.824186642332016*^9, 3.8287792024368873`*^9, {3.831184720770644*^9, 
   3.8311847357422347`*^9}, 3.8311847846133537`*^9, {3.8311848206545286`*^9, 
   3.831184846091795*^9}, 3.8313892600405483`*^9, 3.8316611579305735`*^9, 
   3.831662691993305*^9, 3.8316629863167744`*^9},
 CellLabel->
  "Out[193]//MatrixForm=",ExpressionUUID->"1bd70009-54bf-4fe6-81e7-\
f62683c6e036"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"transFairG", "[", 
   RowBox[{"[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "2", ",", "197", ",", "247", ",", "251", ",", "252", ",", 
      "253", ",", "254", ",", "255"}], "}"}], "]"}], "]"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabel->
  "In[211]:=",ExpressionUUID->"4936d59b-3285-4e53-b061-3c63fd919940"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"\<\"1-Y\"\>", "\<\"2-E\"\>", "\<\"3-R1\"\>", "\<\"4-R2\"\>", "\<\"5-R3\
\"\>", "\<\"6-R4\"\>", "\<\"7-C\"\>", "\<\"8-CCA\"\>", "\<\"9-F\"\>", \
"\<\"10-Fex\"\>", "\<\"11-TF\"\>", "\<\"12-TMF\"\>", "\<\"13-TMS\"\>", \
"\<\"14-TDF\"\>", "\<\"15-TDS\"\>", "\<\"16-TM\"\>", "\<\"17-TD\"\>", \
"\<\"18-\[Alpha]\"\>", "\<\"19-\[Alpha]check\"\>", "\<\"20-atmosGt\"\>"},
     {"1765", "0.0014088495166172733`", "0", "0", "0", "0", "278.0014091894`",
       "0", "0.00002713138222216843`", "0", "0.00002713138222216843`", "0", 
      "0", "0", "0", "0", "0", "0.16376976980682398`", "0.16376976980682398`",
       "589.3629874815281`"},
     {"1960", "1.9440543694367183`", "21.128016455610112`", 
      "12.041886991164318`", "3.4119549764373933`", "0.5061354237604038`", 
      "315.08940303637223`", "127.56488942971873`", "0.670282134786059`", 
      RowBox[{"-", "0.09670858`"}], "0.573573554786059`", 
      "0.25348281462123096`", "0.04053992541981935`", 
      RowBox[{"-", "0.0063605140386504885`"}], "0.09495473705433902`", 
      "0.29402274004105033`", "0.08859422301568853`", "0.24914898566485816`", 
      "0.2489932388658901`", "667.9895344371091`"},
     {"2010", "4.788646619738229`", "55.255065291487114`", 
      "38.91175936160823`", "15.72222900306456`", "2.5990289100800554`", 
      "390.48949175563996`", "300.7132380154914`", "1.8186105738524678`", 
      "0.2547602`", "2.073370773852468`", "0.9107089250729437`", 
      "0.10880268456715503`", 
      RowBox[{"-", "0.022851951173519847`"}], "0.2548433475615019`", 
      "1.0195116096400987`", "0.23199139638798205`", "0.49637062977917473`", 
      "0.49409424119701495`", "827.8377225219567`"},
     {"2014", "5.143603212334995`", "59.54455987967275`", 
      "42.535958213115435`", "17.773033235291617`", "3.036133584320898`", 
      "400.8910941018007`", "320.5149056954124`", "1.9593184181775172`", 
      "0.2990513`", "2.258369718177517`", "0.9974570033271861`", 
      "0.11839713460284598`", 
      RowBox[{"-", "0.025028676133697268`"}], "0.2773159710526798`", 
      "1.1158541379300322`", "0.25228729491898255`", "0.5374875821462191`", 
      "0.5347480742945276`", "849.8891194958176`"},
     {"2015", "5.160344186055423`", "60.6621540745772`", "43.48746991995442`",
       "18.32063680193661`", "3.1448689760066273`", "403.6165389618749`", 
      "325.64140140220536`", "1.9955833893591133`", "0.311306`", 
      "2.3068893893591134`", "1.0196250517435805`", "0.12092619954091943`", 
      RowBox[{"-", "0.025584927583613713`"}], "0.283239679438949`", 
      "1.1405512512845`", "0.2576547518553353`", "0.5484866288266986`", 
      "0.545620635651642`", "855.6670625991748`"},
     {"2016", "5.088904291728445`", "61.78338626705862`", 
      "44.442356870545765`", "18.863792177103523`", "3.2384879654617804`", 
      "406.3294324695697`", "330.8299968403298`", "2.0314389704259166`", 
      "0.3241427`", "2.3555816704259165`", "1.0420570707021535`", 
      "0.12350908979002721`", 
      RowBox[{"-", "0.026147802710728255`"}], "0.28928946028843083`", 
      "1.1655661604921808`", "0.2631416575777026`", "0.5597955270992065`", 
      "0.5567983011406457`", "861.4183968354879`"},
     {"2017", "5.125813631919348`", "62.88909480187713`", 
      "45.38097746798967`", "19.37868618199987`", "3.300424305760601`", 
      "408.9505919470273`", "336.061615846584`", "2.065855461056593`", 
      "0.3375113`", "2.403366761056593`", "1.0646528427190243`", 
      "0.1261451417472688`", 
      RowBox[{"-", "0.02671478680920534`"}], "0.29546375927564794`", 
      "1.190797984466293`", "0.2687489724664426`", "0.571377178971823`", 
      "0.5682446478590618`", "866.975254927698`"},
     {"2018", "5.231278481860207`", "64.00282403827833`", 
      "46.32778078214769`", "19.89803447676065`", "3.3746182959029634`", 
      "411.60466678248963`", "341.30170209507287`", "2.100480102911593`", 
      "0.3513641`", "2.451844202911593`", "1.0873681099312784`", 
      "0.1288340304791609`", 
      RowBox[{"-", "0.027284769339228656`"}], "0.30176181532437385`", 
      "1.2162021404104393`", "0.2744770459851452`", "0.583188489262328`", 
      "0.5799173728907888`", "872.601893578878`"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.833461280505788*^9},
 CellLabel->
  "Out[211]//MatrixForm=",ExpressionUUID->"26a6d597-f9d9-4e83-9e9e-\
fe9a420c12cb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<spinup2.csv\>\"", ",", "transFairG"}], "]"}]], "Input",
 CellChangeTimes->{{3.8316635963370724`*^9, 3.831663648968707*^9}},
 CellLabel->
  "In[194]:=",ExpressionUUID->"50503fb9-911f-4ebc-aa0b-00baddebab1b"],

Cell[BoxData["\<\"spinup2.csv\"\>"], "Output",
 CellChangeTimes->{3.8316636509907103`*^9},
 CellLabel->
  "Out[194]=",ExpressionUUID->"637b6c19-d0ae-4550-a01c-ff79853c4706"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"datafix", "=", 
   RowBox[{"Import", "[", "\"\<check_fix.csv\>\"", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.831389273822568*^9, 3.8313892916845927`*^9}},
 CellLabel->
  "In[173]:=",ExpressionUUID->"57b8f2eb-487d-4e04-9005-408f8299c0ed"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dimensions", "[", "datafix", "]"}]], "Input",
 CellChangeTimes->{{3.831389298805603*^9, 3.8313893097376184`*^9}},
 CellLabel->
  "In[174]:=",ExpressionUUID->"54a3d8e2-76ab-4073-a91f-79f9df44a22b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"242", ",", "21"}], "}"}]], "Output",
 CellChangeTimes->{3.8313893103176193`*^9, 3.831438170020144*^9, 
  3.8314421168216066`*^9},
 CellLabel->
  "Out[174]=",ExpressionUUID->"f8172fe4-4a70-49a0-b967-ee26bd468bf1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"datafix", "[", 
  RowBox[{"[", 
   RowBox[{"1", ",", "19"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.8314372999245853`*^9, 3.8314373039355907`*^9}, {
  3.8314381526650653`*^9, 
  3.8314381762311525`*^9}},ExpressionUUID->"1e9a9ce3-e972-4356-ae33-\
e2f4411cfda5"],

Cell[BoxData["\<\"Fex\"\>"], "Output",
 CellChangeTimes->{
  3.8314373049855924`*^9, {3.8314381447550545`*^9, 3.8314381660001383`*^9}},
 CellLabel->
  "Out[129]=",ExpressionUUID->"f80da4bf-43af-4c67-83d4-bd7f9ad3a0a6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dimensions", "[", 
  RowBox[{"transFairF", "[", 
   RowBox[{"[", 
    RowBox[{
     RowBox[{"2", ";;", "100"}], ",", "19"}], "]"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.831438667176901*^9, 3.831438682280922*^9}},
 CellLabel->
  "In[134]:=",ExpressionUUID->"bd5cf240-c9fc-47dd-8883-71e9110b0e08"],

Cell[BoxData[
 RowBox[{"{", "99", "}"}]], "Output",
 CellChangeTimes->{3.831438683010923*^9},
 CellLabel->
  "Out[134]=",ExpressionUUID->"f3488663-d8fe-431d-9df4-4ef694178ed1"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"y", "=", "100"}], ",", "\[IndentingNewLine]", 
      RowBox[{"transFairF", "=", 
       RowBox[{"Table", "[", 
        RowBox[{"0", ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "y"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"j", ",", "20"}], "}"}]}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transFairF", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "=", 
       RowBox[{"{", 
        RowBox[{
        "\"\<1-Y\>\"", ",", "\"\<2-E\>\"", ",", "\"\<3-R1\>\"", ",", 
         "\"\<4-R2\>\"", ",", "\"\<5-R3\>\"", ",", "\"\<6-R4\>\"", ",", 
         "\"\<7-C\>\"", ",", "\"\<8-CCA\>\"", ",", "\"\<9-F\>\"", ",", 
         "\"\<10-Fex\>\"", ",", "\"\<11-TF\>\"", ",", "\"\<12-TMF\>\"", ",", 
         "\"\<13-TMS\>\"", ",", "\"\<14-TDF\>\"", ",", "\"\<15-TDS\>\"", ",", 
         "\"\<16-TM\>\"", ",", "\"\<17-TD\>\"", ",", "\"\<18-\[Alpha]\>\"", 
         ",", "\"\<19-\[Alpha]check\>\"", ",", "\"\<20-atmosGt\>\""}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"transFairF", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"n", "+", "1"}], ",", "1"}], "]"}], "]"}], "=", 
         RowBox[{"1960", "-", "1", "+", "n"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"n", ",", "1", ",", 
          RowBox[{"y", "-", "1"}]}], "}"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{
         RowBox[{"transFairG", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;"}], ",", "2"}], "]"}], "]"}], "=", 
         RowBox[{
          RowBox[{"dtemp", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"2", ";;"}], ",", "3"}], "]"}], "]"}], "/", "2.12"}]}], 
        ","}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transFairF", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;", "y"}], ",", "2"}], "]"}], "]"}], "=", 
       RowBox[{
        RowBox[{"datafix", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;", "100"}], ",", "19"}], "]"}], "]"}], "/", 
        "2.1293970467500096"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transFairF", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", 
          RowBox[{"{", 
           RowBox[{"3", ",", "4", ",", "5", ",", "6"}], "}"}]}], "]"}], "]"}],
        "=", 
       RowBox[{"transFairG", "[", 
        RowBox[{"[", 
         RowBox[{"197", ",", 
          RowBox[{"3", ";;", "6"}]}], "]"}], "]"}]}], ",", " ", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{
        "initial", " ", "carbon", " ", "values", " ", "for", " ", "R1"}], ",",
         "R2", ",", "R3", ",", "R4"}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transFairF", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "7"}], "]"}], "]"}], "=", 
       RowBox[{
        RowBox[{"Total", "[", 
         RowBox[{"transFairG", "[", 
          RowBox[{"[", 
           RowBox[{"197", ",", 
            RowBox[{"3", ";;", "6"}]}], "]"}], "]"}], "]"}], "+", 
        "278.0014091894"}]}], ",", " ", 
      RowBox[{"(*", 
       RowBox[{
       "initial", " ", "atmospheric", " ", "carbon", " ", "concentration"}], 
       "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transFairF", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "8"}], "]"}], "]"}], "=", 
       RowBox[{"transFairG", "[", 
        RowBox[{"[", 
         RowBox[{"197", ",", "8"}], "]"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transFairF", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "9"}], "]"}], "]"}], "=", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"F2x", "/", 
           RowBox[{"Log", "[", "2", "]"}]}], ")"}], "*", 
         RowBox[{"Log", "[", 
          RowBox[{
           RowBox[{"transFairF", "[", 
            RowBox[{"[", 
             RowBox[{"2", ",", "7"}], "]"}], "]"}], "/", "278"}], "]"}]}], "/.",
         "parFair"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"fexcolumns", "=", 
       RowBox[{"{", "40", "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transFairF", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", "10"}], "]"}], "]"}], "=", 
       RowBox[{"datafix", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;", "100"}], ",", "21"}], "]"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transFairF", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", "11"}], "]"}], "]"}], "=", 
       RowBox[{"Total", "[", 
        RowBox[{"transFairF", "[", 
         RowBox[{"[", 
          RowBox[{"2", ",", 
           RowBox[{"9", ";;", "10"}]}], "]"}], "]"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transFairF", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", 
          RowBox[{"{", 
           RowBox[{"12", ",", "13", ",", "14", ",", "15"}], "}"}]}], "]"}], 
        "]"}], "=", 
       RowBox[{"transFairG", "[", 
        RowBox[{"[", 
         RowBox[{"197", ",", 
          RowBox[{"12", ";;", "15"}]}], "]"}], "]"}]}], ",", " ", 
      RowBox[{"(*", 
       RowBox[{
       "initial", " ", "values", " ", "for", " ", "Mix", " ", "Layer", " ", 
        "Fast", " ", "and", " ", "Slow", " ", "Response", " ", "and", " ", 
        "Deep", " ", "Layer", " ", "Fast", " ", "and", " ", "Slow", " ", 
        "Response"}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transFairF", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "16"}], "]"}], "]"}], "=", 
       RowBox[{"Total", "[", 
        RowBox[{"transFairF", "[", 
         RowBox[{"[", 
          RowBox[{"2", ",", 
           RowBox[{"12", ";;", "13"}]}], "]"}], "]"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transFairF", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "17"}], "]"}], "]"}], "=", 
       RowBox[{"Total", "[", 
        RowBox[{"transFairF", "[", 
         RowBox[{"[", 
          RowBox[{"2", ",", 
           RowBox[{"14", ";;", "15"}]}], "]"}], "]"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transFairF", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", "18"}], "]"}], "]"}], "=", 
       RowBox[{
        RowBox[{"FindRoot", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"rirf", "[", 
            RowBox[{
             RowBox[{"transFairF", "[", 
              RowBox[{"[", 
               RowBox[{"2", ",", "8"}], "]"}], "]"}], ",", 
             RowBox[{"transFairF", "[", 
              RowBox[{"[", 
               RowBox[{"2", ",", "16"}], "]"}], "]"}]}], "]"}], "\[Equal]", 
           RowBox[{"lirf", "[", "\[Alpha]", "]"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"\[Alpha]", ",", "0.2"}], "}"}]}], "]"}], "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", "2"}], "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transFairF", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "19"}], "]"}], "]"}], "=", 
       RowBox[{"transFairF", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "18"}], "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"transFairF", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", 
              RowBox[{"3", ";;", "6"}]}], "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{"transFairF", "[", 
             RowBox[{"[", 
              RowBox[{
               RowBox[{"i", "-", "1"}], ",", 
               RowBox[{"3", ";;", "6"}]}], "]"}], "]"}], "+", 
            RowBox[{"dr", "[", 
             RowBox[{"aFair", ",", "\[Tau]Fair", ",", 
              RowBox[{"transFairF", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "-", "1"}], ",", "18"}], "]"}], "]"}], ",", 
              RowBox[{"transFairF", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "-", "1"}], ",", "2"}], "]"}], "]"}], ",", 
              RowBox[{"transFairF", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "-", "1"}], ",", 
                 RowBox[{"3", ";;", "6"}]}], "]"}], "]"}]}], "]"}]}]}], ",", 
          RowBox[{
           RowBox[{"transFairF", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "7"}], "]"}], "]"}], "=", 
           RowBox[{"278.0014091894", "+", 
            RowBox[{"Total", "[", 
             RowBox[{"transFairF", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", 
                RowBox[{"3", ";;", "6"}]}], "]"}], "]"}], "]"}]}]}], ",", 
          RowBox[{
           RowBox[{"transFairF", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "8"}], "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{"transFairF", "[", 
             RowBox[{"[", 
              RowBox[{
               RowBox[{"i", "-", "1"}], ",", "8"}], "]"}], "]"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"transFairF", "[", 
                RowBox[{"[", 
                 RowBox[{
                  RowBox[{"i", "-", "1"}], ",", "2"}], "]"}], "]"}], "-", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"transFairF", "[", 
                  RowBox[{"[", 
                   RowBox[{"i", ",", "7"}], "]"}], "]"}], "-", 
                 RowBox[{"transFairF", "[", 
                  RowBox[{"[", 
                   RowBox[{
                    RowBox[{"i", "-", "1"}], ",", "7"}], "]"}], "]"}]}], 
                ")"}]}], ")"}], "*", "2.12"}]}]}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"transFairF", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "9"}], "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"F2x", "/", 
               RowBox[{"Log", "[", "2", "]"}]}], ")"}], "*", 
             RowBox[{"Log", "[", 
              RowBox[{
               RowBox[{"transFairF", "[", 
                RowBox[{"[", 
                 RowBox[{"i", ",", "7"}], "]"}], "]"}], "/", 
               "278.0014091894"}], "]"}]}], "/.", "parFair"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"transFairF", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "11"}], "]"}], "]"}], "=", 
           RowBox[{"Total", "[", 
            RowBox[{"transFairF", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", 
               RowBox[{"9", ";;", "10"}]}], "]"}], "]"}], "]"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"transFairF", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "12"}], "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"expf", "*", 
               RowBox[{"transFairF", "[", 
                RowBox[{"[", 
                 RowBox[{
                  RowBox[{"i", "-", "1"}], ",", "12"}], "]"}], "]"}]}], "+", 
              RowBox[{"amixf", "*", "intf"}]}], "/.", 
             RowBox[{"f0", "\[Rule]", 
              RowBox[{"transFairF", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "-", "1"}], ",", "11"}], "]"}], "]"}]}]}], "/.", 
            RowBox[{"f1", "\[Rule]", 
             RowBox[{"transFairF", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "11"}], "]"}], "]"}]}]}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"transFairF", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "13"}], "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"exps", "*", 
               RowBox[{"transFairF", "[", 
                RowBox[{"[", 
                 RowBox[{
                  RowBox[{"i", "-", "1"}], ",", "13"}], "]"}], "]"}]}], "+", 
              RowBox[{"amixs", "*", "ints"}]}], "/.", 
             RowBox[{"f0", "\[Rule]", 
              RowBox[{"transFairF", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "-", "1"}], ",", "11"}], "]"}], "]"}]}]}], "/.", 
            RowBox[{"f1", "\[Rule]", 
             RowBox[{"transFairF", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "11"}], "]"}], "]"}]}]}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"transFairF", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "14"}], "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"expf", "*", 
               RowBox[{"transFairF", "[", 
                RowBox[{"[", 
                 RowBox[{
                  RowBox[{"i", "-", "1"}], ",", "14"}], "]"}], "]"}]}], "+", 
              RowBox[{"adeepf", "*", "intf"}]}], "/.", 
             RowBox[{"f0", "\[Rule]", 
              RowBox[{"transFairF", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "-", "1"}], ",", "11"}], "]"}], "]"}]}]}], "/.", 
            RowBox[{"f1", "\[Rule]", 
             RowBox[{"transFairF", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "11"}], "]"}], "]"}]}]}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"transFairF", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "15"}], "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"exps", "*", 
               RowBox[{"transFairF", "[", 
                RowBox[{"[", 
                 RowBox[{
                  RowBox[{"i", "-", "1"}], ",", "15"}], "]"}], "]"}]}], "+", 
              RowBox[{"adeeps", "*", "ints"}]}], "/.", 
             RowBox[{"f0", "\[Rule]", 
              RowBox[{"transFairF", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "-", "1"}], ",", "11"}], "]"}], "]"}]}]}], "/.", 
            RowBox[{"f1", "\[Rule]", 
             RowBox[{"transFairF", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "11"}], "]"}], "]"}]}]}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"transFairF", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "16"}], "]"}], "]"}], "=", 
           RowBox[{"Total", "[", 
            RowBox[{"transFairF", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", 
               RowBox[{"12", ";;", "13"}]}], "]"}], "]"}], "]"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"transFairF", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "17"}], "]"}], "]"}], "=", 
           RowBox[{"Total", "[", 
            RowBox[{"transFairF", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", 
               RowBox[{"14", ";;", "15"}]}], "]"}], "]"}], "]"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"(*", 
           RowBox[{
            RowBox[{
             RowBox[{"transFairG", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", 
                RowBox[{"{", 
                 RowBox[{"11", ",", "12"}], "}"}]}], "]"}], "]"}], "=", 
             RowBox[{
              RowBox[{
               RowBox[{"transT", ".", 
                RowBox[{"transFairG", "[", 
                 RowBox[{"[", 
                  RowBox[{
                   RowBox[{"i", "-", "1"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"11", ",", "12"}], "}"}]}], "]"}], "]"}]}], "+", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"1", ",", "0"}], "}"}], "*", "xi1", "*", 
                RowBox[{"Total", "[", 
                 RowBox[{"transFairG", "[", 
                  RowBox[{"[", 
                   RowBox[{"i", ",", 
                    RowBox[{"9", ";;", "10"}]}], "]"}], "]"}], "]"}]}]}], "/.",
               "parTG"}]}], ","}], "\[IndentingNewLine]", 
           RowBox[{"(*", 
            RowBox[{
             RowBox[{
              RowBox[{"transFairG", "[", 
               RowBox[{"[", 
                RowBox[{"i", ",", "13"}], "]"}], "]"}], "=", 
              RowBox[{"Total", "[", 
               RowBox[{"transFairG", "[", 
                RowBox[{"[", 
                 RowBox[{"i", ",", 
                  RowBox[{"11", ";;", "12"}]}], "]"}], "]"}], "]"}]}], ","}], 
            "*)"}], "*)"}], "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"transFairF", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "18"}], "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{"FindRoot", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"rirf", "[", 
                RowBox[{
                 RowBox[{"transFairF", "[", 
                  RowBox[{"[", 
                   RowBox[{"i", ",", "8"}], "]"}], "]"}], ",", 
                 RowBox[{"transFairF", "[", 
                  RowBox[{"[", 
                   RowBox[{"i", ",", "16"}], "]"}], "]"}]}], "]"}], 
               "\[Equal]", 
               RowBox[{"lirf", "[", "\[Alpha]", "]"}]}], ",", 
              RowBox[{"{", 
               RowBox[{"\[Alpha]", ",", 
                RowBox[{"transFairF", "[", 
                 RowBox[{"[", 
                  RowBox[{
                   RowBox[{"i", "-", "1"}], ",", "18"}], "]"}], "]"}]}], 
               "}"}]}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "2"}], "]"}], "]"}]}], ",", 
          RowBox[{
           RowBox[{"transFairF", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "19"}], "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{
             RowBox[{"transFairF", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"i", "-", "1"}], ",", "19"}], "]"}], "]"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"rT", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"transFairF", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "16"}], "]"}], "]"}], "-", 
                   RowBox[{"transFairF", "[", 
                    RowBox[{"[", 
                    RowBox[{
                    RowBox[{"i", "-", "1"}], ",", "16"}], "]"}], "]"}]}], 
                  ")"}]}], "+", 
                RowBox[{"rc", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"transFairF", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "8"}], "]"}], "]"}], "-", 
                   RowBox[{"transFairF", "[", 
                    RowBox[{"[", 
                    RowBox[{
                    RowBox[{"i", "-", "1"}], ",", "8"}], "]"}], "]"}]}], 
                  ")"}]}]}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{"dalpha", "[", 
                RowBox[{"transFairF", "[", 
                 RowBox[{"[", 
                  RowBox[{
                   RowBox[{"i", "-", "1"}], ",", "19"}], "]"}], "]"}], "]"}], 
               ")"}]}]}], "/.", "parFair"}]}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "3", ",", "100"}], "}"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transFairF", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", "20"}], "]"}], "]"}], "=", 
       RowBox[{
        RowBox[{"transFairF", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;"}], ",", "7"}], "]"}], "]"}], "*", "2.12"}]}]}], 
     "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", "1", ",", "1"}], "}"}]}], "]"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->CompressedData["
1:eJwdz38s1HEcx/EbuX7cUhYmZkXNzI9zbY2sTb4rbbkU+kGM/LicU3aRUbHy
89Kd1hIxYdLiiKs7x9UuP9MoEufSz12m5NLXqY0Vzen7+vzx3mPv/54vlwRx
+BkLFovlxxy8a+NZUJxIU3WBosdwmZ9+SsnI85wg6jU9jW2MrGujRInVko9e
QFNGNw4Pmt+MRCwJaeq2a4QAFgbYpEOD5XGirb61PlpEU1VzEhXsS7PSwss5
giFYnPxMHcN4OMy+C7L37hqAn/O6iAb+zxlo/9TWBCXB026xjOqKJ+7QcvaD
F1z4+DcSztTGxUGH6jvx0N0xKgn2rewXwX5lRyXcLJ0grn8wpIUNLzf0QEXM
npR49LIVWdC0Zj4XDiq986BeN1AODeK3RCup07CKMVJ1izje4jEJS/iLRFVn
yiL8zek2Q+NrJ+c2Ru7IN1dY/dyXC6dMZl/oHJ1/FiZr3xEdAn8I1ejb9IeY
IwpOaBLTVMaJMKLyl90F6KuoyYAm3uSWUcZDN+NtocrOr2zkPE05qiOIRzmc
faJsmlrn4UB8v9syemsOs8frdAwcZ5cmwWFzTDLk7TA+zGZMCy9qhZMH+e2Q
PSjvgC4ZDakbrzCdrkViaLrRkwl36g5cgmtDFHXWjIs13veg0SdxDA5yNToY
W7ZqNyahqVm5xh5Kg2T+oTKaCh8vDYByWW+WkHF5SlkA5y2OXIf8yrpyKEs4
WQ+Nwj45jF2qUsKLC43EkmOmdsjjcjug/31pJ6S3KYm9hZkVQ4wG0WAznLHN
/TeF/8uLFTjSvXruK+P2T1op/P5IVAsF/VeJqbqaFhga0ky0Zgcp4VxTOdHv
lTxqmlGaryH+B+UG1hU=
  "],
 CellLabel->
  "In[175]:=",ExpressionUUID->"1d2333bc-3ba6-452d-822e-dd252f0b9b58"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Total", "[", 
  RowBox[{"dr", "[", 
   RowBox[{"aFair", ",", "\[Tau]Fair", ",", 
    RowBox[{"transFairF", "[", 
     RowBox[{"[", 
      RowBox[{"2", ",", "18"}], "]"}], "]"}], ",", 
    RowBox[{"transFairF", "[", 
     RowBox[{"[", 
      RowBox[{"2", ",", "2"}], "]"}], "]"}], ",", 
    RowBox[{"transFairF", "[", 
     RowBox[{"[", 
      RowBox[{"2", ",", 
       RowBox[{"3", ";;", "6"}]}], "]"}], "]"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.8314397539087176`*^9, 3.8314397812227564`*^9}},
 CellLabel->
  "In[158]:=",ExpressionUUID->"126b5147-d455-45e6-9fec-a2946ac8010d"],

Cell[BoxData["0.37387396760171016`"], "Output",
 CellChangeTimes->{{3.831439764879733*^9, 3.831439781902757*^9}, 
   3.83144007959628*^9},
 CellLabel->
  "Out[158]=",ExpressionUUID->"11491479-3245-42e9-8132-95844c429b0e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"transFairG", "[", 
   RowBox[{"[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "196", ",", "197", ",", "198", ",", "255"}], "}"}], 
    "]"}], "]"}], "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.8314398454128475`*^9, 3.8314398723268857`*^9}, {
  3.8314402067045135`*^9, 3.831440208204516*^9}, {3.831441721650839*^9, 
  3.8314417318728533`*^9}},
 CellLabel->
  "In[168]:=",ExpressionUUID->"4af7d193-b26e-40c2-a783-42b556151da6"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"\<\"1-Y\"\>", "\<\"2-E\"\>", "\<\"3-R1\"\>", "\<\"4-R2\"\>", "\<\"5-R3\
\"\>", "\<\"6-R4\"\>", "\<\"7-C\"\>", "\<\"8-CCA\"\>", "\<\"9-F\"\>", \
"\<\"10-Fex\"\>", "\<\"11-TF\"\>", "\<\"12-TMF\"\>", "\<\"13-TMS\"\>", \
"\<\"14-TDF\"\>", "\<\"15-TDS\"\>", "\<\"16-TM\"\>", "\<\"17-TD\"\>", \
"\<\"18-\[Alpha]\"\>", "\<\"19-\[Alpha]check\"\>", "\<\"20-atmosGt\"\>"},
     {"1959", "1.7214242433531184`", "17.807484437223636`", 
      "11.051114316915932`", "3.127375414430334`", "0.469687985681489`", 
      "310.4570713436514`", "104.96955709542411`", "0.5910089235285616`", 
      RowBox[{"-", "0.10587586`"}], "0.4851330635285616`", 
      "0.2166779997450739`", "0.027653116685266745`", 
      RowBox[{"-", "0.005436989727704472`"}], "0.06477057854425027`", 
      "0.24433111643034064`", "0.059333588816545796`", "0.23178879923496115`",
       "0.23166644822579685`", "658.168991248541`"},
     {"1960", "1.9758835673326414`", "18.18147309896712`", 
      "11.315827149220116`", "3.2442568748231286`", "0.4745085184334183`", 
      "311.2174748308438`", "107.00692109848488`", "0.6041025417773012`", 
      RowBox[{"-", "0.09670858`"}], "0.5073939617773011`", 
      "0.22156313927820345`", "0.02819623675716106`", 
      RowBox[{"-", "0.005559570024233318`"}], "0.06604270282868335`", 
      "0.24975937603536452`", "0.060483132804450036`", "0.23341118750297785`",
       "0.23328275275663365`", "659.7810466413889`"},
     {"1961", "1.9473287709912064`", "18.61075470353988`", 
      "11.635503602479627`", "3.4218599580689117`", "0.5481101974913033`", 
      "312.2176376509797`", "109.07544908254192`", "0.6212760200282865`", 
      RowBox[{"-", "0.10438456`"}], "0.5168914600282866`", 
      "0.2270293264050879`", "0.028757931769558924`", 
      RowBox[{"-", "0.005696730249514828`"}], "0.06735833431183597`", 
      "0.2557872581746468`", "0.061661604062321136`", "0.23512675219569854`", 
      "0.23499156885263842`", "661.901391820077`"},
     {"2018", "5.397601620393977`", "62.1266667039106`", "46.37326461997641`",
       "19.82802078076286`", "3.3489340907808485`", "409.67829538483073`", 
      "327.060703435536`", "2.075371274507965`", "0.3513641`", 
      "2.426735374507965`", "1.073144475217117`", "0.11547820055080946`", 
      RowBox[{"-", "0.026927862980842005`"}], "0.2704790908038922`", 
      "1.1886226757679266`", "0.2435512278230502`", "0.5611688825295792`", 
      "0.5578249765019879`", "868.5179862158412`"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.831439873457887*^9, 3.8314400833762856`*^9, 3.831440209184517*^9, {
   3.831441724811844*^9, 3.831441732212854*^9}},
 CellLabel->
  "Out[168]//MatrixForm=",ExpressionUUID->"49bd338c-8664-4b1a-90fc-\
868f3a454671"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"transFairF", "[", 
   RowBox[{"[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "60"}], "}"}], "]"}], 
   "]"}], "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.831438919770256*^9, 3.831438946743294*^9}, {
  3.8314395676244555`*^9, 3.831439567824456*^9}, {3.8314402183755302`*^9, 
  3.831440219225531*^9}, {3.8314419143411684`*^9, 3.831441916342171*^9}},
 CellLabel->
  "In[176]:=",ExpressionUUID->"49b2fb0b-2b74-4dc0-b9cd-d2aaf39fcc05"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"\<\"1-Y\"\>", "\<\"2-E\"\>", "\<\"3-R1\"\>", "\<\"4-R2\"\>", "\<\"5-R3\
\"\>", "\<\"6-R4\"\>", "\<\"7-C\"\>", "\<\"8-CCA\"\>", "\<\"9-F\"\>", \
"\<\"10-Fex\"\>", "\<\"11-TF\"\>", "\<\"12-TMF\"\>", "\<\"13-TMS\"\>", \
"\<\"14-TDF\"\>", "\<\"15-TDS\"\>", "\<\"16-TM\"\>", "\<\"17-TD\"\>", \
"\<\"18-\[Alpha]\"\>", "\<\"19-\[Alpha]check\"\>", "\<\"20-atmosGt\"\>"},
     {"1960", "1.7564732728959689`", "18.18147309896712`", 
      "11.315827149220116`", "3.2442568748231286`", "0.4745085184334183`", 
      "311.2174748308438`", "107.00692109848488`", "0.6041296731595226`", 
      RowBox[{"-", "0.096709`"}], "0.5074206731595226`", 
      "0.22156313927820345`", "0.02819623675716106`", 
      RowBox[{"-", "0.005559570024233318`"}], "0.06604270282868335`", 
      "0.24975937603536452`", "0.060483132804450036`", "0.23341118750310838`",
       "0.23341118750310838`", "659.7810466413889`"},
     {"1961", "1.783185529347538`", "18.56307684655879`", 
      "11.586355696525882`", "3.3598984909202083`", "0.48748713313871467`", 
      "311.9982273565436`", "109.0754490825407`", "0.6175133107883075`", 
      RowBox[{"-", "0.104385`"}], "0.5131283107883076`", 
      "0.22682153141166939`", "0.028755519699388728`", 
      RowBox[{"-", "0.005691516156501165`"}], "0.06735268463472394`", 
      "0.2555770511110581`", "0.06166116847822277`", "0.23510335333769267`", 
      "0.23509764320608278`", "661.4362419958725`"},
     {"1962", "1.8218326196708776`", "18.950484104995084`", 
      "11.860834977762215`", "3.47236020164008`", "0.49841981636392146`", 
      "312.7835082901613`", "111.19100682548799`", "0.6309680536034583`", 
      RowBox[{"-", "0.115335`"}], "0.5156330536034583`", 
      "0.23134321205182995`", "0.029318133205115348`", 
      RowBox[{"-", "0.0058049763657583905`"}], "0.0686704674610676`", 
      "0.2606613452569453`", "0.06286549109530921`", "0.2367488526818149`", 
      "0.2367377430917037`", "663.101037575142`"},
     {"2018", "5.124950753855906`", "60.82938324615455`", 
      "45.132796410060166`", "18.94505284737969`", "3.128374946357101`", 
      "406.0370166393515`", "322.1235195837364`", "2.027585718854319`", 
      "0.351364`", "2.3789497188543187`", "1.0539550779250182`", 
      "0.11409590572789068`", 
      RowBox[{"-", "0.026446353293283827`"}], "0.26724140745636304`", 
      "1.168050983652909`", "0.24079505416307923`", "0.5511311230151984`", 
      "0.5482157778735695`", "860.7984752754253`"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.8314389476832952`*^9, 3.8314395686644573`*^9, 
  3.8314401090323763`*^9, 3.8314402199855323`*^9, 3.8314418667070427`*^9, 
  3.8314419170521727`*^9, 3.8314421399446936`*^9},
 CellLabel->
  "Out[176]//MatrixForm=",ExpressionUUID->"0baead95-0cbe-4c7c-b147-\
014d8e90d2fa"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"datafix", "[", 
   RowBox[{"[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "60"}], "}"}], "]"}], "]"}], "//", 
  "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.8314387566100264`*^9, 3.8314387680720425`*^9}, {
   3.8314389762473354`*^9, 3.831438982137344*^9}, 3.8314395769154687`*^9, {
   3.8314401195743914`*^9, 3.8314401205643926`*^9}, {3.831441681910781*^9, 
   3.8314416906077957`*^9}},
 CellLabel->
  "In[177]:=",ExpressionUUID->"cf5d7984-3aa3-487d-97ec-2018bb118aaa"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"\<\"T\"\>", "\<\"year\"\>", "\<\"mu\"\>", "\<\"EInd\"\>", \
"\<\"scc\"\>", "\<\"Catm\"\>", "\<\"Catmstock\"\>", "\<\"Temp\"\>", \
"\<\"I\"\>", "\<\"K\"\>", "\<\"L\"\>", "\<\"A\"\>", "\<\"Omega\"\>", \
"\<\"QGross\"\>", "\<\"Q\"\>", "\<\"alpha\"\>", "\<\"dalpha\"\>", \
"\<\"Eland\"\>", "\<\"Ec\"\>", "\<\"Ecp\"\>", "\<\"Fex\"\>"},
     {"0", "1960", "0", "9.343153`", "1.163312`", "311.217475`", 
      "659.781047`", "0.249759`", "3.58443`", "40.165992`", "3034.95`", 
      "1.713393`", "0.000043`", "11.285498`", "11.285014`", "0.233411`", 
      "25.035`", "1.192283`", "3.740229`", "1.764259`", 
      RowBox[{"-", "0.096709`"}]},
     {"1", "1961", "0", "9.361011`", "1.169542`", "312.006013`", 
      "661.452747`", "0.255583`", "3.866626`", "42.36859`", "3091.844`", 
      "1.720509`", "0.000047`", "11.66601`", "11.665466`", "0.235098`", 
      "37.67229`", "1.244322`", "3.79711`", "1.79109`", 
      RowBox[{"-", "0.104385`"}]},
     {"58", "2018", "0", "36.381587`", "15.333807`", "406.454893`", 
      "861.684373`", "1.170704`", "39.702865`", "526.666617`", "7631.091`", 
      "4.521448`", "0.00263`", "122.899169`", "122.575914`", "0.549817`", 
      "18.316663`", "0.98954`", "10.913055`", "5.147668`", "0.351364`"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.831438768892044*^9, 3.831438983017345*^9, 3.831439577355469*^9, 
   3.831440088727293*^9, 3.831440121574394*^9, {3.8314416842517843`*^9, 
   3.8314416914777966`*^9}, 3.831442147255704*^9},
 CellLabel->
  "Out[177]//MatrixForm=",ExpressionUUID->"8e16334a-0af3-44ac-8e54-\
5159e69f0439"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"datafix", "[", 
      RowBox[{"[", 
       RowBox[{
        RowBox[{"2", ";;", "100"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "19"}], "}"}]}], "]"}], "]"}], ",", 
     RowBox[{"transFairF", "[", 
      RowBox[{"[", 
       RowBox[{
        RowBox[{"2", ";;", "100"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Blue", ",", "Red"}], "}"}]}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8314387878640704`*^9, 3.8314389030882325`*^9}, {
  3.8314390317164135`*^9, 3.8314391014355116`*^9}},
 CellLabel->
  "In[148]:=",ExpressionUUID->"30e3c3b5-25da-4b8a-8e38-b24f65892d20"],

Cell[BoxData[
 GraphicsBox[{{}, {{{}, {}, 
     {RGBColor[0, 0, 1], PointSize[
       NCache[
        Rational[1, 72], 0.013888888888888888`]], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJwt1AtQlUUUB/CryIUM1AgYrFsC3RQNjHeIin8VUfD9SmKEvICjhCE+4pX4
RAFNBouS1PZ8KqMk5iPQSNEQEGki50p38hEOiLzMK8jV0hCpL/d8Mzvf/GbP
2T27s7tusasXLB+o0Wji1Pb//8WnCFz0u3VM7/A2XrhIYKihz78rgF0s8GnW
PrfFjezjApty7J3n9I6UPiVwpuiwrn6Ih3SZgOFub2qm82jpcoED8x8ttviM
ka4QSG/L+GPWX+xKgZ/sanNCR3tK1whkWifUHrrjJV0nUOV3MDz2JW/pegHT
xsRREVvZRoGTMdPCbPx9pE0C75uWvbbjZV/pGwKBa28XWHq5v1GgsPK78+kW
drNARaSL+9EOjm8V+GFMrnlbvJ90p0DbhtNPWob6S5sFqqfXFMzYyX4osMe+
aNfsFezHAlHKbbfLrZz/VM23jGhY3cHuEzDPbVk3SsfxGsIinU2MVyl7EKGu
IXts8YoAaVsC/WLSp5Wy7Qg5v+8MvBIdKD2MEHWh+oHR+z1pR8Lgbb67R2az
XQhFi6pezbAOktYR0gyJZy15bFdCV1mAu0s1x+sJz1cGLU/qZ3sQ7rel7qvX
c7wnofSBmnCA7U0Yu2RS4M9zx0n7Exam9E6OXskOIoT/+Ew3Yj57AuFS8gnD
DsEGISLmmziEBUuHElzK8jdf+4Q9Q53/9cJGD/fx0rMINrbtnT1xE6TnEaZa
nV7VXjZRehHBaLhYodkbIh1JyEudXvtR9iTppYTCpgTfuwGQXkbYfjXR7JDN
jid09obo9KHslYSbxl/74TRZehXBfZd/zxCFnUyYfqy771Arez3h+7FJhwdo
pkinEdbkBQefeJO9gZDw3GvAUyf2ZsI67/2aakd2FmF/56P5YQvYOep6TPed
t5xkf0bQGRucVl3n9eUTRkVMcf/4AtdbQNg4Ptf230Z2IcF3oiHXpp99QHVK
1cxkV65XIVx/csfVLZRdRLArcIzUJLCLCXt6PL58mMc+Tjgfr3vr5hn2KUJG
61CtuM0uI+SOnFfjruV6ywmWzDXfRrzLriAkNR3uz1jCrlTPY0PVcqfN7BpC
ZYzh0vNidh2h/AP1hjaw69X9a3mjOfwZ20gIiLu2PkU/Vdqkju9tMmyfzb5B
OGJM3x2dwm4kZFlC8toFu5lw4/o5k+0Vdivhi4Xjq01d7E6C9ZHfztk7h0qb
CXOttOE0gf2QoAyvsUmJZT8mHMz6+uymbPZTwvDLa2eWlLD71PHU5+3eVbZG
Qf6c6H88e9gDFWj/LpyR4DBNepCCP83xyQW+bK2C7s+D3jkUxbZVMM6u/WT+
FvZgBQe9OhYsPcq2U3Brd0i7VT17iAKfr+7tzelmD1PQ1PjhxK5XwqQdFGTW
2wwK9mM7KijVdpesXRiG/wBmNuNO
       "]]}, 
     {RGBColor[1, 0, 0], PointSize[
       NCache[
        Rational[1, 72], 0.013888888888888888`]], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJwt0g9M1VUUB3B4YjhEIEX5M0j585B/GiKQELZvgpM/ljzmlPxDqEDmdICa
wISESYbzhUydEdE9vxohA15qwSAg+RMmgohDJmiAEIqUIohuPAVWL++5293d
Z+ec3XPurtPupOgElZGR0R7D/v98vRSBqb7RzO1ti/DaxQIjgeOb9I/ZpQKb
+zuVdbnW0hUC3hm+D++dWyx9ScA0dbDqVMES6UoBrZ1GH5BvI10jcO3qYPjB
QlvpeoGk/PVdYxo76UaBkodzS1YespduEfgx/2Bsm5WDdKvAP/peo9tL35K+
IfC8K2beM9VS6VsCKQOV5Xvdl0l3C0wM7FzROcnuFRiOy/ti7TC7T0CtrUsN
+5M9KNCZX95xuslJ+oGAr0OZz50AZ+lRgepGbXR7D/uJgCp59q/GCBfpCYE7
2SfmjniwXwg0wDVw40XO1wv8fHzdgY7L7BmB1X+/r48aZhsRLia753ikcL0J
4fOxU79W2LtKzyNYPeyMHtrFNifkz1mp6jFWS1sRbL2yryxoZVsToiLjNK52
btK2hJchM2Vtp9kOBKe6msZRq+XSywgDd5cnpGg47kpIynL72vsk251gkf3L
U38d25tQnV7gFOnI9T6Edq15oukfbD/CnAs5to797DUGp5mfCLvGDiYkpx3X
TVu6S4OQZ9eZlqNjhxIC1VvEqnvsMMKbUX6vLDM8pDcSTnbsXhNZ5ikdRZi6
mvns6oiX9GZC7veLnjjXeUvHGN73zNTsRNEK6R2EDddDfPcfWikdR2juO1Iz
Nv9t6XgCBe7J883j+F5C6vosp+z5PtL7CRFD+67f/4qdTPggycs4/Cb7MGH4
wu9Ds4/YaYQFppMRHSarpDMI9tq5BWKG41mG+R0SYjOm2TmG/rumWtb5c34u
4czHLkG3tWwt4W7IrEvxFM+XT/hJfdzG9CD3f44wlLizbLOOXUBQF+17vOsx
u4gQP/w8SbWE71MILSWaBbnvsIsN8djWCo9t7FLCI//h2vZMdgXht7MvVVt/
YF8iHHPMCr58jV1JKC6tL20YY9cQ/l12U/OJNfdfT/juuv0RtyB2I8HFJjQo
PI7dQhivCwqoOsFuJViGHo2L0rFvEJYsHF9s3M2+RTBv1ql1r9jdhNhai+1r
nXylew3/88t+58IN7D6C2eFtpysOsAcJPZ/Rsdiz7AeETzX2Wxtq2KMEN5tR
9fl+9hPC+TylutN4tfQEwdlu+vZHavYLQmZpyhaXMLaeEFqjes9hH3uGoDcr
iQ44xTZSYNkffCG+nK1S0N0UPPFtG9tEwdGz1uVdo+w3FMQnfrgpxcJPep6C
HcdiVqlWs80U9Ia0DGRvYZsruOL29N3xNLaFAo+q9PjIQraVAl160OQ3teyF
CkwzzJvv32VbK2jynPZ00fvhPx1i3TA=
       "]]}}, {
     {RGBColor[0, 0, 1], PointSize[
       NCache[
        Rational[1, 72], 0.013888888888888888`]], AbsoluteThickness[1.6]}, 
     {RGBColor[1, 0, 0], PointSize[
       NCache[
        Rational[1, 72], 0.013888888888888888`]], AbsoluteThickness[1.6]}}, {
     {RGBColor[0, 0, 1], PointSize[
       NCache[
        Rational[1, 72], 0.013888888888888888`]], AbsoluteThickness[1.6]}, 
     {RGBColor[1, 0, 0], PointSize[
       NCache[
        Rational[1, 72], 0.013888888888888888`]], AbsoluteThickness[
      1.6]}, {}, {}, {}}, {
     {RGBColor[0, 0, 1], PointSize[
       NCache[
        Rational[1, 72], 0.013888888888888888`]], AbsoluteThickness[1.6]}, 
     {RGBColor[1, 0, 0], PointSize[
       NCache[
        Rational[1, 72], 0.013888888888888888`]], AbsoluteThickness[
      1.6]}, {}, {}, {}}}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{1957.9583333333333`, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->600,
  Method->{
   "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{1957.9583333333333`, 2058.}, {0, 44.651937}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.831438838060141*^9, 3.831438849171157*^9}, {
  3.83143889418722*^9, 3.831438903598233*^9}, {3.8314390526984434`*^9, 
  3.8314391020455127`*^9}},
 CellLabel->
  "Out[148]=",ExpressionUUID->"6fe7ac72-54c3-470e-bc12-b106eb26fd11"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"dalphav", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "255"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "3"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dalphav", "[", 
    RowBox[{"[", "1", "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"\"\<year\>\"", ",", "\"\<alpha\>\"", ",", "\"\<dalpha\>\""}], 
    "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dalphav", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "1"}], "]"}], "]"}], "=", 
   RowBox[{"transFairG", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "1"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dalphav", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "2"}], "]"}], "]"}], "=", 
   RowBox[{"transFairG", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "18"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dalphav", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "3"}], "]"}], "]"}], "=", 
   RowBox[{"dalpha", "[", 
    RowBox[{"dalphav", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", "2"}], "]"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.828779231509928*^9, 3.8287792479684515`*^9}, {
  3.828779308014536*^9, 3.8287793735851283`*^9}, {3.828779404629672*^9, 
  3.828779425199201*^9}, {3.828779457132246*^9, 3.8287795156483293`*^9}},
 CellLabel->
  "In[163]:=",ExpressionUUID->"bd3cc4c3-d94e-4bdc-a47e-81009fbfa08c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"dalphav", "[", 
   RowBox[{"[", 
    RowBox[{"1", ";;", "5"}], "]"}], "]"}], "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.828779378337635*^9, 3.828779399437165*^9}},
 CellLabel->
  "In[168]:=",ExpressionUUID->"be090750-8e9a-4d26-9b65-4f22ef6e2715"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"\<\"year\"\>", "\<\"alpha\"\>", "\<\"dalpha\"\>"},
     {"1765", "0.16376976980682398`", "52.0265845428803`"},
     {"1766", "0.16379372621624896`", "52.019986897328636`"},
     {"1767", "0.16385769747130374`", "52.00237595674116`"},
     {"1768", "0.1639267209387347`", "51.98338538882672`"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.8287793908236527`*^9, 3.8287793998371654`*^9}, 
   3.8287794702382646`*^9, 3.828779520310836*^9},
 CellLabel->
  "Out[168]//MatrixForm=",ExpressionUUID->"e66ae54e-9212-4ca0-be6c-\
13880ef77b31"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<dalphav.csv\>\"", ",", "dalphav"}], "]"}]], "Input",
 CellChangeTimes->{{3.828779530943351*^9, 3.8287795519028807`*^9}},
 CellLabel->
  "In[169]:=",ExpressionUUID->"593eee1f-edde-48a3-bfe4-a6f561898dd7"],

Cell[BoxData["\<\"dalphav.csv\"\>"], "Output",
 CellChangeTimes->{3.828779554252884*^9},
 CellLabel->
  "Out[169]=",ExpressionUUID->"7fcfb6a0-4df7-4e22-8a27-53d8d207f3d0"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"IVFairwoFex2015", "=", 
   RowBox[{"transFairG", "[", 
    RowBox[{"[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "252"}], "}"}], "]"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.824186443439577*^9, 3.8241864932775145`*^9}},
 CellLabel->
  "In[1921]:=",ExpressionUUID->"0b380800-11a0-4ee2-91b6-1f4d1ab04969"],

Cell[BoxData[
 RowBox[{
  RowBox[{"IVFairwFex2015", "=", 
   RowBox[{"transFairG", "[", 
    RowBox[{"[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "252"}], "}"}], "]"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{3.8241867228443236`*^9},
 CellLabel->
  "In[1928]:=",ExpressionUUID->"cca7d039-e709-441d-a841-5833f201e33b"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{"\"\<Fair_historical_Spin_up.csv\>\"", ",", "FairOutput"}], "]"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Export", "[", 
    RowBox[{"\"\<Fair_historical_Spin_up_wFex.csv\>\"", ",", "transFairG"}], 
    "]"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{"\"\<Fair_historical_Spin_up_woFex.csv\>\"", ",", "transFairG"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.822764648658268*^9, 3.822764649648269*^9}, {
   3.822764742866455*^9, 3.822764746906461*^9}, 3.8227967679454856`*^9, {
   3.822796810071045*^9, 3.822796820226059*^9}, 3.8227968554206085`*^9, {
   3.822799390000684*^9, 3.8227993936352434`*^9}, {3.8227994263192897`*^9, 
   3.82279942698929*^9}, {3.824186710699278*^9, 3.8241867115391054`*^9}, {
   3.8241870537610474`*^9, 
   3.8241870548169074`*^9}},ExpressionUUID->"97933c1b-e5eb-4047-bfab-\
68c9498e684b"],

Cell[BoxData["\<\"Fair_historical_Spin_up_wFex.csv\"\>"], "Output",
 CellChangeTimes->{{3.8227994054132605`*^9, 3.8227994305927954`*^9}, 
   3.8241851432695704`*^9, {3.824186675759321*^9, 3.824186692156361*^9}},
 CellLabel->
  "Out[1927]=",ExpressionUUID->"2cff3c16-78d1-44b8-8434-0a7c9bb920b9"]
}, Open  ]],

Cell["\<\
Illustrate Spin-up with different CC/EBM models specifications\
\>", "Text",
 CellChangeTimes->{{3.71113575119866*^9, 3.7111357648642597`*^9}, {
  3.711171131470954*^9, 3.711171132484956*^9}, {3.712408724609439*^9, 
  3.7124087395614595`*^9}, {3.7662479249546547`*^9, 3.7662479290036545`*^9}, {
  3.810276061054193*^9, 3.810276074321699*^9}, {3.8227646837663717`*^9, 
  3.822764705489403*^9}, {3.8227647695125475`*^9, 3.8227648008765917`*^9}},
 FontSize->18,
 Background->RGBColor[
  0.87, 0.94, 1],ExpressionUUID->"7fb86644-bdc7-4a49-bb85-9dfb45543d62"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SpinupDice165y", "=", 
   RowBox[{
   "Import", "[", 
    "\"\<DICE2016_5y_historical_Spinup_interpolated_overview.csv\>\"", 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SpinupDice161y", "=", 
   RowBox[{
   "Import", "[", "\"\<DICE2016_1y_historical_Spinup_overview.csv\>\"", 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SpinupDice135y", "=", 
   RowBox[{
   "Import", "[", 
    "\"\<DICE2013_5y_historical_Spinup_interpolated_overview.csv\>\"", 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SpinupDice131y", "=", 
   RowBox[{
   "Import", "[", "\"\<DICE2013_1y_historical_Spinup_overview.csv\>\"", 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SpinupDice0710y", "=", 
   RowBox[{
   "Import", "[", 
    "\"\<DICE2007_10y_historical_Spinup_interpolated_overview.csv\>\"", 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SpinupDice071y", "=", 
   RowBox[{
   "Import", "[", "\"\<DICE2007_1y_historical_Spinup_overview.csv\>\"", 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SpinupFair", "=", 
   RowBox[{"Import", "[", "\"\<Fair_historical_Spin_up.csv\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SpinupPlotdata", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "255"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "1", ",", "21"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SpinupPlotdata", "[", 
    RowBox[{"[", "1", "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
    "\"\<1-year\>\"", ",", "\"\<2-Catm-CC165\>\"", ",", 
     "\"\<3-Catm-CC161c\>\"", ",", "\"\<4-Catm-CC161b\>\"", ",", 
     "\"\<5-Catm-CC135\>\"", ",", "\"\<6-Catm-CC131c\>\"", ",", 
     "\"\<7-Catm-CC131b\>\"", ",", "\"\<8-Catm-CC0710\>\"", ",", 
     "\"\<9-Catm-CC071c\>\"", ",", "\"\<10-C-CC071b\>\"", ",", 
     "\"\<11-C-Fair\>\"", ",", "\"\<12-T-CC165\>\"", ",", 
     "\"\<13-T-CC161c\>\"", ",", "\"\<14-T-CC161b\>\"", ",", 
     "\"\<15-T-CC135\>\"", ",", "\"\<16-T-CC131c\>\"", ",", 
     "\"\<17-T-CC131b\>\"", ",", "\"\<18-T-CC0710\>\"", ",", 
     "\"\<19-T-CC071c\>\"", ",", "\"\<20-T-CC071b\>\"", ",", 
     "\"\<21-T-Fair\>\""}], "}"}]}], ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.8227969339927197`*^9, 3.8227969739282756`*^9}, {
  3.822797039397868*^9, 3.822797114753974*^9}, {3.822797270940194*^9, 
  3.822797271600195*^9}, {3.8227973097387486`*^9, 3.8227973102587495`*^9}, {
  3.8227979203911085`*^9, 3.8227981684049587`*^9}, {3.822798202877507*^9, 
  3.822798244959571*^9}, {3.822798286426629*^9, 3.822798328904189*^9}, {
  3.8227983595562325`*^9, 3.822798419883317*^9}, {3.822798905346501*^9, 
  3.822798914797514*^9}},
 CellLabel->
  "In[1884]:=",ExpressionUUID->"2ac70bd5-025f-4f07-89da-64e128d41d29"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SpinupPlotdata", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "1"}], "]"}], "]"}], "=", 
   RowBox[{"SpinupDice165y", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "2"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SpinupPlotdata", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "2"}], "]"}], "]"}], "=", 
   RowBox[{"SpinupDice165y", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "3"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SpinupPlotdata", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "3"}], "]"}], "]"}], "=", 
   RowBox[{"SpinupDice161y", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "3"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SpinupPlotdata", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "4"}], "]"}], "]"}], "=", 
   RowBox[{"SpinupDice161y", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "6"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SpinupPlotdata", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "5"}], "]"}], "]"}], "=", 
   RowBox[{"SpinupDice135y", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "3"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SpinupPlotdata", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "6"}], "]"}], "]"}], "=", 
   RowBox[{"SpinupDice131y", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "3"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SpinupPlotdata", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "7"}], "]"}], "]"}], "=", 
   RowBox[{"SpinupDice131y", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "6"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SpinupPlotdata", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "8"}], "]"}], "]"}], "=", 
   RowBox[{"SpinupDice0710y", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "3"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SpinupPlotdata", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "9"}], "]"}], "]"}], "=", 
   RowBox[{"SpinupDice071y", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "3"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SpinupPlotdata", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "10"}], "]"}], "]"}], "=", 
   RowBox[{"SpinupDice071y", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "6"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SpinupPlotdata", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "11"}], "]"}], "]"}], "=", 
   RowBox[{"SpinupFair", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "6"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SpinupPlotdata", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "12"}], "]"}], "]"}], "=", 
   RowBox[{"SpinupDice165y", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "6"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SpinupPlotdata", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "13"}], "]"}], "]"}], "=", 
   RowBox[{"SpinupDice161y", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "11"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SpinupPlotdata", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "14"}], "]"}], "]"}], "=", 
   RowBox[{"SpinupDice161y", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "14"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SpinupPlotdata", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "15"}], "]"}], "]"}], "=", 
   RowBox[{"SpinupDice135y", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "6"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SpinupPlotdata", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "16"}], "]"}], "]"}], "=", 
   RowBox[{"SpinupDice131y", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "11"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SpinupPlotdata", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "17"}], "]"}], "]"}], "=", 
   RowBox[{"SpinupDice131y", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "14"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SpinupPlotdata", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "18"}], "]"}], "]"}], "=", 
   RowBox[{"SpinupDice0710y", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "6"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SpinupPlotdata", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "19"}], "]"}], "]"}], "=", 
   RowBox[{"SpinupDice071y", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "11"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SpinupPlotdata", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "20"}], "]"}], "]"}], "=", 
   RowBox[{"SpinupDice071y", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "14"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SpinupPlotdata", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "21"}], "]"}], "]"}], "=", 
   RowBox[{"SpinupFair", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "9"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.8227983381592026`*^9, 3.8227983545762253`*^9}, {
  3.822798432859336*^9, 3.822798482118905*^9}, {3.822798637870124*^9, 
  3.822798736633263*^9}, {3.8227988118418694`*^9, 3.8227988852379723`*^9}, {
  3.8227989228285255`*^9, 3.8227990819602494`*^9}},
 CellLabel->
  "In[1893]:=",ExpressionUUID->"060606c8-9a0e-4d56-9a81-b40efab49844"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SpinupCplot", "=", 
   RowBox[{"ListLinePlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"SpinupPlotdata", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}], ",", 
       RowBox[{"SpinupPlotdata", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "3"}], "}"}]}], "]"}], "]"}], ",", 
       RowBox[{"SpinupPlotdata", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "4"}], "}"}]}], "]"}], "]"}], ",", 
       RowBox[{"SpinupPlotdata", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "5"}], "}"}]}], "]"}], "]"}], ",", 
       RowBox[{"SpinupPlotdata", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "6"}], "}"}]}], "]"}], "]"}], ",", 
       RowBox[{"SpinupPlotdata", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "7"}], "}"}]}], "]"}], "]"}], ",", 
       RowBox[{"SpinupPlotdata", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "8"}], "}"}]}], "]"}], "]"}], ",", 
       RowBox[{"SpinupPlotdata", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "9"}], "}"}]}], "]"}], "]"}], ",", 
       RowBox[{"SpinupPlotdata", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "10"}], "}"}]}], "]"}], "]"}], ",", 
       RowBox[{"SpinupPlotdata", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "11"}], "}"}]}], "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Blue", ",", 
        RowBox[{"{", 
         RowBox[{"Blue", ",", "Dashed"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Blue", ",", "DotDashed"}], "}"}], ",", "Red", ",", 
        RowBox[{"{", 
         RowBox[{"Red", ",", "Dashed"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Red", ",", "DotDashed"}], "}"}], ",", "Green", ",", 
        RowBox[{"{", 
         RowBox[{"Green", ",", "Dashed"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Green", ",", "DotDashed"}], "}"}], ",", "Black"}], "}"}]}], 
     ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1765", ",", "2018"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"580", ",", "1000"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"Frame", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"True", ",", "True", ",", "False", ",", "False"}], "}"}]}], 
     ",", 
     RowBox[{"FrameStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Black", ",", "Black", ",", "Automatic", ",", "Black"}], 
       "}"}]}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<Year\>\"", ",", "\"\<GtC\>\"", ",", "None", ",", "None"}],
        "}"}]}], ",", 
     RowBox[{"LabelStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{
        RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
        RowBox[{"FontSize", "\[Rule]", "18"}], ",", "Black"}], "]"}]}], ",", 
     RowBox[{"Epilog", "\[Rule]", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<a) Atmospheric Carbon Stock\>\"", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}]}], "}"}]}], "]"}], ",", 
        RowBox[{"Offset", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"Scaled", "[", 
           RowBox[{"{", 
            RowBox[{"0.35", ",", "0.95"}], "}"}], "]"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}]}], "]"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.8227996106401052`*^9, 3.8227998575204535`*^9}, {
  3.8228008027108955`*^9, 3.8228008604574766`*^9}, {3.82280093317258*^9, 
  3.8228009766456413`*^9}, {3.8228012777461205`*^9, 3.822801301666154*^9}, {
  3.8228013506297235`*^9, 3.8228014233918257`*^9}, {3.8228022324335537`*^9, 
  3.8228022360635595`*^9}, {3.822802309077162*^9, 3.8228023095171623`*^9}, {
  3.822836484330261*^9, 3.822836496422278*^9}, {3.8241851642660313`*^9, 
  3.8241851718370123`*^9}},
 CellLabel->
  "In[1915]:=",ExpressionUUID->"3d0ce2d0-ea65-41b6-b692-abbbb0dd24a4"],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.8228008411004496`*^9, 
  3.822800865942485*^9}},ExpressionUUID->"62bf4777-24eb-4913-b5ef-\
90dc283f2faf"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SpinupTplot", "=", 
   RowBox[{"ListLinePlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"SpinupPlotdata", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "12"}], "}"}]}], "]"}], "]"}], ",", 
       RowBox[{"SpinupPlotdata", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "13"}], "}"}]}], "]"}], "]"}], ",", 
       RowBox[{"SpinupPlotdata", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "14"}], "}"}]}], "]"}], "]"}], ",", 
       RowBox[{"SpinupPlotdata", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "15"}], "}"}]}], "]"}], "]"}], ",", 
       RowBox[{"SpinupPlotdata", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "16"}], "}"}]}], "]"}], "]"}], ",", 
       RowBox[{"SpinupPlotdata", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "17"}], "}"}]}], "]"}], "]"}], ",", 
       RowBox[{"SpinupPlotdata", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "18"}], "}"}]}], "]"}], "]"}], ",", 
       RowBox[{"SpinupPlotdata", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "19"}], "}"}]}], "]"}], "]"}], ",", 
       RowBox[{"SpinupPlotdata", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "20"}], "}"}]}], "]"}], "]"}], ",", 
       RowBox[{"SpinupPlotdata", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "21"}], "}"}]}], "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Blue", ",", 
        RowBox[{"{", 
         RowBox[{"Blue", ",", "Dashed"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Blue", ",", "DotDashed"}], "}"}], ",", "Red", ",", 
        RowBox[{"{", 
         RowBox[{"Red", ",", "Dashed"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Red", ",", "DotDashed"}], "}"}], ",", "Green", ",", 
        RowBox[{"{", 
         RowBox[{"Green", ",", "Dashed"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Green", ",", "DotDashed"}], "}"}], ",", "Black"}], "}"}]}], 
     ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1765", ",", "2018"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1.8"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"Frame", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"True", ",", "True", ",", "False", ",", "False"}], "}"}]}], 
     ",", 
     RowBox[{"FrameStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Black", ",", "Black", ",", "Automatic", ",", "Black"}], 
       "}"}]}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<Year\>\"", ",", "\"\<\[Degree]C\>\"", ",", "None", ",", "None"}], 
       "}"}]}], ",", 
     RowBox[{"LabelStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{
        RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
        RowBox[{"FontSize", "\[Rule]", "18"}], ",", "Black"}], "]"}]}], ",", 
     RowBox[{"Epilog", "\[Rule]", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<b) Global Mean Surface Temperature Increase\>\"", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}]}], "}"}]}], "]"}], ",", 
        RowBox[{"Offset", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"Scaled", "[", 
           RowBox[{"{", 
            RowBox[{"0.45", ",", "0.9"}], "}"}], "]"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}]}], "]"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.8228014590143757`*^9, 3.8228015968490705`*^9}, {
  3.8228022173785324`*^9, 3.8228022464495735`*^9}, {3.822802295031142*^9, 
  3.8228022954021425`*^9}, {3.822836407878153*^9, 3.8228364606772275`*^9}},
 CellLabel->
  "In[1916]:=",ExpressionUUID->"5ed44334-0f06-4e0e-870e-7d633986e2ef"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Ltemp", "=", 
   RowBox[{"LineLegend", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Blue", ",", 
       RowBox[{"Directive", "[", 
        RowBox[{"Blue", ",", "Dashed"}], "]"}], ",", 
       RowBox[{"Directive", "[", 
        RowBox[{"Blue", ",", "DotDashed"}], "]"}], ",", "Red", ",", 
       RowBox[{"Directive", "[", 
        RowBox[{"Red", ",", "Dashed"}], "]"}], ",", 
       RowBox[{"Directive", "[", 
        RowBox[{"Red", ",", "DotDashed"}], "]"}], ",", "Green", ",", 
       RowBox[{"Directive", "[", 
        RowBox[{"Green", ",", "Dashed"}], "]"}], ",", 
       RowBox[{"Directive", "[", 
        RowBox[{"Green", ",", "DotDashed"}], "]"}], ",", "Black"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{"\"\<DICE16-  5y\>\"", ",", 
         RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
         RowBox[{"FontSize", "\[Rule]", "16"}], ",", "Black"}], "]"}], ",", 
       RowBox[{"Style", "[", 
        RowBox[{"\"\<DICE16- 1y-calc\>\"", ",", 
         RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
         RowBox[{"FontSize", "\[Rule]", "16"}], ",", "Black"}], "]"}], ",", 
       RowBox[{"Style", "[", 
        RowBox[{"\"\<DICE16- 1y-calb\>\"", ",", 
         RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
         RowBox[{"FontSize", "\[Rule]", "16"}], ",", "Black"}], "]"}], ",", 
       RowBox[{"Style", "[", 
        RowBox[{"\"\<DICE13-  5y\>\"", ",", 
         RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
         RowBox[{"FontSize", "\[Rule]", "16"}], ",", "Black"}], "]"}], ",", 
       RowBox[{"Style", "[", 
        RowBox[{"\"\<DICE13- 1y-calc\>\"", ",", 
         RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
         RowBox[{"FontSize", "\[Rule]", "16"}], ",", "Black"}], "]"}], ",", 
       RowBox[{"Style", "[", 
        RowBox[{"\"\<DICE13- 1y-calb\>\"", ",", 
         RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
         RowBox[{"FontSize", "\[Rule]", "16"}], ",", "Black"}], "]"}], ",", 
       RowBox[{"Style", "[", 
        RowBox[{"\"\<DICE07-10y\>\"", ",", 
         RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
         RowBox[{"FontSize", "\[Rule]", "16"}], ",", "Black"}], "]"}], ",", 
       RowBox[{"Style", "[", 
        RowBox[{"\"\<DICE07- 1y-calc\>\"", ",", 
         RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
         RowBox[{"FontSize", "\[Rule]", "16"}], ",", "Black"}], "]"}], ",", 
       RowBox[{"Style", "[", 
        RowBox[{"\"\<DICE07-1y-calb\>\"", ",", 
         RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
         RowBox[{"FontSize", "\[Rule]", "16"}], ",", "Black"}], "]"}], ",", 
       RowBox[{"Style", "[", 
        RowBox[{"\"\<Fair-Geoffroy\>\"", ",", 
         RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
         RowBox[{"FontSize", "\[Rule]", "16"}], ",", "Black"}], "]"}]}], 
      "}"}], ",", 
     RowBox[{"LegendLayout", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<Row\>\"", ",", "4"}], "}"}]}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.822801703891721*^9, 3.8228018029338603`*^9}, {
   3.822801837764942*^9, 3.822802084731291*^9}, 3.8228022544005847`*^9},
 CellLabel->
  "In[1917]:=",ExpressionUUID->"036783bd-cb40-4198-ac1f-4e274d9d5fe3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SpinupPlot", "=", 
  RowBox[{"Grid", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "SpinupCplot", "}"}], ",", 
      RowBox[{"{", "SpinupTplot", "}"}], ",", 
      RowBox[{"{", "Ltemp", "}"}]}], "}"}], ",", 
    RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8228021592359505`*^9, 3.822802204271514*^9}, {
  3.822802264356599*^9, 3.8228022691091056`*^9}, {3.822802335079199*^9, 
  3.8228023392717047`*^9}},
 CellLabel->
  "In[1918]:=",ExpressionUUID->"6d4ed6d6-d631-4dd8-83bd-8ca37ead227a"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     GraphicsBox[{{}, {{}, {}, 
        {RGBColor[0, 0, 1], PointSize[
          NCache[
           Rational[1, 180], 0.005555555555555556]], AbsoluteThickness[1.6], 
         LineBox[CompressedData["
1:eJw11Q1UzucbB/BYf8qSNC9ZMWteolATi0lfhDbksUSIf3rHY5WVFXlJRXqR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          "]]}, 
        {RGBColor[0, 0, 1], PointSize[
          NCache[
           Rational[1, 180], 0.005555555555555556]], AbsoluteThickness[1.6], 
         Dashing[{Small, Small}], LineBox[CompressedData["
1:eJw10ws019kWB3Dln0fhSipF75fbIL3pKt+kmDLDqCm9jYikibn/8kilCRGi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          "]]}, 
        {RGBColor[0, 0, 1], PointSize[
          NCache[
           Rational[1, 180], 0.005555555555555556]], AbsoluteThickness[1.6], 
         Dashing[{0, Small, Small, Small}], LineBox[CompressedData["
1:eJw10w1Uz9cfB/BUiIpGf2IhU5PRgzzFMu9RSmMe+lFtZSiUQogKKQohVJLy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          "]]}, 
        {RGBColor[1, 0, 0], PointSize[
          NCache[
           Rational[1, 180], 0.005555555555555556]], AbsoluteThickness[1.6], 
         LineBox[CompressedData["
1:eJw10n1Yz9cbB/BQLUW1hJKHrPglrb4mUyq9PZYWC5G2ED2sCFmhCEVIepI8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          "]]}, 
        {RGBColor[1, 0, 0], PointSize[
          NCache[
           Rational[1, 180], 0.005555555555555556]], AbsoluteThickness[1.6], 
         Dashing[{Small, Small}], LineBox[CompressedData["
1:eJw10w1cT9cfB/AIZZ5SLCMKaaHpF0WSv89WWSaJHv1lUk2hJyQkVisViqRN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          "]]}, 
        {RGBColor[1, 0, 0], PointSize[
          NCache[
           Rational[1, 180], 0.005555555555555556]], AbsoluteThickness[1.6], 
         Dashing[{0, Small, Small, Small}], LineBox[CompressedData["
1:eJw10g9Uj/cXB/Ao0z+E9isyhaKRapPUhDdKaWUtZWZYKMUaUUppLQpfpYRY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          "]]}, 
        {RGBColor[0, 1, 0], PointSize[
          NCache[
           Rational[1, 180], 0.005555555555555556]], AbsoluteThickness[1.6], 
         LineBox[CompressedData["
1:eJw10g1YjtcfB/CoJZuXWLYQQpGkxRqh9JUkRtKSEDWqVYqWrAdJ0huSJJT7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          "]]}, 
        {RGBColor[0, 1, 0], PointSize[
          NCache[
           Rational[1, 180], 0.005555555555555556]], AbsoluteThickness[1.6], 
         Dashing[{Small, Small}], LineBox[CompressedData["
1:eJw113tUz0kfB/AQhZDLqpVLtbXbtq21atEFbzbJKpIQipC2K0UlqvWLUmhD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          "]]}, 
        {RGBColor[0, 1, 0], PointSize[
          NCache[
           Rational[1, 180], 0.005555555555555556]], AbsoluteThickness[1.6], 
         Dashing[{0, Small, Small, Small}], LineBox[CompressedData["
1:eJw10gtUjtkaB/A0MUVNn4RKkdRoSBMTGpP8M4xblG/KrYvw0WVcSklXKqES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          "]]}, 
        {GrayLevel[0], PointSize[
          NCache[
           Rational[1, 180], 0.005555555555555556]], AbsoluteThickness[1.6], 
         LineBox[CompressedData["
1:eJw10w9UjucbB/AXLZkklJVYsSQWC0mz8GUhSgv504RQlpSy0oqykLySymRe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          "]]}}, {{}, {}}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{1765., 580.},
      DisplayFunction->Identity,
      Epilog->InsetBox[
        FormBox[
         StyleBox[
         "\"a) Atmospheric Carbon Stock\"", {
          FontFamily -> "Helvetica", FontSize -> 20}, StripOnInput -> False], 
         TraditionalForm], 
        Offset[{0, 0}, 
         Scaled[{0.35, 0.95}]], 
        ImageScaled[{
          Rational[1, 2], 
          Rational[1, 2]}]],
      Frame->{{True, False}, {True, False}},
      FrameLabel->{{
         FormBox["\"GtC\"", TraditionalForm], None}, {
         FormBox["\"Year\"", TraditionalForm], None}},
      FrameStyle->{
        GrayLevel[0], 
        GrayLevel[0], Automatic, 
        GrayLevel[0]},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImageSize->600,
      LabelStyle->Directive[FontFamily -> "Helvetica", FontSize -> 18, 
        GrayLevel[0]],
      Method->{
       "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
        "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& )}},
      PlotRange->{{1765, 2018}, {580, 1000}},
      PlotRangeClipping->True,
      PlotRangePadding->{{0, 0}, {0, 0}},
      Ticks->{Automatic, Automatic}]},
    {
     GraphicsBox[{{}, {{}, {}, 
        {RGBColor[0, 0, 1], PointSize[
          NCache[
           Rational[1, 180], 0.005555555555555556]], AbsoluteThickness[1.6], 
         LineBox[CompressedData["
1:eJxN03k4Vukfx3ENSSmK9tG0SZuKMkkYnyRpMflladMySotRgyTTtEiPaJFC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          "]]}, 
        {RGBColor[0, 0, 1], PointSize[
          NCache[
           Rational[1, 180], 0.005555555555555556]], AbsoluteThickness[1.6], 
         Dashing[{Small, Small}], LineBox[CompressedData["
1:eJxN03lUz/kex/GQbCEqkyxZskda7NGLarSgLsaEIombJcsdO60yQmESpd/n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          "]]}, 
        {RGBColor[0, 0, 1], PointSize[
          NCache[
           Rational[1, 180], 0.005555555555555556]], AbsoluteThickness[1.6], 
         Dashing[{0, Small, Small, Small}], LineBox[CompressedData["
1:eJxN03k4V2kfx3EVTypMixo12jdmVCYlSnymTBvtJKVo2osoKUXaVEyUKRV+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          "]]}, 
        {RGBColor[1, 0, 0], PointSize[
          NCache[
           Rational[1, 180], 0.005555555555555556]], AbsoluteThickness[1.6], 
         LineBox[CompressedData["
1:eJxN03s4l+cfwHEzFfErK+mgiWEkSklH6SPkECVZqYjvQprWwSEKSyUqESqH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          "]]}, 
        {RGBColor[1, 0, 0], PointSize[
          NCache[
           Rational[1, 180], 0.005555555555555556]], AbsoluteThickness[1.6], 
         Dashing[{Small, Small}], LineBox[CompressedData["
1:eJxN03tUD/kfx/FuYilK2FAbbVmbuw0p8kKtyxYibcJPV0K2FCuXLi4lNjZq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          "]]}, 
        {RGBColor[1, 0, 0], PointSize[
          NCache[
           Rational[1, 180], 0.005555555555555556]], AbsoluteThickness[1.6], 
         Dashing[{0, Small, Small, Small}], LineBox[CompressedData["
1:eJxN03tUTtkfx/FQRBnVoNJQyU8XuTX5KaKP3DKJSKMSPdOUS5MKMUUzopAk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          "]]}, 
        {RGBColor[0, 1, 0], PointSize[
          NCache[
           Rational[1, 180], 0.005555555555555556]], AbsoluteThickness[1.6], 
         LineBox[{{1765., 2.168404344971009*^-19}, {1765., 0.}}], 
         LineBox[CompressedData["
1:eJxV03tUTtkfx/GnJlS/JiQm3SY/RWgUYqLUR9MokglJSVIUZh4mNE0jjaQw
SqQo2nufkGsuyYOkXEbRSISkklSIGpJrGeL3rDnff35nrbPOeq11zj57n33e
A0J+nh6qqVAoHqnPf6+f3oXVfMqE4v8OhobG96vtUvu7/EsthiS38e4nHjrL
1mY4NfdozF+1U2TrMXgfHFvTcWam7F4MFW2nteI+B8o2VI9nu0Zp8vN82UYM
7EvV/EdDFsk2ZbCxYBZvhy+RbcGwNbp9SarzMtmWDLq9+y48qBMh25rBPaOn
0ZDOSNk2DL1qRpmt1lkp247hm8w7BkbjY2TbM9jPyJ5sNylWtgNDc17ZlDit
ONlOapt+f7lfxVrZYNDrU9F/d06CbDeGMV/ZHKrevl62B4NjjlHt0pQ/ZE9h
6PCeqdc/M1G2N4Pbxl17Ek9sku3D8LG6UDO6drNsP4aYoFGXy3ukyJ6jfl/Q
sZveQ7bKnsew6n3uuIIZqbIXMKyO+8HxUHya7EUMQ00GrKg9u022kiHt0dk1
Wu+3yw5nuPX5ZPcmxwzZEQzvN+3dZRO/Q3YUg0WuxSt+c6fsVQwB64vSXwxk
smMZLtobjLy3ksuOZ1hUo5pnXCVkb2AIs+2/dNXXWbKTGF42XqqKv0PewtBt
kc+H/KRdstMYfthbrMxx2y07g+H3GP3Cto9kxoDKYSv7ntwjO4vh+039HPKU
2bKzGcYlla6bNXCv7AMM11WOHenV5MMMua2Ljbsn7ZOdy7Db72piysj9slUM
zuWd1YZ3yfkMI+bq77zy2wHZhQyDB1gubDQ+KPuCevxhM6p3FJCLGW6nqhKs
/Q/JLmV4tDS4R8k78jWGI7eWv92XmiO7gqGuUuNpN7vDsisZzBMH/9r/Grma
YW9x9etZa47IrmM4oD1m88jRR2U3qMdPdxzl30x+xPDVicd/Racek/1U/f28
Msz3muXKfsZg7ZHkOG4puZ3hScs1uzsF5DcMxjP8XpdrHpfdqd7/bJuoVd+T
PzL4drmrHOLICg5zt7yUdZlkLY6JAfd8px0ja3PsaXVyyT1H1uPottN7XcFV
ci8O9N6ycH0l2ZDDqjPCfPh9shHHhndRzSWPyaYcjqq+H0JfkC24uufidKsP
ZEuOWj1Fp4luHvXPkfN5atkRe7INh13RqKmO88l2HH7+ziOWbyPbc/R8+slS
UUZ24HCL6Va79YsT1D/HY5smRbUzGRz1ulaTY1aR3TjMhs0Nsyske3Ck7DLr
LnWRp3AMintdEwkV9c+xcNYgz8DfyT4ctlkTW0KLyH4cb6dlfszsIs9Rzz/k
p3Jdl5PUP4f/5a49RWvICzierNhRer6EvIhj2ryEtab/OUX9c+iv0TZ7MI0c
zpFetvi+wU5yBEfI6Ha9Sw/JURz/tU1T/mhxmvrn+EfaWbwuiByr/j6t72d2
202O5wgKPxB8+yl5A8f+NGZdb59P/XNEnbn2t8F68hb1eifYPpvbQE7jGJJc
8OOxCWeof45LmqEHXuaQmXq9GlbNBhYF1D+H18AhC+1zydkcK99OX6PleZb6
57jgWJgU2k4+zKEo+L1xbFYh9c9hbK+6O392EfXP8XxJ5JUS83PUP0fAsAfa
rs/JhRzf2Wm/KSg5T/2rnZUQruNzgfrn0OylYdjvKrmUo6LKou7ixIvUP0f+
P64qw1Jyhfr5nvNvP/T6k/rn6Nq/KlyrmlzNscwv8U/PsEvUP8dQ1UbF5k5y
A4dqamTwnuRi6p9j59lJpnOtS6h/jrBkxaK0EvIzjuzZ26NNwi5T/xxts4M0
gnWvUP8cVZNPrM44Tu7k+Jzk2r4poJT659CJL5rypfZf1L/A9q2VyU2nyFoC
7iYOuTULr1L/AudiMw6dMy6j/gWE1b5fA2+QewkkKHv3jku4Rv0LGOVvDO90
Kqf+BQJrXERDF9lUoHTe6Kkjzl+n/gXsvJ67jo69Qf0LnLkeIZlYVFD/AiOt
fTUnrCbbCCzLCxhmd59sJ9CkvBydPPYm9S/wyveuj0Ya2UHgy/AbXw1/RnYS
yDr9wqpgwi3qX2BSbegZ3XVkN4Fy56ERTVfIHgIW7wfcvNTjNvUv8K3ZSM8R
E8neAjrnXQKPrCX7CCS+so0ruED2Ezhe9sT+Xhd5jnr+c6e0pzhWUv8CF8+5
2gavJC9Q74ciV1lWQF4k0JiRrjL+QFYKsPw+C2yc71D/Amdfzlm8N54cITCm
Kidv6A1ylIBmp8PwYPMq6l+gT4vT1efLybEC8xzbI34pJ8cLPIhNNOXD71L/
AvGe7sd00slJAhO/mWMyr0c19S+g2+zsUpxMThPY/92gEdHmNdS/QPOEhA6P
U2QmsKXuesbLmbXUv4CyZ6TJ2C5ytoBr1fOEhzn3qH+BezYH61XBddS/QJe+
ic0y8/vUv8DyqFMRdY1klXq9oW3nCnLqqX8BG8XgCclRD6h/9f+2beqRK1YN
1L96fr+5eM3eSi4W8BzT5f6PRiP1LxBxy/zx7gjyNYFIX0flD63kCoGwqy2W
H0KaqH8B/zEXfXfVk6sF5u/2mzQ+8CH1L7Cjn7vb1Xpyg0BZ5uSDHmGPqH+B
S0N6lK1uJz8V0D7j3s8p5jH1L2Duerdjkl4z9S+wsSi27hdOfiNQObDniCS7
J9S/QOwSrxD/EvJH9f6ndr9/MOAp9S/BcFM3/cmvyVoSevj0Deme1EL9S7Bu
UW6uM2+l/iVY3miYdTOP3EtCUMrxy8Yef1P/Esaf/fpJWz3ZSIJF9U/Fa399
Rv1LUK6oWtzT4Dn1LyHBKKvpylGypYTy6TrjHnq1Uf8SDhyZHp3+gmwjYaWq
8Lhx2gvqX0LiOuUn/6/bqX/1/YnRQTaRZAcJ+fsCTq+/TnaSUGcYOOFn65fU
v4Rv+1Q4NK8lu0l4Vq9V86KB7CHB/KRn4GaXV9S/hLZbbxSlEtlbQuwv3p+Z
xmvqX0JHzdHU3qFkPwlpjWNefaogz5EwNthrqrXzG+pfQsvNbyoHHSYvkJB9
uE9uqvFb6l/C0h/H6Wv/QVZKmBh/39isgxwuwXaFg6ZywTvqX8Kw3HXtmyrI
URKcVF8YmDp2UP8SQjpbtx7bQ46VcLFV/2TpF53UvwTfxr+to4LJGyRg8DbV
ycJOl/8BB/+qiA==
          "]]}, 
        {RGBColor[0, 1, 0], PointSize[
          NCache[
           Rational[1, 180], 0.005555555555555556]], AbsoluteThickness[1.6], 
         Dashing[{Small, Small}], LineBox[CompressedData["
1:eJxN1ntUT1kfx/GYnjI0ZJSimKIoK8oj99sHGblMKhlKaNCUoZH0NEVjCpNK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          "]]}, 
        {RGBColor[0, 1, 0], PointSize[
          NCache[
           Rational[1, 180], 0.005555555555555556]], AbsoluteThickness[1.6], 
         Dashing[{0, Small, Small, Small}], LineBox[CompressedData["
1:eJxN03tYTfkex/FNjUsqTTUVonKroUkdZPNEH0QZUSeNGhkluYwyhSIJjUui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          "]]}, 
        {GrayLevel[0], PointSize[
          NCache[
           Rational[1, 180], 0.005555555555555556]], AbsoluteThickness[1.6], 
         LineBox[CompressedData["
1:eJxN03lcT9kfx/EvStF3SHZpMJpsWSd+jaXejSzDN2UbjUiMJUSLpVKZSlNJ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          "]]}}, {{}, {}}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{1765., 0},
      DisplayFunction->Identity,
      Epilog->InsetBox[
        FormBox[
         StyleBox[
         "\"b) Global Mean Surface Temperature Increase\"", {
          FontFamily -> "Helvetica", FontSize -> 20}, StripOnInput -> False], 
         TraditionalForm], 
        Offset[{0, 0}, 
         Scaled[{0.45, 0.9}]], 
        ImageScaled[{
          Rational[1, 2], 
          Rational[1, 2]}]],
      Frame->{{True, False}, {True, False}},
      FrameLabel->{{
         FormBox["\"\[Degree]C\"", TraditionalForm], None}, {
         FormBox["\"Year\"", TraditionalForm], None}},
      FrameStyle->{
        GrayLevel[0], 
        GrayLevel[0], Automatic, 
        GrayLevel[0]},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImageSize->600,
      LabelStyle->Directive[FontFamily -> "Helvetica", FontSize -> 18, 
        GrayLevel[0]],
      Method->{
       "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
        "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& )}},
      PlotRange->{{1765, 2018}, {0, 1.8}},
      PlotRangeClipping->True,
      PlotRangePadding->{{0, 0}, {0, 0}},
      Ticks->{Automatic, Automatic}]},
    {
     TemplateBox[{
       StyleBox["\"DICE16-  5y\"", FontFamily -> "Helvetica", FontSize -> 16, 
        GrayLevel[0], StripOnInput -> False], 
       StyleBox[
       "\"DICE16- 1y-calc\"", FontFamily -> "Helvetica", FontSize -> 16, 
        GrayLevel[0], StripOnInput -> False], 
       StyleBox[
       "\"DICE16- 1y-calb\"", FontFamily -> "Helvetica", FontSize -> 16, 
        GrayLevel[0], StripOnInput -> False], 
       StyleBox["\"DICE13-  5y\"", FontFamily -> "Helvetica", FontSize -> 16, 
        GrayLevel[0], StripOnInput -> False], 
       StyleBox[
       "\"DICE13- 1y-calc\"", FontFamily -> "Helvetica", FontSize -> 16, 
        GrayLevel[0], StripOnInput -> False], 
       StyleBox[
       "\"DICE13- 1y-calb\"", FontFamily -> "Helvetica", FontSize -> 16, 
        GrayLevel[0], StripOnInput -> False], 
       StyleBox["\"DICE07-10y\"", FontFamily -> "Helvetica", FontSize -> 16, 
        GrayLevel[0], StripOnInput -> False], 
       StyleBox[
       "\"DICE07- 1y-calc\"", FontFamily -> "Helvetica", FontSize -> 16, 
        GrayLevel[0], StripOnInput -> False], 
       StyleBox[
       "\"DICE07-1y-calb\"", FontFamily -> "Helvetica", FontSize -> 16, 
        GrayLevel[0], StripOnInput -> False], 
       StyleBox[
       "\"Fair-Geoffroy\"", FontFamily -> "Helvetica", FontSize -> 16, 
        GrayLevel[0], StripOnInput -> False]},
      "LineLegend",
      DisplayFunction->(StyleBox[
        StyleBox[
         PaneBox[
          TagBox[
           GridBox[{{
              TagBox[
               GridBox[{{
                  GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1]], {}}}, AspectRatio -> Full, 
                   ImageSize -> {40, 10}, PlotRangePadding -> None, 
                   ImagePadding -> Automatic, 
                   BaselinePosition -> (Scaled[0.1] -> Baseline)], #, 
                  GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1], 
                    Dashing[{Small, Small}]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1], 
                    Dashing[{Small, Small}]], {}}}, AspectRatio -> Full, 
                   ImageSize -> {40, 10}, PlotRangePadding -> None, 
                   ImagePadding -> Automatic, 
                   BaselinePosition -> (Scaled[0.1] -> Baseline)], #2, 
                  GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1], 
                    Dashing[{0, Small, Small, Small}]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1], 
                    Dashing[{0, Small, Small, Small}]], {}}}, AspectRatio -> 
                   Full, ImageSize -> {40, 10}, PlotRangePadding -> None, 
                   ImagePadding -> Automatic, 
                   BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}}, 
                GridBoxAlignment -> {
                 "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                AutoDelete -> False, 
                GridBoxDividers -> {
                 "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
                GridBoxSpacings -> {"Columns" -> {{0.8, 0.5}}}], "Grid"]}, {
              TagBox[
               GridBox[{{
                  GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0]], {}}}, AspectRatio -> Full, 
                   ImageSize -> {40, 10}, PlotRangePadding -> None, 
                   ImagePadding -> Automatic, 
                   BaselinePosition -> (Scaled[0.1] -> Baseline)], #4, 
                  GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0], 
                    Dashing[{Small, Small}]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0], 
                    Dashing[{Small, Small}]], {}}}, AspectRatio -> Full, 
                   ImageSize -> {40, 10}, PlotRangePadding -> None, 
                   ImagePadding -> Automatic, 
                   BaselinePosition -> (Scaled[0.1] -> Baseline)], #5, 
                  GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0], 
                    Dashing[{0, Small, Small, Small}]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0], 
                    Dashing[{0, Small, Small, Small}]], {}}}, AspectRatio -> 
                   Full, ImageSize -> {40, 10}, PlotRangePadding -> None, 
                   ImagePadding -> Automatic, 
                   BaselinePosition -> (Scaled[0.1] -> Baseline)], #6}}, 
                GridBoxAlignment -> {
                 "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                AutoDelete -> False, 
                GridBoxDividers -> {
                 "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
                GridBoxSpacings -> {"Columns" -> {{0.8, 0.5}}}], "Grid"]}, {
              TagBox[
               GridBox[{{
                  GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 1, 0]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 1, 0]], {}}}, AspectRatio -> Full, 
                   ImageSize -> {40, 10}, PlotRangePadding -> None, 
                   ImagePadding -> Automatic, 
                   BaselinePosition -> (Scaled[0.1] -> Baseline)], #7, 
                  GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 1, 0], 
                    Dashing[{Small, Small}]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 1, 0], 
                    Dashing[{Small, Small}]], {}}}, AspectRatio -> Full, 
                   ImageSize -> {40, 10}, PlotRangePadding -> None, 
                   ImagePadding -> Automatic, 
                   BaselinePosition -> (Scaled[0.1] -> Baseline)], #8, 
                  GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 1, 0], 
                    Dashing[{0, Small, Small, Small}]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 1, 0], 
                    Dashing[{0, Small, Small, Small}]], {}}}, AspectRatio -> 
                   Full, ImageSize -> {40, 10}, PlotRangePadding -> None, 
                   ImagePadding -> Automatic, 
                   BaselinePosition -> (Scaled[0.1] -> Baseline)], #9}}, 
                GridBoxAlignment -> {
                 "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                AutoDelete -> False, 
                GridBoxDividers -> {
                 "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
                GridBoxSpacings -> {"Columns" -> {{0.8, 0.5}}}], "Grid"]}, {
              TagBox[
               GridBox[{{
                  GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0]], {}}}, AspectRatio -> Full, 
                   ImageSize -> {40, 10}, PlotRangePadding -> None, 
                   ImagePadding -> Automatic, 
                   BaselinePosition -> (Scaled[0.1] -> Baseline)], #10}}, 
                GridBoxAlignment -> {
                 "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                AutoDelete -> False, 
                GridBoxDividers -> {
                 "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
                GridBoxSpacings -> {"Columns" -> {{0.8, 0.5}}}], "Grid"]}}, 
            GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
            AutoDelete -> False, 
            GridBoxDividers -> {"Columns" -> {{None}}, "Rows" -> {{None}}}, 
            GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
            GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{1}}}], 
           "Grid"], Alignment -> Left, AppearanceElements -> None, 
          ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> "ResizeToFit"],
          LineIndent -> 0, StripOnInput -> False], {FontFamily -> "Arial"}, 
        Background -> Automatic, StripOnInput -> False]& ),
      Editable->True,
      InterpretationFunction:>(RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               InterpretationBox[
                ButtonBox[
                 TooltipBox[
                  GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                   "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                   FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                   FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                   Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                  StyleBox[
                   RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                   False]], Appearance -> None, BaseStyle -> {}, 
                 BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                 ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                   If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                 Automatic, Method -> "Preemptive"], 
                RGBColor[0, 0, 1], Editable -> False, Selectable -> False], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 0, 1], Editable -> False, Selectable -> 
                    False], ",", 
                   RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"Small", ",", "Small"}], "}"}], "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 0, 1], Editable -> False, Selectable -> 
                    False], ",", 
                   RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "Small", ",", "Small", ",", "Small"}], 
                    "}"}], "]"}]}], "]"}], ",", 
               InterpretationBox[
                ButtonBox[
                 TooltipBox[
                  GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                   "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                   FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                   FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                   Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                  StyleBox[
                   RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0", ",", "0"}], "]"}], NumberMarks -> 
                   False]], Appearance -> None, BaseStyle -> {}, 
                 BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                 ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                   If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                 Automatic, Method -> "Preemptive"], 
                RGBColor[1, 0, 0], Editable -> False, Selectable -> False], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0, 0], Editable -> False, Selectable -> 
                    False], ",", 
                   RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"Small", ",", "Small"}], "}"}], "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0, 0], Editable -> False, Selectable -> 
                    False], ",", 
                   RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "Small", ",", "Small", ",", "Small"}], 
                    "}"}], "]"}]}], "]"}], ",", 
               InterpretationBox[
                ButtonBox[
                 TooltipBox[
                  GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                   "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                   FrameStyle -> RGBColor[0., 0.6666666666666666, 0.], 
                   FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                   Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                  StyleBox[
                   RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "1", ",", "0"}], "]"}], NumberMarks -> 
                   False]], Appearance -> None, BaseStyle -> {}, 
                 BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                 ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                   If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 1, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                 Automatic, Method -> "Preemptive"], 
                RGBColor[0, 1, 0], Editable -> False, Selectable -> False], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0.6666666666666666, 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "1", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 1, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 1, 0], Editable -> False, Selectable -> 
                    False], ",", 
                   RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"Small", ",", "Small"}], "}"}], "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0.6666666666666666, 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "1", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 1, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 1, 0], Editable -> False, Selectable -> 
                    False], ",", 
                   RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "Small", ",", "Small", ",", "Small"}], 
                    "}"}], "]"}]}], "]"}], ",", 
               InterpretationBox[
                ButtonBox[
                 TooltipBox[
                  GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                   "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                   FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                   PlotRangePadding -> None, ImageSize -> 
                   Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                  StyleBox[
                   RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                   False]], Appearance -> None, BaseStyle -> {}, 
                 BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                 ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                   If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                 Automatic, Method -> "Preemptive"], 
                GrayLevel[0], Editable -> False, Selectable -> False]}], 
             "}"}], ",", 
           RowBox[{"{", 
             
             RowBox[{#, ",", #2, ",", #3, ",", #4, ",", #5, ",", #6, ",", #7, 
               ",", #8, ",", #9, ",", #10}], "}"}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"\"Row\"", ",", "4"}], "}"}]}]}], "]"}]& )]}
   },
   AutoDelete->False,
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellChangeTimes->{
  3.8228022053015156`*^9, {3.822802270091607*^9, 3.822802341041707*^9}, {
   3.822836423870176*^9, 3.8228364653582344`*^9}, 3.822836503593288*^9, 
   3.82418518371249*^9},
 CellLabel->
  "Out[1918]=",ExpressionUUID->"b2b4aec8-b88c-4acf-805a-06b50ffd8e36"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<Figure_S2_SpinUpOverview.tiff\>\"", ",", "SpinupPlot"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.82280234341271*^9, 3.8228023766772575`*^9}, {
  3.8228360376405754`*^9, 3.8228360382905765`*^9}},
 CellLabel->
  "In[1919]:=",ExpressionUUID->"3c52d087-8eb2-4a65-bea3-d616886f15f6"],

Cell[BoxData["\<\"Figure_S2_SpinUpOverview.tiff\"\>"], "Output",
 CellChangeTimes->{3.822802379907262*^9, 3.8228365060442915`*^9, 
  3.8241851923484125`*^9},
 CellLabel->
  "Out[1919]=",ExpressionUUID->"17b1defb-c28c-41a1-9b68-b89f37a11c89"]
}, Open  ]],

Cell["\<\
Use Fair-Geoffroy spin up to determine starting values for 2015\
\>", "Text",
 CellChangeTimes->{{3.71113575119866*^9, 3.7111357648642597`*^9}, {
  3.711171131470954*^9, 3.711171132484956*^9}, {3.712408724609439*^9, 
  3.7124087395614595`*^9}, {3.7662479249546547`*^9, 3.7662479290036545`*^9}, {
  3.810276061054193*^9, 3.810276074321699*^9}, {3.8227646837663717`*^9, 
  3.822764705489403*^9}},
 FontSize->18,
 Background->RGBColor[
  0.87, 0.94, 1],ExpressionUUID->"bd6d03f7-5c59-4ac2-8b7c-965bec1fc652"],

Cell[BoxData[{
 RowBox[{"IVFairwFex2015", "=", 
  RowBox[{
  "Import", "[", "\"\<IVFairwFex2015.csv\>\"", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"IVFairwoFex2015", "=", 
  RowBox[{"Import", "[", "\"\<IVFairwoFex2015.csv\>\"", "]"}]}]}], "Input",
 CellChangeTimes->{{3.8241874459179726`*^9, 
  3.82418748819783*^9}},ExpressionUUID->"137bc31b-1e4d-492d-9496-\
53bd0a59682a"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"cwoFexstartvalues2015", "=", 
  RowBox[{"IVFairwoFex2015", "[", 
   RowBox[{"[", 
    RowBox[{"2", ",", 
     RowBox[{"3", ";;", "6"}]}], "]"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"ccawoFexstartvalues2015", "=", 
  RowBox[{"IVFairwoFex2015", "[", 
   RowBox[{"[", 
    RowBox[{"2", ",", "8"}], "]"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"twoFexstartvalues2015", "=", 
  RowBox[{"IVFairwoFex2015", "[", 
   RowBox[{"[", 
    RowBox[{"2", ",", 
     RowBox[{"12", ";;", "15"}]}], "]"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"cwFexstartvalues2015", "=", 
  RowBox[{"IVFairwFex2015", "[", 
   RowBox[{"[", 
    RowBox[{"2", ",", 
     RowBox[{"3", ";;", "6"}]}], "]"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"ccawFexstartvalues2015", "=", 
  RowBox[{"IVFairwFex2015", "[", 
   RowBox[{"[", 
    RowBox[{"2", ",", "8"}], "]"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"twFexstartvalues2015", "=", 
  RowBox[{"IVFairwFex2015", "[", 
   RowBox[{"[", 
    RowBox[{"2", ",", 
     RowBox[{"12", ";;", "15"}]}], "]"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"conlystartvalues2018", "=", 
    RowBox[{
     RowBox[{
      RowBox[{"transFairG", "[", 
       RowBox[{"[", 
        RowBox[{"255", ",", 
         RowBox[{"3", ";;", "6"}]}], "]"}], "]"}], "\[IndentingNewLine]", 
      "cconlystartvalues2018"}], "=", 
     RowBox[{
      RowBox[{
       RowBox[{"transFairG", "[", 
        RowBox[{"[", 
         RowBox[{"255", ",", "8"}], "]"}], "]"}], "\[IndentingNewLine]", 
       "tconlystartvalues2018"}], "=", 
      RowBox[{"transFairG", "[", 
       RowBox[{"[", 
        RowBox[{"255", ",", 
         RowBox[{"12", ";;", "15"}]}], "]"}], "]"}]}]}]}], "*)"}]}]}], "Input",
 CellChangeTimes->{{3.817239776011119*^9, 3.8172397817056475`*^9}, {
  3.8227642965457153`*^9, 3.8227642977757173`*^9}, {3.822836941742019*^9, 
  3.822836960814046*^9}, {3.8231539218536415`*^9, 3.823153925026146*^9}, {
  3.8241871125009212`*^9, 3.824187146263844*^9}, {3.824187205094396*^9, 
  3.824187248393919*^9}},
 CellLabel->
  "In[1943]:=",ExpressionUUID->"b3579501-872b-42d6-81e4-a6b53d9c0ad0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "57.5986822288036`", ",", "42.34107372660842`", ",", "17.112100687069187`", 
   ",", "2.7856856326908783`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.8172397840167503`*^9, 3.818438764153632*^9, 3.818439264633337*^9, 
   3.822764253955655*^9, 3.822764299235719*^9, {3.8228369513730326`*^9, 
   3.822836961354047*^9}, 3.8241871498102226`*^9, 3.824187209452523*^9, 
   3.824187249349472*^9, 3.824187564591673*^9},
 CellLabel->
  "Out[1943]=",ExpressionUUID->"a53ac330-cfc0-467b-87dc-67df4735e648"],

Cell[BoxData["307.98114938782794`"], "Output",
 CellChangeTimes->{
  3.8172397840167503`*^9, 3.818438764153632*^9, 3.818439264633337*^9, 
   3.822764253955655*^9, 3.822764299235719*^9, {3.8228369513730326`*^9, 
   3.822836961354047*^9}, 3.8241871498102226`*^9, 3.824187209452523*^9, 
   3.824187249349472*^9, 3.8241875645981803`*^9},
 CellLabel->
  "Out[1944]=",ExpressionUUID->"c572fcf8-23e0-4152-a0b9-77f1604c5ade"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.8585809605695092`", ",", "0.10589535542587128`", ",", 
   RowBox[{"-", "0.021543930941356156`"}], ",", "0.2480336489426177`"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.8172397840167503`*^9, 3.818438764153632*^9, 3.818439264633337*^9, 
   3.822764253955655*^9, 3.822764299235719*^9, {3.8228369513730326`*^9, 
   3.822836961354047*^9}, 3.8241871498102226`*^9, 3.824187209452523*^9, 
   3.824187249349472*^9, 3.8241875645981803`*^9},
 CellLabel->
  "Out[1945]=",ExpressionUUID->"47cf45e4-d68e-49f4-8c53-67f28ece1539"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "57.5986830980235`", ",", "42.42320774367723`", ",", "17.512988020164883`", 
   ",", "2.9152188930925496`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.8172397840167503`*^9, 3.818438764153632*^9, 3.818439264633337*^9, 
   3.822764253955655*^9, 3.822764299235719*^9, {3.8228369513730326`*^9, 
   3.822836961354047*^9}, 3.8241871498102226`*^9, 3.824187209452523*^9, 
   3.824187249349472*^9, 3.8241875646138077`*^9},
 CellLabel->
  "Out[1946]=",ExpressionUUID->"4557a40f-55a3-41f8-9940-339ec87a3f98"],

Cell[BoxData["306.68253177068163`"], "Output",
 CellChangeTimes->{
  3.8172397840167503`*^9, 3.818438764153632*^9, 3.818439264633337*^9, 
   3.822764253955655*^9, 3.822764299235719*^9, {3.8228369513730326`*^9, 
   3.822836961354047*^9}, 3.8241871498102226`*^9, 3.824187209452523*^9, 
   3.824187249349472*^9, 3.8241875646138077`*^9},
 CellLabel->
  "Out[1947]=",ExpressionUUID->"b7c782d2-b4b5-450f-ba43-4ef8f0d5b9b2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.9880133681630512`", ",", "0.10634114593113277`", ",", 
   RowBox[{"-", "0.0247917118482599`"}], ",", "0.24907780281734904`"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.8172397840167503`*^9, 3.818438764153632*^9, 3.818439264633337*^9, 
   3.822764253955655*^9, 3.822764299235719*^9, {3.8228369513730326`*^9, 
   3.822836961354047*^9}, 3.8241871498102226`*^9, 3.824187209452523*^9, 
   3.824187249349472*^9, 3.8241875646138077`*^9},
 CellLabel->
  "Out[1948]=",ExpressionUUID->"721e089b-3875-4f8c-b353-b64d81fcffc6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"TwoFexDice2015", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Total", "[", 
     RowBox[{"twoFexstartvalues2015", "[", 
      RowBox[{"[", 
       RowBox[{"1", ";;", "2"}], "]"}], "]"}], "]"}], ",", 
    RowBox[{"Total", "[", 
     RowBox[{"twoFexstartvalues2015", "[", 
      RowBox[{"[", 
       RowBox[{"3", ";;", "4"}], "]"}], "]"}], "]"}]}], 
   "}"}]}], "\[IndentingNewLine]", 
 RowBox[{"TwFexDice2015", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Total", "[", 
     RowBox[{"twFexstartvalues2015", "[", 
      RowBox[{"[", 
       RowBox[{"1", ";;", "2"}], "]"}], "]"}], "]"}], ",", 
    RowBox[{"Total", "[", 
     RowBox[{"twFexstartvalues2015", "[", 
      RowBox[{"[", 
       RowBox[{"3", ";;", "4"}], "]"}], "]"}], "]"}]}], "}"}]}]}], "Input",
 CellChangeTimes->{{3.822842415003175*^9, 3.822842493486285*^9}, {
  3.82418729954327*^9, 3.824187334407423*^9}, {3.8241884901405134`*^9, 
  3.8241885013648915`*^9}},
 CellLabel->
  "In[1964]:=",ExpressionUUID->"cae6f9c4-ba52-4d03-b634-52d9a9361262"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.9644763159953804`", ",", "0.22648971800126155`"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.8228424743842583`*^9, 3.8228424967072897`*^9}, 
   3.824187336627592*^9, 3.8241885020133142`*^9},
 CellLabel->
  "Out[1964]=",ExpressionUUID->"5a255d47-da8d-41e8-aec8-f65cd44ebe7b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.094354514094184`", ",", "0.22428609096908914`"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.8228424743842583`*^9, 3.8228424967072897`*^9}, 
   3.824187336627592*^9, 3.8241885020289545`*^9},
 CellLabel->
  "Out[1965]=",ExpressionUUID->"6338a827-dc07-4cbf-bc62-a05e830ab23c"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
  "use", " ", "distribution", " ", "in", " ", "2015", " ", "of", " ", 
   "temperature", " ", "values", " ", "to", " ", "recalculate", " ", "start", 
   " ", "values", " ", "in", " ", "case", " ", "you", " ", "want", " ", "to", 
   " ", "start", " ", "FAIR", " ", "with", " ", "DICE", " ", "temperature", 
   " ", "values"}], "*)"}]], "Input",
 CellChangeTimes->{{3.8227644541249924`*^9, 3.822764486059037*^9}, {
  3.8227645457691216`*^9, 
  3.8227645585601397`*^9}},ExpressionUUID->"d6240b2e-855a-4f6b-9361-\
2fbfd0468f13"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FairGCBATstartvalues2015", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"0.85", "*", 
     RowBox[{
      RowBox[{"twFexstartvalues2015", "[", 
       RowBox[{"[", "1", "]"}], "]"}], "/", 
      RowBox[{"Total", "[", 
       RowBox[{"twFexstartvalues2015", "[", 
        RowBox[{"[", 
         RowBox[{"1", ";;", "2"}], "]"}], "]"}], "]"}]}]}], ",", 
    RowBox[{"0.85", "*", 
     RowBox[{
      RowBox[{"twFexstartvalues2015", "[", 
       RowBox[{"[", "2", "]"}], "]"}], "/", 
      RowBox[{"Total", "[", 
       RowBox[{"twFexstartvalues2015", "[", 
        RowBox[{"[", 
         RowBox[{"1", ";;", "2"}], "]"}], "]"}], "]"}]}]}], ",", 
    RowBox[{"0.0068", "*", 
     RowBox[{
      RowBox[{"twFexstartvalues2015", "[", 
       RowBox[{"[", "3", "]"}], "]"}], "/", 
      RowBox[{"Total", "[", 
       RowBox[{"twFexstartvalues2015", "[", 
        RowBox[{"[", 
         RowBox[{"3", ";;", "4"}], "]"}], "]"}], "]"}]}]}], ",", 
    RowBox[{"0.0068", "*", 
     RowBox[{
      RowBox[{"twFexstartvalues2015", "[", 
       RowBox[{"[", "4", "]"}], "]"}], "/", 
      RowBox[{"Total", "[", 
       RowBox[{"twFexstartvalues2015", "[", 
        RowBox[{"[", 
         RowBox[{"3", ";;", "4"}], "]"}], "]"}], "]"}]}]}]}], 
   "}"}]}]], "Input",
 CellChangeTimes->{{3.816718838634534*^9, 3.816718976446799*^9}, {
  3.816719052282091*^9, 3.8167191322024097`*^9}, {3.824187512437211*^9, 
  3.8241875214272733`*^9}, {3.824187599077925*^9, 3.82418768875239*^9}},
 CellLabel->
  "In[1949]:=",ExpressionUUID->"078267cd-43ae-4453-bd78-19e2897d392e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.7674033890505033`", ",", "0.08259661094949673`", ",", 
   RowBox[{"-", "0.0007516455427073333`"}], ",", "0.007551645542707334`"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.8167188634225063`*^9, 3.81671887131812*^9}, {
   3.816718923441502*^9, 3.816718977260962*^9}, 3.8167191328485627`*^9, 
   3.8171382081489334`*^9, 3.818438943014884*^9, 3.818439272045347*^9, 
   3.8227645639421473`*^9, 3.8241876897236233`*^9},
 CellLabel->
  "Out[1949]=",ExpressionUUID->"2666cc1c-0bb2-4791-a783-b308aa836fd7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"atmosstock2015woFex", "=", 
  RowBox[{"IVFairwoFex2015", "[", 
   RowBox[{"[", 
    RowBox[{"2", ",", "20"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.822838493531578*^9, 3.822838573557691*^9}, {
  3.824187720114817*^9, 3.8241877352476344`*^9}},
 CellLabel->
  "In[1950]:=",ExpressionUUID->"9e5c4ae6-adc0-4671-bb14-0029692ca9e5"],

Cell[BoxData["843.418577104893`"], "Output",
 CellChangeTimes->{{3.822838547322654*^9, 3.8228385749876933`*^9}, 
   3.824187736349972*^9},
 CellLabel->
  "Out[1950]=",ExpressionUUID->"c0430035-20fa-4b6f-bc66-cf2b97c7ba8f"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"transferyCC13", "[", 
    RowBox[{"[", 
     RowBox[{"i", ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"transferyCC13", "[", 
      RowBox[{"[", 
       RowBox[{
        RowBox[{"i", "-", "1"}], ",", 
        RowBox[{"{", 
         RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "]"}], "]"}], ".", 
     "b5"}], "+", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0"}], "}"}], "*", 
     RowBox[{"transferyCC13", "[", 
      RowBox[{"[", 
       RowBox[{
        RowBox[{"i", "-", "1"}], ",", "2"}], "]"}], "]"}]}]}]}], 
  ","}]], "Input",ExpressionUUID->"a2773715-98c1-4f84-92fc-43797b405761"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"intCC132015", "=", 
   RowBox[{
    RowBox[{"intCC132010", ".", "b5"}], "+", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0"}], "}"}], "*", 
     RowBox[{"transferyCC13", "[", 
      RowBox[{"[", 
       RowBox[{"51", ",", "2"}], "]"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"intCC132015", "[", 
    RowBox[{"[", "1", "]"}], "]"}], "=", "atmosstock2015woFex"}], 
  ";"}], "\[IndentingNewLine]", "intCC132015"}], "Input",
 CellChangeTimes->{{3.8228402542220707`*^9, 3.8228402809571085`*^9}, {
  3.822840336786187*^9, 3.822840422410308*^9}, {3.824187756065055*^9, 
  3.824187769096394*^9}},
 CellLabel->
  "In[1954]:=",ExpressionUUID->"f02742d6-7716-4b1d-a267-f30fdff4ffcf"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "843.418577104893`", ",", "1541.1078616666668`", ",", 
   "10010.439124999999`"}], "}"}]], "Output",
 CellChangeTimes->{{3.8228402673050895`*^9, 3.8228402817171097`*^9}, 
   3.822840348429204*^9, 3.8228403856042557`*^9, 3.822840422890309*^9, {
   3.8241877604908915`*^9, 3.8241877698294163`*^9}},
 CellLabel->
  "Out[1956]=",ExpressionUUID->"1e5ba992-7de9-4ad1-9319-0abf48684352"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"intCC072015", "=", 
   RowBox[{
    RowBox[{"intCC072005", ".", "d10"}], "+", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0"}], "}"}], "*", 
     RowBox[{"transferyCC07", "[", 
      RowBox[{"[", 
       RowBox[{"25", ",", "2"}], "]"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"intCC072015", "[", 
    RowBox[{"[", "1", "]"}], "]"}], "=", "atmosstock2015woFex"}], 
  ";"}], "\[IndentingNewLine]", "intCC072015"}], "Input",
 CellChangeTimes->{{3.8231484963367715`*^9, 3.823148507551287*^9}, {
   3.8231485533228517`*^9, 3.823148588240401*^9}, 3.8241877781022043`*^9},
 CellLabel->
  "In[1957]:=",ExpressionUUID->"a05d827c-e6c3-4d65-8fc7-8b0e63d62b47"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "843.418577104893`", ",", "1280.639439195`", ",", "18370.47503777`"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.8231485022202797`*^9, 3.823148556725356*^9, 
  3.8231485910329046`*^9, 3.824187779821845*^9},
 CellLabel->
  "Out[1959]=",ExpressionUUID->"e279dc8d-e2fa-43b7-82b2-007ac553bbb5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Export", "[", 
  RowBox[{"\"\<initalvaluesCC072015.csv\>\"", ",", "intCC072015"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{"\"\<initalvaluesCC132015.csv\>\"", ",", "intCC132015"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.822841674744076*^9, 3.8228417174111357`*^9}},
 CellLabel->
  "In[1960]:=",ExpressionUUID->"665d5027-2e18-4f16-8576-a603ed5a4b6c"],

Cell[BoxData["\<\"initalvaluesCC072015.csv\"\>"], "Output",
 CellChangeTimes->{3.8228417186611376`*^9, 3.823148613975937*^9, 
  3.824187790709851*^9},
 CellLabel->
  "Out[1960]=",ExpressionUUID->"e471f723-bd10-41f0-9677-a04efbdb9f09"],

Cell[BoxData["\<\"initalvaluesCC132015.csv\"\>"], "Output",
 CellChangeTimes->{3.8228417186611376`*^9, 3.823148613975937*^9, 
  3.824187790709851*^9},
 CellLabel->
  "Out[1961]=",ExpressionUUID->"c9a22c9b-720e-4573-b363-7a0dca21e006"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["intC162015"], "Input",
 CellChangeTimes->{{3.8241907471938353`*^9, 3.8241907522399735`*^9}},
 CellLabel->
  "In[1975]:=",ExpressionUUID->"f2ee1ce3-df12-431e-a8fd-9a48cd68b0ef"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"851", ",", "460", ",", "1740"}], "}"}]], "Output",
 CellChangeTimes->{3.8241907528234067`*^9},
 CellLabel->
  "Out[1975]=",ExpressionUUID->"e1b9cac1-749b-48c5-b1c6-fadddb0e61d2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"intCC162015", "=", "intC162015"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"intCC162015", "[", 
    RowBox[{"[", "1", "]"}], "]"}], "=", "atmosstock2015woFex"}], 
  ";"}], "\[IndentingNewLine]", "intCC162015"}], "Input",
 CellChangeTimes->{{3.8241907670429597`*^9, 3.8241908049370203`*^9}},
 CellLabel->
  "In[1976]:=",ExpressionUUID->"c20e81e7-33a1-4c97-af06-edf835876901"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"843.418577104893`", ",", "460", ",", "1740"}], "}"}]], "Output",
 CellChangeTimes->{3.8241908057234526`*^9},
 CellLabel->
  "Out[1978]=",ExpressionUUID->"4e4bbb6d-6ee4-41be-8a30-32e496a24472"]
}, Open  ]],

Cell["Fair Geoffroy Simulation of DICE CBA paths", "Text",
 CellChangeTimes->{{3.71113575119866*^9, 3.7111357648642597`*^9}, {
  3.711171131470954*^9, 3.711171132484956*^9}, {3.712408724609439*^9, 
  3.7124087395614595`*^9}, {3.7662479249546547`*^9, 3.7662479290036545`*^9}, {
  3.810276061054193*^9, 3.810276074321699*^9}, {3.8167180604130163`*^9, 
  3.816718074126128*^9}},
 FontSize->18,
 Background->RGBColor[
  0.87, 0.94, 1],ExpressionUUID->"0b2b37f7-0fd9-4b1e-9ffd-cd9d88c1c4b3"],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "SetDirectory", "[", 
   "\"\<C:\\\\Users\\\\wilmsen\\\\Dropbox\\\\WR\\\\Research\\\\IMPOSE\\\\\
Results_Paper\\\\CBA\>\"", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.8231501582144065`*^9, 3.82315016049691*^9}, {
  3.8231503788508453`*^9, 3.823150399450429*^9}},
 CellLabel->
  "In[727]:=",ExpressionUUID->"7ad51077-f534-459e-91c6-a628d720c9fe"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"dataCBA", "=", 
    RowBox[{"Import", "[", "\"\<CBA_Emissionspaths.csv\>\"", "]"}]}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"dataCBA", "=", 
     RowBox[{"Import", "[", "\"\<CBA_Emissionspaths_IntFair.csv\>\"", "]"}]}],
     ";"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"Dimensions", "[", "dataCBA", "]"}]}], "Input",
 CellChangeTimes->{{3.8167180147412963`*^9, 3.816718033657961*^9}, {
  3.8167191751585956`*^9, 3.8167191837750187`*^9}, {3.8171409060788*^9, 
  3.8171409064107685`*^9}, {3.8171409525861144`*^9, 3.8171409592502728`*^9}, {
  3.823150401191432*^9, 3.82315040704394*^9}, {3.8231504960855656`*^9, 
  3.8231505038380766`*^9}, {3.823150548369194*^9, 3.8231505595917096`*^9}, {
  3.8231541212804227`*^9, 3.823154129512934*^9}, {3.8231541784650583`*^9, 
  3.823154187682126*^9}, {3.8231613484691334`*^9, 3.8231613555491433`*^9}, {
  3.8231613883001895`*^9, 
  3.8231613981252584`*^9}},ExpressionUUID->"53c2a3dd-45ed-484b-ab67-\
cde2aa5c4aa3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"92", ",", "13"}], "}"}]], "Output",
 CellChangeTimes->{
  3.8167191846630387`*^9, 3.817138160203704*^9, 3.817139165500993*^9, 
   3.8171409599093466`*^9, 3.8184387972166786`*^9, 3.818439177606214*^9, 
   3.818439283296363*^9, {3.8231504087964425`*^9, 3.82315041431645*^9}, 
   3.823150504478077*^9, 3.823154090460379*^9, 3.8231541301329355`*^9, 
   3.823161135688777*^9, 3.823161356550144*^9},
 CellLabel->
  "Out[784]=",ExpressionUUID->"171ad16c-0266-48e0-9ee4-3c1d82b8682d"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"FairCBAOutput", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "92"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "14"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"FairCBAOutput", "[", 
    RowBox[{"[", "1", "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
    "\"\<Counter\>\"", ",", "\"\<year\>\"", ",", "\"\<C5y_FD\>\"", ",", 
     "\"\<C1ycalc_FD\>\"", ",", "\"\<C1ycalb_FD\>\"", ",", "\"\<C5y_Fex\>\"", 
     ",", "\"\<C1ycalc_Fex\>\"", ",", "\"\<C1ycalb_Fex\>\"", ",", 
     "\"\<T_5y_FD\>\"", ",", "\"\<T_1ycalc_FD\>\"", ",", 
     "\"\<T_1ycalb_FD\>\"", ",", "\"\<T_5y_Fex\>\"", ",", 
     "\"\<T_1ycalc_Fex\>\"", ",", "\"\<T_1ycalb_Fex\>\""}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"FairCBAOutput", "[", 
     RowBox[{"[", 
      RowBox[{"n", ",", "1"}], "]"}], "]"}], "=", 
    RowBox[{"n", "-", "1"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "2", ",", "92"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"FairCBAOutput", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"n", "+", "2"}], ",", "2"}], "]"}], "]"}], "=", 
    RowBox[{"2015", "+", "n"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "90"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.8167195855206413`*^9, 3.816719812304016*^9}},
 CellLabel->
  "In[785]:=",ExpressionUUID->"320c12c8-0405-4867-9100-977a63030e40"],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"y", "=", "92"}], ",", "\[IndentingNewLine]", 
     RowBox[{"transFairG", "=", 
      RowBox[{"Table", "[", 
       RowBox[{"0", ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "y"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"j", ",", "20"}], "}"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"transFairG", "[", 
       RowBox[{"[", "1", "]"}], "]"}], "=", 
      RowBox[{"{", 
       RowBox[{
       "\"\<1-Y\>\"", ",", "\"\<2-E\>\"", ",", "\"\<3-R1\>\"", ",", 
        "\"\<4-R2\>\"", ",", "\"\<5-R3\>\"", ",", "\"\<6-R4\>\"", ",", 
        "\"\<7-C\>\"", ",", "\"\<8-CCA\>\"", ",", "\"\<9-F\>\"", ",", 
        "\"\<10-Fex\>\"", ",", "\"\<11-TF\>\"", ",", "\"\<12-TMF\>\"", ",", 
        "\"\<13-TMS\>\"", ",", "\"\<14-TDF\>\"", ",", "\"\<15-TDS\>\"", ",", 
        "\"\<16-TM\>\"", ",", "\"\<17-TD\>\"", ",", "\"\<18-\[Alpha]\>\"", 
        ",", "\"\<19-\[Alpha]check\>\"", ",", "\"\<20-atmosGt\>\""}], "}"}]}],
      ",", "\[IndentingNewLine]", 
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"transFairG", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"n", "+", "1"}], ",", "1"}], "]"}], "]"}], "=", 
        RowBox[{"2015", "-", "1", "+", "n"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "1", ",", 
         RowBox[{"y", "-", "1"}]}], "}"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"emcolumns", "=", 
      RowBox[{"{", 
       RowBox[{"2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7"}], 
       "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{
       RowBox[{
        RowBox[{"transFairG", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;"}], ",", "2"}], "]"}], "]"}], "=", 
        RowBox[{
         RowBox[{"dtemp", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;"}], ",", "3"}], "]"}], "]"}], "/", "2.12"}]}], 
       ","}], "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"transFairG", "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{"2", ";;", "y"}], ",", "2"}], "]"}], "]"}], "=", 
      RowBox[{
       RowBox[{"dataCBA", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;", "92"}], ",", 
          RowBox[{"emcolumns", "[", 
           RowBox[{"[", "k", "]"}], "]"}]}], "]"}], "]"}], "/", 
       "2.1293970467500096"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"transFairG", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "4", ",", "5", ",", "6"}], "}"}]}], "]"}], "]"}], 
      "=", "cstartvalues2015"}], ",", " ", 
     RowBox[{"(*", 
      RowBox[{
       RowBox[{
       "initial", " ", "carbon", " ", "values", " ", "for", " ", "R1"}], ",", 
       "R2", ",", "R3", ",", "R4"}], "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"transFairG", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", "7"}], "]"}], "]"}], "=", 
      RowBox[{
       RowBox[{"Total", "[", 
        RowBox[{"transFairG", "[", 
         RowBox[{"[", 
          RowBox[{"2", ",", 
           RowBox[{"3", ";;", "6"}]}], "]"}], "]"}], "]"}], "+", 
       "278.0014091894"}]}], ",", " ", 
     RowBox[{"(*", 
      RowBox[{
      "initial", " ", "atmospheric", " ", "carbon", " ", "concentration"}], 
      "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"transFairG", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", "8"}], "]"}], "]"}], "=", "ccastartvalues2015"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"transFairG", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", "9"}], "]"}], "]"}], "=", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"F2x", "/", 
          RowBox[{"Log", "[", "2", "]"}]}], ")"}], "*", 
        RowBox[{"Log", "[", 
         RowBox[{
          RowBox[{"transFairG", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "7"}], "]"}], "]"}], "/", "278"}], "]"}]}], "/.",
        "parFair"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"fexcolumns", "=", 
      RowBox[{"{", 
       RowBox[{"8", ",", "9", ",", "10", ",", "11", ",", "12", ",", "13"}], 
       "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"transFairG", "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{"2", ";;"}], ",", "10"}], "]"}], "]"}], "=", 
      RowBox[{"dataCBA", "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{"2", ";;", "92"}], ",", 
         RowBox[{"fexcolumns", "[", 
          RowBox[{"[", "k", "]"}], "]"}]}], "]"}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"transFairG", "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{"2", ";;"}], ",", "11"}], "]"}], "]"}], "=", 
      RowBox[{"Total", "[", 
       RowBox[{"transFairG", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", 
          RowBox[{"9", ";;", "10"}]}], "]"}], "]"}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"transFairG", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", 
         RowBox[{"{", 
          RowBox[{"12", ",", "13", ",", "14", ",", "15"}], "}"}]}], "]"}], 
       "]"}], "=", "tstartvalues2015"}], ",", " ", 
     RowBox[{"(*", 
      RowBox[{
      "initial", " ", "values", " ", "for", " ", "Mix", " ", "Layer", " ", 
       "Fast", " ", "and", " ", "Slow", " ", "Response", " ", "and", " ", 
       "Deep", " ", "Layer", " ", "Fast", " ", "and", " ", "Slow", " ", 
       "Response"}], "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"transFairG", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", "16"}], "]"}], "]"}], "=", 
      RowBox[{"Total", "[", 
       RowBox[{"transFairG", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", 
          RowBox[{"12", ";;", "13"}]}], "]"}], "]"}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"transFairG", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", "17"}], "]"}], "]"}], "=", 
      RowBox[{"Total", "[", 
       RowBox[{"transFairG", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", 
          RowBox[{"14", ";;", "15"}]}], "]"}], "]"}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"transFairG", "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{"2", ";;"}], ",", "18"}], "]"}], "]"}], "=", 
      RowBox[{
       RowBox[{"FindRoot", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"rirf", "[", 
           RowBox[{
            RowBox[{"transFairG", "[", 
             RowBox[{"[", 
              RowBox[{"2", ",", "8"}], "]"}], "]"}], ",", 
            RowBox[{"transFairG", "[", 
             RowBox[{"[", 
              RowBox[{"2", ",", "16"}], "]"}], "]"}]}], "]"}], "\[Equal]", 
          RowBox[{"lirf", "[", "\[Alpha]", "]"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"\[Alpha]", ",", "0.2"}], "}"}]}], "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "2"}], "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"transFairG", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", "19"}], "]"}], "]"}], "=", 
      RowBox[{"transFairG", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", "18"}], "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"transFairG", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", 
             RowBox[{"3", ";;", "6"}]}], "]"}], "]"}], "=", 
          RowBox[{
           RowBox[{"transFairG", "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"i", "-", "1"}], ",", 
              RowBox[{"3", ";;", "6"}]}], "]"}], "]"}], "+", 
           RowBox[{"dr", "[", 
            RowBox[{"aFair", ",", "\[Tau]Fair", ",", 
             RowBox[{"transFairG", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"i", "-", "1"}], ",", "18"}], "]"}], "]"}], ",", 
             RowBox[{"transFairG", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"i", "-", "1"}], ",", "2"}], "]"}], "]"}], ",", 
             RowBox[{"transFairG", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"i", "-", "1"}], ",", 
                RowBox[{"3", ";;", "6"}]}], "]"}], "]"}]}], "]"}]}]}], ",", 
         RowBox[{
          RowBox[{"transFairG", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "7"}], "]"}], "]"}], "=", 
          RowBox[{"278.0014091894", "+", 
           RowBox[{"Total", "[", 
            RowBox[{"transFairG", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", 
               RowBox[{"3", ";;", "6"}]}], "]"}], "]"}], "]"}]}]}], ",", 
         RowBox[{
          RowBox[{"transFairG", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "8"}], "]"}], "]"}], "=", 
          RowBox[{
           RowBox[{"transFairG", "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"i", "-", "1"}], ",", "8"}], "]"}], "]"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"transFairG", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "-", "1"}], ",", "2"}], "]"}], "]"}], "-", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"transFairG", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", ",", "7"}], "]"}], "]"}], "-", 
                RowBox[{"transFairG", "[", 
                 RowBox[{"[", 
                  RowBox[{
                   RowBox[{"i", "-", "1"}], ",", "7"}], "]"}], "]"}]}], 
               ")"}]}], ")"}], "*", "2.12"}]}]}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"transFairG", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "9"}], "]"}], "]"}], "=", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"F2x", "/", 
              RowBox[{"Log", "[", "2", "]"}]}], ")"}], "*", 
            RowBox[{"Log", "[", 
             RowBox[{
              RowBox[{"transFairG", "[", 
               RowBox[{"[", 
                RowBox[{"i", ",", "7"}], "]"}], "]"}], "/", 
              "278.0014091894"}], "]"}]}], "/.", "parFair"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"transFairG", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "11"}], "]"}], "]"}], "=", 
          RowBox[{"Total", "[", 
           RowBox[{"transFairG", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", 
              RowBox[{"9", ";;", "10"}]}], "]"}], "]"}], "]"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"transFairG", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "12"}], "]"}], "]"}], "=", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"expf", "*", 
              RowBox[{"transFairG", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "-", "1"}], ",", "12"}], "]"}], "]"}]}], "+", 
             RowBox[{"amixf", "*", "intf"}]}], "/.", 
            RowBox[{"f0", "\[Rule]", 
             RowBox[{"transFairG", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"i", "-", "1"}], ",", "11"}], "]"}], "]"}]}]}], "/.", 
           RowBox[{"f1", "\[Rule]", 
            RowBox[{"transFairG", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", "11"}], "]"}], "]"}]}]}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"transFairG", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "13"}], "]"}], "]"}], "=", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"exps", "*", 
              RowBox[{"transFairG", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "-", "1"}], ",", "13"}], "]"}], "]"}]}], "+", 
             RowBox[{"amixs", "*", "ints"}]}], "/.", 
            RowBox[{"f0", "\[Rule]", 
             RowBox[{"transFairG", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"i", "-", "1"}], ",", "11"}], "]"}], "]"}]}]}], "/.", 
           RowBox[{"f1", "\[Rule]", 
            RowBox[{"transFairG", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", "11"}], "]"}], "]"}]}]}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"transFairG", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "14"}], "]"}], "]"}], "=", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"expf", "*", 
              RowBox[{"transFairG", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "-", "1"}], ",", "14"}], "]"}], "]"}]}], "+", 
             RowBox[{"adeepf", "*", "intf"}]}], "/.", 
            RowBox[{"f0", "\[Rule]", 
             RowBox[{"transFairG", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"i", "-", "1"}], ",", "11"}], "]"}], "]"}]}]}], "/.", 
           RowBox[{"f1", "\[Rule]", 
            RowBox[{"transFairG", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", "11"}], "]"}], "]"}]}]}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"transFairG", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "15"}], "]"}], "]"}], "=", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"exps", "*", 
              RowBox[{"transFairG", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "-", "1"}], ",", "15"}], "]"}], "]"}]}], "+", 
             RowBox[{"adeeps", "*", "ints"}]}], "/.", 
            RowBox[{"f0", "\[Rule]", 
             RowBox[{"transFairG", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"i", "-", "1"}], ",", "11"}], "]"}], "]"}]}]}], "/.", 
           RowBox[{"f1", "\[Rule]", 
            RowBox[{"transFairG", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", "11"}], "]"}], "]"}]}]}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"transFairG", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "16"}], "]"}], "]"}], "=", 
          RowBox[{"Total", "[", 
           RowBox[{"transFairG", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", 
              RowBox[{"12", ";;", "13"}]}], "]"}], "]"}], "]"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"transFairG", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "17"}], "]"}], "]"}], "=", 
          RowBox[{"Total", "[", 
           RowBox[{"transFairG", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", 
              RowBox[{"14", ";;", "15"}]}], "]"}], "]"}], "]"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"(*", 
          RowBox[{
           RowBox[{
            RowBox[{"transFairG", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", 
               RowBox[{"{", 
                RowBox[{"11", ",", "12"}], "}"}]}], "]"}], "]"}], "=", 
            RowBox[{
             RowBox[{
              RowBox[{"transT", ".", 
               RowBox[{"transFairG", "[", 
                RowBox[{"[", 
                 RowBox[{
                  RowBox[{"i", "-", "1"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"11", ",", "12"}], "}"}]}], "]"}], "]"}]}], "+", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"1", ",", "0"}], "}"}], "*", "xi1", "*", 
               RowBox[{"Total", "[", 
                RowBox[{"transFairG", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", ",", 
                   RowBox[{"9", ";;", "10"}]}], "]"}], "]"}], "]"}]}]}], "/.",
              "parTG"}]}], ","}], "\[IndentingNewLine]", 
          RowBox[{"(*", 
           RowBox[{
            RowBox[{
             RowBox[{"transFairG", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "13"}], "]"}], "]"}], "=", 
             RowBox[{"Total", "[", 
              RowBox[{"transFairG", "[", 
               RowBox[{"[", 
                RowBox[{"i", ",", 
                 RowBox[{"11", ";;", "12"}]}], "]"}], "]"}], "]"}]}], ","}], 
           "*)"}], "*)"}], "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"transFairG", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "18"}], "]"}], "]"}], "=", 
          RowBox[{
           RowBox[{"FindRoot", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"rirf", "[", 
               RowBox[{
                RowBox[{"transFairG", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", ",", "8"}], "]"}], "]"}], ",", 
                RowBox[{"transFairG", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", ",", "16"}], "]"}], "]"}]}], "]"}], "\[Equal]", 
              RowBox[{"lirf", "[", "\[Alpha]", "]"}]}], ",", 
             RowBox[{"{", 
              RowBox[{"\[Alpha]", ",", 
               RowBox[{"transFairG", "[", 
                RowBox[{"[", 
                 RowBox[{
                  RowBox[{"i", "-", "1"}], ",", "18"}], "]"}], "]"}]}], 
              "}"}]}], "]"}], "[", 
           RowBox[{"[", 
            RowBox[{"1", ",", "2"}], "]"}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"transFairG", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "19"}], "]"}], "]"}], "=", 
          RowBox[{
           RowBox[{
            RowBox[{"transFairG", "[", 
             RowBox[{"[", 
              RowBox[{
               RowBox[{"i", "-", "1"}], ",", "19"}], "]"}], "]"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"rT", "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"transFairG", "[", 
                   RowBox[{"[", 
                    RowBox[{"i", ",", "16"}], "]"}], "]"}], "-", 
                  RowBox[{"transFairG", "[", 
                   RowBox[{"[", 
                    RowBox[{
                    RowBox[{"i", "-", "1"}], ",", "16"}], "]"}], "]"}]}], 
                 ")"}]}], "+", 
               RowBox[{"rc", "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"transFairG", "[", 
                   RowBox[{"[", 
                    RowBox[{"i", ",", "8"}], "]"}], "]"}], "-", 
                  RowBox[{"transFairG", "[", 
                   RowBox[{"[", 
                    RowBox[{
                    RowBox[{"i", "-", "1"}], ",", "8"}], "]"}], "]"}]}], 
                 ")"}]}]}], ")"}], "/", 
             RowBox[{"(", 
              RowBox[{"dalpha", "[", 
               RowBox[{"transFairG", "[", 
                RowBox[{"[", 
                 RowBox[{
                  RowBox[{"i", "-", "1"}], ",", "19"}], "]"}], "]"}], "]"}], 
              ")"}]}]}], "/.", "parFair"}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "3", ",", "92"}], "}"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"transFairG", "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{"2", ";;"}], ",", "20"}], "]"}], "]"}], "=", 
      RowBox[{
       RowBox[{"transFairG", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", "7"}], "]"}], "]"}], "*", "2.12"}]}], ",",
      "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"FairCBAOutput", "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{"2", ";;"}], ",", 
         RowBox[{"k", "+", "2"}]}], "]"}], "]"}], "=", 
      RowBox[{"transFairG", "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{"2", ";;"}], ",", "20"}], "]"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"FairCBAOutput", "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{"2", ";;"}], ",", 
         RowBox[{"k", "+", "8"}]}], "]"}], "]"}], "=", 
      RowBox[{"transFairG", "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{"2", ";;"}], ",", "16"}], "]"}], "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "1", ",", "6"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.810280473345899*^9, 3.810280835289139*^9}, {
   3.8103641075717745`*^9, 3.810364110692772*^9}, {3.81036883002244*^9, 
   3.8103688305164795`*^9}, {3.8109597437819242`*^9, 
   3.8109597443484993`*^9}, {3.8126087024628897`*^9, 
   3.8126088027229705`*^9}, {3.8126089125388813`*^9, 3.812608914625472*^9}, {
   3.8133342934321384`*^9, 3.813334420216504*^9}, {3.8133344881701365`*^9, 
   3.813334619140195*^9}, {3.81333853388776*^9, 3.813338608697424*^9}, {
   3.813338681538455*^9, 3.813338685953352*^9}, {3.813338943353011*^9, 
   3.8133389926475935`*^9}, {3.813339447165347*^9, 3.8133394617685184`*^9}, {
   3.813339494809816*^9, 3.8133398477767277`*^9}, {3.8133399070193973`*^9, 
   3.8133399167065544`*^9}, {3.813339954815693*^9, 3.8133399781247263`*^9}, {
   3.8133403577092*^9, 3.8133403587043533`*^9}, {3.813340638363896*^9, 
   3.8133406723371153`*^9}, {3.8133461297614355`*^9, 3.813346237438306*^9}, {
   3.813346311469352*^9, 3.813346313427952*^9}, {3.813346478244486*^9, 
   3.8133464786699057`*^9}, {3.813512800860598*^9, 3.8135128045530205`*^9}, {
   3.8135129613335967`*^9, 3.813512967665472*^9}, {3.813513131335656*^9, 
   3.8135132059702077`*^9}, {3.813513448868885*^9, 3.8135134951501684`*^9}, {
   3.813513585711378*^9, 3.8135136559666605`*^9}, {3.813514076073622*^9, 
   3.8135140787416267`*^9}, {3.813516095289074*^9, 3.81351609572066*^9}, {
   3.8166392503253765`*^9, 3.8166392505416813`*^9}, {3.8166393846856313`*^9, 
   3.816639396927516*^9}, {3.816718495005973*^9, 3.816718499048741*^9}, {
   3.8167192008104115`*^9, 3.816719215239213*^9}, {3.8167192603891344`*^9, 
   3.81671929609338*^9}, {3.81671934571107*^9, 3.8167194515233183`*^9}, {
   3.8167195145526047`*^9, 3.81671951488964*^9}, {3.816719824013314*^9, 
   3.8167198871627383`*^9}, {3.817139186070547*^9, 3.817139191263028*^9}, 
   3.8171399022037325`*^9, 3.823154083397869*^9, {3.823161252323941*^9, 
   3.8231612607859535`*^9}},
 CellLabel->
  "In[789]:=",ExpressionUUID->"00d11e97-bcec-4390-9b6c-a892c001de6c"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{
   "\"\<FairCABAOutput_InitialValuesDICE.csv\>\"", ",", "FairCBAOutput"}], 
   "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Export", "[", 
    RowBox[{
    "\"\<FairCABAOutput_InitialValuesFairGeoffroy.csv\>\"", ",", 
     "FairCBAOutput"}], "]"}], "*)"}]}]}], "Input",
 CellChangeTimes->{{3.8171400781289883`*^9, 3.817140114931199*^9}, {
  3.8171411814833884`*^9, 3.817141185658242*^9}, {3.823150458766513*^9, 
  3.823150537837179*^9}, {3.823154141189951*^9, 3.8231541640205374`*^9}, {
  3.8231613361420608`*^9, 
  3.8231613808991795`*^9}},ExpressionUUID->"7f89032a-8470-4000-8e38-\
28fd86ab2c67"],

Cell["ZECMIP ", "Text",
 CellChangeTimes->{{3.71113575119866*^9, 3.7111357648642597`*^9}, {
  3.711171131470954*^9, 3.711171132484956*^9}, {3.712408724609439*^9, 
  3.7124087395614595`*^9}, {3.7662479249546547`*^9, 3.7662479290036545`*^9}, {
  3.810276061054193*^9, 3.810276074321699*^9}, {3.8167180604130163`*^9, 
  3.816718074126128*^9}, {3.8171501903508883`*^9, 3.8171502004843855`*^9}, {
  3.8231917414303217`*^9, 3.823191760154348*^9}, {3.823320463116739*^9, 
  3.823320465316742*^9}},
 FontSize->18,
 Background->RGBColor[
  0.87, 0.94, 1],ExpressionUUID->"f11b8961-a19e-4a80-a029-eec44a94073c"],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "SetDirectory", "[", 
   "\"\<C:\\\\Users\\\\wilmsen\\\\Dropbox\\\\WR\\\\Research\\\\IMPOSE\\\\\
Results_Paper\\\\CommitedWarming\>\"", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.823191838126458*^9, 3.823191858828487*^9}},
 CellLabel->
  "In[791]:=",ExpressionUUID->"3a9c992a-6f16-40bb-a976-ee2815628ac6"],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "SetDirectory", "[", 
   "\"\<C:\\\\Users\\\\Rickels\\\\Dropbox\\\\WR\\\\Research\\\\IMPOSE\\\\\
Results_Paper\\\\CommitedWarming\>\"", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.824189211658682*^9, 3.8241892124758997`*^9}},
 CellLabel->
  "In[1966]:=",ExpressionUUID->"e56a3bd5-bfb6-47b7-b23d-4f35af3de6d3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"dataB1yNor", "=", 
     RowBox[{"Import", "[", "\"\<ZECMIP_B1_NorESM2.csv\>\"", "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"dataB3yNor", "=", 
     RowBox[{"Import", "[", "\"\<ZECMIP_B3_NorESM2.csv\>\"", "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"dataB4yNor", "=", 
     RowBox[{"Import", "[", "\"\<ZECMIP_B4_NorESM2.csv\>\"", "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"dataNorem", "=", 
     RowBox[{"Import", "[", "\"\<NorESM_ems_B.csv\>\"", "]"}]}], ";"}], 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"dataB", "=", 
    RowBox[{"Import", "[", "\"\<ZECMIP_B_oneyear.csv\>\"", "]"}]}], 
   ";"}]}]], "Input",
 CellChangeTimes->{{3.8231919913507833`*^9, 3.82319203185584*^9}, {
  3.8231930025122833`*^9, 3.823193004213286*^9}, {3.8233476239862213`*^9, 
  3.8233476675102825`*^9}, {3.8241892328245387`*^9, 3.824189236996224*^9}},
 CellLabel->
  "In[1967]:=",ExpressionUUID->"2ebf3e6d-39fd-4790-a0a3-29bbf4538a27"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"zn", "=", 
    RowBox[{
     RowBox[{"Dimensions", "[", "dataNorem", "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"zb", "=", 
   RowBox[{
    RowBox[{"Dimensions", "[", "dataB", "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.823193862512494*^9, 3.8231938775245156`*^9}, {
  3.82334767285229*^9, 3.823347690334315*^9}, {3.824189240604809*^9, 
  3.824189243549305*^9}},
 CellLabel->
  "In[1968]:=",ExpressionUUID->"522a271b-0970-4b96-b0b9-f951ffa54632"],

Cell[BoxData["202"], "Output",
 CellChangeTimes->{{3.8231938719635077`*^9, 3.8231938790945177`*^9}, 
   3.823347694445321*^9, 3.824189244498438*^9},
 CellLabel->
  "Out[1968]=",ExpressionUUID->"ea9de76a-497c-4f53-9d3f-0bb7e63fb052"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ZECMIPresults", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "zb"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "43"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ZECMIPresults", "[", 
    RowBox[{"[", "1", "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
    "\"\<1-year\>\"", ",", "\"\<2-B1C-CC16c\>\"", ",", "\"\<3-B1C-CC16b\>\"", 
     ",", "\"\<4-B1C-CC13c\>\"", ",", "\"\<5-B1C-CC13b\>\"", ",", 
     "\"\<6-B1C-CC07c\>\"", ",", "\"\<7-B1C-CC07b\>\"", ",", 
     "\"\<8-B1C-FG\>\"", ",", "\"\<9-B2C-CC16c\>\"", ",", 
     "\"\<10-B2C-CC16b\>\"", ",", "\"\<11-B2C-CC13c\>\"", ",", 
     "\"\<12-B2C-CC13b\>\"", ",", "\"\<13-B2C-CC07c\>\"", ",", 
     "\"\<14-B2C-CC07b\>\"", ",", "\"\<15-B2C-FG\>\"", ",", 
     "\"\<16-B3C-CC16c\>\"", ",", "\"\<17-B3C-CC16b\>\"", ",", 
     "\"\<18-B3C-CC13c\>\"", ",", "\"\<19-B3C-CC13b\>\"", ",", 
     "\"\<20-B3C-CC07c\>\"", ",", "\"\<21-B3C-CC07b\>\"", ",", 
     "\"\<22-B3C-FG\>\"", ",", "\"\<23-B1T-CC16c\>\"", ",", 
     "\"\<24-B1T-CC16b\>\"", ",", "\"\<25-B1T-CC13c\>\"", ",", 
     "\"\<26-B1T-CC13b\>\"", ",", "\"\<27-B1T-CC07c\>\"", ",", 
     "\"\<28-B1T-CC07b\>\"", ",", "\"\<29-B1T-FG\>\"", ",", 
     "\"\<30-B2T-CC16c\>\"", ",", "\"\<31-B2T-CC16b\>\"", ",", 
     "\"\<32-B2T-CC13c\>\"", ",", "\"\<33-B2T-CC13b\>\"", ",", 
     "\"\<34-B2T-CC07c\>\"", ",", "\"\<35-B2T-CC07b\>\"", ",", 
     "\"\<36-B2T-FG\>\"", ",", "\"\<37-B3T-CC16c\>\"", ",", 
     "\"\<38-B3T-CC16b\>\"", ",", "\"\<39-B3T-CC13c\>\"", ",", 
     "\"\<40-B3T-CC13b\>\"", ",", "\"\<41-B3T-CC07c\>\"", ",", 
     "\"\<42-B3T-CC07b\>\"", ",", "\"\<43-B3T-FG\>\""}], "}"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.82319300733329*^9, 3.8231934475069103`*^9}, {
  3.8231935414880424`*^9, 3.8231936884592495`*^9}, {3.8233282752759695`*^9, 
  3.8233285588713684`*^9}, {3.823328618188452*^9, 3.8233286406214833`*^9}, {
  3.8233477015183306`*^9, 3.823347703938334*^9}, {3.823348614841672*^9, 
  3.8233486827097673`*^9}},
 CellLabel->
  "In[2007]:=",ExpressionUUID->"0a1e28af-2677-4570-a0b4-7bcf51561da4"],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ZECMIPresults", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"i", "+", "1"}], ",", "1"}], "]"}], "]"}], "=", "i"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", 
     RowBox[{"zb", "-", "1"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.82332106699865*^9, 3.8233211028227005`*^9}, {
  3.8233477403523855`*^9, 3.8233477438123903`*^9}, {3.8233477794364405`*^9, 
  3.823347779756441*^9}},
 CellLabel->
  "In[2009]:=",ExpressionUUID->"19312a83-3506-4e6e-ba07-7a4ac946737d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"y", "=", "zb"}], ",", " ", 
      RowBox[{"(*", 
       RowBox[{
       "needs", " ", "to", " ", "plus", " ", "1", " ", "the", " ", "length", 
        " ", "of", " ", "the", " ", "emission", " ", "input", " ", "file"}], 
       "*)"}], "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{"Do", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"transfer", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"i", "+", "2"}], ",", "3"}], "]"}], "]"}], "=", 
          RowBox[{
           RowBox[{"transfer", "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"i", "+", "1"}], ",", "3"}], "]"}], "]"}], "+", 
           "timestep"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", "2"}], "}"}]}], "]"}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{
         RowBox[{"transfer", "[", 
          RowBox[{"[", 
           RowBox[{"2", ",", 
            RowBox[{"{", 
             RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "]"}], "]"}], "=", 
         "int2005"}], ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"transfer", "[", 
          RowBox[{"[", 
           RowBox[{"2", ",", "7"}], "]"}], "]"}], "=", 
         RowBox[{"hfun", "[", 
          RowBox[{"transfer", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "5"}], "]"}], "]"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"transfer", "[", 
          RowBox[{"[", 
           RowBox[{"2", ",", "8"}], "]"}], "]"}], "=", 
         RowBox[{"Afun", "[", "timestep", "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"transfer", "[", 
          RowBox[{"[", 
           RowBox[{"2", ",", "9"}], "]"}], "]"}], "=", 
         RowBox[{"Bfun", "[", 
          RowBox[{"transfer", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "7"}], "]"}], "]"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"transfer", "[", 
          RowBox[{"[", 
           RowBox[{"2", ",", 
            RowBox[{"{", 
             RowBox[{"12", ",", "13", ",", "14"}], "}"}]}], "]"}], "]"}], "=", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"trans", ".", 
              RowBox[{"transfer", "[", 
               RowBox[{"[", 
                RowBox[{"2", ",", 
                 RowBox[{"{", 
                  RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "]"}], "]"}]}], 
             "/.", "par"}], "/.", 
            RowBox[{"t", "\[Rule]", "timestep"}]}], "/.", 
           RowBox[{"A", "\[Rule]", 
            RowBox[{"transfer", "[", 
             RowBox[{"[", 
              RowBox[{"2", ",", "8"}], "]"}], "]"}]}]}], "/.", 
          RowBox[{"B", "\[Rule]", 
           RowBox[{"transfer", "[", 
            RowBox[{"[", 
             RowBox[{"2", ",", "9"}], "]"}], "]"}]}]}]}], ";"}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"transfery1CC16", "=", 
       RowBox[{"Table", "[", 
        RowBox[{"0", ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "y"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"j", ",", "18"}], "}"}]}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transfery1CC16", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "=", 
       RowBox[{"{", 
        RowBox[{
        "\"\<1-Y\>\"", ",", "\"\<2-E\>\"", ",", "\"\<3-CDR\>\"", ",", 
         "\"\<4-MATc\>\"", ",", "\"\<5-MUPc\>\"", ",", "\"\<6-MLOc\>\"", ",", 
         "\"\<7-dC\>\"", ",", "\"\<8-MATb\>\"", ",", "\"\<9-MUPb\>\"", ",", 
         "\"\<10-MLOb\>\"", ",", "\"\<11-dC\>\"", ",", "\"\<12-Fex\>\"", ",", 
         "\"\<13-Fc\>\"", ",", "\"\<14-Fb\>\"", ",", "\"\<15-TempAc\>\"", 
         ",", "\"\<16-TempOc\>\"", ",", "\"\<17-TempAb\>\"", ",", 
         "\"\<18-TempOb\>\""}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"transfery1CC16", "[", 
          RowBox[{"[", 
           RowBox[{"n", ",", "1"}], "]"}], "]"}], "=", 
         RowBox[{"n", "-", "1"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"n", ",", "2", ",", "y"}], "}"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"emcolumns", "=", 
        RowBox[{"{", 
         RowBox[{"3", ",", "4", ",", "5"}], "}"}]}], ";", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"2", ",", "3", ",", "4"}], "}"}], " ", "in", " ", "case", 
         " ", "one", " ", "uses", " ", "NorESM2", " ", "data"}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"emissions1", "=", 
        RowBox[{"dataB", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;", "zb"}], ",", 
           RowBox[{"emcolumns", "[", 
            RowBox[{"[", "k", "]"}], "]"}]}], "]"}], "]"}]}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"cdr1", "=", 
         RowBox[{"Input1CC16", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;", "v3"}], ",", 
            RowBox[{"k", "*", "3"}]}], "]"}], "]"}]}], ","}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transfery1CC16", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;", "y"}], ",", "2"}], "]"}], "]"}], "=", 
       "emissions1"}], ",", " ", 
      RowBox[{"(*", "Emissions", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{
         RowBox[{"transfery1CC16", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;", "y"}], ",", "3"}], "]"}], "]"}], "=", "cdr1"}],
         ","}], "*)"}], 
      RowBox[{"(*", "CDR", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{"Do", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"transfer", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"i", "+", "2"}], ",", "3"}], "]"}], "]"}], "=", 
          RowBox[{
           RowBox[{"transfer", "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"i", "+", "1"}], ",", "3"}], "]"}], "]"}], "+", 
           "timestep"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", "2"}], "}"}]}], "]"}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transfery1CC16", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", 
          RowBox[{"{", 
           RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "]"}], "]"}], "=", 
       "intCC16pre"}], ",", " ", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{
        "initial", " ", "carbon", " ", "values", " ", "for", " ", 
         "atmosphere"}], ",", " ", 
        RowBox[{"upper", " ", "ocean"}], ",", " ", 
        RowBox[{"lower", " ", "ocean"}]}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transfery1CC16", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", 
          RowBox[{"{", 
           RowBox[{"8", ",", "9", ",", "10"}], "}"}]}], "]"}], "]"}], "=", 
       "intCC16pre"}], ",", " ", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{
        "initial", " ", "carbon", " ", "values", " ", "for", " ", 
         "atmosphere"}], ",", " ", 
        RowBox[{"upper", " ", "ocean"}], ",", " ", 
        RowBox[{"lower", " ", "ocean"}]}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transfery1CC16", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", 
          RowBox[{"{", 
           RowBox[{"15", ",", "16"}], "}"}]}], "]"}], "]"}], "=", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], ",", " ", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"atmosphere", " ", "temperature"}], ",", " ", 
        RowBox[{"ocean", " ", "temperature"}]}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transfery1CC16", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", 
          RowBox[{"{", 
           RowBox[{"17", ",", "18"}], "}"}]}], "]"}], "]"}], "=", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], ",", " ", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"atmosphere", " ", "temperature"}], ",", " ", 
        RowBox[{"ocean", " ", "temperature"}]}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"fexcolumns", "=", 
         RowBox[{"{", 
          RowBox[{"40", ",", "44", ",", "45"}], "}"}]}], ","}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transfery1CC16", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;", "y"}], ",", "12"}], "]"}], "]"}], "=", "0"}], 
      ",", " ", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"dataRCP1", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;", "v3"}], ",", 
           RowBox[{"fexcolumns", "[", 
            RowBox[{"[", "k", "]"}], "]"}]}], "]"}], "]"}], ","}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transfery1CC16", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "13"}], "]"}], "]"}], "=", 
       RowBox[{
        RowBox[{
         RowBox[{"\[Eta]", "*", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Log", "[", 
             RowBox[{
              RowBox[{"transfery1CC16", "[", 
               RowBox[{"[", 
                RowBox[{"2", ",", "4"}], "]"}], "]"}], "/", "MPI"}], "]"}], 
            "/", 
            RowBox[{"Log", "[", "2", "]"}]}], ")"}]}], "+", 
         RowBox[{"transfery1CC16", "[", 
          RowBox[{"[", 
           RowBox[{"2", ",", "12"}], "]"}], "]"}]}], "/.", "parT161calc"}]}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transfery1CC16", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "14"}], "]"}], "]"}], "=", 
       RowBox[{
        RowBox[{
         RowBox[{"\[Eta]", "*", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Log", "[", 
             RowBox[{
              RowBox[{"transfery1CC16", "[", 
               RowBox[{"[", 
                RowBox[{"2", ",", "8"}], "]"}], "]"}], "/", "MPI"}], "]"}], 
            "/", 
            RowBox[{"Log", "[", "2", "]"}]}], ")"}]}], "+", 
         RowBox[{"transfery1CC16", "[", 
          RowBox[{"[", 
           RowBox[{"2", ",", "12"}], "]"}], "]"}]}], "/.", "parT161calb"}]}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"timestepy", "=", "85"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Do", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"transfery1CC16", "[", 
            RowBox[{"[", 
             RowBox[{"n", ",", "10"}], "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{"intT2015", "[", 
             RowBox[{"[", "3", "]"}], "]"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "/", "timestepy"}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"intT2015", "[", 
                RowBox[{"[", "4", "]"}], "]"}], "-", 
               RowBox[{"intT2015", "[", 
                RowBox[{"[", "3", "]"}], "]"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{"n", "-", "2"}], ")"}]}]}]}], ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", "3", ",", 
            RowBox[{"timestepy", "+", "2"}]}], "}"}]}], "]"}], ",", " ", 
        RowBox[{"(*", 
         RowBox[{"Calculate", " ", "exogenous", " ", "forcing"}], "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"transfery1CC16", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{
             RowBox[{"timestepy", "+", "3"}], ";;", "y"}], ",", "10"}], "]"}],
           "]"}], "=", 
         RowBox[{"intT2015", "[", 
          RowBox[{"[", "4", "]"}], "]"}]}], ","}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"transfery1CC16", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", 
              RowBox[{"{", 
               RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{
             RowBox[{"transfery1CC16", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"i", "-", "1"}], ",", 
                RowBox[{"{", 
                 RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "]"}], "]"}], 
             ".", "a1calc"}], "+", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"1", ",", "0", ",", "0"}], "}"}], "*", 
             RowBox[{"transfery1CC16", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"i", "-", "1"}], ",", "2"}], "]"}], "]"}]}]}]}], ",", 
          RowBox[{
           RowBox[{"transfery1CC16", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", 
              RowBox[{"{", 
               RowBox[{"8", ",", "9", ",", "10"}], "}"}]}], "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{
             RowBox[{"transfery1CC16", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"i", "-", "1"}], ",", 
                RowBox[{"{", 
                 RowBox[{"8", ",", "9", ",", "10"}], "}"}]}], "]"}], "]"}], 
             ".", "a1calb"}], "+", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"1", ",", "0", ",", "0"}], "}"}], "*", 
             RowBox[{"transfery1CC16", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"i", "-", "1"}], ",", "2"}], "]"}], "]"}]}]}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"transfery1CC16", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "13"}], "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{
             RowBox[{"\[Eta]", "*", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"Log", "[", 
                 RowBox[{
                  RowBox[{"transfery1CC16", "[", 
                   RowBox[{"[", 
                    RowBox[{"i", ",", "4"}], "]"}], "]"}], "/", "MPI"}], 
                 "]"}], "/", 
                RowBox[{"Log", "[", "2", "]"}]}], ")"}]}], "+", 
             RowBox[{"transfery1CC16", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "12"}], "]"}], "]"}]}], "/.", 
            "parT161calc"}]}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"transfery1CC16", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "14"}], "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{
             RowBox[{"\[Eta]", "*", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"Log", "[", 
                 RowBox[{
                  RowBox[{"transfery1CC16", "[", 
                   RowBox[{"[", 
                    RowBox[{"i", ",", "4"}], "]"}], "]"}], "/", "MPI"}], 
                 "]"}], "/", 
                RowBox[{"Log", "[", "2", "]"}]}], ")"}]}], "+", 
             RowBox[{"transfery1CC16", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "12"}], "]"}], "]"}]}], "/.", 
            "parT161calb"}]}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"transfery1CC16", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", 
              RowBox[{"{", 
               RowBox[{"15", ",", "16"}], "}"}]}], "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{
             RowBox[{"TransT161calc", ".", 
              RowBox[{"transfery1CC16", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "-", "1"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"15", ",", "16"}], "}"}]}], "]"}], "]"}]}], "+", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"1", ",", "0"}], "}"}], "*", "xi1", "*", 
              RowBox[{"transfery1CC16", "[", 
               RowBox[{"[", 
                RowBox[{"i", ",", "13"}], "]"}], "]"}]}]}], "/.", 
            "parT161calc"}]}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"transfery1CC16", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", 
              RowBox[{"{", 
               RowBox[{"17", ",", "18"}], "}"}]}], "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{
             RowBox[{"TransT161calb", ".", 
              RowBox[{"transfery1CC16", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "-", "1"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"17", ",", "18"}], "}"}]}], "]"}], "]"}]}], "+", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"1", ",", "0"}], "}"}], "*", "xi1", "*", 
              RowBox[{"transfery1CC16", "[", 
               RowBox[{"[", 
                RowBox[{"i", ",", "14"}], "]"}], "]"}]}]}], "/.", 
            "parT161calb"}]}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"transfery1CC16", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "7"}], "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{"Total", "[", 
             RowBox[{"transfery1CC16", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", 
                RowBox[{"{", 
                 RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "]"}], "]"}], 
             "]"}], "-", 
            RowBox[{"Total", "[", 
             RowBox[{"transfery1CC16", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"i", "-", "1"}], ",", 
                RowBox[{"{", 
                 RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "]"}], "]"}], 
             "]"}]}]}], ",", 
          RowBox[{
           RowBox[{"transfery1CC16", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "11"}], "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{"Total", "[", 
             RowBox[{"transfery1CC16", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", 
                RowBox[{"{", 
                 RowBox[{"8", ",", "9", ",", "10"}], "}"}]}], "]"}], "]"}], 
             "]"}], "-", 
            RowBox[{"Total", "[", 
             RowBox[{"transfery1CC16", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"i", "-", "1"}], ",", 
                RowBox[{"{", 
                 RowBox[{"8", ",", "9", ",", "10"}], "}"}]}], "]"}], "]"}], 
             "]"}]}]}]}], "}"}], ",", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"i", ",", "3", ",", "y"}], "}"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"ZECMIPresults", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;", "y"}], ",", 
          RowBox[{
           RowBox[{"k", "*", "7"}], "-", "5"}]}], "]"}], "]"}], "=", 
       RowBox[{"transfery1CC16", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;", "y"}], ",", "4"}], "]"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"ZECMIPresults", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;", "y"}], ",", 
          RowBox[{
           RowBox[{"k", "*", "7"}], "-", "4"}]}], "]"}], "]"}], "=", 
       RowBox[{"transfery1CC16", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;", "y"}], ",", "8"}], "]"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"ZECMIPresults", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;", "y"}], ",", 
          RowBox[{
           RowBox[{"k", "*", "7"}], "+", "16"}]}], "]"}], "]"}], "=", 
       RowBox[{"transfery1CC16", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;", "y"}], ",", "15"}], "]"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"ZECMIPresults", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;", "y"}], ",", 
          RowBox[{
           RowBox[{"k", "*", "7"}], "+", "17"}]}], "]"}], "]"}], "=", 
       RowBox[{"transfery1CC16", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;", "y"}], ",", "17"}], "]"}], "]"}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", "1", ",", "3"}], "}"}]}], "]"}], ";"}]], "Input",
 CellChangeTimes->{
  3.8231938456504707`*^9, {3.8231938861355276`*^9, 3.8231938880955305`*^9}, {
   3.8231939327015934`*^9, 3.8231939386816015`*^9}, {3.8231939780776567`*^9, 
   3.8231939963316827`*^9}, {3.8231942418270903`*^9, 3.823194247058098*^9}, {
   3.8231943405092297`*^9, 3.823194354451249*^9}, {3.823194560610563*^9, 
   3.823194614957639*^9}, {3.8231946568646984`*^9, 3.8231946701667166`*^9}, {
   3.8231947253337955`*^9, 3.823194773165363*^9}, {3.823328831182751*^9, 
   3.8233288337327547`*^9}, {3.82332888714883*^9, 3.82332890128985*^9}, {
   3.823329076281096*^9, 3.823329084812108*^9}, {3.8233477842574472`*^9, 
   3.82334784983654*^9}},
 CellLabel->
  "In[2010]:=",ExpressionUUID->"859d97ae-a031-473f-8860-6f858d24975e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"y", "=", "zb"}], ",", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{
         RowBox[{"Dimensions", "[", "dataNorem", "]"}], "[", 
         RowBox[{"[", "1", "]"}], "]"}], ","}], "*)"}], " ", 
      "\[IndentingNewLine]", 
      RowBox[{"transfery1CC13", "=", 
       RowBox[{"Table", "[", 
        RowBox[{"0", ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "y"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"j", ",", "18"}], "}"}]}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transfery1CC13", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "=", 
       RowBox[{"{", 
        RowBox[{
        "\"\<1-Y\>\"", ",", "\"\<2-E\>\"", ",", "\"\<3-CDR\>\"", ",", 
         "\"\<4-MATc\>\"", ",", "\"\<5-MUPc\>\"", ",", "\"\<6-MLOc\>\"", ",", 
         "\"\<7-dC\>\"", ",", "\"\<8-MATb\>\"", ",", "\"\<9-MUPb\>\"", ",", 
         "\"\<10-MLOb\>\"", ",", "\"\<11-dC\>\"", ",", "\"\<12-Fex\>\"", ",", 
         "\"\<13-Fc\>\"", ",", "\"\<14-Fb\>\"", ",", "\"\<15-TempAc\>\"", 
         ",", "\"\<16-TempOc\>\"", ",", "\"\<17-TempAb\>\"", ",", 
         "\"\<18-TempOb\>\""}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"transfery1CC13", "[", 
          RowBox[{"[", 
           RowBox[{"n", ",", "1"}], "]"}], "]"}], "=", 
         RowBox[{"1765", "+", "n", "-", "2"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"n", ",", "2", ",", "y"}], "}"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"emcolumns", "=", 
        RowBox[{"{", 
         RowBox[{"3", ",", "4", ",", "5"}], "}"}]}], ";", " ", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"2", ",", "3", ",", "4"}], "}"}], ";"}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"emissions1", "=", 
        RowBox[{"dataB", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;", "zb"}], ",", 
           RowBox[{"emcolumns", "[", 
            RowBox[{"[", "k", "]"}], "]"}]}], "]"}], "]"}]}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transfery1CC13", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;", "y"}], ",", "2"}], "]"}], "]"}], "=", 
       "emissions1"}], ",", " ", 
      RowBox[{"(*", "Emissions", "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transfery1CC13", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", 
          RowBox[{"{", 
           RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "]"}], "]"}], "=", 
       "intCC13pre"}], ",", " ", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{
        "initial", " ", "carbon", " ", "values", " ", "for", " ", 
         "atmosphere"}], ",", " ", 
        RowBox[{"upper", " ", "ocean"}], ",", " ", 
        RowBox[{"lower", " ", "ocean"}]}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transfery1CC13", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", 
          RowBox[{"{", 
           RowBox[{"8", ",", "9", ",", "10"}], "}"}]}], "]"}], "]"}], "=", 
       "intCC13pre"}], ",", " ", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{
        "initial", " ", "carbon", " ", "values", " ", "for", " ", 
         "atmosphere"}], ",", " ", 
        RowBox[{"upper", " ", "ocean"}], ",", " ", 
        RowBox[{"lower", " ", "ocean"}]}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transfery1CC13", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "13"}], "]"}], "]"}], "=", 
       RowBox[{
        RowBox[{
         RowBox[{"\[Eta]", "*", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Log", "[", 
             RowBox[{
              RowBox[{"transfery1CC13", "[", 
               RowBox[{"[", 
                RowBox[{"2", ",", "4"}], "]"}], "]"}], "/", "MPI"}], "]"}], 
            "/", 
            RowBox[{"Log", "[", "2", "]"}]}], ")"}]}], "+", 
         RowBox[{"transfery1CC13", "[", 
          RowBox[{"[", 
           RowBox[{"2", ",", "12"}], "]"}], "]"}]}], "/.", "parT131calc"}]}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transfery1CC13", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "14"}], "]"}], "]"}], "=", 
       RowBox[{
        RowBox[{
         RowBox[{"\[Eta]", "*", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Log", "[", 
             RowBox[{
              RowBox[{"transfery1CC13", "[", 
               RowBox[{"[", 
                RowBox[{"2", ",", "8"}], "]"}], "]"}], "/", "MPI"}], "]"}], 
            "/", 
            RowBox[{"Log", "[", "2", "]"}]}], ")"}]}], "+", 
         RowBox[{"transfery1CC13", "[", 
          RowBox[{"[", 
           RowBox[{"2", ",", "12"}], "]"}], "]"}]}], "/.", "parT131calb"}]}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"transfery1CC13", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", 
              RowBox[{"{", 
               RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{
             RowBox[{"transfery1CC13", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"i", "-", "1"}], ",", 
                RowBox[{"{", 
                 RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "]"}], "]"}], 
             ".", "b1calc"}], "+", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"1", ",", "0", ",", "0"}], "}"}], "*", 
             RowBox[{"transfery1CC13", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"i", "-", "1"}], ",", "2"}], "]"}], "]"}]}]}]}], ",", 
          RowBox[{
           RowBox[{"transfery1CC13", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", 
              RowBox[{"{", 
               RowBox[{"8", ",", "9", ",", "10"}], "}"}]}], "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{
             RowBox[{"transfery1CC13", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"i", "-", "1"}], ",", 
                RowBox[{"{", 
                 RowBox[{"8", ",", "9", ",", "10"}], "}"}]}], "]"}], "]"}], 
             ".", "b1calb"}], "+", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"1", ",", "0", ",", "0"}], "}"}], "*", 
             RowBox[{"transfery1CC13", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"i", "-", "1"}], ",", "2"}], "]"}], "]"}]}]}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"transfery1CC13", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "13"}], "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{
             RowBox[{"\[Eta]", "*", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"Log", "[", 
                 RowBox[{
                  RowBox[{"transfery1CC13", "[", 
                   RowBox[{"[", 
                    RowBox[{"i", ",", "4"}], "]"}], "]"}], "/", "MPI"}], 
                 "]"}], "/", 
                RowBox[{"Log", "[", "2", "]"}]}], ")"}]}], "+", 
             RowBox[{"transfery1CC13", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "12"}], "]"}], "]"}]}], "/.", 
            "parT131calc"}]}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"transfery1CC13", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "14"}], "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{
             RowBox[{"\[Eta]", "*", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"Log", "[", 
                 RowBox[{
                  RowBox[{"transfery1CC13", "[", 
                   RowBox[{"[", 
                    RowBox[{"i", ",", "4"}], "]"}], "]"}], "/", "MPI"}], 
                 "]"}], "/", 
                RowBox[{"Log", "[", "2", "]"}]}], ")"}]}], "+", 
             RowBox[{"transfery1CC13", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "12"}], "]"}], "]"}]}], "/.", 
            "parT131calb"}]}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"transfery1CC13", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", 
              RowBox[{"{", 
               RowBox[{"15", ",", "16"}], "}"}]}], "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{
             RowBox[{"TransT131calc", ".", 
              RowBox[{"transfery1CC13", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "-", "1"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"15", ",", "16"}], "}"}]}], "]"}], "]"}]}], "+", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"1", ",", "0"}], "}"}], "*", "xi1", "*", 
              RowBox[{"transfery1CC13", "[", 
               RowBox[{"[", 
                RowBox[{"i", ",", "13"}], "]"}], "]"}]}]}], "/.", 
            "parT131calc"}]}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"transfery1CC13", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", 
              RowBox[{"{", 
               RowBox[{"17", ",", "18"}], "}"}]}], "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{
             RowBox[{"TransT131calb", ".", 
              RowBox[{"transfery1CC13", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "-", "1"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"17", ",", "18"}], "}"}]}], "]"}], "]"}]}], "+", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"1", ",", "0"}], "}"}], "*", "xi1", "*", 
              RowBox[{"transfery1CC13", "[", 
               RowBox[{"[", 
                RowBox[{"i", ",", "14"}], "]"}], "]"}]}]}], "/.", 
            "parT131calb"}]}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"transfery1CC13", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "7"}], "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{"Total", "[", 
             RowBox[{"transfery1CC13", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", 
                RowBox[{"{", 
                 RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "]"}], "]"}], 
             "]"}], "-", 
            RowBox[{"Total", "[", 
             RowBox[{"transfery1CC13", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"i", "-", "1"}], ",", 
                RowBox[{"{", 
                 RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "]"}], "]"}], 
             "]"}]}]}], ",", 
          RowBox[{
           RowBox[{"transfery1CC13", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "11"}], "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{"Total", "[", 
             RowBox[{"transfery1CC13", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", 
                RowBox[{"{", 
                 RowBox[{"8", ",", "9", ",", "10"}], "}"}]}], "]"}], "]"}], 
             "]"}], "-", 
            RowBox[{"Total", "[", 
             RowBox[{"transfery1CC13", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"i", "-", "1"}], ",", 
                RowBox[{"{", 
                 RowBox[{"8", ",", "9", ",", "10"}], "}"}]}], "]"}], "]"}], 
             "]"}]}]}]}], "}"}], ",", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"i", ",", "3", ",", "y"}], "}"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"ZECMIPresults", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;", "y"}], ",", 
          RowBox[{
           RowBox[{"k", "*", "7"}], "-", "3"}]}], "]"}], "]"}], "=", 
       RowBox[{"transfery1CC13", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;", "y"}], ",", "4"}], "]"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"ZECMIPresults", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;", "y"}], ",", 
          RowBox[{
           RowBox[{"k", "*", "7"}], "-", "2"}]}], "]"}], "]"}], "=", 
       RowBox[{"transfery1CC13", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;", "y"}], ",", "8"}], "]"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"ZECMIPresults", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;", "y"}], ",", 
          RowBox[{
           RowBox[{"k", "*", "7"}], "+", "18"}]}], "]"}], "]"}], "=", 
       RowBox[{"transfery1CC13", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;", "y"}], ",", "15"}], "]"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"ZECMIPresults", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;", "y"}], ",", 
          RowBox[{
           RowBox[{"k", "*", "7"}], "+", "19"}]}], "]"}], "]"}], "=", 
       RowBox[{"transfery1CC13", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;", "y"}], ",", "17"}], "]"}], "]"}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", "1", ",", "3"}], "}"}]}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.7920295174306426`*^9, 3.7920296240259695`*^9}, 
   3.7920296562702756`*^9, 3.7920299489930334`*^9, {3.7920300286729827`*^9, 
   3.7920300452551394`*^9}, {3.792030749055524*^9, 3.792030775922874*^9}, {
   3.7920308859542513`*^9, 3.7920309292614193`*^9}, {3.792031843803426*^9, 
   3.792031942968858*^9}, {3.7920319907182646`*^9, 3.792032015281928*^9}, {
   3.792032058800349*^9, 3.7920320752263308`*^9}, {3.7920323050159206`*^9, 
   3.7920324077366877`*^9}, {3.7920324671434374`*^9, 3.792032482999258*^9}, {
   3.792032611440982*^9, 3.7920326158071566`*^9}, {3.7920327615832467`*^9, 
   3.7920328067427187`*^9}, {3.7920334007064004`*^9, 
   3.7920334214787354`*^9}, {3.792035955558097*^9, 3.792036012070055*^9}, {
   3.792036046458066*^9, 3.792036084942918*^9}, {3.7927439980635*^9, 
   3.7927439995011473`*^9}, {3.810190824093872*^9, 3.8101909750021825`*^9}, {
   3.810191010756048*^9, 3.810191111014434*^9}, {3.810191295273965*^9, 
   3.8101913839399376`*^9}, {3.8101914246549754`*^9, 3.810191428248706*^9}, {
   3.810191635020672*^9, 3.8101917309279904`*^9}, {3.8101920096607895`*^9, 
   3.8101920129720707`*^9}, {3.810227415352755*^9, 3.810227440512192*^9}, {
   3.8102274729351254`*^9, 3.810227538763339*^9}, {3.8102300179769573`*^9, 
   3.810230106483638*^9}, {3.810230177843181*^9, 3.810230229576248*^9}, {
   3.8102302817912793`*^9, 3.810230327595955*^9}, {3.810285105674296*^9, 
   3.8102851588633566`*^9}, {3.8102851897847815`*^9, 
   3.8102851967993245`*^9}, {3.8102852868790426`*^9, 
   3.8102853070075903`*^9}, {3.810363495762292*^9, 3.8103636125162163`*^9}, {
   3.8103636851437254`*^9, 3.8103637031036477`*^9}, {3.8103687955515385`*^9, 
   3.810368796059222*^9}, {3.8109597131811237`*^9, 3.810959713953663*^9}, {
   3.813553794644224*^9, 3.8135538155021615`*^9}, {3.8135540005393896`*^9, 
   3.8135540920428095`*^9}, {3.813554253355591*^9, 3.8135544231263237`*^9}, {
   3.8135546895989656`*^9, 3.8135547249825363`*^9}, {3.813555073137637*^9, 
   3.8135551429410486`*^9}, {3.813555246539295*^9, 3.813555360924416*^9}, {
   3.813555792694582*^9, 3.8135557972368507`*^9}, 3.8136047492743406`*^9, {
   3.8136055987291527`*^9, 3.813605612504076*^9}, {3.823195061659824*^9, 
   3.8231950624598246`*^9}, {3.8231951221279097`*^9, 
   3.8231951909070063`*^9}, {3.823195230052061*^9, 3.823195290861147*^9}, {
   3.8231953259551964`*^9, 3.8231953303552027`*^9}, {3.8231954150493765`*^9, 
   3.8231954225813875`*^9}, {3.823329204517337*^9, 3.823329239912387*^9}, {
   3.8233478828445864`*^9, 3.8233479390916653`*^9}},
 CellLabel->
  "In[2011]:=",ExpressionUUID->"b9ae01f9-70b2-4057-9f2d-f90443b99e2b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"y", "=", "zb"}], ",", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{
         RowBox[{"Dimensions", "[", "dataNorem", "]"}], "[", 
         RowBox[{"[", "1", "]"}], "]"}], ","}], "*)"}], " ", 
      "\[IndentingNewLine]", 
      RowBox[{"transfery1CC07", "=", 
       RowBox[{"Table", "[", 
        RowBox[{"0", ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "y"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"j", ",", "18"}], "}"}]}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transfery1CC07", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "=", 
       RowBox[{"{", 
        RowBox[{
        "\"\<1-Y\>\"", ",", "\"\<2-E\>\"", ",", "\"\<3-CDR\>\"", ",", 
         "\"\<4-MATc\>\"", ",", "\"\<5-MUPc\>\"", ",", "\"\<6-MLOc\>\"", ",", 
         "\"\<7-dC\>\"", ",", "\"\<8-MATb\>\"", ",", "\"\<9-MUPb\>\"", ",", 
         "\"\<10-MLOb\>\"", ",", "\"\<11-dC\>\"", ",", "\"\<12-Fex\>\"", ",", 
         "\"\<13-Fc\>\"", ",", "\"\<14-Fb\>\"", ",", "\"\<15-TempAc\>\"", 
         ",", "\"\<16-TempOc\>\"", ",", "\"\<17-TempAb\>\"", ",", 
         "\"\<18-TempOb\>\""}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"transfery1CC07", "[", 
          RowBox[{"[", 
           RowBox[{"n", ",", "1"}], "]"}], "]"}], "=", 
         RowBox[{"1765", "+", "n", "-", "2"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"n", ",", "2", ",", "y"}], "}"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"emcolumns", "=", 
        RowBox[{"{", 
         RowBox[{"3", ",", "4", ",", "5"}], "}"}]}], ";", " ", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"2", ",", "3", ",", "4"}], "}"}], ";"}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"emissions1", "=", 
        RowBox[{"dataB", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;", "zb"}], ",", 
           RowBox[{"emcolumns", "[", 
            RowBox[{"[", "k", "]"}], "]"}]}], "]"}], "]"}]}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transfery1CC07", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;", "y"}], ",", "2"}], "]"}], "]"}], "=", 
       "emissions1"}], ",", " ", 
      RowBox[{"(*", "Emissions", "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transfery1CC07", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", 
          RowBox[{"{", 
           RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "]"}], "]"}], "=", 
       "intCC07pre"}], ",", " ", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{
        "initial", " ", "carbon", " ", "values", " ", "for", " ", 
         "atmosphere"}], ",", " ", 
        RowBox[{"upper", " ", "ocean"}], ",", " ", 
        RowBox[{"lower", " ", "ocean"}]}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transfery1CC07", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", 
          RowBox[{"{", 
           RowBox[{"8", ",", "9", ",", "10"}], "}"}]}], "]"}], "]"}], "=", 
       "intCC07pre"}], ",", " ", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{
        "initial", " ", "carbon", " ", "values", " ", "for", " ", 
         "atmosphere"}], ",", " ", 
        RowBox[{"upper", " ", "ocean"}], ",", " ", 
        RowBox[{"lower", " ", "ocean"}]}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"fexcolumns", "=", 
         RowBox[{"{", 
          RowBox[{"40", ",", "44", ",", "45"}], "}"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"transfery1CC07", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;", "y"}], ",", "12"}], "]"}], "]"}], "=", 
         RowBox[{"dataRCP1", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;", "v3"}], ",", 
            RowBox[{"fexcolumns", "[", 
             RowBox[{"[", "k", "]"}], "]"}]}], "]"}], "]"}]}], ","}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transfery1CC07", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "13"}], "]"}], "]"}], "=", 
       RowBox[{
        RowBox[{
         RowBox[{"\[Eta]", "*", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Log", "[", 
             RowBox[{
              RowBox[{"transfery1CC07", "[", 
               RowBox[{"[", 
                RowBox[{"2", ",", "4"}], "]"}], "]"}], "/", "MPI"}], "]"}], 
            "/", 
            RowBox[{"Log", "[", "2", "]"}]}], ")"}]}], "+", 
         RowBox[{"transfery1CC07", "[", 
          RowBox[{"[", 
           RowBox[{"2", ",", "12"}], "]"}], "]"}]}], "/.", "parT071calc"}]}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transfery1CC07", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "14"}], "]"}], "]"}], "=", 
       RowBox[{
        RowBox[{
         RowBox[{"\[Eta]", "*", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Log", "[", 
             RowBox[{
              RowBox[{"transfery1CC07", "[", 
               RowBox[{"[", 
                RowBox[{"2", ",", "8"}], "]"}], "]"}], "/", "MPI"}], "]"}], 
            "/", 
            RowBox[{"Log", "[", "2", "]"}]}], ")"}]}], "+", 
         RowBox[{"transfery1CC07", "[", 
          RowBox[{"[", 
           RowBox[{"2", ",", "12"}], "]"}], "]"}]}], "/.", "parT071calb"}]}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"transfery1CC07", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", 
              RowBox[{"{", 
               RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{
             RowBox[{"transfery1CC07", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"i", "-", "1"}], ",", 
                RowBox[{"{", 
                 RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "]"}], "]"}], 
             ".", "d1calc"}], "+", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"1", ",", "0", ",", "0"}], "}"}], "*", 
             RowBox[{"transfery1CC07", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"i", "-", "1"}], ",", "2"}], "]"}], "]"}]}]}]}], ",", 
          RowBox[{
           RowBox[{"transfery1CC07", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", 
              RowBox[{"{", 
               RowBox[{"8", ",", "9", ",", "10"}], "}"}]}], "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{
             RowBox[{"transfery1CC07", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"i", "-", "1"}], ",", 
                RowBox[{"{", 
                 RowBox[{"8", ",", "9", ",", "10"}], "}"}]}], "]"}], "]"}], 
             ".", "d1calb"}], "+", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"1", ",", "0", ",", "0"}], "}"}], "*", 
             RowBox[{"transfery1CC07", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"i", "-", "1"}], ",", "2"}], "]"}], "]"}]}]}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"transfery1CC07", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "13"}], "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{
             RowBox[{"\[Eta]", "*", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"Log", "[", 
                 RowBox[{
                  RowBox[{"transfery1CC07", "[", 
                   RowBox[{"[", 
                    RowBox[{"i", ",", "4"}], "]"}], "]"}], "/", "MPI"}], 
                 "]"}], "/", 
                RowBox[{"Log", "[", "2", "]"}]}], ")"}]}], "+", 
             RowBox[{"transfery1CC07", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "12"}], "]"}], "]"}]}], "/.", 
            "parT071calc"}]}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"transfery1CC07", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "14"}], "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{
             RowBox[{"\[Eta]", "*", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"Log", "[", 
                 RowBox[{
                  RowBox[{"transfery1CC07", "[", 
                   RowBox[{"[", 
                    RowBox[{"i", ",", "4"}], "]"}], "]"}], "/", "MPI"}], 
                 "]"}], "/", 
                RowBox[{"Log", "[", "2", "]"}]}], ")"}]}], "+", 
             RowBox[{"transfery1CC07", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "12"}], "]"}], "]"}]}], "/.", 
            "parT071calb"}]}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"transfery1CC07", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", 
              RowBox[{"{", 
               RowBox[{"15", ",", "16"}], "}"}]}], "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{
             RowBox[{"TransT071calc", ".", 
              RowBox[{"transfery1CC07", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "-", "1"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"15", ",", "16"}], "}"}]}], "]"}], "]"}]}], "+", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"1", ",", "0"}], "}"}], "*", "xi1", "*", 
              RowBox[{"transfery1CC07", "[", 
               RowBox[{"[", 
                RowBox[{"i", ",", "13"}], "]"}], "]"}]}]}], "/.", 
            "parT071calc"}]}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"transfery1CC07", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", 
              RowBox[{"{", 
               RowBox[{"17", ",", "18"}], "}"}]}], "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{
             RowBox[{"TransT071calb", ".", 
              RowBox[{"transfery1CC07", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "-", "1"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"17", ",", "18"}], "}"}]}], "]"}], "]"}]}], "+", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"1", ",", "0"}], "}"}], "*", "xi1", "*", 
              RowBox[{"transfery1CC07", "[", 
               RowBox[{"[", 
                RowBox[{"i", ",", "14"}], "]"}], "]"}]}]}], "/.", 
            "parT071calb"}]}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"transfery1CC07", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "7"}], "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{"Total", "[", 
             RowBox[{"transfery1CC07", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", 
                RowBox[{"{", 
                 RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "]"}], "]"}], 
             "]"}], "-", 
            RowBox[{"Total", "[", 
             RowBox[{"transfery1CC07", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"i", "-", "1"}], ",", 
                RowBox[{"{", 
                 RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "]"}], "]"}], 
             "]"}]}]}], ",", 
          RowBox[{
           RowBox[{"transfery1CC07", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "11"}], "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{"Total", "[", 
             RowBox[{"transfery1CC07", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", 
                RowBox[{"{", 
                 RowBox[{"8", ",", "9", ",", "10"}], "}"}]}], "]"}], "]"}], 
             "]"}], "-", 
            RowBox[{"Total", "[", 
             RowBox[{"transfery1CC07", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"i", "-", "1"}], ",", 
                RowBox[{"{", 
                 RowBox[{"8", ",", "9", ",", "10"}], "}"}]}], "]"}], "]"}], 
             "]"}]}]}]}], "}"}], ",", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"i", ",", "3", ",", "y"}], "}"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"ZECMIPresults", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;", "y"}], ",", 
          RowBox[{
           RowBox[{"k", "*", "7"}], "-", "1"}]}], "]"}], "]"}], "=", 
       RowBox[{"transfery1CC07", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;", "y"}], ",", "4"}], "]"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"ZECMIPresults", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;", "y"}], ",", 
          RowBox[{"k", "*", "7"}]}], "]"}], "]"}], "=", 
       RowBox[{"transfery1CC07", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;", "y"}], ",", "8"}], "]"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{
         RowBox[{"upper1CC13", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;", "y"}], ",", 
            RowBox[{"k", "+", "3"}]}], "]"}], "]"}], "=", 
         RowBox[{"transfery1CC13", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;", "y"}], ",", "5"}], "]"}], "]"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"lower1CC13", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;", "y"}], ",", 
            RowBox[{"k", "+", "3"}]}], "]"}], "]"}], "=", 
         RowBox[{"transfery1CC13", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;", "y"}], ",", "6"}], "]"}], "]"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"force1CC13", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;", "y"}], ",", 
            RowBox[{"k", "+", "3"}]}], "]"}], "]"}], "=", 
         RowBox[{"transfery1CC13", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;", "y"}], ",", "9"}], "]"}], "]"}]}], ","}], 
       "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"ZECMIPresults", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;", "y"}], ",", 
          RowBox[{"20", "+", 
           RowBox[{"k", "*", "7"}]}]}], "]"}], "]"}], "=", 
       RowBox[{"transfery1CC07", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;", "y"}], ",", "15"}], "]"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"ZECMIPresults", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;", "y"}], ",", 
          RowBox[{"21", "+", 
           RowBox[{"k", "*", "7"}]}]}], "]"}], "]"}], "=", 
       RowBox[{"transfery1CC07", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;", "y"}], ",", "17"}], "]"}], "]"}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", "1", ",", "3"}], "}"}]}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.7920295174306426`*^9, 3.7920296240259695`*^9}, 
   3.7920296562702756`*^9, 3.7920299489930334`*^9, {3.7920300286729827`*^9, 
   3.7920300452551394`*^9}, {3.792030749055524*^9, 3.792030775922874*^9}, {
   3.7920308859542513`*^9, 3.7920309292614193`*^9}, {3.792031843803426*^9, 
   3.792031942968858*^9}, {3.7920319907182646`*^9, 3.792032015281928*^9}, {
   3.792032058800349*^9, 3.7920320752263308`*^9}, {3.7920323050159206`*^9, 
   3.7920324077366877`*^9}, {3.7920324671434374`*^9, 3.792032482999258*^9}, {
   3.792032611440982*^9, 3.7920326158071566`*^9}, {3.7920327615832467`*^9, 
   3.7920328067427187`*^9}, {3.7920334007064004`*^9, 
   3.7920334214787354`*^9}, {3.792035955558097*^9, 3.792036012070055*^9}, {
   3.792036046458066*^9, 3.792036084942918*^9}, {3.7927439980635*^9, 
   3.7927439995011473`*^9}, {3.810190824093872*^9, 3.8101909750021825`*^9}, {
   3.810191010756048*^9, 3.810191111014434*^9}, {3.810191295273965*^9, 
   3.8101913839399376`*^9}, {3.8101914246549754`*^9, 3.810191428248706*^9}, {
   3.810191635020672*^9, 3.8101917309279904`*^9}, {3.8101920096607895`*^9, 
   3.8101920129720707`*^9}, {3.810227415352755*^9, 3.810227440512192*^9}, {
   3.8102274729351254`*^9, 3.810227538763339*^9}, {3.8102300179769573`*^9, 
   3.810230106483638*^9}, {3.810230177843181*^9, 3.810230229576248*^9}, {
   3.8102302817912793`*^9, 3.810230327595955*^9}, {3.810233396645327*^9, 
   3.810233400624997*^9}, {3.810233451439539*^9, 3.8102336548939886`*^9}, {
   3.8102337642842765`*^9, 3.810233871481276*^9}, {3.8102344596856575`*^9, 
   3.8102345123115354`*^9}, {3.810234568645584*^9, 3.8102345869509325`*^9}, {
   3.8102346630071793`*^9, 3.810234749532464*^9}, {3.810234829427137*^9, 
   3.8102348360786805`*^9}, {3.8102348795761595`*^9, 
   3.8102348838141346`*^9}, {3.810234914791686*^9, 3.810235062772265*^9}, {
   3.8102350976892834`*^9, 3.8102352657636237`*^9}, {3.810235875475949*^9, 
   3.810235879233179*^9}, 3.8102787856541605`*^9, {3.810299774492795*^9, 
   3.8102997775922203`*^9}, {3.8102998171081157`*^9, 
   3.8102998180284567`*^9}, {3.81030943178913*^9, 3.8103094447911797`*^9}, {
   3.810309646438561*^9, 3.810309650969429*^9}, {3.810310683992111*^9, 
   3.810310696828996*^9}, {3.810363907568935*^9, 3.810364007446059*^9}, {
   3.810368806822912*^9, 3.8103688072710032`*^9}, {3.810959728999687*^9, 
   3.810959730092713*^9}, {3.812825900309496*^9, 3.812825932118302*^9}, 
   3.8128259691292458`*^9, {3.8128260509087143`*^9, 3.8128260547474213`*^9}, {
   3.8128261078560605`*^9, 3.812826128464399*^9}, {3.812826232046361*^9, 
   3.812826280845895*^9}, 3.812826361819337*^9, {3.812826394240965*^9, 
   3.81282659755645*^9}, {3.8128266566365976`*^9, 3.8128266608203464`*^9}, {
   3.8128266975879693`*^9, 3.812826699938088*^9}, {3.8128271172445073`*^9, 
   3.8128271177790637`*^9}, {3.813604642617973*^9, 3.8136046488165317`*^9}, {
   3.813604690382924*^9, 3.8136047059841914`*^9}, {3.8136048008793*^9, 
   3.813604900213408*^9}, 3.8136049770113754`*^9, {3.8136051618384023`*^9, 
   3.813605462551299*^9}, {3.813605818571022*^9, 3.8136060368268642`*^9}, {
   3.823319896986742*^9, 3.82331991699877*^9}, {3.8233199484938145`*^9, 
   3.82331999469088*^9}, {3.82332011569905*^9, 3.82332016549512*^9}, {
   3.8233202080411797`*^9, 3.823320238985224*^9}, {3.8233202851594334`*^9, 
   3.823320314493475*^9}, {3.823320961776496*^9, 3.8233209641864996`*^9}, {
   3.823329150881261*^9, 3.823329168943287*^9}, {3.8233293162724943`*^9, 
   3.8233293380545244`*^9}, {3.8233479441726727`*^9, 3.8233479797847233`*^9}},
 CellLabel->
  "In[2012]:=",ExpressionUUID->"7c6206e2-08e9-4eda-be45-1e4ff9874ce6"],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"y", "=", "zb"}], ",", "\[IndentingNewLine]", 
     RowBox[{"transFairG", "=", 
      RowBox[{"Table", "[", 
       RowBox[{"0", ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "y"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"j", ",", "20"}], "}"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"transFairG", "[", 
       RowBox[{"[", "1", "]"}], "]"}], "=", 
      RowBox[{"{", 
       RowBox[{
       "\"\<1-Y\>\"", ",", "\"\<2-E\>\"", ",", "\"\<3-R1\>\"", ",", 
        "\"\<4-R2\>\"", ",", "\"\<5-R3\>\"", ",", "\"\<6-R4\>\"", ",", 
        "\"\<7-C\>\"", ",", "\"\<8-CCA\>\"", ",", "\"\<9-F\>\"", ",", 
        "\"\<10-Fex\>\"", ",", "\"\<11-TF\>\"", ",", "\"\<12-TMF\>\"", ",", 
        "\"\<13-TMS\>\"", ",", "\"\<14-TDF\>\"", ",", "\"\<15-TDS\>\"", ",", 
        "\"\<16-TM\>\"", ",", "\"\<17-TD\>\"", ",", "\"\<18-\[Alpha]\>\"", 
        ",", "\"\<19-\[Alpha]check\>\"", ",", "\"\<20-atmosGt\>\""}], "}"}]}],
      ",", "\[IndentingNewLine]", 
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"transFairG", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"n", "+", "1"}], ",", "1"}], "]"}], "]"}], "=", 
        RowBox[{"1765", "-", "1", "+", "n"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "1", ",", 
         RowBox[{"y", "-", "1"}]}], "}"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"emcolumns", "=", 
      RowBox[{"{", 
       RowBox[{"3", ",", "4", ",", "5"}], "}"}]}], ",", " ", 
     RowBox[{"(*", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "3", ",", "4"}], "}"}], ","}], "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{
       RowBox[{
        RowBox[{"transFairG", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;"}], ",", "2"}], "]"}], "]"}], "=", 
        RowBox[{
         RowBox[{"dtemp", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;"}], ",", "3"}], "]"}], "]"}], "/", "2.12"}]}], 
       ","}], "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"transFairG", "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{"2", ";;", "y"}], ",", "2"}], "]"}], "]"}], "=", 
      RowBox[{
       RowBox[{"dataB", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;", "zb"}], ",", 
          RowBox[{"emcolumns", "[", 
           RowBox[{"[", "k", "]"}], "]"}]}], "]"}], "]"}], "/", 
       "2.1293970467500096"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"transFairG", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "4", ",", "5", ",", "6"}], "}"}]}], "]"}], "]"}], 
      "=", "0"}], ",", " ", 
     RowBox[{"(*", 
      RowBox[{
       RowBox[{
       "initial", " ", "carbon", " ", "values", " ", "for", " ", "R1"}], ",", 
       "R2", ",", "R3", ",", "R4"}], "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"transFairG", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", "7"}], "]"}], "]"}], "=", 
      RowBox[{
       RowBox[{"Total", "[", 
        RowBox[{"transFairG", "[", 
         RowBox[{"[", 
          RowBox[{"2", ",", 
           RowBox[{"3", ";;", "6"}]}], "]"}], "]"}], "]"}], "+", 
       "278.0014091894"}]}], ",", " ", 
     RowBox[{"(*", 
      RowBox[{
      "initial", " ", "atmospheric", " ", "carbon", " ", "concentration"}], 
      "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"transFairG", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", "8"}], "]"}], "]"}], "=", "0"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"transFairG", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", "9"}], "]"}], "]"}], "=", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"F2x", "/", 
          RowBox[{"Log", "[", "2", "]"}]}], ")"}], "*", 
        RowBox[{"Log", "[", 
         RowBox[{
          RowBox[{"transFairG", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "7"}], "]"}], "]"}], "/", "278"}], "]"}]}], "/.",
        "parFair"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{
       RowBox[{"fexcolumns", "=", 
        RowBox[{"{", 
         RowBox[{"40", ",", "44", ",", "45"}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"transFairG", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;"}], ",", "10"}], "]"}], "]"}], "=", 
        RowBox[{"dataRCP1", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;", "255"}], ",", 
           RowBox[{"fexcolumns", "[", 
            RowBox[{"[", "k", "]"}], "]"}]}], "]"}], "]"}]}], ","}], "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"transFairG", "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{"2", ";;"}], ",", "11"}], "]"}], "]"}], "=", 
      RowBox[{"Total", "[", 
       RowBox[{"transFairG", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", 
          RowBox[{"9", ";;", "10"}]}], "]"}], "]"}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"transFairG", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", 
         RowBox[{"{", 
          RowBox[{"12", ",", "13", ",", "14", ",", "15"}], "}"}]}], "]"}], 
       "]"}], "=", "0"}], ",", " ", 
     RowBox[{"(*", 
      RowBox[{
      "initial", " ", "values", " ", "for", " ", "Mix", " ", "Layer", " ", 
       "Fast", " ", "and", " ", "Slow", " ", "Response", " ", "and", " ", 
       "Deep", " ", "Layer", " ", "Fast", " ", "and", " ", "Slow", " ", 
       "Response"}], "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"transFairG", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", "16"}], "]"}], "]"}], "=", 
      RowBox[{"Total", "[", 
       RowBox[{"transFairG", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", 
          RowBox[{"12", ";;", "13"}]}], "]"}], "]"}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"transFairG", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", "17"}], "]"}], "]"}], "=", 
      RowBox[{"Total", "[", 
       RowBox[{"transFairG", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", 
          RowBox[{"14", ";;", "15"}]}], "]"}], "]"}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"transFairG", "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{"2", ";;"}], ",", "18"}], "]"}], "]"}], "=", 
      RowBox[{
       RowBox[{"FindRoot", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"rirf", "[", 
           RowBox[{
            RowBox[{"transFairG", "[", 
             RowBox[{"[", 
              RowBox[{"2", ",", "8"}], "]"}], "]"}], ",", 
            RowBox[{"transFairG", "[", 
             RowBox[{"[", 
              RowBox[{"2", ",", "16"}], "]"}], "]"}]}], "]"}], "\[Equal]", 
          RowBox[{"lirf", "[", "\[Alpha]", "]"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"\[Alpha]", ",", "0.2"}], "}"}]}], "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "2"}], "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"transFairG", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", "19"}], "]"}], "]"}], "=", 
      RowBox[{"transFairG", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", "18"}], "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"transFairG", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", 
             RowBox[{"3", ";;", "6"}]}], "]"}], "]"}], "=", 
          RowBox[{
           RowBox[{"transFairG", "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"i", "-", "1"}], ",", 
              RowBox[{"3", ";;", "6"}]}], "]"}], "]"}], "+", 
           RowBox[{"dr", "[", 
            RowBox[{"aFair", ",", "\[Tau]Fair", ",", 
             RowBox[{"transFairG", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"i", "-", "1"}], ",", "18"}], "]"}], "]"}], ",", 
             RowBox[{"transFairG", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"i", "-", "1"}], ",", "2"}], "]"}], "]"}], ",", 
             RowBox[{"transFairG", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"i", "-", "1"}], ",", 
                RowBox[{"3", ";;", "6"}]}], "]"}], "]"}]}], "]"}]}]}], ",", 
         RowBox[{
          RowBox[{"transFairG", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "7"}], "]"}], "]"}], "=", 
          RowBox[{"278.0014091894", "+", 
           RowBox[{"Total", "[", 
            RowBox[{"transFairG", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", 
               RowBox[{"3", ";;", "6"}]}], "]"}], "]"}], "]"}]}]}], ",", 
         RowBox[{
          RowBox[{"transFairG", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "8"}], "]"}], "]"}], "=", 
          RowBox[{
           RowBox[{"transFairG", "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"i", "-", "1"}], ",", "8"}], "]"}], "]"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"transFairG", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "-", "1"}], ",", "2"}], "]"}], "]"}], "-", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"transFairG", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", ",", "7"}], "]"}], "]"}], "-", 
                RowBox[{"transFairG", "[", 
                 RowBox[{"[", 
                  RowBox[{
                   RowBox[{"i", "-", "1"}], ",", "7"}], "]"}], "]"}]}], 
               ")"}]}], ")"}], "*", "2.12"}]}]}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"transFairG", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "9"}], "]"}], "]"}], "=", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"F2x", "/", 
              RowBox[{"Log", "[", "2", "]"}]}], ")"}], "*", 
            RowBox[{"Log", "[", 
             RowBox[{
              RowBox[{"transFairG", "[", 
               RowBox[{"[", 
                RowBox[{"i", ",", "7"}], "]"}], "]"}], "/", 
              "278.0014091894"}], "]"}]}], "/.", "parFair"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"transFairG", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "11"}], "]"}], "]"}], "=", 
          RowBox[{"Total", "[", 
           RowBox[{"transFairG", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", 
              RowBox[{"9", ";;", "10"}]}], "]"}], "]"}], "]"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"transFairG", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "12"}], "]"}], "]"}], "=", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"expf", "*", 
              RowBox[{"transFairG", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "-", "1"}], ",", "12"}], "]"}], "]"}]}], "+", 
             RowBox[{"amixf", "*", "intf"}]}], "/.", 
            RowBox[{"f0", "\[Rule]", 
             RowBox[{"transFairG", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"i", "-", "1"}], ",", "11"}], "]"}], "]"}]}]}], "/.", 
           RowBox[{"f1", "\[Rule]", 
            RowBox[{"transFairG", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", "11"}], "]"}], "]"}]}]}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"transFairG", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "13"}], "]"}], "]"}], "=", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"exps", "*", 
              RowBox[{"transFairG", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "-", "1"}], ",", "13"}], "]"}], "]"}]}], "+", 
             RowBox[{"amixs", "*", "ints"}]}], "/.", 
            RowBox[{"f0", "\[Rule]", 
             RowBox[{"transFairG", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"i", "-", "1"}], ",", "11"}], "]"}], "]"}]}]}], "/.", 
           RowBox[{"f1", "\[Rule]", 
            RowBox[{"transFairG", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", "11"}], "]"}], "]"}]}]}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"transFairG", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "14"}], "]"}], "]"}], "=", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"expf", "*", 
              RowBox[{"transFairG", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "-", "1"}], ",", "14"}], "]"}], "]"}]}], "+", 
             RowBox[{"adeepf", "*", "intf"}]}], "/.", 
            RowBox[{"f0", "\[Rule]", 
             RowBox[{"transFairG", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"i", "-", "1"}], ",", "11"}], "]"}], "]"}]}]}], "/.", 
           RowBox[{"f1", "\[Rule]", 
            RowBox[{"transFairG", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", "11"}], "]"}], "]"}]}]}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"transFairG", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "15"}], "]"}], "]"}], "=", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"exps", "*", 
              RowBox[{"transFairG", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "-", "1"}], ",", "15"}], "]"}], "]"}]}], "+", 
             RowBox[{"adeeps", "*", "ints"}]}], "/.", 
            RowBox[{"f0", "\[Rule]", 
             RowBox[{"transFairG", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"i", "-", "1"}], ",", "11"}], "]"}], "]"}]}]}], "/.", 
           RowBox[{"f1", "\[Rule]", 
            RowBox[{"transFairG", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", "11"}], "]"}], "]"}]}]}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"transFairG", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "16"}], "]"}], "]"}], "=", 
          RowBox[{"Total", "[", 
           RowBox[{"transFairG", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", 
              RowBox[{"12", ";;", "13"}]}], "]"}], "]"}], "]"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"transFairG", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "17"}], "]"}], "]"}], "=", 
          RowBox[{"Total", "[", 
           RowBox[{"transFairG", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", 
              RowBox[{"14", ";;", "15"}]}], "]"}], "]"}], "]"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"(*", 
          RowBox[{
           RowBox[{
            RowBox[{"transFairG", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", 
               RowBox[{"{", 
                RowBox[{"11", ",", "12"}], "}"}]}], "]"}], "]"}], "=", 
            RowBox[{
             RowBox[{
              RowBox[{"transT", ".", 
               RowBox[{"transFairG", "[", 
                RowBox[{"[", 
                 RowBox[{
                  RowBox[{"i", "-", "1"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"11", ",", "12"}], "}"}]}], "]"}], "]"}]}], "+", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"1", ",", "0"}], "}"}], "*", "xi1", "*", 
               RowBox[{"Total", "[", 
                RowBox[{"transFairG", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", ",", 
                   RowBox[{"9", ";;", "10"}]}], "]"}], "]"}], "]"}]}]}], "/.",
              "parTG"}]}], ","}], "\[IndentingNewLine]", 
          RowBox[{"(*", 
           RowBox[{
            RowBox[{
             RowBox[{"transFairG", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "13"}], "]"}], "]"}], "=", 
             RowBox[{"Total", "[", 
              RowBox[{"transFairG", "[", 
               RowBox[{"[", 
                RowBox[{"i", ",", 
                 RowBox[{"11", ";;", "12"}]}], "]"}], "]"}], "]"}]}], ","}], 
           "*)"}], "*)"}], "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"transFairG", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "18"}], "]"}], "]"}], "=", 
          RowBox[{
           RowBox[{"FindRoot", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"rirf", "[", 
               RowBox[{
                RowBox[{"transFairG", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", ",", "8"}], "]"}], "]"}], ",", 
                RowBox[{"transFairG", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", ",", "16"}], "]"}], "]"}]}], "]"}], "\[Equal]", 
              RowBox[{"lirf", "[", "\[Alpha]", "]"}]}], ",", 
             RowBox[{"{", 
              RowBox[{"\[Alpha]", ",", 
               RowBox[{"transFairG", "[", 
                RowBox[{"[", 
                 RowBox[{
                  RowBox[{"i", "-", "1"}], ",", "18"}], "]"}], "]"}]}], 
              "}"}]}], "]"}], "[", 
           RowBox[{"[", 
            RowBox[{"1", ",", "2"}], "]"}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"transFairG", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "19"}], "]"}], "]"}], "=", 
          RowBox[{
           RowBox[{
            RowBox[{"transFairG", "[", 
             RowBox[{"[", 
              RowBox[{
               RowBox[{"i", "-", "1"}], ",", "19"}], "]"}], "]"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"rT", "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"transFairG", "[", 
                   RowBox[{"[", 
                    RowBox[{"i", ",", "16"}], "]"}], "]"}], "-", 
                  RowBox[{"transFairG", "[", 
                   RowBox[{"[", 
                    RowBox[{
                    RowBox[{"i", "-", "1"}], ",", "16"}], "]"}], "]"}]}], 
                 ")"}]}], "+", 
               RowBox[{"rc", "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"transFairG", "[", 
                   RowBox[{"[", 
                    RowBox[{"i", ",", "8"}], "]"}], "]"}], "-", 
                  RowBox[{"transFairG", "[", 
                   RowBox[{"[", 
                    RowBox[{
                    RowBox[{"i", "-", "1"}], ",", "8"}], "]"}], "]"}]}], 
                 ")"}]}]}], ")"}], "/", 
             RowBox[{"(", 
              RowBox[{"dalpha", "[", 
               RowBox[{"transFairG", "[", 
                RowBox[{"[", 
                 RowBox[{
                  RowBox[{"i", "-", "1"}], ",", "19"}], "]"}], "]"}], "]"}], 
              ")"}]}]}], "/.", "parFair"}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "3", ",", "zb"}], "}"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"transFairG", "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{"2", ";;"}], ",", "20"}], "]"}], "]"}], "=", 
      RowBox[{
       RowBox[{"transFairG", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", "7"}], "]"}], "]"}], "*", "2.12"}]}], ",",
      "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"ZECMIPresults", "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{"2", ";;", "y"}], ",", 
         RowBox[{
          RowBox[{"k", "*", "7"}], "+", "1"}]}], "]"}], "]"}], "=", 
      RowBox[{"transFairG", "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{"2", ";;"}], ",", "20"}], "]"}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"ZECMIPresults", "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{"2", ";;", "y"}], ",", 
         RowBox[{
          RowBox[{"k", "*", "7"}], "+", "22"}]}], "]"}], "]"}], "=", 
      RowBox[{"transFairG", "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{"2", ";;"}], ",", "16"}], "]"}], "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "1", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->CompressedData["
1:eJwdz2tIk2EAxfHRcqgj0pprbgo5Qsbc1oJYSZB7qaBcECtjy7XlbOm2gtU0
glqRJlNMEMvuZhJ0oxpuDiumSyywUJfktJQaYpaX3lZCUgaOnvN8OPy+/k9O
qWvvkWUcDkdJBm+l512oO8wybVpHO/yncx/wE9V5o9Tos54HHURO7RDVm7S4
PmpjmZlcvhom3kUMi+Usc1lqsMGareluGOMWUQXRp3dNDpa5+cMbgL0nkkLw
tMfWD+vsXUEzcbdeGIa8LRv64KeqMDWm+z4NhS8Ecegt/JprIQavPZdB7tyY
Av4e/2uE060lJVDUctUKZeLiMti7tM0BX/s7r8O0+lFqyr3+ELz/NrUH+syb
nVb08nynYHz5z/PwjV9ZBaPv+67AmGuEmlQvGQgQjYEm6vAT+QRs0C1QA93O
BTjPf5mAM4OS7A6iKjIlhS2vNCo4GU9oYLap+ii0hz5QRdrZ8iD6Vv6hehyF
pY9cLFO5X0/1/8qogBrf7UoYV0+sHiLuarQKYCBjU3PkOMuIgwbqHj6/wHGG
ZZLlIurHjVxTpof8URwyw2HepTI4kDDbYVt8X7icWPC4oQfGnKJB2GqppjZ3
PxyBqjtrxqA8f8dnqM05OwVrapdS7MRz7fmp0GjXS6DF3kR13tiZeYy4NrlR
DAuy5hQwbVaohO7J+bkK4kFuMQuzOsXSk8RVRd/WwRXbx2Ww6+IX6n8LIXBG

  "],
 CellLabel->
  "In[2013]:=",ExpressionUUID->"5d70ae5d-b272-4058-8268-b12a801e6ac4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<ZECMIP_B_results.csv\>\"", ",", "ZECMIPresults"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.8233221321061506`*^9, 3.823322162041193*^9}, {
  3.8233223107235146`*^9, 3.823322312184517*^9}, {3.823348057963834*^9, 
  3.823348059973837*^9}},
 CellLabel->
  "In[1070]:=",ExpressionUUID->"48808856-a49c-4610-944a-574fef34f8ea"],

Cell[BoxData["\<\"ZECMIP_B_results.csv\"\>"], "Output",
 CellChangeTimes->{3.8233221685862055`*^9, 3.823322314034519*^9, 
  3.823345517013924*^9, 3.823348060893838*^9, 3.8233486992007904`*^9},
 CellLabel->
  "Out[1070]=",ExpressionUUID->"2b0007f0-ea0c-4bdb-8580-fac5ac679dc0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ZECMIPresults", "[", 
  RowBox[{"[", 
   RowBox[{"1", ";;", "2"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.8242314137932034`*^9, 3.8242314164301777`*^9}},
 CellLabel->
  "In[2072]:=",ExpressionUUID->"b5f19cdf-3800-4b97-987b-d95ccf566cc7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"1-year\"\>", ",", "\<\"2-B1C-CC16c\"\>", 
     ",", "\<\"3-B1C-CC16b\"\>", ",", "\<\"4-B1C-CC13c\"\>", 
     ",", "\<\"5-B1C-CC13b\"\>", ",", "\<\"6-B1C-CC07c\"\>", 
     ",", "\<\"7-B1C-CC07b\"\>", ",", "\<\"8-B1C-FG\"\>", 
     ",", "\<\"9-B2C-CC16c\"\>", ",", "\<\"10-B2C-CC16b\"\>", 
     ",", "\<\"11-B2C-CC13c\"\>", ",", "\<\"12-B2C-CC13b\"\>", 
     ",", "\<\"13-B2C-CC07c\"\>", ",", "\<\"14-B2C-CC07b\"\>", 
     ",", "\<\"15-B2C-FG\"\>", ",", "\<\"16-B3C-CC16c\"\>", 
     ",", "\<\"17-B3C-CC16b\"\>", ",", "\<\"18-B3C-CC13c\"\>", 
     ",", "\<\"19-B3C-CC13b\"\>", ",", "\<\"20-B3C-CC07c\"\>", 
     ",", "\<\"21-B3C-CC07b\"\>", ",", "\<\"22-B3C-FG\"\>", 
     ",", "\<\"23-B1T-CC16c\"\>", ",", "\<\"24-B1T-CC16b\"\>", 
     ",", "\<\"25-B1T-CC13c\"\>", ",", "\<\"26-B1T-CC13b\"\>", 
     ",", "\<\"27-B1T-CC07c\"\>", ",", "\<\"28-B1T-CC07b\"\>", 
     ",", "\<\"29-B1T-FG\"\>", ",", "\<\"30-B2T-CC16c\"\>", 
     ",", "\<\"31-B2T-CC16b\"\>", ",", "\<\"32-B2T-CC13c\"\>", 
     ",", "\<\"33-B2T-CC13b\"\>", ",", "\<\"34-B2T-CC07c\"\>", 
     ",", "\<\"35-B2T-CC07b\"\>", ",", "\<\"36-B2T-FG\"\>", 
     ",", "\<\"37-B3T-CC16c\"\>", ",", "\<\"38-B3T-CC16b\"\>", 
     ",", "\<\"39-B3T-CC13c\"\>", ",", "\<\"40-B3T-CC13b\"\>", 
     ",", "\<\"41-B3T-CC07c\"\>", ",", "\<\"42-B3T-CC07b\"\>", 
     ",", "\<\"43-B3T-FG\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "588", ",", "588", ",", "588", ",", "588", ",", "587.473`", ",",
      "587.473`", ",", "589.3629874815281`", ",", "588", ",", "588", ",", 
     "588", ",", "588", ",", "587.473`", ",", "587.473`", ",", 
     "589.3629874815281`", ",", "588", ",", "588", ",", "588", ",", "588", 
     ",", "587.473`", ",", "587.473`", ",", "589.3629874815281`", ",", "0", 
     ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.824231417178588*^9},
 CellLabel->
  "Out[2072]=",ExpressionUUID->"be615a8c-1859-459b-8b34-fd9236f231ea"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dataB", "[", 
  RowBox[{"[", 
   RowBox[{"1", ";;", "2"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.8242314695036364`*^9, 3.82423147406775*^9}},
 CellLabel->
  "In[2074]:=",ExpressionUUID->"8e1d1814-1bbf-4082-86b9-b8002fc27065"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"Counter#1\"\>", ",", "\<\"Counter #2\"\>", ",", "\<\"B1\"\>",
      ",", "\<\"B2\"\>", ",", "\<\"B2\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "1", ",", "0.20873014`", ",", "0.1565476`", ",", 
     "0.41746028`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.824231474749881*^9},
 CellLabel->
  "Out[2074]=",ExpressionUUID->"564b2b91-ae8d-41ea-9373-f7761ce439be"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"dataB", "[", 
   RowBox[{"[", 
    RowBox[{
     RowBox[{"2", ";;"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "4"}], "}"}]}], "]"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.8242314474219418`*^9, 3.824231489234949*^9}},
 CellLabel->
  "In[2075]:=",ExpressionUUID->"b65eb2ff-29dc-4599-95e6-2af743bd37cd"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
      NCache[
       Rational[1, 72], 0.013888888888888888`]], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxd1XtM1WUYB/B3mIY5lbILZkNUMDRmeD8Kwpebcj2cwwHOOV3sIKGwNDW1
P0jwzVZzixqsvP1jZ5WNBTGdM+xiexu5MvEPV1HkiGPLrrDZGFYrWzUe1p7v
2c7OPuc573l+v/d9nuc3b9P2yvo4Y8z5f9//fY6/ruW0rpq/y039KEe+wNsp
F3El/xNxPPrLE24bK7goTsAzp46H9h28JL4dVeGTpYemfSFOxBlP9/axOwfE
98BbP/P9XRcGxcnYcjYhnPvKFfF87Lm789yLvd+JU3B1YPDn/o0/ihfi3Td7
s35tHhanwRcXDiYdviZejD2JTbUfZI+K0/H47Olbv8y6Ll6CzpahY48d+UOc
gda2HQl1oRvipbiBzamnPzQY9zLM7bnp2e9nThIvxwt9P332xtHJ4hWYEUwe
3FsbL16J1MzLRS2N08SrkFocv85zaoZ4NV6ve+qXC3NvFXvw7VsrWxtvniVe
g6Yz7TsWJdwhXoviwhJfxZq7xJkoq/dkHn96tjgL59rTMnb/MEe8DodWjL7a
0pAkzsalgSeP/G2TxTlom7RgxPvVPDHw5++Bv/I8C8Ztge7Ytpc7j6VIPBe3
NL1zdM7UhRLPxYknGtpHdt8r8TwU7u3rKhlKk3ge/B1xxcsLF0s8H7Oasz89
8Np9Es/H6M5tHYm/pUu8ACeGB5s6spZIvAC9l785H7fzfokXYuT5tYv2F2VI
vBAvBTJ7P+8Tm/XoiW8dm16wVOLrceD6yf1DXWKzAaev9uQnTVkm8Q3o+npf
98desSlCesrk96Y8NxEvQluwf3h150S8GI1ZW5uHz07EyaZE/96W6P8zpTqf
LdXXY8r09doyfT+mXN+vLdf7Ybx6v6xX76ep0PttK/R5GJ8+L/joPH36vJ1P
14Px63qBn+rJr+vN+akeK3W9olLXs63U9e4qqR8Cul8Q0P1kA7rfXID6sUr3
K6p0P9sq3e+uiuZBtZ4XqNbzxFbreeOqaR7V6HmFGj3PbI2ed66G5mFQz0sE
9Ty1QT1vXZDmcUjPa4T0PLchPe9diJ4HYajnBcKyL/KyZEc2D2iDbMmObB6k
9WRLdmTzEK0nW7Ijm4dpPdmSHdlspPVkS3Zk8witJ1uyI5uIdjIZ5AjZkqNk
R46RTS3lJ4McIVtylOzIMbLZRPnJIEfIlhwlO3KMbOooPxnkCNmSo2RHjpHN
o5SfDHKEbMlRsiPHyKae8pNBjpAtOUp25BjZbKb8ZJAjZEuOkh05RjZbKD8Z
5AjZkqNkR46RTQPlJ4McIVtylOzIMbJppPz/+x8DCxq0
      "]]}}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 201.}, {0, 18.7418898}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.824231465094016*^9, 3.824231489667185*^9}},
 CellLabel->
  "Out[2075]=",ExpressionUUID->"2fe2d295-d9f4-4e82-91b6-4bd339d51f2e"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ZECMIPtable", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "22"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "16"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ZECMIPtable", "[", 
    RowBox[{"[", "1", "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
    "\"\<\>\"", ",", "\"\<int-C\>\"", ",", "\"\<max-C\>\"", ",", 
     "\"\<100y-C\>\"", ",", "\"\<150y-C\>\"", ",", "\"\<200y-C\>\"", ",", 
     "\"\<deltaCmax\>\"", ",", "\"\<deltaC100\>\"", ",", "\"\<deltaC150\>\"", 
     ",", "\"\<deltaC200\>\"", ",", "\"\<ZEC50-C\>\"", ",", "\"\<maxT\>\"", 
     ",", "\"\<100y-T\>\"", ",", "\"\<150y-T\>\"", ",", "\"\<200y-T\>\"", 
     ",", "\"\<ZEC50-T\>\""}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"ZECMIPtable", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", "1"}], "]"}], "]"}], "=", 
    RowBox[{"{", 
     RowBox[{
     "\"\<B1-CC16c\>\"", ",", "\"\<B1-CC16b\>\"", ",", "\"\<B1-CC13c\>\"", 
      ",", "\"\<B1-CC13b\>\"", ",", "\"\<B1-CC07c\>\"", ",", 
      "\"\<B1-CC07b\>\"", ",", "\"\<B1-FG\>\"", ",", "\"\<B1-Nor\>\"", ",", 
      "\"\<B3-CC16c\>\"", ",", "\"\<B3-CC16b\>\"", ",", "\"\<B3-CC13c\>\"", 
      ",", "\"\<B3-CC13b\>\"", ",", "\"\<B3-CC07c\>\"", ",", 
      "\"\<B3-CC07b\>\"", ",", "\"\<B3-FG\>\"", ",", "\"\<B3-Nor\>\"", ",", 
      "\"\<B4-CC16c\>\"", ",", "\"\<B4-CC16b\>\"", ",", "\"\<B4-CC13c\>\"", 
      ",", "\"\<B4-CC13b\>\"", ",", "\"\<B4-CC07c\>\"", ",", 
      "\"\<B4-CC07b\>\"", ",", "\"\<B4-FG\>\"", ",", "\"\<B4-Nor\>\""}], 
     "}"}]}], "*)"}]}]}], "Input",
 CellChangeTimes->{{3.8233281564898024`*^9, 3.823328180093836*^9}, {
   3.8233282318209085`*^9, 3.823328250822935*^9}, {3.8233298060261827`*^9, 
   3.823330039692511*^9}, {3.823330073875559*^9, 3.823330079166567*^9}, {
   3.823330178088706*^9, 3.823330184049714*^9}, {3.8233480999789476`*^9, 
   3.8233481029089518`*^9}, {3.823348142715008*^9, 3.8233481430750084`*^9}, {
   3.824232092970832*^9, 3.824232185144212*^9}, {3.824232426322877*^9, 
   3.824232458979495*^9}, {3.824232511943711*^9, 3.824232520712385*^9}, 
   3.8242328022909746`*^9, 3.82423285090526*^9},
 CellLabel->
  "In[2100]:=",ExpressionUUID->"934db004-6515-4527-9095-7ee2a0bdd225"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ZECMIPtable", "[", 
   RowBox[{"[", 
    RowBox[{
     RowBox[{"2", ";;"}], ",", "1"}], "]"}], "]"}], "=", 
  RowBox[{"{", 
   RowBox[{
   "\"\<B1-CC16c\>\"", ",", "\"\<B1-CC16b\>\"", ",", "\"\<B1-CC13c\>\"", ",", 
    "\"\<B1-CC13b\>\"", ",", "\"\<B1-CC07c\>\"", ",", "\"\<B1-CC07b\>\"", 
    ",", "\"\<B1-FG\>\"", ",", "\"\<B2-CC16c\>\"", ",", "\"\<B2-CC16b\>\"", 
    ",", "\"\<B2-CC13c\>\"", ",", "\"\<B2-CC13b\>\"", ",", "\"\<B2-CC07c\>\"",
     ",", "\"\<B2-CC07b\>\"", ",", "\"\<B2-FG\>\"", ",", "\"\<B3-CC16c\>\"", 
    ",", "\"\<B3-CC16b\>\"", ",", "\"\<B3-CC13c\>\"", ",", "\"\<B3-CC13b\>\"",
     ",", "\"\<B3-CC07c\>\"", ",", "\"\<B3-CC07b\>\"", ",", "\"\<B3-FG\>\""}],
    "}"}]}]], "Input",
 CellChangeTimes->{{3.823348118680974*^9, 3.823348134461996*^9}, {
  3.8233487081418033`*^9, 3.823348735445896*^9}},
 CellLabel->
  "In[2102]:=",ExpressionUUID->"b9266b67-8016-4f3d-aa9e-1c51a4bd943d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"B1-CC16c\"\>", ",", "\<\"B1-CC16b\"\>", 
   ",", "\<\"B1-CC13c\"\>", ",", "\<\"B1-CC13b\"\>", ",", "\<\"B1-CC07c\"\>", 
   ",", "\<\"B1-CC07b\"\>", ",", "\<\"B1-FG\"\>", ",", "\<\"B2-CC16c\"\>", 
   ",", "\<\"B2-CC16b\"\>", ",", "\<\"B2-CC13c\"\>", ",", "\<\"B2-CC13b\"\>", 
   ",", "\<\"B2-CC07c\"\>", ",", "\<\"B2-CC07b\"\>", ",", "\<\"B2-FG\"\>", 
   ",", "\<\"B3-CC16c\"\>", ",", "\<\"B3-CC16b\"\>", ",", "\<\"B3-CC13c\"\>", 
   ",", "\<\"B3-CC13b\"\>", ",", "\<\"B3-CC07c\"\>", ",", "\<\"B3-CC07b\"\>", 
   ",", "\<\"B3-FG\"\>"}], "}"}]], "Output",
 CellChangeTimes->{
  3.8233300403925123`*^9, 3.823330079506567*^9, 3.8233301852697163`*^9, {
   3.8233303033738823`*^9, 3.823330318186903*^9}, 3.823345519103927*^9, 
   3.8233481486350164`*^9, 3.8233487361258974`*^9, 3.8241923495505657`*^9, 
   3.824232806185011*^9, 3.8242328601804705`*^9},
 CellLabel->
  "Out[2102]=",ExpressionUUID->"22ac5163-34fc-459c-9dd0-284b3af1e877"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ZECMIPresults", "[", 
  RowBox[{"[", 
   RowBox[{"152", ",", "1"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.8242322685229006`*^9, 3.824232283897195*^9}, {
  3.82423248494189*^9, 3.8242324854652615`*^9}},
 CellLabel->
  "In[2080]:=",ExpressionUUID->"11bf98b3-3b1a-461c-bfd1-14baf653865e"],

Cell[BoxData["151"], "Output",
 CellChangeTimes->{{3.8242322772437563`*^9, 3.8242322842981615`*^9}, 
   3.8242324860446243`*^9},
 CellLabel->
  "Out[2080]=",ExpressionUUID->"8a1dfab8-9af6-420f-b53e-90843f6d816d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ZECMIPresults", "[", 
   RowBox[{"[", 
    RowBox[{"151", ",", "23"}], "]"}], "]"}], "-", 
  RowBox[{"ZECMIPresults", "[", 
   RowBox[{"[", 
    RowBox[{"101", ",", "23"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.824231669268749*^9, 3.8242317048556023`*^9}},
 CellLabel->
  "In[2076]:=",ExpressionUUID->"eff06132-31c3-40a0-9a69-356cbade73e8"],

Cell[BoxData["0.43464033958258685`"], "Output",
 CellChangeTimes->{3.8242317061901765`*^9},
 CellLabel->
  "Out[2076]=",ExpressionUUID->"63583507-5f09-491a-80b1-09ce77c9df2e"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ZECMIPtable", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;", "22"}], ",", "2"}], "]"}], "]"}], "=", 
    RowBox[{"ZECMIPresults", "[", 
     RowBox[{"[", 
      RowBox[{"2", ",", 
       RowBox[{"2", ";;", "22"}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"ZECMIPtable", "[", 
      RowBox[{"[", 
       RowBox[{
        RowBox[{"10", ";;", "16"}], ",", "2"}], "]"}], "]"}], "=", 
     RowBox[{"ZECMIPresults", "[", 
      RowBox[{"[", 
       RowBox[{"2", ",", 
        RowBox[{"9", ";;", "15"}]}], "]"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"ZECMIPtable", "[", 
      RowBox[{"[", 
       RowBox[{
        RowBox[{"18", ";;", "24"}], ",", "2"}], "]"}], "]"}], "=", 
     RowBox[{"ZECMIPresults", "[", 
      RowBox[{"[", 
       RowBox[{"2", ",", 
        RowBox[{"16", ";;", "22"}]}], "]"}], "]"}]}], ";"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ZECMIPtable", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "3"}], "]"}], "]"}], "=", 
    RowBox[{"Max", "[", 
     RowBox[{"ZECMIPresults", "[", 
      RowBox[{"[", 
       RowBox[{
        RowBox[{"2", ";;", "202"}], ",", "i"}], "]"}], "]"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "22"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ZECMIPtable", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;", "22"}], ",", "4"}], "]"}], "]"}], "=", 
   RowBox[{"ZECMIPresults", "[", 
    RowBox[{"[", 
     RowBox[{"102", ",", 
      RowBox[{"2", ";;", "22"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ZECMIPtable", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;", "22"}], ",", "5"}], "]"}], "]"}], "=", 
   RowBox[{"ZECMIPresults", "[", 
    RowBox[{"[", 
     RowBox[{"152", ",", 
      RowBox[{"2", ";;", "22"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ZECMIPtable", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;", "22"}], ",", "6"}], "]"}], "]"}], "=", 
   RowBox[{"ZECMIPresults", "[", 
    RowBox[{"[", 
     RowBox[{"202", ",", 
      RowBox[{"2", ";;", "22"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ZECMIPtable", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "7"}], "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"ZECMIPtable", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", "3"}], "]"}], "]"}], "-", 
    RowBox[{"ZECMIPtable", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", "2"}], "]"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ZECMIPtable", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "8"}], "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"ZECMIPtable", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", "4"}], "]"}], "]"}], "-", 
    RowBox[{"ZECMIPtable", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", "2"}], "]"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ZECMIPtable", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "9"}], "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"ZECMIPtable", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", "5"}], "]"}], "]"}], "-", 
    RowBox[{"ZECMIPtable", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", "2"}], "]"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ZECMIPtable", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "10"}], "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"ZECMIPtable", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", "6"}], "]"}], "]"}], "-", 
    RowBox[{"ZECMIPtable", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", "2"}], "]"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ZECMIPtable", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "11"}], "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"ZECMIPtable", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", "5"}], "]"}], "]"}], "-", 
    RowBox[{"ZECMIPtable", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", "3"}], "]"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ZECMIPtable", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "12"}], "]"}], "]"}], "=", 
    RowBox[{"Max", "[", 
     RowBox[{"ZECMIPresults", "[", 
      RowBox[{"[", 
       RowBox[{
        RowBox[{"2", ";;", "202"}], ",", 
        RowBox[{"i", "+", "21"}]}], "]"}], "]"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "22"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ZECMIPtable", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;", "22"}], ",", "13"}], "]"}], "]"}], "=", 
   RowBox[{"ZECMIPresults", "[", 
    RowBox[{"[", 
     RowBox[{"102", ",", 
      RowBox[{"23", ";;", "43"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ZECMIPtable", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;", "22"}], ",", "14"}], "]"}], "]"}], "=", 
   RowBox[{"ZECMIPresults", "[", 
    RowBox[{"[", 
     RowBox[{"152", ",", 
      RowBox[{"23", ";;", "43"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ZECMIPtable", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;", "22"}], ",", "15"}], "]"}], "]"}], "=", 
   RowBox[{"ZECMIPresults", "[", 
    RowBox[{"[", 
     RowBox[{"202", ",", 
      RowBox[{"23", ";;", "43"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ZECMIPtable", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;", "22"}], ",", "16"}], "]"}], "]"}], "=", 
    RowBox[{
     RowBox[{"ZECMIPtable", "[", 
      RowBox[{"[", 
       RowBox[{
        RowBox[{"2", ";;"}], ",", "14"}], "]"}], "]"}], "-", 
     RowBox[{"ZECMIPtable", "[", 
      RowBox[{"[", 
       RowBox[{
        RowBox[{"2", ";;"}], ",", "13"}], "]"}], "]"}]}]}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"ZECMIPtable", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"i", "+", "1"}], ",", "3"}], "]"}], "]"}], "=", 
       RowBox[{"Max", "[", 
        RowBox[{"ZECMIPresults", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;", "301"}], ",", "i"}], "]"}], "]"}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "9", ",", "15"}], "}"}]}], "]"}], 
    "\[IndentingNewLine]", 
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"ZECMIPtable", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"i", "+", "2"}], ",", "3"}], "]"}], "]"}], "=", 
       RowBox[{"Max", "[", 
        RowBox[{"ZECMIPresults", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;", "301"}], ",", "i"}], "]"}], "]"}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "16", ",", "22"}], "}"}]}], "]"}]}], "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"ZECMIPtable", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"i", "+", "1"}], ",", "7"}], "]"}], "]"}], "=", 
       RowBox[{"Max", "[", 
        RowBox[{"ZECMIPresults", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;", "301"}], ",", 
           RowBox[{"i", "+", "21"}]}], "]"}], "]"}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "9", ",", "15"}], "}"}]}], "]"}], 
    "\[IndentingNewLine]", 
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"ZECMIPtable", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"i", "+", "2"}], ",", "7"}], "]"}], "]"}], "=", 
       RowBox[{"Max", "[", 
        RowBox[{"ZECMIPresults", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;", "301"}], ",", 
           RowBox[{"i", "+", "21"}]}], "]"}], "]"}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "16", ",", "22"}], "}"}]}], "]"}]}], 
   "*)"}]}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.823330198650735*^9, 3.823330407579029*^9}, {
   3.8233304382900724`*^9, 3.823330458562101*^9}, {3.8233304895161448`*^9, 
   3.823330502707163*^9}, {3.8233305348132086`*^9, 3.823330587799283*^9}, {
   3.82333075186057*^9, 3.823330788775622*^9}, {3.823334633403093*^9, 
   3.8233346343630943`*^9}, 3.8233348334483743`*^9, {3.823345189260461*^9, 
   3.8233451901304626`*^9}, {3.8233455322959456`*^9, 
   3.8233455405859575`*^9}, {3.8233481828480644`*^9, 3.823348235726139*^9}, {
   3.823348486886492*^9, 3.8233485364425616`*^9}, {3.8242322226811695`*^9, 
   3.824232262430446*^9}, {3.8242323201006727`*^9, 3.8242323929414062`*^9}, {
   3.824232472997839*^9, 3.8242326196894674`*^9}, {3.8242326498396072`*^9, 
   3.8242326930433483`*^9}, {3.824232730417909*^9, 3.8242327501177225`*^9}, {
   3.8242327918819056`*^9, 3.8242327977184687`*^9}},
 CellLabel->
  "In[2103]:=",ExpressionUUID->"f3dc0bc2-0230-405b-a8eb-c9574438f728"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ZECMIPtable", "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.8233455513669724`*^9, 3.8233455931640863`*^9}, {
   3.823348409157383*^9, 3.8233484116683865`*^9}, {3.823348569256608*^9, 
   3.823348573107613*^9}, 3.8242317478059173`*^9, {3.824232021467301*^9, 
   3.8242320298183646`*^9}},
 CellLabel->
  "In[2118]:=",ExpressionUUID->"549a6d15-b119-46b6-9135-2075d351e08e"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"\<\"\"\>", "\<\"int-C\"\>", "\<\"max-C\"\>", "\<\"100y-C\"\>", \
"\<\"150y-C\"\>", "\<\"200y-C\"\>", "\<\"deltaCmax\"\>", "\<\"deltaC100\"\>", \
"\<\"deltaC150\"\>", "\<\"deltaC200\"\>", "\<\"ZEC50-C\"\>", "\<\"maxT\"\>", \
"\<\"100y-T\"\>", "\<\"150y-T\"\>", "\<\"200y-T\"\>", "\<\"ZEC50-T\"\>"},
     {"\<\"B1-CC16c\"\>", "588", "1251.5680333948405`", "1219.9904383264748`",
       "1187.7886963440098`", "1172.3662282729813`", "663.5680333948405`", 
      "631.9904383264748`", "599.7886963440098`", "584.3662282729813`", 
      RowBox[{"-", "63.77933705083069`"}], "2.950700612808665`", 
      "2.4441260472703115`", "2.865003806388763`", "2.950700612808665`", 
      "0.4208777591184516`"},
     {"\<\"B1-CC16b\"\>", "588", "1267.222070051787`", "1228.9285722513973`", 
      "1189.466791858944`", "1173.9842325042234`", "679.2220700517869`", 
      "640.9285722513973`", "601.4667918589439`", "585.9842325042234`", 
      RowBox[{"-", "77.75527819284298`"}], "2.9289408842421185`", 
      "2.5015582581905043`", "2.8667102294738984`", "2.9289408842421185`", 
      "0.36515197128339416`"},
     {"\<\"B1-CC13c\"\>", "588", "1220.9174165930212`", "1091.578482927782`", 
      "940.115901965126`", "897.4049957324456`", "632.9174165930212`", 
      "503.57848292778203`", "352.115901965126`", "309.4049957324456`", 
      RowBox[{"-", "280.80151462789524`"}], "2.248400460494755`", 
      "2.212916741631391`", "2.0864064531768665`", "1.8451268480835685`", 
      RowBox[{"-", "0.1265102884545244`"}]},
     {"\<\"B1-CC13b\"\>", "588", "1233.1747313775288`", "1106.8711570374326`",
       "949.1694008663673`", "901.4298072894759`", "645.1747313775288`", 
      "518.8711570374326`", "361.16940086636725`", "313.4298072894759`", 
      RowBox[{"-", "284.00533051116156`"}], "2.288214700129879`", 
      "2.2587713706986663`", "2.1050551812233493`", "1.8504553123721617`", 
      RowBox[{"-", "0.15371618947531696`"}]},
     {"\<\"B1-CC07c\"\>", "587.473`", "1193.529276147492`", 
      "1062.710370626211`", "916.1058777887872`", "856.4666056077081`", 
      "606.0562761474921`", "475.23737062621103`", "328.63287778878725`", 
      "268.9936056077081`", 
      RowBox[{"-", "277.42339835870484`"}], "2.138808573344054`", 
      "2.1386556482962003`", "1.8670289879519064`", "1.626495242499509`", 
      RowBox[{"-", "0.27162666034429384`"}]},
     {"\<\"B1-CC07b\"\>", "587.473`", "1240.6109681678608`", 
      "1112.786802582363`", "923.8450175386274`", "831.1276895322995`", 
      "653.1379681678609`", "525.313802582363`", "336.37201753862746`", 
      "243.65468953229959`", 
      RowBox[{"-", "316.76595062923343`"}], "2.232447216204373`", 
      "2.1426873920922476`", "1.7642798590671496`", "1.5874586391952923`", 
      RowBox[{"-", "0.378407533025098`"}]},
     {"\<\"B1-FG\"\>", "589.3629874815281`", "1077.438945425362`", 
      "1042.7151804999858`", "982.5885093752165`", "955.2491067587328`", 
      "488.0759579438338`", "453.3521930184577`", "393.22552189368844`", 
      "365.88611927720467`", 
      RowBox[{"-", "94.85043605014539`"}], "1.704443669838699`", 
      "1.6942432311476758`", "1.6671688859758493`", "1.6925875837644784`", 
      RowBox[{"-", "0.027074345171826497`"}]},
     {"\<\"B2-CC16c\"\>", "588", "1085.6916799242294`", "1062.013810737274`", 
      "1037.8742774190175`", "1026.3187305261445`", "497.69167992422945`", 
      "474.01381073727407`", "449.8742774190175`", "438.31873052614446`", 
      RowBox[{"-", "47.81740250521193`"}], "2.3833390427582857`", 
      "1.9743894838546228`", "2.3160032023936474`", "2.3833390427582857`", 
      "0.34161371853902467`"},
     {"\<\"B2-CC16b\"\>", "588", "1097.4165525810463`", "1068.6964292456887`",
       "1039.1000939425287`", "1027.4881744250254`", "509.4165525810463`", 
      "480.6964292456887`", "451.1000939425287`", "439.48817442502536`", 
      RowBox[{"-", "58.31645863851759`"}], "2.3656877713143714`", 
      "2.0214518887915913`", "2.3175224180635325`", "2.3656877713143714`", 
      "0.2960705292719412`"},
     {"\<\"B2-CC13c\"\>", "588", "1062.6880624821072`", "965.6838622455166`", 
      "852.0869265044126`", "820.0537468246879`", "474.68806248210717`", 
      "377.6838622455166`", "264.08692650441265`", "232.0537468246879`", 
      RowBox[{"-", "210.60113597769453`"}], "1.8056444427912814`", 
      "1.7801892840163376`", "1.6621245366491155`", "1.4584541924420462`", 
      RowBox[{"-", "0.11806474736722206`"}]},
     {"\<\"B2-CC13b\"\>", "588", "1071.8810485647534`", "977.15336782849`", 
      "858.8770506811487`", "823.0723554928609`", "483.8810485647534`", 
      "389.15336782849`", "270.8770506811487`", "235.07235549286088`", 
      RowBox[{"-", "213.0039978836047`"}], "1.8380935762791817`", 
      "1.8172163183194179`", "1.6767498890355257`", "1.4623325586457965`", 
      RowBox[{"-", "0.1404664292838922`"}]},
     {"\<\"B2-CC07c\"\>", "587.473`", "1042.015915573726`", 
      "943.902140041617`", "833.9494348315466`", "789.2205499046304`", 
      "454.5429155737261`", "356.4291400416171`", "246.4764348315466`", 
      "201.74754990463043`", 
      RowBox[{"-", "208.06648074217946`"}], "1.7170371788386085`", 
      "1.7170371788386085`", "1.4812688405723435`", "1.2798219989514494`", 
      RowBox[{"-", "0.23576833826626498`"}]},
     {"\<\"B2-CC07b\"\>", "587.473`", "1077.3264761570895`", 
      "981.4583519865085`", "839.7520131830433`", "770.2140171695323`", 
      "489.8534761570895`", "393.9853519865086`", "252.2790131830434`", 
      "182.74101716953237`", 
      RowBox[{"-", "237.57446297404613`"}], "1.7992450227166639`", 
      "1.7195985988565212`", "1.396741700343727`", "1.2486423364808292`", 
      RowBox[{"-", "0.3228568985127942`"}]},
     {"\<\"B2-FG\"\>", "589.3629874815281`", "935.4204565514946`", 
      "907.4233936141687`", "864.8875748005903`", "845.0579432955454`", 
      "346.0574690699665`", "318.06040613264065`", "275.5245873190622`", 
      "255.69495581401736`", 
      RowBox[{"-", "70.53288175090427`"}], "1.3002151091830734`", 
      "1.2852417868282322`", "1.2539199863575061`", "1.2673393875235672`", 
      RowBox[{"-", "0.03132180047072608`"}]},
     {"\<\"B3-CC16c\"\>", "588", "1915.0734469574265`", "1851.8969484847814`",
       "1787.4463718289928`", "1756.5562190503156`", "1327.0734469574265`", 
      "1263.8969484847814`", "1199.4463718289928`", "1168.5562190503156`", 
      RowBox[{"-", "127.62707512843372`"}], "4.672311366800934`", 
      "3.8737692555284107`", "4.528052727379349`", "4.672311366800934`", 
      "0.6542834718509387`"},
     {"\<\"B3-CC16b\"\>", "588", "1946.4441396012573`", "1869.8571440759279`",
       "1790.9335833096309`", "1759.968464610384`", "1358.4441396012573`", 
      "1281.8571440759279`", "1202.9335833096309`", "1171.968464610384`", 
      RowBox[{"-", "155.51055629162647`"}], "4.638166866337812`", 
      "3.960902361279203`", "4.529811665917556`", "4.638166866337812`", 
      "0.5689093046383533`"},
     {"\<\"B3-CC13c\"\>", "588", "1853.834832647813`", "1595.1569655263293`", 
      "1292.231803694347`", "1206.8099912555433`", "1265.834832647813`", 
      "1007.1569655263293`", "704.231803694347`", "618.8099912555433`", 
      RowBox[{"-", "561.603028953466`"}], "3.619789590022503`", 
      "3.544369485939683`", "3.428802877791833`", "3.098453488364881`", 
      RowBox[{"-", "0.11556660814784969`"}]},
     {"\<\"B3-CC13b\"\>", "588", "1878.3494621753616`", "1625.7423137345593`",
       "1310.3388014907887`", "1214.859614366981`", "1290.3494621753616`", 
      "1037.7423137345593`", "722.3388014907887`", "626.8596143669811`", 
      RowBox[{"-", "568.0106606845729`"}], "3.6809838935865473`", 
      "3.6169328570606964`", "3.4606547010325053`", "3.1092762496376305`", 
      RowBox[{"-", "0.15627815602819117`"}]},
     {"\<\"B3-CC07c\"\>", "587.473`", "1799.5827180806766`", 
      "1537.9432928455722`", "1244.7316495089003`", "1125.4508283256014`", 
      "1212.1097180806767`", "950.4702928455722`", "657.2586495089004`", 
      "537.9778283256014`", 
      RowBox[{"-", "554.8510685717763`"}], "3.443760160401817`", 
      "3.4407550488384104`", "3.101164089364882`", "2.7654038422040315`", 
      RowBox[{"-", "0.33959095947352846`"}]},
     {"\<\"B3-CC07b\"\>", "587.473`", "1893.7489357493741`", 
      "1638.1006048184447`", "1260.217034851719`", "1074.7823789002016`", 
      "1306.2759357493742`", "1050.6276048184448`", "672.7440348517191`", 
      "487.30937890020164`", 
      RowBox[{"-", "633.5319008976551`"}], "3.556743620663843`", 
      "3.451033130082277`", "2.949641873448344`", "2.7044206637005663`", 
      RowBox[{"-", "0.5013912566339331`"}]},
     {"\<\"B3-FG\"\>", "589.3629874815281`", "1732.2535736918485`", 
      "1682.4377694773266`", "1571.776371619649`", "1511.039530963299`", 
      "1142.8905862103204`", "1093.0747819957985`", "982.4133841381208`", 
      "921.676543481771`", 
      RowBox[{"-", "160.4772020721996`"}], "3.266470312617746`", 
      "3.0945609811154218`", "3.169825143969832`", "3.266470312617746`", 
      "0.07526416285441018`"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.824232030673812*^9, 3.82423281345475*^9, 
  3.8242328657410493`*^9},
 CellLabel->
  "Out[2118]//MatrixForm=",ExpressionUUID->"3b51b784-805b-4ffb-a207-\
972ee40e7f51"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{"\"\<ZECMIP_B_overview.csv\>\"", ",", "ZECMIPtable"}], "]"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.8233459108165894`*^9, 3.8233459683836703`*^9}, {
  3.8233485869686327`*^9, 3.8233485875486336`*^9}},
 CellLabel->
  "In[2119]:=",ExpressionUUID->"6c136577-d08f-47b5-ab6e-9767775c6b2b"],

Cell[BoxData["\<\"ZECMIP_B_overview.csv\"\>"], "Output",
 CellChangeTimes->{{3.82334594681164*^9, 3.8233459711546745`*^9}, 
   3.823348746646912*^9, 3.8234114335277896`*^9, 3.824232927536729*^9},
 CellLabel->
  "Out[2119]=",ExpressionUUID->"d9671775-bc71-4e07-9071-e8e6122af60d"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"B1Cplot", "=", 
   RowBox[{"ListLinePlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"ZECMIPresults", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}], ",", 
       RowBox[{"ZECMIPresults", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "3"}], "}"}]}], "]"}], "]"}], ",", 
       RowBox[{"ZECMIPresults", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "4"}], "}"}]}], "]"}], "]"}], ",", 
       RowBox[{"ZECMIPresults", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "5"}], "}"}]}], "]"}], "]"}], ",", 
       RowBox[{"ZECMIPresults", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "6"}], "}"}]}], "]"}], "]"}], ",", 
       RowBox[{"ZECMIPresults", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "7"}], "}"}]}], "]"}], "]"}], ",", 
       RowBox[{"ZECMIPresults", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "8"}], "}"}]}], "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Blue", ",", 
        RowBox[{"{", 
         RowBox[{"Blue", ",", "Dashed"}], "}"}], ",", "Red", ",", 
        RowBox[{"{", 
         RowBox[{"Red", ",", "Dashed"}], "}"}], ",", "Green", ",", 
        RowBox[{"{", 
         RowBox[{"Green", ",", "Dashed"}], "}"}], ",", "Black"}], "}"}]}], 
     ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "200"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"588", ",", "1400"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"Frame", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"True", ",", "True", ",", "False", ",", "False"}], "}"}]}], 
     ",", 
     RowBox[{"FrameStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Black", ",", "Black", ",", "Automatic", ",", "Black"}], 
       "}"}]}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<Year\>\"", ",", "\"\<GtC\>\"", ",", "None", ",", "None"}],
        "}"}]}], ",", 
     RowBox[{"LabelStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{
        RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
        RowBox[{"FontSize", "\[Rule]", "18"}], ",", "Black"}], "]"}]}], ",", 
     RowBox[{"Epilog", "\[Rule]", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<a)\>\"", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}]}], "}"}]}], "]"}], ",", 
        RowBox[{"Offset", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"Scaled", "[", 
           RowBox[{"{", 
            RowBox[{"0.05", ",", "0.95"}], "}"}], "]"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}]}], "]"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.823348859493126*^9, 3.823348913109201*^9}, {
  3.8233489497542524`*^9, 3.823349026924361*^9}, {3.8233491194754915`*^9, 
  3.8233491735825677`*^9}, {3.8233492097266183`*^9, 3.823349218448631*^9}, {
  3.823434641903642*^9, 3.823434667526678*^9}},
 CellLabel->
  "In[2024]:=",ExpressionUUID->"caa9a136-255c-42cc-9d42-f17bac02d8e7"],

Cell[BoxData[
 RowBox[{
  RowBox[{"B2Cplot", "=", 
   RowBox[{"ListLinePlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"ZECMIPresults", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "9"}], "}"}]}], "]"}], "]"}], ",", 
       RowBox[{"ZECMIPresults", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "10"}], "}"}]}], "]"}], "]"}], ",", 
       RowBox[{"ZECMIPresults", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "11"}], "}"}]}], "]"}], "]"}], ",", 
       RowBox[{"ZECMIPresults", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "12"}], "}"}]}], "]"}], "]"}], ",", 
       RowBox[{"ZECMIPresults", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "13"}], "}"}]}], "]"}], "]"}], ",", 
       RowBox[{"ZECMIPresults", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "14"}], "}"}]}], "]"}], "]"}], ",", 
       RowBox[{"ZECMIPresults", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "15"}], "}"}]}], "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Blue", ",", 
        RowBox[{"{", 
         RowBox[{"Blue", ",", "Dashed"}], "}"}], ",", "Red", ",", 
        RowBox[{"{", 
         RowBox[{"Red", ",", "Dashed"}], "}"}], ",", "Green", ",", 
        RowBox[{"{", 
         RowBox[{"Green", ",", "Dashed"}], "}"}], ",", "Black"}], "}"}]}], 
     ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "200"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"588", ",", "1200"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"Frame", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"True", ",", "True", ",", "False", ",", "False"}], "}"}]}], 
     ",", 
     RowBox[{"FrameStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Black", ",", "Black", ",", "Automatic", ",", "Black"}], 
       "}"}]}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<Year\>\"", ",", "\"\<GtC\>\"", ",", "None", ",", "None"}],
        "}"}]}], ",", 
     RowBox[{"LabelStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{
        RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
        RowBox[{"FontSize", "\[Rule]", "18"}], ",", "Black"}], "]"}]}], ",", 
     RowBox[{"Epilog", "\[Rule]", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<b)\>\"", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}]}], "}"}]}], "]"}], ",", 
        RowBox[{"Offset", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"Scaled", "[", 
           RowBox[{"{", 
            RowBox[{"0.05", ",", "0.95"}], "}"}], "]"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}]}], "]"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.8233492711747046`*^9, 3.8233493371917973`*^9}, {
  3.823434678152701*^9, 3.8234346948557243`*^9}},
 CellLabel->
  "In[2025]:=",ExpressionUUID->"7508d29a-c684-456e-a63f-c483a5bbcf82"],

Cell[BoxData[
 RowBox[{
  RowBox[{"B3Cplot", "=", 
   RowBox[{"ListLinePlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"ZECMIPresults", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "16"}], "}"}]}], "]"}], "]"}], ",", 
       RowBox[{"ZECMIPresults", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "17"}], "}"}]}], "]"}], "]"}], ",", 
       RowBox[{"ZECMIPresults", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "18"}], "}"}]}], "]"}], "]"}], ",", 
       RowBox[{"ZECMIPresults", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "19"}], "}"}]}], "]"}], "]"}], ",", 
       RowBox[{"ZECMIPresults", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "20"}], "}"}]}], "]"}], "]"}], ",", 
       RowBox[{"ZECMIPresults", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "21"}], "}"}]}], "]"}], "]"}], ",", 
       RowBox[{"ZECMIPresults", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "22"}], "}"}]}], "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Blue", ",", 
        RowBox[{"{", 
         RowBox[{"Blue", ",", "Dashed"}], "}"}], ",", "Red", ",", 
        RowBox[{"{", 
         RowBox[{"Red", ",", "Dashed"}], "}"}], ",", "Green", ",", 
        RowBox[{"{", 
         RowBox[{"Green", ",", "Dashed"}], "}"}], ",", "Black"}], "}"}]}], 
     ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "200"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"588", ",", "2200"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"Frame", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"True", ",", "True", ",", "False", ",", "False"}], "}"}]}], 
     ",", 
     RowBox[{"FrameStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Black", ",", "Black", ",", "Automatic", ",", "Black"}], 
       "}"}]}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<Year\>\"", ",", "\"\<GtC\>\"", ",", "None", ",", "None"}],
        "}"}]}], ",", 
     RowBox[{"LabelStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{
        RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
        RowBox[{"FontSize", "\[Rule]", "18"}], ",", "Black"}], "]"}]}], ",", 
     RowBox[{"Epilog", "\[Rule]", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<c)\>\"", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}]}], "}"}]}], "]"}], ",", 
        RowBox[{"Offset", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"Scaled", "[", 
           RowBox[{"{", 
            RowBox[{"0.05", ",", "0.95"}], "}"}], "]"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}]}], "]"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.823349363114834*^9, 3.8233494066418953`*^9}, {
  3.8233669485500827`*^9, 3.8233669501000853`*^9}, {3.8234347013867335`*^9, 
  3.8234347160877542`*^9}},
 CellLabel->
  "In[2026]:=",ExpressionUUID->"7359fa93-166c-41c9-ac92-9e518a6cd882"],

Cell[BoxData[
 RowBox[{
  RowBox[{"B1Tplot", "=", 
   RowBox[{"ListLinePlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"ZECMIPresults", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "23"}], "}"}]}], "]"}], "]"}], ",", 
       RowBox[{"ZECMIPresults", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "24"}], "}"}]}], "]"}], "]"}], ",", 
       RowBox[{"ZECMIPresults", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "25"}], "}"}]}], "]"}], "]"}], ",", 
       RowBox[{"ZECMIPresults", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "26"}], "}"}]}], "]"}], "]"}], ",", 
       RowBox[{"ZECMIPresults", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "27"}], "}"}]}], "]"}], "]"}], ",", 
       RowBox[{"ZECMIPresults", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "28"}], "}"}]}], "]"}], "]"}], ",", 
       RowBox[{"ZECMIPresults", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "29"}], "}"}]}], "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Blue", ",", 
        RowBox[{"{", 
         RowBox[{"Blue", ",", "Dashed"}], "}"}], ",", "Red", ",", 
        RowBox[{"{", 
         RowBox[{"Red", ",", "Dashed"}], "}"}], ",", "Green", ",", 
        RowBox[{"{", 
         RowBox[{"Green", ",", "Dashed"}], "}"}], ",", "Black"}], "}"}]}], 
     ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "200"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "3"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"Frame", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"True", ",", "True", ",", "False", ",", "False"}], "}"}]}], 
     ",", 
     RowBox[{"FrameStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Black", ",", "Black", ",", "Automatic", ",", "Black"}], 
       "}"}]}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<Year\>\"", ",", "\"\<\[Degree]C\>\"", ",", "None", ",", "None"}], 
       "}"}]}], ",", 
     RowBox[{"LabelStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{
        RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
        RowBox[{"FontSize", "\[Rule]", "18"}], ",", "Black"}], "]"}]}], ",", 
     RowBox[{"Epilog", "\[Rule]", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<d)\>\"", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}]}], "}"}]}], "]"}], ",", 
        RowBox[{"Offset", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"Scaled", "[", 
           RowBox[{"{", 
            RowBox[{"0.05", ",", "0.95"}], "}"}], "]"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}]}], "]"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.8233495010510283`*^9, 3.823349501461029*^9}, {
  3.823349537075079*^9, 3.8233495727901287`*^9}, {3.823434752083805*^9, 
  3.8234347868878536`*^9}},
 CellLabel->
  "In[2027]:=",ExpressionUUID->"875e8063-b35e-45ba-a561-4f699aa2403f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"B2Tplot", "=", 
   RowBox[{"ListLinePlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"ZECMIPresults", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "30"}], "}"}]}], "]"}], "]"}], ",", 
       RowBox[{"ZECMIPresults", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "31"}], "}"}]}], "]"}], "]"}], ",", 
       RowBox[{"ZECMIPresults", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "32"}], "}"}]}], "]"}], "]"}], ",", 
       RowBox[{"ZECMIPresults", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "33"}], "}"}]}], "]"}], "]"}], ",", 
       RowBox[{"ZECMIPresults", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "34"}], "}"}]}], "]"}], "]"}], ",", 
       RowBox[{"ZECMIPresults", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "35"}], "}"}]}], "]"}], "]"}], ",", 
       RowBox[{"ZECMIPresults", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "36"}], "}"}]}], "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Blue", ",", 
        RowBox[{"{", 
         RowBox[{"Blue", ",", "Dashed"}], "}"}], ",", "Red", ",", 
        RowBox[{"{", 
         RowBox[{"Red", ",", "Dashed"}], "}"}], ",", "Green", ",", 
        RowBox[{"{", 
         RowBox[{"Green", ",", "Dashed"}], "}"}], ",", "Black"}], "}"}]}], 
     ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "200"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "3"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"Frame", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"True", ",", "True", ",", "False", ",", "False"}], "}"}]}], 
     ",", 
     RowBox[{"FrameStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Black", ",", "Black", ",", "Automatic", ",", "Black"}], 
       "}"}]}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<Year\>\"", ",", "\"\<GtC\>\"", ",", "None", ",", "None"}],
        "}"}]}], ",", 
     RowBox[{"LabelStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{
        RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
        RowBox[{"FontSize", "\[Rule]", "18"}], ",", "Black"}], "]"}]}], ",", 
     RowBox[{"Epilog", "\[Rule]", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<e)\>\"", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}]}], "}"}]}], "]"}], ",", 
        RowBox[{"Offset", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"Scaled", "[", 
           RowBox[{"{", 
            RowBox[{"0.05", ",", "0.95"}], "}"}], "]"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}]}], "]"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.8233496637332573`*^9, 3.8233496980183053`*^9}, {
   3.823349783278425*^9, 3.823349797320445*^9}, {3.823434793558863*^9, 
   3.8234348045298786`*^9}, 3.823434835754923*^9},
 CellLabel->
  "In[2028]:=",ExpressionUUID->"37aff4af-a8b5-44c6-90a8-cd838e7634a9"],

Cell[BoxData[
 RowBox[{
  RowBox[{"B3Tplot", "=", 
   RowBox[{"ListLinePlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"ZECMIPresults", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "37"}], "}"}]}], "]"}], "]"}], ",", 
       RowBox[{"ZECMIPresults", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "38"}], "}"}]}], "]"}], "]"}], ",", 
       RowBox[{"ZECMIPresults", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "39"}], "}"}]}], "]"}], "]"}], ",", 
       RowBox[{"ZECMIPresults", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "40"}], "}"}]}], "]"}], "]"}], ",", 
       RowBox[{"ZECMIPresults", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "41"}], "}"}]}], "]"}], "]"}], ",", 
       RowBox[{"ZECMIPresults", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "42"}], "}"}]}], "]"}], "]"}], ",", 
       RowBox[{"ZECMIPresults", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "43"}], "}"}]}], "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Blue", ",", 
        RowBox[{"{", 
         RowBox[{"Blue", ",", "Dashed"}], "}"}], ",", "Red", ",", 
        RowBox[{"{", 
         RowBox[{"Red", ",", "Dashed"}], "}"}], ",", "Green", ",", 
        RowBox[{"{", 
         RowBox[{"Green", ",", "Dashed"}], "}"}], ",", "Black"}], "}"}]}], 
     ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "200"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "5"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"Frame", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"True", ",", "True", ",", "False", ",", "False"}], "}"}]}], 
     ",", 
     RowBox[{"FrameStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Black", ",", "Black", ",", "Automatic", ",", "Black"}], 
       "}"}]}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<Year\>\"", ",", "\"\<\[Degree]C\>\"", ",", "None", ",", "None"}], 
       "}"}]}], ",", 
     RowBox[{"LabelStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{
        RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
        RowBox[{"FontSize", "\[Rule]", "18"}], ",", "Black"}], "]"}]}], ",", 
     RowBox[{"Epilog", "\[Rule]", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<f)\>\"", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}]}], "}"}]}], "]"}], ",", 
        RowBox[{"Offset", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"Scaled", "[", 
           RowBox[{"{", 
            RowBox[{"0.05", ",", "0.95"}], "}"}], "]"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}]}], "]"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.8233498161054716`*^9, 3.823349853999525*^9}, {
  3.82336034828071*^9, 3.823360348980711*^9}, {3.8234348433659334`*^9, 
  3.823434870593026*^9}},
 CellLabel->
  "In[2029]:=",ExpressionUUID->"31c0ee1a-97f9-47bb-8d1a-a2ca4a88a920"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SIFigureZECMIP", "=", 
  RowBox[{"Legended", "[", 
   RowBox[{
    RowBox[{"Grid", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{",", 
          RowBox[{"Text", "[", 
           RowBox[{"Style", "[", 
            RowBox[{"\"\<Atmospheric CO2 (Gt C)\>\"", ",", 
             RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
             RowBox[{"FontSize", "\[Rule]", "18"}], ",", "Black", ",", 
             "Bold"}], "]"}], "]"}], ",", 
          RowBox[{"Text", "[", 
           RowBox[{"Style", "[", 
            RowBox[{"\"\<delta SAT (\[Degree]C)\>\"", ",", 
             RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
             RowBox[{"FontSize", "\[Rule]", "18"}], ",", "Black", ",", 
             "Bold"}], "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Text", "[", 
           RowBox[{"Style", "[", 
            RowBox[{"\"\<B1\>\"", ",", 
             RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
             RowBox[{"FontSize", "\[Rule]", "18"}], ",", "Black", ",", 
             "Bold"}], "]"}], "]"}], ",", "B1Cplot", ",", "B1Tplot"}], "}"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Text", "[", 
           RowBox[{"Style", "[", 
            RowBox[{"\"\<B2\>\"", ",", 
             RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
             RowBox[{"FontSize", "\[Rule]", "18"}], ",", "Black", ",", 
             "Bold"}], "]"}], "]"}], ",", "B2Cplot", ",", "B2Tplot"}], "}"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Text", "[", 
           RowBox[{"Style", "[", 
            RowBox[{"\"\<B3\>\"", ",", 
             RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
             RowBox[{"FontSize", "\[Rule]", "18"}], ",", "Black", ",", 
             "Bold"}], "]"}], "]"}], ",", "B3Cplot", ",", "B3Tplot"}], 
         "}"}]}], "}"}], ",", 
      RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}], ",", 
    RowBox[{"Placed", "[", 
     RowBox[{
      RowBox[{"LineLegend", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Blue", ",", 
          RowBox[{"{", 
           RowBox[{"Blue", ",", "Dashed"}], "}"}], ",", "Red", ",", 
          RowBox[{"{", 
           RowBox[{"Red", ",", " ", "Dashed"}], "}"}], ",", "Green", ",", 
          RowBox[{"{", 
           RowBox[{"Green", ",", "Dashed"}], "}"}], ",", "Black"}], "}"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"\"\<D16-calc\>\"", ",", 
            RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", 
          RowBox[{"Style", "[", 
           RowBox[{"\"\<D16-calb\>\"", ",", 
            RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", 
          RowBox[{"Style", "[", 
           RowBox[{"\"\<D13-calc\>\"", ",", 
            RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", 
          RowBox[{"Style", "[", 
           RowBox[{"\"\<D13-calb\>\"", ",", 
            RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", 
          RowBox[{"Style", "[", 
           RowBox[{"\"\<D07-calc\>\"", ",", 
            RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", 
          RowBox[{"Style", "[", 
           RowBox[{"\"\<D07-calb\>\"", ",", 
            RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", 
          RowBox[{"Style", "[", 
           RowBox[{"\"\<Fair-Geoffroy\>\"", ",", 
            RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}]}], "}"}], ",", 
        RowBox[{"LegendLayout", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"\"\<Row\>\"", ",", "1"}], "}"}]}]}], "]"}], ",", "Below"}],
      "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8234340921908674`*^9, 3.8234341448579416`*^9}, {
  3.823434287016142*^9, 3.8234343858732815`*^9}, {3.823434451432374*^9, 
  3.823434457073382*^9}, {3.8234348869050493`*^9, 3.8234349374811215`*^9}, {
  3.8234445905422926`*^9, 3.8234447462905116`*^9}},
 CellLabel->
  "In[2030]:=",ExpressionUUID->"5bab5ff8-ff4e-41db-95f1-c4fc66dde41e"],

Cell[BoxData[
 TemplateBox[{
   TagBox[
    GridBox[{{"", 
       InterpretationBox[
        Cell[
         BoxData[
          FormBox[
           StyleBox[
           "\"Atmospheric CO2 (Gt C)\"", FontFamily -> "Helvetica", FontSize -> 
            18, 
            GrayLevel[0], Bold, StripOnInput -> False], TextForm]], 
         "InlineText"], 
        Text[
         Style[
         "Atmospheric CO2 (Gt C)", FontFamily -> "Helvetica", FontSize -> 18, 
          GrayLevel[0], Bold]]], 
       InterpretationBox[
        Cell[
         BoxData[
          FormBox[
           StyleBox[
           "\"delta SAT (\[Degree]C)\"", FontFamily -> "Helvetica", FontSize -> 
            18, 
            GrayLevel[0], Bold, StripOnInput -> False], TextForm]], 
         "InlineText"], 
        Text[
         Style[
         "delta SAT (\[Degree]C)", FontFamily -> "Helvetica", FontSize -> 18, 
          GrayLevel[0], Bold]]]}, {
       InterpretationBox[
        Cell[
         BoxData[
          FormBox[
           StyleBox["\"B1\"", FontFamily -> "Helvetica", FontSize -> 18, 
            GrayLevel[0], Bold, StripOnInput -> False], TextForm]], 
         "InlineText"], 
        Text[
         Style["B1", FontFamily -> "Helvetica", FontSize -> 18, 
          GrayLevel[0], Bold]]], 
       GraphicsBox[{{}, {{{}, {}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             PointSize[0.006944444444444445], 
             AbsoluteThickness[1.6], 
             RGBColor[0, 0, 1]], 
            LineBox[CompressedData["
1:eJw1lns41Pkex6foIhVdV+WWLYR0Qcjg7RaSZNwGgzE3M4jtJFRkUrJuS61p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             "]]}, {
            Hue[0.9060679774997897, 0.6, 0.6], 
            Directive[
             PointSize[0.006944444444444445], 
             AbsoluteThickness[1.6], 
             RGBColor[0, 0, 1], 
             Dashing[{Small, Small}]], 
            LineBox[CompressedData["
1:eJw1lXs41Pkex4c2ds/sQYlK1yVk0lV0RPU26y73cRm35j5TKLrJVIwuLluu
5eQS0ebUtpaKFFbE6YKUTjqFslLSRTelWhW75+zvM88zz+95zXtev9cf852Z
70QbfKTqLBar+c/n/65/PV6v+v9FsAvMC3hmelb5s5D4a/SY3Zl5XEysA3HS
iJq6jHgSfOuGI9sUxFPgmGZhMCOCeDryM1KlmlHEs3FC70B6yWZiQ/DP33ml
qySeg0P11WYbVcQmmDbYFvQwiXguhvs0uWkZxBw4TZGGFuQRm8Oup/fTyn8R
L8Bkn0C7kgriRTjAGpyq0US8GNuuZhjkdxAvwZcL+1YXPyG2wIy5HQ8Cx4iX
QkuY3f7V1N0MW2KJdSTvmSWxFY5lp/O8/ImXoeVceFmckvgfCJ+9QFp3lNga
9jnzz/neIF6O1p/0piWx9jBsgy3HVaZ5VsS2WB2mVLRGE6/AZCd3U94Z4pUo
GKo1k38kXgVeevz6hfZ7GQZaEopeXM9mWAW4mBWLQ1/QbgeTNY0LBlwTmd0O
3xlqO0aUMcziwsNog/dvk5OYnQuze7xnc5IYZn2PXF0vtu5n2r+HacJwZdTW
ZGa3R1zz82vDwwyr7CFKt7VxU6YwuwO01sc4s8f9wOwO0Mxir2xMZ5jlCLf+
ROdXs/YxuyO4XIfc8RUMs5yQrRz6d6TzfmZ3AmtZfWDSbwyznKHMcy06GZPK
7M54UzX7IEcnjdldsMvgnwP+JxhWuSDPW9c8blU6s7sise3m6KsOhlWuOFlt
lz9mkcHsbrh9vVpdfQfDKjdc4mxTX9hI+2pMe66vY6ORyeyrMaa3ltPrxDDL
Hd9+WFfUk0i7O75qWln7pZF2D1TEujt/+5l2D1wa7FB7sDiL2T2xtXxpR5CE
YZUnyo5MZwkP0O6FE0vuTn14gWF4AavUB+4+pvd7gW1cO53LPvAXN3ih2/ET
y8ScYZY3Fh11HspyYRjecLvt3lkgZljljVXzlclCJfneqN508O+jqeT7wEbr
2O+HCsn3geKtzY8BpeT74FzgCrniHPk+OFLW/PxDPfm+4P7aqrC8TL4vAjlm
v3u1kO+LHO2FH5TXyPeFaIAne0jM4mG0fiS8upV8Hmza7O5ymsnnYSO7vF58
iXwePOvajdMayPdDQ0rt+Zs15Pshwe7eYd9K8v3wHx2us9Uv5Pshgs+LyC0h
3x+Ph0oHcwvI90ecRekD72zy/dH/0a3k7n7y/WEQfPwJdw/5Adj5/Fz70e3k
B8Cw48qUrzeRH4CR6KXWqnXkByAqxyZTX0R+IGbp5Wd18MkPxGP9sRcXvckP
RKiBT/0j+nwbAuF4fl61HZd8PjxNqj3uLSefj8cvj3VXWZDPRxXP56MhnZcG
PnZsZ795N4f8IHi2DK4zmUl+EEb57VGnJ5MfBC39NxEZE8gPwovat4YX6Dyy
ghHN9zxpqUF+MOq8tdcOscgPxjLPp1qvPzHnuSEYb/uKMzgf6PyH4GV/jVHh
EJ3/EFiPyZY7vaTzHwKTz3Xxhs/ID0He4PwOc/p+sEJRa2XsKu4jPxR9E4YM
m3rID8WDCR2tLt3kh2JisW33uzvkh6E11karsYP8MFwPm+RYfpP8MIjjPu2t
uU5+GDT03r9+0Er+GvDZ968YNZO/Bq4b4uVxl8lfg/UtfY6vm8j/k2OODMdc
JF8AD6sAg0n1DM8WICTYPrrpV7qfAD1avS17ahgWCGBrXvi3gPN0fwGiZHXG
1lUMFwmwPJJjyKmkngDdfZv1zM4w3CvAlPG3jSxPUV8Ii1HEu5dRXwjOwwxZ
dCn1hbDffGpO0UnqC3Gs6b525wnqCyF5+zZ52nHqC5HjcnFEVkJ9Ia4+knfW
/Eh9IWpkV4v1j1JfBM33w3dji6gvwji1CvajQuqL0Gj5vo1XQH0RuubF1LTm
U1+EUnvuRuc86ovQ4OF7uCWH+iIMxlv1ex+ivgjtgvLR+9nUF2OLq/TI+oPU
F2NoevaucfT7DDFk3VfkhzOpL8a7ntSJ1hnUF8M2YKVrZxr1xYi6VdO5I5X6
YsQesEo32k99MTIkarZtP1BfgsJ2v8rYFOpLYBTOuTE3mfoSNH6jIetKpL4E
NdX/5aXtpb4EkY6tsfZ7qC9Br+nCs593UV+CijPOT6sSqC9BuNR6ZKOK+lLY
Lu5tWxRPfSkyC+vcXu+kvhRZ5Z0hp3dQX4qrkp+fb9pOfSnKmtUeLVNSX4q6
qJdLvmyjvhT9TqcvN8VQX4qP5SVp+7ZSX4ZrjYu287ZQX4Z5Z0/tnLmZ+jK0
cCOTn26kvgy/6KaknY2mvgx+7He7d0VRXwajTWGhXhuoL4PFkLnOrPXUl6HT
ITLrZQT15Thd1tp1IZz6cnzSSOlNX0d9OUpjovOFa6kvh13jrXFLFdSXQ0c/
dqKmnPpy+CkKGrqk1JfjluMTzXL6/++VQzhD1rdbTH0FjAcSXPki6ivQZT+2
fKGQ+gpUvnlXNl5AfQXYmVeK74VRX4FlN+ZoV4ZSXwFZ++jQvhDqK5D7JMlF
Ekx9BUxzFmivCKL+WiRczYU+n/prYeFQ0vUqIAt/AIVcuL8=
             "]]}, {
            Hue[0.1421359549995791, 0.6, 0.6], 
            Directive[
             PointSize[0.006944444444444445], 
             AbsoluteThickness[1.6], 
             RGBColor[1, 0, 0]], 
            LineBox[CompressedData["
1:eJw1lQdUVGcahkewYACRqNgRBcEoRUoCMZQXqQ460pmhTWMKipTsCFJUJEpU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             "]]}, {
            Hue[0.37820393249936934`, 0.6, 0.6], 
            Directive[
             PointSize[0.006944444444444445], 
             AbsoluteThickness[1.6], 
             RGBColor[1, 0, 0], 
             Dashing[{Small, Small}]], 
            LineBox[CompressedData["
1:eJw1lQtYzPkeh6c6K6lO2VUkaZR2GbeUiVB9uulK96abmvtMWwehDSUTRas6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             "]]}, {
            Hue[0.6142719099991583, 0.6, 0.6], 
            Directive[
             PointSize[0.006944444444444445], 
             AbsoluteThickness[1.6], 
             RGBColor[0, 1, 0]], 
            LineBox[CompressedData["
1:eJw9lgtUjHkfx581oey7DnK/ZEIlpS0qhfKdFDWV7s1kpprmnnFQuii36eaS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             "]]}, {
            Hue[0.8503398874989481, 0.6, 0.6], 
            Directive[
             PointSize[0.006944444444444445], 
             AbsoluteThickness[1.6], 
             RGBColor[0, 1, 0], 
             Dashing[{Small, Small}]], 
            LineBox[CompressedData["
1:eJw91glQk3caBvCoHKIVRAWpiEYsHqgoyikej4DcmnAEEo6Qk4Ba0FWhKCrl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             "]]}, {
            Hue[0.08640786499873876, 0.6, 0.6], 
            Directive[
             PointSize[0.006944444444444445], 
             AbsoluteThickness[1.6], 
             GrayLevel[0]], 
            LineBox[CompressedData["
1:eJw1lgs0lHkfxyds22VFl022WiOKXCIKifFVQuM+DIPBXAxDEaLSzaR3a1K6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             "]]}}}, {{}, {}}}, {
        DisplayFunction -> Identity, DisplayFunction -> Identity, AspectRatio -> 
         NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
         AxesLabel -> {None, None}, AxesOrigin -> {1., 588.}, DisplayFunction :> 
         Identity, Epilog -> InsetBox[
           FormBox[
            StyleBox[
            "\"a)\"", {FontFamily -> "Helvetica", FontSize -> 20}, 
             StripOnInput -> False], TraditionalForm], 
           Offset[{0, 0}, 
            Scaled[{0.05, 0.95}]], 
           ImageScaled[{
             Rational[1, 2], 
             Rational[1, 2]}]], Frame -> {{True, False}, {True, False}}, 
         FrameLabel -> {{
            FormBox["\"GtC\"", TraditionalForm], None}, {
            FormBox["\"Year\"", TraditionalForm], None}}, FrameStyle -> {
           GrayLevel[0], 
           GrayLevel[0], Automatic, 
           GrayLevel[0]}, 
         FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
         GridLines -> {None, None}, GridLinesStyle -> Directive[
           GrayLevel[0.5, 0.4]], ImageSize -> 600, LabelStyle -> 
         Directive[FontFamily -> "Helvetica", FontSize -> 18, 
           GrayLevel[0]], 
         Method -> {
          "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
           "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), "CopiedValueFunction" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& )}}, PlotRange -> {{1, 200}, {588, 1400}}, 
         PlotRangeClipping -> True, PlotRangePadding -> {{0, 0}, {0, 0}}, 
         Ticks -> {Automatic, Automatic}}], 
       GraphicsBox[{{}, {{{}, {}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             PointSize[0.006944444444444445], 
             AbsoluteThickness[1.6], 
             RGBColor[0, 0, 1]], 
            LineBox[CompressedData["
1:eJxVk3tYjHkfh6cDwhK9ylopUl6l2rYIqXxKhZFMM+momplmmikXW1nK5jDZ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             "]]}, {
            Hue[0.9060679774997897, 0.6, 0.6], 
            Directive[
             PointSize[0.006944444444444445], 
             AbsoluteThickness[1.6], 
             RGBColor[0, 0, 1], 
             Dashing[{Small, Small}]], 
            LineBox[CompressedData["
1:eJxV03s81Pkex/FxCbvlPKpVaztLUqksRReXzPJGkREZdwZzv4gUuki70coe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             "]]}, {
            Hue[0.1421359549995791, 0.6, 0.6], 
            Directive[
             PointSize[0.006944444444444445], 
             AbsoluteThickness[1.6], 
             RGBColor[1, 0, 0]], 
            LineBox[CompressedData["
1:eJxVlQs01Hkfh0e6kKLaWqxiKinZte5JFx9yTUlj5M7MmDGkNt2UajXSVLtt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             "]]}, {
            Hue[0.37820393249936934`, 0.6, 0.6], 
            Directive[
             PointSize[0.006944444444444445], 
             AbsoluteThickness[1.6], 
             RGBColor[1, 0, 0], 
             Dashing[{Small, Small}]], 
            LineBox[CompressedData["
1:eJxVlXs41PkexyfJUlrSoZIyCrkdJVGUvItcknG/32bGzJhyolVZSTUHe+gi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             "]]}, {
            Hue[0.6142719099991583, 0.6, 0.6], 
            Directive[
             PointSize[0.006944444444444445], 
             AbsoluteThickness[1.6], 
             RGBColor[0, 1, 0]], 
            LineBox[CompressedData["
1:eJxV1XtUzHkfB/CfyGUfhIekUiPq0CppCyXbOxWNLrrfR3OfqQe5LpLdkdxW
5Bo22XFJEvKI9CzbMyndLZvLptAotA1SVJsurOf4fP94OmdO53Xe8+7d/M78
vr9J4vhAmR7HcaWfX//7HVWwudm8dRS4//sZi5rxrm5Dyk1dv9gIoXBykTbM
IptiqeOKxbtfLiDzkHDg0Q8rPIPIFkg5ltGh+0FAnoKRjiOLp0BGtoKw64zp
0fBl5Kl4+kvfwPqTq8nWqE3f5V6QuYE8HcqPEK9cpiLbwm7IMXuv/GSyHY64
95/LKdlJnomlTudKplxOJdvj9dDEJlffA+RvELckQ9fke5jsAJdBzjtNXqWT
HSFI2JcwOF1NnoU3umKDWPUp8myU/XuZ1sYgizwHG9u+8rRqP0d2QtDkYHu5
fy7ZGa2jTXsPmlwmzwV3wtTq8R9XyC6w26h3iNd4jTwP2w68exHtep38LcrK
d4VGdRSSXZF/mhv5e1IRGTCq7SrJvV78xSpgVXKCW45VKeVuqHlwq1Z2q5xy
N5wtKNRzPlpF+Xz0Pdu81v7Ub5TPh32nUfaAd3cpd4eDgXih3sUayt3hNDW2
IW3rfco9cE9mkL1z/UPKPfD66aBzq7bVUu4J/m3tg2sX6yj3xPNO55bdbY8p
X4DZ9bmdHxY1UL4ANsX88tinWsoXIpWXXSGxaKR8Ie73d52/sKKJci/0/rDW
cX35c8q9kJKY5/R86kvK+YgzmFg0aF8z5XwEn26e9ezTn5QvwtZDmrPr1ugo
X4TpdZuH/vfNK8q9YTtWPzY77g3l3ug5OWaGla6Vch8UWjsZ7Xdso9wHAg+9
p/wuMueL4Nww9yv57ZT7oqyu/obvd+8o98NpP92MNIf3lPthR0rytdHtZG4x
epy0ofycDsoXo1bf8miVuJNyf5yZaWhmM77ri+EPrfWBfw4rJ6v88eK1/rEB
a//6Yo0/MrRdkzQTu6kfAPOB5kc7i8gIwN0WxYVI0QfqB6B/cqw2t5esCUCB
Wi/t17091A/EI5e7o4J5vdQPhOikR4z3ObIqEDsSApy32PZRPxA9/LSHjefJ
XBA81ltkh1v2Uz8INx7oeHWHyaog5Cgmh0oGfaR+EFwrblzqiiNzwSjr9N9+
rIqMYEzwvndNbPWJ+sGwroieG72RrAlG+9Vl+epKMheCkkeJA62+4vClH4J7
q279+e10sioEC4YJtp/3JmtCIJ0x9vZmJZkLRYX70MaaJNYPBW+L4/srP7F+
KObVu32ad4n1Q3HvTkNmcjHrh2H5KaOen++zfhjsM6+HZTWxfhgqG8xdLrex
fhjqUkMsantZPxxpx++L7fQHUD8crTlZhjXDyapwTOnV/3hvDFkTjs1K9zif
8WQuAjYX3lsHGLN+BN7mGX7/lwnrR8ArNCxnoSnrR2Bcdsz+cJZzkdjSnvfE
dQLrR2Jci8noMYasH4ksxB9uHM36kYj/sepOMfv/uCh8WOdkXDaY9aMwl1fW
1PeJff4orK8yvbymm33+KLjs2Wc7j10PLhobK0vspM3s+kVDuamovOsJ60fD
fMwlrwHs+mqiEe1h4pdawfoCSFdXV+YUsr4A2enuI0R5rC/AVf075QVZrC/A
rP0LJt5IZ/0leC9bfnx1KusvgeTgoKhm9n1QLYGF56Yms+9YfwkG567wnxTL
+jGQTy706oxi/Rj0eSiGnPBj/RjUKKxE1m6sH4PzPTcr0r5hfSGiCq0iXlmS
eUIkrJl1d7oR+3tCtB5ckRHDvt9CIaq57JsGH9j9IcQ2k2kvAp+Q1UJoVlqX
pBax+0WIOZ7r+qszyVohLLuNL4/6kd0/InQVe+0WLifzRFg+801lUSAZIhgO
b53nNJssFKFNahpaZcL2RRg29rFlIsf2RTDWT1YsfsHudxHSNyQkeVWStSJU
80ftjctl978YpSPNhAUHyTwxbAfINzkksPNAjBLnX2c+iyELxeh+/XGnxpOs
EiNkYHXE/a/JajFW75ngajaG7YvR7rw38+duOo+0Ypz9VFgR0UDmJGgznHzD
t5TMk3y+4kOkiRfYeSZBlb1L0suDZKEE8aPP56UksvNNAsGpytXxUrJagvru
JrNUH7JGgmFG3h2vHNi+BEFz4oy2TWT7UmBgfppgMNuX4gS2Sla9pfMVUmR4
/CYoqSULpSiVV/kH3SSrpDC+vr3TjJ3HaimuzQ7psEpj57UU9VKbl3EqslaK
37P6Q3Rx7PyWYaGNtuh0CJknw8V/zT92FGxfhnbrHp/yr9m+DFYdfHu78Wxf
BueiByfu6rH9z+//ZUfL2VZ6fmhkuFOx1L+gjqyVYd/VNeM/lpI5OXq2OiVs
yCPz5NhwJyd3mpo9j+Qw3PMf3YjdZKEcydNaIi0T2PNJjlJH3fR4BVktR3Oi
6S5dMNuXI+mPEcfT5rN9ObYEvU1ZZcf2FfCy0Pt+kxnbVyClqC8tfzjbV+BR
tbLftJeel0IFXjV8eJjbQlYp4PfmCX95LVmtQJZiyKawMrJGgYjDK4/E5ZO1
CjStjLl1JpM9f5Vocz9k+49DZJ4SZht3c4eTyVAio/ZsLH8N21eiPyDyp0lS
tq+EeaPfLbNgtq/E7R37zOHB9pVwv5KjTXZg+0q0+9yc/3oK249FzZHcpLXj
2H4snk011poP7nH9GxVdvaw=
             "]]}, {
            Hue[0.8503398874989481, 0.6, 0.6], 
            Directive[
             PointSize[0.006944444444444445], 
             AbsoluteThickness[1.6], 
             RGBColor[0, 1, 0], 
             Dashing[{Small, Small}]], 
            LineBox[CompressedData["
1:eJxV1ntUzHkfB/CphPaJrXVfK9W2WJcu0haJd41kUGq60m2ae2gJKVKNVMjt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             "]]}, {
            Hue[0.08640786499873876, 0.6, 0.6], 
            Directive[
             PointSize[0.006944444444444445], 
             AbsoluteThickness[1.6], 
             GrayLevel[0]], 
            LineBox[CompressedData["
1:eJxVlAtYzOkexwdF5dLuyrViCB116jSDlBFfE4lEqel+mfuk4UGmHJc9hvaw
tNuejdpHziapJKGwXWwyuqEjdFHalEpbErl0IVqdPY/353nOPM8883zmO5/3
O//3Nku6daNiJIfDuf3n+3+fn16vlnP+/4WA2F+6eLZm7HsDyG1ML+zmOTD+
Am8Eh+w921wZm0BYc6E/zlTEeCradzx6NjBOzNgM6ZbjDatqlIy5SJFfy6nQ
38p4NspaZnV/tUnDeA4cZdvKtzjsZjwPyt9ayzq/1TL+C3JnLizy+f4bxla4
MT8qPXHZYcZ/hfhUkdbiSixjW7jpBa9pjo5jbIey4ak+JVYJjHm4HGC8biA4
kTEf9gZ3XpXbnGS8ACLJkpybohTGCzFnYlDDXU0a40VwLznrHPNHBmN7RBY7
mT8dzGK8GDw3dYzh1WzGDvjFXjKeJ7jM2BGLuGY/JurnMl6CvLRq2/AZBYwF
uHJ2cXTakULGS5GueVH7g6WOsRO6bGLH8h2KGS/D4s1j/Dx2lTJejmCDiPKb
z8sZA4/m+G61O3b7E2uBwAsfCqu33WH5ChjNGOvyc/Q9lq+AofqY7ntlFcuF
iK/xu507r4blQtTPGMrnjnzAcmfMMJt/V/mujuXOOChvvNFh0MDylcidvqzn
Or+R5Stxrq19W42mieWrUBKov76s8jHLV2F51Zi1w+atLHeBaeiepQ9D2lju
Aie1GX9zxhOWr0bjcf3wlMF2lq/G6J1not09O1juioVH+jJsL3Sy3BWdffzh
dxO6WL4GpeH714sinrF8DcJv8u/9XtfN8rXI8gwfu1bwguVrEW9lWTI7qYfl
bjArHtBN+viS5W7wffCw/GkWnbN14Pr77jLwe83ydbhulWp+b5gxxx2nn1qb
nDv9huXuWCJYu2qScy/L1yOtItUpromxdj1calsnX47oY/kG5AbaW08e2c/y
DTC2OHFUFcOY44GQiivbJRMGPjE8YIOwMXeOMNZ64Nnx3qSvOW8/sc4DO3Ya
rA7YypjjieS9j5Re9YzhidK0LbYqh3fM90R06ZbOk3GMdZ6w6/W3ntjBmLMR
hxyEo1r5g8zfiIbswn7+LsbajXA+Lh8jKGCs2wjLSMtL/F7GHC/YPY+s97d8
z3wvxJ1YkdMvYqz1Qn/I12Ub9jHWeSH/ecLjK6cZc7zxH2vziZoS8r3hPXtX
RVMz+d5A05p24QD53mjfn9Daa/iB+SJw/kidh+mMIcIEl8YNkZaMtSIIr6Wc
aOYx1olw9HD9plJH8n2wa+GT++rl5Pvg+RxH18nO5Psg0uQ71YhV5Psg1v1a
gZKY44smmVPKnpXk+0Id5ee1XUi+L6zs82s0NL7OF+Xprl9eFJDvB2nk8eGV
i8n3w/RLVdd9+eT7oS1edF/Phnw/JKV7CJX0fBx/dLVF9MbNIt8f4e+9KpJM
yffHvyafmqmaRL4/hoysBE8mkB+AQxFXW1cZkB+A2uH+DZdGkB+AwerCH/GB
5j8AyfoBWZx+Wr9AbEuv7R7qofULhOOvmlhBF61fILRHnw1ef0J+IPrVeokx
tL6cINj9Q65NaiA/CDd46rq3teQHIfzWS5uE++QHYat0uGDnHfKD0XM3KCrx
FvnBWBl8RjhUSn4wQrfk9SXeID8Yia0lck0R+SEYe9068uCv5Ieg2tJxyr18
8kPwOrTKfV0u+SHYUVtkO3SZ/FAI9I2fPMohPxR/D2tIf36R/FB0zsu8Nf8C
+aGQnc/PiMsiX4ygLr38uecYc8V4n7N5Z+tZGk+M3wNKo0ozGIvFsJg86FV5
hsYXIzUPV9+nM04WY8oeP4kbsU6MFIuacUVpjFvE+HlkVIwnMUeCU0Onc/WI
uRLs3v5ge10q9UtgdMs0s4xYLEGW+qKoilgrwReTDu14R5wsgafLW6MlNJ5O
gosm/tbxn/slkHrmdRvQ/+NIsVe1P/wYMVcKBzvnSnt6PkixwFmCl8RiKTIE
DQOFNB9aKWL36VudpPlKlsJFKJ8Wn0n9UshDJEZJNL8tUjy9M9u14PP8y3Bg
n69Fx3nql+GIwuCNBa0fZGjeqzaOyKZ+GSLz8xvv0XprZXiQzilcSvshWYbq
fL3p+VeoX4bscV/KV9D+aZEBZ+rHPcyjfjkOjHeP2VNA/XLcn3kwwPrzfpSj
2e6nwY5C6pfDylnTfZ72r1YOtaI6d5+O+uU4Ms2oI7CY+uU4W/R+tJDOQ4sc
hwd6Mnnl1K+A4ev9Sis6P1wF2pL/WWVdQf0KBFV0HVxE502sAK/z9JzVd6lf
AXXlT25iOp/JCqwx339SW039CiRubio/Q+e5RYGyWfXhD+qoX4mbI3iLDen8
c5VoEfN/EzZSvxImg0f1DjRRvxIzQrZsKn9M/Up8Nzy7yLiN+pXoK/W+GtxO
/UpkL6ickt1B/Uq8mbY9bjTdTxwVUq797am4m/pVMI/pfVj0gvpVWLD06Dzu
K+pXIUpTcuybN9SvQkKVQVd3H/WrMDU885noLfWrIM1JlRYPUr8Kxbf/bcob
ov4wJC2obT31kfrDsKfFLNqE7l+EwelU5d1vRzEWh8GsNzf+oz7dz2HQTJua
GUn3d3IYlAnHHr8wovv+z9/3zB+rGs+4JQw/FM4d1WpM9/8mLJxodjLwK8bc
TVgxtzmvzuTD8v8CuUb9sw==
             "]]}}}, {{}, {}}}, {
        DisplayFunction -> Identity, DisplayFunction -> Identity, AspectRatio -> 
         NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
         AxesLabel -> {None, None}, AxesOrigin -> {1., 0}, DisplayFunction :> 
         Identity, Epilog -> InsetBox[
           FormBox[
            StyleBox[
            "\"d)\"", {FontFamily -> "Helvetica", FontSize -> 20}, 
             StripOnInput -> False], TraditionalForm], 
           Offset[{0, 0}, 
            Scaled[{0.05, 0.95}]], 
           ImageScaled[{
             Rational[1, 2], 
             Rational[1, 2]}]], Frame -> {{True, False}, {True, False}}, 
         FrameLabel -> {{
            FormBox["\"\[Degree]C\"", TraditionalForm], None}, {
            FormBox["\"Year\"", TraditionalForm], None}}, FrameStyle -> {
           GrayLevel[0], 
           GrayLevel[0], Automatic, 
           GrayLevel[0]}, 
         FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
         GridLines -> {None, None}, GridLinesStyle -> Directive[
           GrayLevel[0.5, 0.4]], ImageSize -> 600, LabelStyle -> 
         Directive[FontFamily -> "Helvetica", FontSize -> 18, 
           GrayLevel[0]], 
         Method -> {
          "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
           "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), "CopiedValueFunction" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& )}}, PlotRange -> {{1, 200}, {0, 3}}, 
         PlotRangeClipping -> True, PlotRangePadding -> {{0, 0}, {0, 0}}, 
         Ticks -> {Automatic, Automatic}}]}, {
       InterpretationBox[
        Cell[
         BoxData[
          FormBox[
           StyleBox["\"B2\"", FontFamily -> "Helvetica", FontSize -> 18, 
            GrayLevel[0], Bold, StripOnInput -> False], TextForm]], 
         "InlineText"], 
        Text[
         Style["B2", FontFamily -> "Helvetica", FontSize -> 18, 
          GrayLevel[0], Bold]]], 
       GraphicsBox[{{}, {{{}, {}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             PointSize[0.006944444444444445], 
             AbsoluteThickness[1.6], 
             RGBColor[0, 0, 1]], 
            LineBox[CompressedData["
1:eJw1lns4Vfkeh3dFRRiaONKemcb9UtolIuIjl+0W253ttu97mxpUjq7YaJeE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             "]]}, {
            Hue[0.9060679774997897, 0.6, 0.6], 
            Directive[
             PointSize[0.006944444444444445], 
             AbsoluteThickness[1.6], 
             RGBColor[0, 0, 1], 
             Dashing[{Small, Small}]], 
            LineBox[CompressedData["
1:eJw9lQlQUwcehzMWEUXkUCpyKEeAylVOBQTyC7cgCiFAMEDuBASLBypWcAOo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             "]]}, {
            Hue[0.1421359549995791, 0.6, 0.6], 
            Directive[
             PointSize[0.006944444444444445], 
             AbsoluteThickness[1.6], 
             RGBColor[1, 0, 0]], 
            LineBox[CompressedData["
1:eJw1lgtUzHkfhyepbC5Jiza08YZaci0S6tON0nXSdG+ae6OoZVVk2YkuShfK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             "]]}, {
            Hue[0.37820393249936934`, 0.6, 0.6], 
            Directive[
             PointSize[0.006944444444444445], 
             AbsoluteThickness[1.6], 
             RGBColor[1, 0, 0], 
             Dashing[{Small, Small}]], 
            LineBox[CompressedData["
1:eJw1lgs01HkfhydSkfZSNqX2NUWo7HZRIV0+SiJyGbdhXOY+0+21TRd6Sw25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             "]]}, {
            Hue[0.6142719099991583, 0.6, 0.6], 
            Directive[
             PointSize[0.006944444444444445], 
             AbsoluteThickness[1.6], 
             RGBColor[0, 1, 0]], 
            LineBox[CompressedData["
1:eJw9lglQU3cex4OiBboVXK2rgyIiVS61cggiwpebcN8ECJI7QQXExYtdIeLB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             "]]}, {
            Hue[0.8503398874989481, 0.6, 0.6], 
            Directive[
             PointSize[0.006944444444444445], 
             AbsoluteThickness[1.6], 
             RGBColor[0, 1, 0], 
             Dashing[{Small, Small}]], 
            LineBox[CompressedData["
1:eJw9lgs01Hkfh2dLvaWmot5o10ZWnaQtwlh0+cj9fr9PmfuMbLQqCvVOQsll
I5ZXFqWb1cWpkNqYXip0Ubsi8tZo6w2ptNLldPHas79vznHmPOczj+c48///
5j9PFOMnHcfhcK6O/f71GpTLNR/OnwbOXz+C5L9fOTMQWWxe7fOZZ2Fr0Qh3
g4hYFwbXvzYfkRDrweS4o8lLObEB/tuiuyw+itgQ6oy6h8UxxEYYrpNHJGwi
XgBF8TebFyUQL4SLxYm6ViXxIjQWehxM3E28GB4luTmCHOIlGI116S7dT2yK
0cqT1aKjxGbgP7MyuXOWeBl++1ajb34TsTl4H7ZppN0htsA7xws1C/uJLZGY
lDG0epSYB+H9uD5N3Z2MrfC1lTyr1pz4O0hDFz3+lx+xNfSjC4KKNhHbwNSw
Wm1bRGwL4/GPUNBIvBzzjlzU7BkiXgH/nU/PWhqmMF6JdPn7ktZg4lVweF0+
60IOMbC5NNXf4BZjJdCQ3FY4ZWYq2+1Q8mXK8tQwxko7FCXMUWccoX01SlI2
18x8Q/tqxOf/PjDBI43t9vgz7J4JDjNW2mPur7UReeN2sd0B48KR2ixmrHTA
86Hoyz810+6IJdGRtSdMd7PdEUuXaN+t2s+Y4wTXQp6l9eR0tjsh3vCTW8cW
xhxn/Grzhdb0AdqdIWt1Nhfz97DdBfyU9z94tDFWusClycQQqzPY7opJGxya
q84yVrrinf6DpukLMtnuBr9s2ZS2fMZKNxRJjLtF47PY7o6UDqMo+2jGSnc8
rXuV9/wO7R64/HjYv986m+0e6P14zvzSvxlzPLG/NyOXO0K7J7J6Dp3b4P4j
273QHjtSX1jMWOmFUq/bduij3RuC6KpoHZ29bPdGjHhHnZ4VY44PjheM05sX
wBg+KG9qcdaLpvf7QMvLLnRqKmOVDzp4G/NGCsn3RcExHe7DCvJ90RVcury3
lnxfSHk26f9oJN8XN6aNqtZfI98PFUaiTNPb5Puh4H/O92LayffD9olN3l53
yPdD2nBixdDv5PvjjpPQYtst8v2R226x4iv6+0p/jC5/mPXn574/3KyShhdd
ID8ATnfN2p5WkR+AMfVM+GHyA9CQsGtqGf2/qgDwZJO6evaQHwj7jsAoiyTy
A2GeVGZz9XvyA3H/bk/9GT75gRDI7UNme5AfhPB1TnaTbckPgs3S9+mHjMkP
giKx56tP9PmpgtC+7EqT8UTyg/FBzN0bS583glEz3Nq3pYmuh2DwbOcnJZcx
VgVjYO7zmqNJdH2EYKF4cvPHEPJDMGLkrv7JkvwQVDfYbkzWJj8EUdNj42+8
oOszFC2nth5OvsEYofgDsWd/qaTrNRQVJ7u7HNIZq0KRza9ZmSsnPwwDWrrT
sp3ID0NUomaB+QLyw/BynNJ9+0Tyw5Bb59YQ+YTun3DIZ+sdfdnMGOE47ZXZ
qVVJ91s4DnCNHa5kMVaNsX/GJ80fyOfjhdMmy54A8vk4oRoy51mTz4eDeKfg
n3PJ5yNuUuDyuM/39xoMBkWJAvvZ/Y81UPo8TjvVRufB2F65Im5HDWPVGty6
kTur+Wc6P9ZCwHvFV6aSvxbuNtWCo+vJX4ui+01ONkHkr0VGlaY7bxX5Ecje
2HyxcCH5EShQcsZHaJMfAZsz6py0D+z8UkWg+5LZq6lP6HwTIO5B6+UXtxkb
CBCfNvns4ouMIcAjD89tl44xFggQVB4/VJlH56EAA4KYwX4l4zIBgkePRmxd
Tz0B5kQddw4JY6wWIMfjRFWKM/WFOH1Ku/qDBfWFODA0Y1u9IfWFSGzHyuYZ
1BfCsMbGVneUzmshzpyyaDz+jHGZECMV5WYpPYxVQpy3ffCs+BpjtRD37JvX
jZyn81+EmcaxCzJ/YWwgQnHlzYqIIsYQQdOSvzt6D2OBCHH7OiJqE6g/9n7u
QOd3UdQXYUZ934GX4dQXwcUoeYvag/oiHOtO0tdYSX0xfISx4vCl1Bej41nm
nMcG1BejyNRZv0yb+mM7Z0lYhgb1xXihLq89/Jp9v5WJoeN5ZPHzPsYqMfKv
5FWL7zFWi7E7+13ghJv0/SiBbHyA7m8qxgYSnM57xG05wxgSvEWCV/8RxgIJ
7HPt3poV0fepBDe5+UsPZlFfgs4pbXOtd1BfgteDeq9HNlFfguyD/k87FdSX
IlB52fo+n/pSzPecYzjJl/pSHEk3HAhwpL4UpX+c72m0pr4Un64XuwYsob4U
b79dlTrhG+pL0WV8uq9Dh/pShDxPun11KvVlKExNOtD5BfVlmF3eWD/hDXu+
gAxGksR9voOMBTKc+tCUdb6Xnkdk8HQt1kcn4zIZ2lddqO+9zlglQ5vV9kcl
/2GslmGjRgs3/hw9v8jxpGvwfORJxgZyNLzJjok7RH05hrX3ni4uor4cyq2v
uD17qS9HwMD1aRa7qC/HTD0Dx0PbqC9HwbN2+8WbqC+Hju3PZdfWUV+Buf69
wzuE1FcgY+Lxu14h1FdginfBoJk39RXI3VXXtsiJ+gpsX7bPyHoF9RXguX78
kW9BfQVMtXTr8kyor4As1sa115D6kfj+Wu9Tuy+pHwnJqoNeNVq78X95ka0t

             "]]}, {
            Hue[0.08640786499873876, 0.6, 0.6], 
            Directive[
             PointSize[0.006944444444444445], 
             AbsoluteThickness[1.6], 
             GrayLevel[0]], 
            LineBox[CompressedData["
1:eJw9lQs01Ikex2dz0fZA5SayTCbZrB3pYbyGLyo9Rkbe7zFPhNVjLzfJ5FFe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             "]]}}}, {{}, {}}}, {
        DisplayFunction -> Identity, DisplayFunction -> Identity, AspectRatio -> 
         NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
         AxesLabel -> {None, None}, AxesOrigin -> {1., 588.}, DisplayFunction :> 
         Identity, Epilog -> InsetBox[
           FormBox[
            StyleBox[
            "\"b)\"", {FontFamily -> "Helvetica", FontSize -> 20}, 
             StripOnInput -> False], TraditionalForm], 
           Offset[{0, 0}, 
            Scaled[{0.05, 0.95}]], 
           ImageScaled[{
             Rational[1, 2], 
             Rational[1, 2]}]], Frame -> {{True, False}, {True, False}}, 
         FrameLabel -> {{
            FormBox["\"GtC\"", TraditionalForm], None}, {
            FormBox["\"Year\"", TraditionalForm], None}}, FrameStyle -> {
           GrayLevel[0], 
           GrayLevel[0], Automatic, 
           GrayLevel[0]}, 
         FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
         GridLines -> {None, None}, GridLinesStyle -> Directive[
           GrayLevel[0.5, 0.4]], ImageSize -> 600, LabelStyle -> 
         Directive[FontFamily -> "Helvetica", FontSize -> 18, 
           GrayLevel[0]], 
         Method -> {
          "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
           "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), "CopiedValueFunction" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& )}}, PlotRange -> {{1, 200}, {588, 1200}}, 
         PlotRangeClipping -> True, PlotRangePadding -> {{0, 0}, {0, 0}}, 
         Ticks -> {Automatic, Automatic}}], 
       GraphicsBox[{{}, {{{}, {}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             PointSize[0.006944444444444445], 
             AbsoluteThickness[1.6], 
             RGBColor[0, 0, 1]], 
            LineBox[CompressedData["
1:eJxV03s01Pkfx/HBVoSoTaX6lSWRrkSK5CW3lRKGcWeGubi1bfq1JbYG1Xbx
E9IFXUZqK0JKF0LTXRe3tVRbIVFuKbZkS/n1O96fP35zzpw5j/Oe1/d55o/5
IXitu0iRw+Hc+/b+3+fw65015/9f4MW5b4+KHFo2TGXoGF810nw4ib6niRtl
4/fG6huRxyNtdFZBxAhz8iT8LA9xnuy4nDwVfHutPSZ6zmQdnHplWK+wmEvW
RWpilJXhCl/yDER0blkbFycgz0R7iFZ21x9isiGKFQNTNluvIRthdMzcrVOi
o8hzoGJeZV6ovpE8D6pti6cLN8WSF+AaT9E0LiKObIySUfdfztffTjZBlZpU
wSxmF3khnpmL9mnHJZFNcS//eNNn/VSyGVKtg/yWRO8nL8KcAV1frkM62RzC
2Txd5Ywj5MV4oKWQ/BeyyEtg5m8ULxtxgmyBDJuD0VLdU2TLb7/PRvLwaA55
KWblTIvsissnWyGjI+Xm8bBC8jKYiPWKJlReIFtjtP+x4NafLpEBmXVfdYx7
8bClQKvShy3/iimluw04jUVVlV3X6G6DlFvqLifqrtN9Obpj+CWfHt2k+3JM
uKTr1qN0h+62+LkSp128K+hui+zs3G3n6+/T3Q69u4/5/Tu2ku52EJdPqfea
WUN3e1yuHntoenYt3e1x6NpHlUDTOro74O3OgwPlT/6kuwPqJDvbKlMb6O4I
laUru/sDH9PdEQdUzqrvtPqL7j9CPq+54fzcZ3T/EXsN6nyS5jXS3QlPTwZf
TJzeTHcn5NYf2jNt/gu6r0BzQfUJiX0L3Vdg+eYZd+8LXtLdGeXl0f3ZCa10
d0ZvZvQrp5w2uq/EAv2MSI36V3RfCeOUTW/slNrpvgpJ6cLrS0w76L4KL6tD
Eq0knXR3QVtUzI6szC66u6B44pbC4ppuuq8Gr13t0/MRPXRfjeYzbTYRFm/p
7oo4h0HDlkX0v4crIpVTfM5Uk6Wu2Dvke8lW0jtsuStC3Of+ueYLmeOGXv7W
I+0pfbR3g8bVX3dFz/ib9m5IKn56u7OILHfDwJMCrqrte9q7Y/P96xMLqshw
R8vX6sZ8rw+0d0d+fQSv/TlZ7o68jBmfrQT9tOeiTLlm8MALMrjQs6nTbgr8
SHsuLk0Oihr5hCznQnN5loeC6wDtPfAo8b1ixU0yPMBp0tnAM/2H9h5IXleq
dTaLLPeAP68s9oHqJ9p74oGJrWFJFBmeMMvbbyptIEu/3U3txxuaf6a9J8Ld
nJzK08gcHmoTWqa7vSWDB61NPRHvHAZpz0M6x84pL5Ms5yH8VGpT+hsyxwtv
0gyM7i39QnsvPDjZdNNlF1nqhSvbfrm8rI4s94L/rRUeeZO/0t4buYqZowqC
yPDG5bbZFt7HyVJvvP1gblLWQpZ7o6k25p9enSHa+6AKMx1HB5DhA4X/RKzR
PkiW+uCQaWKfXjVZ7oPm2ZF3jylyMLz3RU3fonD5VDJ84VpVIPtiRpb6wu4H
3mm+C1nui5QiNfs+Edv7YVAhvqIklu39cGfEVO0bqWzvh5SLa69onGZ7P5jJ
ne/llLK9P367FaCVUcP2/hCXbhrX+pLt/eHSE/86qZ/t/XHEbew6mbIC7QOg
13vRftpkMgKgHTuyRH02WRqAeU1BrestyfIA1KyJkHk6s30gDB6FpV72ZftA
fH7iaHQ0jO0DoSiR/q6+ie0DEZBVPWH0DrYPwt7e4sCD+9g+CDYGnebFMrYP
glJUmOn6PLYPwqqKC/KKYrbnY8PMXP2y22QdPjJbI3Zza9nz+Gi0+K4/6RmZ
z8eIV5puUa/Z8/lwLIWE00eW8bHthbzdcpD1+BDM2RdhMFJx2M18FBjXRN7W
IHME2OnW4DZJm6wjgIuKJExXlwwBcPlCd5sRmS+A/2tfjmghWSrAzbleF7Ms
yTIByqXNKkdtyXIBjv6NTj9n1hdgzokjxs/dWT8YqUeKcvR8WT8YoeJkTWMB
6wejvMVYY1Qo6wcjzsDY7tRPrB8MWa2n9fcbWD8YLmEGCStjWD8YQtdftnvE
sX4w9M8/L5jzG+uHILtlGb8hkfVDsDFtUYd7KuuHINYuMTX7IOuH4Inp4fR7
h1k/BHtWlBrfyWL9EGhMObwt43fWD0FGlOy8Yy7rf3v+AYu6qgLWFyIn3vLD
giLWF+JSgN70tVdYX4gTPmtW7y5lfSEKzR7HJshZX4ji5NwDfrdYXwjvJZ+2
fV/B+kI8PPnC8OwD1hdiqOSO/8xq1hdh16jk9/F/sL4I8/c/L7tRz/oiWKxb
Jn31mPVF6FcRful5yvoi3PqV2/uskfVFCOtPG1f4gvVFyJ8lGBfZyvoi3JlQ
eXjMa9YXQzbhvXd6B+uL0cLV6VDrZn0xxpb3dob1sL4YnrsTPp57x/pi6HKT
s1v6WF8M1ddpW4fes74Yhg29E5U/sr4YSQ9VPwwOsL4E8XfDMxs/sb4Eq0we
78kbZH0JuvpjbMO/sr4EU5MGLLU4StSXoER7R1e+AlkmQf4+tdvmSmS5BJhi
tfjcd+RmCcaE5xROGknmhGJddHPGulFknVAc5sf4XlUmIxTC9VYe/SpkfigW
npnRoavK+qFw4G7daKPG+qFQmMXxc1dn/VA8PFfb7TmG9UNxUvVMwkoN1g+D
2azH6xdpsn4Y1MODNMaPVcJ/AeQZiHQ=
             "]]}, {
            Hue[0.9060679774997897, 0.6, 0.6], 
            Directive[
             PointSize[0.006944444444444445], 
             AbsoluteThickness[1.6], 
             RGBColor[0, 0, 1], 
             Dashing[{Small, Small}]], 
            LineBox[CompressedData["
1:eJxVk3tUjfkeh3eOCEnj0gWjpJi2xiSNS6GPnaYb2dVO7V2y2+1bpnNcu6DL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             "]]}, {
            Hue[0.1421359549995791, 0.6, 0.6], 
            Directive[
             PointSize[0.006944444444444445], 
             AbsoluteThickness[1.6], 
             RGBColor[1, 0, 0]], 
            LineBox[CompressedData["
1:eJxV1Qs01HkfBvAp2a22VlbRxWW2VF4ltWlDxeOSErmMO4MZw8xQwlK0qQZt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             "]]}, {
            Hue[0.37820393249936934`, 0.6, 0.6], 
            Directive[
             PointSize[0.006944444444444445], 
             AbsoluteThickness[1.6], 
             RGBColor[1, 0, 0], 
             Dashing[{Small, Small}]], 
            LineBox[CompressedData["
1:eJxV1X001PkeB/Dp4RK3Enq+aGoppSS3SJG3JPKUZzMex8yYGdJWsqhbmZ6U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             "]]}, {
            Hue[0.6142719099991583, 0.6, 0.6], 
            Directive[
             PointSize[0.006944444444444445], 
             AbsoluteThickness[1.6], 
             RGBColor[0, 1, 0]], 
            LineBox[CompressedData["
1:eJxV1Xk01XkfB/CrJNJKC9ouGaNFi12Fd9kq+7Vkv/e6rqsZMq2iyXNbhmgZ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             "]]}, {
            Hue[0.8503398874989481, 0.6, 0.6], 
            Directive[
             PointSize[0.006944444444444445], 
             AbsoluteThickness[1.6], 
             RGBColor[0, 1, 0], 
             Dashing[{Small, Small}]], 
            LineBox[CompressedData["
1:eJxVlXlUk1caxiMCslgFdxQFqUWwCCpgRa08YhOWCGWHEJasJCgmouICDsSF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             "]]}, {
            Hue[0.08640786499873876, 0.6, 0.6], 
            Directive[
             PointSize[0.006944444444444445], 
             AbsoluteThickness[1.6], 
             GrayLevel[0]], 
            LineBox[CompressedData["
1:eJxVlAtUTfkexw93Wt50eyGqo9KYQomkor56l16n1zmdnDqddyiK0mEmR2Fu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             "]]}}}, {{}, {}}}, {
        DisplayFunction -> Identity, DisplayFunction -> Identity, AspectRatio -> 
         NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
         AxesLabel -> {None, None}, AxesOrigin -> {1., 0}, DisplayFunction :> 
         Identity, Epilog -> InsetBox[
           FormBox[
            StyleBox[
            "\"e)\"", {FontFamily -> "Helvetica", FontSize -> 20}, 
             StripOnInput -> False], TraditionalForm], 
           Offset[{0, 0}, 
            Scaled[{0.05, 0.95}]], 
           ImageScaled[{
             Rational[1, 2], 
             Rational[1, 2]}]], Frame -> {{True, False}, {True, False}}, 
         FrameLabel -> {{
            FormBox["\"GtC\"", TraditionalForm], None}, {
            FormBox["\"Year\"", TraditionalForm], None}}, FrameStyle -> {
           GrayLevel[0], 
           GrayLevel[0], Automatic, 
           GrayLevel[0]}, 
         FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
         GridLines -> {None, None}, GridLinesStyle -> Directive[
           GrayLevel[0.5, 0.4]], ImageSize -> 600, LabelStyle -> 
         Directive[FontFamily -> "Helvetica", FontSize -> 18, 
           GrayLevel[0]], 
         Method -> {
          "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
           "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), "CopiedValueFunction" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& )}}, PlotRange -> {{1, 200}, {0, 3}}, 
         PlotRangeClipping -> True, PlotRangePadding -> {{0, 0}, {0, 0}}, 
         Ticks -> {Automatic, Automatic}}]}, {
       InterpretationBox[
        Cell[
         BoxData[
          FormBox[
           StyleBox["\"B3\"", FontFamily -> "Helvetica", FontSize -> 18, 
            GrayLevel[0], Bold, StripOnInput -> False], TextForm]], 
         "InlineText"], 
        Text[
         Style["B3", FontFamily -> "Helvetica", FontSize -> 18, 
          GrayLevel[0], Bold]]], 
       GraphicsBox[{{}, {{{}, {}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             PointSize[0.006944444444444445], 
             AbsoluteThickness[1.6], 
             RGBColor[0, 0, 1]], 
            LineBox[CompressedData["
1:eJw1lHs41PkexyeXrjaaIjpOlEq0RMph2fVGJtfcYsy4zX2mnG4uoeusQok2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             "]]}, {
            Hue[0.9060679774997897, 0.6, 0.6], 
            Directive[
             PointSize[0.006944444444444445], 
             AbsoluteThickness[1.6], 
             RGBColor[0, 0, 1], 
             Dashing[{Small, Small}]], 
            LineBox[CompressedData["
1:eJw1lAtUzHkfh0dqe20ke6yy0sWrpHVJkm6mT2W6KzVN0725z9RqdyXXdzGU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             "]]}, {
            Hue[0.1421359549995791, 0.6, 0.6], 
            Directive[
             PointSize[0.006944444444444445], 
             AbsoluteThickness[1.6], 
             RGBColor[1, 0, 0]], 
            LineBox[CompressedData["
1:eJw11glYjPseB/BR3CzlhORQh0KdrtJySyqlb5tJom1ap2XWZqLFdpFrGUWi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             "]]}, {
            Hue[0.37820393249936934`, 0.6, 0.6], 
            Directive[
             PointSize[0.006944444444444445], 
             AbsoluteThickness[1.6], 
             RGBColor[1, 0, 0], 
             Dashing[{Small, Small}]], 
            LineBox[CompressedData["
1:eJw1lgtUzGkfx4eQkIoQso3QagipRFFfVLpS02Vqusw0d23vpuioJLMuJWUr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             "]]}, {
            Hue[0.6142719099991583, 0.6, 0.6], 
            Directive[
             PointSize[0.006944444444444445], 
             AbsoluteThickness[1.6], 
             RGBColor[0, 1, 0]], 
            LineBox[CompressedData["
1:eJw1lgtUzGkfx6eIvGNdXhWlTZGklaPbohjfrnSvSarRZe4zUW+Wd0u23WZ1
k0omW+SyG5FKr0UMyWXY2jdtaRWFQkpK5bp53dl3zz6/OWfO/3zO93zP53+e
/3OzECfwZbocDqfh//+/ngc3mPDG1emA89dPuPnvJ0cflQc4ltMkxJNg/+UL
7u8KYgNY1B1Vx8YTT0NnzacL3H8TmyJA8tv9nm+IzVHg1vTOPIN4JpQWL20/
5hNbwlsZalqzl9gKXrndXjuPEFtj9EeDkL5zxDbYcNPZ7dXvxPPwLmlnvvUA
8XzwfR7ademmMV4AvWZ8k2JBbAeTifWtmzyI7bF34rfugXHEDtCLT+tKKiZ2
xPQTnXeTmoidUNMn0LTrpTP+EuVbhmrNvIgXoqO6WNuZR7wI95RTxcV3iBdj
8WWXL+47ZTB2xoEK4/RFO4ldMGfBkiQz3UzGSzCs4oeMSyJeitojfHvp/4h5
4HEz1+Wqshgvg3m0y4wWwy2MgculOt/LNYxVwMhcj31J4myWuyJ5NO/tRJOt
LHfF2Yjm3Fl3GHPcYLne/vHWIzksd4PuCf97Ohm5LHeH/pO5S6xi81jujpGA
cd5JYdtY7oHbX73PCA3MZ7kHUlVG3+lYb2e5J+BfrM+vYqzyhIlJ5zpzRzXL
veAhWqbuvcBY5YWaE0ZuY/wKWL4cg9kXGgZuM1YtR61mVmrPmh0sX4GH1klV
7u8Yq1bgu7LJWWE5P7DcG1cC9VbJTQpZ7o1ZPRblpw8z5vhge01c4Q/2RSz3
wbaL+z55n2XM8YXEaumvNrydLPfFKLulverzjDl+KHSMlj1YuIvlfujatIO3
o4oxxx8Vfa13TKcXs9wfqYc6ciekMeYE4ME9h1y9B5QHYEzKnEc/L93N8kBw
eAu5zfmMVYGYORL72vY25UFoyBUEnzLd8zcjCC7y6rFhYYxVQcj53qpt6lbG
2iA0+0SsGX+KMScYj97GZ4bfpH4wsgw3n7EdoX4wnrp7Gjfq72X9YOw3dO9M
NGLM4aN5QnpD5ueMwYdt/PiTK80Yq/ioCzjQ72pMfT4OWpcWnpxA/RAILrWE
Gn0ifwiccLS6dZD8IZhhfqUttJXePwTFcxwcuRp6/5V4dehaTmQR9VfCP36g
8dgG6q8EJ1vJWxtA/ZWYJtrYPmhF/VAsDDDanv2BjSdCMfCxibO3lcY7FC6V
HbpflTHWhkLBLUgNTqbxX4U1Y/4TqvKl/iqMTfAKd/6c+qtwTnVfonnCvq92
Feo2m2XO1tL3D8OS44ZO1WrGCAN3rteODAnNhzC88XU5f96J+mF4WjPfbKM+
9cNR3e90pamTzTeEY4ai/nrLzzQfw7Hr4D6NOp2xNhyVV1U/zhDQ/IyA88mQ
q2kLqB+Bmd75T+rHUj8C3K6K2py7bL5rIxBbfj0xVUPzX4ClbwTqonzGEECd
OufOr7G0XgSIMw3IHuNJfQGq4k6Z+VlQfzVS/ribsu0jW29YDUljU3tdF63H
1XBsGHXsYS1j7WocNa64NbSH1mckuEFnE5pSqB+JmhfR7apo6kfCuZJ/WseV
+pFInKn4tNyS+lF43Wja5adP/SigNLhm3GPaL6IwskJv2cZWxtooPEq3Cyw4
Q/tHNN7u1ozi/8QY0ZAeFlQdz6R+NHoFnU1H/kX9aIyOnzzdJYz6MbCbOftb
Aagfg8YVbWP1bKgfA3ejy++dDKgfg1J+X8PAR9rfhBjxfK5rPMjYXAi/7s7Y
yzcYQ4j24rW93ZcYC4WYkNe2ad1RxiohOoIjY+L3MC4RIsrSuLdtC2OtEOP6
y5NLEhl3C3GyQPd0i5T8IrhW+QVEh5BfhC2Ci5O83cgvArd2+3CuHflFyJo6
NGRlQX4RKvYPOxhMJr8I5VHHRvF1yC/Cmv6Y6jvP2f7eLYL+Jf/qkz20/4sR
0TU153obY3MxJhq03nSuZwwxtvouCurTMBaKsfhpf821cjovxLipLnnxYTfj
EjH8ZDmDijzGWjEWBGUf/ExFfjHWS7KcHq8nvwSbvr71y2g5+SVIrdydyY8g
vwSHq6fUX/cjvwRZ263as0F+CVQlF2escyS/BPPafI0yrckvwesGhyWNpuSX
IEOz2sJlMvmlcLx3WNyhR34pzqVkVOx7y85LSGEzlHQk9yljoRTzXlTMLX1A
56kUD/XSnt27xbhEimEBOlxbGGul8K5UX/xvHeNuKerSFheuO0vnswyXPjvu
73KMsbkM7lNa+q3KyC/DNdf1a+33kl+GoeT5jyILyC/DsOGH5ENbyC+Dzfhn
PG4q+WWY3tovzPua/DJ49vtO+iKO/HLkPK1P7xWTX44Ez0/vT0WQX47dj4UX
9geRX46rN24YlC0nvxyePvn8yzzyyzEr77eWl07klyM+5cfBZbbkl+O4w7kx
JZbkV8B4p2eeoSn5FUjUFA3/NIX8Cni8MtrF45JfgYSX/9B/rkt+BbhcZY3m
Lbv/lCjwIKHCNv8FY60CPj1lg8mDjLsVeNkYtymxh+5PSiReNVybfpuxuRLT
Lh4KKG1lDCWKevrOtjYyFioRl+rm/c9f6L6lxMSyiiJRLfmVOGOz1l1bTX4l
btUZ/2FbRX4lqr3j/SoPkj8WA69mv3HcR/5YeDU+O9RcqMaf1ZauLg==
             "]]}, {
            Hue[0.8503398874989481, 0.6, 0.6], 
            Directive[
             PointSize[0.006944444444444445], 
             AbsoluteThickness[1.6], 
             RGBColor[0, 1, 0], 
             Dashing[{Small, Small}]], 
            LineBox[CompressedData["
1:eJw91glUzXkbB/DbwjAlJEuM0aLSKCLFhPoWNZX2RXvd7tK9JBkTGjVcWky9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             "]]}, {
            Hue[0.08640786499873876, 0.6, 0.6], 
            Directive[
             PointSize[0.006944444444444445], 
             AbsoluteThickness[1.6], 
             GrayLevel[0]], 
            LineBox[CompressedData["
1:eJw1lXs41Pkex2eVRMqlHiodIavVYUhkKLyF3JLLMBi3MVeli3SPaii5pBsr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             "]]}}}, {{}, {}}}, {
        DisplayFunction -> Identity, DisplayFunction -> Identity, AspectRatio -> 
         NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
         AxesLabel -> {None, None}, AxesOrigin -> {1., 588.}, DisplayFunction :> 
         Identity, Epilog -> InsetBox[
           FormBox[
            StyleBox[
            "\"c)\"", {FontFamily -> "Helvetica", FontSize -> 20}, 
             StripOnInput -> False], TraditionalForm], 
           Offset[{0, 0}, 
            Scaled[{0.05, 0.95}]], 
           ImageScaled[{
             Rational[1, 2], 
             Rational[1, 2]}]], Frame -> {{True, False}, {True, False}}, 
         FrameLabel -> {{
            FormBox["\"GtC\"", TraditionalForm], None}, {
            FormBox["\"Year\"", TraditionalForm], None}}, FrameStyle -> {
           GrayLevel[0], 
           GrayLevel[0], Automatic, 
           GrayLevel[0]}, 
         FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
         GridLines -> {None, None}, GridLinesStyle -> Directive[
           GrayLevel[0.5, 0.4]], ImageSize -> 600, LabelStyle -> 
         Directive[FontFamily -> "Helvetica", FontSize -> 18, 
           GrayLevel[0]], 
         Method -> {
          "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
           "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), "CopiedValueFunction" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& )}}, PlotRange -> {{1, 200}, {588, 2200}}, 
         PlotRangeClipping -> True, PlotRangePadding -> {{0, 0}, {0, 0}}, 
         Ticks -> {Automatic, Automatic}}], 
       GraphicsBox[{{}, {{{}, {}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             PointSize[0.006944444444444445], 
             AbsoluteThickness[1.6], 
             RGBColor[0, 0, 1]], 
            LineBox[CompressedData["
1:eJxV0ns01Pkfx/EhiWqxEVpt4Wcp2aJsNiu9RiQJYzTulzFmxqj8IqJfqUZK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             "]]}, {
            Hue[0.9060679774997897, 0.6, 0.6], 
            Directive[
             PointSize[0.006944444444444445], 
             AbsoluteThickness[1.6], 
             RGBColor[0, 0, 1], 
             Dashing[{Small, Small}]], 
            LineBox[CompressedData["
1:eJxVkns0lfkeh/codzW6qYTIrZgoJJX4uORS7vf7ttl721GiQy5RG2Haps5J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             "]]}, {
            Hue[0.1421359549995791, 0.6, 0.6], 
            Directive[
             PointSize[0.006944444444444445], 
             AbsoluteThickness[1.6], 
             RGBColor[1, 0, 0]], 
            LineBox[CompressedData["
1:eJxV1Qs41PkeBvDpdtw661JJhajlbE6lxBYV72xFLjHud8bMmBlRIrq57NSK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             "]]}, {
            Hue[0.37820393249936934`, 0.6, 0.6], 
            Directive[
             PointSize[0.006944444444444445], 
             AbsoluteThickness[1.6], 
             RGBColor[1, 0, 0], 
             Dashing[{Small, Small}]], 
            LineBox[CompressedData["
1:eJxV1Qs01HkfBvCpLIndVW9ZXZRbotWuS26zlScKZV0G4zZk7pdcI6E6mUpJ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             "]]}, {
            Hue[0.6142719099991583, 0.6, 0.6], 
            Directive[
             PointSize[0.006944444444444445], 
             AbsoluteThickness[1.6], 
             RGBColor[0, 1, 0]], 
            LineBox[CompressedData["
1:eJxV1X1UzPkeB/BhKqucFWFpsVOiFMUqJVnvREkeqqnpueaxGVG58tBQmdLE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             "]]}, {
            Hue[0.8503398874989481, 0.6, 0.6], 
            Directive[
             PointSize[0.006944444444444445], 
             AbsoluteThickness[1.6], 
             RGBColor[0, 1, 0], 
             Dashing[{Small, Small}]], 
            LineBox[CompressedData["
1:eJxVlgs01Hkfh2cshby1SiWFKbqsIpRxq3yUS66N+7iNMWYMW2lRqbRMlLc3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             "]]}, {
            Hue[0.08640786499873876, 0.6, 0.6], 
            Directive[
             PointSize[0.006944444444444445], 
             AbsoluteThickness[1.6], 
             GrayLevel[0]], 
            LineBox[CompressedData["
1:eJxVknlYjXkfhw+SCkVCTFFpLDNpX2eoT9Imrad9O6dzOueUJU16kyVzCpPo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             "]]}}}, {{}, {}}}, {
        DisplayFunction -> Identity, DisplayFunction -> Identity, AspectRatio -> 
         NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
         AxesLabel -> {None, None}, AxesOrigin -> {1., 0}, DisplayFunction :> 
         Identity, Epilog -> InsetBox[
           FormBox[
            StyleBox[
            "\"f)\"", {FontFamily -> "Helvetica", FontSize -> 20}, 
             StripOnInput -> False], TraditionalForm], 
           Offset[{0, 0}, 
            Scaled[{0.05, 0.95}]], 
           ImageScaled[{
             Rational[1, 2], 
             Rational[1, 2]}]], Frame -> {{True, False}, {True, False}}, 
         FrameLabel -> {{
            FormBox["\"\[Degree]C\"", TraditionalForm], None}, {
            FormBox["\"Year\"", TraditionalForm], None}}, FrameStyle -> {
           GrayLevel[0], 
           GrayLevel[0], Automatic, 
           GrayLevel[0]}, 
         FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
         GridLines -> {None, None}, GridLinesStyle -> Directive[
           GrayLevel[0.5, 0.4]], ImageSize -> 600, LabelStyle -> 
         Directive[FontFamily -> "Helvetica", FontSize -> 18, 
           GrayLevel[0]], 
         Method -> {
          "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
           "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), "CopiedValueFunction" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& )}}, PlotRange -> {{1, 200}, {0, 5}}, 
         PlotRangeClipping -> True, PlotRangePadding -> {{0, 0}, {0, 0}}, 
         Ticks -> {Automatic, Automatic}}]}}, AutoDelete -> False, 
     GridBoxFrame -> {"Columns" -> {{True}}, "Rows" -> {{True}}}, 
     GridBoxItemSize -> {
      "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"], 
   TemplateBox[{
     StyleBox[
     "\"D16-calc\"", FontFamily -> "Helvetica", FontSize -> 20, StripOnInput -> 
      False], 
     StyleBox[
     "\"D16-calb\"", FontFamily -> "Helvetica", FontSize -> 20, StripOnInput -> 
      False], 
     StyleBox[
     "\"D13-calc\"", FontFamily -> "Helvetica", FontSize -> 20, StripOnInput -> 
      False], 
     StyleBox[
     "\"D13-calb\"", FontFamily -> "Helvetica", FontSize -> 20, StripOnInput -> 
      False], 
     StyleBox[
     "\"D07-calc\"", FontFamily -> "Helvetica", FontSize -> 20, StripOnInput -> 
      False], 
     StyleBox[
     "\"D07-calb\"", FontFamily -> "Helvetica", FontSize -> 20, StripOnInput -> 
      False], 
     StyleBox[
     "\"Fair-Geoffroy\"", FontFamily -> "Helvetica", FontSize -> 20, 
      StripOnInput -> False]}, "LineLegend", DisplayFunction -> (StyleBox[
      StyleBox[
       PaneBox[
        TagBox[
         GridBox[{{
            TagBox[
             GridBox[{{
                GraphicsBox[{{
                   Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                   Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1]], {}}}, AspectRatio -> Full, 
                 ImageSize -> {40, 10}, PlotRangePadding -> None, 
                 ImagePadding -> Automatic, 
                 BaselinePosition -> (Scaled[0.1] -> Baseline)], #, 
                GraphicsBox[{{
                   Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1], 
                    Dashing[{Small, Small}]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                   Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1], 
                    Dashing[{Small, Small}]], {}}}, AspectRatio -> Full, 
                 ImageSize -> {40, 10}, PlotRangePadding -> None, 
                 ImagePadding -> Automatic, 
                 BaselinePosition -> (Scaled[0.1] -> Baseline)], #2, 
                GraphicsBox[{{
                   Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                   Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0]], {}}}, AspectRatio -> Full, 
                 ImageSize -> {40, 10}, PlotRangePadding -> None, 
                 ImagePadding -> Automatic, 
                 BaselinePosition -> (Scaled[0.1] -> Baseline)], #3, 
                GraphicsBox[{{
                   Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0], 
                    Dashing[{Small, Small}]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                   Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0], 
                    Dashing[{Small, Small}]], {}}}, AspectRatio -> Full, 
                 ImageSize -> {40, 10}, PlotRangePadding -> None, 
                 ImagePadding -> Automatic, 
                 BaselinePosition -> (Scaled[0.1] -> Baseline)], #4, 
                GraphicsBox[{{
                   Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 1, 0]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                   Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 1, 0]], {}}}, AspectRatio -> Full, 
                 ImageSize -> {40, 10}, PlotRangePadding -> None, 
                 ImagePadding -> Automatic, 
                 BaselinePosition -> (Scaled[0.1] -> Baseline)], #5, 
                GraphicsBox[{{
                   Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 1, 0], 
                    Dashing[{Small, Small}]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                   Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 1, 0], 
                    Dashing[{Small, Small}]], {}}}, AspectRatio -> Full, 
                 ImageSize -> {40, 10}, PlotRangePadding -> None, 
                 ImagePadding -> Automatic, 
                 BaselinePosition -> (Scaled[0.1] -> Baseline)], #6, 
                GraphicsBox[{{
                   Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                   Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0]], {}}}, AspectRatio -> Full, 
                 ImageSize -> {40, 10}, PlotRangePadding -> None, 
                 ImagePadding -> Automatic, 
                 BaselinePosition -> (Scaled[0.1] -> Baseline)], #7}}, 
              GridBoxAlignment -> {
               "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
              AutoDelete -> False, 
              GridBoxDividers -> {
               "Columns" -> {{False}}, "Rows" -> {{False}}}, 
              GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
              GridBoxSpacings -> {"Columns" -> {{0.8, 0.5}}}], "Grid"]}}, 
          GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
          AutoDelete -> False, 
          GridBoxDividers -> {"Columns" -> {{None}}, "Rows" -> {{None}}}, 
          GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
          GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{1}}}], "Grid"], 
        Alignment -> Left, AppearanceElements -> None, 
        ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> "ResizeToFit"], 
       LineIndent -> 0, StripOnInput -> False], {FontFamily -> "Arial"}, 
      Background -> Automatic, StripOnInput -> False]& ), 
    InterpretationFunction :> (RowBox[{"LineLegend", "[", 
       RowBox[{
         RowBox[{"{", 
           RowBox[{
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{
                   GrayLevel[0], 
                   RectangleBox[{0, 0}]}, {
                   GrayLevel[0], 
                   RectangleBox[{1, -1}]}, {
                   RGBColor[0, 0, 1], 
                   RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                 "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                 FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                 FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                StyleBox[
                 RowBox[{"RGBColor", "[", 
                   RowBox[{"0", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                 False]], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
               ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[0, 0, 1]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[0, 0, 1], Editable -> False, Selectable -> False], ",", 
             RowBox[{"{", 
               RowBox[{
                 InterpretationBox[
                  ButtonBox[
                   TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                   BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                   ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                   Automatic, Method -> "Preemptive"], 
                  RGBColor[0, 0, 1], Editable -> False, Selectable -> False], 
                 ",", 
                 RowBox[{"Dashing", "[", 
                   RowBox[{"{", 
                    RowBox[{"Small", ",", "Small"}], "}"}], "]"}]}], "}"}], 
             ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{
                   GrayLevel[0], 
                   RectangleBox[{0, 0}]}, {
                   GrayLevel[0], 
                   RectangleBox[{1, -1}]}, {
                   RGBColor[1, 0, 0], 
                   RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                 "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                 FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                 FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                StyleBox[
                 RowBox[{"RGBColor", "[", 
                   RowBox[{"1", ",", "0", ",", "0"}], "]"}], NumberMarks -> 
                 False]], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
               ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",", 
             RowBox[{"{", 
               RowBox[{
                 InterpretationBox[
                  ButtonBox[
                   TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                   BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                   ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                   Automatic, Method -> "Preemptive"], 
                  RGBColor[1, 0, 0], Editable -> False, Selectable -> False], 
                 ",", 
                 RowBox[{"Dashing", "[", 
                   RowBox[{"{", 
                    RowBox[{"Small", ",", "Small"}], "}"}], "]"}]}], "}"}], 
             ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{
                   GrayLevel[0], 
                   RectangleBox[{0, 0}]}, {
                   GrayLevel[0], 
                   RectangleBox[{1, -1}]}, {
                   RGBColor[0, 1, 0], 
                   RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                 "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                 FrameStyle -> RGBColor[0., 0.6666666666666666, 0.], 
                 FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                StyleBox[
                 RowBox[{"RGBColor", "[", 
                   RowBox[{"0", ",", "1", ",", "0"}], "]"}], NumberMarks -> 
                 False]], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
               ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[0, 1, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[0, 1, 0], Editable -> False, Selectable -> False], ",", 
             RowBox[{"{", 
               RowBox[{
                 InterpretationBox[
                  ButtonBox[
                   TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0.6666666666666666, 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "1", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                   BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                   ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 1, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                   Automatic, Method -> "Preemptive"], 
                  RGBColor[0, 1, 0], Editable -> False, Selectable -> False], 
                 ",", 
                 RowBox[{"Dashing", "[", 
                   RowBox[{"{", 
                    RowBox[{"Small", ",", "Small"}], "}"}], "]"}]}], "}"}], 
             ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{
                   GrayLevel[0], 
                   RectangleBox[{0, 0}]}, {
                   GrayLevel[0], 
                   RectangleBox[{1, -1}]}, {
                   GrayLevel[0], 
                   RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                 "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                 FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                 PlotRangePadding -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                StyleBox[
                 RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> False]],
                Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = GrayLevel[0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              GrayLevel[0], Editable -> False, Selectable -> False]}], "}"}], 
         ",", 
         RowBox[{"{", 
           RowBox[{#, ",", #2, ",", #3, ",", #4, ",", #5, ",", #6, ",", #7}], 
           "}"}], ",", 
         RowBox[{"LegendLayout", "\[Rule]", 
           RowBox[{"{", 
             RowBox[{"\"Row\"", ",", "1"}], "}"}]}]}], "]"}]& ), Editable -> 
    True]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "Below"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.823434146647944*^9, 3.8234343867532825`*^9, 3.8234344590833845`*^9, {
   3.8234348971360636`*^9, 3.823434939171124*^9}, 3.8234359679996862`*^9, 
   3.823444593054296*^9, 3.823444748691515*^9, 3.824192366412307*^9},
 CellLabel->
  "Out[2030]=",ExpressionUUID->"5b9c93ce-4a9e-4090-b1fd-14fdd580c015"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<SIFigureZECMIP.tiff\>\"", ",", "SIFigureZECMIP"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.8234349513931413`*^9, 3.8234349784231796`*^9}},
 CellLabel->
  "In[1333]:=",ExpressionUUID->"f26af0f5-f0af-484d-b9f5-3ed694560923"],

Cell[BoxData["\<\"SIFigureZECMIP.tiff\"\>"], "Output",
 CellChangeTimes->{3.8234349820531845`*^9, 3.823444763742536*^9},
 CellLabel->
  "Out[1333]=",ExpressionUUID->"09ca9c80-3e06-4c70-a952-cf3046c8fb15"]
}, Open  ]],

Cell["ZEC: 420 GtCO2 from 2018", "Text",
 CellChangeTimes->{{3.71113575119866*^9, 3.7111357648642597`*^9}, {
  3.711171131470954*^9, 3.711171132484956*^9}, {3.712408724609439*^9, 
  3.7124087395614595`*^9}, {3.7662479249546547`*^9, 3.7662479290036545`*^9}, {
  3.810276061054193*^9, 3.810276074321699*^9}, {3.8167180604130163`*^9, 
  3.816718074126128*^9}, {3.8171501903508883`*^9, 3.8171502004843855`*^9}, {
  3.8234352506786737`*^9, 3.823435263659692*^9}, {3.824190835026394*^9, 
  3.8241908353115764`*^9}},
 FontSize->18,
 Background->RGBColor[
  0.87, 0.94, 1],ExpressionUUID->"7dd2443e-c6be-4abc-b2dc-23b01d4cc60e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"dataCW", "=", 
   RowBox[{
   "Import", "[", "\"\<Emissionspaths_committedwarming420.csv\>\"", "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.8171502256474347`*^9, 3.8171502452327433`*^9}, {
  3.824189303676859*^9, 3.824189304556935*^9}},
 CellLabel->
  "In[1969]:=",ExpressionUUID->"4075e960-8a19-45b8-a82c-fc729d38e731"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cwl", "=", 
  RowBox[{
   RowBox[{"Dimensions", "[", "dataCW", "]"}], "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8171502507523904`*^9, 3.817150257319104*^9}, {
  3.8233617519121127`*^9, 3.823361760094124*^9}},
 CellLabel->
  "In[1970]:=",ExpressionUUID->"e66a07d3-112b-4464-a9b9-74e61ed22aa7"],

Cell[BoxData["287"], "Output",
 CellChangeTimes->{3.8171502583166447`*^9, 3.823360565039359*^9, 
  3.823361760944125*^9, 3.8241893095065756`*^9},
 CellLabel->
  "Out[1970]=",ExpressionUUID->"0e40c5c3-d277-487c-a415-d0bf76b0adc0"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"CW85Results", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "cwl"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "15"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CW85Results", "[", 
    RowBox[{"[", "1", "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
    "\"\<1-year\>\"", ",", "\"\<2-C-CC16c\>\"", ",", "\"\<3-C-CC16b\>\"", 
     ",", "\"\<4-C-CC13c\>\"", ",", "\"\<5-C-CC13b\>\"", ",", 
     "\"\<6-C-CC07c\>\"", ",", "\"\<7-C-CC07b\>\"", ",", "\"\<8-C-FG\>\"", 
     ",", "\"\<9-T-CC16c\>\"", ",", "\"\<10-T-CC16b\>\"", ",", 
     "\"\<11-T-CC13c\>\"", ",", "\"\<12-T-CC13b\>\"", ",", 
     "\"\<13-T-CC07c\>\"", ",", "\"\<14-T-CC07b\>\"", ",", 
     "\"\<15-T-FG\>\""}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"CW85Results", "[", 
      RowBox[{"[", 
       RowBox[{
        RowBox[{"i", "+", "1"}], ",", "1"}], "]"}], "]"}], "=", 
     RowBox[{"2014", "+", "i"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", 
      RowBox[{"cwl", "-", "1"}]}], "}"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.8233619328173676`*^9, 3.8233619455993857`*^9}, {
  3.8233621407209578`*^9, 3.823362145251964*^9}, {3.823362258913124*^9, 
  3.823362259563125*^9}, {3.823362756046414*^9, 3.823362841554537*^9}, {
  3.8233629285976596`*^9, 3.823362986454741*^9}},
 CellLabel->
  "In[1971]:=",ExpressionUUID->"5fc2d92b-c500-49af-bde4-3c8f8963a7d3"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Do", "[", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"y", "=", "cwl"}], ",", " ", 
       RowBox[{"(*", 
        RowBox[{
        "needs", " ", "to", " ", "plus", " ", "1", " ", "the", " ", "length", 
         " ", "of", " ", "the", " ", "emission", " ", "input", " ", "file"}], 
        "*)"}], "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{"Do", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"transfer", "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"i", "+", "2"}], ",", "3"}], "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{"transfer", "[", 
             RowBox[{"[", 
              RowBox[{
               RowBox[{"i", "+", "1"}], ",", "3"}], "]"}], "]"}], "+", 
            "timestep"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "1", ",", "2"}], "}"}]}], "]"}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{
          RowBox[{"transfer", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", 
             RowBox[{"{", 
              RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "]"}], "]"}], "=", 
          "int2005"}], ";", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"transfer", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "7"}], "]"}], "]"}], "=", 
          RowBox[{"hfun", "[", 
           RowBox[{"transfer", "[", 
            RowBox[{"[", 
             RowBox[{"2", ",", "5"}], "]"}], "]"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"transfer", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "8"}], "]"}], "]"}], "=", 
          RowBox[{"Afun", "[", "timestep", "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"transfer", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "9"}], "]"}], "]"}], "=", 
          RowBox[{"Bfun", "[", 
           RowBox[{"transfer", "[", 
            RowBox[{"[", 
             RowBox[{"2", ",", "7"}], "]"}], "]"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"transfer", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", 
             RowBox[{"{", 
              RowBox[{"12", ",", "13", ",", "14"}], "}"}]}], "]"}], "]"}], 
          "=", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"trans", ".", 
               RowBox[{"transfer", "[", 
                RowBox[{"[", 
                 RowBox[{"2", ",", 
                  RowBox[{"{", 
                   RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "]"}], "]"}]}],
               "/.", "par"}], "/.", 
             RowBox[{"t", "\[Rule]", "timestep"}]}], "/.", 
            RowBox[{"A", "\[Rule]", 
             RowBox[{"transfer", "[", 
              RowBox[{"[", 
               RowBox[{"2", ",", "8"}], "]"}], "]"}]}]}], "/.", 
           RowBox[{"B", "\[Rule]", 
            RowBox[{"transfer", "[", 
             RowBox[{"[", 
              RowBox[{"2", ",", "9"}], "]"}], "]"}]}]}]}], ";"}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"transfery1CC16", "=", 
        RowBox[{"Table", "[", 
         RowBox[{"0", ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "y"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"j", ",", "18"}], "}"}]}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"transfery1CC16", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "=", 
        RowBox[{"{", 
         RowBox[{
         "\"\<1-Y\>\"", ",", "\"\<2-E\>\"", ",", "\"\<3-CDR\>\"", ",", 
          "\"\<4-MATc\>\"", ",", "\"\<5-MUPc\>\"", ",", "\"\<6-MLOc\>\"", 
          ",", "\"\<7-dC\>\"", ",", "\"\<8-MATb\>\"", ",", "\"\<9-MUPb\>\"", 
          ",", "\"\<10-MLOb\>\"", ",", "\"\<11-dC\>\"", ",", "\"\<12-Fex\>\"",
           ",", "\"\<13-Fc\>\"", ",", "\"\<14-Fb\>\"", ",", 
          "\"\<15-TempAc\>\"", ",", "\"\<16-TempOc\>\"", ",", 
          "\"\<17-TempAb\>\"", ",", "\"\<18-TempOb\>\""}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Do", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"transfery1CC16", "[", 
           RowBox[{"[", 
            RowBox[{"n", ",", "1"}], "]"}], "]"}], "=", 
          RowBox[{"2015", "+", "n", "-", "2"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "2", ",", "y"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"emcolumns", "=", 
         RowBox[{"{", "5", "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"emissions1", "=", 
         RowBox[{"dataCW", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;", "cwl"}], ",", 
            RowBox[{"emcolumns", "[", 
             RowBox[{"[", "k", "]"}], "]"}]}], "]"}], "]"}]}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"cdr1", "=", 
          RowBox[{"Input1CC16", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"2", ";;", "v3"}], ",", 
             RowBox[{"k", "*", "3"}]}], "]"}], "]"}]}], ","}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"transfery1CC16", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;", "y"}], ",", "2"}], "]"}], "]"}], "=", 
        "emissions1"}], ",", " ", 
       RowBox[{"(*", "Emissions", "*)"}], "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{
          RowBox[{"transfery1CC16", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"2", ";;", "y"}], ",", "3"}], "]"}], "]"}], "=", 
          "cdr1"}], ","}], "*)"}], 
       RowBox[{"(*", "CDR", "*)"}], "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{"Do", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"transfer", "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"i", "+", "2"}], ",", "3"}], "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{"transfer", "[", 
             RowBox[{"[", 
              RowBox[{
               RowBox[{"i", "+", "1"}], ",", "3"}], "]"}], "]"}], "+", 
            "timestep"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "1", ",", "2"}], "}"}]}], "]"}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"transfery1CC16", "[", 
         RowBox[{"[", 
          RowBox[{"2", ",", 
           RowBox[{"{", 
            RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "]"}], "]"}], "=", 
        "intCC162015"}], ",", " ", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{
         "initial", " ", "carbon", " ", "values", " ", "for", " ", 
          "atmosphere"}], ",", " ", 
         RowBox[{"upper", " ", "ocean"}], ",", " ", 
         RowBox[{"lower", " ", "ocean"}]}], "*)"}], "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"transfery1CC16", "[", 
         RowBox[{"[", 
          RowBox[{"2", ",", 
           RowBox[{"{", 
            RowBox[{"8", ",", "9", ",", "10"}], "}"}]}], "]"}], "]"}], "=", 
        "intCC162015"}], ",", " ", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{
         "initial", " ", "carbon", " ", "values", " ", "for", " ", 
          "atmosphere"}], ",", " ", 
         RowBox[{"upper", " ", "ocean"}], ",", " ", 
         RowBox[{"lower", " ", "ocean"}]}], "*)"}], "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"transfery1CC16", "[", 
         RowBox[{"[", 
          RowBox[{"2", ",", 
           RowBox[{"{", 
            RowBox[{"15", ",", "16"}], "}"}]}], "]"}], "]"}], "=", 
        "TwoFexDice2015"}], ",", " ", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{"atmosphere", " ", "temperature"}], ",", " ", 
         RowBox[{"ocean", " ", "temperature"}]}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"transfery1CC16", "[", 
         RowBox[{"[", 
          RowBox[{"2", ",", 
           RowBox[{"{", 
            RowBox[{"17", ",", "18"}], "}"}]}], "]"}], "]"}], "=", 
        "TwoFexDice2015"}], ",", " ", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{"atmosphere", " ", "temperature"}], ",", " ", 
         RowBox[{"ocean", " ", "temperature"}]}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"fexcolumns", "=", 
          RowBox[{"{", 
           RowBox[{"40", ",", "44", ",", "45"}], "}"}]}], ","}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"transfery1CC16", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;", "y"}], ",", "12"}], "]"}], "]"}], "=", "0"}], 
       ",", " ", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"dataRCP1", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;", "v3"}], ",", 
            RowBox[{"fexcolumns", "[", 
             RowBox[{"[", "k", "]"}], "]"}]}], "]"}], "]"}], ","}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"transfery1CC16", "[", 
         RowBox[{"[", 
          RowBox[{"2", ",", "13"}], "]"}], "]"}], "=", 
        RowBox[{
         RowBox[{
          RowBox[{"\[Eta]", "*", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Log", "[", 
              RowBox[{
               RowBox[{"transfery1CC16", "[", 
                RowBox[{"[", 
                 RowBox[{"2", ",", "4"}], "]"}], "]"}], "/", "MPI"}], "]"}], 
             "/", 
             RowBox[{"Log", "[", "2", "]"}]}], ")"}]}], "+", 
          RowBox[{"transfery1CC16", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "12"}], "]"}], "]"}]}], "/.", "parT161calc"}]}],
        ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"transfery1CC16", "[", 
         RowBox[{"[", 
          RowBox[{"2", ",", "14"}], "]"}], "]"}], "=", 
        RowBox[{
         RowBox[{
          RowBox[{"\[Eta]", "*", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Log", "[", 
              RowBox[{
               RowBox[{"transfery1CC16", "[", 
                RowBox[{"[", 
                 RowBox[{"2", ",", "8"}], "]"}], "]"}], "/", "MPI"}], "]"}], 
             "/", 
             RowBox[{"Log", "[", "2", "]"}]}], ")"}]}], "+", 
          RowBox[{"transfery1CC16", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "12"}], "]"}], "]"}]}], "/.", "parT161calb"}]}],
        ",", "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"timestepy", "=", "85"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Do", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"transfery1CC16", "[", 
             RowBox[{"[", 
              RowBox[{"n", ",", "10"}], "]"}], "]"}], "=", 
            RowBox[{
             RowBox[{"intT2015", "[", 
              RowBox[{"[", "3", "]"}], "]"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "/", "timestepy"}], ")"}], "*", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"intT2015", "[", 
                 RowBox[{"[", "4", "]"}], "]"}], "-", 
                RowBox[{"intT2015", "[", 
                 RowBox[{"[", "3", "]"}], "]"}]}], ")"}], "*", 
              RowBox[{"(", 
               RowBox[{"n", "-", "2"}], ")"}]}]}]}], ",", 
           RowBox[{"{", 
            RowBox[{"n", ",", "3", ",", 
             RowBox[{"timestepy", "+", "2"}]}], "}"}]}], "]"}], ",", " ", 
         RowBox[{"(*", 
          RowBox[{"Calculate", " ", "exogenous", " ", "forcing"}], "*)"}], 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"transfery1CC16", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{
              RowBox[{"timestepy", "+", "3"}], ";;", "y"}], ",", "10"}], 
            "]"}], "]"}], "=", 
          RowBox[{"intT2015", "[", 
           RowBox[{"[", "4", "]"}], "]"}]}], ","}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"Do", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"transfery1CC16", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", 
               RowBox[{"{", 
                RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "]"}], "]"}], "=", 
            RowBox[{
             RowBox[{
              RowBox[{"transfery1CC16", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "-", "1"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "]"}], "]"}], 
              ".", "a1calc"}], "+", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"1", ",", "0", ",", "0"}], "}"}], "*", 
              RowBox[{"transfery1CC16", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "-", "1"}], ",", "2"}], "]"}], "]"}]}]}]}], ",", 
           RowBox[{
            RowBox[{"transfery1CC16", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", 
               RowBox[{"{", 
                RowBox[{"8", ",", "9", ",", "10"}], "}"}]}], "]"}], "]"}], 
            "=", 
            RowBox[{
             RowBox[{
              RowBox[{"transfery1CC16", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "-", "1"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"8", ",", "9", ",", "10"}], "}"}]}], "]"}], "]"}], 
              ".", "a1calb"}], "+", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"1", ",", "0", ",", "0"}], "}"}], "*", 
              RowBox[{"transfery1CC16", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "-", "1"}], ",", "2"}], "]"}], "]"}]}]}]}], ",",
            "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"transfery1CC16", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", "13"}], "]"}], "]"}], "=", 
            RowBox[{
             RowBox[{
              RowBox[{"\[Eta]", "*", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"Log", "[", 
                  RowBox[{
                   RowBox[{"transfery1CC16", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "4"}], "]"}], "]"}], "/", "MPI"}], 
                  "]"}], "/", 
                 RowBox[{"Log", "[", "2", "]"}]}], ")"}]}], "+", 
              RowBox[{"transfery1CC16", "[", 
               RowBox[{"[", 
                RowBox[{"i", ",", "12"}], "]"}], "]"}]}], "/.", 
             "parT161calc"}]}], ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"transfery1CC16", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", "14"}], "]"}], "]"}], "=", 
            RowBox[{
             RowBox[{
              RowBox[{"\[Eta]", "*", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"Log", "[", 
                  RowBox[{
                   RowBox[{"transfery1CC16", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "4"}], "]"}], "]"}], "/", "MPI"}], 
                  "]"}], "/", 
                 RowBox[{"Log", "[", "2", "]"}]}], ")"}]}], "+", 
              RowBox[{"transfery1CC16", "[", 
               RowBox[{"[", 
                RowBox[{"i", ",", "12"}], "]"}], "]"}]}], "/.", 
             "parT161calb"}]}], ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"transfery1CC16", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", 
               RowBox[{"{", 
                RowBox[{"15", ",", "16"}], "}"}]}], "]"}], "]"}], "=", 
            RowBox[{
             RowBox[{
              RowBox[{"TransT161calc", ".", 
               RowBox[{"transfery1CC16", "[", 
                RowBox[{"[", 
                 RowBox[{
                  RowBox[{"i", "-", "1"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"15", ",", "16"}], "}"}]}], "]"}], "]"}]}], "+", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"1", ",", "0"}], "}"}], "*", "xi1", "*", 
               RowBox[{"transfery1CC16", "[", 
                RowBox[{"[", 
                 RowBox[{"i", ",", "13"}], "]"}], "]"}]}]}], "/.", 
             "parT161calc"}]}], ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"transfery1CC16", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", 
               RowBox[{"{", 
                RowBox[{"17", ",", "18"}], "}"}]}], "]"}], "]"}], "=", 
            RowBox[{
             RowBox[{
              RowBox[{"TransT161calb", ".", 
               RowBox[{"transfery1CC16", "[", 
                RowBox[{"[", 
                 RowBox[{
                  RowBox[{"i", "-", "1"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"17", ",", "18"}], "}"}]}], "]"}], "]"}]}], "+", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"1", ",", "0"}], "}"}], "*", "xi1", "*", 
               RowBox[{"transfery1CC16", "[", 
                RowBox[{"[", 
                 RowBox[{"i", ",", "14"}], "]"}], "]"}]}]}], "/.", 
             "parT161calb"}]}], ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"transfery1CC16", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", "7"}], "]"}], "]"}], "=", 
            RowBox[{
             RowBox[{"Total", "[", 
              RowBox[{"transfery1CC16", "[", 
               RowBox[{"[", 
                RowBox[{"i", ",", 
                 RowBox[{"{", 
                  RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "]"}], "]"}], 
              "]"}], "-", 
             RowBox[{"Total", "[", 
              RowBox[{"transfery1CC16", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "-", "1"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "]"}], "]"}], 
              "]"}]}]}], ",", 
           RowBox[{
            RowBox[{"transfery1CC16", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", "11"}], "]"}], "]"}], "=", 
            RowBox[{
             RowBox[{"Total", "[", 
              RowBox[{"transfery1CC16", "[", 
               RowBox[{"[", 
                RowBox[{"i", ",", 
                 RowBox[{"{", 
                  RowBox[{"8", ",", "9", ",", "10"}], "}"}]}], "]"}], "]"}], 
              "]"}], "-", 
             RowBox[{"Total", "[", 
              RowBox[{"transfery1CC16", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "-", "1"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"8", ",", "9", ",", "10"}], "}"}]}], "]"}], "]"}], 
              "]"}]}]}]}], "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"i", ",", "3", ",", "y"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"CW85Results", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;", "y"}], ",", 
           RowBox[{"k", "+", "1"}]}], "]"}], "]"}], "=", 
        RowBox[{"transfery1CC16", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;", "y"}], ",", "4"}], "]"}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"CW85Results", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;", "y"}], ",", 
           RowBox[{"k", "+", "2"}]}], "]"}], "]"}], "=", 
        RowBox[{"transfery1CC16", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;", "y"}], ",", "8"}], "]"}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"CW85Results", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;", "y"}], ",", 
           RowBox[{"k", "+", "8"}]}], "]"}], "]"}], "=", 
        RowBox[{"transfery1CC16", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;", "y"}], ",", "15"}], "]"}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"CW85Results", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;", "y"}], ",", 
           RowBox[{"k", "+", "9"}]}], "]"}], "]"}], "=", 
        RowBox[{"transfery1CC16", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;", "y"}], ",", "17"}], "]"}], "]"}]}]}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "1", ",", "1"}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.817183532094037*^9, 3.8171835849316654`*^9}, {
   3.8171836261424646`*^9, 3.8171836559173756`*^9}, {3.8171836926721554`*^9, 
   3.817183700225592*^9}, {3.8171837483355293`*^9, 3.817183754024845*^9}, {
   3.8171840794336424`*^9, 3.817184157689059*^9}, {3.8171995198952336`*^9, 
   3.81719953469452*^9}, {3.817200647782261*^9, 3.817200656880283*^9}, 
   3.8172009826487427`*^9, {3.823363085973169*^9, 3.82336309408418*^9}, {
   3.8233631281342287`*^9, 3.8233631708602886`*^9}, {3.823363280570443*^9, 
   3.8233633821375866`*^9}, {3.8233634378577194`*^9, 
   3.8233634441287284`*^9}, {3.824190849362445*^9, 3.8241908549757586`*^9}},
 CellLabel->
  "In[1979]:=",ExpressionUUID->"3084e01c-e325-4008-8680-79e5e84f9e7d"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Do", "[", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"y", "=", "cwl"}], ",", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{
          RowBox[{"Dimensions", "[", "dataNorem", "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}], ","}], "*)"}], " ", 
       "\[IndentingNewLine]", 
       RowBox[{"transfery1CC13", "=", 
        RowBox[{"Table", "[", 
         RowBox[{"0", ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "y"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"j", ",", "18"}], "}"}]}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"transfery1CC13", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "=", 
        RowBox[{"{", 
         RowBox[{
         "\"\<1-Y\>\"", ",", "\"\<2-E\>\"", ",", "\"\<3-CDR\>\"", ",", 
          "\"\<4-MATc\>\"", ",", "\"\<5-MUPc\>\"", ",", "\"\<6-MLOc\>\"", 
          ",", "\"\<7-dC\>\"", ",", "\"\<8-MATb\>\"", ",", "\"\<9-MUPb\>\"", 
          ",", "\"\<10-MLOb\>\"", ",", "\"\<11-dC\>\"", ",", "\"\<12-Fex\>\"",
           ",", "\"\<13-Fc\>\"", ",", "\"\<14-Fb\>\"", ",", 
          "\"\<15-TempAc\>\"", ",", "\"\<16-TempOc\>\"", ",", 
          "\"\<17-TempAb\>\"", ",", "\"\<18-TempOb\>\""}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Do", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"transfery1CC13", "[", 
           RowBox[{"[", 
            RowBox[{"n", ",", "1"}], "]"}], "]"}], "=", 
          RowBox[{"1765", "+", "n", "-", "2"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "2", ",", "y"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"emcolumns", "=", 
         RowBox[{"{", "5", "}"}]}], ";", " ", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"2", ",", "3", ",", "4"}], "}"}], ";"}], "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"emissions1", "=", 
         RowBox[{"dataCW", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;", "cwl"}], ",", 
            RowBox[{"emcolumns", "[", 
             RowBox[{"[", "k", "]"}], "]"}]}], "]"}], "]"}]}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"transfery1CC13", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;", "y"}], ",", "2"}], "]"}], "]"}], "=", 
        "emissions1"}], ",", " ", 
       RowBox[{"(*", "Emissions", "*)"}], "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"transfery1CC13", "[", 
         RowBox[{"[", 
          RowBox[{"2", ",", 
           RowBox[{"{", 
            RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "]"}], "]"}], "=", 
        "intCC132015"}], ",", " ", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{
         "initial", " ", "carbon", " ", "values", " ", "for", " ", 
          "atmosphere"}], ",", " ", 
         RowBox[{"upper", " ", "ocean"}], ",", " ", 
         RowBox[{"lower", " ", "ocean"}]}], "*)"}], "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"transfery1CC13", "[", 
         RowBox[{"[", 
          RowBox[{"2", ",", 
           RowBox[{"{", 
            RowBox[{"8", ",", "9", ",", "10"}], "}"}]}], "]"}], "]"}], "=", 
        "intCC132015"}], ",", " ", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{
         "initial", " ", "carbon", " ", "values", " ", "for", " ", 
          "atmosphere"}], ",", " ", 
         RowBox[{"upper", " ", "ocean"}], ",", " ", 
         RowBox[{"lower", " ", "ocean"}]}], "*)"}], "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"transfery1CC13", "[", 
         RowBox[{"[", 
          RowBox[{"2", ",", 
           RowBox[{"{", 
            RowBox[{"15", ",", "16"}], "}"}]}], "]"}], "]"}], "=", 
        "TwoFexDice2015"}], ",", " ", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{"atmosphere", " ", "temperature"}], ",", " ", 
         RowBox[{"ocean", " ", "temperature"}]}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"transfery1CC13", "[", 
         RowBox[{"[", 
          RowBox[{"2", ",", 
           RowBox[{"{", 
            RowBox[{"17", ",", "18"}], "}"}]}], "]"}], "]"}], "=", 
        "TwoFexDice2015"}], ",", " ", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{"atmosphere", " ", "temperature"}], ",", " ", 
         RowBox[{"ocean", " ", "temperature"}]}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"transfery1CC13", "[", 
         RowBox[{"[", 
          RowBox[{"2", ",", "13"}], "]"}], "]"}], "=", 
        RowBox[{
         RowBox[{
          RowBox[{"\[Eta]", "*", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Log", "[", 
              RowBox[{
               RowBox[{"transfery1CC13", "[", 
                RowBox[{"[", 
                 RowBox[{"2", ",", "4"}], "]"}], "]"}], "/", "MPI"}], "]"}], 
             "/", 
             RowBox[{"Log", "[", "2", "]"}]}], ")"}]}], "+", 
          RowBox[{"transfery1CC13", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "12"}], "]"}], "]"}]}], "/.", "parT131calc"}]}],
        ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"transfery1CC13", "[", 
         RowBox[{"[", 
          RowBox[{"2", ",", "14"}], "]"}], "]"}], "=", 
        RowBox[{
         RowBox[{
          RowBox[{"\[Eta]", "*", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Log", "[", 
              RowBox[{
               RowBox[{"transfery1CC13", "[", 
                RowBox[{"[", 
                 RowBox[{"2", ",", "8"}], "]"}], "]"}], "/", "MPI"}], "]"}], 
             "/", 
             RowBox[{"Log", "[", "2", "]"}]}], ")"}]}], "+", 
          RowBox[{"transfery1CC13", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "12"}], "]"}], "]"}]}], "/.", "parT131calb"}]}],
        ",", "\[IndentingNewLine]", 
       RowBox[{"Do", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"transfery1CC13", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", 
               RowBox[{"{", 
                RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "]"}], "]"}], "=", 
            RowBox[{
             RowBox[{
              RowBox[{"transfery1CC13", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "-", "1"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "]"}], "]"}], 
              ".", "b1calc"}], "+", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"1", ",", "0", ",", "0"}], "}"}], "*", 
              RowBox[{"transfery1CC13", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "-", "1"}], ",", "2"}], "]"}], "]"}]}]}]}], ",", 
           RowBox[{
            RowBox[{"transfery1CC13", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", 
               RowBox[{"{", 
                RowBox[{"8", ",", "9", ",", "10"}], "}"}]}], "]"}], "]"}], 
            "=", 
            RowBox[{
             RowBox[{
              RowBox[{"transfery1CC13", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "-", "1"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"8", ",", "9", ",", "10"}], "}"}]}], "]"}], "]"}], 
              ".", "b1calb"}], "+", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"1", ",", "0", ",", "0"}], "}"}], "*", 
              RowBox[{"transfery1CC13", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "-", "1"}], ",", "2"}], "]"}], "]"}]}]}]}], ",",
            "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"transfery1CC13", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", "13"}], "]"}], "]"}], "=", 
            RowBox[{
             RowBox[{
              RowBox[{"\[Eta]", "*", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"Log", "[", 
                  RowBox[{
                   RowBox[{"transfery1CC13", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "4"}], "]"}], "]"}], "/", "MPI"}], 
                  "]"}], "/", 
                 RowBox[{"Log", "[", "2", "]"}]}], ")"}]}], "+", 
              RowBox[{"transfery1CC13", "[", 
               RowBox[{"[", 
                RowBox[{"i", ",", "12"}], "]"}], "]"}]}], "/.", 
             "parT131calc"}]}], ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"transfery1CC13", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", "14"}], "]"}], "]"}], "=", 
            RowBox[{
             RowBox[{
              RowBox[{"\[Eta]", "*", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"Log", "[", 
                  RowBox[{
                   RowBox[{"transfery1CC13", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "4"}], "]"}], "]"}], "/", "MPI"}], 
                  "]"}], "/", 
                 RowBox[{"Log", "[", "2", "]"}]}], ")"}]}], "+", 
              RowBox[{"transfery1CC13", "[", 
               RowBox[{"[", 
                RowBox[{"i", ",", "12"}], "]"}], "]"}]}], "/.", 
             "parT131calb"}]}], ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"transfery1CC13", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", 
               RowBox[{"{", 
                RowBox[{"15", ",", "16"}], "}"}]}], "]"}], "]"}], "=", 
            RowBox[{
             RowBox[{
              RowBox[{"TransT131calc", ".", 
               RowBox[{"transfery1CC13", "[", 
                RowBox[{"[", 
                 RowBox[{
                  RowBox[{"i", "-", "1"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"15", ",", "16"}], "}"}]}], "]"}], "]"}]}], "+", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"1", ",", "0"}], "}"}], "*", "xi1", "*", 
               RowBox[{"transfery1CC13", "[", 
                RowBox[{"[", 
                 RowBox[{"i", ",", "13"}], "]"}], "]"}]}]}], "/.", 
             "parT131calc"}]}], ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"transfery1CC13", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", 
               RowBox[{"{", 
                RowBox[{"17", ",", "18"}], "}"}]}], "]"}], "]"}], "=", 
            RowBox[{
             RowBox[{
              RowBox[{"TransT131calb", ".", 
               RowBox[{"transfery1CC13", "[", 
                RowBox[{"[", 
                 RowBox[{
                  RowBox[{"i", "-", "1"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"17", ",", "18"}], "}"}]}], "]"}], "]"}]}], "+", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"1", ",", "0"}], "}"}], "*", "xi1", "*", 
               RowBox[{"transfery1CC13", "[", 
                RowBox[{"[", 
                 RowBox[{"i", ",", "14"}], "]"}], "]"}]}]}], "/.", 
             "parT131calb"}]}], ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"transfery1CC13", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", "7"}], "]"}], "]"}], "=", 
            RowBox[{
             RowBox[{"Total", "[", 
              RowBox[{"transfery1CC13", "[", 
               RowBox[{"[", 
                RowBox[{"i", ",", 
                 RowBox[{"{", 
                  RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "]"}], "]"}], 
              "]"}], "-", 
             RowBox[{"Total", "[", 
              RowBox[{"transfery1CC13", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "-", "1"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "]"}], "]"}], 
              "]"}]}]}], ",", 
           RowBox[{
            RowBox[{"transfery1CC13", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", "11"}], "]"}], "]"}], "=", 
            RowBox[{
             RowBox[{"Total", "[", 
              RowBox[{"transfery1CC13", "[", 
               RowBox[{"[", 
                RowBox[{"i", ",", 
                 RowBox[{"{", 
                  RowBox[{"8", ",", "9", ",", "10"}], "}"}]}], "]"}], "]"}], 
              "]"}], "-", 
             RowBox[{"Total", "[", 
              RowBox[{"transfery1CC13", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "-", "1"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"8", ",", "9", ",", "10"}], "}"}]}], "]"}], "]"}], 
              "]"}]}]}]}], "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"i", ",", "3", ",", "y"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"CW85Results", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;", "y"}], ",", 
           RowBox[{"k", "+", "3"}]}], "]"}], "]"}], "=", 
        RowBox[{"transfery1CC13", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;", "y"}], ",", "4"}], "]"}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"CW85Results", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;", "y"}], ",", 
           RowBox[{"k", "+", "4"}]}], "]"}], "]"}], "=", 
        RowBox[{"transfery1CC13", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;", "y"}], ",", "8"}], "]"}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"CW85Results", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;", "y"}], ",", 
           RowBox[{"k", "+", "10"}]}], "]"}], "]"}], "=", 
        RowBox[{"transfery1CC13", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;", "y"}], ",", "15"}], "]"}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"CW85Results", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;", "y"}], ",", 
           RowBox[{"k", "+", "11"}]}], "]"}], "]"}], "=", 
        RowBox[{"transfery1CC13", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;", "y"}], ",", "17"}], "]"}], "]"}]}]}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "1", ",", "1"}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.8172311946795764`*^9, 3.8172312213353*^9}, {
  3.8172312711628575`*^9, 3.817231332982591*^9}, {3.8172315544338975`*^9, 
  3.817231627210719*^9}, {3.817232060663287*^9, 3.8172320831769705`*^9}, {
  3.82336347329377*^9, 3.823363580819921*^9}, {3.8233639108756795`*^9, 
  3.82336396795576*^9}, {3.823365281642679*^9, 3.8233652932846956`*^9}, {
  3.824190871953808*^9, 3.824190875678615*^9}},
 CellLabel->
  "In[1980]:=",ExpressionUUID->"70005b8f-ce0f-477f-9b8e-a640762bc78d"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Do", "[", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"y", "=", "cwl"}], ",", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{
          RowBox[{"Dimensions", "[", "dataNorem", "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}], ","}], "*)"}], " ", 
       "\[IndentingNewLine]", 
       RowBox[{"transfery1CC07", "=", 
        RowBox[{"Table", "[", 
         RowBox[{"0", ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "y"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"j", ",", "18"}], "}"}]}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"transfery1CC07", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "=", 
        RowBox[{"{", 
         RowBox[{
         "\"\<1-Y\>\"", ",", "\"\<2-E\>\"", ",", "\"\<3-CDR\>\"", ",", 
          "\"\<4-MATc\>\"", ",", "\"\<5-MUPc\>\"", ",", "\"\<6-MLOc\>\"", 
          ",", "\"\<7-dC\>\"", ",", "\"\<8-MATb\>\"", ",", "\"\<9-MUPb\>\"", 
          ",", "\"\<10-MLOb\>\"", ",", "\"\<11-dC\>\"", ",", "\"\<12-Fex\>\"",
           ",", "\"\<13-Fc\>\"", ",", "\"\<14-Fb\>\"", ",", 
          "\"\<15-TempAc\>\"", ",", "\"\<16-TempOc\>\"", ",", 
          "\"\<17-TempAb\>\"", ",", "\"\<18-TempOb\>\""}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Do", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"transfery1CC07", "[", 
           RowBox[{"[", 
            RowBox[{"n", ",", "1"}], "]"}], "]"}], "=", 
          RowBox[{"2015", "+", "n", "-", "2"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "2", ",", "y"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"emcolumns", "=", 
         RowBox[{"{", "5", "}"}]}], ";", " ", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"2", ",", "3", ",", "4"}], "}"}], ";"}], "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"emissions1", "=", 
         RowBox[{"dataCW", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;", "cwl"}], ",", 
            RowBox[{"emcolumns", "[", 
             RowBox[{"[", "k", "]"}], "]"}]}], "]"}], "]"}]}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"transfery1CC07", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;", "y"}], ",", "2"}], "]"}], "]"}], "=", 
        "emissions1"}], ",", " ", 
       RowBox[{"(*", "Emissions", "*)"}], "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"transfery1CC07", "[", 
         RowBox[{"[", 
          RowBox[{"2", ",", 
           RowBox[{"{", 
            RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "]"}], "]"}], "=", 
        "intCC072015"}], ",", " ", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{
         "initial", " ", "carbon", " ", "values", " ", "for", " ", 
          "atmosphere"}], ",", " ", 
         RowBox[{"upper", " ", "ocean"}], ",", " ", 
         RowBox[{"lower", " ", "ocean"}]}], "*)"}], "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"transfery1CC07", "[", 
         RowBox[{"[", 
          RowBox[{"2", ",", 
           RowBox[{"{", 
            RowBox[{"8", ",", "9", ",", "10"}], "}"}]}], "]"}], "]"}], "=", 
        "intCC072015"}], ",", " ", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{
         "initial", " ", "carbon", " ", "values", " ", "for", " ", 
          "atmosphere"}], ",", " ", 
         RowBox[{"upper", " ", "ocean"}], ",", " ", 
         RowBox[{"lower", " ", "ocean"}]}], "*)"}], "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"transfery1CC07", "[", 
         RowBox[{"[", 
          RowBox[{"2", ",", 
           RowBox[{"{", 
            RowBox[{"15", ",", "16"}], "}"}]}], "]"}], "]"}], "=", 
        "TwoFexDice2015"}], ",", " ", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{"atmosphere", " ", "temperature"}], ",", " ", 
         RowBox[{"ocean", " ", "temperature"}]}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"transfery1CC07", "[", 
         RowBox[{"[", 
          RowBox[{"2", ",", 
           RowBox[{"{", 
            RowBox[{"17", ",", "18"}], "}"}]}], "]"}], "]"}], "=", 
        "TwoFexDice2015"}], ",", " ", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{"atmosphere", " ", "temperature"}], ",", " ", 
         RowBox[{"ocean", " ", "temperature"}]}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"fexcolumns", "=", 
          RowBox[{"{", 
           RowBox[{"40", ",", "44", ",", "45"}], "}"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"transfery1CC07", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"2", ";;", "y"}], ",", "12"}], "]"}], "]"}], "=", 
          RowBox[{"dataRCP1", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"2", ";;", "v3"}], ",", 
             RowBox[{"fexcolumns", "[", 
              RowBox[{"[", "k", "]"}], "]"}]}], "]"}], "]"}]}], ","}], "*)"}],
        "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"transfery1CC07", "[", 
         RowBox[{"[", 
          RowBox[{"2", ",", "13"}], "]"}], "]"}], "=", 
        RowBox[{
         RowBox[{
          RowBox[{"\[Eta]", "*", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Log", "[", 
              RowBox[{
               RowBox[{"transfery1CC07", "[", 
                RowBox[{"[", 
                 RowBox[{"2", ",", "4"}], "]"}], "]"}], "/", "MPI"}], "]"}], 
             "/", 
             RowBox[{"Log", "[", "2", "]"}]}], ")"}]}], "+", 
          RowBox[{"transfery1CC07", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "12"}], "]"}], "]"}]}], "/.", "parT071calc"}]}],
        ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"transfery1CC07", "[", 
         RowBox[{"[", 
          RowBox[{"2", ",", "14"}], "]"}], "]"}], "=", 
        RowBox[{
         RowBox[{
          RowBox[{"\[Eta]", "*", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Log", "[", 
              RowBox[{
               RowBox[{"transfery1CC07", "[", 
                RowBox[{"[", 
                 RowBox[{"2", ",", "8"}], "]"}], "]"}], "/", "MPI"}], "]"}], 
             "/", 
             RowBox[{"Log", "[", "2", "]"}]}], ")"}]}], "+", 
          RowBox[{"transfery1CC07", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "12"}], "]"}], "]"}]}], "/.", "parT071calb"}]}],
        ",", "\[IndentingNewLine]", 
       RowBox[{"Do", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"transfery1CC07", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", 
               RowBox[{"{", 
                RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "]"}], "]"}], "=", 
            RowBox[{
             RowBox[{
              RowBox[{"transfery1CC07", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "-", "1"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "]"}], "]"}], 
              ".", "d1calc"}], "+", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"1", ",", "0", ",", "0"}], "}"}], "*", 
              RowBox[{"transfery1CC07", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "-", "1"}], ",", "2"}], "]"}], "]"}]}]}]}], ",", 
           RowBox[{
            RowBox[{"transfery1CC07", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", 
               RowBox[{"{", 
                RowBox[{"8", ",", "9", ",", "10"}], "}"}]}], "]"}], "]"}], 
            "=", 
            RowBox[{
             RowBox[{
              RowBox[{"transfery1CC07", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "-", "1"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"8", ",", "9", ",", "10"}], "}"}]}], "]"}], "]"}], 
              ".", "d1calb"}], "+", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"1", ",", "0", ",", "0"}], "}"}], "*", 
              RowBox[{"transfery1CC07", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "-", "1"}], ",", "2"}], "]"}], "]"}]}]}]}], ",",
            "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"transfery1CC07", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", "13"}], "]"}], "]"}], "=", 
            RowBox[{
             RowBox[{
              RowBox[{"\[Eta]", "*", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"Log", "[", 
                  RowBox[{
                   RowBox[{"transfery1CC07", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "4"}], "]"}], "]"}], "/", "MPI"}], 
                  "]"}], "/", 
                 RowBox[{"Log", "[", "2", "]"}]}], ")"}]}], "+", 
              RowBox[{"transfery1CC07", "[", 
               RowBox[{"[", 
                RowBox[{"i", ",", "12"}], "]"}], "]"}]}], "/.", 
             "parT071calc"}]}], ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"transfery1CC07", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", "14"}], "]"}], "]"}], "=", 
            RowBox[{
             RowBox[{
              RowBox[{"\[Eta]", "*", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"Log", "[", 
                  RowBox[{
                   RowBox[{"transfery1CC07", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "4"}], "]"}], "]"}], "/", "MPI"}], 
                  "]"}], "/", 
                 RowBox[{"Log", "[", "2", "]"}]}], ")"}]}], "+", 
              RowBox[{"transfery1CC07", "[", 
               RowBox[{"[", 
                RowBox[{"i", ",", "12"}], "]"}], "]"}]}], "/.", 
             "parT071calb"}]}], ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"transfery1CC07", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", 
               RowBox[{"{", 
                RowBox[{"15", ",", "16"}], "}"}]}], "]"}], "]"}], "=", 
            RowBox[{
             RowBox[{
              RowBox[{"TransT071calc", ".", 
               RowBox[{"transfery1CC07", "[", 
                RowBox[{"[", 
                 RowBox[{
                  RowBox[{"i", "-", "1"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"15", ",", "16"}], "}"}]}], "]"}], "]"}]}], "+", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"1", ",", "0"}], "}"}], "*", "xi1", "*", 
               RowBox[{"transfery1CC07", "[", 
                RowBox[{"[", 
                 RowBox[{"i", ",", "13"}], "]"}], "]"}]}]}], "/.", 
             "parT071calc"}]}], ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"transfery1CC07", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", 
               RowBox[{"{", 
                RowBox[{"17", ",", "18"}], "}"}]}], "]"}], "]"}], "=", 
            RowBox[{
             RowBox[{
              RowBox[{"TransT071calb", ".", 
               RowBox[{"transfery1CC07", "[", 
                RowBox[{"[", 
                 RowBox[{
                  RowBox[{"i", "-", "1"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"17", ",", "18"}], "}"}]}], "]"}], "]"}]}], "+", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"1", ",", "0"}], "}"}], "*", "xi1", "*", 
               RowBox[{"transfery1CC07", "[", 
                RowBox[{"[", 
                 RowBox[{"i", ",", "14"}], "]"}], "]"}]}]}], "/.", 
             "parT071calb"}]}], ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"transfery1CC07", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", "7"}], "]"}], "]"}], "=", 
            RowBox[{
             RowBox[{"Total", "[", 
              RowBox[{"transfery1CC07", "[", 
               RowBox[{"[", 
                RowBox[{"i", ",", 
                 RowBox[{"{", 
                  RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "]"}], "]"}], 
              "]"}], "-", 
             RowBox[{"Total", "[", 
              RowBox[{"transfery1CC07", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "-", "1"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "]"}], "]"}], 
              "]"}]}]}], ",", 
           RowBox[{
            RowBox[{"transfery1CC07", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", "11"}], "]"}], "]"}], "=", 
            RowBox[{
             RowBox[{"Total", "[", 
              RowBox[{"transfery1CC07", "[", 
               RowBox[{"[", 
                RowBox[{"i", ",", 
                 RowBox[{"{", 
                  RowBox[{"8", ",", "9", ",", "10"}], "}"}]}], "]"}], "]"}], 
              "]"}], "-", 
             RowBox[{"Total", "[", 
              RowBox[{"transfery1CC07", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "-", "1"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"8", ",", "9", ",", "10"}], "}"}]}], "]"}], "]"}], 
              "]"}]}]}]}], "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"i", ",", "3", ",", "y"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"CW85Results", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;", "y"}], ",", 
           RowBox[{"k", "+", "5"}]}], "]"}], "]"}], "=", 
        RowBox[{"transfery1CC07", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;", "y"}], ",", "4"}], "]"}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"CW85Results", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;", "y"}], ",", 
           RowBox[{"k", "+", "6"}]}], "]"}], "]"}], "=", 
        RowBox[{"transfery1CC07", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;", "y"}], ",", "8"}], "]"}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"CW85Results", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;", "y"}], ",", 
           RowBox[{"k", "+", "12"}]}], "]"}], "]"}], "=", 
        RowBox[{"transfery1CC07", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;", "y"}], ",", "15"}], "]"}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"CW85Results", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;", "y"}], ",", 
           RowBox[{"k", "+", "13"}]}], "]"}], "]"}], "=", 
        RowBox[{"transfery1CC07", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;", "y"}], ",", "17"}], "]"}], "]"}]}]}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "1", ",", "1"}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.8172328860915947`*^9, 3.8172328901397295`*^9}, {
  3.8172330384503593`*^9, 3.81723308849992*^9}, {3.8172333876348906`*^9, 
  3.8172334452794604`*^9}, {3.8172335594616413`*^9, 3.817233637779185*^9}, {
  3.81723375617695*^9, 3.817233756743413*^9}, {3.817233857752122*^9, 
  3.8172338587553453`*^9}, {3.8172344850450583`*^9, 3.817234493145195*^9}, {
  3.81723464737422*^9, 3.8172347263653665`*^9}, {3.817235016411627*^9, 
  3.8172350486881227`*^9}, {3.823364467721467*^9, 3.8233646089196653`*^9}, {
  3.8233653022157087`*^9, 3.823365312477723*^9}, {3.8241908883722*^9, 
  3.8241908927523007`*^9}},
 CellLabel->
  "In[1981]:=",ExpressionUUID->"2eb790b3-0af1-46a8-84e2-2804457bc858"],

Cell[BoxData[{
 RowBox[{"cwoFexstartvalues2015", "=", 
  RowBox[{"IVFairwoFex2015", "[", 
   RowBox[{"[", 
    RowBox[{"2", ",", 
     RowBox[{"3", ";;", "6"}]}], "]"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"ccawoFexstartvalues2015", "=", 
  RowBox[{"IVFairwoFex2015", "[", 
   RowBox[{"[", 
    RowBox[{"2", ",", "8"}], "]"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"twoFexstartvalues2015", "=", 
  RowBox[{"IVFairwoFex2015", "[", 
   RowBox[{"[", 
    RowBox[{"2", ",", 
     RowBox[{"12", ";;", "15"}]}], "]"}], "]"}]}]}], "Input",ExpressionUUID->\
"2239a459-7b46-44a8-9d19-434e9398606e"],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"y", "=", "cwl"}], ",", "\[IndentingNewLine]", 
     RowBox[{"transFairG", "=", 
      RowBox[{"Table", "[", 
       RowBox[{"0", ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "y"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"j", ",", "20"}], "}"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"transFairG", "[", 
       RowBox[{"[", "1", "]"}], "]"}], "=", 
      RowBox[{"{", 
       RowBox[{
       "\"\<1-Y\>\"", ",", "\"\<2-E\>\"", ",", "\"\<3-R1\>\"", ",", 
        "\"\<4-R2\>\"", ",", "\"\<5-R3\>\"", ",", "\"\<6-R4\>\"", ",", 
        "\"\<7-C\>\"", ",", "\"\<8-CCA\>\"", ",", "\"\<9-F\>\"", ",", 
        "\"\<10-Fex\>\"", ",", "\"\<11-TF\>\"", ",", "\"\<12-TMF\>\"", ",", 
        "\"\<13-TMS\>\"", ",", "\"\<14-TDF\>\"", ",", "\"\<15-TDS\>\"", ",", 
        "\"\<16-TM\>\"", ",", "\"\<17-TD\>\"", ",", "\"\<18-\[Alpha]\>\"", 
        ",", "\"\<19-\[Alpha]check\>\"", ",", "\"\<20-atmosGt\>\""}], "}"}]}],
      ",", "\[IndentingNewLine]", 
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"transFairG", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"n", "+", "1"}], ",", "1"}], "]"}], "]"}], "=", 
        RowBox[{"2015", "-", "1", "+", "n"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "1", ",", 
         RowBox[{"y", "-", "1"}]}], "}"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"emcolumns", "=", 
      RowBox[{"{", "5", "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{
       RowBox[{
        RowBox[{"transFairG", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;"}], ",", "2"}], "]"}], "]"}], "=", 
        RowBox[{
         RowBox[{"dtemp", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;"}], ",", "3"}], "]"}], "]"}], "/", "2.12"}]}], 
       ","}], "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"transFairG", "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{"2", ";;", "y"}], ",", "2"}], "]"}], "]"}], "=", 
      RowBox[{
       RowBox[{"dataCW", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", 
          RowBox[{"emcolumns", "[", 
           RowBox[{"[", "k", "]"}], "]"}]}], "]"}], "]"}], "/", 
       "2.1293970467500096"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"transFairG", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "4", ",", "5", ",", "6"}], "}"}]}], "]"}], "]"}], 
      "=", "cwoFexstartvalues2015"}], ",", " ", 
     RowBox[{"(*", 
      RowBox[{
       RowBox[{
       "initial", " ", "carbon", " ", "values", " ", "for", " ", "R1"}], ",", 
       "R2", ",", "R3", ",", "R4"}], "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"transFairG", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", "7"}], "]"}], "]"}], "=", 
      RowBox[{
       RowBox[{"Total", "[", 
        RowBox[{"transFairG", "[", 
         RowBox[{"[", 
          RowBox[{"2", ",", 
           RowBox[{"3", ";;", "6"}]}], "]"}], "]"}], "]"}], "+", 
       "278.0014091894"}]}], ",", " ", 
     RowBox[{"(*", 
      RowBox[{
      "initial", " ", "atmospheric", " ", "carbon", " ", "concentration"}], 
      "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"transFairG", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", "8"}], "]"}], "]"}], "=", 
      "ccawoFexstartvalues2015"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"transFairG", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", "9"}], "]"}], "]"}], "=", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"F2x", "/", 
          RowBox[{"Log", "[", "2", "]"}]}], ")"}], "*", 
        RowBox[{"Log", "[", 
         RowBox[{
          RowBox[{"transFairG", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "7"}], "]"}], "]"}], "/", "278"}], "]"}]}], "/.",
        "parFair"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{
       RowBox[{"fexcolumns", "=", 
        RowBox[{"{", 
         RowBox[{"8", ",", "9", ",", "10", ",", "11", ",", "12", ",", "13"}], 
         "}"}]}], ","}], "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"transFairG", "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{"2", ";;"}], ",", "10"}], "]"}], "]"}], "=", "0"}], ",", 
     RowBox[{"(*", 
      RowBox[{
       RowBox[{"dataCBA", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;", "92"}], ",", 
          RowBox[{"fexcolumns", "[", 
           RowBox[{"[", "k", "]"}], "]"}]}], "]"}], "]"}], ","}], "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"transFairG", "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{"2", ";;"}], ",", "11"}], "]"}], "]"}], "=", 
      RowBox[{"Total", "[", 
       RowBox[{"transFairG", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", 
          RowBox[{"9", ";;", "10"}]}], "]"}], "]"}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"transFairG", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", 
         RowBox[{"{", 
          RowBox[{"12", ",", "13", ",", "14", ",", "15"}], "}"}]}], "]"}], 
       "]"}], "=", "twoFexstartvalues2015"}], ",", " ", 
     RowBox[{"(*", 
      RowBox[{
      "initial", " ", "values", " ", "for", " ", "Mix", " ", "Layer", " ", 
       "Fast", " ", "and", " ", "Slow", " ", "Response", " ", "and", " ", 
       "Deep", " ", "Layer", " ", "Fast", " ", "and", " ", "Slow", " ", 
       "Response"}], "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"transFairG", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", "16"}], "]"}], "]"}], "=", 
      RowBox[{"Total", "[", 
       RowBox[{"transFairG", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", 
          RowBox[{"12", ";;", "13"}]}], "]"}], "]"}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"transFairG", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", "17"}], "]"}], "]"}], "=", 
      RowBox[{"Total", "[", 
       RowBox[{"transFairG", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", 
          RowBox[{"14", ";;", "15"}]}], "]"}], "]"}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"transFairG", "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{"2", ";;"}], ",", "18"}], "]"}], "]"}], "=", 
      RowBox[{
       RowBox[{"FindRoot", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"rirf", "[", 
           RowBox[{
            RowBox[{"transFairG", "[", 
             RowBox[{"[", 
              RowBox[{"2", ",", "8"}], "]"}], "]"}], ",", 
            RowBox[{"transFairG", "[", 
             RowBox[{"[", 
              RowBox[{"2", ",", "16"}], "]"}], "]"}]}], "]"}], "\[Equal]", 
          RowBox[{"lirf", "[", "\[Alpha]", "]"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"\[Alpha]", ",", "0.2"}], "}"}]}], "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "2"}], "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"transFairG", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", "19"}], "]"}], "]"}], "=", 
      RowBox[{"transFairG", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", "18"}], "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"transFairG", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", 
             RowBox[{"3", ";;", "6"}]}], "]"}], "]"}], "=", 
          RowBox[{
           RowBox[{"transFairG", "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"i", "-", "1"}], ",", 
              RowBox[{"3", ";;", "6"}]}], "]"}], "]"}], "+", 
           RowBox[{"dr", "[", 
            RowBox[{"aFair", ",", "\[Tau]Fair", ",", 
             RowBox[{"transFairG", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"i", "-", "1"}], ",", "18"}], "]"}], "]"}], ",", 
             RowBox[{"transFairG", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "2"}], "]"}], "]"}], ",", 
             RowBox[{"transFairG", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"i", "-", "1"}], ",", 
                RowBox[{"3", ";;", "6"}]}], "]"}], "]"}]}], "]"}]}]}], ",", 
         RowBox[{
          RowBox[{"transFairG", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "7"}], "]"}], "]"}], "=", 
          RowBox[{"278.0014091894", "+", 
           RowBox[{"Total", "[", 
            RowBox[{"transFairG", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", 
               RowBox[{"3", ";;", "6"}]}], "]"}], "]"}], "]"}]}]}], ",", 
         RowBox[{
          RowBox[{"transFairG", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "8"}], "]"}], "]"}], "=", 
          RowBox[{
           RowBox[{"transFairG", "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"i", "-", "1"}], ",", "8"}], "]"}], "]"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"transFairG", "[", 
               RowBox[{"[", 
                RowBox[{"i", ",", "2"}], "]"}], "]"}], "-", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"transFairG", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", ",", "7"}], "]"}], "]"}], "-", 
                RowBox[{"transFairG", "[", 
                 RowBox[{"[", 
                  RowBox[{
                   RowBox[{"i", "-", "1"}], ",", "7"}], "]"}], "]"}]}], 
               ")"}]}], ")"}], "*", "2.12"}]}]}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"transFairG", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "9"}], "]"}], "]"}], "=", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"F2x", "/", 
              RowBox[{"Log", "[", "2", "]"}]}], ")"}], "*", 
            RowBox[{"Log", "[", 
             RowBox[{
              RowBox[{"transFairG", "[", 
               RowBox[{"[", 
                RowBox[{"i", ",", "7"}], "]"}], "]"}], "/", 
              "278.0014091894"}], "]"}]}], "/.", "parFair"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"transFairG", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "11"}], "]"}], "]"}], "=", 
          RowBox[{"Total", "[", 
           RowBox[{"transFairG", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", 
              RowBox[{"9", ";;", "10"}]}], "]"}], "]"}], "]"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"transFairG", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "12"}], "]"}], "]"}], "=", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"expf", "*", 
              RowBox[{"transFairG", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "-", "1"}], ",", "12"}], "]"}], "]"}]}], "+", 
             RowBox[{"amixf", "*", "intf"}]}], "/.", 
            RowBox[{"f0", "\[Rule]", 
             RowBox[{"transFairG", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"i", "-", "1"}], ",", "11"}], "]"}], "]"}]}]}], "/.", 
           RowBox[{"f1", "\[Rule]", 
            RowBox[{"transFairG", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", "11"}], "]"}], "]"}]}]}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"transFairG", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "13"}], "]"}], "]"}], "=", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"exps", "*", 
              RowBox[{"transFairG", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "-", "1"}], ",", "13"}], "]"}], "]"}]}], "+", 
             RowBox[{"amixs", "*", "ints"}]}], "/.", 
            RowBox[{"f0", "\[Rule]", 
             RowBox[{"transFairG", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"i", "-", "1"}], ",", "11"}], "]"}], "]"}]}]}], "/.", 
           RowBox[{"f1", "\[Rule]", 
            RowBox[{"transFairG", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", "11"}], "]"}], "]"}]}]}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"transFairG", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "14"}], "]"}], "]"}], "=", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"expf", "*", 
              RowBox[{"transFairG", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "-", "1"}], ",", "14"}], "]"}], "]"}]}], "+", 
             RowBox[{"adeepf", "*", "intf"}]}], "/.", 
            RowBox[{"f0", "\[Rule]", 
             RowBox[{"transFairG", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"i", "-", "1"}], ",", "11"}], "]"}], "]"}]}]}], "/.", 
           RowBox[{"f1", "\[Rule]", 
            RowBox[{"transFairG", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", "11"}], "]"}], "]"}]}]}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"transFairG", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "15"}], "]"}], "]"}], "=", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"exps", "*", 
              RowBox[{"transFairG", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "-", "1"}], ",", "15"}], "]"}], "]"}]}], "+", 
             RowBox[{"adeeps", "*", "ints"}]}], "/.", 
            RowBox[{"f0", "\[Rule]", 
             RowBox[{"transFairG", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"i", "-", "1"}], ",", "11"}], "]"}], "]"}]}]}], "/.", 
           RowBox[{"f1", "\[Rule]", 
            RowBox[{"transFairG", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", "11"}], "]"}], "]"}]}]}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"transFairG", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "16"}], "]"}], "]"}], "=", 
          RowBox[{"Total", "[", 
           RowBox[{"transFairG", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", 
              RowBox[{"12", ";;", "13"}]}], "]"}], "]"}], "]"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"transFairG", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "17"}], "]"}], "]"}], "=", 
          RowBox[{"Total", "[", 
           RowBox[{"transFairG", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", 
              RowBox[{"14", ";;", "15"}]}], "]"}], "]"}], "]"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"(*", 
          RowBox[{
           RowBox[{
            RowBox[{"transFairG", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", 
               RowBox[{"{", 
                RowBox[{"11", ",", "12"}], "}"}]}], "]"}], "]"}], "=", 
            RowBox[{
             RowBox[{
              RowBox[{"transT", ".", 
               RowBox[{"transFairG", "[", 
                RowBox[{"[", 
                 RowBox[{
                  RowBox[{"i", "-", "1"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"11", ",", "12"}], "}"}]}], "]"}], "]"}]}], "+", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"1", ",", "0"}], "}"}], "*", "xi1", "*", 
               RowBox[{"Total", "[", 
                RowBox[{"transFairG", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", ",", 
                   RowBox[{"9", ";;", "10"}]}], "]"}], "]"}], "]"}]}]}], "/.",
              "parTG"}]}], ","}], "\[IndentingNewLine]", 
          RowBox[{"(*", 
           RowBox[{
            RowBox[{
             RowBox[{"transFairG", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "13"}], "]"}], "]"}], "=", 
             RowBox[{"Total", "[", 
              RowBox[{"transFairG", "[", 
               RowBox[{"[", 
                RowBox[{"i", ",", 
                 RowBox[{"11", ";;", "12"}]}], "]"}], "]"}], "]"}]}], ","}], 
           "*)"}], "*)"}], "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"transFairG", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "18"}], "]"}], "]"}], "=", 
          RowBox[{
           RowBox[{"FindRoot", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"rirf", "[", 
               RowBox[{
                RowBox[{"transFairG", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", ",", "8"}], "]"}], "]"}], ",", 
                RowBox[{"transFairG", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", ",", "16"}], "]"}], "]"}]}], "]"}], "\[Equal]", 
              RowBox[{"lirf", "[", "\[Alpha]", "]"}]}], ",", 
             RowBox[{"{", 
              RowBox[{"\[Alpha]", ",", 
               RowBox[{"transFairG", "[", 
                RowBox[{"[", 
                 RowBox[{
                  RowBox[{"i", "-", "1"}], ",", "18"}], "]"}], "]"}]}], 
              "}"}]}], "]"}], "[", 
           RowBox[{"[", 
            RowBox[{"1", ",", "2"}], "]"}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"transFairG", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "19"}], "]"}], "]"}], "=", 
          RowBox[{
           RowBox[{
            RowBox[{"transFairG", "[", 
             RowBox[{"[", 
              RowBox[{
               RowBox[{"i", "-", "1"}], ",", "19"}], "]"}], "]"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"rT", "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"transFairG", "[", 
                   RowBox[{"[", 
                    RowBox[{"i", ",", "16"}], "]"}], "]"}], "-", 
                  RowBox[{"transFairG", "[", 
                   RowBox[{"[", 
                    RowBox[{
                    RowBox[{"i", "-", "1"}], ",", "16"}], "]"}], "]"}]}], 
                 ")"}]}], "+", 
               RowBox[{"rc", "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"transFairG", "[", 
                   RowBox[{"[", 
                    RowBox[{"i", ",", "8"}], "]"}], "]"}], "-", 
                  RowBox[{"transFairG", "[", 
                   RowBox[{"[", 
                    RowBox[{
                    RowBox[{"i", "-", "1"}], ",", "8"}], "]"}], "]"}]}], 
                 ")"}]}]}], ")"}], "/", 
             RowBox[{"(", 
              RowBox[{"dalpha", "[", 
               RowBox[{"transFairG", "[", 
                RowBox[{"[", 
                 RowBox[{
                  RowBox[{"i", "-", "1"}], ",", "19"}], "]"}], "]"}], "]"}], 
              ")"}]}]}], "/.", "parFair"}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "3", ",", "cwl"}], "}"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"transFairG", "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{"2", ";;"}], ",", "20"}], "]"}], "]"}], "=", 
      RowBox[{
       RowBox[{"transFairG", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", "7"}], "]"}], "]"}], "*", "2.12"}]}], ",",
      "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CW85Results", "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{"2", ";;"}], ",", 
         RowBox[{"k", "+", "7"}]}], "]"}], "]"}], "=", 
      RowBox[{"transFairG", "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{"2", ";;"}], ",", "20"}], "]"}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CW85Results", "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{"2", ";;"}], ",", 
         RowBox[{"k", "+", "14"}]}], "]"}], "]"}], "=", 
      RowBox[{"transFairG", "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{"2", ";;"}], ",", "16"}], "]"}], "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "1", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.810280473345899*^9, 3.810280835289139*^9}, {
   3.8103641075717745`*^9, 3.810364110692772*^9}, {3.81036883002244*^9, 
   3.8103688305164795`*^9}, {3.8109597437819242`*^9, 
   3.8109597443484993`*^9}, {3.8126087024628897`*^9, 
   3.8126088027229705`*^9}, {3.8126089125388813`*^9, 3.812608914625472*^9}, {
   3.8133342934321384`*^9, 3.813334420216504*^9}, {3.8133344881701365`*^9, 
   3.813334619140195*^9}, {3.81333853388776*^9, 3.813338608697424*^9}, {
   3.813338681538455*^9, 3.813338685953352*^9}, {3.813338943353011*^9, 
   3.8133389926475935`*^9}, {3.813339447165347*^9, 3.8133394617685184`*^9}, {
   3.813339494809816*^9, 3.8133398477767277`*^9}, {3.8133399070193973`*^9, 
   3.8133399167065544`*^9}, {3.813339954815693*^9, 3.8133399781247263`*^9}, {
   3.8133403577092*^9, 3.8133403587043533`*^9}, {3.813340638363896*^9, 
   3.8133406723371153`*^9}, {3.8133461297614355`*^9, 3.813346237438306*^9}, {
   3.813346311469352*^9, 3.813346313427952*^9}, {3.813346478244486*^9, 
   3.8133464786699057`*^9}, {3.813512800860598*^9, 3.8135128045530205`*^9}, {
   3.8135129613335967`*^9, 3.813512967665472*^9}, {3.813513131335656*^9, 
   3.8135132059702077`*^9}, {3.813513448868885*^9, 3.8135134951501684`*^9}, {
   3.813513585711378*^9, 3.8135136559666605`*^9}, {3.813514076073622*^9, 
   3.8135140787416267`*^9}, {3.813516095289074*^9, 3.81351609572066*^9}, {
   3.8166392503253765`*^9, 3.8166392505416813`*^9}, {3.8166393846856313`*^9, 
   3.816639396927516*^9}, {3.816718495005973*^9, 3.816718499048741*^9}, {
   3.8167192008104115`*^9, 3.816719215239213*^9}, {3.8167192603891344`*^9, 
   3.81671929609338*^9}, {3.81671934571107*^9, 3.8167194515233183`*^9}, {
   3.8167195145526047`*^9, 3.81671951488964*^9}, {3.816719824013314*^9, 
   3.8167198871627383`*^9}, {3.817139186070547*^9, 3.817139191263028*^9}, 
   3.8171399022037325`*^9, {3.8172394370831194`*^9, 3.817239467874445*^9}, {
   3.8172399276347847`*^9, 3.817239975185067*^9}, {3.817240023461197*^9, 
   3.8172400612357087`*^9}, {3.8172401019563017`*^9, 
   3.8172401025560985`*^9}, {3.8233649005810847`*^9, 
   3.8233649121021013`*^9}, {3.82336502974327*^9, 3.8233651138463883`*^9}, {
   3.824190968772769*^9, 3.8241909856882954`*^9}},
 CellLabel->
  "In[1982]:=",ExpressionUUID->"3d2678de-74f3-4179-93ae-d85501128dbf"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<CW85Results.csv\>\"", ",", "CW85Results"}], "]"}]], "Input",
 CellChangeTimes->{{3.823449601878076*^9, 3.823449626713111*^9}},
 CellLabel->
  "In[1983]:=",ExpressionUUID->"bbdfaa4a-1b08-41f2-8030-7c24602da134"],

Cell[BoxData["\<\"CW85Results.csv\"\>"], "Output",
 CellChangeTimes->{3.8234496287031136`*^9, 3.8241910030237904`*^9},
 CellLabel->
  "Out[1983]=",ExpressionUUID->"fb822d10-b8aa-4a6c-9591-54bc6fb2e754"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CW85Results", "[", 
   RowBox[{"[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "87", ",", "187", ",", "287"}], "}"}], "]"}],
    "]"}], "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.823365357374786*^9, 3.823365424703881*^9}},
 CellLabel->
  "In[1984]:=",ExpressionUUID->"7a3a07cd-b195-4fd0-8dd2-f708aeaf2704"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"\<\"1-year\"\>", "\<\"2-C-CC16c\"\>", "\<\"3-C-CC16b\"\>", \
"\<\"4-C-CC13c\"\>", "\<\"5-C-CC13b\"\>", "\<\"6-C-CC07c\"\>", "\<\"7-C-CC07b\
\"\>", "\<\"8-C-FG\"\>", "\<\"9-T-CC16c\"\>", "\<\"10-T-CC16b\"\>", \
"\<\"11-T-CC13c\"\>", "\<\"12-T-CC13b\"\>", "\<\"13-T-CC07c\"\>", \
"\<\"14-T-CC07b\"\>", "\<\"15-T-FG\"\>"},
     {"2015", "843.418577104893`", "843.418577104893`", "843.418577104893`", 
      "843.418577104893`", "843.418577104893`", "843.418577104893`", 
      "843.418577104893`", "0.9644763159953804`", "0.9644763159953804`", 
      "0.9644763159953804`", "0.9644763159953804`", "0.9644763159953804`", 
      "0.9644763159953804`", "0.9644763159953804`"},
     {"2100", "891.3468446796244`", "892.0779849028004`", 
      "790.9425019375955`", "794.6750513945208`", "766.2516799967838`", 
      "767.5274230072116`", "830.6933621646323`", "1.72378274431113`", 
      "1.720050598695086`", "1.3210599032353156`", "1.3290762123794961`", 
      "1.1499285002370305`", "1.0657276566020681`", "1.1573786378018958`"},
     {"2200", "876.5735081222009`", "877.4773673076253`", 
      "762.6227610197643`", "763.5154633642675`", "712.6043678211448`", 
      "688.1364403304391`", "802.603220750293`", "1.7516182265191467`", 
      "1.7355300612517273`", "1.1059677655495748`", "1.1056436106154448`", 
      "0.8811905199515626`", "0.8600495473688763`", "1.1748690801377026`"},
     {"2300", "863.1238005547223`", "864.4265797436677`", 
      "755.3489024243156`", "755.9195881779503`", "680.8402540263622`", 
      "650.1318060653351`", "785.0530407488656`", "1.7125682751430025`", 
      "1.6977957730967395`", "1.0543495452633893`", "1.0521539186195084`", 
      "0.7175556577430108`", "0.6999294365292246`", "1.177873616827193`"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.8233646317136974`*^9, {3.8233653340617533`*^9, 3.8233653585947876`*^9}, {
   3.823365389968832*^9, 3.8233654256638823`*^9}, 3.8241910057840567`*^9},
 CellLabel->
  "Out[1984]//MatrixForm=",ExpressionUUID->"bfe342f4-5c2d-4709-a628-\
8f002da72ad1"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"CWtable", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "9"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CWtable", "[", 
    RowBox[{"[", "1", "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
    "\"\<\>\"", ",", "\"\<deltaC2100\>\"", ",", "\"\<deltaC2200\>\"", ",", 
     "\"\<deltaC2300\>\"", ",", "\"\<deltaCmax\>\"", ",", 
     "\"\<deltaT2100\>\"", ",", "\"\<deltaT2200\>\"", ",", 
     "\"\<deltaT2300\>\"", ",", "\"\<deltaTmax\>\""}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CWtable", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "1"}], "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
    "\"\<CC16c\>\"", ",", "\"\<CC16b\>\"", ",", "\"\<CC13c\>\"", ",", 
     "\"\<CC13b\>\"", ",", "\"\<CC07c\>\"", ",", "\"\<CC07b\>\"", ",", 
     "\"\<FG\>\""}], "}"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.8233659498906207`*^9, 3.8233661827359486`*^9}},
 CellLabel->
  "In[1985]:=",ExpressionUUID->"5f1c51a7-89f3-4982-b205-6407fb116266"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"CWtable", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "2"}], "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"CW85Results", "[", 
     RowBox[{"[", 
      RowBox[{"87", ",", 
       RowBox[{"2", ";;", "8"}]}], "]"}], "]"}], "-", 
    RowBox[{"CW85Results", "[", 
     RowBox[{"[", 
      RowBox[{"2", ",", 
       RowBox[{"2", ";;", "8"}]}], "]"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CWtable", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "3"}], "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"CW85Results", "[", 
     RowBox[{"[", 
      RowBox[{"187", ",", 
       RowBox[{"2", ";;", "8"}]}], "]"}], "]"}], "-", 
    RowBox[{"CW85Results", "[", 
     RowBox[{"[", 
      RowBox[{"2", ",", 
       RowBox[{"2", ";;", "8"}]}], "]"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CWtable", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "4"}], "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"CW85Results", "[", 
     RowBox[{"[", 
      RowBox[{"287", ",", 
       RowBox[{"2", ";;", "8"}]}], "]"}], "]"}], "-", 
    RowBox[{"CW85Results", "[", 
     RowBox[{"[", 
      RowBox[{"2", ",", 
       RowBox[{"2", ";;", "8"}]}], "]"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CWtable", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "6"}], "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"CW85Results", "[", 
     RowBox[{"[", 
      RowBox[{"87", ",", 
       RowBox[{"9", ";;", "15"}]}], "]"}], "]"}], "-", 
    RowBox[{"CW85Results", "[", 
     RowBox[{"[", 
      RowBox[{"2", ",", 
       RowBox[{"9", ";;", "15"}]}], "]"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CWtable", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "7"}], "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"CW85Results", "[", 
     RowBox[{"[", 
      RowBox[{"187", ",", 
       RowBox[{"9", ";;", "15"}]}], "]"}], "]"}], "-", 
    RowBox[{"CW85Results", "[", 
     RowBox[{"[", 
      RowBox[{"2", ",", 
       RowBox[{"9", ";;", "15"}]}], "]"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CWtable", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "8"}], "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"CW85Results", "[", 
     RowBox[{"[", 
      RowBox[{"287", ",", 
       RowBox[{"9", ";;", "15"}]}], "]"}], "]"}], "-", 
    RowBox[{"CW85Results", "[", 
     RowBox[{"[", 
      RowBox[{"2", ",", 
       RowBox[{"9", ";;", "15"}]}], "]"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"CWtable", "[", 
      RowBox[{"[", 
       RowBox[{
        RowBox[{"i", ";;"}], ",", "5"}], "]"}], "]"}], "=", 
     RowBox[{
      RowBox[{"Max", "[", 
       RowBox[{"CW85Results", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", "i"}], "]"}], "]"}], "]"}], "-", 
      RowBox[{"CW85Results", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", "i"}], "]"}], "]"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "2", ",", "8"}], "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"CWtable", "[", 
      RowBox[{"[", 
       RowBox[{
        RowBox[{"i", ";;"}], ",", "9"}], "]"}], "]"}], "=", 
     RowBox[{
      RowBox[{"Max", "[", 
       RowBox[{"CW85Results", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", 
          RowBox[{"i", "+", "7"}]}], "]"}], "]"}], "]"}], "-", 
      RowBox[{"CW85Results", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", 
         RowBox[{"i", "+", "7"}]}], "]"}], "]"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "2", ",", "8"}], "}"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.8233662733760777`*^9, 3.823366328833156*^9}, {
  3.8233663645882063`*^9, 3.8233663905932426`*^9}, {3.823366737550731*^9, 
  3.823366815830841*^9}},
 CellLabel->
  "In[1988]:=",ExpressionUUID->"082f4812-bb3f-4cd1-a234-02a0c6749953"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"CW85Results", "[", 
  RowBox[{"[", 
   RowBox[{
    RowBox[{"10", "+", 
     RowBox[{
      RowBox[{"Position", "[", 
       RowBox[{
        RowBox[{"Abs", "[", 
         RowBox[{
          RowBox[{"CW85Results", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"10", ";;"}], ",", "4"}], "]"}], "]"}], "-", 
          RowBox[{"CW85Results", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "4"}], "]"}], "]"}]}], "]"}], ",", 
        RowBox[{"Min", "[", 
         RowBox[{"Abs", "[", 
          RowBox[{
           RowBox[{"CW85Results", "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"10", ";;"}], ",", "4"}], "]"}], "]"}], "-", 
           RowBox[{"CW85Results", "[", 
            RowBox[{"[", 
             RowBox[{"2", ",", "4"}], "]"}], "]"}]}], "]"}], "]"}]}], "]"}], 
      "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ",", "1"}], "]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"CW85Results", "[", 
  RowBox[{"[", 
   RowBox[{
    RowBox[{"10", "+", 
     RowBox[{
      RowBox[{"Position", "[", 
       RowBox[{
        RowBox[{"Abs", "[", 
         RowBox[{
          RowBox[{"CW85Results", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"10", ";;"}], ",", "6"}], "]"}], "]"}], "-", 
          RowBox[{"CW85Results", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "6"}], "]"}], "]"}]}], "]"}], ",", 
        RowBox[{"Min", "[", 
         RowBox[{"Abs", "[", 
          RowBox[{
           RowBox[{"CW85Results", "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"10", ";;"}], ",", "6"}], "]"}], "]"}], "-", 
           RowBox[{"CW85Results", "[", 
            RowBox[{"[", 
             RowBox[{"2", ",", "6"}], "]"}], "]"}]}], "]"}], "]"}]}], "]"}], 
      "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ",", "1"}], "]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"CW85Results", "[", 
  RowBox[{"[", 
   RowBox[{
    RowBox[{"10", "+", 
     RowBox[{
      RowBox[{"Position", "[", 
       RowBox[{
        RowBox[{"Abs", "[", 
         RowBox[{
          RowBox[{"CW85Results", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"10", ";;"}], ",", "8"}], "]"}], "]"}], "-", 
          RowBox[{"CW85Results", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "8"}], "]"}], "]"}]}], "]"}], ",", 
        RowBox[{"Min", "[", 
         RowBox[{"Abs", "[", 
          RowBox[{
           RowBox[{"CW85Results", "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"10", ";;"}], ",", "8"}], "]"}], "]"}], "-", 
           RowBox[{"CW85Results", "[", 
            RowBox[{"[", 
             RowBox[{"2", ",", "8"}], "]"}], "]"}]}], "]"}], "]"}]}], "]"}], 
      "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ",", "1"}], "]"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.823367477861828*^9, 3.8233675528009334`*^9}, {
   3.823367589957986*^9, 3.823367688663125*^9}, {3.8233677353491907`*^9, 
   3.8233678080162964`*^9}, 3.8242306778283195`*^9, {3.824230738878247*^9, 
   3.824230755698344*^9}, {3.8242308004681273`*^9, 
   3.824230802328452*^9}},ExpressionUUID->"f3fa46c5-a34c-45e9-86d9-\
80d2bdb61776"],

Cell[BoxData["2059"], "Output",
 CellChangeTimes->{{3.823367540159916*^9, 3.8233675536319346`*^9}, {
   3.823367618482026*^9, 3.823367689583126*^9}, 3.8233677609622264`*^9, 
   3.8233678086662974`*^9, 3.824191026586739*^9, 3.8242306656379423`*^9, {
   3.8242307419781623`*^9, 3.824230756698397*^9}},
 CellLabel->
  "Out[2064]=",ExpressionUUID->"8d49040c-7931-44ab-861a-c62b3d0a4a7d"],

Cell[BoxData["2051"], "Output",
 CellChangeTimes->{{3.823367540159916*^9, 3.8233675536319346`*^9}, {
   3.823367618482026*^9, 3.823367689583126*^9}, 3.8233677609622264`*^9, 
   3.8233678086662974`*^9, 3.824191026586739*^9, 3.8242306656379423`*^9, {
   3.8242307419781623`*^9, 3.824230756708187*^9}},
 CellLabel->
  "Out[2065]=",ExpressionUUID->"96c07dec-ce8a-478f-a800-0d29ea250837"],

Cell[BoxData["2076"], "Output",
 CellChangeTimes->{{3.823367540159916*^9, 3.8233675536319346`*^9}, {
   3.823367618482026*^9, 3.823367689583126*^9}, 3.8233677609622264`*^9, 
   3.8233678086662974`*^9, 3.824191026586739*^9, 3.8242306656379423`*^9, {
   3.8242307419781623`*^9, 3.824230756708187*^9}},
 CellLabel->
  "Out[2066]=",ExpressionUUID->"cf1f90c8-30bd-4b20-9c19-134c7244456e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CW85Results", "[", 
  RowBox[{"[", 
   RowBox[{"2", ",", "9"}], "]"}], "]"}]], "Input",
 CellLabel->
  "In[2120]:=",ExpressionUUID->"9badd38a-d8c4-45fd-afe7-6372e7bed173"],

Cell[BoxData["0.9644763159953804`"], "Output",
 CellChangeTimes->{3.8242340524142857`*^9},
 CellLabel->
  "Out[2120]=",ExpressionUUID->"853d989a-692f-475b-86b9-b9ea732ecd23"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<CWtable.csv\>\"", ",", "CWtable"}], "]"}]], "Input",
 CellChangeTimes->{{3.8234105491093597`*^9, 3.8234105731073937`*^9}},
 CellLabel->
  "In[1999]:=",ExpressionUUID->"b9e639e5-f327-40e0-a452-c8c4398150c5"],

Cell[BoxData["\<\"CWtable.csv\"\>"], "Output",
 CellChangeTimes->{3.8234105777884007`*^9, 3.824191034806039*^9},
 CellLabel->
  "Out[1999]=",ExpressionUUID->"634b5b28-24dd-4052-b885-4126990f34dc"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"CWCcalcplot", "=", 
   RowBox[{"Show", "[", 
    RowBox[{
     RowBox[{"ListLinePlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"CW85Results", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}], ",", 
         RowBox[{"CW85Results", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "4"}], "}"}]}], "]"}], "]"}], ",", 
         RowBox[{"CW85Results", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "6"}], "}"}]}], "]"}], "]"}], ",", 
         RowBox[{"CW85Results", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "8"}], "}"}]}], "]"}], "]"}]}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Blue", ",", "Red", ",", "Green", ",", "Black"}], "}"}]}], 
       ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"2015", ",", "2200"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"700", ",", "1000"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"Frame", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"True", ",", "True", ",", "False", ",", "False"}], "}"}]}], 
       ",", 
       RowBox[{"FrameStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Black", ",", "Black", ",", "Automatic", ",", "Black"}], 
         "}"}]}], ",", 
       RowBox[{"FrameLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
         "\"\<Year\>\"", ",", "\"\<Atmospheric CO2 (GtC)\>\"", ",", "None", 
          ",", "None"}], "}"}]}], ",", 
       RowBox[{"LabelStyle", "\[Rule]", 
        RowBox[{"Directive", "[", 
         RowBox[{
          RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
          RowBox[{"FontSize", "\[Rule]", "18"}], ",", "Black"}], "]"}]}], ",", 
       RowBox[{"Epilog", "\[Rule]", 
        RowBox[{"Text", "[", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"\"\<a) ZEC: 420 Gt CO2 from 2018\>\"", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
              RowBox[{"FontSize", "\[Rule]", "20"}]}], "}"}]}], "]"}], ",", 
          RowBox[{"Offset", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}], ",", 
            RowBox[{"Scaled", "[", 
             RowBox[{"{", 
              RowBox[{"0.65", ",", "0.95"}], "}"}], "]"}]}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}]}], "]"}]}], ",", 
       RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}], ",", 
     RowBox[{"Plot", "[", 
      RowBox[{"atmosstock2015woFex", ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "2015", ",", "2300"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Black", ",", "Thin", ",", " ", "Dashed"}], "}"}]}]}], 
      "]"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.8233669959571495`*^9, 3.8233671694303937`*^9}, {
  3.8233672016744394`*^9, 3.8233672021044397`*^9}, {3.823367316648601*^9, 
  3.823367412632736*^9}, {3.8234338557755346`*^9, 3.8234338614665422`*^9}, {
  3.823436330696307*^9, 3.8234363515093365`*^9}, {3.8234367383978806`*^9, 
  3.8234367400178833`*^9}, {3.8234368626810555`*^9, 3.823436864291058*^9}, {
  3.824228956512068*^9, 3.82422897884921*^9}},
 CellLabel->
  "In[2040]:=",ExpressionUUID->"b39f7a57-3b01-45b8-9fc9-0a39fe3557e0"],

Cell[BoxData[
 RowBox[{
  RowBox[{"CWTcalcplot", "=", 
   RowBox[{"Show", "[", 
    RowBox[{
     RowBox[{"ListLinePlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"CW85Results", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "9"}], "}"}]}], "]"}], "]"}], ",", 
         RowBox[{"CW85Results", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "11"}], "}"}]}], "]"}], "]"}], ",", 
         RowBox[{"CW85Results", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "13"}], "}"}]}], "]"}], "]"}], ",", 
         RowBox[{"CW85Results", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "15"}], "}"}]}], "]"}], "]"}]}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Blue", ",", "Red", ",", "Green", ",", "Black"}], "}"}]}], 
       ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"2015", ",", "2200"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0.9", ",", "2"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"Frame", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"True", ",", "True", ",", "False", ",", "False"}], "}"}]}], 
       ",", 
       RowBox[{"FrameStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Black", ",", "Black", ",", "Automatic", ",", "Black"}], 
         "}"}]}], ",", 
       RowBox[{"FrameLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
         "\"\<Year\>\"", ",", "\"\<delta SAT (\[Degree]C)\>\"", ",", "None", 
          ",", "None"}], "}"}]}], ",", 
       RowBox[{"LabelStyle", "\[Rule]", 
        RowBox[{"Directive", "[", 
         RowBox[{
          RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
          RowBox[{"FontSize", "\[Rule]", "18"}], ",", "Black"}], "]"}]}], ",", 
       RowBox[{"Epilog", "\[Rule]", 
        RowBox[{"Text", "[", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"\"\<b) ZEC: 420 Gt CO2 from 2018\>\"", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
              RowBox[{"FontSize", "\[Rule]", "20"}]}], "}"}]}], "]"}], ",", 
          RowBox[{"Offset", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}], ",", 
            RowBox[{"Scaled", "[", 
             RowBox[{"{", 
              RowBox[{"0.65", ",", "0.95"}], "}"}], "]"}]}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}]}], "]"}]}], ",", 
       RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}], ",", 
     RowBox[{"Plot", "[", 
      RowBox[{"1.5", ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "2015", ",", "2300"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Black", ",", "Thin", ",", " ", "Dashed"}], "}"}]}]}], 
      "]"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.823436299982264*^9, 3.823436316344287*^9}, {
  3.82343636835036*^9, 3.823436388453388*^9}, {3.823436521820576*^9, 
  3.8234365298915873`*^9}, {3.8234367008228283`*^9, 3.823436732166872*^9}, {
  3.823436889485093*^9, 3.8234368914150963`*^9}, {3.8242289891049004`*^9, 
  3.824228999298485*^9}, {3.824234064829712*^9, 3.824234065513445*^9}},
 CellLabel->
  "In[2121]:=",ExpressionUUID->"42f40b34-bdc9-45ae-ae86-6ac55be92e81"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MainB1Cplot", "=", 
   RowBox[{"ListLinePlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"ZECMIPresults", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}], ",", 
       RowBox[{"ZECMIPresults", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "4"}], "}"}]}], "]"}], "]"}], ",", 
       RowBox[{"ZECMIPresults", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "6"}], "}"}]}], "]"}], "]"}], ",", 
       RowBox[{"ZECMIPresults", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "8"}], "}"}]}], "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Blue", ",", "Red", ",", "Green", ",", "Black"}], "}"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "200"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"588", ",", "1400"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"Frame", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"True", ",", "True", ",", "False", ",", "False"}], "}"}]}], 
     ",", 
     RowBox[{"FrameStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Black", ",", "Black", ",", "Automatic", ",", "Black"}], 
       "}"}]}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<Year\>\"", ",", "\"\<Atmospheric CO2 (GtC)\>\"", ",", "None", ",",
         "None"}], "}"}]}], ",", 
     RowBox[{"LabelStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{
        RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
        RowBox[{"FontSize", "\[Rule]", "18"}], ",", "Black"}], "]"}]}], ",", 
     RowBox[{"Epilog", "\[Rule]", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<c) ZECMIP:B1(1000 Gt C)\>\"", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}]}], "}"}]}], "]"}], ",", 
        RowBox[{"Offset", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"Scaled", "[", 
           RowBox[{"{", 
            RowBox[{"0.25", ",", "0.95"}], "}"}], "]"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}]}], "]"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.8234364002644053`*^9, 3.823436430157447*^9}, {
  3.8234366100817003`*^9, 3.8234366864198074`*^9}, {3.8234369008081093`*^9, 
  3.82343690134811*^9}, {3.8234376509542255`*^9, 3.8234376513242264`*^9}},
 CellLabel->
  "In[2033]:=",ExpressionUUID->"0b93dc21-cf85-4cfe-89f2-d8298de47312"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MainB1Tplot", "=", 
   RowBox[{"ListLinePlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"ZECMIPresults", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "23"}], "}"}]}], "]"}], "]"}], ",", 
       RowBox[{"ZECMIPresults", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "25"}], "}"}]}], "]"}], "]"}], ",", 
       RowBox[{"ZECMIPresults", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "27"}], "}"}]}], "]"}], "]"}], ",", 
       RowBox[{"ZECMIPresults", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "29"}], "}"}]}], "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Blue", ",", "Red", ",", "Green", ",", "Black"}], "}"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "200"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "3"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"Frame", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"True", ",", "True", ",", "False", ",", "False"}], "}"}]}], 
     ",", 
     RowBox[{"FrameStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Black", ",", "Black", ",", "Automatic", ",", "Black"}], 
       "}"}]}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<Year\>\"", ",", "\"\<delta SAT (\[Degree]C)\>\"", ",", "None", 
        ",", "None"}], "}"}]}], ",", 
     RowBox[{"LabelStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{
        RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
        RowBox[{"FontSize", "\[Rule]", "18"}], ",", "Black"}], "]"}]}], ",", 
     RowBox[{"Epilog", "\[Rule]", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<d) ZECMIP:B1(1000 Gt C)\>\"", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}]}], "}"}]}], "]"}], ",", 
        RowBox[{"Offset", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"Scaled", "[", 
           RowBox[{"{", 
            RowBox[{"0.25", ",", "0.95"}], "}"}], "]"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}]}], "]"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.8234364722635064`*^9, 3.8234365128095636`*^9}, {
   3.823436548084613*^9, 3.8234366010606875`*^9}, 3.823436694301819*^9},
 CellLabel->
  "In[2034]:=",ExpressionUUID->"535c7250-ba01-4def-b1ee-d516ee14731d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ZECFigure", "=", 
  RowBox[{"Legended", "[", 
   RowBox[{
    RowBox[{"Grid", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"CWCcalcplot", ",", "CWTcalcplot"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"MainB1Cplot", ",", "MainB1Tplot"}], "}"}]}], "}"}], ",", 
      RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}], ",", 
    RowBox[{"Placed", "[", 
     RowBox[{
      RowBox[{"LineLegend", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Blue", ",", "Red", ",", "Green", ",", "Black"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"\"\<DICE16\>\"", ",", 
            RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", 
          RowBox[{"Style", "[", 
           RowBox[{"\"\<DICE13\>\"", ",", 
            RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", 
          RowBox[{"Style", "[", 
           RowBox[{"\"\<DICE07\>\"", ",", 
            RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", 
          RowBox[{"Style", "[", 
           RowBox[{"\"\<Fair-Geoffroy\>\"", ",", 
            RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}]}], "}"}], ",", 
        RowBox[{"LegendLayout", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"\"\<Row\>\"", ",", "1"}], "}"}]}]}], "]"}], ",", "Below"}],
      "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8234372794646473`*^9, 3.823437333441723*^9}, {
  3.823437381836791*^9, 3.823437540761015*^9}},
 CellLabel->
  "In[2122]:=",ExpressionUUID->"41b91866-efca-407c-a0be-5716fb8e942c"],

Cell[BoxData[
 TemplateBox[{
   TagBox[
    GridBox[{{
       GraphicsBox[{{{}, {{{}, {}, {
             Hue[0.67, 0.6, 0.6], 
             Directive[
              PointSize[
               NCache[
                Rational[1, 120], 0.008333333333333333]], 
              AbsoluteThickness[1.6], 
              RGBColor[0, 0, 1]], 
             LineBox[CompressedData["
1:eJw12HlYzdkfwPHbImlDklTSKIlWIVrUpyYRioqUYrjWQkaSpqlUJFpsLbb4
npOIso4oiaJlWmxD0lC02krakCS/8xuf0z89r+e5T/d+z/mc865+EW92WyMp
Eom0JESi/3//7ytUgE+SPTZe3rHwnyMEqDJf+c8Oit4lgHO/3aH1Leg9AiR2
rN6qNTHup+MFqCwJCi/ahD4gQFyl25X4q+gkAVydTLZKDaCPCDB8i1WRiVP8
T6cKEDX046lRyWgiwEqvyrTCBnS6AK/8FRtMTBJ++qwAHl43NfzC0OcF0JxV
evfPCvRlAdrXBa2XzUJnC3BBzt/9SQI6V4Bki+RnVwLQ+QLYxXwMDPVCFwrQ
FG19XMkeXSxAqPXIAEdDdJkAS4wmn5ZWQ98TIKV251TDQehH7PVn3s1O68bP
XyXA0/HaMi5N6BoBNgZW+qtVoWsFeDTDZXpbCbpegIgSm8xruehmASbHz94r
Po9+K0DCc4fOBoJuE+C13TbQTUF3CHDUPHlAPR7dI0CM+E5pbhS6VwCtuu9m
nX+g+wXIGrAvz92CFhGwqOl6J+2HliQQHJFaUClGSxP4bXWPibQPWoZAfNr7
+6cXo2UJpBtV3Du7AC1H4JiMc8+guWgFAms9EpOvO6CVCITtbYvItkUPIzDn
kbj/qyVamYDswb68SHO0CoGTfkeqHM3QqgTGr4287WCMViMwscHXYfsktDp7
niTZqOd6aE0CJ5p06vx00FoEnoqHicZro7UJJGsfqRo0Bj2OgGKn/Q45dbQu
gf0RvUtNR6H1CLRGfuoJVEHrE6iuUBxSPRw9iYDtmWnhrkPRhgRWDnde1aKA
NiYg831C2345tCn7PEMe+i+QRZsROBPfs2KcDHoqgcG9RxcPlkabEygZ3tjX
L4GeQUCSKKhJitCWBDKCj8SN5OfPmsAltb1O5v1oGwJqY+97repDA4FEi6Lq
471oewJRti9aX35GOxDoF7tWGXxCOxJYFiPxPLIbPYfAs86Fi+o70XMJnM80
zHDsQM8nYDVIwz67He3C5qtxuaD/Ab2QwAofg19PtaLdCGikvc7TeY9eRCCn
KST13Fu0B4F3dtnRU9+gPdl+VWRqFLeglxKYcnS6nGcz2odAs2ugVEcjejmb
D22HgrgG9AoC3iktfZPq0WIC2jfig++/RK8mUE+kfwTUodcSWKXl6aVRi15P
wPJlhEfpc7QfgWH7Ncu3/oveSODPIxNidGrQ/mweevN9n1ajfyfwtfn5/L1P
0QFs3msMhtpWoQMJhFx9cvDzY3QQgUWnIffSP+hgAlsO/1jn9wgdQuD7k8Q9
eg/RoQTmXXCVar6PDifwvNWqKO0eOoLN64OmbHElOorAaL95pToV6F0E8qDi
dUsZejeBzLpumXN/o/cQMPCMUNtUio5l651ormRWwntBwHdszYsvReh9BJoO
KgXdvsv7wdZ/3tLH0XfQhwg4hkm+cS7kPSHQJZbJUi1Ap7B5ShyqWn+L94Xd
Nx5rtDPz0ccITG2vvxt4E51KQCmv8bNtHvokgb+M5lyXv4EmBKR3ib89y0Gn
sXnSbS9Mv45OJxBzTk4y4Br6DPt50VPybLPRZwmc0rdoUeT9yyQw5rrljtor
6PPsfIwnu7Iuoy8SuFyr0hVyCX2ZgPK5qOK5F9F/sfM1VvGr+gV0NoEjLooJ
rVno6wReliqG52eicwlsai0tTziHziNQFKvh/9tZdD6ByJyRvpMz0LcJ+NQ1
5UqdQRcSiFWs9q5OR98lQMK9F547hS5m94+1KDk0DV3K5llig/5Cii5j82jr
PUSXoCsIRDtkmPeeRN9j92+c5aV7J9AP2P2urxJAU9GPCCx2nRUedBz9mICO
XMfjecfQVQTu1M/a/MtRdDV7nr93u305jK5h501KFHo/Bf2cgKaRfOupZHQt
m3cnRSEkCf2SQGf7tsOuieh6dr+H3H6ifwjdyNbTy9dddBDdTEBYKqFasx/9
moDNsNEal/eh37L9sJor3pOAfs/uY8dprSvi0W0ErhdEXLOIQ7ez9/tQU6gc
i+5g8+/9UaFtD7qLQMP2kKMlMegeAiozpq0VdqM/s97deRnwRzS6l93noy0L
3Heh+9h9Xas4z3gnup/Ap34d1SFR6AECI8OctJsj0CIKXy1dfAt2oCUplOdI
dx4LR0tTMHxtlxMUhpah0Put9qZbKFqWgvfsSwPGf6LlKBgMTtohH4JWYHZc
b/M2GK1EQeGGnFXJdvQwCn0nvbelBaGVKQSkW3/YsQ2tQsGt7EDaskC0KoUG
e+tkq61oNQpX/XVLRgeg1SnMuWpi1vs7WpOC7ZZZtdWb0VoUJDqci675o7Up
PJhv9iaJ/z47joLMhtrZgRvRuhSEFvMW9w1oPQrXJIwKpvih9Skop2U+HeGL
nkThtFWqfs86tCGFFxXtOVVr0cYU8sr377y2Bm1KoUBvU1zKarQZBbH1tofb
V6GnUnAsT1ngJUabU+h+WyhvtRI9g4KuYpPUmBVoSwqxX9qm/1jO+09hePaD
jIZlvP8UYhKD3Yt9eP/Z+um9sMzw5v2ncMfizbLYpbz/FOQfJeRv8uL9p2Ck
Xejh6sn7T8HvwGbDaUt4/yk4X02YOdqD959CkoNC7PdFvP8UFujVDW905/2n
MG15V1WpG+8/hckjbJ5kufL+Uxgd95fCwYW8/xSS9e0jgxbw/lOY4PvK1MeF
95/Cb02hGvbOvP8UTGYp2unP5/2n4OO2kyrN4/1n+9f0j/UnJ95/CvsaW5Vr
5/D+U2h0LtYpms37T+GZmcvmTEfef7a/F0M/HZzF+09hcLv99T8ceP8pWE9K
urLyV95/Np+Zq9442fP+s/27k77EzI73n4LF/bmSGsD7T+HGdKc3Ura8/2x+
AxNlPszk/acg+0NzRbU17z+Fp8v/7S6w4v1nn2dc/p1zlrz/7Plf5ZYnWvD+
s/2aViQfPoP3n0J6+YOY9dN5/ynoOD2c6W7O+0/BdF2ukc003n8K0XVhSyZO
5f2n8HbDiJsqU3j/Kbx+ttFTZMb7TyGlLcykzZT3n+1XiCXUmPD+s/PgkRJb
bMz7T0HbJ1rpihHvP4U032+VJwx5/yl8EbfdjTXg/adgaTq/e/sk3n8KpbeU
lq3hf7+epKDWP0Hkrs/7T+Hyq7hamMD7T6FzhXGXsR7vP4UhoVJ2Y8bz/lOo
Nv1RJq/L+0/hYdTI2L5xvP8UPgZb7nr3C+8/BTJGnFOjzftPITM8QqdsLO8/
e74Le8tytHj/Kbje2nImYwzvP4X8UsNbhzV5/yl8a7qosEeD95/CbbO2pGB1
3n8KN5/ULPYdzftP4dT79QuWqvH+U1A/eSBy3ijefwpZoxzarFV5/ykU7ty+
33gk7z+F48PHbtBW4f2n4NJtvEN5BO8/W79lxyullXn/2X7u8Vz4ZRjvP4WL
F5Yqvh/K+8/eTy5Fsk6J95+dv1cDJo8Uef8pzN+0N7lIgfefwrq+iVNy5Hn/
KYx4UCWbJcf7z9bXLFxVGML7z/oUqO6TKMv7TyG1+cS/MYN5/9nrn/TvC5Xh
/aeQkWIQumUQ7z+Fll1adK007z+FUb3l372leP8p7Jw/7pCrJO8/ha56jeWz
JXj/KWSrZq2cKeL9p3DUtTh1yg/8f0o7hY4v3kMnDaA7KOwOWHtD+zu6i+2X
Yc2xUf3oHjZ/SaevKn1Df2b3v1qRlEwfupetn/H4uO+9sfA/UNKwZQ==
              "]]}, {
             Hue[0.9060679774997897, 0.6, 0.6], 
             Directive[
              PointSize[
               NCache[
                Rational[1, 120], 0.008333333333333333]], 
              AbsoluteThickness[1.6], 
              RGBColor[1, 0, 0]], 
             LineBox[CompressedData["
1:eJw113tYjVkXAPAuukwSmtCXJOmmiWJIui5dlEihSUgkQzUxpFyTgxxHUxKl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              "]]}, {
             Hue[0.1421359549995791, 0.6, 0.6], 
             Directive[
              PointSize[
               NCache[
                Rational[1, 120], 0.008333333333333333]], 
              AbsoluteThickness[1.6], 
              RGBColor[0, 1, 0]], 
             LineBox[CompressedData["
1:eJwt1QtUTdsaB/CkkpB3JEUeW55RSUI+STqk41nCoSuvSKhGOLpx3FDpJT3o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              "]]}, {
             Hue[0.37820393249936934`, 0.6, 0.6], 
             Directive[
              PointSize[
               NCache[
                Rational[1, 120], 0.008333333333333333]], 
              AbsoluteThickness[1.6], 
              GrayLevel[0]], 
             LineBox[CompressedData["
1:eJw11XlYTlsbBvCkEgqlSMVJuaKEJBpUnjpIhCTJUEimhExFkihpQpOEtNci
nZQhkTJFFCGJSJJCIaREQjrOt77jPu8/7/W79l7zs+490HON8xJZGRmZAZ1k
ZP7//+8vUKKvsq02c+ZF0r8OlkhnvYfDgEg4VKLDPvGut/PgcImyS+/+ON0A
R0t0TLsj7Ve/qN+Okajg+jstYyc4QaL53c+UfgiDk0T7/joevvlwskQxFTOK
attgJlHJQ3ejqcbRv50qkVpDfesNbzhdIhPvtLRZqfAJiVxqbRdNXQdnSTTT
9KOzryN8TqLQ1A+pqsPhPInWx/xqD1ODL0t0eXbXA6a/MP41iQzXyB3XeQ8X
SrSjsTz35BO4WCLO8z/73YRLJPrTwT3I8jxcJlF+y0SvkjT4kUR6y7dG90iC
KyW6O7Tw6ocIuFoiq4HTd7oEwi9Ee8Mf+tZr4HqJFI/lrUr2hBsk2u44/KG3
K9wo1u98r41Phj9J1CfsjZPVOLhVtDc812xqCn+XaJT5SdddBnCHRE5RDl4j
/oBlGBllV5CBOizLKMB0j/Pa7rAcoyKVAaPlZGEFRncMN52t+Y56UGQ0O0z/
xt/NcDdG+nppwR5vYSVGr29uNPpVA/dgJIUfGVJVAfcS75ueamsuhVXF8+Tc
0da3YDVGaYWP2NWrcB9GC+vilTf+V58ajPafPuQ97wysySgoaUm+bwaszaiv
Sg/9s0fhAYxe9TF/pHMY1mHkdadTr7xEWJeRhreiqX8MPIhRD5eAk/P/ux/6
jCY0j/65NBQewqgjvPVEQhBsyMjQJdizfhNsxGhoWesdl/XwcEYHWhRT61fB
xoxm+nleiFsOmzBKetZS574YNmV01t+16wQPeAyjU3aTteznwOaMpr1U67vY
BbZkJLtbXj5pOmzFqNeWL9/qJ8M2jAxWFCo5TISJUePf31fcsIXtGH09aTNu
pjU8ntHw5wpF38zhiYxy2nStskzhSYzuWy75uMUYnsyoq/xEg7lGsCOjkTN2
208eAk9jNGaSzF9TBsFOjFK46kl3HdiZ0a70Q0XbtGEXsb7zezzPaMCujKZ/
O/+zRQ12Y2Tp5NfDVgWey2iq9a7+KcrwfEY9wwqyFLvBHozeHnnpEqwALxTr
zXY+JNcZ9mSkUtfeb98/Eb/txejvwd1WjuyAlzJSGnHX6Ol3eLlY70q/TtFf
YW9GgXpd9jp8hn1E+1Wq21Sa4dWMlH9KQXUfYF9GLyU5m6sN8DpGFhH5vqmv
4Q2MSmRn3ot7Bfsx6lwwTDmyFt7E6PnB7Y0R1XAAo+VHDQ3jnsKBjMziYncd
qYCDGFWsjCm+WA4Hi3qb53a2qgzewYhlufWSLYVDGem06GcY34XDGNl/WzZ1
aTEczii6+8XiI0VwJCPjFqnx9XU4mpFilU/UiGvwHkZ6ZiM3b7sCxzDymZ8e
9fgiHMeo8qP+wZF5cAKjscqRW+Nz4ERGfWhwr5/ZcJKoB/krw5ZnwQfF+fX2
Olt1Ek5mNGT09m3OmXAKo4FFuWvvp8NM9JdT7T0jDT7CSGbwe8fKo3CqyMfI
L+2LOZzGSNVCc05rCpzO6EPsDseIZDiD0fFQh0u6B+ETYn6xAdHX9sOnxP6O
VEj33AdnMYo9ntemGA9ni/lYjvQ8GwOfYySX/fTRoj3weZFfbjUWatFwHqPv
I/S33omAL4q82DklKnQXfJnRzycJM+x2wvkiz2SbrnQOga+J889+mV8cDF8X
92Vw/J+xQXChyC+DvLHugfBNRr+mxO83CoCLGe1d0mT/jz98h9F5O3Wbxxvh
EkYX4spWnloPlzJq77LoRuRauEz0lxlg5r0GfsjIxIsuOa6CH4n+j42zM1kJ
VzCynuVzTXMFXMmouVzbUGEZXCXyyURhQ6sXXM2o+17z+NeecA2j2gStrU8X
wi8Y5Q5aObjMA34lvifapuG358P14r7bPdhXNBd+w8jOsWFioRvcIOantCyu
yBV+z2jUueA1t13gRpFfYzIf33eGm8T5FyZfrnSCPzHqvdRBu34a/Fmc57EX
jS2OcCsjtXl39WWnwG2MbHcev67mAH8X9UBOFwzs4XYxv/u3OttOgDsYtWY7
HJr7J/xLfG9qbTb72cIynCLarfcnjINlOVmd6dp8zhqW46SitTfgyVhYgdO+
EfWjOixgRU5hkyeq65nD3TjZX9Xo5zgGVuK0PaDOwt8U7iHan5mxLtUE7sWJ
JOMr5cawKqcGx9Xq8iNgNU7flmn4mQ+D+3DqoTevatVQWIPTWN1g62MGsCan
9rUfD9YMhrU5+YUPauqnDw/gdMWpwGT2IFiHk/e4zV6JurAup2W+mtue6MCD
OC28Fxmk+Qesz+mU1S2PBf3hIZzMKl9ppWnBhpyGGilkN/WDjcT8A1f3t9CA
h3MKVls1d2cf2Fi0T1y6pFwNNuEUNeehpV5v2JTTlzsWTzaowGM4XXpoZlbc
EzbnVGG7aXb/HrAlp5Hjc003KMFWnFwrr90t6QbbcBrv6NtvcFeYOFlcPa0Z
0gW242SY7l/yQh4ez+n1wtKhJAdP5OSfc2s0l4Uncar1D33buRM8mVNeXxOb
5f+E/7Yjp2fW3cxK/4ancfprpfP90R2wE6f6w/PkpHbYmZP2l+3lXX/ALpym
zjKy9PsGu3I6oV8yuv4r7MYpsqX6xsxWeC6nUVr1Lws/w/M5hR/w3W3WAntw
mpWpWZjZDC/k5BwfEjKwCfbkFDtr1u2kRtiLk5e/XbzKB3ipGK9AvjbqHbxc
vC/nmdGlAfbmFFg78EvoG9iHk0N439zOr+HVnHYlareG1MG+nBrvq6TLv4LX
if7basrCX8AbRD0nrfNRroX9OPWsL9gU/xzexGmCX/EXzWo4gNMF0/BnR6vg
QE6pA7sOH/4UDuI0xnTOuwtP4GAx/sjo7vYV8A5RjxGX4h4/gkM5bRymsHVJ
ORzGSWlDTHHbAzicU+nnkPURZXCkuO8Legb2vw9Hc9riu/RF9j14D6dp+QUp
DiVwDKeQNI+cl3fgOJEfI7bpbrkNJ4j1Nq6oVy+GEznp1a34ceYmnCTyYEPp
gulF8EFO72w+qDfdgJM5LVLS0NxzHU4R9XM+y3tEAcw49emtrvDwKnxE5EF1
+vuN+XCq2P/D5X20rsBp4j5JMhEFl+B0TpllKeNWXIQzON3L1bFQvQCf4FTk
3rH+ci58SuyfdWbTsvNwlsgv44y/1HLgbE4LFm0+fP0sfI7TdYvk0rXZ8HlO
xs4HLHTPwHmcyhe3V5efhi9ycrNwzA07BV/mdI4NuGV5Es4X+e4u1/1TJnyN
k5Fm/Pa0DPg6p+Puiw08jsOFnH5s6dWpbzp8k9P0KPMuD9LgYpE/swMto4/B
d8R5uW07MCkVLuG0n7/VVTgKl3KyqXF/XMjhMnH/bHefDmXwQ7H/W/WyJkjw
I5FXF8sed0mBKzj1jrL/424yXMmprd4qau8huIpTmfpyjVkH4WpOdpd2FGkd
gGvE+xcmxdbth19wGjB6U8CJRPiV2I+wB9v89sH1or5N+zLbBPgNJ9Vm5Srl
eLiB07XtgUbPYuH3Iq/LhiYej4EbOT0qe6O+eS/cxGlnUECGwx74EyfbpznO
Wrvhz+L78myFclMU3CrWv3HF04JIuE30HxKRkxgBf+f0/B5jPuHh9D+Tjrr0

              "]]}}}, {{}, {}}}, {{{{}, {}, 
            TagBox[{
              Directive[
               Opacity[1.], 
               AbsoluteThickness[1.6], 
               GrayLevel[0], 
               Thickness[Tiny], 
               Dashing[{Small, Small}]], 
              LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQvTu4jZGhZr7DV6YvdpHRXQ5sh2ebG7Qj+IFGG3MT
JiH4TrzPNy5aheAX/3yc5XkQwXd2zUypu47g5/b+NJ36HsHPKdaw42BeAOf7
zYs8a8aP4P//ca5GRxrBD7yzPC1EDcG/YNtmk2uE4L9XP+GzwxbBv+voV3vK
A8H/efPmzLMhCP7WXyc+MCUg+PNm7jXWzEHwwzO+TROrQPA37J9kYtaM4JtN
Ndnn1o/gx3y2bOqchaT+vIvR3mUI/uXbk5l2bELwpxW48T7di+C3Nf9jZj6F
4IvLS5kGX0Xwy19VtmU9QPBZTO4fLnqD4BuxrbBe+x3B7w0rm3+DeSGcv/1a
h/JpfgS/8f6/h++lEPzKtKoeVnUEX7AsstDXCMGv2FpTFmOL4PMUL02P8UTw
HXcaTu4LQfAX1x5etTEBwV96ascfthwEv8z9U55yOYJf6mR41qAZwRc5djm1
oA/Bf3C8+tWCWQh+zc/0/hnLEPwdm7fnHdqI4Cu+4bG6uxfB11p71F7rJILP
PO9Qqt0VBJ+T92i58wMEfz2L9pGq1wh+5tvNiXs/IvjK12z+//+O4AMAdGiJ
7A==
               "]]}, 
             Annotation[#, "Charting`Private`Tag$506055#1"]& ]}}, {}}}, {
        DisplayFunction -> Identity, DisplayFunction -> Identity, AspectRatio -> 
         NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
         AxesLabel -> {None, None}, AxesOrigin -> {2015., 700.}, 
         DisplayFunction :> Identity, Epilog -> InsetBox[
           FormBox[
            StyleBox[
            "\"a) ZEC: 420 Gt CO2 from 2018\"", {
             FontFamily -> "Helvetica", FontSize -> 20}, StripOnInput -> 
             False], TraditionalForm], 
           Offset[{0, 0}, 
            Scaled[{0.65, 0.95}]], 
           ImageScaled[{
             Rational[1, 2], 
             Rational[1, 2]}]], Frame -> {{True, False}, {True, False}}, 
         FrameLabel -> {{
            FormBox["\"Atmospheric CO2 (GtC)\"", TraditionalForm], None}, {
            FormBox["\"Year\"", TraditionalForm], None}}, FrameStyle -> {
           GrayLevel[0], 
           GrayLevel[0], Automatic, 
           GrayLevel[0]}, 
         FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
         GridLines -> {None, None}, GridLinesStyle -> Directive[
           GrayLevel[0.5, 0.4]], ImageSize -> 600, LabelStyle -> 
         Directive[FontFamily -> "Helvetica", FontSize -> 18, 
           GrayLevel[0]], 
         Method -> {
          "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
           "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), "CopiedValueFunction" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& )}}, PlotRange -> {{2015, 2200}, {700, 1000}}, 
         PlotRangeClipping -> True, PlotRangePadding -> {{0, 0}, {0, 0}}, 
         Ticks -> {Automatic, Automatic}}], 
       GraphicsBox[{{{}, {{{}, {}, {
             Hue[0.67, 0.6, 0.6], 
             Directive[
              PointSize[0.006944444444444445], 
              AbsoluteThickness[1.6], 
              RGBColor[0, 0, 1]], 
             LineBox[CompressedData["
1:eJw913lYzlkbB/CUyhJCJYSyNEkiWwtvvkOZxpbSGOOV7DsVCdUkTZKQZBlD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              "]]}, {
             Hue[0.9060679774997897, 0.6, 0.6], 
             Directive[
              PointSize[0.006944444444444445], 
              AbsoluteThickness[1.6], 
              RGBColor[1, 0, 0]], 
             LineBox[CompressedData["
1:eJw113s8VVkbB/BTTCKVIimXhFcilTJdZZ50HSkqoTJCNyNJ7skk5ZLuGULF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              "]]}, {
             Hue[0.1421359549995791, 0.6, 0.6], 
             Directive[
              PointSize[0.006944444444444445], 
              AbsoluteThickness[1.6], 
              RGBColor[0, 1, 0]], 
             LineBox[CompressedData["
1:eJw11gs0V/kWB3BJmBhL8c/4Z8gjRcVMSophT8noMVRXhqasHjIWt1ITRSmP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              "]]}, {
             Hue[0.37820393249936934`, 0.6, 0.6], 
             Directive[
              PointSize[0.006944444444444445], 
              AbsoluteThickness[1.6], 
              GrayLevel[0]], 
             LineBox[CompressedData["
1:eJw913s8l2cfB3CzDrMKSaWT1NRT0cnKWgc+nSTRmppEk0o5rIMOzDqNomjm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              "]]}}}, {{}, {}}}, {{{{}, {}, 
            TagBox[{
              Directive[
               Opacity[1.], 
               AbsoluteThickness[1.6], 
               GrayLevel[0], 
               Thickness[Tiny], 
               Dashing[{Small, Small}]], 
              LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQvTu4jZGhZr4DAxj8sGc7PNvcoB3BDzTamJswCcF3
4n2+cdEqBL/45+Msz4MIvrNrZkrddQQ/t/en6dT3CH5OsYYdB/MCON9vXuRZ
M34E//+PczU60gh+4J3laSFqCP4F2zabXCME/736CZ8dtgj+XUe/2lMeCP7P
mzdnng1B8Lf+OvGBKQHBnzdzr7FmDoIfnvFtmlgFgr9h/yQTs2YE32yqyT63
fgQ/5rNlU+csJPXnXYz2LkPwL9+ezLRjE4I/rcCN9+leBL+t+R8z8ykEX1xe
yjT4KoJf/qqyLesBgs9icv9w0RsE34hthfXa7wh+b1jZ/BvMC+H87dc6lE/z
I/iN9/89fC+F4FemVfWwqiP4gmWRhb5GCH7F1pqyGFsEn6d4aXqMJ4LvuNNw
cl8Igr+49vCqjQkI/tJTO/6w5SD4Ze6f8pTLEfxSJ8OzBs0Ivsixy6kFfQj+
g+PVrxbMQvBrfqb3z1iG4O/YvD3v0EYEX/ENj9XdvQi+1tqj9lonEXzmeYdS
7a4g+Jy8R8udHyD461m0j1S9RvAz325O3PsRwVe+ZvP//3cEHwAZzQss
               "]]}, 
             Annotation[#, "Charting`Private`Tag$522342#1"]& ]}}, {}}}, {
        DisplayFunction -> Identity, DisplayFunction -> Identity, AspectRatio -> 
         NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
         AxesLabel -> {None, None}, AxesOrigin -> {2015., 0.9}, 
         DisplayFunction :> Identity, Epilog -> InsetBox[
           FormBox[
            StyleBox[
            "\"b) ZEC: 420 Gt CO2 from 2018\"", {
             FontFamily -> "Helvetica", FontSize -> 20}, StripOnInput -> 
             False], TraditionalForm], 
           Offset[{0, 0}, 
            Scaled[{0.65, 0.95}]], 
           ImageScaled[{
             Rational[1, 2], 
             Rational[1, 2]}]], Frame -> {{True, False}, {True, False}}, 
         FrameLabel -> {{
            FormBox["\"delta SAT (\[Degree]C)\"", TraditionalForm], None}, {
            FormBox["\"Year\"", TraditionalForm], None}}, FrameStyle -> {
           GrayLevel[0], 
           GrayLevel[0], Automatic, 
           GrayLevel[0]}, 
         FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
         GridLines -> {None, None}, GridLinesStyle -> Directive[
           GrayLevel[0.5, 0.4]], ImageSize -> 600, LabelStyle -> 
         Directive[FontFamily -> "Helvetica", FontSize -> 18, 
           GrayLevel[0]], 
         Method -> {
          "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
           "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), "CopiedValueFunction" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& )}}, PlotRange -> {{2015, 2200}, {0.9, 2}}, 
         PlotRangeClipping -> True, PlotRangePadding -> {{0, 0}, {0, 0}}, 
         Ticks -> {Automatic, Automatic}}]}, {
       GraphicsBox[{{}, {{{}, {}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             PointSize[
              NCache[
               Rational[1, 120], 0.008333333333333333]], 
             AbsoluteThickness[1.6], 
             RGBColor[0, 0, 1]], 
            LineBox[CompressedData["
1:eJw1lns41Pkex6foIhVdV+WWLYR0Qcjg7RaSZNwGgzE3M4jtJFRkUrJuS61p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             "]]}, {
            Hue[0.9060679774997897, 0.6, 0.6], 
            Directive[
             PointSize[
              NCache[
               Rational[1, 120], 0.008333333333333333]], 
             AbsoluteThickness[1.6], 
             RGBColor[1, 0, 0]], 
            LineBox[CompressedData["
1:eJw1lQdUVGcahkewYACRqNgRBcEoRUoCMZQXqQ460pmhTWMKipTsCFJUJEpU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             "]]}, {
            Hue[0.1421359549995791, 0.6, 0.6], 
            Directive[
             PointSize[
              NCache[
               Rational[1, 120], 0.008333333333333333]], 
             AbsoluteThickness[1.6], 
             RGBColor[0, 1, 0]], 
            LineBox[CompressedData["
1:eJw9lgtUjHkfx581oey7DnK/ZEIlpS0qhfKdFDWV7s1kpprmnnFQuii36eaS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             "]]}, {
            Hue[0.37820393249936934`, 0.6, 0.6], 
            Directive[
             PointSize[
              NCache[
               Rational[1, 120], 0.008333333333333333]], 
             AbsoluteThickness[1.6], 
             GrayLevel[0]], 
            LineBox[CompressedData["
1:eJw1lgs0lHkfxyds22VFl022WiOKXCIKifFVQuM+DIPBXAxDEaLSzaR3a1K6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             "]]}}}, {{}, {}}}, {
        DisplayFunction -> Identity, DisplayFunction -> Identity, AspectRatio -> 
         NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
         AxesLabel -> {None, None}, AxesOrigin -> {1., 588.}, DisplayFunction :> 
         Identity, Epilog -> InsetBox[
           FormBox[
            StyleBox[
            "\"c) ZECMIP:B1(1000 Gt C)\"", {
             FontFamily -> "Helvetica", FontSize -> 20}, StripOnInput -> 
             False], TraditionalForm], 
           Offset[{0, 0}, 
            Scaled[{0.25, 0.95}]], 
           ImageScaled[{
             Rational[1, 2], 
             Rational[1, 2]}]], Frame -> {{True, False}, {True, False}}, 
         FrameLabel -> {{
            FormBox["\"Atmospheric CO2 (GtC)\"", TraditionalForm], None}, {
            FormBox["\"Year\"", TraditionalForm], None}}, FrameStyle -> {
           GrayLevel[0], 
           GrayLevel[0], Automatic, 
           GrayLevel[0]}, 
         FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
         GridLines -> {None, None}, GridLinesStyle -> Directive[
           GrayLevel[0.5, 0.4]], ImageSize -> 600, LabelStyle -> 
         Directive[FontFamily -> "Helvetica", FontSize -> 18, 
           GrayLevel[0]], 
         Method -> {
          "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
           "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), "CopiedValueFunction" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& )}}, PlotRange -> {{1, 200}, {588, 1400}}, 
         PlotRangeClipping -> True, PlotRangePadding -> {{0, 0}, {0, 0}}, 
         Ticks -> {Automatic, Automatic}}], 
       GraphicsBox[{{}, {{{}, {}, {
            Hue[0.67, 0.6, 0.6], 
            Directive[
             PointSize[
              NCache[
               Rational[1, 120], 0.008333333333333333]], 
             AbsoluteThickness[1.6], 
             RGBColor[0, 0, 1]], 
            LineBox[CompressedData["
1:eJxVk3tYjHkfh6cDwhK9ylopUl6l2rYIqXxKhZFMM+momplmmikXW1nK5jDZ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             "]]}, {
            Hue[0.9060679774997897, 0.6, 0.6], 
            Directive[
             PointSize[
              NCache[
               Rational[1, 120], 0.008333333333333333]], 
             AbsoluteThickness[1.6], 
             RGBColor[1, 0, 0]], 
            LineBox[CompressedData["
1:eJxVlQs01Hkfh0e6kKLaWqxiKinZte5JFx9yTUlj5M7MmDGkNt2UajXSVLtt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             "]]}, {
            Hue[0.1421359549995791, 0.6, 0.6], 
            Directive[
             PointSize[
              NCache[
               Rational[1, 120], 0.008333333333333333]], 
             AbsoluteThickness[1.6], 
             RGBColor[0, 1, 0]], 
            LineBox[CompressedData["
1:eJxV1XtUzHkfB/CfyGUfhIekUiPq0CppCyXbOxWNLrrfR3OfqQe5LpLdkdxW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             "]]}, {
            Hue[0.37820393249936934`, 0.6, 0.6], 
            Directive[
             PointSize[
              NCache[
               Rational[1, 120], 0.008333333333333333]], 
             AbsoluteThickness[1.6], 
             GrayLevel[0]], 
            LineBox[CompressedData["
1:eJxVlAtYzOkexwdF5dLuyrViCB116jSDlBFfE4lEqel+mfuk4UGmHJc9hvaw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             "]]}}}, {{}, {}}}, {
        DisplayFunction -> Identity, DisplayFunction -> Identity, AspectRatio -> 
         NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
         AxesLabel -> {None, None}, AxesOrigin -> {1., 0}, DisplayFunction :> 
         Identity, Epilog -> InsetBox[
           FormBox[
            StyleBox[
            "\"d) ZECMIP:B1(1000 Gt C)\"", {
             FontFamily -> "Helvetica", FontSize -> 20}, StripOnInput -> 
             False], TraditionalForm], 
           Offset[{0, 0}, 
            Scaled[{0.25, 0.95}]], 
           ImageScaled[{
             Rational[1, 2], 
             Rational[1, 2]}]], Frame -> {{True, False}, {True, False}}, 
         FrameLabel -> {{
            FormBox["\"delta SAT (\[Degree]C)\"", TraditionalForm], None}, {
            FormBox["\"Year\"", TraditionalForm], None}}, FrameStyle -> {
           GrayLevel[0], 
           GrayLevel[0], Automatic, 
           GrayLevel[0]}, 
         FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
         GridLines -> {None, None}, GridLinesStyle -> Directive[
           GrayLevel[0.5, 0.4]], ImageSize -> 600, LabelStyle -> 
         Directive[FontFamily -> "Helvetica", FontSize -> 18, 
           GrayLevel[0]], 
         Method -> {
          "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
           "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), "CopiedValueFunction" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& )}}, PlotRange -> {{1, 200}, {0, 3}}, 
         PlotRangeClipping -> True, PlotRangePadding -> {{0, 0}, {0, 0}}, 
         Ticks -> {Automatic, Automatic}}]}}, AutoDelete -> False, 
     GridBoxFrame -> {"Columns" -> {{True}}, "Rows" -> {{True}}}, 
     GridBoxItemSize -> {
      "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"], 
   TemplateBox[{
     StyleBox[
     "\"DICE16\"", FontFamily -> "Helvetica", FontSize -> 20, StripOnInput -> 
      False], 
     StyleBox[
     "\"DICE13\"", FontFamily -> "Helvetica", FontSize -> 20, StripOnInput -> 
      False], 
     StyleBox[
     "\"DICE07\"", FontFamily -> "Helvetica", FontSize -> 20, StripOnInput -> 
      False], 
     StyleBox[
     "\"Fair-Geoffroy\"", FontFamily -> "Helvetica", FontSize -> 20, 
      StripOnInput -> False]}, "LineLegend", DisplayFunction -> (StyleBox[
      StyleBox[
       PaneBox[
        TagBox[
         GridBox[{{
            TagBox[
             GridBox[{{
                GraphicsBox[{{
                   Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                   Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1]], {}}}, AspectRatio -> Full, 
                 ImageSize -> {20, 10}, PlotRangePadding -> None, 
                 ImagePadding -> Automatic, 
                 BaselinePosition -> (Scaled[0.1] -> Baseline)], #, 
                GraphicsBox[{{
                   Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                   Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0]], {}}}, AspectRatio -> Full, 
                 ImageSize -> {20, 10}, PlotRangePadding -> None, 
                 ImagePadding -> Automatic, 
                 BaselinePosition -> (Scaled[0.1] -> Baseline)], #2, 
                GraphicsBox[{{
                   Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 1, 0]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                   Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 1, 0]], {}}}, AspectRatio -> Full, 
                 ImageSize -> {20, 10}, PlotRangePadding -> None, 
                 ImagePadding -> Automatic, 
                 BaselinePosition -> (Scaled[0.1] -> Baseline)], #3, 
                GraphicsBox[{{
                   Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                   Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0]], {}}}, AspectRatio -> Full, 
                 ImageSize -> {20, 10}, PlotRangePadding -> None, 
                 ImagePadding -> Automatic, 
                 BaselinePosition -> (Scaled[0.1] -> Baseline)], #4}}, 
              GridBoxAlignment -> {
               "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
              AutoDelete -> False, 
              GridBoxDividers -> {
               "Columns" -> {{False}}, "Rows" -> {{False}}}, 
              GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
              GridBoxSpacings -> {"Columns" -> {{0.8, 0.5}}}], "Grid"]}}, 
          GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
          AutoDelete -> False, 
          GridBoxDividers -> {"Columns" -> {{None}}, "Rows" -> {{None}}}, 
          GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
          GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{1}}}], "Grid"], 
        Alignment -> Left, AppearanceElements -> None, 
        ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> "ResizeToFit"], 
       LineIndent -> 0, StripOnInput -> False], {FontFamily -> "Arial"}, 
      Background -> Automatic, StripOnInput -> False]& ), 
    InterpretationFunction :> (RowBox[{"LineLegend", "[", 
       RowBox[{
         RowBox[{"{", 
           RowBox[{
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{
                   GrayLevel[0], 
                   RectangleBox[{0, 0}]}, {
                   GrayLevel[0], 
                   RectangleBox[{1, -1}]}, {
                   RGBColor[0, 0, 1], 
                   RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                 "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                 FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                 FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                StyleBox[
                 RowBox[{"RGBColor", "[", 
                   RowBox[{"0", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                 False]], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
               ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[0, 0, 1]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[0, 0, 1], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{
                   GrayLevel[0], 
                   RectangleBox[{0, 0}]}, {
                   GrayLevel[0], 
                   RectangleBox[{1, -1}]}, {
                   RGBColor[1, 0, 0], 
                   RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                 "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                 FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                 FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                StyleBox[
                 RowBox[{"RGBColor", "[", 
                   RowBox[{"1", ",", "0", ",", "0"}], "]"}], NumberMarks -> 
                 False]], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
               ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{
                   GrayLevel[0], 
                   RectangleBox[{0, 0}]}, {
                   GrayLevel[0], 
                   RectangleBox[{1, -1}]}, {
                   RGBColor[0, 1, 0], 
                   RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                 "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                 FrameStyle -> RGBColor[0., 0.6666666666666666, 0.], 
                 FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                StyleBox[
                 RowBox[{"RGBColor", "[", 
                   RowBox[{"0", ",", "1", ",", "0"}], "]"}], NumberMarks -> 
                 False]], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
               ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[0, 1, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[0, 1, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{
                   GrayLevel[0], 
                   RectangleBox[{0, 0}]}, {
                   GrayLevel[0], 
                   RectangleBox[{1, -1}]}, {
                   GrayLevel[0], 
                   RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                 "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                 FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                 PlotRangePadding -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                StyleBox[
                 RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> False]],
                Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
               Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = GrayLevel[0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              GrayLevel[0], Editable -> False, Selectable -> False]}], "}"}], 
         ",", 
         RowBox[{"{", 
           RowBox[{#, ",", #2, ",", #3, ",", #4}], "}"}], ",", 
         RowBox[{"LegendLayout", "\[Rule]", 
           RowBox[{"{", 
             RowBox[{"\"Row\"", ",", "1"}], "}"}]}]}], "]"}]& ), Editable -> 
    True]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "Below"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{{3.8234368483900356`*^9, 3.823436869743066*^9}, 
   3.8234369057691164`*^9, 3.8234371588794737`*^9, 3.823437335571726*^9, 
   3.823437431794862*^9, 3.823437472108918*^9, {3.823437522497989*^9, 
   3.823437542191017*^9}, 3.823437655869233*^9, 3.8241923888666735`*^9, {
   3.8242290068017273`*^9, 3.8242290191481915`*^9}, 3.824234071528016*^9},
 CellLabel->
  "Out[2122]=",ExpressionUUID->"ec129035-ce8f-4b8c-ac14-ed6743ce1e78"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<ZECFigure.tiff\>\"", ",", "ZECFigure"}], "]"}]], "Input",
 CellChangeTimes->{{3.823437560672043*^9, 3.8234375844250765`*^9}},
 CellLabel->
  "In[2123]:=",ExpressionUUID->"e5aa870b-c35e-4fbe-be2a-7160c886b4e7"],

Cell[BoxData["\<\"ZECFigure.tiff\"\>"], "Output",
 CellChangeTimes->{3.82343758725508*^9, 3.8234376676002493`*^9, 
  3.824192398774006*^9, 3.8242290278848867`*^9, 3.824234077389537*^9},
 CellLabel->
  "Out[2123]=",ExpressionUUID->"ac9d4990-4117-4b21-ad8b-c80f37111d3c"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"SICWCplot", "=", 
   RowBox[{"Show", "[", 
    RowBox[{
     RowBox[{"ListLinePlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"CW85Results", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}], ",", 
         RowBox[{"CW85Results", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "3"}], "}"}]}], "]"}], "]"}], ",", 
         RowBox[{"CW85Results", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "4"}], "}"}]}], "]"}], "]"}], ",", 
         RowBox[{"CW85Results", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "5"}], "}"}]}], "]"}], "]"}], ",", 
         RowBox[{"CW85Results", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "6"}], "}"}]}], "]"}], "]"}], ",", 
         RowBox[{"CW85Results", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "7"}], "}"}]}], "]"}], "]"}], ",", 
         RowBox[{"CW85Results", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "8"}], "}"}]}], "]"}], "]"}]}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Blue", ",", 
          RowBox[{"{", 
           RowBox[{"Blue", ",", "Dashed"}], "}"}], ",", "Red", ",", 
          RowBox[{"{", 
           RowBox[{"Red", ",", "Dashed"}], "}"}], ",", "Green", ",", 
          RowBox[{"{", 
           RowBox[{"Green", ",", "Dashed"}], "}"}], ",", "Black"}], "}"}]}], 
       ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"2015", ",", "2200"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"650", ",", "1000"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"Frame", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"True", ",", "True", ",", "False", ",", "False"}], "}"}]}], 
       ",", 
       RowBox[{"FrameStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Black", ",", "Black", ",", "Automatic", ",", "Black"}], 
         "}"}]}], ",", 
       RowBox[{"FrameLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
         "\"\<Year\>\"", ",", "\"\<Atmosphere GtC\>\"", ",", "None", ",", 
          "None"}], "}"}]}], ",", 
       RowBox[{"LabelStyle", "\[Rule]", 
        RowBox[{"Directive", "[", 
         RowBox[{
          RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
          RowBox[{"FontSize", "\[Rule]", "18"}], ",", "Black"}], "]"}]}], ",", 
       RowBox[{"Epilog", "\[Rule]", 
        RowBox[{"Text", "[", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"\"\<a) atmospheric CO2\>\"", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
              RowBox[{"FontSize", "\[Rule]", "20"}]}], "}"}]}], "]"}], ",", 
          RowBox[{"Offset", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}], ",", 
            RowBox[{"Scaled", "[", 
             RowBox[{"{", 
              RowBox[{"0.80", ",", "0.95"}], "}"}], "]"}]}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}]}], "]"}]}], ",", 
       RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}], ",", 
     RowBox[{"Plot", "[", 
      RowBox[{"atmosstock2015woFex", ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "2015", ",", "2300"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Black", ",", "Thin", ",", " ", "Dashed"}], "}"}]}]}], 
      "]"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.823367228187476*^9, 3.823367239299492*^9}, {
   3.8233678859384065`*^9, 3.8233679001694264`*^9}, {3.823433454493969*^9, 
   3.8234335742921376`*^9}, {3.823433637491226*^9, 3.823433639401229*^9}, 
   3.823433886011577*^9, {3.823435350266816*^9, 3.823435489526012*^9}, {
   3.823435673673271*^9, 3.823435737075361*^9}, {3.824191585039579*^9, 
   3.824191593521619*^9}},
 CellLabel->
  "In[2000]:=",ExpressionUUID->"a30cab50-2c9b-4b40-8dc6-9036bed34094"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SICWTplot", "=", 
   RowBox[{"Show", "[", 
    RowBox[{
     RowBox[{"ListLinePlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"CW85Results", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "9"}], "}"}]}], "]"}], "]"}], ",", 
         RowBox[{"CW85Results", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "10"}], "}"}]}], "]"}], "]"}], ",", 
         RowBox[{"CW85Results", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "11"}], "}"}]}], "]"}], "]"}], ",", 
         RowBox[{"CW85Results", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "12"}], "}"}]}], "]"}], "]"}], ",", 
         RowBox[{"CW85Results", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "13"}], "}"}]}], "]"}], "]"}], ",", 
         RowBox[{"CW85Results", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "14"}], "}"}]}], "]"}], "]"}], ",", 
         RowBox[{"CW85Results", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "15"}], "}"}]}], "]"}], "]"}]}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Blue", ",", 
          RowBox[{"{", 
           RowBox[{"Blue", ",", "Dashed"}], "}"}], ",", "Red", ",", 
          RowBox[{"{", 
           RowBox[{"Red", ",", "Dashed"}], "}"}], ",", "Green", ",", 
          RowBox[{"{", 
           RowBox[{"Green", ",", "Dashed"}], "}"}], ",", "Black"}], "}"}]}], 
       ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"2015", ",", "2200"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0.9", ",", "2"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"Frame", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"True", ",", "True", ",", "False", ",", "False"}], "}"}]}], 
       ",", 
       RowBox[{"FrameStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Black", ",", "Black", ",", "Automatic", ",", "Black"}], 
         "}"}]}], ",", 
       RowBox[{"FrameLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
         "\"\<Year\>\"", ",", "\"\<\[Degree]C\>\"", ",", "None", ",", 
          "None"}], "}"}]}], ",", 
       RowBox[{"LabelStyle", "\[Rule]", 
        RowBox[{"Directive", "[", 
         RowBox[{
          RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
          RowBox[{"FontSize", "\[Rule]", "18"}], ",", "Black"}], "]"}]}], ",", 
       RowBox[{"Epilog", "\[Rule]", 
        RowBox[{"Text", "[", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"\"\<b) delta SAT \>\"", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
              RowBox[{"FontSize", "\[Rule]", "20"}]}], "}"}]}], "]"}], ",", 
          RowBox[{"Offset", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}], ",", 
            RowBox[{"Scaled", "[", 
             RowBox[{"{", 
              RowBox[{"0.90", ",", "0.95"}], "}"}], "]"}]}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}]}], "]"}]}], ",", 
       RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}], ",", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"CW85Results", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "9"}], "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "2015", ",", "2300"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Black", ",", "Thin", ",", " ", "Dashed"}], "}"}]}]}], 
      "]"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.823368127059766*^9, 3.8233681367227793`*^9}, {
   3.8234337968764515`*^9, 3.8234338136974754`*^9}, 3.8234339202266254`*^9, {
   3.823435497328023*^9, 3.8234356632022567`*^9}, {3.823435745906373*^9, 
   3.8234357585883913`*^9}},
 CellLabel->
  "In[2001]:=",ExpressionUUID->"e1821d0b-b5b1-4d3a-9c5c-ddf9a903ffa4"],

Cell[BoxData[
 RowBox[{
  RowBox[{"LLtemp", "=", 
   RowBox[{"LineLegend", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Blue", ",", 
       RowBox[{"Directive", "[", 
        RowBox[{"Blue", ",", "Dashed"}], "]"}], ",", "Red", ",", 
       RowBox[{"Directive", "[", 
        RowBox[{"Red", ",", "Dashed"}], "]"}], ",", "Green", ",", 
       RowBox[{"Directive", "[", 
        RowBox[{"Green", ",", "Dashed"}], "]"}], ",", "Black"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{"\"\<D16-calc\>\"", ",", 
         RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
         RowBox[{"FontSize", "\[Rule]", "16"}], ",", "Black"}], "]"}], ",", 
       RowBox[{"Style", "[", 
        RowBox[{"\"\<D16-calb\>\"", ",", 
         RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
         RowBox[{"FontSize", "\[Rule]", "16"}], ",", "Black"}], "]"}], ",", 
       RowBox[{"Style", "[", 
        RowBox[{"\"\<D13-calc\>\"", ",", 
         RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
         RowBox[{"FontSize", "\[Rule]", "16"}], ",", "Black"}], "]"}], ",", 
       RowBox[{"Style", "[", 
        RowBox[{"\"\<D13-calb\>\"", ",", 
         RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
         RowBox[{"FontSize", "\[Rule]", "16"}], ",", "Black"}], "]"}], ",", 
       RowBox[{"Style", "[", 
        RowBox[{"\"\<D07-calc\>\"", ",", 
         RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
         RowBox[{"FontSize", "\[Rule]", "16"}], ",", "Black"}], "]"}], ",", 
       RowBox[{"Style", "[", 
        RowBox[{"\"\<D07-calb\>\"", ",", 
         RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
         RowBox[{"FontSize", "\[Rule]", "16"}], ",", "Black"}], "]"}], ",", 
       RowBox[{"Style", "[", 
        RowBox[{"\"\<Fair-Geoffroy\>\"", ",", 
         RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
         RowBox[{"FontSize", "\[Rule]", "16"}], ",", "Black"}], "]"}]}], 
      "}"}], ",", 
     RowBox[{"LegendLayout", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<Row\>\"", ",", "2"}], "}"}]}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.8234449336258307`*^9, 3.8234450663630185`*^9}},
 CellLabel->
  "In[2002]:=",ExpressionUUID->"40f21b70-237a-42e8-b2c2-4f4f67582b57"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SIFigureZECIPCC", "=", 
  RowBox[{"Grid", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Text", "[", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<ZEC: 420 Gt CO2 from 2018 until 2026\>\"", ",", 
          RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
          RowBox[{"FontSize", "\[Rule]", "18"}], ",", "Black"}], "]"}], "]"}],
        "}"}], ",", 
      RowBox[{"{", "SICWCplot", "}"}], ",", 
      RowBox[{"{", "SICWTplot", "}"}], ",", 
      RowBox[{"{", "LLtemp", "}"}]}], "}"}], ",", 
    RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.823435855983528*^9, 3.823435951877663*^9}, 
   3.823445071784026*^9, {3.8241916115870934`*^9, 3.8241916342881737`*^9}, {
   3.824191696215638*^9, 3.824191696467532*^9}},
 CellLabel->
  "In[2005]:=",ExpressionUUID->"b44deddd-eb95-4a6c-ad43-be4019809d21"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     InterpretationBox[Cell[BoxData[
       FormBox[
        StyleBox["\<\"ZEC: 420 Gt CO2 from 2018 until 2026\"\>",
         StripOnInput->False,
         LineColor->GrayLevel[0],
         FrontFaceColor->GrayLevel[0],
         BackFaceColor->GrayLevel[0],
         GraphicsColor->GrayLevel[0],
         FontFamily->"Helvetica",
         FontSize->18,
         FontColor->GrayLevel[0]], TextForm]], "InlineText",ExpressionUUID->
       "8972496e-f9ea-453a-87dc-8bb58af55c4c"],
      Text[
       Style[
       "ZEC: 420 Gt CO2 from 2018 until 2026", FontFamily -> "Helvetica", 
        FontSize -> 18, 
        GrayLevel[0]]]]},
    {
     GraphicsBox[{{{}, {{}, {}, 
         {RGBColor[0, 0, 1], PointSize[0.006944444444444445], 
          AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJw12HlYzdkfwPHbImlDklTSKIlWIVrUpyYRioqUYrjWQkaSpqlUJFpsLbb4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           "]]}, 
         {RGBColor[0, 0, 1], PointSize[0.006944444444444445], 
          AbsoluteThickness[1.6], Dashing[{Small, Small}], 
          LineBox[CompressedData["
1:eJw113k0V1sbB3AkU0KhJI2X0KDC1SB6cg0lpTcUrhRJJZWkMiVJUlGRUOLs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           "]]}, 
         {RGBColor[1, 0, 0], PointSize[0.006944444444444445], 
          AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJw113tYjVkXAPAuukwSmtCXJOmmiWJIui5dlEihSUgkQzUxpFyTgxxHUxKl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           "]]}, 
         {RGBColor[1, 0, 0], PointSize[0.006944444444444445], 
          AbsoluteThickness[1.6], Dashing[{Small, Small}], 
          LineBox[CompressedData["
1:eJw11Xs4VdkbB3AhGSJJiKKbUqmEcun2Rg4hyUh0UVNIUpkYKSo1knJqVEjC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           "]]}, 
         {RGBColor[0, 1, 0], PointSize[0.006944444444444445], 
          AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJwt1Xk8V1kfB3AUSYtWWaJ1pL0oScWXKRlJ20SqKUOUFiSPajIyRlnKkrUx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           "]]}, 
         {RGBColor[0, 1, 0], PointSize[0.006944444444444445], 
          AbsoluteThickness[1.6], Dashing[{Small, Small}], 
          LineBox[CompressedData["
1:eJw11Xs4VlkbBnAiJGSaoqORTqivUUmiw0OFkDBFSoUOVIiYHFIiVEKFJGSv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           "]]}, 
         {GrayLevel[0], PointSize[0.006944444444444445], AbsoluteThickness[
          1.6], LineBox[CompressedData["
1:eJw11XlYTlsbBvCkEgqlSMVJuaKEJBpUnjpIhCTJUEimhExFkihpQpOEtNci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           "]]}}, {{}, {}}}, {{{}, {}, 
         TagBox[
          {GrayLevel[0], Thickness[Tiny], Opacity[1.], 
           Dashing[{Small, Small}], LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQvTu4jZGhZr7DV6YvdpHRXQ5sh2ebG7Qj+IFGG3MT
JiH4TrzPNy5aheAX/3yc5XkQwXd2zUypu47g5/b+NJ36HsHPKdaw42BeAOf7
zYs8a8aP4P//ca5GRxrBD7yzPC1EDcG/YNtmk2uE4L9XP+GzwxbBv+voV3vK
A8H/efPmzLMhCP7WXyc+MCUg+PNm7jXWzEHwwzO+TROrQPA37J9kYtaM4JtN
Ndnn1o/gx3y2bOqchaT+vIvR3mUI/uXbk5l2bELwpxW48T7di+C3Nf9jZj6F
4IvLS5kGX0Xwy19VtmU9QPBZTO4fLnqD4BuxrbBe+x3B7w0rm3+DeSGcv/1a
h/JpfgS/8f6/h++lEPzKtKoeVnUEX7AsstDXCMGv2FpTFmOL4PMUL02P8UTw
HXcaTu4LQfAX1x5etTEBwV96ascfthwEv8z9U55yOYJf6mR41qAZwRc5djm1
oA/Bf3C8+tWCWQh+zc/0/hnLEPwdm7fnHdqI4Cu+4bG6uxfB11p71F7rJILP
PO9Qqt0VBJ+T92i58wMEfz2L9pGq1wh+5tvNiXs/IvjK12z+//+O4AMAdGiJ
7A==
            "]]},
          Annotation[#, "Charting`Private`Tag$497328#1"]& ]}, {}}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{2015., 650.},
      DisplayFunction->Identity,
      Epilog->InsetBox[
        FormBox[
         StyleBox[
         "\"a) atmospheric CO2\"", {
          FontFamily -> "Helvetica", FontSize -> 20}, StripOnInput -> False], 
         TraditionalForm], 
        Offset[{0, 0}, 
         Scaled[{0.8, 0.95}]], 
        ImageScaled[{
          Rational[1, 2], 
          Rational[1, 2]}]],
      Frame->{{True, False}, {True, False}},
      FrameLabel->{{
         FormBox["\"Atmosphere GtC\"", TraditionalForm], None}, {
         FormBox["\"Year\"", TraditionalForm], None}},
      FrameStyle->{
        GrayLevel[0], 
        GrayLevel[0], Automatic, 
        GrayLevel[0]},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImageSize->600,
      LabelStyle->Directive[FontFamily -> "Helvetica", FontSize -> 18, 
        GrayLevel[0]],
      Method->{
       "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
        "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& )}},
      PlotRange->{{2015, 2200}, {650, 1000}},
      PlotRangeClipping->True,
      PlotRangePadding->{{0, 0}, {0, 0}},
      Ticks->{Automatic, Automatic}]},
    {
     GraphicsBox[{{{}, {{}, {}, 
         {RGBColor[0, 0, 1], PointSize[0.006944444444444445], 
          AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJw913lYzlkbB/CUyhJCJYSyNEkiWwtvvkOZxpbSGOOV7DsVCdUkTZKQZBlD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           "]]}, 
         {RGBColor[0, 0, 1], PointSize[0.006944444444444445], 
          AbsoluteThickness[1.6], Dashing[{Small, Small}], 
          LineBox[CompressedData["
1:eJw113lYj1kbwPFsyZZlRCIyyhalmMRQd4umfVooSqHNMsg2MiKpKJSKSpSe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           "]]}, 
         {RGBColor[1, 0, 0], PointSize[0.006944444444444445], 
          AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJw113s8VVkbB/BTTCKVIimXhFcilTJdZZ50HSkqoTJCNyNJ7skk5ZLuGULF
XiuUGhNJNck1UppeI6mIpKIpIYx7t3e/4+f8cz7fzzn7s9d+1m89a6+JzrvW
bB0skUg0Bkkk///+9xMokONHh11falp++Nf7BWrQSq9eYP2x3yECqUX8E5Bc
Bh8SSNKqnt2r19rvowJpsxRXGTf4pECnLdaGel6FowRSt1c669YLxwoUYGA+
6/Witn6fE0g6Idci/yTMBEogA9OOl3CSQLMibpXvMGrvd4pA67KC5o4JhVMF
UpWZ15b3HE4XiOs2K3KDf/qdKdDe6Pz17/3gPwS67ZT++F4enC3QU7NVPT9L
dfQ7X6C1S/TTP5nBRQLZL2twurgPvi9Qj+fHL9E34Ifi/R93yH5shMsEyhzV
91ulame/KwQKdDC47vcjXCmQr8em1I9ecI1A78KsKp3PwnUC3Vx47Mf2PLhe
rI+6dn3OK/idQL2W0j/XS7r63SRQSKF+0EF1uFWgkgd7sm/OhjsESjRxvHLO
Eu4RaP1Bk9cWW+HPAn0zDGl+5Q9LGLmHpvt4H4YHM8qOb5utdgaWZjTH+pJC
60V4CKMNPG3wkEx4KKPGeCdTr1xYjtGeyEA9i3uwPKODjsWOSaXwCEbKx0Lu
H6+AFRgtMCw8pF4Fj2Z0qtlNxbkGVmIku/17s521sDKjA002+pYvYRVGJZ06
1mMHPJ7RpqXeFytewGqMev+u8omuhjUY7ZK7E7S9EtZkVFOxqdd2YDxajJIN
/U54/QXrMHLZM8ituATWZTRhxZV59oWwHqNJfWRI2bA+o/3DH34LHKjPFEY6
2/78rJYKTxU9XGOQfiI8nZFqaF3Q73HwDEbb9+iFpZ+AjRmlsfO580PhWeLv
iYo+tgHwHEaa5dlxw3bB8xg1eCYXbdoMmzAydCmZs9EWNmW0+6Ph39IrYGI0
1OjF7s2msBmjX2xKpv5iBC9mZF8Zo2+nAy9lZJS+zqBPGV7OyGbsmGsusrA5
o//4+Qy+9An5tWA01kBZNb8ZXsUo8GpHQcZL2IpR/JsbwaGP4DWM1j94lWpS
CFszOsq+bKrJhG0YSZ26eNDlAmwn1i/rVGl9DLyBUcGX3fesI2B78f8T64pv
B8AOYr1ua/equcGOjBI92jft/Ql2ZtT0j0ZF1Sp4CyPbhXNl5hO8TXyew5qh
3Ah2YfRyQfj1kdqwK6Mt7OcX4Uqwmzgf1n6a8kNgd0YTl3kcSOhG//BgNNnG
5x29hz3FvGqtHN/5HPZm9MopvjD7Iewr5nvYOJ+4XNif0drixOSj6XAAI4U3
rtdizsOBjFabdNTfjoL3Mbplpe3aFwbvZzSrwfgn6z3wAUYW+64WPtgBhzDS
/WxzwsEBDmMkl9iboLAaPsTo7jP7vFeL4MOMAp5IpZbPgo+K+WF9I+snw8cZ
XfONCVNWh08yqv5mfM5VAY5kVOXbUFo30J+jGO2Un3BiTzf692nx+iwn+v4D
HMvo5p2nc5VewmcYnZZrLFZ+DJ9jZHLqxaQF9+AERvoGtpHht2EmzmfWO6Ou
NPg8ozsjf9WLSIKTGJVdXnSC4uALYn72rvRVOw6nMPq1qqZB7SB8mVHbi221
C/3hVHG9mCitP7ITviL200eTlvc6w+li/b5zijliB2cw0jbcMMVs1cB+xqhZ
6s1btcXwDXF9edpy1XkD+xuj1Iz26abT4SxGGoMmbAvRHdjvGHU3F8i3qMG5
jFr9QpsCFOF8RkFDNUr05eA7jOw8jjl/kcBFjGQkm33au7HfFjOKedaTJfsR
vs8oMvzKe7O38ANGcWoTr8e/gB8y0rriWDruCVzKqCdcu/7GQ7iMkcd33ee9
i+ByRtuM3a+vyYYrxH61blWRVSb8VNxvVt7ydU+FK8X5mWDj+VsS/JxRXoDf
Rpl4uEasjz89CY6Gaxk5x94LHn8crhPzLTNn8KMw+DUjM/O2rqQguJ5Rjl3y
t2h/+C2j58Y+txN3w+8YBSvJl/zXFW4U+/ukW8WKW+AmRnNlDq3x+QluEfNd
byvXbgO3MkrwbTsSYQW3M3LLUfWZbw53iOv7YtpmmcVwF6Mf4y93Ni2Ae8Q8
yFDJh9lwH6OrZe8DpWbAnxnt7fNLmzkF/ir2d5ogCdSFJZx86sJG1GjCgznZ
RDwJWKsKS3NqDcxpeDUGHsIprim8NUwBHsppcdyEBWbDYDlOBnnj3RWHwPKc
6q2LdPsk8AhObsk6w7o+4X1PgZOHhWz+kG54NKeys/IfDNphJU7Ku8/N2NoM
K3PaHiwxzXgHq3Aar+V4fXQ9PJ7TsKh7C8MG3ifVxOd5NuWYfDWswWnicG+z
5KewJqdsN6/hVuWwFifTR11n5EthHU4n6u/EPi+BdTmdb4q5fusurMdpyw/G
/FIBrM/pvpON/OUceAqnKU9zU7JuwVPF50kwmlx9HZ7OydDLb+GwDHgGp9m3
HS6YX4GNOZ2Zlz087jI8i1PdoR1Tuy7AcziFmlvmOyXC8zgZzVwdWC3AJpx8
HzupbT4Hm3JqM/bf2BMLE6eoZac6z0TDZpz+1Eq7aB4JL+Y0Sr1ymswJeCkn
p+wxK8uOwMs5VQd75SUfgs05NUZ+WRYeCltwGmqWl+J9AF4lPu+egqSdQbAV
p39kZCWegfAaTgufRQUF74GtOa2Rtn9/1he24fSsfoV0gRdsJ+alc0lsqwe8
gdOtG+ru+u6wPacQz9OW7jtgB3G83Y4y2S6wI6evC8c5KW6DncX5Vlw82Xsz
vEWsT4iFYa0jvI1TaUjw/NUOsAsntlZR+78bYVdOwS0KmavXw26cRvptzau1
gd3FvJ16ouxtDXtwksr9fHTUGtiTk+SSeecNS9ib04q9Ep0tK2FfLp7Xprao
rID9OTXFpU1+shwO4PRUX//32KVwoLj+MmStNi+G93HyfvNLo7EZvF8czwG/
dcMJPsDpbGqya9MCOESsj6KXdPl8OIzT+iVSX3Pmwoc45TVOm5k+Gz4sjn90
2P6U7+GjnJb5LCq8MBM+zim6eG3VZSP4pDg/X1fyzGlwJKfLV3b3FRrCUZza
bZOKKg3g05zm33Wva58Mx4r5d+2bOloPPiPev2RE5CzdgfMmJ93KEU2bdOAE
TibeXROOaw2cPzmtLLcdVaAJn+f0qdcuqUdj4DzKaeaSqznG6vAFTrJvL5j5
qMIpYh495cdljYMvc3rgbzpJSgVO5fRNaaK1lTJ8ReyXUerhXAlO55Q2TjOl
azScwWm4RbRgOQrO5LREzsUmdSR8g9Nj3W/X5UfAf3Cy0p+f4iEPZ3Gapu49
tlIOzuZ0yc6vxUwWzuXU4hCqclUGzhfnO8syWGsIfIdTWEOXUow0XCTmadbQ
/BFScLHYTyr37ooYBN/nVFuYoSAjgR9wmlHsfSr8K87/DznlHGl5KfcFLuV0
LSOt8eQnuEysf0MKG9cHl3PS+TS5LakHruD018S6P2d0w085FchXaBZ2wpXi
9VNc6tZ1wM85VX2w+dTYDtdw0utOdz7QBtdyuhFWLaPWCtdxUrl2vOZmC/ya
09q/Hpeva4brOak+kHrR+QF+y+lD9N3mmEb4nVjPGPme+e/hRk5cfezHV3/D
TZw0qtyKI97CLZy+2/Ji98wGuJVT5/19DbVv4HZO/oqpY46+hjvE9fZWqnve
K7iL02qV7fs+vIR7OHXYdLP42tYf/gcw7zhb
           "]]}, 
         {RGBColor[1, 0, 0], PointSize[0.006944444444444445], 
          AbsoluteThickness[1.6], Dashing[{Small, Small}], 
          LineBox[CompressedData["
1:eJw113k4V9kfB/BvUowkRItU1mgZUwYpyqeSNiRJkjElql+U0jIqJRIVU9Ki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           "]]}, 
         {RGBColor[0, 1, 0], PointSize[0.006944444444444445], 
          AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJw11gs0V/kWB3BJmBhL8c/4Z8gjRcVMSophT8noMVRXhqasHjIWt1ITRSmP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           "]]}, 
         {RGBColor[0, 1, 0], PointSize[0.006944444444444445], 
          AbsoluteThickness[1.6], Dashing[{Small, Small}], 
          LineBox[CompressedData["
1:eJw11X081+caB3AnD2E5iVghpRoq51eE4yG5XtasUdZphqyjJ5rHodU8tSWa
Vic9eTjVGfdFJYpDkTA1T5UabXX0ZGo/pZJ+/VL9ZmbifNvv0/16fV/f1/uP
7/e+7+u+7uuyWhu7PGyMhobGYel5/f5zbBa0+llI7KsupeefThU0Y+axObPK
nqm9TdAp7YfKRM9+tb8RFDSrfsFIMbxLUMT5rR72xs/V3iuo7mSexztfwdmC
ct1NQvf1wQcEfaA5vHdF0Au1vxWk6qjRCr0Is6AOpfXMg39/qfYRQenTf/O6
XwwXCxo+XPS5zFyldqmgVr2zDeN3wxWCXKoNf1iihKsELfA3XTF+4a9q1wiK
bGp7uWgLXC8ouuh50NFKuEGQ3HiuR00X3CLoQb9efOcfcKsg468Dk7yMBtRu
E/TY3vm4lhX8k6ClPz+5ajoL7pDi0Zq/5aM58C1BTZP+3b/ZFu4SFD4xq8zz
zfdyQeXjquSOpnCPoMx8juoZC/cKovdLWi4MYD0KQS82jinwvg/3C8oK2Brf
1A6rBJWmVFVnVsODggx/LZ33Ig8eFjQ/IkA5bxuswRTdf80zPQIew3TR8flu
cz9Yi+mo/pZp1g6wDtPO2GcNl0xgXSbHvO0htr8j/vpM1u36Wau64HFMH4si
yx3fw39lsrc59fF3hbAhU/6PRWl6GbAR0z+1sz22RcATmXIi7epcl8KmTBuu
RBs428OTmBLvNEalm8BmTGOsklbPHkL+WDCtneo4av8LbMn0eEiatQWeJu0n
87hz0nF4OpNtYpNJ4154JtPis7djkhNga6a7k5e5HguBbZlK3d8+v9gbns00
f/zZC6tksB1TyvaxcQpTWMak/0loqnIU+T9P2p9VuH/YY9iBqUC57+WH/4Md
mdZ3p1mUnYWdmZwmdXyYUgy7MH2iqrhdkwW7MfVmB3au2wIvYNpzPW9pchS8
kCnuUc6EoUCYmGprIxXyRbAX01s3duyzc4AXMe3QlRV1ToW9mZqmrDzfawAv
Zjo4e026/zDuuw+TpUweZ/4EXsJUH5Yyxb0T9mMyXDnT7OQleBnTgd0WfyTX
wsuZmpPKV+SWwP5M3X1l1zUOwQFMx/ikac1OOIjJJH1ue20KHCzNNz6kUjMG
XinF45UqMysEDmFqz75s9+kyeDXTjMrlUZu94LXSfiZr2l91hEOl/LLh+HU2
8Hqmq/KNf7M3g8OZjC4mxrsYwJFM2y+EBSZowNHS+S9o0Fa8RP38jCm++1p5
9iM4jqlwHufE/gxvYNKtvayZ8iO8kenRfzZ9dLoZ/oJpJMiyz6IGTmRy641z
rSiFk6X4a739fUwBvJlp9WfpWv658FfSfe2uzV/zLziVydd3oiwnFU5jsrqn
HfJ0E7yN6d7XXT3hUXAGU8L91HSdNW/6A9PyKift8wHwTql+xAZ4Hl7ypl9I
9eWMyQT2gnczlZxzX1fnAu9l8nnQY/NcBu9nyj1Nwe++A2dL+RD7j5FycziX
6Y536TRnI/gAU1eM240OXfiQdF8tBxJMR9HPvmW69c2upxUKOJ/pldf09Qmd
MDNdaQz7ILwVLmSq+jLAIK0aPsJkManDqfkIXMQ0MDrXf3YWXMykxY061Vvh
49J+Lb8cDI2DS5l0Tu2SO62C/yvlyx7FVhs/uEKKV6TeCRcP+BSTZtYap3A7
uIrpTI6t9mlzuFrKjw1PdS3fgmukeuT7rmvhEPp5HdPnB6MPUB9cz7SxUddh
8DZ8TsrPqS1mrZfgBun8Q/XjymvhJqaY974LLCuBW5jux3ePNhyELzBNOBeV
/3gH3MoUnNIbZ50MX2YKUXrVfxEJt0nrvZnWdjsYvsKU/SpT5ecL/8S06cyT
zOvu8DVpPYE7B6Pt4A6m35IzDk2cAt+Q/jdH9csPBvAtpsvnStz2jzxVu5Mp
NXHc9E+fwV1Mge13jXzk8F2m/iWGe9yuwnKmJIs9U1ya4HtSPfrdzMerEu6R
+kPt5KNBR+CHTM6uMc3JOXCv1G8qfRYWZ8B9TCdijSvlCbCCKeqirHlGBKyU
6k3EA+P4YLifKfSOh1+rL/yCKc2903KWB6yS+sXYm05ZMniA6X27E9460+BB
pjojPd20CfAQU159w3wdTXj4df0szNivUqg9wuTgEdZg/RDWKKCe97Yfbrqp
8Iwxlddl/KWA2tteD4Xn/wHMG4iz
           "]]}, 
         {GrayLevel[0], PointSize[0.006944444444444445], AbsoluteThickness[
          1.6], LineBox[CompressedData["
1:eJw913s8l2cfB3CzDrMKSaWT1NRT0cnKWgc+nSTRmppEk0o5rIMOzDqNomjm
lNMk93VJJSFJopFDSkkIk2R7JCsrj6STPOi5nnV95x+v9+vH/bt/1/fwuX9j
Nmy33qSqoqKi+5GKyv9///2zT4Hjc4ft3fWtpn/bW8GC6lk3TXc+/2BfBQkP
8jzte7d9sL+CJgun0x3W0oEKqtquLVeLlw5RULexf/W8l9LhCr5JemXQbPbi
g6MVHHg9Mfp4rHSs+H9D5bjWK2kmru+Rnqtr1f7BCQqaxwYHKGekExWUWYZr
Tvz45QcnK8ge/6rK0Eo6TcH9t+nadXukMxRkFn/uejRCOktBxZYlao4npXMU
5DTPXOmRKJ2vYPUoo1PHzkgXKQjYscTvVLz0TQWXx3jlvo+RLlUw9suBw0ND
pSsUzNjeNkT1iHS1gsLMqskle6VrFRzym2Vr4i5dr6CnVG3AcSfpBnG93v+d
0W+NdJM4z5Wu6in0+ZoVGO3UOR2xQLpFQZ9pVSurvpBuE38/YPHh7ZOlXymY
+mfKQPfPpDsUDN9oMK52mHSXglkeoe8TNaVVGFTnuns09pVWZXimU7Xq0Ht5
/r0YpvbKOR/wVroPQ6dt46CXz6U/YTD+7IeMnGbpTxkmjD8Q8OihdH+GCykT
nZ0eSKszlCRu1Zj7m7Qmg/bUNybO5dJaDG/qCzIbb0lrM1RN0l94rkh6CIOm
2t383DxpHYaNhW56Q3+VHs6Qv6bVJSNTeiTDyrxF2WHp0roMwWzK0vOp0noM
P7++6Nr3nPRYhvYqY79o6j99hvCY+aMdE6THM7S1jK2259ITGFLZJtuAOOlJ
DMPtp3o9Pi5tKM5LJ2jIjl+kpzAU3L9i+K8o6WkMq8fZ3OoTIW0kXu/iGurH
pGcwNJf/ajwnVNqYwWRvrX9gsPQs4dRDG1SCpGcz3Cl+ND0iUHouw8F7qp5L
f5I2YXg0f9TVEUelwbDg6zeJnwZIL2B48ZtRk7a/9CKGXW3ZBl8ekTZjWPjX
iKWeh6XNGZx032vd9pO2YOhbGbbFmGzJcDG/7+LLvtLLGQZZqUdZklcwlA61
c3l9SNqawaJy0q008ioG8xF1VfvJNqJ/jLcl25NtGRw2T/deSrZjsC+w8jMj
rxX1s97a+TXZQdTH0mH8d2RHhh9n/Lo6lLyBobw8suka2YlhZKLBJFW6382i
/qrBgcvILgyZBs6eCtmNYcTvCbbd5C0M17NNk5zoPLYxBCW8flJNdmf4oqZ/
uBWd506Gu/E6xmXk3QwGufl2NnT+ngxazUeP/Un2YjjSddpzL9VrD8O/dXPj
hlI99zG4Db6alE0+IOqVcGneeqq/N8OJurieAdQfB8X9GM+OziP7ivMN+TPL
g/rpsPh8Vz20pv0s7S/e79ZAu1byUQaWq2GeRv0YyFD3V2WUB/VrEINK1Lm+
JiHSIQyN2lm2atTfYQzztYuX3yOHMxzHnLQzYdKRDGf7tS3eQ/MRLeYlZvSD
5eHSMQw2ZUvnjaN5imX4w3rk3G5yHMOOdPuzNZHSjKFw7R3bCzSP8QxdkWP1
fo6mPGKY81VTjSvN72mGyKJ1NktiKJ8Y9vcc+2EczXuSmJdP9Eb1ipVOFvPW
Mn30I3IqQy9Hz3WFJ6TTGIx01fI47Y90htfNm/R8FOkMhsAJds6OTDqTIe2z
t16mtH+yxPkV+87RjZe+wuDZszuyi5zD0OG3emfdSemroh5WZVmXaZ/lM9Ra
HFwVfkq6kOFlvs5099PSRQyL30+Ys4z24Q0xD4eNHMclSt9kmB1xLKiHXMLw
yUjvSzVnpUuF+78rSkmSLmM4o1KUcoj2bYXYxws3rrdNlq5k0NVTrzRIka5m
uHL0bHs3uYZhysCCzDLa37Vifw711oo7L10n+tX2XOd3adL1Yr6TY5xmXZD+
Q9yP5udmH1MeNDC4PG6IKCU3MqjtCbMIvyjdxGCdmW5vlyH9WOTdYP0C3UvS
zQzxRXN2PSQ/ZfDvzHGLp/xpYdA7UM3WX5ZuFf1oq60xOku6jcEse/v5OnK7
2H89xvvCs6VfifN9Osjd8or0G9FP3b0Pq1LedTDEvnPIziR3iv3nk9fbNUe6
i2HRo0HOw3Klexg2q4TeLyarcNitvLBm91VpVY7DQ4yadClfe3H4+Wt6FpP7
cDy2ONJ/Wz7lP8fV+/1OaRVQ/nMU6VvOu0Tuz/HU2LDqm0LKf462rmtOr8ia
HAf0vm0LuUb5z7HknftuA8p7bY6toaefX/sn/znUCyoc7a5T/nOo2LXcaCUP
54hz1R3jc4Pyn2ODf/q2gcWU/+LzmAw7r5D1uHgeevzQ4CblP4fyrrxPJlmf
Q18jeZQJPY+M57DRdB9fRJ7ARb9PHWNeQvnPYVqho15CNuSo1vb6z9LblP8c
Y1ov5BWTp3HYOyzyW1hK+c+Rv+K6SS55Bod58MOWGXco/zlci+1DksizOK6F
9JukW0b5zzHbt/5KMHkuh6rdnYXvySYcsRrPr2+h5y2I99dxWlBLXsAxLWLd
lfkVlP8cOqH6U8+SzThalvWOV79L+c+RemSD9k6yBYdufdKRKrIlx7LBdt1G
lZT/HNHHOjxDyCs4vr80/M0zsjUHzBz3La6i/OdIfrGr3wmyDcfvuZ+eaifb
chwKeGRhVk35z3Ex9EZPFHktx+B3voVPyA4cl206ombS86cjx0ozVR8f8gZx
fZXAH2+TnTjUXvtFDKqh/Ofo5fykaA3ZhUNTK1UjjuzG4VD2+/cN5C0cmbO9
3+vdo/wX/eSWkLiO7M6xOczBI5a8k6Mhv9j5Hnm36Mfgbh/NWsp/jrx/j7mx
hOzFMfaYnfF+8h7xutXd6jTyPo70mRdPNpIPcIRmTjuldZ/yn2O6+f4HIB/k
GD6z3Hwr2Vfcj/O651Hkw6J+M13v5pP9OSwnT3rxhHxU+K+HKwbUUf5zTGq4
2z6NHMQx98t5963JIRzxJ1367CKHcdhOidkXSg7n8B49zCSVHMkxuWKy1S1y
NEdtwJjkRnIMR+d6k287ybFiHkeUb9Ck7x9xYl56jc7TJzOOnQ9+2P0FOZ6j
JMXAz5ycwGGQ7/1yNfk0xwT36wWbyInieqPM2neQkzgsNL86so+cLOZpneEh
P3Iqh3P9xOZAcprYfz1hWWHkdI5vStLfRJIzOKzzqxJ+IWdyGN40vR5DzuJI
0IPdP77CEbxs1OZocg5HT7fus3DyVdFvGoHPgsn5HE1uSa4B5EJx/x/lOfuQ
izhGZQ1o/p58g2PiuvstW8g3OXawjV6O5BKOxtctgdbkUo7SExmGC8llHEGB
HWuMyBUca51eD9EjV4r+cHu8qT+5WtR3b++lb6meNRwjev9U2ECu5bjXkVJ9
k1wn8uf6SZ/z5HqRV1+z2+HkPzg6Wn/L8CI3iPxY5WFqT27kuBSVsnUuuUnU
d3zy/JHkxxwu+bG5ndTvzRwHt519dI/8VNT7x85LF8ktHL7emcZB5FaOVbNV
XZzJbRzlZ1UsTcntHIldlU2Dya84Pv4pesYzmt83HFo12+blkTs4xvns+ChM
+H9ihmo1
           "]]}}, {{}, {}}}, {{{}, {}, 
         TagBox[
          {GrayLevel[0], Thickness[Tiny], Opacity[1.], 
           Dashing[{Small, Small}], LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQvTu4jZGhZr5Dwvu4/L933tmzHZ5tbtCO4AcabcxN
mITgO/E+37hoFYJf/PNxludBBN/ZNTOl7jqCn9v703TqewQ/p1jDjoN5AZzv
Ny/yrBk/gv//x7kaHWkEP/DO8rQQNQT/gm2bTa4Rgv9e/YTPDlsE/66jX+0p
DwT/582bM8+GIPhbf534wJSA4M+buddYMwfBD8/4Nk2sAsHfsH+SiVkzgm82
1WSfWz+CH/PZsqlzFpL68y5Ge5ch+JdvT2basQnBn1bgxvt0L4Lf1vyPmfkU
gi8uL2UafBXBL39V2Zb1AMFnMbl/uOgNgm/EtsJ67XcEvzesbP4N5oVw/vZr
Hcqn+RH8xvv/Hr6XQvAr06p6WNURfMGyyEJfIwS/YmtNWYwtgs9TvDQ9xhPB
d9xpOLkvBMFfXHt41cYEBH/pqR1/2HIQ/DL3T3nK5Qh+qZPhWYNmBF/k2OXU
gj4E/8Hx6lcLZiH4NT/T+2csQ/B3bN6ed2gjgq/4hsfq7l4EX2vtUXutkwg+
87xDqXZXEHxO3qPlzg8Q/PUs2keqXiP4mW83J+79iOArX7P5//87gg8AA2TW
6A==
            "]]},
          Annotation[#, "Charting`Private`Tag$497597#1"]& ]}, {}}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{2015., 0.9},
      DisplayFunction->Identity,
      Epilog->InsetBox[
        FormBox[
         StyleBox[
         "\"b) delta SAT \"", {FontFamily -> "Helvetica", FontSize -> 20}, 
          StripOnInput -> False], TraditionalForm], 
        Offset[{0, 0}, 
         Scaled[{0.9, 0.95}]], 
        ImageScaled[{
          Rational[1, 2], 
          Rational[1, 2]}]],
      Frame->{{True, False}, {True, False}},
      FrameLabel->{{
         FormBox["\"\[Degree]C\"", TraditionalForm], None}, {
         FormBox["\"Year\"", TraditionalForm], None}},
      FrameStyle->{
        GrayLevel[0], 
        GrayLevel[0], Automatic, 
        GrayLevel[0]},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImageSize->600,
      LabelStyle->Directive[FontFamily -> "Helvetica", FontSize -> 18, 
        GrayLevel[0]],
      Method->{
       "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
        "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& )}},
      PlotRange->{{2015, 2200}, {0.9, 2}},
      PlotRangeClipping->True,
      PlotRangePadding->{{0, 0}, {0, 0}},
      Ticks->{Automatic, Automatic}]},
    {
     TemplateBox[{
      StyleBox["\"D16-calc\"", FontFamily -> "Helvetica", FontSize -> 16, 
        GrayLevel[0], StripOnInput -> False],StyleBox[
       "\"D16-calb\"", FontFamily -> "Helvetica", FontSize -> 16, 
        GrayLevel[0], StripOnInput -> False],StyleBox[
       "\"D13-calc\"", FontFamily -> "Helvetica", FontSize -> 16, 
        GrayLevel[0], StripOnInput -> False],StyleBox[
       "\"D13-calb\"", FontFamily -> "Helvetica", FontSize -> 16, 
        GrayLevel[0], StripOnInput -> False],StyleBox[
       "\"D07-calc\"", FontFamily -> "Helvetica", FontSize -> 16, 
        GrayLevel[0], StripOnInput -> False],StyleBox[
       "\"D07-calb\"", FontFamily -> "Helvetica", FontSize -> 16, 
        GrayLevel[0], StripOnInput -> False],StyleBox[
       "\"Fair-Geoffroy\"", FontFamily -> "Helvetica", FontSize -> 16, 
        GrayLevel[0], StripOnInput -> False]},
      "LineLegend",
      DisplayFunction->(StyleBox[
        StyleBox[
         PaneBox[
          TagBox[
           GridBox[{{
              TagBox[
               GridBox[{{
                  GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1]], {}}}, AspectRatio -> Full, 
                   ImageSize -> {40, 10}, PlotRangePadding -> None, 
                   ImagePadding -> Automatic, 
                   BaselinePosition -> (Scaled[0.1] -> Baseline)], #, 
                  GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1], 
                    Dashing[{Small, Small}]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1], 
                    Dashing[{Small, Small}]], {}}}, AspectRatio -> Full, 
                   ImageSize -> {40, 10}, PlotRangePadding -> None, 
                   ImagePadding -> Automatic, 
                   BaselinePosition -> (Scaled[0.1] -> Baseline)], #2, 
                  GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0]], {}}}, AspectRatio -> Full, 
                   ImageSize -> {40, 10}, PlotRangePadding -> None, 
                   ImagePadding -> Automatic, 
                   BaselinePosition -> (Scaled[0.1] -> Baseline)], #3, 
                  GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0], 
                    Dashing[{Small, Small}]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0], 
                    Dashing[{Small, Small}]], {}}}, AspectRatio -> Full, 
                   ImageSize -> {40, 10}, PlotRangePadding -> None, 
                   ImagePadding -> Automatic, 
                   BaselinePosition -> (Scaled[0.1] -> Baseline)], #4}}, 
                GridBoxAlignment -> {
                 "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                AutoDelete -> False, 
                GridBoxDividers -> {
                 "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
                GridBoxSpacings -> {"Columns" -> {{0.8, 0.5}}}], "Grid"]}, {
              TagBox[
               GridBox[{{
                  GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 1, 0]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 1, 0]], {}}}, AspectRatio -> Full, 
                   ImageSize -> {40, 10}, PlotRangePadding -> None, 
                   ImagePadding -> Automatic, 
                   BaselinePosition -> (Scaled[0.1] -> Baseline)], #5, 
                  GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 1, 0], 
                    Dashing[{Small, Small}]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 1, 0], 
                    Dashing[{Small, Small}]], {}}}, AspectRatio -> Full, 
                   ImageSize -> {40, 10}, PlotRangePadding -> None, 
                   ImagePadding -> Automatic, 
                   BaselinePosition -> (Scaled[0.1] -> Baseline)], #6, 
                  GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0]], {}}}, AspectRatio -> Full, 
                   ImageSize -> {40, 10}, PlotRangePadding -> None, 
                   ImagePadding -> Automatic, 
                   BaselinePosition -> (Scaled[0.1] -> Baseline)], #7}}, 
                GridBoxAlignment -> {
                 "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                AutoDelete -> False, 
                GridBoxDividers -> {
                 "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
                GridBoxSpacings -> {"Columns" -> {{0.8, 0.5}}}], "Grid"]}}, 
            GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
            AutoDelete -> False, 
            GridBoxDividers -> {"Columns" -> {{None}}, "Rows" -> {{None}}}, 
            GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
            GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{1}}}], 
           "Grid"], Alignment -> Left, AppearanceElements -> None, 
          ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> "ResizeToFit"],
          LineIndent -> 0, StripOnInput -> False], {FontFamily -> "Arial"}, 
        Background -> Automatic, StripOnInput -> False]& ),
      Editable->True,
      InterpretationFunction:>(RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               InterpretationBox[
                ButtonBox[
                 TooltipBox[
                  GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                   "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                   FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                   FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                   Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                  StyleBox[
                   RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                   False]], Appearance -> None, BaseStyle -> {}, 
                 BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                 ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                   If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                 Automatic, Method -> "Preemptive"], 
                RGBColor[0, 0, 1], Editable -> False, Selectable -> False], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 0, 1], Editable -> False, Selectable -> 
                    False], ",", 
                   RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"Small", ",", "Small"}], "}"}], "]"}]}], "]"}], 
               ",", 
               InterpretationBox[
                ButtonBox[
                 TooltipBox[
                  GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                   "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                   FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                   FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                   Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                  StyleBox[
                   RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0", ",", "0"}], "]"}], NumberMarks -> 
                   False]], Appearance -> None, BaseStyle -> {}, 
                 BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                 ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                   If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                 Automatic, Method -> "Preemptive"], 
                RGBColor[1, 0, 0], Editable -> False, Selectable -> False], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0, 0], Editable -> False, Selectable -> 
                    False], ",", 
                   RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"Small", ",", "Small"}], "}"}], "]"}]}], "]"}], 
               ",", 
               InterpretationBox[
                ButtonBox[
                 TooltipBox[
                  GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                   "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                   FrameStyle -> RGBColor[0., 0.6666666666666666, 0.], 
                   FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                   Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                  StyleBox[
                   RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "1", ",", "0"}], "]"}], NumberMarks -> 
                   False]], Appearance -> None, BaseStyle -> {}, 
                 BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                 ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                   If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 1, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                 Automatic, Method -> "Preemptive"], 
                RGBColor[0, 1, 0], Editable -> False, Selectable -> False], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0.6666666666666666, 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "1", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 1, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 1, 0], Editable -> False, Selectable -> 
                    False], ",", 
                   RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"Small", ",", "Small"}], "}"}], "]"}]}], "]"}], 
               ",", 
               InterpretationBox[
                ButtonBox[
                 TooltipBox[
                  GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                   "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                   FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                   PlotRangePadding -> None, ImageSize -> 
                   Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                  StyleBox[
                   RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                   False]], Appearance -> None, BaseStyle -> {}, 
                 BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                 ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                   If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                 Automatic, Method -> "Preemptive"], 
                GrayLevel[0], Editable -> False, Selectable -> False]}], 
             "}"}], ",", 
           RowBox[{"{", 
             
             RowBox[{#, ",", #2, ",", #3, ",", #4, ",", #5, ",", #6, 
               ",", #7}], "}"}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"\"Row\"", ",", "2"}], "}"}]}]}], "]"}]& )]}
   },
   AutoDelete->False,
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellChangeTimes->{{3.823435925444626*^9, 3.8234359527576647`*^9}, 
   3.8234450725940275`*^9, 3.824191635243787*^9, 3.82419169726925*^9},
 CellLabel->
  "Out[2005]=",ExpressionUUID->"4e2f2601-fea4-4a94-a3fc-e631726118fb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<SIFigureZEC_420GtCO2.tiff\>\"", ",", "SIFigureZECIPCC"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.8234360634828205`*^9, 3.823436092726862*^9}, {
  3.8241916822287464`*^9, 3.8241916843379035`*^9}},
 CellLabel->
  "In[2006]:=",ExpressionUUID->"3075bd89-3484-4791-85e6-b682f38cd2ea"],

Cell[BoxData["\<\"SIFigureZEC_420GtCO2.tiff\"\>"], "Output",
 CellChangeTimes->{3.8234360948568645`*^9, 3.8234450792760363`*^9, 
  3.824191645028385*^9, 3.8241917023433723`*^9},
 CellLabel->
  "Out[2006]=",ExpressionUUID->"17ad73af-c87e-482a-a418-3c4e46f54b3c"]
}, Open  ]],

Cell["Overshot Plots", "Text",
 CellChangeTimes->{{3.71113575119866*^9, 3.7111357648642597`*^9}, {
  3.711171131470954*^9, 3.711171132484956*^9}, {3.712408724609439*^9, 
  3.7124087395614595`*^9}, {3.7662479249546547`*^9, 3.7662479290036545`*^9}, {
  3.810276061054193*^9, 3.810276074321699*^9}, {3.8167180604130163`*^9, 
  3.816718074126128*^9}, {3.8171501903508883`*^9, 3.8171502004843855`*^9}, {
  3.8234352506786737`*^9, 3.823435263659692*^9}, {3.823699844189975*^9, 
  3.823699849562482*^9}},
 FontSize->18,
 Background->RGBColor[
  0.87, 0.94, 1],ExpressionUUID->"56eef708-ac1c-4a48-8e2b-5fa84eba9649"],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "SetDirectory", "[", 
   "\"\<C:\\\\Users\\\\wilmsen\\\\Dropbox\\\\WR\\\\Research\\\\IMPOSE\\\\\
Results_Paper\\\\Overshot\>\"", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.8237007331177826`*^9, 3.8237007628728247`*^9}},
 CellLabel->
  "In[1071]:=",ExpressionUUID->"e0734672-5de1-454e-a0d7-55531a140512"],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "SetDirectory", "[", 
   "\"\<C:\\\\Users\\\\Rickels\\\\Dropbox\\\\WR\\\\Research\\\\IMPOSE\\\\\
Results_Paper\\\\Overshot\>\"", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.823769737550105*^9, 3.823769740258625*^9}},
 CellLabel->
  "In[118]:=",ExpressionUUID->"33c67dfc-31bf-4969-aafb-0652b90e668c"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"osD16medium", "=", 
   RowBox[{
   "Import", "[", "\"\<overshot_D16_CDR_mediumcost2300.csv\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"osD16low", "=", 
   RowBox[{"Import", "[", "\"\<overshot_D16_CDR_lowcost2300.csv\>\"", "]"}]}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"osD16high", "=", 
   RowBox[{
   "Import", "[", "\"\<overshot_D16_CDR_highcost2300.csv\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"osFGmedium", "=", 
   RowBox[{
   "Import", "[", "\"\<overshot_FairGeoffroy_mediumcost2300.csv\>\"", "]"}]}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"osFGlow", "=", 
   RowBox[{
   "Import", "[", "\"\<overshot_FairGeoffroy_lowcost2300.csv\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"osFGhigh", "=", 
   RowBox[{
   "Import", "[", "\"\<overshot_FairGeoffroy_highcost2300.csv\>\"", "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.823699856434992*^9, 3.8236998968010483`*^9}, {
  3.8237004517813854`*^9, 3.8237005885795784`*^9}, {3.823700771443836*^9, 
  3.823700781874851*^9}, {3.823878765579769*^9, 3.823878864419287*^9}, {
  3.823878903040989*^9, 3.8238789083243127`*^9}},
 CellLabel->"In[2]:=",ExpressionUUID->"61dc6c7f-56f4-44fe-85ac-b184d895cd3c"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"osD13medium", "=", 
   RowBox[{"Import", "[", "\"\<overshot_D13_CDR_medcost2300.csv\>\"", "]"}]}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"osD13low", "=", 
   RowBox[{"Import", "[", "\"\<overshot_D13_CDR_lowcost2300.csv\>\"", "]"}]}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"osD13high", "=", 
   RowBox[{
   "Import", "[", "\"\<overshot_D13_CDR_highcost2300.csv\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"osD07medium", "=", 
   RowBox[{"Import", "[", "\"\<overshot_D07_CDR_medcost2300.csv\>\"", "]"}]}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"osD07low", "=", 
   RowBox[{"Import", "[", "\"\<overshot_D07_CDR_lowcost2300.csv\>\"", "]"}]}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"osD07high", "=", 
   RowBox[{
   "Import", "[", "\"\<overshot_D07_CDR_highcost2300.csv\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.825180202182803*^9, 3.8251802563628798`*^9}},
 CellLabel->"In[14]:=",ExpressionUUID->"4aca67ee-a8d8-4edb-8260-74579db8dfe9"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ospD16medium", "=", 
   RowBox[{"Import", "[", "\"\<overshoot_DICE2016_2100_med.csv\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ospD16low", "=", 
   RowBox[{"Import", "[", "\"\<overshoot_DICE2016_2100_low.csv\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ospD16high", "=", 
   RowBox[{"Import", "[", "\"\<overshoot_DICE2016_2100_high.csv\>\"", "]"}]}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ospFGmedium", "=", 
   RowBox[{"Import", "[", "\"\<overshoot_FairG_2100_med.csv\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ospFGlow", "=", 
   RowBox[{"Import", "[", "\"\<overshoot_FairG_2100_low.csv\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ospFGhigh", "=", 
   RowBox[{"Import", "[", "\"\<overshoot_FairG_2100_high.csv\>\"", "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.825424940789762*^9, 3.825425070337945*^9}},
 CellLabel->
  "In[1072]:=",ExpressionUUID->"2d2011b3-e2cb-43f5-a6c1-64ee5d1b62c3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ospD16low", "[", 
  RowBox[{"[", 
   RowBox[{"1", ",", "9"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.8254253529028454`*^9, 3.8254253599453554`*^9}, {
  3.825425596585189*^9, 3.8254256009671955`*^9}},
 CellLabel->
  "In[1105]:=",ExpressionUUID->"b7d10b52-a651-4fa6-865f-668ff2e59a2b"],

Cell[BoxData["\<\"cprice\"\>"], "Output",
 CellChangeTimes->{
  3.8254253606153564`*^9, {3.825425597585191*^9, 3.8254256015071964`*^9}},
 CellLabel->
  "Out[1105]=",ExpressionUUID->"1b50ea32-03f6-4d50-a44f-d39fb792f40a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ospFGmedium", "[", 
   RowBox[{"[", 
    RowBox[{
     RowBox[{"1", ";;", "2"}], ",", 
     RowBox[{"20", ";;", "22"}]}], "]"}], "]"}], "//", 
  "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.8254252626887164`*^9, 3.8254252992342696`*^9}, {
  3.8254253738098745`*^9, 3.8254254097744255`*^9}, {3.825425465370504*^9, 
  3.8254254675505075`*^9}, {3.8254255758871603`*^9, 3.825425587483176*^9}},
 CellLabel->
  "In[1103]:=",ExpressionUUID->"7a95b2e4-cbb5-4aa4-8a88-e1e593049219"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"\<\"Temp\"\>", "\<\"mu\"\>", "\<\"cprice\"\>"},
     {"0.964476`", "0.14867`", "26.056661`"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.8254252699597263`*^9, 3.8254252998642707`*^9}, {
   3.825425378862382*^9, 3.825425410084426*^9}, 3.8254254679105077`*^9, {
   3.8254255794821653`*^9, 3.825425587873177*^9}},
 CellLabel->
  "Out[1103]//MatrixForm=",ExpressionUUID->"cf0cb6fd-0eb8-4f7e-8d9c-\
4343a7c9070a"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"T2100low", "=", 
   RowBox[{"Show", "[", 
    RowBox[{
     RowBox[{"ListLinePlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"ospD16low", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;", "185"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "8"}], "}"}]}], "]"}], "]"}], ",", 
         RowBox[{"ospFGlow", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;", "185"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "20"}], "}"}]}], "]"}], "]"}]}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Blue", ",", "Black"}], "}"}]}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"2015", ",", "2200"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0.9", ",", "1.8"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"Frame", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"True", ",", "True", ",", "False", ",", "False"}], "}"}]}], 
       ",", 
       RowBox[{"FrameStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Black", ",", "Black", ",", "Automatic", ",", "Black"}], 
         "}"}]}], ",", 
       RowBox[{"FrameLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
         "\"\<Year\>\"", ",", "\"\<\[Degree]C\>\"", ",", "None", ",", 
          "None"}], "}"}]}], ",", 
       RowBox[{"LabelStyle", "\[Rule]", 
        RowBox[{"Directive", "[", 
         RowBox[{
          RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
          RowBox[{"FontSize", "\[Rule]", "18"}], ",", "Black"}], "]"}]}], ",", 
       RowBox[{"Epilog", "\[Rule]", 
        RowBox[{"Text", "[", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"\"\<a) delta SAT \>\"", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
              RowBox[{"FontSize", "\[Rule]", "20"}]}], "}"}]}], "]"}], ",", 
          RowBox[{"Offset", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}], ",", 
            RowBox[{"Scaled", "[", 
             RowBox[{"{", 
              RowBox[{"0.80", ",", "0.95"}], "}"}], "]"}]}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}]}], "]"}]}], ",", 
       RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}], ",", 
     RowBox[{"Plot", "[", 
      RowBox[{"1.3", ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "2015", ",", "2200"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Gray", ",", "Dashed", ",", "Thin"}], "}"}]}]}], "]"}], ",", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{"Gray", ",", "Dashed", ",", "Thin", ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"2100", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"2100", ",", "1.8"}], "}"}]}], "}"}], "]"}]}], "}"}], 
      "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"T2100med", "=", 
   RowBox[{"Show", "[", 
    RowBox[{
     RowBox[{"ListLinePlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"ospD16medium", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;", "185"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "8"}], "}"}]}], "]"}], "]"}], ",", 
         RowBox[{"ospFGmedium", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;", "185"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "20"}], "}"}]}], "]"}], "]"}]}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Blue", ",", "Black"}], "}"}]}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"2015", ",", "2200"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0.9", ",", "1.8"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"Frame", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"True", ",", "True", ",", "False", ",", "False"}], "}"}]}], 
       ",", 
       RowBox[{"FrameStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Black", ",", "Black", ",", "Automatic", ",", "Black"}], 
         "}"}]}], ",", 
       RowBox[{"FrameLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
         "\"\<Year\>\"", ",", "\"\<\[Degree]C\>\"", ",", "None", ",", 
          "None"}], "}"}]}], ",", 
       RowBox[{"LabelStyle", "\[Rule]", 
        RowBox[{"Directive", "[", 
         RowBox[{
          RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
          RowBox[{"FontSize", "\[Rule]", "18"}], ",", "Black"}], "]"}]}], ",", 
       RowBox[{"Epilog", "\[Rule]", 
        RowBox[{"Text", "[", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"\"\<c) delta SAT \>\"", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
              RowBox[{"FontSize", "\[Rule]", "20"}]}], "}"}]}], "]"}], ",", 
          RowBox[{"Offset", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}], ",", 
            RowBox[{"Scaled", "[", 
             RowBox[{"{", 
              RowBox[{"0.80", ",", "0.95"}], "}"}], "]"}]}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}]}], "]"}]}], ",", 
       RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}], ",", 
     RowBox[{"Plot", "[", 
      RowBox[{"1.3", ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "2015", ",", "2200"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Gray", ",", "Dashed", ",", "Thin"}], "}"}]}]}], "]"}], ",", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{"Gray", ",", "Dashed", ",", "Thin", ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"2100", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"2100", ",", "1.8"}], "}"}]}], "}"}], "]"}]}], "}"}], 
      "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"T2100high", "=", 
   RowBox[{"Show", "[", 
    RowBox[{
     RowBox[{"ListLinePlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"ospD16high", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;", "185"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "8"}], "}"}]}], "]"}], "]"}], ",", 
         RowBox[{"ospFGhigh", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;", "185"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "20"}], "}"}]}], "]"}], "]"}]}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Blue", ",", "Black"}], "}"}]}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"2015", ",", "2200"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0.9", ",", "1.8"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"Frame", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"True", ",", "True", ",", "False", ",", "False"}], "}"}]}], 
       ",", 
       RowBox[{"FrameStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Black", ",", "Black", ",", "Automatic", ",", "Black"}], 
         "}"}]}], ",", 
       RowBox[{"FrameLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
         "\"\<Year\>\"", ",", "\"\<\[Degree]C\>\"", ",", "None", ",", 
          "None"}], "}"}]}], ",", 
       RowBox[{"LabelStyle", "\[Rule]", 
        RowBox[{"Directive", "[", 
         RowBox[{
          RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
          RowBox[{"FontSize", "\[Rule]", "18"}], ",", "Black"}], "]"}]}], ",", 
       RowBox[{"Epilog", "\[Rule]", 
        RowBox[{"Text", "[", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"\"\<d) delta SAT \>\"", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
              RowBox[{"FontSize", "\[Rule]", "20"}]}], "}"}]}], "]"}], ",", 
          RowBox[{"Offset", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}], ",", 
            RowBox[{"Scaled", "[", 
             RowBox[{"{", 
              RowBox[{"0.80", ",", "0.95"}], "}"}], "]"}]}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}]}], "]"}]}], ",", 
       RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}], ",", 
     RowBox[{"Plot", "[", 
      RowBox[{"1.3", ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "2015", ",", "2200"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Gray", ",", "Dashed", ",", "Thin"}], "}"}]}]}], "]"}], ",", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{"Gray", ",", "Dashed", ",", "Thin", ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"2100", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"2100", ",", "1.8"}], "}"}]}], "}"}], "]"}]}], "}"}], 
      "]"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.82543971016317*^9, 3.8254397415772142`*^9}, {
  3.825439772061257*^9, 3.8254400401896343`*^9}, {3.8254400732136807`*^9, 
  3.8254401420137777`*^9}},
 CellLabel->
  "In[1125]:=",ExpressionUUID->"8592cb9c-7aa5-416f-9c48-f2858b08d347"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"C2100low", "=", 
   RowBox[{"Show", "[", 
    RowBox[{
     RowBox[{"ListLinePlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"ospD16low", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;", "185"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "4"}], "}"}]}], "]"}], "]"}], ",", 
         RowBox[{"ospFGlow", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;", "185"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "13"}], "}"}]}], "]"}], "]"}]}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Blue", ",", "Black"}], "}"}]}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"2015", ",", "2200"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"650", ",", "1100"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"Frame", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"True", ",", "True", ",", "False", ",", "False"}], "}"}]}], 
       ",", 
       RowBox[{"FrameStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Black", ",", "Black", ",", "Automatic", ",", "Black"}], 
         "}"}]}], ",", 
       RowBox[{"FrameLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
         "\"\<Year\>\"", ",", "\"\<GtC\>\"", ",", "None", ",", "None"}], 
         "}"}]}], ",", 
       RowBox[{"LabelStyle", "\[Rule]", 
        RowBox[{"Directive", "[", 
         RowBox[{
          RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
          RowBox[{"FontSize", "\[Rule]", "18"}], ",", "Black"}], "]"}]}], ",", 
       RowBox[{"Epilog", "\[Rule]", 
        RowBox[{"Text", "[", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"\"\<b) C atmos\>\"", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
              RowBox[{"FontSize", "\[Rule]", "20"}]}], "}"}]}], "]"}], ",", 
          RowBox[{"Offset", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}], ",", 
            RowBox[{"Scaled", "[", 
             RowBox[{"{", 
              RowBox[{"0.80", ",", "0.95"}], "}"}], "]"}]}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}]}], "]"}]}], ",", 
       RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}], ",", 
     RowBox[{"Plot", "[", 
      RowBox[{"1.3", ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "2015", ",", "2200"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Gray", ",", "Dashed", ",", "Thin"}], "}"}]}]}], "]"}], ",", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{"Gray", ",", "Dashed", ",", "Thin", ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"2100", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"2100", ",", "1.8"}], "}"}]}], "}"}], "]"}]}], "}"}], 
      "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"C2100med", "=", 
   RowBox[{"Show", "[", 
    RowBox[{
     RowBox[{"ListLinePlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"ospD16medium", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;", "185"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "4"}], "}"}]}], "]"}], "]"}], ",", 
         RowBox[{"ospFGmedium", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;", "185"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "13"}], "}"}]}], "]"}], "]"}]}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Blue", ",", "Black"}], "}"}]}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"2015", ",", "2200"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"650", ",", "1100"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"Frame", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"True", ",", "True", ",", "False", ",", "False"}], "}"}]}], 
       ",", 
       RowBox[{"FrameStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Black", ",", "Black", ",", "Automatic", ",", "Black"}], 
         "}"}]}], ",", 
       RowBox[{"FrameLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
         "\"\<Year\>\"", ",", "\"\<GtC\>\"", ",", "None", ",", "None"}], 
         "}"}]}], ",", 
       RowBox[{"LabelStyle", "\[Rule]", 
        RowBox[{"Directive", "[", 
         RowBox[{
          RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
          RowBox[{"FontSize", "\[Rule]", "18"}], ",", "Black"}], "]"}]}], ",", 
       RowBox[{"Epilog", "\[Rule]", 
        RowBox[{"Text", "[", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"\"\<d) C atmos\>\"", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
              RowBox[{"FontSize", "\[Rule]", "20"}]}], "}"}]}], "]"}], ",", 
          RowBox[{"Offset", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}], ",", 
            RowBox[{"Scaled", "[", 
             RowBox[{"{", 
              RowBox[{"0.80", ",", "0.95"}], "}"}], "]"}]}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}]}], "]"}]}], ",", 
       RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}], ",", 
     RowBox[{"Plot", "[", 
      RowBox[{"1.3", ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "2015", ",", "2200"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Gray", ",", "Dashed", ",", "Thin"}], "}"}]}]}], "]"}], ",", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{"Gray", ",", "Dashed", ",", "Thin", ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"2100", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"2100", ",", "1.8"}], "}"}]}], "}"}], "]"}]}], "}"}], 
      "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"C2100high", "=", 
   RowBox[{"Show", "[", 
    RowBox[{
     RowBox[{"ListLinePlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"ospD16high", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;", "185"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "4"}], "}"}]}], "]"}], "]"}], ",", 
         RowBox[{"ospFGhigh", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;", "185"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "13"}], "}"}]}], "]"}], "]"}]}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Blue", ",", "Black"}], "}"}]}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"2015", ",", "2200"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"650", ",", "1100"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"Frame", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"True", ",", "True", ",", "False", ",", "False"}], "}"}]}], 
       ",", 
       RowBox[{"FrameStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Black", ",", "Black", ",", "Automatic", ",", "Black"}], 
         "}"}]}], ",", 
       RowBox[{"FrameLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
         "\"\<Year\>\"", ",", "\"\<GtC\>\"", ",", "None", ",", "None"}], 
         "}"}]}], ",", 
       RowBox[{"LabelStyle", "\[Rule]", 
        RowBox[{"Directive", "[", 
         RowBox[{
          RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
          RowBox[{"FontSize", "\[Rule]", "18"}], ",", "Black"}], "]"}]}], ",", 
       RowBox[{"Epilog", "\[Rule]", 
        RowBox[{"Text", "[", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"\"\<e) C atmos\>\"", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
              RowBox[{"FontSize", "\[Rule]", "20"}]}], "}"}]}], "]"}], ",", 
          RowBox[{"Offset", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}], ",", 
            RowBox[{"Scaled", "[", 
             RowBox[{"{", 
              RowBox[{"0.80", ",", "0.95"}], "}"}], "]"}]}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}]}], "]"}]}], ",", 
       RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}], ",", 
     RowBox[{"Plot", "[", 
      RowBox[{"1.3", ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "2015", ",", "2200"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Gray", ",", "Dashed", ",", "Thin"}], "}"}]}]}], "]"}], ",", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{"Gray", ",", "Dashed", ",", "Thin", ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"2100", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"2100", ",", "1.8"}], "}"}]}], "}"}], "]"}]}], "}"}], 
      "]"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.82543971016317*^9, 3.8254397415772142`*^9}, {
  3.825439772061257*^9, 3.8254400401896343`*^9}, {3.8254400732136807`*^9, 
  3.8254403406940575`*^9}, {3.825440371848101*^9, 3.825440387969124*^9}, {
  3.8254405502803526`*^9, 3.8254405552403593`*^9}},
 CellLabel->
  "In[1141]:=",ExpressionUUID->"74a0e8ec-1878-457a-b180-3456ba897b11"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SI62100", "=", 
  RowBox[{"Legended", "[", 
   RowBox[{
    RowBox[{"Grid", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\"\<\>\"", ",", 
          RowBox[{"Text", "[", 
           RowBox[{"Style", "[", 
            RowBox[{
            "\"\<Surface Air Temperature Increase above preindustrial\>\"", 
             ",", 
             RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
             RowBox[{"FontSize", "\[Rule]", "18"}], ",", "Black", ",", 
             "Bold"}], "]"}], "]"}], ",", 
          RowBox[{"Text", "[", 
           RowBox[{"Style", "[", 
            RowBox[{"\"\<Atmospheric Carbon\>\"", ",", 
             RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
             RowBox[{"FontSize", "\[Rule]", "18"}], ",", "Black", ",", 
             "Bold"}], "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Rotate", "[", 
           RowBox[{
            RowBox[{"Text", "[", 
             RowBox[{"Style", "[", 
              RowBox[{"\"\<low CDR cost\>\"", ",", 
               RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
               RowBox[{"FontSize", "\[Rule]", "18"}], ",", "Black", ",", 
               "Bold"}], "]"}], "]"}], ",", 
            RowBox[{"90", " ", "Degree"}]}], "]"}], ",", "T2100low", ",", 
          "C2100low"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Rotate", "[", 
           RowBox[{
            RowBox[{"Text", "[", 
             RowBox[{"Style", "[", 
              RowBox[{"\"\<medium CDR cost\>\"", ",", 
               RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
               RowBox[{"FontSize", "\[Rule]", "18"}], ",", "Black", ",", 
               "Bold"}], "]"}], "]"}], ",", 
            RowBox[{"90", " ", "Degree"}]}], "]"}], ",", "T2100med", ",", 
          "C2100med"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Rotate", "[", 
           RowBox[{
            RowBox[{"Text", "[", 
             RowBox[{"Style", "[", 
              RowBox[{"\"\<high CDR cost\>\"", ",", 
               RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
               RowBox[{"FontSize", "\[Rule]", "18"}], ",", "Black", ",", 
               "Bold"}], "]"}], "]"}], ",", 
            RowBox[{"90", " ", "Degree"}]}], "]"}], ",", "T2100high", ",", 
          "C2100high"}], "}"}]}], "}"}], ",", 
      RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}], ",", 
    RowBox[{"Placed", "[", 
     RowBox[{
      RowBox[{"LineLegend", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Black", ",", "Blue"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"\"\<DICE2016\>\"", ",", 
            RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", 
          RowBox[{"Style", "[", 
           RowBox[{"\"\<FaIR-Geoffroy\>\"", ",", 
            RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}]}], "}"}], ",", 
        RowBox[{"LegendMarkerSize", "\[Rule]", "20"}], ",", 
        RowBox[{"LegendLayout", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"\"\<Row\>\"", ",", "1"}], "}"}]}]}], "]"}], ",", "Below"}],
      "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8254404045111475`*^9, 3.8254404819712563`*^9}, {
  3.8254405980874195`*^9, 3.825440638102476*^9}, {3.8254406795505342`*^9, 
  3.8254407037225685`*^9}, {3.8254407356776133`*^9, 3.8254408474037704`*^9}},
 CellLabel->
  "In[1147]:=",ExpressionUUID->"ffba291e-354d-4c8d-909b-96588cee5625"],

Cell[BoxData[
 TemplateBox[{TagBox[
    GridBox[{{"\"\"", 
       InterpretationBox[
        Cell[
         BoxData[
          FormBox[
           StyleBox[
           "\"Surface Air Temperature Increase above preindustrial\"", 
            FontFamily -> "Helvetica", FontSize -> 18, 
            GrayLevel[0], Bold, StripOnInput -> False], TextForm]], 
         "InlineText"], 
        Text[
         Style[
         "Surface Air Temperature Increase above preindustrial", FontFamily -> 
          "Helvetica", FontSize -> 18, 
          GrayLevel[0], Bold]]], 
       InterpretationBox[
        Cell[
         BoxData[
          FormBox[
           StyleBox[
           "\"Atmospheric Carbon\"", FontFamily -> "Helvetica", FontSize -> 
            18, 
            GrayLevel[0], Bold, StripOnInput -> False], TextForm]], 
         "InlineText"], 
        Text[
         Style[
         "Atmospheric Carbon", FontFamily -> "Helvetica", FontSize -> 18, 
          GrayLevel[0], Bold]]]}, {
       RotationBox[
        InterpretationBox[
         Cell[
          BoxData[
           FormBox[
            StyleBox[
            "\"low CDR cost\"", FontFamily -> "Helvetica", FontSize -> 18, 
             GrayLevel[0], Bold, StripOnInput -> False], TextForm]], 
          "InlineText"], 
         Text[
          Style["low CDR cost", FontFamily -> "Helvetica", FontSize -> 18, 
           GrayLevel[0], Bold]]], BoxRotation -> 1.5707963267948966`], 
       GraphicsBox[{{{}, {{{}, {}, {
             Hue[0.67, 0.6, 0.6], 
             Directive[
              PointSize[
               NCache[
                Rational[1, 90], 0.011111111111111112`]], 
              AbsoluteThickness[1.6], 
              RGBColor[0, 0, 1]], 
             LineBox[CompressedData["
1:eJxd1Hsw1WkYB/BTmbPF6aZWLa0iI2GzJHTTs12sLUou6TRIIsKkrFUqWza5
tLKIrVDv44RsVIp0UklSyS0ql4rNyki7SLkmoz11HrOz7zvzm3c+//zmfZ/n
+z4abn62HqMFAoFU9n3aP6/9DBwapHeHGjqXffZBBuZViiKx8xu5QxnccDaw
ntxEjmDwIlJsEGbUJXcUg0NWRv4qgeQYBqbFeyoy88nxDNaVpoaZCN7KfYKB
SkFBbZoFOZlB7XBlX9tRMjJo8bDW76ohpzIIcNl6PEP9ndwZDK7ZLdr40ZOc
xeCtrk9S8yVyNoNVNRcDzIfIuQwaVxT1D1t0yy1lUNPRrjcxjnyDgau52NCp
kVzIIFTq31ep0yN3MQNv6+5ouwByCQORsK6h+ha5nEGY2OuVsVKv3FUMHtuc
iXHfQH7CYGBH970fUsj1DIZMZAX6h9zAoNJUsq92QZ/cTQycBKppaw6QWxgc
nyktnVJCbmPgqzWu6MtJ/XK3MyicrWtv6kjuovucIvcwMIjM0fRuJg8wELLW
llXaA3IPMUjKWj+x2ossQLhvJXHp+oM8GmFZlqn34ddkBYSLwaNu7pzzXm4h
Qp1n5WD8VvJYBPEZdUn1KbIiwmMvf0NhLVmE8DTwmepk0aDcExAEUZ5VVcvI
kxDu+q/J1NhFVkZI672q0MTIUxGmePjNfVVGVkEIOF4sntxLno6g6qd300Tt
g9yqCHaV0/YZmJNnIHh8HX3hkTNZHSG4KkfcG0SehXDzL3N/nziyJoKRo7BG
eJashfAu28Yn8SpZG6FRZNrUfYesg9DlfW3+lHKyruz/Gi03Pj4k6yOUiOzv
3RrxPITWWW1eDmXkbxGEFi61xUVkIwTliLpepTyyMYKug6T9mzSyCYLmXUGk
dgzZDKHT+VBBTyB5EYLvpeeeCWLyEoSwMl1foRnZHEFLGnt5lTIZZJbFy6aN
6rkc4ZiZnkQ7n7wSwb3ceU1JONlC1q+saSsWridbIgxe6X18QIW8GuGnLNu9
6XXUfyuEmiXft1yPJ69FGH4ToVhjTbaR3Sft6ZIJY8i2CFVKu+dF5VL+7BHm
Ci2NQ9zIGxDOWVwU6ownb0SITQw0rMilvG9CeOS3+YtKMdkJYd6DUdcTh+g9
uSB44/vk66fIrgj2ra1q1UvJbgiKT4PUkhrpvboj1KpdKeoJJm9DyOmcqVSt
QfZCqCj/tGg+eCNEb9oy6HKI7Itw4eDypcEryTsQXqRutzGeSN6JkLVY5Xlq
M80jf1n9Sip2jikgByDMCV+3KBbJgQi7LQ1BEknegxB0PrQzbg95L8Lr4Jc+
D33J+xGe1HUvKPMg/yw7b2zCZuFW8kGE/Ppc27Hu5F8QHhqsrtrsRQ5FSHdf
OC7NjxyG8OFyrt2PQeQIhC8SpNG7DpOPyPJ8+LuTFsfIUQhHKu5fSZGQo2X5
THDdZZZDjpH1LzjG43YxOQ7BrN/xtw+15HiEzA7tgfTX5N8RthjrPQ8fIp9A
mN17unT7SD0TEc6/sLKapklORhg3qLTUzZh8GsHJPC5O3YKMCJ+mvZYjWYKw
Ni9ksY0nORVBqSN5W0ggOR1hwO5lWlIoOUM2f3YUvgqPJZ9DOKnfuczoFDkL
odnpjujoWfIFhNSM+f0x2eRshOT5klxTKfkywlf2askRBeRcBB/XTIVf75Dz
EDZ36FSuv0+WyvLxzMHy/QNyPsLi5pjxqWXkGwiJQf7WISP5LODyWsi5iHMx
53ucSziXci7nXMm5ivMjzk8413Ku5/yMcwPnPzk3cW7m3MK5lXMb5785t3Pu
RLht61xYNuIuzu8493Du4zzAeZDzEOdhzoKU/3s0ZwXOQs5jOStyFnGewHkS
Z2XOUzmrcJ7OWZXzDM7qnGdx1uSsxVmbsw5n3RTIq+/IKR2x/n/+F1m3Tf8=

              "]]}, {
             Hue[0.9060679774997897, 0.6, 0.6], 
             Directive[
              PointSize[
               NCache[
                Rational[1, 90], 0.011111111111111112`]], 
              AbsoluteThickness[1.6], 
              GrayLevel[0]], 
             LineBox[CompressedData["
1:eJxd1A1QVFUUB/ANcXVAkAH82pARNDJCJDBl8IOjw0QakKFWKmkQAoaGkoEY
KgLjiiKCYSyKe09qSsIQ4mqLgyjKAjkgn5kiFhUiNCiLAiKQ9vQdp+ncmTdv
fvPunbnnf899DiFRgetMFAqFXnqev1+MeAErWvSG4ZYH3i+cIMDNdcX6fZHd
spMF+LhZuk5+RN4j4OeKpBkxc42yUwXkfeNhGxtPThcQph5Qz7hIzhSgGvjA
YugfskZAhLJn12TvHtk5Au4E22QXJ5BRQLTaP7T9CvmEgKKZt7YWjnwoO1fA
mYBD3ZMWk/MFbG7bVeW4n1wooDhts8FQT9YJcBgRF/Nk/CPZeqmex/mRuiBy
iYADnqEjOo+RLwtI2tOk29dJLheQ6HW3fr9br+wqAbmG1uDmWHK1gL0dv954
/xK5TspzgtH9qrJPdpOAo1ZeHdYB5JsCJr0yLm3KIXKLAH2sxWDDbXKrgE9S
oG+sY7/sNik/j5RtZeHkDgGd2/+KrM0ndwloCXMun9pDNkrzf5+QdXrWY9m9
ArTdpyreiyUPCIg7dM6/R08eFtBYNuitfkJWIJzc/uXOPs8B2SYIphWDSqdY
sinCs6zIehMdWYmQnBioi+4mj0Y4PPpV7Zo3nsg2Q5jnUbapIJg8BsFvQkif
r4ZsidAwZ73KtoZsJa0/Z5ve/4xsjRD/prVNk9ugbFuEoIIdGw6uJY9HGLVW
4zculTwRYboxYMH882QVQmpia8/9O2Q7hMaAmrvKEUOy7RHSbZxSw14jT0GI
SmqOuu9DdkS4sWV+/VfB5GkI/i7GcXe2kZ0QpNXrhtLJ0xEKY2zv5R4nOyO4
Ln96rqSI7IJgsG+uNCsluyJEdIjWEAPZDcHiqm95ZhXZHeHrm+YjN1SSZyF8
tsbXrqiMPBvBvUDv6fwT2RNhmYN9StYpshfC9Yol1WcPkuch5Hgc083ZSl4g
zS/KSW74iAwIK7/v9Zv5FnkRgvZ17dmRpmQfhMW77VbX1lGe70j5hWdFbdeQ
30V4e5H3sh9Xk5cghLabZFWqyH4IG+3VZcO/0PkGICz/o9YYtp+8VOq3uU/N
TReSAxEq9qr8rhqpv5Yj5NU8y0vLIX8o5alIcVrqQ/4YYV9kvNPQPernVQhH
LzxcqVWTgxCyLY9qY6eS1yDM3OjpYlFC9+dTqZ8W+uatCiSHIGSEJPjYdND9
DKX+3EkOQ5idkW0eZE+OQKipfj7of/C5VO8K61ujsskbEA5Eux1RJJG/QFCO
bSwt3knehBBg9G8MV5OjpfMZFTdfk0negmDe+FiVeJwcg9B16br/kTPkrQiJ
0bdLfS+StyGE3Kp2+MFAjkfQDMYty7hG3iHVExftv+vlfhPY/hMRRJvlkaqX
TmbfdzPvYd7LnMqcxpzOfJA5k/lbZg3zYeYcZi0zMh9jPsF8kjmX+TRzPnMB
cyFzEbOO+TyznvkCcwlzKfNl5ivM5cwVzFXM15irma8z1zE3MDcx32C+ydzM
3ML8G3Mr85/MbcztzB3MfzN3MT9gNjI/ZO5l7mceYB5kHmZ+yqz47v82YTZl
VjKPZjZjHsNsyWzFbM1syzyeeSKzitmO2Z55CrMj8zRmJ+bpzM7MLv/5X8qx
nkM=
              "]]}}, {{
             Directive[
              PointSize[
               NCache[
                Rational[1, 90], 0.011111111111111112`]], 
              AbsoluteThickness[1.6], 
              RGBColor[0, 0, 1]]}, {
             Directive[
              PointSize[
               NCache[
                Rational[1, 90], 0.011111111111111112`]], 
              AbsoluteThickness[1.6], 
              GrayLevel[0]]}}, {{
             Directive[
              PointSize[
               NCache[
                Rational[1, 90], 0.011111111111111112`]], 
              AbsoluteThickness[1.6], 
              RGBColor[0, 0, 1]]}, {
             Directive[
              PointSize[
               NCache[
                Rational[1, 90], 0.011111111111111112`]], 
              AbsoluteThickness[1.6], 
              GrayLevel[0]]}, {}, {}, {}}, {{
             Directive[
              PointSize[
               NCache[
                Rational[1, 90], 0.011111111111111112`]], 
              AbsoluteThickness[1.6], 
              RGBColor[0, 0, 1]]}, {
             Directive[
              PointSize[
               NCache[
                Rational[1, 90], 0.011111111111111112`]], 
              AbsoluteThickness[1.6], 
              GrayLevel[0]]}, {}, {}, {}}}, {{}, {}}}, {{{{}, {}, 
            TagBox[{
              Directive[
               Opacity[1.], 
               AbsoluteThickness[1.6], 
               GrayLevel[0.5], 
               Dashing[{Small, Small}], 
               Thickness[Tiny]], 
              LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQfTTuLwNDzXyHs2dA4Iv95PZeK+dmBD9xg2xJWxeC
b3z97lrXWQj+483Kh3+uQOIH+DKlbEfwJQ+LcbAfR/B1X6e+nHcVwS9/ETIx
/ymCL7RMPfnbFwT/KI8Dx07GBXC+jKGN02ROBD/J4PfL5wII/gX+NcvEJRD8
mzfXHHssj+BfrCsI0VJH8FP4Wlx59RF8+bpO79NmCP7JE4H7me0QfL5/mdNu
uCL4Tnyut9V9EXxBzoJm4VAEn+NJj8OtGAT/3cycbOkUBD/fas7PH9kI/v2t
fV8DihH8csFitpYqBH9V+PKq4CYE/0zFvJi5nQh+Z8vThc0TEfy8Ark/LjOR
3GsudaRhAYK/8UXq+4gVCD5/aUnH6vUI/tSHJWY3tyH42yyOui/eh+Afy7px
7PlRBL+w3XrlibMIPnd94k/lqwj+2bDKuKg7CL6W5EM13ScIftk27tiq1wh+
rF3bt+TPCH7usk9LNH4j+NkvFQ+mMy2E81nEFzo4cyH4PfKPdWcKIvg2HOIG
pyQQ/I7bs6ZOV0DwD3U+zLivjuAb5Bpuea+N4M8NaPz/Xx/BBwAbVv2/
               "]]}, 
             Annotation[#, "Charting`Private`Tag$182212#1"]& ]}}, {}}, {
          GrayLevel[0.5], 
          Dashing[{Small, Small}], 
          Thickness[Tiny], 
          LineBox[{{2100, 0}, {2100, 1.8}}]}}, {
        DisplayFunction -> Identity, DisplayFunction -> Identity, AspectRatio -> 
         NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
         AxesLabel -> {None, None}, AxesOrigin -> {2015., 0.9}, 
         DisplayFunction :> Identity, Epilog -> InsetBox[
           FormBox[
            StyleBox[
            "\"a) delta SAT \"", {FontFamily -> "Helvetica", FontSize -> 20}, 
             StripOnInput -> False], TraditionalForm], 
           Offset[{0, 0}, 
            Scaled[{0.8, 0.95}]], {0, 0}], 
         Frame -> {{True, False}, {True, False}}, FrameLabel -> {{
            FormBox["\"\[Degree]C\"", TraditionalForm], None}, {
            FormBox["\"Year\"", TraditionalForm], None}}, FrameStyle -> {
           GrayLevel[0], 
           GrayLevel[0], Automatic, 
           GrayLevel[0]}, 
         FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
         GridLines -> {None, None}, GridLinesStyle -> Directive[
           GrayLevel[0.5, 0.4]], ImageSize -> 600, LabelStyle -> 
         Directive[FontFamily -> "Helvetica", FontSize -> 18, 
           GrayLevel[0]], 
         Method -> {
          "OptimizePlotMarkers" -> True, 
           "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
               (Identity[#]& )[
                Part[#, 1]], 
               (Identity[#]& )[
                Part[#, 2]]}& ), "CopiedValueFunction" -> ({
               (Identity[#]& )[
                Part[#, 1]], 
               (Identity[#]& )[
                Part[#, 2]]}& )}}, PlotRange -> {{2015, 2200}, {0.9, 1.8}}, 
         PlotRangeClipping -> True, PlotRangePadding -> {{0, 0}, {0, 0}}, 
         Ticks -> {Automatic, Automatic}}], 
       GraphicsBox[{{{}, {{{}, {}, {
             Hue[0.67, 0.6, 0.6], 
             Directive[
              PointSize[
               NCache[
                Rational[1, 90], 0.011111111111111112`]], 
              AbsoluteThickness[1.6], 
              RGBColor[0, 0, 1]], 
             LineBox[CompressedData["
1:eJw11QtUTukaB/BvQlOu1VBux1EqURRD5dL4yxSDFIrINWGK3OpkTKRSuhPy
0fjYzx53p6ZEVEJJihoSk4yoGSk1LrEqjOLsMz3vXmuvvX5rX973fS7vNvZe
P2ellkqlylLO/1//ObZKGKWTMnChVyz+caiEq8NS3PV2siMkPIj8tyYtnR0t
4XJsfM9pj9jxEj7d/6HhRpe4DidKCLKtlfrZsJMkuO6Zcn3EQvZBCY7BLW+a
drA1EtK2fXHZLZVNEuwKn/48voJ9TEIv3eqPhz6xT0mw6ZX8drl5fIdTJPje
fOq7xYWdLgFGPfrdCWCfl5DzwTnQNZmdJaFlpe/JusvsXAlRruP3hP7BzpMw
9XNJpk7nhA5fl+BuH+7uZ8YuluD5aatXohO7VEJVyAeflT7sMglO+nMu3gtj
35cQPWPXhMLD7EoJ/1UHJg3JYldJKLIKNqgsY9dIsAiJzy6pZ9dKMIwNnFTf
xn4u4cnnIt2v9HZ1+IWEs48dYGfMbpJwLmNb8QQbdrMEn9LFM3Qc2O8luLiE
20VMZbdJ2BAcfl3tylYR7GW9L4Z6sLUIR/cdrxjgye5MGL4ho8ciYW2Ck/VR
z9vieR3Cwh3vPBa4sbsSBuskyk/FeN0Jlq0HHs+dyO5JyDnyPCdxBFuPYP3Y
VDtsANuAUL5xbEY3bXZvwhC9tL+MXnI8DAlT07QtEkT8+hKGGswcOzed3Z/Q
aZuJ65x49kBCdoH56ACRr0GEzT4ptpI9ezBh/3c9/PN02CaE9wNeZuXf5/ow
JRSFvmjZpWGbE6wOjTPts4xtQQh0Tmp1NmEPJ5xsONfpl6dcv1aEyResltod
Y48klGU/ailfwbYhFIS4pgSYsEcTZpWZR/Wq4X4bQ4j2ra6SNGxbwofmSrWx
J9teyZ/1rK37DdjjCWYmbXGq0pgOTyTMLNKsXhvB/kb5fpPLvfoJbBDWqkuc
o95Gd9iRoDWyWL3yFPtbwhJL+dKxxWxnwr64UenrDNjTCMMcG4Nab0R1eDph
V5fIyVuC2TMJ24xrcyfZsGcp85k9MkF6trPDboQf46LetR1izyFEVbtcLJ3L
dic8yJunq+7Bnkfo3uhV13wzssOehNykHB9NDHshYYZDN8cFLuxFhJf6fjt7
G7KXEPqm1w6vqI3o8DIlflFrMoty2N6E4mWFp22T2T6E8LqAV+ow9irCOV0b
q6tx7O8Jtv8Z1GdpHtuPEDz9dky7JY+3luCs+3e3f+1hryOcuah9oWsTewPB
ffeYrB7f8fo2Kf0QF/Prag07kBA2ufykRyM7SIm3sadHr685nj8Q2r9alFIc
xP6R4F//8fTZTPZWwu4a51utr9khSj9Zr/HON+P8hRJudlndZDefHa6sb8hv
m0Mi2BFKv656++uFVPZOwp+laXWqe+xogn7berPgZnYs4XZRpuxowPUVr8T3
2OywACv2LkLECrXDsCnsRML6Fk1zyDz2XsLESu+Lu1exkwirt1NVUABbTTCe
37jAbRv7IOFJ0d2B40R9/0RoOXLL1zWarVHiOdZx0rkY9hFCzTTK3ynuk1Jv
ftMzXon3f1byr372l8F29jElXz8Nbhy0mX2CcHdLwmJHf/YpwsNFY++cXc4+
Q6io++xx0p2dQjg93WvRCmf2LwS/yIbgEXbsdML35xoDPIayMwjHK+/ajzFi
nydktltajviSfYGA2PEBae843lmEzvaX4+wa2DmE/v1dO8+uYucq860/Gn/w
LvsKQX2gzfXKTXae0s8FQw9HF7KvKeP1N3hnL3xdqb8XLa9eX2ffIMydOPLM
ceFigqY9bJOX8C3C1wN89uoLlxIKU8P7FhewbxNSr5qptguXKfvtxjFTbYXL
CfXxFi9fXmPfV/pJT+vtceEKwoSE8+5LhCuV/a4T+hgJ/07I1zo4uiyfXUW4
VeCYGiP8hNBVSt0xRbhGWV9SZWZ7HvtPwqa1DlOyhGuV/9lrD8sA4TpC7ECT
dSOFnyv1Hbm/a+NVdiNhzZthqhPCLwimy6tneQu/IpzQWLcOEm4iBI3p2fLo
Cvut8j+yCJ6RLNys7B+Tm97PE24lxIT4t/cWfk8wH7ds/r3L7L8JB2vuf7lX
uI3QuD+j+2zhT4QDxV1W6wmrZJjqXutTlsvWktHv+e9GicKdZdgcrvB3E9aW
8SbrlKG+sI4MqVOJfvkldlcZrecLlu4T7i4jz0z12V24p4zsBO0mQ2E9GWec
vh31MIdtIGN25KSCQ8K9ZTT13nR8ibChjJJcjwfGwn2V+Tv5eD7LZveX8U2Q
kcVp4YEyFvdtcPIXHiQj1PLh2VHCg2U0bl6+pjWLbSKjuvDjxkvCpjLosXFh
qLC5DOur93ychS1k3Bkd59ZdeLiMfNW1qPKLbCsZ09+80U1W/D9XoLh7
              "]]}, {
             Hue[0.9060679774997897, 0.6, 0.6], 
             Directive[
              PointSize[
               NCache[
                Rational[1, 90], 0.011111111111111112`]], 
              AbsoluteThickness[1.6], 
              GrayLevel[0]], 
             LineBox[CompressedData["
1:eJw11Qs0lekaB/Cd6SIJNSIllWLcqgk1bjWPYaY0Og4p6aLESNLOsgwt01CN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              "]]}}, {{
             Directive[
              PointSize[
               NCache[
                Rational[1, 90], 0.011111111111111112`]], 
              AbsoluteThickness[1.6], 
              RGBColor[0, 0, 1]]}, {
             Directive[
              PointSize[
               NCache[
                Rational[1, 90], 0.011111111111111112`]], 
              AbsoluteThickness[1.6], 
              GrayLevel[0]]}}, {{
             Directive[
              PointSize[
               NCache[
                Rational[1, 90], 0.011111111111111112`]], 
              AbsoluteThickness[1.6], 
              RGBColor[0, 0, 1]]}, {
             Directive[
              PointSize[
               NCache[
                Rational[1, 90], 0.011111111111111112`]], 
              AbsoluteThickness[1.6], 
              GrayLevel[0]]}, {}, {}, {}}, {{
             Directive[
              PointSize[
               NCache[
                Rational[1, 90], 0.011111111111111112`]], 
              AbsoluteThickness[1.6], 
              RGBColor[0, 0, 1]]}, {
             Directive[
              PointSize[
               NCache[
                Rational[1, 90], 0.011111111111111112`]], 
              AbsoluteThickness[1.6], 
              GrayLevel[0]]}, {}, {}, {}}}, {{}, {}}}, {{{{}, {}, 
            TagBox[{
              Directive[
               Opacity[1.], 
               AbsoluteThickness[1.6], 
               GrayLevel[0.5], 
               Dashing[{Small, Small}], 
               Thickness[Tiny]], 
              LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQfTTuLwNDzXyHs2dA4Iv95PZeK+dmBD9xg2xJWxeC
b3z97lrXWQj+483Kh3+uQOIH+DKlbEfwJQ+LcbAfR/B1X6e+nHcVwS9/ETIx
/ymCL7RMPfnbFwT/KI8Dx07GBXC+jKGN02ROBD/J4PfL5wII/gX+NcvEJRD8
mzfXHHssj+BfrCsI0VJH8FP4Wlx59RF8+bpO79NmCP7JE4H7me0QfL5/mdNu
uCL4Tnyut9V9EXxBzoJm4VAEn+NJj8OtGAT/3cycbOkUBD/fas7PH9kI/v2t
fV8DihH8csFitpYqBH9V+PKq4CYE/0zFvJi5nQh+Z8vThc0TEfy8Ark/LjOR
3GsudaRhAYK/8UXq+4gVCD5/aUnH6vUI/tSHJWY3tyH42yyOui/eh+Afy7px
7PlRBL+w3XrlibMIPnd94k/lqwj+2bDKuKg7CL6W5EM13ScIftk27tiq1wh+
rF3bt+TPCH7usk9LNH4j+NkvFQ+mMy2E81nEFzo4cyH4PfKPdWcKIvg2HOIG
pyQQ/I7bs6ZOV0DwD3U+zLivjuAb5Bpuea+N4M8NaPz/Xx/BBwAbVv2/
               "]]}, 
             Annotation[#, "Charting`Private`Tag$190065#1"]& ]}}, {}}, {
          GrayLevel[0.5], 
          Dashing[{Small, Small}], 
          Thickness[Tiny], 
          LineBox[{{2100, 0}, {2100, 1.8}}]}}, {
        DisplayFunction -> Identity, DisplayFunction -> Identity, AspectRatio -> 
         NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
         AxesLabel -> {None, None}, AxesOrigin -> {2015., 650.}, 
         DisplayFunction :> Identity, Epilog -> InsetBox[
           FormBox[
            StyleBox[
            "\"b) C atmos\"", {FontFamily -> "Helvetica", FontSize -> 20}, 
             StripOnInput -> False], TraditionalForm], 
           Offset[{0, 0}, 
            Scaled[{0.8, 0.95}]], {0, 0}], 
         Frame -> {{True, False}, {True, False}}, FrameLabel -> {{
            FormBox["\"GtC\"", TraditionalForm], None}, {
            FormBox["\"Year\"", TraditionalForm], None}}, FrameStyle -> {
           GrayLevel[0], 
           GrayLevel[0], Automatic, 
           GrayLevel[0]}, 
         FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
         GridLines -> {None, None}, GridLinesStyle -> Directive[
           GrayLevel[0.5, 0.4]], ImageSize -> 600, LabelStyle -> 
         Directive[FontFamily -> "Helvetica", FontSize -> 18, 
           GrayLevel[0]], 
         Method -> {
          "OptimizePlotMarkers" -> True, 
           "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
               (Identity[#]& )[
                Part[#, 1]], 
               (Identity[#]& )[
                Part[#, 2]]}& ), "CopiedValueFunction" -> ({
               (Identity[#]& )[
                Part[#, 1]], 
               (Identity[#]& )[
                Part[#, 2]]}& )}}, PlotRange -> {{2015, 2200}, {650, 1100}}, 
         PlotRangeClipping -> True, PlotRangePadding -> {{0, 0}, {0, 0}}, 
         Ticks -> {Automatic, Automatic}}]}, {
       RotationBox[
        InterpretationBox[
         Cell[
          BoxData[
           FormBox[
            StyleBox[
            "\"medium CDR cost\"", FontFamily -> "Helvetica", FontSize -> 18, 
             GrayLevel[0], Bold, StripOnInput -> False], TextForm]], 
          "InlineText"], 
         Text[
          Style["medium CDR cost", FontFamily -> "Helvetica", FontSize -> 18, 
           GrayLevel[0], Bold]]], BoxRotation -> 1.5707963267948966`], 
       GraphicsBox[{{{}, {{{}, {}, {
             Hue[0.67, 0.6, 0.6], 
             Directive[
              PointSize[
               NCache[
                Rational[1, 90], 0.011111111111111112`]], 
              AbsoluteThickness[1.6], 
              RGBColor[0, 0, 1]], 
             LineBox[CompressedData["
1:eJxd1Qs0lmccAPCPJAmpUEmSWa6VWlkl/LNIl6m+WSOX5DbdvuxLJc2mJgmr
5hCa9fyTddNSjZKa496F9IUuE6JMZkIRX7rYW9/f2dnznPOe9/zO+57n/T/v
8///n8l+m8WByiKRKFe43t8/jG8ZfFmXW/qmrsPhgyMZ3LJ1vfOTV6fCUQzq
AtzGl9WTYxgsfxordrTuUjiegckL7yXeUvJBBhIdjw1mOeREBieSHI2S5eQU
Bk5/NFanzX+ucBqDXwIyy813kZGBWXWwdEYZOUOYv+N8z9ERLxQ+yeDp/nfJ
G1aSzzDI0/kqKSKZfI7BnbZmjdJ6cjaD9b1gaW3SrXCu8H56ovaZ9eSrwnyN
qTKT8+QCBiPNfpbu6SOXMPBYJ1bPs+tR+DqDClPL6MwfyBUMwnxFTZ/dIMsY
hMcaGEu0Xipcw6BolsakUV+QHzBwezyvTDeZXMfAKi3jlX8tuZHB1O1Bu5sM
ehVuZrBIWdNmqw+5lYG3OKdehZHb6XkDuYtB9Uxx5ymDPoV7GDTLj1bFeJDl
DKx3eW7vTiS/EfZLXh9aXkkWIfgOlUu6VeUKKyNkrU7tWmpHVkF4a+0Ylv0N
WRWhznlI2IgMshrCsxoviXUNWR3ht18jsweUXimsgfDj8BnJblPJWghKK639
1VeRtREk4jvur3eSRyOYdO1lA0fIOgjiIzvmtueT9RCcHfRdUx+SxyHcDJnP
lF6S9RHCH8lrPxnRr7ABgvzT4Cx7Q7IhwsmSrfGW08hGCMNL/ukfaks2RlgX
f2/l3YVkE4TxoY6tuJQ8BcHJ/1nnxuVkMwQDx6TDdivIFgjl8r7xY13JVghf
7+yJfu1CnobQfSO2qQ3I1ghhPhY2LbPJM4V451RHPTMlz0JYHXg8+50e2QYh
03tMlf4Q8hyERydOy6Cd1j8PoebuxLhNVeT5CElr6zTTc8j2CB8tbXFvSCID
QkSC7UbjLWRHhCuWV3xDPicvFP7PgHFwhQnZGQElWGD7ivbbBUEmcygsvUle
gqDR5tkSmkpehqDm2d7rEUh2Rdhj714WPY28AiEu7ph0zEvKRzHCpgMNIZMu
k90QSrdcjJSFk1ch7J3pVuo2j+yO8LFKZttffVQPqxE2PDcXlf1O9hLiM79+
21lC9kHwGTml9Jop2RfhfsbD0ZcbqR79EK4Oa81PSyUHIHi2GWUNG6znIATd
kNvdJzTJwQi3Kt4P6gfrEfpU16QsSyJvRFi72c/FNYgsEdYfYbtPzYEcgnBw
sXNlkSFZirDIMMaqSoUcijAQ9r4iqT9tQ4jXnZ0S3UQOQ5gQqRmjfZ8cjhD4
NsgvT0b+FiHgrMZpzUrydwibo5yc0gYdiTB7QU2EqIq8G+Hs7nGttYPzRSF0
uhXY3X5EjkbYr7ywMP5vcgzCpHsTcop6yLEI0SEVF0yVKP54hKaaYQnbtcj7
hXzvsPOSGpAPIhwzdjX904KcgDBx8pAd2+aSE4V+Mib5ia4L+RCCfUKCYfQq
corQn7QnWKUFkA8jTJfPMp0uJacJ/SIl3Uv/e/IRIR7z5iV2cWREeFKodyXi
EDkdYfE6mwPFSM5AmDPqbW3/KfJxBAulGcPHXiCfRLjU0XJK6zL5tFB/a7LO
NeaTzwj1dPGSZ0Ix+SxCWfFOLatr5HPC9/cZVRYPnicXEGw/NGhyNoKX0YLn
/oP5dVHIRzXpiqJB53L5l8f5Kud8zgWciziXcC7jfJ3zTc4VnCs5yzhXca7h
fI/zA861nOs4N3Bu5PyYczPnFs6tnNs4t3Pu4NzF+QXnHoRCsXdB+aB7Ocs5
93N+w/kdZ9HR/1uZswpnVc5qnNU5a3DW4qzNeTRnHc56nMdx1udswNmQsxFn
Y84mnKdwNuNswdnqP/8LwjpNwA==
              "]]}, {
             Hue[0.9060679774997897, 0.6, 0.6], 
             Directive[
              PointSize[
               NCache[
                Rational[1, 90], 0.011111111111111112`]], 
              AbsoluteThickness[1.6], 
              GrayLevel[0]], 
             LineBox[CompressedData["
1:eJxd038wFmYcAPB3L2firSnWWymai1Os5FhdZ/pGp0ZXy4WKakP6tfVDlEPW
oahESZ0r83xnpFyj/F5l3MLxpjJnQ946iwyJF696lbS33m+32/e5e+65z1/P
9+dngfu8t0slEkm59r57359oAT7K8ppx5cDy9z4qoNFItunR7kGd4wUkLO4d
zFGREwV8b+6xQrVUpXOSAMtd+/39I8hnBIzUWcpcyshpAmJ8Fm6YGCWnC8gy
7vPvdhrSOUOAedxawzlhZBQwZv8g7lYROVvAo5L46MYR8hUB/5yqkG9zGtb5
moB583u/3RlOvi7Afclrvael5GIBl1L2uNdoyOUCPlnl1zuwbETn2wJO93ve
XX2EXCVgjl5hy61KcrWABwk7JjlK1TrXCSg+7OF/fiW5QcDbLyOeNx0nNwq4
09Jys7mO3KzN73aB4pjRqM6tAhYpf3Vo8iIrtf8VgDo7idwhwNhmwravgdwl
QFK9peKk7IXOPQIc1Il/HPQi9wtIq4xadfoEWaXtp1zleKeWrBYQp6lKfit9
qbNGgHX3pq/sXMnjAlYE2axfFEGWICiHz6apr5OlCONyQ2lwD1kfIaM9Pmq7
hUZnAwT0tlY89iYbIkyWaCfqGNkIoVbjENVWSpYh5LSEBFl3k6cgJN8w3Rpr
OqazCcKa3HDzZlfyNIT8NoXXxA6yGULY4N+pncnk6Qiel/KigovIMxCG4kau
Bv1JnoXwZse9lEo1eTaC5lRbqs/UVzpbIITn21rr25HnInRbHjl3eQXZCqGo
dL6F3Ic8D8Gy3bHDfjvZBiFyn+yjqgNkW239RsZ3/RxJXoAQ0OOpn/cD2R7h
SVdMQtZR8kKEdR8XZm4+QnZA8DBuLL0YTnZE8HI9JLfdRXZCUIwFDtb4kb9A
eH6zzGrxh3iXIhw0CSvOsyYvQ7ghN2qdYkB2QQh1LrT7vJPq4YqQ8OiwLKWC
DAiql9oCnSe7IRjWS2327yGvRHhRstDZbTnZA2HJm7YUs6nk1QiZpR76nR3U
X0+EU84BXZn55DUIY7HTpzlEktciNBSl+ka7k79GKIiscgk2InsjBMXs3am4
T/O3AeHcgaTglDNkX20+le7rcR15I0L8fEXOkDF5M8KWJ3V6Z2toHwIQpnqX
FRVEk7dq++0StK1wMfkb7fyETH7s95T2LxDhUv2SdmU6ORjhx/gmudtacgjC
Qz+L7FxD8k6Eew3vDu3/boTlMzvv9OeQv0PoXRl7NeQCeS/CzPBfKtadJ+9H
OPFshl9ABjlUW8/00UDbXHIYQt0kU4+iQvIhBBF++oJeBTkCYWPKa99n1eRI
hJJPX98dqCdHI7T1hXrCh/hiWLxHmWOZ45mPMycyn2ROYk5mPsOcypzGfIE5
nfkicwZzJjMyZzFnM19mvsKcx3yNOZ/5OnMhczFzKXM5803m28y/MVcx/85c
zVzLXMesYG5gvs/cyNzE3Mz8F3Mr80NmJfNj5g7mJ8xdzN3MPcx9zP3MA8wq
5mFmNfMLZg3zK+Zx5glmyU//t5RZn9mA2ZDZiFnGPIXZhHkasxnzdOYZzLOY
ZzNbMM9ltmKex2zDbMu8gNn+P/8LuX6oiQ==
              "]]}}, {{
             Directive[
              PointSize[
               NCache[
                Rational[1, 90], 0.011111111111111112`]], 
              AbsoluteThickness[1.6], 
              RGBColor[0, 0, 1]]}, {
             Directive[
              PointSize[
               NCache[
                Rational[1, 90], 0.011111111111111112`]], 
              AbsoluteThickness[1.6], 
              GrayLevel[0]]}}, {{
             Directive[
              PointSize[
               NCache[
                Rational[1, 90], 0.011111111111111112`]], 
              AbsoluteThickness[1.6], 
              RGBColor[0, 0, 1]]}, {
             Directive[
              PointSize[
               NCache[
                Rational[1, 90], 0.011111111111111112`]], 
              AbsoluteThickness[1.6], 
              GrayLevel[0]]}, {}, {}, {}}, {{
             Directive[
              PointSize[
               NCache[
                Rational[1, 90], 0.011111111111111112`]], 
              AbsoluteThickness[1.6], 
              RGBColor[0, 0, 1]]}, {
             Directive[
              PointSize[
               NCache[
                Rational[1, 90], 0.011111111111111112`]], 
              AbsoluteThickness[1.6], 
              GrayLevel[0]]}, {}, {}, {}}}, {{}, {}}}, {{{{}, {}, 
            TagBox[{
              Directive[
               Opacity[1.], 
               AbsoluteThickness[1.6], 
               GrayLevel[0.5], 
               Dashing[{Small, Small}], 
               Thickness[Tiny]], 
              LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQfTTuLwNDzXyHs2dA4Iv95PZeK+dmBD9xg2xJWxeC
b3z97lrXWQj+483Kh3+uQOIH+DKlbEfwJQ+LcbAfR/B1X6e+nHcVwS9/ETIx
/ymCL7RMPfnbFwT/KI8Dx07GBXC+jKGN02ROBD/J4PfL5wII/gX+NcvEJRD8
mzfXHHssj+BfrCsI0VJH8FP4Wlx59RF8+bpO79NmCP7JE4H7me0QfL5/mdNu
uCL4Tnyut9V9EXxBzoJm4VAEn+NJj8OtGAT/3cycbOkUBD/fas7PH9kI/v2t
fV8DihH8csFitpYqBH9V+PKq4CYE/0zFvJi5nQh+Z8vThc0TEfy8Ark/LjOR
3GsudaRhAYK/8UXq+4gVCD5/aUnH6vUI/tSHJWY3tyH42yyOui/eh+Afy7px
7PlRBL+w3XrlibMIPnd94k/lqwj+2bDKuKg7CL6W5EM13ScIftk27tiq1wh+
rF3bt+TPCH7usk9LNH4j+NkvFQ+mMy2E81nEFzo4cyH4PfKPdWcKIvg2HOIG
pyQQ/I7bs6ZOV0DwD3U+zLivjuAb5Bpuea+N4M8NaPz/Xx/BBwAbVv2/
               "]]}, 
             Annotation[#, "Charting`Private`Tag$182298#1"]& ]}}, {}}, {
          GrayLevel[0.5], 
          Dashing[{Small, Small}], 
          Thickness[Tiny], 
          LineBox[{{2100, 0}, {2100, 1.8}}]}}, {
        DisplayFunction -> Identity, DisplayFunction -> Identity, AspectRatio -> 
         NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
         AxesLabel -> {None, None}, AxesOrigin -> {2015., 0.9}, 
         DisplayFunction :> Identity, Epilog -> InsetBox[
           FormBox[
            StyleBox[
            "\"c) delta SAT \"", {FontFamily -> "Helvetica", FontSize -> 20}, 
             StripOnInput -> False], TraditionalForm], 
           Offset[{0, 0}, 
            Scaled[{0.8, 0.95}]], {0, 0}], 
         Frame -> {{True, False}, {True, False}}, FrameLabel -> {{
            FormBox["\"\[Degree]C\"", TraditionalForm], None}, {
            FormBox["\"Year\"", TraditionalForm], None}}, FrameStyle -> {
           GrayLevel[0], 
           GrayLevel[0], Automatic, 
           GrayLevel[0]}, 
         FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
         GridLines -> {None, None}, GridLinesStyle -> Directive[
           GrayLevel[0.5, 0.4]], ImageSize -> 600, LabelStyle -> 
         Directive[FontFamily -> "Helvetica", FontSize -> 18, 
           GrayLevel[0]], 
         Method -> {
          "OptimizePlotMarkers" -> True, 
           "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
               (Identity[#]& )[
                Part[#, 1]], 
               (Identity[#]& )[
                Part[#, 2]]}& ), "CopiedValueFunction" -> ({
               (Identity[#]& )[
                Part[#, 1]], 
               (Identity[#]& )[
                Part[#, 2]]}& )}}, PlotRange -> {{2015, 2200}, {0.9, 1.8}}, 
         PlotRangeClipping -> True, PlotRangePadding -> {{0, 0}, {0, 0}}, 
         Ticks -> {Automatic, Automatic}}], 
       GraphicsBox[{{{}, {{{}, {}, {
             Hue[0.67, 0.6, 0.6], 
             Directive[
              PointSize[
               NCache[
                Rational[1, 90], 0.011111111111111112`]], 
              AbsoluteThickness[1.6], 
              RGBColor[0, 0, 1]], 
             LineBox[CompressedData["
1:eJw11g1UT/cfB/C0KBXmofQsTrVYzCSS5v/WpJCJNXMqjfaTjJRGlIceRotq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              "]]}, {
             Hue[0.9060679774997897, 0.6, 0.6], 
             Directive[
              PointSize[
               NCache[
                Rational[1, 90], 0.011111111111111112`]], 
              AbsoluteThickness[1.6], 
              GrayLevel[0]], 
             LineBox[CompressedData["
1:eJw11Qs0VukaB3DjdFNEKFEjGUk03SfVoEelTEZEV0wiDMWolOqEaYrILZUp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              "]]}}, {{
             Directive[
              PointSize[
               NCache[
                Rational[1, 90], 0.011111111111111112`]], 
              AbsoluteThickness[1.6], 
              RGBColor[0, 0, 1]]}, {
             Directive[
              PointSize[
               NCache[
                Rational[1, 90], 0.011111111111111112`]], 
              AbsoluteThickness[1.6], 
              GrayLevel[0]]}}, {{
             Directive[
              PointSize[
               NCache[
                Rational[1, 90], 0.011111111111111112`]], 
              AbsoluteThickness[1.6], 
              RGBColor[0, 0, 1]]}, {
             Directive[
              PointSize[
               NCache[
                Rational[1, 90], 0.011111111111111112`]], 
              AbsoluteThickness[1.6], 
              GrayLevel[0]]}, {}, {}, {}}, {{
             Directive[
              PointSize[
               NCache[
                Rational[1, 90], 0.011111111111111112`]], 
              AbsoluteThickness[1.6], 
              RGBColor[0, 0, 1]]}, {
             Directive[
              PointSize[
               NCache[
                Rational[1, 90], 0.011111111111111112`]], 
              AbsoluteThickness[1.6], 
              GrayLevel[0]]}, {}, {}, {}}}, {{}, {}}}, {{{{}, {}, 
            TagBox[{
              Directive[
               Opacity[1.], 
               AbsoluteThickness[1.6], 
               GrayLevel[0.5], 
               Dashing[{Small, Small}], 
               Thickness[Tiny]], 
              LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQfTTuLwNDzXyHs2dA4Iv95PZeK+dmBD9xg2xJWxeC
b3z97lrXWQj+483Kh3+uQOIH+DKlbEfwJQ+LcbAfR/B1X6e+nHcVwS9/ETIx
/ymCL7RMPfnbFwT/KI8Dx07GBXC+jKGN02ROBD/J4PfL5wII/gX+NcvEJRD8
mzfXHHssj+BfrCsI0VJH8FP4Wlx59RF8+bpO79NmCP7JE4H7me0QfL5/mdNu
uCL4Tnyut9V9EXxBzoJm4VAEn+NJj8OtGAT/3cycbOkUBD/fas7PH9kI/v2t
fV8DihH8csFitpYqBH9V+PKq4CYE/0zFvJi5nQh+Z8vThc0TEfy8Ark/LjOR
3GsudaRhAYK/8UXq+4gVCD5/aUnH6vUI/tSHJWY3tyH42yyOui/eh+Afy7px
7PlRBL+w3XrlibMIPnd94k/lqwj+2bDKuKg7CL6W5EM13ScIftk27tiq1wh+
rF3bt+TPCH7usk9LNH4j+NkvFQ+mMy2E81nEFzo4cyH4PfKPdWcKIvg2HOIG
pyQQ/I7bs6ZOV0DwD3U+zLivjuAb5Bpuea+N4M8NaPz/Xx/BBwAbVv2/
               "]]}, 
             Annotation[#, "Charting`Private`Tag$190151#1"]& ]}}, {}}, {
          GrayLevel[0.5], 
          Dashing[{Small, Small}], 
          Thickness[Tiny], 
          LineBox[{{2100, 0}, {2100, 1.8}}]}}, {
        DisplayFunction -> Identity, DisplayFunction -> Identity, AspectRatio -> 
         NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
         AxesLabel -> {None, None}, AxesOrigin -> {2015., 650.}, 
         DisplayFunction :> Identity, Epilog -> InsetBox[
           FormBox[
            StyleBox[
            "\"d) C atmos\"", {FontFamily -> "Helvetica", FontSize -> 20}, 
             StripOnInput -> False], TraditionalForm], 
           Offset[{0, 0}, 
            Scaled[{0.8, 0.95}]], {0, 0}], 
         Frame -> {{True, False}, {True, False}}, FrameLabel -> {{
            FormBox["\"GtC\"", TraditionalForm], None}, {
            FormBox["\"Year\"", TraditionalForm], None}}, FrameStyle -> {
           GrayLevel[0], 
           GrayLevel[0], Automatic, 
           GrayLevel[0]}, 
         FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
         GridLines -> {None, None}, GridLinesStyle -> Directive[
           GrayLevel[0.5, 0.4]], ImageSize -> 600, LabelStyle -> 
         Directive[FontFamily -> "Helvetica", FontSize -> 18, 
           GrayLevel[0]], 
         Method -> {
          "OptimizePlotMarkers" -> True, 
           "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
               (Identity[#]& )[
                Part[#, 1]], 
               (Identity[#]& )[
                Part[#, 2]]}& ), "CopiedValueFunction" -> ({
               (Identity[#]& )[
                Part[#, 1]], 
               (Identity[#]& )[
                Part[#, 2]]}& )}}, PlotRange -> {{2015, 2200}, {650, 1100}}, 
         PlotRangeClipping -> True, PlotRangePadding -> {{0, 0}, {0, 0}}, 
         Ticks -> {Automatic, Automatic}}]}, {
       RotationBox[
        InterpretationBox[
         Cell[
          BoxData[
           FormBox[
            StyleBox[
            "\"high CDR cost\"", FontFamily -> "Helvetica", FontSize -> 18, 
             GrayLevel[0], Bold, StripOnInput -> False], TextForm]], 
          "InlineText"], 
         Text[
          Style["high CDR cost", FontFamily -> "Helvetica", FontSize -> 18, 
           GrayLevel[0], Bold]]], BoxRotation -> 1.5707963267948966`], 
       GraphicsBox[{{{}, {{{}, {}, {
             Hue[0.67, 0.6, 0.6], 
             Directive[
              PointSize[
               NCache[
                Rational[1, 90], 0.011111111111111112`]], 
              AbsoluteThickness[1.6], 
              RGBColor[0, 0, 1]], 
             LineBox[CompressedData["
1:eJxd0wsw11kUB/B//5CVIiGpRKRGSCl55kz7T6+dEtFLeUvRrhqvWqktLSOl
JLFr3UM2QoVVjNWDZKU/2UqpbA89PJNCbFT7q/9pmr135jd3PjO/mXvuPd+j
5/WDk69YJBKVCN+n/fOKYODSVHJ1qKnL/rP3MJiZJVdp4PZK5igGw7LCXkc2
kWMYpI8JdPto2i1zHIOYJSWHFwWRDzO4YXbu99GF5EQGcsMVJy/tJScL/49N
Xt5h8VrmVAZtvymVtOwgI4Ntw/wTTS+QMxnsPXJ8boHojczZDH5M3/PSQ0LO
Y5CqWdY6I4acL9Tv6OQxTEouYrDe/v2mWpUemUsYeFxzMY50Jpcx8H2kUf4x
iXyZQfRAtIndfXIlg6cH3obrTeqVuZrBMdW8nOPuZCmD4/GZmdHp5HoGg/J/
ej5oJt9mkC+OKN6h3ydzI4MyRefEZd7kJgajsqS18zLIjxnsCk/S1X9Mfsbg
1ZFal56Jb2VuZWBzaLLRwTXkTgbWitbrGhLI3UJ/jCN2nb5O7mUwJ6No3oC4
X+YBBoUqhcbJluQhBgXm++sCAskihBbrg0Wr0shihAebAyRmdWQ5BC358qcP
BskKCBPuXuownzYgsyKCZ07KOXVHshKClWeFv2soWRlh5M24hbdSyKMRZq9t
2u1TSlZFOLLbT3VyI1kN4VbAHwVqPWR1hAzJMp0VI/+VWRMhwfZu/xNdshaC
XoLeX3fMydoI1/f1qltJyBMRGl52zlBxIusgnE30jfHeQNZFwFWDwbZ+5CnC
+RqB+mmBZAOE0MshV+OCyIYIV84vTBm1nTwdob6ztHjKNrIRwqkmiUntVrIx
gvfOCjUVf7IpgqjK3L/VnWyGEGslNNSFPBtB3GAf47OYPAfBTSfAQcGKbIGQ
rBEbbD+NbImQCyYKKmPJ1sJ9xleOCB2i97NFCMPlO4KfkucjmDVI1ylVkwGh
OXfSVasc8gKE/IT4f+RjyRKE0v6ga9s2kR0QVs6qexS1gLxYuL+KftSiCeSl
Qj+9O8ZXvKa8fIdg73x2vVwVeTnCfvn+4TrJZEeEjf2uBob+ZCeEeykLWuZa
kFchrC6yqtv6Jc+uCDE+1QV9Usr7GgRXo+zsd8fI64R8zZduPL+B7CbUV1RZ
429A3ogQ0VAT5d5O8+aB8G5q8+mes2QvhMJGQ42DIWQfwQ52khM2ZD+Eis3l
By6Kyf4ItdJPi+Z/C8LMLf25IkYORNn8hZO/RxCqV36yhhyE4LVv/9E59uTt
CNoP88oHjcjBCC86Zg9lTSCHInwbr2VXrEoOR2hTjivL+4a8E2GcV98iLQVy
BIJDV1v7IXlyJMLiJzvVz4wg70HQcQ7zHadM3ivUfzKlK0SNHIUgl9v+PEyb
/DOCRyJeqtcnxyA4d7x3sDElxyIomBh4BFuR4xDuW3qZzF9IPiT0+06l2H0l
+TCC76m+yBMbyAkI5S5p0LiZnCjkecWzJTdDyEkIs0a+TPX7iZyMMChdy7bH
kX9BOOpsc+V2EjkVoerSjZIgJKchxGuP9TI9RUbhPe12yX3IJ2cgzIjWvFdX
TM5EUE0qSP/1AvkkQt3gR0vPCnK2MH+JaW1Tq8g5CPpstW1fNTkPwVDH0eJ5
DfkMwvPuJdPUvuQlH2HM3L9bTnxxIZenIs7nOZdwLuVcxvki58ucKzhXcq7i
XM25hrOUcx3nes43Od/mfIdzI+f7nJs4P+T8mHMz52ecX3Bu5dzOuZNzF+du
zm8493J+y3mA8zvOQ5w/cBal/99iznKcFTgrclbirMx5NGdVzmqc1Tlrctbi
rM15Imcdzrqcp3A24GzIeTpnI87GX/0fHshoJg==
              "]]}, {
             Hue[0.9060679774997897, 0.6, 0.6], 
             Directive[
              PointSize[
               NCache[
                Rational[1, 90], 0.011111111111111112`]], 
              AbsoluteThickness[1.6], 
              GrayLevel[0]], 
             LineBox[CompressedData["
1:eJxd0wtQlFUUB/AdhgQJUTcSxpB4BWRqxSA6GXhC8DUiugklJvLSDDAlJAgF
UfGBwiqNAQZyD76AJFCgIGKQAAFdMofHRromumJkKMuyCTokre5hms6d+ebO
b858d+73/86xD9sq22gkkUiq9c+z/fnaKSBAVX1pVPVw4XOnCDCWG0+Pjhww
OFWA7SqPXrMB8kEBxZ9YdayYpzE4XYAUz2Z9G0c+KuCJT77T+gryMQH267LK
FBpyjoB0vzf2wZxBg/MEWDsUlv0RRUb9+1WK5JvF5NMCfmhpPzCnj1wkIMo3
V61y1hpcIiD56Q7N9Y3k8wLW1yvMXzlDrhQQHGGUnHGXXC3gjqdJlqPTkMG1
AlzcYncrwsn1AqKdb0XHniI3CRgYU6dOVJNbBVyd23YtwUFncJsAmQumnQ8l
XxOw5wPFieNI7hRQ+FrgYsdb5G4BzZYlMR4z/jZYJeBprpVLXRC5R0BciSzx
bDb5rgDPRfM3/dZB7hOwef2pXpj8yOB+fV5JY/cuLSNrBEy1yY55fy9ZJ6C8
piu2/UfyiIDusKpfZg6RRwWkZRfG+r4+bLAE4WLoyffMgslGCMHKJqMNmWRj
hATtnxdmN5InIHQr/cfWDpFNEbZK99ZfsR8x2AzBEt4uj1hJNkfAJyaZ5l+Q
LRC6+rokZwrIUxAOn1laJ20lSxG2qP3XePSTLRGcA274aSY9NngaQpTLcm+H
2WRrhJZ8z+ziZeTpCD+NBZaHh5NtENTyeY9nJ5JtEQ4UNYjbGWQ7hFdP1GjX
5pMdEG70+OiizpGdELShj8ofVJKdEXbgy9blNWRXfT6uZrq0WvJMhGarB4Pe
4/VZCPa2+sQryHMQnJKCfHcVkd9CWGx6xEOeQ3ZDmBySuWFhKtkdwXVAvVke
TfZA6Azdt85LRp6PULWoMaxzLvkdhFKLlOpzVuR3Ef6RDiofD1OeXghukjUx
aiUZEJTyOzZxlWRvhGmFQS9WHCX7IBRoy3q/iiIv1p/nZu0o9SUvRfBf6/fr
SzPIyxG+Ux2fuH+8P1bo811x6Ih/K3mlvl9qF7gF5pJXIaR5K2p2RZNlCLKh
AO2FBeQ1CFdXL2npMiUHIoRc2H9Y1UH9/CFCw9x43cU8chBCUrYsOz2c/BFC
eNhQzBZXcjDCJHcRW/UXzVeIvr+OFPaalJLDEE6757aEbiNHINg9vB8Q4U7e
hCC5vSgta5TmezPCz23PFjlS/33KnqSAUnK0/v+FTW20OEX+FEFkmmaEjHsb
wk3YHa8tJn+GUBvfmTOlgrwdwberbLtXLflzBM8QW7feRnKCfr5W1+jevExO
RLj8wseaYQV5J7tfMnMKwrFIIW8Z9x5WT2Xez3yQ+RBzOrOc+Sjzl8zHmLOY
c5i/Zs5jzmdG5pPMp5nPMhcxf8NcwlzKfJ65nLmS+XvmauYa5lrmOuZ65gbm
JuZm5lbmK8xtzFeZrzG3M3cyK5m7ma8zq5h/Z+5hvsN8l/kecx/zfeZ+5ofM
GmYts475EfMI8xPmUeanzJKC/9uI2Zh5ArMpsxmzObMF8xRmKbMl8zRma+bp
zDbMtsx2zA7MTszOzK7MM5ln/ed/Aahyqfo=
              "]]}}, {{
             Directive[
              PointSize[
               NCache[
                Rational[1, 90], 0.011111111111111112`]], 
              AbsoluteThickness[1.6], 
              RGBColor[0, 0, 1]]}, {
             Directive[
              PointSize[
               NCache[
                Rational[1, 90], 0.011111111111111112`]], 
              AbsoluteThickness[1.6], 
              GrayLevel[0]]}}, {{
             Directive[
              PointSize[
               NCache[
                Rational[1, 90], 0.011111111111111112`]], 
              AbsoluteThickness[1.6], 
              RGBColor[0, 0, 1]]}, {
             Directive[
              PointSize[
               NCache[
                Rational[1, 90], 0.011111111111111112`]], 
              AbsoluteThickness[1.6], 
              GrayLevel[0]]}, {}, {}, {}}, {{
             Directive[
              PointSize[
               NCache[
                Rational[1, 90], 0.011111111111111112`]], 
              AbsoluteThickness[1.6], 
              RGBColor[0, 0, 1]]}, {
             Directive[
              PointSize[
               NCache[
                Rational[1, 90], 0.011111111111111112`]], 
              AbsoluteThickness[1.6], 
              GrayLevel[0]]}, {}, {}, {}}}, {{}, {}}}, {{{{}, {}, 
            TagBox[{
              Directive[
               Opacity[1.], 
               AbsoluteThickness[1.6], 
               GrayLevel[0.5], 
               Dashing[{Small, Small}], 
               Thickness[Tiny]], 
              LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQfTTuLwNDzXyHs2dA4Iv95PZeK+dmBD9xg2xJWxeC
b3z97lrXWQj+483Kh3+uQOIH+DKlbEfwJQ+LcbAfR/B1X6e+nHcVwS9/ETIx
/ymCL7RMPfnbFwT/KI8Dx07GBXC+jKGN02ROBD/J4PfL5wII/gX+NcvEJRD8
mzfXHHssj+BfrCsI0VJH8FP4Wlx59RF8+bpO79NmCP7JE4H7me0QfL5/mdNu
uCL4Tnyut9V9EXxBzoJm4VAEn+NJj8OtGAT/3cycbOkUBD/fas7PH9kI/v2t
fV8DihH8csFitpYqBH9V+PKq4CYE/0zFvJi5nQh+Z8vThc0TEfy8Ark/LjOR
3GsudaRhAYK/8UXq+4gVCD5/aUnH6vUI/tSHJWY3tyH42yyOui/eh+Afy7px
7PlRBL+w3XrlibMIPnd94k/lqwj+2bDKuKg7CL6W5EM13ScIftk27tiq1wh+
rF3bt+TPCH7usk9LNH4j+NkvFQ+mMy2E81nEFzo4cyH4PfKPdWcKIvg2HOIG
pyQQ/I7bs6ZOV0DwD3U+zLivjuAb5Bpuea+N4M8NaPz/Xx/BBwAbVv2/
               "]]}, 
             Annotation[#, "Charting`Private`Tag$182384#1"]& ]}}, {}}, {
          GrayLevel[0.5], 
          Dashing[{Small, Small}], 
          Thickness[Tiny], 
          LineBox[{{2100, 0}, {2100, 1.8}}]}}, {
        DisplayFunction -> Identity, DisplayFunction -> Identity, AspectRatio -> 
         NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
         AxesLabel -> {None, None}, AxesOrigin -> {2015., 0.9}, 
         DisplayFunction :> Identity, Epilog -> InsetBox[
           FormBox[
            StyleBox[
            "\"d) delta SAT \"", {FontFamily -> "Helvetica", FontSize -> 20}, 
             StripOnInput -> False], TraditionalForm], 
           Offset[{0, 0}, 
            Scaled[{0.8, 0.95}]], {0, 0}], 
         Frame -> {{True, False}, {True, False}}, FrameLabel -> {{
            FormBox["\"\[Degree]C\"", TraditionalForm], None}, {
            FormBox["\"Year\"", TraditionalForm], None}}, FrameStyle -> {
           GrayLevel[0], 
           GrayLevel[0], Automatic, 
           GrayLevel[0]}, 
         FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
         GridLines -> {None, None}, GridLinesStyle -> Directive[
           GrayLevel[0.5, 0.4]], ImageSize -> 600, LabelStyle -> 
         Directive[FontFamily -> "Helvetica", FontSize -> 18, 
           GrayLevel[0]], 
         Method -> {
          "OptimizePlotMarkers" -> True, 
           "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
               (Identity[#]& )[
                Part[#, 1]], 
               (Identity[#]& )[
                Part[#, 2]]}& ), "CopiedValueFunction" -> ({
               (Identity[#]& )[
                Part[#, 1]], 
               (Identity[#]& )[
                Part[#, 2]]}& )}}, PlotRange -> {{2015, 2200}, {0.9, 1.8}}, 
         PlotRangeClipping -> True, PlotRangePadding -> {{0, 0}, {0, 0}}, 
         Ticks -> {Automatic, Automatic}}], 
       GraphicsBox[{{{}, {{{}, {}, {
             Hue[0.67, 0.6, 0.6], 
             Directive[
              PointSize[
               NCache[
                Rational[1, 90], 0.011111111111111112`]], 
              AbsoluteThickness[1.6], 
              RGBColor[0, 0, 1]], 
             LineBox[CompressedData["
1:eJw11gtUDvkbB/CQilJuvVGhCIV1eSNh8d3e3Ja/2jZOZYku2EVuSUpSrW4S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              "]]}, {
             Hue[0.9060679774997897, 0.6, 0.6], 
             Directive[
              PointSize[
               NCache[
                Rational[1, 90], 0.011111111111111112`]], 
              AbsoluteThickness[1.6], 
              GrayLevel[0]], 
             LineBox[CompressedData["
1:eJw11Qs0VfkeB3A1SJGM0Ll6kqEMiQ5Jgx896KU8QumpUkqRYohoXGoqFWq6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              "]]}}, {{
             Directive[
              PointSize[
               NCache[
                Rational[1, 90], 0.011111111111111112`]], 
              AbsoluteThickness[1.6], 
              RGBColor[0, 0, 1]]}, {
             Directive[
              PointSize[
               NCache[
                Rational[1, 90], 0.011111111111111112`]], 
              AbsoluteThickness[1.6], 
              GrayLevel[0]]}}, {{
             Directive[
              PointSize[
               NCache[
                Rational[1, 90], 0.011111111111111112`]], 
              AbsoluteThickness[1.6], 
              RGBColor[0, 0, 1]]}, {
             Directive[
              PointSize[
               NCache[
                Rational[1, 90], 0.011111111111111112`]], 
              AbsoluteThickness[1.6], 
              GrayLevel[0]]}, {}, {}, {}}, {{
             Directive[
              PointSize[
               NCache[
                Rational[1, 90], 0.011111111111111112`]], 
              AbsoluteThickness[1.6], 
              RGBColor[0, 0, 1]]}, {
             Directive[
              PointSize[
               NCache[
                Rational[1, 90], 0.011111111111111112`]], 
              AbsoluteThickness[1.6], 
              GrayLevel[0]]}, {}, {}, {}}}, {{}, {}}}, {{{{}, {}, 
            TagBox[{
              Directive[
               Opacity[1.], 
               AbsoluteThickness[1.6], 
               GrayLevel[0.5], 
               Dashing[{Small, Small}], 
               Thickness[Tiny]], 
              LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQfTTuLwNDzXyHs2dA4Iv95PZeK+dmBD9xg2xJWxeC
b3z97lrXWQj+483Kh3+uQOIH+DKlbEfwJQ+LcbAfR/B1X6e+nHcVwS9/ETIx
/ymCL7RMPfnbFwT/KI8Dx07GBXC+jKGN02ROBD/J4PfL5wII/gX+NcvEJRD8
mzfXHHssj+BfrCsI0VJH8FP4Wlx59RF8+bpO79NmCP7JE4H7me0QfL5/mdNu
uCL4Tnyut9V9EXxBzoJm4VAEn+NJj8OtGAT/3cycbOkUBD/fas7PH9kI/v2t
fV8DihH8csFitpYqBH9V+PKq4CYE/0zFvJi5nQh+Z8vThc0TEfy8Ark/LjOR
3GsudaRhAYK/8UXq+4gVCD5/aUnH6vUI/tSHJWY3tyH42yyOui/eh+Afy7px
7PlRBL+w3XrlibMIPnd94k/lqwj+2bDKuKg7CL6W5EM13ScIftk27tiq1wh+
rF3bt+TPCH7usk9LNH4j+NkvFQ+mMy2E81nEFzo4cyH4PfKPdWcKIvg2HOIG
pyQQ/I7bs6ZOV0DwD3U+zLivjuAb5Bpuea+N4M8NaPz/Xx/BBwAbVv2/
               "]]}, 
             Annotation[#, "Charting`Private`Tag$190237#1"]& ]}}, {}}, {
          GrayLevel[0.5], 
          Dashing[{Small, Small}], 
          Thickness[Tiny], 
          LineBox[{{2100, 0}, {2100, 1.8}}]}}, {
        DisplayFunction -> Identity, DisplayFunction -> Identity, AspectRatio -> 
         NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
         AxesLabel -> {None, None}, AxesOrigin -> {2015., 650.}, 
         DisplayFunction :> Identity, Epilog -> InsetBox[
           FormBox[
            StyleBox[
            "\"e) C atmos\"", {FontFamily -> "Helvetica", FontSize -> 20}, 
             StripOnInput -> False], TraditionalForm], 
           Offset[{0, 0}, 
            Scaled[{0.8, 0.95}]], {0, 0}], 
         Frame -> {{True, False}, {True, False}}, FrameLabel -> {{
            FormBox["\"GtC\"", TraditionalForm], None}, {
            FormBox["\"Year\"", TraditionalForm], None}}, FrameStyle -> {
           GrayLevel[0], 
           GrayLevel[0], Automatic, 
           GrayLevel[0]}, 
         FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
         GridLines -> {None, None}, GridLinesStyle -> Directive[
           GrayLevel[0.5, 0.4]], ImageSize -> 600, LabelStyle -> 
         Directive[FontFamily -> "Helvetica", FontSize -> 18, 
           GrayLevel[0]], 
         Method -> {
          "OptimizePlotMarkers" -> True, 
           "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
               (Identity[#]& )[
                Part[#, 1]], 
               (Identity[#]& )[
                Part[#, 2]]}& ), "CopiedValueFunction" -> ({
               (Identity[#]& )[
                Part[#, 1]], 
               (Identity[#]& )[
                Part[#, 2]]}& )}}, PlotRange -> {{2015, 2200}, {650, 1100}}, 
         PlotRangeClipping -> True, PlotRangePadding -> {{0, 0}, {0, 0}}, 
         Ticks -> {Automatic, Automatic}}]}}, AutoDelete -> False, 
     GridBoxFrame -> {"Columns" -> {{True}}, "Rows" -> {{True}}}, 
     GridBoxItemSize -> {
      "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"],FormBox[
    TemplateBox[{
      StyleBox[
      "\"DICE2016\"", FontFamily -> "Helvetica", FontSize -> 20, StripOnInput -> 
       False], 
      StyleBox[
      "\"FaIR-Geoffroy\"", FontFamily -> "Helvetica", FontSize -> 20, 
       StripOnInput -> False]}, "LineLegend", DisplayFunction -> (FormBox[
       StyleBox[
        StyleBox[
         PaneBox[
          TagBox[
           GridBox[{{
              TagBox[
               GridBox[{{
                  GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0]], {
                    LineBox[{{0, 20}, {20, 20}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0]], {}}}, AspectRatio -> Full, 
                   ImageSize -> {20, 20}, PlotRangePadding -> None, 
                   ImagePadding -> Automatic, 
                   BaselinePosition -> (Scaled[0.30000000000000004`] -> 
                    Baseline)], #, 
                  GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1]], {
                    LineBox[{{0, 20}, {20, 20}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1]], {}}}, AspectRatio -> Full, 
                   ImageSize -> {20, 20}, PlotRangePadding -> None, 
                   ImagePadding -> Automatic, 
                   BaselinePosition -> (Scaled[0.30000000000000004`] -> 
                    Baseline)], #2}}, 
                GridBoxAlignment -> {
                 "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                AutoDelete -> False, 
                GridBoxDividers -> {
                 "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
                GridBoxSpacings -> {"Columns" -> {{0.8, 0.5}}}], "Grid"]}}, 
            GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
            AutoDelete -> False, 
            GridBoxDividers -> {"Columns" -> {{None}}, "Rows" -> {{None}}}, 
            GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
            GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{1}}}], 
           "Grid"], Alignment -> Left, AppearanceElements -> None, 
          ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> "ResizeToFit"],
          LineIndent -> 0, StripOnInput -> False], {FontFamily -> "Arial"}, 
        Background -> Automatic, StripOnInput -> False], TraditionalForm]& ), 
     InterpretationFunction :> (RowBox[{"LineLegend", "[", 
        RowBox[{
          RowBox[{"{", 
            RowBox[{
              InterpretationBox[
               ButtonBox[
                TooltipBox[
                 GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                  "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                  FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                  PlotRangePadding -> None, ImageSize -> 
                  Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                 StyleBox[
                  RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                  False]], Appearance -> None, BaseStyle -> {}, 
                BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                  If[
                   Not[
                    AbsoluteCurrentValue["Deployed"]], 
                   SelectionMove[Typeset`box$, All, Expression]; 
                   FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                   FrontEnd`Private`$ColorSelectorInitialColor = GrayLevel[0]; 
                   FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                   MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                Automatic, Method -> "Preemptive"], 
               GrayLevel[0], Editable -> False, Selectable -> False], ",", 
              InterpretationBox[
               ButtonBox[
                TooltipBox[
                 GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                  "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                  FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                  FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                  Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                 StyleBox[
                  RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                  False]], Appearance -> None, BaseStyle -> {}, 
                BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                  If[
                   Not[
                    AbsoluteCurrentValue["Deployed"]], 
                   SelectionMove[Typeset`box$, All, Expression]; 
                   FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                   FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                   FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                   MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                Automatic, Method -> "Preemptive"], 
               RGBColor[0, 0, 1], Editable -> False, Selectable -> False]}], 
            "}"}], ",", 
          RowBox[{"{", 
            RowBox[{#, ",", #2}], "}"}], ",", 
          RowBox[{"LegendMarkerSize", "\[Rule]", "20"}], ",", 
          RowBox[{"LegendLayout", "\[Rule]", 
            RowBox[{"{", 
              RowBox[{"\"Row\"", ",", "1"}], "}"}]}]}], "]"}]& ), Editable -> 
     True], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "Below"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{{3.8254404460172057`*^9, 3.8254404829212575`*^9}, 
   3.8254406390724773`*^9, 3.82544070457257*^9, 3.82544081856073*^9, 
   3.8254408589557867`*^9},
 CellLabel->
  "Out[1147]=",ExpressionUUID->"dc84bf8b-0a3c-4786-af72-2310ca18b0fd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<SI62100.tiff\>\"", ",", "SI62100"}], "]"}]], "Input",
 CellChangeTimes->{{3.8254408643267946`*^9, 3.8254408806588173`*^9}},
 CellLabel->
  "In[1148]:=",ExpressionUUID->"d47b5dbd-1e1d-4f60-825a-21407b9e2213"],

Cell[BoxData["\<\"SI62100.tiff\"\>"], "Output",
 CellChangeTimes->{3.8254408885598288`*^9},
 CellLabel->
  "Out[1148]=",ExpressionUUID->"27b12c2c-eee7-41fb-9c78-f5ada9debdf6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"ospD16low", "[", 
      RowBox[{"[", 
       RowBox[{
        RowBox[{"2", ";;", "185"}], ",", "9"}], "]"}], "]"}], ",", 
     RowBox[{"ospFGmedium", "[", 
      RowBox[{"[", 
       RowBox[{
        RowBox[{"2", ";;", "185"}], ",", "22"}], "]"}], "]"}]}], "}"}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "500"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8254254565644913`*^9, 3.825425480826026*^9}, {
  3.825425532031598*^9, 3.8254255356916037`*^9}, {3.825425613420713*^9, 
  3.825425616783218*^9}},
 CellLabel->
  "In[1106]:=",ExpressionUUID->"284d7b8c-06af-48b7-93a0-e8f19967b0d5"],

Cell[BoxData[
 GraphicsBox[{{}, {{{}, {}, 
     {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
       NCache[
        Rational[1, 90], 0.011111111111111112`]], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJw11glUVNcdBvBBECioKCIa0LIoIEoJi2BAlg9QFtmHdWCYfYZFEUUNxQhM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       "]]}, 
     {RGBColor[0.880722, 0.611041, 0.142051], PointSize[
       NCache[
        Rational[1, 90], 0.011111111111111112`]], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJw11glQU+caBuCIckHckFq1F1TAuiAICtSy8wKyCARDCCQsQnKysINcRCyg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       "]]}}, {
     {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
       NCache[
        Rational[1, 90], 0.011111111111111112`]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.880722, 0.611041, 0.142051], PointSize[
       NCache[
        Rational[1, 90], 0.011111111111111112`]], AbsoluteThickness[1.6]}}, {
     {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
       NCache[
        Rational[1, 90], 0.011111111111111112`]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.880722, 0.611041, 0.142051], PointSize[
       NCache[
        Rational[1, 90], 0.011111111111111112`]], AbsoluteThickness[
      1.6]}, {}, {}, {}}, {
     {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
       NCache[
        Rational[1, 90], 0.011111111111111112`]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.880722, 0.611041, 0.142051], PointSize[
       NCache[
        Rational[1, 90], 0.011111111111111112`]], AbsoluteThickness[
      1.6]}, {}, {}, {}}}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0., 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->500,
  Method->{
   "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0., 184.}, {0, 422.678868}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.8254254811960263`*^9, 3.825425536161604*^9, 
  3.8254256172632184`*^9},
 CellLabel->
  "Out[1106]=",ExpressionUUID->"1095aae3-0d17-4218-8848-598c52a92cac"]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{
  3.8254249205047336`*^9},ExpressionUUID->"2ec21420-69d6-4d4f-b4b8-\
1cce8e5f5b4c"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Dimensions", "[", "osD16medium", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Dimensions", "[", "osD16low", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Dimensions", "[", "osD16high", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Dimensions", "[", "osFGmedium", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Dimensions", "[", "osFGlow", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Dimensions", "[", "osFGhigh", "]"}]}], "Input",
 CellChangeTimes->{{3.8237008744639816`*^9, 3.8237009583231535`*^9}},
 CellLabel->
  "In[323]:=",ExpressionUUID->"d6afa5b2-e232-4817-9f83-5b7e246f34a5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"137", ",", "48"}], "}"}]], "Output",
 CellChangeTimes->{3.823700892477007*^9, 3.8237009589431543`*^9, 
  3.823701917024619*^9, 3.8237022692551727`*^9, 3.8237452291557803`*^9, 
  3.8238789128684444`*^9, 3.82428347600815*^9, 3.8246193287823524`*^9, 
  3.8246198251649265`*^9, 3.8246198581200686`*^9, 3.8246202154001074`*^9},
 CellLabel->
  "Out[323]=",ExpressionUUID->"38365c7d-2c7d-43d1-8320-a3e257afe8d5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"137", ",", "48"}], "}"}]], "Output",
 CellChangeTimes->{3.823700892477007*^9, 3.8237009589431543`*^9, 
  3.823701917024619*^9, 3.8237022692551727`*^9, 3.8237452291557803`*^9, 
  3.8238789128684444`*^9, 3.82428347600815*^9, 3.8246193287823524`*^9, 
  3.8246198251649265`*^9, 3.8246198581200686`*^9, 3.8246202154052544`*^9},
 CellLabel->
  "Out[324]=",ExpressionUUID->"e658ba7c-3420-4ae2-b911-ea2bcfd153c5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"137", ",", "48"}], "}"}]], "Output",
 CellChangeTimes->{3.823700892477007*^9, 3.8237009589431543`*^9, 
  3.823701917024619*^9, 3.8237022692551727`*^9, 3.8237452291557803`*^9, 
  3.8238789128684444`*^9, 3.82428347600815*^9, 3.8246193287823524`*^9, 
  3.8246198251649265`*^9, 3.8246198581200686`*^9, 3.824620215413495*^9},
 CellLabel->
  "Out[325]=",ExpressionUUID->"b6542fb2-8626-4845-a76b-a88d1fda0577"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"137", ",", "48"}], "}"}]], "Output",
 CellChangeTimes->{3.823700892477007*^9, 3.8237009589431543`*^9, 
  3.823701917024619*^9, 3.8237022692551727`*^9, 3.8237452291557803`*^9, 
  3.8238789128684444`*^9, 3.82428347600815*^9, 3.8246193287823524`*^9, 
  3.8246198251649265`*^9, 3.8246198581200686`*^9, 3.82462021541449*^9},
 CellLabel->
  "Out[326]=",ExpressionUUID->"9cd3bdaa-3c05-4fcf-bda0-b7394d93743a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"137", ",", "48"}], "}"}]], "Output",
 CellChangeTimes->{3.823700892477007*^9, 3.8237009589431543`*^9, 
  3.823701917024619*^9, 3.8237022692551727`*^9, 3.8237452291557803`*^9, 
  3.8238789128684444`*^9, 3.82428347600815*^9, 3.8246193287823524`*^9, 
  3.8246198251649265`*^9, 3.8246198581200686`*^9, 3.8246202154224377`*^9},
 CellLabel->
  "Out[327]=",ExpressionUUID->"5f99ddfd-ecd9-4fde-9621-848b0679780e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"137", ",", "48"}], "}"}]], "Output",
 CellChangeTimes->{3.823700892477007*^9, 3.8237009589431543`*^9, 
  3.823701917024619*^9, 3.8237022692551727`*^9, 3.8237452291557803`*^9, 
  3.8238789128684444`*^9, 3.82428347600815*^9, 3.8246193287823524`*^9, 
  3.8246198251649265`*^9, 3.8246198581200686`*^9, 3.8246202154282303`*^9},
 CellLabel->
  "Out[328]=",ExpressionUUID->"b5f0986d-6c1f-4771-998c-4f9f90113145"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dimensions", "[", 
  RowBox[{"SI6T1", "[", 
   RowBox[{"[", 
    RowBox[{
     RowBox[{"3", ";;"}], ",", "1"}], "]"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.824653431326795*^9, 3.8246534453795447`*^9}},
 CellLabel->
  "In[462]:=",ExpressionUUID->"5b9514b7-e0ab-46ed-a0b2-5948b26fa027"],

Cell[BoxData[
 RowBox[{"{", "6", "}"}]], "Output",
 CellChangeTimes->{3.8246534460740385`*^9, 3.824653503381032*^9},
 CellLabel->
  "Out[462]=",ExpressionUUID->"2ea5c800-6a1c-4a28-85bb-2e3ac9bb313e"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SI6T1", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"\"\<-\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "14"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "17"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SI6T1", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", ";;"}], "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
    "\"\<\>\"", ",", "\"\<\>\"", ",", "\"\<\>\"", ",", "\"\<Peak\>\"", ",", 
     "\"\<\>\"", ",", "\"\<\>\"", ",", "\"\<DIVE-T\>\"", ",", "\"\<\>\"", 
     ",", "\"\<\>\"", ",", "\"\<Peak-A\>\"", ",", "\"\<\>\"", ",", "\"\<\>\"",
      ",", "\"\<Ct1\>\"", ",", "\"\<\>\"", ",", "\"\<\>\"", ",", 
     "\"\<DIVE-C\>\"", ",", "\"\<\>\""}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SI6T1", "[", 
    RowBox[{"[", 
     RowBox[{"2", ",", ";;"}], "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
    "\"\<\>\"", ",", "\"\<\>\"", ",", "\"\<low\>\"", ",", "\"\<medium\>\"", 
     ",", "\"\<high\>\"", ",", "\"\<low\>\"", ",", "\"\<medium\>\"", ",", 
     "\"\<high\>\"", ",", "\"\<low\>\"", ",", "\"\<medium\>\"", ",", 
     "\"\<high\>\"", ",", "\"\<low\>\"", ",", "\"\<medium\>\"", ",", 
     "\"\<high\>\"", ",", "\"\<low\>\"", ",", "\"\<medium\>\"", ",", 
     "\"\<high\>\""}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"SI6T1", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"3", ";;"}], ",", "1"}], "]"}], "]"}], "=", 
    RowBox[{"{", 
     RowBox[{
     "\"\<D16\>\"", ",", "\"\<\>\"", ",", "\"\<\>\"", ",", "\"\<D13\>\"", 
      ",", "\"\<\>\"", ",", "\"\<\>\"", ",", "\"\<D07\>\"", ",", "\"\<\>\"", 
      ",", "\"\<\>\"", ",", "\"\<FG\>\"", ",", "\"\<\>\"", ",", "\"\<\>\""}], 
     "}"}]}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"SI6T1", "[", 
      RowBox[{"[", 
       RowBox[{
        RowBox[{"3", ";;"}], ",", "2"}], "]"}], "]"}], "=", 
     RowBox[{"{", 
      RowBox[{
      "\"\<low\>\"", ",", "\"\<med\>\"", ",", "\"\<high\>\"", ",", 
       "\"\<low\>\"", ",", "\"\<med\>\"", ",", "\"\<high\>\""}], "}"}]}], 
    ";"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SI6T1", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"3", ";;"}], ",", "2"}], "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
    "\"\<2050\>\"", ",", "\"\<2100\>\"", ",", "\"\<2150\>\"", ",", 
     "\"\<2050\>\"", ",", "\"\<2100\>\"", ",", "\"\<2150\>\"", ",", 
     "\"\<2050\>\"", ",", "\"\<2100\>\"", ",", "\"\<2150\>\"", ",", 
     "\"\<2050\>\"", ",", "\"\<2100\>\"", ",", "\"\<2150\>\""}], "}"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.8246529561815195`*^9, 3.824653074149477*^9}, {
   3.824653116588577*^9, 3.8246533950998235`*^9}, 3.824653499373687*^9, {
   3.82465353224226*^9, 3.824653555960035*^9}, 3.8246537129007654`*^9, {
   3.8246553031620817`*^9, 3.824655338370352*^9}, 3.8246640084748864`*^9, {
   3.8246641412516317`*^9, 3.8246642215879493`*^9}, {3.8251802846189194`*^9, 
   3.825180311013957*^9}, {3.8251803732340446`*^9, 3.825180375784048*^9}},
 CellLabel->"In[26]:=",ExpressionUUID->"0c2f880e-8792-46e8-b64f-92936093aed6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SI6T1", "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.8246642297492127`*^9, 3.824664235828268*^9}},
 CellLabel->"In[59]:=",ExpressionUUID->"3b267443-f450-4d37-8893-11cd7271af87"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"Peak\"\>", "\<\"\"\>", "\<\"\"\
\>", "\<\"DIVE-T\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"Peak-A\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"Ct1\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"DIVE-C\"\>", \
"\<\"\"\>"},
     {"\<\"\"\>", "\<\"\"\>", "\<\"low\"\>", "\<\"medium\"\>", \
"\<\"high\"\>", "\<\"low\"\>", "\<\"medium\"\>", "\<\"high\"\>", \
"\<\"low\"\>", "\<\"medium\"\>", "\<\"high\"\>", "\<\"low\"\>", "\<\"medium\"\
\>", "\<\"high\"\>", "\<\"low\"\>", "\<\"medium\"\>", "\<\"high\"\>"},
     {"\<\"D16\"\>", "\<\"2050\"\>", "0.`", "0.`", 
      "0.`", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "856.652471`", 
      "855.649454`", "855.266156`", "807.803238`", "808.695348`", 
      "809.225664`", 
      RowBox[{"-", "42.380322`"}], 
      RowBox[{"-", "42.427722`"}], 
      RowBox[{"-", "42.349605`"}]},
     {"\<\"\"\>", "\<\"2100\"\>", "0.438282`", "0.34459`", "0.290345`", 
      RowBox[{"-", "0.311696`"}], 
      RowBox[{"-", "0.229678`"}], 
      RowBox[{"-", "0.186736`"}], "971.044968`", "943.798895`", "927.872988`",
       "664.0464`", "693.085872`", "709.340224`", "60.29757`", "52.046701`", 
      "47.049967`"},
     {"\<\"\"\>", "\<\"2150\"\>", "1.342913`", "1.128765`", "1.00233`", 
      RowBox[{"-", "0.785576`"}], 
      RowBox[{"-", "0.601822`"}], 
      RowBox[{"-", "0.50654`"}], "1222.765807`", "1153.396162`", 
      "1113.274991`", "511.027945`", "565.063865`", "595.340352`", 
      "83.163859`", "79.343306`", "76.341426`"},
     {"\<\"D13\"\>", "\<\"2050\"\>", "0.`", "0.`", 
      "0.`", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "874.868558`", 
      "873.485225`", "872.959602`", "841.275039`", "842.505359`", 
      "842.960102`", 
      RowBox[{"-", "46.347855`"}], 
      RowBox[{"-", "45.866622`"}], 
      RowBox[{"-", "45.673126`"}]},
     {"\<\"\"\>", "\<\"2100\"\>", "0.407229`", "0.33893`", "0.29836`", 
      RowBox[{"-", "0.295004`"}], 
      RowBox[{"-", "0.226572`"}], 
      RowBox[{"-", "0.190212`"}], "996.513914`", "974.637175`", "962.127832`",
       "691.090385`", "715.891363`", "729.749485`", "59.019403`", 
      "52.060748`", "47.838464`"},
     {"\<\"\"\>", "\<\"2150\"\>", "1.207293`", "1.049092`", "0.953259`", 
      RowBox[{"-", "0.63739`"}], 
      RowBox[{"-", "0.490565`"}], 
      RowBox[{"-", "0.413194`"}], "1240.183286`", "1186.772865`", 
      "1155.485456`", "570.447561`", "617.189997`", "644.009132`", 
      "92.616681`", "85.463632`", "81.050578`"},
     {"\<\"D07\"\>", "\<\"2050\"\>", "0.`", "0.`", 
      "0.`", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "881.690764`", 
      "880.34037`", "879.845332`", "856.484766`", "857.740476`", 
      "858.210082`", 
      RowBox[{"-", "37.365845`"}], 
      RowBox[{"-", "36.755695`"}], 
      RowBox[{"-", "36.49427`"}]},
     {"\<\"\"\>", "\<\"2100\"\>", "0.426977`", "0.362006`", "0.323132`", 
      RowBox[{"-", "0.29064`"}], 
      RowBox[{"-", "0.223587`"}], 
      RowBox[{"-", "0.188459`"}], "1009.325554`", "988.28435`", "976.301271`",
       "723.543374`", "744.224546`", "755.431115`", "39.677215`", 
      "35.680771`", "32.8309`"},
     {"\<\"\"\>", "\<\"2150\"\>", "1.187247`", "1.043`", "0.954473`", 
      RowBox[{"-", "0.577632`"}], 
      RowBox[{"-", "0.445713`"}], 
      RowBox[{"-", "0.375777`"}], "1246.205696`", "1196.265605`", 
      "1166.824103`", "620.685141`", "658.34857`", "680.00503`", "62.726071`",
       "58.63822`", "55.855617`"},
     {"\<\"FG\"\>", "\<\"2050\"\>", "0.`", "0", 
      "0.`", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", "911.330759`", 
      "910.606751`", "910.271601`", "905.683451`", "906.317786`", 
      "906.532382`", 
      RowBox[{"-", "12.24114`"}], 
      RowBox[{"-", "10.600776`"}], 
      RowBox[{"-", "9.888807`"}]},
     {"\<\"\"\>", "\<\"2100\"\>", "0.43647`", "0.356405`", "0.30853`", 
      RowBox[{"-", "0.238767`"}], 
      RowBox[{"-", "0.172928`"}], 
      RowBox[{"-", "0.139657`"}], "1048.411741`", "1020.90485`", 
      "1004.953569`", "836.083892`", "843.948295`", "848.935524`", 
      RowBox[{"-", "61.599514`"}], 
      RowBox[{"-", "47.395095`"}], 
      RowBox[{"-", "40.375658`"}]},
     {"\<\"\"\>", "\<\"2150\"\>", "1.126197`", "0.95359`", "0.848611`", 
      RowBox[{"-", "0.46701`"}], 
      RowBox[{"-", "0.362945`"}], 
      RowBox[{"-", "0.309593`"}], "1299.110987`", "1230.380822`", 
      "1190.438038`", "759.847765`", "776.265563`", "785.45194`", 
      RowBox[{"-", "97.732234`"}], 
      RowBox[{"-", "76.674356`"}], 
      RowBox[{"-", "65.863619`"}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.8246642365090337`*^9, 3.8246642903496056`*^9, 
  3.8246643451185827`*^9, 3.824664397765046*^9, 3.8246644553807735`*^9, 
  3.824664494666582*^9, 3.8246645479283237`*^9, 3.8246646643756204`*^9, 
  3.8251803440500035`*^9, 3.825180379885054*^9, 3.8251805126892414`*^9, 
  3.82518056851932*^9},
 CellLabel->
  "Out[59]//MatrixForm=",ExpressionUUID->"eea8a4fd-7835-43e0-8a43-\
a16b9d0b06f4"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SI6T1", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"3", ";;", "5"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", "6", ",", "9", ",", "12", ",", "15"}], "}"}]}], 
     "]"}], "]"}], "=", 
   RowBox[{"osD16low", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"37", ",", "87", ",", "137"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"40", ",", "39", ",", "29", ",", "33", ",", "34"}], "}"}]}], 
     "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SI6T1", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"3", ";;", "5"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "7", ",", "10", ",", "13", ",", "16"}], "}"}]}], 
     "]"}], "]"}], "=", 
   RowBox[{"osD16medium", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"37", ",", "87", ",", "137"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"40", ",", "39", ",", "29", ",", "33", ",", "34"}], "}"}]}], 
     "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SI6T1", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"3", ";;", "5"}], ",", 
      RowBox[{"{", 
       RowBox[{"5", ",", "8", ",", "11", ",", "14", ",", "17"}], "}"}]}], 
     "]"}], "]"}], "=", 
   RowBox[{"osD16high", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"37", ",", "87", ",", "137"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"40", ",", "39", ",", "29", ",", "33", ",", "34"}], "}"}]}], 
     "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SI6T1", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"6", ";;", "8"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", "6", ",", "9", ",", "12", ",", "15"}], "}"}]}], 
     "]"}], "]"}], "=", 
   RowBox[{"osD13low", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"37", ",", "87", ",", "137"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"40", ",", "39", ",", "29", ",", "33", ",", "34"}], "}"}]}], 
     "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SI6T1", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"6", ";;", "8"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "7", ",", "10", ",", "13", ",", "16"}], "}"}]}], 
     "]"}], "]"}], "=", 
   RowBox[{"osD13medium", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"37", ",", "87", ",", "137"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"40", ",", "39", ",", "29", ",", "33", ",", "34"}], "}"}]}], 
     "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SI6T1", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"6", ";;", "8"}], ",", 
      RowBox[{"{", 
       RowBox[{"5", ",", "8", ",", "11", ",", "14", ",", "17"}], "}"}]}], 
     "]"}], "]"}], "=", 
   RowBox[{"osD13high", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"37", ",", "87", ",", "137"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"40", ",", "39", ",", "29", ",", "33", ",", "34"}], "}"}]}], 
     "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SI6T1", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"9", ";;", "11"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", "6", ",", "9", ",", "12", ",", "15"}], "}"}]}], 
     "]"}], "]"}], "=", 
   RowBox[{"osD07low", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"37", ",", "87", ",", "137"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"40", ",", "39", ",", "29", ",", "33", ",", "34"}], "}"}]}], 
     "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SI6T1", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"9", ";;", "11"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "7", ",", "10", ",", "13", ",", "16"}], "}"}]}], 
     "]"}], "]"}], "=", 
   RowBox[{"osD07medium", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"37", ",", "87", ",", "137"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"40", ",", "39", ",", "29", ",", "33", ",", "34"}], "}"}]}], 
     "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SI6T1", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"9", ";;", "11"}], ",", 
      RowBox[{"{", 
       RowBox[{"5", ",", "8", ",", "11", ",", "14", ",", "17"}], "}"}]}], 
     "]"}], "]"}], "=", 
   RowBox[{"osD07high", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"37", ",", "87", ",", "137"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"40", ",", "39", ",", "29", ",", "33", ",", "34"}], "}"}]}], 
     "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SI6T1", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"12", ";;", "14"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", "6", ",", "9", ",", "12", ",", "15"}], "}"}]}], 
     "]"}], "]"}], "=", 
   RowBox[{"osFGlow", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"37", ",", "87", ",", "137"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"40", ",", "39", ",", "29", ",", "33", ",", "34"}], "}"}]}], 
     "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SI6T1", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"12", ";;", "14"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "7", ",", "10", ",", "13", ",", "16"}], "}"}]}], 
     "]"}], "]"}], "=", 
   RowBox[{"osFGmedium", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"37", ",", "87", ",", "137"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"40", ",", "39", ",", "29", ",", "33", ",", "34"}], "}"}]}], 
     "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SI6T1", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"12", ";;", "14"}], ",", 
      RowBox[{"{", 
       RowBox[{"5", ",", "8", ",", "11", ",", "14", ",", "17"}], "}"}]}], 
     "]"}], "]"}], "=", 
   RowBox[{"osFGhigh", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"37", ",", "87", ",", "137"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"40", ",", "39", ",", "29", ",", "33", ",", "34"}], "}"}]}], 
     "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SI6T1", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"3", ",", "6", ",", "9", ",", "12"}], "}"}], ",", 
      RowBox[{"6", ";;", "8"}]}], "]"}], "]"}], "=", "\"\<-\>\""}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.824664269319462*^9, 3.82466427877218*^9}, {
  3.824664324183864*^9, 3.8246643934498835`*^9}, {3.82466442881787*^9, 
  3.824664534838464*^9}, {3.8246645733020535`*^9, 3.824664604350786*^9}, {
  3.8246646428039236`*^9, 3.824664685544166*^9}, {3.825180388476066*^9, 
  3.8251805079482346`*^9}, {3.8251805474142904`*^9, 3.82518056125731*^9}},
 CellLabel->"In[46]:=",ExpressionUUID->"762ac6a9-8819-4aa6-a97d-cf22a740567f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<SI6T1.csv\>\"", ",", "SI6T1"}], "]"}]], "Input",
 CellChangeTimes->{{3.825181155903152*^9, 3.825181176247181*^9}},
 CellLabel->"In[97]:=",ExpressionUUID->"65bad775-8e90-4834-89b6-0d2cbfaaf553"],

Cell[BoxData["\<\"SI6T1.csv\"\>"], "Output",
 CellChangeTimes->{3.825181176827213*^9},
 CellLabel->"Out[97]=",ExpressionUUID->"10e05ee8-57e6-4062-98d8-efd199ea3405"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SI6T2", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"\"\<-\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "14"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "14"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SI6T2", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", ";;"}], "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
    "\"\<\>\"", ",", "\"\<\>\"", ",", "\"\<\>\"", ",", "\"\<SCC2030\>\"", 
     ",", "\"\<\>\"", ",", "\"\<\>\"", ",", "\"\<\>\"", ",", 
     "\"\<SCC2050\>\"", ",", "\"\<\>\"", ",", "\"\<\>\"", ",", "\"\<\>\"", 
     ",", "\"\<SCC2100\>\"", ",", "\"\<\>\"", ",", "\"\<\>\""}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SI6T2", "[", 
    RowBox[{"[", 
     RowBox[{"2", ",", ";;"}], "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
    "\"\<\>\"", ",", "\"\<\>\"", ",", "\"\<low\>\"", ",", "\"\<medium\>\"", 
     ",", "\"\<high\>\"", ",", "\"\<average\>\"", ",", "\"\<low\>\"", ",", 
     "\"\<medium\>\"", ",", "\"\<high\>\"", ",", "\"\<average\>\"", ",", 
     "\"\<low\>\"", ",", "\"\<medium\>\"", ",", "\"\<high\>\"", ",", 
     "\"\<average\>\""}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"SI6T2", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"3", ";;"}], ",", "1"}], "]"}], "]"}], "=", 
    RowBox[{"{", 
     RowBox[{
     "\"\<D16\>\"", ",", "\"\<\>\"", ",", "\"\<\>\"", ",", "\"\<D13\>\"", 
      ",", "\"\<\>\"", ",", "\"\<\>\"", ",", "\"\<D07\>\"", ",", "\"\<\>\"", 
      ",", "\"\<\>\"", ",", "\"\<FG\>\"", ",", "\"\<\>\"", ",", "\"\<\>\""}], 
     "}"}]}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"SI6T1", "[", 
      RowBox[{"[", 
       RowBox[{
        RowBox[{"3", ";;"}], ",", "2"}], "]"}], "]"}], "=", 
     RowBox[{"{", 
      RowBox[{
      "\"\<low\>\"", ",", "\"\<med\>\"", ",", "\"\<high\>\"", ",", 
       "\"\<low\>\"", ",", "\"\<med\>\"", ",", "\"\<high\>\""}], "}"}]}], 
    ";"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SI6T2", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"3", ";;"}], ",", "2"}], "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
    "\"\<2050\>\"", ",", "\"\<2100\>\"", ",", "\"\<2150\>\"", ",", 
     "\"\<2050\>\"", ",", "\"\<2100\>\"", ",", "\"\<2150\>\"", ",", 
     "\"\<2050\>\"", ",", "\"\<2100\>\"", ",", "\"\<2150\>\"", ",", 
     "\"\<2050\>\"", ",", "\"\<2100\>\"", ",", "\"\<2150\>\""}], "}"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.824665001158885*^9, 3.824665150517965*^9}, {
  3.8246652097835817`*^9, 3.8246652122240105`*^9}, {3.8246653211297216`*^9, 
  3.8246653400156517`*^9}, {3.825180820127678*^9, 3.8251808440827117`*^9}, {
  3.825180955279868*^9, 3.825180955949869*^9}},
 CellLabel->"In[75]:=",ExpressionUUID->"94273f25-bb4b-4905-99ad-d298f29ed97f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SI6T2", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"3", ";;", "5"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", "7", ",", "11"}], "}"}]}], "]"}], "]"}], "=", 
   RowBox[{"osD16low", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"37", ",", "87", ",", "137"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"44", ",", "45", ",", "46"}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SI6T2", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"3", ";;", "5"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "8", ",", "12"}], "}"}]}], "]"}], "]"}], "=", 
   RowBox[{"osD16medium", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"37", ",", "87", ",", "137"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"44", ",", "45", ",", "46"}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SI6T2", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"3", ";;", "5"}], ",", 
      RowBox[{"{", 
       RowBox[{"5", ",", "9", ",", "13"}], "}"}]}], "]"}], "]"}], "=", 
   RowBox[{"osD16high", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"37", ",", "87", ",", "137"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"44", ",", "45", ",", "46"}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SI6T2", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"6", ";;", "8"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", "7", ",", "11"}], "}"}]}], "]"}], "]"}], "=", 
   RowBox[{"osD13low", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"37", ",", "87", ",", "137"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"44", ",", "45", ",", "46"}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SI6T2", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"6", ";;", "8"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "8", ",", "12"}], "}"}]}], "]"}], "]"}], "=", 
   RowBox[{"osD13medium", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"37", ",", "87", ",", "137"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"44", ",", "45", ",", "46"}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SI6T2", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"6", ";;", "8"}], ",", 
      RowBox[{"{", 
       RowBox[{"5", ",", "9", ",", "13"}], "}"}]}], "]"}], "]"}], "=", 
   RowBox[{"osD13high", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"37", ",", "87", ",", "137"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"44", ",", "45", ",", "46"}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SI6T2", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"9", ";;", "11"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", "7", ",", "11"}], "}"}]}], "]"}], "]"}], "=", 
   RowBox[{"osD07low", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"37", ",", "87", ",", "137"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"44", ",", "45", ",", "46"}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SI6T2", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"9", ";;", "11"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "8", ",", "12"}], "}"}]}], "]"}], "]"}], "=", 
   RowBox[{"osD07medium", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"37", ",", "87", ",", "137"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"44", ",", "45", ",", "46"}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SI6T2", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"9", ";;", "11"}], ",", 
      RowBox[{"{", 
       RowBox[{"5", ",", "9", ",", "13"}], "}"}]}], "]"}], "]"}], "=", 
   RowBox[{"osD07high", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"37", ",", "87", ",", "137"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"44", ",", "45", ",", "46"}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SI6T2", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"12", ";;", "14"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", "7", ",", "11"}], "}"}]}], "]"}], "]"}], "=", 
   RowBox[{"osFGlow", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"37", ",", "87", ",", "137"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"44", ",", "45", ",", "46"}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SI6T2", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"12", ";;", "14"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "8", ",", "12"}], "}"}]}], "]"}], "]"}], "=", 
   RowBox[{"osFGmedium", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"37", ",", "87", ",", "137"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"44", ",", "45", ",", "46"}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SI6T2", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"12", ";;", "14"}], ",", 
      RowBox[{"{", 
       RowBox[{"5", ",", "9", ",", "13"}], "}"}]}], "]"}], "]"}], "=", 
   RowBox[{"osFGhigh", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"37", ",", "87", ",", "137"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"44", ",", "45", ",", "46"}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"SI6T2", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"i", "+", "3"}], ",", "6"}], "]"}], "]"}], "=", 
    RowBox[{"Mean", "[", 
     RowBox[{"SI6T2", "[", 
      RowBox[{"[", 
       RowBox[{
        RowBox[{"i", "+", "3"}], ",", 
        RowBox[{"3", ";;", "5"}]}], "]"}], "]"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "0", ",", "11"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"SI6T2", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"i", "+", "3"}], ",", "10"}], "]"}], "]"}], "=", 
    RowBox[{"Mean", "[", 
     RowBox[{"SI6T2", "[", 
      RowBox[{"[", 
       RowBox[{
        RowBox[{"i", "+", "3"}], ",", 
        RowBox[{"7", ";;", "9"}]}], "]"}], "]"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "0", ",", "11"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"SI6T2", "[", 
      RowBox[{"[", 
       RowBox[{
        RowBox[{"i", "+", "3"}], ",", "14"}], "]"}], "]"}], "=", 
     RowBox[{"Mean", "[", 
      RowBox[{"SI6T2", "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{"i", "+", "3"}], ",", 
         RowBox[{"11", ";;", "13"}]}], "]"}], "]"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "0", ",", "11"}], "}"}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.824665370841205*^9, 3.824665557547775*^9}, {
  3.8246656171761274`*^9, 3.8246658896550627`*^9}, {3.825180849533719*^9, 
  3.8251809959859257`*^9}, {3.825181033239978*^9, 3.8251810497420015`*^9}},
 CellLabel->"In[80]:=",ExpressionUUID->"e43aa7a5-9ed0-4e06-bb28-6b8c6bc8ebbf"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SI6T2", "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.824665155551978*^9, 3.82466516549959*^9}},
 CellLabel->"In[95]:=",ExpressionUUID->"b36de00e-4393-4ebf-951c-6f1cfdbe410a"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"SCC2030\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"SCC2050\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"SCC2100\"\>", "\<\"\"\>", "\<\"\"\>"},
     {"\<\"\"\>", "\<\"\"\>", "\<\"low\"\>", "\<\"medium\"\>", \
"\<\"high\"\>", "\<\"average\"\>", "\<\"low\"\>", "\<\"medium\"\>", "\<\"high\
\"\>", "\<\"average\"\>", "\<\"low\"\>", "\<\"medium\"\>", "\<\"high\"\>", \
"\<\"average\"\>"},
     {"\<\"D16\"\>", "\<\"2050\"\>", "242.705702`", "298.905272`", 
      "330.901479`", "290.83748433333335`", "341.707819`", "420.159213`", 
      "460.675376`", "407.514136`", "255.600731`", "291.493707`", 
      "308.754645`", "285.28302766666667`"},
     {"\<\"\"\>", "\<\"2100\"\>", "105.142273`", "143.974739`", "173.33442`", 
      "140.81714399999998`", "241.390926`", "326.853654`", "390.865191`", 
      "319.703257`", "109.70846`", "136.325439`", "153.665426`", 
      "133.23310833333332`"},
     {"\<\"\"\>", "\<\"2150\"\>", "29.309668`", "43.943665`", "55.96493`", 
      "43.072754333333336`", "72.733476`", "108.62926`", "137.895489`", 
      "106.41940833333332`", "357.63594`", "357.63594`", "357.63594`", 
      "357.63594`"},
     {"\<\"D13\"\>", "\<\"2050\"\>", "175.311439`", "209.156985`", 
      "227.681545`", "204.04998966666668`", "294.421797`", "353.445085`", 
      "384.922276`", "344.2630526666667`", "236.424269`", "268.148769`", 
      "283.305846`", "262.62629466666664`"},
     {"\<\"\"\>", "\<\"2100\"\>", "64.238468`", "84.059624`", "97.878192`", 
      "82.05876133333334`", "169.006944`", "219.634927`", "254.550099`", 
      "214.39732333333336`", "103.463744`", "125.343151`", "138.943784`", 
      "122.58355966666666`"},
     {"\<\"\"\>", "\<\"2150\"\>", "13.490519`", "19.721674`", "24.690771`", 
      "19.300988`", "36.404131`", "53.264557`", "66.692493`", 
      "52.120393666666665`", "338.216761`", "357.63594`", "357.63594`", 
      "351.1628803333333`"},
     {"\<\"D07\"\>", "\<\"2050\"\>", "153.090453`", "180.064405`", 
      "194.654038`", "175.93629866666666`", "275.158598`", "328.287294`", 
      "356.254182`", "319.90002466666664`", "233.942286`", "265.134583`", 
      "280.024012`", "259.7002936666667`"},
     {"\<\"\"\>", "\<\"2100\"\>", "50.833406`", "65.819528`", "76.097914`", 
      "64.25028266666668`", "139.85229`", "180.269536`", "207.766987`", 
      "175.96293766666668`", "111.778425`", "134.21613`", "147.579605`", 
      "131.19138666666666`"},
     {"\<\"\"\>", "\<\"2150\"\>", "10.698243`", "15.476858`", "19.260976`", 
      "15.145359`", "29.063714`", "42.062615`", "52.346924`", "41.157751`", 
      "284.698422`", "357.63594`", "357.63594`", "333.323434`"},
     {"\<\"FG\"\>", "\<\"2050\"\>", "112.767765`", "129.841991`", 
      "138.953469`", "127.18774166666667`", "260.299096`", "311.41557