(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    342323,       7053]
NotebookOptionsPosition[    331714,       6876]
NotebookOutlinePosition[    332243,       6894]
CellTagsIndexPosition[    332200,       6891]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
   "SetDirectory", "[", 
    "\"\<C:\\\\Users\\\\wilmsen\\\\Dropbox\\\\Historic_DICE_Dropbox\\\\Data\\\
\\SI_SpinUp\>\"", "]"}], ";"}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.818438376389078*^9, 3.8184383796690826`*^9}, 
   3.8313892410244665`*^9, {3.841027660831501*^9, 3.8410276629625044`*^9}},
 CellLabel->"In[2]:=",ExpressionUUID->"012e4ec2-5954-4e72-8e0c-cd62752b98ad"],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "SetDirectory", "[", 
   "\"\<C:\\\\Users\\\\Rickels\\\\Dropbox\\\\Historic_DICE_Dropbox\\\\Data_\
1960_2019\\\\SI_SpinUp\>\"", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.8241808193512616`*^9, 3.824180820761224*^9}, {
  3.831173359438088*^9, 3.8311733741053286`*^9}, {3.8311842771845646`*^9, 
  3.8311842840717587`*^9}},
 CellLabel->
  "In[862]:=",ExpressionUUID->"71510dd2-2def-4f9f-b96e-bdf21b72f1d2"],

Cell["Fair Carbon Cycle Setup", "Text",
 CellChangeTimes->{{3.71113575119866*^9, 3.7111357648642597`*^9}, {
  3.711171131470954*^9, 3.711171132484956*^9}, {3.712408724609439*^9, 
  3.7124087395614595`*^9}, {3.7662479249546547`*^9, 3.7662479290036545`*^9}, {
  3.810276061054193*^9, 3.810276074321699*^9}},
 FontSize->18,
 Background->RGBColor[
  0.87, 0.94, 1],ExpressionUUID->"f703d587-e791-4118-b11d-f6f4e4ac5987"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"parFair", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"q1", "\[Rule]", "0.33"}], ",", 
     RowBox[{"q2", "\[Rule]", "0.41"}], ",", 
     RowBox[{"d1", "\[Rule]", "239"}], ",", 
     RowBox[{"d2", "\[Rule]", "4.1"}], ",", 
     RowBox[{"r0", "\[Rule]", "35"}], 
     RowBox[{"(*", "32.4", "*)"}], ",", 
     RowBox[{"rc", "\[Rule]", "0.019"}], ",", 
     RowBox[{"rT", "\[Rule]", "4.165"}], ",", 
     RowBox[{"F2x", "\[Rule]", "3.71"}], ",", 
     RowBox[{"\[Tau]1", "\[Rule]", 
      RowBox[{"10", "^", "6"}]}], ",", 
     RowBox[{"\[Tau]2", "\[Rule]", "394.4"}], ",", 
     RowBox[{"\[Tau]3", "\[Rule]", "36.54"}], ",", 
     RowBox[{"\[Tau]4", "\[Rule]", "4.304"}]}], " ", "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"aFair", "=", 
   RowBox[{"{", 
    RowBox[{"0.2173", ",", "0.2240", ",", "0.2824", ",", "0.2763"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Tau]Fair", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"10", "^", "6"}], ",", "394.4", ",", "36.54", ",", "4.304"}], 
    "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"rirf", "[", 
    RowBox[{"Cacc_", ",", "T_"}], "]"}], "=", 
   RowBox[{
    RowBox[{"r0", "+", 
     RowBox[{"rc", "*", "Cacc"}], "+", 
     RowBox[{"rT", "*", "T"}]}], "/.", "parFair"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fn", "[", 
    RowBox[{"\[Alpha]_", ",", "ai_", ",", "\[Tau]i_"}], "]"}], "=", 
   RowBox[{"\[Alpha]", "*", "ai", "*", "\[Tau]i", "*", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"Exp", "[", 
       RowBox[{
        RowBox[{"-", "100"}], "/", 
        RowBox[{"(", 
         RowBox[{"\[Alpha]", "*", "\[Tau]i"}], ")"}]}], "]"}]}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"lirf", "[", "\[Alpha]_", "]"}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"fn", "[", 
       RowBox[{"\[Alpha]", ",", 
        RowBox[{"aFair", "[", 
         RowBox[{"[", "1", "]"}], "]"}], ",", "\[Tau]1"}], "]"}], "+", 
      RowBox[{"fn", "[", 
       RowBox[{"\[Alpha]", ",", 
        RowBox[{"aFair", "[", 
         RowBox[{"[", "2", "]"}], "]"}], ",", "\[Tau]2"}], "]"}], "+", 
      RowBox[{"fn", "[", 
       RowBox[{"\[Alpha]", ",", 
        RowBox[{"aFair", "[", 
         RowBox[{"[", "3", "]"}], "]"}], ",", "\[Tau]3"}], "]"}], "+", 
      RowBox[{"fn", "[", 
       RowBox[{"\[Alpha]", ",", 
        RowBox[{"aFair", "[", 
         RowBox[{"[", "4", "]"}], "]"}], ",", "\[Tau]4"}], "]"}]}], "/.", 
     "parFair"}], "//", "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dalpha", "[", "\[Alpha]_", "]"}], "=", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"lirf", "[", "\[Alpha]", "]"}], ",", "\[Alpha]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dr", "[", 
    RowBox[{"ai_", ",", "\[Tau]i_", ",", "\[Alpha]_", ",", "e_", ",", "R_"}], 
    "]"}], "=", 
   RowBox[{
    RowBox[{"ai", "*", "e"}], "-", 
    RowBox[{"R", "/", 
     RowBox[{"(", 
      RowBox[{"\[Alpha]", "*", "\[Tau]i"}], ")"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"parPG", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Lambda]g", "->", "1.18"}], ",", 
     RowBox[{"upperc", "->", "8.2"}], ",", 
     RowBox[{"lowerc", "->", "109.0"}], ",", 
     RowBox[{"\[Beta]", "->", "0.67"}], ",", 
     RowBox[{"eff", "->", "1.28"}], ",", 
     RowBox[{"dt", "->", "1"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"cdeepp", "=", 
   RowBox[{
    RowBox[{"lowerc", "*", "eff"}], "/.", "parPG"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gammap", "=", 
   RowBox[{
    RowBox[{"\[Beta]", "*", "eff"}], "/.", "parPG"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g1", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"\[Lambda]g", "+", "gammap"}], ")"}], "/", "upperc"}], "/.", 
    "parPG"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g2", "=", 
   RowBox[{"gammap", "/", "cdeepp"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"g1", "+", "g2"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"gstar", "=", 
   RowBox[{"g1", "-", "g2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"delsqrt", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"g", "*", "g"}], "-", 
       RowBox[{"4", "*", "g2", "*", 
        RowBox[{"\[Lambda]g", "/", "upperc"}]}]}], ")"}], "^", "0.5"}], "/.", 
    "parPG"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"afast", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"g", "+", "delsqrt"}], ")"}], "/", "2"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"aslow", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"g", "-", "delsqrt"}], ")"}], "/", "2"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"cc", "=", 
   RowBox[{
    RowBox[{"0.5", "/", 
     RowBox[{"(", 
      RowBox[{"upperc", "*", "delsqrt"}], ")"}]}], "/.", "parPG"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"amixf", "=", 
   RowBox[{"cc", "*", 
    RowBox[{"(", 
     RowBox[{"gstar", "+", "delsqrt"}], ")"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"amixs", "=", 
   RowBox[{
    RowBox[{"-", "cc"}], "*", 
    RowBox[{"(", 
     RowBox[{"gstar", "-", "delsqrt"}], ")"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"adeepf", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "gammap"}], "/", 
     RowBox[{"(", 
      RowBox[{"upperc", "*", "cdeepp", "*", "delsqrt"}], ")"}]}], "/.", 
    "parPG"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"adeeps", "=", 
   RowBox[{"-", "adeepf"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"adf", "=", 
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"afast", "*", "1"}], ")"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"ads", "=", 
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"aslow", "*", "1"}], ")"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"expf", "=", 
   RowBox[{"Exp", "[", 
    RowBox[{
     RowBox[{"-", "1"}], "/", "adf"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"exps", "=", 
   RowBox[{"Exp", "[", 
    RowBox[{
     RowBox[{"-", "1"}], "/", "ads"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"intf", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"f0", "*", "adf"}], "+", 
      RowBox[{"f1", "*", 
       RowBox[{"(", 
        RowBox[{"1", "-", "adf"}], ")"}]}], "-", 
      RowBox[{"expf", "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"f0", "*", 
          RowBox[{"(", 
           RowBox[{"1", "+", "adf"}], ")"}]}], "-", 
         RowBox[{"f1", "*", "adf"}]}], ")"}]}]}], ")"}], "/", "afast"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"ints", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"f0", "*", "ads"}], "+", 
      RowBox[{"f1", "*", 
       RowBox[{"(", 
        RowBox[{"1", "-", "ads"}], ")"}]}], "-", 
      RowBox[{"exps", "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"f0", "*", 
          RowBox[{"(", 
           RowBox[{"1", "+", "ads"}], ")"}]}], "-", 
         RowBox[{"f1", "*", "ads"}]}], ")"}]}]}], ")"}], "/", "aslow"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.810277248743802*^9, 3.8102773313886356`*^9}, {
  3.810277381764123*^9, 3.810277400477229*^9}, {3.810277857843212*^9, 
  3.810277859394146*^9}, {3.813333362695059*^9, 3.8133334744113755`*^9}, {
  3.813549386661647*^9, 3.813549387362056*^9}},
 CellLabel->"In[3]:=",ExpressionUUID->"e2867d17-67ce-400c-8e50-5ca3eff26e6c"],

Cell["Fair Carbon Cycle Spin-up", "Text",
 CellChangeTimes->{{3.71113575119866*^9, 3.7111357648642597`*^9}, {
  3.711171131470954*^9, 3.711171132484956*^9}, {3.712408724609439*^9, 
  3.7124087395614595`*^9}, {3.7662479249546547`*^9, 3.7662479290036545`*^9}, {
  3.810276061054193*^9, 3.810276074321699*^9}, {3.8227995602020345`*^9, 
  3.8227995659345427`*^9}},
 FontSize->18,
 Background->RGBColor[
  0.87, 0.94, 1],ExpressionUUID->"e3ce86a0-f9e3-4e92-9220-6d4ace1602d8"],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Import", "[", "\"\<hist_emissions_GCB_full.csv\>\"", "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.831184072986274*^9, 3.831184097552437*^9}, {
   3.8311842327609935`*^9, 3.8311842352948065`*^9}, {3.8316610941384273`*^9, 
   3.831661094598428*^9}, {3.833461259229766*^9, 3.8334612596995316`*^9}, {
   3.8384434984452615`*^9, 3.8384435049260263`*^9}, {3.8384438796288476`*^9, 
   3.838443880346557*^9}, {3.8384441028172073`*^9, 3.8384441035015*^9}, {
   3.838444400922853*^9, 3.838444403104461*^9}, 3.8384447480922966`*^9, {
   3.838460179789896*^9, 3.8384601934343634`*^9}, {3.8384602867376223`*^9, 
   3.8384602877859035`*^9}, {3.838460400506288*^9, 3.838460402543787*^9}, {
   3.838460433768389*^9, 3.838460434788916*^9}, {3.8384681317318134`*^9, 
   3.8384681343911057`*^9}, {3.8384692415617037`*^9, 3.8384692422416315`*^9}, 
   3.8384867461534786`*^9, {3.8384915027060328`*^9, 3.8384915102593927`*^9}},
 CellLabel->"In[36]:=",ExpressionUUID->"9e535e12-e998-42b7-a958-92111de62308"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dimensions", "[", "data", "]"}]], "Input",
 CellChangeTimes->{{3.8410277364259033`*^9, 3.8410277429940047`*^9}},
 CellLabel->"In[37]:=",ExpressionUUID->"2a238be7-3573-4785-a9dd-8b60aea040d4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"257", ",", "15"}], "}"}]], "Output",
 CellChangeTimes->{3.841027744066521*^9, 3.841027844668812*^9},
 CellLabel->"Out[37]=",ExpressionUUID->"b4dc16c5-01f1-4f8e-8272-9d221d2b1f74"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"y", "=", "256"}], ",", "\[IndentingNewLine]", 
      RowBox[{"transFairG", "=", 
       RowBox[{"Table", "[", 
        RowBox[{"0", ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "y"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"j", ",", "20"}], "}"}]}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transFairG", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "=", 
       RowBox[{"{", 
        RowBox[{
        "\"\<1-Y\>\"", ",", "\"\<2-E\>\"", ",", "\"\<3-R1\>\"", ",", 
         "\"\<4-R2\>\"", ",", "\"\<5-R3\>\"", ",", "\"\<6-R4\>\"", ",", 
         "\"\<7-C\>\"", ",", "\"\<8-CCA\>\"", ",", "\"\<9-F\>\"", ",", 
         "\"\<10-Fex\>\"", ",", "\"\<11-TF\>\"", ",", "\"\<12-TMF\>\"", ",", 
         "\"\<13-TMS\>\"", ",", "\"\<14-TDF\>\"", ",", "\"\<15-TDS\>\"", ",", 
         "\"\<16-TM\>\"", ",", "\"\<17-TD\>\"", ",", "\"\<18-\[Alpha]\>\"", 
         ",", "\"\<19-\[Alpha]check\>\"", ",", "\"\<20-atmosGt\>\""}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"transFairG", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"n", "+", "1"}], ",", "1"}], "]"}], "]"}], "=", 
         RowBox[{"1765", "-", "1", "+", "n"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"n", ",", "1", ",", 
          RowBox[{"y", "-", "1"}]}], "}"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"emcolumns", "=", 
       RowBox[{"{", "5", "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{
         RowBox[{"transFairG", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;"}], ",", "2"}], "]"}], "]"}], "=", 
         RowBox[{
          RowBox[{"dtemp", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"2", ";;"}], ",", "3"}], "]"}], "]"}], "/", "2.12"}]}], 
        ","}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transFairG", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;", "y"}], ",", "2"}], "]"}], "]"}], "=", 
       RowBox[{
        RowBox[{"data", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"3", ";;"}], ",", 
           RowBox[{"emcolumns", "[", 
            RowBox[{"[", "k", "]"}], "]"}]}], "]"}], "]"}], "/", 
        "2.1293970467500096"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transFairG", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", 
          RowBox[{"{", 
           RowBox[{"3", ",", "4", ",", "5", ",", "6"}], "}"}]}], "]"}], "]"}],
        "=", "0"}], ",", " ", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{
        "initial", " ", "carbon", " ", "values", " ", "for", " ", "R1"}], ",",
         "R2", ",", "R3", ",", "R4"}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transFairG", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "7"}], "]"}], "]"}], "=", 
       RowBox[{
        RowBox[{"Total", "[", 
         RowBox[{"transFairG", "[", 
          RowBox[{"[", 
           RowBox[{"2", ",", 
            RowBox[{"3", ";;", "6"}]}], "]"}], "]"}], "]"}], "+", "278"}]}], 
      ",", " ", 
      RowBox[{"(*", 
       RowBox[{"276.60278", ",", " ", ".0014091894", ","}], "*)"}], " ", 
      RowBox[{"(*", 
       RowBox[{
       "initial", " ", "atmospheric", " ", "carbon", " ", "concentration"}], 
       "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transFairG", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "8"}], "]"}], "]"}], "=", "0"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transFairG", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "9"}], "]"}], "]"}], "=", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"F2x", "/", 
           RowBox[{"Log", "[", "2", "]"}]}], ")"}], "*", 
         RowBox[{"Log", "[", 
          RowBox[{
           RowBox[{"transFairG", "[", 
            RowBox[{"[", 
             RowBox[{"2", ",", "7"}], "]"}], "]"}], "/", "278"}], "]"}]}], "/.",
         "parFair"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"fexcolumns", "=", 
       RowBox[{"{", "6", "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transFairG", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", "10"}], "]"}], "]"}], "=", 
       RowBox[{"data", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"3", ";;"}], ",", 
          RowBox[{"fexcolumns", "[", 
           RowBox[{"[", "k", "]"}], "]"}]}], "]"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transFairG", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", "11"}], "]"}], "]"}], "=", 
       RowBox[{"Total", "[", 
        RowBox[{"transFairG", "[", 
         RowBox[{"[", 
          RowBox[{"2", ",", 
           RowBox[{"9", ";;", "10"}]}], "]"}], "]"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transFairG", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", 
          RowBox[{"{", 
           RowBox[{"12", ",", "13", ",", "14", ",", "15"}], "}"}]}], "]"}], 
        "]"}], "=", "0"}], ",", " ", 
      RowBox[{"(*", 
       RowBox[{
       "initial", " ", "values", " ", "for", " ", "Mix", " ", "Layer", " ", 
        "Fast", " ", "and", " ", "Slow", " ", "Response", " ", "and", " ", 
        "Deep", " ", "Layer", " ", "Fast", " ", "and", " ", "Slow", " ", 
        "Response"}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transFairG", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "16"}], "]"}], "]"}], "=", 
       RowBox[{"Total", "[", 
        RowBox[{"transFairG", "[", 
         RowBox[{"[", 
          RowBox[{"2", ",", 
           RowBox[{"12", ";;", "13"}]}], "]"}], "]"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transFairG", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "17"}], "]"}], "]"}], "=", 
       RowBox[{"Total", "[", 
        RowBox[{"transFairG", "[", 
         RowBox[{"[", 
          RowBox[{"2", ",", 
           RowBox[{"14", ";;", "15"}]}], "]"}], "]"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transFairG", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", "18"}], "]"}], "]"}], "=", 
       RowBox[{
        RowBox[{"FindRoot", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"rirf", "[", 
            RowBox[{
             RowBox[{"transFairG", "[", 
              RowBox[{"[", 
               RowBox[{"2", ",", "8"}], "]"}], "]"}], ",", 
             RowBox[{"transFairG", "[", 
              RowBox[{"[", 
               RowBox[{"2", ",", "16"}], "]"}], "]"}]}], "]"}], "\[Equal]", 
           RowBox[{"lirf", "[", "\[Alpha]", "]"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"\[Alpha]", ",", "0.2"}], "}"}]}], "]"}], "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", "2"}], "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transFairG", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "19"}], "]"}], "]"}], "=", 
       RowBox[{"transFairG", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "18"}], "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"transFairG", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", 
              RowBox[{"3", ";;", "6"}]}], "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{"transFairG", "[", 
             RowBox[{"[", 
              RowBox[{
               RowBox[{"i", "-", "1"}], ",", 
               RowBox[{"3", ";;", "6"}]}], "]"}], "]"}], "+", 
            RowBox[{"dr", "[", 
             RowBox[{"aFair", ",", "\[Tau]Fair", ",", 
              RowBox[{"transFairG", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "-", "1"}], ",", "18"}], "]"}], "]"}], ",", 
              RowBox[{"transFairG", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "-", "1"}], ",", "2"}], "]"}], "]"}], ",", 
              RowBox[{"transFairG", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "-", "1"}], ",", 
                 RowBox[{"3", ";;", "6"}]}], "]"}], "]"}]}], "]"}]}]}], ",", 
          RowBox[{
           RowBox[{"transFairG", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "7"}], "]"}], "]"}], "=", 
           RowBox[{"278", "+", 
            RowBox[{"Total", "[", 
             RowBox[{"transFairG", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", 
                RowBox[{"3", ";;", "6"}]}], "]"}], "]"}], "]"}]}]}], ",", 
          RowBox[{
           RowBox[{"transFairG", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "8"}], "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{"transFairG", "[", 
             RowBox[{"[", 
              RowBox[{
               RowBox[{"i", "-", "1"}], ",", "8"}], "]"}], "]"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"transFairG", "[", 
                RowBox[{"[", 
                 RowBox[{
                  RowBox[{"i", "-", "1"}], ",", "2"}], "]"}], "]"}], "-", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"transFairG", "[", 
                  RowBox[{"[", 
                   RowBox[{"i", ",", "7"}], "]"}], "]"}], "-", 
                 RowBox[{"transFairG", "[", 
                  RowBox[{"[", 
                   RowBox[{
                    RowBox[{"i", "-", "1"}], ",", "7"}], "]"}], "]"}]}], 
                ")"}]}], ")"}], "*", "2.12"}]}]}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"transFairG", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "9"}], "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"F2x", "/", 
               RowBox[{"Log", "[", "2", "]"}]}], ")"}], "*", 
             RowBox[{"Log", "[", 
              RowBox[{
               RowBox[{"transFairG", "[", 
                RowBox[{"[", 
                 RowBox[{"i", ",", "7"}], "]"}], "]"}], "/", "278"}], "]"}]}],
             "/.", "parFair"}]}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"transFairG", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "11"}], "]"}], "]"}], "=", 
           RowBox[{"Total", "[", 
            RowBox[{"transFairG", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", 
               RowBox[{"9", ";;", "10"}]}], "]"}], "]"}], "]"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"transFairG", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "12"}], "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"expf", "*", 
               RowBox[{"transFairG", "[", 
                RowBox[{"[", 
                 RowBox[{
                  RowBox[{"i", "-", "1"}], ",", "12"}], "]"}], "]"}]}], "+", 
              RowBox[{"amixf", "*", "intf"}]}], "/.", 
             RowBox[{"f0", "\[Rule]", 
              RowBox[{"transFairG", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "-", "1"}], ",", "11"}], "]"}], "]"}]}]}], "/.", 
            RowBox[{"f1", "\[Rule]", 
             RowBox[{"transFairG", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "11"}], "]"}], "]"}]}]}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"transFairG", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "13"}], "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"exps", "*", 
               RowBox[{"transFairG", "[", 
                RowBox[{"[", 
                 RowBox[{
                  RowBox[{"i", "-", "1"}], ",", "13"}], "]"}], "]"}]}], "+", 
              RowBox[{"amixs", "*", "ints"}]}], "/.", 
             RowBox[{"f0", "\[Rule]", 
              RowBox[{"transFairG", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "-", "1"}], ",", "11"}], "]"}], "]"}]}]}], "/.", 
            RowBox[{"f1", "\[Rule]", 
             RowBox[{"transFairG", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "11"}], "]"}], "]"}]}]}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"transFairG", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "14"}], "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"expf", "*", 
               RowBox[{"transFairG", "[", 
                RowBox[{"[", 
                 RowBox[{
                  RowBox[{"i", "-", "1"}], ",", "14"}], "]"}], "]"}]}], "+", 
              RowBox[{"adeepf", "*", "intf"}]}], "/.", 
             RowBox[{"f0", "\[Rule]", 
              RowBox[{"transFairG", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "-", "1"}], ",", "11"}], "]"}], "]"}]}]}], "/.", 
            RowBox[{"f1", "\[Rule]", 
             RowBox[{"transFairG", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "11"}], "]"}], "]"}]}]}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"transFairG", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "15"}], "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"exps", "*", 
               RowBox[{"transFairG", "[", 
                RowBox[{"[", 
                 RowBox[{
                  RowBox[{"i", "-", "1"}], ",", "15"}], "]"}], "]"}]}], "+", 
              RowBox[{"adeeps", "*", "ints"}]}], "/.", 
             RowBox[{"f0", "\[Rule]", 
              RowBox[{"transFairG", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "-", "1"}], ",", "11"}], "]"}], "]"}]}]}], "/.", 
            RowBox[{"f1", "\[Rule]", 
             RowBox[{"transFairG", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "11"}], "]"}], "]"}]}]}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"transFairG", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "16"}], "]"}], "]"}], "=", 
           RowBox[{"Total", "[", 
            RowBox[{"transFairG", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", 
               RowBox[{"12", ";;", "13"}]}], "]"}], "]"}], "]"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"transFairG", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "17"}], "]"}], "]"}], "=", 
           RowBox[{"Total", "[", 
            RowBox[{"transFairG", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", 
               RowBox[{"14", ";;", "15"}]}], "]"}], "]"}], "]"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"(*", 
           RowBox[{
            RowBox[{
             RowBox[{"transFairG", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", 
                RowBox[{"{", 
                 RowBox[{"11", ",", "12"}], "}"}]}], "]"}], "]"}], "=", 
             RowBox[{
              RowBox[{
               RowBox[{"transT", ".", 
                RowBox[{"transFairG", "[", 
                 RowBox[{"[", 
                  RowBox[{
                   RowBox[{"i", "-", "1"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"11", ",", "12"}], "}"}]}], "]"}], "]"}]}], "+", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"1", ",", "0"}], "}"}], "*", "xi1", "*", 
                RowBox[{"Total", "[", 
                 RowBox[{"transFairG", "[", 
                  RowBox[{"[", 
                   RowBox[{"i", ",", 
                    RowBox[{"9", ";;", "10"}]}], "]"}], "]"}], "]"}]}]}], "/.",
               "parTG"}]}], ","}], "\[IndentingNewLine]", 
           RowBox[{"(*", 
            RowBox[{
             RowBox[{
              RowBox[{"transFairG", "[", 
               RowBox[{"[", 
                RowBox[{"i", ",", "13"}], "]"}], "]"}], "=", 
              RowBox[{"Total", "[", 
               RowBox[{"transFairG", "[", 
                RowBox[{"[", 
                 RowBox[{"i", ",", 
                  RowBox[{"11", ";;", "12"}]}], "]"}], "]"}], "]"}]}], ","}], 
            "*)"}], "*)"}], "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"transFairG", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "18"}], "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{"FindRoot", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"rirf", "[", 
                RowBox[{
                 RowBox[{"transFairG", "[", 
                  RowBox[{"[", 
                   RowBox[{"i", ",", "8"}], "]"}], "]"}], ",", 
                 RowBox[{"transFairG", "[", 
                  RowBox[{"[", 
                   RowBox[{"i", ",", "16"}], "]"}], "]"}]}], "]"}], 
               "\[Equal]", 
               RowBox[{"lirf", "[", "\[Alpha]", "]"}]}], ",", 
              RowBox[{"{", 
               RowBox[{"\[Alpha]", ",", 
                RowBox[{"transFairG", "[", 
                 RowBox[{"[", 
                  RowBox[{
                   RowBox[{"i", "-", "1"}], ",", "18"}], "]"}], "]"}]}], 
               "}"}]}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "2"}], "]"}], "]"}]}], ",", 
          RowBox[{
           RowBox[{"transFairG", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "19"}], "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{
             RowBox[{"transFairG", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"i", "-", "1"}], ",", "19"}], "]"}], "]"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"rT", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"transFairG", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "16"}], "]"}], "]"}], "-", 
                   RowBox[{"transFairG", "[", 
                    RowBox[{"[", 
                    RowBox[{
                    RowBox[{"i", "-", "1"}], ",", "16"}], "]"}], "]"}]}], 
                  ")"}]}], "+", 
                RowBox[{"rc", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"transFairG", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "8"}], "]"}], "]"}], "-", 
                   RowBox[{"transFairG", "[", 
                    RowBox[{"[", 
                    RowBox[{
                    RowBox[{"i", "-", "1"}], ",", "8"}], "]"}], "]"}]}], 
                  ")"}]}]}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{"dalpha", "[", 
                RowBox[{"transFairG", "[", 
                 RowBox[{"[", 
                  RowBox[{
                   RowBox[{"i", "-", "1"}], ",", "19"}], "]"}], "]"}], "]"}], 
               ")"}]}]}], "/.", "parFair"}]}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "3", ",", "256"}], "}"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transFairG", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", "20"}], "]"}], "]"}], "=", 
       RowBox[{
        RowBox[{"transFairG", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;"}], ",", "7"}], "]"}], "]"}], "*", "2.12"}]}]}], 
     "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", "1", ",", "1"}], "}"}]}], "]"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.810280473345899*^9, 3.810280835289139*^9}, {
   3.8103641075717745`*^9, 3.810364110692772*^9}, {3.81036883002244*^9, 
   3.8103688305164795`*^9}, {3.8109597437819242`*^9, 
   3.8109597443484993`*^9}, {3.8126087024628897`*^9, 
   3.8126088027229705`*^9}, {3.8126089125388813`*^9, 3.812608914625472*^9}, {
   3.8133342934321384`*^9, 3.813334420216504*^9}, {3.8133344881701365`*^9, 
   3.813334619140195*^9}, {3.81333853388776*^9, 3.813338608697424*^9}, {
   3.813338681538455*^9, 3.813338685953352*^9}, {3.813338943353011*^9, 
   3.8133389926475935`*^9}, {3.813339447165347*^9, 3.8133394617685184`*^9}, {
   3.813339494809816*^9, 3.8133398477767277`*^9}, {3.8133399070193973`*^9, 
   3.8133399167065544`*^9}, {3.813339954815693*^9, 3.8133399781247263`*^9}, {
   3.8133403577092*^9, 3.8133403587043533`*^9}, {3.813340638363896*^9, 
   3.8133406723371153`*^9}, {3.8133461297614355`*^9, 3.813346237438306*^9}, {
   3.813346311469352*^9, 3.813346313427952*^9}, {3.813346478244486*^9, 
   3.8133464786699057`*^9}, {3.813512800860598*^9, 3.8135128045530205`*^9}, {
   3.8135129613335967`*^9, 3.813512967665472*^9}, {3.813513131335656*^9, 
   3.8135132059702077`*^9}, {3.813513448868885*^9, 3.8135134951501684`*^9}, {
   3.813513585711378*^9, 3.8135136559666605`*^9}, {3.813514076073622*^9, 
   3.8135140787416267`*^9}, {3.813516095289074*^9, 3.81351609572066*^9}, {
   3.8166392503253765`*^9, 3.8166392505416813`*^9}, {3.8166393846856313`*^9, 
   3.816639396927516*^9}, {3.816718495005973*^9, 3.816718499048741*^9}, {
   3.8172397137213984`*^9, 3.817239714740735*^9}, {3.8227993523451304`*^9, 
   3.822799352755131*^9}, {3.8231600241002007`*^9, 3.823160042974227*^9}, {
   3.823160116563333*^9, 3.823160130937353*^9}, {3.8233613752542953`*^9, 
   3.8233613881663136`*^9}, {3.8233614503524017`*^9, 3.823361461274417*^9}, {
   3.824184173201676*^9, 3.824184188160412*^9}, {3.8241842460173254`*^9, 
   3.824184266150652*^9}, {3.8241866294469028`*^9, 3.824186633425532*^9}, {
   3.824187019099598*^9, 3.8241870297244606`*^9}, {3.828779183986861*^9, 
   3.8287791897393694`*^9}, {3.8311367163522387`*^9, 3.831136756588296*^9}, {
   3.831184318048298*^9, 3.831184413558957*^9}, {3.831184458437858*^9, 
   3.8311845570185905`*^9}, {3.831184658699529*^9, 3.831184710075184*^9}, {
   3.8311847808429403`*^9, 3.8311847812485924`*^9}, {3.8311848154476986`*^9, 
   3.831184817443138*^9}, {3.8311848763324246`*^9, 3.8311848775351467`*^9}, {
   3.831661124843525*^9, 3.8316611505885615`*^9}, {3.83844366913942*^9, 
   3.8384437079690127`*^9}, 3.838444715596843*^9, {3.8384507691594057`*^9, 
   3.8384507702019463`*^9}, {3.838450816055798*^9, 3.8384508723020687`*^9}, {
   3.8384521274676695`*^9, 3.8384521311303415`*^9}, 3.8384531702551346`*^9, {
   3.8384651924675827`*^9, 3.8384652102144337`*^9}, {3.8384654610708156`*^9, 
   3.8384654632627745`*^9}, {3.8410278504364004`*^9, 
   3.8410278508939075`*^9}, {3.8410278841741557`*^9, 3.8410278846441565`*^9}},
 CellLabel->"In[41]:=",ExpressionUUID->"d89c5852-c7fb-45f8-b606-2af1c7082687"],

Cell[BoxData[
 TemplateBox[{
  "FindRoot","lstol",
   "\"The line search decreased the step size to within tolerance specified \
by AccuracyGoal and PrecisionGoal but was unable to find a sufficient \
decrease in the merit function. You may need more than \
\\!\\(\\*RowBox[{\\\"MachinePrecision\\\"}]\\) digits of working precision to \
meet these tolerances.\"",2,41,6,26441536519985202249,"Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.838453631080349*^9, 3.838454338638012*^9, 
  3.8384601992862043`*^9, 3.8384602908840837`*^9, 3.8384604057285585`*^9, 
  3.8384604380011*^9, 3.838465220417252*^9, 3.8384654645960846`*^9, 
  3.8384681374974747`*^9, 3.838469245610936*^9, 3.8384693025035152`*^9, 
  3.838470346488985*^9, 3.8384725197976017`*^9, 3.8384731996192775`*^9, 
  3.838486095435239*^9, 3.8384867496401324`*^9, 3.8384915138945065`*^9, 
  3.839032206606062*^9, 3.8392110627502584`*^9, 3.841027697353553*^9, 
  3.8410278535464487`*^9, 3.8410278854441576`*^9},
 CellLabel->
  "During evaluation of \
In[41]:=",ExpressionUUID->"4bb79286-394b-4d02-99e0-7d993dfeeaa4"],

Cell[BoxData[
 TemplateBox[{
  "FindRoot","lstol",
   "\"The line search decreased the step size to within tolerance specified \
by AccuracyGoal and PrecisionGoal but was unable to find a sufficient \
decrease in the merit function. You may need more than \
\\!\\(\\*RowBox[{\\\"MachinePrecision\\\"}]\\) digits of working precision to \
meet these tolerances.\"",2,41,7,26441536519985202249,"Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.838453631080349*^9, 3.838454338638012*^9, 
  3.8384601992862043`*^9, 3.8384602908840837`*^9, 3.8384604057285585`*^9, 
  3.8384604380011*^9, 3.838465220417252*^9, 3.8384654645960846`*^9, 
  3.8384681374974747`*^9, 3.838469245610936*^9, 3.8384693025035152`*^9, 
  3.838470346488985*^9, 3.8384725197976017`*^9, 3.8384731996192775`*^9, 
  3.838486095435239*^9, 3.8384867496401324`*^9, 3.8384915138945065`*^9, 
  3.839032206606062*^9, 3.8392110627502584`*^9, 3.841027697353553*^9, 
  3.8410278535464487`*^9, 3.841027885494158*^9},
 CellLabel->
  "During evaluation of \
In[41]:=",ExpressionUUID->"24cf1941-40f5-4525-a52f-6f865f9a2775"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dimensions", "[", "transFairG", "]"}]], "Input",
 CellChangeTimes->{{3.841027706085565*^9, 3.841027714236577*^9}},
 CellLabel->"In[39]:=",ExpressionUUID->"83df5bfc-91a0-4c90-9da5-2a84244caf82"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"256", ",", "20"}], "}"}]], "Output",
 CellChangeTimes->{3.8410277149175777`*^9, 3.841027856768998*^9},
 CellLabel->"Out[39]=",ExpressionUUID->"9c488e35-a554-4fff-9506-7237284e38fc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"transFairG", "[", 
   RowBox[{"[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "2", ",", "187", ",", "197", ",", "207", ",", "242", ",", 
      "247", ",", "251", ",", "252", ",", "253", ",", "254", ",", "255", ",", 
      "256"}], "}"}], "]"}], "]"}], "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.8384603272300262`*^9, 3.838460353604717*^9}, {
  3.8410278631835966`*^9, 3.841027864193612*^9}},
 CellLabel->"In[42]:=",ExpressionUUID->"a1a03af9-5ba6-46f2-912f-f74288d6b27f"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"\<\"1-Y\"\>", "\<\"2-E\"\>", "\<\"3-R1\"\>", "\<\"4-R2\"\>", "\<\"5-R3\
\"\>", "\<\"6-R4\"\>", "\<\"7-C\"\>", "\<\"8-CCA\"\>", "\<\"9-F\"\>", \
"\<\"10-Fex\"\>", "\<\"11-TF\"\>", "\<\"12-TMF\"\>", "\<\"13-TMS\"\>", \
"\<\"14-TDF\"\>", "\<\"15-TDS\"\>", "\<\"16-TM\"\>", "\<\"17-TD\"\>", \
"\<\"18-\[Alpha]\"\>", "\<\"19-\[Alpha]check\"\>", "\<\"20-atmosGt\"\>"},
     {"1765", "0.001408379900111734`", "0", "0", "0", "0", "278", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0.16376976980682398`", 
      "0.16376976980682398`", "589.36`"},
     {"1950", "1.1745252595410498`", "14.996093698125186`", 
      "9.13920221456826`", "2.196446319075466`", "0.28624750076304933`", 
      "304.61798973253195`", "89.91099476802299`", "0.4894093327518194`", 
      RowBox[{"-", "0.04104037`"}], "0.4483689627518194`", 
      "0.20866176201967995`", "0.02333680906330187`", 
      RowBox[{"-", "0.005235842392861609`"}], "0.0546606967167681`", 
      "0.23199857108298183`", "0.04942485432390649`", "0.2230467134422109`", 
      "0.22294628974854466`", "645.7901382329678`"},
     {"1960", "1.75649877307222`", "18.203007736109267`", 
      "11.326230867136207`", "3.2207093771215467`", "0.46876364269174997`", 
      "311.21871162305877`", "107.21144528642759`", "0.6041509437895604`", 
      RowBox[{"-", "0.09670858`"}], "0.5074423637895603`", 
      "0.22194488969596748`", "0.02826341598212919`", 
      RowBox[{"-", "0.005569149091339215`"}], "0.06620005352867367`", 
      "0.25020830567809665`", "0.06063090443733445`", "0.23356401903046692`", 
      "0.23343482811989277`", "659.7836686408846`"},
     {"1970", "2.462721974750469`", "22.573108057250362`", 
      "14.506365576170952`", "4.615536873058242`", "0.6953385546632006`", 
      "320.39034906114273`", "130.41078304141317`", "0.759606947525973`", 
      RowBox[{"-", "0.06039031`"}], "0.699216637525973`", 
      "0.2888072589476998`", "0.03460227708641386`", 
      RowBox[{"-", "0.0072468921719443195`"}], "0.08104726607650597`", 
      "0.3234095360341137`", "0.07380037390456165`", "0.25417479656711217`", 
      "0.25394858489427186`", "679.2275400096227`"},
     {"2005", "4.331038222334268`", "47.39651105804594`", 
      "33.94231174123948`", "13.012441835708838`", "2.033463765651825`", 
      "374.38472840064605`", "258.1569145639965`", "1.5932101715517182`", 
      "0.1662832`", "1.7594933715517183`", "0.7879511803762365`", 
      "0.08386394591755704`", 
      RowBox[{"-", "0.019771654153529758`"}], "0.1964305274485733`", 
      "0.8718151262937935`", "0.17665887329504354`", "0.4274733491844599`", 
      "0.4257118482384702`", "793.6956242093697`"},
     {"2010", "4.7368808064211505`", "52.27771067470023`", 
      "37.95815126006738`", "15.086798256444428`", "2.4367668074317814`", 
      "385.7594269986438`", "281.6694440472369`", "1.7534073268489934`", 
      "0.2547602`", "2.008167526848993`", "0.8798393692893773`", 
      "0.09445541560380523`", 
      RowBox[{"-", "0.022077357269701677`"}], "0.2212384225954406`", 
      "0.9742947848931826`", "0.19916106532573893`", "0.4687777651173261`", 
      "0.46656623042076817`", "817.8099852371249`"},
     {"2014", "4.981607359787681`", "56.513108444521926`", 
      "41.50045242584529`", "17.014010549341023`", "2.8362392868888975`", 
      "395.8638107065971`", "301.573453321395`", "1.891800608070047`", 
      "0.2990513`", "2.190851908070047`", "0.9659913152999909`", 
      "0.10391158941083962`", 
      RowBox[{"-", "0.024239123789756997`"}], "0.24338716826008125`", 
      "1.0699029047108306`", "0.21914804447032427`", "0.5080760237556111`", 
      "0.505406736360369`", "839.2312786979859`"},
     {"2015", "4.970937672781833`", "57.59550049417318`", 
      "42.409229076645396`", "17.504365036482646`", "2.9156516400976944`", 
      "398.4247462473989`", "306.7052775776451`", "1.9263150050985665`", 
      "0.311306`", "2.2376210050985663`", "0.9878452372591622`", 
      "0.10640333875484692`", 
      RowBox[{"-", "0.02478749302586709`"}], "0.2492234741071034`", 
      "1.094248576014009`", "0.22443598108123633`", "0.5185423118652773`", 
      "0.5157491981298662`", "844.6604620444857`"},
     {"2016", "4.965903383842454`", "58.675574178528784`", 
      "43.31535229333766`", "17.98432452171608`", "2.982712696061844`", 
      "400.9579636896444`", "311.8732444663822`", "1.9602382679231831`", 
      "0.3241427`", "2.284380967923183`", "1.009835995780928`", 
      "0.10894666846452612`", 
      RowBox[{"-", "0.02533929583154159`"}], "0.25518059418870603`", 
      "1.1187826642454541`", "0.22984129835716444`", "0.5292520454479842`", 
      "0.5263316082476026`", "850.0308830220462`"},
     {"2017", "5.020040774601`", "59.754554118750534`", "44.22020304150369`", 
      "18.456738263232772`", "3.045378901501732`", "403.4768743249887`", 
      "317.06086909319816`", "1.9937580937425978`", "0.3375113`", 
      "2.331269393742598`", "1.0319398774639246`", "0.11154147420794257`", 
      RowBox[{"-", "0.025893937178583005`"}], "0.2612582841331661`", 
      "1.1434813516718672`", "0.23536434695458308`", "0.5401872892065357`", 
      "0.5371363730732067`", "855.3709735689762`"},
     {"2018", "5.106581704241743`", "60.84529836085555`", 
      "45.137134180763475`", "18.939332243622367`", "3.122556677097502`", 
      "406.04432146233887`", "322.26036760416997`", "2.0277091418824877`", 
      "0.3513641`", "2.379073241882488`", "1.0541892089948133`", 
      "0.11418824876142183`", 
      RowBox[{"-", "0.026452228223931663`"}], "0.2674576981470081`", 
      "1.1683774577562351`", "0.24100546992307642`", "0.5513511064394384`", 
      "0.5481664808830051`", "860.8139615001585`"},
     {"2019", "5.106581704241743`", "61.95484820846966`", 
      "46.07343645618666`", "19.44134430178632`", "3.2176448033826297`", 
      "408.6872737698253`", "327.48326192529123`", "2.062435139840845`", 
      "0.3513641`", "2.413799239840845`", "1.07587160461552`", 
      "0.1168789572634852`", 
      RowBox[{"-", "0.026996293437753567`"}], "0.2737600165567601`", 
      "1.192750561879005`", "0.24676372311900652`", "0.562590318618633`", 
      "0.5592717150067075`", "866.4170203920297`"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.83845434687495*^9, 3.83846020450949*^9, 3.838460294455101*^9, {
   3.8384603298721724`*^9, 3.838460354592569*^9}, 3.8384604108927016`*^9, 
   3.8384604417262297`*^9, 3.838465224760932*^9, 3.8384654670970583`*^9, 
   3.838468139790786*^9, 3.8384703548843985`*^9, 3.8384725213181534`*^9, 
   3.8384860978142223`*^9, 3.838486751586898*^9, 3.8384915416964817`*^9, 
   3.8392110654714403`*^9, {3.8410278648211217`*^9, 3.8410278880741615`*^9}},
 CellLabel->
  "Out[42]//MatrixForm=",ExpressionUUID->"0b8f1854-f9e7-45bb-a46e-\
1d7210f55b5d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"378.32", "-", 
  RowBox[{"Total", "[", 
   RowBox[{"transFairG", "[", 
    RowBox[{"[", 
     RowBox[{"242", ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", "4", ",", "5", ",", "6"}], "}"}]}], "]"}], "]"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.8384527256158*^9, 3.8384527618858523`*^9}, {
   3.838452801327428*^9, 3.8384528101353207`*^9}, {3.8384530605092154`*^9, 
   3.83845308039557*^9}, {3.838460576371073*^9, 3.8384605873910093`*^9}, 
   3.838460678141687*^9, {3.838472553314474*^9, 3.8384725555891733`*^9}, {
   3.8384918204763365`*^9, 3.838491824112238*^9}},
 CellLabel->"In[43]:=",ExpressionUUID->"ded2957d-a156-4d8a-a93f-098a9ef10581"],

Cell[BoxData["281.9352715993539`"], "Output",
 CellChangeTimes->{3.8384918247472553`*^9, 3.839032229272278*^9, 
  3.8410278995571775`*^9},
 CellLabel->"Out[43]=",ExpressionUUID->"d9be28b1-e9d0-49d3-9512-7b2da3dcde76"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dimensions", "[", "data", "]"}]], "Input",
 CellChangeTimes->{{3.841027941705237*^9, 3.8410279469852443`*^9}},
 CellLabel->"In[45]:=",ExpressionUUID->"974814dc-d9e6-4588-98f2-5615907b1886"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"257", ",", "15"}], "}"}]], "Output",
 CellChangeTimes->{3.841027947615245*^9},
 CellLabel->"Out[45]=",ExpressionUUID->"f10f6e43-9ff2-4669-9461-dfc7fbf9e0f7"]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.838491817236718*^9, 
  3.8384918187787046`*^9}},ExpressionUUID->"ae747199-6e34-4b24-9f1c-\
121cb7aa62af"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"y", "=", "71"}], ",", "\[IndentingNewLine]", 
      RowBox[{"transFairN", "=", 
       RowBox[{"Table", "[", 
        RowBox[{"0", ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "y"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"j", ",", "20"}], "}"}]}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transFairN", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "=", 
       RowBox[{"{", 
        RowBox[{
        "\"\<1-Y\>\"", ",", "\"\<2-E\>\"", ",", "\"\<3-R1\>\"", ",", 
         "\"\<4-R2\>\"", ",", "\"\<5-R3\>\"", ",", "\"\<6-R4\>\"", ",", 
         "\"\<7-C\>\"", ",", "\"\<8-CCA\>\"", ",", "\"\<9-F\>\"", ",", 
         "\"\<10-Fex\>\"", ",", "\"\<11-TF\>\"", ",", "\"\<12-TMF\>\"", ",", 
         "\"\<13-TMS\>\"", ",", "\"\<14-TDF\>\"", ",", "\"\<15-TDS\>\"", ",", 
         "\"\<16-TM\>\"", ",", "\"\<17-TD\>\"", ",", "\"\<18-\[Alpha]\>\"", 
         ",", "\"\<19-\[Alpha]check\>\"", ",", "\"\<20-atmosGt\>\""}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"transFairN", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"n", "+", "1"}], ",", "1"}], "]"}], "]"}], "=", 
         RowBox[{"1950", "-", "1", "+", "n"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"n", ",", "1", ",", 
          RowBox[{"y", "-", "1"}]}], "}"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"emcolumns", "=", 
       RowBox[{"{", "5", "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{
         RowBox[{"transFairG", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;"}], ",", "2"}], "]"}], "]"}], "=", 
         RowBox[{
          RowBox[{"dtemp", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"2", ";;"}], ",", "3"}], "]"}], "]"}], "/", "2.12"}]}], 
        ","}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transFairN", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;", "y"}], ",", "2"}], "]"}], "]"}], "=", 
       RowBox[{
        RowBox[{"data", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"188", ";;", "257"}], ",", 
           RowBox[{"emcolumns", "[", 
            RowBox[{"[", "k", "]"}], "]"}]}], "]"}], "]"}], "/", 
        "2.1293970467500096"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transFairN", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", 
          RowBox[{"{", 
           RowBox[{"3", ",", "4", ",", "5", ",", "6"}], "}"}]}], "]"}], "]"}],
        "=", 
       RowBox[{"transFairG", "[", 
        RowBox[{"[", 
         RowBox[{"187", ",", 
          RowBox[{"3", ";;", "6"}]}], "]"}], "]"}]}], ",", " ", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{
        "initial", " ", "carbon", " ", "values", " ", "for", " ", "R1"}], ",",
         "R2", ",", "R3", ",", "R4"}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transFairN", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "7"}], "]"}], "]"}], "=", 
       RowBox[{
        RowBox[{"Total", "[", 
         RowBox[{"transFairN", "[", 
          RowBox[{"[", 
           RowBox[{"2", ",", 
            RowBox[{"3", ";;", "6"}]}], "]"}], "]"}], "]"}], "+", 
        "281.9352715993539"}]}], ",", " ", 
      RowBox[{"(*", 
       RowBox[{"281.9109520290951", ","}], "*)"}], " ", 
      RowBox[{"(*", 
       RowBox[{"276.60278", ",", " ", ".0014091894", ","}], "*)"}], " ", 
      RowBox[{"(*", 
       RowBox[{
       "initial", " ", "atmospheric", " ", "carbon", " ", "concentration"}], 
       "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transFairN", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "8"}], "]"}], "]"}], "=", 
       RowBox[{"transFairG", "[", 
        RowBox[{"[", 
         RowBox[{"187", ",", "8"}], "]"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transFairN", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "9"}], "]"}], "]"}], "=", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"F2x", "/", 
           RowBox[{"Log", "[", "2", "]"}]}], ")"}], "*", 
         RowBox[{"Log", "[", 
          RowBox[{
           RowBox[{"transFairN", "[", 
            RowBox[{"[", 
             RowBox[{"2", ",", "7"}], "]"}], "]"}], "/", 
           "281.9352715993539"}], "]"}]}], "/.", "parFair"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"fexcolumns", "=", 
       RowBox[{"{", "6", "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transFairN", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", "10"}], "]"}], "]"}], "=", 
       RowBox[{"data", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"188", ";;", "257"}], ",", 
          RowBox[{"fexcolumns", "[", 
           RowBox[{"[", "k", "]"}], "]"}]}], "]"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transFairN", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", "11"}], "]"}], "]"}], "=", 
       RowBox[{"Total", "[", 
        RowBox[{"transFairN", "[", 
         RowBox[{"[", 
          RowBox[{"2", ",", 
           RowBox[{"9", ";;", "10"}]}], "]"}], "]"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transFairN", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", 
          RowBox[{"{", 
           RowBox[{"12", ",", "13", ",", "14", ",", "15"}], "}"}]}], "]"}], 
        "]"}], "=", 
       RowBox[{"transFairG", "[", 
        RowBox[{"[", 
         RowBox[{"187", ",", 
          RowBox[{"12", ";;", "15"}]}], "]"}], "]"}]}], ",", " ", 
      RowBox[{"(*", 
       RowBox[{
       "initial", " ", "values", " ", "for", " ", "Mix", " ", "Layer", " ", 
        "Fast", " ", "and", " ", "Slow", " ", "Response", " ", "and", " ", 
        "Deep", " ", "Layer", " ", "Fast", " ", "and", " ", "Slow", " ", 
        "Response"}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transFairN", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "16"}], "]"}], "]"}], "=", 
       RowBox[{"Total", "[", 
        RowBox[{"transFairN", "[", 
         RowBox[{"[", 
          RowBox[{"2", ",", 
           RowBox[{"12", ";;", "13"}]}], "]"}], "]"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transFairN", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "17"}], "]"}], "]"}], "=", 
       RowBox[{"Total", "[", 
        RowBox[{"transFairN", "[", 
         RowBox[{"[", 
          RowBox[{"2", ",", 
           RowBox[{"14", ";;", "15"}]}], "]"}], "]"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transFairN", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", "18"}], "]"}], "]"}], "=", 
       RowBox[{
        RowBox[{"FindRoot", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"rirf", "[", 
            RowBox[{
             RowBox[{"transFairN", "[", 
              RowBox[{"[", 
               RowBox[{"2", ",", "8"}], "]"}], "]"}], ",", 
             RowBox[{"transFairN", "[", 
              RowBox[{"[", 
               RowBox[{"2", ",", "16"}], "]"}], "]"}]}], "]"}], "\[Equal]", 
           RowBox[{"lirf", "[", "\[Alpha]", "]"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"\[Alpha]", ",", "0.2"}], "}"}]}], "]"}], "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", "2"}], "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transFairN", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "19"}], "]"}], "]"}], "=", 
       RowBox[{"transFairN", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "18"}], "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"transFairN", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", 
              RowBox[{"3", ";;", "6"}]}], "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{"transFairN", "[", 
             RowBox[{"[", 
              RowBox[{
               RowBox[{"i", "-", "1"}], ",", 
               RowBox[{"3", ";;", "6"}]}], "]"}], "]"}], "+", 
            RowBox[{"dr", "[", 
             RowBox[{"aFair", ",", "\[Tau]Fair", ",", 
              RowBox[{"transFairN", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "-", "1"}], ",", "18"}], "]"}], "]"}], ",", 
              RowBox[{"transFairN", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "-", "1"}], ",", "2"}], "]"}], "]"}], ",", 
              RowBox[{"transFairN", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "-", "1"}], ",", 
                 RowBox[{"3", ";;", "6"}]}], "]"}], "]"}]}], "]"}]}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"transFairN", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "7"}], "]"}], "]"}], "=", 
           RowBox[{"281.9352715993539", "+", 
            RowBox[{"Total", "[", 
             RowBox[{"transFairN", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", 
                RowBox[{"3", ";;", "6"}]}], "]"}], "]"}], "]"}]}]}], ",", 
          RowBox[{
           RowBox[{"transFairN", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "8"}], "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{"transFairN", "[", 
             RowBox[{"[", 
              RowBox[{
               RowBox[{"i", "-", "1"}], ",", "8"}], "]"}], "]"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"transFairN", "[", 
                RowBox[{"[", 
                 RowBox[{
                  RowBox[{"i", "-", "1"}], ",", "2"}], "]"}], "]"}], "-", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"transFairN", "[", 
                  RowBox[{"[", 
                   RowBox[{"i", ",", "7"}], "]"}], "]"}], "-", 
                 RowBox[{"transFairN", "[", 
                  RowBox[{"[", 
                   RowBox[{
                    RowBox[{"i", "-", "1"}], ",", "7"}], "]"}], "]"}]}], 
                ")"}]}], ")"}], "*", "2.12"}]}]}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"transFairN", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "9"}], "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"F2x", "/", 
               RowBox[{"Log", "[", "2", "]"}]}], ")"}], "*", 
             RowBox[{"Log", "[", 
              RowBox[{
               RowBox[{"transFairN", "[", 
                RowBox[{"[", 
                 RowBox[{"i", ",", "7"}], "]"}], "]"}], "/", 
               "281.9352715993539"}], "]"}]}], "/.", "parFair"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"transFairN", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "11"}], "]"}], "]"}], "=", 
           RowBox[{"Total", "[", 
            RowBox[{"transFairN", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", 
               RowBox[{"9", ";;", "10"}]}], "]"}], "]"}], "]"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"transFairN", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "12"}], "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"expf", "*", 
               RowBox[{"transFairN", "[", 
                RowBox[{"[", 
                 RowBox[{
                  RowBox[{"i", "-", "1"}], ",", "12"}], "]"}], "]"}]}], "+", 
              RowBox[{"amixf", "*", "intf"}]}], "/.", 
             RowBox[{"f0", "\[Rule]", 
              RowBox[{"transFairN", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "-", "1"}], ",", "11"}], "]"}], "]"}]}]}], "/.", 
            RowBox[{"f1", "\[Rule]", 
             RowBox[{"transFairN", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "11"}], "]"}], "]"}]}]}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"transFairN", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "13"}], "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"exps", "*", 
               RowBox[{"transFairN", "[", 
                RowBox[{"[", 
                 RowBox[{
                  RowBox[{"i", "-", "1"}], ",", "13"}], "]"}], "]"}]}], "+", 
              RowBox[{"amixs", "*", "ints"}]}], "/.", 
             RowBox[{"f0", "\[Rule]", 
              RowBox[{"transFairN", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "-", "1"}], ",", "11"}], "]"}], "]"}]}]}], "/.", 
            RowBox[{"f1", "\[Rule]", 
             RowBox[{"transFairN", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "11"}], "]"}], "]"}]}]}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"transFairN", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "14"}], "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"expf", "*", 
               RowBox[{"transFairN", "[", 
                RowBox[{"[", 
                 RowBox[{
                  RowBox[{"i", "-", "1"}], ",", "14"}], "]"}], "]"}]}], "+", 
              RowBox[{"adeepf", "*", "intf"}]}], "/.", 
             RowBox[{"f0", "\[Rule]", 
              RowBox[{"transFairN", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "-", "1"}], ",", "11"}], "]"}], "]"}]}]}], "/.", 
            RowBox[{"f1", "\[Rule]", 
             RowBox[{"transFairN", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "11"}], "]"}], "]"}]}]}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"transFairN", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "15"}], "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"exps", "*", 
               RowBox[{"transFairN", "[", 
                RowBox[{"[", 
                 RowBox[{
                  RowBox[{"i", "-", "1"}], ",", "15"}], "]"}], "]"}]}], "+", 
              RowBox[{"adeeps", "*", "ints"}]}], "/.", 
             RowBox[{"f0", "\[Rule]", 
              RowBox[{"transFairN", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "-", "1"}], ",", "11"}], "]"}], "]"}]}]}], "/.", 
            RowBox[{"f1", "\[Rule]", 
             RowBox[{"transFairN", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "11"}], "]"}], "]"}]}]}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"transFairN", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "16"}], "]"}], "]"}], "=", 
           RowBox[{"Total", "[", 
            RowBox[{"transFairN", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", 
               RowBox[{"12", ";;", "13"}]}], "]"}], "]"}], "]"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"transFairN", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "17"}], "]"}], "]"}], "=", 
           RowBox[{"Total", "[", 
            RowBox[{"transFairN", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", 
               RowBox[{"14", ";;", "15"}]}], "]"}], "]"}], "]"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"(*", 
           RowBox[{
            RowBox[{
             RowBox[{"transFairG", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", 
                RowBox[{"{", 
                 RowBox[{"11", ",", "12"}], "}"}]}], "]"}], "]"}], "=", 
             RowBox[{
              RowBox[{
               RowBox[{"transT", ".", 
                RowBox[{"transFairG", "[", 
                 RowBox[{"[", 
                  RowBox[{
                   RowBox[{"i", "-", "1"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"11", ",", "12"}], "}"}]}], "]"}], "]"}]}], "+", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"1", ",", "0"}], "}"}], "*", "xi1", "*", 
                RowBox[{"Total", "[", 
                 RowBox[{"transFairG", "[", 
                  RowBox[{"[", 
                   RowBox[{"i", ",", 
                    RowBox[{"9", ";;", "10"}]}], "]"}], "]"}], "]"}]}]}], "/.", \
"parTG"}]}], ","}], "\[IndentingNewLine]", 
           RowBox[{"(*", 
            RowBox[{
             RowBox[{
              RowBox[{"transFairG", "[", 
               RowBox[{"[", 
                RowBox[{"i", ",", "13"}], "]"}], "]"}], "=", 
              RowBox[{"Total", "[", 
               RowBox[{"transFairG", "[", 
                RowBox[{"[", 
                 RowBox[{"i", ",", 
                  RowBox[{"11", ";;", "12"}]}], "]"}], "]"}], "]"}]}], ","}], 
            "*)"}], "*)"}], "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"transFairN", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "18"}], "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{"FindRoot", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"rirf", "[", 
                RowBox[{
                 RowBox[{"transFairN", "[", 
                  RowBox[{"[", 
                   RowBox[{"i", ",", "8"}], "]"}], "]"}], ",", 
                 RowBox[{"transFairN", "[", 
                  RowBox[{"[", 
                   RowBox[{"i", ",", "16"}], "]"}], "]"}]}], "]"}], 
               "\[Equal]", 
               RowBox[{"lirf", "[", "\[Alpha]", "]"}]}], ",", 
              RowBox[{"{", 
               RowBox[{"\[Alpha]", ",", 
                RowBox[{"transFairN", "[", 
                 RowBox[{"[", 
                  RowBox[{
                   RowBox[{"i", "-", "1"}], ",", "18"}], "]"}], "]"}]}], 
               "}"}]}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "2"}], "]"}], "]"}]}], ",", 
          RowBox[{
           RowBox[{"transFairN", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "19"}], "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{
             RowBox[{"transFairN", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"i", "-", "1"}], ",", "19"}], "]"}], "]"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"rT", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"transFairN", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "16"}], "]"}], "]"}], "-", 
                   RowBox[{"transFairN", "[", 
                    RowBox[{"[", 
                    RowBox[{
                    RowBox[{"i", "-", "1"}], ",", "16"}], "]"}], "]"}]}], 
                  ")"}]}], "+", 
                RowBox[{"rc", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"transFairN", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "8"}], "]"}], "]"}], "-", 
                   RowBox[{"transFairN", "[", 
                    RowBox[{"[", 
                    RowBox[{
                    RowBox[{"i", "-", "1"}], ",", "8"}], "]"}], "]"}]}], 
                  ")"}]}]}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{"dalpha", "[", 
                RowBox[{"transFairN", "[", 
                 RowBox[{"[", 
                  RowBox[{
                   RowBox[{"i", "-", "1"}], ",", "19"}], "]"}], "]"}], "]"}], 
               ")"}]}]}], "/.", "parFair"}]}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "3", ",", "71"}], "}"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transFairN", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", "20"}], "]"}], "]"}], "=", 
       RowBox[{
        RowBox[{"transFairN", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;"}], ",", "7"}], "]"}], "]"}], "*", "2.12"}]}]}], 
     "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", "1", ",", "1"}], "}"}]}], "]"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.810280473345899*^9, 3.810280835289139*^9}, {
   3.8103641075717745`*^9, 3.810364110692772*^9}, {3.81036883002244*^9, 
   3.8103688305164795`*^9}, {3.8109597437819242`*^9, 
   3.8109597443484993`*^9}, {3.8126087024628897`*^9, 
   3.8126088027229705`*^9}, {3.8126089125388813`*^9, 3.812608914625472*^9}, {
   3.8133342934321384`*^9, 3.813334420216504*^9}, {3.8133344881701365`*^9, 
   3.813334619140195*^9}, {3.81333853388776*^9, 3.813338608697424*^9}, {
   3.813338681538455*^9, 3.813338685953352*^9}, {3.813338943353011*^9, 
   3.8133389926475935`*^9}, {3.813339447165347*^9, 3.8133394617685184`*^9}, {
   3.813339494809816*^9, 3.8133398477767277`*^9}, {3.8133399070193973`*^9, 
   3.8133399167065544`*^9}, {3.813339954815693*^9, 3.8133399781247263`*^9}, {
   3.8133403577092*^9, 3.8133403587043533`*^9}, {3.813340638363896*^9, 
   3.8133406723371153`*^9}, {3.8133461297614355`*^9, 3.813346237438306*^9}, {
   3.813346311469352*^9, 3.813346313427952*^9}, {3.813346478244486*^9, 
   3.8133464786699057`*^9}, {3.813512800860598*^9, 3.8135128045530205`*^9}, {
   3.8135129613335967`*^9, 3.813512967665472*^9}, {3.813513131335656*^9, 
   3.8135132059702077`*^9}, {3.813513448868885*^9, 3.8135134951501684`*^9}, {
   3.813513585711378*^9, 3.8135136559666605`*^9}, {3.813514076073622*^9, 
   3.8135140787416267`*^9}, {3.813516095289074*^9, 3.81351609572066*^9}, {
   3.8166392503253765`*^9, 3.8166392505416813`*^9}, {3.8166393846856313`*^9, 
   3.816639396927516*^9}, {3.816718495005973*^9, 3.816718499048741*^9}, {
   3.8172397137213984`*^9, 3.817239714740735*^9}, {3.8227993523451304`*^9, 
   3.822799352755131*^9}, {3.8231600241002007`*^9, 3.823160042974227*^9}, {
   3.823160116563333*^9, 3.823160130937353*^9}, {3.8233613752542953`*^9, 
   3.8233613881663136`*^9}, {3.8233614503524017`*^9, 3.823361461274417*^9}, {
   3.824184173201676*^9, 3.824184188160412*^9}, {3.8241842460173254`*^9, 
   3.824184266150652*^9}, {3.8241866294469028`*^9, 3.824186633425532*^9}, {
   3.824187019099598*^9, 3.8241870297244606`*^9}, {3.828779183986861*^9, 
   3.8287791897393694`*^9}, {3.8311367163522387`*^9, 3.831136756588296*^9}, {
   3.831184318048298*^9, 3.831184413558957*^9}, {3.831184458437858*^9, 
   3.8311845570185905`*^9}, {3.831184658699529*^9, 3.831184710075184*^9}, {
   3.8311847808429403`*^9, 3.8311847812485924`*^9}, {3.8311848154476986`*^9, 
   3.831184817443138*^9}, {3.8311848763324246`*^9, 3.8311848775351467`*^9}, {
   3.831661124843525*^9, 3.8316611505885615`*^9}, {3.83844366913942*^9, 
   3.8384437079690127`*^9}, 3.838444715596843*^9, {3.8384507691594057`*^9, 
   3.8384507702019463`*^9}, {3.838450816055798*^9, 3.8384508723020687`*^9}, {
   3.8384521274676695`*^9, 3.8384521311303415`*^9}, {3.838452180772383*^9, 
   3.838452196366704*^9}, {3.838452400538794*^9, 3.8384526680171556`*^9}, {
   3.8384526998611517`*^9, 3.838452715573786*^9}, {3.8384527691321893`*^9, 
   3.838452787308704*^9}, {3.8384530950283437`*^9, 3.838453117713615*^9}, {
   3.8384531857186203`*^9, 3.8384532366488323`*^9}, {3.8384533859461875`*^9, 
   3.8384533966815605`*^9}, {3.838453469822365*^9, 3.838453494066008*^9}, {
   3.8384536864763985`*^9, 3.8384536873877463`*^9}, {3.8384539789950914`*^9, 
   3.83845399545926*^9}, {3.8384606029416747`*^9, 3.838460619763105*^9}, {
   3.8384606919781504`*^9, 3.8384607065861025`*^9}, {3.838464290544545*^9, 
   3.8384642994399405`*^9}, {3.838464803822725*^9, 3.838464816168724*^9}, {
   3.83846530219372*^9, 3.8384653548276653`*^9}, {3.8384676243525476`*^9, 
   3.8384676604020023`*^9}, {3.8384725962508645`*^9, 
   3.8384726043566265`*^9}, {3.838472644058118*^9, 3.838472655353733*^9}, {
   3.8384918401309285`*^9, 3.8384918909309874`*^9}, {3.8410279143311987`*^9, 
   3.8410279201622066`*^9}, {3.841027984781299*^9, 3.8410280001943207`*^9}},
 CellLabel->"In[46]:=",ExpressionUUID->"40198677-a435-4109-8318-3ae36523278b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"transFairN", "[", 
   RowBox[{"[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "2", ",", "3", ",", "12", ",", "57", ",", "62", ",", "70", ",",
       "71"}], "}"}], "]"}], "]"}], "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.83845327191763*^9, 3.838453281428947*^9}, {
  3.838453408848366*^9, 3.8384534258736424`*^9}, {3.8384536601355596`*^9, 
  3.838453660326619*^9}, {3.8384537201114964`*^9, 3.8384537212576466`*^9}, {
  3.8384537588861027`*^9, 3.838453759475523*^9}, {3.8410280078153315`*^9, 
  3.8410280084753323`*^9}},
 CellLabel->"In[47]:=",ExpressionUUID->"909958bf-6cd4-4f64-b774-9715c1d76a07"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"\<\"1-Y\"\>", "\<\"2-E\"\>", "\<\"3-R1\"\>", "\<\"4-R2\"\>", "\<\"5-R3\
\"\>", "\<\"6-R4\"\>", "\<\"7-C\"\>", "\<\"8-CCA\"\>", "\<\"9-F\"\>", \
"\<\"10-Fex\"\>", "\<\"11-TF\"\>", "\<\"12-TMF\"\>", "\<\"13-TMS\"\>", \
"\<\"14-TDF\"\>", "\<\"15-TDS\"\>", "\<\"16-TM\"\>", "\<\"17-TD\"\>", \
"\<\"18-\[Alpha]\"\>", "\<\"19-\[Alpha]check\"\>", "\<\"20-atmosGt\"\>"},
     {"1950", "1.1745252595410498`", "14.996093698125186`", 
      "9.13920221456826`", "2.196446319075466`", "0.28624750076304933`", 
      "308.55326133188584`", "89.91099476802299`", "0.4828771483269661`", 
      RowBox[{"-", "0.04104037`"}], "0.4418367783269661`", 
      "0.20866176201967995`", "0.02333680906330187`", 
      RowBox[{"-", "0.005235842392861609`"}], "0.0546606967167681`", 
      "0.23199857108298183`", "0.04942485432390649`", "0.22304671344192184`", 
      "0.22304671344192184`", "654.132914023598`"},
     {"1951", "1.3259527767775081`", "15.251250804050297`", 
      "9.2984054407392`", "2.2586338330747244`", "0.31259219278366396`", 
      "309.05615387000176`", "91.33485613744425`", "0.4915936019510101`", 
      RowBox[{"-", "0.05942583`"}], "0.4321677719510101`", 
      "0.20893254465742064`", "0.02381862735753418`", 
      RowBox[{"-", "0.005242637002473885`"}], "0.055789236766188924`", 
      "0.23275117201495482`", "0.05054659976371504`", "0.22381598208279901`", 
      "0.22381474675004248`", "655.1990462044038`"},
     {"1960", "1.75649877307222`", "18.20300703632554`", 
      "11.325173811458129`", "3.218447034933485`", "0.4680527384510075`", 
      "315.14995222052204`", "107.21999101043566`", "0.5961022688539186`", 
      RowBox[{"-", "0.09670858`"}], "0.4993936888539186`", 
      "0.2186186679264346`", "0.02817142443251744`", 
      RowBox[{"-", "0.005485685917346959`"}], "0.06598458610207758`", 
      "0.24679009235895205`", "0.06049890018473062`", "0.23319046667214266`", 
      "0.2331675522742891`", "668.1178987075068`"},
     {"2005", "4.331038222334268`", "47.39649768937143`", 
      "33.92223315376489`", "12.97851189841982`", "2.02593649203156`", 
      "378.25845083294155`", "258.2873987981602`", "1.5730709289974365`", 
      "0.1662832`", "1.7393541289974366`", "0.7788820003541139`", 
      "0.08304579269024309`", 
      RowBox[{"-", "0.019544085878591848`"}], "0.1945142060995514`", 
      "0.861927793044357`", "0.17497012022095954`", "0.4257137512905222`", 
      "0.42415105088180893`", "801.9079157658362`"},
     {"2010", "4.7368808064211505`", "52.27769494340196`", 
      "37.93437642985077`", "15.046069756777896`", "2.4268580262298434`", 
      "389.62027075561434`", "281.8272310730894`", "1.7314746610531655`", 
      "0.2547602`", "1.9862348610531655`", "0.8699640424148016`", 
      "0.09351675864244416`", 
      RowBox[{"-", "0.021829560765958968`"}], "0.21903985108779075`", 
      "0.9634808010572458`", "0.1972102903218318`", "0.4667197436915042`", 
      "0.4647251915889075`", "825.9949740019024`"},
     {"2018", "5.106581704241743`", "60.84527854161267`", 
      "45.106832022850945`", "18.885304148918305`", "3.108675660162142`", 
      "409.88136197289793`", "322.468617512415`", "2.0028153469329895`", 
      "0.3513641`", "2.3541794469329895`", "1.0429236211450947`", 
      "0.11303671679122193`", 
      RowBox[{"-", "0.02616954661579638`"}], "0.2647605196419253`", 
      "1.1559603379363166`", "0.23859097302612894`", "0.5487022761077567`", 
      "0.5457696385947219`", "868.9484873825437`"},
     {"2019", "5.106581704241743`", "61.95482785652187`", 
      "46.042272278795174`", "19.385472714541883`", "3.2032893076499356`", 
      "412.52113375686275`", "327.6982545434021`", "2.0371760386941666`", 
      "0.3513641`", "2.3885401386941667`", "1.0644311987574016`", 
      "0.11569911716496169`", 
      RowBox[{"-", "0.026709225211147537`"}], "0.27099653327056017`", 
      "1.1801303159223633`", "0.24428730805941262`", "0.5598605326690723`", 
      "0.5567985749006304`", "874.544803564549`"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.8384532820974436`*^9, {3.8384534001797266`*^9, 3.8384534267656045`*^9}, 
   3.8384534970316744`*^9, {3.838453661025032*^9, 3.838453690031409*^9}, 
   3.838453722399371*^9, 3.838453760351301*^9, 3.8384539999061284`*^9, 
   3.838454403718176*^9, 3.8384602384147234`*^9, 3.8384606309685636`*^9, 
   3.838460713881199*^9, 3.838464305914472*^9, 3.8384648201921225`*^9, 
   3.838465362757909*^9, 3.8384654756226454`*^9, 3.838472666763912*^9, 
   3.8384867710067024`*^9, 3.838491895377638*^9, 3.8390322462069964`*^9, 
   3.8390333809385185`*^9, 3.8410280090163336`*^9},
 CellLabel->
  "Out[47]//MatrixForm=",ExpressionUUID->"9e541a18-0189-44b3-8437-\
429d31f90d73"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<spinup_GCB.csv\>\"", ",", "transFairN"}], "]"}]], "Input",
 CellChangeTimes->{{3.8316635963370724`*^9, 3.831663648968707*^9}, {
  3.8384450618699255`*^9, 3.8384450657113485`*^9}, {3.838460767927788*^9, 
  3.8384607687921753`*^9}},
 CellLabel->"In[48]:=",ExpressionUUID->"50503fb9-911f-4ebc-aa0b-00baddebab1b"],

Cell[BoxData["\<\"spinup_GCB.csv\"\>"], "Output",
 CellChangeTimes->{3.8316636509907103`*^9, 3.838445120051243*^9, 
  3.8384458537832813`*^9, 3.838460769938547*^9, 3.8384726709748697`*^9, 
  3.8384735516692724`*^9, 3.838492519594673*^9, 3.83903225691098*^9, 
  3.841028021357351*^9},
 CellLabel->"Out[48]=",ExpressionUUID->"d263b195-3a70-45a0-8b3c-2c60002dd95b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dalphatemp", "=", 
  RowBox[{"dalpha", "[", 
   RowBox[{"transFairN", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "18"}], "]"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8410281808505774`*^9, 3.84102818280058*^9}, {
  3.8410282441886673`*^9, 3.841028275435712*^9}},
 CellLabel->"In[50]:=",ExpressionUUID->"5f3a27e3-ada6-4f8e-959c-399c84f8a072"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "39.30552045267541`", ",", "39.17941756627988`", ",", "39.065287737961626`",
    ",", "38.94374101507128`", ",", "38.810888357809745`", ",", 
   "38.66782140271971`", ",", "38.513652193243615`", ",", 
   "38.34483771759551`", ",", "38.15869632153772`", ",", 
   "37.947128988365876`", ",", "37.70563655416481`", ",", 
   "37.45662115138839`", ",", "37.216229808778735`", ",", 
   "36.97537894832203`", ",", "36.72158197595854`", ",", 
   "36.451236649620114`", ",", "36.16369328967994`", ",", 
   "35.86201529362006`", ",", "35.54746124884696`", ",", 
   "35.216131831810344`", ",", "34.856151984713506`", ",", 
   "34.45845822186675`", ",", "34.037099904817296`", ",", 
   "33.61631303696777`", ",", "33.19851576740621`", ",", 
   "32.781992428790545`", ",", "32.374918679124676`", ",", 
   "31.977892577269813`", ",", "31.575193341181148`", ",", 
   "31.16051797181717`", ",", "30.741757925483398`", ",", 
   "30.332913624326466`", ",", "29.942423180764308`", ",", 
   "29.570175459899474`", ",", "29.203888826508773`", ",", 
   "28.834310819016537`", ",", "28.45908525964478`", ",", 
   "28.081785795395263`", ",", "27.70341490060673`", ",", 
   "27.318104156292975`", ",", "26.92544746180647`", ",", 
   "26.536558659077855`", ",", "26.161130874883384`", ",", 
   "25.797998369991546`", ",", "25.44592621762422`", ",", 
   "25.09773990471149`", ",", "24.749312104075216`", ",", 
   "24.40695181748015`", ",", "24.079988253099145`", ",", 
   "23.768227941152873`", ",", "23.469368412799668`", ",", 
   "23.181135785678634`", ",", "22.89583223182126`", ",", 
   "22.609692249272484`", ",", "22.322212668688735`", ",", 
   "22.03157556944643`", ",", "21.7333115687361`", ",", "21.425550238083815`",
    ",", "21.109417487721657`", ",", "20.787350878148573`", ",", 
   "20.464023309672484`", ",", "20.145992013742216`", ",", 
   "19.833314214920392`", ",", "19.525363742228365`", ",", 
   "19.222134092648048`", ",", "18.92413832299644`", ",", 
   "18.631556730368175`", ",", "18.344791511801304`", ",", 
   "18.06363482552115`", ",", "17.79160171697731`"}], "}"}]], "Output",
 CellChangeTimes->{{3.8410282676247005`*^9, 3.8410282781057158`*^9}},
 CellLabel->"Out[50]=",ExpressionUUID->"a2311b67-32a6-4c12-a01e-a5ff0ccb54a9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<dalphatemp.csv\>\"", ",", "dalpha"}], "]"}]], "Input",
 CellChangeTimes->{{3.841028280369719*^9, 3.8410282986227446`*^9}},
 CellLabel->"In[51]:=",ExpressionUUID->"8bf5783c-d972-4938-9d37-4d810c333ef3"],

Cell[BoxData["\<\"dalphatemp.csv\"\>"], "Output",
 CellChangeTimes->{3.8410282998227463`*^9},
 CellLabel->"Out[51]=",ExpressionUUID->"b72b8ffd-9f28-4e0b-aaae-b8017c7b4d9c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Fdata", "=", 
   RowBox[{"Import", "[", "\"\<F_external.csv\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Dimensions", "[", "Fdata", "]"}]}], "Input",
 CellLabel->
  "In[851]:=",ExpressionUUID->"16036bbe-9aba-4e82-ac1b-eb978e3e7028"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"474", ",", "10"}], "}"}]], "Output",
 CellChangeTimes->{3.83916923816683*^9},
 CellLabel->
  "Out[852]=",ExpressionUUID->"ea029d17-eceb-4b74-b4f9-33de1bd354ff"]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.8390323179968395`*^9, 3.839032423264656*^9}, {
   3.8390330004390287`*^9, 3.8390330030650597`*^9}, 
   3.839036188298076*^9},ExpressionUUID->"7110ca41-1ed3-4953-8c2c-\
cbcc59d82ebb"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"transEx", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "474"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "20"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"transEx", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "1"}], "]"}], "]"}], "=", 
    RowBox[{"2018", "+", "i", "-", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "3", ",", "474"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"transEx", "[", 
    RowBox[{"[", 
     RowBox[{"1", ";;", "2"}], "]"}], "]"}], "=", 
   RowBox[{"transFairN", "[", 
    RowBox[{"[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "70"}], "}"}], "]"}], "]"}]}], ";", 
  RowBox[{
   RowBox[{"transEx", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"3", ";;"}], ",", "10"}], "]"}], "]"}], "=", 
   RowBox[{"Fdata", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"3", ";;"}], ",", "10"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"transEx", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"3", ";;"}], ",", "7"}], "]"}], "]"}], "=", 
   RowBox[{"transEx", "[", 
    RowBox[{"[", 
     RowBox[{"2", ",", "7"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"transEx", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"3", ";;"}], ",", "9"}], "]"}], "]"}], "=", 
   RowBox[{"transEx", "[", 
    RowBox[{"[", 
     RowBox[{"2", ",", "9"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"transEx", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"3", ";;"}], ",", "11"}], "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"transEx", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"3", ";;"}], ",", "9"}], "]"}], "]"}], "+", 
    RowBox[{"transEx", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"3", ";;"}], ",", "10"}], "]"}], "]"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.839033015172097*^9, 3.839033055573701*^9}, {
   3.8390330871732473`*^9, 3.839033095491227*^9}, 3.839033138556717*^9, {
   3.839033232125368*^9, 3.8390332329049244`*^9}, {3.839033296812982*^9, 
   3.839033303664225*^9}, {3.8390333882097483`*^9, 3.839033393666327*^9}, {
   3.8390334639564114`*^9, 3.8390335144911423`*^9}, {3.8390361899174805`*^9, 
   3.8390362027971125`*^9}},
 CellLabel->
  "In[897]:=",ExpressionUUID->"7bd38d84-2e8d-4def-a67f-079197035fae"],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.8390337480107293`*^9, 3.839033789830181*^9}, 
   3.8390362006103177`*^9},ExpressionUUID->"ddfa8e9b-ef7a-49d3-a88c-\
40580cdab7ad"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"transEx", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "12"}], "]"}], "]"}], "=", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"expf", "*", 
           RowBox[{"transEx", "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"i", "-", "1"}], ",", "12"}], "]"}], "]"}]}], "+", 
          RowBox[{"amixf", "*", "intf"}]}], "/.", 
         RowBox[{"f0", "\[Rule]", 
          RowBox[{"transEx", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"i", "-", "1"}], ",", "11"}], "]"}], "]"}]}]}], "/.", 
        RowBox[{"f1", "\[Rule]", 
         RowBox[{"transEx", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "11"}], "]"}], "]"}]}]}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transEx", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "13"}], "]"}], "]"}], "=", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"exps", "*", 
           RowBox[{"transEx", "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"i", "-", "1"}], ",", "13"}], "]"}], "]"}]}], "+", 
          RowBox[{"amixs", "*", "ints"}]}], "/.", 
         RowBox[{"f0", "\[Rule]", 
          RowBox[{"transEx", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"i", "-", "1"}], ",", "11"}], "]"}], "]"}]}]}], "/.", 
        RowBox[{"f1", "\[Rule]", 
         RowBox[{"transEx", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "11"}], "]"}], "]"}]}]}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transEx", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "14"}], "]"}], "]"}], "=", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"expf", "*", 
           RowBox[{"transEx", "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"i", "-", "1"}], ",", "14"}], "]"}], "]"}]}], "+", 
          RowBox[{"adeepf", "*", "intf"}]}], "/.", 
         RowBox[{"f0", "\[Rule]", 
          RowBox[{"transEx", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"i", "-", "1"}], ",", "11"}], "]"}], "]"}]}]}], "/.", 
        RowBox[{"f1", "\[Rule]", 
         RowBox[{"transEx", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "11"}], "]"}], "]"}]}]}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transEx", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "15"}], "]"}], "]"}], "=", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"exps", "*", 
           RowBox[{"transEx", "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"i", "-", "1"}], ",", "15"}], "]"}], "]"}]}], "+", 
          RowBox[{"adeeps", "*", "ints"}]}], "/.", 
         RowBox[{"f0", "\[Rule]", 
          RowBox[{"transEx", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"i", "-", "1"}], ",", "11"}], "]"}], "]"}]}]}], "/.", 
        RowBox[{"f1", "\[Rule]", 
         RowBox[{"transEx", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "11"}], "]"}], "]"}]}]}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transEx", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "16"}], "]"}], "]"}], "=", 
       RowBox[{"Total", "[", 
        RowBox[{"transEx", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", 
           RowBox[{"12", ";;", "13"}]}], "]"}], "]"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transEx", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "17"}], "]"}], "]"}], "=", 
       RowBox[{"Total", "[", 
        RowBox[{"transEx", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", 
           RowBox[{"14", ";;", "15"}]}], "]"}], "]"}], "]"}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "3", ",", "474"}], "}"}]}], "]"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.83903360660674*^9, 3.8390337304150867`*^9}},
 CellLabel->
  "In[903]:=",ExpressionUUID->"a1aaea27-8ea0-4ff1-8980-6661f90199ee"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"transEx", "[", 
   RowBox[{"[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "84"}], "}"}], "]"}], "]"}], "//", 
  "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.839033801341624*^9, 3.8390338441143303`*^9}, {
  3.839034104571452*^9, 3.839034105248418*^9}},
 CellLabel->
  "In[904]:=",ExpressionUUID->"cec79f70-0edd-4f47-b466-cfa0a3ce3701"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"\<\"1-Y\"\>", "\<\"2-E\"\>", "\<\"3-R1\"\>", "\<\"4-R2\"\>", "\<\"5-R3\
\"\>", "\<\"6-R4\"\>", "\<\"7-C\"\>", "\<\"8-CCA\"\>", "\<\"9-F\"\>", \
"\<\"10-Fex\"\>", "\<\"11-TF\"\>", "\<\"12-TMF\"\>", "\<\"13-TMS\"\>", \
"\<\"14-TDF\"\>", "\<\"15-TDS\"\>", "\<\"16-TM\"\>", "\<\"17-TD\"\>", \
"\<\"18-\[Alpha]\"\>", "\<\"19-\[Alpha]check\"\>", "\<\"20-atmosGt\"\>"},
     {"2018", "5.106581704241743`", "60.84527854161267`", 
      "45.106832022850945`", "18.885304148918305`", "3.108675660162142`", 
      "409.88136197289793`", "322.468617512415`", "2.0028153469329895`", 
      "0.3513641`", "2.3541794469329895`", "1.0429236211450947`", 
      "0.11303671679122193`", 
      RowBox[{"-", "0.02616954661579638`"}], "0.2647605196419253`", 
      "1.1559603379363166`", "0.23859097302612894`", "0.5487022761077567`", 
      "0.5457696385947219`", "868.9484873825437`"},
     {"2100", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.0938641`", "3.0966794469329892`", 
      "1.4704048750416285`", "0.336826991225404`", 
      RowBox[{"-", "0.03689611409821806`"}], "0.7889338239624948`", 
      "1.8072318662670326`", "0.7520377098642768`", "0", "0", "0"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.839033812609381*^9, 3.8390338445771875`*^9}, 
   3.8390341060822463`*^9, 3.8392111139959993`*^9},
 CellLabel->
  "Out[904]//MatrixForm=",ExpressionUUID->"42f86ae2-ac24-44e9-9396-\
7f975e7e341d"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Fdata19raw", "=", 
   RowBox[{"Import", "[", "\"\<F_external_19.csv\>\"", "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.83903558130049*^9, 3.8390356250154643`*^9}, {
  3.8390360429413867`*^9, 3.8390360434533887`*^9}},
 CellLabel->
  "In[905]:=",ExpressionUUID->"0da448e0-c553-4571-9af2-1701a44f1337"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Fint", "=", 
    RowBox[{"Interpolation", "[", 
     RowBox[{"Fdata19raw", "[", 
      RowBox[{"[", 
       RowBox[{
        RowBox[{"2", ";;"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.8390356589279633`*^9, 3.839035687054818*^9}},
 CellLabel->
  "In[906]:=",ExpressionUUID->"1c1702b7-56d5-4bbc-a299-dc3d807440b0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fdata19raw", "[", 
  RowBox[{"[", "1", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.8390360010776987`*^9, 3.8390360127273526`*^9}},
 CellLabel->
  "In[118]:=",ExpressionUUID->"c3d606f1-eafd-4eef-baeb-169215242ec2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"year\"\>", ",", "\<\"Fex\"\>"}], "}"}]], "Output",
 CellChangeTimes->{3.839036013383071*^9, 3.839036047495433*^9},
 CellLabel->
  "Out[118]=",ExpressionUUID->"e4728dbb-769b-46dc-8f86-dd6c5d2775d3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["Fint"], "Input",
 CellChangeTimes->{{3.8390359901365137`*^9, 3.8390359906034327`*^9}},
 CellLabel->
  "In[126]:=",ExpressionUUID->"de1280cd-bb78-47af-ab37-976cb054eaf9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox["InterpolatingFunction",
    "SummaryHead"], "[", 
   DynamicModuleBox[{Typeset`open$$ = False, Typeset`embedState$$ = "Ready"}, 
    TemplateBox[{PaneSelectorBox[{False -> GridBox[{{
            PaneBox[
             ButtonBox[
              DynamicBox[
               FEPrivate`FrontEndResource[
               "FEBitmaps", "SquarePlusIconMedium"]], 
              ButtonFunction :> (Typeset`open$$ = True), Appearance -> None, 
              BaseStyle -> {}, Evaluator -> Automatic, Method -> 
              "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
             Dynamic[{
               Automatic, 
                3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}]], 
            GraphicsBox[{{{{}, {}, 
                TagBox[{
                  Directive[
                   Opacity[1.], 
                   RGBColor[0.368417, 0.506779, 0.709798], 
                   AbsoluteThickness[1]], 
                  LineBox[CompressedData["
1:eJwV0H08FHYcwPHLjMhDyoTNa+llWYzYbqNw36/WyxmNeV4eWnKymscZqzlP
6YR5qGWo1uv3Y5k0epGY0Oahucyu3Z1znu507mYZISREmf3xeX3+f5sfi/ON
VGMwGM4b/f8MvWgGw58gR0ecG7iXD7HjOlL7YIIvmpWFkfAnxK2t6v97lGDd
5wJr69tCYGXdD7GNImiTqWuVvSQG9m8HrPxjCEqmfcay9fqB47QlbD2RoGeN
hMu0GwAvy/pyx28ItllMHdTSH4JDfpUeSxkE86R80Z6lYTjLZCeXnCO43+Ge
rPyODPJ43Q1dBQQ9Di+ec3cbhR+NigOSiwlGWWDxRQ0F5O0ArV8uEzy2K8P2
j0EF/CwohUFK8PxznoF3yRgouljDaVUEO3tCFl4eUoJqT1d2Qy3B9N1Ong/k
Slj56/vSmNsEU1nbX3snWAUfWRtZb24l6JbGFldfVEHUs0ShXQdB4+Dytzty
VVC2aefwKJ+gS9r6rbojKijlVi+aPtjwkJs1FbyhghsOmUkyCcHn5a59RXeV
sFSlcSpthOBncXzvuo+VsC3nRP7NMYLTKb9vp/IxwOumr3ImCO5juTS0R42B
s2N1UdUMwaV573DVvAK+TB3/ofcpQXWOTmNtigLa1OL1klYJ0uYryx/MPITJ
1Sl3KYOi91XXbUFPRyHDiN/GVKeYxti6oDYhh4YtKwlZmhTVe4cTkhZlIGg2
sbukTZF76W6jr4kM5njhdE6XYp/jtZqyd0dgTbvMxMCAos0npyyWI4bh2sm3
JDsNKdbEHy/trhiCgMkhTNxBkRfg/vKxbBCmzVOb8k0pyuZ+vefkPAhFp9mj
E2YU51cD9xZeHQDjXIa+jjnFnvjOlFDDAWAlbs1804Jiya4T198rlUJsKrsy
yZJiltTYashYCjyIEX9nRREDTFe6bvRDpXlL/bwNxWzBrAPHsR8iRsPEB+wp
nu1XcF8XSEDT78nqYSbF6k3nQztjJdD4qHqgwYHi8VbmgpeeBDyYvm2S/RTr
F7p+irjTB9wQH+W4C0V/boLa5ZN90Fzxdcs+V4pq2gWb60z6YKQ8/4r/QYrp
n3pnGYnFoNlx3/YWm6KgN/JCbI4YRC0hrzA8KXro16e3fiiGM9FyhaEXxZlH
ye25GmJwZmXHR/tQbNn9vuVstwjkfDOtb/0pNqXbfyEsEEFOgszvcRBFCU/q
suYjAuHi3EOXEIpHJ1/YPjEWwbr9s68Cj1D8Z+rmhOJvITgWmrfVh1MMDZvT
9qsVQlCFk46Es+ErarWfPS2E9uWe9fUoihUXYn103YTwHyPO4KU=
                   "]]}, 
                 Annotation[#, "Charting`Private`Tag$26685#1"]& ]}}, {}}, {
             DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
              AxesOrigin -> {2005., 0.18113214234844854`}, 
              FrameTicks -> {{{}, {}}, {{}, {}}}, GridLines -> {None, None}, 
              DisplayFunction -> Identity, PlotRangePadding -> {{
                 Scaled[0.1], 
                 Scaled[0.1]}, {
                 Scaled[0.1], 
                 Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
              All, DisplayFunction -> Identity, AspectRatio -> 1, 
              Axes -> {False, False}, AxesLabel -> {None, None}, 
              AxesOrigin -> {2005., 0.18113214234844854`}, DisplayFunction :> 
              Identity, Frame -> {{True, True}, {True, True}}, 
              FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
              Directive[
                Opacity[0.5], 
                Thickness[Tiny], 
                RGBColor[0.368417, 0.506779, 0.709798]], 
              FrameTicks -> {{None, None}, {None, None}}, 
              GridLines -> {None, None}, GridLinesStyle -> Directive[
                GrayLevel[0.5, 0.4]], ImageSize -> 
              Dynamic[{
                Automatic, 
                 3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                  Magnification])}], 
              Method -> {
               "DefaultBoundaryStyle" -> Automatic, 
                "DefaultGraphicsInteraction" -> {
                 "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                  "Effects" -> {
                   "Highlight" -> {"ratio" -> 2}, 
                    "HighlightPoint" -> {"ratio" -> 2}, 
                    "Droplines" -> {
                    "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
                "DefaultMeshStyle" -> AbsolutePointSize[6], 
                "ScalingFunctions" -> None, 
                "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& )}}, 
              PlotRange -> {{2005., 2100.}, {0.18113214234844854`, 
               0.6117753130928996}}, PlotRangeClipping -> True, 
              PlotRangePadding -> {{
                 Scaled[0.1], 
                 Scaled[0.1]}, {
                 Scaled[0.1], 
                 Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
            GridBox[{{
               RowBox[{
                 TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox[
                  RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"2005.`", ",", "2100.`"}], "}"}], "}"}], 
                  "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["\"scalar\"", "SummaryItem"]}]}}, 
             GridBoxAlignment -> {
              "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
             False, GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{2}}, "Rows" -> {{Automatic}}},
              BaseStyle -> {
              ShowStringCharacters -> False, NumberMarks -> False, 
               PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
          GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
          GridBoxItemSize -> {
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
          BaselinePosition -> {1, 1}], True -> GridBox[{{
            PaneBox[
             ButtonBox[
              DynamicBox[
               FEPrivate`FrontEndResource[
               "FEBitmaps", "SquareMinusIconMedium"]], 
              ButtonFunction :> (Typeset`open$$ = False), Appearance -> None, 
              BaseStyle -> {}, Evaluator -> Automatic, Method -> 
              "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
             Dynamic[{
               Automatic, 
                3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}]], 
            GraphicsBox[{{{{}, {}, 
                TagBox[{
                  Directive[
                   Opacity[1.], 
                   RGBColor[0.368417, 0.506779, 0.709798], 
                   AbsoluteThickness[1]], 
                  LineBox[CompressedData["
1:eJwV0H08FHYcwPHLjMhDyoTNa+llWYzYbqNw36/WyxmNeV4eWnKymscZqzlP
6YR5qGWo1uv3Y5k0epGY0Oahucyu3Z1znu507mYZISREmf3xeX3+f5sfi/ON
VGMwGM4b/f8MvWgGw58gR0ecG7iXD7HjOlL7YIIvmpWFkfAnxK2t6v97lGDd
5wJr69tCYGXdD7GNImiTqWuVvSQG9m8HrPxjCEqmfcay9fqB47QlbD2RoGeN
hMu0GwAvy/pyx28ItllMHdTSH4JDfpUeSxkE86R80Z6lYTjLZCeXnCO43+Ge
rPyODPJ43Q1dBQQ9Di+ec3cbhR+NigOSiwlGWWDxRQ0F5O0ArV8uEzy2K8P2
j0EF/CwohUFK8PxznoF3yRgouljDaVUEO3tCFl4eUoJqT1d2Qy3B9N1Ong/k
Slj56/vSmNsEU1nbX3snWAUfWRtZb24l6JbGFldfVEHUs0ShXQdB4+Dytzty
VVC2aefwKJ+gS9r6rbojKijlVi+aPtjwkJs1FbyhghsOmUkyCcHn5a59RXeV
sFSlcSpthOBncXzvuo+VsC3nRP7NMYLTKb9vp/IxwOumr3ImCO5juTS0R42B
s2N1UdUMwaV573DVvAK+TB3/ofcpQXWOTmNtigLa1OL1klYJ0uYryx/MPITJ
1Sl3KYOi91XXbUFPRyHDiN/GVKeYxti6oDYhh4YtKwlZmhTVe4cTkhZlIGg2
sbukTZF76W6jr4kM5njhdE6XYp/jtZqyd0dgTbvMxMCAos0npyyWI4bh2sm3
JDsNKdbEHy/trhiCgMkhTNxBkRfg/vKxbBCmzVOb8k0pyuZ+vefkPAhFp9mj
E2YU51cD9xZeHQDjXIa+jjnFnvjOlFDDAWAlbs1804Jiya4T198rlUJsKrsy
yZJiltTYashYCjyIEX9nRREDTFe6bvRDpXlL/bwNxWzBrAPHsR8iRsPEB+wp
nu1XcF8XSEDT78nqYSbF6k3nQztjJdD4qHqgwYHi8VbmgpeeBDyYvm2S/RTr
F7p+irjTB9wQH+W4C0V/boLa5ZN90Fzxdcs+V4pq2gWb60z6YKQ8/4r/QYrp
n3pnGYnFoNlx3/YWm6KgN/JCbI4YRC0hrzA8KXro16e3fiiGM9FyhaEXxZlH
ye25GmJwZmXHR/tQbNn9vuVstwjkfDOtb/0pNqXbfyEsEEFOgszvcRBFCU/q
suYjAuHi3EOXEIpHJ1/YPjEWwbr9s68Cj1D8Z+rmhOJvITgWmrfVh1MMDZvT
9qsVQlCFk46Es+ErarWfPS2E9uWe9fUoihUXYn103YTwHyPO4KU=
                   "]]}, 
                 Annotation[#, "Charting`Private`Tag$26685#1"]& ]}}, {}}, {
             DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
              AxesOrigin -> {2005., 0.18113214234844854`}, 
              FrameTicks -> {{{}, {}}, {{}, {}}}, GridLines -> {None, None}, 
              DisplayFunction -> Identity, PlotRangePadding -> {{
                 Scaled[0.1], 
                 Scaled[0.1]}, {
                 Scaled[0.1], 
                 Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
              All, DisplayFunction -> Identity, AspectRatio -> 1, 
              Axes -> {False, False}, AxesLabel -> {None, None}, 
              AxesOrigin -> {2005., 0.18113214234844854`}, DisplayFunction :> 
              Identity, Frame -> {{True, True}, {True, True}}, 
              FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
              Directive[
                Opacity[0.5], 
                Thickness[Tiny], 
                RGBColor[0.368417, 0.506779, 0.709798]], 
              FrameTicks -> {{None, None}, {None, None}}, 
              GridLines -> {None, None}, GridLinesStyle -> Directive[
                GrayLevel[0.5, 0.4]], ImageSize -> 
              Dynamic[{
                Automatic, 
                 3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                  Magnification])}], 
              Method -> {
               "DefaultBoundaryStyle" -> Automatic, 
                "DefaultGraphicsInteraction" -> {
                 "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                  "Effects" -> {
                   "Highlight" -> {"ratio" -> 2}, 
                    "HighlightPoint" -> {"ratio" -> 2}, 
                    "Droplines" -> {
                    "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
                "DefaultMeshStyle" -> AbsolutePointSize[6], 
                "ScalingFunctions" -> None, 
                "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& )}}, 
              PlotRange -> {{2005., 2100.}, {0.18113214234844854`, 
               0.6117753130928996}}, PlotRangeClipping -> True, 
              PlotRangePadding -> {{
                 Scaled[0.1], 
                 Scaled[0.1]}, {
                 Scaled[0.1], 
                 Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
            GridBox[{{
               RowBox[{
                 TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox[
                  RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"2005.`", ",", "2100.`"}], "}"}], "}"}], 
                  "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["\"scalar\"", "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["3", "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["\"Hermite\"", "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["False", "SummaryItem"]}]}}, 
             GridBoxAlignment -> {
              "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
             False, GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{2}}, "Rows" -> {{Automatic}}},
              BaseStyle -> {
              ShowStringCharacters -> False, NumberMarks -> False, 
               PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
          GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
          GridBoxItemSize -> {
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
          BaselinePosition -> {1, 1}]}, 
       Dynamic[Typeset`open$$], ImageSize -> Automatic]},
     "SummaryPanel"],
    DynamicModuleValues:>{}], "]"}],
  InterpolatingFunction[{{2005., 2100.}}, {
   5, 7, 0, {11}, {4}, 0, 0, 0, 0, Automatic, {}, {}, False}, {{2005., 2010., 
   2020., 2030., 2040., 2050., 2060., 2070., 2080., 2090., 2100.}}, {
   Developer`PackedArrayForm, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11}, {
    0.1811321, 0.300819867, 0.481484033, 0.610934267, 0.5617363, 0.468219733, 
    0.386563667, 0.335608133, 0.300230933, 0.274879, 0.254275633}}, {
   Automatic}],
  Editable->False,
  SelectWithContents->True,
  Selectable->False]], "Output",
 CellChangeTimes->{3.839035991621975*^9, 3.8390360621561203`*^9},
 CellLabel->
  "Out[126]=",ExpressionUUID->"1702dafc-150d-492a-b6aa-034c9bf299f6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fdata19", "[", 
  RowBox[{"[", "84", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.8390360818152995`*^9, 3.8390360922635865`*^9}},
 CellLabel->
  "In[132]:=",ExpressionUUID->"02143397-d874-44a8-9717-ccb742d9832c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2100", ",", "0.254275633`"}], "}"}]], "Output",
 CellChangeTimes->{3.8390360930430565`*^9},
 CellLabel->
  "Out[132]=",ExpressionUUID->"c72bdf31-0760-4b89-a748-21e29d4b667a"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Fdata19", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "474"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "2"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Fdata19", "[", 
    RowBox[{"[", "1", "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"\"\<year\>\"", ",", "\"\<Fex\>\""}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Fdata19", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "1"}], "]"}], "]"}], "=", 
    RowBox[{"2018", "+", "i", "-", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "474"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Fdata19", "[", 
    RowBox[{"[", 
     RowBox[{"2", ",", "2"}], "]"}], "]"}], "=", 
   RowBox[{"Fdata", "[", 
    RowBox[{"[", 
     RowBox[{"2", ",", "10"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Fdata19", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "2"}], "]"}], "]"}], "=", 
    RowBox[{"Fint", "[", 
     RowBox[{"Fdata19", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", "1"}], "]"}], "]"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "3", ",", "84"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Fdata19", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"85", ";;"}], ",", "2"}], "]"}], "]"}], "=", 
   RowBox[{"Fdata19", "[", 
    RowBox[{"[", 
     RowBox[{"84", ",", "2"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.839035692387619*^9, 3.839035836684169*^9}, {
  3.8390358921574535`*^9, 3.839035952523394*^9}, {3.8390360977475357`*^9, 
  3.8390361263217783`*^9}},
 CellLabel->
  "In[907]:=",ExpressionUUID->"a686a423-4f9a-4c1d-a5d3-562de7d26616"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<Fdata19.csv\>\"", ",", "Fdata19"}], "]"}]], "Input",
 CellChangeTimes->{{3.8390418999005637`*^9, 3.839041918396562*^9}},
 CellLabel->
  "In[861]:=",ExpressionUUID->"14d58fa9-58bf-4bd2-aa31-78258ad24add"],

Cell[BoxData["\<\"Fdata19.csv\"\>"], "Output",
 CellChangeTimes->{3.83904191928623*^9, 3.83916926615977*^9},
 CellLabel->
  "Out[861]=",ExpressionUUID->"ee29d568-11db-402e-83c9-0390bf2e5584"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"transEx19", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "474"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "20"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"transEx19", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "1"}], "]"}], "]"}], "=", 
    RowBox[{"2018", "+", "i", "-", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "3", ",", "474"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"transEx19", "[", 
    RowBox[{"[", 
     RowBox[{"1", ";;", "2"}], "]"}], "]"}], "=", 
   RowBox[{"transFairN", "[", 
    RowBox[{"[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "70"}], "}"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"transEx19", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"3", ";;"}], ",", "10"}], "]"}], "]"}], "=", 
   RowBox[{"Fdata19", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"3", ";;"}], ",", "2"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"transEx19", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"3", ";;"}], ",", "7"}], "]"}], "]"}], "=", 
   RowBox[{"transEx19", "[", 
    RowBox[{"[", 
     RowBox[{"2", ",", "7"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"transEx19", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"3", ";;"}], ",", "9"}], "]"}], "]"}], "=", 
   RowBox[{"transEx19", "[", 
    RowBox[{"[", 
     RowBox[{"2", ",", "9"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"transEx19", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"3", ";;"}], ",", "11"}], "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"transEx19", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"3", ";;"}], ",", "9"}], "]"}], "]"}], "+", 
    RowBox[{"transEx19", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"3", ";;"}], ",", "10"}], "]"}], "]"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.8390362182049284`*^9, 3.839036290556758*^9}},
 CellLabel->
  "In[913]:=",ExpressionUUID->"a11da327-3b7d-4613-baa5-fea76b356cbb"],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"transEx19", "[", 
       RowBox[{"[", 
        RowBox[{"i", ",", "12"}], "]"}], "]"}], "=", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"expf", "*", 
          RowBox[{"transEx19", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"i", "-", "1"}], ",", "12"}], "]"}], "]"}]}], "+", 
         RowBox[{"amixf", "*", "intf"}]}], "/.", 
        RowBox[{"f0", "\[Rule]", 
         RowBox[{"transEx19", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"i", "-", "1"}], ",", "11"}], "]"}], "]"}]}]}], "/.", 
       RowBox[{"f1", "\[Rule]", 
        RowBox[{"transEx19", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "11"}], "]"}], "]"}]}]}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"transEx19", "[", 
       RowBox[{"[", 
        RowBox[{"i", ",", "13"}], "]"}], "]"}], "=", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"exps", "*", 
          RowBox[{"transEx19", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"i", "-", "1"}], ",", "13"}], "]"}], "]"}]}], "+", 
         RowBox[{"amixs", "*", "ints"}]}], "/.", 
        RowBox[{"f0", "\[Rule]", 
         RowBox[{"transEx19", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"i", "-", "1"}], ",", "11"}], "]"}], "]"}]}]}], "/.", 
       RowBox[{"f1", "\[Rule]", 
        RowBox[{"transEx19", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "11"}], "]"}], "]"}]}]}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"transEx19", "[", 
       RowBox[{"[", 
        RowBox[{"i", ",", "14"}], "]"}], "]"}], "=", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"expf", "*", 
          RowBox[{"transEx19", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"i", "-", "1"}], ",", "14"}], "]"}], "]"}]}], "+", 
         RowBox[{"adeepf", "*", "intf"}]}], "/.", 
        RowBox[{"f0", "\[Rule]", 
         RowBox[{"transEx19", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"i", "-", "1"}], ",", "11"}], "]"}], "]"}]}]}], "/.", 
       RowBox[{"f1", "\[Rule]", 
        RowBox[{"transEx19", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "11"}], "]"}], "]"}]}]}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"transEx19", "[", 
       RowBox[{"[", 
        RowBox[{"i", ",", "15"}], "]"}], "]"}], "=", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"exps", "*", 
          RowBox[{"transEx19", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"i", "-", "1"}], ",", "15"}], "]"}], "]"}]}], "+", 
         RowBox[{"adeeps", "*", "ints"}]}], "/.", 
        RowBox[{"f0", "\[Rule]", 
         RowBox[{"transEx19", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"i", "-", "1"}], ",", "11"}], "]"}], "]"}]}]}], "/.", 
       RowBox[{"f1", "\[Rule]", 
        RowBox[{"transEx19", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "11"}], "]"}], "]"}]}]}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"transEx19", "[", 
       RowBox[{"[", 
        RowBox[{"i", ",", "16"}], "]"}], "]"}], "=", 
      RowBox[{"Total", "[", 
       RowBox[{"transEx19", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", 
          RowBox[{"12", ";;", "13"}]}], "]"}], "]"}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"transEx19", "[", 
       RowBox[{"[", 
        RowBox[{"i", ",", "17"}], "]"}], "]"}], "=", 
      RowBox[{"Total", "[", 
       RowBox[{"transEx19", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", 
          RowBox[{"14", ";;", "15"}]}], "]"}], "]"}], "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "3", ",", "474"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8390363321234765`*^9, 3.8390363906791067`*^9}},
 CellLabel->
  "In[920]:=",ExpressionUUID->"11404842-6474-449b-9879-18eeba2239b2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dimensions", "[", "Fdata19", "]"}]], "Input",
 CellChangeTimes->{{3.8392116482159214`*^9, 3.8392116699231*^9}},
 CellLabel->
  "In[923]:=",ExpressionUUID->"516f5d0b-61d2-42bd-af8f-07f1392c5dc4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"474", ",", "2"}], "}"}]], "Output",
 CellChangeTimes->{{3.839211658086523*^9, 3.8392116707756433`*^9}},
 CellLabel->
  "Out[923]=",ExpressionUUID->"05b495b4-cc6a-48b8-b128-be1c872a7c0e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"transEx19", "[", 
   RowBox[{"[", 
    RowBox[{"84", ",", "16"}], "]"}], "]"}], "-", 
  RowBox[{"transEx19", "[", 
   RowBox[{"[", 
    RowBox[{"2", ",", "16"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8392180349452653`*^9, 3.839218066593053*^9}},
 CellLabel->
  "In[976]:=",ExpressionUUID->"803c59a1-fc9d-4128-a061-6bb415aefcc2"],

Cell[BoxData["0.2389824179761384`"], "Output",
 CellChangeTimes->{{3.8392180620011053`*^9, 3.839218066979468*^9}},
 CellLabel->
  "Out[976]=",ExpressionUUID->"8ac37916-a1c5-44da-bc78-456274b57db8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"transEx19", "[", 
   RowBox[{"[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "84"}], "}"}], "]"}], "]"}], "//", 
  "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.839036294485796*^9, 3.8390363027788343`*^9}, {
  3.8390363978223357`*^9, 3.839036405425908*^9}},
 CellLabel->
  "In[921]:=",ExpressionUUID->"929c773e-17d6-441e-b48b-8cd4f46157f8"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"\<\"1-Y\"\>", "\<\"2-E\"\>", "\<\"3-R1\"\>", "\<\"4-R2\"\>", "\<\"5-R3\
\"\>", "\<\"6-R4\"\>", "\<\"7-C\"\>", "\<\"8-CCA\"\>", "\<\"9-F\"\>", \
"\<\"10-Fex\"\>", "\<\"11-TF\"\>", "\<\"12-TMF\"\>", "\<\"13-TMS\"\>", \
"\<\"14-TDF\"\>", "\<\"15-TDS\"\>", "\<\"16-TM\"\>", "\<\"17-TD\"\>", \
"\<\"18-\[Alpha]\"\>", "\<\"19-\[Alpha]check\"\>", "\<\"20-atmosGt\"\>"},
     {"2018", "5.106581704241743`", "60.84527854161267`", 
      "45.106832022850945`", "18.885304148918305`", "3.108675660162142`", 
      "409.88136197289793`", "322.468617512415`", "2.0028153469329895`", 
      "0.3513641`", "2.3541794469329895`", "1.0429236211450947`", 
      "0.11303671679122193`", 
      RowBox[{"-", "0.02616954661579638`"}], "0.2647605196419253`", 
      "1.1559603379363166`", "0.23859097302612894`", "0.5487022761077567`", 
      "0.5457696385947219`", "868.9484873825437`"},
     {"2100", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "0.254275633`", "2.2570909799329897`", 
      "1.0884705173116762`", "0.3064722386007787`", 
      RowBox[{"-", "0.027312431481255166`"}], "0.7178353321924106`", 
      "1.394942755912455`", "0.6905229007111554`", "0", "0", "0"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.8390363034738197`*^9, {3.8390363937817144`*^9, 3.83903640618882*^9}, 
   3.8392111529685183`*^9},
 CellLabel->
  "Out[921]//MatrixForm=",ExpressionUUID->"590de729-4964-44ed-a538-\
295703bb6c1b"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"y", "=", "83"}], ",", "\[IndentingNewLine]", 
      RowBox[{"transFairN15", "=", 
       RowBox[{"Table", "[", 
        RowBox[{"0", ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "y"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"j", ",", "20"}], "}"}]}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transFairN15", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "=", 
       RowBox[{"{", 
        RowBox[{
        "\"\<1-Y\>\"", ",", "\"\<2-E\>\"", ",", "\"\<3-R1\>\"", ",", 
         "\"\<4-R2\>\"", ",", "\"\<5-R3\>\"", ",", "\"\<6-R4\>\"", ",", 
         "\"\<7-C\>\"", ",", "\"\<8-CCA\>\"", ",", "\"\<9-F\>\"", ",", 
         "\"\<10-Fex\>\"", ",", "\"\<11-TF\>\"", ",", "\"\<12-TMF\>\"", ",", 
         "\"\<13-TMS\>\"", ",", "\"\<14-TDF\>\"", ",", "\"\<15-TDS\>\"", ",", 
         "\"\<16-TM\>\"", ",", "\"\<17-TD\>\"", ",", "\"\<18-\[Alpha]\>\"", 
         ",", "\"\<19-\[Alpha]check\>\"", ",", "\"\<20-atmosGt\>\""}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"transFairN15", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"n", "+", "1"}], ",", "1"}], "]"}], "]"}], "=", 
         RowBox[{"2019", "-", "1", "+", "n"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"n", ",", "1", ",", 
          RowBox[{"y", "-", "1"}]}], "}"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"emcolumns", "=", 
       RowBox[{"{", "5", "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{
         RowBox[{"transFairG", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;"}], ",", "2"}], "]"}], "]"}], "=", 
         RowBox[{
          RowBox[{"dtemp", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"2", ";;"}], ",", "3"}], "]"}], "]"}], "/", "2.12"}]}], 
        ","}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transFairN15", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;", "y"}], ",", "2"}], "]"}], "]"}], "=", 
       RowBox[{"3", "/", "2.1293970467500096"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transFairN15", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", 
          RowBox[{"{", 
           RowBox[{"3", ",", "4", ",", "5", ",", "6"}], "}"}]}], "]"}], "]"}],
        "=", 
       RowBox[{"transFairN", "[", 
        RowBox[{"[", 
         RowBox[{"70", ",", 
          RowBox[{"3", ";;", "6"}]}], "]"}], "]"}]}], ",", " ", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{
        "initial", " ", "carbon", " ", "values", " ", "for", " ", "R1"}], ",",
         "R2", ",", "R3", ",", "R4"}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transFairN15", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "7"}], "]"}], "]"}], "=", 
       RowBox[{
        RowBox[{"Total", "[", 
         RowBox[{"transFairN15", "[", 
          RowBox[{"[", 
           RowBox[{"2", ",", 
            RowBox[{"3", ";;", "6"}]}], "]"}], "]"}], "]"}], "+", 
        "281.9352715993539"}]}], ",", " ", 
      RowBox[{"(*", 
       RowBox[{"281.9109520290951", ","}], "*)"}], " ", 
      RowBox[{"(*", 
       RowBox[{"276.60278", ",", " ", ".0014091894", ","}], "*)"}], " ", 
      RowBox[{"(*", 
       RowBox[{
       "initial", " ", "atmospheric", " ", "carbon", " ", "concentration"}], 
       "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transFairN15", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "8"}], "]"}], "]"}], "=", 
       RowBox[{"transFairN", "[", 
        RowBox[{"[", 
         RowBox[{"70", ",", "8"}], "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transFairN15", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "9"}], "]"}], "]"}], "=", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"F2x", "/", 
           RowBox[{"Log", "[", "2", "]"}]}], ")"}], "*", 
         RowBox[{"Log", "[", 
          RowBox[{
           RowBox[{"transFairN15", "[", 
            RowBox[{"[", 
             RowBox[{"2", ",", "7"}], "]"}], "]"}], "/", 
           "281.9352715993539"}], "]"}]}], "/.", "parFair"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"fexcolumns", "=", 
       RowBox[{"{", "6", "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transFairN15", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", "10"}], "]"}], "]"}], "=", 
       RowBox[{"Fdata19", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;", "83"}], ",", "2"}], "]"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transFairN15", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", "11"}], "]"}], "]"}], "=", 
       RowBox[{"Total", "[", 
        RowBox[{"transFairN15", "[", 
         RowBox[{"[", 
          RowBox[{"2", ",", 
           RowBox[{"9", ";;", "10"}]}], "]"}], "]"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transFairN15", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", 
          RowBox[{"{", 
           RowBox[{"12", ",", "13", ",", "14", ",", "15"}], "}"}]}], "]"}], 
        "]"}], "=", 
       RowBox[{"transFairN", "[", 
        RowBox[{"[", 
         RowBox[{"70", ",", 
          RowBox[{"12", ";;", "15"}]}], "]"}], "]"}]}], ",", " ", 
      RowBox[{"(*", 
       RowBox[{
       "initial", " ", "values", " ", "for", " ", "Mix", " ", "Layer", " ", 
        "Fast", " ", "and", " ", "Slow", " ", "Response", " ", "and", " ", 
        "Deep", " ", "Layer", " ", "Fast", " ", "and", " ", "Slow", " ", 
        "Response"}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transFairN15", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "16"}], "]"}], "]"}], "=", 
       RowBox[{"Total", "[", 
        RowBox[{"transFairN15", "[", 
         RowBox[{"[", 
          RowBox[{"2", ",", 
           RowBox[{"12", ";;", "13"}]}], "]"}], "]"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transFairN15", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "17"}], "]"}], "]"}], "=", 
       RowBox[{"Total", "[", 
        RowBox[{"transFairN15", "[", 
         RowBox[{"[", 
          RowBox[{"2", ",", 
           RowBox[{"14", ";;", "15"}]}], "]"}], "]"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transFairN15", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", "18"}], "]"}], "]"}], "=", 
       RowBox[{
        RowBox[{"FindRoot", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"rirf", "[", 
            RowBox[{
             RowBox[{"transFairN15", "[", 
              RowBox[{"[", 
               RowBox[{"2", ",", "8"}], "]"}], "]"}], ",", 
             RowBox[{"transFairN15", "[", 
              RowBox[{"[", 
               RowBox[{"2", ",", "16"}], "]"}], "]"}]}], "]"}], "\[Equal]", 
           RowBox[{"lirf", "[", "\[Alpha]", "]"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"\[Alpha]", ",", "0.2"}], "}"}]}], "]"}], "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", "2"}], "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transFairN15", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "19"}], "]"}], "]"}], "=", 
       RowBox[{"transFairN15", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "18"}], "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"transFairN15", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", 
              RowBox[{"3", ";;", "6"}]}], "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{"transFairN15", "[", 
             RowBox[{"[", 
              RowBox[{
               RowBox[{"i", "-", "1"}], ",", 
               RowBox[{"3", ";;", "6"}]}], "]"}], "]"}], "+", 
            RowBox[{"dr", "[", 
             RowBox[{"aFair", ",", "\[Tau]Fair", ",", 
              RowBox[{"transFairN15", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "-", "1"}], ",", "18"}], "]"}], "]"}], ",", 
              RowBox[{"transFairN15", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "-", "1"}], ",", "2"}], "]"}], "]"}], ",", 
              RowBox[{"transFairN15", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "-", "1"}], ",", 
                 RowBox[{"3", ";;", "6"}]}], "]"}], "]"}]}], "]"}]}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"transFairN15", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "7"}], "]"}], "]"}], "=", 
           RowBox[{"281.9352715993539", "+", 
            RowBox[{"Total", "[", 
             RowBox[{"transFairN15", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", 
                RowBox[{"3", ";;", "6"}]}], "]"}], "]"}], "]"}]}]}], ",", 
          RowBox[{
           RowBox[{"transFairN15", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "8"}], "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{"transFairN15", "[", 
             RowBox[{"[", 
              RowBox[{
               RowBox[{"i", "-", "1"}], ",", "8"}], "]"}], "]"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"transFairN15", "[", 
                RowBox[{"[", 
                 RowBox[{
                  RowBox[{"i", "-", "1"}], ",", "2"}], "]"}], "]"}], "-", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"transFairN15", "[", 
                  RowBox[{"[", 
                   RowBox[{"i", ",", "7"}], "]"}], "]"}], "-", 
                 RowBox[{"transFairN15", "[", 
                  RowBox[{"[", 
                   RowBox[{
                    RowBox[{"i", "-", "1"}], ",", "7"}], "]"}], "]"}]}], 
                ")"}]}], ")"}], "*", "2.12"}]}]}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"transFairN15", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "9"}], "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"F2x", "/", 
               RowBox[{"Log", "[", "2", "]"}]}], ")"}], "*", 
             RowBox[{"Log", "[", 
              RowBox[{
               RowBox[{"transFairN15", "[", 
                RowBox[{"[", 
                 RowBox[{"i", ",", "7"}], "]"}], "]"}], "/", 
               "281.9352715993539"}], "]"}]}], "/.", "parFair"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"transFairN15", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "11"}], "]"}], "]"}], "=", 
           RowBox[{"Total", "[", 
            RowBox[{"transFairN15", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", 
               RowBox[{"9", ";;", "10"}]}], "]"}], "]"}], "]"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"transFairN15", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "12"}], "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"expf", "*", 
               RowBox[{"transFairN15", "[", 
                RowBox[{"[", 
                 RowBox[{
                  RowBox[{"i", "-", "1"}], ",", "12"}], "]"}], "]"}]}], "+", 
              RowBox[{"amixf", "*", "intf"}]}], "/.", 
             RowBox[{"f0", "\[Rule]", 
              RowBox[{"transFairN15", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "-", "1"}], ",", "11"}], "]"}], "]"}]}]}], "/.", 
            RowBox[{"f1", "\[Rule]", 
             RowBox[{"transFairN15", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "11"}], "]"}], "]"}]}]}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"transFairN15", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "13"}], "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"exps", "*", 
               RowBox[{"transFairN15", "[", 
                RowBox[{"[", 
                 RowBox[{
                  RowBox[{"i", "-", "1"}], ",", "13"}], "]"}], "]"}]}], "+", 
              RowBox[{"amixs", "*", "ints"}]}], "/.", 
             RowBox[{"f0", "\[Rule]", 
              RowBox[{"transFairN15", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "-", "1"}], ",", "11"}], "]"}], "]"}]}]}], "/.", 
            RowBox[{"f1", "\[Rule]", 
             RowBox[{"transFairN15", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "11"}], "]"}], "]"}]}]}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"transFairN15", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "14"}], "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"expf", "*", 
               RowBox[{"transFairN15", "[", 
                RowBox[{"[", 
                 RowBox[{
                  RowBox[{"i", "-", "1"}], ",", "14"}], "]"}], "]"}]}], "+", 
              RowBox[{"adeepf", "*", "intf"}]}], "/.", 
             RowBox[{"f0", "\[Rule]", 
              RowBox[{"transFairN15", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "-", "1"}], ",", "11"}], "]"}], "]"}]}]}], "/.", 
            RowBox[{"f1", "\[Rule]", 
             RowBox[{"transFairN15", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "11"}], "]"}], "]"}]}]}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"transFairN15", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "15"}], "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"exps", "*", 
               RowBox[{"transFairN15", "[", 
                RowBox[{"[", 
                 RowBox[{
                  RowBox[{"i", "-", "1"}], ",", "15"}], "]"}], "]"}]}], "+", 
              RowBox[{"adeeps", "*", "ints"}]}], "/.", 
             RowBox[{"f0", "\[Rule]", 
              RowBox[{"transFairN15", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"i", "-", "1"}], ",", "11"}], "]"}], "]"}]}]}], "/.", 
            RowBox[{"f1", "\[Rule]", 
             RowBox[{"transFairN15", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "11"}], "]"}], "]"}]}]}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"transFairN15", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "16"}], "]"}], "]"}], "=", 
           RowBox[{"Total", "[", 
            RowBox[{"transFairN15", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", 
               RowBox[{"12", ";;", "13"}]}], "]"}], "]"}], "]"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"transFairN15", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "17"}], "]"}], "]"}], "=", 
           RowBox[{"Total", "[", 
            RowBox[{"transFairN15", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", 
               RowBox[{"14", ";;", "15"}]}], "]"}], "]"}], "]"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"(*", 
           RowBox[{
            RowBox[{
             RowBox[{"transFairG", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", 
                RowBox[{"{", 
                 RowBox[{"11", ",", "12"}], "}"}]}], "]"}], "]"}], "=", 
             RowBox[{
              RowBox[{
               RowBox[{"transT", ".", 
                RowBox[{"transFairG", "[", 
                 RowBox[{"[", 
                  RowBox[{
                   RowBox[{"i", "-", "1"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"11", ",", "12"}], "}"}]}], "]"}], "]"}]}], "+", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"1", ",", "0"}], "}"}], "*", "xi1", "*", 
                RowBox[{"Total", "[", 
                 RowBox[{"transFairG", "[", 
                  RowBox[{"[", 
                   RowBox[{"i", ",", 
                    RowBox[{"9", ";;", "10"}]}], "]"}], "]"}], "]"}]}]}], "/.",
               "parTG"}]}], ","}], "\[IndentingNewLine]", 
           RowBox[{"(*", 
            RowBox[{
             RowBox[{
              RowBox[{"transFairG", "[", 
               RowBox[{"[", 
                RowBox[{"i", ",", "13"}], "]"}], "]"}], "=", 
              RowBox[{"Total", "[", 
               RowBox[{"transFairG", "[", 
                RowBox[{"[", 
                 RowBox[{"i", ",", 
                  RowBox[{"11", ";;", "12"}]}], "]"}], "]"}], "]"}]}], ","}], 
            "*)"}], "*)"}], "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"transFairN15", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "18"}], "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{"FindRoot", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"rirf", "[", 
                RowBox[{
                 RowBox[{"transFairN15", "[", 
                  RowBox[{"[", 
                   RowBox[{"i", ",", "8"}], "]"}], "]"}], ",", 
                 RowBox[{"transFairN15", "[", 
                  RowBox[{"[", 
                   RowBox[{"i", ",", "16"}], "]"}], "]"}]}], "]"}], 
               "\[Equal]", 
               RowBox[{"lirf", "[", "\[Alpha]", "]"}]}], ",", 
              RowBox[{"{", 
               RowBox[{"\[Alpha]", ",", 
                RowBox[{"transFairN15", "[", 
                 RowBox[{"[", 
                  RowBox[{
                   RowBox[{"i", "-", "1"}], ",", "18"}], "]"}], "]"}]}], 
               "}"}]}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "2"}], "]"}], "]"}]}], ",", 
          RowBox[{
           RowBox[{"transFairN15", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "19"}], "]"}], "]"}], "=", 
           RowBox[{
            RowBox[{
             RowBox[{"transFairN15", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"i", "-", "1"}], ",", "19"}], "]"}], "]"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"rT", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"transFairN15", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "16"}], "]"}], "]"}], "-", 
                   RowBox[{"transFairN15", "[", 
                    RowBox[{"[", 
                    RowBox[{
                    RowBox[{"i", "-", "1"}], ",", "16"}], "]"}], "]"}]}], 
                  ")"}]}], "+", 
                RowBox[{"rc", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"transFairN15", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "8"}], "]"}], "]"}], "-", 
                   RowBox[{"transFairN15", "[", 
                    RowBox[{"[", 
                    RowBox[{
                    RowBox[{"i", "-", "1"}], ",", "8"}], "]"}], "]"}]}], 
                  ")"}]}]}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{"dalpha", "[", 
                RowBox[{"transFairN15", "[", 
                 RowBox[{"[", 
                  RowBox[{
                   RowBox[{"i", "-", "1"}], ",", "19"}], "]"}], "]"}], "]"}], 
               ")"}]}]}], "/.", "parFair"}]}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "3", ",", "83"}], "}"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"transFairN15", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"2", ";;"}], ",", "20"}], "]"}], "]"}], "=", 
       RowBox[{
        RowBox[{"transFairN15", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"2", ";;"}], ",", "7"}], "]"}], "]"}], "*", "2.12"}]}]}], 
     "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", "1", ",", "1"}], "}"}]}], "]"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.8390358409925165`*^9, 3.8390358540432453`*^9}, 
   3.8390361443902717`*^9, 3.8392111852233524`*^9, {3.8392112332702155`*^9, 
   3.839211508513281*^9}, {3.8392115404320183`*^9, 3.8392116065886335`*^9}, {
   3.8392116870816746`*^9, 3.8392117063776627`*^9}, {3.8392118713589463`*^9, 
   3.839211875960139*^9}, {3.839212186562964*^9, 3.8392121893690844`*^9}, {
   3.8392126113273325`*^9, 3.8392126215258045`*^9}, {3.839212703149372*^9, 
   3.8392127344705954`*^9}},
 CellLabel->
  "In[971]:=",ExpressionUUID->"d4f1f33c-577b-4386-acc3-3a83e0eeac7d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"transFairN15", "[", 
   RowBox[{"[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "83"}], "}"}], "]"}], "]"}], "//", 
  "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.8392126367347*^9, 3.8392126814009657`*^9}, {
  3.839212741740838*^9, 3.8392127436046157`*^9}},
 CellLabel->
  "In[972]:=",ExpressionUUID->"4460af13-c6f7-4664-bb0d-a694ac73921a"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"\<\"1-Y\"\>", "\<\"2-E\"\>", "\<\"3-R1\"\>", "\<\"4-R2\"\>", "\<\"5-R3\
\"\>", "\<\"6-R4\"\>", "\<\"7-C\"\>", "\<\"8-CCA\"\>", "\<\"9-F\"\>", \
"\<\"10-Fex\"\>", "\<\"11-TF\"\>", "\<\"12-TMF\"\>", "\<\"13-TMS\"\>", \
"\<\"14-TDF\"\>", "\<\"15-TDS\"\>", "\<\"16-TM\"\>", "\<\"17-TD\"\>", \
"\<\"18-\[Alpha]\"\>", "\<\"19-\[Alpha]check\"\>", "\<\"20-atmosGt\"\>"},
     {"2019", "1.4088495166172732`", "60.84527854161267`", 
      "45.106832022850945`", "18.885304148918305`", "3.108675660162142`", 
      "409.88136197289793`", "322.468617512415`", "2.0028153469329895`", 
      "0.3513641`", "2.3541794469329895`", "1.0429236211450947`", 
      "0.11303671679122193`", 
      RowBox[{"-", "0.02616954661579638`"}], "0.2647605196419253`", 
      "1.1559603379363166`", "0.23859097302612894`", "0.5487022761085889`", 
      "0.5487022761085889`", "868.9484873825437`"},
     {"2100", "1.4088495166172732`", "85.6348413198252`", 
      "56.55228269699198`", "11.92959701793151`", "1.474662568613561`", 
      "437.52665520271614`", "505.78823485871834`", "2.3521657257081316`", 
      "0.2562726702085`", "2.6084383959166315`", "1.2456451156401307`", 
      "0.31693185409354485`", 
      RowBox[{"-", "0.031256332927517755`"}], "0.742334391539954`", 
      "1.5625769697336755`", "0.7110780586124362`", "0.8963566591935924`", 
      "0.8951316356879575`", "927.5565090297582`"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.8392126598719754`*^9, 3.839212681741377*^9}, 
   3.8392127440798836`*^9},
 CellLabel->
  "Out[972]//MatrixForm=",ExpressionUUID->"12938992-a06d-4426-b951-\
1165a2c5ef39"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"82", "*", "3"}]], "Input",
 CellChangeTimes->{{3.839212762524849*^9, 3.8392127812377014`*^9}},
 CellLabel->
  "In[974]:=",ExpressionUUID->"92287a7f-f016-4b36-bbee-d76a04284e26"],

Cell[BoxData["246"], "Output",
 CellChangeTimes->{3.8392127818132*^9},
 CellLabel->
  "Out[974]=",ExpressionUUID->"ca2d3a1e-a545-4175-9d34-4e0d3a5bc265"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dimensions", "[", 
  RowBox[{"Fdata19", "[", 
   RowBox[{"[", 
    RowBox[{
     RowBox[{"2", ";;", "82"}], ",", "2"}], "]"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.8392118007061043`*^9, 3.839211824671611*^9}},
 CellLabel->
  "In[929]:=",ExpressionUUID->"6e534521-680e-40a8-922e-93ff49631ea2"],

Cell[BoxData[
 RowBox[{"{", "81", "}"}]], "Output",
 CellChangeTimes->{{3.8392118201206074`*^9, 3.8392118251041346`*^9}},
 CellLabel->
  "Out[929]=",ExpressionUUID->"defdef76-79fc-4f97-b217-b41335b5f923"]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.8390332035043645`*^9, 
  3.839033230594761*^9}},ExpressionUUID->"ef92775f-2d49-4601-952f-\
dfb77a1ac1af"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"transFairN15", "[", 
  RowBox[{"[", "2", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.839211720914155*^9, 3.8392117336113567`*^9}},
 CellLabel->
  "In[931]:=",ExpressionUUID->"5a62d82f-1159-4c23-afb7-0ea573175cd2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2019", ",", "1.4088495166172732`", ",", "60.84527854161267`", ",", 
   "45.106832022850945`", ",", "18.885304148918305`", ",", 
   "3.108675660162142`", ",", "409.88136197289793`", ",", "322.468617512415`",
    ",", "2.0028153469329895`", ",", "0.3513641`", ",", 
   RowBox[{"{", 
    RowBox[{
    "2.3541794469329895`", ",", "2.4690735345345893`", ",", 
     "2.4842993799329895`", ",", "2.5016516957114896`", ",", 
     "2.5183644379009893`", ",", "2.5343101722324892`", ",", 
     "2.5493614644369895`", ",", "2.5633908802454894`", ",", 
     "2.5762709853889896`", ",", "2.5878743455984896`", ",", 
     "2.5980735266049892`", ",", "2.6067410941394895`", ",", 
     "2.613749613932989`", ",", "2.6146525478614895`", ",", 
     "2.6139033293809897`", ",", "2.6116362880924893`", ",", 
     "2.6079857535969895`", ",", "2.6030860554954893`", ",", 
     "2.5970715233889896`", ",", "2.5900764868784893`", ",", 
     "2.5822352755649893`", ",", "2.5736822190494895`", ",", 
     "2.5645516469329896`", ",", "2.5562673720664897`", ",", 
     "2.5475960903009893`", ",", "2.5385939807374895`", ",", 
     "2.5293172224769895`", ",", "2.5198219946204894`", ",", 
     "2.510164476268989`", ",", "2.5004008465234895`", ",", 
     "2.4905872844849894`", ",", "2.4807799692544896`", ",", 
     "2.4710350799329897`", ",", "2.4620248902764894`", ",", 
     "2.4531521456609893`", ",", "2.4444356861174894`", ",", 
     "2.4358943516769895`", ",", "2.4275469823704894`", ",", 
     "2.4194124182289896`", ",", "2.4115094992834893`", ",", 
     "2.4038570655649893`", ",", "2.3964739571044893`", ",", 
     "2.3893790139329893`", ",", "2.3831514528599893`", ",", 
     "2.3772157749089895`", ",", "2.3715568578819894`", ",", 
     "2.3661595795809895`", ",", "2.3610088178079893`", ",", 
     "2.3560894503649896`", ",", "2.3513863550539895`", ",", 
     "2.3468844096769894`", ",", "2.3425684920359893`", ",", 
     "2.3384234799329895`", ",", "2.3342763605084893`", ",", 
     "2.3302794713569894`", ",", "2.3264272594114894`", ",", 
     "2.3227141716049893`", ",", "2.3191346548704894`", ",", 
     "2.3156831561409894`", ",", "2.3123541223494897`", ",", 
     "2.3091420004289893`", ",", "2.3060412373124892`", ",", 
     "2.3030462799329894`", ",", "2.3001470151844896`", ",", 
     "2.2973427264049895`", ",", "2.2946281368934893`", ",", 
     "2.2919979699489894`", ",", "2.2894469488704896`", ",", 
     "2.2869697969569893`", ",", "2.2845612375074893`", ",", 
     "2.2822159938209894`", ",", "2.2799287891964894`", ",", 
     "2.2776943469329893`", ",", "2.2755073903294893`", ",", 
     "2.2733626426849893`", ",", "2.2712548272984896`", ",", 
     "2.2691786674689896`", ",", "2.2671288864954895`", ",", 
     "2.2651002076769893`", ",", "2.2630873543124896`", ",", 
     "2.2610850497009896`", ",", "2.2590880171414893`", ",", 
     "2.2570909799329897`"}], "}"}], ",", "1.0429236211450947`", ",", 
   "0.11303671679122193`", ",", 
   RowBox[{"-", "0.02616954661579638`"}], ",", "0.2647605196419253`", ",", 
   "1.1559603379363166`", ",", "0.23859097302612894`", ",", 
   "0.5487022761085889`", ",", "0.5487022761085889`", ",", "0"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.8392117279568996`*^9, 3.8392117340549917`*^9}, 
   3.839211892352155*^9},
 CellLabel->
  "Out[931]=",ExpressionUUID->"bafcc331-a3aa-41dc-ab16-5579b972ed7b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"transEx", "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.839032426923333*^9, 3.839032434311928*^9}, {
  3.8390331162525187`*^9, 3.8390331527719793`*^9}},
 CellLabel->"In[94]:=",ExpressionUUID->"5614ee89-a86e-4e1c-82c3-242295feea85"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"\<\"1-Y\"\>", "\<\"2-E\"\>", "\<\"3-R1\"\>", "\<\"4-R2\"\>", "\<\"5-R3\
\"\>", "\<\"6-R4\"\>", "\<\"7-C\"\>", "\<\"8-CCA\"\>", "\<\"9-F\"\>", \
"\<\"10-Fex\"\>", "\<\"11-TF\"\>", "\<\"12-TMF\"\>", "\<\"13-TMS\"\>", \
"\<\"14-TDF\"\>", "\<\"15-TDS\"\>", "\<\"16-TM\"\>", "\<\"17-TD\"\>", \
"\<\"18-\[Alpha]\"\>", "\<\"19-\[Alpha]check\"\>", "\<\"20-atmosGt\"\>"},
     {"2018", "5.106581704241743`", "60.84527854161267`", 
      "45.106832022850945`", "18.885304148918305`", "3.108675660162142`", 
      "409.88136197289793`", "322.468617512415`", "2.0028153469329895`", 
      "0.3513641`", "2.3541794469329895`", "1.0429236211450947`", 
      "0.11303671679122193`", 
      RowBox[{"-", "0.02616954661579638`"}], "0.2647605196419253`", 
      "1.1559603379363166`", "0.23859097302612894`", "0.5487022761077567`", 
      "0.5457696385947219`", "868.9484873825437`"},
     {"2019", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "0.3513641`", "2.3541794469329895`", 
      "1.062521389040098`", "0.11567693568937096`", 
      RowBox[{"-", "0.026661303337089874`"}], "0.27094457865642646`", 
      "1.178198324729469`", "0.24428327531933658`", "0", "0", "0"},
     {"2020", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "0.360530767`", "2.363346113932989`", 
      "1.0782766762487104`", "0.1183137883476738`", 
      RowBox[{"-", "0.027056642664622165`"}], "0.277120753087615`", 
      "1.196590464596384`", "0.25006411042299287`", "0", "0", "0"},
     {"2021", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "0.369697433`", "2.3725127799329897`", 
      "1.0915113649138057`", "0.12095319718149476`", 
      RowBox[{"-", "0.027388733907877823`"}], "0.2833029147270107`", 
      "1.2124645620953005`", "0.25591418081913286`", "0", "0", "0"},
     {"2022", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "0.3788641`", "2.3816794469329894`", 
      "1.1027851913747688`", "0.12359515320259104`", 
      RowBox[{"-", "0.027671622243252408`"}], "0.2894910425218803`", 
      "1.2263803445773598`", "0.26181942027862787`", "0", "0", "0"},
     {"2023", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "0.388030767`", "2.3908461139329895`", 
      "1.1125335942519647`", "0.1262396474549925`", 
      RowBox[{"-", "0.027916233908336988`"}], "0.29568511549508136`", 
      "1.2387732417069572`", "0.2677688815867444`", "0", "0", "0"},
     {"2024", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "0.397197433`", "2.4000127799329896`", 
      "1.1210953164475836`", "0.1288866710129692`", 
      RowBox[{"-", "0.028131068804744593`"}], "0.3018851127403017`", 
      "1.249981987460553`", "0.27375404393555713`", "0", "0", "0"},
     {"2025", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "0.4063641`", "2.4091794469329892`", 
      "1.128733878032437`", "0.13153621498271897`", 
      RowBox[{"-", "0.028322739306226734`"}], "0.308091013426012`", 
      "1.260270093015156`", "0.2797682741197852`", "0", "0", "0"},
     {"2026", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "0.415530767`", "2.4183461139329894`", 
      "1.1356542805792653`", "0.134188270502422`", 
      RowBox[{"-", "0.02849638941192715`"}], "0.31430279679559353`", 
      "1.2698425510816873`", "0.28580640738366636`", "0", "0", "0"},
     {"2027", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "0.424697433`", "2.4275127799329894`", 
      "1.1420160019108154`", "0.13684282874004247`", 
      RowBox[{"-", "0.02865602081691912`"}], "0.32052044216218933`", 
      "1.278858830650858`", "0.29186442134527024`", "0", "0", "0"},
     {"2028", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "0.4338641`", "2.4366794469329895`", 
      "1.1479431054912517`", "0.13949988089535142`", 
      RowBox[{"-", "0.028804746581970422`"}], "0.3267439289134422`", 
      "1.287442986386603`", "0.2979391823314718`", "0", "0", "0"},
     {"2029", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "0.443030767`", "2.4458461139329897`", 
      "1.1535321046969624`", "0.1421594181996481`", 
      RowBox[{"-", "0.02894498846765032`"}], "0.3329732365108419`", 
      "1.2956915228966106`", "0.30402824804319156`", "0", "0", "0"},
     {"2030", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "0.452197433`", "2.4550127799329893`", 
      "1.1588580805692816`", "0.14482143191381344`", 
      RowBox[{"-", "0.029078630443955575`"}], "0.3392083444851658`", 
      "1.303679512483095`", "0.3101297140412102`", "0", "0", "0"},
     {"2031", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "0.4613641`", "2.4641794469329894`", 
      "1.16397944134948`", "0.14748591333012506`", 
      RowBox[{"-", "0.029207138118876732`"}], "0.34544923244073056`", 
      "1.311465354679605`", "0.31624209432185385`", "0", "0", "0"},
     {"2032", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "0.470530767`", "2.4733461139329895`", 
      "1.1689416249082112`", "0.15015285377202187`", 
      RowBox[{"-", "0.029331651641558067`"}], "0.3516958800548401`", 
      "1.319094478680233`", "0.32236422841328205`", "0", "0", "0"},
     {"2033", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "0.479697433`", "2.4825127799329896`", 
      "1.1737799788555396`", "0.15282224459228383`", 
      RowBox[{"-", "0.029453057971418842`"}], "0.35794826707352273`", 
      "1.3266022234478234`", "0.3284952091021039`", "0", "0", "0"},
     {"2034", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "0.4888641`", "2.4916794469329897`", 
      "1.1785220013998834`", "0.1554940771746811`", 
      RowBox[{"-", "0.029572047106875478`"}], "0.3642063733153936`", 
      "1.3340160785745645`", "0.3346343262085181`", "0", "0", "0"},
     {"2035", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "0.498030767`", "2.5008461139329894`", 
      "1.1831890844108186`", "0.1581683429338233`", 
      RowBox[{"-", "0.029689155823121028`"}], "0.37047017867130144`", 
      "1.3413574273446418`", "0.3407810228481804`", "0", "0", "0"},
     {"2036", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "0.507197433`", "2.5100127799329894`", 
      "1.187797869268934`", "0.16084503331338235`", 
      RowBox[{"-", "0.02980480169376897`"}], "0.37673966310016643`", 
      "1.3486429025823163`", "0.34693486140639745`", "0", "0", "0"},
     {"2037", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "0.5163641`", "2.5191794469329896`", 
      "1.1923613019491928`", "0.1635241397876589`", 
      RowBox[{"-", "0.029919309565517967`"}], "0.3830148066326491`", 
      "1.3558854417368518`", "0.3530954970671311`", "0", "0", "0"},
     {"2038", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "0.525530767`", "2.5283461139329892`", 
      "1.1968894536272416`", "0.16620565386172517`", 
      RowBox[{"-", "0.030032932149204387`"}], "0.38929558937148445`", 
      "1.3630951074889668`", "0.35926265722228007`", "0", "0", "0"},
     {"2039", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "0.534697433`", "2.5375127799329897`", 
      "1.201390158917927`", "0.16888956706902206`", 
      RowBox[{"-", "0.030145866034793467`"}], "0.39558199148585416`", 
      "1.370279725986949`", "0.3654361254510607`", "0", "0", "0"},
     {"2040", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "0.5438641`", "2.5466794469329894`", 
      "1.2058695127035766`", "0.17157587097359567`", 
      RowBox[{"-", "0.030258264158036178`"}], "0.40187399321662515`", 
      "1.3774453836771723`", "0.371615729058589`", "0", "0", "0"},
     {"2041", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "0.553030767`", "2.5558461139329895`", 
      "1.2103322564540508`", "0.17426455716965594`", 
      RowBox[{"-", "0.030370245494199758`"}], "0.40817157487531563`", 
      "1.3845968136237068`", "0.3778013293811159`", "0", "0", "0"},
     {"2042", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "0.562197433`", "2.5650127799329896`", 
      "1.2147820786187218`", "0.17695561727976017`", 
      RowBox[{"-", "0.030481902595649334`"}], "0.41447471683984033`", 
      "1.391737695898482`", "0.383992814244191`", "0", "0", "0"},
     {"2043", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "0.5713641`", "2.5741794469329893`", 
      "1.2192218486320496`", "0.17964904295650713`", 
      RowBox[{"-", "0.030593307463629628`"}], "0.420783399558479`", 
      "1.3988708915885568`", "0.39019009209484934`", "0", "0", "0"},
     {"2044", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "0.580530767`", "2.5833461139329894`", 
      "1.2236537987746259`", "0.18234482588259845`", 
      RowBox[{"-", "0.030704516111610666`"}], "0.42709760355001947`", 
      "1.4059986246572242`", "0.3963930874384088`", "0", "0", "0"},
     {"2045", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "0.589697433`", "2.5925127799329895`", 
      "1.2280796655092865`", "0.18504295776864668`", 
      RowBox[{"-", "0.030815572111762272`"}], "0.4334173093986244`", 
      "1.4131226232779333`", "0.4026017372868621`", "0", "0", "0"},
     {"2046", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "0.5988641`", "2.6016794469329896`", 
      "1.2325007997515516`", "0.18774343035495464`", 
      RowBox[{"-", "0.030926509361913553`"}], "0.4397424977579982`", 
      "1.4202442301065061`", "0.40881598839608463`", "0", "0", "0"},
     {"2047", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "0.608030767`", "2.6108461139329897`", 
      "1.236918252472752`", "0.1904462354116612`", 
      RowBox[{"-", "0.031037354233548163`"}], "0.4460731493517291`", 
      "1.4273644878844132`", "0.41503579511818095`", "0", "0", "0"},
     {"2048", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "0.617197433`", "2.6200127799329893`", 
      "1.2413328411537257`", "0.19315136473642538`", 
      RowBox[{"-", "0.031148127239292785`"}], "0.4524092449678643`", 
      "1.434484205890151`", "0.4212611177285715`", "0", "0", "0"},
     {"2049", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "0.6263641`", "2.6291794469329894`", 
      "1.2457452018015926`", "0.19585881015645717`", 
      RowBox[{"-", "0.03125884433814733`"}], "0.4587507654636669`", 
      "1.4416040119580498`", "0.42749192112551954`", "0", "0", "0"},
     {"2050", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "0.635530767`", "2.6383461139329896`", 
      "1.2501558292353105`", "0.19856856352845537`", 
      RowBox[{"-", "0.03136951794634968`"}], "0.4650976917654701`", 
      "1.4487243927637659`", "0.43372817381912043`", "0", "0", "0"},
     {"2051", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "0.644697433`", "2.6475127799329896`", 
      "1.254565108285235`", "0.20128061673629272`", 
      RowBox[{"-", "0.03148015772025024`"}], "0.4714500048632558`", 
      "1.4558457250215278`", "0.4399698471430055`", "0", "0", "0"},
     {"2052", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "0.6538641`", "2.6566794469329893`", 
      "1.2589733383844717`", "0.20399496169313164`", 
      RowBox[{"-", "0.03159077117337011`"}], "0.4778076858156091`", 
      "1.4629683000776033`", "0.446216914642239`", "0", "0", "0"},
     {"2053", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "0.663030767`", "2.6658461139329894`", 
      "1.2633807525192156`", "0.20671159034107073`", 
      RowBox[{"-", "0.03170136415191216`"}], "0.48417071574889137`", 
      "1.4700923428602863`", "0.4524693515969792`", "0", "0", "0"},
     {"2054", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "0.672197433`", "2.6750127799329895`", 
      "1.267787531830917`", "0.20943049464949953`", 
      RowBox[{"-", "0.031811941201165754`"}], "0.490539075853386`", 
      "1.4772180264804167`", "0.45872713465222026`", "0", "0", "0"},
     {"2055", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "0.6813641`", "2.6841794469329896`", 
      "1.2721938172959222`", "0.21215166661646268`", 
      RowBox[{"-", "0.031922505858577914`"}], "0.49691274738649405`", 
      "1.4843454839123849`", "0.4649902415279161`", "0", "0", "0"},
     {"2056", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "0.690530767`", "2.6933461139329893`", 
      "1.2765997186313411`", "0.21487509826885118`", 
      RowBox[{"-", "0.032033060877223726`"}], "0.5032917116731819`", 
      "1.4914748169001923`", "0.47125865079595813`", "0", "0", "0"},
     {"2057", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "0.699697433`", "2.7025127799329893`", 
      "1.2810053210832713`", "0.2176007816602985`", 
      RowBox[{"-", "0.0321436083961397`"}], "0.5096759501010535`", 
      "1.4986061027435698`", "0.47753234170491377`", "0", "0", "0"},
     {"2058", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "0.7088641`", "2.7116794469329895`", 
      "1.2854106910276908`", "0.22032870887308903`", 
      RowBox[{"-", "0.032254150080864165`"}], "0.5160654441248206`", 
      "1.5057393999007798`", "0.4838112940439564`", "0", "0", "0"},
     {"2059", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "0.718030767`", "2.7208461139329896`", 
      "1.2898158801474657`", "0.22305887201797384`", 
      RowBox[{"-", "0.032364687228248715`"}], "0.5224601752658711`", 
      "1.5128747521654395`", "0.4900954880376224`", "0", "0", "0"},
     {"2060", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "0.727197433`", "2.7300127799329896`", 
      "1.294220928541812`", "0.2257912632321099`", 
      RowBox[{"-", "0.032475220844482386`"}], "0.5288601251074422`", 
      "1.520012191773922`", "0.4963849042629598`", "0", "0", "0"},
     {"2061", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "0.7363641`", "2.7391794469329893`", 
      "1.2986258674653621`", "0.22852587468101138`", 
      RowBox[{"-", "0.032585751713821616`"}], "0.5352652752991907`", 
      "1.5271517421463736`", "0.502679523585369`", "0", "0", "0"},
     {"2062", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "0.745530767`", "2.7483461139329894`", 
      "1.303030721278851`", "0.2312626985582831`", 
      RowBox[{"-", "0.03269628044753781`"}], "0.5416756075565688`", 
      "1.534293419837134`", "0.508979327109031`", "0", "0", "0"},
     {"2063", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "0.754697433`", "2.7575127799329895`", 
      "1.3074355088266512`", "0.2340017270837695`", 
      RowBox[{"-", "0.032806807518483104`"}], "0.5480911036564888`", 
      "1.5414372359104207`", "0.5152842961380057`", "0", "0", "0"},
     {"2064", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "0.7638641`", "2.7666794469329896`", 
      "1.311840244828504`", "0.23674295250525645`", 
      RowBox[{"-", "0.03291733329601243`"}], "0.5545117454413084`", 
      "1.5485831973337605`", "0.521594412145296`", "0", "0", "0"},
     {"2065", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "0.773030767`", "2.7758461139329893`", 
      "1.3162449407820733`", "0.23948636709853957`", 
      RowBox[{"-", "0.03302785806863076`"}], "0.5609375148189917`", 
      "1.555731307880613`", "0.527909656750361`", "0", "0", "0"},
     {"2066", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "0.782197433`", "2.7850127799329893`", 
      "1.3206496055250931`", "0.24223196316524015`", 
      RowBox[{"-", "0.0331383820580988`"}], "0.5673683937579925`", 
      "1.5628815686903332`", "0.5342300116998937`", "0", "0", "0"},
     {"2067", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "0.7913641`", "2.7941794469329895`", 
      "1.3250542459927899`", "0.24497973303459145`", 
      RowBox[{"-", "0.03324890543843863`"}], "0.5738043642914393`", 
      "1.5700339790273814`", "0.5405554588530007`", "0", "0", "0"},
     {"2068", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "0.800530767`", "2.8033461139329896`", 
      "1.32945886762698`", "0.24772966906359198`", 
      RowBox[{"-", "0.03335942834619896`"}], "0.5802454085174936`", 
      "1.577188536690572`", "0.5468859801712946`", "0", "0", "0"},
     {"2069", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "0.809697433`", "2.812512779932989`", 
      "1.3338634745543425`", "0.2504817636346968`", 
      RowBox[{"-", "0.033469950884928414`"}], "0.5866915085939427`", 
      "1.5843452381890393`", "0.5532215577090143`", "0", "0", "0"},
     {"2070", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "0.8188641`", "2.8216794469329893`", 
      "1.3382680700452072`", "0.2532360091578975`", 
      RowBox[{"-", "0.0335804731366877`"}], "0.5931426467430709`", 
      "1.5915040792031048`", "0.5595621736063833`", "0", "0", "0"},
     {"2071", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "0.828030767`", "2.8308461139329895`", 
      "1.3426726566903389`", "0.2559923980705415`", 
      RowBox[{"-", "0.033690995166485556`"}], "0.5995988052512377`", 
      "1.5986650547608803`", "0.5659078100847521`", "0", "0", "0"},
     {"2072", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "0.837197433`", "2.8400127799329895`", 
      "1.3470772363984826`", "0.2587509228351506`", 
      RowBox[{"-", "0.033801517022217134`"}], "0.6060599664637663`", 
      "1.6058281592336332`", "0.5722584494415491`", "0", "0", "0"},
     {"2073", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "0.8463641`", "2.8491794469329896`", 
      "1.3514818107145603`", "0.26151157594145946`", 
      RowBox[{"-", "0.03391203874264837`"}], "0.6125261127897199`", 
      "1.6129933866560198`", "0.5786140740470715`", "0", "0", "0"},
     {"2074", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "0.855530767`", "2.8583461139329893`", 
      "1.3558863808870798`", "0.26427434990619514`", 
      RowBox[{"-", "0.03402256035910744`"}], "0.6189972267013848`", 
      "1.620160730793275`", "0.5849746663422773`", "0", "0", "0"},
     {"2075", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "0.864697433`", "2.8675127799329894`", 
      "1.3602909477805998`", "0.2670392372712716`", 
      RowBox[{"-", "0.034133081893288245`"}], "0.6254732907300411`", 
      "1.6273301850518713`", "0.5913402088367529`", "0", "0", "0"},
     {"2076", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "0.8738641`", "2.8766794469329895`", 
      "1.3646955121277318`", "0.26980623060532827`", 
      RowBox[{"-", "0.034243603363573856`"}], "0.6319542874695667`", 
      "1.6345017427330601`", "0.5977106841059928`", "0", "0", "0"},
     {"2077", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "0.883030767`", "2.8858461139329896`", 
      "1.369100074545058`", "0.2725753225038444`", 
      RowBox[{"-", "0.03435412478543585`"}], "0.6384401995767054`", 
      "1.6416753970489024`", "0.6040860747912695`", "0", "0", "0"},
     {"2078", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "0.892197433`", "2.8950127799329897`", 
      "1.3735046354055407`", "0.27534650558695917`", 
      RowBox[{"-", "0.03446464616823275`"}], "0.6449310097659603`", 
      "1.6488511409925`", "0.6104663635977275`", "0", "0", "0"},
     {"2079", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "0.9013641`", "2.9041794469329894`", 
      "1.377909195059361`", "0.2781197725015122`", 
      RowBox[{"-", "0.034575167520751494`"}], "0.6514267008143741`", 
      "1.6560289675608733`", "0.6168515332936226`", "0", "0", "0"},
     {"2080", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "0.910530767`", "2.9133461139329895`", 
      "1.382313753825596`", "0.2808951159207831`", 
      RowBox[{"-", "0.03468568885099852`"}], "0.6579272555609185`", 
      "1.6632088697463792`", "0.6232415667099199`", "0", "0", "0"},
     {"2081", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "0.919697433`", "2.9225127799329895`", 
      "1.3867183118457655`", "0.28367252854256264`", 
      RowBox[{"-", "0.034796210162524904`"}], "0.6644326569019764`", 
      "1.670390840388328`", "0.6296364467394515`", "0", "0", "0"},
     {"2082", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "0.9288641`", "2.931679446932989`", 
      "1.3911228692900064`", "0.2864520030909859`", 
      RowBox[{"-", "0.03490673145959981`"}], "0.6709428877956358`", 
      "1.6775748723809922`", "0.636036156336036`", "0", "0", "0"},
     {"2083", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "0.938030767`", "2.9408461139329893`", 
      "1.3955274263373327`", "0.2892335323163559`", 
      RowBox[{"-", "0.03501725274671515`"}], "0.6774579312612767`", 
      "1.6847609586536887`", "0.6424406785145615`", "0", "0", "0"},
     {"2084", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "0.947197433`", "2.9500127799329894`", 
      "1.3999319830203034`", "0.29201710899317446`", 
      RowBox[{"-", "0.03512777402468789`"}], "0.6839777703749589`", 
      "1.6919490920134779`", "0.648849996350271`", "0", "0", "0"},
     {"2085", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "0.9563641`", "2.9591794469329895`", 
      "1.4043365394242895`", "0.29480272592197604`", 
      RowBox[{"-", "0.03523829529566022`"}], "0.6905023882737169`", 
      "1.6991392653462656`", "0.6552640929780567`", "0", "0", "0"},
     {"2086", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "0.965530767`", "2.9683461139329896`", 
      "1.4087410956623645`", "0.2975903759293197`", 
      RowBox[{"-", "0.03534881656246942`"}], "0.6970317681555417`", 
      "1.7063314715916842`", "0.6616829515930722`", "0", "0", "0"},
     {"2087", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "0.974697433`", "2.9775127799329892`", 
      "1.4131456517157899`", "0.30038005186569516`", 
      RowBox[{"-", "0.03545933782464532`"}], "0.7035658932744757`", 
      "1.713525703581485`", "0.6681065554498304`", "0", "0", "0"},
     {"2088", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "0.9838641`", "2.9866794469329894`", 
      "1.4175502076300308`", "0.30317174660735763`", 
      RowBox[{"-", "0.03556985908332872`"}], "0.7101047469449105`", 
      "1.7207219542373884`", "0.6745348878615818`", "0", "0", "0"},
     {"2089", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "0.993030767`", "2.9958461139329895`", 
      "1.4219547634871157`", "0.30596545305632056`", 
      RowBox[{"-", "0.03568038034057794`"}], "0.7166483125415705`", 
      "1.7279202165434362`", "0.6809679322009925`", "0", "0", "0"},
     {"2090", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.002197433`", "3.0050127799329895`", 
      "1.4263593192441555`", "0.3087611641381376`", 
      RowBox[{"-", "0.035790901595316775`"}], "0.7231965734943164`", 
      "1.735120483382293`", "0.6874056718989997`", "0", "0", "0"},
     {"2091", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.0113641`", "3.0141794469329897`", 
      "1.4307638749278273`", "0.31155887280394734`", 
      RowBox[{"-", "0.03590142284821463`"}], "0.7297495132929362`", 
      "1.7423227477317746`", "0.6938480904447216`", "0", "0", "0"},
     {"2092", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.020530767`", "3.0233461139329894`", 
      "1.4351684306055446`", "0.31435857203030004`", 
      RowBox[{"-", "0.03601194410096307`"}], "0.7363071154867377`", 
      "1.7495270026358445`", "0.7002951713857746`", "0", "0", "0"},
     {"2093", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.029697433`", "3.0325127799329894`", 
      "1.439572986223048`", "0.3171602548172324`", 
      RowBox[{"-", "0.036122465352200595`"}], "0.7428693636800403`", 
      "1.7567332410402803`", "0.7067468983278398`", "0", "0", "0"},
     {"2094", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.0388641`", "3.0416794469329895`", 
      "1.4439775417981697`", "0.31996391418989584`", 
      RowBox[{"-", "0.03623298660237466`"}], "0.7494362415359882`", 
      "1.7639414559880655`", "0.7132032549336136`", "0", "0", "0"},
     {"2095", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.048030767`", "3.050846113932989`", 
      "1.448382097391442`", "0.32276954319871815`", 
      RowBox[{"-", "0.03634350785300416`"}], "0.7560077327769292`", 
      "1.7711516405901602`", "0.7196642249239251`", "0", "0", "0"},
     {"2096", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.057197433`", "3.0600127799329897`", 
      "1.4527866529432527`", "0.32557713491731216`", 
      RowBox[{"-", "0.036454029102593294`"}], "0.7625838211795167`", 
      "1.778363787860565`", "0.7261297920769234`", "0", "0", "0"},
     {"2097", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.0663641`", "3.0691794469329894`", 
      "1.45719120846727`", "0.3283866824441884`", 
      RowBox[{"-", "0.03656455035148501`"}], "0.7691644905787204`", 
      "1.7855778909114584`", "0.7325999402272354`", "0", "0", "0"},
     {"2098", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.075530767`", "3.0783461139329895`", 
      "1.461595764020787`", "0.33119817890279235`", 
      RowBox[{"-", "0.03667507160111695`"}], "0.7757497248679139`", 
      "1.7927939429235793`", "0.739074653266797`", "0", "0", "0"},
     {"2099", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.084697433`", "3.0875127799329896`", 
      "1.4660003195416706`", "0.33401161743949787`", 
      RowBox[{"-", "0.03678559284993005`"}], "0.7823395079941753`", 
      "1.8000119369811685`", "0.7455539151442452`", "0", "0", "0"},
     {"2100", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.0938641`", "3.0966794469329892`", 
      "1.4704048750416285`", "0.336826991225404`", 
      RowBox[{"-", "0.03689611409821806`"}], "0.7889338239624948`", 
      "1.8072318662670326`", "0.7520377098642768`", "0", "0", "0"},
     {"2101", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4756692296662715`", "0.3396542795885236`", 
      RowBox[{"-", "0.03702820984421374`"}], "0.7955560468777242`", 
      "1.815323509254795`", "0.7585278370335105`", "0", "0", "0"},
     {"2102", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4810239495334443`", "0.3424875113919913`", 
      RowBox[{"-", "0.037162573078814425`"}], "0.8021921908302914`", 
      "1.8235114609254355`", "0.7650296177514769`", "0", "0", "0"},
     {"2103", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4851895743419443`", "0.34531078074362176`", 
      RowBox[{"-", "0.037267098962014064`"}], "0.8088050002062698`", 
      "1.830500355085566`", "0.7715379012442557`", "0", "0", "0"},
     {"2104", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.488430160306407`", "0.34812412267423976`", 
      RowBox[{"-", "0.03734841332074571`"}], "0.8153945570566921`", 
      "1.8365542829806467`", "0.7780461437359464`", "0", "0", "0"},
     {"2105", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.490951126038041`", "0.3509275720914916`", 
      RowBox[{"-", "0.03741167061868512`"}], "0.8219609431440761`", 
      "1.8418786981295328`", "0.784549272525391`", "0", "0", "0"},
     {"2106", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4929122738951777`", "0.3537211637802783`", 
      RowBox[{"-", "0.03746088069431027`"}], "0.8285042399434394`", 
      "1.846633437675456`", "0.791043359249129`", "0", "0", "0"},
     {"2107", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4944379197495774`", "0.35650493240318737`", 
      RowBox[{"-", "0.03749916294192307`"}], "0.8350245286433099`", 
      "1.8509428521527647`", "0.7975253657013868`", "0", "0", "0"},
     {"2108", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.495624773287712`", "0.3592789125009226`", 
      RowBox[{"-", "0.03752894404800084`"}], "0.8415218901467338`", 
      "1.8549036857886345`", "0.803992946098733`", "0", "0", "0"},
     {"2109", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4965480683741306`", "0.36204313849273284`", 
      RowBox[{"-", "0.03755211181725478`"}], "0.847996405072279`", 
      "1.8585912068668633`", "0.8104442932550242`", "0", "0", "0"},
     {"2110", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4972663320766129`", "0.3647976446768392`", 
      RowBox[{"-", "0.037570134839327966`"}], "0.8544481537550354`", 
      "1.862063976753452`", "0.8168780189157074`", "0", "0", "0"},
     {"2111", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4978250946584704`", "0.3675424652308601`", 
      RowBox[{"-", "0.037584155581726175`"}], "0.8608772162476117`", 
      "1.8653675598893305`", "0.8232930606658855`", "0", "0", "0"},
     {"2112", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.498259775711968`", "0.37027763421223614`", 
      RowBox[{"-", "0.037595062810081036`"}], "0.8672836723211291`", 
      "1.8685374099242043`", "0.8296886095110481`", "0", "0", "0"},
     {"2113", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.498597929382963`", "0.373003185558652`", 
      RowBox[{"-", "0.03760354792641841`"}], "0.8736676014662105`", 
      "1.871601114941615`", "0.8360640535397921`", "0", "0", "0"},
     {"2114", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.498860991010074`", "0.3757191530884576`", 
      RowBox[{"-", "0.03761014879667768`"}], "0.8800290828939671`", 
      "1.8745801440985317`", "0.8424189340972894`", "0", "0", "0"},
     {"2115", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4990656358966863`", "0.37842557050108827`", 
      RowBox[{"-", "0.037615283845679644`"}], "0.8863681955369813`", 
      "1.8774912063977744`", "0.8487529116913016`", "0", "0", "0"},
     {"2116", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499224836347457`", "0.38112247137748234`", 
      RowBox[{"-", "0.03761927858080044`"}], "0.892685018050286`", 
      "1.8803473077249393`", "0.8550657394694856`", "0", "0", "0"},
     {"2117", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4993486839741685`", "0.38380988918049785`", 
      RowBox[{"-", "0.03762238622566989`"}], "0.8989796288123405`", 
      "1.8831585731546663`", "0.8613572425866706`", "0", "0", "0"},
     {"2118", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499445029396357`", "0.38648785725532797`", 
      RowBox[{"-", "0.03762480377185071`"}], "0.9052521059260031`", 
      "1.885932886651685`", "0.8676273021541524`", "0", "0", "0"},
     {"2119", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4995199798869168`", "0.38915640882991465`", 
      RowBox[{"-", "0.03762668446600396`"}], "0.9115025272195002`", 
      "1.8886763887168314`", "0.8738758427534963`", "0", "0", "0"},
     {"2120", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4995782865081086`", "0.39181557701536096`", 
      RowBox[{"-", "0.037628147524094074`"}], "0.9177309702473918`", 
      "1.8913938635234695`", "0.8801028227232978`", "0", "0", "0"},
     {"2121", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4996236452782707`", "0.3944653948063419`", 
      RowBox[{"-", "0.037629285688410355`"}], "0.9239375122915341`", 
      "1.8940890400846127`", "0.8863082266031237`", "0", "0", "0"},
     {"2122", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4996589314599864`", "0.3971058950815136`", 
      RowBox[{"-", "0.03763017110643962`"}], "0.930122230362038`", 
      "1.8967648265415`", "0.8924920592555984`", "0", "0", "0"},
     {"2123", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4996863818210882`", "0.3997371106039216`", 
      RowBox[{"-", "0.03763085990424792`"}], "0.9362852011982251`", 
      "1.8994234924250097`", "0.8986543412939771`", "0", "0", "0"},
     {"2124", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4997077364218971`", "0.40235907402140725`", 
      RowBox[{"-", "0.03763139574427494`"}], "0.9424265012695796`", 
      "1.9020668104433045`", "0.9047951055253046`", "0", "0", "0"},
     {"2125", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4997243489165022`", "0.40497181786701264`", 
      RowBox[{"-", "0.037631812593067276`"}], "0.948546206776697`", 
      "1.904696166783515`", "0.9109143941836297`", "0", "0", "0"},
     {"2126", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4997372723600015`", "0.4075753745593844`", 
      RowBox[{"-", "0.03763213687439549`"}], "0.9546443936522299`", 
      "1.907312646919386`", "0.9170122567778344`", "0", "0", "0"},
     {"2127", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499747325960972`", "0.4101697764031761`", 
      RowBox[{"-", "0.037632389144239525`"}], "0.96072113756183`", 
      "1.909917102364148`", "0.9230887484175905`", "0", "0", "0"},
     {"2128", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499755147010561`", "0.4127550555894487`", 
      RowBox[{"-", "0.037632585393818745`"}], "0.9667765139050869`", 
      "1.9125102026000098`", "0.9291439285112681`", "0", "0", "0"},
     {"2129", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4997612312799542`", "0.4153312441960705`", 
      RowBox[{"-", "0.03763273806326479`"}], "0.9728105978164637`", 
      "1.9150924754760248`", "0.9351778597531989`", "0", "0", "0"},
     {"2130", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4997659644469834`", "0.4178983741881145`", 
      RowBox[{"-", "0.03763285683019335`"}], "0.9788234641662296`", 
      "1.917664338635098`", "0.9411906073360362`", "0", "0", "0"},
     {"2131", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499769646543991`", "0.42045647741825565`", 
      RowBox[{"-", "0.037632949223161856`"}], "0.984815187561388`", 
      "1.9202261239622467`", "0.9471822383382261`", "0", "0", "0"},
     {"2132", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4997725109766826`", "0.4230055856271657`", 
      RowBox[{"-", "0.037633021098899766`"}], "0.9907858423466032`", 
      "1.9227780966038484`", "0.9531528212477034`", "0", "0", "0"},
     {"2133", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499774739319561`", "0.4255457304439072`", 
      RowBox[{"-", "0.03763307701356279`"}], "0.9967355026051223`", 
      "1.9253204697634683`", "0.9591024255915596`", "0", "0", "0"},
     {"2134", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4997764728258147`", "0.42807694338632585`", 
      RowBox[{"-", "0.03763312051154461`"}], "1.0026642421596947`", 
      "1.9278534162121406`", "0.9650311216481501`", "0", "0", "0"},
     {"2135", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499777821381264`", "0.43059925586144154`", 
      RowBox[{"-", "0.03763315435015367`"}], "1.0085721345734877`", 
      "1.9303770772427056`", "0.970938980223334`", "0", "0", "0"},
     {"2136", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499778870469951`", "0.43311269916583817`", 
      RowBox[{"-", "0.03763318067439712`"}], "1.0144592531509997`", 
      "1.9328915696357893`", "0.9768260724766026`", "0", "0", "0"},
     {"2137", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4997796865929174`", "0.43561730448605185`", 
      RowBox[{"-", "0.03763320115295142`"}], "1.0203256709389692`", 
      "1.9353969910789692`", "0.9826924697860178`", "0", "0", "0"},
     {"2138", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4997803214836603`", "0.4381131028989581`", 
      RowBox[{"-", "0.03763321708393865`"}], "1.026171460727282`", 
      "1.9378934243826182`", "0.9885382436433434`", "0", "0", "0"},
     {"2139", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4997808153874863`", "0.4406001253721571`", 
      RowBox[{"-", "0.03763322947721361`"}], "1.0319966950498738`", 
      "1.9403809407596433`", "0.9943634655726602`", "0", "0", "0"},
     {"2140", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4997811996126338`", "0.44307840276435817`", 
      RowBox[{"-", "0.03763323911837784`"}], "1.03780144618563`", 
      "1.942859602376992`", "1.0001682070672522`", "0", "0", "0"},
     {"2141", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4997814985148819`", "0.4455479658257626`", 
      RowBox[{"-", "0.03763324661857839`"}], "1.0435857861592828`", 
      "1.9453294643406445`", "1.0059525395407043`", "0", "0", "0"},
     {"2142", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4997817310414474`", "0.4480088451984452`", 
      RowBox[{"-", "0.037633252453248035`"}], "1.0493497867423052`", 
      "1.9477905762398926`", "1.011716534289057`", "0", "0", "0"},
     {"2143", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4997819119320364`", "0.4504610714167345`", 
      RowBox[{"-", "0.037633256992242646`"}], "1.055093519453801`", 
      "1.9502429833487709`", "1.0174602624615583`", "0", "0", "0"},
     {"2144", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782052653184`", "0.4529046749075917`", 
      RowBox[{"-", "0.037633260523286104`"}], "1.0608170555613923`", 
      "1.9526867275607755`", "1.0231837950381062`", "0", "0", "0"},
     {"2145", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782162125111`", "0.45533968599098784`", 
      RowBox[{"-", "0.03763326327020893`"}], "1.0665204660821044`", 
      "1.9551218481160988`", "1.0288872028118954`", "0", "0", "0"},
     {"2146", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4997822472871714`", "0.4577661348802805`", 
      RowBox[{"-", "0.037633265407136754`"}], "1.072203821783246`", 
      "1.957548382167452`", "1.0345705563761092`", "0", "0", "0"},
     {"2147", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4997823135377315`", "0.46018405168258847`", 
      RowBox[{"-", "0.03763326706952803`"}], "1.0778671931832875`", 
      "1.9599663652203199`", "1.0402339261137594`", "0", "0", "0"},
     {"2148", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782365076371`", "0.4625934663991653`", 
      RowBox[{"-", "0.03763326836276063`"}], "1.083510650552737`", 
      "1.9623758314755364`", "1.0458773821899763`", "0", "0", "0"},
     {"2149", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4997824051700903`", "0.4649944089257716`", 
      RowBox[{"-", "0.037633269368811735`"}], "1.0891342639150108`", 
      "1.964776814095862`", "1.051500994546199`", "0", "0", "0"},
     {"2150", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782436360404`", "0.4673869090530458`", 
      RowBox[{"-", "0.03763327015145425`"}], "1.0947381030473031`", 
      "1.9671693454134498`", "1.0571048328958488`", "0", "0", "0"},
     {"2151", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4997824606244452`", "0.46977099646687415`", 
      RowBox[{"-", "0.03763327076029937`"}], "1.1003222374814516`", 
      "1.9695534570913193`", "1.0626889667211523`", "0", "0", "0"},
     {"2152", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4997824795002959`", "0.47214670074875864`", 
      RowBox[{"-", "0.03763327123394139`"}], "1.1058867365048004`", 
      "1.9719291802490546`", "1.068253465270859`", "0", "0", "0"},
     {"2153", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4997824941844835`", "0.4745140513761844`", 
      RowBox[{"-", "0.03763327160240417`"}], "1.1114316691610588`", 
      "1.974296545560668`", "1.0737983975586547`", "0", "0", "0"},
     {"2154", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4997825056078293`", "0.4768730777229854`", 
      RowBox[{"-", "0.03763327188904432`"}], "1.1169571042511597`", 
      "1.9766555833308148`", "1.0793238323621153`", "0", "0", "0"},
     {"2155", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4997825144944517`", "0.4792238090597085`", 
      RowBox[{"-", "0.03763327211203177`"}], "1.1224631103341114`", 
      "1.9790063235541602`", "1.0848298382220796`", "0", "0", "0"},
     {"2156", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4997825214076674`", "0.48156627455397727`", 
      RowBox[{"-", "0.03763327228550154`"}], "1.1279497557278497`", 
      "1.9813487959616447`", "1.0903164834423482`", "0", "0", "0"},
     {"2157", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782526785701`", "0.4839005032708533`", 
      RowBox[{"-", "0.037633272420449775`"}], "1.1334171085100848`", 
      "1.9836830300565542`", "1.095783836089635`", "0", "0", "0"},
     {"2158", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4997825309694623`", "0.48622652417319745`", 
      RowBox[{"-", "0.03763327252543075`"}], "1.1388652365191463`", 
      "1.98600905514266`", "1.1012319639937156`", "0", "0", "0"},
     {"2159", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4997825342241573`", "0.4885443661220287`", 
      RowBox[{"-", "0.03763327260709914`"}], "1.144294207354825`", 
      "1.9883269003461859`", "1.1066609347477259`", "0", "0", "0"},
     {"2160", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782536756099`", "0.4908540578768824`", 
      RowBox[{"-", "0.03763327267063185`"}], "1.1497040883792113`", 
      "1.9906365946329814`", "1.1120708157085795`", "0", "0", "0"},
     {"2161", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4997825387257855`", "0.4931556280961674`", 
      RowBox[{"-", "0.03763327272005618`"}], "1.1550949467175313`", 
      "1.9929381668219528`", "1.1174616739974752`", "0", "0", "0"},
     {"2162", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4997825402580738`", "0.4954491053375212`", 
      RowBox[{"-", "0.0376332727585051`"}], "1.1604668492589798`", 
      "1.995231645595595`", "1.1228335765004747`", "0", "0", "0"},
     {"2163", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4997825414500947`", "0.4977345180581645`", 
      RowBox[{"-", "0.03763327278841587`"}], "1.16581986265755`", 
      "1.9975170595082592`", "1.1281865898691341`", "0", "0", "0"},
     {"2164", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4997825423774096`", "0.5000118946152544`", 
      RowBox[{"-", "0.03763327281168451`"}], "1.1711540533328606`", 
      "1.999794436992664`", "1.133520780521176`", "0", "0", "0"},
     {"2165", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4997825430988005`", "0.502281263266236`", 
      RowBox[{"-", "0.037633272829786`"}], "1.17646948747098`", 
      "2.0020638063650367`", "1.1388362146411941`", "0", "0", "0"},
     {"2166", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4997825436599959`", "0.5045426521691934`", 
      RowBox[{"-", "0.037633272843867784`"}], "1.1817662310252475`", 
      "2.004325195829189`", "1.1441329581813797`", "0", "0", "0"},
     {"2167", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4997825440965695`", "0.5067960893831984`", 
      RowBox[{"-", "0.0376332728548225`"}], "1.1870443497170915`", 
      "2.006578633479768`", "1.149411076862269`", "0", "0", "0"},
     {"2168", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4997825444361954`", "0.5090416028686596`", 
      RowBox[{"-", "0.03763327286334456`"}], "1.1923039090368452`", 
      "2.008824147304855`", "1.1546706361735006`", "0", "0", "0"},
     {"2169", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4997825447004023`", "0.5112792204876685`", 
      RowBox[{"-", "0.03763327286997417`"}], "1.1975449742445594`", 
      "2.011061765188071`", "1.1599117013745852`", "0", "0", "0"},
     {"2170", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782544905938`", "0.5135089700043456`", 
      RowBox[{"-", "0.03763327287513158`"}], "1.2027676103708114`", 
      "2.013291514910284`", "1.1651343374956797`", "0", "0", "0"},
     {"2171", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4997825450658318`", "0.5157308790851848`", 
      RowBox[{"-", "0.037633272879143705`"}], "1.2079718822175125`", 
      "2.0155134241510164`", "1.1703386093383688`", "0", "0", "0"},
     {"2172", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4997825451902187`", "0.5179449752993968`", 
      RowBox[{"-", "0.03763327288226488`"}], "1.2131578543587125`", 
      "2.0177275204896157`", "1.1755245814764477`", "0", "0", "0"},
     {"2173", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4997825452869835`", "0.520151286119251`", 
      RowBox[{"-", "0.03763327288469295`"}], "1.2183255911413997`", 
      "2.0199338314062345`", "1.1806923182567068`", "0", "0", "0"},
     {"2174", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4997825453622604`", "0.5223498389204166`", 
      RowBox[{"-", "0.03763327288658184`"}], "1.2234751566863007`", 
      "2.022132384282677`", "1.1858418837997189`", "0", "0", "0"},
     {"2175", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545420821`", "0.524540660982302`", 
      RowBox[{"-", "0.03763327288805127`"}], "1.2286066148886747`", 
      "2.024323206403123`", "1.1909733420006234`", "0", "0", "0"},
     {"2176", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4997825454663771`", "0.5267237794883933`", 
      RowBox[{"-", "0.03763327288919439`"}], "1.2337200294191075`", 
      "2.0265063249547706`", "1.1960867565299131`", "0", "0", "0"},
     {"2177", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545501817`", "0.5288992215265921`", 
      RowBox[{"-", "0.03763327289008366`"}], "1.2388154637243005`", 
      "2.028681767028409`", "1.2011821908342168`", "0", "0", "0"},
     {"2178", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545529387`", "0.5310670140895507`", 
      RowBox[{"-", "0.037633272890775456`"}], "1.2438929810278585`", 
      "2.0308495596189378`", "1.206259708137083`", "0", "0", "0"},
     {"2179", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4997825455508345`", "0.5332271840750079`", 
      RowBox[{"-", "0.03763327289131363`"}], "1.2489526443310741`", 
      "2.0330097296258423`", "1.2113193714397605`", "0", "0", "0"},
     {"2180", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4997825455675193`", "0.5353797582861222`", 
      RowBox[{"-", "0.037633272891732295`"}], "1.2539945164137094`", 
      "2.0351623038536415`", "1.216361243521977`", "0", "0", "0"},
     {"2181", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545580499`", "0.5375247634318046`", 
      RowBox[{"-", "0.037633272892057985`"}], "1.259018659834775`", 
      "2.0373073090123035`", "1.221385386942717`", "0", "0", "0"},
     {"2182", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4997825455905964`", "0.53966222612705`", 
      RowBox[{"-", "0.03763327289231135`"}], "1.264025136933306`", 
      "2.0394447717176463`", "1.2263918640409945`", "0", "0", "0"},
     {"2183", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4997825455984515`", "0.5417921728932672`", 
      RowBox[{"-", "0.03763327289250846`"}], "1.2690140098291356`", 
      "2.041574718491719`", "1.2313807369366272`", "0", "0", "0"},
     {"2184", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4997825456045621`", "0.5439146301586083`", 
      RowBox[{"-", "0.037633272892661794`"}], "1.2739853404236663`", 
      "2.0436971757631706`", "1.2363520675310045`", "0", "0", "0"},
     {"2185", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545609316`", "0.5460296242582965`", 
      RowBox[{"-", "0.037633272892781074`"}], "1.278939190400637`", 
      "2.045812169867612`", "1.241305917507856`", "0", "0", "0"},
     {"2186", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545613014`", "0.5481371814349528`", 
      RowBox[{"-", "0.03763327289287387`"}], "1.2838756212268898`", 
      "2.047919727047967`", "1.246242348334016`", "0", "0", "0"},
     {"2187", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4997825456158909`", "0.5502373278389217`", 
      RowBox[{"-", "0.03763327289294605`"}], "1.288794694153131`", 
      "2.0500198734548123`", "1.251161421260185`", "0", "0", "0"},
     {"2188", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4997825456181288`", "0.5523300895285953`", 
      RowBox[{"-", "0.03763327289300221`"}], "1.2936964702146923`", 
      "2.0521126351467243`", "1.25606319732169`", "0", "0", "0"},
     {"2189", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.49978254561987`", "0.5544154924707374`", 
      RowBox[{"-", "0.037633272893045897`"}], "1.2985810102322877`", 
      "2.0541980380906075`", "1.2609477373392417`", "0", "0", "0"},
     {"2190", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4997825456212244`", "0.5564935625408051`", 
      RowBox[{"-", "0.03763327289307988`"}], "1.3034483748127683`", 
      "2.0562761081620295`", "1.2658151019196884`", "0", "0", "0"},
     {"2191", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545622278`", "0.5585643255232697`", 
      RowBox[{"-", "0.03763327289310632`"}], "1.3082986243498742`", 
      "2.058346871145548`", "1.2706653514567678`", "0", "0", "0"},
     {"2192", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4997825456230978`", "0.5606278071119375`", 
      RowBox[{"-", "0.03763327289312689`"}], "1.3131318190249839`", 
      "2.060410352735035`", "1.275498546131857`", "0", "0", "0"},
     {"2193", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4997825456237355`", "0.5626840329102676`", 
      RowBox[{"-", "0.03763327289314289`"}], "1.3179480188078607`", 
      "2.062466578534003`", "1.2803147459147177`", "0", "0", "0"},
     {"2194", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4997825456242315`", "0.5647330284316902`", 
      RowBox[{"-", "0.03763327289315534`"}], "1.3227472834573974`", 
      "2.0645155740559216`", "1.285114010564242`", "0", "0", "0"},
     {"2195", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4997825456246174`", "0.5667748190999229`", 
      RowBox[{"-", "0.03763327289316502`"}], "1.3275296725223575`", 
      "2.0665573647245403`", "1.2898963996291926`", "0", "0", "0"},
     {"2196", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4997825456249176`", "0.5688094302492864`", 
      RowBox[{"-", "0.03763327289317256`"}], "1.332295245342114`", 
      "2.068591975874204`", "1.2946619724489414`", "0", "0", "0"},
     {"2197", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4997825456251512`", "0.5708368871250187`", 
      RowBox[{"-", "0.037633272893178416`"}], "1.3370440610473853`", 
      "2.0706194327501697`", "1.2994107881542067`", "0", "0", "0"},
     {"2198", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4997825456253329`", "0.5728572148835881`", 
      RowBox[{"-", "0.037633272893182974`"}], "1.3417761785609699`", 
      "2.072639760508921`", "1.304142905667787`", "0", "0", "0"},
     {"2199", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4997825456254743`", "0.5748704385930058`", 
      RowBox[{"-", "0.03763327289318652`"}], "1.3464916565984766`", 
      "2.07465298421848`", "1.30885838370529`", "0", "0", "0"},
     {"2200", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4997825456255842`", "0.5768765832331366`", 
      RowBox[{"-", "0.03763327289318928`"}], "1.3511905536690534`", 
      "2.076659128858721`", "1.3135572807758642`", "0", "0", "0"},
     {"2201", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4997825456256697`", "0.5788756736960091`", 
      RowBox[{"-", "0.037633272893191426`"}], "1.3558729280761135`", 
      "2.078658219321679`", "1.318239655182922`", "0", "0", "0"},
     {"2202", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4997825456257363`", "0.5808677347861243`", 
      RowBox[{"-", "0.0376332728931931`"}], "1.3605388379180587`", 
      "2.0806502804118607`", "1.3229055650248656`", "0", "0", "0"},
     {"2203", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625788`", "0.5828527912207634`", 
      RowBox[{"-", "0.037633272893194396`"}], "1.3651883410890002`", 
      "2.0826353368465513`", "1.327555068195806`", "0", "0", "0"},
     {"2204", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4997825456258282`", "0.5848308676302948`", 
      RowBox[{"-", "0.03763327289319541`"}], "1.3698214952794767`", 
      "2.084613413256123`", "1.3321882223862813`", "0", "0", "0"},
     {"2205", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4997825456258596`", "0.5868019885584794`", 
      RowBox[{"-", "0.03763327289319619`"}], "1.374438357977171`", 
      "2.0865845341843388`", "1.3368050850839748`", "0", "0", "0"},
     {"2206", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625884`", "0.5887661784627752`", 
      RowBox[{"-", "0.037633272893196804`"}], "1.3790389864676225`", 
      "2.088548724088659`", "1.3414057135744257`", "0", "0", "0"},
     {"2207", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4997825456259029`", "0.590723461714641`", 
      RowBox[{"-", "0.03763327289319728`"}], "1.3836234378349381`", 
      "2.0905060073405437`", "1.345990164941741`", "0", "0", "0"},
     {"2208", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4997825456259177`", "0.5926738625998381`", 
      RowBox[{"-", "0.03763327289319765`"}], "1.3881917689625012`", 
      "2.0924564082257557`", "1.3505584960693036`", "0", "0", "0"},
     {"2209", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4997825456259293`", "0.5946174053187326`", 
      RowBox[{"-", "0.03763327289319794`"}], "1.3927440365336763`", 
      "2.094399950944662`", "1.3551107636404784`", "0", "0", "0"},
     {"2210", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4997825456259382`", "0.5965541139865952`", 
      RowBox[{"-", "0.037633272893198164`"}], "1.3972802970325138`", 
      "2.0963366596125335`", "1.3596470241393157`", "0", "0", "0"},
     {"2211", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625945`", "0.5984840126339`", 
      RowBox[{"-", "0.03763327289319834`"}], "1.4018006067444495`", 
      "2.098266558259845`", "1.3641673338512512`", "0", "0", "0"},
     {"2212", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4997825456259504`", "0.6004071252066236`", 
      RowBox[{"-", "0.037633272893198476`"}], "1.4063050217570037`", 
      "2.100189670832574`", "1.3686717488638052`", "0", "0", "0"},
     {"2213", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4997825456259546`", "0.6023234755665414`", 
      RowBox[{"-", "0.03763327289319858`"}], "1.4107935979604769`", 
      "2.102106021192496`", "1.3731603250672784`", "0", "0", "0"},
     {"2214", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625958`", "0.604233087491524`", 
      RowBox[{"-", "0.03763327289319866`"}], "1.4152663910486434`", 
      "2.104015633117482`", "1.3776331181554446`", "0", "0", "0"},
     {"2215", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4997825456259604`", "0.6061359846758325`", 
      RowBox[{"-", "0.037633272893198726`"}], "1.4197234565194423`", 
      "2.1059185303017927`", "1.3820901836262436`", "0", "0", "0"},
     {"2216", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4997825456259624`", "0.6080321907304118`", 
      RowBox[{"-", "0.037633272893198774`"}], "1.4241648496756663`", 
      "2.1078147363563744`", "1.3865315767824675`", "0", "0", "0"},
     {"2217", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625964`", "0.6099217291831842`", 
      RowBox[{"-", "0.037633272893198816`"}], "1.4285906256256473`", 
      "2.109704274809148`", "1.3909573527324486`", "0", "0", "0"},
     {"2218", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625965`", "0.6118046234793412`", 
      RowBox[{"-", "0.037633272893198844`"}], "1.4330008392839408`", 
      "2.1115871691053063`", "1.395367566390742`", "0", "0", "0"},
     {"2219", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625966`", "0.613680896981634`", 
      RowBox[{"-", "0.037633272893198864`"}], "1.437395545372007`", 
      "2.1134634426075998`", "1.3997622724788081`", "0", "0", "0"},
     {"2220", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4997825456259666`", "0.615550572970664`", 
      RowBox[{"-", "0.037633272893198885`"}], "1.44177479841889`", 
      "2.1153331185966304`", "1.404141525525691`", "0", "0", "0"},
     {"2221", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4997825456259672`", "0.6174136746451713`", 
      RowBox[{"-", "0.0376332728931989`"}], "1.446138652761894`", 
      "2.1171962202711385`", "1.408505379868695`", "0", "0", "0"},
     {"2222", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4997825456259677`", "0.6192702251223224`", 
      RowBox[{"-", "0.03763327289319891`"}], "1.4504871625472577`", 
      "2.11905277074829`", "1.4128538896540588`", "0", "0", "0"},
     {"2223", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4997825456259681`", "0.6211202474379977`", 
      RowBox[{"-", "0.03763327289319892`"}], "1.4548203817308263`", 
      "2.1209027930639657`", "1.4171871088376273`", "0", "0", "0"},
     {"2224", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4997825456259684`", "0.6229637645470762`", 
      RowBox[{"-", "0.03763327289319893`"}], "1.4591383640787208`", 
      "2.122746310173045`", "1.4215050911855218`", "0", "0", "0"},
     {"2225", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4997825456259686`", "0.6248007993237218`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.4634411631680049`", 
      "2.1245833449496905`", "1.425807890274806`", "0", "0", "0"},
     {"2226", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.4997825456259688`", "0.6266313745616655`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.4677288323873505`", 
      "2.1264139201876344`", "1.4300955594941516`", "0", "0", "0"},
     {"2227", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.6284555129744896`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.4720014249376996`", 
      "2.128238058600459`", "1.4343681520445006`", "0", "0", "0"},
     {"2228", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.6302732371959088`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.4762589938329245`", 
      "2.130055782821878`", "1.4386257209397255`", "0", "0", "0"},
     {"2229", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.632084569780051`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.4805015919004851`", 
      "2.13186711540602`", "1.4428683190072862`", "0", "0", "0"},
     {"2230", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.6338895332017377`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.4847292717820857`", 
      "2.133672078827707`", "1.4470959988888867`", "0", "0", "0"},
     {"2231", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.6356881498567623`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.4889420859343265`", 
      "2.135470695482731`", "1.4513088130411276`", "0", "0", "0"},
     {"2232", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.637480442062168`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.493140086629356`", 
      "2.1372629876881373`", "1.455506813736157`", "0", "0", "0"},
     {"2233", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.6392664320565254`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.4973233259555185`", 
      "2.1390489776824944`", "1.4596900530623196`", "0", "0", "0"},
     {"2234", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.6410461420002076`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.501491855818001`", 
      "2.1408286876261764`", "1.463858582924802`", "0", "0", "0"},
     {"2235", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.6428195939756655`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.505645727939477`", 
      "2.1426021396016344`", "1.468012455046278`", "0", "0", "0"},
     {"2236", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.6445868099877019`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.5097849938607482`", 
      "2.144369355613671`", "1.4721517209675492`", "0", "0", "0"},
     {"2237", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.6463478119637445`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.513909704941384`", 
      "2.1461303575897137`", "1.4762764320481851`", "0", "0", "0"},
     {"2238", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.6481026217541176`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.5180199123603597`", 
      "2.1478851673800867`", "1.4803866394671608`", "0", "0", "0"},
     {"2239", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.6498512611323138`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.5221156671166898`", 
      "2.149633806758283`", "1.4844823942234908`", "0", "0", "0"},
     {"2240", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.651593751795264`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.5261970200300619`", 
      "2.151376297421233`", "1.488563747136863`", "0", "0", "0"},
     {"2241", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.6533301153636061`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.5302640217414674`", 
      "2.153112660989575`", "1.4926307488482684`", "0", "0", "0"},
     {"2242", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.6550603733819539`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.5343167227138292`", 
      "2.154842919007923`", "1.4966834498206303`", "0", "0", "0"},
     {"2243", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.6567845473191642`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.5383551732326284`", 
      "2.1565670929451333`", "1.5007219003394294`", "0", "0", "0"},
     {"2244", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.6585026585686031`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.5423794234065278`", 
      "2.158285204194572`", "1.5047461505133288`", "0", "0", "0"},
     {"2245", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.6602147284484117`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.5463895231679938`", 
      "2.1599972740743807`", "1.5087562502747949`", "0", "0", "0"},
     {"2246", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.66192077820177`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.5503855222739162`", 
      "2.161703323827739`", "1.5127522493807173`", "0", "0", "0"},
     {"2247", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.6636208289971613`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.5543674703062254`", 
      "2.1634033746231305`", "1.5167341974130264`", "0", "0", "0"},
     {"2248", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.6653149019286345`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.5583354166725072`", 
      "2.1650974475546034`", "1.5207021437793082`", "0", "0", "0"},
     {"2249", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.6670030180160657`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.5622894106066165`", 
      "2.166785563642035`", "1.5246561377134176`", "0", "0", "0"},
     {"2250", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.6686851982054188`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.5662295011692882`", 
      "2.1684677438313877`", "1.5285962282760892`", "0", "0", "0"},
     {"2251", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.6703614633690063`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.5701557372487451`", 
      "2.170144008994975`", "1.5325224643555462`", "0", "0", "0"},
     {"2252", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.6720318343057471`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.5740681675613053`", 
      "2.171814379931716`", "1.5364348946681063`", "0", "0", "0"},
     {"2253", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.6736963317414256`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.5779668406519864`", 
      "2.1734788773673945`", "1.5403335677587875`", "0", "0", "0"},
     {"2254", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.6753549763289483`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.581851804895108`", 
      "2.1751375219549174`", "1.544218532001909`", "0", "0", "0"},
     {"2255", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.6770077886486`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.5857231084948915`", 
      "2.176790334274569`", "1.5480898356016926`", "0", "0", "0"},
     {"2256", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.6786547892082996`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.5895807994860587`", 
      "2.1784373348342685`", "1.5519475265928597`", "0", "0", "0"},
     {"2257", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.6802959984438542`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.5934249257344275`", 
      "2.1800785440698234`", "1.5557916528412286`", "0", "0", "0"},
     {"2258", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.6819314367192129`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.597255534937506`", 
      "2.181713982345182`", "1.559622262044307`", "0", "0", "0"},
     {"2259", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.6835611243267189`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.601072674625084`", 
      "2.183343669952688`", "1.5634394017318851`", "0", "0", "0"},
     {"2260", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.6851850814873623`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.6048763921598237`", 
      "2.1849676271133314`", "1.5672431192666247`", "0", "0", "0"},
     {"2261", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.6868033283510302`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.6086667347378458`", 
      "2.186585873976999`", "1.5710334618446469`", "0", "0", "0"},
     {"2262", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.6884158849967567`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.6124437493893164`", 
      "2.188198430622726`", "1.5748104764961175`", "0", "0", "0"},
     {"2263", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.6900227714329725`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.6162074829790303`", 
      "2.1898053170589415`", "1.5785742100858313`", "0", "0", "0"},
     {"2264", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.6916240075977532`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.6199579822069916`", 
      "2.191406553223722`", "1.5823247093137927`", "0", "0", "0"},
     {"2265", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.693219613359066`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.6236952936089946`", 
      "2.193002158985035`", "1.5860620207157956`", "0", "0", "0"},
     {"2266", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.6948096085150168`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.6274194635572`", 
      "2.194592154140986`", "1.589786190664001`", "0", "0", "0"},
     {"2267", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.6963940127940959`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.6311305382607109`", 
      "2.1961765584200648`", "1.593497265367512`", "0", "0", "0"},
     {"2268", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.6979728458554222`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.6348285637661462`", 
      "2.197755391481391`", "1.5971952908729472`", "0", "0", "0"},
     {"2269", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.6995461272889879`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.6385135859582114`", 
      "2.199328672914957`", "1.6008803130650124`", "0", "0", "0"},
     {"2270", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.7011138766159011`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.6421856505602686`", 
      "2.20089642224187`", "1.6045523776670696`", "0", "0", "0"},
     {"2271", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.7026761132886279`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.6458448031349031`", 
      "2.2024586589145967`", "1.6082115302417042`", "0", "0", "0"},
     {"2272", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.7042328566912343`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.6494910890844894`", 
      "2.204015402317203`", "1.6118578161912904`", "0", "0", "0"},
     {"2273", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.7057841261396262`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.6531245536517545`", 
      "2.2055666717655953`", "1.6154912807585555`", "0", "0", "0"},
     {"2274", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.7073299408817892`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.6567452419203386`", 
      "2.207112486507758`", "1.6191119690271396`", "0", "0", "0"},
     {"2275", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.7088703200980278`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.6603531988153553`", 
      "2.2086528657239968`", "1.6227199259221563`", "0", "0", "0"},
     {"2276", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.7104052829012026`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.6639484691039483`", 
      "2.2101878285271717`", "1.6263151962107494`", "0", "0", "0"},
     {"2277", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.7119348483369684`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.6675310973958477`", 
      "2.2117173939629375`", "1.6298978245026488`", "0", "0", "0"},
     {"2278", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.7134590353840097`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.671101128143923`", 
      "2.213241581009979`", "1.633467855250724`", "0", "0", "0"},
     {"2279", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.7149778629542766`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.6746586056447343`", 
      "2.2147604085802457`", "1.6370253327515354`", "0", "0", "0"},
     {"2280", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.7164913498932195`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.6782035740390826`", 
      "2.2162738955191887`", "1.6405703011458836`", "0", "0", "0"},
     {"2281", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.7179995149800228`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.6817360773125574`", 
      "2.217782060605992`", "1.6441028044193584`", "0", "0", "0"},
     {"2282", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.7195023769278378`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.6852561592960822`", 
      "2.2192849225538067`", "1.6476228864028832`", "0", "0", "0"},
     {"2283", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.7209999543840151`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.6887638636664584`", 
      "2.2207825000099843`", "1.6511305907732594`", "0", "0", "0"},
     {"2284", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.722492265930336`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.6922592339469071`", 
      "2.222274811556305`", "1.6546259610537082`", "0", "0", "0"},
     {"2285", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.7239793300832427`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.69574231350761`", 
      "2.2237618757092115`", "1.658109040614411`", "0", "0", "0"},
     {"2286", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.7254611652940685`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.699213145566246`", 
      "2.2252437109200374`", "1.661579872673047`", "0", "0", "0"},
     {"2287", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.7269377899492664`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.7026717731885288`", 
      "2.2267203355752354`", "1.6650385002953298`", "0", "0", "0"},
     {"2288", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.7284092223706377`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.7061182392887408`", 
      "2.2281917679966066`", "1.668484966395542`", "0", "0", "0"},
     {"2289", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.7298754808155585`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.7095525866302654`", 
      "2.2296580264415278`", "1.6719193137370665`", "0", "0", "0"},
     {"2290", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.7313365834772073`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.7129748578261177`", 
      "2.2311191291031762`", "1.6753415849329187`", "0", "0", "0"},
     {"2291", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.7327925484847898`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.7163850953394733`", 
      "2.232575094110759`", "1.6787518224462743`", "0", "0", "0"},
     {"2292", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.7342433939037644`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.7197833414841952`", 
      "2.2340259395297335`", "1.6821500685909963`", "0", "0", "0"},
     {"2293", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.735689137736066`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.7231696384253588`", 
      "2.235471683362035`", "1.6855363655321598`", "0", "0", "0"},
     {"2294", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.73712979792033`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.7265440281797748`", 
      "2.236912343546299`", "1.6889107552865759`", "0", "0", "0"},
     {"2295", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.7385653923321138`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.7299065526165114`", 
      "2.238347937958083`", "1.6922732797233124`", "0", "0", "0"},
     {"2296", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.73999593878412`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.7332572534574124`", 
      "2.239778484410089`", "1.6956239805642135`", "0", "0", "0"},
     {"2297", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.7414214550264159`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.7365961722776164`", 
      "2.241204000652385`", "1.6989628993844175`", "0", "0", "0"},
     {"2298", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.742841958746655`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.7399233505060714`", 
      "2.242624504372624`", "1.7022900776128724`", "0", "0", "0"},
     {"2299", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.7442574675702959`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.7432388294260497`", 
      "2.244040013196265`", "1.7056055565328507`", "0", "0", "0"},
     {"2300", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.7456679990608207`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.7465426501756598`", 
      "2.24545054468679`", "1.7089093772824608`", "0", "0", "0"},
     {"2301", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.7470735707199537`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.7498348537483568`", 
      "2.246856116345923`", "1.7122015808551578`", "0", "0", "0"},
     {"2302", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.748474199987878`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.7531154809934513`", 
      "2.248256745613847`", "1.7154822081002523`", "0", "0", "0"},
     {"2303", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.7498699042434519`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.7563845726166156`", 
      "2.249652449869421`", "1.7187512997234167`", "0", "0", "0"},
     {"2304", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.7512607008044249`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.7596421691803898`", 
      "2.251043246430394`", "1.722008896287191`", "0", "0", "0"},
     {"2305", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.7526466069276522`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.7628883111046842`", 
      "2.252429152553621`", "1.7252550382114853`", "0", "0", "0"},
     {"2306", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.754027639809309`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.7661230386672813`", 
      "2.253810185435278`", "1.7284897657740823`", "0", "0", "0"},
     {"2307", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.7554038165851038`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.769346392004335`", 
      "2.255186362211073`", "1.7317131191111361`", "0", "0", "0"},
     {"2308", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.7567751543304913`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.7725584111108699`", 
      "2.2565576999564603`", "1.734925138217671`", "0", "0", "0"},
     {"2309", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.7581416700608836`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.7757591358412756`", 
      "2.2579242156868524`", "1.7381258629480767`", "0", "0", "0"},
     {"2310", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.7595033807318622`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.7789486059098032`", 
      "2.259285926357831`", "1.7413153330166042`", "0", "0", "0"},
     {"2311", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.7608603032393875`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.7821268608910565`", 
      "2.2606428488653565`", "1.7444935879978576`", "0", "0", "0"},
     {"2312", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.7622124544200092`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.7852939402204842`", 
      "2.261995000045978`", "1.7476606673272852`", "0", "0", "0"},
     {"2313", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.7635598510510748`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.7884498831948683`", 
      "2.263342396677044`", "1.7508166103016694`", "0", "0", "0"},
     {"2314", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.7649025098509379`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.7915947289728125`", 
      "2.2646850554769067`", "1.7539614560796135`", "0", "0", "0"},
     {"2315", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.7662404474791654`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.7947285165752274`", 
      "2.2660229931051346`", "1.7570952436820284`", "0", "0", "0"},
     {"2316", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.7675736805367447`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.7978512848858148`", 
      "2.267356226162714`", "1.7602180119926158`", "0", "0", "0"},
     {"2317", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.7689022255662892`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.8009630726515506`", 
      "2.268684771192258`", "1.7633297997583517`", "0", "0", "0"},
     {"2318", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.7702260990522437`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.8040639184831653`", 
      "2.270008644678213`", "1.7664306455899663`", "0", "0", "0"},
     {"2319", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.7715453174210891`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.8071538608556228`", 
      "2.271327863047058`", "1.7695205879624238`", "0", "0", "0"},
     {"2320", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.7728598970415461`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.8102329381085982`", 
      "2.2726424426675154`", "1.7725996652153992`", "0", "0", "0"},
     {"2321", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.7741698542247782`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.8133011884469532`", 
      "2.273952399850747`", "1.7756679155537543`", "0", "0", "0"},
     {"2322", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.7754752052245945`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.8163586499412105`", 
      "2.2752577508505634`", "1.7787253770480116`", "0", "0", "0"},
     {"2323", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.7767759662376506`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.819405360528026`", 
      "2.2765585118636196`", "1.781772087634827`", "0", "0", "0"},
     {"2324", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.7780721534036503`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.8224413580106593`", 
      "2.2778546990296196`", "1.7848080851174604`", "0", "0", "0"},
     {"2325", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.7793637828055456`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.825466680059443`", 
      "2.2791463284315148`", "1.787833407166244`", "0", "0", "0"},
     {"2326", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.7806508704697364`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.8284813642122502`", 
      "2.2804334160957054`", "1.7908480913190512`", "0", "0", "0"},
     {"2327", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.7819334323662687`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.8314854478749596`", 
      "2.2817159779922376`", "1.7938521749817606`", "0", "0", "0"},
     {"2328", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.7832114844090338`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.834478968321921`", 
      "2.282994030035003`", "1.796845695428722`", "0", "0", "0"},
     {"2329", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.7844850424559648`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.8374619626964162`", 
      "2.284267588081934`", "1.7998286898032172`", "0", "0", "0"},
     {"2330", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.7857541223092342`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.840434468011121`", 
      "2.285536667935203`", "1.8028011951179221`", "0", "0", "0"},
     {"2331", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.7870187397154493`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.8433965211485643`", 
      "2.2868012853414186`", "1.8057632482553654`", "0", "0", "0"},
     {"2332", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.7882789103658479`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.8463481588615849`", 
      "2.2880614559918167`", "1.808714885968386`", "0", "0", "0"},
     {"2333", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.7895346498964926`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.8492894177737884`", 
      "2.289317195522462`", "1.8116561448805895`", "0", "0", "0"},
     {"2334", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.7907859738884656`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.8522203343800014`", 
      "2.2905685195144345`", "1.8145870614868025`", "0", "0", "0"},
     {"2335", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.7920328978680615`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.8551409450467242`", 
      "2.2918154434940305`", "1.8175076721535253`", "0", "0", "0"},
     {"2336", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.7932754373069798`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.8580512860125822`", 
      "2.293057982932949`", "1.8204180131193832`", "0", "0", "0"},
     {"2337", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.7945136076225172`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.8609513933887754`", 
      "2.294296153248486`", "1.8233181204955764`", "0", "0", "0"},
     {"2338", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.7957474241777588`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.8638413031595265`", 
      "2.2955299698037277`", "1.8262080302663275`", "0", "0", "0"},
     {"2339", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.7969769022817687`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.8667210511825272`", 
      "2.296759447907738`", "1.8290877782893282`", "0", "0", "0"},
     {"2340", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.7982020571897799`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.8695906731893837`", 
      "2.297984602815749`", "1.8319574002961847`", "0", "0", "0"},
     {"2341", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.7994229041033837`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.8724502047860594`", 
      "2.2992054497293526`", "1.8348169318928604`", "0", "0", "0"},
     {"2342", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8006394581707182`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.8752996814533172`", 
      "2.300422003796687`", "1.8376664085601182`", "0", "0", "0"},
     {"2343", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8018517344866566`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.878139138547159`", 
      "2.3016342801126255`", "1.8405058656539601`", "0", "0", "0"},
     {"2344", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8030597480929939`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.8809686112992658`", 
      "2.302842293718963`", "1.843335338406067`", "0", "0", "0"},
     {"2345", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8042635139786338`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.883788134817433`", 
      "2.3040460596046026`", "1.846154861924234`", "0", "0", "0"},
     {"2346", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8054630470797751`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.8865977440860076`", 
      "2.3052455927057443`", "1.8489644711928086`", "0", "0", "0"},
     {"2347", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8066583622800964`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.8893974739663213`", 
      "2.3064409079060653`", "1.8517642010731223`", "0", "0", "0"},
     {"2348", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8078494744109409`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.8921873591971237`", 
      "2.30763202003691`", "1.8545540863039247`", "0", "0", "0"},
     {"2349", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.809036398251501`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.8949674343950127`", 
      "2.30881894387747`", "1.8573341615018137`", "0", "0", "0"},
     {"2350", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8102191485290009`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.8977377340548645`", 
      "2.3100016941549697`", "1.8601044611616655`", "0", "0", "0"},
     {"2351", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8113977399188798`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.9004982925502616`", 
      "2.311180285544849`", "1.8628650196570626`", "0", "0", "0"},
     {"2352", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8125721870449737`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.9032491441339192`", 
      "2.3123547326709426`", "1.8656158712407203`", "0", "0", "0"},
     {"2353", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8137425044796972`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.9059903229381099`", 
      "2.313525050105666`", "1.868357050044911`", "0", "0", "0"},
     {"2354", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8149087067442242`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.9087218629750877`", 
      "2.314691252370193`", "1.8710885900818888`", "0", "0", "0"},
     {"2355", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8160708083086678`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.9114437981375099`", 
      "2.315853353934637`", "1.873810525244311`", "0", "0", "0"},
     {"2356", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8172288235922602`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.914156162198857`", 
      "2.3170113692182293`", "1.876522889305658`", "0", "0", "0"},
     {"2357", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8183827669635313`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.916858988813853`", 
      "2.3181653125895005`", "1.879225715920654`", "0", "0", "0"},
     {"2358", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8195326527404873`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.919552311518882`", 
      "2.319315198366456`", "1.881919038625683`", "0", "0", "0"},
     {"2359", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8206784951907881`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.9222361637324044`", 
      "2.320461040816757`", "1.8846028908392054`", "0", "0", "0"},
     {"2360", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8218203085319246`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.924910578755372`", 
      "2.3216028541578937`", "1.887277305862173`", "0", "0", "0"},
     {"2361", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8229581069313947`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.9275755897716407`", 
      "2.3227406525573637`", "1.8899423168784417`", "0", "0", "0"},
     {"2362", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8240919045068796`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.9302312298483828`", 
      "2.3238744501328488`", "1.8925979569551838`", "0", "0", "0"},
     {"2363", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8252217153264185`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.932877531936497`", 
      "2.3250042609523875`", "1.895244259043298`", "0", "0", "0"},
     {"2364", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8263475534085835`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.935514528871017`", 
      "2.3261300990345526`", "1.897881255977818`", "0", "0", "0"},
     {"2365", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8274694327226532`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.938142253371519`", 
      "2.327251978348622`", "1.90050898047832`", "0", "0", "0"},
     {"2366", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8285873671887863`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.9407607380425282`", 
      "2.3283699128147552`", "1.9031274651493293`", "0", "0", "0"},
     {"2367", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8297013706781945`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.943370015373923`", 
      "2.3294839163041634`", "1.905736742480724`", "0", "0", "0"},
     {"2368", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.830811457013314`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.9459701177413378`", 
      "2.330594002639283`", "1.9083368448481388`", "0", "0", "0"},
     {"2369", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8319176399679776`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.948561077406565`", 
      "2.3317001855939465`", "1.910927804513366`", "0", "0", "0"},
     {"2370", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8330199332675853`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.9511429265179556`", 
      "2.332802478893554`", "1.9135096536247567`", "0", "0", "0"},
     {"2371", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8341183505892746`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.953715697110818`", 
      "2.3339008962152437`", "1.916082424217619`", "0", "0", "0"},
     {"2372", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8352129055620905`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.9562794211078147`", 
      "2.3349954511880595`", "1.9186461482146158`", "0", "0", "0"},
     {"2373", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8363036117671542`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.9588341303193595`", 
      "2.3360861573931233`", "1.9212008574261605`", "0", "0", "0"},
     {"2374", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8373904827378317`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.9613798564440115`", 
      "2.3371730283638006`", "1.9237465835508125`", "0", "0", "0"},
     {"2375", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.838473531959902`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.9639166310688687`", 
      "2.338256077585871`", "1.9262833581756698`", "0", "0", "0"},
     {"2376", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8395527728717245`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.9664444856699597`", 
      "2.3393353184976933`", "1.9288112127767607`", "0", "0", "0"},
     {"2377", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8406282188644049`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.9689634516126346`", 
      "2.340410764490374`", "1.9313301787194357`", "0", "0", "0"},
     {"2378", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8416998832819623`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.971473560151954`", 
      "2.3414824289079315`", "1.933840287258755`", "0", "0", "0"},
     {"2379", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8427677794214945`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.9739748424330763`", 
      "2.3425503250474637`", "1.9363415695398773`", "0", "0", "0"},
     {"2380", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8438319205333427`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.9764673294916453`", 
      "2.3436144661593117`", "1.9388340565984463`", "0", "0", "0"},
     {"2381", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8448923198212561`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.9789510522541742`", 
      "2.3446748654472254`", "1.9413177793609753`", "0", "0", "0"},
     {"2382", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.845948990442556`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.98142604153843`", 
      "2.345731536068525`", "1.943792768645231`", "0", "0", "0"},
     {"2383", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8470019455082987`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.9838923280538152`", 
      "2.346784491134268`", "1.9462590551606163`", "0", "0", "0"},
     {"2384", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8480511980834381`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.98634994240175`", 
      "2.347833743709407`", "1.948716669508551`", "0", "0", "0"},
     {"2385", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8490967611869882`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.9887989150760503`", 
      "2.3488793068129574`", "1.9511656421828514`", "0", "0", "0"},
     {"2386", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8501386477921843`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.991239276463308`", 
      "2.349921193418153`", "1.953606003570109`", "0", "0", "0"},
     {"2387", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8511768708266442`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.9936710568432665`", 
      "2.3509594164526133`", "1.9560377839500676`", "0", "0", "0"},
     {"2388", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8522114431725285`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.996094286389197`", 
      "2.3519939887984975`", "1.958461013495998`", "0", "0", "0"},
     {"2389", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8532423776667004`", 
      RowBox[{"-", "0.037633272893198934`"}], "1.9985089951682733`", 
      "2.3530249232926694`", "1.9608757222750743`", "0", "0", "0"},
     {"2390", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.854269687100885`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.000915213141944`", 
      "2.354052232726854`", "1.9632819402487451`", "0", "0", "0"},
     {"2391", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8552933842218281`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.003312970166305`", 
      "2.3550759298477972`", "1.9656796972731059`", "0", "0", "0"},
     {"2392", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8563134817314543`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.005702295992469`", 
      "2.3560960273574234`", "1.9680690230992701`", "0", "0", "0"},
     {"2393", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8573299922870244`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.008083220266936`", 
      "2.3571125379129936`", "1.970449947373737`", "0", "0", "0"},
     {"2394", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8583429285012931`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.01045577253196`", 
      "2.358125474127262`", "1.972822499638761`", "0", "0", "0"},
     {"2395", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8593523029426647`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.012819982225917`", 
      "2.3591348485686336`", "1.975186709332718`", "0", "0", "0"},
     {"2396", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8603581281353495`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.0151758786836673`", 
      "2.3601406737613186`", "1.9775426057904684`", "0", "0", "0"},
     {"2397", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8613604165595191`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.0175234911369233`", 
      "2.3611429621854882`", "1.9798902182437244`", "0", "0", "0"},
     {"2398", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8623591806514613`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.0198628487146095`", 
      "2.3621417262774305`", "1.9822295758214106`", "0", "0", "0"},
     {"2399", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8633544328037344`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.022193980443225`", 
      "2.3631369784297034`", "1.984560707550026`", "0", "0", "0"},
     {"2400", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8643461853653206`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.0245169152472036`", 
      "2.3641287309912897`", "1.9868836423540046`", "0", "0", "0"},
     {"2401", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8653344506417799`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.026831681949272`", 
      "2.3651169962677487`", "1.9891984090560733`", "0", "0", "0"},
     {"2402", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8663192408954025`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.0291383092708086`", 
      "2.3661017865213716`", "1.9915050363776097`", "0", "0", "0"},
     {"2403", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8673005683453605`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.031436825832199`", 
      "2.3670831139713293`", "1.993803552939`", "0", "0", "0"},
     {"2404", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8682784451678602`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.033727260153191`", 
      "2.368060990793829`", "1.9960939872599919`", "0", "0", "0"},
     {"2405", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8692528834962929`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.036009640653249`", 
      "2.369035429122262`", "1.9983763677600501`", "0", "0", "0"},
     {"2406", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8702238954213853`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.038283995651907`", 
      "2.3700064410473543`", "2.0006507227587083`", "0", "0", "0"},
     {"2407", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8711914929913497`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.0405503533691185`", 
      "2.3709740386173186`", "2.0029170804759198`", "0", "0", "0"},
     {"2408", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8721556882120334`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.0428087419256085`", 
      "2.3719382338380024`", "2.0051754690324097`", "0", "0", "0"},
     {"2409", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8731164930470677`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.045059189343221`", 
      "2.3728990386730366`", "2.007425916450022`", "0", "0", "0"},
     {"2410", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8740739194180166`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.047301723545267`", 
      "2.3738564650439855`", "2.009668450652068`", "0", "0", "0"},
     {"2411", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8750279792045241`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.049536372356872`", 
      "2.374810524830493`", "2.011903099463673`", "0", "0", "0"},
     {"2412", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8759786842444622`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.0517631635053193`", 
      "2.3757612298704314`", "2.0141298906121206`", "0", "0", "0"},
     {"2413", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8769260463340777`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.053982124620396`", 
      "2.3767085919600466`", "2.0163488517271975`", "0", "0", "0"},
     {"2414", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.877870077228138`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.0561932832347347`", 
      "2.3776526228541073`", "2.018560010341536`", "0", "0", "0"},
     {"2415", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8788107886400779`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.0583966667841556`", 
      "2.378593334266047`", "2.020763393890957`", "0", "0", "0"},
     {"2416", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8797481922421441`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.060592302608006`", 
      "2.379530737868113`", "2.0229590297148072`", "0", "0", "0"},
     {"2417", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8806822996655402`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.062780217949501`", 
      "2.380464845291509`", "2.0251469450563024`", "0", "0", "0"},
     {"2418", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8816131225005717`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.064960439956061`", 
      "2.3813956681265407`", "2.0273271670628623`", "0", "0", "0"},
     {"2419", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8825406722967887`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.0671329956796476`", 
      "2.3823232179227576`", "2.029499722786449`", "0", "0", "0"},
     {"2420", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8834649605631302`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.0692979120771002`", 
      "2.3832475061890994`", "2.0316646391839015`", "0", "0", "0"},
     {"2421", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8843859987680662`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.0714552160104702`", 
      "2.3841685443940355`", "2.0338219431172715`", "0", "0", "0"},
     {"2422", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8853037983397406`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.073604934247355`", 
      "2.3850863439657095`", "2.0359716613541563`", "0", "0", "0"},
     {"2423", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8862183706661123`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.0757470934612283`", 
      "2.3860009162920814`", "2.0381138205680296`", "0", "0", "0"},
     {"2424", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8871297270950972`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.0778817202317734`", 
      "2.3869122727210663`", "2.0402484473385747`", "0", "0", "0"},
     {"2425", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8880378789347085`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.080008841045211`", 
      "2.387820424560678`", "2.0423755681520124`", "0", "0", "0"},
     {"2426", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8889428374531974`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.0821284822946295`", 
      "2.3887253830791666`", "2.044495209401431`", "0", "0", "0"},
     {"2427", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8898446138791923`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.0842406702803107`", 
      "2.3896271595051615`", "2.046607397387112`", "0", "0", "0"},
     {"2428", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8907432194018391`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.086345431210058`", 
      "2.390525765027808`", "2.0487121583168593`", "0", "0", "0"},
     {"2429", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.891638665170939`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.0884427911995203`", 
      "2.391421210796908`", "2.0508095183063215`", "0", "0", "0"},
     {"2430", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8925309622970876`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.090532776272516`", 
      "2.3923135079230566`", "2.0528995033793174`", "0", "0", "0"},
     {"2431", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8934201218518124`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.0926154123613574`", 
      "2.3932026674777815`", "2.0549821394681587`", "0", "0", "0"},
     {"2432", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8943061548677101`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.0946907253071703`", 
      "2.394088700493679`", "2.0570574524139715`", "0", "0", "0"},
     {"2433", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8951890723385839`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.096758740860216`", 
      "2.394971617964553`", "2.0591254679670175`", "0", "0", "0"},
     {"2434", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8960688852195794`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.0988194846802113`", 
      "2.3958514308455485`", "2.0611862117870126`", "0", "0", "0"},
     {"2435", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.896945604427321`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.100872982336645`", 
      "2.39672815005329`", "2.0632397094434465`", "0", "0", "0"},
     {"2436", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8978192408400469`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.1029192593090973`", 
      "2.3976017864660157`", "2.0652859864158986`", "0", "0", "0"},
     {"2437", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8986898052977446`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.1049583409875536`", 
      "2.3984723509237136`", "2.067325068094355`", "0", "0", "0"},
     {"2438", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.8995573086022848`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.106990252672722`", 
      "2.399339854228254`", "2.0693569797795233`", "0", "0", "0"},
     {"2439", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.9004217615175559`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.109015019576346`", 
      "2.400204307143525`", "2.0713817466831475`", "0", "0", "0"},
     {"2440", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.9012831747695975`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.1110326668215174`", 
      "2.4010657203955663`", "2.0733993939283186`", "0", "0", "0"},
     {"2441", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.9021415590467332`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.113043219442987`", 
      "2.4019241046727022`", "2.0754099465497884`", "0", "0", "0"},
     {"2442", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.9029969249997034`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.1150467023874775`", 
      "2.4027794706256724`", "2.0774134294942788`", "0", "0", "0"},
     {"2443", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.9038492832417976`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.1170431405139913`", 
      "2.4036318288677667`", "2.0794098676207926`", "0", "0", "0"},
     {"2444", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.9046986443489857`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.1190325585941197`", 
      "2.4044811899749545`", "2.081399285700921`", "0", "0", "0"},
     {"2445", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.9055450188600499`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.12101498131235`", 
      "2.405327564486019`", "2.083381708419151`", "0", "0", "0"},
     {"2446", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.9063884172767146`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.122990433266371`", 
      "2.4061709629026837`", "2.085357160373172`", "0", "0", "0"},
     {"2447", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.9072288500637773`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.1249589389673798`", 
      "2.4070113956897465`", "2.087325666074181`", "0", "0", "0"},
     {"2448", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.9080663276492383`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.1269205228403854`", 
      "2.4078488732752072`", "2.0892872499471866`", "0", "0", "0"},
     {"2449", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.9089008604244302`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.128875209224511`", 
      "2.4086834060503994`", "2.091241936331312`", "0", "0", "0"},
     {"2450", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.9097324587441464`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.130823022373296`", 
      "2.4095150043701157`", "2.0931897494800973`", "0", "0", "0"},
     {"2451", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.9105611329267702`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.1327639864549983`", 
      "2.4103436785527395`", "2.0951307135617996`", "0", "0", "0"},
     {"2452", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.9113868932544024`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.134698125552893`", 
      "2.4111694388803713`", "2.0970648526596944`", "0", "0", "0"},
     {"2453", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.9122097499729888`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.136625463665572`", 
      "2.411992295598958`", "2.0989921907723734`", "0", "0", "0"},
     {"2454", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.9130297132924479`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.1385460247072405`", 
      "2.412812258918417`", "2.100912751814042`", "0", "0", "0"},
     {"2455", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.9138467933867969`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.1404598325080144`", 
      "2.4136293390127657`", "2.1028265596148157`", "0", "0", "0"},
     {"2456", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.9146610003942784`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.1423669108142174`", 
      "2.4144435460202476`", "2.1047336379210186`", "0", "0", "0"},
     {"2457", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.9154723444174862`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.1442672832886727`", 
      "2.415254890043455`", "2.106634010395474`", "0", "0", "0"},
     {"2458", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.9162808355234899`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.1461609735109994`", 
      "2.416063381149459`", "2.1085277006178007`", "0", "0", "0"},
     {"2459", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.9170864837439613`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.1480480049779036`", 
      "2.41686902936993`", "2.110414732084705`", "0", "0", "0"},
     {"2460", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.9178892990752971`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.1499284011034705`", 
      "2.417671844701266`", "2.1122951282102718`", "0", "0", "0"},
     {"2461", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.9186892914787446`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.1518021852194544`", 
      "2.418471837104714`", "2.1141689123262557`", "0", "0", "0"},
     {"2462", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.9194864708805238`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.1536693805755682`", 
      "2.419269016506493`", "2.1160361076823695`", "0", "0", "0"},
     {"2463", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.9202808471719518`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.1555300103397728`", 
      "2.4200633927979207`", "2.117896737446574`", "0", "0", "0"},
     {"2464", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.9210724302095648`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.1573840975985634`", 
      "2.4208549758355336`", "2.1197508247053647`", "0", "0", "0"},
     {"2465", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.9218612298152404`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.1592316653572574`", 
      "2.4216437754412095`", "2.1215983924640587`", "0", "0", "0"},
     {"2466", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.9226472557763202`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.1610727365402775`", 
      "2.422429801402289`", "2.123439463647079`", "0", "0", "0"},
     {"2467", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.9234305178457303`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.162907333991439`", 
      "2.4232130634716995`", "2.1252740610982404`", "0", "0", "0"},
     {"2468", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.9242110257421027`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.164735480474231`", 
      "2.423993571368072`", "2.127102207581032`", "0", "0", "0"},
     {"2469", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.9249887891498962`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.1665571986720997`", 
      "2.4247713347758655`", "2.128923925778901`", "0", "0", "0"},
     {"2470", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.9257638177195161`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.16837251118873`", 
      "2.425546363345485`", "2.1307392382955315`", "0", "0", "0"},
     {"2471", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.9265361210674341`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.170181440548326`", 
      "2.426318666693403`", "2.1325481676551274`", "0", "0", "0"},
     {"2472", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.9273057087763077`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.1719840091958904`", 
      "2.4270882544022765`", "2.1343507363026917`", "0", "0", "0"},
     {"2473", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.928072590395099`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.1737802394975017`", 
      "2.4278551360210683`", "2.136146966604303`", "0", "0", "0"},
     {"2474", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.9288367754391934`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.175570153740594`", 
      "2.4286193210651623`", "2.1379368808473953`", "0", "0", "0"},
     {"2475", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.9295982733905171`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.1773537741342324`", 
      "2.4293808190164863`", "2.1397205012410336`", "0", "0", "0"},
     {"2476", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.9303570936976556`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.179131122809388`", 
      "2.4301396393236248`", "2.141497849916189`", "0", "0", "0"},
     {"2477", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.9311132457759701`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.180902221819214`", 
      "2.430895791401939`", "2.143268948926015`", "0", "0", "0"},
     {"2478", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.9318667390077149`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.182667093139317`", 
      "2.431649284633684`", "2.1450338202461183`", "0", "0", "0"},
     {"2479", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.9326175827421536`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.1844257586680325`", 
      "2.4324001283681227`", "2.1467924857748337`", "0", "0", "0"},
     {"2480", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.933365786295675`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.186178240226694`", 
      "2.433148331921644`", "2.1485449673334953`", "0", "0", "0"},
     {"2481", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.9341113589519091`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.187924559559906`", 
      "2.4338939045778782`", "2.1502912866667074`", "0", "0", "0"},
     {"2482", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.9348543099618417`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.189664738335813`", 
      "2.4346368555878106`", "2.1520314654426143`", "0", "0", "0"},
     {"2483", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.9355946485439296`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.1913987981463663`", 
      "2.4353771941698987`", "2.1537655252531676`", "0", "0", "0"},
     {"2484", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.9363323838842149`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.1931267605075955`", 
      "2.436114929510184`", "2.1554934876143967`", "0", "0", "0"},
     {"2485", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.9370675251364389`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.194848646859873`", 
      "2.436850070762408`", "2.1572153739666744`", "0", "0", "0"},
     {"2486", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.9378000814221558`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.196564478568181`", 
      "2.437582627048125`", "2.1589312056749823`", "0", "0", "0"},
     {"2487", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.9385300618308458`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.1982742769223758`", 
      "2.438312607456815`", "2.160641004029177`", "0", "0", "0"},
     {"2488", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.9392574754200278`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.199978063137453`", 
      "2.439040021045997`", "2.162344790244254`", "0", "0", "0"},
     {"2489", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.9399823312153721`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.2016758583538096`", 
      "2.439764876841341`", "2.164042585460611`", "0", "0", "0"},
     {"2490", "0", "0", "0", "0", "0", "409.88136197289793`", "0", 
      "2.0028153469329895`", "1.1185`", "3.1213153469329895`", 
      "1.499782545625969`", "0.940704638210812`", 
      RowBox[{"-", "0.037633272893198934`"}], "2.203367683637508`", 
      "2.440487183836781`", "2.1657344107443093`", "0", "0", "0"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.8390324352408285`*^9, {3.839033098662942*^9, 3.839033153686508*^9}, 
   3.8390332259845157`*^9, 3.8390333140471277`*^9, 3.8390333670135803`*^9, 
   3.8390334007522616`*^9, {3.839033508027255*^9, 3.8390335209194183`*^9}, 
   3.8390337332454033`*^9, 3.8390337937205505`*^9},
 CellLabel->
  "Out[94]//MatrixForm=",ExpressionUUID->"fe654833-c9f4-469c-8d23-\
a3418389c982"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"mtemp", "=", 
   RowBox[{"transFairN", "[", 
    RowBox[{"[", 
     RowBox[{";;", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "16"}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"amtemp", "=", "mtemp"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"amtemp", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "2"}], "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"mtemp", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"2", ";;"}], ",", "2"}], "]"}], "]"}], "-", 
    "0.04858988775395398"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.8384673382714515`*^9, 3.8384673984126883`*^9}, {
  3.8384674315562353`*^9, 3.8384674650654316`*^9}, {3.8384727061150846`*^9, 
  3.8384727069535804`*^9}, {3.8384868144626937`*^9, 3.838486819715597*^9}, {
  3.838492028917917*^9, 3.838492029682382*^9}},
 CellLabel->"In[68]:=",ExpressionUUID->"860dbcf3-c5de-489d-bae9-48b9700cbdc0"],

Cell[BoxData[
 RowBox[{
  RowBox[{"check", "=", 
   RowBox[{"Import", "[", "\"\<observed_climate.csv\>\"", "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.838467074927126*^9, 3.83846711046072*^9}, {
  3.838467172623846*^9, 3.8384671743218393`*^9}},
 CellLabel->"In[46]:=",ExpressionUUID->"f73f00ff-47ba-4753-b396-df8469b1855c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"check", "[", 
      RowBox[{"[", 
       RowBox[{
        RowBox[{"2", ";;"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}], ",", 
     RowBox[{"amtemp", "[", 
      RowBox[{"[", 
       RowBox[{
        RowBox[{"2", ";;"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "}"}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8384920471863956`*^9, 3.838492100163594*^9}},
 CellLabel->"In[73]:=",ExpressionUUID->"1e539bd4-2cbf-4d7f-b0ab-1086461cd226"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
      NCache[
       Rational[1, 72], 0.013888888888888888`]], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxd0m1Ik1EUB/D1wpJQcCVpWVGgYLRYVISV5j9QCmaS4gMLJGMVZBiZ+SFM
RoOCwQzRD4My76kUJiLSQkNS06SiZdRsmraaaS2zfEFXkYv1su1cP9SFh4cf
995zzzn3bjSeyTuxWKVSpYW+8D8ybgjYTTfnrMkvMiJuEBiqL0lfPuRmNwps
jwzpZoELcS37x8oH2LcF2tdfnsxtb2G3CngcA0ndhl52u4Al0EZu9VN2p8Ce
YGlnR0cfu0fAoWQZnbrH7IcCz90m2GNk/CcCuY5ijUbTz34m8GuuNkFvesB2
/Zf/gMCf+YOVyd3D7GGBGtfhWI1Grn8rcO1qeDjZowKbCqp6v6d0sn0C04ZT
NYXa1+wJgfBsQdVL9pTArSKrLWiU87MCZ0Pdqi/xsr8J5EUaMsqeF1i07M45
D4bYQYFs59dQ/DG2inDEVla0pO4VeylhVVsgX1EG2VGEaqf9+k6XPC+aIMwr
QvXL/bGEyPHp79lxhOgRxRevH2EnEPpbs/Qmh4+9lpCa2OzwxX9gbyBs05q7
Df437CTCOtOuEa9X1pNC/+arJaypK3Wrd39kbyX8jB2MKfPIencQutS/Q/WM
s1MXzptkpxG2ZEbts8fIfEBwd/y4b/DLfDIJjYa7Fotlgn2AZP+/sLMJ48Yr
2sAj6UOEhvBzrZfr80ne5xTbQPDW1OpsQbm+gDBWHn7A0kcJ4dcc1/KJfZyg
099rNefIfE8SipVqg986zS5e6MdndgnB6qloamqS8coW6pH7zxNW23oKtQG5
v4LQY54K3ecc+yLhnXp4ZmbGz75EyDq9V1EUOW8hbHb1mXMSZ9mVBJhWHnPq
/Bl/AY8aS8A=
      "]]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], PointSize[
      NCache[
       Rational[1, 72], 0.013888888888888888`]], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJwt031MDXoYB/Aj5l7qj6QZ5qW67rTVddO8TnO+C4ndTYh7zbsQJ2TuZdlQ
maZOrZu46STPw7x01y11rJxmt0OtVE7eOhVSqSg5hzo5GVpGPL9ne/bs8893
zz9f723Rq3a4aDSaJUP77X6fGMKE/HUpvYertN99hPAsLbkuM105jnDj/crN
f+qVTxBGpbs0xsYqJxKWBmtOGRKUUwguRvd3xVnKaQQ/j6X2T2blMwS9JWXx
NqdyJmGq2z+V5xZWi7MJwz+b3p4rUr5ASI6IquNNNeLLBPvx7MJl4+6K/yUs
6DqYON2knEdgXWp34xqLuJDw03nX+cbRteIiwmzdl8TIJuUSgjHMbNZW3RP/
TzD8fjT7leW++Dbh5AfXgNOdD8QVhP7I7e2j0h6Kqwmt98/+4lz+SFxLCCrI
Mvr414kfEhw5UzaM+9kqrid4urd0FHrVi58QmqetvjpjYoO4mXDnVHzhbo9G
cRsB2tjAYyMei18S2grKyhY4lLsJO6MfJUR1PBG/GcpflhCb1flU7CCEbL7s
mu9oEvcT1n56X2R0PhN/JGyxBef1djWLBwk33TyGZ1haxBpGVvDFkNz8VvEI
hq305nGd4bn4R8bkRT3Fx0LbxG6MTZbU1JIqZXeG/ePAkurl7WJPxpTgjIHc
BuXxjL/7QnzzdnWIJzHKk1L6HYPKXgzdOhf7F/0L8TTGYOi+3C6Pl2JfxqUx
M20Fmcr+jNZD0c9LvTrFAYymp5X5MdeUZzHie/zMk4K6xPMYLy78CtNt5SDG
69DrW01Br8RgGKyeV32vKy9mrCzRGrb6dItDGQ2164svnlb+jWHaW+7lPfq1
OIzhHbeCjiQohzNK5w3MaRlpE//BqHUkmcvTlTcwds+9ElDqbxdvGfqnffUt
a73ydkZFxhxdfNIb8S7G+gPDVtSEvBXvYTgjrHU7f+gR72dE6PMarNXKfzEi
/wvP2ZjcK45hnHVWBlZMd6j+DznQdj5HrxzHqEktcw/rUT7BiGrxibiyqk/1
n2HdXzb2rqlP+xXL24mh
      "]]}}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{1948.5625, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->600,
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{1948.5625, 2019.}, {0, 1.183333333}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.838492067219513*^9, 3.8384921009019394`*^9}},
 CellLabel->"Out[73]=",ExpressionUUID->"1eb56dcc-cda8-402b-b55e-0a27a8e095dd"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"cdat", "=", 
   RowBox[{"Import", "[", "\"\<CO2_concentration_GCP.csv\>\"", "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.8384756106147313`*^9, 3.8384756293324413`*^9}, {
  3.8384765774652576`*^9, 3.838476590138352*^9}},
 CellLabel->"In[53]:=",ExpressionUUID->"346baede-a1f2-4514-aa6a-224616f9a5f1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dimensions", "[", "cdat", "]"}]], "Input",
 CellChangeTimes->{{3.8384756336297636`*^9, 3.8384756380139823`*^9}},
 CellLabel->"In[58]:=",ExpressionUUID->"cc0dd6eb-ec9a-4fd9-9e4d-f85941f64be2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"323", ",", "4"}], "}"}]], "Output",
 CellChangeTimes->{3.8384756387785234`*^9, 3.8384766239096565`*^9, 
  3.8384917622778254`*^9},
 CellLabel->"Out[58]=",ExpressionUUID->"f9ad59a5-271d-49b4-99b7-2672cf9d2a0b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cdat", "[", 
  RowBox[{"[", 
   RowBox[{"{", 
    RowBox[{"252", ",", "307"}], "}"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.838475644915618*^9, 3.838475645541032*^9}, {
  3.8384766287126236`*^9, 3.8384766390640144`*^9}, {3.8384917393691287`*^9, 
  3.8384917702482033`*^9}},
 CellLabel->"In[59]:=",ExpressionUUID->"7d71344f-43b1-4d2a-a613-84ab6b477c18"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1950", ",", "12", ",", "3740.47`", ",", "311.7058333`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"2005", ",", "12", ",", "4541.42`", ",", "378.4516667`"}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.8384756462267756`*^9, {3.8384766326352425`*^9, 3.8384766395158453`*^9}, {
   3.8384917312994833`*^9, 3.838491770967832*^9}},
 CellLabel->"Out[59]=",ExpressionUUID->"c1b65d5c-b124-4b02-889a-cd455d05ceae"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"transFairN", "[", 
   RowBox[{"[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "12"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "7"}], "}"}]}], "]"}], "]"}], "//", 
  "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.8384859714535065`*^9, 3.8384860147101984`*^9}},
 CellLabel->
  "In[642]:=",ExpressionUUID->"0f156a84-b752-4ce4-99fa-3ace9530f1f4"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"\<\"1-Y\"\>", "\<\"7-C\"\>"},
     {"1960", "311.21871162305797`"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.8384859836294622`*^9, 3.838486015075367*^9}},
 CellLabel->
  "Out[642]//MatrixForm=",ExpressionUUID->"42ea013b-5d60-473e-8933-\
e65c8c628810"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"transFairN", "[", 
      RowBox[{"[", 
       RowBox[{
        RowBox[{"2", ";;"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "7"}], "}"}]}], "]"}], "]"}], ",", 
     RowBox[{"cdat", "[", 
      RowBox[{"[", 
       RowBox[{
        RowBox[{"252", ";;", "320"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "4"}], "}"}]}], "]"}], "]"}]}], "}"}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.838462915638306*^9, 3.8384629768364897`*^9}, {
  3.838467185733942*^9, 3.8384672070766435`*^9}, {3.8384674766045947`*^9, 
  3.838467505321786*^9}, {3.838467759246047*^9, 3.8384677717378707`*^9}, {
  3.838476649664179*^9, 3.8384766549480405`*^9}, {3.8384767894750433`*^9, 
  3.8384767902908897`*^9}, {3.838485745047056*^9, 3.8384857465480413`*^9}, {
  3.8384857837903795`*^9, 3.838485791948988*^9}, {3.838491938766786*^9, 
  3.8384919408863735`*^9}},
 CellLabel->"In[64]:=",ExpressionUUID->"335fa024-c033-47dc-b90c-447a415e13b1"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
      NCache[
       Rational[1, 72], 0.013888888888888888`]], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJwtz3ssFQAUBvCb23rIPGJl1XqxZdWSWEVaX6GQVnpi1sM8oxDi6jLqWv4g
hlmKc0qqWyu7QsPaomlXoVxRJFs181is2mitpOSes519+/1z9p1VIbEHw0wU
CoXX9P7PmUkhJI3kOrz3TsCM1QTX6pJZgwfEGYTqJqXCECTWEB6/jdVtCBVn
E6zH9u0pOyPOIeweeVQenSzOJ7xsK7ZPuyguImRORmk9r4ivEgy67qG118Sl
BNXfnCXJd8Q3CA+r/FzCH4krCMpdHm/mPBVrCSdqLnRyq/gBocdmuFbTI9YR
4gsc77oPimsIK8bDG/PHxXXT/ZuXxqqViUY/Ifyo2nRwnbW4kdDS/33Y0k7c
THDpP54Y5ixuIRzK4khTL3EbYSJe7T91TNxB+Huq3C3mtLiLYFvUONKeJu4h
tOr+3PMsEH8gbOlL9xm7Lf5IuFRS6uNWLx4geP2KTy5/JR4mOFlm9e4dEI8S
zA126579En8jdNicy0u1SjJ6nKB1trZwXyP+SdDnbFeNbRNPEnwdtX5p/mIF
o9e8KyckQjyb0aPW7wxKF89jVASnxwYXi80YoQlRfKFSbMkYnTLdT3qxDcNb
n2Vl/llsy9COG7hoUryMUXdr0qpy8XmjVzJ+ZNdGP3cW2zOKBxd5YZ/YgTHc
HuPpHyFez/DtLc27nCneyHjbqHmqKhW7ML7lBh2JqxNvZZBJYtP8LrE746z/
8t+uX8VgbJ/KvF5jmmy0J8OurNDNYY3YmxHw7k93oYfYj6EJqAvUnRIfYHxS
Dt3vzxQfZjQ4HStbXSEOYJjvmXBy0IuDGRahfQ07vohPMhJS622PW6YYHcoo
7/aZq9gsjmScXzn35migOGb6vlnkgp8Z4jiGyzzrV/n3xIkMs1yPgLxOcQpj
0YuOoKjfYvX0fwWas0ftVUZnMG67ve42+Ik1jIktIUULk8TZjCu2SoslpMI/
1jZexg==
      "]]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], PointSize[
      NCache[
       Rational[1, 72], 0.013888888888888888`]], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJwt0w1IU1EUB/DZZIQlKA2yFFuiMGF9QJIVKSc1MhRrljXIcEpRWqDVTJ0i
JiqWfZjZF+U5gtJCw7IEDfqiVglJTQoU0ygwXSgipVZg0Jv3f+Hx+HHvu/f/
zjtvdU5++uFFOp1uu3b57gujmGnw2eflKaWnaMFlTNamR21t5XAFU19n9s+6
SriKydS8z/K3Bq5lis689HK2Dj7PNGntCa++DNczraqesPZchxuZSo0dO74x
fIOpW78yOLgdvs10Ii5goKUbbmbybW9+A7ciTz98l2nPx7NZli/wPaaDbWs8
uWPwAybtNKdxGu5i8m1fMAf3wEscyk+QJwR+wVQ/Ytc3RcFuppg0DnTEw71M
2tNxAbvgPqYDjv2hXhvsYZoza2+QB39iStfKM3EBHmRyBzVu9FyFh5lO2go7
R1vgr8jzEB5lOnKmn1zvYC/TBt/4AU8izz94mqnKMzYyElaoPMO0c/771FQM
/Ifp8ebp1w3J8DxTslaujmxYJ+p8J+wv5ItvbYAXi8p/B16K9W44SKhs3YqI
iHHYKCqv32nlEKGb5Wuf24xwmNDvxLe5+mjYJKq/YuFIrE+CzUK+dnJmwhZR
378UXo+81+AYIb/QY0PUDm8Suug6lxY6AG8V1W8zMAnFRyWUdxqKlJNE/S8m
OBl5EuBUoVat/AO58G7MV8N7hZZdGTZsccE21KMXzhTVX17YLmTeFuntMhQr
H8L+Jvgo5hPh40LheRVFRXa4QFT/V8IOoffjsa7ADrhY6NWs1qAf4DKhW13+
jqFfcIVQjeFpQ5a5RLlK6H5OakZGClyL+uWX0H+RYlDH
      "]]}}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{1948.5833333333335`, 302.9239224073852},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->600,
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{1948.5833333333335`, 2018.}, {302.9239224073852, 
   409.88136197289793`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.83846292637302*^9, 3.838462977727253*^9}, 
   3.8384643212043085`*^9, 3.838465395611436*^9, 3.838467068763502*^9, 
   3.8384672080620055`*^9, {3.8384674798179827`*^9, 3.8384675071088824`*^9}, 
   3.8384676717890034`*^9, 3.838467772538886*^9, 3.8384727173629*^9, 
   3.8384766568993015`*^9, 3.8384767912438674`*^9, 3.8384868470802593`*^9, {
   3.8384919220351877`*^9, 3.8384919414817104`*^9}},
 CellLabel->"Out[64]=",ExpressionUUID->"8ee7a66f-9af8-4ee1-8cb2-484466766839"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"transFairN", "[", 
      RowBox[{"[", 
       RowBox[{
        RowBox[{"2", ";;"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "16"}], "}"}]}], "]"}], "]"}], ",", 
     RowBox[{"amtemp", "[", 
      RowBox[{"[", 
       RowBox[{
        RowBox[{"2", ";;"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}], ",", 
     RowBox[{"check", "[", 
      RowBox[{"[", 
       RowBox[{
        RowBox[{"2", ";;"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]}], "}"}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.838467746191677*^9, {3.8384731567308683`*^9, 3.8384731640113907`*^9}},
 CellLabel->"In[49]:=",ExpressionUUID->"365e7b34-80ec-4f6e-bd52-70a4b11d2285"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
      NCache[
       Rational[1, 72], 0.013888888888888888`]], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJwt031MFHQYB3Bitkl5oGIzzQQZTqdCRi1xQ/g2uIFi40VnaRbFSImOxII6
8SQVhy8oIleEps9zJSCgY2FHUGqczRZbuXjrPE/MAxE9ODoEFWyXdvF7nu3Z
s89fz55n+85L35L6nq+Pj4/W2//PidITWsKnzW0+3h4zYQMh7vms8AGzeCdh
MHpaVfOP4j2EzrFu7ekL4n2EwMoVbfd/FR8kZDhWNtTZxKUE97XN2/2HxZ8T
tLYU3aB/h3IF4c20R+uGIsXHCZZvjsWH68UmgmNkmS2xXVxJeJBs8Hz/Uqdy
DSH/s7CZ7x4SnyFk/2Kfs6lf/C3hS+OTIemrupTNhFNb8y8/fU7cTDDXmh9P
X/6n8nnCvFCjMfui2OJ1VN7Fs6lW5UuE35qeulIyKm4lzF9k7bjUcEX5d0IA
NYU8V25TbiO0/hB8cqjsqnKX998D6+u1RruyjdDkLn3i5pFryt2E4NiU/LTD
3coOQsSZ3S80Fl1X7iNsK3/R95VP/1K+Q7h8Iqo6KfuGsovgKhtD13KH8jDh
oTP9LlvE9wgjdXlZW2N7lMcJuZNMDtNPYg+hd/3a+xERvco+DG188cLbJ8WT
GF9pLBfmzr6pPJmxpHD3a1PKxVMY0ZW++qRn+pSnMqYXeuriK8QzGDuSI4vd
IbeUn2V8Z3L11jeK5zAO5CVuMq3sVw5m6INaFlRYxaGMf79OrNO8dVt5IaO2
sc/4R494CcPi/GCN//t3lJcy0vofjs98IH6ZsSHauX9WoVM5ktE2WHzu9OQB
5ShGwM9HA1OKxGBYN3vCEjziOIZfUN+H/+gGlRO892e0nJ99Q7yasdScVGBd
51JOZjRoAnRjneK1jNjhq7q3Xx9SfoORsNhRMuuWeCOj9KOgTPfOv5Xf8e7f
daS2epFbOYPhqqqpOewQZzJy/Xrs7qRhZR1j36mC0rMN4hxGqsYvxx54VzmX
sddpGK/6RKz3/u/j9hMldrGBUW/eXtAUMyL5Z2wsenQsrFq8h7GG5i/eqxmV
/DMMOa9u+SJvNOY/5kaFUg==
      "]]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], PointSize[
      NCache[
       Rational[1, 72], 0.013888888888888888`]], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJwt01tME3YUBnBwkIjhAZ06mWSCmymycbGiEzHyDS/VIIpSIixWRFREGay2
Kll0YQlW5nTe0Gg05xQnShamaBxd8BplUlEQRETHReQ22YqKdlDURdHzP8nJ
ye/py3n4AlZmLVk9xM3Nbc7gvrvvJ5vgSm0NGBi4HvXeWwhDvtoXbQiqEOcQ
4nJbQ19OUc4l+PdtNj6MVM4jWBdGWMxxyjsJ0RWL57UYlfcQEi/taiq0KucT
PGwpl5JblA8Rwv4s25+qtYuPEl7GvDB3lihbCdMdwQf9U2+IjxPWFJW29Gkq
xUWETE/fkTGNysUE/V7TuIRdN8UlhKLgGxNjE26JzxHs3WdzrFOrxH8Q2pI0
nae01eILhAsLO7xXzbotvkJYHqUP79fWiMsJQ893z6+rU7YTVgb/PsdrX634
FmFBwcEDyZvuiGsInhffjNKa6sR3Ca97pgXsMN0V3yc4n2eZNRvqxU0Ew9yw
nl+y7olbCVmnU44NrGkQdxBKD/ts/G7pffFjwrCCsb75sQ/EDsKoidVOR/xf
4meE0IbjCbkpjWInISCpUqdJaxK7CBO8x4VbDM3i1wR323bDr7NbxG6Mir3/
XRsR+FDswYjYHdqPYa3ioYxKj+eWEIuyN6NpwoYzRs9HYh9GiUdGR3qe8kjG
2Dsny4d/2CYew1g8fplfbaGyHyOwv4yvRrSL/RmjC0JSyq4rf8Y48un59tDY
DnEgQ/elvqq3VvkLxvL1jTvDkjrFYYz/09K107uUwxmuy4nXIk1d4mmMzG9e
OatcyjMYv83yijVt+lsMhrl7fdo6h/JsxklrfJGf4bF43uD/nSF9M24rL2BU
T7lsc83tFscxFu3+vtC3XFnPeGScfyJH9484kdFVvMgeWa+8jBHi/LlguPFf
8YrB/A/c2+0fO8SrGDs0Y9rO1CivZVjyJz1139MjzmCcqsn4env8E/G3jOij
P/g2fPRUbGYU69ODMpuVsxnZ4T+W8ZJnqv+MrRsnH7HblHMYn+tKbTM/6VX9
Z4xPbtYd2qacx4iZNPDTiZ7eqLfCSXXV
      "]]}, 
    {RGBColor[0.560181, 0.691569, 0.194885], PointSize[
      NCache[
       Rational[1, 72], 0.013888888888888888`]], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxd0m1Ik1EUB/D1wpJQcCVpWVGgYLRYVISV5j9QCmaS4gMLJGMVZBiZ+SFM
RoOCwQzRD4My76kUJiLSQkNS06SiZdRsmraaaS2zfEFXkYv1su1cP9SFh4cf
995zzzn3bjSeyTuxWKVSpYW+8D8ybgjYTTfnrMkvMiJuEBiqL0lfPuRmNwps
jwzpZoELcS37x8oH2LcF2tdfnsxtb2G3CngcA0ndhl52u4Al0EZu9VN2p8Ce
YGlnR0cfu0fAoWQZnbrH7IcCz90m2GNk/CcCuY5ijUbTz34m8GuuNkFvesB2
/Zf/gMCf+YOVyd3D7GGBGtfhWI1Grn8rcO1qeDjZowKbCqp6v6d0sn0C04ZT
NYXa1+wJgfBsQdVL9pTArSKrLWiU87MCZ0Pdqi/xsr8J5EUaMsqeF1i07M45
D4bYQYFs59dQ/DG2inDEVla0pO4VeylhVVsgX1EG2VGEaqf9+k6XPC+aIMwr
QvXL/bGEyPHp79lxhOgRxRevH2EnEPpbs/Qmh4+9lpCa2OzwxX9gbyBs05q7
Df437CTCOtOuEa9X1pNC/+arJaypK3Wrd39kbyX8jB2MKfPIencQutS/Q/WM
s1MXzptkpxG2ZEbts8fIfEBwd/y4b/DLfDIJjYa7Fotlgn2AZP+/sLMJ48Yr
2sAj6UOEhvBzrZfr80ne5xTbQPDW1OpsQbm+gDBWHn7A0kcJ4dcc1/KJfZyg
099rNefIfE8SipVqg986zS5e6MdndgnB6qloamqS8coW6pH7zxNW23oKtQG5
v4LQY54K3ecc+yLhnXp4ZmbGz75EyDq9V1EUOW8hbHb1mXMSZ9mVBJhWHnPq
/Bl/AY8aS8A=
      "]]}}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{1948.5625, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->600,
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{1948.5625, 2019.}, {0, 1.2162069650576361`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.8384727270688457`*^9, 3.8384731648200855`*^9, 
  3.838486894332199*^9},
 CellLabel->"Out[49]=",ExpressionUUID->"dcaeca39-182e-45b9-9dc9-b1dcb8f4be79"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"da", "=", 
  RowBox[{"dalpha", "[", 
   RowBox[{"transFairN", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;"}], ",", "18"}], "]"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.838445692171412*^9, 3.838445740356785*^9}, {
  3.8384607823996453`*^9, 3.838460790245618*^9}},
 CellLabel->"In[75]:=",ExpressionUUID->"f6408a64-4af2-4cc2-a067-ab765b62fa14"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "39.30552045267541`", ",", "39.17941756627988`", ",", "39.065287737961626`",
    ",", "38.94374101507128`", ",", "38.810888357809745`", ",", 
   "38.66782140271971`", ",", "38.513652193243615`", ",", 
   "38.34483771759551`", ",", "38.15869632153772`", ",", 
   "37.947128988365876`", ",", "37.70563655416481`", ",", 
   "37.45662115138839`", ",", "37.216229808778735`", ",", 
   "36.97537894832203`", ",", "36.72158197595854`", ",", 
   "36.451236649620114`", ",", "36.16369328967994`", ",", 
   "35.86201529362006`", ",", "35.54746124884696`", ",", 
   "35.216131831810344`", ",", "34.856151984713506`", ",", 
   "34.45845822186675`", ",", "34.037099904817296`", ",", 
   "33.61631303696777`", ",", "33.19851576740621`", ",", 
   "32.781992428790545`", ",", "32.374918679124676`", ",", 
   "31.977892577269813`", ",", "31.575193341181148`", ",", 
   "31.16051797181717`", ",", "30.741757925483398`", ",", 
   "30.332913624326466`", ",", "29.942423180764308`", ",", 
   "29.570175459899474`", ",", "29.203888826508773`", ",", 
   "28.834310819016537`", ",", "28.45908525964478`", ",", 
   "28.081785795395263`", ",", "27.70341490060673`", ",", 
   "27.318104156292975`", ",", "26.92544746180647`", ",", 
   "26.536558659077855`", ",", "26.161130874883384`", ",", 
   "25.797998369991546`", ",", "25.44592621762422`", ",", 
   "25.09773990471149`", ",", "24.749312104075216`", ",", 
   "24.40695181748015`", ",", "24.079988253099145`", ",", 
   "23.768227941152873`", ",", "23.469368412799668`", ",", 
   "23.181135785678634`", ",", "22.89583223182126`", ",", 
   "22.609692249272484`", ",", "22.322212668688735`", ",", 
   "22.03157556944643`", ",", "21.7333115687361`", ",", "21.425550238083815`",
    ",", "21.109417487721657`", ",", "20.787350878148573`", ",", 
   "20.464023309672484`", ",", "20.145992013742216`", ",", 
   "19.833314214920392`", ",", "19.525363742228365`", ",", 
   "19.222134092648048`", ",", "18.92413832299644`", ",", 
   "18.631556730368175`", ",", "18.344791511801304`", ",", 
   "18.06363482552115`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.8384456934648767`*^9, 3.838445741752761*^9, 3.8384461582492037`*^9, 
   3.8384607914907503`*^9, {3.8384735416272726`*^9, 3.8384735573030753`*^9}, 
   3.838492528920434*^9},
 CellLabel->"Out[75]=",ExpressionUUID->"80332714-82a2-467f-b811-149d32007a28"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<dalpa.csv\>\"", ",", "da"}], "]"}]], "Input",
 CellChangeTimes->{{3.8384461600115647`*^9, 3.8384461742044764`*^9}},
 CellLabel->"In[76]:=",ExpressionUUID->"48942292-0b13-45b4-b4fa-88cb28a84fed"],

Cell[BoxData["\<\"dalpa.csv\"\>"], "Output",
 CellChangeTimes->{3.838446175283641*^9, 3.8384607936636534`*^9, 
  3.838473558241146*^9, 3.8384925302280045`*^9},
 CellLabel->"Out[76]=",ExpressionUUID->"da6e018e-7e3f-4e02-a872-3f2f1d613d39"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"lc", "=", 
    RowBox[{"Import", "[", "\"\<landuse.csv\>\"", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.838468643894857*^9, 3.838468658369888*^9}, {
  3.8384687051947937`*^9, 3.8384687072576857`*^9}},
 CellLabel->
  "In[451]:=",ExpressionUUID->"7a9635ec-1df5-42fd-b445-3e2ea96e1510"],

Cell[BoxData[
 RowBox[{
  RowBox[{"lcint", "=", 
   RowBox[{"Interpolation", "[", 
    RowBox[{"lc", "[", 
     RowBox[{"[", 
      RowBox[{";;", ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.8384687154357824`*^9, 3.838468726859084*^9}},
 CellLabel->
  "In[452]:=",ExpressionUUID->"041eeb26-347c-4be6-bfe6-28c9656909c4"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"lcdata", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"2019", "-", "1850"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "2"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"lcdata", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "1"}], "]"}], "]"}], "=", 
    RowBox[{"1850", "+", "i", "-", "1"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", 
     RowBox[{"2019", "-", "1850"}]}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"lcdata", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "2"}], "]"}], "]"}], "=", 
    RowBox[{"lcint", "[", 
     RowBox[{"lcdata", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", "1"}], "]"}], "]"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", 
     RowBox[{"2006", "-", "1850"}]}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.838468738670842*^9, 3.838468888009165*^9}, {
  3.8384689417788863`*^9, 3.8384689432275534`*^9}},
 CellLabel->
  "In[464]:=",ExpressionUUID->"c93bd799-0f25-40c6-a08f-4a06572b6483"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<lcdata.csv\>\"", ",", "lcdata"}], "]"}]], "Input",
 CellChangeTimes->{{3.8384689540062723`*^9, 3.8384689684256086`*^9}},
 CellLabel->
  "In[468]:=",ExpressionUUID->"e2d4600b-6080-44b7-9c69-8b11ff856e32"],

Cell[BoxData["\<\"lcdata.csv\"\>"], "Output",
 CellChangeTimes->{3.838468969149887*^9},
 CellLabel->
  "Out[468]=",ExpressionUUID->"b14b6690-f916-400e-8ad2-9e30a4af5283"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"lcdata", "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.8384688100075145`*^9, 3.838468811054019*^9}, {
  3.8384689047747746`*^9, 3.8384689073777294`*^9}},
 CellLabel->
  "In[467]:=",ExpressionUUID->"44a678df-67fa-4d62-92f9-c53af752e5ed"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1850", "0.454`"},
     {"1851", "0.4747095`"},
     {"1852", "0.491416`"},
     {"1853", "0.5044365000000001`"},
     {"1854", "0.514088`"},
     {"1855", "0.5206875000000001`"},
     {"1856", "0.524552`"},
     {"1857", "0.5259985`"},
     {"1858", "0.525344`"},
     {"1859", "0.5229055`"},
     {"1860", "0.519`"},
     {"1861", "0.5139445`"},
     {"1862", "0.5080560000000001`"},
     {"1863", "0.5016515`"},
     {"1864", "0.495048`"},
     {"1865", "0.4885625`"},
     {"1866", "0.482512`"},
     {"1867", "0.47721349999999996`"},
     {"1868", "0.47298399999999996`"},
     {"1869", "0.47014049999999996`"},
     {"1870", "0.469`"},
     {"1871", "0.48109949999999996`"},
     {"1872", "0.49485599999999996`"},
     {"1873", "0.5099065`"},
     {"1874", "0.525888`"},
     {"1875", "0.5424375`"},
     {"1876", "0.559192`"},
     {"1877", "0.5757885`"},
     {"1878", "0.591864`"},
     {"1879", "0.6070555`"},
     {"1880", "0.621`"},
     {"1881", "0.6238635`"},
     {"1882", "0.625328`"},
     {"1883", "0.6256045`"},
     {"1884", "0.624904`"},
     {"1885", "0.6234375`"},
     {"1886", "0.621416`"},
     {"1887", "0.6190505`"},
     {"1888", "0.616552`"},
     {"1889", "0.6141314999999999`"},
     {"1890", "0.612`"},
     {"1891", "0.612563`"},
     {"1892", "0.613704`"},
     {"1893", "0.615501`"},
     {"1894", "0.618032`"},
     {"1895", "0.621375`"},
     {"1896", "0.625608`"},
     {"1897", "0.6308090000000001`"},
     {"1898", "0.6370560000000001`"},
     {"1899", "0.644427`"},
     {"1900", "0.653`"},
     {"1901", "0.670707`"},
     {"1902", "0.689296`"},
     {"1903", "0.708369`"},
     {"1904", "0.727528`"},
     {"1905", "0.746375`"},
     {"1906", "0.764512`"},
     {"1907", "0.7815409999999999`"},
     {"1908", "0.797064`"},
     {"1909", "0.8106829999999999`"},
     {"1910", "0.822`"},
     {"1911", "0.8150409999999999`"},
     {"1912", "0.805928`"},
     {"1913", "0.795207`"},
     {"1914", "0.7834239999999999`"},
     {"1915", "0.771125`"},
     {"1916", "0.758856`"},
     {"1917", "0.7471629999999999`"},
     {"1918", "0.7365919999999999`"},
     {"1919", "0.7276889999999999`"},
     {"1920", "0.721`"},
     {"1921", "0.7356499999999999`"},
     {"1922", "0.75248`"},
     {"1923", "0.77091`"},
     {"1924", "0.79036`"},
     {"1925", "0.81025`"},
     {"1926", "0.83`"},
     {"1927", "0.84903`"},
     {"1928", "0.86676`"},
     {"1929", "0.88261`"},
     {"1930", "0.896`"},
     {"1931", "0.8875730000000001`"},
     {"1932", "0.876664`"},
     {"1933", "0.863831`"},
     {"1934", "0.849632`"},
     {"1935", "0.8346250000000001`"},
     {"1936", "0.819368`"},
     {"1937", "0.804419`"},
     {"1938", "0.790336`"},
     {"1939", "0.7776770000000001`"},
     {"1940", "0.767`"},
     {"1941", "0.7693735`"},
     {"1942", "0.774208`"},
     {"1943", "0.7814245`"},
     {"1944", "0.790944`"},
     {"1945", "0.8026875`"},
     {"1946", "0.816576`"},
     {"1947", "0.8325305000000001`"},
     {"1948", "0.850472`"},
     {"1949", "0.8703215`"},
     {"1950", "0.892`"},
     {"1951", "0.92188`"},
     {"1952", "0.95304`"},
     {"1953", "0.9850099999999999`"},
     {"1954", "1.01732`"},
     {"1955", "1.0495`"},
     {"1956", "1.08108`"},
     {"1957", "1.11159`"},
     {"1958", "1.14056`"},
     {"1959", "1.16752`"},
     {"1960", "1.192`"},
     {"1961", "1.203828`"},
     {"1962", "1.212824`"},
     {"1963", "1.219106`"},
     {"1964", "1.222792`"},
     {"1965", "1.224`"},
     {"1966", "1.222848`"},
     {"1967", "1.219454`"},
     {"1968", "1.2139360000000001`"},
     {"1969", "1.206412`"},
     {"1970", "1.197`"},
     {"1971", "1.1771555`"},
     {"1972", "1.156184`"},
     {"1973", "1.1347285`"},
     {"1974", "1.113432`"},
     {"1975", "1.0929375`"},
     {"1976", "1.073888`"},
     {"1977", "1.0569264999999999`"},
     {"1978", "1.0426959999999998`"},
     {"1979", "1.0318395`"},
     {"1980", "1.025`"},
     {"1981", "1.048775`"},
     {"1982", "1.07628`"},
     {"1983", "1.106585`"},
     {"1984", "1.13876`"},
     {"1985", "1.171875`"},
     {"1986", "1.2049999999999998`"},
     {"1987", "1.2372049999999999`"},
     {"1988", "1.26756`"},
     {"1989", "1.295135`"},
     {"1990", "1.319`"},
     {"1991", "1.3067232`"},
     {"1992", "1.2907856`"},
     {"1993", "1.2721664`"},
     {"1994", "1.2518448`"},
     {"1995", "1.2308`"},
     {"1996", "1.2100112`"},
     {"1997", "1.1904576`"},
     {"1998", "1.1731184000000001`"},
     {"1999", "1.1589728`"},
     {"2000", "1.149`"},
     {"2001", "1.1441792`"},
     {"2002", "1.1454896`"},
     {"2003", "1.1539104`"},
     {"2004", "1.1704208`"},
     {"2005", "1.196`"},
     {"2006", "0"},
     {"2007", "0"},
     {"2008", "0"},
     {"2009", "0"},
     {"2010", "0"},
     {"2011", "0"},
     {"2012", "0"},
     {"2013", "0"},
     {"2014", "0"},
     {"2015", "0"},
     {"2016", "0"},
     {"2017", "0"},
     {"2018", "0"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.838468813763221*^9, 3.8384688384172196`*^9}, {
   3.838468897740508*^9, 3.8384689081508417`*^9}, 3.8384689454383655`*^9},
 CellLabel->
  "Out[467]//MatrixForm=",ExpressionUUID->"5626c4db-b133-4c65-a538-\
92c9b614d741"]
}, Open  ]]
},
WindowSize->{1350, 710},
WindowMargins->{{-2, Automatic}, {Automatic, 0}},
TaggingRules->{
 "WelcomeScreenSettings" -> {"FEStarting" -> False}, "TryRealOnly" -> False},
FrontEndVersion->"12.0 for Microsoft Windows (64-bit) (April 8, 2019)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, 
  "FunctionResourceDocumentationStyles.nb", CharacterEncoding -> "UTF-8"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 439, 9, 48, "Input",ExpressionUUID->"012e4ec2-5954-4e72-8e0c-cd62752b98ad"],
Cell[1000, 31, 443, 10, 28, "Input",ExpressionUUID->"71510dd2-2def-4f9f-b96e-bdf21b72f1d2"],
Cell[1446, 43, 416, 7, 54, "Text",ExpressionUUID->"f703d587-e791-4118-b11d-f6f4e4ac5987"],
Cell[1865, 52, 7515, 237, 561, "Input",ExpressionUUID->"e2867d17-67ce-400c-8e50-5ca3eff26e6c"],
Cell[9383, 291, 471, 8, 54, "Text",ExpressionUUID->"e3ce86a0-f9e3-4e92-9220-6d4ace1602d8"],
Cell[9857, 301, 1050, 16, 28, "Input",ExpressionUUID->"9e535e12-e998-42b7-a958-92111de62308"],
Cell[CellGroupData[{
Cell[10932, 321, 215, 3, 28, "Input",ExpressionUUID->"2a238be7-3573-4785-a9dd-8b60aea040d4"],
Cell[11150, 326, 219, 4, 32, "Output",ExpressionUUID->"b4dc16c5-01f1-4f8e-8272-9d221d2b1f74"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11406, 335, 23138, 571, 751, "Input",ExpressionUUID->"d89c5852-c7fb-45f8-b606-2af1c7082687"],
Cell[34547, 908, 1096, 19, 39, "Message",ExpressionUUID->"4bb79286-394b-4d02-99e0-7d993dfeeaa4"],
Cell[35646, 929, 1094, 19, 39, "Message",ExpressionUUID->"24cf1941-40f5-4525-a52f-6f865f9a2775"]
}, Open  ]],
Cell[CellGroupData[{
Cell[36777, 953, 217, 3, 28, "Input",ExpressionUUID->"83df5bfc-91a0-4c90-9da5-2a84244caf82"],
Cell[36997, 958, 221, 4, 32, "Output",ExpressionUUID->"9c488e35-a554-4fff-9506-7237284e38fc"]
}, Open  ]],
Cell[CellGroupData[{
Cell[37255, 967, 521, 11, 28, "Input",ExpressionUUID->"a1a03af9-5ba6-46f2-912f-f74288d6b27f"],
Cell[37779, 980, 7167, 118, 249, "Output",ExpressionUUID->"0b8f1854-f9e7-45bb-a46e-1d7210f55b5d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[44983, 1103, 678, 14, 28, "Input",ExpressionUUID->"ded2957d-a156-4d8a-a93f-098a9ef10581"],
Cell[45664, 1119, 217, 3, 32, "Output",ExpressionUUID->"d9be28b1-e9d0-49d3-9512-7b2da3dcde76"]
}, Open  ]],
Cell[CellGroupData[{
Cell[45918, 1127, 213, 3, 28, "Input",ExpressionUUID->"974814dc-d9e6-4588-98f2-5615907b1886"],
Cell[46134, 1132, 197, 4, 32, "Output",ExpressionUUID->"f10f6e43-9ff2-4669-9461-dfc7fbf9e0f7"]
}, Open  ]],
Cell[46346, 1139, 154, 3, 28, "Input",ExpressionUUID->"ae747199-6e34-4b24-9f1c-121cb7aa62af"],
Cell[46503, 1144, 24544, 598, 770, "Input",ExpressionUUID->"40198677-a435-4109-8318-3ae36523278b"],
Cell[CellGroupData[{
Cell[71072, 1746, 649, 13, 28, "Input",ExpressionUUID->"909958bf-6cd4-4f64-b774-9715c1d76a07"],
Cell[71724, 1761, 5102, 86, 164, "Output",ExpressionUUID->"9e541a18-0189-44b3-8437-429d31f90d73"]
}, Open  ]],
Cell[CellGroupData[{
Cell[76863, 1852, 363, 6, 28, "Input",ExpressionUUID->"50503fb9-911f-4ebc-aa0b-00baddebab1b"],
Cell[77229, 1860, 362, 5, 32, "Output",ExpressionUUID->"d263b195-3a70-45a0-8b3c-2c60002dd95b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[77628, 1870, 401, 9, 28, "Input",ExpressionUUID->"5f3a27e3-ada6-4f8e-959c-399c84f8a072"],
Cell[78032, 1881, 2267, 38, 90, "Output",ExpressionUUID->"a2311b67-32a6-4c12-a01e-a5ff0ccb54a9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[80336, 1924, 255, 4, 28, "Input",ExpressionUUID->"8bf5783c-d972-4938-9d37-4d810c333ef3"],
Cell[80594, 1930, 172, 2, 89, "Output",ExpressionUUID->"b72b8ffd-9f28-4e0b-aaae-b8017c7b4d9c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[80803, 1937, 282, 7, 48, "Input",ExpressionUUID->"16036bbe-9aba-4e82-ac1b-eb978e3e7028"],
Cell[81088, 1946, 200, 5, 32, "Output",ExpressionUUID->"ea029d17-eceb-4b74-b4f9-33de1bd354ff"]
}, Open  ]],
Cell[81303, 1954, 231, 4, 28, "Input",ExpressionUUID->"7110ca41-1ed3-4953-8c2c-cbcc59d82ebb"],
Cell[81537, 1960, 2511, 79, 124, "Input",ExpressionUUID->"7bd38d84-2e8d-4def-a67f-079197035fae"],
Cell[84051, 2041, 179, 3, 28, "Input",ExpressionUUID->"ddfa8e9b-ef7a-49d3-a88c-40580cdab7ad"],
Cell[84233, 2046, 4184, 122, 143, "Input",ExpressionUUID->"a1aaea27-8ea0-4ff1-8980-6661f90199ee"],
Cell[CellGroupData[{
Cell[88442, 2172, 382, 10, 28, "Input",ExpressionUUID->"cec79f70-0edd-4f47-b466-cfa0a3ce3701"],
Cell[88827, 2184, 1863, 36, 79, "Output",ExpressionUUID->"42f86ae2-ac24-44e9-9396-7f975e7e341d"]
}, Open  ]],
Cell[90705, 2223, 340, 8, 28, "Input",ExpressionUUID->"0da448e0-c553-4571-9af2-1701a44f1337"],
Cell[91048, 2233, 482, 14, 48, "Input",ExpressionUUID->"1c1702b7-56d5-4bbc-a299-dc3d807440b0"],
Cell[CellGroupData[{
Cell[91555, 2251, 239, 5, 28, "Input",ExpressionUUID->"c3d606f1-eafd-4eef-baeb-169215242ec2"],
Cell[91797, 2258, 241, 5, 32, "Output",ExpressionUUID->"e4728dbb-769b-46dc-8f86-dd6c5d2775d3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[92075, 2268, 183, 3, 28, "Input",ExpressionUUID->"de1280cd-bb78-47af-ab37-976cb054eaf9"],
Cell[92261, 2273, 13788, 274, 76, "Output",ExpressionUUID->"1702dafc-150d-492a-b6aa-034c9bf299f6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[106086, 2552, 237, 5, 28, "Input",ExpressionUUID->"02143397-d874-44a8-9717-ccb742d9832c"],
Cell[106326, 2559, 214, 5, 32, "Output",ExpressionUUID->"c72bdf31-0760-4b89-a748-21e29d4b667a"]
}, Open  ]],
Cell[106555, 2567, 1906, 60, 143, "Input",ExpressionUUID->"a686a423-4f9a-4c1d-a5d3-562de7d26616"],
Cell[CellGroupData[{
Cell[108486, 2631, 257, 5, 28, "Input",ExpressionUUID->"14d58fa9-58bf-4bd2-aa31-78258ad24add"],
Cell[108746, 2638, 191, 3, 32, "Output",ExpressionUUID->"ee29d568-11db-402e-83c9-0390bf2e5584"]
}, Open  ]],
Cell[108952, 2644, 2242, 76, 143, "Input",ExpressionUUID->"a11da327-3b7d-4613-baa5-fea76b356cbb"],
Cell[111197, 2722, 4072, 120, 124, "Input",ExpressionUUID->"11404842-6474-449b-9879-18eeba2239b2"],
Cell[CellGroupData[{
Cell[115294, 2846, 218, 4, 28, "Input",ExpressionUUID->"516f5d0b-61d2-42bd-af8f-07f1392c5dc4"],
Cell[115515, 2852, 226, 5, 32, "Output",ExpressionUUID->"05b495b4-cc6a-48b8-b128-be1c872a7c0e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[115778, 2862, 373, 10, 28, "Input",ExpressionUUID->"803c59a1-fc9d-4128-a061-6bb415aefcc2"],
Cell[116154, 2874, 197, 3, 32, "Output",ExpressionUUID->"8ac37916-a1c5-44da-bc78-456274b57db8"]
}, Open  ]],
Cell[CellGroupData[{
Cell[116388, 2882, 386, 10, 28, "Input",ExpressionUUID->"929c773e-17d6-441e-b48b-8cd4f46157f8"],
Cell[116777, 2894, 1868, 37, 79, "Output",ExpressionUUID->"590de729-4964-44ed-a538-295703bb6c1b"]
}, Open  ]],
Cell[118660, 2934, 21088, 545, 770, "Input",ExpressionUUID->"d4f1f33c-577b-4386-acc3-3a83e0eeac7d"],
Cell[CellGroupData[{
Cell[139773, 3483, 387, 10, 28, "Input",ExpressionUUID->"4460af13-c6f7-4664-bb0d-a694ac73921a"],
Cell[140163, 3495, 2025, 39, 79, "Output",ExpressionUUID->"12938992-a06d-4426-b951-1165a2c5ef39"]
}, Open  ]],
Cell[CellGroupData[{
Cell[142225, 3539, 201, 4, 28, "Input",ExpressionUUID->"92287a7f-f016-4b36-bbee-d76a04284e26"],
Cell[142429, 3545, 153, 3, 32, "Output",ExpressionUUID->"ca2d3a1e-a545-4175-9d34-4e0d3a5bc265"]
}, Open  ]],
Cell[CellGroupData[{
Cell[142619, 3553, 325, 8, 28, "Input",ExpressionUUID->"6e534521-680e-40a8-922e-93ff49631ea2"],
Cell[142947, 3563, 204, 4, 32, "Output",ExpressionUUID->"defdef76-79fc-4f97-b217-b41335b5f923"]
}, Open  ]],
Cell[143166, 3570, 154, 3, 28, "Input",ExpressionUUID->"ef92775f-2d49-4601-952f-dfb77a1ac1af"],
Cell[CellGroupData[{
Cell[143345, 3577, 239, 5, 28, "Input",ExpressionUUID->"5a62d82f-1159-4c23-afb7-0ea573175cd2"],
Cell[143587, 3584, 3382, 59, 128, "Output",ExpressionUUID->"bafcc331-a3aa-41dc-ab16-5579b972ed7b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[147006, 3648, 263, 4, 28, "Input",ExpressionUUID->"5614ee89-a86e-4e1c-82c3-242295feea85"],
Cell[147272, 3654, 153699, 2394, 8086, "Output",ExpressionUUID->"fe654833-c9f4-469c-8d23-a3418389c982"]
}, Open  ]],
Cell[300986, 6051, 985, 27, 67, "Input",ExpressionUUID->"860dbcf3-c5de-489d-bae9-48b9700cbdc0"],
Cell[301974, 6080, 330, 7, 28, "Input",ExpressionUUID->"f73f00ff-47ba-4753-b396-df8469b1855c"],
Cell[CellGroupData[{
Cell[302329, 6091, 673, 19, 28, "Input",ExpressionUUID->"1e539bd4-2cbf-4d7f-b0ab-1086461cd226"],
Cell[303005, 6112, 3488, 77, 388, "Output",ExpressionUUID->"1eb56dcc-cda8-402b-b55e-0a27a8e095dd"]
}, Open  ]],
Cell[306508, 6192, 339, 7, 28, "Input",ExpressionUUID->"346baede-a1f2-4514-aa6a-224616f9a5f1"],
Cell[CellGroupData[{
Cell[306872, 6203, 215, 3, 28, "Input",ExpressionUUID->"cc0dd6eb-ec9a-4fd9-9e4d-f85941f64be2"],
Cell[307090, 6208, 249, 5, 32, "Output",ExpressionUUID->"f9ad59a5-271d-49b4-99b7-2672cf9d2a0b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[307376, 6218, 384, 8, 28, "Input",ExpressionUUID->"7d71344f-43b1-4d2a-a613-84ab6b477c18"],
Cell[307763, 6228, 492, 12, 32, "Output",ExpressionUUID->"c1b65d5c-b124-4b02-889a-cd455d05ceae"]
}, Open  ]],
Cell[CellGroupData[{
Cell[308292, 6245, 408, 12, 28, "Input",ExpressionUUID->"0f156a84-b752-4ce4-99fa-3ace9530f1f4"],
Cell[308703, 6259, 688, 19, 62, "Output",ExpressionUUID->"42ea013b-5d60-473e-8933-e65c8c628810"]
}, Open  ]],
Cell[CellGroupData[{
Cell[309428, 6283, 1089, 25, 28, "Input",ExpressionUUID->"335fa024-c033-47dc-b90c-447a415e13b1"],
Cell[310520, 6310, 3797, 81, 383, "Output",ExpressionUUID->"8ee7a66f-9af8-4ee1-8cb2-484466766839"]
}, Open  ]],
Cell[CellGroupData[{
Cell[314354, 6396, 890, 26, 28, "Input",ExpressionUUID->"365e7b34-80ec-4f6e-bd52-70a4b11d2285"],
Cell[315247, 6424, 4784, 101, 388, "Output",ExpressionUUID->"dcaeca39-182e-45b9-9dc9-b1dcb8f4be79"]
}, Open  ]],
Cell[CellGroupData[{
Cell[320068, 6530, 392, 9, 28, "Input",ExpressionUUID->"f6408a64-4af2-4cc2-a067-ab765b62fa14"],
Cell[320463, 6541, 2367, 41, 90, "Output",ExpressionUUID->"80332714-82a2-467f-b811-149d32007a28"]
}, Open  ]],
Cell[CellGroupData[{
Cell[322867, 6587, 248, 4, 28, "Input",ExpressionUUID->"48942292-0b13-45b4-b4fa-88cb28a84fed"],
Cell[323118, 6593, 238, 3, 32, "Output",ExpressionUUID->"da6e018e-7e3f-4e02-a872-3f2f1d613d39"]
}, Open  ]],
Cell[323371, 6599, 363, 9, 48, "Input",ExpressionUUID->"7a9635ec-1df5-42fd-b445-3e2ea96e1510"],
Cell[323737, 6610, 408, 12, 28, "Input",ExpressionUUID->"041eeb26-347c-4be6-bfe6-28c9656909c4"],
Cell[324148, 6624, 1211, 36, 67, "Input",ExpressionUUID->"c93bd799-0f25-40c6-a08f-4a06572b6483"],
Cell[CellGroupData[{
Cell[325384, 6664, 257, 5, 28, "Input",ExpressionUUID->"e2d4600b-6080-44b7-9c69-8b11ff856e32"],
Cell[325644, 6671, 170, 3, 32, "Output",ExpressionUUID->"b14b6690-f916-400e-8ad2-9e30a4af5283"]
}, Open  ]],
Cell[CellGroupData[{
Cell[325851, 6679, 268, 5, 28, "Input",ExpressionUUID->"44a678df-67fa-4d62-92f9-c53af752e5ed"],
Cell[326122, 6686, 5576, 187, 2901, "Output",ExpressionUUID->"5626c4db-b133-4c65-a538-92c9b614d741"]
}, Open  ]]
}
]
*)

