/*
 * Decompiled with CFR 0.152.
 */
package ruleset;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import misc.FileManager;
import ruleset.PadInfo;

public class UnknownSequenceSummary {
    public static void main(String[] args) throws Exception {
        File unknowLogFile = new File(args[0]);
        File rulesetDir = new File(args[1]);
        File outputDir = new File(args[2]);
        Map<String, Map<String, PadInfo>> padInfo = UnknownSequenceSummary.parseFile(unknowLogFile);
        StringBuilder builder = new StringBuilder();
        builder.append("Allele").append("\t").append("Exon").append("\t").append("PadWithAllele").append("\t").append("SupportingCount").append("\t").append("SampleName").append("\n");
        for (String allele : padInfo.keySet()) {
            for (String exon : padInfo.get(allele).keySet()) {
                PadInfo info = padInfo.get(allele).get(exon);
                builder.append(allele).append("\t");
                builder.append(exon).append("\t");
                builder.append(info.getPadAlleleName()).append("\t");
                builder.append(info.getSampleNames().size()).append("\t");
                builder.append(info.getSampleNames()).append("\n");
            }
        }
        System.out.println(builder.toString());
    }

    private static Map<String, Map<String, PadInfo>> parseFile(File unknowLogFile) throws Exception {
        TreeMap<String, Map<String, PadInfo>> padInfo = new TreeMap<String, Map<String, PadInfo>>();
        String[] lines = FileManager.readTextFile(unknowLogFile).split("\n");
        String sampleName = null;
        Object alleleName = null;
        int i = 0;
        while (i < lines.length) {
            String line = lines[i].trim();
            if (line.length() != 0) {
                if (line.startsWith("Sample")) {
                    sampleName = UnknownSequenceSummary.parseSampleName(line);
                } else if (line.startsWith(">")) {
                    UnknownSequenceSummary.parsePadDetail(line, lines[i + 1].trim(), sampleName, padInfo);
                    ++i;
                }
            }
            ++i;
        }
        return padInfo;
    }

    private static void parsePadDetail(String line, String seq, String sampleName, Map<String, Map<String, PadInfo>> padInfo) {
        PadInfo info = new PadInfo();
        String[] items = line.substring(1).split("-");
        String alleleName = items[0];
        String exon = items[1];
        String padAlleleName = items[2];
        if (!padInfo.containsKey(alleleName)) {
            padInfo.put(alleleName, new LinkedHashMap());
        }
        if (!padInfo.get(alleleName).containsKey(exon)) {
            padInfo.get(alleleName).put(exon, new PadInfo());
        }
        padInfo.get(alleleName).get(exon).setAlleleName(alleleName);
        padInfo.get(alleleName).get(exon).setPadAlleleName(padAlleleName);
        padInfo.get(alleleName).get(exon).setSequence(seq);
        padInfo.get(alleleName).get(exon).addSampleNames(sampleName);
    }

    private static String parseSampleName(String line) {
        return line.trim().split("\\s+")[1];
    }
}

