/*
 * Decompiled with CFR 0.152.
 */
package ruleset;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import misc.FileManager;
import ruleset.Nmer;
import ruleset.PickingNmersForBCexon2;
import ruleset.PickingNmersForBridge23;

public class PickingNmersForDoubleCoverageForBC {
    static List<Integer> excludingSite = PickingNmersForDoubleCoverageForBC.loadExcludingSite();
    static List<Nmer> nmerList = new ArrayList<Nmer>();

    public static void main(String[] args) throws Exception {
        String exon = args[0];
        File rulesetDir = new File(args[1]);
        int nmerSize = new Integer(args[2]);
        File nMerFile = new File(args[3]);
        LinkedHashMap<String, String> uniqueASequences = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> majorASequences = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> uniqueBSequences = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> majorBSequences = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> uniqueCSequences = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> majorCSequences = new LinkedHashMap<String, String>();
        File inputA = new File(rulesetDir, "A-" + exon + ".fa");
        File inputB = new File(rulesetDir, "B-" + exon + ".fa");
        File inputC = new File(rulesetDir, "C-" + exon + ".fa");
        PickingNmersForDoubleCoverageForBC.loadAllSequence(inputA, "A", uniqueASequences, majorASequences);
        PickingNmersForDoubleCoverageForBC.loadAllSequence(inputB, "B", uniqueBSequences, majorBSequences);
        PickingNmersForDoubleCoverageForBC.loadAllSequence(inputC, "C", uniqueCSequences, majorCSequences);
        PickingNmersForDoubleCoverageForBC.parseNmerFile(nMerFile);
        System.out.println("A uniqueASequences.size=" + uniqueASequences.size());
        System.out.println("B uniqueBSequences.size=" + uniqueBSequences.size());
        System.out.println("C uniqueCSequences.size=" + uniqueCSequences.size());
        Map<String, Integer> coverageA = PickingNmersForDoubleCoverageForBC.checkCoverage(uniqueASequences, "A-" + exon.replace("exon", ""));
        Map<String, Integer> coverageB = PickingNmersForDoubleCoverageForBC.checkCoverage(uniqueBSequences, "B-" + exon.replace("exon", ""));
        Map<String, Integer> coverageC = PickingNmersForDoubleCoverageForBC.checkCoverage(uniqueCSequences, "C-" + exon.replace("exon", ""));
        Map<String, String> singleCoverageAsequence = PickingNmersForDoubleCoverageForBC.getSingleCoverageSequence(uniqueASequences, coverageA);
        Map<String, String> singleCoverageBsequence = PickingNmersForDoubleCoverageForBC.getSingleCoverageSequence(uniqueBSequences, coverageB);
        Map<String, String> singleCoverageCsequence = PickingNmersForDoubleCoverageForBC.getSingleCoverageSequence(uniqueCSequences, coverageC);
        List<Nmer> nMerListA = PickingNmersForDoubleCoverageForBC.constructNmers(singleCoverageAsequence, nmerSize, uniqueBSequences, uniqueCSequences, 0);
        Map<Nmer, List<String>> matchRecordA = PickingNmersForBridge23.recordMatches(nMerListA, singleCoverageAsequence);
        Map<Nmer, List<String>> fullCoverageMapA = PickingNmersForBridge23.computeFullCoveragePath(matchRecordA, singleCoverageAsequence, new ArrayList<String>(), 1);
        System.out.println("number of Nmer for A = " + fullCoverageMapA.size());
        for (Nmer nmer : fullCoverageMapA.keySet()) {
            System.out.println(String.valueOf(nmer.getSequence()) + "\tHit=" + fullCoverageMapA.get(nmer).size() + " position=" + nmer.getPosition() + "\trevcomp\t" + PickingNmersForDoubleCoverageForBC.revComp(nmer.getSequence()) + "\t" + fullCoverageMapA.get(nmer).toString());
        }
        List<Nmer> nMerListB = PickingNmersForDoubleCoverageForBC.constructNmers(singleCoverageBsequence, nmerSize, uniqueASequences, uniqueCSequences, 0);
        Map<Nmer, List<String>> matchRecordB = PickingNmersForBridge23.recordMatches(nMerListB, singleCoverageBsequence);
        ArrayList<String> uncoveredBList = new ArrayList<String>();
        Map<Nmer, List<String>> fullCoverageMapB = PickingNmersForBridge23.computeFullCoveragePath(matchRecordB, singleCoverageBsequence, uncoveredBList, 1);
        System.out.println("number of Nmer for B = " + fullCoverageMapB.size());
        for (Nmer nmer : fullCoverageMapB.keySet()) {
            System.out.println(String.valueOf(nmer.getSequence()) + "\tHit=" + fullCoverageMapB.get(nmer).size() + " position=" + nmer.getPosition() + "\trevcomp\t" + PickingNmersForDoubleCoverageForBC.revComp(nmer.getSequence()) + "\t" + fullCoverageMapB.get(nmer).toString());
        }
        LinkedHashMap<String, String> uncoveredSequencesB2 = new LinkedHashMap<String, String>();
        PickingNmersForBCexon2.addUncoveredSeq(uncoveredSequencesB2, uniqueBSequences, uncoveredBList);
        List<Nmer> nMerListC = PickingNmersForDoubleCoverageForBC.constructNmers(singleCoverageCsequence, nmerSize, new LinkedHashMap<String, String>(), uncoveredSequencesB2, 0);
        Map<Nmer, List<String>> matchRecordC = PickingNmersForBridge23.recordMatches(nMerListC, singleCoverageCsequence);
        ArrayList<String> uncoveredCList = new ArrayList<String>();
        Map<Nmer, List<String>> fullCoverageMapC = PickingNmersForBridge23.computeFullCoveragePath(matchRecordC, singleCoverageCsequence, uncoveredCList, 1);
        System.out.println("number of Nmer for C = " + fullCoverageMapC.size());
        for (Nmer nmer : fullCoverageMapC.keySet()) {
            System.out.println(String.valueOf(nmer.getSequence()) + "\tHit=" + fullCoverageMapC.get(nmer).size() + " position=" + nmer.getPosition() + "\trevcomp\t" + PickingNmersForDoubleCoverageForBC.revComp(nmer.getSequence()) + "\t" + fullCoverageMapC.get(nmer).toString());
        }
        System.out.println("-----round2 don't consider C*16:85 for now");
        LinkedHashMap<String, String> uncoveredSequencesC2 = new LinkedHashMap<String, String>();
        PickingNmersForBCexon2.addUncoveredSeq(uncoveredSequencesC2, uniqueCSequences, uncoveredCList);
        if (uncoveredSequencesC2.size() == 1) {
            uncoveredSequencesC2 = new LinkedHashMap();
        }
        List<Nmer> nMerListB2 = PickingNmersForBridge23.constructNmers(uncoveredSequencesB2, nmerSize, new LinkedHashMap<String, String>(), uncoveredSequencesC2, 0);
        Map<Nmer, List<String>> matchRecordB2 = PickingNmersForBridge23.recordMatches(nMerListB2, uncoveredSequencesB2);
        ArrayList<String> uncoveredB2List = new ArrayList<String>();
        Map<Nmer, List<String>> fullCoverageMapB2 = PickingNmersForBridge23.computeFullCoveragePath(matchRecordB2, uncoveredSequencesB2, uncoveredB2List, 2);
        System.out.println("number of Nmer for B = " + fullCoverageMapB2.size());
        for (Nmer nmer : fullCoverageMapB2.keySet()) {
            System.out.println(String.valueOf(nmer.getSequence()) + "\tHit=" + fullCoverageMapB2.get(nmer).size() + " position=" + nmer.getPosition() + "\trevcomp\t" + PickingNmersForDoubleCoverageForBC.revComp(nmer.getSequence()) + "\t" + fullCoverageMapB2.get(nmer).toString());
        }
        List<Nmer> nMerListC2 = PickingNmersForBridge23.constructNmers(uncoveredSequencesC2, nmerSize, new LinkedHashMap<String, String>(), uncoveredSequencesB2, 0);
        Map<Nmer, List<String>> matchRecordC2 = PickingNmersForBridge23.recordMatches(nMerListC2, uncoveredSequencesC2);
        ArrayList<String> uncoveredC2List = new ArrayList<String>();
        Map<Nmer, List<String>> fullCoverageMapC2 = PickingNmersForBridge23.computeFullCoveragePath(matchRecordC2, uncoveredSequencesC2, uncoveredC2List, 2);
        System.out.println("number of Nmer for C = " + fullCoverageMapC2.size());
        for (Nmer nmer : fullCoverageMapC2.keySet()) {
            System.out.println(String.valueOf(nmer.getSequence()) + "\tHit=" + fullCoverageMapC2.get(nmer).size() + " position=" + nmer.getPosition() + "\trevcomp\t" + PickingNmersForDoubleCoverageForBC.revComp(nmer.getSequence()) + "\t" + fullCoverageMapC2.get(nmer).toString());
        }
        LinkedHashMap<String, String> uncoveredSequences = new LinkedHashMap<String, String>();
        PickingNmersForBCexon2.addUncoveredSeq(uncoveredSequences, uniqueBSequences, uncoveredB2List);
        PickingNmersForBCexon2.addUncoveredSeq(uncoveredSequences, uniqueCSequences, uncoveredC2List);
        List<String> nMerListShared = PickingNmersForBCexon2.constructNmers(uncoveredSequences, nmerSize, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>());
        Map<String, List<String>> matchRecordShared = PickingNmersForBCexon2.recordMatches(nMerListShared, uncoveredSequences);
        ArrayList<String> uncoveredSharedList = new ArrayList<String>();
        Map<String, List<String>> fullCoverageMapShared = PickingNmersForBCexon2.computeFullCoveragePath(matchRecordShared, uncoveredSequences, uncoveredSharedList, 3);
        System.out.println("number of Nmer for BC = " + fullCoverageMapShared.size());
        for (String nmer : fullCoverageMapShared.keySet()) {
            System.out.println(String.valueOf(nmer) + "\t" + fullCoverageMapShared.get(nmer).size());
        }
    }

    public static Map<String, String> getSingleCoverageSequence(Map<String, String> uniqueSequences, Map<String, Integer> coverage) {
        HashMap<String, String> sequences = new HashMap<String, String>();
        for (String name : uniqueSequences.keySet()) {
            if (coverage.get(name) >= 2) continue;
            sequences.put(name, uniqueSequences.get(name));
        }
        return sequences;
    }

    public static Map<String, Integer> checkCoverage(Map<String, String> uniqueSequences, String locusExon) {
        HashMap<String, Integer> coverage = new HashMap<String, Integer>();
        for (String name : uniqueSequences.keySet()) {
            String seq = uniqueSequences.get(name);
            int count = 0;
            for (Nmer nmer : nmerList) {
                if (!nmer.getDestination().get(0).equals(locusExon) || seq.indexOf(nmer.getSequence()) <= -1) continue;
                ++count;
            }
            coverage.put(name, count);
        }
        int multiCoveredCount = 0;
        int singleCount = 0;
        int noCoverageCount = 0;
        for (String name : coverage.keySet()) {
            int count = (Integer)coverage.get(name);
            if (count > 1) {
                ++multiCoveredCount;
                continue;
            }
            if (count == 1) {
                ++singleCount;
                continue;
            }
            if (count != 0) continue;
            ++noCoverageCount;
            System.out.println("\tuncovered: " + name);
        }
        System.out.println(String.valueOf(locusExon) + " uniqueSequences.size=" + uniqueSequences.size() + " multiCoveredCount=" + multiCoveredCount + " singleCount=" + singleCount + " noCoverageCount=" + noCoverageCount);
        return coverage;
    }

    private static List<Integer> loadExcludingSite() {
        ArrayList<Integer> excludingSite = new ArrayList<Integer>();
        return excludingSite;
    }

    public static void parseNmerFile(File file) throws IOException {
        String[] nmerInfo;
        String[] stringArray = nmerInfo = FileManager.readTextFile(file).split("\n");
        int n = nmerInfo.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            String[] items = line.trim().split(",");
            if (line.trim().length() != 0 && items.length >= 4 && items[0].trim().length() != 0) {
                String[] dests;
                Nmer nmer = new Nmer(items[0].trim(), items[2].trim(), Integer.valueOf(items[1]));
                String[] stringArray2 = dests = items[3].trim().split("/");
                int n3 = dests.length;
                int n4 = 0;
                while (n4 < n3) {
                    String dest = stringArray2[n4];
                    nmer.getDestination().add(dest);
                    ++n4;
                }
                nmerList.add(nmer);
            }
            ++n2;
        }
    }

    public static List<Nmer> constructNmers(Map<String, String> majorSequences, int nmerSize, Map<String, String> otherUniqueSequences1, Map<String, String> otherUniqueSequences2, int offset) {
        ArrayList<Nmer> nMerList = new ArrayList<Nmer>();
        ArrayList<String> nMerSeq = new ArrayList<String>();
        for (String name : majorSequences.keySet()) {
            String seq = majorSequences.get(name);
            int i = offset;
            while (i <= seq.length() - nmerSize - offset) {
                Nmer nMer = new Nmer(seq.substring(i, i + nmerSize), i + 1);
                if (!(nMer.getSequence().indexOf("X") >= 0 || PickingNmersForDoubleCoverageForBC.inNmerList(nMer.getSequence()) || nMerSeq.contains(nMer.getSequence()) || PickingNmersForDoubleCoverageForBC.findMatch(nMer.getSequence(), otherUniqueSequences1) || PickingNmersForDoubleCoverageForBC.findMatch(nMer.getSequence(), otherUniqueSequences2))) {
                    nMerList.add(nMer);
                    nMerSeq.add(nMer.getSequence());
                }
                ++i;
            }
        }
        System.out.println("nMerList.size()=" + nMerList.size());
        return nMerList;
    }

    private static boolean inNmerList(String sequence) {
        for (Nmer nmer : nmerList) {
            if (!nmer.getSequence().equals(sequence)) continue;
            return true;
        }
        return false;
    }

    private static boolean findMatch(String nmer, Map<String, String> uniqueSequences) {
        for (String name : uniqueSequences.keySet()) {
            if (uniqueSequences.get(name).indexOf(nmer) <= -1) continue;
            return true;
        }
        return false;
    }

    private static boolean inExcludingRange(int position) {
        for (Integer exPos : excludingSite) {
            if (position <= exPos - 30 || position >= exPos + 30) continue;
            return true;
        }
        return false;
    }

    private static String revComp(String seq) {
        String revcomp = new StringBuilder(seq.replace('A', 'B').replace('T', 'A').replace('B', 'T').replace('C', 'D').replace('G', 'C').replace('D', 'G')).reverse().toString();
        return revcomp;
    }

    private static void loadAllSequence(File input, String header, Map<String, String> uniqueSequences, Map<String, String> majorSequenceNames) {
        Map<String, String> sequences = PickingNmersForDoubleCoverageForBC.getSequences(input, header);
        System.out.println(String.valueOf(input.getName()) + " sequences.size=" + sequences.size());
        ArrayList<String> majorGroupNameList = new ArrayList<String>();
        ArrayList<String> majorGroupSequenceList = new ArrayList<String>();
        LinkedHashMap<String, String> seqToName = new LinkedHashMap<String, String>();
        for (String name : sequences.keySet()) {
            if (seqToName.containsKey(sequences.get(name))) {
                String collectionName = String.valueOf((String)seqToName.get(sequences.get(name))) + "," + name;
                seqToName.put(sequences.get(name), collectionName);
            } else {
                seqToName.put(sequences.get(name), name);
            }
            String majorGroup = name.split("\\:")[0];
            if (majorGroupNameList.contains(majorGroup) || majorGroupSequenceList.contains(sequences.get(name))) continue;
            majorSequenceNames.put(name, sequences.get(name));
            majorGroupNameList.add(majorGroup);
            majorGroupSequenceList.add(sequences.get(name));
        }
        for (String seq : seqToName.keySet()) {
            uniqueSequences.put((String)seqToName.get(seq), seq);
        }
    }

    private static Map<String, String> getSequences(File fastaFile, String header) {
        LinkedHashMap<String, String> sequences = new LinkedHashMap<String, String>();
        String[] lines = FileManager.readTextFile(fastaFile).split("\n");
        int i = 0;
        while (i < lines.length) {
            if (lines[i].trim().length() != 0 && lines[i].trim().startsWith(">" + header)) {
                String name = lines[i].trim().substring(1);
                String sequence = lines[i + 1].trim();
                sequences.put(name, sequence);
            }
            ++i;
        }
        return sequences;
    }
}

