/*
 * Decompiled with CFR 0.152.
 */
package ruleset;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import misc.FileManager;
import ruleset.Nmer;
import ruleset.PickingNmersForBridge23;

public class PickingNmersForBCexon2 {
    static int ROUND_1_PICK_NUM_1 = 15;
    static int ROUND_1_PICK_NUM_2 = 3;

    public static void main(String[] args) throws Exception {
        String exon = args[0];
        File rulesetDir = new File(args[1]);
        int nmerSize = new Integer(args[2]);
        LinkedHashMap<String, String> uniqueASequences = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> majorASequences = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> uniqueBSequences = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> majorBSequences = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> uniqueCSequences = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> majorCSequences = new LinkedHashMap<String, String>();
        File inputA = new File(rulesetDir, "A-" + exon + ".fa");
        File inputB = new File(rulesetDir, "B-" + exon + ".fa");
        File inputC = new File(rulesetDir, "C-" + exon + ".fa");
        PickingNmersForBCexon2.loadAllSequence(inputA, "A", uniqueASequences, majorASequences);
        PickingNmersForBCexon2.loadAllSequence(inputB, "B", uniqueBSequences, majorBSequences);
        PickingNmersForBCexon2.loadAllSequence(inputC, "C", uniqueCSequences, majorCSequences);
        System.out.println("uniqueASequences.size=" + uniqueASequences.size());
        System.out.println("uniqueBSequences.size=" + uniqueBSequences.size());
        System.out.println("uniqueCSequences.size=" + uniqueCSequences.size());
        List<Nmer> nMerListA = PickingNmersForBridge23.constructNmers(uniqueASequences, nmerSize, uniqueBSequences, uniqueCSequences, 0);
        Map<Nmer, List<String>> matchRecordA = PickingNmersForBridge23.recordMatches(nMerListA, uniqueASequences);
        Map<Nmer, List<String>> fullCoverageMapA = PickingNmersForBridge23.computeFullCoveragePath(matchRecordA, uniqueASequences, new ArrayList<String>(), 1);
        System.out.println("number of Nmer for A = " + fullCoverageMapA.size());
        for (Nmer nmer : fullCoverageMapA.keySet()) {
            System.out.println(String.valueOf(nmer.getSequence()) + "\tHit=" + fullCoverageMapA.get(nmer).size() + " position=" + nmer.getPosition() + "\trevcomp\t" + PickingNmersForBCexon2.revComp(nmer.getSequence()) + "\t" + fullCoverageMapA.get(nmer).toString());
        }
        List<Nmer> nMerListB = PickingNmersForBridge23.constructNmers(uniqueBSequences, nmerSize, new LinkedHashMap<String, String>(), uniqueCSequences, 0);
        Map<Nmer, List<String>> matchRecordB = PickingNmersForBridge23.recordMatches(nMerListB, uniqueBSequences);
        ArrayList<String> uncoveredBList = new ArrayList<String>();
        Map<Nmer, List<String>> fullCoverageMapB = PickingNmersForBridge23.computeFullCoveragePath(matchRecordB, uniqueBSequences, uncoveredBList, 1);
        System.out.println("number of Nmer for B = " + fullCoverageMapB.size());
        for (Nmer nmer : fullCoverageMapB.keySet()) {
            System.out.println(String.valueOf(nmer.getSequence()) + "\tHit=" + fullCoverageMapB.get(nmer).size() + " position=" + nmer.getPosition() + "\trevcomp\t" + PickingNmersForBCexon2.revComp(nmer.getSequence()) + "\t" + fullCoverageMapB.get(nmer).toString());
        }
        LinkedHashMap<String, String> uncoveredSequencesB2 = new LinkedHashMap<String, String>();
        PickingNmersForBCexon2.addUncoveredSeq(uncoveredSequencesB2, uniqueBSequences, uncoveredBList);
        List<Nmer> nMerListC = PickingNmersForBridge23.constructNmers(uniqueCSequences, nmerSize, new LinkedHashMap<String, String>(), uncoveredSequencesB2, 0);
        Map<Nmer, List<String>> matchRecordC = PickingNmersForBridge23.recordMatches(nMerListC, uniqueCSequences);
        ArrayList<String> uncoveredCList = new ArrayList<String>();
        Map<Nmer, List<String>> fullCoverageMapC = PickingNmersForBridge23.computeFullCoveragePath(matchRecordC, uniqueCSequences, uncoveredCList, 1);
        System.out.println("number of Nmer for C = " + fullCoverageMapC.size());
        for (Nmer nmer : fullCoverageMapC.keySet()) {
            System.out.println(String.valueOf(nmer.getSequence()) + "\tHit=" + fullCoverageMapC.get(nmer).size() + " position=" + nmer.getPosition() + "\trevcomp\t" + PickingNmersForBCexon2.revComp(nmer.getSequence()) + "\t" + fullCoverageMapC.get(nmer).toString());
        }
        System.out.println("-----round2 don't consider C*16:85 for now");
        LinkedHashMap<String, String> uncoveredSequencesC2 = new LinkedHashMap<String, String>();
        PickingNmersForBCexon2.addUncoveredSeq(uncoveredSequencesC2, uniqueCSequences, uncoveredCList);
        if (uncoveredSequencesC2.size() == 1) {
            uncoveredSequencesC2 = new LinkedHashMap();
        }
        List<Nmer> nMerListB2 = PickingNmersForBridge23.constructNmers(uncoveredSequencesB2, nmerSize, new LinkedHashMap<String, String>(), uncoveredSequencesC2, 0);
        Map<Nmer, List<String>> matchRecordB2 = PickingNmersForBridge23.recordMatches(nMerListB2, uncoveredSequencesB2);
        ArrayList<String> uncoveredB2List = new ArrayList<String>();
        Map<Nmer, List<String>> fullCoverageMapB2 = PickingNmersForBridge23.computeFullCoveragePath(matchRecordB2, uncoveredSequencesB2, uncoveredB2List, 2);
        System.out.println("number of Nmer for B = " + fullCoverageMapB2.size());
        for (Nmer nmer : fullCoverageMapB2.keySet()) {
            System.out.println(String.valueOf(nmer.getSequence()) + "\tHit=" + fullCoverageMapB2.get(nmer).size() + " position=" + nmer.getPosition() + "\trevcomp\t" + PickingNmersForBCexon2.revComp(nmer.getSequence()) + "\t" + fullCoverageMapB2.get(nmer).toString());
        }
        List<Nmer> nMerListC2 = PickingNmersForBridge23.constructNmers(uncoveredSequencesC2, nmerSize, new LinkedHashMap<String, String>(), uncoveredSequencesB2, 0);
        Map<Nmer, List<String>> matchRecordC2 = PickingNmersForBridge23.recordMatches(nMerListC2, uncoveredSequencesC2);
        ArrayList<String> uncoveredC2List = new ArrayList<String>();
        Map<Nmer, List<String>> fullCoverageMapC2 = PickingNmersForBridge23.computeFullCoveragePath(matchRecordC2, uncoveredSequencesC2, uncoveredC2List, 2);
        System.out.println("number of Nmer for C = " + fullCoverageMapC2.size());
        for (Nmer nmer : fullCoverageMapC2.keySet()) {
            System.out.println(String.valueOf(nmer.getSequence()) + "\tHit=" + fullCoverageMapC2.get(nmer).size() + " position=" + nmer.getPosition() + "\trevcomp\t" + PickingNmersForBCexon2.revComp(nmer.getSequence()) + "\t" + fullCoverageMapC2.get(nmer).toString());
        }
        LinkedHashMap<String, String> uncoveredSequences = new LinkedHashMap<String, String>();
        PickingNmersForBCexon2.addUncoveredSeq(uncoveredSequences, uniqueBSequences, uncoveredB2List);
        PickingNmersForBCexon2.addUncoveredSeq(uncoveredSequences, uniqueCSequences, uncoveredC2List);
        List<String> nMerListShared = PickingNmersForBCexon2.constructNmers(uncoveredSequences, nmerSize, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>());
        Map<String, List<String>> matchRecordShared = PickingNmersForBCexon2.recordMatches(nMerListShared, uncoveredSequences);
        ArrayList<String> uncoveredSharedList = new ArrayList<String>();
        Map<String, List<String>> fullCoverageMapShared = PickingNmersForBCexon2.computeFullCoveragePath(matchRecordShared, uncoveredSequences, uncoveredSharedList, 3);
        System.out.println("number of Nmer for BC = " + fullCoverageMapShared.size());
        for (String nmer : fullCoverageMapShared.keySet()) {
            System.out.println(String.valueOf(nmer) + "\t" + fullCoverageMapShared.get(nmer).size());
        }
    }

    private static String revComp(String seq) {
        String revcomp = new StringBuilder(seq.replace('A', 'B').replace('T', 'A').replace('B', 'T').replace('C', 'D').replace('G', 'C').replace('D', 'G')).reverse().toString();
        return revcomp;
    }

    public static void addUncoveredSeq(Map<String, String> uncoveredSequences, Map<String, String> uniqueSequences, List<String> uncoveredList) {
        for (String name : uncoveredList) {
            uncoveredSequences.put(name, uniqueSequences.get(name));
        }
    }

    public static Map<String, List<String>> computeFullCoveragePath(Map<String, List<String>> matchRecord, Map<String, String> uniqueSequences, List<String> uncoveredList, int round) {
        int limit = 8;
        if (round == 1) {
            limit = ROUND_1_PICK_NUM_1;
        }
        if (round == 2) {
            limit = ROUND_1_PICK_NUM_2;
        }
        LinkedHashMap<String, List<String>> fullCoverageMap = new LinkedHashMap<String, List<String>>();
        uncoveredList.addAll(uniqueSequences.keySet());
        int i = 0;
        while (i < matchRecord.size()) {
            if (uncoveredList.size() == 0) break;
            String bestNmer = null;
            List<String> maxCoverage = new ArrayList<String>();
            for (String nmer : matchRecord.keySet()) {
                List<String> affectiveCoverage;
                if (fullCoverageMap.containsKey(nmer) || (affectiveCoverage = PickingNmersForBCexon2.getAffectiveCoverage(matchRecord.get(nmer), uncoveredList)).size() <= maxCoverage.size()) continue;
                maxCoverage = affectiveCoverage;
                bestNmer = nmer;
            }
            if (bestNmer != null) {
                fullCoverageMap.put(bestNmer, matchRecord.get(bestNmer));
                PickingNmersForBCexon2.updateUncoverList(maxCoverage, uncoveredList);
            }
            if (fullCoverageMap.size() >= limit) break;
            ++i;
        }
        System.out.println("total type covered: " + (uniqueSequences.size() - uncoveredList.size()) + ", uncovered: " + uncoveredList.size());
        if (round == 2) {
            System.out.println(uncoveredList.toString());
        }
        return fullCoverageMap;
    }

    private static void updateUncoverList(List<String> maxCoverage, List<String> uncoveredList) {
        Iterator<String> it = uncoveredList.iterator();
        while (it.hasNext()) {
            String t = it.next();
            if (!maxCoverage.contains(t)) continue;
            it.remove();
        }
    }

    private static List<String> getAffectiveCoverage(List<String> coverage, List<String> uncoveredList) {
        ArrayList<String> thisCoverage = new ArrayList<String>();
        for (String name : coverage) {
            if (!uncoveredList.contains(name)) continue;
            thisCoverage.add(name);
        }
        return thisCoverage;
    }

    public static Map<String, List<String>> recordMatches(List<String> nMerList, Map<String, String> uniqueSequences) {
        LinkedHashMap<String, List<String>> matchRecord = new LinkedHashMap<String, List<String>>();
        for (String nmer : nMerList) {
            matchRecord.put(nmer, new ArrayList());
            for (String name : uniqueSequences.keySet()) {
                if (uniqueSequences.get(name).indexOf(nmer) <= -1) continue;
                ((List)matchRecord.get(nmer)).add(name);
            }
        }
        return matchRecord;
    }

    private static boolean findMatch(String nmer, Map<String, String> uniqueSequences) {
        for (String name : uniqueSequences.keySet()) {
            if (uniqueSequences.get(name).indexOf(nmer) <= -1) continue;
            return true;
        }
        return false;
    }

    public static List<String> constructNmers(Map<String, String> majorSequences, int nmerSize, Map<String, String> otherUniqueSequences1, Map<String, String> otherUniqueSequences2) {
        ArrayList<String> nMerList = new ArrayList<String>();
        for (String name : majorSequences.keySet()) {
            String seq = majorSequences.get(name);
            int i = 0;
            while (i <= seq.length() - nmerSize) {
                String nMer = seq.substring(i, i + nmerSize);
                if (!(nMer.indexOf("X") >= 0 || nMerList.contains(nMer) || PickingNmersForBCexon2.findMatch(nMer, otherUniqueSequences1) || PickingNmersForBCexon2.findMatch(nMer, otherUniqueSequences2))) {
                    nMerList.add(nMer);
                }
                ++i;
            }
        }
        System.out.println("nMerList.size()=" + nMerList.size());
        return nMerList;
    }

    private static void loadAllSequence(File input, String header, Map<String, String> uniqueSequences, Map<String, String> majorSequenceNames) {
        Map<String, String> sequences = PickingNmersForBCexon2.getSequences(input, header);
        System.out.println("sequences.size=" + sequences.size());
        ArrayList<String> majorGroupNameList = new ArrayList<String>();
        ArrayList<String> majorGroupSequenceList = new ArrayList<String>();
        LinkedHashMap<String, String> seqToName = new LinkedHashMap<String, String>();
        for (String name : sequences.keySet()) {
            if (seqToName.containsKey(sequences.get(name))) {
                String collectionName = String.valueOf((String)seqToName.get(sequences.get(name))) + "," + name;
                seqToName.put(sequences.get(name), collectionName);
            } else {
                seqToName.put(sequences.get(name), name);
            }
            String majorGroup = name.split("\\:")[0];
            if (majorGroupNameList.contains(majorGroup) || majorGroupSequenceList.contains(sequences.get(name))) continue;
            majorSequenceNames.put(name, sequences.get(name));
            majorGroupNameList.add(majorGroup);
            majorGroupSequenceList.add(sequences.get(name));
        }
        for (String seq : seqToName.keySet()) {
            uniqueSequences.put((String)seqToName.get(seq), seq);
        }
    }

    private static Map<String, String> getSequences(File fastaFile, String header) {
        LinkedHashMap<String, String> sequences = new LinkedHashMap<String, String>();
        String[] lines = FileManager.readTextFile(fastaFile).split("\n");
        int i = 0;
        while (i < lines.length) {
            if (lines[i].trim().length() != 0 && lines[i].trim().startsWith(">" + header)) {
                String name = lines[i].trim().substring(1);
                String sequence = lines[i + 1].trim();
                sequences.put(name, sequence);
            }
            ++i;
        }
        return sequences;
    }
}

