/*
 * Decompiled with CFR 0.152.
 */
package primerDesign;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import misc.FileManager;

public class ParseBlastOutput {
    public static void main(String[] args) throws Exception {
        File primerFile = new File(args[0]);
        File blastFile = new File(args[1]);
        File outputFile = new File(args[2]);
        List<String> primers = ParseBlastOutput.getAllPrimers(primerFile);
        String[] lines = FileManager.readTextFile(blastFile).split("\n");
        HashMap<String, Integer> matches = new HashMap<String, Integer>();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            String[] items = line.split("\t");
            String primerName = items[0].trim();
            if (!matches.containsKey(primerName)) {
                matches.put(primerName, 0);
            }
            matches.put(primerName, (Integer)matches.get(primerName) + 1);
            ++n2;
        }
        FileManager.writeTextFile(outputFile, ParseBlastOutput.buildOutput(primers, matches), true);
    }

    private static String buildOutput(List<String> primers, Map<String, Integer> matches) {
        StringBuilder builder = new StringBuilder();
        for (String primer : primers) {
            builder.append(primer).append("\t");
            if (matches.containsKey(primer)) {
                builder.append(matches.get(primer));
            } else {
                builder.append(0);
            }
            builder.append("\n");
        }
        return builder.toString();
    }

    private static List<String> getAllPrimers(File primerFile) {
        String[] lines;
        ArrayList<String> primers = new ArrayList<String>();
        String[] stringArray = lines = FileManager.readTextFile(primerFile).split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.startsWith(">")) {
                primers.add(line.trim().substring(1));
            }
            ++n2;
        }
        return primers;
    }
}

