/*
 * Decompiled with CFR 0.152.
 */
package primerDesign;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import misc.FileManager;

public class ExactSequenceFromAlignment {
    private static int GAP = 10;

    public static void main(String[] args) {
        File alignmentFn = new File(args[0]);
        File outputDir = new File(args[1]);
        String[] alignments = FileManager.readTextFile(alignmentFn).split("\n");
        ArrayList<Integer> discrepency = new ArrayList<Integer>();
        LinkedHashMap<Integer, String> seqMap = new LinkedHashMap<Integer, String>();
        ExactSequenceFromAlignment.getSeqFromAlignment(alignments, seqMap, discrepency);
        ExactSequenceFromAlignment.writeOutput(seqMap, discrepency, outputDir);
    }

    private static void writeOutput(Map<Integer, String> seqMap, List<Integer> discrepency, File outputDir) {
        StringBuilder builder = new StringBuilder();
        for (Integer pos : seqMap.keySet()) {
            builder.append(">").append(pos).append(" length ").append(seqMap.get(pos).length()).append("\n");
            builder.append(seqMap.get(pos)).append("\n");
        }
        FileManager.writeTextFile(new File(outputDir, "seq.fa"), builder.toString(), true);
        builder = new StringBuilder();
        for (Integer pos : discrepency) {
            builder.append(pos).append("\n");
        }
        FileManager.writeTextFile(new File(outputDir, "snp.txt"), builder.toString(), true);
    }

    private static void getSeqFromAlignment(String[] alignments, Map<Integer, String> seqMap, List<Integer> discrepency) {
        int mapKey = -1;
        int currentPos = -1;
        StringBuilder sequence = null;
        int i = 0;
        while (i < alignments.length) {
            String line = alignments[i].trim();
            if (line.startsWith("ref")) {
                int pos = Integer.valueOf(line.split("\\s+")[1]);
                if (currentPos < 0) {
                    sequence = new StringBuilder();
                    mapKey = pos;
                } else if (pos > currentPos + 50 + GAP) {
                    seqMap.put(mapKey, sequence.toString());
                    sequence = new StringBuilder();
                    mapKey = pos;
                }
                currentPos = pos;
                sequence.append(line.split("\\s+")[2]);
                ExactSequenceFromAlignment.addSnpPos(alignments[i + 24], currentPos, discrepency);
                i += 24;
            }
            ++i;
        }
        seqMap.put(mapKey, sequence.toString());
        ExactSequenceFromAlignment.addSnpPos(alignments[alignments.length - 1], currentPos, discrepency);
    }

    private static void addSnpPos(String line, int pos, List<Integer> discrepency) {
        String snps = line.substring(21);
        int i = 0;
        while (i < snps.length()) {
            if (snps.charAt(i) == '*') {
                discrepency.add(ExactSequenceFromAlignment.coverPos(i, pos));
            }
            ++i;
        }
    }

    private static int coverPos(int i, int offset) {
        return offset + i;
    }
}

