/*
 * Decompiled with CFR 0.152.
 */
package pacBio;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import misc.FileManager;
import misc.SystemCommand;
import pacBio.BaseCall;
import pacBio.CanuResult;
import pacBio.Contig;
import pacBio.Discrepancy;
import pacBio.Layout;
import pacBio.OneMatch;
import pacBio.RemoveAmpicillin;
import pacBio.SnpPosition;

public class SummerizeCanuContigsAndCheck {
    static int MIN_CHILDREN_COUNT = 5;
    static String LABEL = "Contig000000";
    private static String DELETION = "-";
    static int LOW_COVERAGE = 5;
    private static final int SNP_THRESHOLD = 30;

    public static void main(String[] args) throws Exception {
        File demultiplexFastaDir = new File(args[0]);
        File canuContigDir = new File(args[1]);
        File outputFile = new File(args[2]);
        File newFastaDir = new File(args[3]);
        Object[] demultiplexFastas = demultiplexFastaDir.listFiles();
        LinkedHashMap<String, CanuResult> canuResultsMap = new LinkedHashMap<String, CanuResult>();
        System.out.println(demultiplexFastas.length);
        Arrays.sort(demultiplexFastas);
        Object[] objectArray = demultiplexFastas;
        int n = demultiplexFastas.length;
        int n2 = 0;
        while (n2 < n) {
            Object demultiplexFasta = objectArray[n2];
            if (((File)demultiplexFasta).getName().endsWith("fasta")) {
                String fosmidName = ((File)demultiplexFasta).getName().replace(".fasta", "");
                canuResultsMap.put(fosmidName, new CanuResult(fosmidName));
                Map<String, String> sequenceMap = SummerizeCanuContigsAndCheck.loadInputSeqInfo((File)demultiplexFasta, (CanuResult)canuResultsMap.get(fosmidName));
                SummerizeCanuContigsAndCheck.loadCanuResults(canuContigDir, (CanuResult)canuResultsMap.get(fosmidName), sequenceMap);
                SummerizeCanuContigsAndCheck.generateNewFasta(fosmidName, (CanuResult)canuResultsMap.get(fosmidName), newFastaDir);
            }
            ++n2;
        }
        FileManager.writeTextFile(outputFile, SummerizeCanuContigsAndCheck.outputSummary(canuResultsMap), true);
    }

    private static void generateNewFasta(String fosmidName, CanuResult canuResult, File newFastaDir) {
        File output = new File(newFastaDir, String.valueOf(fosmidName) + ".contigs.fasta");
        StringBuilder builder = new StringBuilder();
        for (Contig contig : canuResult.getContigs()) {
            builder.append(">").append(SummerizeCanuContigsAndCheck.getTigName(contig.getId())).append(" ").append("len=").append(contig.getTrimmedSequence().length()).append(" ").append("reads=").append(contig.getChild()).append("\n");
            builder.append(contig.getTrimmedSequence()).append("\n");
        }
        FileManager.writeTextFile(output, builder.toString(), true);
    }

    private static Object getTigName(String id) {
        if (id.length() == 1) {
            return "tig0000000" + id;
        }
        return "tig000000" + id;
    }

    private static String outputSummary(Map<String, CanuResult> canuResultsMap) {
        StringBuilder builder = new StringBuilder();
        builder.append("fosmid").append(",").append("demultiplexCount").append(",").append("averageSeqLen").append("\n");
        builder.append("\t,tigID").append(",").append("tigLen").append(",").append("coverage").append(",").append("numChildren").append(",").append("children%mismatch").append(",").append("<5xCoveragePositions").append(",").append(">30%SnpPositions").append(",").append("afterTrimLength").append(",").append("afterTrimAverageCoverage").append("\n");
        for (String fosmid : canuResultsMap.keySet()) {
            builder.append(fosmid).append(",").append(canuResultsMap.get(fosmid).getInputSeqCount()).append(",").append(canuResultsMap.get(fosmid).getAverageSeqLength()).append("\n");
            for (Contig contig : canuResultsMap.get(fosmid).getContigs()) {
                builder.append("\t,").append(contig.getId()).append(",").append(contig.getLength()).append(",").append(contig.getCoverage()).append(",").append(contig.getChild()).append(",").append(String.format("%.2f", contig.getChildrenPercentDiscrep())).append(",").append(contig.getNoCoveragePositions().size() + contig.getLowCoveragePositions().size()).append(",").append(contig.getSnps().size()).append(",").append(contig.getTrimmedSequence().length()).append(",").append(String.format("%.2f", contig.getAfterTrimmedRegionCoverage())).append("\n");
            }
        }
        return builder.toString();
    }

    private static void loadCanuResults(File canuContigDir, CanuResult canuResult, Map<String, String> sequenceMap) throws Exception {
        String rootName = SummerizeCanuContigsAndCheck.getRootName(canuResult.getFosmidName());
        File canuContigFastaFile = new File(canuContigDir, String.valueOf(rootName) + ".contigs.fasta");
        File canuContigInfoFile = new File(canuContigDir, String.valueOf(rootName) + ".contigs.layout.tigInfo");
        File canuContigLayoutFile = new File(canuContigDir, String.valueOf(rootName) + ".contigs.layout.readToTig");
        File canuReadNameFile = new File(canuContigDir, String.valueOf(rootName) + ".readNames.txt");
        if (canuContigInfoFile.exists()) {
            System.out.println("Process " + rootName);
            SummerizeCanuContigsAndCheck.loadCanuContigInfo(canuResult, canuContigInfoFile);
            SummerizeCanuContigsAndCheck.loadCanuContigLayout(canuResult, canuContigLayoutFile);
            SummerizeCanuContigsAndCheck.loadReadName(canuResult, canuReadNameFile);
            SummerizeCanuContigsAndCheck.loadCanuContigFasta(canuResult, canuContigFastaFile);
            SummerizeCanuContigsAndCheck.checkContigByCM(canuResult, sequenceMap);
        } else {
            System.out.println("No output for " + rootName);
        }
    }

    private static void checkContigByCM(CanuResult canuResult, Map<String, String> sequenceMap) throws Exception {
        for (Contig contig : canuResult.getContigs()) {
            String target = contig.getSequence();
            File targetFile = SummerizeCanuContigsAndCheck.getBackboneFile(target, contig.getId());
            List<Layout> layouts = canuResult.getReadLayout().get(contig.getId());
            File queryFile = SummerizeCanuContigsAndCheck.getChildReadsFile(layouts, sequenceMap, canuResult.getReadNames());
            HashMap<String, OneMatch> matchResult = new HashMap<String, OneMatch>();
            System.out.println("Start cross_match.. contig " + contig.getId());
            File matchResultFile = SummerizeCanuContigsAndCheck.runCrossMatch(queryFile, targetFile);
            SummerizeCanuContigsAndCheck.ParseResult(matchResult, matchResultFile, queryFile);
            System.out.println("input sequences matched pairs=" + matchResult.size());
            SummerizeCanuContigsAndCheck.summarizeMatch(matchResult, contig);
        }
    }

    private static void summarizeMatch(Map<String, OneMatch> matchResult, Contig contig) {
        double avePercentDiscrep = SummerizeCanuContigsAndCheck.getAvePercentDiscrep(matchResult);
        contig.setChildrenPercentDiscrep(avePercentDiscrep);
        String backbone = contig.getSequence();
        Map<Integer, Integer> posCount = SummerizeCanuContigsAndCheck.initMap(backbone.length());
        HashMap<Integer, Map<String, Integer>> misMatchPosCount = new HashMap<Integer, Map<String, Integer>>();
        HashMap<Integer, Map<Integer, Map<String, Integer>>> insertionCountMap = new HashMap<Integer, Map<Integer, Map<String, Integer>>>();
        for (OneMatch match : matchResult.values()) {
            int start = match.getTargetStart();
            int end = match.getTargetEnd();
            SummerizeCanuContigsAndCheck.addToPosCount(posCount, start, end);
            SummerizeCanuContigsAndCheck.addInDiscrepenies(match.getDiscrepencies(), posCount, misMatchPosCount, insertionCountMap);
        }
        SummerizeCanuContigsAndCheck.summarizeConsensusSequence(backbone, posCount, misMatchPosCount, insertionCountMap, contig);
    }

    private static int getNoiseCount(Map<String, Integer> misMatchCount, String maxBase, String backboneBase, int matchBackboneCount) {
        int noiseCount = 0;
        if (maxBase.equals(backboneBase)) {
            for (String b : misMatchCount.keySet()) {
                noiseCount += misMatchCount.get(b).intValue();
            }
        } else {
            noiseCount += matchBackboneCount;
            for (String b : misMatchCount.keySet()) {
                if (maxBase.equals(b)) continue;
                noiseCount += misMatchCount.get(b).intValue();
            }
        }
        return noiseCount;
    }

    private static void summarizeConsensusSequence(String backbone, Map<Integer, Integer> posCount, Map<Integer, Map<String, Integer>> misMatchPosCount, Map<Integer, Map<Integer, Map<String, Integer>>> insertionCountMap, Contig contig) {
        LinkedHashMap<Integer, SnpPosition> snps = new LinkedHashMap<Integer, SnpPosition>();
        ArrayList<Integer> lowCoveragePositions = new ArrayList<Integer>();
        ArrayList<Integer> noCoveragePositions = new ArrayList<Integer>();
        int coverageCount = 0;
        int i = 0;
        while (i < backbone.length()) {
            String backboneBase = String.valueOf(backbone.charAt(i));
            int matchCount = posCount.get(i + 1);
            boolean isSnp = SummerizeCanuContigsAndCheck.checkSnp(matchCount, backboneBase, matchCount, backboneBase, misMatchPosCount.get(i + 1));
            if (matchCount == 0) {
                noCoveragePositions.add(i + 1);
            } else if (matchCount < LOW_COVERAGE) {
                lowCoveragePositions.add(i + 1);
            } else {
                ++coverageCount;
                if (isSnp) {
                    int noiseCount = SummerizeCanuContigsAndCheck.getNoiseCount(misMatchPosCount.get(i + 1), backboneBase, backboneBase, matchCount);
                    SnpPosition snp = new SnpPosition(i + 1, backboneBase, matchCount, noiseCount, 20, 20);
                    BaseCall secondMajor = null;
                    secondMajor = SummerizeCanuContigsAndCheck.getSecondaryBase(misMatchPosCount.get(i + 1), backboneBase, backboneBase, matchCount);
                    snp.setMinorBase(secondMajor.getBase());
                    snp.setMinorBaseCount(secondMajor.getCount());
                    snp.setMinorBaseQuality(secondMajor.getQuality());
                    snps.put(i + 1, snp);
                }
            }
            ++i;
        }
        contig.setCoverageCount(coverageCount);
        contig.setLowCoveragePositions(lowCoveragePositions);
        contig.setNoCoveragePositions(noCoveragePositions);
        SummerizeCanuContigsAndCheck.trim(backbone, lowCoveragePositions, noCoveragePositions, snps, posCount, contig);
        contig.setSnps(snps);
    }

    private static void trim(String backbone, List<Integer> lowCoveragePositions, List<Integer> noCoveragePositions, Map<Integer, SnpPosition> snps, Map<Integer, Integer> posCount, Contig contig) {
        int size;
        ArrayList<Integer> skipPositions = new ArrayList<Integer>();
        skipPositions.addAll(lowCoveragePositions);
        skipPositions.addAll(noCoveragePositions);
        Iterator it = skipPositions.iterator();
        while (it.hasNext()) {
            Integer p = (Integer)it.next();
            if (!snps.containsKey(p)) continue;
            it.remove();
        }
        if (skipPositions.size() <= 2) {
            contig.setTrimmedSequence(backbone);
            contig.setAfterTrimmedRegionCoverage(contig.getCoverage());
            return;
        }
        Object[] pos = skipPositions.toArray();
        Arrays.sort(pos);
        int maxChunk = 0;
        int start = 0;
        int end = 0;
        int i = 0;
        while (i < pos.length - 1) {
            int size2;
            if (i == 0) {
                size2 = (Integer)pos[i] - 1;
                if (size2 > maxChunk) {
                    maxChunk = size2;
                    start = 0;
                    end = (Integer)pos[i];
                }
            } else {
                size2 = (Integer)pos[i + 1] - (Integer)pos[i] - 1;
                if (size2 > maxChunk) {
                    maxChunk = size2;
                    start = (Integer)pos[i];
                    end = (Integer)pos[i + 1];
                }
            }
            ++i;
        }
        if ((Integer)pos[pos.length - 1] < backbone.length() && (size = backbone.length() - (Integer)pos[pos.length - 1]) > maxChunk) {
            maxChunk = size;
            start = (Integer)pos[pos.length - 1];
            end = backbone.length();
        }
        System.out.println(pos.length);
        System.out.println(String.valueOf(maxChunk) + " after trim " + start + " " + end);
        contig.setTrimmedSequence(backbone.substring(start, end - 1));
        double sum = 0.0;
        int i2 = start;
        while (i2 < end - 1) {
            sum += (double)posCount.get(i2 + 1).intValue();
            ++i2;
        }
        contig.setAfterTrimmedRegionCoverage(sum / (double)maxChunk);
    }

    private static BaseCall getSecondaryBase(Map<String, Integer> misMatchCount, String maxBase, String backboneBase, int matchBackboneCount) {
        int nextMax = 0;
        String nextBase = "";
        if (maxBase.equals(backboneBase)) {
            for (String b : misMatchCount.keySet()) {
                if (misMatchCount.get(b) <= nextMax) continue;
                nextMax = misMatchCount.get(b);
                nextBase = b;
            }
        } else {
            nextMax = matchBackboneCount;
            nextBase = backboneBase;
            for (String b : misMatchCount.keySet()) {
                if (maxBase.equals(b) || misMatchCount.get(b) <= nextMax) continue;
                nextMax = misMatchCount.get(b);
                nextBase = b;
            }
        }
        if (nextBase.length() == 0) {
            return null;
        }
        BaseCall baseCall = new BaseCall(nextBase);
        baseCall.setCount(nextMax);
        return baseCall;
    }

    private static boolean checkSnp(int max, String maxBase, int matchBackboneCount, String backboneBase, Map<String, Integer> misMatchCount) {
        if (misMatchCount == null) {
            return false;
        }
        if (max < LOW_COVERAGE) {
            return false;
        }
        int noiseCount = 0;
        if (maxBase.equals(backboneBase)) {
            for (String b : misMatchCount.keySet()) {
                noiseCount += misMatchCount.get(b).intValue();
            }
        } else {
            noiseCount += matchBackboneCount;
            for (String b : misMatchCount.keySet()) {
                if (maxBase.equals(b)) continue;
                noiseCount += misMatchCount.get(b).intValue();
            }
        }
        return 100 * noiseCount / (max + noiseCount) > 30;
    }

    private static double getAvePercentDiscrep(Map<String, OneMatch> matchResult) {
        double discrepTotal = 0.0;
        for (OneMatch match : matchResult.values()) {
            discrepTotal += match.getPercentDiscrep();
        }
        return discrepTotal / (1.0 * (double)matchResult.size());
    }

    public static void addInDiscrepenies(List<Discrepancy> discrepencies, Map<Integer, Integer> posCount, Map<Integer, Map<String, Integer>> misMatchPosCount, Map<Integer, Map<Integer, Map<String, Integer>>> insertionCount) {
        for (Discrepancy d : discrepencies) {
            if (!posCount.containsKey(d.getTargetPosition())) continue;
            if (!misMatchPosCount.containsKey(d.getTargetPosition())) {
                misMatchPosCount.put(d.getTargetPosition(), new LinkedHashMap());
            }
            if (d.getType() == 'S') {
                int count = posCount.get(d.getTargetPosition()) - 1;
                posCount.put(d.getTargetPosition(), count);
                String base = d.getQueryBase();
                if (!misMatchPosCount.get(d.getTargetPosition()).containsKey(base)) {
                    misMatchPosCount.get(d.getTargetPosition()).put(base, 0);
                }
                count = misMatchPosCount.get(d.getTargetPosition()).get(d.getQueryBase()) + 1;
                misMatchPosCount.get(d.getTargetPosition()).put(d.getQueryBase(), count);
            } else if (d.getType() == 'D') {
                String base = "-";
                int i = 0;
                while (i < d.getCount()) {
                    int count = posCount.get(d.getTargetPosition() + i) - 1;
                    posCount.put(d.getTargetPosition() + i, count);
                    if (!misMatchPosCount.containsKey(d.getTargetPosition() + i)) {
                        misMatchPosCount.put(d.getTargetPosition() + i, new LinkedHashMap());
                    }
                    if (!misMatchPosCount.get(d.getTargetPosition() + i).containsKey(base)) {
                        misMatchPosCount.get(d.getTargetPosition() + i).put(base, 0);
                    }
                    count = misMatchPosCount.get(d.getTargetPosition() + i).get(base) + 1;
                    misMatchPosCount.get(d.getTargetPosition() + i).put(base, count);
                    ++i;
                }
            }
            if (d.getType() != 'I') continue;
            if (!insertionCount.containsKey(d.getTargetPosition())) {
                insertionCount.put(d.getTargetPosition(), new LinkedHashMap());
            }
            Map<Integer, Map<String, Integer>> insertionMap = insertionCount.get(d.getTargetPosition());
            int i = 0;
            while (i < d.getCount()) {
                if (!insertionMap.containsKey(i)) {
                    insertionMap.put(i, new LinkedHashMap());
                }
                String base = d.getQueryBase().substring(i, i + 1);
                if (!insertionMap.get(i).containsKey(base)) {
                    insertionMap.get(i).put(base, 0);
                }
                int count = insertionMap.get(i).get(base) + 1;
                insertionMap.get(i).put(base, count);
                ++i;
            }
        }
    }

    public static void addToPosCount(Map<Integer, Integer> posCount, int start, int end) {
        int i = start;
        while (i < end + 1) {
            if (posCount.get(i) != null) {
                int count = posCount.get(i) + 1;
                posCount.put(i, count);
            }
            ++i;
        }
    }

    public static Map<Integer, Integer> initMap(int exonSize) {
        LinkedHashMap<Integer, Integer> posCount = new LinkedHashMap<Integer, Integer>();
        int i = 1;
        while (i < exonSize + 1) {
            posCount.put(i, 0);
            ++i;
        }
        return posCount;
    }

    private static void ParseResult(Map<String, OneMatch> result, File matchResult, File queryFile) throws Exception {
        String[] lines = FileManager.readTextFile(matchResult).split("\n");
        boolean startRecord = false;
        OneMatch aMatch = null;
        String fullName = null;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.indexOf(LABEL) > 0 && line.trim().split("\\s+").length >= 12) {
                String[] items = line.trim().split("\\s+");
                startRecord = true;
                fullName = items[4].trim();
                aMatch = SummerizeCanuContigsAndCheck.populateAmatch(queryFile, result, line);
                result.put(fullName, aMatch);
            } else if (startRecord && line.trim().split("\\s+").length == 5) {
                SummerizeCanuContigsAndCheck.populateDiscrepency(aMatch, line, fullName);
            }
            ++n2;
        }
    }

    private static void populateDiscrepency(OneMatch match, String line, String fullName) {
        String[] items = line.trim().split("\\s+");
        if (items[0].charAt(0) != 'S' && items[0].charAt(0) != 'I' && items[0].charAt(0) != 'D') {
            return;
        }
        List<Discrepancy> discrepancies = SummerizeCanuContigsAndCheck.generateDiscrepancy(items, fullName, match.isReverseComp());
        match.setDiscrepencies(discrepancies);
    }

    public static String revCompSeq(String seq) {
        String ret = "";
        String base = "";
        int i = seq.length() - 1;
        while (i >= 0) {
            if ("Aa".indexOf(seq.charAt(i)) > -1) {
                base = "T";
            } else if ("Tt".indexOf(seq.charAt(i)) > -1) {
                base = "A";
            } else if ("Cc".indexOf(seq.charAt(i)) > -1) {
                base = "G";
            } else if ("Gg".indexOf(seq.charAt(i)) > -1) {
                base = "C";
            } else if ("Nn".indexOf(seq.charAt(i)) > -1) {
                base = "N";
            } else if ("Ww".indexOf(seq.charAt(i)) > -1) {
                base = "W";
            } else if (".".indexOf(seq.charAt(i)) > -1) {
                base = ".";
            }
            ret = String.valueOf(ret) + base;
            --i;
        }
        return ret;
    }

    private static List<Discrepancy> generateDiscrepancy(String[] items, String fullName, boolean isReverseComp) {
        int count = 1;
        if (items[0].trim().length() > 1) {
            count = new Integer(items[0].trim().substring(2));
        }
        char type = items[0].charAt(0);
        String base = items[2].trim().substring(0, items[2].indexOf("("));
        if (isReverseComp) {
            base = SummerizeCanuContigsAndCheck.revCompSeq(base);
        }
        int queryPosition = Integer.parseInt(items[1]);
        int targetPosition = Integer.parseInt(items[3]);
        String queryFlanking = items[4].trim();
        ArrayList<Discrepancy> discrepancies = new ArrayList<Discrepancy>();
        if (type == 'D') {
            int i = 0;
            while (i < count) {
                Discrepancy dis;
                if (isReverseComp) {
                    dis = new Discrepancy(type, 1, queryPosition, DELETION, 20, targetPosition - i, queryFlanking);
                    discrepancies.add(dis);
                } else {
                    dis = new Discrepancy(type, 1, queryPosition, DELETION, 20, targetPosition + i, queryFlanking);
                    discrepancies.add(dis);
                }
                ++i;
            }
        } else {
            Discrepancy dis = new Discrepancy(type, count, queryPosition, base, 20, targetPosition, queryFlanking);
            discrepancies.add(dis);
        }
        return discrepancies;
    }

    public static OneMatch populateAmatch(File fastaFile, Map<String, OneMatch> result, String line) {
        String[] items = line.trim().split("\\s+");
        boolean isRevComp = items[8].trim().equals("C");
        double discrep = Double.valueOf(items[1].trim());
        OneMatch aMatch = null;
        aMatch = isRevComp ? new OneMatch(Integer.valueOf(items[5].trim()), Integer.valueOf(items[6].trim()), Integer.valueOf(items[12].trim()), Integer.valueOf(items[11].trim()), true) : new OneMatch(Integer.valueOf(items[5].trim()), Integer.valueOf(items[6].trim()), Integer.valueOf(items[9].trim()), Integer.valueOf(items[10].trim()), false);
        aMatch.setPercentDiscrep(discrep);
        return aMatch;
    }

    private static File runCrossMatch(File fastaFile, File hapFile) throws Exception {
        File tmpFile = File.createTempFile("out", "txt");
        tmpFile.deleteOnExit();
        String cmd = "/genome/bin/cross_match -minmatch 500 -minscore 1000 -discrep_lists  " + fastaFile.getAbsolutePath() + " " + hapFile.getAbsolutePath() + " > " + tmpFile.getAbsolutePath();
        String[] commandArray = new String[]{"bash", "-c", cmd};
        SystemCommand command = new SystemCommand(commandArray, null, false);
        command.makeItSo();
        return tmpFile;
    }

    private static File getBackboneFile(String target, String contigName) throws Exception {
        File tempOutputFile = File.createTempFile("seq", "txt");
        tempOutputFile.deleteOnExit();
        StringBuilder seq = new StringBuilder();
        seq.append(">").append(LABEL).append(contigName).append("\n");
        seq.append(target).append("\n");
        FileManager.writeTextFile(tempOutputFile, seq.toString(), true);
        return tempOutputFile;
    }

    private static File getChildReadsFile(List<Layout> layouts, Map<String, String> sequenceMap, Map<String, String> readIdNameMap) throws Exception {
        File tempOutputFile = File.createTempFile("seq", "txt");
        tempOutputFile.deleteOnExit();
        StringBuilder seq = new StringBuilder();
        for (Layout layout : layouts) {
            String readName = readIdNameMap.get(layout.readId);
            seq.append(">").append(readName).append("\n");
            seq.append(sequenceMap.get(readName)).append("\n");
        }
        FileManager.writeTextFile(tempOutputFile, seq.toString(), true);
        return tempOutputFile;
    }

    private static void loadCanuContigFasta(CanuResult canuResult, File canuContigFastaFile) {
        String[] lines = FileManager.readTextFile(canuContigFastaFile).split("\n");
        HashMap<String, String> sequenceMap = new HashMap<String, String>();
        int i = 0;
        while (i < lines.length) {
            if (lines[i].startsWith(">")) {
                String[] items = lines[i].trim().substring(1).split("\\s+");
                String seqName = items[0].trim().replace("tig0000000", "").replace("tig000000", "");
                StringBuilder seq = new StringBuilder();
                int j = i + 1;
                while (j < lines.length) {
                    if (lines[j].startsWith(">")) break;
                    seq.append(lines[j].trim());
                    ++j;
                }
                sequenceMap.put(seqName, seq.toString().trim());
                System.out.println("collect " + seqName);
            }
            ++i;
        }
        for (Contig contig : canuResult.getContigs()) {
            System.out.println("contig " + contig.getId());
            System.out.println("contig " + contig.getId() + " length=" + ((String)sequenceMap.get(contig.getId())).length());
            contig.setSequence((String)sequenceMap.get(contig.getId()));
        }
    }

    private static void loadReadName(CanuResult canuResult, File canuReadNameFile) {
        String[] lines = FileManager.readTextFile(canuReadNameFile).split("\n");
        int i = 0;
        while (i < lines.length) {
            String[] items = lines[i].split("\\s+");
            String canuId = items[0].trim();
            String seqName = items[1];
            String seqId = items[2].trim().substring(3);
            canuResult.addReadNames(canuId, seqName);
            ++i;
        }
    }

    private static void loadCanuContigLayout(CanuResult canuResult, File canuContigLayoutFile) {
        String[] lines = FileManager.readTextFile(canuContigLayoutFile).split("\n");
        int i = 1;
        while (i < lines.length) {
            String[] fields = lines[i].split("\\s+");
            Layout layout = new Layout();
            layout.setReadId(fields[0].trim());
            layout.setTigId(fields[1].trim());
            layout.setBgn(new Integer(fields[2]));
            layout.setEnd(new Integer(fields[3]));
            canuResult.addReadLayout(fields[1].trim(), layout);
            ++i;
        }
    }

    private static void loadCanuContigInfo(CanuResult canuResult, File canuContigInfoFile) {
        String[] lines = FileManager.readTextFile(canuContigInfoFile).split("\n");
        int i = 1;
        while (i < lines.length) {
            String[] fields = lines[i].split("\\s+");
            int count = Integer.valueOf(fields[7].trim());
            if (count > MIN_CHILDREN_COUNT) {
                Contig contig = new Contig();
                contig.setId(fields[0].trim());
                contig.setLength(Integer.valueOf(fields[1].trim()));
                contig.setCoverage(Double.valueOf(fields[2].trim()));
                contig.setChild(Integer.valueOf(fields[7].trim()));
                canuResult.getContigs().add(contig);
            }
            ++i;
        }
    }

    private static String getRootName(String fosmidName) {
        return fosmidName;
    }

    private static Map<String, String> loadInputSeqInfo(File demultiplexFasta, CanuResult canuResult) {
        HashMap<String, String> sequenceMap = new HashMap<String, String>();
        HashMap<String, String> nameIdMap = new HashMap<String, String>();
        RemoveAmpicillin.getSequenceFromFasta(demultiplexFasta, sequenceMap, nameIdMap);
        canuResult.setInputSeqCount(sequenceMap.size());
        canuResult.setAverageSeqLength(SummerizeCanuContigsAndCheck.getAverageSeqLength(sequenceMap));
        return sequenceMap;
    }

    private static int getAverageSeqLength(Map<String, String> sequenceMap) {
        int total = 0;
        for (String seq : sequenceMap.values()) {
            total += seq.length();
        }
        return total / sequenceMap.size();
    }
}

