/*
 * Decompiled with CFR 0.152.
 */
package pacBio;

import java.io.File;
import java.util.Arrays;
import misc.FileManager;
import misc.SystemCommand;

public class SplitBamFile2 {
    public static void main(String[] args) throws Exception {
        File inputBam = new File(args[0]);
        File zmwFileDir = new File(args[1]);
        File outputDir = new File(args[2]);
        Object[] zmwFiles = zmwFileDir.listFiles();
        Arrays.sort(zmwFiles);
        System.out.println("total zmws files = " + zmwFiles.length);
        StringBuilder builder = new StringBuilder();
        Object[] objectArray = zmwFiles;
        int n = zmwFiles.length;
        int n2 = 0;
        while (n2 < n) {
            Object zmwFile = objectArray[n2];
            String name = SplitBamFile2.formatName(((File)zmwFile).getName());
            int count = FileManager.readTextFile((File)zmwFile).split("\n").length;
            File outputFile = new File(outputDir, String.valueOf(name) + ".bam");
            System.out.println(String.valueOf(((File)zmwFile).getName()) + "-->" + outputFile.getName() + " " + count);
            SplitBamFile2.sliceBamFile(inputBam, (File)zmwFile, outputFile);
            builder.append(name).append("\t").append(count).append("\n");
            ++n2;
        }
        File summaryFile = new File(outputDir, "summary.txt");
        FileManager.writeTextFile(summaryFile, builder.toString(), true);
    }

    private static String formatName(String name) {
        return name.split("\\.")[1].split("--")[0];
    }

    private static void sliceBamFile(File inputBam, File whiteList, File outputFile) {
        String cmd = "/smrttools/smrtcmds/bin/bamsieve --whitelist " + whiteList.getAbsolutePath() + " " + inputBam.getAbsolutePath() + " " + outputFile.getAbsolutePath();
        System.out.println("cmd= " + cmd);
        String[] commandArray = new String[]{"bash", "-c", cmd};
        SystemCommand command = new SystemCommand(commandArray, null, false);
        command.makeItSo();
    }

    private static File makeWhiteList(String[] zmws, int unit, int index) throws Exception {
        File tempOutputFile = File.createTempFile("unit", "txt");
        tempOutputFile.deleteOnExit();
        StringBuilder builder = new StringBuilder();
        int i = unit * index;
        while (i < unit * index + unit) {
            builder.append(zmws[i]).append("\n");
            ++i;
        }
        FileManager.writeTextFile(tempOutputFile, builder.toString(), true);
        return tempOutputFile;
    }

    public static File getZMWlist(File inputBam) throws Exception {
        System.out.println("createTempFile ");
        File tempOutputFile = File.createTempFile("zmw", "txt");
        tempOutputFile.deleteOnExit();
        String cmd = "/smrttools/smrtcmds/bin/bamsieve --show-zmws " + inputBam.getAbsolutePath() + " > " + tempOutputFile.getAbsolutePath();
        System.out.println("cmd= " + cmd);
        String[] commandArray = new String[]{"bash", "-c", cmd};
        SystemCommand command = new SystemCommand(commandArray, null, false);
        command.makeItSo();
        return tempOutputFile;
    }
}

